(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21659,        871]
NotebookOptionsPosition[     15718,        661]
NotebookOutlinePosition[     17012,        698]
CellTagsIndexPosition[     16927,        693]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Forms of Assignment" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialFormsOfAssignment"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Special Forms of Assignment\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Increment" :> Documentation`HelpLookup["paclet:ref/Increment"],
           "AddTo" :> Documentation`HelpLookup["paclet:ref/AddTo"], 
          "PreDecrement" :> 
          Documentation`HelpLookup["paclet:ref/PreDecrement"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Increment\"\>", 2->"\<\"AddTo\"\>", 
       3->"\<\"PreDecrement\"\>", 4->"\<\"Set\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "PreIncrement ",
 StyleBox["(++)", "OperatorCharacter"]
}], "ObjectName",
 CellID->4438],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"++", 
       StyleBox["x", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]increases the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " by 1, returning the new value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26218]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PreIncrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreIncrement"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10120],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"++", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   RowBox[{
    StyleBox["x", "TI"], "+", "1"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24912]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80745623],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->275676648],

Cell["Decrement the value by one and return the new value:", "ExampleText",
 CellID->42508190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", "1"}], ";", 
  RowBox[{"++", "k"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80703199],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->837268406]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["k"], "Input",
 CellLabel->"In[2]:=",
 CellID->105454447],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94974586]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10317],

Cell["Increment a numerical value:", "ExampleText",
 CellID->1113876286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "1.5"}], ";", " ", 
  RowBox[{"++", "x"}], ";", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1774324750],

Cell[BoxData["2.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197301373]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206580424],

Cell["Increment a symbolic value:", "ExampleText",
 CellID->838884225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", "a"}], ";", 
  RowBox[{"++", "v"}], ";", "v"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1698859122],

Cell[BoxData[
 RowBox[{"1", "+", "a"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->564561726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2063940682],

Cell["Increment all values in a list:", "ExampleText",
 CellID->822015323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2332824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->501265830]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"++", "x"}], ";", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1729906436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->685422305]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24865],

Cell["Find the first integer with a certain property:", "ExampleText",
 CellID->2078680352],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Prime", "[", 
      RowBox[{"++", "i"}], "]"}], "<", 
     RowBox[{"10", "^", "6"}]}], ",", "Null"}], "]"}], 
  ";"}], "\n", "i"}], "Input",
 CellLabel->"In[1]:=",
 CellID->84768696],

Cell[BoxData["78499"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4010153]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24952],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Increment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Increment"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PreIncrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreIncrement"]], "InlineFormula"],
 " differ in the return value of the operation:"
}], "ExampleText",
 CellID->440092738],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->550656451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "++"}], ",", 
   RowBox[{"++", "b"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->532828009],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->465619533]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->195309579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->320585950]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->300188328],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PreIncrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreIncrement"]], "InlineFormula"],
 " is a short form of this assignment:"
}], "ExampleText",
 CellID->2065810971],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"k", "=", 
  RowBox[{"k", "+", "1"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1887499219],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1736880614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->607562233],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PreIncrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreIncrement"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["AddTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AddTo"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1728269985],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"k", "+=", "1"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->683214900],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1283532592]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->224632663],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Decrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decrement"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PreDecrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreDecrement"]], "InlineFormula"],
 " are closely related operations:"
}], "ExampleText",
 CellID->73150939],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634282679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "++"}], ",", 
   RowBox[{"++", "b"}], ",", 
   RowBox[{"c", "--"}], ",", 
   RowBox[{"--", "d"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->463191000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177942332]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->95912239],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->96917032]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6719],

Cell["A variable to be incremented must have an initial value:", "ExampleText",
 CellID->992262862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"++", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1397421414],

Cell[BoxData[
 RowBox[{
  RowBox[{"PreIncrement", "::", "\<\"rvalue\"\>"}], ":", 
  " ", "\<\"\\!\\(x\\) is not a variable with a value, so its value cannot be \
changed.\"\>"}]], "Message", "MSG",
 CellID->451679670],

Cell[BoxData[
 RowBox[{"++", "x"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212760974]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5570],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Increment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Increment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AddTo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PreDecrement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PreDecrement"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2337]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16897],

Cell[TextData[ButtonBox["Special Forms of Assignment",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFormsOfAssignment"]], "Tutorials",
 CellID->9605]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PreIncrement (++) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 44.8422590}", "context" -> "System`", 
    "keywords" -> {
     "pre-increment", "preincrement", "incrementing a variable"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "++x increases the value of x by 1, returning the new value of x. ", 
    "synonyms" -> {"pre increment", "++"}, "title" -> "PreIncrement", "type" -> 
    "Symbol", "uri" -> "ref/PreIncrement"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3897, 139, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->80745623]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16785, 686}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1473, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2096, 62, 105, 4, 70, "ObjectName",
 CellID->4438],
Cell[2204, 68, 544, 18, 70, "Usage",
 CellID->26218]
}, Open  ]],
Cell[CellGroupData[{
Cell[2785, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3263, 108, 318, 12, 70, "Notes",
 CellID->10120],
Cell[3584, 122, 276, 12, 70, "Notes",
 CellID->24912]
}, Closed]],
Cell[CellGroupData[{
Cell[3897, 139, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80745623],
Cell[CellGroupData[{
Cell[4281, 153, 148, 5, 70, "ExampleSection",
 CellID->275676648],
Cell[4432, 160, 94, 1, 70, "ExampleText",
 CellID->42508190],
Cell[CellGroupData[{
Cell[4551, 165, 133, 5, 28, "Input",
 CellID->80703199],
Cell[4687, 172, 158, 5, 36, "Output",
 CellID->837268406]
}, Open  ]],
Cell[CellGroupData[{
Cell[4882, 182, 70, 2, 28, "Input",
 CellID->105454447],
Cell[4955, 186, 157, 5, 36, "Output",
 CellID->94974586]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5161, 197, 216, 7, 70, "ExampleSection",
 CellID->10317],
Cell[5380, 206, 72, 1, 70, "ExampleText",
 CellID->1113876286],
Cell[CellGroupData[{
Cell[5477, 211, 152, 5, 70, "Input",
 CellID->1774324750],
Cell[5632, 218, 161, 5, 36, "Output",
 CellID->197301373]
}, Open  ]],
Cell[5808, 226, 125, 3, 70, "ExampleDelimiter",
 CellID->206580424],
Cell[5936, 231, 70, 1, 70, "ExampleText",
 CellID->838884225],
Cell[CellGroupData[{
Cell[6031, 236, 145, 5, 70, "Input",
 CellID->1698859122],
Cell[6179, 243, 180, 6, 36, "Output",
 CellID->564561726]
}, Open  ]],
Cell[6374, 252, 126, 3, 70, "ExampleDelimiter",
 CellID->2063940682],
Cell[6503, 257, 74, 1, 70, "ExampleText",
 CellID->822015323],
Cell[CellGroupData[{
Cell[6602, 262, 147, 5, 70, "Input",
 CellID->2332824],
Cell[6752, 269, 213, 7, 36, "Output",
 CellID->501265830]
}, Open  ]],
Cell[CellGroupData[{
Cell[7002, 281, 112, 4, 70, "Input",
 CellID->1729906436],
Cell[7117, 287, 213, 7, 36, "Output",
 CellID->685422305]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7379, 300, 223, 7, 70, "ExampleSection",
 CellID->24865],
Cell[7605, 309, 91, 1, 70, "ExampleText",
 CellID->2078680352],
Cell[CellGroupData[{
Cell[7721, 314, 322, 12, 70, "Input",
 CellID->84768696],
Cell[8046, 328, 160, 5, 36, "Output",
 CellID->4010153]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8255, 339, 233, 7, 70, "ExampleSection",
 CellID->24952],
Cell[8491, 348, 361, 12, 70, "ExampleText",
 CellID->440092738],
Cell[8855, 362, 208, 8, 70, "Input",
 CellID->550656451],
Cell[CellGroupData[{
Cell[9088, 374, 155, 6, 70, "Input",
 CellID->532828009],
Cell[9246, 382, 203, 7, 36, "Output",
 CellID->465619533]
}, Open  ]],
Cell[CellGroupData[{
Cell[9486, 394, 115, 4, 70, "Input",
 CellID->195309579],
Cell[9604, 400, 203, 7, 36, "Output",
 CellID->320585950]
}, Open  ]],
Cell[9822, 410, 125, 3, 70, "ExampleDelimiter",
 CellID->300188328],
Cell[9950, 415, 222, 7, 70, "ExampleText",
 CellID->2065810971],
Cell[CellGroupData[{
Cell[10197, 426, 169, 6, 70, "Input",
 CellID->1887499219],
Cell[10369, 434, 159, 5, 36, "Output",
 CellID->1736880614]
}, Open  ]],
Cell[10543, 442, 125, 3, 70, "ExampleDelimiter",
 CellID->607562233],
Cell[10671, 447, 327, 12, 70, "ExampleText",
 CellID->1728269985],
Cell[CellGroupData[{
Cell[11023, 463, 146, 5, 70, "Input",
 CellID->683214900],
Cell[11172, 470, 159, 5, 36, "Output",
 CellID->1283532592]
}, Open  ]],
Cell[11346, 478, 125, 3, 70, "ExampleDelimiter",
 CellID->224632663],
Cell[11474, 483, 347, 12, 70, "ExampleText",
 CellID->73150939],
Cell[11824, 497, 248, 8, 70, "Input",
 CellID->634282679],
Cell[CellGroupData[{
Cell[12097, 509, 215, 8, 70, "Input",
 CellID->463191000],
Cell[12315, 519, 223, 7, 36, "Output",
 CellID->177942332]
}, Open  ]],
Cell[CellGroupData[{
Cell[12575, 531, 134, 4, 70, "Input",
 CellID->95912239],
Cell[12712, 537, 222, 7, 36, "Output",
 CellID->96917032]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12983, 550, 225, 7, 70, "ExampleSection",
 CellID->6719],
Cell[13211, 559, 99, 1, 70, "ExampleText",
 CellID->992262862],
Cell[CellGroupData[{
Cell[13335, 564, 89, 3, 70, "Input",
 CellID->1397421414],
Cell[13427, 569, 217, 5, 70, "Message",
 CellID->451679670],
Cell[13647, 576, 176, 6, 36, "Output",
 CellID->212760974]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13884, 589, 310, 9, 70, "SeeAlsoSection",
 CellID->5570],
Cell[14197, 600, 934, 35, 70, "SeeAlso",
 CellID->2337]
}, Open  ]],
Cell[CellGroupData[{
Cell[15168, 640, 314, 9, 70, "TutorialsSection",
 CellID->16897],
Cell[15485, 651, 161, 3, 70, "Tutorials",
 CellID->9605]
}, Open  ]],
Cell[15661, 657, 27, 0, 70, "History"],
Cell[15691, 659, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

