(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58417,       2065]
NotebookOptionsPosition[     47437,       1672]
NotebookOutlinePosition[     48824,       1711]
CellTagsIndexPosition[     48738,       1706]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Precision" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalPrecision"], 
          "The Uncertainties of Numerical Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheUncertaintiesOfNumericalMathematics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Numerical Precision\"\>", 
       2->"\<\"The Uncertainties of Numerical Mathematics\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Accuracy" :> Documentation`HelpLookup["paclet:ref/Accuracy"], 
          "RealExponent" :> 
          Documentation`HelpLookup["paclet:ref/RealExponent"], "N" :> 
          Documentation`HelpLookup["paclet:ref/N"], "Chop" :> 
          Documentation`HelpLookup["paclet:ref/Chop"], "SetPrecision" :> 
          Documentation`HelpLookup["paclet:ref/SetPrecision"], 
          "MachineNumberQ" :> 
          Documentation`HelpLookup["paclet:ref/MachineNumberQ"], 
          "MachinePrecision" :> 
          Documentation`HelpLookup["paclet:ref/MachinePrecision"], 
          "PrecisionGoal" :> 
          Documentation`HelpLookup["paclet:ref/PrecisionGoal"], 
          "WorkingPrecision" :> 
          Documentation`HelpLookup["paclet:ref/WorkingPrecision"], 
          "ExactNumberQ" :> 
          Documentation`HelpLookup["paclet:ref/ExactNumberQ"], "NumberMarks" :> 
          Documentation`HelpLookup["paclet:ref/NumberMarks"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Accuracy\"\>", 
       2->"\<\"RealExponent\"\>", 3->"\<\"N\"\>", 4->"\<\"Chop\"\>", 
       5->"\<\"SetPrecision\"\>", 6->"\<\"MachineNumberQ\"\>", 
       7->"\<\"MachinePrecision\"\>", 8->"\<\"PrecisionGoal\"\>", 
       9->"\<\"WorkingPrecision\"\>", 10->"\<\"ExactNumberQ\"\>", 
       11->"\<\"NumberMarks\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Atomic Elements of Expressions\"\>", 
       2->"\<\"Numerical Evaluation & Precision\"\>", 
       3->"\<\"Precision & Accuracy Control\"\>", 
       4->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Precision", "ObjectName",
 CellID->3826],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Precision",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Precision"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the effective number of digits of precision in \
the number ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2852]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives a measure of the relative uncertainty in the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5675],

Cell[TextData[{
 "With absolute uncertainty ",
 Cell[BoxData[
  StyleBox["dx", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"-", 
   RowBox[{
    ButtonBox["Log",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Log"], "[", 
    RowBox[{"10", ",", 
     RowBox[{
      StyleBox["dx", "TI"], "/", 
      StyleBox["x", "TI"]}]}], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24177],

Cell[TextData[{
 "For exact numbers such as integers, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20734],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " does not normally yield an integer result. "
}], "Notes",
 CellID->16620],

Cell[TextData[{
 "For any approximate number ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["RealExponent",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RealExponent"], "[", 
    StyleBox["x", "TI"], "]"}], "+", 
   RowBox[{
    ButtonBox["Accuracy",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Accuracy"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->97107366],

Cell[TextData[{
 "For machine\[Hyphen]precision numbers ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " yields ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23893],

Cell[TextData[{
 "Numbers entered in the form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["digits", "TI"], "`", 
    StyleBox["p", "TI"]}]]], "InlineFormula"],
 " are taken to have precision ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15023],

Cell[TextData[{
 "Numbers such as ",
 Cell[BoxData[
  RowBox[{"0``", 
   StyleBox["a", "TI"]}]], "InlineFormula"],
 " whose overall scale cannot be determined are treated as having zero \
precision. "
}], "Notes",
 CellID->25940],

Cell[TextData[{
 "Numbers with zero precision are output in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  RowBox[{"0.", "\[Cross]", 
   SuperscriptBox["10", 
    RowBox[{"-", 
     StyleBox["a", "TI"]}]]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is their accuracy. "
}], "Notes",
 CellID->19959],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is not a number, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives the minimum value of ",
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " for all the numbers that appear in ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " is considered smaller than any explicit precision."
}], "Notes",
 CellID->2118]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1891328],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->317305414],

Cell["Machine-precision number:", "ExampleText",
 CellID->421249407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "1.2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11096231],

Cell[BoxData["MachinePrecision"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40726994]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->69124036],

Cell["Arbitrary-precision number:", "ExampleText",
 CellID->3448096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "1.2`20", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153474450],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->713406879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158241588],

Cell["Exact number:", "ExampleText",
 CellID->297284483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"12", "/", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46174991],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193696749]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->180356269],

Cell["A zero known to accuracy 20:", "ExampleText",
 CellID->165573397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", "=", "0``20"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39426141],

Cell[BoxData["0``20."], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89129494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "z", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167591720],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->189321237]
}, Open  ]],

Cell["The precision is 0.:", "ExampleText",
 CellID->444624858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "z", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->141907394],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->287370908]
}, Open  ]],

Cell[TextData[{
 "The precision of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "+", "1"}], TraditionalForm]], "InlineMath"],
 " is the same as the accuracy of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->6099327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "z"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->319029520],

Cell[BoxData["1.`20."], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->319895705]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->103449877],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->372335302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6633176],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " attempts to get a result correct to the given precision:"
}], "ExampleText",
 CellID->11412577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"E", "+", "Pi"}], ",", "23.4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179032025],

Cell[BoxData["5.85987448204883847382293085205733533571`23.4"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147991183]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->838734594],

Cell[BoxData["23.4`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->264817522]
}, Open  ]],

Cell["This cannot always be achieved:", "ExampleText",
 CellID->332895917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"], "-", 
    SqrtBox[
     RowBox[{"5", "+", 
      RowBox[{"2", " ", 
       SqrtBox["6"]}]}]]}], ",", "23.4"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->674769444],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\@2 + \\@3 - \\@\\(5 + \\(\\(2\\\\ \\@6\\)\\)\
\\)\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->613066915],

Cell[BoxData["0``72.425083533165"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->313932283]
}, Open  ]],

Cell[TextData[{
 "This is because relative error cannot be measured at zero and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SqrtBox["2"], "+", 
     SqrtBox["3"], "-", 
     SqrtBox[
      RowBox[{
       RowBox[{"2", " ", 
        SqrtBox["6"]}], "+", "5"}]]}], "=", "0"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->649401628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"], "-", 
    SqrtBox[
     RowBox[{"5", "+", 
      RowBox[{"2", " ", 
       SqrtBox["6"]}]}]]}], "\[Equal]", "0"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->61197906],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->511577651]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16159676],

Cell["\<\
The precision of a symbolic expression is the minimum of the precisions of \
its numbers:\
\>", "ExampleText",
 CellID->776752013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"f", "[", 
   RowBox[{"2`20", ",", "3`30"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70904881],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414482249]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"3`25", "+", 
   RowBox[{"5`30", " ", 
    RowBox[{"x", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->242094160],

Cell[BoxData["25.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->818666108]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->376523236],

Cell["Check the quality of a result:", "ExampleText",
 CellID->551088138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "1000`20", "]"}], "+", "1`22"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->147132312],

Cell[BoxData["1.82687954053200256025588742911`17.511673035636893"], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->422442005]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->35230516],

Cell[BoxData["17.511673035636893`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->491841932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->368721674],

Cell["Track precision loss in a repetitive calculation:", "ExampleText",
 CellID->243398517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"logistic", "=", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"4", " ", "#", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", 
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"1", "/", "Pi"}], ",", "30"}], "]"}], ",", "20"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12630614],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.318309886183790671537767526745028724068919465732`30.", ",", 
   "0.867954810165811600375552254141204340658242320512`29.83358699570566", 
   ",", "0.458437030703366192594167986182804187589133652602`28.\
954309580979626", ",", 
   "0.99309007833298830171554900593974559151`28.687958541715883", ",", 
   "0.02744869859826984222841441846916507566`26.527431665822732", ",", 
   "0.10678107017412472570726730226536690625`26.515344185155232", ",", 
   "0.38151549290637350651196345415566890939`26.466302103575913", ",", 
   "0.94384568631512149258038655460975085698`26.25763092869219", ",", 
   "0.21200402695783509522130913584810687521`25.007014052381056", ",", 
   "0.66823327804598650176735708251893348717`24.903538050467013", ",", 
   "0.88679025663160718450293876351139003482`24.424370872189872", ",", 
   "0.40157318949942181772164212120993060195`23.47825467809718", ",", 
   "0.96124865189873308989962754932619493218`23.255265720493068", ",", 
   "0.14899872448640539016699587224472497048`21.843552536051714", ",", 
   "0.50719241835131859586878641962302165222`21.773482747074137", ",", 
   "0.99979307647303846196500989612591990944`21.46616012772981", ",", 
   "0.00082752283846211133052805116539958442`17.78196999997449", ",", 
   "0.00330735217765573976369766624255912271`17.781610462588873", ",", 
   "0.01318565439691478239879285745554853514`17.780171717255993", ",", 
   "0.05204717166015961705943987078`17.774407171582986", ",", 
   "0.19735305432934997868341913021`17.751193898265548"}], "}"}]], "Output",
 ImageSize->{552, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->798653935]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Map", "[", 
   RowBox[{"Precision", ",", "logistic"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->343669980],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 30.}, {2., 29.83358699570566}, {3., 28.954309580979626`}, {
     4., 28.687958541715883`}, {5., 26.527431665822732`}, {6., 
     26.515344185155232`}, {7., 26.466302103575913`}, {8., 
     26.25763092869219}, {9., 25.007014052381056`}, {10., 
     24.903538050467013`}, {11., 24.424370872189872`}, {12., 
     23.47825467809718}, {13., 23.255265720493068`}, {14., 
     21.843552536051714`}, {15., 21.773482747074137`}, {16., 
     21.46616012772981}, {17., 17.78196999997449}, {18., 
     17.781610462588873`}, {19., 17.780171717255993`}, {20., 
     17.774407171582986`}, {21., 17.751193898265548`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 18.},
  PlotRange->{{0., 21.}, {17.751193898265548`, 30.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8549789]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->123714036],

Cell[TextData[{
 "All machine numbers have the same precision, ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->177122592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}], " ", 
   RowBox[{"10", "^", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "300"}], ",", "300"}], "}"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216964836],

Cell[BoxData["6.006448622415221`*^117"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->730016569]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387012710],

Cell[BoxData["MachinePrecision"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33590941]
}, Open  ]],

Cell["This is 53 bits or about 16 digits:", "ExampleText",
 CellID->763851532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"MachinePrecision", "*", 
     RowBox[{"Log", "[", 
      RowBox[{"2", ",", "10"}], "]"}]}], "]"}], ",", 
   RowBox[{"N", "[", "MachinePrecision", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->57700068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"53.`", ",", "15.954589770191003`"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->415193685]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11361655],

Cell[TextData[{
 "For nonmachine numbers, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Precision", "[", 
    StyleBox["x", "TI"], "]"}], " ", "==", " ", 
   RowBox[{
    RowBox[{
     ButtonBox["RealExponent",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RealExponent"], "[", 
     StyleBox["x", "TI"], "]"}], " ", "+", " ", 
    RowBox[{
     ButtonBox["Accuracy",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Accuracy"], "[", 
     StyleBox["x", "TI"], "]"}]}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->519801120],

Cell[BoxData[
 RowBox[{
  RowBox[{"numberTypes", "=", 
   RowBox[{"{", 
    RowBox[{"123456789.987654321", ",", "0``40", ",", "2`21", ",", 
     RowBox[{"N", "[", 
      RowBox[{"Pi", ",", "18.9"}], "]"}], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"N", "[", 
      RowBox[{"Exp", "[", 
       RowBox[{"10", "+", "I"}], "]"}], "]"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->358501667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Precision", "[", "x", "]"}], ",", 
       RowBox[{"RealExponent", "[", "x", "]"}], ",", 
       RowBox[{"Accuracy", "[", "x", "]"}], ",", 
       RowBox[{
        RowBox[{"Precision", "[", "x", "]"}], "==", 
        RowBox[{
         RowBox[{"RealExponent", "[", "x", "]"}], "+", 
         RowBox[{"Accuracy", "[", "x", "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "numberTypes"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<x\>\"", ",", "\"\<Precision\>\"", ",", "\"\<RealExponent\>\"", 
        ",", "\"\<Accuracy\>\"", ",", "\"\<equality\>\""}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48002357],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"x\"\>",
       HoldForm], 
      TagBox["\<\"Precision\"\>",
       HoldForm], 
      TagBox["\<\"RealExponent\"\>",
       HoldForm], 
      TagBox["\<\"Accuracy\"\>",
       HoldForm], 
      TagBox["\<\"equality\"\>",
       HoldForm]},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "1.23456789987654321`17.091514980643627*^8", "17.091514980643627`", 
      "8.091514980643627`", "9.000000000000002`", "True"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "0``40.", "0.`", 
      RowBox[{"-", "40.`"}], "40.`", "True"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "2.`21.", "21.`", 
      "0.3010299956639812`", "20.69897000433602`", "True"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      "3.14159265358979323846264338328`18.900000000000002", 
      "18.900000000000002`", "0.4971498726941334`", "18.402850127305868`", 
      "True"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      RowBox[{"-", "7"}], "\[Infinity]", "0.8450980400142569`", "\[Infinity]",
       "True"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      RowBox[{"11900.950259059777`", "\[InvisibleSpace]", "+", 
       RowBox[{"18534.631864193456`", " ", "\[ImaginaryI]"}]}], 
      "MachinePrecision", "4.342944819032518`", "11.611644951158484`", 
      "True"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$, 
    TableHeadings -> {{}, {
      "x", "Precision", "RealExponent", "Accuracy", "equality"}}]]]], "Output",\

 ImageSize->{510, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->62365798]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31274],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " is always considered effectively smaller than any explicit precision:"
}], "ExampleText",
 CellID->5783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"{", 
   RowBox[{"3.0", ",", "2`5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15781],

Cell[BoxData["MachinePrecision"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30506]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4987],

Cell[BoxData["15.954589770191003`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14568],

Cell["\<\
Numbers with sufficiently low precision are displayed with zero mantissa: \
\>", "ExampleText",
 CellID->28192],

Cell[CellGroupData[{

Cell[BoxData["2000`0.001"], "Input",
 CellLabel->"In[1]:=",
 CellID->23714],

Cell[BoxData["2000.`0.0010000000000001132"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192614355]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1705],

Cell[TextData[{
 "The default tolerance used in ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " makes these numbers be considered the same: "
}], "ExampleText",
 CellID->11694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1`0.01", "\[Equal]", "1000`0.01"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8130],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223332811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89937797],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " is based on relative error, it is not measurable for zero:"
}], "ExampleText",
 CellID->409164920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"1", "/", "GoldenRatio"}], "-", "GoldenRatio"}], ",", "20"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->409337429],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(1 + 1\\/GoldenRatio - GoldenRatio\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->550886698],

Cell[BoxData["0``69.31389110503036"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->646250034]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375009785],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->95795711]
}, Open  ]],

Cell[TextData[{
 "You can measure the absolute size of the error with ",
 Cell[BoxData[
  ButtonBox["Accuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accuracy"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->187418523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->151560790],

Cell[BoxData["69.31389110503036`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->154461715]
}, Open  ]],

Cell[TextData[{
 "If you expect the result to be near zero, you can specify accuracy as a \
goal for ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->762571856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"1", "/", "GoldenRatio"}], "-", "GoldenRatio"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Infinity]", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->728621748],

Cell[BoxData["0``20."], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->83952052]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->224275394],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->88944670]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26598],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Accuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accuracy"]], "InlineFormula"],
 " in iterating the tent map:"
}], "ExampleText",
 CellID->23151542],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"1", "-", 
        RowBox[{"2", "#"}]}], "]"}], "&"}], ",", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"1", "/", "Pi"}], ",", "30"}], "]"}], ",", "120"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39315120],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Accuracy", "/@", "i"}]}], ";", " ", 
  RowBox[{"p", "=", 
   RowBox[{"Precision", "/@", "i"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->521809281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "p"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", "Axis"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->233071193],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXX1sHEcVX/vOd+fPxHUcozS1I9o0KarEP2ArsZMGQVPSBKQoRQJUaOz4
qwhUSIOEUICQYLdCSBWKFBGIfSoURJAiAg1xhWhSBEKgqFRIqCoKEWqCCBCq
JG3t2D7fLTPzdt7Ozn7c3pfvw89SLnt7s7+dee83b968+frY4KHxkS8MHnry
wOCGRw4OfnH8yQNPb9j51EF2K1JnGHUPGoZx7j0GuzbZlfi3yjRNI8KvxJ/4
725+YQT/In/oEKmeeYbdNsfHTaPB91lIuWEDT5lIyJQxCyvm8UQ7v2gA7N27
zb6+xampjPVco5Y+4vG8yEUcnm9ttd575cpbqVTaQoHH4K+e/Yt6oEatr20C
racnw77GYjw3yaQTLUyeWvhFE8rr9On5/v4lViwGxH4BOECLs896H8k0KZLB
khn1/7sxazQwABXMsNFUlAZfVNAQK+GWLamTJ5cCURNWHr3QEkJek5MZ0F5v
L5fXtau3ZmcXAzFVdjU4pdXdnYGi/u2NG+wXAMuGpedLaKVFk92ZM4tbty6x
DBaOjPJjgCdOpG7fnr9+/W32SyHIdfwihjUBZMlg6xm6ESsMP80/GlHGQHCU
McM28n0LfwmgY60/ezbFaIVyLgRdLUOKfzSjfFiVOn58gWEwJEQt1rsW/Ote
zP3KYrxxowlWqN6qbZv5zSj+bt3dZP0f8fm+0dJIvXa/3VnrLSsbWJ4IlEda
TSPC67RtRYUZZSWCO1HPMt0v3grf8VPkTS+5UlKPFPeKmqGmKEI63zd65VFY
9PjEBK82u3ZlHO1CoBRXISsYGLCCJzcM/qR8Hbu23htx1KtNoSTDE8imDhOC
VMsqM9FSKnb9ngw2zqasDCFrFMpOpI+zrwDiIzs1F5uz5PJer98d5QwryftM
qGs+CDnJTrTkevvl6UfkJ8Fs7MtFgsHljhQk09xZJyQX0r8pvewK545qQ/Hm
MtZiYVjimlcS6OHlag/ZBXsijD2833S2at5t5GZFln5tpPpd/p+/HxpY4rjd
jqotALSpCGP3TFwcEoauCb2rHLzYUvor/ClpoRgvcvaDS5m3/4jaoFnPnLFL
mcPL4rspyWY08+8PPruaf/9TXR/7/O97+efC0Mj8kWM8UV8ffqaGR2cPH2UX
mV77Jlzf2T+8ePRbWvrwIOnRMbuXyyl7n2Ctmnv0sDvZFRZWq8mqBFgylhzF
qKFs9EPBBwJQID2QLiSInfdgFEt7pUDx7qmoKIJJrTmjoAkNRlHlGBKlMwyK
JgEVBOpSpybI8CjeNRJRRN77uRxnZmZ7+81k0o1y8RFet96p4+bgjpFgKc0d
O8yDB+GTv4aZVOdN/qnc5Gl8fsoHJJn0sA1Uu6h2VWTtsv02DeXCzklD1qsF
I/ba6h2/O5B0xQr1qGkiy+8x/5oRc9PRUxcap7114ULRpZhzzfCUovQaWv2k
mMX38ETJXjOK48FkRQlTM/LURhiUnGtGGJScteFGuRbdYKh14n3E8armeKm0
kQfH3dooLceb3XL8zUcmmHYurd1tsfuDyOaIbDPKyuKQclsWFueMQiwuBYsb
UY7QGXjlgTFmo6E/YPRVqDUmHhOPfXmM9L10bMayw8Rj4nGF8bjNekBEO9Oj
Y4ACIck/940zkn6916LvVmIvsbey2NtiPSAHYADl5uoey3EQgwsDxFvibWXy
dmZmrq8/s+8xGAj67NrzF40dw9EkhKVt3lKvjfhaVr42qSi32rm1XYwkYNyE
MXU7WVhibLEY210IY9MTk+pIO3iwextnmF0daUh+iHhKPK0InmZ6uA3NxBOZ
Hu6rztclYEoc2FPiKfG0aDxdH6RTOcnJT45L584v9m975/jJH3/mV8yGPvd+
yzf9MDGUGFoshq4L0qns2nugCPK+2sub+P37UzgJ82GT+k3EyVJy0mcmG/aN
MPSEPSSbk2QviZsFaqMrV51Cr+hC4241vGR8lDhJnCxbnAks5UJ94qGHMpyN
jxIbiY3FYmNHeJ3CXKmXorshRGTsMcl7JP4tH/9wmojVKtv8IztIPCxQG+1Z
dYqz7exZSh8XDIxbFlBdLUBMJCbmqY02VY7QH1kYGlFHad6stwzhXsG/JoV3
/FJd+0w8JB4Wg4cwCmMmHKMwe6KWISQeEg9LxkM5A0jEsDO7Hl3Yum3uxA+0
UZZ9vgwU+8rEA/CJecQ8b200WZsQiM0XUlFu8oaGlnD05BOCc177ypG1I87l
yzloYJciMWbexhNJbXTE5pxq59S9IIl7K5B73YVwD6zcnf3D82dfnN8ycGhN
Up1h80lT7qSi7zpKTFuBTFsfnmmwNCY9OoYgYNsy8cTRo0uw4RIMaXzapEge
cctYF55b6e4e8MIQBDoEpwameqxfzMdNGp8gNoXRxuyZX7JeZXpqmqcX/cwX
WnmgLR63PS+bTWSjVjCruvLztJQxfDF29QSxidiUR5/xws5Jxxj8IPGIeJSF
R14z1/WxdOIR8YihdAShQOAzGoVtV48cSalbHhgHTPK2VzBz2oNQxCzwueY1
sBjWPldnhKwOccePO57rUrE7RtxZWdxZ60aBjb8xvqiieK4VHSfGrCTGrHGj
pO9xRA1VFJxPABHpz5nkzawAjtzlRrl9+uxiv4wFChToc1/cPIaR5c+TJVlJ
LPFDabJuig72u/XWnvzoohBLiCU34KSlKzICnKqT+2g/RewgdrC86BHdLxEv
iBcsL3qE1uYFeaTVywdcz+GnjWYbRbgVqeHRrx1edERanyYLUUOMwJUVftpo
RBTcThA7IsaXBRcipvO8XJqLXBvcWDp3HlY7BHFDcyDsCClwQ8zYDDx9l9bp
1AZbQmlDcyu+QhypdY4EjukqIOymfhrOV3NgB62zqipWBI7XChBY735xs3K6
zGGyFsQLj9NaiBc1z4u2AG2ApcBm4xum7JO4ziUn3Vej7ls8tfHyw9xZwKOI
v2lSVKIGtQzWHo//tLVMUciq0m4TRB7Nvj7cCXhoaAmb8GNUe6tbv3Frn/y6
OnVXXWOS9Fodel3lFgHMb7u8iQf2jscOOnakJb1WiV5b7dfK8RyYhaZNTjSe
pZa1sjWpjMzJGew//NSL6qRB49tUK6tDl3zcBByivwvzOr19uqcnY7WZ3yEt
VpYW2x0owowuDI3Aa8HtAWOqbpRDWqw0LbY5UKQJhU1CwMkRhpQr7znSXWXp
rsWBMjMDo9La6bHfNcmDqShtyYW/IBftzFRbW1THKkJr3rsNYoN2nPRVWfqK
e+7UZ5wgPZVLT44xKjzf1HNXO9JS2bQkxxmgdRLWTt0RDvTzPfIlllsvcjWT
8MzBqp0amMLF+t+nGlM2zaihCveesKAZOQcYpmHIPxp1LwKKs+fqjD946Suu
BiXsCO+UibNklDkxEe07zZEpAkqnI/PShnlqTB1lwQCEkSRdLZeuOhyZl7EF
T11pAQfj+dBaotmpRW6rmm0UOa6lBRhU7dizAk2aDVZy3TQiCq4YsuPiP7K1
0qBqhVeQGGmltN4dzJTEtTo/MdWZklGT9lgvkc8mFzjAaANu1QBVArRAfc0C
UFo8pQ3NNW558FOUM7E7ZxTRyKZHx6xY8awS4Yct0oaGlp7osnZJ+xlJOn8U
2VtwSNrvtHqSdAEoMzNzff3pqWkrng7jH/rZ62dIwsVCabi52nmS+M+p5XOj
3BUGBRZdX9jEOj2Wzf0F8bRAmeLCMrSuJNMAlFXXXT1wQIFoMXgFhz9w3lqj
d45kGQrFGSzU2n3jPEkxFMrMzPyWgYWTp6DDpbfpthSp3UGUZjcKdKBYe23J
7SVin3ZSO+6nBA+oHaLh4TR2iIxfk+Q0yeG+Q56Gzo4XkuRuaGdh4648nsbt
ZZKXGg9S84LmDLofF1dyKyBn+42Ps7sTExmI4GBv4rfEIjwLF44cgRPZVNME
MpKje7T3GURRYLobHLZhnzf2e1OONMhRH/ys/V061oSRIM4XhJloeOLEH8zw
e5vUxCizr7SsFeTCYlmrjePWVoQ4yQWkpdbBFcEw3/iG5WUJCwZzTE4NTKEF
++PKlNYqP2kxz2quzzooyO5zX0I7b8TUGuhfD2tPWl5nuIHXAIbK7ltfQktf
+7vvyFgNPADuOPgJ9qy7V82a8jJFlECcp8VKd80ZJbCi+q9hiWtK4/asFphF
8coDYzDjiPfv/1LrZXYHx6u9zLJPLUe2ryszNCCCg1te/7W6Syp7w9JcXVd6
w9jMvV6ddkqWTYzlZvY9BtE4bSrg69WtvyYVxT2l7o1qK50cLnKMu2sH7RmX
q61UznkbcRjrhuplewNlK9X6PEslBlKW9u6DvqlWr64st81YV0h9Ao1AzQFX
5R/l0kaXZzkwJOdXDvDC7TpytbLyn5HnAvj13XXfuGz5967jELpiOXPnH6yu
Hc/653IzvyM882EXbftEn3+VS8oh8iybAv20mbLluT1rnrEBtvcf/repRoLL
vgKuLaAM2gzwGybGZZUIkL6ipQwxDW/vHG5qZIEyVNAqHKe/LWJvzCeFuC72
Kd4y9dibLukySV56m8Kjnm3SD82+6Z3v0jLd45xMWDfHTcfVW1q7iJ7xTayX
wbHzEq548NhX0ToFVhlVslvEt7E+LtOKjFY3CpxACpq3W7x30SIX1uIpm8IY
GFHSUODEKdvPmStya6B0hF15kC1Sd3fGoZli50HG0BDF45wlO9YyvxztoXaS
Tyr3d3aGfOdtn6UwRio8y3I4V0RbCGKkcy9ZDudV2LN+zALfg7OL1C7ym/Wu
SFwe73HsVYJzcdRzy/dErZaKo0fC68WxjzfOVdHOt+Z/Df659rX36mnrOGsB
jyPjf/GcUB0ncouq7x7nz4LqYeHVM5z1ngNHa8pdX65zOjlOS6BWpCWD53UP
2/m8Kx/N2GmDLVKYRPRzADlCmylb2Ei20R5u34BosLnH9PZpdCoE1mpT9yx8
RyPbEBstyWWf3SlyRG7m3+UWC+luuzrYLQFP3GGq7bTbw+AttvA2G154/Jxj
j1aeoNNEjzX7eSVx9v30IDcpU9um7JP3eIKu8OXiKChup+Xo8tchz52IlkhJ
rnMxhl/yj7sdXHTe8U5r1P0f5jombQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[3]=",
 CellID->166603946]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27035],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MachineNumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MachineNumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MachinePrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrecisionGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrecisionGoal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExactNumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExactNumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberMarks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberMarks"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13028],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "Tutorials",
 CellID->17376],

Cell[TextData[ButtonBox["The Uncertainties of Numerical Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheUncertaintiesOfNumericalMathematics"]], "Tutorials",
 CellID->3856]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->26262174],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->12350991],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->134996362],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->196025919],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->230807783]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Precision - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 43.2640936}", "context" -> "System`", 
    "keywords" -> {
     "arbitrary precision arithmetic", "arbitrary precision numbers", 
      "relative error", "relative error interval", "significance arithmetic", 
      "significant digits"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Precision[x] gives the effective number of digits of precision in the \
number x. ", "synonyms" -> {"`"}, "title" -> "Precision", "type" -> "Symbol", 
    "uri" -> "ref/Precision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9963, 339, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1891328]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48597, 1699}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3710, 81, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4333, 108, 46, 1, 70, "ObjectName",
 CellID->3826],
Cell[4382, 111, 585, 19, 70, "Usage",
 CellID->2852]
}, Open  ]],
Cell[CellGroupData[{
Cell[5004, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5482, 152, 344, 12, 70, "Notes",
 CellID->5675],
Cell[5829, 166, 588, 24, 70, "Notes",
 CellID->24177],
Cell[6420, 192, 391, 15, 70, "Notes",
 CellID->20734],
Cell[6814, 209, 264, 9, 70, "Notes",
 CellID->16620],
Cell[7081, 220, 682, 26, 70, "Notes",
 CellID->97107366],
Cell[7766, 248, 413, 15, 70, "Notes",
 CellID->23893],
Cell[8182, 265, 296, 12, 70, "Notes",
 CellID->15023],
Cell[8481, 279, 229, 8, 70, "Notes",
 CellID->25940],
Cell[8713, 289, 458, 17, 70, "Notes",
 CellID->19959],
Cell[9174, 308, 752, 26, 70, "Notes",
 CellID->2118]
}, Closed]],
Cell[CellGroupData[{
Cell[9963, 339, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1891328],
Cell[CellGroupData[{
Cell[10346, 353, 148, 5, 70, "ExampleSection",
 CellID->317305414],
Cell[10497, 360, 68, 1, 70, "ExampleText",
 CellID->421249407],
Cell[CellGroupData[{
Cell[10590, 365, 106, 3, 28, "Input",
 CellID->11096231],
Cell[10699, 370, 173, 5, 36, "Output",
 CellID->40726994]
}, Open  ]],
Cell[10887, 378, 124, 3, 70, "ExampleDelimiter",
 CellID->69124036],
Cell[11014, 383, 68, 1, 70, "ExampleText",
 CellID->3448096],
Cell[CellGroupData[{
Cell[11107, 388, 110, 3, 70, "Input",
 CellID->153474450],
Cell[11220, 393, 161, 5, 36, "Output",
 CellID->713406879]
}, Open  ]],
Cell[11396, 401, 125, 3, 70, "ExampleDelimiter",
 CellID->158241588],
Cell[11524, 406, 56, 1, 70, "ExampleText",
 CellID->297284483],
Cell[CellGroupData[{
Cell[11605, 411, 129, 4, 70, "Input",
 CellID->46174991],
Cell[11737, 417, 168, 5, 36, "Output",
 CellID->193696749]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11954, 428, 220, 7, 70, "ExampleSection",
 CellID->180356269],
Cell[12177, 437, 71, 1, 70, "ExampleText",
 CellID->165573397],
Cell[CellGroupData[{
Cell[12273, 442, 95, 3, 70, "Input",
 CellID->39426141],
Cell[12371, 447, 162, 5, 36, "Output",
 CellID->89129494]
}, Open  ]],
Cell[CellGroupData[{
Cell[12570, 457, 104, 3, 70, "Input",
 CellID->167591720],
Cell[12677, 462, 161, 5, 36, "Output",
 CellID->189321237]
}, Open  ]],
Cell[12853, 470, 63, 1, 70, "ExampleText",
 CellID->444624858],
Cell[CellGroupData[{
Cell[12941, 475, 105, 3, 70, "Input",
 CellID->141907394],
Cell[13049, 480, 160, 5, 36, "Output",
 CellID->287370908]
}, Open  ]],
Cell[13224, 488, 268, 10, 70, "ExampleText",
 CellID->6099327],
Cell[CellGroupData[{
Cell[13517, 502, 92, 3, 70, "Input",
 CellID->319029520],
Cell[13612, 507, 164, 5, 36, "Output",
 CellID->319895705]
}, Open  ]],
Cell[CellGroupData[{
Cell[13813, 517, 105, 3, 70, "Input",
 CellID->103449877],
Cell[13921, 522, 161, 5, 36, "Output",
 CellID->372335302]
}, Open  ]],
Cell[14097, 530, 123, 3, 70, "ExampleDelimiter",
 CellID->6633176],
Cell[14223, 535, 219, 7, 70, "ExampleText",
 CellID->11412577],
Cell[CellGroupData[{
Cell[14467, 546, 148, 5, 70, "Input",
 CellID->179032025],
Cell[14618, 553, 203, 5, 36, "Output",
 CellID->147991183]
}, Open  ]],
Cell[CellGroupData[{
Cell[14858, 563, 105, 3, 70, "Input",
 CellID->838734594],
Cell[14966, 568, 162, 5, 36, "Output",
 CellID->264817522]
}, Open  ]],
Cell[15143, 576, 74, 1, 70, "ExampleText",
 CellID->332895917],
Cell[CellGroupData[{
Cell[15242, 581, 269, 11, 70, "Input",
 CellID->674769444],
Cell[15514, 594, 466, 9, 70, "Message",
 CellID->613066915],
Cell[15983, 605, 175, 5, 36, "Output",
 CellID->313932283]
}, Open  ]],
Cell[16173, 613, 370, 15, 70, "ExampleText",
 CellID->649401628],
Cell[CellGroupData[{
Cell[16568, 632, 279, 11, 70, "Input",
 CellID->61197906],
Cell[16850, 645, 161, 5, 36, "Output",
 CellID->511577651]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17060, 656, 242, 7, 70, "ExampleSection",
 CellID->16159676],
Cell[17305, 665, 140, 4, 70, "ExampleText",
 CellID->776752013],
Cell[CellGroupData[{
Cell[17470, 673, 162, 5, 70, "Input",
 CellID->70904881],
Cell[17635, 680, 161, 5, 36, "Output",
 CellID->414482249]
}, Open  ]],
Cell[CellGroupData[{
Cell[17833, 690, 183, 6, 70, "Input",
 CellID->242094160],
Cell[18019, 698, 161, 5, 36, "Output",
 CellID->818666108]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18229, 709, 227, 7, 70, "ExampleSection",
 CellID->376523236],
Cell[18459, 718, 73, 1, 70, "ExampleText",
 CellID->551088138],
Cell[CellGroupData[{
Cell[18557, 723, 131, 4, 70, "Input",
 CellID->147132312],
Cell[18691, 729, 208, 5, 36, "Output",
 CellID->422442005]
}, Open  ]],
Cell[CellGroupData[{
Cell[18936, 739, 104, 3, 70, "Input",
 CellID->35230516],
Cell[19043, 744, 176, 5, 36, "Output",
 CellID->491841932]
}, Open  ]],
Cell[19234, 752, 125, 3, 70, "ExampleDelimiter",
 CellID->368721674],
Cell[19362, 757, 92, 1, 70, "ExampleText",
 CellID->243398517],
Cell[CellGroupData[{
Cell[19479, 762, 368, 13, 70, "Input",
 CellID->12630614],
Cell[19850, 777, 1690, 29, 173, "Output",
 CellID->798653935]
}, Open  ]],
Cell[CellGroupData[{
Cell[21577, 811, 173, 5, 70, "Input",
 CellID->343669980],
Cell[21753, 818, 1069, 25, 141, "Output",
 CellID->8549789]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22871, 849, 237, 7, 70, "ExampleSection",
 CellID->123714036],
Cell[23111, 858, 244, 8, 70, "ExampleText",
 CellID->177122592],
Cell[CellGroupData[{
Cell[23380, 870, 373, 13, 70, "Input",
 CellID->216964836],
Cell[23756, 885, 180, 5, 36, "Output",
 CellID->730016569]
}, Open  ]],
Cell[CellGroupData[{
Cell[23973, 895, 105, 3, 70, "Input",
 CellID->387012710],
Cell[24081, 900, 173, 5, 36, "Output",
 CellID->33590941]
}, Open  ]],
Cell[24269, 908, 78, 1, 70, "ExampleText",
 CellID->763851532],
Cell[CellGroupData[{
Cell[24372, 913, 288, 9, 70, "Input",
 CellID->57700068],
Cell[24663, 924, 225, 7, 36, "Output",
 CellID->415193685]
}, Open  ]],
Cell[24903, 934, 124, 3, 70, "ExampleDelimiter",
 CellID->11361655],
Cell[25030, 939, 544, 19, 70, "ExampleText",
 CellID->519801120],
Cell[25577, 960, 411, 12, 70, "Input",
 CellID->358501667],
Cell[CellGroupData[{
Cell[26013, 976, 940, 27, 70, "Input",
 CellID->48002357],
Cell[26956, 1005, 2949, 84, 144, "Output",
 CellID->62365798]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29954, 1095, 226, 7, 70, "ExampleSection",
 CellID->31274],
Cell[30183, 1104, 258, 7, 70, "ExampleText",
 CellID->5783],
Cell[CellGroupData[{
Cell[30466, 1115, 152, 5, 70, "Input",
 CellID->15781],
Cell[30621, 1122, 170, 5, 36, "Output",
 CellID->30506]
}, Open  ]],
Cell[CellGroupData[{
Cell[30828, 1132, 92, 3, 70, "Input",
 CellID->4987],
Cell[30923, 1137, 171, 5, 36, "Output",
 CellID->9501]
}, Open  ]],
Cell[31109, 1145, 121, 3, 70, "ExampleDelimiter",
 CellID->14568],
Cell[31233, 1150, 121, 3, 70, "ExampleText",
 CellID->28192],
Cell[CellGroupData[{
Cell[31379, 1157, 75, 2, 70, "Input",
 CellID->23714],
Cell[31457, 1161, 184, 5, 36, "Output",
 CellID->192614355]
}, Open  ]],
Cell[31656, 1169, 120, 3, 70, "ExampleDelimiter",
 CellID->1705],
Cell[31779, 1174, 247, 8, 70, "ExampleText",
 CellID->11694],
Cell[CellGroupData[{
Cell[32051, 1186, 107, 3, 70, "Input",
 CellID->8130],
Cell[32161, 1191, 161, 5, 36, "Output",
 CellID->223332811]
}, Open  ]],
Cell[32337, 1199, 124, 3, 70, "ExampleDelimiter",
 CellID->89937797],
Cell[32464, 1204, 249, 8, 70, "ExampleText",
 CellID->409164920],
Cell[CellGroupData[{
Cell[32738, 1216, 230, 8, 70, "Input",
 CellID->409337429],
Cell[32971, 1226, 448, 8, 70, "Message",
 CellID->550886698],
Cell[33422, 1236, 177, 5, 36, "Output",
 CellID->646250034]
}, Open  ]],
Cell[CellGroupData[{
Cell[33636, 1246, 105, 3, 70, "Input",
 CellID->375009785],
Cell[33744, 1251, 159, 5, 36, "Output",
 CellID->95795711]
}, Open  ]],
Cell[33918, 1259, 235, 8, 70, "ExampleText",
 CellID->187418523],
Cell[CellGroupData[{
Cell[34178, 1271, 104, 3, 70, "Input",
 CellID->151560790],
Cell[34285, 1276, 175, 5, 36, "Output",
 CellID->154461715]
}, Open  ]],
Cell[34475, 1284, 252, 9, 70, "ExampleText",
 CellID->762571856],
Cell[CellGroupData[{
Cell[34752, 1297, 259, 8, 70, "Input",
 CellID->728621748],
Cell[35014, 1307, 162, 5, 36, "Output",
 CellID->83952052]
}, Open  ]],
Cell[CellGroupData[{
Cell[35213, 1317, 104, 3, 70, "Input",
 CellID->224275394],
Cell[35320, 1322, 160, 5, 36, "Output",
 CellID->88944670]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35529, 1333, 224, 7, 70, "ExampleSection",
 CellID->26598],
Cell[35756, 1342, 334, 12, 70, "ExampleText",
 CellID->23151542],
Cell[36093, 1356, 380, 14, 70, "Input",
 CellID->39315120],
Cell[36476, 1372, 213, 7, 70, "Input",
 CellID->521809281],
Cell[CellGroupData[{
Cell[36714, 1383, 376, 12, 70, "Input",
 CellID->233071193],
Cell[37093, 1397, 5421, 93, 70, "Output",
 Evaluatable->False,
 CellID->166603946]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42575, 1497, 311, 9, 70, "SeeAlsoSection",
 CellID->27035],
Cell[42889, 1508, 2718, 98, 70, "SeeAlso",
 CellID->15565]
}, Open  ]],
Cell[CellGroupData[{
Cell[45644, 1611, 314, 9, 70, "TutorialsSection",
 CellID->13028],
Cell[45961, 1622, 148, 3, 70, "Tutorials",
 CellID->17376],
Cell[46112, 1627, 193, 4, 70, "Tutorials",
 CellID->3856]
}, Open  ]],
Cell[CellGroupData[{
Cell[46342, 1636, 318, 9, 70, "MoreAboutSection",
 CellID->26262174],
Cell[46663, 1647, 168, 3, 70, "MoreAbout",
 CellID->12350991],
Cell[46834, 1652, 175, 3, 70, "MoreAbout",
 CellID->134996362],
Cell[47012, 1657, 167, 3, 70, "MoreAbout",
 CellID->196025919],
Cell[47182, 1662, 160, 3, 70, "MoreAbout",
 CellID->230807783]
}, Open  ]],
Cell[47357, 1668, 50, 0, 70, "History"],
Cell[47410, 1670, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

