(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32688,       1148]
NotebookOptionsPosition[     26823,        947]
NotebookOutlinePosition[     28260,        986]
CellTagsIndexPosition[     28175,        981]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Integration" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalIntegration"], 
          "Controlling the Precision of Results" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ControllingThePrecisionOfResults"], 
          "The Uncertainties of Numerical Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheUncertaintiesOfNumericalMathematics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Numerical Integration\"\>", 
       2->"\<\"Controlling the Precision of Results\"\>", 
       3->"\<\"The Uncertainties of Numerical Mathematics\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AccuracyGoal" :> 
          Documentation`HelpLookup["paclet:ref/AccuracyGoal"], 
          "WorkingPrecision" :> 
          Documentation`HelpLookup["paclet:ref/WorkingPrecision"], 
          "Precision" :> Documentation`HelpLookup["paclet:ref/Precision"], 
          "SetPrecision" :> 
          Documentation`HelpLookup["paclet:ref/SetPrecision"], "Accuracy" :> 
          Documentation`HelpLookup["paclet:ref/Accuracy"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AccuracyGoal\"\>", 
       2->"\<\"WorkingPrecision\"\>", 3->"\<\"Precision\"\>", 
       4->"\<\"SetPrecision\"\>", 5->"\<\"Accuracy\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Differential Equations" :> 
          Documentation`HelpLookup["paclet:guide/DifferentialEquations"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Differential Equations\"\>", 
       2->"\<\"Numerical Evaluation & Precision\"\>", 
       3->"\<\"Precision & Accuracy Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PrecisionGoal", "ObjectName",
 CellID->2827],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PrecisionGoal",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
     "\[LineSeparator]is an option for various numerical operations which \
specifies how many effective digits of precision should be sought in the \
final result. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12915]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " is an option for such functions as ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14337],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PrecisionGoal", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " normally yields a precision goal equal to half the setting for ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12788],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PrecisionGoal", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " specifies that precision should not be used as the criterion for \
terminating the numerical procedure. ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " is typically used in this case. "
}], "Notes",
 CellID->27255],

Cell[TextData[{
 "Even though you may specify ",
 Cell[BoxData[
  RowBox[{"PrecisionGoal", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", the results you get may sometimes have much less than ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]digit precision. "
}], "Notes",
 CellID->15177],

Cell[TextData[{
 "In most cases, you must set ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " to be at least as large as ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20851],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " effectively specifies the relative error allowed in a numerical procedure. \
"
}], "Notes",
 CellID->19968],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"PrecisionGoal", "->", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AccuracyGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AccuracyGoal"], "->", 
   StyleBox["a", "TI"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " attempts to make the numerical error in a result of size ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " be less than ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["10", 
     RowBox[{"-", 
      StyleBox["a", "TI"]}]], "+"}], "\[VerticalSeparator]", 
   StyleBox["x", "TI"], "\[VerticalSeparator]", " ", 
   SuperscriptBox["10", 
    RowBox[{"-", 
     StyleBox["p", "TI"]}]]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20584]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89053],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->79051068],

Cell["Approximate an integral to at least 10 digits of precision:", \
"ExampleText",
 CellID->488571990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", 
     RowBox[{"Sqrt", "[", "x", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->117314454],

Cell[BoxData["2.119525586696614`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->825580772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->542004814],

Cell["\<\
Use accuracy (absolute error) as the basis for error control in solving an \
ODE:\
\>", "ExampleText",
 CellID->610799303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"x", "[", "t", "]"}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "100000"}]}], "}"}], ",", 
    "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "\[Infinity]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25265625],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->875658035]
}, Open  ]],

Cell["The error is small:", "ExampleText",
 CellID->279646829],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"err", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"100000", " ", 
     RowBox[{"Exp", "[", "t", "]"}]}], "-", 
    RowBox[{"x", "[", "t", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->89748316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"err", "[", "1", "]"}], "/.", "s"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->45259306],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"-", "6.530899554491043`*^-8"}], "}"}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->46175080]
}, Open  ]],

Cell[TextData[{
 "Without specifying the ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 ", the error is much larger:"
}], "ExampleText",
 CellID->550133790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"err", "[", "1", "]"}], "/.", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"x", "[", "t", "]"}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "100000"}]}], "}"}], ",", 
    "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->47137234],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"-", "0.0021757128997705877`"}], "}"}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->489132363]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->331153410],

Cell[TextData[{
 "Find a minimum with convergence criteria ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     SubscriptBox["x", "k"], "-", 
     SuperscriptBox["x", "*"]}], "||", " ", 
    RowBox[{"\[LessEqual]", " ", 
     RowBox[{"max", "(", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]], ",", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "10"}]], "||", 
        SubscriptBox["x", "k"], "||"}]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[EmptyDownTriangle]f", "(", 
     SubscriptBox["x", "k"], ")"}], "\[LessEqual]", 
    SuperscriptBox["10", 
     RowBox[{"-", "8"}]]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->764461149],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50954599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "8"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1625295724],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.170803763674703`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->176754447]
}, Open  ]],

Cell[TextData[{
 "Try with convergence criteria ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     SubscriptBox["x", "k"], "-", 
     SuperscriptBox["x", "*"]}], "||", 
    RowBox[{"\[LessEqual]", " ", 
     RowBox[{"max", "(", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "18"}]], ",", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "20"}]], "||", 
        SubscriptBox["x", "k"], "||"}]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[EmptyDownTriangle]f", "(", 
     SubscriptBox["x", "k"], ")"}], "\[LessEqual]", 
    SuperscriptBox["10", 
     RowBox[{"-", "18"}]]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->24245662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "18"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->453268449],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"lstol\"\>"}], ":", 
  " ", "\<\"The line search decreased the step size to within tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function.  You may need more than \
\\!\\(MachinePrecision\\) digits of working precision to meet these \
tolerances.\"\>"}]], "Message", "MSG",
 CellID->315723304],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.170803763674711`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->152718031]
}, Open  ]],

Cell["Use a higher working precision to allow convergence:", "ExampleText",
 CellID->199685194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "18"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "20"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "40"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->219178825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "-", "0.9999999999999999999999999999999999999999948832025900195505`40."}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "x", "\[Rule]", 
     "2.1708037636748029780883070582387642608676704333581456734007`40."}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{342, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->256597186]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101268243],

Cell["\<\
Solve a differential equation using high precision arithmetic:\
\>", "ExampleText",
 CellID->137303445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s32", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}], 
         RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "Pi", " ", "t"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
    "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "32"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->631190080],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5.`32."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{519, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65304856]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], "/.", "s32"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->563876876],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->396270601]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " at half the 32 digit working precision:"
}], "ExampleText",
 CellID->697087395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sag", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}], 
         RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "Pi", " ", "t"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
    "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "32"}], ",", 
    RowBox[{"AccuracyGoal", "\[Rule]", "16"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "16"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->337245167],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5.`32."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{519, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->250111691]
}, Open  ]],

Cell[TextData[{
 "This corresponds to the automatic setting used by ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->13141975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s32", "===", "sag"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->509765148],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->55795473]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21745],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AccuracyGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AccuracyGoal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29745]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->377],

Cell[TextData[ButtonBox["Numerical Integration",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalIntegration"]], "Tutorials",
 CellID->9246],

Cell[TextData[ButtonBox["Controlling the Precision of Results",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ControllingThePrecisionOfResults"]], "Tutorials",\

 CellID->16020],

Cell[TextData[ButtonBox["The Uncertainties of Numerical Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheUncertaintiesOfNumericalMathematics"]], "Tutorials",
 CellID->3856]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->66072301],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DifferentialEquations"]], "MoreAbout",
 CellID->233027130],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->143031217],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->237584783]
}, Open  ]],

Cell["New in 2  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrecisionGoal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 42.8890840}", "context" -> "System`", 
    "keywords" -> {
     "approximation error", "approximation quality", "error goal", 
      "relative error", "rounding error ", "truncation error"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PrecisionGoal is an option for various numerical operations which \
specifies how many effective digits of precision should be sought in the \
final result. ", "synonyms" -> {"precision goal"}, "title" -> "PrecisionGoal",
     "type" -> "Symbol", "uri" -> "ref/PrecisionGoal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7962, 259, 356, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->89053]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28036, 974}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3041, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3664, 96, 50, 1, 70, "ObjectName",
 CellID->2827],
Cell[3717, 99, 536, 15, 70, "Usage",
 CellID->12915]
}, Open  ]],
Cell[CellGroupData[{
Cell[4290, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4768, 136, 470, 17, 70, "Notes",
 CellID->14337],
Cell[5241, 155, 414, 13, 70, "Notes",
 CellID->12788],
Cell[5658, 170, 476, 14, 70, "Notes",
 CellID->27255],
Cell[6137, 186, 319, 10, 70, "Notes",
 CellID->15177],
Cell[6459, 198, 380, 13, 70, "Notes",
 CellID->20851],
Cell[6842, 213, 255, 8, 70, "Notes",
 CellID->19968],
Cell[7100, 223, 825, 31, 70, "Notes",
 CellID->20584]
}, Closed]],
Cell[CellGroupData[{
Cell[7962, 259, 356, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89053],
Cell[CellGroupData[{
Cell[8343, 273, 147, 5, 70, "ExampleSection",
 CellID->79051068],
Cell[8493, 280, 104, 2, 70, "ExampleText",
 CellID->488571990],
Cell[CellGroupData[{
Cell[8622, 286, 331, 10, 28, "Input",
 CellID->117314454],
Cell[8956, 298, 175, 5, 36, "Output",
 CellID->825580772]
}, Open  ]],
Cell[9146, 306, 125, 3, 70, "ExampleDelimiter",
 CellID->542004814],
Cell[9274, 311, 132, 4, 70, "ExampleText",
 CellID->610799303],
Cell[CellGroupData[{
Cell[9431, 319, 535, 17, 70, "Input",
 CellID->25265625],
Cell[9969, 338, 466, 17, 36, "Output",
 CellID->875658035]
}, Open  ]],
Cell[10450, 358, 62, 1, 70, "ExampleText",
 CellID->279646829],
Cell[10515, 361, 258, 9, 70, "Input",
 CellID->89748316],
Cell[CellGroupData[{
Cell[10798, 374, 122, 4, 70, "Input",
 CellID->45259306],
Cell[10923, 380, 219, 7, 39, "Output",
 CellID->46175080]
}, Open  ]],
Cell[11157, 390, 242, 8, 70, "ExampleText",
 CellID->550133790],
Cell[CellGroupData[{
Cell[11424, 402, 503, 17, 70, "Input",
 CellID->47137234],
Cell[11930, 421, 219, 7, 36, "Output",
 CellID->489132363]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12198, 434, 220, 7, 70, "ExampleSection",
 CellID->331153410],
Cell[12421, 443, 787, 28, 70, "ExampleText",
 CellID->764461149],
Cell[13211, 473, 195, 7, 70, "Input",
 CellID->50954599],
Cell[CellGroupData[{
Cell[13431, 484, 313, 9, 70, "Input",
 CellID->1625295724],
Cell[13747, 495, 299, 11, 36, "Output",
 CellID->176754447]
}, Open  ]],
Cell[14061, 509, 772, 28, 70, "ExampleText",
 CellID->24245662],
Cell[CellGroupData[{
Cell[14858, 541, 313, 9, 70, "Input",
 CellID->453268449],
Cell[15174, 552, 416, 8, 70, "Message",
 CellID->315723304],
Cell[15593, 562, 299, 11, 36, "Output",
 CellID->152718031]
}, Open  ]],
Cell[15907, 576, 95, 1, 70, "ExampleText",
 CellID->199685194],
Cell[CellGroupData[{
Cell[16027, 581, 369, 10, 70, "Input",
 CellID->219178825],
Cell[16399, 593, 428, 15, 54, "Output",
 CellID->256597186]
}, Open  ]],
Cell[16842, 611, 125, 3, 70, "ExampleDelimiter",
 CellID->101268243],
Cell[16970, 616, 113, 3, 70, "ExampleText",
 CellID->137303445],
Cell[CellGroupData[{
Cell[17108, 623, 821, 26, 70, "Input",
 CellID->631190080],
Cell[17932, 651, 466, 17, 36, "Output",
 CellID->65304856]
}, Open  ]],
Cell[CellGroupData[{
Cell[18435, 673, 289, 9, 70, "Input",
 CellID->563876876],
Cell[18727, 684, 2319, 42, 70, "Output",
 Evaluatable->False,
 CellID->396270601]
}, Open  ]],
Cell[21061, 729, 373, 13, 70, "ExampleText",
 CellID->697087395],
Cell[CellGroupData[{
Cell[21459, 746, 928, 28, 70, "Input",
 CellID->337245167],
Cell[22390, 776, 467, 17, 36, "Output",
 CellID->250111691]
}, Open  ]],
Cell[22872, 796, 231, 8, 70, "ExampleText",
 CellID->13141975],
Cell[CellGroupData[{
Cell[23128, 808, 98, 3, 70, "Input",
 CellID->509765148],
Cell[23229, 813, 160, 5, 36, "Output",
 CellID->55795473]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23450, 825, 311, 9, 70, "SeeAlsoSection",
 CellID->21745],
Cell[23764, 836, 1220, 44, 70, "SeeAlso",
 CellID->29745]
}, Open  ]],
Cell[CellGroupData[{
Cell[25021, 885, 312, 9, 70, "TutorialsSection",
 CellID->377],
Cell[25336, 896, 151, 3, 70, "Tutorials",
 CellID->9246],
Cell[25490, 901, 181, 4, 70, "Tutorials",
 CellID->16020],
Cell[25674, 907, 193, 4, 70, "Tutorials",
 CellID->3856]
}, Open  ]],
Cell[CellGroupData[{
Cell[25904, 916, 318, 9, 70, "MoreAboutSection",
 CellID->66072301],
Cell[26225, 927, 155, 3, 70, "MoreAbout",
 CellID->233027130],
Cell[26383, 932, 175, 3, 70, "MoreAbout",
 CellID->143031217],
Cell[26561, 937, 167, 3, 70, "MoreAbout",
 CellID->237584783]
}, Open  ]],
Cell[26743, 943, 50, 0, 70, "History"],
Cell[26796, 945, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

