(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22136,        811]
NotebookOptionsPosition[     17467,        646]
NotebookOutlinePosition[     18666,        681]
CellTagsIndexPosition[     18581,        676]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Adding, Removing and Modifying List Elements" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AddingRemovingAndModifyingListElements"], 
          "Manipulating Lists by Their Indices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsByTheirIndices"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Adding, Removing and Modifying List Elements\"\>", 
       2->"\<\"Manipulating Lists by Their Indices\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Append" :> Documentation`HelpLookup["paclet:ref/Append"], 
          "Insert" :> Documentation`HelpLookup["paclet:ref/Insert"], 
          "PadRight" :> Documentation`HelpLookup["paclet:ref/PadRight"], 
          "Join" :> Documentation`HelpLookup["paclet:ref/Join"], "PrependTo" :> 
          Documentation`HelpLookup["paclet:ref/PrependTo"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Append\"\>", 2->"\<\"Insert\"\>", 
       3->"\<\"PadRight\"\>", 4->"\<\"Join\"\>", 
       5->"\<\"PrependTo\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Parts of Expressions\"\>", 
       3->"\<\"Structural Operations on Expressions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Prepend", "ObjectName",
 CellID->15815],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Prepend",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Prepend"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " prepended. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12937]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Prepend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prepend"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects, returning ordinary lists if necessary. "
}], "Notes",
 CellID->10531]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->106993491],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->67379749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prepend", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16016],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202547570]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25331],

Cell[TextData[{
 "Use a head other than ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prepend", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"x", "+", "y"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2608],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455428495]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20452],

Cell["Prepend a row to a matrix:", "ExampleText",
 CellID->17016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Prepend", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18664],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"x", "y"},
     {"a", "b"},
     {"c", "d"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{46, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->754997557]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22686],

Cell["Prepend to each row in a matrix:", "ExampleText",
 CellID->18551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Prepend", "[", 
      RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29087],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwWAKxjAQDkP0fyAJj
y///gTSEZAWRzCBRMGDQQuOzgFWxoIkyAQkmIBdGcwNpkDQPkGZlwDSVGasp
YFEWBB9iDgMrXAQiyMCFVZSNKDtYoC7kQRPnIcFMZjRRVpLMZMcSdphmspAS
FsimEW0DM5Y4Y4HSID7UsyDlGOGA3UQ1LOFCWJcq1D7iXK03qgpP/IGSBwcS
TeV0RmZaRskfNDGZ9z8k7VJiFikhAQt3wqmd2JKSG8l2BgZsrsZenimi8dFj
HbsuBajt6KUHRDVxdQCkvmBgBAD21VXQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->488924692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18345],

Cell["Prepend a vector to a matrix:", "ExampleText",
 CellID->10963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MapThread", "[", 
   RowBox[{"Prepend", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23376],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVUsOwiAQHQE/sXXvwkWN0YUm7nsBXXmIxpjowmjU++NAwdZhTGl0KQmf
B9M38Gagu+JxPJyLx2lfZNtbcT2e9vdsc7nhlOwAQI51MgYcaxzZmmuN/RBb
hXBlUde00qzaAorgGbceWFGWBBsDU+y7EHqRH1kEwsSC17y1LfcdzvaimOsY
vIfaetqCW3JnVxV2O21k7xMrwbKrFlpQvyLai3TxcuF1xWdK4uLiBLAiUm14
3gWnVeNXc+cvbu/rv1UtikY3oat7ZJJkUOsjM+4tn9vcx7iY+ZvO34xfMI90
mbvfcLVRwuvenO30bRI6jJr0vlT1ZoW75t+6KcE06vxXmfNO35DSmp5kySkF
5f8FOk9Qemq7\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->406557507]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30813],

Cell["Successively prepend to a list:", "ExampleText",
 CellID->28889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Prepend", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{"{", "a", "}"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "a"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{473, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->673124377]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prepend", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "a", ",", "b", ",", "c"}], 
  "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257551843]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11718],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1494276596]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13674],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Append",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Append"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Insert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Insert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Join",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Join"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrependTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrependTo"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16838]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23461],

Cell[TextData[ButtonBox["Adding, Removing and Modifying List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AddingRemovingAndModifyingListElements"]], "Tutorials",
 CellID->610],

Cell[TextData[ButtonBox["Manipulating Lists by Their Indices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsByTheirIndices"]], "Tutorials",\

 CellID->4047]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->75462883],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->173966951],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->510557040],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->190830534]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Prepend",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Prepend"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Prepend"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Prepend - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 45.1547670}", "context" -> "System`", 
    "keywords" -> {"prepend elements to lists"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Prepend[expr, elem] gives expr with elem prepended. ", "synonyms" -> {}, 
    "title" -> "Prepend", "type" -> "Symbol", "uri" -> "ref/Prepend"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4997, 155, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->106993491]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18438, 669}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2742, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3365, 90, 45, 1, 70, "ObjectName",
 CellID->15815],
Cell[3413, 93, 678, 23, 70, "Usage",
 CellID->12937]
}, Open  ]],
Cell[CellGroupData[{
Cell[4128, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4606, 138, 354, 12, 70, "Notes",
 CellID->10531]
}, Closed]],
Cell[CellGroupData[{
Cell[4997, 155, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->106993491],
Cell[CellGroupData[{
Cell[5382, 169, 147, 5, 70, "ExampleSection",
 CellID->67379749],
Cell[CellGroupData[{
Cell[5554, 178, 194, 7, 28, "Input",
 CellID->16016],
Cell[5751, 187, 233, 7, 36, "Output",
 CellID->202547570]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6033, 200, 239, 7, 70, "ExampleSection",
 CellID->25331],
Cell[6275, 209, 192, 8, 70, "ExampleText",
 CellID->1943],
Cell[CellGroupData[{
Cell[6492, 221, 209, 7, 70, "Input",
 CellID->2608],
Cell[6704, 230, 253, 8, 36, "Output",
 CellID->455428495]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7006, 244, 223, 7, 70, "ExampleSection",
 CellID->20452],
Cell[7232, 253, 65, 1, 70, "ExampleText",
 CellID->17016],
Cell[CellGroupData[{
Cell[7322, 258, 368, 13, 70, "Input",
 CellID->18664],
Cell[7693, 273, 742, 23, 78, "Output",
 CellID->754997557]
}, Open  ]],
Cell[8450, 299, 121, 3, 70, "ExampleDelimiter",
 CellID->22686],
Cell[8574, 304, 71, 1, 70, "ExampleText",
 CellID->18551],
Cell[CellGroupData[{
Cell[8670, 309, 400, 15, 70, "Input",
 CellID->29087],
Cell[9073, 326, 560, 13, 70, "Output",
 Evaluatable->False,
 CellID->488924692]
}, Open  ]],
Cell[9648, 342, 121, 3, 70, "ExampleDelimiter",
 CellID->18345],
Cell[9772, 347, 68, 1, 70, "ExampleText",
 CellID->10963],
Cell[CellGroupData[{
Cell[9865, 352, 446, 16, 70, "Input",
 CellID->23376],
Cell[10314, 370, 601, 14, 70, "Output",
 Evaluatable->False,
 CellID->406557507]
}, Open  ]],
Cell[10930, 387, 121, 3, 70, "ExampleDelimiter",
 CellID->30813],
Cell[11054, 392, 70, 1, 70, "ExampleText",
 CellID->28889],
Cell[CellGroupData[{
Cell[11149, 397, 238, 8, 70, "Input",
 CellID->25632],
Cell[11390, 407, 616, 19, 36, "Output",
 CellID->673124377]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12055, 432, 226, 7, 70, "ExampleSection",
 CellID->29539],
Cell[CellGroupData[{
Cell[12306, 443, 230, 8, 70, "Input",
 CellID->14990],
Cell[12539, 453, 276, 10, 36, "Output",
 CellID->257551843]
}, Open  ]],
Cell[CellGroupData[{
Cell[12852, 468, 99, 3, 70, "Input",
 CellID->11718],
Cell[12954, 473, 234, 7, 36, "Output",
 CellID->1494276596]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13249, 487, 311, 9, 70, "SeeAlsoSection",
 CellID->13674],
Cell[13563, 498, 1172, 44, 70, "SeeAlso",
 CellID->16838]
}, Open  ]],
Cell[CellGroupData[{
Cell[14772, 547, 314, 9, 70, "TutorialsSection",
 CellID->23461],
Cell[15089, 558, 194, 4, 70, "Tutorials",
 CellID->610],
Cell[15286, 564, 178, 4, 70, "Tutorials",
 CellID->4047]
}, Open  ]],
Cell[CellGroupData[{
Cell[15501, 573, 318, 9, 70, "MoreAboutSection",
 CellID->75462883],
Cell[15822, 584, 144, 3, 70, "MoreAbout",
 CellID->173966951],
Cell[15969, 589, 150, 3, 70, "MoreAbout",
 CellID->510557040],
Cell[16122, 594, 181, 3, 70, "MoreAbout",
 CellID->190830534]
}, Open  ]],
Cell[CellGroupData[{
Cell[16340, 602, 305, 8, 70, "RelatedLinksSection"],
Cell[16648, 612, 359, 12, 70, "RelatedLinks"],
Cell[17010, 626, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[17410, 642, 27, 0, 70, "History"],
Cell[17440, 644, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

