(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29536,        986]
NotebookOptionsPosition[     23951,        790]
NotebookOutlinePosition[     25208,        826]
CellTagsIndexPosition[     25123,        821]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Prime" :> Documentation`HelpLookup["paclet:ref/Prime"], 
          "NextPrime" :> Documentation`HelpLookup["paclet:ref/NextPrime"], 
          "Zeta" :> Documentation`HelpLookup["paclet:ref/Zeta"], "ZetaZero" :> 
          Documentation`HelpLookup["paclet:ref/ZetaZero"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Prime\"\>", 2->"\<\"NextPrime\"\>", 
       3->"\<\"Zeta\"\>", 4->"\<\"ZetaZero\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mathematical Functions\"\>", 
       2->"\<\"Number Theoretic Functions\"\>", 3->"\<\"Number Theory\"\>", 
       4->"\<\"Prime Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PrimePi", "ObjectName",
 CellID->22704],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PrimePi",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PrimePi"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number of primes ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Pi]", "TR"], 
       RowBox[{"(", 
        StyleBox["x", "TI"], ")"}]}]], "InlineFormula"],
     " less than or equal to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 "The argument of ",
 Cell[BoxData[
  ButtonBox["PrimePi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimePi"]], "InlineFormula"],
 " can be any positive real number. "
}], "Notes",
 CellID->25067],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimePi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimePi"], "[", "1", "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30054],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrimePi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimePi"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->376531352],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->43327349],

Cell["The number of primes up to a billion:", "ExampleText",
 CellID->4655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimePi", "[", 
  RowBox[{"10", "^", "9"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28019],

Cell[BoxData["50847534"], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->721802021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13619],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrimePi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimePi"]], "InlineFormula"],
 " increases every time there is a prime:"
}], "ExampleText",
 CellID->2948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PrimePi", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "2", ",", "3", ",", "3", ",", "4", ",", "4", 
   ",", "4", ",", "4", ",", "5", ",", "5", ",", "6", ",", "6", ",", "6", ",", 
   "6", ",", "7", ",", "7", ",", "8", ",", "8"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78278443]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22178],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrimePi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimePi"]], "InlineFormula"],
 " takes continuous arguments, but gives integer values:"
}], "ExampleText",
 CellID->13273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimePi", "[", "10.1", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23489],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259870440]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PrimePi", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25338],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiWgkGIPs/kAXG
W/7/B9KYpD6QZAYqUIXSTECaCUgrQfkMLGBlUAASZUFSxQyWNAKRIMX/wYBB
GUSwIPgQ9cgqFND4zNjkWSF8OAk2BeQ9RhBNI5sVsZpAa1uVkPjYfWoADXE1
4uxCqIDqUyXKBmRzVImziRXZJpDJ4NBgQ9aHKxwNoW5T+Y9ITbC0xwRNesh8
5v/IqQ45FXOguWwlHlFWILkW5huEmvPnngIRAyuIQOKzwfhQM1jRzCTEZxtk
6mltHzPWkFdD46uTKI/dVHyxTKooKF2torktuO3mA8s+fPg+P28zEDGwgQjm
mTNOQlVPwGoGRNfVKy9QUu/bt1/x6qKPj6gVmiywSghDBlY3IXEw1KCXWaCU
BOKKgTnJSWvsbWcCEQMfiGA+fOg+VF09WDd6OY1u2koSVKGWpTh8BEnoYICe
swZzCsbMyz9//oGmST5wmrx96w1UPh/FxZCcDkzB0HTPB0731VU7MVQP3RSM
LQ2SqwpbbjAH84HBPH/eGSBikAMRzEuXnAdGAkjK7z8kbSFqf1DaAnEhOoGp
HqpTHqzz8+efUJN9/xOXKgmrIM53Q6nURhaNQIsBPnA4bt92Aypvi+LiSLDq
588/oagG6sZQPXTTPBFphpjyEEMNSEkmWC2wjICWGXJoZYYMEeZDzACWStBS
Sg6tlIKYwUwwxYNI3CmeCafPhlJKB9ndDZadPOkYSn25etUlqGruAXIbNUOL
VmmWsE0gBbPAKoFlr7fnfFDgsoFDGJi0oTqZaeaCjWAm5tgAAyMAc9DXlw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56095719]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1384295],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->150871505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrimePi", "[", "n", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20100723],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox["\[Pi]",
    PrimePi], "(", "n", ")"}], TraditionalForm]], "Output",
 ImageSize->{24, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->35368514]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PrimePi", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23829],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWE1oFDEUTp2Z3VpQUOyvCtVLqx4EvUhBikpbRAT1pqXCuojtoVbrVqQ9
iBerqAcrCP7QIlRB681SERTEgiiIBVEQFaSC1INFsHgoCOPLSzKTZDKz09nt
4jKbbPJe3vfey3t5md2byXUe7c7kurKZ+rbezInOruyp+taeXpiyyggh4/A9
U0Pgtwu/8DvuutAH2wZobWBYAv0S6OvoLJ1wxYfO1vLe4n2NNq6G3pKkWFJP
SCNtHSbTa5GXWB4SypCQDRyVtEnJHGa+VTH5KiMRhY7UoWW0x7kNsbSkDMTx
sLm06v9A/40GjoBMna5gxLWiksdAiIQi610ViWYZKVWL6OeGmLLD9aY5JrLG
myxprDS6ajabz4Y6yYKws0E/E/yzQT6Llmk6j0bMVkB7DyZtI4+zyGO7xHil
tidl9OpabbwmDz0fv4TiR/Ds7J+pt9+hveNRabSgindHp3qOP4LWp8WNF32W
5duH9z8ADJ7p6V/DCh7Snbm5+b7cBGDCc+XyJBkuGBc9b3/+9JPhggK3FFz0
iTN4/jkDHeh/Mj//l9wsGLccx4A4MvwGHmLTxgL7OH1I0WIpck+++Kpwz8z8
VripLRRCjyamQbnJ4wvmWo7+AGSmCTzgO3I1dC0dRq1JcQvNOqe0WT0vGFea
y9CpK3AMPlW89njiI6dfVHy8ErlhdyGefW7weYA76Z6zCjL24B3TB3BoLA0q
WtSimd5Og7IXEuFSWSy/QQqLXWLTxoIQ59xnjTJW4xh2i2UEsWlD/RK5Ko4+
65H6+tU3rk8a9bk29JJznzbKWCf2heuTRn382GereOHhH1H7zFEVrO16lJtz
I946Otzkmk6NXEJ0lGZ7OwJnY18J7Aiu41cE/Ihbg8P7zbgCLG7efgMekqaN
lGtdiaImPJa2IRXKUsuu2xTKRrzskYecO1tkvGbcUdhLZl9H+326o5mCUXa4
0dl2UNFipxud0YxbvOmwjwCMyAVp1oofQQtY1eaachiqAKfviy2VDpk0SAPl
HIHYC0oL3I4jvBC42+vVJ5gFtmuuPPtx7N0quL1+dW9VdvUAcsM5qNjje8fn
Thplh9A+uQJThVoULdrz8CTF7sCxX4XTWFdZ8aOkJkWLwyJSeBVm3FAzubSm
gvU5hmP9LgW2cvpWRZ9OsZMhNy/GLf9jY44wfrkmclvsqtONO+jlBTzPnn4h
W3CRnEskBjaT5WUsewVIKEt4QLZhIR6IqjsncQXopuQOvCTw6GowxgBb5b1t
kJR2HplXxakTA0iFeFVOaNgHzl1vlNHv8hwJqQLmVXH0Oefy+FXqsl8nqxNJ
Dse7hFS48HC8CsTz73gVrsgX9cYWkjW2HC36KVuc2sRW5eMSOXZd7NSe3SNo
Gjb+6eGYpUVYGJXZ5vcdUwUaw6ng/8mk7B/HdD+G\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74721069]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28989],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["PrimePi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimePi"]], "InlineFormula"],
 " compared with estimates:"
}], "ExampleText",
 CellID->28298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PrimePi", "[", "n", "]"}], ",", 
     RowBox[{"n", "/", 
      RowBox[{"Log", "[", "n", "]"}]}], ",", 
     RowBox[{"LogIntegral", "[", "n", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1.5", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27883],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->130084506]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18421],

Cell[TextData[{
 "For primes, ",
 Cell[BoxData[
  ButtonBox["Prime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prime"]], "InlineFormula"],
 " is effectively the inverse of ",
 Cell[BoxData[
  ButtonBox["PrimePi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimePi"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimePi", "[", "997", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30437],

Cell[BoxData["168"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24328034]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prime", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13384],

Cell[BoxData["997"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->113843979]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24022],

Cell[TextData[{
 "Integrate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    TagBox["\[Pi]",
     PrimePi], "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->24787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PrimePi", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9193],

Cell[BoxData["23"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70502871]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27935],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NextPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NextPrime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Zeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Zeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ZetaZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZetaZero"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32215]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3285],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->32085]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->16921],

Cell[TextData[{
 ButtonBox["Demonstrations with PrimePi",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=PrimePi"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#12788"], None}]], "RelatedLinks",
 CellID->305696279],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/PrimeCountingFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/NumberTheoryFunctions/PrimePi/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
PrimePi"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->685526411],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->25292188],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->75630079],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->530728811],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->191741359]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrimePi - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 52.8268384}", "context" -> "System`", 
    "keywords" -> {"distribution of primes", "prime counting function"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PrimePi[x] gives the number of primes \\[Pi] (x) less than or equal to \
x. ", "synonyms" -> {"prime pi"}, "title" -> "PrimePi", "type" -> "Symbol", 
    "uri" -> "ref/PrimePi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5262, 173, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->376531352]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24980, 814}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2507, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3130, 84, 45, 1, 70, "ObjectName",
 CellID->22704],
Cell[3178, 87, 720, 24, 70, "Usage",
 CellID->16736]
}, Open  ]],
Cell[CellGroupData[{
Cell[3935, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4413, 133, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4548, 139, 220, 8, 70, "Notes",
 CellID->25067],
Cell[4771, 149, 248, 10, 70, "Notes",
 CellID->30054],
Cell[5022, 161, 203, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[5262, 173, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->376531352],
Cell[CellGroupData[{
Cell[5647, 187, 147, 5, 70, "ExampleSection",
 CellID->43327349],
Cell[5797, 194, 75, 1, 70, "ExampleText",
 CellID->4655],
Cell[CellGroupData[{
Cell[5897, 199, 123, 4, 28, "Input",
 CellID->28019],
Cell[6023, 205, 165, 5, 36, "Output",
 CellID->721802021]
}, Open  ]],
Cell[6203, 213, 121, 3, 70, "ExampleDelimiter",
 CellID->13619],
Cell[6327, 218, 209, 7, 70, "ExampleText",
 CellID->2948],
Cell[CellGroupData[{
Cell[6561, 229, 205, 7, 70, "Input",
 CellID->12656],
Cell[6769, 238, 394, 10, 36, "Output",
 CellID->78278443]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7212, 254, 216, 7, 70, "ExampleSection",
 CellID->22178],
Cell[7431, 263, 225, 7, 70, "ExampleText",
 CellID->13273],
Cell[CellGroupData[{
Cell[7681, 274, 102, 3, 70, "Input",
 CellID->23489],
Cell[7786, 279, 158, 5, 36, "Output",
 CellID->259870440]
}, Open  ]],
Cell[CellGroupData[{
Cell[7981, 289, 214, 7, 70, "Input",
 CellID->25338],
Cell[8198, 298, 1066, 22, 70, "Output",
 Evaluatable->False,
 CellID->56095719]
}, Open  ]],
Cell[9279, 323, 123, 3, 70, "ExampleDelimiter",
 CellID->1384295],
Cell[9405, 328, 203, 7, 70, "ExampleText",
 CellID->150871505],
Cell[CellGroupData[{
Cell[9633, 339, 140, 4, 70, "Input",
 CellID->20100723],
Cell[9776, 345, 259, 9, 50, "Output",
 CellID->35368514]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10084, 360, 223, 7, 70, "ExampleSection",
 CellID->31465],
Cell[CellGroupData[{
Cell[10332, 371, 215, 7, 70, "Input",
 CellID->23829],
Cell[10550, 380, 1655, 31, 70, "Output",
 Evaluatable->False,
 CellID->74721069]
}, Open  ]],
Cell[12220, 414, 121, 3, 70, "ExampleDelimiter",
 CellID->28989],
Cell[12344, 419, 206, 8, 70, "ExampleText",
 CellID->28298],
Cell[CellGroupData[{
Cell[12575, 431, 379, 12, 70, "Input",
 CellID->27883],
Cell[12957, 445, 4384, 76, 70, "Output",
 Evaluatable->False,
 CellID->130084506]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17390, 527, 233, 7, 70, "ExampleSection",
 CellID->18421],
Cell[17626, 536, 338, 13, 70, "ExampleText",
 CellID->14039],
Cell[CellGroupData[{
Cell[17989, 553, 101, 3, 70, "Input",
 CellID->30437],
Cell[18093, 558, 159, 5, 36, "Output",
 CellID->24328034]
}, Open  ]],
Cell[CellGroupData[{
Cell[18289, 568, 97, 3, 70, "Input",
 CellID->13384],
Cell[18389, 573, 160, 5, 36, "Output",
 CellID->113843979]
}, Open  ]],
Cell[18564, 581, 121, 3, 70, "ExampleDelimiter",
 CellID->24022],
Cell[18688, 586, 194, 9, 70, "ExampleText",
 CellID->24787],
Cell[CellGroupData[{
Cell[18907, 599, 218, 7, 70, "Input",
 CellID->9193],
Cell[19128, 608, 158, 5, 36, "Output",
 CellID->70502871]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19347, 620, 311, 9, 70, "SeeAlsoSection",
 CellID->27935],
Cell[19661, 631, 929, 35, 70, "SeeAlso",
 CellID->32215]
}, Open  ]],
Cell[CellGroupData[{
Cell[20627, 671, 313, 9, 70, "TutorialsSection",
 CellID->3285],
Cell[20943, 682, 198, 4, 70, "Tutorials",
 CellID->32085]
}, Open  ]],
Cell[CellGroupData[{
Cell[21178, 691, 321, 9, 70, "RelatedLinksSection",
 CellID->16921],
Cell[21502, 702, 359, 12, 70, "RelatedLinks"],
Cell[21864, 716, 271, 6, 70, "RelatedLinks",
 CellID->305696279],
Cell[22138, 724, 192, 4, 70, "RelatedLinks"],
Cell[22333, 730, 201, 4, 70, "RelatedLinks"],
Cell[22537, 736, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22959, 754, 319, 9, 70, "MoreAboutSection",
 CellID->685526411],
Cell[23281, 765, 154, 3, 70, "MoreAbout",
 CellID->25292188],
Cell[23438, 770, 161, 3, 70, "MoreAbout",
 CellID->75630079],
Cell[23602, 775, 137, 3, 70, "MoreAbout",
 CellID->530728811],
Cell[23742, 780, 137, 3, 70, "MoreAbout",
 CellID->191741359]
}, Open  ]],
Cell[23894, 786, 27, 0, 70, "History"],
Cell[23924, 788, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

