(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33874,       1305]
NotebookOptionsPosition[     26187,       1035]
NotebookOutlinePosition[     27515,       1074]
CellTagsIndexPosition[     27429,       1069]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplifying with Assumptions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SimplifyingWithAssumptions"], "Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Simplifying with Assumptions\"\>", 
       2->"\<\"Using Assumptions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "PrimeQ" :> Documentation`HelpLookup["paclet:ref/PrimeQ"], "Prime" :> 
          Documentation`HelpLookup["paclet:ref/Prime"], "Integers" :> 
          Documentation`HelpLookup["paclet:ref/Integers"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Element\"\>", 2->"\<\"Simplify\"\>",
        3->"\<\"PrimeQ\"\>", 4->"\<\"Prime\"\>", 
       5->"\<\"Integers\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>", 
       2->"\<\"Number Recognition\"\>", 3->"\<\"Number Theory\"\>", 
       4->"\<\"Prime Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Primes", "ObjectName",
 CellID->13039],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Primes",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Primes"]], "InlineFormula"],
     "\[LineSeparator]represents the domain of prime numbers, as in ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "\[Element]", "Primes"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7810]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Element]", "Primes"}]], "InlineFormula"],
 " evaluates only if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a numeric quantity. "
}], "Notes",
 CellID->27214],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], "\[Element]", "Primes"}], "]"}]], 
  "InlineFormula"],
 " can be used to try to determine whether an expression corresponds to a \
prime number. "
}], "Notes",
 CellID->4751],

Cell["\<\
The domain of primes is taken to be a subset of the domain of integers. \
\>", "Notes",
 CellID->4432],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " unless ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " explicitly has head ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7985],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Primes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Primes"]], "InlineFormula"],
 " is output in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalP]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->17684]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5958279],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->333248400],

Cell[TextData[{
 "The number ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", "107"], "-", "1"}], TraditionalForm]], "InlineMath"],
 " is a prime:"
}], "ExampleText",
 CellID->1984642532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", "107"}], "-", "1"}], ",", "Primes"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1171030120],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1850016701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->304033470],

Cell["Fermat's little theorem:", "ExampleText",
 CellID->1779089361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"a", "^", "p"}], ",", "p"}], "]"}], "\[Equal]", 
    RowBox[{"Mod", "[", 
     RowBox[{"a", ",", "p"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{"a", ",", "Integers"}], "]"}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"p", ",", "Primes"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1740073146],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1962452441]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12940960],

Cell["Find primes satisfying an inequality:", "ExampleText",
 CellID->314968886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"10", "^", "6"}], "<", "x", "<", 
    RowBox[{
     RowBox[{"10", "^", "6"}], "+", "100"}]}], ",", "x", ",", "Primes"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333962027],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "1000003"}], "||", 
  RowBox[{"x", "\[Equal]", "1000033"}], "||", 
  RowBox[{"x", "\[Equal]", "1000037"}], "||", 
  RowBox[{"x", "\[Equal]", "1000039"}], "||", 
  RowBox[{"x", "\[Equal]", "1000081"}], "||", 
  RowBox[{"x", "\[Equal]", "1000099"}]}]], "Output",
 ImageSize->{566, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276859475]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->442783681],

Cell["Test domain membership of a numeric expression:  ", "ExampleText",
 CellID->594525347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"107", ",", "Primes"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217419318],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1884325261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141169714],

Cell["Make domain membership assumptions:", "ExampleText",
 CellID->261361710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"GCD", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"p", "|", "q"}], ",", "Primes"}], "]"}], "&&", 
    RowBox[{"p", "\[NotEqual]", "q"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143649669],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->506853418]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->707367836],

Cell[TextData[{
 "Specify the default domain for ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->24255137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "10"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Primes"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->421960511],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "2"}], "&&", 
  RowBox[{"y", "\[Equal]", "2"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42552380]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"p", ">", 
    RowBox[{"10", "^", "10"}]}], ",", "p", ",", "Primes"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->618438515],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"p", "\[Rule]", "10000001959"}], "}"}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->225679153]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->241367718],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->263471383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Primes", "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1101018048],

Cell[BoxData[
 FormBox[
  TagBox["\[DoubleStruckCapitalP]",
   Function[{}, Primes]], TraditionalForm]], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->913319318]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->239198308],

Cell[TextData[{
 "Wilson's theorem ",
 ButtonBox["[more info]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/WilsonsTheorem.html"], None}],
 ":"
}], "ExampleText",
 CellID->1636017044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}], "!"}], ",", "p"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"p", ",", "Primes"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219635805],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "p"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48892577]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->357693504],

Cell["A list of twin primes:", "ExampleText",
 CellID->1087531164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", " ", "/.", 
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"p", ",", "Primes"}], "]"}], " ", "&&", " ", 
     RowBox[{"Element", "[", 
      RowBox[{
       RowBox[{"p", "+", "2"}], ",", "Primes"}], "]"}]}], ",", "p", ",", 
    "5"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1660278848],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"67217", ",", "33827", ",", "72221", ",", "11057", ",", "52541"}], 
  "}"}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2057600888]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->902953731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"And", " ", "@@", " ", 
     RowBox[{"PrimeQ", "[", 
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"#", "+", "2"}]}], "}"}], "]"}]}], ")"}], "&"}], " ", "/@", 
  " ", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1226985227],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1168956975]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->604106546],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Primes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Primes"]], "InlineFormula"],
 " is contained in ",
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Algebraics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Algebraics"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rationals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationals"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->356793860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Refine", "[", 
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "#"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "Primes"}], "]"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "Complexes", ",", "Reals", ",", "Algebraics", ",", "Rationals", ",", 
    "Integers"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134385914],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246448383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->457992686],

Cell["Simplifications involving prime numbers:", "ExampleText",
 CellID->2059095393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"p", "+", "1"}], "\[Element]", "Primes"}], ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "Primes"}], "&&", 
    RowBox[{"p", ">", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517298746],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1988626717]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"p", "+", "q"}], ")"}], "\[Pi]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "Primes"}], "&&", 
    RowBox[{"q", "\[Element]", "Primes"}], "&&", 
    RowBox[{"p", ">", "2"}], "&&", 
    RowBox[{"q", ">", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1842698950],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1561234358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31422977],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Primes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Primes"]], "InlineFormula"],
 " represents the set of positive integers that are prime:"
}], "ExampleText",
 CellID->113490503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{"#", ",", "Primes"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"17", ",", 
    RowBox[{"-", "17"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140979848],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35951931]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if an integer, positive or negative, is prime:"
}], "ExampleText",
 CellID->1767807299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "/@", 
  RowBox[{"{", 
   RowBox[{"17", ",", 
    RowBox[{"-", "17"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1588335686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55805717]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for explicit numeric primes and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " otherwise:"
}], "ExampleText",
 CellID->658707985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "/@", 
  RowBox[{"{", 
   RowBox[{"7", ",", "a", ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"E", "+", "7"}], ")"}], "^", "2"}], "/", "7"}], "-", 
     RowBox[{
      RowBox[{"E", "^", "2"}], "/", "7"}], "-", 
     RowBox[{"2", "E"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->214818019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "False"}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->180935352]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Element",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Element"]], "InlineFormula"],
 " remains unevaluated when it cannot decide whether an expression is a \
prime:"
}], "ExampleText",
 CellID->180188583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{"#", ",", "Primes"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"7", ",", "a", ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"E", "+", "7"}], ")"}], "^", "2"}], "/", "7"}], "-", 
     RowBox[{
      RowBox[{"E", "^", "2"}], "/", "7"}], "-", 
     RowBox[{"2", "E"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->445605478],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", 
   RowBox[{"a", "\[Element]", "Primes"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ExponentialE]"}], "-", 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", "2"], "7"], "+", 
     RowBox[{
      FractionBox["1", "7"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"7", "+", "\[ExponentialE]"}], ")"}], "2"]}]}], "\[Element]", 
    "Primes"}]}], "}"}]], "Output",
 ImageSize->{315, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->349350056]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->64597674],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", 
   RowBox[{"a", "\[Element]", "Primes"}], ",", "True"}], "}"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->53010413]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15012],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13440]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23301],

Cell[TextData[ButtonBox["Simplifying with Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingWithAssumptions"]], "Tutorials",
 CellID->24535],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->9502]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->148098],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->84021636],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->562556913],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->126944521],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->614675190]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Primes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 12, 55.4362802}", "context" -> "System`", 
    "keywords" -> {"prime domain", "prime number", "primes"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Primes represents the domain of prime numbers, as in x \\[Element] \
Primes. ", 
    "synonyms" -> {
     "prime numbers", "prime number solutions", "prime number variables", 
      "primes"}, "title" -> "Primes", "type" -> "Symbol", "uri" -> 
    "ref/Primes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6135, 203, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5958279]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27288, 1062}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2676, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3299, 87, 44, 1, 70, "ObjectName",
 CellID->13039],
Cell[3346, 90, 542, 17, 70, "Usage",
 CellID->7810]
}, Open  ]],
Cell[CellGroupData[{
Cell[3925, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4403, 129, 248, 9, 70, "Notes",
 CellID->27214],
Cell[4654, 140, 350, 12, 70, "Notes",
 CellID->4751],
Cell[5007, 154, 112, 3, 70, "Notes",
 CellID->4432],
Cell[5122, 159, 561, 22, 70, "Notes",
 CellID->7985],
Cell[5686, 183, 412, 15, 70, "Notes",
 CellID->17684]
}, Closed]],
Cell[CellGroupData[{
Cell[6135, 203, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5958279],
Cell[CellGroupData[{
Cell[6518, 217, 148, 5, 70, "ExampleSection",
 CellID->333248400],
Cell[6669, 224, 203, 8, 70, "ExampleText",
 CellID->1984642532],
Cell[CellGroupData[{
Cell[6897, 236, 183, 6, 28, "Input",
 CellID->1171030120],
Cell[7083, 244, 162, 5, 36, "Output",
 CellID->1850016701]
}, Open  ]],
Cell[7260, 252, 125, 3, 70, "ExampleDelimiter",
 CellID->304033470],
Cell[7388, 257, 68, 1, 70, "ExampleText",
 CellID->1779089361],
Cell[CellGroupData[{
Cell[7481, 262, 463, 15, 70, "Input",
 CellID->1740073146],
Cell[7947, 279, 162, 5, 36, "Output",
 CellID->1962452441]
}, Open  ]],
Cell[8124, 287, 124, 3, 70, "ExampleDelimiter",
 CellID->12940960],
Cell[8251, 292, 80, 1, 70, "ExampleText",
 CellID->314968886],
Cell[CellGroupData[{
Cell[8356, 297, 257, 9, 70, "Input",
 CellID->333962027],
Cell[8616, 308, 442, 12, 36, "Output",
 CellID->276859475]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9107, 326, 220, 7, 70, "ExampleSection",
 CellID->442783681],
Cell[9330, 335, 92, 1, 70, "ExampleText",
 CellID->594525347],
Cell[CellGroupData[{
Cell[9447, 340, 133, 4, 70, "Input",
 CellID->217419318],
Cell[9583, 346, 162, 5, 36, "Output",
 CellID->1884325261]
}, Open  ]],
Cell[9760, 354, 125, 3, 70, "ExampleDelimiter",
 CellID->141169714],
Cell[9888, 359, 78, 1, 70, "ExampleText",
 CellID->261361710],
Cell[CellGroupData[{
Cell[9991, 364, 341, 11, 70, "Input",
 CellID->143649669],
Cell[10335, 377, 158, 5, 36, "Output",
 CellID->506853418]
}, Open  ]],
Cell[10508, 385, 125, 3, 70, "ExampleDelimiter",
 CellID->707367836],
Cell[10636, 390, 346, 13, 70, "ExampleText",
 CellID->24255137],
Cell[CellGroupData[{
Cell[11007, 407, 302, 10, 70, "Input",
 CellID->421960511],
Cell[11312, 419, 240, 8, 36, "Output",
 CellID->42552380]
}, Open  ]],
Cell[CellGroupData[{
Cell[11589, 432, 197, 6, 70, "Input",
 CellID->618438515],
Cell[11789, 440, 244, 8, 36, "Output",
 CellID->225679153]
}, Open  ]],
Cell[12048, 451, 125, 3, 70, "ExampleDelimiter",
 CellID->241367718],
Cell[12176, 456, 203, 7, 70, "ExampleText",
 CellID->263471383],
Cell[CellGroupData[{
Cell[12404, 467, 113, 3, 70, "Input",
 CellID->1101018048],
Cell[12520, 472, 261, 8, 50, "Output",
 CellID->913319318]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12830, 486, 227, 7, 70, "ExampleSection",
 CellID->239198308],
Cell[13060, 495, 219, 8, 70, "ExampleText",
 CellID->1636017044],
Cell[CellGroupData[{
Cell[13304, 507, 328, 11, 70, "Input",
 CellID->219635805],
Cell[13635, 520, 197, 7, 36, "Output",
 CellID->48892577]
}, Open  ]],
Cell[13847, 530, 125, 3, 70, "ExampleDelimiter",
 CellID->357693504],
Cell[13975, 535, 66, 1, 70, "ExampleText",
 CellID->1087531164],
Cell[CellGroupData[{
Cell[14066, 540, 379, 12, 70, "Input",
 CellID->1660278848],
Cell[14448, 554, 258, 8, 36, "Output",
 CellID->2057600888]
}, Open  ]],
Cell[14721, 565, 49, 1, 70, "ExampleText",
 CellID->902953731],
Cell[CellGroupData[{
Cell[14795, 570, 307, 11, 70, "Input",
 CellID->1226985227],
Cell[15105, 583, 253, 8, 36, "Output",
 CellID->1168956975]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15407, 597, 237, 7, 70, "ExampleSection",
 CellID->604106546],
Cell[15647, 606, 824, 32, 70, "ExampleText",
 CellID->356793860],
Cell[CellGroupData[{
Cell[16496, 642, 425, 14, 70, "Input",
 CellID->134385914],
Cell[16924, 658, 252, 8, 36, "Output",
 CellID->246448383]
}, Open  ]],
Cell[17191, 669, 125, 3, 70, "ExampleDelimiter",
 CellID->457992686],
Cell[17319, 674, 84, 1, 70, "ExampleText",
 CellID->2059095393],
Cell[CellGroupData[{
Cell[17428, 679, 279, 9, 70, "Input",
 CellID->517298746],
Cell[17710, 690, 163, 5, 36, "Output",
 CellID->1988626717]
}, Open  ]],
Cell[CellGroupData[{
Cell[17910, 700, 411, 13, 70, "Input",
 CellID->1842698950],
Cell[18324, 715, 159, 5, 36, "Output",
 CellID->1561234358]
}, Open  ]],
Cell[18498, 723, 124, 3, 70, "ExampleDelimiter",
 CellID->31422977],
Cell[18625, 728, 229, 7, 70, "ExampleText",
 CellID->113490503],
Cell[CellGroupData[{
Cell[18879, 739, 245, 9, 70, "Input",
 CellID->140979848],
Cell[19127, 750, 209, 7, 36, "Output",
 CellID->35951931]
}, Open  ]],
Cell[19351, 760, 344, 12, 70, "ExampleText",
 CellID->1767807299],
Cell[CellGroupData[{
Cell[19720, 776, 168, 6, 70, "Input",
 CellID->1588335686],
Cell[19891, 784, 208, 7, 36, "Output",
 CellID->55805717]
}, Open  ]],
Cell[20114, 794, 460, 17, 70, "ExampleText",
 CellID->658707985],
Cell[CellGroupData[{
Cell[20599, 815, 374, 13, 70, "Input",
 CellID->214818019],
Cell[20976, 830, 225, 7, 36, "Output",
 CellID->180935352]
}, Open  ]],
Cell[21216, 840, 253, 8, 70, "ExampleText",
 CellID->180188583],
Cell[CellGroupData[{
Cell[21494, 852, 452, 16, 70, "Input",
 CellID->445605478],
Cell[21949, 870, 611, 20, 54, "Output",
 CellID->349350056]
}, Open  ]],
Cell[CellGroupData[{
Cell[22597, 895, 103, 3, 70, "Input",
 CellID->64597674],
Cell[22703, 900, 257, 8, 36, "Output",
 CellID->53010413]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23021, 915, 311, 9, 70, "SeeAlsoSection",
 CellID->15012],
Cell[23335, 926, 1174, 44, 70, "SeeAlso",
 CellID->13440]
}, Open  ]],
Cell[CellGroupData[{
Cell[24546, 975, 314, 9, 70, "TutorialsSection",
 CellID->23301],
Cell[24863, 986, 165, 3, 70, "Tutorials",
 CellID->24535],
Cell[25031, 991, 143, 3, 70, "Tutorials",
 CellID->9502]
}, Open  ]],
Cell[CellGroupData[{
Cell[25211, 999, 316, 9, 70, "MoreAboutSection",
 CellID->148098],
Cell[25530, 1010, 155, 3, 70, "MoreAbout",
 CellID->84021636],
Cell[25688, 1015, 147, 3, 70, "MoreAbout",
 CellID->562556913],
Cell[25838, 1020, 137, 3, 70, "MoreAbout",
 CellID->126944521],
Cell[25978, 1025, 137, 3, 70, "MoreAbout",
 CellID->614675190]
}, Open  ]],
Cell[26130, 1031, 27, 0, 70, "History"],
Cell[26160, 1033, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

