(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37737,       1375]
NotebookOptionsPosition[     30135,       1096]
NotebookOutlinePosition[     31310,       1131]
CellTagsIndexPosition[     31224,       1126]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Repetitive Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/RepetitiveOperations"], 
          "Generating Unstructured Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GeneratingUnstructuredOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Repetitive Operations\"\>", 
       2->"\<\"Generating Unstructured Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PrintTemporary" :> 
          Documentation`HelpLookup["paclet:ref/PrintTemporary"], "CellPrint" :> 
          Documentation`HelpLookup["paclet:ref/CellPrint"], "Message" :> 
          Documentation`HelpLookup["paclet:ref/Message"], "Monitor" :> 
          Documentation`HelpLookup["paclet:ref/Monitor"], "Put" :> 
          Documentation`HelpLookup["paclet:ref/Put"], "Write" :> 
          Documentation`HelpLookup["paclet:ref/Write"], "Reap" :> 
          Documentation`HelpLookup["paclet:ref/Reap"], "EvaluationMonitor" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationMonitor"], 
          "StepMonitor" :> Documentation`HelpLookup["paclet:ref/StepMonitor"],
           "FilePrint" :> Documentation`HelpLookup["paclet:ref/FilePrint"], 
          "MessageDialog" :> 
          Documentation`HelpLookup["paclet:ref/MessageDialog"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PrintTemporary\"\>", 
       2->"\<\"CellPrint\"\>", 3->"\<\"Message\"\>", 4->"\<\"Monitor\"\>", 
       5->"\<\"Put\"\>", 6->"\<\"Write\"\>", 7->"\<\"Reap\"\>", 
       8->"\<\"EvaluationMonitor\"\>", 9->"\<\"StepMonitor\"\>", 
       10->"\<\"FilePrint\"\>", 
       11->"\<\"MessageDialog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "MathLink Packets" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkPackets"], 
          "Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"Document Generation\"\>", 3->"\<\"MathLink Packets\"\>", 
       4->"\<\"Palettes\"\>", 5->"\<\"Procedural Programming\"\>", 
       6->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Print", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Print",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Print"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as output. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7917]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In a notebook, ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " generates a cell with style ",
 Cell[BoxData["\"\<Print\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->21870],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " can print any expression, including graphics and dynamic objects."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->415],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " prints ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " concatenated together, effectively using ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->19629,
  ButtonNote->"19629"]
}], "Notes",
 CellID->4643],

Cell[TextData[{
 "With a text\[Hyphen]based interface, ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " ends its output with a single newline (line feed). "
}], "Notes",
 CellID->21700],

Cell[TextData[{
 "You can arrange to have expressions on several lines by using ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->25149,
  ButtonNote->"25149"]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->22022],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " sends its output to the channel ",
 Cell[BoxData[
  ButtonBox["$Output",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Output"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17852],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " uses the format type of ",
 Cell[BoxData[
  ButtonBox["$Output",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Output"]], "InlineFormula"],
 " as its default format type. "
}], "Notes",
 CellID->28505]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62387759],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->277053962],

Cell[TextData[{
 "Print ",
 Cell[BoxData[
  RowBox[{"x", "+", "y"}]], "InlineFormula"],
 ", then print ",
 Cell[BoxData[
  RowBox[{"a", "+", "b"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"x", "+", "y"}], "]"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"a", "+", "b"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "+", "y"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->6016],

Cell[BoxData[
 RowBox[{"a", "+", "b"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->735]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22804],

Cell["Print the first 5 primes:", "ExampleText",
 CellID->31918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"Prime", "[", "n", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4513],

Cell[CellGroupData[{

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->15408],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1594],

Cell[BoxData["5"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->31018],

Cell[BoxData["7"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->25247],

Cell[BoxData["11"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->32546]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6152],

Cell["Print graphics:", "ExampleText",
 CellID->26848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{"Circle", "[", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12561],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  ImageMargins->0.,
  ImageSize->{100, Automatic}]], "Print",
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"During evaluation of In[9]:=",
 CellID->21568]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"Sphere", "[", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13213],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}]]], "Print",
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"During evaluation of In[39]:=",
 CellID->598439521]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6689],

Cell["Print a column of expressions:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"Column", "[", 
   RowBox[{"{", 
    RowBox[{"x", ",", "aaa", ",", "z"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18781],

Cell[BoxData[
 TagBox[GridBox[{
    {"x"},
    {"aaa"},
    {"z"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  "Column"]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->29711]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14455],

Cell[TextData[{
 "Print normally prints in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", so strings do not have quotes:"
}], "ExampleText",
 CellID->12218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<this is a string\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1706],

Cell[BoxData["\<\"this is a string\"\>"], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->27934]
}, Open  ]],

Cell[TextData[{
 "Print in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"InputForm", "[", "\"\<this is a string\>\"", "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->32581],

Cell[BoxData[
 InterpretationBox[
  StyleBox["\"\<this is a string\>\"",
   ShowStringCharacters->True,
   NumberMarks->True],
  InputForm["this is a string"],
  AutoDelete->True,
  Editable->True]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->6122]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4092],

Cell[TextData[{
 "Print in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"TraditionalForm", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "3"}], "-", "1"}], ")"}]}], ",", "x"}], "]"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26873],

Cell[BoxData[
 TagBox[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["tan", 
        RowBox[{"-", "1"}]], "(", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", "x"}], "+", "1"}], 
        SqrtBox["3"]], ")"}], 
      SqrtBox["3"]]}], "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"log", "(", 
      RowBox[{"x", "-", "1"}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"log", "(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", "x", "+", "1"}], ")"}]}]}],
   TraditionalForm],
  TraditionalForm,
  Editable->True]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->28124]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7997],

Cell["Print in a specified style:", "ExampleText",
 CellID->9387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"Style", "[", 
   RowBox[{"aaa", ",", "18", ",", "Red"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31394],

Cell[BoxData[
 StyleBox["aaa",
  StripOnInput->False,
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontSize->18,
  FontColor->RGBColor[1, 0, 0]]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->27948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->686],

Cell["Print active controls:", "ExampleText",
 CellID->23414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Slider", "[", "]"}], "]"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"InputField", "[", "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8994],

Cell[CellGroupData[{

Cell[BoxData[
 SliderBox[0.5]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->330307440],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`i$$ = Null}, 
   InputFieldBox[Dynamic[Typeset`i$$]],
   DynamicModuleValues:>{}],
  InputField[
   Setting[#]]& ]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->315658911]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14781],

Cell["Print a button:", "ExampleText",
 CellID->27923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"PasteButton", "[", "\"\<xyz\>\"", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9062],

Cell[BoxData[
 ButtonBox["\<\"xyz\"\>",
  BaseStyle->"Paste"]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->20444]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23259],

Cell["Print several expressions concatenated together:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->19629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", "\"\<=\>\"", ",", "12434"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->13048],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["x", "2"], "\[InvisibleSpace]", "\<\"=\"\>", 
   "\[InvisibleSpace]", "12434"}],
  SequenceForm[$CellContext`x^2, "=", 12434],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->151199441]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1258],

Cell["Print Mersenne primes as soon as they are found:", "ExampleText",
 CellID->9247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PrimeQ", "[", 
      RowBox[{
       RowBox[{"2", "^", "n"}], "-", "1"}], "]"}], ",", 
     RowBox[{"Print", "[", "n", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "50", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23921],

Cell[CellGroupData[{

Cell[BoxData["61"], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->18779],

Cell[BoxData["89"], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->26601]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10127],

Cell["Print a sequence of graphics:", "ExampleText",
 CellID->4127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Disk", "[", "]"}], ",", 
      RowBox[{"ImageSize", "->", 
       RowBox[{"10", "n"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13211],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}],
  ImageSize->10]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->30352],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}],
  ImageSize->20]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->5793],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}],
  ImageSize->30]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->26639]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22935],

Cell[TextData[{
 "The actual expression returned by ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", "x", "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15013],

Cell[BoxData["x"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->26144],

Cell["Null", "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->25159]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29740],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrintTemporary",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrintTemporary"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellPrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Message",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Message"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Monitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Monitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Write",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Write"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reap",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reap"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StepMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StepMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FilePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FilePrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageDialog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4824]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20150],

Cell[TextData[ButtonBox["Repetitive Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepetitiveOperations"]], "Tutorials",
 CellID->2228],

Cell[TextData[ButtonBox["Generating Unstructured Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneratingUnstructuredOutput"]], "Tutorials",
 CellID->19560]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->649134704],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->306463334],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->277833276],

Cell[TextData[ButtonBox["MathLink Packets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkPackets"]], "MoreAbout",
 CellID->19601110],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->307187538],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->107954769],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->96128873]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Print - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 0.9989226}", "context" -> "System`", 
    "keywords" -> {"display", "type", "Write"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Print[expr] prints expr as output. ", "synonyms" -> {}, "title" -> 
    "Print", "type" -> "Symbol", "uri" -> "ref/Print"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12429, 344, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->62387759]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31081, 1119}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3710, 77, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4333, 104, 4189, 83, 70, "ObjectNameGrid"],
Cell[8525, 189, 534, 18, 70, "Usage",
 CellID->7917]
}, Open  ]],
Cell[CellGroupData[{
Cell[9096, 212, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9574, 229, 266, 10, 70, "Notes",
 CellID->21870],
Cell[9843, 241, 355, 10, 70, "Notes",
 CellID->415],
Cell[10201, 253, 801, 31, 70, "Notes",
 CellID->4643],
Cell[11005, 286, 255, 8, 70, "Notes",
 CellID->21700],
Cell[11263, 296, 468, 15, 70, "Notes",
 CellID->22022],
Cell[11734, 313, 318, 12, 70, "Notes",
 CellID->17852],
Cell[12055, 327, 337, 12, 70, "Notes",
 CellID->28505]
}, Closed]],
Cell[CellGroupData[{
Cell[12429, 344, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62387759],
Cell[CellGroupData[{
Cell[12813, 358, 148, 5, 70, "ExampleSection",
 CellID->277053962],
Cell[12964, 365, 205, 9, 70, "ExampleText",
 CellID->8107],
Cell[CellGroupData[{
Cell[13194, 378, 200, 7, 70, "Input",
 CellID->11463],
Cell[CellGroupData[{
Cell[13419, 389, 108, 3, 70, "Print",
 CellID->6016],
Cell[13530, 394, 107, 3, 70, "Print",
 CellID->735]
}, Open  ]]
}, Open  ]],
Cell[13664, 401, 121, 3, 70, "ExampleDelimiter",
 CellID->22804],
Cell[13788, 406, 64, 1, 70, "ExampleText",
 CellID->31918],
Cell[CellGroupData[{
Cell[13877, 411, 232, 8, 70, "Input",
 CellID->4513],
Cell[CellGroupData[{
Cell[14134, 423, 87, 2, 70, "Print",
 CellID->15408],
Cell[14224, 427, 86, 2, 70, "Print",
 CellID->1594],
Cell[14313, 431, 87, 2, 70, "Print",
 CellID->31018],
Cell[14403, 435, 87, 2, 70, "Print",
 CellID->25247],
Cell[14493, 439, 88, 2, 70, "Print",
 CellID->32546]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14642, 448, 215, 7, 70, "ExampleSection",
 CellID->6152],
Cell[14860, 457, 54, 1, 70, "ExampleText",
 CellID->26848],
Cell[CellGroupData[{
Cell[14939, 462, 161, 5, 70, "Input",
 CellID->12561],
Cell[15103, 469, 219, 6, 70, "Print",
 CellID->21568]
}, Open  ]],
Cell[CellGroupData[{
Cell[15359, 480, 163, 5, 70, "Input",
 CellID->13213],
Cell[15525, 487, 178, 4, 70, "Print",
 CellID->598439521]
}, Open  ]],
Cell[15718, 494, 120, 3, 70, "ExampleDelimiter",
 CellID->6689],
Cell[15841, 499, 117, 2, 70, "ExampleText",
 CellID->25149],
Cell[CellGroupData[{
Cell[15983, 505, 191, 6, 70, "Input",
 CellID->18781],
Cell[16177, 513, 281, 11, 70, "Print",
 CellID->29711]
}, Open  ]],
Cell[16473, 527, 121, 3, 70, "ExampleDelimiter",
 CellID->14455],
Cell[16597, 532, 243, 8, 70, "ExampleText",
 CellID->12218],
Cell[CellGroupData[{
Cell[16865, 544, 119, 3, 70, "Input",
 CellID->1706],
Cell[16987, 549, 110, 2, 70, "Print",
 CellID->27934]
}, Open  ]],
Cell[17112, 554, 190, 8, 70, "ExampleText",
 CellID->21417],
Cell[CellGroupData[{
Cell[17327, 566, 158, 5, 70, "Input",
 CellID->32581],
Cell[17488, 573, 267, 9, 70, "Print",
 CellID->6122]
}, Open  ]],
Cell[17770, 585, 120, 3, 70, "ExampleDelimiter",
 CellID->4092],
Cell[17893, 590, 202, 8, 70, "ExampleText",
 CellID->25714],
Cell[CellGroupData[{
Cell[18120, 602, 315, 11, 70, "Input",
 CellID->26873],
Cell[18438, 615, 707, 27, 70, "Print",
 CellID->28124]
}, Open  ]],
Cell[19160, 645, 120, 3, 70, "ExampleDelimiter",
 CellID->7997],
Cell[19283, 650, 65, 1, 70, "ExampleText",
 CellID->9387],
Cell[CellGroupData[{
Cell[19373, 655, 168, 5, 70, "Input",
 CellID->31394],
Cell[19544, 662, 281, 9, 70, "Print",
 CellID->27948]
}, Open  ]],
Cell[19840, 674, 119, 3, 70, "ExampleDelimiter",
 CellID->686],
Cell[19962, 679, 61, 1, 70, "ExampleText",
 CellID->23414],
Cell[CellGroupData[{
Cell[20048, 684, 213, 7, 70, "Input",
 CellID->8994],
Cell[CellGroupData[{
Cell[20286, 695, 104, 3, 70, "Print",
 CellID->330307440],
Cell[20393, 700, 240, 8, 70, "Print",
 CellID->315658911]
}, Open  ]]
}, Open  ]],
Cell[20660, 712, 121, 3, 70, "ExampleDelimiter",
 CellID->14781],
Cell[20784, 717, 54, 1, 70, "ExampleText",
 CellID->27923],
Cell[CellGroupData[{
Cell[20863, 722, 144, 4, 70, "Input",
 CellID->9062],
Cell[21010, 728, 132, 4, 70, "Print",
 CellID->20444]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21191, 738, 239, 7, 70, "ExampleSection",
 CellID->23259],
Cell[21433, 747, 135, 2, 70, "ExampleText",
 CellID->19629],
Cell[CellGroupData[{
Cell[21593, 753, 168, 6, 70, "Input",
 CellID->13048],
Cell[21764, 761, 283, 8, 70, "Print",
 CellID->151199441]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22096, 775, 222, 7, 70, "ExampleSection",
 CellID->1258],
Cell[22321, 784, 86, 1, 70, "ExampleText",
 CellID->9247],
Cell[CellGroupData[{
Cell[22432, 789, 360, 12, 70, "Input",
 CellID->23921],
Cell[CellGroupData[{
Cell[22817, 805, 88, 2, 70, "Print",
 CellID->18779],
Cell[22908, 809, 88, 2, 70, "Print",
 CellID->26601]
}, Open  ]]
}, Open  ]],
Cell[23023, 815, 121, 3, 70, "ExampleDelimiter",
 CellID->10127],
Cell[23147, 820, 67, 1, 70, "ExampleText",
 CellID->4127],
Cell[CellGroupData[{
Cell[23239, 825, 352, 12, 70, "Input",
 CellID->13211],
Cell[CellGroupData[{
Cell[23616, 841, 131, 4, 70, "Print",
 CellID->30352],
Cell[23750, 847, 130, 4, 70, "Print",
 CellID->5793],
Cell[23883, 853, 131, 4, 70, "Print",
 CellID->26639]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24075, 864, 233, 7, 70, "ExampleSection",
 CellID->22935],
Cell[24311, 873, 326, 13, 70, "ExampleText",
 CellID->9078],
Cell[CellGroupData[{
Cell[24662, 890, 129, 4, 70, "Input",
 CellID->15013],
Cell[24794, 896, 87, 2, 70, "Print",
 CellID->26144],
Cell[24884, 900, 159, 5, 50, "Output",
 CellID->25159]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25104, 912, 311, 9, 70, "SeeAlsoSection",
 CellID->29740],
Cell[25418, 923, 2677, 98, 70, "SeeAlso",
 CellID->4824]
}, Open  ]],
Cell[CellGroupData[{
Cell[28132, 1026, 314, 9, 70, "TutorialsSection",
 CellID->20150],
Cell[28449, 1037, 151, 3, 70, "Tutorials",
 CellID->2228],
Cell[28603, 1042, 169, 3, 70, "Tutorials",
 CellID->19560]
}, Open  ]],
Cell[CellGroupData[{
Cell[28809, 1050, 319, 9, 70, "MoreAboutSection",
 CellID->649134704],
Cell[29131, 1061, 173, 3, 70, "MoreAbout",
 CellID->306463334],
Cell[29307, 1066, 149, 3, 70, "MoreAbout",
 CellID->277833276],
Cell[29459, 1071, 142, 3, 70, "MoreAbout",
 CellID->19601110],
Cell[29604, 1076, 128, 3, 70, "MoreAbout",
 CellID->307187538],
Cell[29735, 1081, 155, 3, 70, "MoreAbout",
 CellID->107954769],
Cell[29893, 1086, 147, 3, 70, "MoreAbout",
 CellID->96128873]
}, Open  ]],
Cell[30055, 1092, 50, 0, 70, "History"],
Cell[30108, 1094, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

