(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    101958,       3756]
NotebookOptionsPosition[     75876,       2924]
NotebookOutlinePosition[     84942,       3163]
CellTagsIndexPosition[     83735,       3134]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sums and Products" :> 
          Documentation`HelpLookup["paclet:tutorial/SumsAndProducts"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Sums and Products\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Do" :> Documentation`HelpLookup["paclet:ref/Do"], "Sum" :> 
          Documentation`HelpLookup["paclet:ref/Sum"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"], "NProduct" :> 
          Documentation`HelpLookup["paclet:ref/NProduct"], "RSolve" :> 
          Documentation`HelpLookup["paclet:ref/RSolve"], "Times" :> 
          Documentation`HelpLookup["paclet:ref/Times"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Do\"\>", 2->"\<\"Sum\"\>", 3->"\<\"Table\"\>", 
       4->"\<\"NProduct\"\>", 5->"\<\"RSolve\"\>", 
       6->"\<\"Times\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> 
          Documentation`HelpLookup["paclet:guide/Calculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Calculus\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "Product ",
     StyleBox["(\[Product])", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Product",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Product"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates the product ",
     Cell[BoxData[
      RowBox[{
       UnderoverscriptBox["\[Product]", 
        RowBox[{
         StyleBox["i", "TI"], "=", "1"}], 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]],
        LimitsPositioning->True], " ", 
       StyleBox["f", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Product",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Product"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]starts with ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], "=", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Product",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Product"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["di", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses steps ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Product",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Product"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]uses successive values ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["i", "1"], ",", 
        SubscriptBox["i", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Product",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Product"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["j", "TI"], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates the multiple product ",
     Cell[BoxData[
      RowBox[{
       UnderoverscriptBox["\[Product]", 
        RowBox[{
         StyleBox["i", "TI"], "=", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["min", "TI"]]}], 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]],
        LimitsPositioning->True], 
       RowBox[{
        UnderoverscriptBox["\[Product]", 
         RowBox[{
          StyleBox["j", "TI"], "=", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["min", "TI"]]}], 
         SubscriptBox[
          StyleBox["j", "TI"], 
          StyleBox["max", "TI"]],
         LimitsPositioning->True], 
        RowBox[{
         StyleBox["\[Ellipsis]", "TR"], " ", 
         StyleBox["f", "TI"]}]}]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->15722]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Product",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Product"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " can be entered as ",
 Cell[BoxData[
  RowBox[{
   UnderoverscriptBox["\[Product]", 
    StyleBox["i", "TI"], 
    StyleBox[
     SubscriptBox["i", "max"], "TI"]], 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11209],

Cell[TextData[{
 Cell[BoxData["\[Product]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]prod\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Product]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Product"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->18610],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Product",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Product"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " can be entered as ",
 Cell[BoxData[
  RowBox[{
   UnderoverscriptBox["\[Product]", 
    RowBox[{
     StyleBox["i", "TI"], "=", 
     StyleBox[
      SubscriptBox["i", "min"], "TI"]}], 
    StyleBox[
     SubscriptBox["i", "max"], "TI"]], 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16279],

Cell[TextData[{
 "The limits should be underscripts and overscripts of ",
 Cell[BoxData["\[Product]"], "InlineFormula"],
 " in normal input, and subscripts and superscripts when embedded in other \
text. "
}], "Notes",
 CellID->8442],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 " uses the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " iteration specification. "
}], "Notes",
 CellID->24009],

Cell[TextData[{
 "The iteration variable ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " is treated as local, effectively using ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10984],

Cell[TextData[{
 "If the range of a product is finite, ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " is typically assigned a sequence of values, with ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " being evaluated for each one."
}], "Notes",
 CellID->1432],

Cell["\<\
In multiple products, the range of the outermost variable is given first. \
\>", "Notes",
 CellID->2383],

Cell[TextData[{
 "The limits of a product need not be numbers. They can be ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " or symbolic expressions. "
}], "Notes",
 CellID->29957],

Cell[TextData[{
 "If a product cannot be carried out explicitly by multiplying a finite \
number of terms, ",
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 " will attempt to find a symbolic result. In this case, ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " is first evaluated symbolically. "
}], "Notes",
 CellID->30402],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 " can do essentially all products that are given in standard books of \
tables. "
}], "Notes",
 CellID->26275],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 " is output in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " using ",
 Cell[BoxData["\[Product]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11430]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21575854],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->838510519],

Cell["Numeric product:", "ExampleText",
 CellID->319962190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"i", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030567868345786083,1",
 CellLabel->"In[1]:=",
 CellID->41346309],

Cell[BoxData["518400"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030567868345786083,1",
 CellLabel->"Out[1]=",
 CellID->618091247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32535520],

Cell["Symbolic product:", "ExampleText",
 CellID->21521981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"i", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030567868345786083,2",
 CellLabel->"In[1]:=",
 CellID->625339466],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"n", "!"}], ")"}], "2"]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030567868345786083,2",
 CellLabel->"Out[1]=",
 CellID->217618592]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->490212368],

Cell[TextData[{
 "Use ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]prod\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter ",
 Cell[BoxData["\[Product]"], "InlineFormula"],
 " and ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " to enter lower limit, then ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " for the upper limit: "
}], "ExampleText",
 CellID->42968189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Product]", 
   RowBox[{"i", "=", "1"}], "n"], 
  RowBox[{"i", "^", "2"}]}]], "Input",
 CellTags->"Ex--22030567868345786083,3",
 CellLabel->"In[1]:=",
 CellID->505254588],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"n", "!"}], ")"}], "2"]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030567868345786083,3",
 CellLabel->"Out[1]=",
 CellID->17771527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->222573277],

Cell["Infinite product:", "ExampleText",
 CellID->235884109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"1", "/", 
     RowBox[{"i", "^", "4"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030567868345786083,4",
 CellLabel->"In[1]:=",
 CellID->406018980],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sinh", "[", "\[Pi]", "]"}], 
  RowBox[{"4", " ", "\[Pi]"}]]], "Output",
 ImageSize->{59, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030567868345786083,4",
 CellLabel->"Out[1]=",
 CellID->8802080]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286837283],

Cell[TextData[{
 "Multiple product with product over ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " performed first:"
}], "ExampleText",
 CellID->28118046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"2", "^", 
    RowBox[{"(", 
     RowBox[{"j", "+", "i"}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "p"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "1", ",", "i"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030567868345786083,5",
 CellLabel->"In[1]:=",
 CellID->240006786],

Cell[BoxData[
 SuperscriptBox["2", 
  RowBox[{
   FractionBox["1", "2"], " ", "p", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "p"}], ")"}], "2"]}]]], "Output",
 ImageSize->{59, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030567868345786083,5",
 CellLabel->"Out[1]=",
 CellID->11739946]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(15)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23794],

Cell["The product of a constant is an exponential:", "ExampleText",
 CellID->344857222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,40",
 CellLabel->"In[1]:=",
 CellID->319363121],

Cell[BoxData[
 SuperscriptBox["a", "n"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,40",
 CellLabel->"Out[1]=",
 CellID->669849968]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->533333338],

Cell["\<\
Exponentials of polynomials will give results of the same type:\
\>", "ExampleText",
 CellID->487135429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"a", "^", 
    RowBox[{"(", 
     RowBox[{"i", "^", "2"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71108354],

Cell[BoxData[
 SuperscriptBox["a", 
  RowBox[{
   FractionBox["1", "6"], " ", "n", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "n"}]}], ")"}]}]]], "Output",
 ImageSize->{88, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150094076]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"a", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"i", "^", "2"}], "+", 
      RowBox[{"i", "^", "5"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34840622],

Cell[BoxData[
 SuperscriptBox["a", 
  RowBox[{
   FractionBox["1", "12"], " ", "n", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "n", "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["n", "3"]}]}], ")"}]}]]], "Output",
 ImageSize->{135, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->219530092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->278124480],

Cell["Exponentials of rational functions can always be done: ", "ExampleText",
 CellID->296397689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"a", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"i", 
        RowBox[{"(", 
         RowBox[{"i", "+", "1"}], ")"}]}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398413405],

Cell[BoxData[
 SuperscriptBox["a", 
  FractionBox["n", 
   RowBox[{"1", "+", "n"}]]]], "Output",
 ImageSize->{30, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131889512]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"a", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"i", "^", "2"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45345826],

Cell[BoxData[
 SuperscriptBox["a", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"\[Pi]", " ", 
      RowBox[{"Coth", "[", "\[Pi]", "]"}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], "+", "n"}]}], "]"}]}], 
     "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], "+", "n"}]}], "]"}]}]}],
     ")"}]}]]], "Output",
 ImageSize->{315, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->271257850]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->471159425],

Cell["\<\
If the exponent can be summed the corresponding product can be computed:\
\>", "ExampleText",
 CellID->479020932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"a", "^", 
    RowBox[{"(", 
     RowBox[{"i", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "i"}], "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49385515],

Cell[BoxData[
 SuperscriptBox["a", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"Csc", "[", "1", "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "n"}], ")"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "n"}], "]"}]}], "-", 
     RowBox[{"n", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "n"}], ")"}]}], "]"}]}]}], ")"}]}]]], "Output",
 ImageSize->{202, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136394409]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->701809551],

Cell[TextData[{
 "Polynomials will in general result in ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " and related functions:"
}], "ExampleText",
 CellID->403070171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"i", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"i", "+", "2"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232517014],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"2", "+", "n"}], "]"}], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"3", "+", "n"}], "]"}]}]], "Output",
 ImageSize->{173, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->343719128]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "i"}], "+", "b"}], ")"}], "^", "2"}], "-", " ", 
    RowBox[{"c", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->64719160],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox["a", "2"], ")"}], "n"], " ", 
  RowBox[{"Pochhammer", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"a", "+", "b", "-", "c"}], "a"], ",", "n"}], "]"}], " ", 
  RowBox[{"Pochhammer", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"a", "+", "b", "+", "c"}], "a"], ",", "n"}], "]"}]}]], "Output",
 ImageSize->{348, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->296875431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12534245],

Cell[TextData[{
 "Rational functions in general give quotients of ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " and related functions:"
}], "ExampleText",
 CellID->233397618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"i", "+", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"i", "+", 
      RowBox[{"1", "/", "2"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145093370],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"2", "+", "n"}], "]"}]}], 
  RowBox[{"2", " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["3", "2"], "+", "n"}], "]"}]}]]], "Output",
 ImageSize->{112, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155660208]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"i", "^", "3"}], "-", "8"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"i", "^", "3"}], "+", "8"}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->985676097],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"12", "+", 
     RowBox[{"6", " ", "n"}], "+", 
     RowBox[{"7", " ", 
      SuperscriptBox["n", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["n", "3"]}], "+", 
     SuperscriptBox["n", "4"]}], ")"}]}], 
  RowBox[{"7", " ", "n", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "-", "n", "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["n", "2"]}], "+", 
     SuperscriptBox["n", "3"]}], ")"}]}]]], "Output",
 ImageSize->{172, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26724924]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213189072],

Cell["Rational times exponential functions:", "ExampleText",
 CellID->21956245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"i", "^", "2"}], " ", 
    RowBox[{"2", "^", "i"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->828643144],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{
    FractionBox["1", "2"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}]}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"n", "!"}], ")"}], "2"]}]], "Output",
 ImageSize->{92, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53833977]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"i", "+", "1"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"i", "+", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], 
    RowBox[{"3", "^", 
     RowBox[{"(", 
      RowBox[{"i", "-", 
       RowBox[{"i", "^", "2"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->890113783],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["3", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "3"]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "n"}], ")"}]}]], " ", 
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"2", "+", "n"}], "]"}]}], 
  RowBox[{"2", " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["3", "2"], "+", "n"}], "]"}]}]]], "Output",
 ImageSize->{202, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28724806]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163912892],

Cell["Special trigonometric products: ", "ExampleText",
 CellID->15290317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "i"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"i", " ", 
      RowBox[{"Pi", "/", "n"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->848956353],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{"1", "-", "n"}]], " ", 
  SuperscriptBox["a", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n"}]], " ", 
  "n"}]], "Output",
 ImageSize->{94, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3423699]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"Sec", "[", 
    RowBox[{"1", "+", 
     RowBox[{"i", " ", 
      RowBox[{"Pi", "/", "n"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", 
     RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11886305],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]], " ", 
  RowBox[{"Csc", "[", 
   RowBox[{
    FractionBox["1", "2"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "\[Pi]"}], ")"}]}], "]"}]}]], "Output",
 ImageSize->{136, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->198899554]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"x", "/", 
     RowBox[{"2", "^", "i"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", " ", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->126245723],

Cell[BoxData[
 RowBox[{"Sinc", "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->495782668]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->287168328],

Cell["Infinite products of exponential functions:", "ExampleText",
 CellID->330097240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"2", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"i", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->658122518],

Cell[BoxData[
 SuperscriptBox["2", 
  FractionBox[
   SuperscriptBox["\[Pi]", "2"], "6"]]], "Output",
 ImageSize->{26, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2055751]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"a", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sin", "[", "i", "]"}], "/", 
      RowBox[{"i", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->761596006],

Cell[BoxData[
 SuperscriptBox["a", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "\[ImaginaryI]"}]]}], "]"}], "-", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"]}], "]"}]}], 
    ")"}]}]]], "Output",
 ImageSize->{180, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->291484803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->796376836],

Cell["Infinite products of rational functions:", "ExampleText",
 CellID->318939577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "i"}], "+", "1"}], ")"}], "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39074791],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196754241]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"i", "^", "2"}], "+", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"i", "^", "2"}], "+", 
      RowBox[{"1", "/", "2"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->187742283],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "-", 
     FractionBox["\[ImaginaryI]", 
      SqrtBox["2"]]}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", 
     FractionBox["\[ImaginaryI]", 
      SqrtBox["2"]]}], "]"}]}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "-", "\[ImaginaryI]"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[ImaginaryI]"}], "]"}]}]]], "Output",
 ImageSize->{198, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->206403463]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->433228669],

Cell["Infinite products of rational exponential functions:", "ExampleText",
 CellID->948883918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", "i"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "i"}], "+", "1"}], ")"}], "^", "5"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25320527],

Cell[BoxData[
 FractionBox[
  RowBox[{"5", " ", 
   SuperscriptBox["\[Pi]", "5"]}], "1536"]], "Output",
 ImageSize->{37, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237721914]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"1", "/", "i"}]}], ")"}], 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "i"}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->233372662],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", "EulerGamma"}]]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->546597704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62043496],

Cell["Products of algebraic functions:", "ExampleText",
 CellID->256247123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"i", "+", "1"}], ")"}], "^", "a"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"i", "+", "2"}], ")"}], "^", "b"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25149235],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", "b"], " ", 
  SuperscriptBox[
   RowBox[{"Gamma", "[", 
    RowBox[{"2", "+", "n"}], "]"}], "a"], " ", 
  SuperscriptBox[
   RowBox[{"Gamma", "[", 
    RowBox[{"3", "+", "n"}], "]"}], 
   RowBox[{"-", "b"}]]}]], "Output",
 ImageSize->{190, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237285634]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", "i"}], "-", "1"}], ")"}], "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"9", "i"}], "-", "6"}], ")"}], "i"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->541243147],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   RowBox[{"Gamma", "[", 
    FractionBox["1", "3"], "]"}]], 
  RowBox[{"Gamma", "[", 
   FractionBox["2", "3"], "]"}]]], "Output",
 ImageSize->{88, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->443932039]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->551472604],

Cell[TextData[{
 "Euler's product for the ",
 Cell[BoxData[
  ButtonBox["Zeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Zeta"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->34454062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"1", "/", 
       RowBox[{
        RowBox[{"Prime", "[", "i", "]"}], "^", "s"}]}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", " ", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,23",
 CellLabel->"In[1]:=",
 CellID->552679402],

Cell[BoxData[
 RowBox[{"Zeta", "[", "s", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,23",
 CellLabel->"Out[1]=",
 CellID->299774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292549264],

Cell["Weierstrass factorizations for trigonometric functions:", "ExampleText",
 CellID->79804725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", " ", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Pi", "^", "2"}], " ", 
        RowBox[{"i", "^", "2"}]}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198512892],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    SuperscriptBox["z", "2"]], " ", 
   RowBox[{"Sin", "[", 
    SqrtBox[
     SuperscriptBox["z", "2"]], "]"}]}], "z"]], "Output",
 ImageSize->{109, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299596028]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"4", " ", 
       RowBox[{"z", "^", "2"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Pi", "^", "2"}], " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "i"}], "-", "1"}], ")"}], "^", "2"}]}], ")"}]}]}],
    ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->223199947],

Cell[BoxData[
 RowBox[{"Cos", "[", 
  SqrtBox[
   SuperscriptBox["z", "2"]], "]"}]], "Output",
 ImageSize->{71, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138612805]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Pi", "^", "2"}], " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "i"}], "-", "1"}], ")"}], "^", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Pi", "^", "2"}], " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "i"}], "-", "1"}], ")"}], "^", "2"}]}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"z", "^", "2"}]}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->677356697],

Cell[BoxData[
 RowBox[{"Sec", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->82347364]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "/", "z"}], ")"}], " ", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Pi", "^", "2"}], " ", 
       RowBox[{"i", "^", "2"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Pi", "^", "2"}], " ", 
        RowBox[{"i", "^", "2"}]}], "-", 
       RowBox[{"z", "^", "2"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->274625116],

Cell[BoxData[
 RowBox[{"Csc", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->486373822]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->392005149],

Cell["Multiple products:", "ExampleText",
 CellID->464056523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"i", " ", "j"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "1", ",", "p"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "q"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->735595568],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"p", "!"}], ")"}], "q"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"q", "!"}], ")"}], "p"]}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66805525]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"a", "^", 
    RowBox[{"(", 
     RowBox[{"j", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"i", "^", 
         RowBox[{"(", 
          RowBox[{"j", "+", "1"}], ")"}]}], 
        RowBox[{"(", 
         RowBox[{"j", "+", "3"}], ")"}]}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "1", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->521819224],

Cell[BoxData[
 SuperscriptBox["a", 
  RowBox[{"EulerGamma", "+", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"Log", "[", "2", "]"}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"Log", "[", "Glaisher", "]"}]}], "+", 
      RowBox[{"Log", "[", "\[Pi]", "]"}]}], ")"}]}]}]]], "Output",
 ImageSize->{245, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->154799480]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23045],

Cell[TextData[{
 "Product over the index list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "3", ",", "5", ",", "7"}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->657459082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"i", "^", "2"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "12", ",", "17"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,41",
 CellLabel->"In[1]:=",
 CellID->25539175],

Cell[BoxData["374544"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,41",
 CellLabel->"Out[1]=",
 CellID->304080939]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401900678],

Cell["Product with step size 2:", "ExampleText",
 CellID->7884257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"f", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "5", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,24",
 CellLabel->"In[1]:=",
 CellID->474271506],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "1", "]"}], " ", 
  RowBox[{"f", "[", "3", "]"}], " ", 
  RowBox[{"f", "[", "5", "]"}]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,24",
 CellLabel->"Out[1]=",
 CellID->5399889]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->525730107],

Cell["Doubly infinite product:", "ExampleText",
 CellID->379379947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", "i"}], "+", 
        RowBox[{"1", "/", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,26",
 CellLabel->"In[1]:=",
 CellID->3083180],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,26",
 CellLabel->"Out[1]=",
 CellID->344634753]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6662],

Cell["A Lagrange interpolating polynomial:", "ExampleText",
 CellID->52817570],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LagrangePolynomial", "[", 
    RowBox[{"data_", ",", "x_"}], "]"}], "/;", 
   RowBox[{"MatrixQ", "[", "data", "]"}]}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"Length", "[", "data", "]"}]}], ",", " ", "xl", ",", "yl"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"xl", ",", "yl"}], "}"}], "=", 
      RowBox[{"Transpose", "[", "data", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "-", 
             RowBox[{"xl", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"xl", "[", 
              RowBox[{"[", "j", "]"}], "]"}], "-", 
             RowBox[{"xl", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Complement", "[", 
             RowBox[{
              RowBox[{"Range", "[", "n", "]"}], ",", 
              RowBox[{"{", "j", "}"}]}], "]"}]}], "}"}]}], "]"}], 
        RowBox[{"yl", "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1860633],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LagrangePolynomial", "[", 
    RowBox[{"data_", ",", "x_"}], "]"}], "/;", 
   RowBox[{"VectorQ", "[", "data", "]"}]}], " ", ":=", "\[IndentingNewLine]", 
  
  RowBox[{"LagrangePolynomial", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"Length", "[", "data", "]"}], "]"}], ",", "data"}], "}"}], 
     "]"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6952747],

Cell["A Lagrange interpolating polynomial for symbolic values:", "ExampleText",
 CellID->19442535],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "=", 
  RowBox[{"LagrangePolynomial", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "y1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x2", ",", "y2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x3", ",", "y3"}], "}"}]}], "}"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->86279698],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "x2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "x3"}], ")"}], " ", "y1"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x1", "-", "x2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"x1", "-", "x3"}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "x1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "x3"}], ")"}], " ", "y2"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "x1"}], "+", "x2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"x2", "-", "x3"}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "x1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "x2"}], ")"}], " ", "y3"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "x1"}], "+", "x3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "x2"}], "+", "x3"}], ")"}]}]]}]], "Output",
 ImageSize->{405, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->36105901]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"q", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->190784277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y1", ",", "y2", ",", "y3"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->130332862]
}, Open  ]],

Cell["A Newton interpolating polynomial for symbolic values:", "ExampleText",
 CellID->340680967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"InterpolatingPolynomial", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "y1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x2", ",", "y2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x3", ",", "y3"}], "}"}]}], "}"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->392474565],

Cell[BoxData[
 RowBox[{"y1", "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "x1"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "y1"}], "+", "y2"}], 
      RowBox[{
       RowBox[{"-", "x1"}], "+", "x2"}]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "x2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            RowBox[{"-", "y1"}], "+", "y2"}], 
           RowBox[{
            RowBox[{"-", "x1"}], "+", "x2"}]]}], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"-", "y2"}], "+", "y3"}], 
          RowBox[{
           RowBox[{"-", "x2"}], "+", "x3"}]]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", "x1"}], "+", "x3"}]]}], ")"}]}]}]], "Output",
 ImageSize->{318, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->9251186]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"q", "-", "r"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->488441457],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->870596859]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15626],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " will use numerical methods to compute products:"
}], "ExampleText",
 CellID->298260114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NProduct", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"5", "/", 
     RowBox[{"i", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,30",
 CellLabel->"In[1]:=",
 CellID->61518255],

Cell[BoxData["0.09615773802594951`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,30",
 CellLabel->"Out[1]=",
 CellID->114363246]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"5", "/", 
     RowBox[{"i", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,31",
 CellLabel->"In[2]:=",
 CellID->387858907],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", 
   RowBox[{
    SqrtBox["5"], " ", "\[Pi]"}], "]"}], 
  RowBox[{
   SqrtBox["5"], " ", "\[Pi]"}]]], "Output",
 ImageSize->{78, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,31",
 CellLabel->"Out[2]=",
 CellID->290607009]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,32",
 CellLabel->"In[3]:=",
 CellID->887373165],

Cell[BoxData["0.09615773797943993`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,32",
 CellLabel->"Out[3]=",
 CellID->235975528]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27969436],

Cell[TextData[{
 "Applying ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to an unevaluated product effectively uses ",
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->671625159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"1", " ", "-", " ", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "^", "i"}], " ", 
       RowBox[{"i", "^", "3"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,33",
 CellLabel->"In[1]:=",
 CellID->158872134],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Product]", 
   RowBox[{"i", "=", "1"}], "\[Infinity]"], 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    FractionBox[
     SuperscriptBox["2", 
      RowBox[{"-", "i"}]], 
     SuperscriptBox["i", "3"]]}], ")"}]}]], "Output",
 ImageSize->{77, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,33",
 CellLabel->"Out[1]=",
 CellID->737381930]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,34",
 CellLabel->"In[2]:=",
 CellID->836934216],

Cell[BoxData["0.4814897509108579`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,34",
 CellLabel->"Out[2]=",
 CellID->26255]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327488008],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 " essentially solves a special difference equation as solved by ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11454870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", 
      RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
     RowBox[{"2", 
      RowBox[{"y", "[", "n", "]"}]}]}], "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"y", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,37",
 CellLabel->"In[1]:=",
 CellID->265481422],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "n", "]"}], "\[Rule]", 
    SuperscriptBox["2", "n"]}], "}"}], "}"}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,37",
 CellLabel->"Out[1]=",
 CellID->312317324]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,38",
 CellLabel->"In[2]:=",
 CellID->173154281],

Cell[BoxData[
 SuperscriptBox["2", "n"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,38",
 CellLabel->"Out[2]=",
 CellID->90173093]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", 
      RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}], 
      RowBox[{"y", "[", "n", "]"}]}]}], "&&", 
    RowBox[{
     RowBox[{"y", "[", "1", "]"}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"y", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,35",
 CellLabel->"In[3]:=",
 CellID->152988950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "n"}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{152, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,35",
 CellLabel->"Out[3]=",
 CellID->240287287]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Product", "[", 
   RowBox[{"i", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellTags->"Ex--22030612118326582043,36",
 CellLabel->"In[4]:=",
 CellID->173277563],

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"1", "+", "n"}], "]"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,36",
 CellLabel->"Out[4]=",
 CellID->266784123]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->475],

Cell["A product may not be convergent:", "ExampleText",
 CellID->227930287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"1", "/", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,27",
 CellLabel->"In[1]:=",
 CellID->845549556],

Cell[BoxData[
 RowBox[{
  RowBox[{"Product", "::", "\<\"div\"\>"}], ":", 
  " ", "\<\"Product does not converge.\"\>"}]], "Message", "MSG",
 CellTags->"Ex--22030612118326582043,27",
 CellID->518127423],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Product]", 
   RowBox[{"i", "=", "1"}], "\[Infinity]"], 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    FractionBox["1", "i"]}], ")"}]}]], "Output",
 ImageSize->{66, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,27",
 CellLabel->"Out[1]=",
 CellID->151882570]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9538],

Cell[TextData[{
 "Answers in terms of ",
 Cell[BoxData[
  ButtonBox["Zeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Zeta"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolyLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyLog"]], "InlineFormula"],
 " derivatives:"
}], "ExampleText",
 CellID->152382400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", "i"}], "-", "1"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", "i"}], "-", "1"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "n"}], "}"}]}], "]"}], "\n"}]], "Input",
 CellTags->"Ex--22030612118326582043,29",
 CellLabel->"In[1]:=",
 CellID->173697590],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     FractionBox["1", "12"], "-", 
     RowBox[{"8", " ", 
      RowBox[{"Zeta", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{
         FractionBox["3", "4"], "+", "n"}]}], "]"}]}]}]], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     FractionBox["1", "24"], "+", 
     FractionBox["Catalan", "\[Pi]"], "+", 
     RowBox[{"4", " ", 
      RowBox[{
       SuperscriptBox["Zeta", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{
         FractionBox["3", "4"], "+", "n"}]}], "]"}]}]}]]}], 
  SqrtBox["Glaisher"]]], "Output",
 ImageSize->{271, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,29",
 CellLabel->"Out[1]=",
 CellID->797622571]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"i", "^", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], " ", "i"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22030612118326582043,11",
 CellLabel->"In[2]:=",
 CellID->536775297],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", 
   RowBox[{
    SuperscriptBox["PolyLog", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"0", ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "a"}]]}], "]"}]}]]], "Output",
 ImageSize->{113, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030612118326582043,11",
 CellLabel->"Out[2]=",
 CellID->125780006]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75394086],

Cell["\<\
Using a symbolic closed\[Hyphen]form product can provide fast evaluation:\
\>", "ExampleText",
 CellID->144166700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "/", "2"}], ")"}], "^", "i"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"2", "^", "n"}]}], "}"}]}], "]"}]}]], "Input",
 CellTags->"Ex--22030600223518944757,6",
 CellLabel->"In[1]:=",
 CellID->71996010],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   FractionBox["3", "2"], ")"}], 
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["2", "n"]}], ")"}]}]]], "Output",
 ImageSize->{88, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030600223518944757,6",
 CellLabel->"Out[1]=",
 CellID->189616648]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Timing", "[", 
        RowBox[{"s", ";"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
      RowBox[{
       RowBox[{"Timing", "[", 
        RowBox[{
         RowBox[{"Product", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}], "^", "i"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", 
             RowBox[{"2", "^", "n"}]}], "}"}]}], "]"}], ";"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"n", ",", "6", ",", " ", "11"}], "}"}]}], "]"}], "//", 
  "Grid"}]], "Input",
 CellTags->"Ex--22030600223518944757,7",
 CellLabel->"In[2]:=",
 CellID->463795767],

Cell[BoxData[
 TagBox[GridBox[{
    {"2.2100377083944522`*^-15", "2.2100377083944522`*^-15"},
    {"2.2100377083944522`*^-15", "2.2100377083944522`*^-15"},
    {"2.2100377083944522`*^-15", "0.010000000000002209`"},
    {"0.009999999999997095`", "0.06999999999999909`"},
    {"0.0299999999999988`", "0.9409999999999976`"},
    {"0.11000000000000226`", "7.972000000000003`"}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{192, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22030600223518944757,7",
 CellLabel->"Out[2]=",
 CellID->43705785]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10717],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Do",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Do"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Times",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Times"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26526]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31450],

Cell[TextData[ButtonBox["Sums and Products",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SumsAndProducts"]], "Tutorials",
 CellID->19449]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->4123],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#10202"], None}]], "RelatedLinks",
 CellID->7463]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->14270132],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->237753092]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Product (\[Product]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 11.7804486}", "context" -> "System`", 
    "keywords" -> {"multiple products", "prod"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Product[f, {i, i_max}] evaluates the product \
UnderoverscriptBox[\"\\[Product]\", RowBox[{\"i\", \"=\", \"1\"}], \"i_max\", \
LimitsPositioning->True]\\ f. Product[f, {i, i_min, i_max}] starts with i = \
i_min. Product[f, {i, i_min, i_max, di}] uses steps di. Product[expr, {i, \
{i_1, i_2, ...}}] uses successive values i_1, i_2, .... Product[f, {i, i_min, \
i_max}, {j, j_min, j_max}, ...] evaluates the multiple product \
UnderoverscriptBox[\"\\[Product]\", RowBox[{\"i\", \"=\", \"i_min\"}], \
\"i_max\", LimitsPositioning->True] UnderoverscriptBox[\"\\[Product]\", \
RowBox[{\"j\", \"=\", \"j_min\"}], \"j_max\", LimitsPositioning->True]...\\ \
f. ", "synonyms" -> {}, "title" -> "Product", "type" -> "Symbol", "uri" -> 
    "ref/Product"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16879, 530, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->21575854]},
 "Ex--22030567868345786083,1"->{
  Cell[17498, 556, 249, 8, 28, "Input",
   CellTags->"Ex--22030567868345786083,1",
   CellID->41346309],
  Cell[17750, 566, 204, 6, 36, "Output",
   CellTags->"Ex--22030567868345786083,1",
   CellID->618091247]},
 "Ex--22030567868345786083,2"->{
  Cell[18180, 585, 250, 8, 70, "Input",
   CellTags->"Ex--22030567868345786083,2",
   CellID->625339466],
  Cell[18433, 595, 264, 9, 36, "Output",
   CellTags->"Ex--22030567868345786083,2",
   CellID->217618592]},
 "Ex--22030567868345786083,3"->{
  Cell[19371, 633, 216, 7, 70, "Input",
   CellTags->"Ex--22030567868345786083,3",
   CellID->505254588],
  Cell[19590, 642, 263, 9, 36, "Output",
   CellTags->"Ex--22030567868345786083,3",
   CellID->17771527]},
 "Ex--22030567868345786083,4"->{
  Cell[20081, 664, 308, 10, 70, "Input",
   CellTags->"Ex--22030567868345786083,4",
   CellID->406018980],
  Cell[20392, 676, 279, 9, 52, "Output",
   CellTags->"Ex--22030567868345786083,4",
   CellID->8802080]},
 "Ex--22030567868345786083,5"->{
  Cell[21010, 703, 375, 12, 70, "Input",
   CellTags->"Ex--22030567868345786083,5",
   CellID->240006786],
  Cell[21388, 717, 352, 12, 43, "Output",
   CellTags->"Ex--22030567868345786083,5",
   CellID->11739946]},
 "Ex--22030612118326582043,40"->{
  Cell[22121, 749, 227, 7, 70, "Input",
   CellTags->"Ex--22030612118326582043,40",
   CellID->319363121],
  Cell[22351, 758, 223, 7, 36, "Output",
   CellTags->"Ex--22030612118326582043,40",
   CellID->669849968]},
 "Ex--22030612118326582043,23"->{
  Cell[43241, 1624, 407, 13, 70, "Input",
   CellTags->"Ex--22030612118326582043,23",
   CellID->552679402],
  Cell[43651, 1639, 227, 7, 36, "Output",
   CellTags->"Ex--22030612118326582043,23",
   CellID->299774]},
 "Ex--22030612118326582043,41"->{
  Cell[49762, 1893, 328, 11, 70, "Input",
   CellTags->"Ex--22030612118326582043,41",
   CellID->25539175],
  Cell[50093, 1906, 205, 6, 36, "Output",
   CellTags->"Ex--22030612118326582043,41",
   CellID->304080939]},
 "Ex--22030612118326582043,24"->{
  Cell[50532, 1925, 266, 8, 70, "Input",
   CellTags->"Ex--22030612118326582043,24",
   CellID->474271506],
  Cell[50801, 1935, 314, 10, 36, "Output",
   CellTags->"Ex--22030612118326582043,24",
   CellID->5399889]},
 "Ex--22030612118326582043,26"->{
  Cell[51350, 1958, 443, 15, 70, "Input",
   CellTags->"Ex--22030612118326582043,26",
   CellID->3083180],
  Cell[51796, 1975, 217, 7, 36, "Output",
   CellTags->"Ex--22030612118326582043,26",
   CellID->344634753]},
 "Ex--22030612118326582043,30"->{
  Cell[58962, 2253, 309, 10, 70, "Input",
   CellTags->"Ex--22030612118326582043,30",
   CellID->61518255],
  Cell[59274, 2265, 219, 6, 36, "Output",
   CellTags->"Ex--22030612118326582043,30",
   CellID->114363246]},
 "Ex--22030612118326582043,31"->{
  Cell[59530, 2276, 309, 10, 70, "Input",
   CellTags->"Ex--22030612118326582043,31",
   CellID->387858907],
  Cell[59842, 2288, 332, 12, 64, "Output",
   CellTags->"Ex--22030612118326582043,31",
   CellID->290607009]},
 "Ex--22030612118326582043,32"->{
  Cell[60211, 2305, 139, 4, 70, "Input",
   CellTags->"Ex--22030612118326582043,32",
   CellID->887373165],
  Cell[60353, 2311, 219, 6, 36, "Output",
   CellTags->"Ex--22030612118326582043,32",
   CellID->235975528]},
 "Ex--22030612118326582043,33"->{
  Cell[61085, 2342, 402, 13, 70, "Input",
   CellTags->"Ex--22030612118326582043,33",
   CellID->158872134],
  Cell[61490, 2357, 439, 15, 59, "Output",
   CellTags->"Ex--22030612118326582043,33",
   CellID->737381930]},
 "Ex--22030612118326582043,34"->{
  Cell[61966, 2377, 139, 4, 70, "Input",
   CellTags->"Ex--22030612118326582043,34",
   CellID->836934216],
  Cell[62108, 2383, 214, 6, 36, "Output",
   CellTags->"Ex--22030612118326582043,34",
   CellID->26255]},
 "Ex--22030612118326582043,37"->{
  Cell[62848, 2413, 437, 14, 70, "Input",
   CellTags->"Ex--22030612118326582043,37",
   CellID->265481422],
  Cell[63288, 2429, 331, 11, 36, "Output",
   CellTags->"Ex--22030612118326582043,37",
   CellID->312317324]},
 "Ex--22030612118326582043,38"->{
  Cell[63656, 2445, 227, 7, 70, "Input",
   CellTags->"Ex--22030612118326582043,38",
   CellID->173154281],
  Cell[63886, 2454, 222, 7, 36, "Output",
   CellTags->"Ex--22030612118326582043,38",
   CellID->90173093]},
 "Ex--22030612118326582043,35"->{
  Cell[64145, 2466, 492, 16, 70, "Input",
   CellTags->"Ex--22030612118326582043,35",
   CellID->152988950],
  Cell[64640, 2484, 366, 12, 36, "Output",
   CellTags->"Ex--22030612118326582043,35",
   CellID->240287287]},
 "Ex--22030612118326582043,36"->{
  Cell[65043, 2501, 270, 9, 70, "Input",
   CellTags->"Ex--22030612118326582043,36",
   CellID->173277563],
  Cell[65316, 2512, 254, 8, 36, "Output",
   CellTags->"Ex--22030612118326582043,36",
   CellID->266784123]},
 "Ex--22030612118326582043,27"->{
  Cell[65946, 2540, 283, 9, 70, "Input",
   CellTags->"Ex--22030612118326582043,27",
   CellID->845549556],
  Cell[66232, 2551, 201, 5, 70, "Message",
   CellTags->"Ex--22030612118326582043,27",
   CellID->518127423],
  Cell[66436, 2558, 363, 12, 58, "Output",
   CellTags->"Ex--22030612118326582043,27",
   CellID->151882570]},
 "Ex--22030612118326582043,29"->{
  Cell[67433, 2602, 416, 15, 70, "Input",
   CellTags->"Ex--22030612118326582043,29",
   CellID->173697590],
  Cell[67852, 2619, 972, 34, 64, "Output",
   CellTags->"Ex--22030612118326582043,29",
   CellID->797622571]},
 "Ex--22030612118326582043,11"->{
  Cell[68861, 2658, 359, 12, 70, "Input",
   CellTags->"Ex--22030612118326582043,11",
   CellID->536775297],
  Cell[69223, 2672, 522, 18, 40, "Output",
   CellTags->"Ex--22030612118326582043,11",
   CellID->125780006]},
 "Ex--22030600223518944757,6"->{
  Cell[70036, 2705, 356, 12, 70, "Input",
   CellTags->"Ex--22030600223518944757,6",
   CellID->71996010],
  Cell[70395, 2719, 437, 16, 55, "Output",
   CellTags->"Ex--22030600223518944757,6",
   CellID->189616648]},
 "Ex--22030600223518944757,7"->{
  Cell[70869, 2740, 853, 27, 70, "Input",
   CellTags->"Ex--22030600223518944757,7",
   CellID->463795767],
  Cell[71725, 2769, 692, 18, 118, "Output",
   CellTags->"Ex--22030600223518944757,7",
   CellID->43705785]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 77462, 2956},
 {"Ex--22030567868345786083,1", 77615, 2960},
 {"Ex--22030567868345786083,2", 77861, 2967},
 {"Ex--22030567868345786083,3", 78108, 2974},
 {"Ex--22030567868345786083,4", 78354, 2981},
 {"Ex--22030567868345786083,5", 78600, 2988},
 {"Ex--22030612118326582043,40", 78849, 2995},
 {"Ex--22030612118326582043,23", 79099, 3002},
 {"Ex--22030612118326582043,41", 79349, 3009},
 {"Ex--22030612118326582043,24", 79601, 3016},
 {"Ex--22030612118326582043,26", 79852, 3023},
 {"Ex--22030612118326582043,30", 80103, 3030},
 {"Ex--22030612118326582043,31", 80355, 3037},
 {"Ex--22030612118326582043,32", 80609, 3044},
 {"Ex--22030612118326582043,33", 80861, 3051},
 {"Ex--22030612118326582043,34", 81115, 3058},
 {"Ex--22030612118326582043,37", 81363, 3065},
 {"Ex--22030612118326582043,38", 81617, 3072},
 {"Ex--22030612118326582043,35", 81868, 3079},
 {"Ex--22030612118326582043,36", 82122, 3086},
 {"Ex--22030612118326582043,27", 82374, 3093},
 {"Ex--22030612118326582043,29", 82737, 3103},
 {"Ex--22030612118326582043,11", 82991, 3110},
 {"Ex--22030600223518944757,6", 83244, 3117},
 {"Ex--22030600223518944757,7", 83494, 3124}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2115, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2738, 78, 4267, 86, 70, "ObjectNameGrid"],
Cell[7008, 166, 5033, 168, 70, "Usage",
 CellID->15722]
}, Open  ]],
Cell[CellGroupData[{
Cell[12078, 339, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[12556, 356, 605, 24, 70, "Notes",
 CellID->11209],
Cell[13164, 382, 380, 12, 70, "Notes",
 CellID->18610],
Cell[13547, 396, 767, 30, 70, "Notes",
 CellID->16279],
Cell[14317, 428, 233, 6, 70, "Notes",
 CellID->8442],
Cell[14553, 436, 264, 10, 70, "Notes",
 CellID->24009],
Cell[14820, 448, 300, 11, 70, "Notes",
 CellID->10984],
Cell[15123, 461, 302, 9, 70, "Notes",
 CellID->1432],
Cell[15428, 472, 114, 3, 70, "Notes",
 CellID->2383],
Cell[15545, 477, 255, 8, 70, "Notes",
 CellID->29957],
Cell[15803, 487, 417, 12, 70, "Notes",
 CellID->30402],
Cell[16223, 501, 244, 8, 70, "Notes",
 CellID->26275],
Cell[16470, 511, 372, 14, 70, "Notes",
 CellID->11430]
}, Closed]],
Cell[CellGroupData[{
Cell[16879, 530, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21575854],
Cell[CellGroupData[{
Cell[17263, 544, 148, 5, 70, "ExampleSection",
 CellID->838510519],
Cell[17414, 551, 59, 1, 70, "ExampleText",
 CellID->319962190],
Cell[CellGroupData[{
Cell[17498, 556, 249, 8, 28, "Input",
 CellTags->"Ex--22030567868345786083,1",
 CellID->41346309],
Cell[17750, 566, 204, 6, 36, "Output",
 CellTags->"Ex--22030567868345786083,1",
 CellID->618091247]
}, Open  ]],
Cell[17969, 575, 124, 3, 70, "ExampleDelimiter",
 CellID->32535520],
Cell[18096, 580, 59, 1, 70, "ExampleText",
 CellID->21521981],
Cell[CellGroupData[{
Cell[18180, 585, 250, 8, 70, "Input",
 CellTags->"Ex--22030567868345786083,2",
 CellID->625339466],
Cell[18433, 595, 264, 9, 36, "Output",
 CellTags->"Ex--22030567868345786083,2",
 CellID->217618592]
}, Open  ]],
Cell[18712, 607, 125, 3, 70, "ExampleDelimiter",
 CellID->490212368],
Cell[18840, 612, 506, 17, 70, "ExampleText",
 CellID->42968189],
Cell[CellGroupData[{
Cell[19371, 633, 216, 7, 70, "Input",
 CellTags->"Ex--22030567868345786083,3",
 CellID->505254588],
Cell[19590, 642, 263, 9, 36, "Output",
 CellTags->"Ex--22030567868345786083,3",
 CellID->17771527]
}, Open  ]],
Cell[19868, 654, 125, 3, 70, "ExampleDelimiter",
 CellID->222573277],
Cell[19996, 659, 60, 1, 70, "ExampleText",
 CellID->235884109],
Cell[CellGroupData[{
Cell[20081, 664, 308, 10, 70, "Input",
 CellTags->"Ex--22030567868345786083,4",
 CellID->406018980],
Cell[20392, 676, 279, 9, 52, "Output",
 CellTags->"Ex--22030567868345786083,4",
 CellID->8802080]
}, Open  ]],
Cell[20686, 688, 125, 3, 70, "ExampleDelimiter",
 CellID->286837283],
Cell[20814, 693, 171, 6, 70, "ExampleText",
 CellID->28118046],
Cell[CellGroupData[{
Cell[21010, 703, 375, 12, 70, "Input",
 CellTags->"Ex--22030567868345786083,5",
 CellID->240006786],
Cell[21388, 717, 352, 12, 43, "Output",
 CellTags->"Ex--22030567868345786083,5",
 CellID->11739946]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21789, 735, 217, 7, 70, "ExampleSection",
 CellID->23794],
Cell[22009, 744, 87, 1, 70, "ExampleText",
 CellID->344857222],
Cell[CellGroupData[{
Cell[22121, 749, 227, 7, 70, "Input",
 CellTags->"Ex--22030612118326582043,40",
 CellID->319363121],
Cell[22351, 758, 223, 7, 36, "Output",
 CellTags->"Ex--22030612118326582043,40",
 CellID->669849968]
}, Open  ]],
Cell[22589, 768, 125, 3, 70, "ExampleDelimiter",
 CellID->533333338],
Cell[22717, 773, 114, 3, 70, "ExampleText",
 CellID->487135429],
Cell[CellGroupData[{
Cell[22856, 780, 259, 9, 70, "Input",
 CellID->71108354],
Cell[23118, 791, 370, 13, 43, "Output",
 CellID->150094076]
}, Open  ]],
Cell[CellGroupData[{
Cell[23525, 809, 313, 11, 70, "Input",
 CellID->34840622],
Cell[23841, 822, 469, 16, 43, "Output",
 CellID->219530092]
}, Open  ]],
Cell[24325, 841, 125, 3, 70, "ExampleDelimiter",
 CellID->278124480],
Cell[24453, 846, 98, 1, 70, "ExampleText",
 CellID->296397689],
Cell[CellGroupData[{
Cell[24576, 851, 369, 13, 70, "Input",
 CellID->398413405],
Cell[24948, 866, 226, 8, 42, "Output",
 CellID->131889512]
}, Open  ]],
Cell[CellGroupData[{
Cell[25211, 879, 343, 12, 70, "Input",
 CellID->45345826],
Cell[25557, 893, 813, 27, 43, "Output",
 CellID->271257850]
}, Open  ]],
Cell[26385, 923, 125, 3, 70, "ExampleDelimiter",
 CellID->471159425],
Cell[26513, 928, 123, 3, 70, "ExampleText",
 CellID->479020932],
Cell[CellGroupData[{
Cell[26661, 935, 321, 11, 70, "Input",
 CellID->49385515],
Cell[26985, 948, 633, 22, 43, "Output",
 CellID->136394409]
}, Open  ]],
Cell[27633, 973, 125, 3, 70, "ExampleDelimiter",
 CellID->701809551],
Cell[27761, 978, 237, 8, 70, "ExampleText",
 CellID->403070171],
Cell[CellGroupData[{
Cell[28023, 990, 306, 11, 70, "Input",
 CellID->232517014],
Cell[28332, 1003, 324, 11, 51, "Output",
 CellID->343719128]
}, Open  ]],
Cell[CellGroupData[{
Cell[28693, 1019, 344, 12, 70, "Input",
 CellID->64719160],
Cell[29040, 1033, 505, 17, 51, "Output",
 CellID->296875431]
}, Open  ]],
Cell[29560, 1053, 124, 3, 70, "ExampleDelimiter",
 CellID->12534245],
Cell[29687, 1058, 247, 8, 70, "ExampleText",
 CellID->233397618],
Cell[CellGroupData[{
Cell[29959, 1070, 338, 12, 70, "Input",
 CellID->145093370],
Cell[30300, 1084, 382, 14, 65, "Output",
 CellID->155660208]
}, Open  ]],
Cell[CellGroupData[{
Cell[30719, 1103, 370, 13, 70, "Input",
 CellID->985676097],
Cell[31092, 1118, 646, 22, 62, "Output",
 CellID->26724924]
}, Open  ]],
Cell[31753, 1143, 125, 3, 70, "ExampleDelimiter",
 CellID->213189072],
Cell[31881, 1148, 79, 1, 70, "ExampleText",
 CellID->21956245],
Cell[CellGroupData[{
Cell[31985, 1153, 264, 9, 70, "Input",
 CellID->828643144],
Cell[32252, 1164, 379, 14, 43, "Output",
 CellID->53833977]
}, Open  ]],
Cell[CellGroupData[{
Cell[32668, 1183, 469, 17, 70, "Input",
 CellID->890113783],
Cell[33140, 1202, 636, 23, 69, "Output",
 CellID->28724806]
}, Open  ]],
Cell[33791, 1228, 125, 3, 70, "ExampleDelimiter",
 CellID->163912892],
Cell[33919, 1233, 74, 1, 70, "ExampleText",
 CellID->15290317],
Cell[CellGroupData[{
Cell[34018, 1238, 346, 12, 70, "Input",
 CellID->848956353],
Cell[34367, 1252, 393, 15, 43, "Output",
 CellID->3423699]
}, Open  ]],
Cell[CellGroupData[{
Cell[34797, 1272, 320, 11, 70, "Input",
 CellID->11886305],
Cell[35120, 1285, 391, 14, 51, "Output",
 CellID->198899554]
}, Open  ]],
Cell[CellGroupData[{
Cell[35548, 1304, 284, 9, 70, "Input",
 CellID->126245723],
Cell[35835, 1315, 188, 6, 36, "Output",
 CellID->495782668]
}, Open  ]],
Cell[36038, 1324, 125, 3, 70, "ExampleDelimiter",
 CellID->287168328],
Cell[36166, 1329, 86, 1, 70, "ExampleText",
 CellID->330097240],
Cell[CellGroupData[{
Cell[36277, 1334, 294, 10, 70, "Input",
 CellID->658122518],
Cell[36574, 1346, 229, 8, 46, "Output",
 CellID->2055751]
}, Open  ]],
Cell[CellGroupData[{
Cell[36840, 1359, 328, 11, 70, "Input",
 CellID->761596006],
Cell[37171, 1372, 565, 18, 43, "Output",
 CellID->291484803]
}, Open  ]],
Cell[37751, 1393, 125, 3, 70, "ExampleDelimiter",
 CellID->796376836],
Cell[37879, 1398, 83, 1, 70, "ExampleText",
 CellID->318939577],
Cell[CellGroupData[{
Cell[37987, 1403, 345, 12, 70, "Input",
 CellID->39074791],
Cell[38335, 1417, 182, 6, 49, "Output",
 CellID->196754241]
}, Open  ]],
Cell[CellGroupData[{
Cell[38554, 1428, 399, 14, 70, "Input",
 CellID->187742283],
Cell[38956, 1444, 585, 20, 70, "Output",
 CellID->206403463]
}, Open  ]],
Cell[39556, 1467, 125, 3, 70, "ExampleDelimiter",
 CellID->433228669],
Cell[39684, 1472, 95, 1, 70, "ExampleText",
 CellID->948883918],
Cell[CellGroupData[{
Cell[39804, 1477, 421, 15, 70, "Input",
 CellID->25320527],
Cell[40228, 1494, 233, 8, 54, "Output",
 CellID->237721914]
}, Open  ]],
Cell[CellGroupData[{
Cell[40498, 1507, 374, 13, 70, "Input",
 CellID->233372662],
Cell[40875, 1522, 222, 7, 36, "Output",
 CellID->546597704]
}, Open  ]],
Cell[41112, 1532, 124, 3, 70, "ExampleDelimiter",
 CellID->62043496],
Cell[41239, 1537, 75, 1, 70, "ExampleText",
 CellID->256247123],
Cell[CellGroupData[{
Cell[41339, 1542, 364, 13, 70, "Input",
 CellID->25149235],
Cell[41706, 1557, 398, 14, 36, "Output",
 CellID->237285634]
}, Open  ]],
Cell[CellGroupData[{
Cell[42141, 1576, 422, 15, 70, "Input",
 CellID->541243147],
Cell[42566, 1593, 300, 11, 85, "Output",
 CellID->443932039]
}, Open  ]],
Cell[42881, 1607, 125, 3, 70, "ExampleDelimiter",
 CellID->551472604],
Cell[43009, 1612, 207, 8, 70, "ExampleText",
 CellID->34454062],
Cell[CellGroupData[{
Cell[43241, 1624, 407, 13, 70, "Input",
 CellTags->"Ex--22030612118326582043,23",
 CellID->552679402],
Cell[43651, 1639, 227, 7, 36, "Output",
 CellTags->"Ex--22030612118326582043,23",
 CellID->299774]
}, Open  ]],
Cell[43893, 1649, 125, 3, 70, "ExampleDelimiter",
 CellID->292549264],
Cell[44021, 1654, 97, 1, 70, "ExampleText",
 CellID->79804725],
Cell[CellGroupData[{
Cell[44143, 1659, 410, 14, 70, "Input",
 CellID->198512892],
Cell[44556, 1675, 313, 12, 65, "Output",
 CellID->299596028]
}, Open  ]],
Cell[CellGroupData[{
Cell[44906, 1692, 526, 19, 70, "Input",
 CellID->223199947],
Cell[45435, 1713, 224, 8, 48, "Output",
 CellID->138612805]
}, Open  ]],
Cell[CellGroupData[{
Cell[45696, 1726, 667, 23, 70, "Input",
 CellID->677356697],
Cell[46366, 1751, 186, 6, 36, "Output",
 CellID->82347364]
}, Open  ]],
Cell[CellGroupData[{
Cell[46589, 1762, 568, 20, 70, "Input",
 CellID->274625116],
Cell[47160, 1784, 187, 6, 36, "Output",
 CellID->486373822]
}, Open  ]],
Cell[47362, 1793, 125, 3, 70, "ExampleDelimiter",
 CellID->392005149],
Cell[47490, 1798, 61, 1, 70, "ExampleText",
 CellID->464056523],
Cell[CellGroupData[{
Cell[47576, 1803, 278, 9, 70, "Input",
 CellID->735595568],
Cell[47857, 1814, 315, 12, 36, "Output",
 CellID->66805525]
}, Open  ]],
Cell[CellGroupData[{
Cell[48209, 1831, 542, 18, 70, "Input",
 CellID->521819224],
Cell[48754, 1851, 495, 16, 43, "Output",
 CellID->154799480]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49298, 1873, 239, 7, 70, "ExampleSection",
 CellID->23045],
Cell[49540, 1882, 197, 7, 70, "ExampleText",
 CellID->657459082],
Cell[CellGroupData[{
Cell[49762, 1893, 328, 11, 70, "Input",
 CellTags->"Ex--22030612118326582043,41",
 CellID->25539175],
Cell[50093, 1906, 205, 6, 36, "Output",
 CellTags->"Ex--22030612118326582043,41",
 CellID->304080939]
}, Open  ]],
Cell[50313, 1915, 125, 3, 70, "ExampleDelimiter",
 CellID->401900678],
Cell[50441, 1920, 66, 1, 70, "ExampleText",
 CellID->7884257],
Cell[CellGroupData[{
Cell[50532, 1925, 266, 8, 70, "Input",
 CellTags->"Ex--22030612118326582043,24",
 CellID->474271506],
Cell[50801, 1935, 314, 10, 36, "Output",
 CellTags->"Ex--22030612118326582043,24",
 CellID->5399889]
}, Open  ]],
Cell[51130, 1948, 125, 3, 70, "ExampleDelimiter",
 CellID->525730107],
Cell[51258, 1953, 67, 1, 70, "ExampleText",
 CellID->379379947],
Cell[CellGroupData[{
Cell[51350, 1958, 443, 15, 70, "Input",
 CellTags->"Ex--22030612118326582043,26",
 CellID->3083180],
Cell[51796, 1975, 217, 7, 36, "Output",
 CellTags->"Ex--22030612118326582043,26",
 CellID->344634753]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[52062, 1988, 222, 7, 70, "ExampleSection",
 CellID->6662],
Cell[52287, 1997, 78, 1, 70, "ExampleText",
 CellID->52817570],
Cell[52368, 2000, 1559, 46, 70, "Input",
 CellID->1860633],
Cell[53930, 2048, 508, 16, 70, "Input",
 CellID->6952747],
Cell[54441, 2066, 98, 1, 70, "ExampleText",
 CellID->19442535],
Cell[CellGroupData[{
Cell[54564, 2071, 396, 14, 70, "Input",
 CellID->86279698],
Cell[54963, 2087, 1126, 42, 53, "Output",
 CellID->36105901]
}, Open  ]],
Cell[CellGroupData[{
Cell[56126, 2134, 241, 9, 70, "Input",
 CellID->190784277],
Cell[56370, 2145, 216, 7, 36, "Output",
 CellID->130332862]
}, Open  ]],
Cell[56601, 2155, 97, 1, 70, "ExampleText",
 CellID->340680967],
Cell[CellGroupData[{
Cell[56723, 2160, 402, 14, 70, "Input",
 CellID->392474565],
Cell[57128, 2176, 974, 35, 71, "Output",
 CellID->9251186]
}, Open  ]],
Cell[CellGroupData[{
Cell[58139, 2216, 127, 4, 70, "Input",
 CellID->488441457],
Cell[58269, 2222, 158, 5, 36, "Output",
 CellID->870596859]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58476, 2233, 233, 7, 70, "ExampleSection",
 CellID->15626],
Cell[58712, 2242, 225, 7, 70, "ExampleText",
 CellID->298260114],
Cell[CellGroupData[{
Cell[58962, 2253, 309, 10, 70, "Input",
 CellTags->"Ex--22030612118326582043,30",
 CellID->61518255],
Cell[59274, 2265, 219, 6, 36, "Output",
 CellTags->"Ex--22030612118326582043,30",
 CellID->114363246]
}, Open  ]],
Cell[CellGroupData[{
Cell[59530, 2276, 309, 10, 70, "Input",
 CellTags->"Ex--22030612118326582043,31",
 CellID->387858907],
Cell[59842, 2288, 332, 12, 64, "Output",
 CellTags->"Ex--22030612118326582043,31",
 CellID->290607009]
}, Open  ]],
Cell[CellGroupData[{
Cell[60211, 2305, 139, 4, 70, "Input",
 CellTags->"Ex--22030612118326582043,32",
 CellID->887373165],
Cell[60353, 2311, 219, 6, 36, "Output",
 CellTags->"Ex--22030612118326582043,32",
 CellID->235975528]
}, Open  ]],
Cell[60587, 2320, 124, 3, 70, "ExampleDelimiter",
 CellID->27969436],
Cell[60714, 2325, 346, 13, 70, "ExampleText",
 CellID->671625159],
Cell[CellGroupData[{
Cell[61085, 2342, 402, 13, 70, "Input",
 CellTags->"Ex--22030612118326582043,33",
 CellID->158872134],
Cell[61490, 2357, 439, 15, 59, "Output",
 CellTags->"Ex--22030612118326582043,33",
 CellID->737381930]
}, Open  ]],
Cell[CellGroupData[{
Cell[61966, 2377, 139, 4, 70, "Input",
 CellTags->"Ex--22030612118326582043,34",
 CellID->836934216],
Cell[62108, 2383, 214, 6, 36, "Output",
 CellTags->"Ex--22030612118326582043,34",
 CellID->26255]
}, Open  ]],
Cell[62337, 2392, 125, 3, 70, "ExampleDelimiter",
 CellID->327488008],
Cell[62465, 2397, 358, 12, 70, "ExampleText",
 CellID->11454870],
Cell[CellGroupData[{
Cell[62848, 2413, 437, 14, 70, "Input",
 CellTags->"Ex--22030612118326582043,37",
 CellID->265481422],
Cell[63288, 2429, 331, 11, 36, "Output",
 CellTags->"Ex--22030612118326582043,37",
 CellID->312317324]
}, Open  ]],
Cell[CellGroupData[{
Cell[63656, 2445, 227, 7, 70, "Input",
 CellTags->"Ex--22030612118326582043,38",
 CellID->173154281],
Cell[63886, 2454, 222, 7, 36, "Output",
 CellTags->"Ex--22030612118326582043,38",
 CellID->90173093]
}, Open  ]],
Cell[CellGroupData[{
Cell[64145, 2466, 492, 16, 70, "Input",
 CellTags->"Ex--22030612118326582043,35",
 CellID->152988950],
Cell[64640, 2484, 366, 12, 36, "Output",
 CellTags->"Ex--22030612118326582043,35",
 CellID->240287287]
}, Open  ]],
Cell[CellGroupData[{
Cell[65043, 2501, 270, 9, 70, "Input",
 CellTags->"Ex--22030612118326582043,36",
 CellID->173277563],
Cell[65316, 2512, 254, 8, 36, "Output",
 CellTags->"Ex--22030612118326582043,36",
 CellID->266784123]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[65619, 2526, 224, 7, 70, "ExampleSection",
 CellID->475],
Cell[65846, 2535, 75, 1, 70, "ExampleText",
 CellID->227930287],
Cell[CellGroupData[{
Cell[65946, 2540, 283, 9, 70, "Input",
 CellTags->"Ex--22030612118326582043,27",
 CellID->845549556],
Cell[66232, 2551, 201, 5, 70, "Message",
 CellTags->"Ex--22030612118326582043,27",
 CellID->518127423],
Cell[66436, 2558, 363, 12, 58, "Output",
 CellTags->"Ex--22030612118326582043,27",
 CellID->151882570]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66848, 2576, 223, 7, 70, "ExampleSection",
 CellID->9538],
Cell[67074, 2585, 334, 13, 70, "ExampleText",
 CellID->152382400],
Cell[CellGroupData[{
Cell[67433, 2602, 416, 15, 70, "Input",
 CellTags->"Ex--22030612118326582043,29",
 CellID->173697590],
Cell[67852, 2619, 972, 34, 64, "Output",
 CellTags->"Ex--22030612118326582043,29",
 CellID->797622571]
}, Open  ]],
Cell[CellGroupData[{
Cell[68861, 2658, 359, 12, 70, "Input",
 CellTags->"Ex--22030612118326582043,11",
 CellID->536775297],
Cell[69223, 2672, 522, 18, 40, "Output",
 CellTags->"Ex--22030612118326582043,11",
 CellID->125780006]
}, Open  ]],
Cell[69760, 2693, 124, 3, 70, "ExampleDelimiter",
 CellID->75394086],
Cell[69887, 2698, 124, 3, 70, "ExampleText",
 CellID->144166700],
Cell[CellGroupData[{
Cell[70036, 2705, 356, 12, 70, "Input",
 CellTags->"Ex--22030600223518944757,6",
 CellID->71996010],
Cell[70395, 2719, 437, 16, 55, "Output",
 CellTags->"Ex--22030600223518944757,6",
 CellID->189616648]
}, Open  ]],
Cell[CellGroupData[{
Cell[70869, 2740, 853, 27, 70, "Input",
 CellTags->"Ex--22030600223518944757,7",
 CellID->463795767],
Cell[71725, 2769, 692, 18, 118, "Output",
 CellTags->"Ex--22030600223518944757,7",
 CellID->43705785]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72478, 2794, 311, 9, 70, "SeeAlsoSection",
 CellID->10717],
Cell[72792, 2805, 1393, 53, 70, "SeeAlso",
 CellID->26526]
}, Open  ]],
Cell[CellGroupData[{
Cell[74222, 2863, 314, 9, 70, "TutorialsSection",
 CellID->31450],
Cell[74539, 2874, 143, 3, 70, "Tutorials",
 CellID->19449]
}, Open  ]],
Cell[CellGroupData[{
Cell[74719, 2882, 320, 9, 70, "RelatedLinksSection",
 CellID->4123],
Cell[75042, 2893, 253, 5, 70, "RelatedLinks",
 CellID->7463]
}, Open  ]],
Cell[CellGroupData[{
Cell[75332, 2903, 318, 9, 70, "MoreAboutSection",
 CellID->14270132],
Cell[75653, 2914, 128, 3, 70, "MoreAbout",
 CellID->237753092]
}, Open  ]],
Cell[75796, 2920, 50, 0, 70, "History"],
Cell[75849, 2922, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

