(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    231997,       5413]
NotebookOptionsPosition[    217992,       4925]
NotebookOutlinePosition[    219442,       4965]
CellTagsIndexPosition[    219355,       4960]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Log" :> Documentation`HelpLookup["paclet:ref/Log"], "Exp" :> 
          Documentation`HelpLookup["paclet:ref/Exp"], "FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Log\"\>", 2->"\<\"Exp\"\>", 
       3->"\<\"FindRoot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Inverse Functions\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ProductLog", "ObjectName",
 CellID->23547],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ProductLog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ProductLog"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the principal solution for ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      FormBox[
       RowBox[{"z", "=", 
        RowBox[{"w", "\[InvisibleSpace]", 
         SuperscriptBox["e", "w"]}]}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ProductLog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ProductLog"], "[", 
       RowBox[{
        StyleBox["k", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " solution. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22655]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell["\<\
The solutions are ordered according to their imaginary parts. \
\>", "Notes",
 CellID->15743],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", ">", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "e"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ProductLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProductLog"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is real. "
}], "Notes",
 CellID->18362],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ProductLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProductLog"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " satisfies the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"d", "\[InvisibleSpace]", 
     RowBox[{"w", "/", "d"}], "\[InvisibleSpace]", "z"}], "=", 
    RowBox[{"w", "/", 
     RowBox[{"(", 
      RowBox[{"z", "(", 
       RowBox[{"1", "+", "w"}], ")"}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->1207],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ProductLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ProductLog"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ProductLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ProductLog"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ProductLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ProductLog"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ProductLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProductLog"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "/", "e"}], TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ProductLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProductLog"], "[", 
   RowBox[{
    StyleBox["k", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " for integer ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", ">", "0"}], TraditionalForm]], "InlineMath"],
 " has a branch cut discontinuity from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to 0. "
}], "Notes",
 CellID->12004]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->180480929],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->68877009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"ProductLog", "[", 
   RowBox[{"-", "1.5"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1274],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.03278373591557242`"}], "+", 
  RowBox[{"1.5496438233501593`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->332390981]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->359235939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ProductLog", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "E"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->147701801],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->420302825]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ProductLog", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29508],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"z", "-", 
   SuperscriptBox["z", "2"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["z", "3"]}], "2"], "-", 
   FractionBox[
    RowBox[{"8", " ", 
     SuperscriptBox["z", "4"]}], "3"], "+", 
   FractionBox[
    RowBox[{"125", " ", 
     SuperscriptBox["z", "5"]}], "24"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "6"],
    SeriesData[$CellContext`z, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, -1, 
    Rational[3, 2], 
    Rational[-8, 3], 
    Rational[125, 24]}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{214, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168724804]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17950],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->565983956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProductLog", "[", 
  RowBox[{"2.5", "+", 
   RowBox[{"2", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->254334273],

Cell[BoxData[
 RowBox[{"1.0561679689486352`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.35256052020787015`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->721074878]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->94442221],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->859381732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ProductLog", "[", 
    RowBox[{"4", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218877805],

Cell[BoxData["0.\
2971677506731385467797269622470213419044581015501274519083671027243`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136422456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->538599550],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->73333118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProductLog", "[", "0.400000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6884168],

Cell[BoxData["0.297167750673138546779726962247021341904458101551`29.\
715056134320882"], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->477228167]
}, Open  ]],

Cell["\<\
The precision of the output can be much lower than the precision of the \
input:\
\>", "ExampleText",
 CellID->450527416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProductLog", "[", 
  RowBox[{"-", "0.367879441171442321595523770161"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->789870],

Cell[BoxData[
 RowBox[{"-", "1.`14.933367757014167"}]], "Output",
 ImageSize->{124, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->193616357]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->430956447],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->638281798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProductLog", "[", 
  RowBox[{
   RowBox[{"-", "Pi"}], "/", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->125697834],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "2"]], "Output",
 ImageSize->{28, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8949594]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProductLog", "[", 
  RowBox[{"1", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->630487120],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->383234074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->801998940],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ProductLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ProductLog"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->23721356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProductLog", "[", 
  RowBox[{"{", 
   RowBox[{"0.2", ",", "0.5", ",", "0.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53074613],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.16891597349910958`", ",", "0.3517337112491958`", ",", 
   "0.4900678588015799`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179240339]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80273313],

Cell["Find series expansions at branch points and branch cuts:", "ExampleText",
 CellID->23161600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ProductLog", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "E"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->640489264],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{
    SqrtBox[
     RowBox[{"2", " ", "\[ExponentialE]"}]], " ", 
    SqrtBox[
     RowBox[{"x", "+", 
      FractionBox["1", "\[ExponentialE]"]}]]}], "-", 
   RowBox[{
    FractionBox["2", "3"], " ", "\[ExponentialE]", " ", 
    RowBox[{"(", 
     RowBox[{"x", "+", 
      FractionBox["1", "\[ExponentialE]"]}], ")"}]}], "+", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"3", "/", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", 
        FractionBox["1", "\[ExponentialE]"]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}], 
    RowBox[{"18", " ", 
     SqrtBox["2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "+", 
       FractionBox["1", "\[ExponentialE]"]}], "]"}], 
     RowBox[{"5", "/", "2"}]],
    SeriesData[$CellContext`x, (-1)/E, {}, 0, 5, 2],
    Editable->False]}],
  SeriesData[$CellContext`x, (-1)/
   E, {-1, (2 E)^Rational[1, 2], Rational[-2, 3] E, Rational[11, 18] 
    2^Rational[-1, 2] E^Rational[3, 2]}, 0, 5, 2],
  Editable->False]], "Output",
 ImageSize->{399, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20998293]
}, Open  ]],

Cell["The series expansion at infinity contains nested logarithms:", \
"ExampleText",
 CellID->273695081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"ProductLog", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "Infinity", ",", "0"}], "}"}]}], "]"}], "//", 
  "Normal"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4958433],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    FractionBox["1", "x"], "]"}]}], "-", 
  RowBox[{"Log", "[", 
   RowBox[{"-", 
    RowBox[{"Log", "[", 
     FractionBox["1", "x"], "]"}]}], "]"}], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      FractionBox["1", "x"], "]"}]}], "]"}], 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox["1", "x"], "]"}], "2"]], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      FractionBox["1", "x"], "]"}]}], "]"}], 
   RowBox[{"Log", "[", 
    FractionBox["1", "x"], "]"}]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      RowBox[{"Log", "[", 
       FractionBox["1", "x"], "]"}]}], "]"}], "2"], 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      FractionBox["1", "x"], "]"}], "2"]}]]}]], "Output",
 ImageSize->{479, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->640036627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->388597735],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->257901027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ProductLog", "[", "z", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157825268],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox["W",
    ProductLog], "(", "z", ")"}], TraditionalForm]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->103096408]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18847],

Cell["\<\
Evaluate numerically on different sheets of the Riemann surface:\
\>", "ExampleText",
 CellID->23376710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ProductLog", "[", 
    RowBox[{"k", ",", "2.3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->267094722],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.5617487724863615`"}], "-", 
    RowBox[{"10.852650657302862`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.6961313670818546`"}], "-", 
    RowBox[{"4.5609285808367765`", " ", "\[ImaginaryI]"}]}], ",", 
   "0.9182235367998267`", ",", 
   RowBox[{
    RowBox[{"-", "0.6961313670818546`"}], "+", 
    RowBox[{"4.5609285808367765`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.5617487724863615`"}], "+", 
    RowBox[{"10.852650657302862`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{362, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->469396900]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86981060],

Cell["Find series expansions at branch points and branch cuts:", "ExampleText",
 CellID->288307966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ProductLog", "[", 
    RowBox[{"2", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->810504861],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0tPFEEQnn1iRHnIGsETCirhoWI0EUQvJnDyRxBiAjFEAxzwtNF48MbJ
7M09rjeOnAxHjhx8bKI/gCMXE26209M9OzPf1jx6p2d2RyXZ2anpR1V9VTXb
Vd08W91Zf765urOxtjq+srX6an1jbXt8+eWW+aiQM4zcD8Mwno4a5j0z76wP
//tpfsStuJvg14LdyowF88LJkvmdN7/75XcR+n0G+mHEcSsW1+vw9DHQeaD7
gS4A/cKH+wL0W4rJZ9mS/ho8LUnuXNc+8xtHIV0i6JIcZ89TtLErtvpJnfI+
yCK9qajrtJSiT7N2xUS0G7LoWq12cnLCb++RlikHyGZeRXvJLQN/eo6axZFU
Stk+jn6KkufbZqMQc9P3Y1pAj39Nk9qht+hBvNRlxIV3nZ2d7e7uMl/v4vOW
bZ1cOva18StLC+j1pIK0FGKO/R5osUnaUTADNMqjjr5er4qK/rBFm45kuhO/
nWd+vhQcXWgTXxvhmyFh/eaV7ZBOFMwCjW8qPYij16aBuPCoZrPZaDRsC7R7
VKEN5QS9yY1rR9FOjeDkrBYrpREXc1F4xrKHgq8lZo+L1vO9vT35/C6jfM89
2pCz25HPVzCDRH97ZcLlFaqJP8CNqa0TEY252FZIMypuAx1kJQrnga7hTPsJ
5n3ulSuX4Sa0jwAdlp+hVHMsGJ/k/JBeLaMvof43NOt/waLNLMljBcz57Tca
SndVolFhwTk9eiWirmrVGcn3fEQ5xzqUk0bnDUh/RxGdGowXkVCtVj1c3sJs
/FIh5XNGXgFOFj5W509EzyCELV2MD/D0HdDvYVZ885WZU3WJHhl6eFs8NWQZ
QhqB1+HhoYz1bSvgp6am5Jqde15r5dpBv9dWv3q9LrkWQDu7RhJNK78VSJrI
9oIMUa3LbzFCBvw5KHqy4uwYlR5uJcnNMG4xb0XzEaMrnDY9Ce1LIf0nFPsP
gIaDAf3bbCR+DQNWC6r1X0QSfzdx/JOY808mPD++6bH2IVAcZQF1PIgeuz1K
vZAar79iO5KQ9OlU0y9lWvpo/jXm5WHEq8t0Vgkm68ldrARXegCTbldiqUj+
jwkVYU4ukUaERa+Au/Pe9CvgemMoK7sueqMkK1pjHEwz1y+U8H/8NYwTo8qV
4bD9yjTq95jnp49CL+wbYRXo30RBxAvWSRXixI2Cjxxq9e4YERIiS4erry7h
0Eu7YQqx8lfjQFdsMVpCq/g+HAyjmzso6Os6tUhvvw09NZta2LudwtePj48P
Dg74rdhpR3+jdHbrobqrE+YZYfxU91vCbJg0P3xXCNSr1arnxMwo8+63lJna
bpBdqbwccR6//R17noqmeeh33unpqefsGW+qkz0bjYbEyen5ESy06DvHQqsF
TwYLuZw9C375YrUIvs1mU0YFb/nqanHez06LiHVTUNFotXxrteSPjo74k++u
vs7ZTm9fdx1Lb8sio2va40ytFs8ny5EcVOvc5CkxFx23bv6blLI36seDQbMA
NxVp0zmfTCObzZrokFZ+f8cJYdq+vVqRS4ZbVk7g2tr/8rVZNupIQxp5ZPf0
Kx152apzKFgyhFe2T5XStuxeTo52yWYlIRqqqlkpYpN01uu/NlXJ+oaZnqyR
d6LX9PySXHZi5l9kFkRlTGZ2Jf8jwOnrn5GJFnPy/f19b4t/5sfvRHZo5P4A
VTKVAw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{474, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98097362]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36718179],

Cell[TextData[{
 "The branch points and branch cuts are different for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "=", "0"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->184563188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Im", "[", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"k", ",", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"Exclusions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y", "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"E", " ", "x"}], "<", 
          RowBox[{"k", "-", "1"}]}]}], "}"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127730750],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225226478]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], "==", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31828],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    RowBox[{"ProductLog", "[", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], ",", 
      RowBox[{"-", "1"}]}], "]"}]}]}]}]], "Output",
 ImageSize->{292, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5581198]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177306855],

Cell[TextData[{
 "Plot the real and imaginary parts of",
 Cell[BoxData[
  RowBox[{" ", "ProductLog"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->97739527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"k", ",", "x"}], "]"}], "]"}], ",", 
        RowBox[{"Im", "[", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"k", ",", "x"}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129515485],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307285]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->985379848],

Cell[TextData[{
 "Plot the Riemann surface of ",
 Cell[BoxData[
  ButtonBox["ProductLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ProductLog"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->460557743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"u", "+", 
          RowBox[{"\[ImaginaryI]", " ", "v"}]}], ")"}], 
        RowBox[{"Exp", "[", 
         RowBox[{"u", "+", 
          RowBox[{"\[ImaginaryI]", " ", "v"}]}], "]"}]}], "]"}], ",", 
      RowBox[{"Im", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"u", "+", 
          RowBox[{"\[ImaginaryI]", " ", "v"}]}], ")"}], 
        RowBox[{"Exp", "[", 
         RowBox[{"u", "+", 
          RowBox[{"\[ImaginaryI]", " ", "v"}]}], "]"}]}], "]"}], ",", "v"}], 
     "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", 
      RowBox[{"3", "/", "2"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17658646],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{203, 277},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100427194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->419325224],

Cell[TextData[{
 "Calculate the limit of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", 
    SuperscriptBox["x", 
     SuperscriptBox["x", "\[Ellipsis]"]]], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->424720475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "w"], "==", "w"}], ",", "w"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41310105],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->466937827],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->453484587],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"ProductLog", "[", 
       RowBox[{"-", 
        RowBox[{"Log", "[", "x", "]"}]}], "]"}], 
      RowBox[{"Log", "[", "x", "]"}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{201, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->792130034]
}, Open  ]],

Cell[TextData[{
 "Compare the exact result with explicit iterations for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"\[Pi]", "/", "4"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->191133386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"Pi", "/", "4"}], ",", "20"}], "]"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"ProductLog", "[", 
        RowBox[{"-", 
         RowBox[{"Log", "[", "x", "]"}]}], "]"}], 
       RowBox[{"Log", "[", "x", "]"}]]}], ",", 
     RowBox[{"Nest", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Power", "[", 
         RowBox[{"x", ",", "#"}], "]"}], "&"}], ",", "x", ",", "1000"}], 
      "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15450935],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.82025194858179069646672621623`19.119485900256127", ",", 
   "0.82025194858179069646672621622951730022`19.87991866693638"}], 
  "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->204222176]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->211926865],

Cell["\<\
Determine the number of labeled unrooted trees from the generating function:\
\>", "ExampleText",
 CellID->204010594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"CoefficientList", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"-", "x"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "12"}], "}"}]}], "]"}], ",", "x"}], "]"}],
    " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "12"}], "]"}], "!"}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->413516975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "9", ",", "64", ",", "625", ",", "7776", ",", 
   "117649", ",", "2097152", ",", "43046721", ",", "1000000000", ",", 
   "25937424601", ",", "743008370688"}], "}"}]], "Output",
 ImageSize->{362, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->576953108]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"n", "^", 
    RowBox[{"(", 
     RowBox[{"n", "-", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45127923],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "9", ",", "64", ",", "625", ",", "7776", ",", "117649", 
   ",", "2097152", ",", "43046721", ",", "1000000000", ",", "25937424601", 
   ",", "743008370688"}], "}"}]], "Output",
 ImageSize->{362, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->310987789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15423973],

Cell["\<\
Solve Lotka\[Hyphen]Volterra equations:\
\>", "ExampleText",
 CellID->289956769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "==", 
      RowBox[{"\[Alpha]", " ", 
       RowBox[{"x", "[", "t", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"y", "[", "t", "]"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], "==", " ", 
      RowBox[{"\[Beta]", " ", 
       RowBox[{"y", "[", "t", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"x", "[", "t", "]"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->335034465],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->789915382],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->259085394],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->273333426],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->51953187],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{"-", 
        RowBox[{"ProductLog", "[", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"C", "[", "1", "]"}]}], "-", 
             FractionBox[
              RowBox[{"\[Beta]", " ", 
               RowBox[{
                RowBox[{"InverseFunction", "[", 
                 RowBox[{
                  RowBox[{
                   SubsuperscriptBox["\[Integral]", "1", "#1"], 
                   RowBox[{
                    FractionBox["1", 
                    RowBox[{
                    RowBox[{"K", "[", "1", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"ProductLog", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["\[ExponentialE]", 
                    FractionBox[
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "\[Alpha]"}], " ", 
                    RowBox[{"C", "[", "1", "]"}]}], "-", 
                    RowBox[{"\[Beta]", " ", 
                    RowBox[{"K", "[", "1", "]"}]}]}], "\[Alpha]"]]}], " ", 
                    SuperscriptBox[
                    RowBox[{"K", "[", "1", "]"}], 
                    FractionBox["\[Beta]", "\[Alpha]"]]}], "]"}]}], ")"}]}]], 
                    
                    RowBox[{"\[DifferentialD]", 
                    RowBox[{"K", "[", "1", "]"}]}]}]}], "&"}], "]"}], "[", 
                RowBox[{
                 RowBox[{"t", " ", "\[Alpha]"}], "+", 
                 RowBox[{"C", "[", "2", "]"}]}], "]"}]}], "\[Alpha]"]}]]}], 
          " ", 
          SuperscriptBox[
           RowBox[{
            RowBox[{"InverseFunction", "[", 
             RowBox[{
              RowBox[{
               SubsuperscriptBox["\[Integral]", "1", "#1"], 
               RowBox[{
                FractionBox["1", 
                 RowBox[{
                  RowBox[{"K", "[", "1", "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"ProductLog", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["\[ExponentialE]", 
                    FractionBox[
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "\[Alpha]"}], " ", 
                    RowBox[{"C", "[", "1", "]"}]}], "-", 
                    RowBox[{"\[Beta]", " ", 
                    RowBox[{"K", "[", "1", "]"}]}]}], "\[Alpha]"]]}], " ", 
                    SuperscriptBox[
                    RowBox[{"K", "[", "1", "]"}], 
                    FractionBox["\[Beta]", "\[Alpha]"]]}], "]"}]}], ")"}]}]], 
                
                RowBox[{"\[DifferentialD]", 
                 RowBox[{"K", "[", "1", "]"}]}]}]}], "&"}], "]"}], "[", 
            RowBox[{
             RowBox[{"t", " ", "\[Alpha]"}], "+", 
             RowBox[{"C", "[", "2", "]"}]}], "]"}], 
           FractionBox["\[Beta]", "\[Alpha]"]]}], "]"}]}]}], "]"}]}], ",", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{"InverseFunction", "[", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox["\[Integral]", "1", "#1"], 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"K", "[", "1", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"ProductLog", "[", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["\[ExponentialE]", 
                    FractionBox[
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "\[Alpha]"}], " ", 
                    RowBox[{"C", "[", "1", "]"}]}], "-", 
                    RowBox[{"\[Beta]", " ", 
                    RowBox[{"K", "[", "1", "]"}]}]}], "\[Alpha]"]]}], " ", 
                  SuperscriptBox[
                   RowBox[{"K", "[", "1", "]"}], 
                   FractionBox["\[Beta]", "\[Alpha]"]]}], "]"}]}], ")"}]}]], 
            RowBox[{"\[DifferentialD]", 
             RowBox[{"K", "[", "1", "]"}]}]}]}], "&"}], "]"}], "[", 
        RowBox[{
         RowBox[{"t", " ", "\[Alpha]"}], "+", 
         RowBox[{"C", "[", "2", "]"}]}], "]"}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{568, 267},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->402492725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36785391],

Cell["Find frequency of the maximum of the blackbody spectrum:", "ExampleText",
 CellID->39800692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"8", "\[Pi]"}], 
        SuperscriptBox["c", "3"]], 
       FractionBox[
        RowBox[{"f", "^", "3"}], 
        RowBox[{
         RowBox[{"Exp", "[", 
          FractionBox[
           RowBox[{"h", " ", "f"}], 
           RowBox[{"kB", " ", "T"}]], "]"}], "-", "1"}]]}], ",", "f"}], "]"}],
     "==", "0"}], ",", "f", ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148406178],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "\[NotEqual]", "0"}], "&&", 
  RowBox[{"h", "\[NotEqual]", "0"}], "&&", 
  RowBox[{"kB", "\[NotEqual]", "0"}], "&&", 
  RowBox[{"T", "\[NotEqual]", "0"}], "&&", 
  RowBox[{"f", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{"3", " ", "kB", " ", "T"}], "+", 
     RowBox[{"kB", " ", "T", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"-", 
        FractionBox["3", 
         SuperscriptBox["\[ExponentialE]", "3"]]}], "]"}]}]}], 
    "h"]}]}]], "Output",
 ImageSize->{410, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73517456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->606528733],

Cell["Solve the Haissinski equation:", "ExampleText",
 CellID->109092795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"w", "'"}], "[", "x", "]"}], " ", "==", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"-", " ", "x"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", " ", "-", " ", 
        RowBox[{"\[Alpha]", " ", 
         RowBox[{"w", "[", "x", "]"}]}]}], ")"}]}], " ", 
     RowBox[{"w", "[", "x", "]"}]}]}], ",", " ", "w", ",", " ", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486681432],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->286645973],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->235933721],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"ProductLog", "[", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", 
              FractionBox[
               SuperscriptBox["x", "2"], "2"]}], "-", 
             RowBox[{"C", "[", "1", "]"}]}]]}], " ", "\[Alpha]"}], "]"}], 
        "\[Alpha]"]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{322, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114690290]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->445576773],

Cell["Equipotential curves of a plate capacitor:", "ExampleText",
 CellID->118673452],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", "y_"}], "}"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"z", "=", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}]}], "}"}], ",", 
    RowBox[{"Im", "[", 
     RowBox[{"z", "-", "1", "-", 
      RowBox[{"ProductLog", "[", 
       RowBox[{
        RowBox[{"Ceiling", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", " ", "-", "Pi"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "Pi"}], ")"}]}], "]"}], ",", 
        RowBox[{"Exp", "[", 
         RowBox[{"z", "-", "1"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->219667548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Thickness", "[", "0.02", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "Pi"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "Pi"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "Pi"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "Pi"}]}], "}"}]}], "}"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ContourShading", "->", "False"}], ",", 
   RowBox[{"Contours", "->", "20"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->595316164],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxsnXV8Fcf3sOM3JCGhFIdCcSlStPguFCkUd3d3d9fiWty1xV0Ds7hDILi7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   "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3038, 3084, 3523, 5123, 5125, 5124, 3518, 4073, 4074, 4075, 
         3813, 3831, 5148, 3552, 5147, 3553, 5149, 5242, 5243, 5244, 5098, 
         5097, 3451, 5099, 3452, 4705, 3302, 3333, 5216, 3105, 3358, 5240, 
         3359, 3335, 5036, 3334, 5037, 5050, 5049, 3749, 3104, 5044, 5045, 
         5043, 5047, 5046, 3133, 3839, 3132, 5231, 3545, 3625, 3626, 3543, 
         5141, 3544, 5142, 3441, 5090, 3440, 3732, 3114, 4499, 4500, 4498, 
         4523, 4522, 4947, 3083, 5254, 4521, 4009, 5022, 5023, 5021, 4082, 
         4982, 4497, 3329, 4496, 3328, 5033, 3664, 4946, 4945, 5018, 3289, 
         5020, 5019, 5236, 5235, 4981, 4980, 5042, 5041, 4068, 4063, 3327, 
         4495, 3148, 4457, 3288, 4057, 3287, 4456, 3347, 4062, 4061, 4060, 
         3326, 4494, 3147, 4455, 3286, 4453, 3285, 4454, 3346, 4055, 4054, 
         4053, 3325, 4493, 3146, 4452, 3284, 4450, 3283, 4451, 3345, 4052, 
         4051, 4050, 3324, 4492, 3145, 4449, 3282, 4446, 4448, 4447, 4518, 
         3100, 4049, 4048, 4491, 4490, 4696}],
        "2.61`"],
       Annotation[#, 2.61, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3039, 3085, 3649, 3650, 3599, 3843, 3106, 5217, 3600, 4954, 
         4953, 3303, 5026, 3151, 5035, 3332, 4976, 4977, 5122, 3522, 4988, 
         4989, 3792, 3446, 3840, 3546, 3846, 3627, 5143, 3547, 5001, 5002, 
         4698, 3443, 4697, 3442, 5091, 3786, 3115, 4083, 3734, 3301, 3838, 
         3300, 4501, 3330, 4072, 4973, 4460, 3291, 4458, 3290, 4459, 4520, 
         4519, 3103, 4071, 4070, 4086, 5255, 5257, 5256, 3119, 4767, 3120, 
         3602, 3845, 3844, 3512, 5190, 5191, 4971, 4972, 3102, 4755, 3101, 
         5215, 4754, 4069, 4753, 4752, 3624, 4751, 3511, 4065, 4066, 4067, 
         3826, 4970, 4969, 4064, 3510, 4750, 3623, 4749, 3508, 4056, 4058, 
         4059, 3824, 3825, 3507, 4747, 3506, 4748, 3032, 5116, 3503, 4744, 
         3504, 4745, 3500, 4743, 3502, 4741, 3501, 4742, 3031, 5115, 3498, 
         4739, 3499, 4740, 3495, 4738, 3497, 4736, 3496, 4737, 3030, 5114, 
         3492, 4734, 3493, 4735, 3489, 4733, 3491, 4731, 3490, 4732, 3494}],
        "2.32`"],
       Annotation[#, 2.32, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3040, 3086, 4949, 4948, 3295, 5024, 3036, 4879, 5095, 5094, 
         3447, 3828, 3829, 3612, 3628, 3035, 3830, 4873, 4872, 4871, 3567, 
         3788, 3787, 4984, 4983, 4084, 5120, 5119, 4975, 4974, 3331, 5034, 
         3149, 3785, 3150, 3665, 4016, 3087, 3814, 4952, 4951, 4015, 3469, 
         4711, 3565, 4772, 3566, 4773, 3514, 5117, 3515, 4761, 3513, 4759, 
         4760, 4756, 4758, 4757, 3033, 3884, 3885, 3883, 5089, 3882, 3881, 
         3436, 3725, 3724, 3775, 3080, 3643, 3509, 3721, 3720, 3774, 3079, 
         3642, 3505, 3719, 4746, 3718, 3773, 3434, 3641, 3640, 3823, 3268, 
         3717, 3433, 3639, 3638, 3822, 3267, 3716, 3432, 3637, 3636, 3821, 
         3266, 3715, 3879}],
        "2.03`"],
       Annotation[#, 2.03, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3795, 3794, 5175, 5176, 5174, 3577, 5177, 3448, 5172, 3575, 
         5171, 3574, 3793, 5169, 3572, 5168, 3573, 5170, 3444, 5165, 3569, 
         5163, 3568, 5164, 3780, 3789, 3790, 3648, 3647, 3847, 3292, 4869, 
         5202, 4870, 4699, 5092, 4762, 5270, 5272, 5271, 3516, 5118, 3517, 
         4763, 3439, 4693, 5086, 5085, 3729, 3777, 3081, 3646, 3468, 3728, 
         3727, 3776, 3437, 3645, 3644, 3827, 3275, 3726, 3435, 3880, 4689, 
         4688, 3274, 3770, 3273, 3722, 4862, 4431, 3272, 4000, 3271, 4430, 
         4861, 4429, 3270, 3998, 3269, 4428, 4859, 4860, 4426, 4941, 4427, 
         3996, 4425, 4424, 3024, 4422, 4940, 4423, 3994, 4421, 4420, 3023, 
         4418, 4939, 4419, 3992, 4417, 4416, 4687}],
        "1.7399999999999998`"],
       Annotation[#, 1.7399999999999998`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3041, 4884, 3037, 4883, 4882, 3450, 5096, 3449, 5173, 3576, 
         4880, 4881, 3791, 3445, 5167, 3571, 5166, 3570, 3784, 4703, 4704, 
         4702, 4701, 4010, 3293, 4874, 5203, 4875, 4700, 5093, 4876, 4877, 
         3778, 3779, 3562, 4768, 3561, 5162, 3731, 4695, 3082, 5209, 4694, 
         4007, 3279, 4441, 3438, 4690, 4692, 4691, 3278, 4004, 3277, 4440, 
         4863, 4439, 3276, 4002, 4438, 4437, 3026, 4435, 4436, 4432, 4434, 
         4433, 3025, 3723, 3019, 3875, 3874, 3426, 3711, 3710, 4675, 3076, 
         4943, 4674, 3999, 4398, 4397, 4673, 3075, 4942, 4672, 3997, 4394, 
         4393, 4671, 3425, 4670, 4669, 3995, 3251, 4389, 3424, 4668, 4667, 
         3993, 3250, 4384, 3423, 4665, 4664, 3991, 3249, 4379, 4852}],
        "1.45`"],
       Annotation[#, 1.45, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4666, 4375, 4376, 3974, 4378, 4933, 4377, 3016, 4380, 4381, 
         3976, 4383, 4934, 4382, 3017, 4385, 4386, 3978, 4388, 4935, 4387, 
         3018, 4390, 4391, 3980, 3252, 4392, 4853, 4395, 3253, 3982, 3254, 
         4396, 4854, 4399, 3255, 3984, 3256, 4400, 4855, 4401, 3257, 3986, 
         3258, 4677, 4678, 4676, 3427, 4402, 3259, 4001, 4679, 4680, 3428, 
         4408, 3260, 4003, 4681, 4944, 3077, 4682, 3713, 3714, 3429, 3876, 
         3877, 3878, 3730, 3027, 4443, 4444, 4442, 3280, 4445, 4866, 5087, 
         5088, 4865, 5201, 4864, 3281, 4008, 4769, 4770, 3563, 4771, 3781, 
         3782, 3564, 4867, 4868, 3028, 3783, 3034, 4462, 4463, 4461, 3294, 
         4464, 4878}],
        "1.16`"],
       Annotation[#, 1.16, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3029, 3771, 3772, 3560, 5160, 3559, 5161, 3769, 4686, 3078, 
         5253, 4685, 4006, 3265, 4415, 3431, 4684, 4683, 4005, 3264, 4857, 
         5268, 3430, 5084, 4858, 4414, 3263, 3988, 3262, 4413, 4856, 4412, 
         3261, 4409, 4411, 4410, 3021, 4406, 4407, 4403, 4405, 4404, 3020, 
         3712, 3870, 3869, 3868, 3420, 3709, 3708, 4652, 3073, 4938, 4651, 
         3985, 4365, 4364, 4650, 3072, 4937, 4649, 3983, 4360, 4359, 4648, 
         3071, 4936, 4647, 3981, 3239, 4354, 3419, 4646, 4645, 3979, 3238, 
         4349, 3418, 4644, 4643, 3977, 3237, 4344, 3417, 4642, 4641, 3975, 
         3236, 4339, 3416, 4639, 4638, 3973, 3235, 4334, 4848}],
        "0.8699999999999999`"],
       Annotation[#, 0.8699999999999999, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3022, 3768, 3873, 3872, 3871, 3558, 3767, 3766, 4663, 3074, 
         5252, 4662, 3990, 4374, 4373, 4660, 4661, 4659, 4658, 3989, 3248, 
         4372, 3422, 4657, 4656, 3987, 3247, 4371, 3421, 4653, 4655, 4654, 
         3246, 3969, 3245, 4370, 4851, 4369, 3244, 3967, 3243, 4368, 4850, 
         4367, 3242, 3965, 3241, 4366, 4849, 4363, 3240, 3963, 4362, 4361, 
         3014, 4357, 4931, 4358, 3961, 4356, 4355, 3013, 4352, 4930, 4353, 
         3959, 4351, 4350, 3012, 4347, 4929, 4348, 3957, 4346, 4345, 3011, 
         4342, 4928, 4343, 3955, 4341, 4340, 3010, 4337, 4927, 4338, 3953, 
         4336, 4335, 3009, 4332, 4926, 4333, 3951, 4331, 4330, 4640}],
        "0.58`"],
       Annotation[#, 0.58, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3015, 3765, 3867, 3866, 3865, 3557, 3707, 3706, 4637, 3070, 
         5251, 4636, 3972, 4324, 4323, 4635, 3069, 5250, 4634, 3971, 4317, 
         4316, 4633, 3068, 5249, 4632, 3970, 4310, 4309, 4631, 3067, 4932, 
         4630, 3968, 3234, 4303, 3415, 4629, 4628, 3966, 3233, 4297, 3414, 
         4627, 4626, 3964, 3232, 4291, 3413, 4625, 4624, 3962, 3231, 4285, 
         3412, 4623, 4622, 3960, 3230, 4279, 3411, 4621, 4620, 3958, 3229, 
         4273, 3410, 4619, 4618, 3956, 3228, 4267, 3409, 4617, 4616, 3954, 
         3227, 4261, 3408, 4615, 4614, 3952, 3226, 4255, 3407, 4612, 4611, 
         3950, 3225, 4249, 4847}],
        "0.29`"],
       Annotation[#, 0.29, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3008, 4328, 4329, 4325, 4327, 4326, 3007, 4321, 4322, 4318, 
         4320, 4319, 3006, 4314, 4315, 4311, 4313, 4312, 3005, 4307, 4308, 
         4304, 4306, 4305, 3004, 4301, 4302, 4298, 4300, 4299, 3003, 4295, 
         4296, 4292, 4294, 4293, 3002, 4289, 4290, 4286, 4288, 4287, 3001, 
         4283, 4284, 4280, 4282, 4281, 3000, 4277, 4278, 4274, 4276, 4275, 
         2999, 4271, 4272, 4268, 4270, 4269, 2998, 4265, 4266, 4262, 4264, 
         4263, 2997, 4259, 4260, 4256, 4258, 4257, 2996, 4253, 4254, 4250, 
         4252, 4251, 2995, 4247, 4248, 4244, 4246, 4245, 4613}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3406, 4208, 3206, 3931, 3207, 4209, 4838, 4210, 3208, 3933, 
         3209, 4211, 4839, 4212, 3210, 3935, 3211, 4213, 4840, 4214, 3212, 
         3937, 3213, 4215, 4841, 4216, 3214, 3939, 3215, 4217, 4842, 4218, 
         3216, 3941, 3217, 4219, 4843, 4220, 3218, 3943, 3219, 4221, 4844, 
         4222, 3220, 3945, 3221, 4223, 4845, 4224, 3222, 3947, 3223, 4225, 
         4846, 4226, 3224, 3949, 4228, 4925, 4227, 2991, 4230, 4231, 4229, 
         4233, 4232, 2992, 4235, 4236, 4234, 4238, 4237, 2993, 4240, 4241, 
         4239, 4243, 4242, 2994, 3704, 3705, 3405, 4835, 4836, 4837, 3066, 
         3764}],
        RowBox[{"-", "0.29`"}]],
       Annotation[#, -0.29, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2985, 4164, 4165, 3930, 4592, 4919, 3060, 4593, 4168, 4169, 
         3932, 4594, 4920, 3061, 4595, 4172, 4173, 3934, 4596, 4921, 3062, 
         4597, 4176, 4177, 3936, 4598, 4922, 3063, 4599, 4181, 4182, 3938, 
         4600, 4923, 3064, 4601, 4187, 4188, 3940, 4602, 4924, 3065, 4603, 
         4193, 4194, 3942, 4604, 4605, 3402, 4195, 3199, 3944, 4606, 4607, 
         3403, 4196, 3200, 3946, 4608, 4609, 3404, 4197, 3201, 3948, 4610, 
         4830, 5200, 4831, 5083, 5082, 4832, 4198, 5274, 3202, 3929, 3203, 
         4199, 4833, 4201, 3204, 4200, 3205, 4202, 4834, 2989, 4204, 4205, 
         4203, 4207, 4206, 2990, 3702, 3703, 3400, 3864, 4824, 4825, 3059, 
         3763}],
        RowBox[{"-", "0.58`"}]],
       Annotation[#, -0.58, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3401, 4162, 3190, 3913, 3191, 4163, 4826, 4166, 3192, 3915, 
         3193, 4167, 4827, 4170, 3194, 3917, 3195, 4171, 4828, 4174, 3196, 
         3919, 3197, 4175, 4829, 4178, 3198, 3921, 4180, 4916, 4179, 2986, 
         4183, 4184, 3923, 4186, 4917, 4185, 2987, 4189, 4190, 3925, 4192, 
         4918, 4191, 2988, 3700, 3701, 3396, 3863, 4821, 4822, 3057, 4585, 
         4151, 4152, 3926, 4586, 5248, 3058, 4587, 4153, 4154, 3927, 4588, 
         4589, 3397, 4155, 3186, 3928, 4590, 5241, 5267, 5266, 3398, 5081, 
         3399, 4591, 3187, 4156, 3188, 4157, 4823, 4159, 3189, 4158, 4161, 
         4160, 2984, 3699, 5078, 3390, 5077, 3391, 3635, 3053, 3762}],
        RowBox[{"-", "0.8699999999999999`"}]],
       Annotation[#, -0.8699999999999999, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2980, 4123, 4124, 3912, 4572, 4913, 3054, 4573, 4127, 4128, 
         3914, 4574, 4914, 3055, 4575, 4131, 4132, 3916, 4576, 4915, 3056, 
         4577, 4137, 4138, 3918, 4578, 4579, 3393, 4143, 3180, 3920, 4580, 
         4581, 3394, 4144, 3181, 3922, 4582, 4583, 3395, 4145, 3182, 3924, 
         4584, 4817, 5199, 4818, 5080, 5079, 4819, 4146, 5273, 3183, 3908, 
         3184, 4147, 4820, 4148, 3185, 3910, 4150, 4912, 4149, 2983, 3697, 
         3698, 3388, 3862, 4809, 4810, 3052, 4567, 4117, 4118, 3911, 4568, 
         5264, 4569, 5265, 3389, 5075, 5076, 4571, 4570, 3172, 4119, 3173, 
         4120, 4811, 4812, 3693, 3694, 3380, 4805, 4806, 2973, 3046, 4547, 
         4098, 4099, 3895, 4548, 5261, 5263, 5262, 3381}],
        RowBox[{"-", "1.16`"}]],
       Annotation[#, -1.16, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3392, 4121, 3174, 3897, 3175, 4122, 4813, 4125, 3176, 3899, 
         3177, 4126, 4814, 4129, 3178, 3901, 3179, 4130, 4815, 4816, 4133, 
         4134, 3903, 4136, 4909, 4135, 2981, 4139, 4140, 3905, 4142, 4910, 
         4141, 2982, 3695, 3696, 3386, 3858, 4807, 2977, 3050, 4559, 4108, 
         4109, 3906, 4562, 4911, 3051, 4563, 4110, 4111, 3907, 4564, 4565, 
         3387, 4112, 3170, 3909, 4566, 5073, 5074, 3861, 4808, 4114, 3171, 
         4113, 4116, 4115, 2979, 3692, 4546, 3378, 4545, 3379, 3633, 3045, 
         5072, 3377, 4542, 4544, 4543, 3157, 4096, 3158, 4097, 4804, 2972, 
         3669, 5069, 3372, 5068, 3373, 5070, 3631, 3632, 3370, 5066, 3371, 
         5067, 3154, 5062, 3365, 4800, 4801, 2963, 3042, 5109, 3479}],
        RowBox[{"-", "1.45`"}]],
       Annotation[#, -1.45, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2962, 3666, 2961, 4799, 4798, 3362, 5058, 3629, 5061, 3364, 
         5059, 3363, 5060, 3667, 2967, 5198, 3367, 3630, 5065, 3369, 5063, 
         3368, 5064, 3668, 2971, 4803, 4095, 3156, 4094, 3155, 4540, 4541, 
         4539, 5071, 3375, 5260, 4904, 4905, 3894, 3466, 4709, 3376, 3848, 
         3849, 3760, 3759, 3691, 2978, 4785, 4786, 3614, 4787, 3613, 3850, 
         3465, 3690, 3689, 3860, 3859, 3688, 3169, 3811, 3168, 3687, 3857, 
         3851, 4561, 4560, 3634, 3761, 3167, 3686, 3385, 4558, 4557, 3904, 
         3166, 4107, 3384, 4556, 4555, 3902, 3165, 4106, 3383, 4554, 3049, 
         4908, 4553, 3900, 4105, 4104, 4552, 3048, 4907, 4551, 3898, 4103, 
         4102, 4550, 3047, 4906, 4549, 3896, 4101, 4100, 2974}],
        RowBox[{"-", "1.7399999999999998`"}]],
       Annotation[#, -1.7399999999999998`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3382, 3670, 3159, 3803, 3160, 3671, 3853, 3672, 3161, 3804, 
         3162, 3673, 3854, 3674, 3163, 3805, 3164, 3675, 3855, 3856, 3676, 
         4724, 3677, 3462, 3679, 3678, 2975, 3680, 3681, 3463, 3683, 3682, 
         2976, 3684, 3685, 3374, 3852, 3891, 3892, 4764, 4902, 3044, 4901, 
         4765, 4766, 4728, 4730, 4729, 3464, 4783, 3597, 3893, 4903, 3663, 
         3144, 4710, 3467, 4011, 4012, 4013, 3812, 3819, 3820, 3598, 4047, 
         4967, 4968, 3756, 4537, 4538, 4465, 3299, 4014, 4950, 5233, 5234, 
         5008, 5009, 5010, 4092, 4093, 3887, 5197, 2966, 3043, 4893, 4894, 
         4533, 4535, 4534, 3153, 5056, 5057, 4797, 2960, 4889, 4888, 4887, 
         5017, 5016, 5055}],
        RowBox[{"-", "2.03`"}]],
       Annotation[#, -2.03, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2968, 4802, 5269, 3480, 5110, 3481, 4718, 3459, 4775, 3590, 
         3888, 4895, 4896, 3660, 5111, 3482, 4719, 3483, 4720, 3460, 4776, 
         3591, 3889, 4897, 4898, 3661, 5112, 3484, 4721, 3485, 4722, 3461, 
         4777, 3592, 3890, 4899, 4900, 3662, 5113, 3486, 4723, 3487, 3807, 
         5213, 3806, 4778, 3593, 4031, 3594, 4779, 3142, 4725, 3488, 4034, 
         4036, 4037, 3808, 4781, 3595, 4780, 3596, 4782, 3143, 4726, 4727, 
         4038, 4039, 3096, 3758, 3809, 3810, 3521, 4085, 4987, 3118, 3742, 
         4536, 4484, 4485, 4040, 4515, 5214, 3097, 4516, 4517, 4043, 4042, 
         4041, 3323, 4486, 3621, 3622, 3297, 3837, 3298, 3733, 4044, 3098, 
         3757, 4707, 3457, 4706, 3458, 4708, 3588, 4774, 3589, 5187, 3586, 
         5185, 3587, 5186, 3519, 3601, 4986, 4985, 3520, 5121, 5189, 5188, 
         3842, 5000, 4999, 4998, 3611, 5196, 4078, 4077, 5237, 3307, 5030, 
         4966, 4965, 5259, 3141, 5007, 4795, 4796, 2959, 5025, 3657}],
        RowBox[{"-", "2.32`"}]],
       Annotation[#, -2.32, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3099, 4045, 4046, 4018, 4506, 5212, 3094, 4507, 3095, 4020, 
         4019, 3308, 4471, 3617, 4472, 3309, 4021, 4508, 4509, 3341, 4024, 
         4023, 4022, 3310, 4473, 3618, 4474, 3311, 4025, 4510, 4511, 3342, 
         4028, 4027, 4026, 3312, 4475, 3619, 4476, 3313, 4029, 4512, 4513, 
         3343, 4033, 4032, 4030, 3314, 4477, 3620, 4478, 3315, 4035, 4514, 
         5039, 5040, 4079, 4080, 3737, 3317, 3800, 3316, 3736, 2969, 3738, 
         3320, 3835, 3321, 3739, 4081, 3743, 3322, 3802, 3455, 3741, 3740, 
         2970, 4480, 4481, 4479, 4483, 4482, 3113, 3744, 4531, 5275, 4532, 
         4530, 3366, 5100, 3456, 4892, 5208, 3747, 3351, 4784, 3610, 4090, 
         4091, 3130, 3836, 3131, 4488, 4489, 4487, 4525, 4524, 5048, 3748, 
         3093, 4964, 4505, 3339, 4504, 3340, 3356, 5239, 3355, 3109, 5221, 
         3338, 3296, 3306, 5211, 3092, 3548, 5003, 3134, 5105, 3478, 5104, 
         3477, 3091, 3816, 4963, 4962, 4017, 3476, 5155, 5156, 4789, 4790, 
         4791, 3735, 3656}],
        RowBox[{"-", "2.61`"}]],
       Annotation[#, -2.61, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0kdsz3EYx/FvL7RUdasKbY3WAYm9FbVdRIzEVoKqFaM3m4vYirO9EiNx
sE/2Xq04IEFixEgQ1VK8vod33s/neb7j//v9fwWli8cuSggh1KOycQiFmSG8
aRJCO37LRfyCc/kV5/BLbs6FySFcVTdQX+OGvJL7cF3ckxHCOPV47EsJIQMj
1Jk8ku9Z05QfcBO+zylc5Nzr6kT1DU7iVdyXf3ML505QT8R+Z2VhlDqbR/ND
a9L5MafyI07j9s69qW6kvsVV1j/FH/VKvXrORDO9Mrmr9b/U3Xi+/MSsRL7N
c+TO+tXyX3mV/I+z4jvSK5e7m9eqe/AC+anZEPkOz5W76D+TA1bLCZwd3y0v
lHua16l78SK5ymyo3Eqdh83ewxYUmz/X7683AP0wEMX4aXbEmho+yvlxpn7t
rAJ1a3zT/4HvSI3PwvP0V3MyN8Ya9Vp8dE9tU+8FNbhr/TC9DvF87hjv45b6
h+P/Ev8TVMsb7N+I3tZ8iM+YHsKetBD24pOzTvIV81xr1/H6+HvVS9w/yJ7L
cnP5IufwJd7tm82I3xQuOO88zqHA/IQ7jqOtvSucXYHl+CAfsnd4fN+chU7u
H6OfZF+FsxLjNyRPUr/nIdhj3V7siveiEieRZjaTZ2CT9SXyVvVZv+MLf8U0
TI/v1+yde6eqp2ByPM9dnzlPPx875HJ7d/IC3srzeTvP421cFvue/YB9B7HU
cy1DqftnYxbauGup2TKcMjuD0xisf8w9CZ75PwCdhac=
         "]],
        RowBox[{"-", "2.9`"}]],
       Annotation[#, -2.9, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Epilog->{
    RGBColor[1, 0, 0], 
    Thickness[0.02], 
    LineBox[
     NCache[{{-2, Pi}, {0, Pi}}, {{-2, 3.141592653589793}, {
       0, 3.141592653589793}}]], 
    LineBox[
     NCache[{{-2, -Pi}, {0, -Pi}}, {{-2, -3.141592653589793}, {
       0, -3.141592653589793}}]]},
  Frame->True,
  ImageMargins->0.,
  ImageSize->{181., Automatic},
  PlotRange->{{-2, 2}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{185, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->673834274]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ProductLog", "[", 
    RowBox[{"-", "1"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28184],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "0.31813150520476413531265425158766451721`19.514958920897826"}], "+", 
  RowBox[{
  "1.33723570143068940890116214319371061253`20.13856020344278", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136078750]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", 
  RowBox[{"Exp", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->480],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "1.00000000000000000000000000000000000011`19.580826789852107"}], "+", 
  RowBox[{"0``19.6152611388604", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52960582]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6698],

Cell[TextData[{
 "Compositions with the inverse function may need ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1886345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ProductLog", "[", "z", "]"}], 
  RowBox[{"Exp", "[", 
   RowBox[{"ProductLog", "[", "z", "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25193912],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380515543]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProductLog", "[", 
  RowBox[{"z", " ", 
   RowBox[{"Exp", "[", "z", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74339664],

Cell[BoxData[
 RowBox[{"ProductLog", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "z"], " ", "z"}], "]"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->169035059]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->66632568],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24442589]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32377383],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing",
 Cell[BoxData[
  RowBox[{" ", "ProductLog"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->39757699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[Alpha]", " ", 
     RowBox[{"ProductLog", "[", "z", "]"}]}]], "/", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", "z", "]"}], 
    RowBox[{"-", "\[Alpha]"}]]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77758727],

Cell[BoxData[
 SuperscriptBox["z", "\[Alpha]"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168451493]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->632414504],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->132863979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"ProductLog", "[", "z", "]"}], "2"], "-", 
     RowBox[{"5", " ", 
      RowBox[{"ProductLog", "[", "z", "]"}]}], "+", "1"}], "\[Equal]", "6"}], 
   ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55564816],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "-", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}], ")"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"5", "-", 
          RowBox[{"3", " ", 
           SqrtBox["5"]}]}], ")"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}], ")"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          RowBox[{"3", " ", 
           SqrtBox["5"]}]}], ")"}]}]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{403, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202137487]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39870680],

Cell["Integrals:", "ExampleText",
 CellID->196975415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["z", "a"], " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", "z", "]"}], "b"]}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242647067],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], "2"]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "a"}], " ", 
     RowBox[{"ProductLog", "[", "z", "]"}]}]], " ", 
   SuperscriptBox["z", "a"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "a"}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{
        RowBox[{"1", "+", "a", "+", "b"}], ",", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}]}], " ", 
         RowBox[{"ProductLog", "[", "z", "]"}]}]}], "]"}]}], "-", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"2", "+", "a", "+", "b"}], ",", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"1", "+", "a"}], ")"}]}], " ", 
        RowBox[{"ProductLog", "[", "z", "]"}]}]}], "]"}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"ProductLog", "[", "z", "]"}], "b"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1", "+", "a"}], ")"}]}], " ", 
      RowBox[{"ProductLog", "[", "z", "]"}]}], ")"}], 
    RowBox[{
     RowBox[{"-", "a"}], "-", "b"}]]}]}]], "Output",
 ImageSize->{568, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37501495]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->106967244],

Cell[TextData[{
 "Generically ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      RowBox[{"-", "1"}]], "(", 
     RowBox[{"f", "(", "z", ")"}], ")"}], "\[NotEqual]", "z"}], 
   TraditionalForm]], "InlineMath"],
 Cell[BoxData[Cell["", "InlineFormula"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->65468627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProductLog", "[", 
  RowBox[{
   RowBox[{"-", "3."}], " ", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", "3."}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->482481032],

Cell[BoxData[
 RowBox[{"-", "0.17856062787792112`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58783983]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ProductLog", "[", "3.", "]"}], " ", 
  RowBox[{"Exp", "[", " ", 
   RowBox[{"ProductLog", "[", "3.", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->246013012],

Cell[BoxData["2.9999999999999996`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38990589]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->250258779],

Cell["Nested derivatives:", "ExampleText",
 CellID->30287488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
     RowBox[{"ProductLog", "[", "x", "]"}], ",", "6"}], "]"}], "//", 
   "Simplify"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56872311],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{553, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->764031196]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->637342238],

Cell["Nested integrals:", "ExampleText",
 CellID->59711969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
     RowBox[{"ProductLog", "[", "x", "]"}], ",", "6"}], "]"}], "//", 
   "Simplify"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110011325],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     TagBox["W",
      ProductLog], "(", "x", ")"}], ",", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        TagBox["W",
         ProductLog], "(", "x", ")"}], "-", "1", "+", 
       FractionBox["1", 
        RowBox[{
         TagBox["W",
          ProductLog], "(", "x", ")"}]]}], ")"}]}], ",", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "3"]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "2"]}], "+", 
        RowBox[{"6", " ", 
         RowBox[{
          TagBox["W",
           ProductLog], "(", "x", ")"}]}], "+", "1"}], ")"}]}], 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{
        TagBox["W",
         ProductLog], "(", "x", ")"}], "2"]}]], ",", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"108", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "4"]}], "-", 
        RowBox[{"198", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "3"]}], "+", 
        RowBox[{"198", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "2"]}], "+", 
        RowBox[{"57", " ", 
         RowBox[{
          TagBox["W",
           ProductLog], "(", "x", ")"}]}], "+", "8"}], ")"}]}], 
     RowBox[{"648", " ", 
      SuperscriptBox[
       RowBox[{
        TagBox["W",
         ProductLog], "(", "x", ")"}], "3"]}]], ",", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3456", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "5"]}], "-", 
        RowBox[{"7200", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "4"]}], "+", 
        RowBox[{"7200", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "3"]}], "+", 
        RowBox[{"2760", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "2"]}], "+", 
        RowBox[{"700", " ", 
         RowBox[{
          TagBox["W",
           ProductLog], "(", "x", ")"}]}], "+", "81"}], ")"}]}], 
     RowBox[{"82944", " ", 
      SuperscriptBox[
       RowBox[{
        TagBox["W",
         ProductLog], "(", "x", ")"}], "4"]}]], ",", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1296000000", " ", 
       SuperscriptBox[
        RowBox[{
         TagBox["W",
          ProductLog], "(", "x", ")"}], "5"]}]], 
     RowBox[{
      SuperscriptBox["x", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"10800000", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "6"]}], "-", 
        RowBox[{"24660000", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "5"]}], "+", 
        RowBox[{"24660000", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "4"]}], "+", 
        RowBox[{"11397000", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "3"]}], "+", 
        RowBox[{"3974300", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "2"]}], "+", 
        RowBox[{"850905", " ", 
         RowBox[{
          TagBox["W",
           ProductLog], "(", "x", ")"}]}], "+", "82944"}], ")"}]}]}], ",", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"69984000000", " ", 
       SuperscriptBox[
        RowBox[{
         TagBox["W",
          ProductLog], "(", "x", ")"}], "6"]}]], 
     RowBox[{
      SuperscriptBox["x", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"97200000", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "7"]}], "-", 
        RowBox[{"238140000", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "6"]}], "+", 
        RowBox[{"238140000", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "5"]}], "+", 
        RowBox[{"126063000", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "4"]}], "+", 
        RowBox[{"54299700", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "3"]}], "+", 
        RowBox[{"16276995", " ", 
         SuperscriptBox[
          RowBox[{
           TagBox["W",
            ProductLog], "(", "x", ")"}], "2"]}], "+", 
        RowBox[{"2978976", " ", 
         RowBox[{
          TagBox["W",
           ProductLog], "(", "x", ")"}]}], "+", "250000"}], ")"}]}]}]}], 
   "}"}], TraditionalForm]], "Output",
 ImageSize->{482, 263},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->54514104]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6809],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27819]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28774],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->371]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->19586],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/LambertW-Function.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/ProductLog/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ProductLog"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->104630290],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->655144978],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->301244935]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ProductLog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 9.0460036}", "context" -> "System`", 
    "keywords" -> {
     "exponential function", "Lambert function", "Lambert's W-function", 
      "LambertW", "LambertW function", "logarithm", 
      "transcendental equations", "tree generating function"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ProductLog[z] gives the principal solution for w in z = we^w. \
ProductLog[k, z] gives the k\\[Null]^th solution. ", 
    "synonyms" -> {"product log"}, "title" -> "ProductLog", "type" -> 
    "Symbol", "uri" -> "ref/ProductLog"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7382, 264, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->180480929]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 219212, 4953}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2006, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2629, 76, 48, 1, 70, "ObjectName",
 CellID->23547],
Cell[2680, 79, 1249, 41, 70, "Usage",
 CellID->22655]
}, Open  ]],
Cell[CellGroupData[{
Cell[3966, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4444, 142, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4567, 148, 103, 3, 70, "Notes",
 CellID->15743],
Cell[4673, 153, 382, 16, 70, "Notes",
 CellID->18362],
Cell[5058, 171, 560, 20, 70, "Notes",
 CellID->1207],
Cell[5621, 193, 247, 8, 70, "Notes",
 CellID->9487],
Cell[5871, 203, 222, 7, 70, "Notes",
 CellID->31226],
Cell[6096, 212, 205, 7, 70, "Notes",
 CellID->28162],
Cell[6304, 221, 1041, 38, 70, "Notes",
 CellID->12004]
}, Closed]],
Cell[CellGroupData[{
Cell[7382, 264, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->180480929],
Cell[CellGroupData[{
Cell[7767, 278, 147, 5, 70, "ExampleSection",
 CellID->68877009],
Cell[CellGroupData[{
Cell[7939, 287, 140, 5, 28, "Input",
 CellID->1274],
Cell[8082, 294, 271, 8, 36, "Output",
 CellID->332390981]
}, Open  ]],
Cell[8368, 305, 125, 3, 70, "ExampleDelimiter",
 CellID->359235939],
Cell[CellGroupData[{
Cell[8518, 312, 268, 9, 28, "Input",
 CellID->147701801],
Cell[8789, 323, 2689, 48, 163, "Output",
 Evaluatable->False,
 CellID->420302825]
}, Open  ]],
Cell[11493, 374, 121, 3, 70, "ExampleDelimiter",
 CellID->23047],
Cell[CellGroupData[{
Cell[11639, 381, 218, 7, 70, "Input",
 CellID->29508],
Cell[11860, 390, 779, 27, 54, "Output",
 CellID->168724804]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12688, 423, 216, 7, 70, "ExampleSection",
 CellID->17950],
Cell[12907, 432, 74, 1, 70, "ExampleText",
 CellID->565983956],
Cell[CellGroupData[{
Cell[13006, 437, 150, 5, 70, "Input",
 CellID->254334273],
Cell[13159, 444, 274, 7, 36, "Output",
 CellID->721074878]
}, Open  ]],
Cell[13448, 454, 124, 3, 70, "ExampleDelimiter",
 CellID->94442221],
Cell[13575, 459, 70, 1, 70, "ExampleText",
 CellID->859381732],
Cell[CellGroupData[{
Cell[13670, 464, 185, 6, 70, "Input",
 CellID->218877805],
Cell[13858, 472, 235, 7, 36, "Output",
 CellID->136422456]
}, Open  ]],
Cell[14108, 482, 125, 3, 70, "ExampleDelimiter",
 CellID->538599550],
Cell[14236, 487, 112, 3, 70, "ExampleText",
 CellID->73333118],
Cell[CellGroupData[{
Cell[14373, 494, 138, 4, 70, "Input",
 CellID->6884168],
Cell[14514, 500, 229, 6, 36, "Output",
 CellID->477228167]
}, Open  ]],
Cell[14758, 509, 131, 4, 70, "ExampleText",
 CellID->450527416],
Cell[CellGroupData[{
Cell[14914, 517, 152, 4, 70, "Input",
 CellID->789870],
Cell[15069, 523, 196, 6, 36, "Output",
 CellID->193616357]
}, Open  ]],
Cell[15280, 532, 125, 3, 70, "ExampleDelimiter",
 CellID->430956447],
Cell[15408, 537, 91, 1, 70, "ExampleText",
 CellID->638281798],
Cell[CellGroupData[{
Cell[15524, 542, 149, 5, 70, "Input",
 CellID->125697834],
Cell[15676, 549, 215, 7, 51, "Output",
 CellID->8949594]
}, Open  ]],
Cell[CellGroupData[{
Cell[15928, 561, 129, 4, 70, "Input",
 CellID->630487120],
Cell[16060, 567, 185, 6, 36, "Output",
 CellID->383234074]
}, Open  ]],
Cell[16260, 576, 125, 3, 70, "ExampleDelimiter",
 CellID->801998940],
Cell[16388, 581, 213, 7, 70, "ExampleText",
 CellID->23721356],
Cell[CellGroupData[{
Cell[16626, 592, 168, 5, 70, "Input",
 CellID->53074613],
Cell[16797, 599, 276, 9, 36, "Output",
 CellID->179240339]
}, Open  ]],
Cell[17088, 611, 124, 3, 70, "ExampleDelimiter",
 CellID->80273313],
Cell[17215, 616, 98, 1, 70, "ExampleText",
 CellID->23161600],
Cell[CellGroupData[{
Cell[17338, 621, 270, 9, 70, "Input",
 CellID->640489264],
Cell[17611, 632, 1308, 42, 64, "Output",
 CellID->20998293]
}, Open  ]],
Cell[18934, 677, 105, 2, 70, "ExampleText",
 CellID->273695081],
Cell[CellGroupData[{
Cell[19064, 683, 263, 9, 70, "Input",
 CellID->4958433],
Cell[19330, 694, 1050, 38, 70, "Output",
 CellID->640036627]
}, Open  ]],
Cell[20395, 735, 125, 3, 70, "ExampleDelimiter",
 CellID->388597735],
Cell[20523, 740, 203, 7, 70, "ExampleText",
 CellID->257901027],
Cell[CellGroupData[{
Cell[20751, 751, 144, 4, 70, "Input",
 CellID->157825268],
Cell[20898, 757, 259, 9, 50, "Output",
 CellID->103096408]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21206, 772, 239, 7, 70, "ExampleSection",
 CellID->18847],
Cell[21448, 781, 114, 3, 70, "ExampleText",
 CellID->23376710],
Cell[CellGroupData[{
Cell[21587, 788, 269, 9, 70, "Input",
 CellID->267094722],
Cell[21859, 799, 727, 21, 54, "Output",
 CellID->469396900]
}, Open  ]],
Cell[22601, 823, 124, 3, 70, "ExampleDelimiter",
 CellID->86981060],
Cell[22728, 828, 99, 1, 70, "ExampleText",
 CellID->288307966],
Cell[CellGroupData[{
Cell[22852, 833, 247, 8, 70, "Input",
 CellID->810504861],
Cell[23102, 843, 1927, 36, 70, "Output",
 Evaluatable->False,
 CellID->98097362]
}, Open  ]],
Cell[25044, 882, 124, 3, 70, "ExampleDelimiter",
 CellID->36718179],
Cell[25171, 887, 204, 7, 70, "ExampleText",
 CellID->184563188],
Cell[CellGroupData[{
Cell[25400, 898, 848, 27, 70, "Input",
 CellID->127730750],
Cell[26251, 927, 35133, 580, 70, "Output",
 Evaluatable->False,
 CellID->225226478]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[61433, 1513, 222, 7, 70, "ExampleSection",
 CellID->1734],
Cell[CellGroupData[{
Cell[61680, 1524, 178, 6, 70, "Input",
 CellID->31828],
Cell[61861, 1532, 416, 14, 36, "Output",
 CellID->5581198]
}, Open  ]],
Cell[62292, 1549, 125, 3, 70, "ExampleDelimiter",
 CellID->177306855],
Cell[62420, 1554, 164, 6, 70, "ExampleText",
 CellID->97739527],
Cell[CellGroupData[{
Cell[62609, 1564, 715, 22, 70, "Input",
 CellID->129515485],
Cell[63327, 1588, 5630, 96, 70, "Output",
 Evaluatable->False,
 CellID->307285]
}, Open  ]],
Cell[68972, 1687, 125, 3, 70, "ExampleDelimiter",
 CellID->985379848],
Cell[69100, 1692, 215, 8, 70, "ExampleText",
 CellID->460557743],
Cell[CellGroupData[{
Cell[69340, 1704, 1077, 34, 70, "Input",
 CellID->17658646],
Cell[70420, 1740, 40184, 663, 70, "Output",
 Evaluatable->False,
 CellID->100427194]
}, Open  ]],
Cell[110619, 2406, 125, 3, 70, "ExampleDelimiter",
 CellID->419325224],
Cell[110747, 2411, 239, 9, 70, "ExampleText",
 CellID->424720475],
Cell[CellGroupData[{
Cell[111011, 2424, 174, 6, 70, "Input",
 CellID->41310105],
Cell[111188, 2432, 428, 8, 70, "Message",
 CellID->466937827],
Cell[111619, 2442, 453, 8, 70, "Message",
 CellID->453484587],
Cell[112075, 2452, 412, 14, 53, "Output",
 CellID->792130034]
}, Open  ]],
Cell[112502, 2469, 235, 8, 70, "ExampleText",
 CellID->191133386],
Cell[CellGroupData[{
Cell[112762, 2481, 691, 24, 70, "Input",
 CellID->15450935],
Cell[113456, 2507, 320, 10, 36, "Output",
 CellID->204222176]
}, Open  ]],
Cell[113791, 2520, 125, 3, 70, "ExampleDelimiter",
 CellID->211926865],
Cell[113919, 2525, 127, 3, 70, "ExampleText",
 CellID->204010594],
Cell[CellGroupData[{
Cell[114071, 2532, 511, 18, 70, "Input",
 CellID->413516975],
Cell[114585, 2552, 379, 10, 54, "Output",
 CellID->576953108]
}, Open  ]],
Cell[CellGroupData[{
Cell[115001, 2567, 248, 9, 70, "Input",
 CellID->45127923],
Cell[115252, 2578, 369, 10, 54, "Output",
 CellID->310987789]
}, Open  ]],
Cell[115636, 2591, 124, 3, 70, "ExampleDelimiter",
 CellID->15423973],
Cell[115763, 2596, 90, 3, 70, "ExampleText",
 CellID->289956769],
Cell[CellGroupData[{
Cell[115878, 2603, 739, 24, 70, "Input",
 CellID->335034465],
Cell[116620, 2629, 428, 8, 70, "Message",
 CellID->789915382],
Cell[117051, 2639, 453, 8, 70, "Message",
 CellID->259085394],
Cell[117507, 2649, 419, 8, 70, "Message",
 CellID->273333426],
Cell[117929, 2659, 418, 8, 70, "Message",
 CellID->51953187],
Cell[118350, 2669, 4748, 122, 288, "Output",
 CellID->402492725]
}, Open  ]],
Cell[123113, 2794, 124, 3, 70, "ExampleDelimiter",
 CellID->36785391],
Cell[123240, 2799, 98, 1, 70, "ExampleText",
 CellID->39800692],
Cell[CellGroupData[{
Cell[123363, 2804, 546, 19, 70, "Input",
 CellID->148406178],
Cell[123912, 2825, 639, 20, 62, "Output",
 CellID->73517456]
}, Open  ]],
Cell[124566, 2848, 125, 3, 70, "ExampleDelimiter",
 CellID->606528733],
Cell[124694, 2853, 73, 1, 70, "ExampleText",
 CellID->109092795],
Cell[CellGroupData[{
Cell[124792, 2858, 479, 16, 70, "Input",
 CellID->486681432],
Cell[125274, 2876, 428, 8, 70, "Message",
 CellID->286645973],
Cell[125705, 2886, 453, 8, 70, "Message",
 CellID->235933721],
Cell[126161, 2896, 712, 23, 68, "Output",
 CellID->114690290]
}, Open  ]],
Cell[126888, 2922, 125, 3, 70, "ExampleDelimiter",
 CellID->445576773],
Cell[127016, 2927, 85, 1, 70, "ExampleText",
 CellID->118673452],
Cell[127104, 2930, 740, 25, 70, "Input",
 CellID->219667548],
Cell[CellGroupData[{
Cell[127869, 2959, 1181, 37, 70, "Input",
 CellID->595316164],
Cell[129053, 2998, 65104, 1093, 70, "Output",
 CellID->673834274]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[194206, 4097, 232, 7, 70, "ExampleSection",
 CellID->8505],
Cell[CellGroupData[{
Cell[194463, 4108, 175, 6, 70, "Input",
 CellID->28184],
Cell[194641, 4116, 359, 11, 36, "Output",
 CellID->136078750]
}, Open  ]],
Cell[CellGroupData[{
Cell[195037, 4132, 116, 4, 70, "Input",
 CellID->480],
Cell[195156, 4138, 312, 9, 36, "Output",
 CellID->52960582]
}, Open  ]],
Cell[195483, 4150, 120, 3, 70, "ExampleDelimiter",
 CellID->6698],
Cell[195606, 4155, 235, 8, 70, "ExampleText",
 CellID->1886345],
Cell[CellGroupData[{
Cell[195866, 4167, 191, 6, 70, "Input",
 CellID->25193912],
Cell[196060, 4175, 158, 5, 36, "Output",
 CellID->380515543]
}, Open  ]],
Cell[CellGroupData[{
Cell[196255, 4185, 159, 5, 70, "Input",
 CellID->74339664],
Cell[196417, 4192, 257, 8, 36, "Output",
 CellID->169035059]
}, Open  ]],
Cell[CellGroupData[{
Cell[196711, 4205, 106, 3, 70, "Input",
 CellID->66632568],
Cell[196820, 4210, 157, 5, 36, "Output",
 CellID->24442589]
}, Open  ]],
Cell[196992, 4218, 124, 3, 70, "ExampleDelimiter",
 CellID->32377383],
Cell[197119, 4223, 299, 11, 70, "ExampleText",
 CellID->39757699],
Cell[CellGroupData[{
Cell[197443, 4238, 332, 10, 70, "Input",
 CellID->77758727],
Cell[197778, 4250, 188, 6, 36, "Output",
 CellID->168451493]
}, Open  ]],
Cell[197981, 4259, 125, 3, 70, "ExampleDelimiter",
 CellID->632414504],
Cell[198109, 4264, 75, 1, 70, "ExampleText",
 CellID->132863979],
Cell[CellGroupData[{
Cell[198209, 4269, 328, 11, 70, "Input",
 CellID->55564816],
Cell[198540, 4282, 1058, 37, 56, "Output",
 CellID->202137487]
}, Open  ]],
Cell[199613, 4322, 124, 3, 70, "ExampleDelimiter",
 CellID->39870680],
Cell[199740, 4327, 53, 1, 70, "ExampleText",
 CellID->196975415],
Cell[CellGroupData[{
Cell[199818, 4332, 247, 9, 70, "Input",
 CellID->242647067],
Cell[200068, 4343, 1431, 48, 71, "Output",
 CellID->37501495]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[201548, 4397, 230, 7, 70, "ExampleSection",
 CellID->106967244],
Cell[201781, 4406, 347, 13, 70, "ExampleText",
 CellID->65468627],
Cell[CellGroupData[{
Cell[202153, 4423, 201, 7, 70, "Input",
 CellID->482481032],
Cell[202357, 4432, 193, 6, 36, "Output",
 CellID->58783983]
}, Open  ]],
Cell[CellGroupData[{
Cell[202587, 4443, 204, 6, 70, "Input",
 CellID->246013012],
Cell[202794, 4451, 175, 5, 36, "Output",
 CellID->38990589]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[203018, 4462, 228, 7, 70, "ExampleSection",
 CellID->250258779],
Cell[203249, 4471, 61, 1, 70, "ExampleText",
 CellID->30287488],
Cell[CellGroupData[{
Cell[203335, 4476, 333, 11, 70, "Input",
 CellID->56872311],
Cell[203671, 4489, 4695, 81, 70, "Output",
 Evaluatable->False,
 CellID->764031196]
}, Open  ]],
Cell[208381, 4573, 125, 3, 70, "ExampleDelimiter",
 CellID->637342238],
Cell[208509, 4578, 59, 1, 70, "ExampleText",
 CellID->59711969],
Cell[CellGroupData[{
Cell[208593, 4583, 342, 11, 70, "Input",
 CellID->110011325],
Cell[208938, 4596, 5639, 194, 298, "Output",
 CellID->54514104]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[214638, 4797, 310, 9, 70, "SeeAlsoSection",
 CellID->6809],
Cell[214951, 4808, 676, 26, 70, "SeeAlso",
 CellID->27819]
}, Open  ]],
Cell[CellGroupData[{
Cell[215664, 4839, 314, 9, 70, "TutorialsSection",
 CellID->28774],
Cell[215981, 4850, 142, 3, 70, "Tutorials",
 CellID->371]
}, Open  ]],
Cell[CellGroupData[{
Cell[216160, 4858, 321, 9, 70, "RelatedLinksSection",
 CellID->19586],
Cell[216484, 4869, 188, 4, 70, "RelatedLinks"],
Cell[216675, 4875, 202, 4, 70, "RelatedLinks"],
Cell[216880, 4881, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217305, 4899, 319, 9, 70, "MoreAboutSection",
 CellID->104630290],
Cell[217627, 4910, 145, 3, 70, "MoreAbout",
 CellID->655144978],
Cell[217775, 4915, 145, 3, 70, "MoreAbout",
 CellID->301244935]
}, Open  ]],
Cell[217935, 4921, 27, 0, 70, "History"],
Cell[217965, 4923, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

