(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    131637,       2665]
NotebookOptionsPosition[    126641,       2493]
NotebookOutlinePosition[    128005,       2532]
CellTagsIndexPosition[    127918,       2527]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Background" :> 
          Documentation`HelpLookup["paclet:ref/Background"], "Epilog" :> 
          Documentation`HelpLookup["paclet:ref/Epilog"], "BaseStyle" :> 
          Documentation`HelpLookup["paclet:ref/BaseStyle"], "FrameStyle" :> 
          Documentation`HelpLookup["paclet:ref/FrameStyle"], "AxesStyle" :> 
          Documentation`HelpLookup["paclet:ref/AxesStyle"], "PlotStyle" :> 
          Documentation`HelpLookup["paclet:ref/PlotStyle"], "DisplayFunction" :> 
          Documentation`HelpLookup["paclet:ref/DisplayFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Background\"\>", 
       2->"\<\"Epilog\"\>", 3->"\<\"BaseStyle\"\>", 4->"\<\"FrameStyle\"\>", 
       5->"\<\"AxesStyle\"\>", 6->"\<\"PlotStyle\"\>", 
       7->"\<\"DisplayFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graphics Annotation & Appearance\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Prolog", "ObjectName",
 CellID->26073],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Prolog",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Prolog"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics functions which gives a list \
of graphics primitives to be rendered before the main part of the graphics is \
rendered. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22341]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Graphics primitives specified by ",
 Cell[BoxData[
  ButtonBox["Prolog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prolog"]], "InlineFormula"],
 " are rendered after axes, boxes and frames are rendered. "
}], "Notes",
 CellID->587],

Cell[TextData[{
 "In three\[Hyphen]dimensional graphics, two\[Hyphen]dimensional graphics \
primitives can be specified by the ",
 Cell[BoxData[
  ButtonBox["Prolog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prolog"]], "InlineFormula"],
 " option. The graphics primitives are rendered in a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "1"}], TraditionalForm]], "InlineMath"],
 " coordinate system. "
}], "Notes",
 CellID->24461],

Cell[TextData[{
 "Directives specified by ",
 Cell[BoxData[
  ButtonBox["Prolog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prolog"]], "InlineFormula"],
 " affect only the prolog, and not other contents of a graphic."
}], "Notes",
 CellID->31612853]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->95497529],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->332488882],

Cell["Draw a disk behind the plot of a quadratic function:", "ExampleText",
 CellID->77499382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"Prolog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", "1"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225818802],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWguMFdUZHnfm3uUlyMIKLALLe0HeiFqtEmutRRGrbdWUmgaJqaSxtD6a
Rhuz+LYuLVWqGLGQVI0P0mAkVhOMjZtICU1JpMamNCHWNLcJNSRuGrLBZPr9
/3fmnH/OnX1UG5uUXPbeM3PO978fZ85cteGOW26+dcMdmzZu6Lz8tg0/uGXT
xts7v7L5NlxKT0uSZB/+b52c4HeOX/p/X57ju/lvK/6mmNAiI/mhVzHG//EV
9+RncU++04p1Cwa5Nxhm2yC8KFYyIlpVj8bjorGuysI44YzSldZozdwhZwxN
pa2CTzHMafLNKakTzso3iGQieVYxr5n2KDczqXHsb/yPJP3/sVksSZbTz+OV
w5Gg5tZ2DXhnaNR4RsFPdaxk0Xj8p+Tarpk/5IyhqVRJUcoMeZGnWpLwfYb7
rrvv8dH9riHmt0X3ScVmxvURH9fp1RuUxUbj48N//Ds+om35Svv6+t28az2/
L3lbjKqSKdbKZ7j/38arvD/Cj/Pjx/NDhzDcdevTG6/Ynq6+6CmdjW/52bJ5
3eNqY3zz0yKXR/gZ+GxZ/ySG/b3v5I3G58L954jHxBvbfHI0juPz9GisGaye
nzwpl/bsyXt6PvjR/Q9dty0TXWZQ6nMbet774QN9P7k3zbu7k5EyrbubH1w8
vPnBNzc98tS3t954+S8T1X8rZlxz6ZNY1nffI/kLL8CEeV9fdbyZ8YTPeL9a
GxdSuvffF9Huv7//ni0Hb33ozq89Rl/Cj13f2Spitcqf1MuGJTL+6K57IUaQ
7MpLnsR8SC2znn02P3w4P3Uq+bJSvowm7OvLX38dSgR/goC50I16q1LcesPP
j97+gCoyoqjjOriDyum7l63e8dvvPkIc8J7v3QsnTr6k1C4ltRMn8n37cC9R
29R7v/cwNM/VoAT2x0RURus8GA3xxHkgB4OnpAJrNRoCvVqpXOKpgLZOkNWQ
Cf7B1YCBPGNxXbKbfCc1ME0uIMArN/8Uli9jX6TYq4l96lT+1lsigc6qwdOu
v+wJYkNxyKdl/scWHGz5huMAPzB0NKD6kye93ZOLSePo0Xz7dplAGi9vfBSc
YemmtdshOnJ6mYbSrMGrYW7MAj8QsZCip0esDtgLlMIXSQFEIZ4sUzI0OT6P
f+tnEyJ0pVZr/Pg+UKeOYHOuS/OdOyXnAfJ8Rb+Q6B9+KGQ9/3Bir3/R78SI
Qlsxy+sIFikoPPxwfuSIwJ6nFC4ghd5et5YUoFB6ITQg3LU7+7aXpUMsME7E
CWFIQK1S1PO9VhAkhVYElV7nNHpmxDfRwSutA9059B07xAUBeY6in+cjDTcq
0aHdZFKErtQySEN0aLDuLUq/XKno53qf37YtoCOUSuiTI/RJA6FD3zAfIFco
+iqigyBuDMj7lAh9coFOj0Ro131WgHMDcrmin1OJDk+gNZHIQCnpiNCVWobI
I+/Bqh59maKv9Johus7KkEM941Odn0wt+PXuFxCpjaWKuCLSNREhHl0PwXlW
xOvUwkeIjEQW9EwrLlHk5d4D6SNERrQw5OB+0yJkpZTB6Ugb0jhksEbvW2yR
NdxDxHvtgcT0CFkpZTQBzAxz1H20M2oWKfIyIh84UEKG5zGbgrUZlciwKXMm
4r3V50HWv7MVeanPIzCA9QvmILCG34mgC7jyn0H5lAjp0qGiihJ1oaIu8Tq2
1qMGwRAY74z4nWH8AuBQWrAedVxC1qITNIHqxnVgbWaErJQyuC5pQyUOefdu
x/MCRV7sNWGRYWxGFqw3wflwaigkCXfPtYgquaBl7772F66LYIIVQl2Wpjqi
z7GZ1z4Wao3IAm7S1I+0VFEOvgEbhWxGnyLtRZU+xQxOPQ2Ptgxn6UyEXGw9
7226T6PPaX42WUgixMfsxP9Y3tkmMyCNQXk1n1EY9yXa4CjSNRYxc7Y30a45
i8fWnV1eG+oRYp/yzlOaC728JrqCjgFQTdPSyqLxnCadOdoqrBCca2lH8tp1
k5x0re47pjS3idtaJCUpLYikjDQLgPmVyN7Pg/68DHMscrkHcbHMfDnf8a4U
MiRvZib8cLzu21eFqE0fJ5QyGtTTFfFK3qkF0DTdEqOJuF2+vlqrsQKi5INu
BapogPkZUepwfSadbXG9FckvOlAsQoAjzGNk5T9kUswIXXYFsraPPq6EI+YN
FNKFETIpsXWUnJb5OGNnTdz5xD12zHKcMvfD3IhDWmxhkae85h2eNtECMsvi
YStg+fQWg6XPjvgk39ieOYs5XNSMClxUAZtXIBcdEvmxAjVYDPXA7YxQ4izu
vLzYvTAayC8rFC0WI59dnlHsp1MWPoGbGZBHeM3i42MM3CyOUBcZDxR50ki7
BrPVaxcfuKLT25IqRIkxehZKY0uk2RJm0QdBHroUJFRMsT6xmbXFlxwSKmET
Ut1HK50IIi2NOFPZ696XuI+G/md7lJayt2FGjLEk8lPHEbIaOepUrLnkCFsx
XeWDYVkVWt2KLjeOHp1lURDr3d1en3DpGEV5rNEirG2o14nBqIk9u7uD1y53
+lWkmo9mQMDG5ZW9vZ409KIrLW1FyEgbIP17XzWrM6D53L2icmXIbfc8b1f2
PvGqJyp1lOctUY2vqIPLbZR8dWd//yczA2q68evPOA3MjdYxY9oKG9c58s9t
1ssvvet8bw65ffuYj8pPiVzwfPWvwXNnwE433rSHpoGHDgdZJqwkr9c87Xgl
3mzL65pnoPrhIdoZK8lrz4ue1xkBu+D1wd8kcS0fLjKyhAN56V0iq1dk7/3p
H45i7zvznPfW8+q+S5FqqIZOVGUTu5KAdvddb+DGc88eRmCsql6NXJfnnhW3
Wm1eO/qXf4pvXrrzo4/+hWBNVjk+zuHKQ4cwy5MurSTdxx97R3JFX19SSbvO
LS54xnLJCm8fm6YYasXMUuczTLbJwUeb8LTw4h8EkaR90x6Dl27t6SVP7vmx
7Cqr0XQ8QnqB4p/l8SzFVJtlYA0M4nqj8bFDRYc1CGoqD3qYQSkTWd38/VcT
g5vu+tUfJJHe9YZ7Ghz2JSucDej5YUehaJnnE8qbqnjTm647RN+bDcCn77wo
F/TmODK4qVe0O0UMForzp0MtLOTOnbz+8KPD4NIfoewC1z9FiHE5DpWyFtma
qOoHafDV1kirA6B67dbKHtnX1z/F4N55x2suehxuUQ8HwtWHRSx6Mp/RIuuJ
elaZGozHs4mwM17mvMDh+b1sq5Hz+m8+b/GcBUUnI/PyPiKusxyHvQKp37j+
RWcTPTmhH2RQBS34wQcnHC56hEFxNeoDLn0IOrS47qr422ii6gPSvOgC4q5A
9zBEHVl4PPmCGicZXGjFSeFwtesYBBc+QtxRkRaJ2mE0Dg25U6NgqaLDWxpZ
SqlnUJr3qDMNXvAoh3fkiMFr7tPEluRyTORRRJ1SpgblOFwwwyfmMS77Z2na
teVzfAQ5Da7TCWLOneqHuJInZHFHM9AzosVRzI1VLKYtOdJtV4qTm/LZOC8J
zy7iZ3/1aBx3V4u8ZSjpOJOBt3Tvt3TTN/f/VfrhW/a6c3SJ5CDpp6CqNdRT
dfmQNW+ioYv6IJvQ1/7sTuflkM482RyCrgy5K5SaR3rjIz8htUkm87CdaPMx
zf1bTC/Lq3sTR88/wSC9g7//m/MfQ8/E1MTIf+Kn2nEvFY8XRj40wcS8+JCO
6bviQ1eu2cXM1U66fvfbkQ/+LGiBzzmMZvKNPsv5jKGTwmquwp/pdcmYq3xW
oTHHs632Jp9oM7j0Cclk1GJ4xtDlbO7w/B6X68CfsznR2k1uoM3pc+EZQ9zj
chz2uaQP/bpewOCmT+04KA+9dhx0mS08q457co4lz1OnU0zVQVdMD6KmQ/yD
7Q4f/zxDi3G5T5GMzOcyHaa+PPTg7yyuy2++G1NUbROb9lFziLptm0OdWrYV
8vkZBpdxJvHLjiGct8xxHhbw+Hx/WhSfRJtQUMFVOC/UMN3jkc/ZEZ+zItzp
Jg7FVgbX5TzJ452RTmdFqDMjnXaaXI3swWxWij6x4KzIAzojVI4lCok6M8oO
RG0z3iaZhLvH0M3E+Z/jcPIa77P6PxlrcOER3DG5nXQ4U648rTLnxHONv0pU
EnV84a++z53nLUbdTnMeMM3rlNE/z+QU6YMMXvrK3vdcz7TAZ0yeIUyNuOzw
OWX/fnkHo8t4EPk53eCisuEiqpx5Vs83GirPQjVayS3ns28R7RH1DJNb6K+L
fK5ita48H9ZqrBsQdy7Duuv7K+K63CL+6s7tkOl4wlZ5Yq6oUBS0sKRcAeAM
Ywwu/Vg81p1hwsCM1onOVhMjPM7jrkP4Ido446my63CnznzHptu9fxC/8aD+
z/dl9Bw58+vB7miDS08Vaud6j0I7sXNn9bsgWq0QJCdOuPcCGJfIBOxF6V8l
nXwh55urw3keNYrlGE6IrRqUcvz4BcZGUhMNFbND0Tc33Jts8lffZBNf3b27
inI05vmsUIXSEOEg3GjwbZZStzvK0Gb9Q65z76QkSem9spqMkSmOHZMfhw5p
IeRVFER+DhwAJ5hg9rP6tpHbt0qeJ0X11tIe6aKIJvftYZzojl8mrDHxL5Fu
EF1PIfn74mHh2RlrmjLASIMcIvjCaqRBsa/IQ2ciVYvIY5ooiubt25/xW6pX
mCwn3bbBcVelRq+tWhW03Wh8PMKsI1dYreuE6tpIYs4e3cRtTOdKYwPhzqwz
3F1VtarEXatZx8wr3MXr1hqvFS65Sr1B3nv1+8fqdWHHYtYZr1pXtSrUKxCo
m3XBv9c5Ha6LuOPskYY75v2YDrkNfYhZ5yq+5IyrK1cBjrYprQI1pETpPuJV
yisCnrOr3yNe7+S5no592r8BrhBBQw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197418247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7488895],

Cell[TextData[{
 "Draw a bar chart using rectangles behind ",
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->278338907],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "10", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71189055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Prolog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"MapIndexed", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Rectangle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"First", "[", "#2", "]"}], "-", ".3"}], ",", "0"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"First", "[", "#2", "]"}], "+", ".3"}], ",", "#1"}], 
            "}"}]}], "]"}], "&"}], ",", "data"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->55194591],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], 
    LineBox[{{1., 0.058502045207886155`}, {2., 0.15464794266670268`}, {3., 
     0.08730336249615678}, {4., 0.3622283584415604}, {5., 
     0.7652144875581199}, {6., 0.21206414036223586`}, {7., 
     0.599931834533034}, {8., 0.931554769946978}, {9., 0.8186708063005934}, {
     10., 0.21362364005464274`}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 0.931554769946978}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Prolog->{
    RGBColor[1, 0.5, 0], {
     RectangleBox[{0.7, 0}, {1.3, 0.058502045207886155`}], 
     RectangleBox[{1.7, 0}, {2.3, 0.15464794266670268`}], 
     RectangleBox[{2.7, 0}, {3.3, 0.08730336249615678}], 
     RectangleBox[{3.7, 0}, {4.3, 0.3622283584415604}], 
     RectangleBox[{4.7, 0}, {5.3, 0.7652144875581199}], 
     RectangleBox[{5.7, 0}, {6.3, 0.21206414036223586`}], 
     RectangleBox[{6.7, 0}, {7.3, 0.599931834533034}], 
     RectangleBox[{7.7, 0}, {8.3, 0.931554769946978}], 
     RectangleBox[{8.7, 0}, {9.3, 0.8186708063005934}], 
     RectangleBox[{9.7, 0}, {10.3, 0.21362364005464274`}]}}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56235444]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16567],

Cell[TextData[{
 "The ordinary coordinate system is used for ",
 Cell[BoxData[
  ButtonBox["Prolog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prolog"]], "InlineFormula"],
 " in 2D graphics:"
}], "ExampleText",
 CellID->156588669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"Opacity", "[", ".5", "]"}], ",", 
       RowBox[{"Disk", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "10"}], "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Prolog", "\[Rule]", 
      RowBox[{"Disk", "[", 
       RowBox[{"p", ",", "2"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "7"}], ",", 
         RowBox[{"-", "7"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "7"}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423060883],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], Opacity[0.5], DiskBox[{0, 0}, 10]},
    Axes->True,
    Prolog->DiskBox[{-7, -7}, 2]], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], Opacity[0.5], DiskBox[{0, 0}, 10]},
    Axes->True,
    Prolog->DiskBox[{0, 0}, 2]], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], Opacity[0.5], DiskBox[{0, 0}, 10]},
    Axes->True,
    Prolog->DiskBox[{7, 7}, 2]]}], "}"}]], "Output",
 ImageSize->{341, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->266755899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34043803],

Cell[TextData[{
 "Scaled 0,1 coordinate system is used for ",
 Cell[BoxData[
  ButtonBox["Prolog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prolog"]], "InlineFormula"],
 " in 3D graphics:"
}], "ExampleText",
 CellID->152766262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", ".5", "]"}], ",", 
       RowBox[{"Sphere", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "10"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"Prolog", "\[Rule]", 
      RowBox[{"Disk", "[", 
       RowBox[{"p", ",", ".1"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{".2", ",", ".2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".8", ",", ".8"}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->419412716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Opacity[0.5], SphereBox[{0, 0, 0}, 10]},
    Prolog->DiskBox[{0.2, 0.2}, 0.1],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Opacity[0.5], SphereBox[{0, 0, 0}, 10]},
    Prolog->DiskBox[{0.5, 0.5}, 0.1],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Opacity[0.5], SphereBox[{0, 0, 0}, 10]},
    Prolog->DiskBox[{0.8, 0.8}, 0.1],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->699484876]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14677],

Cell["Define a simple graphic to use as background: ", "ExampleText",
 CellID->4340755],

Cell[BoxData[
 RowBox[{
  RowBox[{"bg", "=", 
   RowBox[{"Polygon", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"VertexColors", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "LightBlue", ",", "LightGreen", ",", "LightYellow", ",", "LightRed"}], 
       "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->461869528],

Cell["Use it in multiple graphics: ", "ExampleText",
 CellID->715663351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Prolog", "\[Rule]", "bg"}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->783773864],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->603561377]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Prolog", "\[Rule]", "bg"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10122518],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->722528481]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7799],

Cell[TextData[{
 "Objects in ",
 Cell[BoxData[
  ButtonBox["Prolog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prolog"]], "InlineFormula"],
 " is not counted in during ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " computation:"
}], "ExampleText",
 CellID->142687151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Prolog", "\[Rule]", 
    RowBox[{"Circle", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74032185],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Frame->True,
  Prolog->CircleBox[{0, 1}]]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->30436920]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4199],

Cell["Use a raster as a wallpaper:", "ExampleText",
 CellID->152295767],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"Raster", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"i", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "100"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "100"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "100"}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Pastel\>\""}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->383435643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"Csc", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Prolog", "\[Rule]", "r"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50141092],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->113074575]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31560],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Background",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Background"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Epilog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Epilog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaseStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AxesStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AxesStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DisplayFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DisplayFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8359]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->710366195],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->177354370]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Prolog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 14.9055286}", "context" -> "System`", 
    "keywords" -> {
     "prolog", "layered graphics", "bottom layer", "graphics layer", 
      "pre-rendering"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Prolog is an option for graphics functions which gives a list of \
graphics primitives to be rendered before the main part of the graphics is \
rendered. ", "synonyms" -> {}, "title" -> "Prolog", "type" -> "Symbol", "uri" -> 
    "ref/Prolog"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4548, 145, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->95497529]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 127776, 2520}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1841, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2464, 67, 44, 1, 70, "ObjectName",
 CellID->26073],
Cell[2511, 70, 526, 15, 70, "Usage",
 CellID->22341]
}, Open  ]],
Cell[CellGroupData[{
Cell[3074, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3552, 107, 256, 8, 70, "Notes",
 CellID->587],
Cell[3811, 117, 441, 13, 70, "Notes",
 CellID->24461],
Cell[4255, 132, 256, 8, 70, "Notes",
 CellID->31612853]
}, Closed]],
Cell[CellGroupData[{
Cell[4548, 145, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->95497529],
Cell[CellGroupData[{
Cell[4932, 159, 148, 5, 70, "ExampleSection",
 CellID->332488882],
Cell[5083, 166, 94, 1, 70, "ExampleText",
 CellID->77499382],
Cell[CellGroupData[{
Cell[5202, 171, 563, 17, 49, "Input",
 CellID->225818802],
Cell[5768, 190, 5125, 88, 162, "Output",
 Evaluatable->False,
 CellID->197418247]
}, Open  ]],
Cell[10908, 281, 123, 3, 70, "ExampleDelimiter",
 CellID->7488895],
Cell[11034, 286, 232, 8, 70, "ExampleText",
 CellID->278338907],
Cell[11269, 296, 202, 7, 70, "Input",
 CellID->71189055],
Cell[CellGroupData[{
Cell[11496, 307, 763, 23, 70, "Input",
 CellID->55194591],
Cell[12262, 332, 1387, 32, 137, "Output",
 CellID->56235444]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13698, 370, 216, 7, 70, "ExampleSection",
 CellID->16567],
Cell[13917, 379, 237, 8, 70, "ExampleText",
 CellID->156588669],
Cell[CellGroupData[{
Cell[14179, 391, 899, 29, 70, "Input",
 CellID->423060883],
Cell[15081, 422, 644, 20, 122, "Output",
 CellID->266755899]
}, Open  ]],
Cell[15740, 445, 124, 3, 70, "ExampleDelimiter",
 CellID->34043803],
Cell[15867, 450, 235, 8, 70, "ExampleText",
 CellID->152766262],
Cell[CellGroupData[{
Cell[16127, 462, 818, 28, 70, "Input",
 CellID->419412716],
Cell[16948, 492, 38717, 647, 131, "Output",
 CellID->699484876]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55714, 1145, 223, 7, 70, "ExampleSection",
 CellID->14677],
Cell[55940, 1154, 87, 1, 70, "ExampleText",
 CellID->4340755],
Cell[56030, 1157, 820, 25, 70, "Input",
 CellID->461869528],
Cell[56853, 1184, 72, 1, 70, "ExampleText",
 CellID->715663351],
Cell[CellGroupData[{
Cell[56950, 1189, 344, 10, 70, "Input",
 CellID->783773864],
Cell[57297, 1201, 13840, 231, 70, "Output",
 Evaluatable->False,
 CellID->603561377]
}, Open  ]],
Cell[CellGroupData[{
Cell[71174, 1437, 400, 12, 70, "Input",
 CellID->10122518],
Cell[71577, 1451, 35759, 590, 70, "Output",
 Evaluatable->False,
 CellID->722528481]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[107385, 2047, 232, 7, 70, "ExampleSection",
 CellID->7799],
Cell[107620, 2056, 354, 13, 70, "ExampleText",
 CellID->142687151],
Cell[CellGroupData[{
Cell[107999, 2073, 377, 12, 70, "Input",
 CellID->74032185],
Cell[108379, 2087, 310, 10, 162, "Output",
 CellID->30436920]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[108738, 2103, 223, 7, 70, "ExampleSection",
 CellID->4199],
Cell[108964, 2112, 71, 1, 70, "ExampleText",
 CellID->152295767],
Cell[109038, 2115, 741, 24, 70, "Input",
 CellID->383435643],
Cell[CellGroupData[{
Cell[109804, 2143, 437, 13, 70, "Input",
 CellID->50141092],
Cell[110244, 2158, 13717, 229, 70, "Output",
 Evaluatable->False,
 CellID->113074575]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[124022, 2394, 311, 9, 70, "SeeAlsoSection",
 CellID->31560],
Cell[124336, 2405, 1699, 62, 70, "SeeAlso",
 CellID->8359]
}, Open  ]],
Cell[CellGroupData[{
Cell[126072, 2472, 319, 9, 70, "MoreAboutSection",
 CellID->710366195],
Cell[126394, 2483, 175, 3, 70, "MoreAbout",
 CellID->177354370]
}, Open  ]],
Cell[126584, 2489, 27, 0, 70, "History"],
Cell[126614, 2491, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

