(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21345,        828]
NotebookOptionsPosition[     15446,        623]
NotebookOutlinePosition[     16782,        661]
CellTagsIndexPosition[     16697,        656]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Attributes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Locked" :> Documentation`HelpLookup["paclet:ref/Locked"], 
          "ReadProtected" :> 
          Documentation`HelpLookup["paclet:ref/ReadProtected"], "Editable" :> 
          Documentation`HelpLookup["paclet:ref/Editable"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Locked\"\>", 
       2->"\<\"ReadProtected\"\>", 3->"\<\"Editable\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Defining Variables and Functions" :> 
          Documentation`HelpLookup["paclet:guide/VariablesAndFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Defining Variables and Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Protected", "ObjectName",
 CellID->2624],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Protected",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which prevents any values associated \
with a symbol from being modified. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23035]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Many built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions have the attribute ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30498]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68909100],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->535881531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "String", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264065325],

Cell[BoxData[
 RowBox[{"{", "Protected", "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103141905]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->526687803],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->458281062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->191526465],

Cell[BoxData[
 RowBox[{"{", "Protected", "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66343763]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->299501064],

Cell["Unprotect a system symbol to make a definition for it:", "ExampleText",
 CellID->218889083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"protected", "=", 
  RowBox[{"Unprotect", "[", "Sqrt", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->739941894],

Cell[BoxData[
 RowBox[{"{", "\<\"Sqrt\"\>", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185922997]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", 
   RowBox[{"x_", "^", "2"}], "]"}], ":=", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->267327978],

Cell["Restore protection:", "ExampleText",
 CellID->978005475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Protect", "[", 
  RowBox[{"Evaluate", "[", "protected", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6538135],

Cell[BoxData[
 RowBox[{"{", "\<\"Sqrt\"\>", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->893659]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->631413864],

Cell[TextData[{
 "Protecting a symbol is equivalent to setting the ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->111255568],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"g", ",", "Protected"}], "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->634542146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"{", 
   RowBox[{"f", ",", "g"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->491598477],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "Protected", "}"}], ",", 
   RowBox[{"{", "Protected", "}"}]}], "}"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->207008463]
}, Open  ]],

Cell[TextData[{
 "Unprotecting a symbol is equivalent to clearing the ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->245737481],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "f", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ClearAttributes", "[", 
   RowBox[{"g", ",", "Protected"}], "]"}], ";"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->105125778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"{", 
   RowBox[{"f", ",", "g"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->78016570],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->182684100]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99419516],

Cell["No more definitions can be made for a protected symbol:", "ExampleText",
 CellID->322015275],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->230977323],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90568818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->265663274],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDelayed", "::", "\<\"write\"\>"}], ":", 
  " ", "\<\"Tag \\!\\(f\\) in \\!\\(f[x_]\\) is Protected.\"\>"}]], "Message",\
 "MSG",
 CellID->289465799],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17098278]
}, Open  ]],

Cell["Neither can definitions be cleared:", "ExampleText",
 CellID->650898680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27818971],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "::", "\<\"wrsym\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(f\\) is Protected.\"\>"}]], "Message", "MSG",
 CellID->348857921]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427394102],

Cell["\<\
To modify definitions of a protect symbol, unprotect it first:\
\>", "ExampleText",
 CellID->2436852],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->330197432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->788416547],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDelayed", "::", "\<\"write\"\>"}], ":", 
  " ", "\<\"Tag \\!\\(f\\) in \\!\\(f[x_]\\) is Protected.\"\>"}]], "Message",\
 "MSG",
 CellID->128766945],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->86016795]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "f", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->603177675],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->123212235],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->672344848],

Cell["\<\
A symbol that is locked and protected can no longer be changed:\
\>", "ExampleText",
 CellID->737482312],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"Locked", ",", "Protected"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->273142003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->181152790],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDelayed", "::", "\<\"write\"\>"}], ":", 
  " ", "\<\"Tag \\!\\(f\\) in \\!\\(f[x_]\\) is Protected.\"\>"}]], "Message",\
 "MSG",
 CellID->241150266],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->399572924]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "f", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->200658330],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "::", "\<\"locked\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(f\\) is locked.\"\>"}]], "Message", "MSG",
 CellID->16899935]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10813],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Locked",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locked"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReadProtected",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadProtected"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Editable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Editable"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23208]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9172],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->21947]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->32113446],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->76173471],

Cell[TextData[ButtonBox["Defining Variables and Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariablesAndFunctions"]], "MoreAbout",
 CellID->216332138]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Protected - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 17.0149576}", "context" -> "System`", 
    "keywords" -> {
     "immutable", "protected attribute", "unchangeable", "unmodifiable", 
      "write protected", "attribute"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Protected is an attribute which prevents any values associated with a \
symbol from being modified. ", "synonyms" -> {}, "title" -> "Protected", 
    "type" -> "Symbol", "uri" -> "ref/Protected"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4040, 133, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->68909100]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16555, 649}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2059, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2682, 78, 46, 1, 70, "ObjectName",
 CellID->2624],
Cell[2731, 81, 475, 14, 70, "Usage",
 CellID->23035]
}, Open  ]],
Cell[CellGroupData[{
Cell[3243, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3721, 117, 282, 11, 70, "Notes",
 CellID->30498]
}, Closed]],
Cell[CellGroupData[{
Cell[4040, 133, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68909100],
Cell[CellGroupData[{
Cell[4424, 147, 148, 5, 70, "ExampleSection",
 CellID->535881531],
Cell[CellGroupData[{
Cell[4597, 156, 111, 3, 28, "Input",
 CellID->264065325],
Cell[4711, 161, 188, 6, 36, "Output",
 CellID->103141905]
}, Open  ]],
Cell[4914, 170, 125, 3, 70, "ExampleDelimiter",
 CellID->526687803],
Cell[5042, 175, 229, 8, 70, "Input",
 CellID->458281062],
Cell[CellGroupData[{
Cell[5296, 187, 106, 3, 28, "Input",
 CellID->191526465],
Cell[5405, 192, 187, 6, 36, "Output",
 CellID->66343763]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5641, 204, 227, 7, 70, "ExampleSection",
 CellID->299501064],
Cell[5871, 213, 97, 1, 70, "ExampleText",
 CellID->218889083],
Cell[CellGroupData[{
Cell[5993, 218, 139, 4, 70, "Input",
 CellID->739941894],
Cell[6135, 224, 191, 6, 36, "Output",
 CellID->185922997]
}, Open  ]],
Cell[6341, 233, 149, 5, 70, "Input",
 CellID->267327978],
Cell[6493, 240, 62, 1, 70, "ExampleText",
 CellID->978005475],
Cell[CellGroupData[{
Cell[6580, 245, 144, 4, 70, "Input",
 CellID->6538135],
Cell[6727, 251, 188, 6, 36, "Output",
 CellID->893659]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[6964, 263, 237, 7, 70, "ExampleSection",
 CellID->631413864],
Cell[7204, 272, 244, 8, 70, "ExampleText",
 CellID->111255568],
Cell[7451, 282, 223, 7, 70, "Input",
 CellID->634542146],
Cell[CellGroupData[{
Cell[7699, 293, 153, 5, 70, "Input",
 CellID->491598477],
Cell[7855, 300, 268, 9, 36, "Output",
 CellID->207008463]
}, Open  ]],
Cell[8138, 312, 247, 8, 70, "ExampleText",
 CellID->245737481],
Cell[8388, 322, 227, 7, 70, "Input",
 CellID->105125778],
Cell[CellGroupData[{
Cell[8640, 333, 152, 5, 70, "Input",
 CellID->78016570],
Cell[8795, 340, 241, 9, 36, "Output",
 CellID->182684100]
}, Open  ]],
Cell[9051, 352, 124, 3, 70, "ExampleDelimiter",
 CellID->99419516],
Cell[9178, 357, 98, 1, 70, "ExampleText",
 CellID->322015275],
Cell[9279, 360, 145, 5, 70, "Input",
 CellID->230977323],
Cell[9427, 367, 120, 4, 70, "Input",
 CellID->90568818],
Cell[CellGroupData[{
Cell[9572, 375, 145, 5, 70, "Input",
 CellID->265663274],
Cell[9720, 382, 186, 5, 70, "Message",
 CellID->289465799],
Cell[9909, 389, 163, 5, 36, "Output",
 CellID->17098278]
}, Open  ]],
Cell[10087, 397, 78, 1, 70, "ExampleText",
 CellID->650898680],
Cell[CellGroupData[{
Cell[10190, 402, 100, 3, 70, "Input",
 CellID->27818971],
Cell[10293, 407, 164, 4, 70, "Message",
 CellID->348857921]
}, Open  ]],
Cell[10472, 414, 125, 3, 70, "ExampleDelimiter",
 CellID->427394102],
Cell[10600, 419, 111, 3, 70, "ExampleText",
 CellID->2436852],
Cell[10714, 424, 229, 8, 70, "Input",
 CellID->330197432],
Cell[CellGroupData[{
Cell[10968, 436, 145, 5, 70, "Input",
 CellID->788416547],
Cell[11116, 443, 186, 5, 70, "Message",
 CellID->128766945],
Cell[11305, 450, 163, 5, 36, "Output",
 CellID->86016795]
}, Open  ]],
Cell[11483, 458, 123, 4, 70, "Input",
 CellID->603177675],
Cell[11609, 464, 145, 5, 70, "Input",
 CellID->123212235],
Cell[11757, 471, 125, 3, 70, "ExampleDelimiter",
 CellID->672344848],
Cell[11885, 476, 114, 3, 70, "ExampleText",
 CellID->737482312],
Cell[12002, 481, 302, 10, 70, "Input",
 CellID->273142003],
Cell[CellGroupData[{
Cell[12329, 495, 145, 5, 70, "Input",
 CellID->181152790],
Cell[12477, 502, 186, 5, 70, "Message",
 CellID->241150266],
Cell[12666, 509, 164, 5, 36, "Output",
 CellID->399572924]
}, Open  ]],
Cell[CellGroupData[{
Cell[12867, 519, 123, 4, 70, "Input",
 CellID->200658330],
Cell[12993, 525, 163, 4, 70, "Message",
 CellID->16899935]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13217, 536, 311, 9, 70, "SeeAlsoSection",
 CellID->10813],
Cell[13531, 547, 702, 26, 70, "SeeAlso",
 CellID->23208]
}, Open  ]],
Cell[CellGroupData[{
Cell[14270, 578, 313, 9, 70, "TutorialsSection",
 CellID->9172],
Cell[14586, 589, 131, 3, 70, "Tutorials",
 CellID->21947]
}, Open  ]],
Cell[CellGroupData[{
Cell[14754, 597, 318, 9, 70, "MoreAboutSection",
 CellID->32113446],
Cell[15075, 608, 131, 3, 70, "MoreAbout",
 CellID->76173471],
Cell[15209, 613, 165, 3, 70, "MoreAbout",
 CellID->216332138]
}, Open  ]],
Cell[15389, 619, 27, 0, 70, "History"],
Cell[15419, 621, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

