(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52868,       1804]
NotebookOptionsPosition[     44022,       1491]
NotebookOutlinePosition[     45353,       1529]
CellTagsIndexPosition[     45267,       1524]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Matrix Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedMatrixOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Advanced Matrix Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inverse" :> Documentation`HelpLookup["paclet:ref/Inverse"], 
          "LeastSquares" :> 
          Documentation`HelpLookup["paclet:ref/LeastSquares"], "Fit" :> 
          Documentation`HelpLookup["paclet:ref/Fit"], 
          "SingularValueDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SingularValueDecomposition"], 
          "SingularValueList" :> 
          Documentation`HelpLookup["paclet:ref/SingularValueList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Inverse\"\>", 
       2->"\<\"LeastSquares\"\>", 3->"\<\"Fit\"\>", 
       4->"\<\"SingularValueDecomposition\"\>", 
       5->"\<\"SingularValueList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MatrixBasedMinimization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Linear Systems\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>", 
       3->"\<\"Matrix-Based Minimization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PseudoInverse", "ObjectName",
 CellID->8054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PseudoInverse",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PseudoInverse"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the pseudoinverse of a rectangular matrix. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3127]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PseudoInverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PseudoInverse"]], "InlineFormula"],
 " works on both symbolic and numerical matrices. "
}], "Notes",
 CellID->26806],

Cell[TextData[{
 "For a square matrix, ",
 Cell[BoxData[
  ButtonBox["PseudoInverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PseudoInverse"]], "InlineFormula"],
 " gives the Moore\[Dash]Penrose inverse."
}], "Notes",
 CellID->7334],

Cell[TextData[{
 "For numerical matrices, ",
 Cell[BoxData[
  ButtonBox["PseudoInverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PseudoInverse"]], "InlineFormula"],
 " is based on ",
 Cell[BoxData[
  ButtonBox["SingularValueDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueDecomposition"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20347],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PseudoInverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PseudoInverse"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{
     ButtonBox["Tolerance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tolerance"], "->", 
     StyleBox["t", "TI"]}]}], "]"}]], "InlineFormula"],
 " specifies that singular values smaller than ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " times the maximum singular value should be dropped. "
}], "Notes",
 CellID->2619],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tolerance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tolerance"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", singular values are dropped when they are less than 100 times ",
 Cell[BoxData[
  SuperscriptBox["10", 
   RowBox[{"-", 
    StyleBox["p", "TI"]}]]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25265],

Cell[TextData[{
 "For non\[Hyphen]singular square matrices ",
 Cell[BoxData[
  StyleBox["M", "TB"]], "InlineFormula"],
 ", the pseudoinverse ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["M", "TB"], 
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}]]], "InlineFormula"],
 " is equivalent to the standard inverse. "
}], "Notes",
 CellID->30683]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->421505251],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->313702541],

Cell["A matrix has a pseudoinverse even if it is singular:", "ExampleText",
 CellID->11919623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PseudoInverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204568946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["23", "36"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "6"]}], ",", 
     FractionBox["11", "36"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "18"]}], ",", "0", ",", 
     FractionBox["1", "18"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["19", "36"], ",", 
     FractionBox["1", "6"], ",", 
     RowBox[{"-", 
      FractionBox["7", "36"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{319, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49994911]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24323],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 4\[Times]3 matrix:"
}], "ExampleText",
 CellID->468105420],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "11", ",", "12"}], "}"}]}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->357944799],

Cell["Compute using exact arithmetic:", "ExampleText",
 CellID->471096364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PseudoInverse", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->234734638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["29", "60"]}], ",", 
     RowBox[{"-", 
      FractionBox["11", "45"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "180"]}], ",", 
     FractionBox["7", "30"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "30"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "90"]}], ",", 
     FractionBox["1", "90"], ",", 
     FractionBox["1", "30"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["5", "12"], ",", 
     FractionBox["2", "9"], ",", 
     FractionBox["1", "36"], ",", 
     RowBox[{"-", 
      FractionBox["1", "6"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{440, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->664756751]
}, Open  ]],

Cell["Compute using machine arithmetic:", "ExampleText",
 CellID->532288082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PseudoInverse", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->383493770],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.483333333333333`"}], ",", 
     RowBox[{"-", "0.24444444444444394`"}], ",", 
     RowBox[{"-", "0.0055555555555553155`"}], ",", "0.23333333333333287`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.033333333333333576`"}], ",", 
     RowBox[{"-", "0.01111111111111121`"}], ",", "0.011111111111111115`", ",",
      "0.03333333333333341`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.41666666666666663`", ",", "0.2222222222222219`", ",", 
     "0.02777777777777758`", ",", 
     RowBox[{"-", "0.1666666666666664`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{333, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->198171715]
}, Open  ]],

Cell["\<\
Compute using 24\[Hyphen]digit precision arithmetic:\
\>", "ExampleText",
 CellID->210313213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PseudoInverse", "[", 
  RowBox[{"N", "[", 
   RowBox[{"m", ",", " ", "24"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16322019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
     "-", "0.48333333333333333333333333333333333333`23.517891041431813"}], 
     ",", 
     RowBox[{
     "-", "0.24444444444444444444444444444444444442`23.499313122575575"}], 
     ",", 
     RowBox[{
     "-", "0.00555555555555555555555555555555555555`22.832501112203765"}], 
     ",", "0.23333333333333333333333333333333333332`23.522878745280337"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
     "-", "0.03333333333333333333333333333333333335`23.447069649249038"}], 
     ",", 
     RowBox[{
     "-", "0.01111111111111111111111111111111111112`23.14322867625123"}], ",",
      "0.01111111111111111111111111111111111111`23.43593328313108", ",", 
     "0.03333333333333333333333333333333333334`23.522878745280337"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "0.41666666666666666666666666666666666667`23.52287874528034", ",", 
     "0.22222222222222222222222222222222222221`23.522878745280337", ",", 
     "0.02777777777777777777777777777777777777`23.522878745280337", ",", 
     RowBox[{
     "-", "0.16666666666666666666666666666666666666`23.433739871994423"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{423, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->175625917]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13226464],

Cell["\<\
Compute the pseudoinverse for a random complex 3\[Times]2 matrix:\
\>", "ExampleText",
 CellID->471316172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PseudoInverse", "[", 
  RowBox[{"RandomComplex", "[", 
   RowBox[{
    RowBox[{"1", " ", "+", "I"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->805696311],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.5317604560052093`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.0012207428728307768`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.711775541594129`"}], "+", 
      RowBox[{"0.5196156518804337`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.3318118847235074`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.9660926721654507`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.3584902731173971`"}], "-", 
      RowBox[{"0.3234440552218461`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.9739125940076948`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.5491963059741721`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.021186335844206143`"}], "+", 
      RowBox[{"0.7189572557219658`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{477, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73922327]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21720],

Cell["Compute symbolic result:", "ExampleText",
 CellID->135627519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "\[Element]", 
    "Reals"}], ",", 
   RowBox[{"Refine", "[", 
    RowBox[{"PseudoInverse", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->231721198],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXEtvFEcQnt2xvTYvP7CNLRLZkRLzWIzE2iS5JafkEhLEJYLkYiEiOKBE
wDXyDyB3828sRSRXyC/qTL/Ws9/WTFfPYz2z25Y8M1VTXV1V/ZjqzwUPjt48
f/by6M2Lp0e73786+uP5i6evd7/7/VXCijtR1BlEUXSyFSXPInlSv/LnIPnV
j/i0klznE7FLyT1O7huGXjD32Nx75n0v9T6KrX4xlL9g7tdq1BtFq/I6P5RS
PC0zzl0nufM1cXtgPy1FW7o9lV5tCceIpfTK2ZI1C7w8SLXtZUrNZ+rwHp/W
+OAzGluEB3MlbcaZZHWWifj523kW1W5CdaFtnGmLlJRv16DFXKblpH6Wn132
OrZWURrsu/UZ8tXakr6bNTSnW0TqJwYdds6gD1eJCMR2xxjR2DMaFkzPugst
sGxaUb12h0EZspOfzdZZvET0OzJKZyOBIw07cpq+Qs6EZZDacNCLpBaUOk9b
FlnRWzHRx/WCltrRWzbym+Z+DeR6ho+jvDahfvC7S3ud/mbIWF0C+pHj/fWS
7TEKtJXbjlg9cry/XrI9L5by8QZL8h1w3xZq9ZejVUfYeR3Fp6enemOK/lS7
0fHxsZGyJ5AFhxxql3Ry1FK9dErYVywW/Fh/Cdw9oN+ztNwH7k2gfwMae/2s
kl6eAf010LuV9PJY6J0H90179rQzZlWMnllxB9phWXMI3NtA/ywvzrx0iZSi
c51lD1m0uZhPNmIXgb9gIkjxpfwPlJfQm5Treng0clqC70hd/tP24S6bc35z
Sj1wREpqyT4LYZ7Bi8WngsqHeb7bteTKi3K8LbEmqBPF5UxpPA9gHPqk37GJ
OOmRt8c/Gm3oo4wjnYGviuwMHHcq2oPKZy3E8Qnw8ES4Q2q+mxnt2Dgp7yvi
7AQTE+NIRQXtsRnxrqBnzD5pCa68TUckUP5vpRW/US6tOKJLxub3lWj7QGpJ
fx9lKDeBxnWitWBmgF9ZtAWj/lFpkY/ZaDb1FBDuarkB4UZuQLib5ENAuOtD
uGW+bjOhWUF/ZwnpVjjv2OxTdrcKN24f0r2RHXmPM8SsINvrZLRiMV1I9hrp
ZRozkbGYNHJN7xHo+6SRapyNF0gr5WXbRPsiKYEoLNLqBDV2jkLE963pQ1uB
Jx1ta3lk+grLlhOWn7SUvOyRbw6ARnT5X7LVAGhEYH8FGs+M+4W0/gI0osd3
Cmn9SdBZsC9a3Cd7vwc0osNlkbBq0WHah8+Nxzj/fVFhnq+Tx4S11zYn/oJt
ZVXYWh42WDXmq30dlPCRi/w2EePl+V0U+ZXjGBPrpEqMd5ARmbEYkJ4Wm59l
cN7BmM/ULmJzbHl3Ib/4FeChvPgVwK+tL+qrcdl7pk+Mqy8++4/S9k0tWnxR
Xq3l2xwtlC0YdZ03yMeA8o5y24OHBpS32QhpQHkDyhvqmGcP3bW2qKwj1C9P
wGIyWwz1ysx6ZR2taa9P1l42rR5ZW9W0+mOMpV6c8hFrYu3fAtSuXFPdse1D
W1FXvXGPZcsiy8+lzHjpN/8BF1HdW2QrxFMRtUVUF5FUpLXWr4CLveB5nqe1
L6pBbRHb4PWuUNzGoLaPgUaMmZ4jPB8mj8aOoGhzaWnZ9DJI2/M4fqHL+FwH
7srHvqtC7SSOfZYl4pygvpCTwmJdtc4M3NnpvUaT+mI8+6N2DDqH9EFni/lU
bGS1b3eBi37xUNqHJJeal9Qc4FQJ09bvG40YJxea+1DQfyvpjo1eGk/uDpek
bRATc1Vb9oHSnJNjXE31rHtA27Tej0RsUNKe2Mn8KEUfkhp98WJaiy9erLVg
xuGLF6vaZEUEvHiU2x5kNeDFzcZaA14c8OK8qNpqYJvxherg6fRVV/5hNkD9
++h2obTtw5U3+CORk2XPKs68zoredFYTu7xuRnWxy8pmVhu7rJaX0epjVwte
NbLrpJlfnZzeidCvaiuVfe08KRQjXit52WNJ4v+TgZj4fZaWPtC+GPkhqxdE
63wxc14vnwi6rrdqDJ1njfzfCNqDqR9U6NP5YOzD9V4YY9cxwFMDz+fpwNh1
BG4LXk3uRPH1gnEogrKrtZFb41sNxp5VJ1/PiI7lBZiDpegdUvd5Yeu3jEZc
xxxsPSZGL2Dr04WtR53/AYxnTJg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{306, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387225313]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3735],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Tolerance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->27347],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 16\[Times]16 Hilbert matrix:"
}], "ExampleText",
 CellID->600859646],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"HilbertMatrix", "[", "16", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412871025],

Cell["\<\
Some singular values are below the default tolerance for machine precision:\
\>", "ExampleText",
 CellID->17387579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"SingularValueList", "[", 
   RowBox[{"N", "[", "m", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->441002359],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->201817690]
}, Open  ]],

Cell["Compute the pseudoinverse with the default tolerance:", "ExampleText",
 CellID->69027838],

Cell[BoxData[
 RowBox[{
  RowBox[{"minv", " ", "=", " ", 
   RowBox[{"PseudoInverse", "[", 
    RowBox[{"N", "[", "m", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->104890562],

Cell["\<\
It is not a true inverse since some singular values were considered to be \
effectively zero:\
\>", "ExampleText",
 CellID->326868747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"minv", ".", "m"}], " ", "-", " ", 
    RowBox[{"IdentityMatrix", "[", "16", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->131399327],

Cell[BoxData["0.620276927947998`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->682718382]
}, Open  ]],

Cell["Compute the pseudoinverse with no tolerance:", "ExampleText",
 CellID->193403974],

Cell[BoxData[
 RowBox[{
  RowBox[{"minv0", " ", "=", " ", 
   RowBox[{"PseudoInverse", "[", 
    RowBox[{
     RowBox[{"N", "[", "m", "]"}], ",", " ", 
     RowBox[{"Tolerance", "\[Rule]", "0"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->481614583],

Cell["\<\
Even though no singular values were considered zero, it is worse due to \
numerical error:\
\>", "ExampleText",
 CellID->120079724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"minv0", ".", "m"}], " ", "-", " ", 
    RowBox[{"IdentityMatrix", "[", "16", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->52736173],

Cell[BoxData["4.25`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->339484162]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26660],

Cell["Here is some data:", "ExampleText",
 CellID->357325855],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"3", "+", 
    RowBox[{"14", "t"}], "+", 
    RowBox[{"1.5", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "100"}], "]"}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"t", ",", "r"}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", "data", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->293510528],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWc1vVFUUf7w3M29mcCwo1FYxYWEMxsQQY9wY6ActFYRKsUJQJ3QgRvAD
EFrqQuJGQoOy00g7RvkoNQZ3GEhckZAQXRC3rv1Hnvfr3XPf7565zBRdOEmn
79x3zu983HPPOe/N3tbssfc/ac0eP9raPHG6derY8aNnNu88eVosJWuiKPpV
/H0wEInrTFypv0aWZbG4uCH+R5GkopIkl/8c2rZ46et714vrB99eEevjO76H
9T9+//vkiVt3bv/lrCcSX32i5VWtgl2SRxsVrVO0NTIqGe7EwYokLf42uvfK
Vo/h6Gck5WXcxT25FDP3Es9mETBjsw2g5iqRZBSVwfoNHkcFtD3pcZS8FR/F
5+kHXN+2uOiT3mwTGdqHuqJtMjA43XlQ6tLuf923mpsfc7O3hV87Rtpmx8rg
LXofe8gp6H6Ct9fZ842r8lpaJjPvqV58LZyF0eF2FAs/okRvnRLMmIx16NX4
m1vK+5l0GYFe9jS2p/Ta1Qdv7L5yceGusRPy1KF9z3rZBd8D92TLy//kTJp1
patis9JePGasq5j/eXXDPdvgrOfecHI5nQSssLliLxYD3Db+9mJtVjxhX7HS
OlKUlzxXHbBqsOdaSnKt5PvhYdgTIZaohhNGXt+Io5LvmjXP7rQ1pZQx0fgf
01350yG2FMsG0CqSsmaJoO2a+HFo2+W88zt5ZmO6HtCffQi9qSsbG5BDuo5q
7cPbF03+aZus5da4zwKYlL0V0KHQyhrt22/um2hgBQthQwyTPbuvCOyRoSVT
F0GXQ2PHm7daqNvsm7ymumSORp5g/ygDPc/a3A82x0BjnpSB5lH5WfP5jK+V
fDSfgWhUi7n3kH0eVPuopV+X+atioPYx1av7p5bd4tdhTwednBOzSSEfKLaf
F3bqaYgR1r7HwbOPWM1bgQvngZAUThGkOyS1cOGukDp14lb0Kcu1hc1X0oV+
zQRQIE/r2sIvzv0mVg9M3xDfh5s3LRTGm5BlvF8AH1Pn3MkhS09aJI2nmbfz
ZflV1edNnN5ROZhePjC9ooU+ZGVe5E44dSwx9klbPg7IopU0RYWkyJezLNcY
2NUsxG8cNDdZjJHi6bUqee7tRW4L3geWTLLSr8mvmi9NfvaBzRrHDBLmExv/
sCMq9IoPir1AyaWWFhTp1/r8ydV7QuV0Y21Ya20RlKuP/Nvfgz5JTihcq8fF
KvjRC65Lj0OssM6wfdWhdz6SXqgeJY2robFOYl98NM3QCUsaV0NjDLB3as1m
hFefpEOG7s1M3Zjad12X5LfYczIJvhGXRH0T9PMYU7AzNaDHAlKkuQZ0SAqn
DcwSus+jTMsv09t3TfzQ4X0BPoG8GsDSdo/Z/o6drQ50AAv7UOqeQbKmAryE
KHfuXe50edPMEGvFO4rOp862kcUJpgoaXglg5TNn2zvlKi4pW730TMEj0rRu
2RterCjaPFIT9mR9B2TMsS0BNDuFmJlBV2F5Sz0bp3xtxkmcNMi9VNNFoU40
vKjBiSjEQb8XE9NQ9Bxr+eHM1IrWzC/N934WQvgcorNXDB9mHuJxzima5g2e
6zxEc1OAiyLCc50BrD6wm6RkHGcB86UAJmHwXPzzyQLYo2Z/U5zzTy6CFXsB
Tp2WxR7ivdtmUei8dY8iyTmwfx3Ewu+V2JVrq7J6DnZmwMt47MGOHurBGd8L
58AL/DVCeyXuH5m5qfMfu4ijzftFAt+Qq8xl5laTC07vzn8FwfcvGsGfLgfZ
nDsPthZz/iL4OsBifAlcWI+wAmLtr3ZGbcC7nvmzdw4d/ImpgVXQGcL039W4
tZCeQqsQGx7zgvyqWy4r7pqHs0CFRVLRNnV5dHhJu9vhtxfM6ACieZs0uedq
YVLBCRVmZ5sDl+AuvoFpsJp7+Q3wO/CtHuCCmYjnYrpwWvCpDVgpi7UEnvJc
2qdozT9ynzCs\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80414259]
}, Open  ]],

Cell["Construct a design matrix for fitting to a line:", "ExampleText",
 CellID->188782123],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "s", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "s"}], "}"}]}], "]"}], ",", "t"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->593728085],

Cell["\<\
Get the coefficients for a linear least\[Hyphen]squares fit:\
\>", "ExampleText",
 CellID->507596383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PseudoInverse", "[", "m", "]"}], ".", "r"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->175401898],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.0992713592847587`", ",", "14.025032273368664`"}], 
  "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->225625141]
}, Open  ]],

Cell[TextData[{
 "This is the same as the result given by ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->193107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "s"}], "}"}], ",", "s"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->698365324],

Cell[BoxData[
 RowBox[{"3.099271359284761`", "\[InvisibleSpace]", "+", 
  RowBox[{"14.025032273368659`", " ", "s"}]}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->21261064]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{"%", ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", "data", "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->207597993],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->233637060]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28368],

Cell["\<\
For a nonsingular matrix, the pseudoinverse is the same as the inverse:\
\>", "ExampleText",
 CellID->316235439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PseudoInverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "8", ",", "27"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->410020150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", 
      FractionBox["5", "2"]}], ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["3", "2"]}], ",", "2", ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["1", "6"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{273, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34490886]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "8", ",", "27"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->451461945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", 
      FractionBox["5", "2"]}], ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["3", "2"]}], ",", "2", ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["1", "6"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{273, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121806892]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55851416],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], " ", "=", " ", 
   RowBox[{"PseudoInverse", "[", 
    StyleBox["m", "TI"], "]"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], " ", "=", " ", 
   RowBox[{
    StyleBox["p", "TI"], ".", 
    StyleBox["b", "TI"]}]}]], "InlineFormula"],
 " gives the minimum norm ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " that minimizes ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{"\[LeftDoubleBracketingBar]", 
     RowBox[{
      RowBox[{"m", ".", "x"}], "-", "b"}], "\[RightDoubleBracketingBar]"}], 
    "2"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->136675047],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->667062967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{
   RowBox[{"PseudoInverse", "[", "m", "]"}], ".", "b"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58732233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["2", "3"]}], ",", "0", ",", 
   FractionBox["2", "3"]}], "}"}]], "Output",
 ImageSize->{78, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->113505737]
}, Open  ]],

Cell[TextData[{
 "Adding any vector in the ",
 Cell[BoxData[
  ButtonBox["NullSpace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NullSpace"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " will leave the residual unchanged:"
}], "ExampleText",
 CellID->316841290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"NullSpace", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->55826691],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "2"}], ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->828848630]
}, Open  ]],

Cell[TextData[{
 "The minimum is at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", " ", "=", " ", "0"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->247584839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{"(", 
     RowBox[{"x", "+", 
      RowBox[{"t", " ", 
       RowBox[{"v", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->107771048],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->446594761]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22760566],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PseudoInverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PseudoInverse"]], "InlineFormula"],
 " satisfy the Moore\[Dash]Penrose equations [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Moore-PenroseMatrixInverse.html"], 
    None}],
 "]:"
}], "ExampleText",
 CellID->121717130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->954264896],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->903041395]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"PseudoInverse", "[", "a", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91978447],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{166, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->618509260]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", ".", "b", ".", "a"}], "\[Equal]", "a"}], ",", 
   RowBox[{
    RowBox[{"b", ".", "a", ".", "b"}], "\[Equal]", "b"}], ",", 
   RowBox[{
    RowBox[{"a", ".", "b"}], "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", ".", "b"}], ")"}], "\[Transpose]"}]}], ",", 
   RowBox[{
    RowBox[{"b", ".", "a"}], "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", ".", "a"}], ")"}], "\[Transpose]"}]}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->91694244],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->182189231]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20250],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeastSquares",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeastSquares"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SingularValueDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SingularValueDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SingularValueList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SingularValueList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32762]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29352],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "Tutorials",
 CellID->20883]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->483709446],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "MoreAbout",
 CellID->81788834],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->409012582],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "MoreAbout",
 CellID->25676955]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
PseudoInverse"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PseudoInverse - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 21.6713268}", "context" -> "System`", 
    "keywords" -> {
     "generalized inverse of matrices", "Moore-Penrose inverse", 
      "pseudo-inverse", "semi-inverse"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PseudoInverse[m] finds the pseudoinverse of a rectangular matrix. ", 
    "synonyms" -> {"pseudo inverse"}, "title" -> "PseudoInverse", "type" -> 
    "Symbol", "uri" -> "ref/PseudoInverse"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6810, 228, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->421505251]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45124, 1517}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2589, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3212, 88, 50, 1, 70, "ObjectName",
 CellID->8054],
Cell[3265, 91, 500, 15, 70, "Usage",
 CellID->3127]
}, Open  ]],
Cell[CellGroupData[{
Cell[3802, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4280, 128, 225, 7, 70, "Notes",
 CellID->26806],
Cell[4508, 137, 241, 8, 70, "Notes",
 CellID->7334],
Cell[4752, 147, 381, 13, 70, "Notes",
 CellID->20347],
Cell[5136, 162, 552, 18, 70, "Notes",
 CellID->2619],
Cell[5691, 182, 737, 27, 70, "Notes",
 CellID->25265],
Cell[6431, 211, 342, 12, 70, "Notes",
 CellID->30683]
}, Closed]],
Cell[CellGroupData[{
Cell[6810, 228, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->421505251],
Cell[CellGroupData[{
Cell[7195, 242, 148, 5, 70, "ExampleSection",
 CellID->313702541],
Cell[7346, 249, 94, 1, 70, "ExampleText",
 CellID->11919623],
Cell[CellGroupData[{
Cell[7465, 254, 349, 11, 28, "Input",
 CellID->204568946],
Cell[7817, 267, 679, 25, 51, "Output",
 CellID->49994911]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8545, 298, 216, 7, 70, "ExampleSection",
 CellID->24323],
Cell[8764, 307, 139, 5, 70, "ExampleText",
 CellID->468105420],
Cell[8906, 314, 446, 15, 70, "Input",
 CellID->357944799],
Cell[9355, 331, 74, 1, 70, "ExampleText",
 CellID->471096364],
Cell[CellGroupData[{
Cell[9454, 336, 109, 3, 70, "Input",
 CellID->234734638],
Cell[9566, 341, 854, 31, 51, "Output",
 CellID->664756751]
}, Open  ]],
Cell[10435, 375, 76, 1, 70, "ExampleText",
 CellID->532288082],
Cell[CellGroupData[{
Cell[10536, 380, 137, 4, 70, "Input",
 CellID->383493770],
Cell[10676, 386, 797, 23, 71, "Output",
 CellID->198171715]
}, Open  ]],
Cell[11488, 412, 103, 3, 70, "ExampleText",
 CellID->210313213],
Cell[CellGroupData[{
Cell[11616, 419, 166, 5, 70, "Input",
 CellID->16322019],
Cell[11785, 426, 1344, 37, 122, "Output",
 CellID->175625917]
}, Open  ]],
Cell[13144, 466, 124, 3, 70, "ExampleDelimiter",
 CellID->13226464],
Cell[13271, 471, 116, 3, 70, "ExampleText",
 CellID->471316172],
Cell[CellGroupData[{
Cell[13412, 478, 259, 8, 70, "Input",
 CellID->805696311],
Cell[13674, 488, 1063, 27, 54, "Output",
 CellID->73922327]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14786, 521, 239, 7, 70, "ExampleSection",
 CellID->21720],
Cell[15028, 530, 67, 1, 70, "ExampleText",
 CellID->135627519],
Cell[CellGroupData[{
Cell[15120, 535, 486, 17, 70, "Input",
 CellID->231721198],
Cell[15609, 554, 2376, 43, 70, "Output",
 Evaluatable->False,
 CellID->387225313]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18034, 603, 217, 7, 70, "ExampleSection",
 CellID->3735],
Cell[CellGroupData[{
Cell[18276, 614, 226, 7, 70, "ExampleSubsection",
 CellID->27347],
Cell[18505, 623, 149, 5, 70, "ExampleText",
 CellID->600859646],
Cell[18657, 630, 162, 5, 70, "Input",
 CellID->412871025],
Cell[18822, 637, 125, 3, 70, "ExampleText",
 CellID->17387579],
Cell[CellGroupData[{
Cell[18972, 644, 175, 5, 70, "Input",
 CellID->441002359],
Cell[19150, 651, 159, 5, 36, "Output",
 CellID->201817690]
}, Open  ]],
Cell[19324, 659, 95, 1, 70, "ExampleText",
 CellID->69027838],
Cell[19422, 662, 194, 6, 70, "Input",
 CellID->104890562],
Cell[19619, 670, 144, 4, 70, "ExampleText",
 CellID->326868747],
Cell[CellGroupData[{
Cell[19788, 678, 235, 7, 70, "Input",
 CellID->131399327],
Cell[20026, 687, 175, 5, 36, "Output",
 CellID->682718382]
}, Open  ]],
Cell[20216, 695, 87, 1, 70, "ExampleText",
 CellID->193403974],
Cell[20306, 698, 266, 8, 70, "Input",
 CellID->481614583],
Cell[20575, 708, 141, 4, 70, "ExampleText",
 CellID->120079724],
Cell[CellGroupData[{
Cell[20741, 716, 235, 7, 70, "Input",
 CellID->52736173],
Cell[20979, 725, 162, 5, 36, "Output",
 CellID->339484162]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[21202, 737, 223, 7, 70, "ExampleSection",
 CellID->26660],
Cell[21428, 746, 61, 1, 70, "ExampleText",
 CellID->357325855],
Cell[CellGroupData[{
Cell[21514, 751, 649, 23, 70, "Input",
 CellID->293510528],
Cell[22166, 776, 2176, 40, 70, "Output",
 Evaluatable->False,
 CellID->80414259]
}, Open  ]],
Cell[24357, 819, 91, 1, 70, "ExampleText",
 CellID->188782123],
Cell[24451, 822, 319, 12, 70, "Input",
 CellID->593728085],
Cell[24773, 836, 111, 3, 70, "ExampleText",
 CellID->507596383],
Cell[CellGroupData[{
Cell[24909, 843, 132, 4, 70, "Input",
 CellID->175401898],
Cell[25044, 849, 243, 8, 36, "Output",
 CellID->225625141]
}, Open  ]],
Cell[25302, 860, 210, 8, 70, "ExampleText",
 CellID->193107],
Cell[CellGroupData[{
Cell[25537, 872, 184, 6, 70, "Input",
 CellID->698365324],
Cell[25724, 880, 259, 7, 36, "Output",
 CellID->21261064]
}, Open  ]],
Cell[CellGroupData[{
Cell[26020, 892, 282, 9, 70, "Input",
 CellID->207597993],
Cell[26305, 903, 3246, 57, 70, "Output",
 Evaluatable->False,
 CellID->233637060]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29600, 966, 233, 7, 70, "ExampleSection",
 CellID->28368],
Cell[29836, 975, 122, 3, 70, "ExampleText",
 CellID->316235439],
Cell[CellGroupData[{
Cell[29983, 982, 350, 11, 70, "Input",
 CellID->410020150],
Cell[30336, 995, 646, 24, 51, "Output",
 CellID->34490886]
}, Open  ]],
Cell[CellGroupData[{
Cell[31019, 1024, 344, 11, 70, "Input",
 CellID->451461945],
Cell[31366, 1037, 647, 24, 51, "Output",
 CellID->121806892]
}, Open  ]],
Cell[32028, 1064, 124, 3, 70, "ExampleDelimiter",
 CellID->55851416],
Cell[32155, 1069, 713, 27, 70, "ExampleText",
 CellID->136675047],
Cell[32871, 1098, 470, 16, 70, "Input",
 CellID->667062967],
Cell[CellGroupData[{
Cell[33366, 1118, 155, 5, 70, "Input",
 CellID->58732233],
Cell[33524, 1125, 277, 10, 51, "Output",
 CellID->113505737]
}, Open  ]],
Cell[33816, 1138, 310, 11, 70, "ExampleText",
 CellID->316841290],
Cell[CellGroupData[{
Cell[34151, 1153, 127, 4, 70, "Input",
 CellID->55826691],
Cell[34281, 1159, 257, 9, 36, "Output",
 CellID->828848630]
}, Open  ]],
Cell[34553, 1171, 180, 7, 70, "ExampleText",
 CellID->247584839],
Cell[CellGroupData[{
Cell[34758, 1182, 375, 13, 70, "Input",
 CellID->107771048],
Cell[35136, 1197, 2640, 47, 70, "Output",
 Evaluatable->False,
 CellID->446594761]
}, Open  ]],
Cell[37791, 1247, 124, 3, 70, "ExampleDelimiter",
 CellID->22760566],
Cell[37918, 1252, 390, 13, 70, "ExampleText",
 CellID->121717130],
Cell[CellGroupData[{
Cell[38333, 1269, 207, 7, 70, "Input",
 CellID->954264896],
Cell[38543, 1278, 322, 11, 36, "Output",
 CellID->903041395]
}, Open  ]],
Cell[CellGroupData[{
Cell[38902, 1294, 131, 4, 70, "Input",
 CellID->91978447],
Cell[39036, 1300, 382, 14, 36, "Output",
 CellID->618509260]
}, Open  ]],
Cell[CellGroupData[{
Cell[39455, 1319, 546, 18, 70, "Input",
 CellID->91694244],
Cell[40004, 1339, 236, 7, 36, "Output",
 CellID->182189231]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40301, 1353, 311, 9, 70, "SeeAlsoSection",
 CellID->20250],
Cell[40615, 1364, 1236, 44, 70, "SeeAlso",
 CellID->32762]
}, Open  ]],
Cell[CellGroupData[{
Cell[41888, 1413, 314, 9, 70, "TutorialsSection",
 CellID->29352],
Cell[42205, 1424, 161, 3, 70, "Tutorials",
 CellID->20883]
}, Open  ]],
Cell[CellGroupData[{
Cell[42403, 1432, 319, 9, 70, "MoreAboutSection",
 CellID->483709446],
Cell[42725, 1443, 138, 3, 70, "MoreAbout",
 CellID->81788834],
Cell[42866, 1448, 163, 3, 70, "MoreAbout",
 CellID->409012582],
Cell[43032, 1453, 159, 3, 70, "MoreAbout",
 CellID->25676955]
}, Open  ]],
Cell[CellGroupData[{
Cell[43228, 1461, 305, 8, 70, "RelatedLinksSection"],
Cell[43536, 1471, 391, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[43942, 1487, 50, 0, 70, "History"],
Cell[43995, 1489, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

