(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23144,        601]
NotebookOptionsPosition[     20489,        511]
NotebookOutlinePosition[     21687,        547]
CellTagsIndexPosition[     21602,        542]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LightPurple" :> 
          Documentation`HelpLookup["paclet:ref/LightPurple"], "ColorData" :> 
          Documentation`HelpLookup["paclet:ref/ColorData"], "Lighter" :> 
          Documentation`HelpLookup["paclet:ref/Lighter"], "Darker" :> 
          Documentation`HelpLookup["paclet:ref/Darker"], "Hue" :> 
          Documentation`HelpLookup["paclet:ref/Hue"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LightPurple\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Hue\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Purple", "ObjectName",
 CellID->6361],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Purple",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Purple"]], "InlineFormula"],
     "\[LineSeparator]represents the color purple in graphics or style \
specifications. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Purple",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Purple"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"0.5", ",", "0", ",", "0.5"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->198832108],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->108435509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Purple", ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.5, 0, 0.5], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->100075418]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Purple"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245967023],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->208002107]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Purple", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->82364862],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.5, 0, 0.5], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->224328400,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVmwd7I8exrl8r2HKS07F9dG0f69gX5C43gjnnnBNIECSIRBAgCCLnnBNz
2P23eu7taYArLkjJKz27Iwymt+d7u6qrqmfQS6aA3XpiChxZTN/O+Ewe+5HF
/+202ye++vxnwIH46/xvxOf/Jz7Jv+Pfffcdn1ut1u/kf/xTOTAijl+KL7+V
Z0Pi+Jk4+7zx//q3/eKo/MMvH/Qgjo0eehttv3ryanfj6q+Usy8+3F18+B95
vaPR92+Usy8/XG/08Q/ZRt3o43c/0uZNo80fn2zzd9nmZeNe/9U0Ep81nX8j
W7c1evzrJ7VubfT9TdPVz5vO/1u2VjX6/vsntf53o/X/NF39oulcKuXbhpJv
m65+2XT+F9n6fxp9//uTWv+t0beq6erPm87/LFt/0+j72Se1/mujdVvT1V80
nUvryaPy5cumq181nf9Jtv5jo+83n9T6943W6qarv2w6l77GbxtKOpqu/qrp
/A+y9a8bfXd/UutfNlr3Nl39ddP572Xrrxqt+/9D39+3fjhf/68ckJeo36Du
QN2Nug/1AOpB1MOoPxtB3XzX5vPffd/vRzNdRoLftaJ+cd95D+p+1EOoRa/j
qCdRT6OeQT2Heh71Amo+WxSHz+fl3P/uCX/8TdP519/f+9Hs/5uEbkH97CkJ
o1LCFOpZeX9x8yXUK4J4TSj4+QbqTdQaeRSf11E3z7ofUfIjUUPOp7+oUIth
aUP9GrUadZcc88H7YZmSYyLGQIzFMupVefsNqWYLtRb1DuovdULlF9uo1+RQ
3UfJB3f6rdTTPIuaKRTP/0zI4a8PB6n7wSBNSCPN3o/QqrxlXc22lCKU7KLe
Q72v2M8gRtCoaDPIL8TXn6yt2daKv36uaPvmsQ8J1xyTDjRzb736SNXtVh8m
nby9HrWQIiSZUJsVhRbUnx8oXmaR2sR1mvX95kl9zfHr6/ux+0eLtOdjH3so
sW7MprHb/VifUCSUWVEforYpg2hXdIo7Hsprj3T++kmdzeeS5p9CaF3m83ul
7U8Z+l5p+xrtG7RraNfSvkP7Lu162g20m2g338sUGoXCI2VUHeLw1TFqp/wj
bi4+O2QLwfXbT9LdPHd+eW//b1vv5/Dre9V9DdXtE3RM0zFH5yJdy3St0rVB
t4bubbp1dO/RrafbQLeJbgvdB3Qd0mmj84gOBx3HtAutJ8JjXeIuv3BL3eLo
kl8eS0Satf/qSe3NOeIX99pVLfcj/mGu99IxSOcIXeN0T9E9S88Cvcv0rdK3
QZ+G/m36dfTv0b9Pv4F+E/0W+q302+iz03tE7zE9TrpP6HbR5abTQ4eXdp+U
z2c+xXG8qN2Swv549KXWR97cHNWV2fiFJKiHqleo39LRQWcPXQN0D9MzTu8k
fTP0zzOwxOAqg+sMbTK0zdAOw7sM6xk2MGxi2MKwlSEbQ3aGHAweM3jCgIt+
N/0eer30+Oj20xWgUyH4PKAQ+FELEo/0ouZY+zRBc6sv7gleCed5SccbOtvp
7qanj94h+kcZmGBwmqE5hhcZXmZkjdFNRrcY0zKmY0zPuIFxE+MWxg4YO2TM
zpiDsWNGTxhxMeJh2MuQj0E/AwH6g/SF6BX3D9EZpiNMewh1ELXA8cpZ8Ujh
V09yNNvrs3uO1y10tNH5im41vV309TIwwOAIQ+OMTDE6y9gCY0uMrzKxwaSG
yW0mdUztMbXPlJFpM1MHTB0yZWfKwdQxkydMupjwMO5l3M9YgNEgIyGGwwxG
GBASIvRG6Y7SFaUjgjqMWjD5H1vkaZKvm87ljFCraFfR2Up3Gz2v6WtnoJuh
foaHGB1lbJLxGSbnmVxkaoXpdWY2mdlmdofZXWb1zBqZMzN3wJyVORuzR8we
M3vCrIsZDzNepv1MBZgKMhliIsxYhNEoI0JEjME4/XF643TH6IzRHpVEgScs
84sneWT87VEKYYWi/qdDRZeKnmf0vWTgLUOdjPQyNsD4CJPjTE0xPcvMArPL
zK4yt8H8FgtaFnQs7LFgYNHEooVFK4s2Fu0sOlh0suBiwc28l3kfcwHmgsyG
mAkzHWUqxmScCaEhwUiC4SSDSfqT9CToStARQx2RBnpE9PMniWTNq1ilq07S
Qm8rA20MvWaknbFuJvqZGmJ6lJkJZqeZm2N+kYUVFtdY3GRpm+UdlndZ3mfF
yIqZlQNWDlmxs+JgxcnKCStulj0s+1jysxRkMcRCmPkoczFm48wkmBZykkyk
GEsxmmY4xUCK3hTdSTrikkdEgUfxqc7zVM0gebqFi6nobqGvlcFnjLxk7C0T
nUz1MD3A7DBzY8xPsTDL0gLLSyyvsrLBqoZVLWs61vZYN7BuYt3CupV1G+tH
rB+zfsK6i3UPaz7W/KwGWQ2xEmElynKMpTiLCRaSzKeYFaLSTGWYyDCWYSTD
YIb+tKRK0C78TpkzSsH81Q+S0HfvYgKkv5WhZ4y2MfGKSTXTXcz2MT/IwiiL
EyxPszLH6iJry6ytsb7JxhYbO2zusqln04DGjOYAzSEaOxoHGieaEzRuNF42
fWwG2AiyEWY9wnqMtTirCVaSLKdYSrMgZGWYzTKTZSrHRJbRLMNZ+jP0pOiM
1+eQEm8VgOYa88sn+eRc6v/Ap6K/heFWxp4z8YLpN8y2M9/NQj9Lw6yMsTrJ
2gzr82wssbnC5joaDVvbbOnY3mN7n20jWgtaK1ob2iO0x2idaF1oPWh9bPvZ
DrIVYiuCJoomxmaCjSTrKdbSrGZYEcqyLOaYzzObZzrPZJ7xHCNZBiSlMrUU
az1ZtT5NNyAjnYKmYriF8WdMvmDmFXNvWehkqZeVAVZHWB9nY4rNWTQLbC2z
vcr2BloNO1p2dtHp0RnQmdi1sHvIrp1dB7vH7J6w62bXy64fXQBdiJ0wO1G0
MbRxthNspdCk2cywkRUubLXmWMmzVGCxwFyBmQJTBcbzjOQkYJJ2xYbNa8an
6WRcH5S266zTqRhvZeo5sy+Yf82SmuUuVntZG2RjlM0JtqbZnkO7yM4KujV0
m+xusbvD3i57++iN6M3oD9Afsm9n38G+E70LvQe9D70ffZC9EHsRdqPsxtEl
0CXZSaHNsJ1lK4dGiMuzXmC1yEqRpSILRWaLTBeYKEjGNF3CT38an7Bebx1O
xVQrs89ZeMnSG1bbWetmo4/NIbbG2J5EO8POHLpFdlfYW0e/iX6b/R329zDs
YzBitGC0YrRhPMJ4jPEEoxujB6MPYwBDEEMYQ4T9GPtx9En2Uuym2c2gy7GT
Y1uIK6ApslFkvcRqieUSiyXmBGJRImaV4NL5aXyywhiW9hPeOVTnUzHXymIb
y69Yfct6B5s9bPWzPczOGLpJdmfYm0e/xP4qhg0MGoxaTDpMeswGzCbMFsxW
LHYsDizHWE6wuLF4sfgxBzCHMEcwRTHFMSYwJjGk2c+gz7KXYzePTugroi2x
VUJTYqPMWpmVMotl5kqSMs9wRqlH1M3Vdp2yOe58/T2lmIljdUQVi62stLH2
mg01mk62e9kZQDfM7jj6KfZnMSxgXMa4hmkD8xYWLZZdDvQcGLCasR4glmNW
O1YHVidWF1YPVh9WP9Yg1jAHEQ5iWOJYkphTmNKYMhhzGPLsF9BLSl2JnTLb
ZbYqbFZYr7BSUUDnS4rHjuWUpN7x0yh7VIyomKwjqlhpYb2NzVdsqdF2oetl
d5C9EfbHMUxjnMW0gHkZyxoHm1i3sO5wuMvhPjYjNjO2A2yH2OzYj7E7sbuw
e7D5sAWwBbGFsUU5jHGYQKRua4qDDJYs5hzmPKYCBqGvhL7MXhldBW2FrSqa
agN0SYKK8COyfW+zx37xo5SD0ldn6ogq1lvQPGf7FTtqdF3s9bE/iGEU4wTm
aSxzHCxiXcG6xuEmtm1sO9h3se9zZOTIzJEVhw3HEY5jHCc43Dg8OHw4AjhC
HIU5imKPYU9gT2JLc5jhMIsINAcFLEXh7Qqlocx+BX2F3So7VbbroNWGRUUM
mswy9GmUcl6OSo8dke46r2JZxZqKzRa229h5zW47+m4MfRiHMI9imeBgBusc
h4vYVrCvc6ThaBvHDo49jvc5NuG04LTitOE8wnnMyQlON04vTj/OIM4QzgjH
UY7jOBI4UhylOcpgz2HLc1hAuOuBkFjGXMFUwVBFX2Wvhq7Gdu2etcxCiZkc
owm6m/32x1n7pEWF0y59AG1F18bea/bbMXRj6scyxMEo1kkOZ7DPY1/iaAXH
OscanNs4dZzscWLAZcJlwWXFZcPlwO3EfYLbjduLy48riCuEK4IrxkmckyTO
FM40x1kcOY7yHBWwF7FJ1oMKliqmKsYa+7UGrrbW8OHlslImTKYZ/GmsItJO
q1hQsXoPuvOMvRfsv8HYgbmHg36sQxyOYZvkaAbHPMdLOFdxrnOiwaXFpcO9
h9uAx4THgseKx47XgdeJ14XXjdeL148niCeMJ4InhjuOO4krhSvDSRZnDmee
4wKOovB/hdVWwVrloIq5hqmG4QHuZlUJwqJomBEV7NOsze8uvm6wij+z0ns3
VGy1SNDn7L/A9AZzBwc9HPZjG8Y+hmOS4xmc85ws4VrFtYFbg0eLR4dXj9eA
z4TvAN8hPjt+B34nfhd+D34vfj/+IL4wvgi+GN4E3iTeFJ4M7izuHK4CJ0Wc
JY6FxApHFWxVDmsc1LCcYjrFcMreqXTmKhsVpXiYzzL+01gnpFGF92pUaFvY
a2X/OaYXWN5w0MFhD/YBHMMcj+Gc5GQG1zzuJTyreDbwavBp8enw6/EbCJgJ
HBA4JGgn6CDoJOgi6CHoIxggGCQYJhAlEMOfwJ/En8aXwZvFm8dTwF3EVeJE
sh5XcVSx17DVsJ4+wK0pcUpknvWiUvBO/TTWaTlThVG3Vey2sP8MYxuWl1jf
YOvA3oNjAOcwJ2O4JnHP4lnAu4RvFf8G/i0CWoI6gnqCBkJmQgeEDgnbCTsI
Owm7CHsI+wgHCAcJhwlFCcUIJQgmCaYJZPBn8efxFfAW8ZRwS9aTKk6BW+Po
FNvp97hi7oqwLPLPZokVsX75CaxvZZ5ZlUbdUaFXYXyGuQ3rK2xvOerA0YNz
gJNh3GN4JvHO4lvAv0RgleAGwS1CWsI6wnrCBiJmIgdEDonaiTqIOom6iHqI
+ogGiAaJhIlEicQIJwgnCacJZQhmCeYJFPAX8SnvePi6gruKS+DWOD79CLce
qkS6FQXUWpa55pzz+Q+zvpIReL1uVBUGFeZWDtqwveToLccdOHtw9eMexjuG
bxL/LIEFgkuEVgltENYQ0RLREdUTNRAzEzsgdkjMTtxB3EncRdxD3Ec8QDxI
LEwsSixGNEE0SSRNJEM4S1gK4/cl/GV84mMVj4CtcfIxrFlGKZFyRbUoVjcL
P4G0TSbVjQ8mVXHQwuFzjl5y/JaTDlw9ePrxDuMfIzBJcIbQPOElIqtENohq
iGmJ6YjriRtImEgckDgkYSfpIOkk6SLpIekjGSARJBEmESERI54gniQm+f6U
I1IgXCRUIlgmUMFfZ63hFqyn96wySokcJMoLUTBqsiw9Wp/VSZvfMsnVZ6ss
kjQfDKrCqsL+HMdLnG9xdeDpwdePf5jAGKFJwjNE5okuEV0ltk5cQ1xLQkdS
T9JA0kTqgNQhKTspByknaRdpDykfKT+pIKkwqQjJugX/kiKRIZ4lliOWJ1ok
UiJcJlQmWKetfUxbU2KyyLhGUTIW2RLr8Z9A+m8ZkrZU7NUNqsLWguMZzpe4
3uDpwNeNv5/gEKExwpNEZojOE1sivkpinaSGpJaUjtQeaQNpE2kLGSsZOxkH
GScZFxk3GS8Z+YKTb2Kk46SSpFIkMySzJHLE88QKxIpE66QVglUCD0lrSnwS
4ViEK1MZfUFZva7+FIt+K9PMtnRcYc7DFo5aOG7F1YbnNb52/N0E+wgNERkl
Oklshvg8iSWSK6TWSWlIb5PRkdkjs0/WRNZC1krORu6I3DE5abt/+MkFyYbI
RsjGyMbJJMikSKdJZUnlSOZJFIgXiZWIlolUCAtYSeqTsGLCiuh0JPKsqKJK
ysJnJ8nKJ5LK515/F3lUeq2lbssWTlpxt+F9jb+dYDfhPiJDREeJT5CYJjlH
apHUCul1Mptkt8nukNsjt0/OSN5C3kpe0n17QsFNwUvBTz5APkQ+Qj5KLk4u
QTZFNk0mQzpLOk+qQLJIokS8TKwiSauStIpPhiaRdo4r2EW9WFSWeLoYyz+B
8hsZhQzSY+0qnC24WvE+x/+KoJpQF5E+YoPER0hMkJwmNUd6kcwK2TVym+S2
ye+Q36OwT6E+7/5lo3hE8ZjiCUU3RQ9FH8UAxRCFMIUohRj5BPkkuTS5DNks
mZxCmv5hUm8VdwVnmaMy1gLGLLvNz5Y/+2HGP0tLGmXwOVJx0oLnGb42Ai8J
vSXSSayX+ACJEVLjpKfIzJJdILdMbo38huCSM05lpGSmdEDpkLKdsoOyk7KL
soeyj7KfUpBSmFKEYoxinEKSQop8mnyWXI5snkyBdJFUieRDxrrfVvCICqKs
VMSHYvmaQvfo6fmPEP5Rhh5BeKjCocKlwvsMfxvBl0TeEu0k3kNigNQw6TEy
U2RnyS00vPG5hpKWko6ynrKBsonKAZVDKnYqDipOKi4qHipeKn4qQcohyhHK
UUpxSgmKKYppCpkfxhTTU8aigKz0RWkoCn+bWKUn2PkBRumw9S/rv4v5WoVJ
wh2rcKvwtRB4TvgF0TfEO0h0k+onPUxmrBE/Xi5RXKW0TllDeZuKjsoeVQNV
E1ULVSs1G7UjasfUTqi5qXmp+qkGqIaohqlEqcQoJygnKQm+DMUshRz5PLkC
2Y/5RPgRsTZYksVCUVnb2DKYw2x9ItuvVew/ZFMRbCXygthrEu0ku0nX59Xr
CQrTFOcoLVJaobxOZZPqNtUdanvU9qkZOTVzauXUxukRp8ecnnDq4tTDqY/T
ALUgtTC1CNUY1TgVwZeinKb0JJ+ciiK8iqwZKsp8mceZVZ5CmJ56O/gE2Vcy
7wsypwqPCr+KUAvRNuKSR91LdpD8CIVxilOU5igvUFmmukZ1k9oWtR1OdznV
c2bkzMzZAWeHnNk5c3Dm5MzFmYczL2d+zoKchjiNUItSi1NNUE1S+SE2GWZE
6hAVQbhAQKxZhJwUthjGJ997fkxW/wWfjJcKVj02dLwk9ZZMJ9ke8gMUhimO
UZqiPEtlgeoStVVqG5xqONNypuNsj3MD5ybOLZxbubBxccTFMRcnXLg593Du
4zzAeZCzMGcRTmOcxqnVudJUMpQfcNXnnEgUibxS6YRFtS7WYmm5BHv0/vNp
ImmRXhWBFsKtxJ6RaCP9mkw7uW4KfRSHKI1SnqAyQ3We2iKnK5ytc7bJ+Tbn
O1zscbHPhZFLM5cHXNq4POLSwaWTSxeXHi68XPi5CHIe4lxARTmrQyWppqhK
qIax6oFE5ASR53NK+RbJKususap2huVzoGamnz1i+sM9U5/4IKO+mFoBFeEW
Yq0kn5N+RVZNvotCL6VByiNUxqlOUZvldIGzZc7XON/gYosLLZe7XOq5NHBl
4srC1SFXdq6OuDrm6oQrN5deLn1cBhS+izDnEc7rfAmFr5ZSjNZwxnqgFDkv
q5Qy8Yyy8hDrSk+M40exvfl94z3nx+uJD++7eqVXuuqgKuItCmjmJbk3FDoo
9lDupzJMdYzaJKcznM1zvsTFKhfrXGq43OZKx9UeV/tcG7m2cG3l2sa1nWsH
106uXVx7uPJy5VdYL0MK60WdNf7AQesTTySFtJLiM6JmSxNPEUkojww8Qew/
nVOpaD68p+yWsdJ/D5lqJfOC3GsK7ZS6KPdRHaQ2yukEZ9Ocz3GxyOUyl2tc
bXK1xfUO17tc67kxcGPi5oCbQ25s3Bxxc8zNCTeS89qncF5JzssPnA8nYj05
iByfIpNUanGxwBKL50CQk+anb80V2WPCXzQsKSNQl0jgIlqqiAkbtpB5Ru4F
hbeUOqn0UB3gdJizMc6nuJjhcp7LJa5Wud7gWsPNNjc6bva43efWyK2Z2wNu
D7m1c+vg1ikJ3dxIwmtBGOTqMWE9PYj0nlCKNVGAp+LEo4RD+FzYHr3NaX6m
8Zjv/s2srFc6pQWFm0ZVkq+V3HOKryi1U+mm1sfpEGejnE9wMc3lHFeLXK9w
s8bNJjdb3Gq53eVWz52BOxN3Fu6s3Nm4O2og3rq4FYhebuqID40ooqnIEjEl
CZZjSq2WFwuMKMkIsaDylMv1n34T1mD7/nem3z34bXe7tJxwzISKdIvEekH5
DZUOaj2cDXA+zMUYl5NczXA9z/USN6vcrnOr4W6bux3u9rjb552Rd2beHfDu
sEF2d8zdk2Qi5NRDaj23R5TyrCgWFGEyIeURQMSD76nfhj1mUpDk777fSuPE
VKRU5FoptFF6RVVNrYuzPs4HuRjhcoKraa5nuVngdpnbNe42uNPwTss7He/2
ePcxxTs775oohAt6G/Pssp7tZCIXRZgoMotBcgHSPuJugs3z52n9D7/5P8rh
tZxEwhTZVvLPKLVReU2tnbNuzvu5HOJqlOtJbma4meN2kbsV7tZ4t8m7rQbH
ez3vDbw38t7M+8ccMliI2SQ4rmQOOPcrBUnNr9STJT8FH1kPyRMiT/2652fi
VFH+cf6y3v9u+KWKSN0ELRSfUXlJ7S2nnZz3cDHA1TDXY9xMcTvD7Tx3S4r6
d+uK+vdbvN/h/e69etMD9TapXsyS40YsEFFdyWAepewQFZUohUW1X3KTd5F2
EGvOtT9/pLv5GZfch9Am53ZGRV5F6TnVV5yqOe/iopfLQa5HuBnnVmif5W6B
d0u8W+X9Ou+F9u2PtX8Yeaui/U4EMTnJRaQWGUlkX1Eyncsyt3qiLMgKx8oz
k/jvmzR9+Ui1Eo+Up5nST57dqy20Um6j9oozqfayj6sHau9meSfVvv+gtj7S
wk/2eL8v1Zp4Z1FcXoSkW5sSdUVeuZa10IVDqV1rYlEl1sc25clH/I9NOr94
pLP511JyfrbI+Sn0Flup3Ou9kHqvB7kZ4XaCux/Sq73Xq+edQZmid2YlhIos
cSPy/aFS3lwcci4WEWIRaKVoIbtP7E//UWnznJR+8C8RBuWwVp5/L/Pqg8zx
e5nzUuYK79d4v8F7TcMP6pHkTkZ6kcxEur42c2Xmwsy5WVnuVIwU9WT+0nTv
zx+pu9+hIGfWP4VftlBupfZSSurkspfrASlpjNtJ7ma4m+PdIu+WFdesTysl
KMgQfatT8o9IsaKIuNJzIZYoemURVtZR2CRet1FTzf2xmuZ4Jr3wb2KgVIo9
T99w3sFFD1f9XA9xM8rNBLfTykDdiZku4tQyd6vciayx0UiJ16J42+ZSy7mW
U7Eo1FBcIVmPIz+g5PsdIbLVX63KbwrFsFReKHHmvFMRcFmPMyJKTnA91QiU
1wtK2rpe5mqFS1E9rinF8ukqlSUK9b1XXz7MjUo8q9+veXUlx+m/HrYVGbNN
SZe1DiVGN3KNzJgXohaY5FwUdKJwnaE2Q2WSgtw79NGOj/qdmqNW806qzh/4
d7/77umdV10Pzr/n+UNTq+bdXfc70Oqt73cCNbfq+cgmzVeb76Eo+fxD6z83
+mxupWzI+OJ+XfCIvnl0Xn338FeAzd7bnLmef1fft1ffoXC/06q5larRZ303
UbMfNtcj3zb6rO/H+nujz+ZWf2/0KWcLzXvSnoqUSuv6br9/NvpsbvWnxp3/
JVv9b9PV5tz2u0afrbL1v5quPrWuUVq/kK3v99I1t/p5Q4HcISbH7aGnfdHo
Q3osLeL4c2tjVxb87P8D7XhZMw==\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27445],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LightPurple",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LightPurple"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2524]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->413328406],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->675603888]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Purple - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 22.1713396}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Purple represents the color purple in graphics or style specifications. \
", "synonyms" -> {}, "title" -> "Purple", "type" -> "Symbol", "uri" -> 
    "ref/Purple"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3719, 122, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->198832108]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21459, 535}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1677, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2300, 64, 43, 1, 70, "ObjectName",
 CellID->6361],
Cell[2346, 67, 446, 14, 70, "Usage",
 CellID->32421]
}, Open  ]],
Cell[CellGroupData[{
Cell[2829, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3307, 103, 375, 14, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[3719, 122, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->198832108],
Cell[CellGroupData[{
Cell[4104, 136, 148, 5, 70, "ExampleSection",
 CellID->108435509],
Cell[CellGroupData[{
Cell[4277, 145, 184, 6, 28, "Input",
 CellID->511908593],
Cell[4464, 153, 267, 8, 121, "Output",
 CellID->100075418]
}, Open  ]],
Cell[CellGroupData[{
Cell[4768, 166, 267, 8, 28, "Input",
 CellID->245967023],
Cell[5038, 176, 2386, 43, 109, "Output",
 Evaluatable->False,
 CellID->208002107]
}, Open  ]],
Cell[CellGroupData[{
Cell[7461, 224, 187, 6, 70, "Input",
 CellID->82364862],
Cell[7651, 232, 10245, 173, 129, 90, 2, "CachedBoxData", "BoxData", "Output",
 CellID->224328400]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17957, 412, 311, 9, 70, "SeeAlsoSection",
 CellID->27445],
Cell[18271, 423, 1661, 62, 70, "SeeAlso",
 CellID->2524]
}, Open  ]],
Cell[CellGroupData[{
Cell[19969, 490, 319, 9, 70, "MoreAboutSection",
 CellID->413328406],
Cell[20291, 501, 124, 3, 70, "MoreAbout",
 CellID->675603888]
}, Open  ]],
Cell[20430, 507, 29, 0, 70, "History"],
Cell[20462, 509, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

