(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15921,        567]
NotebookOptionsPosition[     12151,        443]
NotebookOutlinePosition[     13493,        480]
CellTagsIndexPosition[     13408,        475]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading and Writing Mathematica Files: Basics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"], 
          "Reading and Writing Mathematica Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Reading and Writing Mathematica Files: Basics\"\>", 
       2->"\<\"Reading and Writing Mathematica Files\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Write" :> Documentation`HelpLookup["paclet:ref/Write"], "Put" :> 
          Documentation`HelpLookup["paclet:ref/Put"], "Save" :> 
          Documentation`HelpLookup["paclet:ref/Save"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Write\"\>", 2->"\<\"Put\"\>", 
       3->"\<\"Save\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Files" :> Documentation`HelpLookup["paclet:guide/Files"], 
          "Mathematica Expressions in Files" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaExpressionsInFiles"], 
          "Mathematica Session History" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionHistory"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"External Operations\"\>", 2->"\<\"Files\"\>", 
       3->"\<\"Mathematica Expressions in Files\"\>", 
       4->"\<\"Mathematica Session History\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "PutAppend ",
 StyleBox["(>>>)", "OperatorCharacter"]
}], "ObjectName",
 CellID->19288],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], ">>>", 
       StyleBox["filename", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]appends ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to a file. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PutAppend",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PutAppend"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", "\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]appends a sequence of expressions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to a file. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->10377]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PutAppend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PutAppend"]], "InlineFormula"],
 " works the same as ",
 Cell[BoxData[
  ButtonBox["Put",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Put"]], "InlineFormula"],
 ", except that it adds output to the end of the file, rather than replacing \
the complete contents of the file. "
}], "Notes",
 CellID->28488]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->457943010],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->319597965],

Cell["Append expression values at the end of a temporary file:", "ExampleText",
 CellID->222931454],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", "=", " ", "1."}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->236685657],

Cell["Set the directory to one for temporary files:", "ExampleText",
 CellID->408311641],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "$TemporaryPrefix", "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143667753],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Put",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Put"]], "InlineFormula"],
 " the value of ",
 Cell[BoxData["x"], "InlineFormula"],
 " in a file:"
}], "ExampleText",
 CellID->50207010],

Cell[BoxData[
 RowBox[{"x", ">>", "\"\<sqrt2\>\""}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17765249],

Cell[TextData[{
 "Update ",
 Cell[BoxData["x"], "InlineFormula"],
 " and append the new value to the file:"
}], "ExampleText",
 CellID->68552961],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", " ", "=", " ", 
   RowBox[{
    RowBox[{"x", "/", "2"}], "+", 
    RowBox[{"1", "/", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"x", ">>>", "\"\<sqrt2\>\""}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->29606283],

Cell["The file now contains the two values:", "ExampleText",
 CellID->209519034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<sqrt2\>\"", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->437240327],

Cell["\<\
1.
1.5\
\>", "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->168154159]
}, Open  ]],

Cell["Append successive iterates to the file in a loop:", "ExampleText",
 CellID->335362708],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{
      RowBox[{"x", "/", "2"}], "+", 
      RowBox[{"1", "/", "x"}]}]}], ";", 
    RowBox[{"x", ">>>", "\"\<sqrt2\>\""}]}], ",", 
   RowBox[{"{", "5", "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->255890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<sqrt2\>\"", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->484245824],

Cell["\<\
1.
1.5
1.4166666666666665
1.4142156862745097
1.4142135623746899
1.414213562373095
1.414213562373095\
\>", "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->430781567]
}, Open  ]],

Cell["Reset to the original directory: ", "ExampleText",
 CellID->224705661],

Cell[BoxData[
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->490378145]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28685],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Write",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Write"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Save",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Save"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->172]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1035],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"],
  FontSlant->"Italic"],
 ButtonBox[" Files: Basics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"]
}], "Tutorials",
 CellID->16116],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Files",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"]
}], "Tutorials",
 CellID->17938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->8417393],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->213946530],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->3185932],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaExpressionsInFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions in Files",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaExpressionsInFiles"]
}], "MoreAbout",
 CellID->206827828],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessionHistory"],
  FontSlant->"Italic"],
 ButtonBox[" Session History",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessionHistory"]
}], "MoreAbout",
 CellID->144081361]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PutAppend (>>>) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 22.5932254}", "context" -> "System`", 
    "keywords" -> {"appending", "append mode", "append to file"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "expr >>> filename appends expr to a file. PutAppend[expr_1, expr_2, ..., \
\" filename\"] appends a sequence of expressions expr_i to a file. ", 
    "synonyms" -> {"put append", ">>>"}, "title" -> "PutAppend", "type" -> 
    "Symbol", "uri" -> "ref/PutAppend"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5520, 172, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->457943010]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13265, 468}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2645, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3268, 88, 104, 4, 70, "ObjectName",
 CellID->19288],
Cell[3375, 94, 1179, 38, 70, "Usage",
 CellID->10377]
}, Open  ]],
Cell[CellGroupData[{
Cell[4591, 137, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5069, 154, 414, 13, 70, "Notes",
 CellID->28488]
}, Closed]],
Cell[CellGroupData[{
Cell[5520, 172, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->457943010],
Cell[CellGroupData[{
Cell[5905, 186, 148, 5, 70, "ExampleSection",
 CellID->319597965],
Cell[6056, 193, 99, 1, 70, "ExampleText",
 CellID->222931454],
Cell[6158, 196, 121, 4, 70, "Input",
 CellID->236685657],
Cell[6282, 202, 88, 1, 70, "ExampleText",
 CellID->408311641],
Cell[6373, 205, 141, 4, 70, "Input",
 CellID->143667753],
Cell[6517, 211, 234, 9, 70, "ExampleText",
 CellID->50207010],
Cell[6754, 222, 104, 3, 70, "Input",
 CellID->17765249],
Cell[6861, 227, 145, 5, 70, "ExampleText",
 CellID->68552961],
Cell[7009, 234, 259, 8, 70, "Input",
 CellID->29606283],
Cell[7271, 244, 80, 1, 70, "ExampleText",
 CellID->209519034],
Cell[CellGroupData[{
Cell[7376, 249, 117, 3, 70, "Input",
 CellID->437240327],
Cell[7496, 254, 95, 5, 70, "Print",
 CellID->168154159]
}, Open  ]],
Cell[7606, 262, 92, 1, 70, "ExampleText",
 CellID->335362708],
Cell[7701, 265, 310, 11, 70, "Input",
 CellID->255890],
Cell[CellGroupData[{
Cell[8036, 280, 117, 3, 70, "Input",
 CellID->484245824],
Cell[8156, 285, 188, 10, 70, "Print",
 CellID->430781567]
}, Open  ]],
Cell[8359, 298, 76, 1, 70, "ExampleText",
 CellID->224705661],
Cell[8438, 301, 123, 4, 70, "Input",
 CellID->490378145]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8610, 311, 311, 9, 70, "SeeAlsoSection",
 CellID->28685],
Cell[8924, 322, 670, 26, 70, "SeeAlso",
 CellID->172]
}, Open  ]],
Cell[CellGroupData[{
Cell[9631, 353, 313, 9, 70, "TutorialsSection",
 CellID->1035],
Cell[9947, 364, 458, 12, 70, "Tutorials",
 CellID->16116],
Cell[10408, 378, 429, 12, 70, "Tutorials",
 CellID->17938]
}, Open  ]],
Cell[CellGroupData[{
Cell[10874, 395, 317, 9, 70, "MoreAboutSection",
 CellID->8417393],
Cell[11194, 406, 149, 3, 70, "MoreAbout",
 CellID->213946530],
Cell[11346, 411, 120, 3, 70, "MoreAbout",
 CellID->3185932],
Cell[11469, 416, 310, 9, 70, "MoreAbout",
 CellID->206827828],
Cell[11782, 427, 297, 9, 70, "MoreAbout",
 CellID->144081361]
}, Open  ]],
Cell[12094, 439, 27, 0, 70, "History"],
Cell[12124, 441, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

