(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     67030,       2270]
NotebookOptionsPosition[     57972,       1951]
NotebookOutlinePosition[     59402,       1990]
CellTagsIndexPosition[     59316,       1985]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Matrix Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedMatrixOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Advanced Matrix Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SchurDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SchurDecomposition"], 
          "LUDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/LUDecomposition"], 
          "SingularValueDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SingularValueDecomposition"], 
          "JordanDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/JordanDecomposition"], 
          "CholeskyDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/CholeskyDecomposition"], 
          "Orthogonalize" :> 
          Documentation`HelpLookup["paclet:ref/Orthogonalize"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SchurDecomposition\"\>", 
       2->"\<\"LUDecomposition\"\>", 3->"\<\"SingularValueDecomposition\"\>", 
       4->"\<\"JordanDecomposition\"\>", 5->"\<\"CholeskyDecomposition\"\>", 
       6->"\<\"Orthogonalize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Matrix Decompositions" :> 
          Documentation`HelpLookup["paclet:guide/MatrixDecompositions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Matrix-Based Minimization\"\>", 
       3->"\<\"Matrix Decompositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["QRDecomposition", "ObjectName",
 CellID->22857],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["QRDecomposition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/QRDecomposition"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields the QR decomposition for a numerical matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". The result is a list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["q", "TI"], ",", 
        StyleBox["r", "TI"]}], "}"}]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " is an orthogonal matrix and ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " is an upper\[Hyphen]triangular matrix. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27857]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The original matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["q", "TI"], "]"}], "]"}], ".", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->140729825,
  ButtonNote->"140729825"]
}], "Notes",
 CellID->3069],

Cell[TextData[{
 "For non\[Hyphen]square matrices, ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " is row orthonormal. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->37047504,
  ButtonNote->"37047504"]
}], "Notes",
 CellID->21922],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " has zeros for all entries below the leading diagonal. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->552222845,
  ButtonNote->"552222845"]
}], "Notes",
 CellID->9704],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["QRDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QRDecomposition"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{"Pivoting", "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " yields a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["q", "TI"], ",", 
    StyleBox["r", "TI"], ",", 
    StyleBox["p", "TI"]}], "}"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is a permutation matrix such that ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], ".", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["q", "TI"], "]"}], "]"}], ".", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->272584853,
  ButtonNote->"272584853"]
}], "Notes",
 CellID->1381]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->717570124],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->131116324],

Cell["\<\
Compute the QR decomposition for a 3\[Times]2 matrix with exact values:\
\>", "ExampleText",
 CellID->204103724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QRDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59311610],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["35"]], ",", 
       FractionBox["3", 
        SqrtBox["35"]], ",", 
       SqrtBox[
        FractionBox["5", "7"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["13", 
        SqrtBox["210"]], ",", 
       RowBox[{"2", " ", 
        SqrtBox[
         FractionBox["2", "105"]]}], ",", 
       RowBox[{"-", 
        SqrtBox[
         FractionBox["5", "42"]]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SqrtBox["35"], ",", 
       RowBox[{
        RowBox[{"6", " ", 
         SqrtBox[
          FractionBox["5", "7"]]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox[
          FractionBox["7", "5"]]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"2", " ", 
        SqrtBox[
         FractionBox["6", "35"]]}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{360, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44621739]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16964659],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", 
         SqrtBox["35"]], 
        FractionBox["3", 
         SqrtBox["35"]], 
        SqrtBox[
         FractionBox["5", "7"]]},
       {
        FractionBox["13", 
         SqrtBox["210"]], 
        RowBox[{"2", " ", 
         SqrtBox[
          FractionBox["2", "105"]]}], 
        RowBox[{"-", 
         SqrtBox[
          FractionBox["5", "42"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SqrtBox["35"], 
        RowBox[{
         RowBox[{"6", " ", 
          SqrtBox[
           FractionBox["5", "7"]]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox[
           FractionBox["7", "5"]]}]}]},
       {"0", 
        RowBox[{"2", " ", 
         SqrtBox[
          FractionBox["6", "35"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{343, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->594178350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145821412],

Cell["\<\
Compute the QR decomposition for a 2\[Times]3 matrix with approximate \
numerical values:\
\>", "ExampleText",
 CellID->228944392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QRDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.", ",", "2.", ",", "3."}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4.", ",", "5.", ",", "6."}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207145909],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.24253562503633308`"}], ",", 
       RowBox[{"-", "0.970142500145332`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.970142500145332`"}], ",", "0.24253562503633289`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.123105625617661`"}], ",", 
       RowBox[{"-", "5.335783750799326`"}], ",", 
       RowBox[{"-", "6.5484618759809905`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "0.7276068751089995`"}], ",", 
       RowBox[{"-", "1.455213750217998`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{421, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->543172755]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16183523],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWs1y0zAQVmzHpGmahKQUKD30QZiBA1NOPESmw0x7YGBK3wI48FYceCdj
2dpE/vzZkhzbHTqT2itptT/6tFqv/Wn3ePf5y+7x/nZ3/fFh9+3u/vb79c3X
h7wpnig1+aGUunql8vssvyt++u9n/itvy7uF/h9Lb6Z+Ab0F+g/Qp8Usp9Cq
Z9Vkkl8jc9V0CuNi066v0/w6NXRkrmwee1zBqMo/mSe25Ml1BXKfAz0FOe+B
Rr0jo0fSYI/InUL/xvDFZt5nYK/wiT9EDsqfF2aLdiilWI3pnjYusmWizmhb
nRstLTRKDrSqzTNr1SKhvQ2zdmsBPLatP9dGdH3X2suw4fYfH+XHew60aDLr
xVcR0GzP7lFX40YsCpJjatkZGc093aahplOyDzgC50RmKr632nGfJE7PdUPZ
21YP4Zx0dbjHWnVF+iQ7RFZsZ77ltqDPEDs4S2FNTRfE+4LK0uuYiGadMNMQ
f5wIwtMuIGIG4Ql3B55i3PIPtBVxRPdtDzjCfOHEy880Orb0073ZE664xt1Q
VvefnNn8jKa7vcLPdpBkGpHRSDOsYVyf2EE/ApKNBjyeof6Il3nNYsyp2Hn0
tNhw50JtePaPOxgPIjYL17miHfr8GGygTg5sNGqJHtgAbcdctvNcEcLrdB8U
JcdkfIgXzjUP0MZvRhrtnaMw9rBcoyvejvetn02cFzPvUFRyWcOcbnpnavI0
qz5T2vFUngcjq30BfCn0a77EouXZGaOIPCdgvp2a8TfmOge9RE/7Wdhu35p5
l1n1xItBL7EP0dbNm78d/TOg/3pJxaiEpyOTymxCaTjPpJAm1ZKMYAwl4Wqi
BL2Kk5zUM0862eKSwG0IXSeXlH7Q8D9LkThxbI3tnMzTlK/Z+xlrfriT0Oq1
Nd7WV2plOL+0b0E/u+ZnX1kFQ5NvGvjTrKo/0mhPn5nG01TT1q26jFVfxHWi
Nd7KU4l/tS48K9O3m1a/8DU6Rj4f9bqDFm5vu6sVtEIUjHPZzTxTGq52N2uV
O2yd0oXkqaVb2uCFkGcf9LlkYMiHdS4X/v28sgrydLqfosxbavVPR38/qOTR
d6w6II+3Y9Q/Xcg88/KLywMufF4APQwuX9JRhYUDnKFD4rK/KuKWzj9OhdSV
By5rnIgLlsmx96XoVckUF9b4toxWvHdpvCZPznxn857I8Ppli2FvfvuqG140
jxuhJoqewLdrS+BHNBz7zgGrpks23sOLNO7gnm5AsVI+ueF+FOQ3jXuh5iuO
o/EriSHxZ/j6KiIoFIF9PmvQ9yYjVEAvgbct5vqj1ZXBlt+7NH1lFFqp3AKf
b2UUtcL1X2WHimdThcE+T14Y/eZkXKLqFY2r7FAxTVT1tLbtbzqnSi/288WX
vi2/IFOTfz6/EnM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{395, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->182491623]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9247],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3\[Times]4 matrix:"
}], "ExampleText",
 CellID->2857946],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "2", "3", "4"},
       {"1", "4", "9", "16"},
       {"1", "8", "27", "64"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103520881],

Cell["QR decomposition computed with exact arithmetic:", "ExampleText",
 CellID->416160638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QRDecomposition", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->109680424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["3"]], ",", 
       FractionBox["1", 
        SqrtBox["3"]], ",", 
       FractionBox["1", 
        SqrtBox["3"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SqrtBox[
         FractionBox["2", "21"]]}], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["42"]]}], ",", 
       FractionBox["5", 
        SqrtBox["42"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SqrtBox[
        FractionBox["2", "7"]], ",", 
       RowBox[{"-", 
        FractionBox["3", 
         SqrtBox["14"]]}], ",", 
       FractionBox["1", 
        SqrtBox["14"]]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SqrtBox["3"], ",", 
       RowBox[{
        FractionBox["8", 
         SqrtBox["3"]], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"]}]}], ",", 
       RowBox[{"13", " ", 
        SqrtBox["3"]}], ",", 
       RowBox[{"28", " ", 
        SqrtBox["3"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"2", " ", 
        SqrtBox[
         FractionBox["14", "3"]]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SqrtBox[
          FractionBox["6", "7"]]}], "+", 
        RowBox[{"3", " ", 
         SqrtBox["42"]}]}], ",", 
       RowBox[{"48", " ", 
        SqrtBox[
         FractionBox["6", "7"]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"3", " ", 
        SqrtBox[
         FractionBox["2", "7"]]}], ",", 
       RowBox[{"12", " ", 
        SqrtBox[
         FractionBox["2", "7"]]}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{490, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->276047578]
}, Open  ]],

Cell["QR decomposition computed with machine arithmetic: ", "ExampleText",
 CellID->241810472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QRDecomposition", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->629839637],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5773502691896257`"}], ",", 
       RowBox[{"-", "0.5773502691896257`"}], ",", 
       RowBox[{"-", "0.5773502691896257`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6172133998483676`", ",", "0.15430334996209188`", ",", 
       RowBox[{"-", "0.7715167498104596`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5345224838248488`", ",", 
       RowBox[{"-", "0.8017837257372732`"}], ",", "0.2672612419124244`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.7320508075688774`"}], ",", 
       RowBox[{"-", "8.082903768654761`"}], ",", 
       RowBox[{"-", "22.516660498395407`"}], ",", 
       RowBox[{"-", "48.49742261192856`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "4.320493798938573`"}], ",", 
       RowBox[{"-", "17.59058189567848`"}], ",", 
       RowBox[{"-", "44.439364789082475`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.`", ",", "0.`", ",", "1.6035674514745448`", ",", 
       "6.41426980589818`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{530, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->473642142]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->310124422],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.5773502691896257`"}], 
        RowBox[{"-", "0.5773502691896257`"}], 
        RowBox[{"-", "0.5773502691896257`"}]},
       {"0.6172133998483676`", "0.15430334996209188`", 
        RowBox[{"-", "0.7715167498104596`"}]},
       {"0.5345224838248488`", 
        RowBox[{"-", "0.8017837257372732`"}], "0.2672612419124244`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "1.7320508075688774`"}], 
        RowBox[{"-", "8.082903768654761`"}], 
        RowBox[{"-", "22.516660498395407`"}], 
        RowBox[{"-", "48.49742261192856`"}]},
       {"0.`", 
        RowBox[{"-", "4.320493798938573`"}], 
        RowBox[{"-", "17.59058189567848`"}], 
        RowBox[{"-", "44.439364789082475`"}]},
       {"0.`", "0.`", "1.6035674514745448`", "6.41426980589818`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{522, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->230144930]
}, Open  ]],

Cell["QR decomposition computed with 24-digit arithmetic:", "ExampleText",
 CellID->212610800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QRDecomposition", "[", 
  RowBox[{"N", "[", 
   RowBox[{"m", ",", "24"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->585712200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.57735026918962576450914878050195745565`24."}], ",", 
       RowBox[{"-", "0.57735026918962576450914878050195745565`24."}], ",", 
       RowBox[{"-", "0.57735026918962576450914878050195745565`24."}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "0.61721339984836764104437785105592665699`24.", ",", 
       "0.15430334996209191026109446276423090559`24.", ",", 
       RowBox[{"-", "0.77151674981045955130547231382015756257`24."}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"0.5345224838248487693691069617598527581`24.", ",", 
       RowBox[{"-", "0.80178372573727315405366044263926525576`24."}], ",", 
       "0.26726124191242438468455348087941249765`24."}], "}"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.73205080756887729352744634150587236694`24."}], ",", 
       RowBox[{"-", "8.08290376865476070312808292703080150464`24."}], ",", 
       RowBox[{"-", "22.51666049839540481585680243956662318759`24."}], ",", 
       RowBox[{"-", "48.49742261192856421876849756216716481881`24."}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4.32049379893857348731064495739018269222`24."}], ",", 
       RowBox[{"-", "17.59058189567847776976476875510219853508`24."}], ",", 
       RowBox[{"-", "44.43936478908247015519520527603966932495`24."}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "1.60356745147454630810732088526701537615`24.", ",",
        "6.41426980589818523242928354109257924887`24."}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{444, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->42950982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90557245],

Cell["\<\
QR decomposition for a 3\[Times]3 matrix with random complex entries:\
\>", "ExampleText",
 CellID->74651653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QRDecomposition", "[", 
  RowBox[{"RandomComplex", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"1", "+", "I"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166142312],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.1684525033593649`"}], "+", 
        RowBox[{"0.038667962838671625`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.4869453629533654`"}], "+", 
        RowBox[{"0.6469352532566169`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.35722288166506083`"}], "+", 
        RowBox[{"0.4322954396807726`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.5164969929240049`"}], "+", 
        RowBox[{"0.6901802631237761`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.18983824358409263`"}], "+", 
        RowBox[{"0.0819563226808786`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.27597024647730084`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.37143920929224483`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.11488943210353524`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.4623970391856477`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.13539081750105786`"}], "-", 
        RowBox[{"0.5322338964909524`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.045580076247284426`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.6850607704102016`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1.2844958019643666`"}], "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.7716774142889902`"}], "+", 
        RowBox[{"0.37133770592582116`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "1.309420626100653`"}], "-", 
        RowBox[{"0.01903248573391353`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.4114338203545199`"}], "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.06327980482072765`"}], "+", 
        RowBox[{"0.5333051402807905`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.4053153399353979`"}], "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{492, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->343299579]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102577554],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "0.1684525033593649`"}], "+", 
         RowBox[{"0.038667962838671625`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.4869453629533654`"}], "+", 
         RowBox[{"0.6469352532566169`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.35722288166506083`"}], "+", 
         RowBox[{"0.4322954396807726`", " ", "\[ImaginaryI]"}]}]},
       {
        RowBox[{
         RowBox[{"-", "0.5164969929240049`"}], "+", 
         RowBox[{"0.6901802631237761`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.18983824358409263`"}], "+", 
         RowBox[{"0.0819563226808786`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"0.27597024647730084`", "\[InvisibleSpace]", "-", 
         RowBox[{"0.37143920929224483`", " ", "\[ImaginaryI]"}]}]},
       {
        RowBox[{"0.11488943210353524`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.4623970391856477`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.13539081750105786`"}], "-", 
         RowBox[{"0.5322338964909524`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"0.045580076247284426`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.6850607704102016`", " ", "\[ImaginaryI]"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "1.2844958019643666`"}], "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.7716774142889902`"}], "+", 
         RowBox[{"0.37133770592582116`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "1.309420626100653`"}], "-", 
         RowBox[{"0.01903248573391353`", " ", "\[ImaginaryI]"}]}]},
       {
        RowBox[{"0.`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.4114338203545199`"}], "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.06327980482072765`"}], "+", 
         RowBox[{"0.5333051402807905`", " ", "\[ImaginaryI]"}]}]},
       {
        RowBox[{"0.`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"0.`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.4053153399353979`"}], "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{493, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->519491399]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12613],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Pivoting",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12700],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "2", "3", "4"},
       {"1", "4", "9", "16"},
       {"1", "8", "27", "64"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->678394638],

Cell["\<\
Compute the QR decomposition using machine arithmetic with pivoting:\
\>", "ExampleText",
 CellID->23133878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"qt", ",", "r", ",", "p"}], "}"}], "=", 
  RowBox[{"QRDecomposition", "[", 
   RowBox[{
    RowBox[{"N", "[", "m", "]"}], ",", 
    RowBox[{"Pivoting", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192079013],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.06052275326688017`"}], ",", 
       RowBox[{"-", "0.24209101306752098`"}], ",", 
       RowBox[{"-", "0.9683640522700839`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5040525320835957`"}], ",", 
       RowBox[{"-", "0.8299485657583315`"}], ",", "0.23899042469480752`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8615497903412851`"}], ",", "0.5025707110324179`", ",", 
       
       RowBox[{"-", "0.07179581586177433`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "66.09084656743322`"}], ",", 
       RowBox[{"-", "28.506216788700595`"}], ",", 
       RowBox[{"-", "1.2709778186044849`"}], ",", 
       RowBox[{"-", "8.836321976964516`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "2.528953221315967`"}], ",", 
       RowBox[{"-", "1.0950106731471196`"}], ",", 
       RowBox[{"-", "2.415975929642057`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", 
       RowBox[{"-", "0.4307748951706412`"}], ",", 
       RowBox[{"-", "0.2871832634470935`"}]}], "}"}]}], "}"}], ",", 
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 4, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "4"}], "}"}]}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{543, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->301336919]
}, Open  ]],

Cell[TextData[{
 "The elements along the diagonal of ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " are in order of decreasing magnitude:"
}], "ExampleText",
 CellID->433995988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "r", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->203769671],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "66.09084656743322`"}], 
      RowBox[{"-", "28.506216788700595`"}], 
      RowBox[{"-", "1.2709778186044849`"}], 
      RowBox[{"-", "8.836321976964516`"}]},
     {"0.`", 
      RowBox[{"-", "2.528953221315967`"}], 
      RowBox[{"-", "1.0950106731471196`"}], 
      RowBox[{"-", "2.415975929642057`"}]},
     {"0.`", "0.`", 
      RowBox[{"-", "0.4307748951706412`"}], 
      RowBox[{"-", "0.2871832634470935`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{290, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->15685389]
}, Open  ]],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " is a permutation matrix:"
}], "ExampleText",
 CellID->50527475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "p", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->318733994],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmC9vg0AUwA8Y69q1frJfY2Zyq9mHIM2SVixbugocElmJ5CMgkUgkEolE
IpHs3b8dvV4T2HqhyWgCd1xe7wfvH+/x6uw3b+/Ofrt2li8753OzXX8tnz92
sGQZCKEVHI8PCOYNzMixahoY22cbn60wDBvyQyacbBC9h9GCcS6NEyLveR6T
t8guN2Sa53kcx3hKd8VEKjUjiz/X5D+o1+otv88sy2RuEARMUBe3rmvXdQXX
4qsUzaQuyaV69n0fINwulGumaTrRxAPzgRGPeUS/ZVnqfE7hOW2u8DJdXFAu
df0zXOxPJkgvGnU0TLl+mLyh3OVJuv6/UjbTG84uqiwz7bQLifoTi86b3/vI
3cgduYNxeVRgkirbdIuKa4354bKMnK151vmLN/Sxvuw5I3fkDsc9FxU868w6
7XKtMd9H6nA4dJASPVFbCmq9qqpU+pRrGmqVoiiiKMLTdoUJxS7rY/p4Q7c3
Ea1skyRRVPJw6+xudHFBt0cdi9yhWZq4wnqCa4KOL/+cuBcxQYtkZ9Zxiucz
tfBONMi4tC3TyRUEylV9F2jXLAsiRb8tIOMbVOqSQQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->665443000]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["QRDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QRDecomposition"]], "InlineFormula"],
 " satisfies ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ".", "p"}], "==", 
   RowBox[{
    RowBox[{
     ButtonBox["ConjugateTranspose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ConjugateTranspose"], "[", "q", "]"}], ".", 
    "r"}]}]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->272584853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Transpose", "[", "qt", "]"}], ".", "r"}], "-", 
   RowBox[{"m", ".", "p"}]}], "//", "Chop"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31211110],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->377566563]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2944],

Cell["Here is some data:", "ExampleText",
 CellID->24734542],

Cell[BoxData[{
 RowBox[{
  RowBox[{"times", "=", 
   RowBox[{"{", 
    RowBox[{"1.", ",", "2.", ",", "3.", ",", "4.", ",", ".5"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"5.", ",", "2.", ",", "3.", ",", "6.", ",", "10."}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"times", ",", "b"}], "}"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->329439179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->415160489],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 5.}, {2., 2.}, {3., 3.}, {4., 6.}, {0.5, 10.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 4.}, {2., 10.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26164760]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is a design matrix for fitting with basis functions ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["t", "2"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->25547681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.", ",", "t", ",", 
        RowBox[{"t", "^", "2"}]}], "}"}]}], "]"}], ",", "times"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->81545202],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "2.`", ",", "4.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "3.`", ",", "9.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "4.`", ",", "16.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.5`", ",", "0.25`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->65994737]
}, Open  ]],

Cell[TextData[{
 "Find the QR decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->181216498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "r"}], "}"}], "=", 
  RowBox[{"QRDecomposition", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->99405816],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.44721359549995787`"}], ",", 
       RowBox[{"-", "0.44721359549995787`"}], ",", 
       RowBox[{"-", "0.44721359549995787`"}], ",", 
       RowBox[{"-", "0.44721359549995787`"}], ",", 
       RowBox[{"-", "0.44721359549995787`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3841366626732681`", ",", "0.034921514788478845`", ",", 
       RowBox[{"-", "0.31429363309631025`"}], ",", 
       RowBox[{"-", "0.6635087809810994`"}], ",", "0.5587442366156624`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.05057645303874734`"}], ",", 
       RowBox[{"-", "0.578330745616981`"}], ",", 
       RowBox[{"-", "0.3848208383382955`"}], ",", "0.5299532687973095`", ",", 
       "0.4837747681967143`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.23606797749979`"}], ",", 
       RowBox[{"-", "4.695742752749558`"}], ",", 
       RowBox[{"-", "13.528211263873725`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "2.863564212655271`"}], ",", 
       RowBox[{"-", "12.781274412583283`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "2.7729090122548006`"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{538, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->71767808]
}, Open  ]],

Cell[TextData[{
 "This finds a vector ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " such that ",
 Cell[BoxData[
  SubscriptBox[
   RowBox[{"\[LeftDoubleBracketingBar]", 
    RowBox[{
     RowBox[{
      StyleBox["m", "TI"], ".", 
      StyleBox["x", "TI"]}], " ", "-", " ", 
     StyleBox["b", "TI"]}], "\[RightDoubleBracketingBar]"}], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " is a minimum:"
}], "ExampleText",
 CellID->128659230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{"r", ",", 
   RowBox[{"q", ".", "b"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->312416862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"13.681998413957182`", ",", 
   RowBox[{"-", "9.704996034892948`"}], ",", "1.9666931007137207`"}], 
  "}"}]], "Output",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->10844076]
}, Open  ]],

Cell["These are the coefficients for the least-squares fit:", "ExampleText",
 CellID->56575746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "t", ",", 
     RowBox[{"t", "^", "2"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->807180684],

Cell[BoxData[
 RowBox[{"13.681998413957176`", "\[InvisibleSpace]", "-", 
  RowBox[{"9.704996034892947`", " ", "t"}], "+", 
  RowBox[{"1.9666931007137203`", " ", 
   SuperscriptBox["t", "2"]}]}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->92790362]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{"%", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"ListPlot", "[", "data", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->21751438],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->57597659]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20747],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3\[Times]4 matrix:"
}], "ExampleText",
 CellID->26543006],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "2", "3", "4"},
       {"1", "4", "9", "16"},
       {"1", "8", "27", "64"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58817970],

Cell["Compute the QR decomposition:", "ExampleText",
 CellID->326727450],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"q", ",", "r"}], "}"}], "=", 
   RowBox[{"QRDecomposition", "[", 
    RowBox[{"N", "[", "m", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10705564],

Cell[TextData[{
 "The rows of ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " are orthonormal:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->37047504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"q", ".", 
   RowBox[{"ConjugateTranspose", "[", "q", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->710247385],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->147142199]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " is upper triangular:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->552222845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayRules", "[", "r", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->545002862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
    RowBox[{"-", "1.7320508075688774`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
    RowBox[{"-", "8.082903768654761`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
    RowBox[{"-", "22.516660498395407`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", 
    RowBox[{"-", "48.49742261192856`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
    RowBox[{"-", "4.320493798938573`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
    RowBox[{"-", "17.59058189567848`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", 
    RowBox[{"-", "44.439364789082475`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "1.6035674514745448`"}], ",", 
   
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "6.41426980589818`"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "0"}]}], "}"}]], "Output",
 ImageSize->{434, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->274189468]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"%", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
    RowBox[{"i", ">", "j"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->49362948],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->50341905]
}, Open  ]],

Cell[TextData[{
 " ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["q", "TI"], "]"}], "]"}], ".", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->140729825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"m", "-", 
   RowBox[{
    RowBox[{"ConjugateTranspose", "[", "q", "]"}], ".", "r"}]}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2225516],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->202988652]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18574],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SchurDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SchurDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LUDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LUDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SingularValueDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SingularValueDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JordanDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JordanDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CholeskyDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CholeskyDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Orthogonalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Orthogonalize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11046]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11821],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "Tutorials",
 CellID->30089]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->21517],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#4987"], None}]], "RelatedLinks",
 CellID->28073]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->246357476],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->374012730],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "MoreAbout",
 CellID->277222927],

Cell[TextData[ButtonBox["Matrix Decompositions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixDecompositions"]], "MoreAbout",
 CellID->106313168]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"QRDecomposition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 25.0620386}", "context" -> "System`", 
    "keywords" -> {
     "Givens rotations", "Householder reflections", 
      "orthogonal decomposition", "QR decomposition"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "QRDecomposition[m] yields the QR decomposition for a numerical matrix m. \
The result is a list {q, r}, where q is an orthogonal matrix and r is an \
upper-triangular matrix. ", "synonyms" -> {"qr"}, "title" -> 
    "QRDecomposition", "type" -> "Symbol", "uri" -> "ref/QRDecomposition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7486, 247, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->717570124]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 59173, 1978}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2854, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3477, 92, 53, 1, 70, "ObjectName",
 CellID->22857],
Cell[3533, 95, 985, 30, 70, "Usage",
 CellID->27857]
}, Open  ]],
Cell[CellGroupData[{
Cell[4555, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5033, 147, 606, 23, 70, "Notes",
 CellID->3069],
Cell[5642, 172, 276, 10, 70, "Notes",
 CellID->21922],
Cell[5921, 184, 289, 10, 70, "Notes",
 CellID->9704],
Cell[6213, 196, 1236, 46, 70, "Notes",
 CellID->1381]
}, Closed]],
Cell[CellGroupData[{
Cell[7486, 247, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->717570124],
Cell[CellGroupData[{
Cell[7871, 261, 148, 5, 70, "ExampleSection",
 CellID->131116324],
Cell[8022, 268, 122, 3, 70, "ExampleText",
 CellID->204103724],
Cell[CellGroupData[{
Cell[8169, 275, 320, 11, 28, "Input",
 CellID->59311610],
Cell[8492, 288, 1135, 44, 102, "Output",
 CellID->44621739]
}, Open  ]],
Cell[CellGroupData[{
Cell[9664, 337, 130, 4, 28, "Input",
 CellID->16964659],
Cell[9797, 343, 2019, 66, 104, "Output",
 CellID->594178350]
}, Open  ]],
Cell[11831, 412, 125, 3, 70, "ExampleDelimiter",
 CellID->145821412],
Cell[11959, 417, 140, 4, 70, "ExampleText",
 CellID->228944392],
Cell[CellGroupData[{
Cell[12124, 425, 286, 9, 70, "Input",
 CellID->207145909],
Cell[12413, 436, 889, 29, 54, "Output",
 CellID->543172755]
}, Open  ]],
Cell[CellGroupData[{
Cell[13339, 470, 130, 4, 28, "Input",
 CellID->16183523],
Cell[13472, 476, 1631, 31, 49, "Output",
 Evaluatable->False,
 CellID->182491623]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15152, 513, 215, 7, 70, "ExampleSection",
 CellID->9247],
Cell[15370, 522, 137, 5, 70, "ExampleText",
 CellID->2857946],
Cell[15510, 529, 761, 22, 70, "Input",
 CellID->103520881],
Cell[16274, 553, 91, 1, 70, "ExampleText",
 CellID->416160638],
Cell[CellGroupData[{
Cell[16390, 558, 111, 3, 70, "Input",
 CellID->109680424],
Cell[16504, 563, 1947, 74, 136, "Output",
 CellID->276047578]
}, Open  ]],
Cell[18466, 640, 94, 1, 70, "ExampleText",
 CellID->241810472],
Cell[CellGroupData[{
Cell[18585, 645, 139, 4, 70, "Input",
 CellID->629839637],
Cell[18727, 651, 1353, 38, 71, "Output",
 CellID->473642142]
}, Open  ]],
Cell[CellGroupData[{
Cell[20117, 694, 131, 4, 70, "Input",
 CellID->310124422],
Cell[20251, 700, 2078, 55, 64, "Output",
 CellID->230144930]
}, Open  ]],
Cell[22344, 758, 94, 1, 70, "ExampleText",
 CellID->212610800],
Cell[CellGroupData[{
Cell[22463, 763, 164, 5, 70, "Input",
 CellID->585712200],
Cell[22630, 770, 1854, 46, 190, "Output",
 CellID->42950982]
}, Open  ]],
Cell[24499, 819, 124, 3, 70, "ExampleDelimiter",
 CellID->90557245],
Cell[24626, 824, 119, 3, 70, "ExampleText",
 CellID->74651653],
Cell[CellGroupData[{
Cell[24770, 831, 304, 10, 70, "Input",
 CellID->166142312],
Cell[25077, 843, 2905, 77, 122, "Output",
 CellID->343299579]
}, Open  ]],
Cell[CellGroupData[{
Cell[28019, 925, 131, 4, 70, "Input",
 CellID->102577554],
Cell[28153, 931, 3670, 91, 108, "Output",
 CellID->519491399]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31872, 1028, 218, 7, 70, "ExampleSection",
 CellID->12613],
Cell[CellGroupData[{
Cell[32115, 1039, 225, 7, 70, "ExampleSubsection",
 CellID->12700],
Cell[32343, 1048, 761, 22, 70, "Input",
 CellID->678394638],
Cell[33107, 1072, 118, 3, 70, "ExampleText",
 CellID->23133878],
Cell[CellGroupData[{
Cell[33250, 1079, 287, 9, 70, "Input",
 CellID->192079013],
Cell[33540, 1090, 1797, 53, 88, "Output",
 CellID->301336919]
}, Open  ]],
Cell[35352, 1146, 193, 6, 70, "ExampleText",
 CellID->433995988],
Cell[CellGroupData[{
Cell[35570, 1156, 106, 3, 70, "Input",
 CellID->203769671],
Cell[35679, 1161, 1134, 32, 78, "Output",
 CellID->15685389]
}, Open  ]],
Cell[36828, 1196, 162, 6, 70, "ExampleText",
 CellID->50527475],
Cell[CellGroupData[{
Cell[37015, 1206, 106, 3, 70, "Input",
 CellID->318733994],
Cell[37124, 1211, 816, 17, 70, "Output",
 Evaluatable->False,
 CellID->665443000]
}, Open  ]],
Cell[37955, 1231, 512, 18, 70, "ExampleText",
 CellID->272584853],
Cell[CellGroupData[{
Cell[38492, 1253, 205, 7, 70, "Input",
 CellID->31211110],
Cell[38700, 1262, 421, 13, 36, "Output",
 CellID->377566563]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[39182, 1282, 222, 7, 70, "ExampleSection",
 CellID->2944],
Cell[39407, 1291, 60, 1, 70, "ExampleText",
 CellID->24734542],
Cell[39470, 1294, 488, 17, 70, "Input",
 CellID->329439179],
Cell[CellGroupData[{
Cell[39983, 1315, 107, 3, 70, "Input",
 CellID->415160489],
Cell[40093, 1320, 473, 15, 143, "Output",
 CellID->26164760]
}, Open  ]],
Cell[40581, 1338, 411, 15, 70, "ExampleText",
 CellID->25547681],
Cell[CellGroupData[{
Cell[41017, 1357, 338, 12, 70, "Input",
 CellID->81545202],
Cell[41358, 1371, 562, 17, 36, "Output",
 CellID->65994737]
}, Open  ]],
Cell[41935, 1391, 150, 6, 70, "ExampleText",
 CellID->181216498],
Cell[CellGroupData[{
Cell[42110, 1401, 180, 6, 70, "Input",
 CellID->99405816],
Cell[42293, 1409, 1512, 41, 88, "Output",
 CellID->71767808]
}, Open  ]],
Cell[43820, 1453, 454, 16, 70, "ExampleText",
 CellID->128659230],
Cell[CellGroupData[{
Cell[44299, 1473, 154, 5, 70, "Input",
 CellID->312416862],
Cell[44456, 1480, 288, 9, 36, "Output",
 CellID->10844076]
}, Open  ]],
Cell[44759, 1492, 95, 1, 70, "ExampleText",
 CellID->56575746],
Cell[CellGroupData[{
Cell[44879, 1497, 220, 7, 70, "Input",
 CellID->807180684],
Cell[45102, 1506, 335, 9, 36, "Output",
 CellID->92790362]
}, Open  ]],
Cell[CellGroupData[{
Cell[45474, 1520, 310, 10, 70, "Input",
 CellID->21751438],
Cell[45787, 1532, 2469, 45, 70, "Output",
 Evaluatable->False,
 CellID->57597659]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48305, 1583, 233, 7, 70, "ExampleSection",
 CellID->20747],
Cell[48541, 1592, 138, 5, 70, "ExampleText",
 CellID->26543006],
Cell[48682, 1599, 760, 22, 70, "Input",
 CellID->58817970],
Cell[49445, 1623, 72, 1, 70, "ExampleText",
 CellID->326727450],
Cell[49520, 1626, 231, 8, 70, "Input",
 CellID->10705564],
Cell[49754, 1636, 196, 7, 70, "ExampleText",
 CellID->37047504],
Cell[CellGroupData[{
Cell[49975, 1647, 169, 5, 70, "Input",
 CellID->710247385],
Cell[50147, 1654, 397, 13, 36, "Output",
 CellID->147142199]
}, Open  ]],
Cell[50559, 1670, 184, 6, 70, "ExampleText",
 CellID->552222845],
Cell[CellGroupData[{
Cell[50768, 1680, 106, 3, 70, "Input",
 CellID->545002862],
Cell[50877, 1685, 1394, 45, 71, "Output",
 CellID->274189468]
}, Open  ]],
Cell[CellGroupData[{
Cell[52308, 1735, 308, 11, 70, "Input",
 CellID->49362948],
Cell[52619, 1748, 174, 6, 36, "Output",
 CellID->50341905]
}, Open  ]],
Cell[52808, 1757, 531, 20, 70, "ExampleText",
 CellID->140729825],
Cell[CellGroupData[{
Cell[53364, 1781, 195, 7, 70, "Input",
 CellID->2225516],
Cell[53562, 1790, 421, 13, 36, "Output",
 CellID->202988652]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54044, 1810, 311, 9, 70, "SeeAlsoSection",
 CellID->18574],
Cell[54358, 1821, 1559, 53, 70, "SeeAlso",
 CellID->11046]
}, Open  ]],
Cell[CellGroupData[{
Cell[55954, 1879, 314, 9, 70, "TutorialsSection",
 CellID->11821],
Cell[56271, 1890, 161, 3, 70, "Tutorials",
 CellID->30089]
}, Open  ]],
Cell[CellGroupData[{
Cell[56469, 1898, 321, 9, 70, "RelatedLinksSection",
 CellID->21517],
Cell[56793, 1909, 266, 6, 70, "RelatedLinks",
 CellID->28073]
}, Open  ]],
Cell[CellGroupData[{
Cell[57096, 1920, 319, 9, 70, "MoreAboutSection",
 CellID->246357476],
Cell[57418, 1931, 163, 3, 70, "MoreAbout",
 CellID->374012730],
Cell[57584, 1936, 160, 3, 70, "MoreAbout",
 CellID->277222927],
Cell[57747, 1941, 153, 3, 70, "MoreAbout",
 CellID->106313168]
}, Open  ]],
Cell[57915, 1947, 27, 0, 70, "History"],
Cell[57945, 1949, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

