(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16462,        585]
NotebookOptionsPosition[     12608,        454]
NotebookOutlinePosition[     13913,        491]
CellTagsIndexPosition[     13828,        486]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/ContinuedFraction"], "Element" :> 
          Documentation`HelpLookup["paclet:ref/Element"], "RootReduce" :> 
          Documentation`HelpLookup["paclet:ref/RootReduce"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ContinuedFraction\"\>", 
       2->"\<\"Element\"\>", 3->"\<\"RootReduce\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumbers"], 
          "Continued Fractions & Rational Approximations" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuedFractionsAndRationalApproximations"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Numbers\"\>", 
       2->"\<\"Continued Fractions & Rational Approximations\"\>", 
       3->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["QuadraticIrrationalQ", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["QuadraticIrrationalQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/QuadraticIrrationalQ"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is a quadratic irrational and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14930]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["QuadraticIrrationalQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QuadraticIrrationalQ"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " tests whether ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " can be expressed in the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "\[PlusMinus]", 
      SqrtBox["b"]}], ")"}], "/", "c"}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " are integers. "
}], "Notes",
 CellID->522345192],

Cell["\<\
Quadratic irrationals have continued fractions that are ultimately periodic.\
\>", "Notes",
 CellID->16654]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->314131831],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->104038980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuadraticIrrationalQ", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19787],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197260633]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuadraticIrrationalQ", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->395746714],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->61925360]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11077],

Cell["Rational numbers are not quadratic irrationals:", "ExampleText",
 CellID->39653430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuadraticIrrationalQ", "[", 
  RowBox[{"3", "/", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22588018],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297977402]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134252111],

Cell["\[Pi] is a transcendental number:", "ExampleText",
 CellID->206690785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuadraticIrrationalQ", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->298367044],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55980943]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9924995],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["QuadraticIrrationalQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QuadraticIrrationalQ"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->2902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuadraticIrrationalQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", 
    RowBox[{"Sqrt", "[", "3", "]"}], ",", 
    RowBox[{"Sqrt", "[", "4", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29916],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "False"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->425117472]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22111],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["QuadraticIrrationalQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QuadraticIrrationalQ"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if not given an explicit quadratic irrational:"
}], "ExampleText",
 CellID->10662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuadraticIrrationalQ", "[", "s", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13127],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->245960728]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2222],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuedFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootReduce"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10645]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->272540954],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "MoreAbout",
 CellID->188748770],

Cell[TextData[ButtonBox["Continued Fractions & Rational Approximations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuedFractionsAndRationalApproximations"]], "MoreAbout",
 CellID->95153413],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->457167903]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"QuadraticIrrationalQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 26.1245658}", "context" -> "System`", 
    "keywords" -> {"quadratic irrational number"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "QuadraticIrrationalQ[x] gives True if x is a quadratic irrational and \
False otherwise.", "synonyms" -> {"quadratic irrational q"}, "title" -> 
    "QuadraticIrrationalQ", "type" -> "Symbol", "uri" -> 
    "ref/QuadraticIrrationalQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6331, 195, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->314131831]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13685, 479}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1841, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2464, 68, 1585, 37, 70, "ObjectNameGrid"],
Cell[4052, 107, 867, 28, 70, "Usage",
 CellID->14930]
}, Open  ]],
Cell[CellGroupData[{
Cell[4956, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5434, 157, 740, 28, 70, "Notes",
 CellID->522345192],
Cell[6177, 187, 117, 3, 70, "Notes",
 CellID->16654]
}, Closed]],
Cell[CellGroupData[{
Cell[6331, 195, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->314131831],
Cell[CellGroupData[{
Cell[6716, 209, 148, 5, 70, "ExampleSection",
 CellID->104038980],
Cell[CellGroupData[{
Cell[6889, 218, 167, 5, 28, "Input",
 CellID->19787],
Cell[7059, 225, 161, 5, 36, "Output",
 CellID->197260633]
}, Open  ]],
Cell[CellGroupData[{
Cell[7257, 235, 203, 6, 28, "Input",
 CellID->395746714],
Cell[7463, 243, 161, 5, 36, "Output",
 CellID->61925360]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7673, 254, 216, 7, 70, "ExampleSection",
 CellID->11077],
Cell[7892, 263, 89, 1, 70, "ExampleText",
 CellID->39653430],
Cell[CellGroupData[{
Cell[8006, 268, 138, 4, 70, "Input",
 CellID->22588018],
Cell[8147, 274, 162, 5, 36, "Output",
 CellID->297977402]
}, Open  ]],
Cell[8324, 282, 125, 3, 70, "ExampleDelimiter",
 CellID->134252111],
Cell[8452, 287, 76, 1, 70, "ExampleText",
 CellID->206690785],
Cell[CellGroupData[{
Cell[8553, 292, 117, 3, 70, "Input",
 CellID->298367044],
Cell[8673, 297, 161, 5, 36, "Output",
 CellID->55980943]
}, Open  ]],
Cell[8849, 305, 123, 3, 70, "ExampleDelimiter",
 CellID->9924995],
Cell[8975, 310, 229, 7, 70, "ExampleText",
 CellID->2902],
Cell[CellGroupData[{
Cell[9229, 321, 268, 8, 70, "Input",
 CellID->29916],
Cell[9500, 331, 224, 7, 36, "Output",
 CellID->425117472]
}, Open  ]],
Cell[9739, 341, 121, 3, 70, "ExampleDelimiter",
 CellID->22111],
Cell[9863, 346, 371, 12, 70, "ExampleText",
 CellID->10662],
Cell[CellGroupData[{
Cell[10259, 362, 112, 3, 70, "Input",
 CellID->13127],
Cell[10374, 367, 162, 5, 36, "Output",
 CellID->245960728]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10597, 379, 310, 9, 70, "SeeAlsoSection",
 CellID->2222],
Cell[10910, 390, 716, 26, 70, "SeeAlso",
 CellID->10645]
}, Open  ]],
Cell[CellGroupData[{
Cell[11663, 421, 319, 9, 70, "MoreAboutSection",
 CellID->272540954],
Cell[11985, 432, 145, 3, 70, "MoreAbout",
 CellID->188748770],
Cell[12133, 437, 202, 4, 70, "MoreAbout",
 CellID->95153413],
Cell[12338, 443, 198, 4, 70, "MoreAbout",
 CellID->457167903]
}, Open  ]],
Cell[12551, 450, 27, 0, 70, "History"],
Cell[12581, 452, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

