(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26790,        970]
NotebookOptionsPosition[     22561,        826]
NotebookOutlinePosition[     23946,        865]
CellTagsIndexPosition[     23861,        860]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cubics" :> Documentation`HelpLookup["paclet:ref/Cubics"], 
          "ToRadicals" :> Documentation`HelpLookup["paclet:ref/ToRadicals"], 
          "Reduce" :> Documentation`HelpLookup["paclet:ref/Reduce"], 
          "Resolve" :> Documentation`HelpLookup["paclet:ref/Resolve"], 
          "Eigenvalues" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvalues"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cubics\"\>", 
       2->"\<\"ToRadicals\"\>", 3->"\<\"Reduce\"\>", 4->"\<\"Resolve\"\>", 
       5->"\<\"Eigenvalues\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Equations" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialEquations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Equations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Quartics", "ObjectName",
 CellID->217],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Quartics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Quartics"]], "InlineFormula"],
     " \[LineSeparator]is an option for functions that involve solving \
algebraic equations, that specifies whether explicit forms for solutions to \
quartic equations should be given."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Quartics", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", roots of quartics are given explicitly in terms of radicals. With ",
 Cell[BoxData[
  RowBox[{"Quartics", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", roots of quartics that do not have very simple forms are given implicitly \
in terms of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects."
}], "Notes",
 CellID->2489],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Quartics", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " may lead to fairly large outputs."
}], "Notes",
 CellID->448808338]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62661939],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->152653803],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " does not use general formulas for solving quartics in radicals:"
}], "ExampleText",
 CellID->413536964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"3", " ", "x"}], "+", "4"}], "==", "0"}], ",", "x"}], "]"}], "//",
   "Last"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258275847],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"4", "+", 
      RowBox[{"3", " ", "#1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]], "Output",
 ImageSize->{217, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111029332]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Quartics", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " solves all quartics in terms of radicals:"
}], "ExampleText",
 CellID->248533402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"3", " ", "x"}], "+", "4"}], "==", "0"}], ",", "x", ",", 
    RowBox[{"Quartics", "\[Rule]", "True"}]}], "]"}], "//", "Last"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->583642825],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox["4", "3"]}], "+", 
      FractionBox["52", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "317"}], "+", 
             RowBox[{"9", " ", "\[ImaginaryI]", " ", 
              SqrtBox["5703"]}]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "317"}], "+", 
            RowBox[{"9", " ", "\[ImaginaryI]", " ", 
             SqrtBox["5703"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}]}]]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"\[Sqrt]", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "8"}], "-", 
         FractionBox["52", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "317"}], "+", 
               RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                SqrtBox["5703"]}]}], ")"}]}], ")"}], 
           RowBox[{"1", "/", "3"}]]], "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "317"}], "+", 
              RowBox[{"9", " ", "\[ImaginaryI]", " ", 
               SqrtBox["5703"]}]}], ")"}]}], ")"}], 
          RowBox[{"1", "/", "3"}]], "+", 
         FractionBox["18", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", 
             FractionBox["4", "3"]}], "+", 
            FractionBox["52", 
             RowBox[{"3", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "317"}], "+", 
                   RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["5703"]}]}], ")"}]}], ")"}], 
               RowBox[{"1", "/", "3"}]]}]], "+", 
            RowBox[{
             FractionBox["1", "3"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "317"}], "+", 
                  RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                   SqrtBox["5703"]}]}], ")"}]}], ")"}], 
              RowBox[{"1", "/", "3"}]]}]}]]]}], ")"}]}], 
      ")"}]}]}]}]}]], "Output",
 ImageSize->{480, 265},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->438601850]
}, Open  ]],

Cell["\<\
Solving this simple quartic in radicals does not require the general \
formulas:\
\>", "ExampleText",
 CellID->887792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", "5"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->256674784],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SuperscriptBox["5", 
     RowBox[{"1", "/", "4"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    SuperscriptBox["5", 
     RowBox[{"1", "/", "4"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["5", 
     RowBox[{"1", "/", "4"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SuperscriptBox["5", 
    RowBox[{"1", "/", "4"}]]}]}]], "Output",
 ImageSize->{287, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->242432346]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19418],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Eigenvalues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvalues"]], "InlineFormula"],
 " does not use general formulas for solving quartics in radicals:"
}], "ExampleText",
 CellID->268083368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "2", ",", "1"}], "}"}]}], "}"}], ",", "1"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178052272],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "36"}], "-", 
      RowBox[{"44", " ", "#1"}], "-", 
      RowBox[{"19", " ", 
       SuperscriptBox["#1", "2"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["#1", "3"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "}"}]], "Output",\

 ImageSize->{278, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100945231]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Quartics", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " all quartics are solved in terms of radicals:"
}], "ExampleText",
 CellID->257425033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "2", ",", "1"}], "}"}]}], "}"}], ",", "1", 
   ",", 
   RowBox[{"Quartics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->651700911],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SqrtBox[
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"50", "-", 
        FractionBox["599", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1925", "+", 
            RowBox[{"36", " ", 
             SqrtBox["168694"]}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1925", "+", 
           RowBox[{"36", " ", 
            SqrtBox["168694"]}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], ")"}]}]]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"\[Sqrt]", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["100", "3"], "+", 
       FractionBox["599", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1925", "+", 
            RowBox[{"36", " ", 
             SqrtBox["168694"]}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]}]], "-", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1925", "+", 
           RowBox[{"36", " ", 
            SqrtBox["168694"]}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], "+", 
       FractionBox["180", 
        SqrtBox[
         RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"50", "-", 
            FractionBox["599", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1925", "+", 
                RowBox[{"36", " ", 
                 SqrtBox["168694"]}]}], ")"}], 
              RowBox[{"1", "/", "3"}]]], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1925", "+", 
               RowBox[{"36", " ", 
                SqrtBox["168694"]}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]}], ")"}]}]]]}], ")"}]}]}]}], 
  "}"}]], "Output",
 ImageSize->{441, 269},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->155710715]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16458946],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " converts all quartic ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects to radicals:"
}], "ExampleText",
 CellID->758680193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nums", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "4"}], "-", 
        RowBox[{"12", "#"}], "+", "7"}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "4"}], "-", "5"}], "&"}], ",", "1"}], "]"}]}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->331327142],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"7", "-", 
       RowBox[{"12", " ", "#1"}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{301, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->631444965]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", "nums", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->362176903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1944", "-", 
           RowBox[{"48", " ", 
            SqrtBox["1383"]}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"81", "+", 
            RowBox[{"2", " ", 
             SqrtBox["1383"]}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]}], 
        SuperscriptBox["3", 
         RowBox[{"2", "/", "3"}]]]}]]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1944", "-", 
              RowBox[{"48", " ", 
               SqrtBox["1383"]}]}], ")"}], 
            RowBox[{"1", "/", "3"}]]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"3", " ", 
              RowBox[{"(", 
               RowBox[{"81", "+", 
                RowBox[{"2", " ", 
                 SqrtBox["1383"]}]}], ")"}]}], ")"}], 
            RowBox[{"1", "/", "3"}]]}], "+", 
          FractionBox["72", 
           SqrtBox[
            RowBox[{
             RowBox[{
              FractionBox["1", "3"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1944", "-", 
                 RowBox[{"48", " ", 
                  SqrtBox["1383"]}]}], ")"}], 
               RowBox[{"1", "/", "3"}]]}], "+", 
             FractionBox[
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"81", "+", 
                  RowBox[{"2", " ", 
                   SqrtBox["1383"]}]}], ")"}], 
                RowBox[{"1", "/", "3"}]]}], 
              SuperscriptBox["3", 
               RowBox[{"2", "/", "3"}]]]}]]]}], ")"}]}], ")"}]}]}]}], ",", 
   RowBox[{"-", 
    SuperscriptBox["5", 
     RowBox[{"1", "/", "4"}]]}]}], "}"}]], "Output",
 ImageSize->{398, 265},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->527570187]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Quartics", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " does not use the general formulas for solving quartics:"
}], "ExampleText",
 CellID->416590211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{"nums", ",", 
   RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->241638772],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"7", "-", 
       RowBox[{"12", " ", "#1"}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"-", 
    SuperscriptBox["5", 
     RowBox[{"1", "/", "4"}]]}]}], "}"}]], "Output",
 ImageSize->{213, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3308400]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11577],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cubics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cubics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToRadicals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToRadicals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Resolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15723]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->170991443],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "MoreAbout",
 CellID->2040138]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Quartics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 29.6090300}", "context" -> "System`", 
    "keywords" -> {
     "radical solutions", "polynomial roots", "Cardano formulas", 
      "Ferrari formulas"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Quartics is an option for functions that involve solving algebraic \
equations, that specifies whether explicit forms for solutions to quartic \
equations should be given.", "synonyms" -> {}, "title" -> "Quartics", "type" -> 
    "Symbol", "uri" -> "ref/Quartics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4195, 139, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->62661939]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23719, 853}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1556, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2179, 63, 44, 1, 70, "ObjectName",
 CellID->217],
Cell[2226, 66, 546, 15, 70, "Usage",
 CellID->20695]
}, Open  ]],
Cell[CellGroupData[{
Cell[2809, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3287, 103, 637, 21, 70, "Notes",
 CellID->2489],
Cell[3927, 126, 231, 8, 70, "Notes",
 CellID->448808338]
}, Closed]],
Cell[CellGroupData[{
Cell[4195, 139, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62661939],
Cell[CellGroupData[{
Cell[4579, 153, 148, 5, 70, "ExampleSection",
 CellID->152653803],
Cell[4730, 160, 253, 8, 70, "ExampleText",
 CellID->413536964],
Cell[CellGroupData[{
Cell[5008, 172, 337, 12, 28, "Input",
 CellID->258275847],
Cell[5348, 186, 423, 14, 39, "Output",
 CellID->111029332]
}, Open  ]],
Cell[5786, 203, 377, 14, 70, "ExampleText",
 CellID->248533402],
Cell[CellGroupData[{
Cell[6188, 221, 387, 13, 28, "Input",
 CellID->583642825],
Cell[6578, 236, 3167, 98, 286, "Output",
 CellID->438601850]
}, Open  ]],
Cell[9760, 337, 128, 4, 70, "ExampleText",
 CellID->887792],
Cell[CellGroupData[{
Cell[9913, 345, 210, 8, 70, "Input",
 CellID->256674784],
Cell[10126, 355, 641, 22, 36, "Output",
 CellID->242432346]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10816, 383, 216, 7, 70, "ExampleSection",
 CellID->19418],
Cell[11035, 392, 263, 8, 70, "ExampleText",
 CellID->268083368],
Cell[CellGroupData[{
Cell[11323, 404, 494, 15, 70, "Input",
 CellID->178052272],
Cell[11820, 421, 510, 18, 39, "Output",
 CellID->100945231]
}, Open  ]],
Cell[12345, 442, 259, 9, 70, "ExampleText",
 CellID->257425033],
Cell[CellGroupData[{
Cell[12629, 455, 545, 16, 70, "Input",
 CellID->651700911],
Cell[13177, 473, 2093, 69, 290, "Output",
 CellID->155710715]
}, Open  ]],
Cell[15285, 545, 124, 3, 70, "ExampleDelimiter",
 CellID->16458946],
Cell[15412, 550, 356, 13, 70, "ExampleText",
 CellID->758680193],
Cell[CellGroupData[{
Cell[15793, 567, 457, 17, 70, "Input",
 CellID->331327142],
Cell[16253, 586, 540, 20, 39, "Output",
 CellID->631444965]
}, Open  ]],
Cell[CellGroupData[{
Cell[16830, 611, 109, 3, 70, "Input",
 CellID->362176903],
Cell[16942, 616, 2413, 78, 286, "Output",
 CellID->527570187]
}, Open  ]],
Cell[19370, 697, 401, 14, 70, "ExampleText",
 CellID->416590211],
Cell[CellGroupData[{
Cell[19796, 715, 173, 5, 70, "Input",
 CellID->241638772],
Cell[19972, 722, 448, 16, 39, "Output",
 CellID->3308400]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20481, 745, 311, 9, 70, "SeeAlsoSection",
 CellID->11577],
Cell[20795, 756, 1186, 44, 70, "SeeAlso",
 CellID->15723]
}, Open  ]],
Cell[CellGroupData[{
Cell[22018, 805, 319, 9, 70, "MoreAboutSection",
 CellID->170991443],
Cell[22340, 816, 149, 3, 70, "MoreAbout",
 CellID->2040138]
}, Open  ]],
Cell[22504, 822, 27, 0, 70, "History"],
Cell[22534, 824, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

