(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     98064,       2519]
NotebookOptionsPosition[     88536,       2183]
NotebookOutlinePosition[     90075,       2229]
CellTagsIndexPosition[     89963,       2223]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mod" :> Documentation`HelpLookup["paclet:ref/Mod"], 
          "PolynomialQuotient" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialQuotient"], 
          "Divisible" :> Documentation`HelpLookup["paclet:ref/Divisible"], 
          "CoprimeQ" :> Documentation`HelpLookup["paclet:ref/CoprimeQ"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Mod\"\>", 
       2->"\<\"PolynomialQuotient\"\>", 3->"\<\"Divisible\"\>", 
       4->"\<\"CoprimeQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Numerical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Quotient", "ObjectName",
 CellID->20164],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Quotient",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Quotient"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the integer quotient of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Quotient",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Quotient"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses an offset ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3749]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quotient"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"], "[", 
   RowBox[{
    StyleBox["m", "TI"], "/", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " for integers ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28583],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quotient"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
 " gives a result ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[LessEqual]", 
    RowBox[{"m", "-", 
     RowBox[{"n", "x"}]}], "<", 
    RowBox[{"d", "+", "n"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->22629],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["n", "TI"], "*", 
    RowBox[{"Quotient", "[", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"], ",", 
      StyleBox["d", "TI"]}], "]"}]}], "+", 
   RowBox[{
    ButtonBox["Mod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mod"], "[", 
    RowBox[{
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"]}], "]"}]}]], "InlineFormula"],
 " is always equal to ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11917],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Quotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quotient"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->369368727],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->313759294],

Cell["Find quotients of two numbers:", "ExampleText",
 CellID->660431835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quotient", "[", 
  RowBox[{"17", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8162292],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->504386562]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->198770542],

Cell["Form the quotient of approximate numbers:", "ExampleText",
 CellID->577496370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quotient", "[", 
  RowBox[{"4.56", ",", "2.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96169293],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->603431907]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->440935164],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Quotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quotient"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->210965654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quotient", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9", ",", "10"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112226680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "2", 
   ",", "3", ",", "3"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->526936283]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->587278267],

Cell["Form quotients with offsets:", "ExampleText",
 CellID->159403218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quotient", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9", ",", "10"}], "}"}], ",", "3", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->728217],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "2", ",", "2", 
   ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189787947]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127311830],

Cell["Use with exact, nonrational arguments:", "ExampleText",
 CellID->37744292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quotient", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"E", "^", "E"}]}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156481549],

Cell[BoxData["1214122"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232237377]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129108082],

Cell["Complex numbers:", "ExampleText",
 CellID->594531386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quotient", "[", 
  RowBox[{
   RowBox[{"10", "+", 
    RowBox[{"8", " ", "I"}]}], ",", 
   RowBox[{
    RowBox[{"-", "4"}], " ", "+", " ", 
    RowBox[{"6", " ", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->884429871],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}]], "Output",
 ImageSize->{30, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285716917]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->169636943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Quotient", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "-", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->916743438],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV0trE1EUvk0mrbrR7lyZboqP2NIYwaLWKtV2JeIPcJE+IFH6sHalP8Gd
biyILtSNuhMUtwpiQSy4El2UCNKNRbC4CAjjdx7pzNxek047k5Uhubnn8d17
7jlnzj1zsbxQmZouL1Qnyj1j8+W5SnXiRs/o7DxY2Q5jTA2/2/sN5j5m/Kv5
Pv6v05glmj9mugU3A2Y/S9fX64v3lmg65MSIVr3+R+nTTVaexEjMjO7Q6dSa
otELuKIf1ss6cVcwEsyLje9jenX119ra7+CkW7ODSMG/evl56f23uPjkzj+p
Xs029W7zmPc1Yn7r5mvE1JxxYkRLnBWcN26OteYeZbpW+6lxCawJbH3yeFm9
7rZ151ZEPSQ2vX2zMjH+nKbDqe8a5h7xNVNxbIrP2YhtBZZ+/fLj4YMPiGFI
utX9Kr5ktDt3rllcdx6O+/Ic5hzaRB5mAgl2YeQ+AmvOxVi76jfL7arFtS0Q
rau6hltq++VgI97wKUYzEvH4IV+ffEgxhqRp5mAvUR4ScHhoEV9yZar7dmpE
9+GU/MRJuTd5jegxC3WA6WdPP0GfITwsf/yu8t2KK4YzRWLqkReNIYAx3YxD
Jisub+1TVH/IfjAKphHEYxyipXp7HLgGbTb2l5STT6OOhlEFtdbmF1vQtnf4
fmIfxFnFpksWnU1xVYlM+Eay9VqtO7BpBfF5l0aw29enTDLa5DEQv6T/RHNG
KX6v4kp+qB60rQoLl27lFc4WuxrtsuiuFvL/+v/MuibPkZ2DttymZdXt1NuZ
bSGTqfXp793+E44yjbqu90PeqvOZiG1jrI2eJ6INepN2O7sclxaR54nw0INJ
JcOkN8aq7e9vuHfPSc+Ir/aVhUgEuLPO4f4WHe0uC871ks5Mfp/0UPnhzMuX
HsG4/tT3DXNPMo2uRC4fuck2rDvFUojUbwMpWRH1idiE/u/unXc0LcZeKd03
8fi4QbIDCVaKgSeScWgb4uCSO2cSb9yDLMXzp++Tpdix3An3BNNwoJTT0O6B
bS5pmtktNmHL2ZkXND2e0Pqm4y8Utcl2\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->341158031]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89753409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Quotient", "[", 
    RowBox[{
     RowBox[{"x", "  ", "y"}], ",", 
     RowBox[{"Max", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27006761],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497067755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84005477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Quotient", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], ",", 
      RowBox[{"2", "-", 
       RowBox[{"2", "I"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336639054],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 245},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->523003039]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->418234841],

Cell["Implement the Euclidean algorithm in one line:", "ExampleText",
 CellID->637488637],

Cell[BoxData[
 RowBox[{
  RowBox[{"euclid", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"FixedPointList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"#2", ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"#2", "==", "0"}], ",", "0", ",", 
            RowBox[{"#", "-", 
             RowBox[{
              RowBox[{"Quotient", "[", "##", "]"}], "#2"}]}]}], "]"}]}], 
         "}"}], "&"}], "@@", "#"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->786185869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"euclid", "[", 
  RowBox[{"12", ",", " ", "24"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9705815],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88539676]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15761126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Quotient", "[", 
    RowBox[{"x", ",", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152127107],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1OwkAQXmj9uRsTrB6QRER9BuPBoCcvvgESY9EIBHkSvMhdb958BxMv
ctdTD4aLxMTEc53dHWh3mVYWREVt2mnn2/nZ6Uyn2+4V6u7haaFeKhbSu7VC
1S0Vz9I7lRpAVoIx5sHRSDG49uFKHJ7vwzlMq5xafExsrCzQI6AcnCZHjzXU
IqVsgT4+PG9tNmFnc5xYxYNrlMoDsVlXTrXGWWnFBZqMnElJQ3VbJvONj5m+
T1WcXeUDmdHRfy88P7xepshRN4SySClHoJ730rp/gp3lOOE1ilIO+tArhK4r
ae3qslUp38DOcpxY541blMpoWmplD16VzA7QuPijn5PJzPgk+Q7yaqLpoiad
08G6W95Xq9ABImpYVCMPXuI2kGCWUqvTecMnYVk8CTCMvN3lh5jRYFJ/p2KX
NDTryy6zquEriK9p+AJpJazN0FpSs8oirc2jL9l25Ma1Mz7dAbMx3sMxiZ6I
nTGYwwYRaZjPxYxz/UVxXsQITa1lUU+1IqSUzkrlQ5XIKZaojPQsE/7XyUyM
raaVd1y7/YpS20LKY9RbckbjZw15U/2v9jduffkwORqq14MpnxJW84ZaMs/f
3Ud/Sw//bC/8HcnBUb5YKCmr13+aF3fKuhR4lEsN5ENa0dfKwBtZMYmnhHeT
Xg1NZp5/ppfhfPMVG/XF3r/qYyNW9omGJtHzvsChnJV/ClCYITlam45GfbtH
xxVdlf1/VFjiHSlvqsQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->335885333]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->548480342],

Cell["Results depend on the sign of the second argument:", "ExampleText",
 CellID->429839107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quotient", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}], ",",
    "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->339452836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144152471]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quotient", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}], ",",
    
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->82849697],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->494438645]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->363296527],

Cell[TextData[{
 "Express through ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->54900378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Quotient", "[", 
   RowBox[{"m", ",", " ", "n"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166292938],

Cell[BoxData[
 RowBox[{"Floor", "[", 
  FractionBox["m", "n"], "]"}]], "Output",
 ImageSize->{65, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27511165]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->534177449],

Cell[TextData[{
 "Simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["Quotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quotient"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->149877473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Quotient", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "n"}], "-", "3"}], ",", "7"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "-", "4"}], ")"}], "/", "7"}], ",", " ", "Integers"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->708873437],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "7"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "8"}], "+", 
    RowBox[{"2", " ", "n"}]}], ")"}]}]], "Output",
 ImageSize->{77, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114301339]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Quotient", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "n"}], "+", "5"}], ",", "2"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"n", ",", "Integers"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->947988242],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "n"}], ")"}]}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->831546643]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3977002],

Cell["Express as a piecewise function:", "ExampleText",
 CellID->3584696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Quotient", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", "1"}], ",", "3"}], "]"}], ",", 
   RowBox[{"0", "<", "x", "<", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->607922195],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVktOAkEQbZgPDN+IGwc3JMYYdaEewI0ajVE33GBCTGBhJMiCHUdgyRFY
cgSPwDFYcoS2p6ebqamphlFc0Ald011Vr6q6PuEtGHbfP4JhrxO0ngZBv9vr
fLUePwfiysoxxtrid3vExDcXX/LX5lxQuFvhbo9Go2+5lsvlS3xvjcdjLhcr
iM0SEBVB84LmFXUEdQT1FL9JarvhFopxvZjCYvb6VnxIOSu+qaCzT6KXkFRZ
+VYE1DX6ZtIuKUr7fkxiaYvVVGQFxfFSHBoJe+UR7w75UN7sHx3LSSZdXQGn
ygNa6nUPbn3l6bWRC1+OlmoiqasdpKBFZvQrGxYdcZjXMK2+og5PVouHsHUu
80a0dJXImrYWi8VYLqkgzwAT2rA5rnTdHWUkmSO9wHg1eV6tVgn74qz4OmZt
BXaca4y1iKz4PNn9HkBLv4lEi5Ct6XQ6m8040btNiJF4ESzppCSghdhr/IJV
dMZ8iyfroQH4OI5+vz+ZTNYZSMVcQ7oXJJZpehwgz86VR7SWzsaNkbu9kzdP
g32YV/fKQ9fIhVHSUg9IytlBClpkRr+yYW2eVxUez6ssc6tOouEerqEzRjFP
pgjJPOPoSbXNfoHTkynqfvNE+5s1h9MTrLGT79tn1//kBk+qQyK631s5A2dz
RetY64peIhQ71rLn83mUNVEcd/CN2DPScte3cY9H/71Z7gfVRF1/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{82, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59461034]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->596012241],

Cell["Solve an implicit equation:", "ExampleText",
 CellID->658199865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Quotient", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", 
         RowBox[{"x", "^", "2"}]}], "+", "1"}], ",", "3"}], "]"}], "==", 
     RowBox[{"Quotient", "[", 
      RowBox[{
       RowBox[{"3", 
        RowBox[{"x", "^", "3"}]}], ",", 
       RowBox[{"x", "^", "2"}]}], "]"}]}], "&&", 
    RowBox[{"0", "<", "x", "<", "20"}]}], ",", "x"}], "]"}]], "Input",
 CellTags->"S3.4.9",
 CellLabel->"In[1]:=",
 CellID->152297330],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", "x", "<", 
   FractionBox["1", "3"]}], "||", 
  RowBox[{
   SqrtBox[
    FractionBox["35", "2"]], "\[LessEqual]", "x", "<", 
   FractionBox["13", "3"]}], "||", 
  RowBox[{
   SqrtBox["19"], "\[LessEqual]", "x", "<", 
   SqrtBox[
    FractionBox["41", "2"]]}], "||", 
  RowBox[{
   FractionBox["14", "3"], "\[LessEqual]", "x", "<", 
   SqrtBox["22"]}]}]], "Output",
 ImageSize->{395, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S3.4.9",
 CellLabel->"Out[1]=",
 CellID->184725229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->69670131],

Cell["Evaluate an integral:", "ExampleText",
 CellID->67350630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Quotient", "[", 
    RowBox[{
     RowBox[{"x", "^", "3"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->528019690],

Cell[BoxData[
 RowBox[{"54", "-", 
  RowBox[{"3", " ", 
   SqrtBox["2"]}], "-", 
  RowBox[{"3", " ", 
   SqrtBox["3"]}], "-", 
  SqrtBox["5"], "-", 
  SqrtBox["6"], "-", 
  SqrtBox["7"], "-", 
  SqrtBox["10"], "-", 
  SqrtBox["11"], "-", 
  SqrtBox["13"], "-", 
  SqrtBox["14"], "-", 
  SqrtBox["15"]}]], "Output",
 ImageSize->{438, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116986607]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->224119550],

Cell[BoxData["19.530803399857398`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->755924608]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Quotient", "[", 
    RowBox[{
     RowBox[{"x", "^", "3"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8495460],

Cell[BoxData["19.53080339985742`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->39749466]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->582972726],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Quotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quotient"]], "InlineFormula"],
 " does not automatically resolve the value:"
}], "ExampleText",
 CellID->16609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quotient", "[", 
  RowBox[{"2", ",", " ", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Pi", "+", "1"}], ")"}], "^", "2"}], "-", 
    RowBox[{"Pi", "^", "2"}], "-", 
    RowBox[{"2", "Pi"}], "-", "1", "+", 
    RowBox[{"10", "^", 
     RowBox[{"-", "100"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149262148],

Cell[BoxData[
 RowBox[{
  RowBox[{"Floor", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(Floor[\\(\\(2\\/\\(1\\/\\(10000000 \\(\\(\
\[LeftSkeleton] 84 \[RightSkeleton]\\)\\) 000000000\\) - \\(\\(2\\\\ \[Pi]\\)\
\\) - \[Pi]\\^2 + \\((1 + \[Pi])\\)\\^2\\)\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"Floor::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->77225754],

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"2", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
     "1", "/", 
      "10000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000"}], "-", 
     RowBox[{"2", " ", "\[Pi]"}], "-", 
     SuperscriptBox["\[Pi]", "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Pi]"}], ")"}], "2"]}], ")"}]}], "]"}]], "Output",
 ImageSize->{571, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102101642]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79464945],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102014211]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->358224797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Quotient", "[", 
      RowBox[{"i", ",", "j"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"3.2", " ", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->441623515],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVmj1oE1EAx194cnBwkBISCARKCoFKIVAoFgKVYqFaKREKoiAoJsHQgFo5
axEFoVQoWETBQUooHVwdHBwcHRw6ODh0cXB0cMjg6CDP//u45F3u2gQhufcC
L7mP/+/HvXf3Pg5SrW2u37lX22w1asVLfu3BeqvxsHhxw8chmiKEHPCSJ9hm
2JKFMsY3+GcfJSV3KT8nPmQfXykZ+M+j9CsKaTLKSoS2CaPkLEoHhX1AqTpZ
RpwtRrzvjBTYF7LK6uKyLDGxb9g90kx7IROFyVWmfNdErLTdj7U5MaYVmBzL
TB522THqf55WAlP0aQhMrmUmcm1Y0zJMnm2mT6D8QaacMqXtMv3ktDAdSlO0
B7uqnZZgythl2hGmCWHqG4VpXztxU84uU3F40yJMebtM5AKja/j9G5pBu8+3
q1kKlljeDWVZgGXSEgv7Qz8Glr3YO51RlilbLG+FpR1vCdqlAkvJFss5yn6d
askoy7QdljKfAQdb5mGZscPyilt2iT7b8Z5I+wxlsw2/I4ZIO8zBMGu2gb0n
YsV/giGtDHOGGy5Lgza2BwZHtcMsDPOGG0herHGFodezqNYO3FAx3fBkkKEM
w4Lphh9yVadGOe1OBvSimfRn9KJT6BnQS2bSt0D31jOhO+YpetlMmpxRdCdE
B/WeBr1iKN1kcjaP0p6iVw2lj0K0o5ElkFcMI9mxnN9kr6B95JpppH8SOQXy
qmnkRHek10hXkdfNIvl7qCS7TzxV9ZwEecMskr+RBWOiVkdO3TSD4u8jMVQB
1G1DKKzQ+YihtXxANQyhSrFUHlTTEIqv5tSKAoSjiFbSxKEgtHrkQNxNlhCr
AfmEUlUPTmwkS7SjRAaEnyzBZ5xsOP0omTQfn7V0GunHCaUxwqkWpCr9NKF0
R6T5NXtIPhtzEr1OXSdPbo87WQ2SLpLPx5vM9lK740ltyZSD1IvxpERvqJOX
o03gOigSr0ecqJM3Izk76P8pB/Jc6h95wMMM\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{157, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15803799]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17310],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialQuotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialQuotient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoprimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoprimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11119]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10781],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->7820],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Quotient.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/Quotient/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Quotient"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->3279821],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->31146110],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->240131228],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->561320018]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Quotient - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 33.1403704}", "context" -> "System`", 
    "keywords" -> {
     "division of integers", "idiv", "idivide", "integral part of division", 
      "iquo", "quo", "quot"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Quotient[m, n] gives the integer quotient of m and n. Quotient[m, n, d] \
uses an offset d. ", "synonyms" -> {}, "title" -> "Quotient", "type" -> 
    "Symbol", "uri" -> "ref/Quotient"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6923, 242, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->369368727]},
 "S3.4.9"->{
  Cell[77374, 1770, 525, 18, 70, "Input",
   CellTags->"S3.4.9",
   CellID->152297330],
  Cell[77902, 1790, 560, 20, 60, "Output",
   CellTags->"S3.4.9",
   CellID->184725229]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 89629, 2209},
 {"S3.4.9", 89762, 2213}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2432, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3055, 84, 46, 1, 70, "ObjectName",
 CellID->20164],
Cell[3104, 87, 1118, 38, 70, "Usage",
 CellID->3749]
}, Open  ]],
Cell[CellGroupData[{
Cell[4259, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4737, 147, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4872, 153, 642, 26, 70, "Notes",
 CellID->28583],
Cell[5517, 181, 571, 22, 70, "Notes",
 CellID->22629],
Cell[6091, 205, 587, 23, 70, "Notes",
 CellID->11917],
Cell[6681, 230, 205, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[6923, 242, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->369368727],
Cell[CellGroupData[{
Cell[7308, 256, 148, 5, 70, "ExampleSection",
 CellID->313759294],
Cell[7459, 263, 73, 1, 70, "ExampleText",
 CellID->660431835],
Cell[CellGroupData[{
Cell[7557, 268, 126, 4, 28, "Input",
 CellID->8162292],
Cell[7686, 274, 158, 5, 36, "Output",
 CellID->504386562]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7893, 285, 220, 7, 70, "ExampleSection",
 CellID->198770542],
Cell[8116, 294, 84, 1, 70, "ExampleText",
 CellID->577496370],
Cell[CellGroupData[{
Cell[8225, 299, 131, 4, 70, "Input",
 CellID->96169293],
Cell[8359, 305, 158, 5, 36, "Output",
 CellID->603431907]
}, Open  ]],
Cell[8532, 313, 125, 3, 70, "ExampleDelimiter",
 CellID->440935164],
Cell[8660, 318, 210, 7, 70, "ExampleText",
 CellID->210965654],
Cell[CellGroupData[{
Cell[8895, 329, 268, 8, 70, "Input",
 CellID->112226680],
Cell[9166, 339, 291, 9, 36, "Output",
 CellID->526936283]
}, Open  ]],
Cell[9472, 351, 125, 3, 70, "ExampleDelimiter",
 CellID->587278267],
Cell[9600, 356, 71, 1, 70, "ExampleText",
 CellID->159403218],
Cell[CellGroupData[{
Cell[9696, 361, 275, 8, 70, "Input",
 CellID->728217],
Cell[9974, 371, 291, 9, 36, "Output",
 CellID->189787947]
}, Open  ]],
Cell[10280, 383, 125, 3, 70, "ExampleDelimiter",
 CellID->127311830],
Cell[10408, 388, 80, 1, 70, "ExampleText",
 CellID->37744292],
Cell[CellGroupData[{
Cell[10513, 393, 177, 6, 70, "Input",
 CellID->156481549],
Cell[10693, 401, 164, 5, 36, "Output",
 CellID->232237377]
}, Open  ]],
Cell[10872, 409, 125, 3, 70, "ExampleDelimiter",
 CellID->129108082],
Cell[11000, 414, 59, 1, 70, "ExampleText",
 CellID->594531386],
Cell[CellGroupData[{
Cell[11084, 419, 256, 9, 70, "Input",
 CellID->884429871],
Cell[11343, 430, 210, 7, 36, "Output",
 CellID->285716917]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11602, 443, 227, 7, 70, "ExampleSection",
 CellID->169636943],
Cell[CellGroupData[{
Cell[11854, 454, 316, 11, 70, "Input",
 CellID->916743438],
Cell[12173, 467, 1334, 26, 70, "Output",
 Evaluatable->False,
 CellID->341158031]
}, Open  ]],
Cell[13522, 496, 124, 3, 70, "ExampleDelimiter",
 CellID->89753409],
Cell[CellGroupData[{
Cell[13671, 503, 442, 15, 70, "Input",
 CellID->27006761],
Cell[14116, 520, 5564, 95, 70, "Output",
 Evaluatable->False,
 CellID->497067755]
}, Open  ]],
Cell[19695, 618, 124, 3, 70, "ExampleDelimiter",
 CellID->84005477],
Cell[CellGroupData[{
Cell[19844, 625, 494, 17, 70, "Input",
 CellID->336639054],
Cell[20341, 644, 48541, 800, 70, "Output",
 Evaluatable->False,
 CellID->523003039]
}, Open  ]],
Cell[68897, 1447, 125, 3, 70, "ExampleDelimiter",
 CellID->418234841],
Cell[69025, 1452, 89, 1, 70, "ExampleText",
 CellID->637488637],
Cell[69117, 1455, 737, 25, 70, "Input",
 CellID->786185869],
Cell[CellGroupData[{
Cell[69879, 1484, 130, 4, 70, "Input",
 CellID->9705815],
Cell[70012, 1490, 158, 5, 36, "Output",
 CellID->88539676]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[70219, 1501, 236, 7, 70, "ExampleSection",
 CellID->15761126],
Cell[CellGroupData[{
Cell[70480, 1512, 264, 9, 70, "Input",
 CellID->152127107],
Cell[70747, 1523, 1017, 21, 70, "Output",
 Evaluatable->False,
 CellID->335885333]
}, Open  ]],
Cell[71779, 1547, 125, 3, 70, "ExampleDelimiter",
 CellID->548480342],
Cell[71907, 1552, 93, 1, 70, "ExampleText",
 CellID->429839107],
Cell[CellGroupData[{
Cell[72025, 1557, 293, 10, 70, "Input",
 CellID->339452836],
Cell[72321, 1569, 314, 11, 36, "Output",
 CellID->144152471]
}, Open  ]],
Cell[CellGroupData[{
Cell[72672, 1585, 311, 11, 70, "Input",
 CellID->82849697],
Cell[72986, 1598, 311, 10, 36, "Output",
 CellID->494438645]
}, Open  ]],
Cell[73312, 1611, 125, 3, 70, "ExampleDelimiter",
 CellID->363296527],
Cell[73440, 1616, 192, 8, 70, "ExampleText",
 CellID->54900378],
Cell[CellGroupData[{
Cell[73657, 1628, 174, 5, 70, "Input",
 CellID->166292938],
Cell[73834, 1635, 209, 7, 49, "Output",
 CellID->27511165]
}, Open  ]],
Cell[74058, 1645, 125, 3, 70, "ExampleDelimiter",
 CellID->534177449],
Cell[74186, 1650, 215, 8, 70, "ExampleText",
 CellID->149877473],
Cell[CellGroupData[{
Cell[74426, 1662, 392, 14, 70, "Input",
 CellID->708873437],
Cell[74821, 1678, 293, 11, 51, "Output",
 CellID->114301339]
}, Open  ]],
Cell[CellGroupData[{
Cell[75151, 1694, 303, 10, 70, "Input",
 CellID->947988242],
Cell[75457, 1706, 227, 8, 36, "Output",
 CellID->831546643]
}, Open  ]],
Cell[75699, 1717, 123, 3, 70, "ExampleDelimiter",
 CellID->3977002],
Cell[75825, 1722, 73, 1, 70, "ExampleText",
 CellID->3584696],
Cell[CellGroupData[{
Cell[75923, 1727, 277, 9, 70, "Input",
 CellID->607922195],
Cell[76203, 1738, 933, 19, 70, "Output",
 Evaluatable->False,
 CellID->59461034]
}, Open  ]],
Cell[77151, 1760, 125, 3, 70, "ExampleDelimiter",
 CellID->596012241],
Cell[77279, 1765, 70, 1, 70, "ExampleText",
 CellID->658199865],
Cell[CellGroupData[{
Cell[77374, 1770, 525, 18, 70, "Input",
 CellTags->"S3.4.9",
 CellID->152297330],
Cell[77902, 1790, 560, 20, 60, "Output",
 CellTags->"S3.4.9",
 CellID->184725229]
}, Open  ]],
Cell[78477, 1813, 124, 3, 70, "ExampleDelimiter",
 CellID->69670131],
Cell[78604, 1818, 63, 1, 70, "ExampleText",
 CellID->67350630],
Cell[CellGroupData[{
Cell[78692, 1823, 274, 9, 70, "Input",
 CellID->528019690],
Cell[78969, 1834, 445, 18, 38, "Output",
 CellID->116986607]
}, Open  ]],
Cell[CellGroupData[{
Cell[79451, 1857, 97, 3, 70, "Input",
 CellID->224119550],
Cell[79551, 1862, 176, 5, 36, "Output",
 CellID->755924608]
}, Open  ]],
Cell[CellGroupData[{
Cell[79764, 1872, 273, 9, 70, "Input",
 CellID->8495460],
Cell[80040, 1883, 174, 5, 36, "Output",
 CellID->39749466]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80263, 1894, 230, 7, 70, "ExampleSection",
 CellID->582972726],
Cell[80496, 1903, 215, 7, 70, "ExampleText",
 CellID->16609],
Cell[CellGroupData[{
Cell[80736, 1914, 371, 12, 70, "Input",
 CellID->149262148],
Cell[81110, 1928, 593, 10, 70, "Message",
 CellID->77225754],
Cell[81706, 1940, 570, 18, 75, "Output",
 CellID->102101642]
}, Open  ]],
Cell[CellGroupData[{
Cell[82313, 1963, 103, 3, 70, "Input",
 CellID->79464945],
Cell[82419, 1968, 158, 5, 36, "Output",
 CellID->102014211]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82626, 1979, 228, 7, 70, "ExampleSection",
 CellID->358224797],
Cell[CellGroupData[{
Cell[82879, 1990, 516, 17, 70, "Input",
 CellID->441623515],
Cell[83398, 2009, 1224, 24, 70, "Output",
 Evaluatable->False,
 CellID->15803799]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84683, 2040, 311, 9, 70, "SeeAlsoSection",
 CellID->17310],
Cell[84997, 2051, 953, 35, 70, "SeeAlso",
 CellID->11119]
}, Open  ]],
Cell[CellGroupData[{
Cell[85987, 2091, 314, 9, 70, "TutorialsSection",
 CellID->10781],
Cell[86304, 2102, 198, 4, 70, "Tutorials",
 CellID->28609]
}, Open  ]],
Cell[CellGroupData[{
Cell[86539, 2111, 320, 9, 70, "RelatedLinksSection",
 CellID->7820],
Cell[86862, 2122, 179, 4, 70, "RelatedLinks"],
Cell[87044, 2128, 197, 4, 70, "RelatedLinks"],
Cell[87244, 2134, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87667, 2152, 317, 9, 70, "MoreAboutSection",
 CellID->3279821],
Cell[87987, 2163, 144, 3, 70, "MoreAbout",
 CellID->31146110],
Cell[88134, 2168, 155, 3, 70, "MoreAbout",
 CellID->240131228],
Cell[88292, 2173, 149, 3, 70, "MoreAbout",
 CellID->561320018]
}, Open  ]],
Cell[88456, 2179, 50, 0, 70, "History"],
Cell[88509, 2181, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

