(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    428758,       8424]
NotebookOptionsPosition[    418115,       8059]
NotebookOutlinePosition[    419589,       8098]
CellTagsIndexPosition[    419502,       8093]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"], 
          "The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>", 
       2->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hue" :> Documentation`HelpLookup["paclet:ref/Hue"], 
          "GrayLevel" :> Documentation`HelpLookup["paclet:ref/GrayLevel"], 
          "CMYKColor" :> Documentation`HelpLookup["paclet:ref/CMYKColor"], 
          "Opacity" :> Documentation`HelpLookup["paclet:ref/Opacity"], 
          "Blend" :> Documentation`HelpLookup["paclet:ref/Blend"], "Lighter" :> 
          Documentation`HelpLookup["paclet:ref/Lighter"], "Darker" :> 
          Documentation`HelpLookup["paclet:ref/Darker"], "Glow" :> 
          Documentation`HelpLookup["paclet:ref/Glow"], "Specularity" :> 
          Documentation`HelpLookup["paclet:ref/Specularity"], "Lighting" :> 
          Documentation`HelpLookup["paclet:ref/Lighting"], "Raster" :> 
          Documentation`HelpLookup["paclet:ref/Raster"], "Red" :> 
          Documentation`HelpLookup["paclet:ref/Red"], "Green" :> 
          Documentation`HelpLookup["paclet:ref/Green"], "Blue" :> 
          Documentation`HelpLookup["paclet:ref/Blue"], "White" :> 
          Documentation`HelpLookup["paclet:ref/White"], "ColorSlider" :> 
          Documentation`HelpLookup["paclet:ref/ColorSlider"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Hue\"\>", 2->"\<\"GrayLevel\"\>", 
       3->"\<\"CMYKColor\"\>", 4->"\<\"Opacity\"\>", 5->"\<\"Blend\"\>", 
       6->"\<\"Lighter\"\>", 7->"\<\"Darker\"\>", 8->"\<\"Glow\"\>", 
       9->"\<\"Specularity\"\>", 10->"\<\"Lighting\"\>", 11->"\<\"Raster\"\>",
        12->"\<\"Red\"\>", 13->"\<\"Green\"\>", 14->"\<\"Blue\"\>", 
       15->"\<\"White\"\>", 16->"\<\"ColorSlider\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicGraphicsLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Colors\"\>", 2->"\<\"Graphics Directives\"\>", 
       3->"\<\"Raster Image Formats\"\>", 
       4->"\<\"Symbolic Graphics Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RGBColor", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RGBColor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RGBColor"], "[", 
       RowBox[{
        StyleBox["red", "TI"], ",", 
        StyleBox["green", "TI"], ",", 
        StyleBox["blue", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that objects \
which follow are to be displayed, if possible, in the color given. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RGBColor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RGBColor"], "[", 
       RowBox[{
        StyleBox["r", "TI"], ",", 
        StyleBox["g", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies opacity ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The alternative forms ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["r", "TI"], ",", 
     StyleBox["g", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["r", "TI"], ",", 
     StyleBox["g", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["a", "TI"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " can also be used. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->383015872]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23764],

Cell[TextData[{
 "Red, green and blue color intensities outside the range 0 to 1 will be \
clipped, as will opacities. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->483075]
}], "Notes",
 CellID->22531],

Cell["\<\
On monochrome output devices, a gray level based on the average of the color \
intensities is used. \
\>", "Notes",
 CellID->11830],

Cell[TextData[{
 "For 3D surfaces, explicit ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " directives define surface colors; the final shading depends on lighting \
and contributions from specularity and glow. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->23349739]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29642],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Glow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Glow"], "[", 
   RowBox[{"RGBColor", "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}]], "InlineFormula"],
 " specifies color independent of lighting. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->255057354]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->11320],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{
    StyleBox["r", "TI"], ",", 
    StyleBox["g", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is an \[OpenCurlyDoubleQuote]alpha channel\[CloseCurlyDoubleQuote] used to \
specify opacity. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->607],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{
    StyleBox["r", "TI"], ",", 
    StyleBox["g", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RGBColor", "[", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      StyleBox["g", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], ",", 
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Opacity"], "[", 
     StyleBox["a", "TI"], "]"}]}], "}"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->196212995]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->28867],

Cell[TextData[{
 "If no opacity has been specified, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{
    StyleBox["r", "TI"], ",", 
    StyleBox["g", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{
    StyleBox["r", "TI"], ",", 
    StyleBox["g", "TI"], ",", 
    StyleBox["b", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->17786],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"RGBColor", "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " should be displayed with the specified color. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->53708190]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->20574]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3570066],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->34774155],

Cell["Specify the color of graphics primitives:", "ExampleText",
 CellID->149026781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RGBColor", "[", 
     RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64769354],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0, 0], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->562514834]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33200138],

Cell["Specify the color with opacity:", "ExampleText",
 CellID->263465182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "1", ",", "0", ",", ".5"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152479682],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0, 1, 0], Opacity[0.5], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->142307062,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->283521252],

Cell["Specify the output color of expressions:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->53708190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195861199],

Cell[BoxData[
 StyleBox[
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["y", "2"]}],
  StripOnInput->False,
  FrontFaceColor->RGBColor[0, 0, 1],
  BackFaceColor->RGBColor[0, 0, 1],
  GraphicsColor->RGBColor[0, 0, 1],
  FontColor->RGBColor[0, 0, 1]]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78435711]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->109280459],

Cell["Specify the color of plots:", "ExampleText",
 CellID->580206808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"1", ",", "0", ",", "1"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211868938],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1XDtsHNcVXXN3uUsuP6JoibQT20zSMF8znUtViZoALlVKMALICIIItgt3
Kl26NOBmg6RQqcaAyy1VulTJkqVLli/77j33zHtn3qwpyRlIJN/M7Lxz7v99
Zv/26IvHf//noy8+/eTR2V8/e/Tk8aeffH72l399tj41fms0Gn23/v+P09H6
77T+y/5/l9L6d/lztv45Xl/ayq38R7JjtLX+8792x1yujPOPSdcejaZyx7d+
euy/8rEVzVd6zp/9tpcpfWPtd7x9mdLK2re9/X3C/QfSXnj7OvmpaK8b19ae
vwK/fMOFXUlXKa3/epjS43TqZ9aPO7eTP6Qjf8TzlNbP/YqYnq1/prRMoz1v
P7X2ZRrtkuMo0xztvKbMDdt0Dcll5WBGJ45vzfh+Sl+n9CTwfZwyhAvie5LS
Ryk9IL717WeGB/iWxufB6+P7MP/YzpK6BfHnZz5MQPhlFlaWwrkjnOTuL63T
67TvXXxkHzknxtPMZ/3JwPilKeU8MGbLzna3XfxuIDIUOH7M6E5ckvdgZbmb
qzQ69LN2Rz7WYF6k0T6RGFa3MLOHeXKpA9tDE/+twHYCTBeUtluoeyH7Ht3x
XuchMrsxsPxgWk6GPyxrmq3z1M6eZ3m6bCYZ3lnyT+CM92FPnhNTKZ8/pfAe
05jpeGttNXdcbuw9mRq+Toe09Afg8jTtCVLrNDC5VRre3VLn9nMjppU9Kexu
jCet/3zbsa297+PA9k3200Ngtw/4qZAX73UpAgmtYhTYzAycwDC23MfEMYWl
BCbzPhyGF1qkx9rJQGUQKVpHNe1QmYjclibJAaxJPN8sNVoZELq0138eO0Ii
SVADENqT8/GS3tfJ0mgZvu6c+8Y81R7j8u0QZvv/MIX/XJXIokdHVvgD/APE
4H9TD3ZxjjIkHzPJkKHByIf7kkcymB2sti3FP/qd4V+IcIhcHVZKdUva+y7l
4JoP+3shUl5lK+uhLaQ3pf3nnr8sZdrAG/YdeOmfxyJLjT3AG9fzYSEFeBkf
3Sp25Wwb7zJf2IyX8gTeiB2R7akp+H5IKLJCocmaDxCGPlyRcdZMNh/WfeBe
hr/dADe9a1vkioy7kphljl3gfmF+0+F+YHbb4S7tZtRnU1hCET2sU/E5RAP6
HPCabgu8tBPgjWcGXsZc4A1vC2Sl3XR451XyN2Rd3FC0pZT/kOqoOhOpA7WJ
oUBN6wfq0Kihzj0jP9Or1WvnwsZjCc6GDt3oNiOnfmei/yNpj+X+PWEGhJFP
PAuM3Q2L69TnzJXMOByCBgdGmBtwYJ8zaXdV5fOSw2X4IjjQt4GRNgYOq/AR
9V1wiOflw+SjHJLZ2kYOtFNwoB0fSZ/g4LVcx4HxZkswD3CghYJDWTcZH3CI
+3ocss8ixkSUCuzUObDTapFHb1lJmzjyoX6AjTYG7MvSO0quwB7c8mH2NPfz
jPoJFeVskwYYeWYiYbBg5NQ6ZSEaAsrLsDKwoFXiOj0L/TEmaDWx7T8YUxMK
LWcT44lyHBtjWx1b/N6fzGi1I8xRK2stQf0uhPlYkEbcjJp83tYf9b+ZmV2t
Rm8z4aNjd/Bbie0TP/gxd4Mf7W8h8gC/eTUyLzSnMQ+a1JhIeTX4mtU435HM
TDi8gn6Tf26Ct8Yt5upDkQt4048Wosex4J7L/Vui11mh9wbfMucWfF9bv4zX
O9I+FFxT4AI/2j08mLloLvICP8bgmfSjeaDB02xqiKfhGvZP2iP4scYBP9oX
9Ej7Q9VwGZFnIjjn0tZcMWvrmfejP61KeP/2Br4lT22Dd4yXgjflfyjyn4qe
wZt5Q8drc3m+5plZW//MkVORa5t3ROL4PcCS0UQrpEN56lS0sytSmcj9YKkj
PaKetbWv/VUss/d0WXOrizVEDVTMlodtm9H7qbuJ6BYsGINfk8WqrHdqFqVO
ficyRaRghsI8JCOFekDMMESkgU41kta5vMhIW8K+hb70+O1NLBgHwIL2fiAy
1bHgTsGi7G1+MzaVxeXn4Hwx51brfCMLVsJgQa88aPdOXWk2mEivsJxLiY4q
lSE2S6libsbmvszys3bAHC0taSa9gw3tGmg1JymbOvf251GWZW5ssGIV2rEq
vF5rXloK2LCyUi8FG0ZkoF1J5mEb12nBN2SjNTaft1FHfOpCnrrfRkmd7gjL
iehkgNVgPh3L/RFV9HybTZ45y03MoPkEWC4r1/91FDhP5fpaz0ckp+Q+fN5e
cwTurzx9bJ12610qlRZL89uofVNtS222b0v7tt9K/4iBkGZZXwvB58xe5tF/
lYHyHWbuPdvTeMA8jD51hnAsCOz6LN+87JBinqPOtXdaHKflnH2WFzIqq9uK
4dOEcVjkwIlr51q0o+zoSbj+WNitZN6Q2r0Zu5/UZG+U1V2Hvhj355BWc3ZA
4/SEhrGmjDuqDFDkwadvxtkU8mqcZcWtx7mukKe87oE17qI3RiXqkTt1WPt5
gtY/7j7zND6jmVRtJrfHnIPozk9fhbs726i/5j8X2ewWevRKai76KXh/JLw1
o9BaurGmz1kPeHnF2WI5bORm3I+B7NgfEVUzziL/VHOBRZSmzjSvdBGryA86
PpVaoht/duPLJscJQn8Zm+l7Hcv8vN/6VUa+XLFlf0Ie5chHaxfVH3CxWlA+
wFmtIRV+eybzjWcyX8V2W0fn8vQDsYQ9kZLOF+qsl0p/gM2qlw/rOvbnYcWK
7UB6XYhOdCTTjKZFlNb1mgFWWs8qK9oIWHGktJEVPQasOLJfSFtnPGPmqvzd
QHVZRfo+C9Wljpjqiq9gsSpZMMKBBevCbofQ/ZJFvZZSWMy26FpHSv8fVjmu
/9uihPHbhpauTTdWik5EexZNiiyWLMo07/qp9nb3FM+7eE776cXdkXaGe/V8
0Oy1ysCtpydbl+uff1aet6da+OhxSahUxnLeRF99fimoTbm955mK8bm3Ol3N
KsQ/Wv3wNI1+43pmPL+Vap/cYW++Pt3tKnI0HAUiR8IOVxITLsMOcZ0xYCL9
6YzX2B8SlTU03JwR6kWOWKP4tTdYM4Fjvc5dPC3mSuaCDdgZaQa4DUZx1tmI
ZDpK0nmyNiuV0Jl8CuwYtcFOR7SMHBoPt4WVjnVuwrLYjVSx41wL6wk8/dru
ekE21A3Y6Py32GdvdFuvP/XZrKQOUfur7LNgw4qhz6Y/+517vchARh94m5Up
WNEid0WGO9IbWGmm1kq1ntnZEN3RZlU4FilOxEbalqi15fsiu1si6125rjMW
eB5zos5N6hhFWeq6uc5/DbBcVjNMPZY6z/VL6tYt6kjaYMWxuq7YqEXqWBeo
aPG4nx7RHJn2WerovsEy+x96f2mWek12ujeBMt2R3nUXi8Z/XbEIv9FZqAFW
q3I8XtT/9d6yns50FfcXIpPbInMdnehq6VSkoqtsGrlbI+5G5hhit6qy5xC7
K9PZFdkxr4Cdrn1SZroCohY0wK4a3bQi/MCsGHE17++x070U73qb+UvnUXQs
pjsYdN5YV7pb7Mr7daevZn3dDThp6XqI5bU95YosOWq5LU+N+T2MTKsxU7Eq
NVjf61yHxsIBVow6zfEEo8hCZHbqbcbA4xol/XIhupzKdZ23HWD1THYMKitG
Lx3VDLMqddWtf7quTkXDxz9hYQtp61gsdIvz9FuNpRElNPvrGv5EWLdZ6frO
icjuWGSrUWGAlfqlzjxpnTnEjlUC2LF2mgr7ySZ2V6aza7KjZR1L73OR/SJV
K4P3ZH/FUmoIrTe5EgCL08xwJiv4Gq3qaqDHbk/Y3PW27l6/HKoxFqIbnTnF
/boPgTLXGkZj4A1Z1mMIRpN9keFd0c3bgkb9Qdf4tDfN9kCvO3zZHmCne01o
scPsSh2CJf0FrOi1d+QpKvM9YaF+AZaMUlphaXWtO2LU8nXPotqMs4yVmtZe
Rd0tAwmwLoEEWD/cEQQ6/t6T+/X9F61Vx3L/gATuyZ6vyIH5MO3oiMCZ29mN
e910fkn3bGjEBX+dI6dX6nsHms122/xWEvN0H04937Fd7XG2Z78J/9wEb2Ye
8GY0A2+NmUtZsycvnUcZ4K3VO+PJwB7On5V3Q+/MTfquEfhXI8Cci9RetDLV
WQRd+R/YG6h7dUPu+bAYrGO1Id6x51H9HPvFWEvq6At8affQN8cN+8JLq7zd
tj61HhuMZCHf5o6SG/Luz9D1+DNu6YzBXbmua2PdW6gvSv46J1bxY7Vd27GN
0+d+PvwvHxaDY4XE68WI5LHSqqwwu6NzWozmd4WlZs19YamV0q5c1z318z67
S77VUL9da3/X7KLWOBJZ3sJdqPE1p9P3gF7ncmkrOqes71YBJd/jSfA1nH+u
75HCBxkz2zUFdPCjzcZcs82cjipYV/CYMWM1dyJou/ecvyrZVFVxy4PcV8q3
N4oKf1nV0D0uRyJBeBGjxonYh2Y/REud4yTm2Nep5xv2Y9qYvzkXejiwsRKB
tQ3OlHTv8lfjXEbEXeGqb2KBU3w+H4YY50Nm+TCL1N0HbVaI4+rRRAFWgzOR
uj6t72KAlb41U9fx9btB3W6vmpVZ0Uy0UI86dBQPNrS/U0Gjc35gE70G2nrP
Vn/fb12v9+wLXIpdJBWXy6r2G9LQdbxJr5kUnLSCJucD4aA7tRd9SV/xrfqG
BnxPE30Ya5zgwjnkNhetEnU3wzvkOi+50K8PHRP7Tngbcc/PR+/5+IHfVtCQ
PDiEDMt3zrUmHeJAeetIVWcB4RH0Y3CISiAf9lm8jR69433WhZy1NIB9ZXwm
Vsdvhh8jNMZceCjzhM7VbolObjn++Hw+zN/2RaZGKvDzrAWawB969XDRW2fo
8He7LDvf7WZfT219DjPosh+xm4EA7rLWML8HburD9xEsmhLGdyaQ+yhmQxk/
2zK/I3fp7AWwa+yvV7vras8wAHvoCuv7Cznr0gV2z0/mKboveiN2yh3YmeeA
/YW8gV6vZdd5y2QN7KyeTDHxHSiuJYtZxbdDUJfAUNedPeQ657QtFoN1Mo2M
9bp1/c6tRR4gpzY8AsZs40jXESfIRzbG0zn+2sZPRNY6N/6en6RVJnyrwpEj
Cib4doIDP7uMKshCUkjYbe17fsvMBL3Y3fqORlu+J2I/U2m/5yfpcY4Keyo9
PprVHPgZynnk8XwCORhSYHQrM8nrW3eOMVvG0DdS6RgP+Lluqu9uvO/4abkG
J/C77Zlmgd+lbyyA3+3VpAj8nqG6HKT1YLFXJ3Vnq5GqjuFO5TldvL6wDaEf
0DZsPAE/i9WcUf/NnTMTcHyb0wSVx/3Mt1t1vDCbB4d6tfA1OLzjdv3U9P3S
hHgvo/oVZb0E/OPSVsyNMaZ4aCiXrI8uLO5dMT/fy3aVtdztYHjSyeuGmPMN
79I2z+3fKvYmXZltfs+I+URGPS9NiF0F90zeA1vJqPlJNdfxGlL99o0+F3MH
8Q1Y/7Gz/e+AG731PwXg4ZY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->597373970]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19242],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Colors in 3D",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->23349739],

Cell["Use diffuse surface color:", "ExampleText",
 CellID->404625886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RGBColor", "[", 
     RowBox[{"1", ",", "0.5", ",", "0"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->907978],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->441003491,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Use diffuse and specular surface color:", "ExampleText",
 CellID->928327454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RGBColor", "[", 
     RowBox[{"1", ",", "0.5", ",", "0"}], "]"}], ",", 
    RowBox[{"Specularity", "[", 
     RowBox[{"White", ",", "20"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29801507],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Specularity[
    GrayLevel[1], 20], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121426975,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Use glow color, setting the diffuse surface color to black:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->255057354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Black", ",", 
    RowBox[{"Glow", "[", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "0.5", ",", "0"}], "]"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->93466233],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], Glow[
    RGBColor[1, 0.5, 0]], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->590555239,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Color Operations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->304353039],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Blend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blend"]], "InlineFormula"],
 " to mix two or more colors:"
}], "ExampleText",
 CellID->84492988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"RGBColor", "[", 
          RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->485561805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[
      NCache[
       Rational[1, 2], 0.5], 0, 
      NCache[
       Rational[1, 2], 0.5]], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->338245211]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Lighter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighter"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Darker",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Darker"]], "InlineFormula"],
 " to mix with white and black, respectively:"
}], "ExampleText",
 CellID->480333690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", ".4"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", ".4"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->516667508],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1., 0.4, 0.4], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0.6, 0., 0.], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->636162078]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24434],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["r", "TI"], ",", 
     StyleBox["g", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{
    StyleBox["r", "TI"], ",", 
    StyleBox["g", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->383015872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "1", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->432857000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 1, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 1, 0], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->70438]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RGBColor", "[", "#", "]"}], ",", 
       RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1817259],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 1, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->245700764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129929248],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->736955090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "2"}], ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Opacity", "[", "a", "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1", ",", ".33"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162022429],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {RGBColor[1, 
       NCache[
        Rational[1, 2], 0.5], 0], DiskBox[{1, 0}]}, 
     {RGBColor[1, 0, 0], Opacity[0.], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {RGBColor[1, 
       NCache[
        Rational[1, 2], 0.5], 0], DiskBox[{1, 0}]}, 
     {RGBColor[1, 0, 0], Opacity[0.33], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {RGBColor[1, 
       NCache[
        Rational[1, 2], 0.5], 0], DiskBox[{1, 0}]}, 
     {RGBColor[1, 0, 0], Opacity[0.66], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {RGBColor[1, 
       NCache[
        Rational[1, 2], 0.5], 0], DiskBox[{1, 0}]}, 
     {RGBColor[1, 0, 0], Opacity[0.99], DiskBox[{0, 0}]}}]}], "}"}]], "Output",\

 ImageSize->{452, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5423781]
}, Open  ]],

Cell[TextData[{
 "Use the opacity argument in ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " directly:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->196212995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "2"}], ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0", ",", "a"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1", ",", ".33"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72375890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {RGBColor[1, 
       NCache[
        Rational[1, 2], 0.5], 0], DiskBox[{1, 0}]}, 
     {RGBColor[1, 0, 0], Opacity[0.], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {RGBColor[1, 
       NCache[
        Rational[1, 2], 0.5], 0], DiskBox[{1, 0}]}, 
     {RGBColor[1, 0, 0], Opacity[0.33], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {RGBColor[1, 
       NCache[
        Rational[1, 2], 0.5], 0], DiskBox[{1, 0}]}, 
     {RGBColor[1, 0, 0], Opacity[0.66], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {RGBColor[1, 
       NCache[
        Rational[1, 2], 0.5], 0], DiskBox[{1, 0}]}, 
     {RGBColor[1, 0, 0], Opacity[0.99], DiskBox[{0, 0}]}}]}], "}"}]], "Output",\

 ImageSize->{452, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->45558819]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17702],

Cell["Define a one-dimensional color function: ", "ExampleText",
 CellID->88338137],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HotColor", "[", " ", "z_", " ", "]"}], " ", ":=", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"Which", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"0", "\[LessEqual]", "z", "\[LessEqual]", 
      RowBox[{"3", "/", "8"}]}], ",", "       ", 
     RowBox[{"RGBColor", "[", 
      RowBox[{
       RowBox[{"z", " ", 
        RowBox[{"8", "/", "3"}]}], ",", "0", ",", "0"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"3", "/", "8"}], "\[LessEqual]", "z", "\[LessEqual]", 
      RowBox[{"6", "/", "8"}]}], ",", " ", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", "-", 
          RowBox[{"3", "/", "8"}]}], ")"}], " ", 
        RowBox[{"8", "/", "3"}]}], ",", " ", "0"}], "]"}], ",", 
     "\[IndentingNewLine]", "True", ",", "                    ", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "1", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", "-", 
          RowBox[{"6", "/", "8"}]}], ")"}], 
        RowBox[{"8", "/", "6"}]}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188096528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "HotColor"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->416844350],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnXeYVdW5xieIIE1pIffKvdFYQTFyxyDiGV2KimAhiQVLAhcBQemKAiIt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   "], {{
     {RGBColor[0., 0, 0], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1585, 1339, 231}, {247, 239, 15}, {1606, 1631, 696}, {
         239, 243, 15}, {1513, 1580, 239}, {1344, 1592, 235}, {248, 240, 
         211}, {549, 244, 240}, {547, 243, 239}, {244, 549, 236}, {1494, 1516,
          549}, {243, 547, 235}, {1336, 1582, 229}, {699, 248, 231}, {1588, 
         1576, 236}, {240, 244, 211}, {1609, 1608, 699}, {247, 696, 239}, {
         248, 699, 240}, {1581, 1493, 547}, {1493, 1515, 547}, {1592, 1590, 
         235}, {1582, 1337, 229}, {1630, 1513, 239}, {1632, 1514, 240}, {1338,
          1585, 231}, {1514, 1583, 240}, {1345, 1588, 236}, {696, 247, 229}, {
         1607, 1606, 696}, {1608, 1633, 699}, {1584, 1494, 549}},
         VertexColors->None], 
        PolygonBox[{{1631, 1630, 239, 696}, {1339, 1609, 699, 231}, {1515, 
         1344, 235, 547}, {1337, 1607, 696, 229}, {1516, 1345, 236, 549}, {
         1633, 1632, 240, 699}, {1583, 1584, 549, 240}, {1580, 1581, 547, 
         239}},
         VertexColors->None]}]}, 
     {RGBColor[0.196141945886954, 0, 0], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VT1Pk1EYvX3l3qa0MFhKCwlNSLpIbDUtHYyLTsZBa/wB9WMRTMTVbx3U
6CB+IgNtFYghcUDRKIKOMjg4mOAiK5Sh/AjPyXM6nNz7Pu+953nO8/G+oxev
np2KnHNPgX3AyeDcUe/cDxgHe5y7jLUTc+4KbPNx53h4HpgD9gN7fId1EqvH
3Wbcnt9HdrYIzhbWdWAIeIH3l8A1gf0M1hU8P8I+BjwGvoPnHdYloAwEYBr4
BXse/LeDnXtOLuAv+D3WJ8AG9ovgLAR7vxwZ9xdn/l4Dfdi3wVUH+rFvwLYK
HAAO494hapBf+iRnEbaDwTSfx3oB2ML+NDAMtHHmG3SsARXk7BnWD4hjG/ff
YN+KWy43nXEy5lewzQB9sKekh3bmkfkewf43OK4Fyw3r0ZK/mPJEXawPOXbw
nJWdMVMf/VNvJjKdA8Ad8N0Npi9inhDDZGRnJ5Sf9bjlkTGxVrFg7walmXrf
4swnb/U/hrUD1CKrHes2FllM5GYss1gXgII0UEsOGAcq6h/eq6mv6GdLZ3nn
jPzX1H88c5z+vb0jFnUmzb6jJmeaWdu8Mz/j2tNfRf2Zlr2be+aU+X8JjR+9
6WAdrqsW9NOUL/ZSUefpqyr/Y8rDbsxiPaV4ktLTK59VxbMgDQXdKYl7SZrL
0lQST0O66HMUcT0MNicD8s8zOc3cT2d9kdW+txu77LSxl4ZVE9rLPTZTXnWs
qyfX1EsZzatXz1Wlh77vI5Y/3vo6rbzyblHP3NNHVjPL3PwTZ796l3247G2W
2JvdPFIXdaY0nw+C+es+pzRHjMmLn3oTkc3frHKclI1xbChXWT2fAN8Rb1oT
qlVbs5sQZ1L2TenIKbe3cPdmMN+cDWpnjzGX/DYE9cauvj9c29onpIGc3Zlk
LubUP9Q/JV5y3gtW+2nN05DiqIuTeS7rHv0UVHfGvYq8fo1bnT97m+c99f6O
7jY1h7xTh59zwerU/V6zZ6rqubzqmFGNMrJzvwL+Rtxmq6RYtpWToHyOBPsf
kDsE+99QK/8lHeWxpBmgthvB/gfswf+qp7rq
         "],
         VertexColors->None], 
        PolygonBox[{{1670, 1669, 524, 654}, {1337, 1582, 668, 697}, {1633, 
         1608, 538, 731}, {1661, 1660, 517, 649}, {1339, 1585, 670, 700}, {
         1582, 1336, 695, 668}, {1953, 1459, 492, 622}, {1592, 1344, 591, 
         679}, {1659, 1975, 1074, 517}, {1436, 1976, 1075, 653}, {1513, 1630, 
         730, 589}, {1514, 1632, 731, 590}, {1590, 1592, 679, 677}, {1594, 
         1542, 622, 682}, {1597, 1565, 648, 686}, {1494, 1584, 669, 675}, {
         1515, 1493, 673, 591}, {1583, 1514, 590, 669}, {1516, 1494, 675, 
         592}, {1585, 1338, 698, 670}, {1580, 1513, 589, 667}, {1493, 1581, 
         667, 673}, {1576, 1588, 674, 663}, {1631, 1606, 533, 730}, {1384, 
         1940, 1037, 618}, {1941, 1939, 485, 1037}, {1974, 1436, 653, 1074}, {
         1537, 1453, 662, 616}, {1608, 1609, 700, 538}, {1456, 1538, 617, 
         485}, {1969, 1485, 513, 648}, {1657, 1658, 649, 513}, {1937, 1454, 
         484, 617}, {1663, 1664, 654, 518}, {1572, 1444, 658, 657}, {1950, 
         1384, 618, 1046}, {1489, 1978, 657, 524}, {1948, 1951, 1046, 491}, {
         1455, 1938, 616, 484}, {1977, 1662, 518, 1075}, {1606, 1607, 697, 
         533}, {1949, 1457, 491, 621}, {1458, 1541, 621, 492}, {1588, 1345, 
         592, 674}},
         VertexColors->None]}]}, 
     {RGBColor[0.521053770871634, 0, 0], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVt1v1EUUnd/sb34DlAelhbaAJlI/ki76hEgE/wITIb4SQuIDNKRq0oKJ
H1UeKCQ8UMAPhIBGA2Vt6yKYtNK0vPnBSlkUoy2P1CC7sbUJhdWqlXNyT1If
bmZ+d+/cuXPOmTv7yEuvvviKd879CsvBFqXORdi2xLmHMueeg41gPg+7ADuL
mE4seBgxM/jO8PuzsD2Y17zFDCGmLTj3UXRuO77PY34K8+VY8yXmn2DejPk0
bAo2DmuCNcLWYu0h5GtHXBvWdibm3wh/WXG7WAdyjCLmDuZX4GvQ2hU4RA51
jMK/FL462Gr412N8GvZ9YvsNY+yFP495K+wY5k8h36fIuxLfJcxL0c7dgXyr
4PsD8zPw9UY7P78Zyzq7UfN+mMf+Sc7Gb4intz2/xXxJavgSWxpxXgX/f9jL
Ye0OxN5MbNyKscfbeq5dg5gy9o34vpTYSH8F853e8hB77w3/JchXQPxr+H4v
Gh/kgniRP+JJjHKK34Hfe6LlKqGuPulgnzcMyDu5+lfzFcj/dTDcupR3o7Qx
o3kVYzu+d2IcCcbZHXFK7PLOsKLwruN7N37fA5vEdxPiL0fbj2eij/WSh5XC
fkbcMF9LamdlLdyPvOel58XSwBbk2wy7iFxzwpEcDeD3fmmFvBDLpc5qryjf
UZx3XTB9zXrTD3Fgnu+k+U7EdMCmvdU8Kn+3vsnPrMZB+A/6BT73ejtrITEs
yO3PsAdT44R1fIbadwfD+BrmLcH0QZwuB1vfp3Ow5iH430Q9fyKmqPtFrKjr
5mC81mWmFWK3F+M7sH+84dsmjqhF4kFcStIw8fwAOY5kdk6uJ7fEn1jWC39i
y3tI7R3Dvh/CHtD9G9Ed5P0tak1OeBA36uKSsChyr2hckhfmICbXgmFBHHjO
mvh4G3VdhP9vfJ/GOBRML+R+WWranJEWqdWPEXMyWh95A2tfh93D2t+lqU3O
etIL0XC5gbgJ9Q72pavCtwnrGjPj8wRij0fjcBjjD1i/Tj2I3PJcHcKadRxC
TH+wHuCR44tgOLPnNavvfQ5fgt8mMb/rTU/U0rh6KTVJHXBeUG+4KU1PqecW
dD/6xGMltf7NM5J7YsZ7US+9kMfD8G1Q7dXU1oyl1lefgf3iDIOq/MTurmq7
hfE3WB0pTW1OTU0J3+elMcZRZ2PKz3r4+5Q4mFD9POus8g8nC/fqrM5SFVbT
Wsv8R4HtuWA9mBqoSt9V3W+ekVqbUz9kDV3SRoO0SQ0Tmznhw3inPk/t/aXz
EpMDem8m1et5LvKwVVwMBOObPuJxS5hE3V3GEGvmoFY2CGv6DmhOzH9EnpFo
HMyJO+r/Xfjej3b3rqtO6o36S9Rvid+TuotO7xbPchI5B6Pl4fu4VpoZg/98
tDXt0ODLsNvetNSv+x6lK56BuC3Xu9yoO0I8yUmL8GUP6lZPpG73iceq4nep
p4xJD8TqtrQ0IS306o6U04V9ylp7VXrkvtR4RX72mYPqNay1IsyXqb/8Xx88
10/qy+TiNHB4NDMf32pqmtx1RuuJ7IfsR4f19s/D90RmNRPrcd3Tx+B7PDMe
+Q706E0P8F0IhltDsLeW7yx5YF8hF19F44kczbPHZqbzNRhbMtub+NwQd/zv
UA62D/kp6e6/hdiuzLRLvq5I6/XidLt6XV556BuQv1F9m3W2qh+Si6Ly0M/6
arpTedXTqjdhQG9VTb17UD2nqL4zrZwF3fGaYhapfmrtPkAwcO0=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllMtvTlEUxc+93z3nfLQDxOOr0qYtI2XU4H8giLlIDFqhJfoQbx20BgZ9
UfWqVxGv0JK0SmumQdJ4VGKuAwyIRAhB+e2swUrW2nuffc9+nFuxbffmXalz
bj3IQFVwbso7txbRlYo/js6tzmSbQBeIacVXjV4EL2D7m8j2Gt6GLck5V4N/
mLMj4Ce+Z8Tk8Q2gS/E1YrsMb+DMDnwl2PrRnphq7rIAPYp+GHX2N/Gd8DvE
v0fXoV/C+0EnPIKDnD0EfqX6Zhn8APgBHyZnA3yG+CL4R2wd8Bdghnxt6Cp4
ZVDteVCOLkcfh+dS1dYO0pxq7OY+KXoJ+WZx3zLim7FN40uJb0ZfQ5fha0Lf
gI9h+8b39qbq7Rv0mkw9vo6+Cr4mOlMalNNytYNudA9YSP5xYi4R+8CrdwVw
Bd2Bfzu+xegM3odtDrye83vQT4ivQn9GJ+g69BbipxPNImBrSTQT8/Vwfnam
mAH0o6jZTqFHvGZqs7Q7D+HrtRj4SmKO4asAE049s1m98uqtzcx6W+k1O+vx
sqBvWO63iXZllVcttjPnomqyWuahi+FN4At6Hd84g7/WazfmZqq1KKjXVnMv
/pNgK7mL0Rvgm8BoTj0bjNpx2+0VYBx+M2p2NrNb6J3k+2D7kKm2VvAnVY0l
XjOzWdlO3feakc3GdnoMvhz/O6eZ74NPevXqO2da7FtRs7Udagyamc3KaryA
7yKYn6mGw0E7brttO78/KKflsp13QXe2u9aij6KPBL0lu/MgvhNRvbAdPgU/
G9W7T+R/6tUT60WfU+31QW/HerAxaiY2C+vhPeK70PlMO2P8rtfbMNtt+D+v
u9gbrvF6Y/a2bKefe71Je4v2T7FdWsr3xhLt1OmoO9rdbKfPw4e8/hXWk/8V
Y5SW
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.845965595856313, 0, 0], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l1lsV1UQxm/v/y5GpfDgAlgsQrRUscbEB/QJAg9VEyVqUsQ1KmDcACny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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllFmIj2EUxt//f+b93mzDhW1EMbJvKW7cWEsoZF+HbEmWmJlcUNaUJfte
iKzZwmAMisYyxjKScEuuibgxtt/Tc3H6nue855z3fGd5O81bMWF5PoQwFylE
ymMIF1IIJZDyXAgLwFPQ1WP0tiCEXvDeyAFwNfZtshDaIr+wPQy/je1pzjvg
Pwher1joqsCL0FXAy5Hz8E/EeAZuG+07jfP58IXJd50g5lTOdhG/BXwNco+z
N+iakc8+ZCl4J+dFygeZAp6E7iVnL5DW4GJ0G8G/iTcC/yXwaeDL2K/l/C7y
HV6BzR1wGbIS/A3dMmyXIh/BC9E1BjdBfsBHk/NjbFvD1+Vdg1XgMmR13jaP
wY90H7ZDua8RuCo6djk2f/jnGnIaVWib88l3KHYndJXYPkQ3ArwSn6fwrcgG
fBvgCdtV0Wdfcs79VjTWP+zCdxF8FjwjRh28Dn4NPgM+NrmGql0V8iC6JqrF
T2wmgmsy5z4c2QM+iO4zuBVSiv9c5CV4B/bjwOOTY/XkH86CzyTPkmaiG/5/
o2t5QPmBXyABvAWZHN1D9e4VcgXfR+h64NsdGQDem/luzdQpzvtGz5pmoDd4
O+cJ3B1ddXTNVWv1eAh4MHINfh25iv8WbE7mfEd99MxqVutyrn1DoWOpBzPx
3YzNa+K/w38qvAA+PXjmOusMn8XY1qL7yXdo5ruKVY/MOuEexNgGHxONlfNx
8Gx0H7D/qv2I3hHthnqmWXmIblPOM1Mc3VP1Ujt1DnwvenY6Ijvhl6J7Hwud
2+vof1OOqsVIeG3eNemTnIPuPlTgXpcl76p63hM8K/pMb0DA/x+8XfCO6K0Y
hu5G3m/GK/h1fPpxV39kTnKP1VvNjHanJfxy3juk2jZL3nXVuBJ8I/mtUYyL
0f+kf9Gdu+E3k2NXcn9TzZfs8t5B7Upt9O5rZ5TbjMy9U47Po2dQs/cPm/vR
NVTt9AZeUmx024LfoMPwQ8mz3ZzzI+CjyVg7ploOT35bVNPZ8IHwYwXu6Xp4
UebdUg87g0syz4reNM3Sk8y7ppmSbym6N3nHqIneCe2CctLZGeR9zjZd8e2S
+W3cj7TPXCPVRjumt7Bd9L/qTdTst8r8lmgH/gNgdsZW
         "],
         VertexColors->None]}]}, 
     {RGBColor[1, 0.170877420840993, 0], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNWHtwV0cZvb/c+9stbaEQp0gpFCi1OBbpwxF8ja1W7IydgUIbMm0gaEkI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllmdsV1UYxs/t/d9zLYoMpSoWbAHRSBXExDoSxRGbaBxpDY2sCmJilChB
xGrENAQ0oXGPgBic+AGoCKUISgSkWqC1anHQ4tYqDowDqYoEf0+eD0/yrjPu
O55zy2fcUX17UQjhIVAAnTGEDjA8CeHKNIR3kLeDk9EvRW9Bfh2ci1yC7RPk
HlCDXob+C/JPYBTydGzrsxDmgNkcsh/bpug9tLYS/w/IvWAk+jT0b5C/AiPQ
J2k98mtgMPo56FPZqzsP4XkuW4XtcuTLQEDu5Yw1xK4C/dHHEv8W8lZwEfJQ
bJ8j7wXlyBOxfcraDbojekPBa5vAWan3qMH3Lnpj4hwMJn4QeIQj5xOzB/lN
Yu7Dt5D1XegrMt9tFvpJ6CeC5cQvSJ3bD8BVqXM8HN8w0IT/AWwXIJ8PetCf
Q/+Q2I/BtcinqAb4lqGXoa8Gbcg7wRXIw/DX4m+OzlUrGIM+D/QiPw3WILdy
v3+IvZ98PUvsEnAkeM8m/GfjP5W7jwbV6K9G53IzOIDt1uhcF7NmBfILILLf
6fjHaz1ox7c0da2mqqcS10y1XAfGp65pEWe1RvfWYvQO4juwNSPXEX8m+hT0
CYn3WIm+i/gq4kfhH4k+AmzmvMXKiWqDvyLxN6xGvlo1Tl3Tt6N7Qr1wMfpY
fONy31V7tHNWu84s+A5vZK6xaluF/wzkity51J0Osde/YC6+WdgmI08CY/At
V88QW5q7tuqBWnzXs2dp4p7aEz1Dmp1qzRCx5bm/RT2xO7oHVPtrsB0fXSPV
Zj41WI+8DhSQx2FrYO9t4CDx92ArI745t68RvQRfG3oN+jL2T/EfKng2b8N/
nGYNNOB7CtuA6BqpNvfi34J8bPTetcRcqHnLXYs+YkrFFcSswvcgMW2aH/zX
4V+ZePa+BLWpZzDBVwRmo89jzdHIx4B69Hr0PmL/BrekznEJvhNyz5JmUFzz
K5iRmnP+QP4TzES/E/9/yIeja3NXMLd8Byan5hhxz4+gLjUHfYt8FHd+InFM
JWedl3sW1dO/4/8NzAk+I+A7Er23vqElM6eISyqx7cNXjO3JxGcMwDcwN3co
x5lql/vb52I7SPxf0XfXN/fDVwzuDs7Jfnz9MtdG3xzx5bnXKqY9mhPEBZoR
9fLQzLVWTx8uuKaqpXokx/d1NNc+jj4B+RJwQ2JOncL6jdFcvVMzKi5UjpDz
xL20I3Nt1VM3oS9C342/KzW3PKP+Tc0xyu330VyvHCs3P0e/FcrRhmgOE3fp
jYn4P4vm6sfwF9C7omfhYfSt6HvFeQVzsLjoJXBaak4S92kG1PviwGnqHdbU
E9+h9wR9WzQX7AKb8PVgW1vwmzAd+b3ot7ATZKpv9Kw+Kr5F75971sU5uotm
RLOhO62N5lBxpzhvJvLNuXMjjtgRfQedLQ7fEp1z5VpvVh3yjbnvKs7oZO+W
3LOlmX8/OifKhd6UL6JrqlpqxvoKnnHN9j5s2zNziLhDb4Bmcwi2xuAZHZ35
DdPb1Y3to+hv1rfqDVLskOi3Q2sqMp+hvdUTmn1xuLhbHKBcbszMncppd3RN
VUv9M+TRM6NZ0T/CK3obM/eWenCp5pl1ExP30ED0QdFcoxl8MfpN1Fuomovr
X45+i8T5/wNR8Bg1
         "],
         VertexColors->None]}]}, 
     {RGBColor[1, 0.495789245825673, 0], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuUllUVxt/ve9/vvGiulWCKrNSVFZouuclMFy5LZoYZATPuBDLDbVUr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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsV0UUxd/r65tRQKCtWFREcMElQWyxqICBElFxiQFS0ooG0yhKkUKN
SwApGoyt2A9qXbAtCorGBSXue8RqImoAoxRtAxqXoMatgopgQX8nxw8n/3Pe
vTP/mXnn3nkjaxfOqC9IkqQFFIJjY5KMBHdlSTI+TZJJ8KvyJHkK/SQ4E90I
euFrwGnw00EbvJL8QeQWom9Et6Ob4WeDtej9mceWgfbMcwwm/1D0YngH+fPh
dZoT3svCHiReAabCO3n2ZUiSr0AV+fWstx+5h4BTU8+xgdhzoILYaHQDYzcS
n8LmishZQ2w1yOEnEH+a2DNgPfM3MOZO+BOMOUCsD4xDnxW91wsY8y1jvwM1
6IXkLyZ3m/bL/JXoPehS0Aq/nDkHwv8lv4H8NsaPQI8lvwP9HrpLZ82zteQv
YY7t6HvRG9DL0J3ovv/nPp/fy9DV4DbGfqAz5VkP+RP5r7HkTCZWGf2uDqKv
gZcTn0x8O8+Ww2fzbFKB5xgDvxnsyvwOL4Y/Enw2L2fe25LcZ6c9am+beDar
0HucCy8Cy8ntAtfBh4Lb4T1gpfYXfZbTmKMWXsz8t/D/W3k2D30tGEPs8dRr
OQ60ZF7TTv5vGbg08Zp/YOyP4Apii3T+5K7K7Y05xPexrl70LHh96rPcmzum
M/2NsXvAXMafmNobOkOdnTxyGLn7iS8g/pDWBF8HRhEfxbMF5B8DmuE7wARi
nYzpLrCHJqL75faSdArfrTOHNzNff3gvOVcz9gH0APSf6HnoVegS9A3B3m9i
jr3Ba9Ja6jJ7fYDeSWbPb4bfQ3yczpb115A/J/dZbwGtuT0lLynnPuL3B8em
pF57EXppgffQCX8X1PLf52SuPXlWXlUNrsi9R+2tC/wM/yn4XVxJ/lvBe9Ze
J+gM0W1guNZOzj74AVCPPomcj+EfBZ/XVJ69CZ/B+KHE7gAz0efl9nIVugPd
DkoTz/k6/DUwE12Bfgn+IjgXXYbuhveA6Xp3PBvCWZSCFeiy1LVRDNalrpH+
8jN6deozfpSxjwW/e/3nEdGel9c1R19wjau2tafdwe9U71IeC9E9Tr3tJvRR
6GGgSWfLszS6Z6pXXq9+GOwReUPv5G704eTcmrlGnke/ELw39bhuchfl9rp6
wKDoGlNtNYKS6B6g2tccqg3VuGpbNbKVuT4B09DzmW8bvAtcolpO7N2a6F4j
D58Bbw32jnrYFvhmUJd4ju/hu4J7o2q0mPyBYHTqHvEXsT90nqk9XxLsKXlJ
PeH34BpVbapGcsZm4JTUd0oCP0j85NQ99Z9gT8lLqtkmrTd379U7vRD+cLB3
1PPfgW8M9rY8o162kpzy1D1tOrwq2Hul4A3428Felid/gf8a7HV5dkR0T1Av
0J15dHQPVO/TO35fvTr3XBcVeu9/B9eyzmB89B2ju0V35CvEXg32sjxczdjq
4N6oO3ET/MPgWlGN7oTvCPa27sSW3HeK7hLtSb2zEQxJ3UN1ljHaizpTnWVB
tPd0pp+hPw32gjyQ5N6D1j4beXz0N4K+DdSjj4yuKdWSev4XjP082DuqueHR
npfX1TPlhcHR3pQnyqO/IfTtoG+Cbxj7dfDdrjt2WO4ep96mO3Jp7jtRd6H2
tJ7cZ4PvevXo/wA5YA46
         "],
         VertexColors->None]}]}, 
     {RGBColor[1, 0.820701070810353, 0], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2mIllUUx593ed4HGyFTQwOD1KxEInMhc5lxgUCbCdxixohABTdcya0o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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllElsjXEUxb/3vf7ftyiR0AVSC9S0IqmIea4EMbUlHQgxJFVJi6AtiSEW
pYYQFTaURFBiiDExb8whhKRa08KGjYTWFILfyVmcvHO+8x/uu/97b+/F1YVV
cRRFi0AWWBKi6GYSRaMQWako6od+jq5E38EvQ/8AV/FGgwPwWvyP6Si6hX8b
vpJv2Xjj2DMOPQGcwi/mW0UmipaDQi6dg+7F2qf4S1l7jP0H8Kbw7T5+Lnve
wMvxH8BzUo7tC2tzIsd4F92VNY3oGegT8GFgKvvbWL8J/wi6nf1fQS68AyzA
v4Kfh1+O3ou3G+yEvwMT8M/ilxJPHvoJ57/g2yT0fNACvwT24b0Hk2Ln5Bbn
/SSOIawfw+94dAH+y9g5WAY/zP6+8NPgO/pb8H8/z/4CvMngsuID7XilIB/v
DCjK+AztVY7q4EPAWHgt/nX8f9w7g/NGsmY6909L/JYX0XvwK9At8K5pv22T
4k/5jd8G51y53gxewwfrfM6rSfm/7g3Onf6zcj0AnIud81nwjcF7y2LH9odz
61KOUbltCP4vyvFM+Prg2Eti19JB9Ke0a+oz/Cv7m2PXzKrgPVpbnXKuFga/
jXJWxP516NuqR9Uc/mz0I7yH4JpqLzg3I8CG4JgVq2Jczv5t6Fdp52gX61/w
rYoYOqH7wwckrpUL5GSQ1gbXsmqyDK8UzITfS/usEs54FvvMG/CbGd+tNdPw
D6H7pF0TR+BNqrnI307CT8hHZ6Mb4ftAd3gP0Mr+tuBcqOdU2zuCa1c1rtrd
n/Fa1XBPeD7fJuJtBSvUK4lrQ3esgq8G79DDOWMFfA17jsNb+bYdvQP81d18
qw6uedV6F/RvvXdw7z3lvLXBb6K3UA3VB/eselU1/SvLM0OzQv/5A/4WdEfa
NbkSXp0414qpM7F8UU+oVsDmxHfqLvV4M/6pjN9KPTgUPz/xbFLOBsEHJp5l
e9Dd4DmJe0EzRLOgX2JPM0FvvzPj3KsGNuk9E7+tZtI8eE1wbyimusQzUrNR
NdyQuKfVy8qZenMu+nHsHtUsqUycW82UGvS6jGeB3kizQzNRs1AzpCR4Bmn2
qKY0OxuD30oz9GjwzNOsUw7nBPeAal93qhe2gPqUe6JYbxH8duqZ/7USx7Y=

         "],
         VertexColors->None]}]}, 
     {RGBColor[1, 1, 0.0728064478975165], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVktsVVUUPe+ee99FEhnozMTEl4j8EjswMaK+10kVtJiYSnRgQqBVI1Io
mviYaBTwm8ikdaIOtPWDONAYGbQ1r+0TMHVia5yYkLZQhFoKNYVYSaDiWqz1
UgYnZ9999tnn7LXX3ueW2rva9iQhhBmMiFFIQ+iAorUQQj/kq9BhCr/nIRwq
hrAS+iZ8r8J8L+aOgnQlyKth82wWQhnf38LZLZjvgv4ryA/A5zXI7dA9CDli
/hX2d8K+375W2HcfDuxN5aMTuocS+eqL2ndbkA+eHb2+uyCbaLvbYXMWPs6l
OretoG/KA9YzvpZE5/8A/RC+/8KoYWxmHLhfYhy4lz7rmEdSnfF51Mz7DKby
ezqRDdeIHePm2TyXui+sb/dd6XMtzlmH0YO1EwXNZcczmwhD3mvGd6PuvPWc
5yx/H/VNHLuQq71FrW3HGICugnEG8jQGwrvhnxiXjD39Ev/XcZdPYDCPtSr0
5UT5HoK+KxPWv0FeDXkM8gbY/ehcfQbdG1gbh/wR5GmMnyE/Dl0rxtEoQv2C
cR3yDqw/nAsX3otcIVbkH32MQW4pCJc6443LOG1KdD5tuPe049qa6BxizLxM
m3tHsHiIOYVuCrrJRPmdcd63QJ7wN+VrsL+aqR7eB5bvYWTwe9xY8j7M/4i5
cT9sD2NMQL4A/RxGc0HYk2fkGG3rrqs61n9iroNivRFPEDcH0mXO1M23gzj/
AMb1RP4vcj9sjkX5WmWujtg/eb3xJm4PO64Y9T1mfc0yMRiyzQHg9CdieQTy
mkyxMS7mbBQ2k0FzzXIahSv38h4jUTXNddq1Wld3vOTQM+bbfpx1JlP85Nox
x/Iu9G9h/GvO8OwJY9hvzC9hns+Ud3Iq+KwF+LmE8SVUj+aqZ+aafGkxZ2qu
qUn3B/KGPjfD/qVM9fQx5tdyYT1q3rYaV55xNOjMgvUno85t4M6ZNqeiOEAu
sEfenavGn4C8NRcW5HTZvNoH/dO5+EH+Drq3DDj21H1s0Dypghf7MC477suO
vbGH9sRxMSqn30XVPvsG+xBrgX2s6vwxLxVzl3HQ54Lj2oO7/Y2xyzms3mQ/
Z042W+ZeYsy6Is7bEmFEP+xLU1FnrIe/nZnu82mm/sJc7UdMByH/B9suzHtz
7WEcLcaK51zwufOWeX4T/JzMxKkFzLcWxb1zkCtF3ekbzEeK6mGPwfeuTH2D
sa3wu3QY619jrI966zr93l2E7Ubon3Sv3m0c2Av5JtHuw0zvHGvxSqoeSju+
XQ1/HxT1vlJeg/kejG6s3Ye9dxSVx273HfKDsXenyuMO84ZYHDemFee3z28o
31LK5D97B7EkVlX4fypX/v6BvJgpP+x5b+bqe/S1lAhn7lvy3p5U37wDa3rE
NTvmO/E+w+4n7De05Z4lz92Wo7EouX5HXed8M5pdO8xvxTxkjbb73dzgN2el
+dvrGKO5MR50Bs/i/Tn3GDfmY1uyXJ/N9v8K4n45V702sOPd1gKT7ZlqhPGd
9xvUB93bsL/CusK8KRf2rDXqeIdFf1NeYM/M1W+IL/s++0YFuueKepdq7iWN
t+Bs41/FuR93LJQZF9/b3ky+Jo1pyf8/bcaK+ee9EttMud55l45MdoyVa9xb
Np/qxpD4M+/cd8p7+a8x6/+Nnbj7i0X9X/wBf+sy/fs8D90LRe3pdJ3QP98n
1k3qt2PYPOH7mjrGWf/3NdkmWk9bfm8x76knVuTyq5n4zLfrnVy5/h+Nbn5d

         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllE1IlFEUhu/9vrnzRcv2QUKWJtGiTWRTG82sCUqsdqEz/Zk0Y4Fj9AOp
lQXOplrVov/UNhG0KFpl0baWgYiTkgtLwyKz/57Du3jhPfc937nnnp+vKlds
KUTOuSxIgXxwrhm0ctjinSvDu9POfcEei507nTh3nbNZ+CcwgDaCHfFxCns3
+lrsevyfY+/AbgY5Yj3Broe3o9+D3wXHsSvYDfhXsE/C93D2Av4SbII3cPbL
6Zvl8G9gP/5PidmEvhVE8Eexci2Br5FyPgI/DCbhU+ACvn/4/i3xFvEvoBXB
R7QZcB79TpD2HVQZB21or7ijA96Y6K4VxDgFrwFXsWfAT/R+4v3DfxR9IaiG
VjvLuRNeBzZGqsnRoBzs7sf4DBJrmDOfUkMs18voIVbOGfTNYCLSm6vRf4B2
7DfYtWjVIOOVUxe8AJ5hT8Sq5SzY5VXTBe4YIv4atDxn5/C9ZfWB54l5G97L
WVOkswP4HgSVSDmU0T7gk/WagaGgN1ju405v+R0Uy95kvchhP4jVk0tpzZDN
jr1xJK0ZstmpA8PYg2CpV45jQTNis5Hh+yJ8J9gHP4bPqkQ9s15diTVLPdij
sWaqj1i94G+kHq1EX53I12rWCi/hX/KK2WW1Ceq1zUgZ+2FauVlOtWjzKe3K
BvT32GeJMYe+xavXVmOrrfX8EN/WcLbMqYZZ+LZEvV/iVZt3QbGsRnvR5rEz
Tm+4EbSDtnt2h+3OtaBdsB3qR+sDjV5v7OG+9ej3nXZiMihHy+01mILfDJod
6/FFvh1INPsWw3Z5MaXa2k7bv2F7ol22f8SZRDNvs27/BJu1E4l22Wbuc9Ab
7W2dXrNqO2O7YjM7h92R1m4Gp10rJppV27lu7HVBvbae2KxNg3GvmWsL+qfY
v8Rq+h+AHqZM
         "],
         VertexColors->None]}]}, 
     {RGBColor[1, 1, 0.235262360389856], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVT1MVEEQ3rfHe6/jsPUhf8VBgASukRBFE6Mn8cATDP0dookWYK8WgspB
tDUIBcSg0Y4GqAxGMdR3NQKSaGiMlYUkJn4f811MbvJmd2dmZ775Zq91fGp0
0jvnliApyPXAuWPpXTjohhxC3wtsfQr6XJ1z7dCPoDd726fNOvYboSeQXdgP
Q/ax/wrrPKQB8iN07jvkGvRc7NxVyBoum4fvtre4jMkceNdZ6GlIFXoZNr1a
7wcWj/du4bsMaYJMRs7dQ/wSzm96i10MLK8zkAPYr+KbhXSoPubP+hi7B1Kv
+N3a/4l4lyEjWL9JWdxCYHa0rwifgDk52+sVPsSkR3q/t7xolxUevIdYTXjD
i7nSjjbLypm5r0BaIS3eekN82Lc+5cJ1J3K8H5l/B/Q7kZ2nlU+9as7q3hJs
zsXW8xnYHmM9rrubndVCP+J+JPznpGe0z9jEg3mzX/Qtyf8v4j2NrbYc9j47
6yPXVfEjJxyJIdeJerRRZ/1k7cPI7SJifYJ+A3ohMq7k8R0Irf8t4g35wDPy
KaP+JIqfKN6BODwvHicA9Iu4lxZOzHMqMj6xngVv8dLiZkH13sb5RGRr8oNY
sj9j0Ke84TAXGRas+wLwGIiNR/uqmfm8x/lsZFxIxAXmnIP+3Bt23eoba+yo
zQD0RW8zRj5tqx7WMuTtrMazPdkH0mvztaC6iElZuL2VP7nCXqyr75zjr5A2
zdwHcXQaNc1AfuPuWXyfQf6kbM539Q6Mo75bkfkXNQfMoRIY78gF4tcnjC8B
k5ewP52yHDbFiTVvcRmTc3k+NuzfefsS/z7sH4VWA3u7q/eBWOTFk6xqbNDd
O+LoIvwexLbm3f3ChD2pqi9tmkny7gps74ZWE/2WQvN9je+T2HwGvWHDWh9h
71toveV+RTELerOISZPwbVTuW8qfd37UW/AY2ExH5t+v95N5kkdlcald9dN3
VX1l3YPIYSg0no7AdjT6PwOb6jXfhmJoPeGb/SI23NmrHc0u34yHse2x34Oa
bXKK2GUUr105dGlOWWO9cK/qndzQ/wdnlutEPKA9fifzvyLuMfdfyp/zOaZZ
21Qc5j+v9yqjPrUqTl4xDsW9nPA/qUmzVutZRfe3yLdNOn27gFlnZLPHfh6q
p/8AcxbPgA==
         "],
         VertexColors->None], 
        PolygonBox[{{1492, 1579, 665, 666}, {1853, 1352, 595, 933}, {1852, 
         1377, 334, 593}, {1593, 1517, 593, 680}, {1686, 1614, 1081, 794}, {
         1589, 1591, 678, 676}, {1598, 1510, 586, 688}, {1586, 1340, 701, 
         671}, {1591, 1335, 588, 678}, {1916, 1434, 455, 610}, {1615, 1347, 
         795, 708}, {1508, 1922, 1013, 584}, {1343, 1587, 672, 706}, {1666, 
         1667, 610, 465}, {1341, 1586, 671, 703}, {1587, 1342, 704, 672}, {
         1924, 1927, 1017, 466}, {1495, 1577, 664, 566}, {1672, 1673, 612, 
         476}, {1635, 1612, 546, 733}, {1577, 1346, 794, 664}, {1638, 1637, 
         335, 567}, {1925, 1442, 466, 612}, {1926, 1508, 584, 1017}, {1435, 
         1917, 582, 455}, {1614, 1616, 708, 1081}, {1519, 1390, 623, 597}, {
         1610, 1611, 703, 732}, {1636, 1854, 933, 335}, {1512, 1492, 666, 
         588}, {1506, 1433, 652, 582}, {1578, 1511, 587, 665}, {1385, 1322, 
         569, 352}, {1386, 1864, 597, 353}, {1511, 1634, 733, 587}, {1648, 
         1647, 353, 569}, {1618, 1610, 732, 709}, {1612, 1613, 706, 546}, {
         1347, 1617, 709, 795}, {1352, 1862, 944, 595}, {1933, 1449, 476, 
         586}, {1863, 1861, 352, 944}, {1376, 1320, 567, 334}, {1923, 1665, 
         465, 1013}},
         VertexColors->None]}]}, 
     {RGBColor[1, 1, 0.333333333333333], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1492, 1512, 529}, {1616, 1614, 707}, {246, 238, 1}, {249,
          702, 241}, {1614, 1686, 707}, {705, 246, 234}, {1586, 1341, 233}, {
         1612, 1635, 705}, {249, 241, 225}, {1613, 1612, 705}, {242, 529, 
         227}, {238, 242, 1}, {707, 245, 241}, {529, 242, 238}, {1634, 1511, 
         238}, {702, 249, 233}, {1579, 1492, 529}, {1591, 1589, 227}, {246, 
         705, 238}, {1587, 1343, 234}, {245, 707, 237}, {1346, 1577, 237}, {
         1611, 1610, 702}, {1347, 1615, 241}, {1610, 1618, 702}, {1617, 1347, 
         241}, {1335, 1591, 227}, {1340, 1586, 233}, {241, 245, 225}, {1511, 
         1578, 238}, {1577, 1495, 237}, {1342, 1587, 234}},
         VertexColors->None], 
        PolygonBox[{{1635, 1634, 238, 705}, {1578, 1579, 529, 238}, {1615, 
         1616, 707, 241}, {1512, 1335, 227, 529}, {1686, 1346, 237, 707}, {
         1618, 1617, 241, 702}, {1341, 1611, 702, 233}, {1343, 1613, 705, 
         234}},
         VertexColors->None]}]}}, {{}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1340, 1586, 1341, 1611, 1610, 1618, 1617, 1347, 1615, 1616, 
        1614, 1686, 1346, 1577, 1495}],
       "0.8`"], 
      TooltipBox[
       LineBox[{1342, 1587, 1343, 1613, 1612, 1635, 1634, 1511, 1578, 1579, 
        1492, 1512, 1335, 1591, 1589}],
       "0.8`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1390, 1519, 1356, 1864, 1386, 1646, 1647, 1648, 1322, 1385, 
        1861, 1863, 1862, 1352, 1853, 1854, 1636, 1637, 1638, 1320, 1376, 
        1851, 1377, 1852, 1348, 1517, 1593}],
       "0.6`"], 
      TooltipBox[
       LineBox[{1433, 1506, 1505, 1917, 1435, 1915, 1434, 1916, 1530, 1667, 
        1666, 1665, 1923, 1922, 1508, 1926, 1927, 1924, 1442, 1925, 1533, 
        1673, 1672, 1671, 1449, 1933, 1509, 1510, 1598}],
       "0.6`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1266, 1518, 1641, 1640, 1639, 1378, 1496, 1321, 1265, 1981, 
        1379, 1353, 1866, 1867, 1865, 1387, 1323, 1270, 1703, 1704, 1676, 
        2003, 1677, 1706, 1705, 1873, 1325, 1272, 1982, 1391, 1357, 1876, 
        1398, 1875, 1397, 1327, 1499, 1400, 1877, 1399, 1878, 1521, 1549}],
       "0.4`"], 
      TooltipBox[
       LineBox[{1319, 1334, 1447, 1932, 1448, 1532, 1531, 1920, 1440, 1919, 
        1441, 1921, 1507, 1439, 2001, 1317, 1529, 1914, 1832, 1833, 1829, 
        1371, 1828, 1831, 1830, 1313, 1528, 1903, 1904, 1902, 1906, 1905, 
        1504, 1428, 1998, 1309, 1525, 1526, 1421, 1653, 1654, 1655, 1331, 
        1562}],
       "0.4`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1280, 1988, 1409, 1360, 1620, 1361, 1621, 1279, 1723, 1362, 
        1722, 1725, 1724, 1281, 1522, 1881, 1882, 1880, 1407, 1883, 1500, 
        1501, 1405, 1406, 1359, 1403, 1986, 1276, 1328, 1401, 2004, 1402, 
        1358, 1393, 1984, 1274, 1498, 1497, 1392, 1983, 1273, 1520, 1868, 
        1695, 1696, 1693, 1354, 1694, 1381, 1619, 1350, 1687, 1349, 1856, 
        1857, 1855, 1380}],
       "0.2`"], 
      TooltipBox[
       LineBox[{1299, 1652, 1899, 1898, 1628, 1603, 1368, 1624, 1416, 1897, 
        1896, 1680, 1812, 1811, 1895, 1330, 1298, 1989, 1415, 1369, 1523, 
        1303, 1992, 1418, 1502, 1420, 2005, 1419, 1524, 1308, 1997, 1425, 
        1503, 1427, 2006, 1426, 1527, 1370, 1913, 1432, 1912, 1431, 1333, 
        1312, 1843, 1844, 1683, 1684, 1685, 1316, 1625, 1375, 1604, 1605, 
        1930, 1931, 1929, 1446}],
       "0.2`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1267, 1689, 1690, 1688, 1692, 1691, 1858, 1698, 1699, 1697, 
        1701, 1700, 1869, 1708, 1709, 1707, 1711, 1710, 1874, 1713, 1714, 
        1712, 1716, 1715, 1879, 1718, 1719, 1717, 1721, 1720, 1884, 1727, 
        1728, 1726, 1730, 1729, 1885, 1736, 1737, 1735, 1739, 1738, 1962, 
        1963, 1595, 1474, 1553, 1552, 1291, 1776, 1777, 1775, 1779, 1778, 
        1292, 1781, 1782, 1780, 1784, 1783, 1293, 1786, 1787, 1785, 1789, 
        1788, 1294, 1791, 1792, 1790, 1794, 1793, 1295, 1796, 1797, 1795, 
        1799, 1798, 1296, 1801, 1802, 1800, 1804, 1803, 1297}],
       "0"], 
      TooltipBox[
       LineBox[{1889, 1741, 1742, 1740, 1744, 1743, 1284, 1746, 1747, 1745, 
        1749, 1748, 1285, 1751, 1752, 1750, 1754, 1753, 1286, 1756, 1757, 
        1755, 1759, 1758, 1287, 1761, 1762, 1760, 1764, 1763, 1288, 1766, 
        1767, 1765, 1769, 1768, 1289, 1771, 1772, 1770, 1774, 1773, 1290, 
        1596, 1411, 1555, 1554, 1890, 1807, 1808, 1806, 1810, 1809, 1894, 
        1814, 1815, 1813, 1817, 1816, 1900, 1819, 1820, 1818, 1822, 1821, 
        1901, 1824, 1825, 1823, 1827, 1826, 1911, 1839, 1840, 1838, 1842, 
        1841, 1918, 1847, 1848, 1846, 1850, 1849, 1928}],
       "0"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1268, 1642, 1860, 1859, 1351, 1599, 1600, 1601, 1269, 1702, 
        1355, 1674, 1675, 1324, 1271, 1539, 1275, 1985, 1460, 1394, 1543, 
        1461, 2007, 1462, 1395, 1465, 2010, 1464, 1545, 1466, 2008, 1467, 
        1404, 1472, 2011, 1471, 1550, 1408, 1473, 1987, 1277, 1551, 1282, 
        1732, 1733, 1731, 1363, 1734, 1283, 1623, 1364, 1622, 1365, 1887, 
        1888, 1886, 1410}],
       RowBox[{"-", "0.2`"}]], 
      TooltipBox[
       LineBox[{1318, 2002, 1445, 1374, 1845, 1373, 2009, 1629, 1438, 1837, 
        1372, 1834, 1836, 1835, 1910, 1568, 1971, 1972, 1970, 1486, 1973, 
        1424, 1564, 1307, 1996, 1484, 1423, 1483, 1995, 1306, 1561, 1302, 
        1991, 1480, 1417, 1479, 1990, 1301, 1557, 1414, 1967, 1476, 1966, 
        1475, 1556, 1965, 1329, 1964, 1679, 1367, 1805, 1412, 1627, 1626, 
        1602, 1366, 1892, 1893, 1891, 1413}],
       RowBox[{"-", "0.2`"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1278, 1548, 1651, 1650, 1649, 1470, 1547, 1546, 1960, 1468, 
        1959, 1469, 1961, 1396, 1957, 1958, 1956, 1463, 1544, 1955, 1326, 
        1954, 1678, 1388, 1870, 1872, 1871, 1947, 1540, 1943, 1944, 1942, 
        1946, 1945, 1382, 1935, 1452, 1934, 1451, 1535, 1536, 1450, 1643, 
        1644, 1645, 1534, 1575}],
       RowBox[{"-", "0.4`"}]], 
      TooltipBox[
       LineBox[{1300, 1558, 1477, 1968, 1478, 1560, 1559, 1304, 1993, 1481, 
        1422, 1482, 1994, 1305, 1563, 1310, 1908, 1909, 1907, 1430, 1681, 
        1682, 1332, 1311, 1567, 1314, 1999, 1487, 1437, 1488, 2000, 1315, 
        1570, 1571, 1491, 1979, 1490, 1980, 1573, 1574}],
       RowBox[{"-", "0.4`"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1444, 1572, 1443, 1978, 1489, 1668, 1669, 1670, 1569, 1664, 
        1663, 1662, 1977, 1976, 1436, 1974, 1975, 1659, 1660, 1661, 1566, 
        1658, 1657, 1656, 1485, 1969, 1429, 1565, 1597}],
       RowBox[{"-", "0.6`"}]], 
      TooltipBox[
       LineBox[{1453, 1537, 1383, 1938, 1455, 1936, 1454, 1937, 1538, 1456, 
        1939, 1941, 1940, 1384, 1950, 1951, 1948, 1457, 1949, 1541, 1458, 
        1952, 1459, 1953, 1389, 1542, 1594}],
       RowBox[{"-", "0.6`"}]]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{1336, 1582, 1337, 1607, 1606, 1631, 1630, 1513, 1580, 1581, 
        1493, 1515, 1344, 1592, 1590}],
       RowBox[{"-", "0.8`"}]], 
      TooltipBox[
       LineBox[{1338, 1585, 1339, 1609, 1608, 1633, 1632, 1514, 1583, 1584, 
        1494, 1516, 1345, 1588, 1576}],
       RowBox[{"-", "0.8`"}]]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->460568891]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "HotColor"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->703730849],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx11zGKFFEQgOHFmwh7j4lNPYJg5uo9DEREDDxFB7IaNAx4BBOFFQQDE3HZ
1Ex3mq/h/Y9ZWIp/pnte//PqVdU8fPLi8dMHFxcXf///38ft7+4ofr++urm+
+r3zp3u8+bXz28tHby4f/dz5x+n6m53fnd7/svP7E38+jussK365vX/Ar7b7
d/66ff7Or7f1d/6wPd/O37bnP4zr3ZV3z0a+mC/mi/livuP3uKyYL+aL+WK+
mC/mm30rT164kS/mi/livmOeLCvmi/livpgv5ov5Ji/L077VCzfyxXwx3/Ec
LCvmi/livpgv5ov55tyVp7zsvtULN/LFfMdzvqyYL+aL+WK+mC/mm7pSns5d
87L7Vi/cyHesY8uK+WK+mC/mi/livqmb5amu9Nw1L7tv9cKNfDFfzBfzxXwx
X8w3faE81c3WlZ675mX3rV64cexHyzr2o2Ud+9Gyjv1oWcd+tKxjP9r7Xnnq
C62brSs9d83L7lu9cCNfzBfzxXwx3/T18tT32hdaN1tXeu6al923euFGvpgv
5ov5Zm4pT329fa99oXWzdaXnrnnZfasXbuSL+WK+mcvK09zSvt6+177Qutm6
0nPXvOy+1Qs38sV8M3eWp7msc0v7evte+0LrZutKz13zsvtWL9zIN3N1eZo7
O5d1bmlfb99rX2jdbF3puWtedt/qhRv5nvsd0Tm7c2jntM4x7fPtg+0TraOt
Mz2HzdPuYz0bn99ffv3nKPLHz7Z4yPvTfa5zPz4X+zm9r8/R53bdx5Pv7VHc
vp7bs683WqfX9fWu33WaN339zLqHf60vYeA=
   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJy1mH9IlHccx58c1HL9UOuiVMZto4iDha1s4apH71SWYJl1TGqsdmCNozG3
lZnEcIQ0F9RYWa4S2oqgi7KxotgqlUJTotQmLbzMmbqmaWdDqqNoMvw+4ee7
V3d/2APHl+fN8Xm+z/t5fz6f9+f7huez7NwIwzAeD/5eMdQVMNXq/u9qNiV+
sKIosPNZg4YX5766/9zFWg0/nb427vyqs9Z97GJ76uNz901j2BUwM2oKjsQP
3NVwe3BmxJn2PzV85bD9Pcfbbnp+eLD7NwuP3uk/MX/NPfE/w0gZlxj9YVmn
hudsexh/ZUurhiek/TSxr6tJw1v3ZO+yfVCt4S++QvMZe8C2ZXNWnYa7b0z/
fn1SpYY3jzVKpjoOW/c5ta5TBW3yvQNmZn5KQ+tAl4Y/fbOh9i1/W9g8F9ZN
nlfT8fy9J9yeVJy/uk/jIWJH9I/+DfK7GoZ9RWJqTEO7ho+u3PvxhvEtGl42
oXTW7JWNGt70Qv5D65P4dJevqG7/9Jh1X5UZM7GnXr5fwHR2TospevC3hr/j
yen29HdouCN5zOhrR2+HzXNUc/riM6NqNNxXt6By35NvLHxq3nuuZk+PztsY
V7r3W/m9DaOi2vG07C+ZV8z/DNC/2o9aZb6rVeqT+PzDVu919nWHrdsM18I5
xXeljgafu3puyYJ9t8Lmec3ee06/vV7DN35XFfX12l8sfBzovMjc3h2zTu6b
+X8d9L8E6o/aD9VPynfSJ/F52rbo8y9672h4EOpD3sWOnMslUi/Mc9HV7Ycu
pVzV44h6onBH8MuUWV8dCcn/FND/KKg/SVD/1XOpHxFvlO+kT+KTdFvV03nF
V3BTw93Ac+DCpVvPZst6OfhdQOfEv1fo39qnqD+R8F0iof+qONTfqR9R/STe
SJ/EZ1rLpKXx626EzXPutT2rdriua3gv8F8I+nfDdzGg/nvhe/mE/1E45ePL
xom3kcKzRwjPGiFc+k+FS7+kcOrv1I+oflK+kz6Jz2TQ/6+QL17Ir+BH/5+P
dsjfAcj3WFEfyM+T/1RxpF9SuOzvCqd6SPWT8p30RnwSb4+AnzToL29DP0qD
/uUU/Y7mI/Lz5D+pX6vnyv6ucOKf6ifxTPokPk+C/yHeksBfZYEfswn/RvMm
zUfkJ8l/huKf+jv1I+KZdEv6JD6bwP+fhXlBraVivlCrb2geofmd5h2aj4h/
8p/WfqD+UH+n/kL1k/Kd9BmKT5uYf9WaCPNy4dB8TechNL8T/zQfkZ8n/6n2
R36JeKZ+RLqlfFcr6ZP4jITzn/Jh50X6RechNL/TvEnzUSg/T/6TeJb9XeGy
Hylc1k+FW8+H84dCOP8ph/M3Ov8MVsQtq3M0anhv/7SWf1Kvm3mlXVEJviqN
n8S4lsbXtp7UcPq/E/4vn/soxH4Ip/i0z3DjZ77fu8m/ZDD+J8k9NXP0OITL
OBlDcSTe/nPX8f7lv5sJ73bnJ005qMUhnOK87Pj/AtdEx7U=
    "]],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->211736638,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVnQeYZFXVrledit3VPdOTEzkjMOScGYKACPorSSSDZJQcBJEsGUkiGYlK
0AEFJImOgCQJioAICJND51BdVeu5d6+1ztq1T6o6hnufe/9n/pHqru7pPu/5
vvWttfc5Z6/DTjvmqBMPO+3YIw5babdTDvvuMccecepKu558ivlQNgMAT5r/
f2QqmP/+X+a/+P+fRETzicjfU8zfWfMGj17RfyD/H3jmP2eY/6D/zTqfA3ov
yNeFP5fm62Y0+ff4/TA19Bn+aK7xGmBa5CPF0NdMiLwj9298l2ktfxL+LWCc
+TsXcyyi75/gv9P7f+w3+P/vmP87P3Ee5byc/G/9pPrVy/0f/gndr5n0b/+k
7neZkfInVk0X/P9VHRed49bs89NDnxc9JzmP/E1fm+QH9H1u1d8ZSi1/i3zk
I52hrwkfmVyL1//q+//Trw+/v/wffj56tsix9NHw/8W5eJpju2roa1YJvV45
9Hr10Gs559JRpZ/xJv9//6Wz4Sb7EcR9EPdG3AvxK4h7IH4ZcTfEXRBnIe6I
uAPidojbIG6FuAXiZoibIG6EuAHiTMR1Eb+EuBbiGoirIZrfdUXE5RGNBIz+
pmB9IlYnYHUcVsditQNH23G0hKN5HM3iaAYrgMOAfYBLAOcD/hPwY8C/Ab4L
+CbgK4C/B3wB8GnAJwAfBXwI8GeAdwD+BPDHgFcDXg54EeB5gGcBngJ4IuB3
AA8HPAhwP8CvAX4FcDfAHQG3AdwMcEPAdQHXAFwZcAbUp8DoRBgeD4Njoa8D
utthSREW5mG+B18AfAbwd4D3Ad4BeB3gZYCXAJ4DeApgNsCjAA8B/AzgToCf
Ah3Q6wCuBLgU4IcA5wGcBXAawMkAxwN8B+BwgIMBDgD4JsA+AF8B+DLAzgA7
AGwLsCXApgAbAqwHsDbA6gCrAKxgrMS4D8BEgC4jWoB2I35gvJF88e/Sd9Hv
7qDfKQ79pogbI26IuD7ieojrIK6NuCbi6ox+JcQVEE0dmE7ocRLWDfrxWBmH
lbE40oEj7ThSwpE8jmRxOEPoBwB7ABcDzgP8DPDvgH8FfBvwdcCXAV8CfA7w
KcDZTP9BwHsBbwe8helfBXhZK/p7AX4ZcCfAbQE3B9yI6a/J9JeD+lSoToLK
eBgaC/0d0NsOy4qwOA8LPJgL8E+AfwB8APAewFsAfwL4A8ALAM9wjHwc4OcA
DwDcA3A7wE8AbgC4BuBHABcD/ADgXIAzAU4BOAngOICjAA4DOAhgf4BvAOwN
sKdzAmwDsAXAJgAbOCfAynwCTOcTYELwBEigr/Wm4PxvgHUU9M5B0Fsjbom4
eVPQxt9WVpkb0Kacm/o3EevjSeaVLhwai0MdONSOQyUcyuNgFgczOMgyXwa4
EPALwE8APwT8C+CfAV8DnAP4IuCzgL8B/BXgI4APAN7DrG8GvB7wSsBLAS9M
wXoW4HaAWwBuDLge4FqAqwAuD/VpxHp0PIyMhcEO6GuH7iIszcMiD+YDif0T
gI8A/grwtor9dwDPAvwG4FemaWCx3wdwl4r9eoCrAC4DuJDFfjbA6QDfAzgR
4BiAIwEOAfgWwH4AXwf4KuPeDWAWwPYAWzu41wVYS3Evz7gnB3EnsJ4SZtsE
7LYJYGP9W0Ss/m1EjOOx3kX+XRmDQ5040IED7ThQwv489mexP4P9LGKx8M8B
/+FY+KuAf2ALfwbwScBfAv6C2d4NeBvgTYDXKdsfAn4/Hdstme1MZruqsp0M
oxOgMhaGOmCgHXqLsCwPiz1YCCRlMfK/AbwL8CbAqyzl5wGeBnjCkfK9AHc4
Ur4C4BKACwC+r17+XfXyI9jLD2QvF7x7BPFuDrAxwPoA6zDe1RLwpmWbEmzz
wuy6s4jWdCbjsG4K8xisdJJoB8rY1459JezNY28WezPYq6KdC/gpG/T7gO8A
vsHlWQxayvNjgD8HvB/wLsCfMttrAa8AvATwAsBzAc9sxXZ7wK0ANwFcH3Bt
wNUAV4D6dKhOYbZdMNIJg+3QV4SePCz1YBGQdK1N/wXgzwCvAfyRpftbgF+z
dB9V6d4NcBvAzY50L3Kc+lQu1capj2an/jY7tcH7NYC9GO+uADsBbAewFcBm
EbwrRfCmZfvlCNjtg2CTElfUjUW07MZGtNiF9TFY7cSKceMyiba3DbtL2J3H
7ix2Z7A7KFrXkP8I+DvHkG30MmxvBbwR8BrAHwFeDPgDZnsG4PcAT2jFdlNm
+yVmuyLUZ0B1KgWwyjhiO9QOA0XozcMyD5YALAjasslgbwC8AvD7ZOmanuhG
gGtZupeyM58PcI7jzMeyMx/qFOJ9GO/uALsE8W6keNcM4pUwlpZtKEy5YKNR
ukmZdd2YRYtjsN6B1TJWTJltIzfuLWJ3AZfmcWkWl2YIrCtaMeS3AP/kGPKv
1ZAlWEmsvoHZSqw2bM8BPB3wu+nYbgC4DuDqgCtBfTlmy/FqZAwMlWGwCP15
6PFgKZB0Q7YsCWsOwIvJ0r0F4McAVwNcziEr5MwnqDPbwvsNDdqCd0cnaBu8
Mx28Kzt4mWWjn4owDaXjJKDNc1MU6FjETqyXsdqOlTaKTgNF7C2QWJfmcHEW
F2VwUUSskpSlT3o+YsR3O2HZtkrnA54NeBozPR7waMDDWjHVhqm+PFSnwehk
ZsqldrAEA3no9aAbYHGcHYfappBk71TJSucU68jHsyMfrgXXYP0fjs+x/ZPF
amuuJOi0em0JNhqIm5RXdWEjVuzAejtW27BiMnERBwpUYbtzJNZFHi7I4AIW
62cRsbpGPFuN+D4tshKOpRGy4diwPRnwOMCj0rFdU9lOh9EpUJkAI13Mtg0G
CtDvQQ+QZGPt+FVtippL9pqII5/BrZE48lFacA3efTlP7a1x2e2OQnhtg5SW
7Y5xbY6AjXY6zXNTECy2Y72E1SJWCtTvDOQoOnV75MJGsQu4t00SbZIRS5G9
NhKOTwU8CfBYZnso4LcA923FdhWorwDVGcx2IoyMgyGOUcQ2C70Ay5LtWJKU
K91fBKVr+6AkR5ZWSPAeoHhDcXkbR73rO3hXSc82CWxIsdFAzG5cn4H1aVif
gnWeWNQ5E9fZjettWC/iaBGHCzho+p0c9mRxmYdLMlRe53Mv+5lOrd5j0Up6
cpPx42zItqO1RVbCsbCVcCxsj3TYfl3Z7qxs7RBrTWp/6itCjWOUsB0e48co
w7YPSLpL2JY/Z1v+kG1ZGlxJUiLd36h0H1bp3s7SvYHDVBNnPkbz1Ld1shXC
u4PitYl5XR1vpGVrJ1ChNseCjXY6Tpk1YGtTsTYZaxOxNh5rXVgbg7UOrLVj
rYS1Ao4YsAXqZXtyuCyLSzxcmCGwc3kc+QngR9rySDvrjipmc7F9WIvtbU6x
lXB8QSu2XwXcndnuALg1s91IxxarckReDmoypRpHMWq4DENFGMhBP/jSlQb3
0zjpvqRB+UmAX/II40GeV8oI4+ameE9KgdfWXtsQbaB407KNBbtBgmIj+anO
YKuTnAlzJ2ViU2aNG1fzOGzcOE+VdlkOl2RxoYfzMz7YT1m0HzQ15EecYnub
FturnXB8biu2ewDuwmy30fHjTG1tV/InkLVJUB0PlTEwUobhIgzlYCBDeLub
SvcPHJSfVWd+zJlGSh90c9PCmxLvjtoQbe4MJ9OylZmxnTiF2hwLNhqMuczW
jWIN2Ik4Oh5Hu3B0DI7a1YMCjuZwKEdubCLUkhwuyuJ8D+dmqMx+qpX2/WCK
ChmyFNufOdOK652J8vnc+LRkuysvLGyr48aZ3NquztPl5QGnQX0S1MZDdSxU
yjBSguEcDGVgAPxE5Ur3fZ1NWek2ceafaOG9mufNl+iCg8wgW+KVwfMuitcO
IzdMz9ZdDIj2r7GKdfJT3VgxLwyM8sJApRMrZWp6KiZC5bGSpZFxX5bcmMBm
ca6Hn2d8sH/XSvs2z6BkvmgM+bdOQhZDvscJUtc5E2Rhe0YKtrJssKWOpNbh
NmgVmkrhdMDJUB8PtbFQLUOlBCN5GM7AIDQSVZJ052ioss78C8eZb2O8N8bh
PSsFXtsYyTjDzpo3bd3XulHYTppCbY4FGgnEJjeZ8lo1SuU5cWOxx1TYHI54
OOhhr8nEHrnwPAPUw08zPtAPeNVHKuxrvPAj7aydGVsjvlsD1I06XZRwfB43
tafzEOrEVkxlhGzHFWv6pRZnAE4BnAD1sVDrgGoJKnkYycAQNOx4QZxkX+Me
9/cJjixZ+TbNU9fFxeWUWHfnIaQbmtPq1U1MsWBXiVeqjCdMIK7xAsAozxJH
yjjShiPFxkLeQAZ7MpyJM+TCnxmwGR/s+yzWP2uFncPtrCzq2VHFA9z13MlG
fEswHF+gjc9pOoQ6phVbaX+ciOyznQo4EbAL6h1Qa4NqHioeDEPAjufp/MJK
VnrcORqmnom0uVJwk/JUS7z78jhjH50x29C8bXq2bmKSKGwnTsE2x9ZWd+5k
Op0aD4lNea20M9gSNTvDORz2cAhocaebV2gXcLMjuUnK619UtLbCvqBG/Ks4
I75JA5Q7OT6Tm9qTU7N1I7LGKJ/tOMBOqLdBLQ9VDypAdtzHdiyzqS+C0n2L
pWvDVNSRpeC6eepaXeG/MAXeA50h5F7B0JyWbTQKNwc7OTBQrJtOhwPxKM8U
SbEFysRDWRxyVmTtWPETLa9/0egkov2DtjxPO4t4Nj3dpqK9jgNUKBwL2+N5
eHwE4CEp2EpEdmIUTvLZYjvUC1DzYBRibPmzoHRjw9RsdWZbcN085cblJngP
C+L9mpOqdm7OdmWHbTQxSRS2EydtcxpDJwHb5U//azwsNoG4UvTL7LAB65l/
z5z3p9DK3VJeBJjHDc8/tJN9l+1YspOo9nnteWY7w2PryDdzS3uNVttogjqO
p8iHAx4MeGAKuF8K5ygcDziG4GIB6lmoAoywL/eCv1Ywj6PUJ452/xxJU641
P6yVNzZQpeF7MK8h7B9JzSl1u25CFG4OdqxOistYMy1sieZOJhBTfuIya9x4
ULfM2PWdz9SQJUK95UQoEe1T2vLEpigR7Y90EhUNUjJE/jbgAYDfTIc2GKdw
LGAZsAiYhVom0ZY/5lUDmSwnhSqZYhi69yfkqpZ0j+KlhEOCdCVdpWUbLbBu
JJ6B9ek0mDD9a2OayAux9Y7G8g7V2CJvjslRszPAeyiMG/eqIc9TQ/4oGKGa
aFZSlDXkGx1DtpOolGx301Hy1jy22Fjbn4SSi22Aeah7LZT7QVNnbon3ajXn
izQ5n63jjJN51nwsrxQdESy/kq7Sso36sBuJZeI0hQYTtQnONLGTrNgodrQN
h9twkJfu+nlY3Md7KHo4Qi2LpKgPghHq5bhKK6KVFHWnU2xlaeAyp9ie1Yrt
3oB7Omy34bHFJrpSICU32ZWNdJtU3Y94+vheQmZuidfW3su0MTqPp1UyjPwu
rxTJzpuoPadlm+TDGontxKnKfWxjmthOVmxq7JChWqR19l4eFndncVmGSuwS
BTtXC607fXL7nuedOcVjwRR1Oyfk2ForQeq0FGy/rKNkYStt0HrMdo2YTgg7
AEtQz0PNFN2mzvxh07rbHO+NivdK7ntlnHG+zppP460ZIQEfwhs0DkjPdtUY
H24U2EmBidMo97GNaWLRXwLoK9AGimW83r4ki4t59W6hA/aTuOmT7XusaN3W
514VrRRb2/1cEsxRp3Jz25LtLjpu3NJh+yXucldLTss5qGahkmnhzH9NaIma
45XkLI3RVTqtulCXEqT8WgEfFxRwWrauXNWHqYPV5FQ3PjyuMXmqcB9rp4my
BNCXp40US/K4KIcLs7TePp9rrAs2dgr1Ig8rnmHR2sGxm6JEtDckBCnJyNLc
tmQbjVNScq0tBxNVvQS1AlRzNMcYiXPmfwbxRnNVGrw3O+X3R1p+JV2d4wg4
FLDSsnXl6o4mZIGdk1ONtyeGJ0/c7pg+diBLi+3LsrRDZkEW52Vp/vQFh6cQ
2HcjUyhxY4nHv2TRurMoV7TXcLF1g5QUW+l/jufBRUu2oTjlltwV44YYJagW
oJKDER5TRZ3ZLbyhXNUSr/S9tyre6zVdXabp6vwEAR+dnq2trlauMprQnRP+
dML4cNmfPA3byRP1sdjvYQ9PjBd5tLzzhYf/zFC782kc2DciU6in1I0fc0Rr
Z1FWtGLIlwanFlJsT9LBxZEp2EbjlJTcldiWnURVL/P8scjj5RwMeyTd0BTy
82DhfY8Lr+SqlHhlKBkqv5KubHt0dkTAadkGq6uVa2Ovk51O8I6nEd4/MSST
J48uB+jL0AZUmRjPy/DyDq8GfJwANpSNpe+RnvZhFq2dRUVF6xbbM51ie5wO
pQ5Nxza25EpanuLMlstQbYNKkVeEsv6Cn3XmhXHObHNVS7wP8NRKhpKh8ivp
yrZH5zkClg6p1frP1EBV9WXKuxL9PU5tzlSiQMP/YbbgQc+fSvQ6PY5bWD9M
Bvo7bWR/E3Hhn3GFvUNHUFGxXsBF9pxIkT1aB40HtWJqY1RsqZ3qJ6n6GF4O
audVviIM52Eo66/R96ojxxZcyVNpsD6oSwmhsiup6opk4abVq2u+dtBkwJYJ
LJZoj1OtiNUCXZlXkXGT58+IB8C/vmOpToply5PME//WFKx1YQv2QXXhpAor
YnU72lCRPVzZ7p+C7UYJpXYa2/EEqHdBbQxUO6DSzgv0BRjKw0AW+jP+7qml
upQbLbiSp5rjfVRnzffFld3rnLYoKtyUbGsTdRgxjrKSv7uprBucirQVZrTg
zxGH1X+Fal+yaK1i33YCcRTsbGeyeL8OoG6PVNgreFRxsSbjcyJF1gaog3mB
wGX7Fd4itWuQ7WYcozYI2rEttVP8JFUfC9VOGC1DpY3wDhVgMAcDni/dJnjf
Y7zN1fsrXkr4BS8Eur4sZdf6sg1WlzgCbsZ2ssN2PG9/Gac7YDopK41yVR1l
qiYHD/HGxIEcXYvV58m4yUNTbc4jxTYB+2cFK4HY7WJteW0u2mu15XEN+Wzt
aFuy3Ye3NsooeRaPLbbl9mdzjlEbOkPHkHQncRPURc5spOvjLZJ0Bx1nbqle
iVR/4oboDzzOeJ6HkU/xSsLsiIDvcQQswcptfMWif5jIVq/NjLv3R/g6zVoX
ER/pwuGxONyJwx04XKbRoh+Q87wVNd+YQ3V7gVGU7ExNgv4GQ5fRRbTDFaf+
RVNBR836+063K+EqDffdeFy1I7e9Wyt3sewmsh5P/W+9k9FLUS7QrrlBLxV6
G7fe0FHHHJ1DP6viftIRdzR0iX3bWG1XHRK4M9umd/bIhul3ktIN90HzpwMH
yzjYTlPlwSJxH+R9b7052tPoT6o8ujhEJlXzdengs+Qm6RVFH5u+BP0DQcnf
4tTpq4J2fn6wVJ+s0bo5/WhjLAFbTH1mgvC5ZlOHLCdAGUY1afsnALQ4ASSY
vafdcugEeI7l/3SC/O+NnANuCU+gH76fhFx+75wMrc+GMu2OM/o350G/+dOO
/W00h+4v+Bfg9vD8YwlvllvAGyHn8SZXOwWRxYaPElK4WP+LwbLuds32VEiq
7JdrAYgt7hLKv5PibIgt8Rtqgou1A60E1FZzRh8tQaXAJ0S29QkhSf19rQeh
cv87xxSeijOF0DkhzZicE/+RF/B5ciO9pOuFZE2pjaj3tmFPCXsK2MPG3+Px
lQg6H5nLm+pMJ/1P8Kck/9D2633d0hFK6VLzn2PwsV21BX+Hbs5y47pU/ou1
CLjF3xYBaciOTME+GgFsKUgyA60GNDHjtnu0yPhzrfFLo/ahxoF3g3FALOFF
TgTPqiW4kf4h5wy4Kxj7UO7bk0sgrndtCdd8un6oSKvCg7zM1FPEZUVajVjG
lyUs02HJfN5h9zlvsvvEGZl8qL2YLE68FWnHJNw94wT3XyaAlogXje+XaMoT
y3fH29bypfluydot+yHjl2YtJPWpAe/HDqi3K+58a9zSl3/sVADBbSvAHzkA
ukXACv7xBOK3M/HUOg/ffyh8F5Zqjvru4RwF+b4cX4vCO9sXc3l3M93nQWl/
wNxli8A7Tqh/NdiwSa7/jZp7KNrfG0Ef6sqtv0vWOyfYm7sWfziP09LQt2U/
avQhsUe83j8BSjBaaH0CyGDm06Dj2wjwOkteUoBr+k87bd7jPKdxzwEZ1bRI
+vq/EdYeVjzqwwc86tisjS/kS4/c8B7y8L+qjb+tK8t/0u7t905nLk7+hFbx
RxT0/cmgr3VGa66fS7I7I9irW0uXUcy3eddXS9ZS1GONfQ1H7DPY223S7+KF
zDItiFSLrXHLHO7zOId/x0n9r0ZM3rZ9scR/1rxj73DYAo4AbdQa4OlKj05X
Fpr3m3PxMkplLtgPnOJsbdu2Z6ES/ZSW6F9qPHu4lYKvdUJa1L8lp53iDMRD
Fn4Qs92vFVtbtJOMXKSc4OW0Tl1qjVfGrPMijm6burc5wr2RYOrPJBNOOWkb
Vbb9PDbrhsaAZR40wNqsbXdIiym/rqY8R/vu57Uk/8aZpYVasDRgk9z5VCeD
Hxdn0Acw228E2e6ubHdy2Dax6VV1HSTBqbEtAa/TrS/TxZEkv/6LEk6y7OcS
NJyS7WCQ6qII1WiWDpmwleuLwUT9hFNwow2VgL1Vo/WPNXGF0rWI9vsq2tOD
g5bY4hti+1UdpO6mbfcOGsC2TJauVOHmeNvZnEuavfMBvH1MuNvx53lOAv+4
FWGr4Red7lwmNLObsz2zwVZMOEr1E9VqbHZ2Tfj3kQTt+vAjyWBFsTdxlA5N
T6wbx1ZaN1M3Z/s1HpLLQE1GKrM0XG/D0nWr7gaRqtsSb9nJ2gUdtWR5ip4B
8AxjWC6qYFnA/kRF/GECYluIf+90W+LUTdie1WC7WLdoRalaB45NxnMcqqF8
7Prww03BimKbuPF5TQ1Zim0atrG2LNJNcuaWeLltbrRSJZ6k8QIYLZLwIN0z
JRhmWAG7FVgy1qcJgKUOuzJ2jTqlJ1uknwWp/lWRilbfjEvCNjNZuYbysFC9
n9eZk8Bep2BjZx0WbBNDPjIF21hbdqUb68zN8Uq0kkapzHOxNn/5eogJD/HG
hCHeVtTvVGDpmOaxhL8I1mGXsGTpt5w4bY06JdtPFam7P+C9YFqyWo0mYdGq
UI3mYUv1bp5fy+wqFJ7EigVsaLYRAhs1ZBGthOSWbKO2HJJuqB9Kg3d8Q8A0
9izzQkibv4I9zPtOhnnXmOws6nMELEXYQv48SFiytAvZLnG/nJqtragh+7VF
VdKS1eqLEQcWrcZW13sdqrfFgb1aa+zlDlg3G5/tgD0lLiGLaA/T5rY526gt
u9KNOnNzvDLTdATsr3PpCvYIL3aM8KbAEfD3BdqNKEtZw4u5DC8IVmIhLPMv
F7ItxinZ2hGEFeobkaIqGTjqwCJUKa1iwiG5hqjewsnJBStyvVyt2C2z58aB
PTk4hQ6JNg3bkC2HpBty5uZ4pe8NCriBl1cyKzzPrPCW3gpvyLcCliJsIS8K
Zq3PnKzlQpYxV0q2bjkNCdVFajOwq1UbmEKl1co1StUtsK5cpca6+SkWbChF
hUQrg4s0bGc5Q4yQdF1nbol3WoyAaYMCE65yxjI9cJV3bFf5eotRvlpqEPxB
h2w4spAXO4SlFEchv5+arSQkt5yGvPeZYFG19vuoU1fFgd3SertmpliqVzmR
2Pqw1FhRrA3GsWBtioqKVgaO+zZla225iXQ3TIFXhpJxAqYbRfDmwBpv6a0V
aUN+LUeX09QydDFcBfyd+RZyrwN5iVONQ5ClMW6xY1MMV5KR28g8k5CPXIE+
GBSoxN/bWaO3BmmGqqrEpUuDMj0/WFvPaAq0uVhTMm0u2Q1aYZVhZFS443nX
GO8sqnN0rvPwql6gq6TqWbrGUciOMtxhB26fM8sKRS03TKfUa9RwQ0h/FVdJ
rUBdqrHOGw3BrkwvdAYTSaHpuwpWyqsbi6Xlcdnur0Nkl62MpKS1tQPlWSpZ
F+8W2gcJXlGt1FxJzLbfXZUJrxQkPFWjsxJ2pxt08WqJrnHEPF2hTIQ9vn2E
Rzd/Gc40dnD3OfKNJdyM7VcabJ/VWJRkuI8kV9K7klOSSzUagq1c04CV3BRy
YSvaZLaegQvb0Lgx1P5IqU2Dd+M4Aa+lw8jmhCPxSgYcdAlrG1+AXuAL4vJ8
8xe5+CLHN1zLgddvsLX1e3Qv2x6P7kC91KP7xy/y6GkQ872mbMc02ArPJ+Nq
KPP0jExhhcRKKvYbS/Vq1eoVEbk6VdUzWKEU7l/Vij0jWfPZWNEeZj57KH22
Gdu2JtI175hFX5/A1zOAYW0fcayCxaNXT0A8zaFsI5bomFcIhbJ/4VSJpx0l
vqFekW6HOVAwP99AHqDYn4PeHPTkYFkOluRgcQ4W5prSDXz0lwC7kfHGllPr
vfckFNWbleoNcUHpRyrXSxNy8Lmq2Di25MYnqiE30e3B8XiFbzvxTZYvE25L
VPBmIJTb4lXMlM071qSzJBbzDPPZ6fT4rJBjd+k4SwaWHXxBRpnvqleG4Xa6
5elgO92weLBEtxk3vPuK9AyI7iI90WVJsSnfxj4Nw9MzQM3P/3CQquO95h13
0Dtu14Ubd8TPYjXvuI4efRebmi7RxvXCmDBsvvIsYiARKjYWH2/ecxy9J6Je
F69n+EI+lnC5QTgq4l0aOh4XQ3nLBuiGWztSNl+5Dv1sX3IUHeK8gnnP8nT8
lnOW+q2iuTibd3SZM4TC9ViojuFbY46B4U66b/FQB3hDZYCCEB9opwe59LTT
g5uaEC40CD/gI/WMUqEQTb8ePVet3Xfgm+NLq2egmq+9MpyHPQPVfK2tsdEy
e4Z5z+m0MeQ0XgsIshWyZZ/sd+KmUQxX6BYabVDAoTsCfEMi3tXVcSFK2DOI
zU/gQnaVPNMXs3AuBCozQ/ZMtjZfr6gDrZOtzxPp6yeY85NunzgequP43rbE
fYS4j4wl3COdMNLBdyHvoEcz9XWkVPDd5uN30c9wpzJN8F/zvh/T73C97mi/
2i+unkFqCMU5sfncD8hKzvfBmtfn0nvP0bU7kSyTNZ/7Hn0umqaOoc99hzzw
aAUcbHCZb9Hne0CMhrOWsXn9VfpOro7DnIthzlsTamFdbLC2at6APrc+fU55
U4lW1uZzq9NPoElMmBd94MspcK7W5nNTqHmdzDdCnUS3MfYqBn9bZQI9QqDC
5Ctd9NgeepzAWBgYG9vz5ht8OSOJSkvxKr3OfPZa+uw1kczEQD1D1HzWunCw
iWWiWVtmzesz6bV2tEI161M9iV6fSK8VrpDNWrLm9RH0qzjdLtPNWrrm9f70
ujnhnKtkzyA27wj6ddZSNq+3pddB0lmbss3rjen1RgHaOZ82o/aoUJcagSyY
vD1D2viclmxLnG5mPJWf+jEFvNHJ5t8YnURPdxk1YvdGx5vXBvrweLDqTZG3
bqKfwwYmJSxWzD6ctXjN68vp97iskYzZkbPWkc3r8+kdNk2dLRU3ayuueX0a
Vc5TdT3PodzWyFbuLMPh3B4ftBQ1k875Q46GY4dZ533WKuh43rmGqreLJ54P
VWrz0Y3ot9gwbOe+vNcG4Z5rcF/NfGQV+s4r+/Vb2JeEfX0G33p+Bj04ojqN
wHtV0nt1Mim9OpHYp3NtX7NZq1nz+kr6DYKpWLSbtdo1r39I75IUFXTlQiAq
M1xmm7WF17z+Ln11MDpLFc7aKmxeH03fTVz6iEaW9gxj8/F4yvkG5SaqLjRI
7+HDjmWd91krbuFdsLxtMPMogmdDxPMh4uaj69K7gtTzIakL+YIlT88ZWAFq
y4NXW8583ICvTYfaNP5jdD8lZf5SsbJWCw2tai6OVWyhoVhtgWJ1W2yEqu+F
1VsIq/eYeK8uNjR8aDhzOTXZluV96XPfpO//DcD/4emWDLj2MR/fm76/xjDz
ek/6HorardXmczvT95ilw80dfdoe4c7awm1eb0XfwyZxR+Li60Xr61HmBcvc
5nPPYDffP4m6zXGe0bs5R2bYK8r52iWnRgeuYYlRadYPxef7TLOWqXl9Dr1W
sUrNLTbylBOWufSaz1nNOh2v+bpjzf8ncM36XA+j14fS6yBbrcgH0usD6HWQ
b9bn+z++louNnO1EbfO2ZMbZJowDinZE7RnC5guFMdfuTej1xv4c1LzegF4L
55n0ej36PtbUtRXLUnTLWls371uVXss0fKW08w+CaL77D9RsFWGOCBYbdus0
sOZzp9LX2NmiyjJnk1ODnnl9jF9XGaD5OhuQ1XpzzegxuBh6OUvP/GF+hSi/
nAIUfOZ9fMNPh58PURCaz+9I31lceXur1kIjZivInCFpvlLFKhRzPkX+4xHM
rJWscMz6HNfxO65saIrCnt1aj0THM3DMf9hqeIZ5cTr9rCKuUxvDXyqI5uO2
JCqgPPHJWz4iL/Ndjgzq61DgypgzdMx3kdLoVMd8bHXMKZV8iAoHXy+GS47q
ZMGvk85oOU9M8rZSysKfefc25qu2ps/Yasn+aT6zGfDMKmuHz8wiR7oqWF3Z
oJROJ3k6tvmGcYl35c3R9ejo5tyjm6fQkfeLkk0dBZGAnv3m6w43bzqM3ill
yZ7/hZh+gg6w+VecQ5zXI5xzj3DezZsaRMx33J2+o1qX+bpdzJt2pneKd+3k
e5d55/b0zu38zpKPcV7nCNnGVLBARzjfGO+Ld6U7lgWdW2cbGa1Af+VsITd/
CnTQcr7n81ErmMNGR818nUZy87FD6LVmNi7o5qtsm72/eUf4yBVij1zB7cr4
yBXMofNCR45OULYNOT+5FTdfpcZv/hTIMXK+Y7BpFGKOX7ojVQwl16J7TI6k
P8VQJSy6Xnowvf42fYXolc+ooibarK/ZfQnkvpGaaM8vJ+MWQ/mnSH/lGml3
d/MRx2F3pXc4Dhs+XnzIilor83S0ot5XwuhdFviIxVyDV/K9q+SeJf4SiD1L
vu0flax1MfP5A6XMyCljPu8cn2/S54PHphA+NvvQx0L5cC/6PnvRa9HhnvSe
Pc179qCPaZgwH5MeoeSeWTvTv6kzgB2b9NfFYN+lRy36Eecr20JHo+QejW+J
htpDR6QUOmOK/hnTZg5Km380aCnJvEcFZb4meDRKoaNRNH+1h45Gif7K0/kT
PRP+nd+13fwKZfOzt5sfvWx+5nbzM5fNzzzB/Mxl8zPT8kjZ/Mjt5mctmx+1
nX7GPP2M//6/z1d70+lKJ4yphRPMX9ubf28T/9/zv53/f//+71Y2P/Mk87NP
4t/h6zDR/BuTzL81iX/HfQ2P/RJ8JvW/5nT0uyurPX2H5CElHa92cs4sQRcl
lPh4fo3PiXbzM7Wbn6ldFLQvZ7j96D37mY/tz3zMxw/Uc69k/mozp2L8z61e
UEDnOkznZ9yZK1ubKGk3Pad8T9qdXWoPCfPUudHP75mfvy308xfpL1Y2t358
fov6uYKYzwd/lyL9xfmU20jfYQ80X/ctX1cB1znYr/bmNevw0IZ3H56y596O
a80O5jfY0bxjJ/ous9Q3CvQX+8iuVLTMd91Nc689AgWXpO9TXugoFEJHoRQ6
CgX3KPie6YVoFtwjwNXoYJmyOL91gf7iCsYtAXu45KSj/dz0nWZHxaG/pfTS
WQrpXHu5pEgt3s6vzkUKOVx/dvJLUjF0vAr0V45OHS5o5kiRT3ErQT72VfrD
dTBHB0oPT9E9OvvSd9nXnwyyf5rjUiRHzdGB0ROCjobU6kPtkfDzzRFc3o+S
dkkqviwfHWO+6lg/KR1v8+aJKc+bjXmMtClPlQrSh27B6XkrSXrUrspsgo+X
eb2D9kRyuPgUK0hN58MlFWx3rWr2jKI05UWOUiFylPbTLHIAyGnD6ddzlXKo
RGTPPU+OlCPjSabm4yLNzLF+8j5eD8+J0vpwSucp//d46p8zf6U7q2YCT9O5
k9sQZPy2sfZ7m3L/x1ObvHSEfDBlrrON+di2fppmucqxzNpTj2XLQdzveeQM
zEsNVLXKQeVQz/Heb6X4sLLH5kNH1TNHNR86qtRT5+mo5u1R9c+6PJ1xBXvG
WeFRY8gH1B+w8eHkc83P7ieDHE7zsVPMx06l43Eazwj8bvTMZke42DjCa3EL
/CW/K+ZJ5nqN6cdMv2uT8RcTMMc/Z46/Jz2IAJD+b0v6IbairxAP2BbsyUxt
PTeTfr8zy5/G7mI+49QL7kaDdY671YIvfufg07HPxRx7txawIxZ8RzwIrBXm
DAN/anUYyEltXh9pPn6UDErkpNYZip7R5vXx/uRTRmUngXDIGRAendg8DT/N
n6AKBfP+s3hyfg7/OZdGPFneWRRZl3PO+1XN51ej77c6rx2sKVPlLI2XiwKL
+ud1wWflS8SfejAjmWA6jDb3SWk3xEKRLnNblon5i4VCMgnUtV2ElBdHqmBJ
WYuOOk82jlPBcrJC4dlTThhJmc7GUHLrE88m82JAvlqY0wn0/YXQSQ1O/mrj
KSCYzH+ezpzMe88EH9PZPqYsLX3kaSQnayE/oBE60OyVZurptLU8T3tX5Ikg
r+vmaEK4Kg+HaS2IV34Zr8yg1qZ3OHT9qRUDlpXFDelnUr5STriecEHxy4ma
IHmgTM+2A+uCfmbxV7J3VuPTcqJcebaetUhjmHpxTPM+0wNd55O5lRIV4/Nc
3zuy4Xsybz4WuPm2NdZqDbwYirwHJEe+JxDPAp7OZa3czOvz6B1K0fzxZ+gX
8kz9YrsSdimvjF3edELQ4FufCvVpUJ9OK3fg1ZczX1Zfnp4OXqeVvfpK/uRf
kAv11YFXCHKCXJyXZ5GlhpgVt9itv7rMqGVHWDQ5QNa3W17L4hkSk5ap6ix/
BrCLP31yEhbXN38eqA5rXjvZk+fz36DXjJkg++uuKlpNDKVQbbNhwWvmqif4
60lZK1Lhm7N8VaOlqEZpWk5Oej59VtD+kP8oV0PVo4XOkmClxc8f8YrZlbyT
4epmnBu7JKqToTbZ/Fy1KebnpNW5abRYZ14b7LnacrSKV19e9mKtSL/JSiDY
gVcFisKdiDvQhXrRtfBGxvFXnpR5Q9pJvClY22ATYp21rONJFy1pK2ZLuehS
tiqOrZ3iyg7hRAXHqLfYUK/DVnRbdHUbUmzRKtane4W/2n01ae8a3thwHf+5
nnY7NKFdsh8dmQCVCVCdQCvutMPG0IdCdQqtx9OqPLM3mvdwBv0ey4G4vLAv
+OxV7EbrvLJQcGMWMY/mWmZe8Jk7wJl3wfL2XXyneF1Ts21Da4hzIcCZIYfT
v+/WBzd8WgB7Gvl9EWuh5TqbDbqzrE2pcoUrry4XGmjP8yuqRyU1awVrXl9M
77NMVau8MyVPWxkEKcM0H72BvvpG3q90M72+JV0nNtgFw10w0gVeZRztnhpP
wCsT+c8kqEwGEvwUqE+h7zmVRhDTeEuO7M0R4isGNJ61uMFfSVpbSa/nJ+n1
aT+Lk6Gj0vZXVIS0Yo7nXPDN24HMjPMhxvGE876SDw3ot73B9xhF7AiX2bZL
A+fjjWjWczOTmLFSpUVsAQv+viJx4atl59G1dJRVprQ7SajewvuBb6Wv+Sl9
j9t4/+EdTetzQ8l9Y2BgDAyOgWHe8uqNjAXoMNhHxsHIeLA6r02E+kTeMjuJ
91ROEeo5H7nv7CvRTxiq5hLd1m70TqWGma+vqP2ef3P6+i0a6SyWc3sjkUkc
Ey0HGLeFdbw/hPi2NfKWKNgJWJywzDtcvtpLClngvR8lEq/QdUqt4cp7Ntss
XSqyQb0C7zUqUX111GqZeiTVkk/2p7zr+w6+YuMu4N2m99AZdG/iOmzZ0u0p
Q28Z+sswUIahMgybPx20rRk8gxvahseSwitdUO2CWhfUx/EFDuNpX7T5VybS
z8CsfW2rjxthM+tSw8YtZXZv5lz0OYueNw5ks1KDchCxv9vfJWxV7Ph0KZ6v
3x2VGmxVvsKWuZasNQfQniJMO6wh0x8R7fcbzY34sEeSLflYhamGJVVqkZQq
SNl5XY12WI0KUEL5M970fz9ffPUgXQnQRL1t9qNL22BZG/S0QW8b9LfBgPmM
N2T+mjjUTryHOoj3SAdUOumi4FonXWRI1zSM5esblLWv6anMma6HMCl9oo/a
rdVrBNKZrdIhGfPq9ub+Pt8IYPCv2LGEgwJmuuUkuo05Lc9oSw3pxtTcgstW
M/KZ9Ju5Ccr6sBOHA2IVsKpS3sE9PmC+t7JEbw9IlK7GEahC9CG6WtLDX5Ap
P8KX8SSul4Xu7reoAEsKsLQA3QXoKUBfAfoLdGXRQBG8AWPj4wzu4TYYaaPL
+avtUGunm+vQtUkdfOmKwBbSE33rNv/SNPLR6Vqr4zjzDr3xPueQkkOhO17F
E4hxnIQbHXIsYKU7ISReqriubE8K07VWDLwbc3xDtxKehG0wNQUcmKmy97bZ
qupL9U6l+jP67vfROxyydFHWI3yB1uN0CZ55x+xm+t3UfnR+FhZmYVEWlmRh
aRa6s9CThb4s9Js/OejPw0Ce7p4zXKC7JFUKdDV/rQj1Il8+2sbXn5UZswja
VfOUhqBjEK8etOygjoFnx22NkJ2g4uVjJdwSbyA4h7Qr83CehW8Sy9aNxg3Z
XhLvxC5X8mCr1lj/dYH+3GH6S76s8gm+xPI3fBeKp5vRbVxRPTcD8zKwIAML
M7A4A0sysCwD3RnozUCf+eNBv0f3NBvy6OY5I1moZOlGDbUc1HN8ZXBBMYua
Q1IOmnYi47WgmYYT+Podcqx6W7I9LEG2olmbomK5OkW2oVftWQnqtdqpRqG6
RO/RiirlVIiK8z4eR/QZvj76ObqdQTq2/+R7oMzlexot4NtmLOa7Kyzjq7V7
+crtfr5If4iv2R/hi/erGbqWv54B9AAFsmi5iZCbEE6WcGu8TaTbnO0R8aIl
M24JNlatItWWVKWkSkjihOSL9NEEkTpI6b4Gv6Pbj6Rj+zHfD+Mzvn3CFwx5
PkNexJCX8sX4AlkIDzJkITwKUAOCTDfkyPPNOUp8o44y37RjDN3AI6Bh8enp
4Z45Bu96ilfUK+V3S+2TZOyxY5Dt7nFsv+kviPtDq29HgnIUbMiJz9ZuJ1pe
40JTg6otqXcESmpAqM2RPstIX2CkL/EdZebwDWZeAWh655K/8b3G/s73somF
K2SXKdw+B67It8ryrbJHV7kU0+112vlWO4JVInWScNNgdSW7dVCyaZjGGrGI
NQ3QUBa2Mr0igeYtDs1QIQ0JtIk6X/ClSTeV+SOjfJXvG/Q63eYrnV7f5TuL
vc+3J/ooDvI8le8SB7L1aCFM2s3AqAejObpr8GiR7l842g6jHdQ61aPF1xVu
c7wbqCMnSXbnVmxbirUl2GgKtlXVjh+iznunUk2qpEI12XB9db7Kd/d6ne/0
9RbfRPOdlGzf5DsCvsOE/8q3GAtBdgnbKrzUKcQD1p0zfI+zHN/vrMj3Pmun
+6AZAdelU4oKuCXemU2la+24JdtY0R6jok1odMiCf6BDpmgGtnJNqqei1YcS
bPfXSjWEVIT6iqr0Tb4r39t8h773+J6a76dk+yrfyfMNvqvnO3xrwBDkj4OE
3Spso1afY9F0h8Is362wSHfiqLCAq2W6e0NMep7SCq915ljpWlverRXbqGjF
kCUTJ4EVK74oIQRbsD+JZF8r14eUqkTe2UGqzyrVWO8Vqu/yrRff5ztrfsj3
wv24Kdvl7Uf/wPdnfYXvxvs6E/5zEHKU8FyFvJAhL1WXpts9e0bCcIbplOgu
stwTj7CCR7kE1+2sw1Vwc77rONacpF3x5TRwo83sCdrtnBoXhy9QL74smJeu
i5ANYb3fiUmPKdZQVX1e05Fgdeqpb74W6wc+U7ox7qd03+NUun2B76v8e76J
9st8o9bXVcYC+b0I4c+4XbJ5S4zaClhi1mCGbvI9mCPAAbqh9rcl3VhndqXr
2vIeKdCGetkTtNmR9Z1QmyNubJOT7Vl/HMf1nkhgesSpq7/m+3X9VrUqUSlk
v2+xUN8JQv07PzyAidL9rOfS813SsX2ab4f+PN8a/SW+wfIfmfCfFHIS4U9Z
xp8Hw1a30yUNZOgO3z7eAlXg0RJF6LrtfUW/zfGuFefMVrlRW/5KK7auZkOG
HMpPrhvbSBzqblyw1oR/7viwVevTjgO7Ucm133cY6V/VfkNU5/N96BfTEzjT
sX2Cn1TxND/T4Dm+MfrvlLDI+LVkwv9Qwl84Al7qtEr9GZplGQEP5agCVzhC
V0t0dyyabnSkwyvGPDNozFs2deWWbK1oQ35s81PUjK9Rxdr11SSwjzo27Aam
F+IC8BtKVXKSuK9Lda5DdSk/GKQ3tq9d2TJ9jB8QN5vJPsXPMRD5ikH/IZns
3zRGW3eeGxQueObfhlP6WbmDXHlHODuPcvNbL6Xguqru6olasp1Lxfrx3qmh
hpzYqvVCaKzPXeGkppZSfTTOgJ+LlNTXgvXUFekn/PiAKM4efj7TAD3PJ5Ve
H+YHP1rCT/JjSEIGPcch/GaCdpOE2xhgNadra65tiGRKZR15HXVk2+Zu6djx
LLVjO0UWtPsmoA0ZsW1kQ5n48mD/GltboznY+q9NwM3N1w1J1nnn8eM/FvGz
j5fxI3z6gR7nMwxYSenF9/EjXmMJi4bdkGVj9Jt8b23J0DLRsvHKHXOkxdup
kWqi9rszdAgZUq6dUEm1TcNWhlF2C407qojVrOvCzcFKEo7GYPHfkFqj5htK
v6GSasAuyNDDjZdksDtDzzbvz9DT64czOJpJYBt3BSjtyYh5Et/d/DDH+5vS
l9ps09crwTZZRl12mGm9e35K9LKeNEbXGSbpBo8ZatqrOS1SqBJvxWW4OXc7
zLDB2fVqqb7R6YUYdUs1P6gZ+bGIRVsp23Qc8mdpY6PpWCzaqHmRR88zXpql
x5v3Zuk5x4NZHMniaDaBe/QqxfCzdb0g/duAHtt6Nz/dz54DjzjnwK9bGfzb
7O521hmKZa1PgBLn7Sa+vmpTU98mBf0mdn4qSz7q5Zdpjb6uqZE/7FTnUIr+
nSP26PjiAx1fEPoMfprBf/Izbefz820XZ3BphrgvzeHSPHbzU+778ziUx5E8
jub/W/Rv5od438bP8bwn7hz4FT9HzjWBUAmQDPeuBriQ/7c+AXjNol5OcH5X
/lHbF/rbO+1VEv2o4Z+khi+xOzoAEeFL4E5C/4gWcHeE9YKD3ko+lLA/Zr3L
iOOzDD2xei4/vXqhRw+6XeZht/mTI+7dBewuYW8JB0o4VMKREpoe9T+hz1da
32D+43qAG/kB7rfyc3zvijsDHncsQFo024TbMUtSDWiNv8D9th2WdekkVNx/
OV5ZXjWhCbMlX9qv5uyjpn+Kmv65LHvX8a8Myv7WhPD2mGo+tsD/yanuf4kL
4p/LGCTD4LO4kJ9dv4yfY2+M3qi9t4C9RXrYeV87DrTjUDuOtONoe6j3ijLX
J2uHqvxVANcC/JiZ38JPbQ4xf8gp/U84qU9s//c6dbHAQ57fGjgvcTSmoyG3
j4rdtXq30Keh3cTkpRG7JBjqrMxv4xWmaP/1S11V+q0zo54TRG17ro8is655
EuQyJHBT0Jfwg617+CHXA+ZPAQeKJHDDeaCMAx041IEjHVhNut9rPPXg3Y4C
9C8DuALgaj0HzCd+EjwH7osT/VPB7DdHg58t+rZpb30C5HjCJgPUMq9uuW4f
lXus1Uuh39UZozWh745XznBMXoTuTlVcod/N489Y9M+oykOJzqK3Qe4zpyeT
IEczMVPQPZK4MfYeruaDXNCHimTsQ204VCbuQ504NBYrY7E6tkW21ydrh1hf
CHAJwOUAVzLx64zbs80L8TuY+L0Jkhebf17HcC8HS/xf0uDmkbk/UC3xalcH
r1XbbB8rdtfaQ2X9yzxWa8n65GBBF1O/2AlySTJ/0JmxzNb0LnX8Jdb4K06z
5oL+REHP1857KTff3YA9pk3zyMiNwAl0AYcLOGL+FHGkjYzcqHukE0fG4EgX
VsZhdVyzHv1C+9HzAS4AuAjgUiV8DcD1DmEb5e7jR3a7gn6SBe3ijTp6a7ye
sxzSxmvVnbqBaEJTKceW7ZRsvxtXsC/Ran2N05/9NCjih53VC1uqbTYXsG/G
gbWjskU6J+s1RProjvCm+R7wqA8byuFwnqiOFrBaxGoJq+1YLWO1E6tjjHwN
VayOx+qEdPOXswHOBTCEfwhwMRP+EYCU7esjZdsV8KPBmv1cXMF+Ow3ejOIt
8Fq17DSx+8OaSHfD5CIt4/DmbGPLczSCR0X7WALYaFUOgV3ggO3nAeggP9N8
OIMjHlZMg53Dah5rBawXsV7CehvWy1jvwHon1sdivQvr47E+AetN7+17gf3o
aUCPYj4H4DwWsLXoK4IWLUn8Tqci/zwd3neamnPImYcdZ66JM0/UOfnyjnS/
pOvRLdnup2ylxf4OB20bvWyHFTJkqby3BEX7YFzZbQJWkrWMQj/nmruQrbib
JttGprRrfyiDwx4OZ3Ekh5W8L9caU8V2xDJiJ+IYxC7EcYjjESciTkJjZql0
+12AUwHOAGgiYJu53Fbb+nNLvO/q9Pzvujlhru4QXGaXqzOUsoedlF2TlD3e
seUVI7a8cQq239Lh2ZHcRB3vdM9nBUV7eUS0t8e5sS2zkqeSFPtRME+5btwn
ivVwKIvD6sOVommOsdqGtXaSK3Yw1bEM1lCdwGAnIxqA09KxPQHgZIBTAE5P
ELBUYMF7iwasu/8VvH/WVupDXRmRFeuFvOrVo/sBZUu+nZjUZGLi2vKKvGi5
uk7KZnLJ3SwF20N0OHJMsDs+WxNzVLRSacWN70/oiF/QoJyUkmn8oWOvBTzz
Wpah5GQKLClWwJrkVKSpR6XNNL9UXWtswg25TlC5GnRTDVg0xyIV2+8AHAdw
IsD3HAF/3xGwNE3XOOX31mD5bYn3DWc6avGGnNnfj8/bAGUeXpN5+FhOVFOS
S65E5ZZsQyHZFtvznBQVrbR3Rdw4VGbn6GDzrbhUTBOODH7h4TyebSzm2YbJ
wwPZANhhDsOVMo52UGyqjaHq2pDrJJarUJ2OuBzdmyUV2yMAjgY4FsAV8FmO
gCVCJ5XfNHj/xH1wbOEVZ+5mZ5ZrLSq8ibfKW+9pmWuMNkPTkkvuFtryNmcb
W2zPZ0O+NE60dziifSSuuxU3fk3Hln8Jhid/npGhaeUCwzZHw4xunmQM5qjA
juQDXU6lE0c5DNdMZnKrq8jVUJ3BYFdAY2Cp2B4McBjAUQDHABwPcBIL+DRH
wD9gf7bl97pI+W2J92Uec0iuihZe15mHeRPvqMeXScnVUR2aqKbGlVzLdmtu
cWe1Ynt8cFR9Lhfbi9iQr4yLx/dypbXZONTNWjd+W8eSMquy7Q4NLDL+stPi
PK099OjCg0lOpsBWjBUbxTLYylgc7aIup8Zh2KmuVq6GKuJKaNwrFdsDAb4N
cCiAFfCJQQFLwLLl101Xt6TAK33vK06uChVeceZl7MyDvIN3lK+wqMl1UWUn
UU1nW3ZLro1T6dm6o+jvO8VW2IZ62vu00j7OorVubMcUr2uZfV/BSnJaEJxB
LTVuzCsLvUUaPBofHuXkZArsqLFio1gGO0q9K9YmYt314YZcDVXEVdCUpVRs
vwlwAMBBAIcAHB4nYAlYtvy6840bU+CVscachFwV68z+9W9ZvuytzUlUdojh
llwbp7bj0dSuKdi6xVbYSrG9jnf9uKK9X9cSf+VkY7fpeZPdWMrsx5FITGOn
DK0a9fDiQV8B+4s4yOtFVY7EjblElwwlsDoJa5Ox7vrw8gx2JQa7qgGLxrdS
sf0awDcA9gMwAhZ/PhLABizbIdnya9OVLb/N8crU6qVgrnILb6wzj/Jlb3RV
YzGSqFYMllw3Tu3IY8fdU7B1O1sZWVzNs6ibgtPkB1W0s3UJwWbjVzUbv8du
LGX28/DkifZ89Hm0/D/Aw8QhI1qOxDXzhyOxSU6mwNaMFRvFMtjaVKxHfXgV
Brs64prIdyZMwXYvgH0A/gdg36CAQwHLLb8XaflNg1eGki/E5SopvEnOXAO+
aLUQl6hWZlsOlVwbp77Mywdp2LpB6houtnal4B4V7SMaj6XSvujMFm02/tAp
swuDk6eBDA5KH+s2saaDbeeBE0dik5x42oR1o1gGW4/xYSNXBrs28v3pmlx7
uDvQo5j3Bvg6gPHl/QG+pcJ1fdmW3VCqEqyxpizTqid108iLWnBfcwYZH2pW
limGbO7sZ0c2kqVrkcWOQ0lK7HitVky/wZv4DuJB45ERptEAJTOoaHqa7az3
2ej0JkenqFgXswX32VFixhk38Wi4phNEfyQxzplHhAprwH8V6Dpofu1Uet0F
4MsAewJ8FUB82cV7ZDq8UnN/ov2ujDNkGDnbKbgvacF9Qwvu34Jtrp1QDXK1
pUvNc05KDtnxmhyj0rM9RifIpzkByhqxLbK3O+nJFetzzkLA685q/Qc6UJTo
JNNE2U85qBMnV6k1HQ0ngrWF1fqvAbuWgl2P7piciu2OADsD7BbEK2VXcnNL
vFc4Ayvpd2VaJbPmx9WRn1VHfllXfKUV+kj7IJlQydrBAFfbKvCNIqKlVlLy
GhqRm7OVIfJRPLA4kRuf051pRciIf+qkJxHtE8EK60Yn2Xf1ocbiuTop7pEN
0BkCa9qcYV6la4ybOn0L9sHaKGwTU0xhNf5rwaI5n1Ox3RZgB8W7B0Co7LbE
exFHqiu1IZJxxh26lPCQFtxfO63QHG2FXOnG2jIF5Szf6KU9oQP6krY/zdke
zsOo47ipPcUJx1Jkr3QWBdwZ1C9UtM+oaOcEo5O9xugTHijO4+2yS3mv7KAM
/2XiVKLBhOlf3XFTPaTYKNjVFOzaDHZdBru+AYumJ0jFdkuAbRjvLIBdAaT8
/qt4L9dxxg06a5alBFt4Z2tWfkGzsqzeu9KNTVJ0m5ci36jJ7YDcGDVTW9uW
bI932EqAkmJ7VTAZ3xNseUS0L6poXwuOFf0NNbxRbr5ukTOBeMijzbCNiVOZ
BhOmf7Xjpvr4IFgbhWMSE4OdyWA3NGDRGFUqtpsCbMF4twfYycFr01VLvBdo
v3tVXK56gBd5xZljQ5Ur3agt0118Crwc1Mm304vGqfW4tZWxRUu20SB1uXY9
riE/4BjyUypa2++8rWW2sVOKN8It4ElxN290NvmpkuWhk504jaHBhOlfa/7a
a5xio2DXUbAbMNiNDVg0jXwqthsCCN6tAbZjvG66aon3bO53f8jTKpurbgrm
qpAzh0KVK92YyXKWt9m08a30uvh+mG6ckqi8oY4ttm/FNhSkLtYg9WM15GiK
ksVZEa1dC3g/uAVuLg+LF/K2tx7e8GbceDRH67D+0KmDJ068W6KmbU4gPK0Y
jMSB5OSA3dSARVOBUrFdD8Dg3QRgc8W747+I9xwdRsbmKuvMj6kzh0JVVLrW
lgdkwa/Ad9Hr4JthTqA72zbi1JraBm2qI6lZrdi6S3qXaJC6QRNykiH/QUXr
Tp8a1wbylkbaupqjudMg70+v5nk/jB06yU6YiTSYqMvEaVqCYqNgN1Kwmxuw
aH7VVGzXBjB4NwDYmPFuBbAt47XpqiXeMxLw3qyFN+rMzzkDyFjpLtXZFN1i
Lc83Sezge51OoDuV16fHReUtddy4Wzq2NiRfq93PHWrI7uDYGvKfVLR/Cy7y
zOeFgCW8YbGHN7ENmY6nQFtiaiVaYG8MncbTjLimg4mY8LRGMBKvr2A3ccGi
iRap2K4BYPCuq3g3A9iS8Uq6aon3ZB5GnslLCaHYbOdUdzmZ+VdBZxbpSmD+
IChdsWW6g14ehkp8n9OxfLPiyXzzcRun3Ki8rY6S92zFViZRl2lIvpGDlBTb
B5MN+c9aaf8RukY7QxGqx1TaHInWZOPRIu91kjFFpzN0mkSK9SdObh8bVWwU
7JYClp6+lYrtKgCrA6zFeNcH2EjxbpMO7wk8az4tOVf9JNmZJVQ1kS7dnSnD
d8As8W1sx9LtqOm249P4UQISp0JReUddJti7FdtQSP6pdj8PtTLkj1i0X+jW
JxpEZbDHxOMsLcgO83anmmxiswNF2b5mp4nTsb5cBOyaQbAbKtjNQmDR5IpU
bFcAukhc8K6jeDeN4LW11zZGMpQ8VvdqJOUqcea7dJrxC2cQ+bxWXel1ZbIs
qwbzbaLK0A1OB4p8V+oxzHYSs12OHgwSz3YXh+0BvElKhsgn6ODiHA3J0SAl
xVYSssyiZMgorY9MGGWdZ566sRVtnyNa48a0ia1Dt8REO54V4vrYqGIt2K0V
7A40cErFdgaA4F1N8c6M4N1Zo9Xe2vce6Mycj2taeG9oJV3pdWXC/DdeNZA5
hk1U/Vlm2073Gh8ZRw8NqE6F2gxmu2oKtrJAcIwOpc7gBsiG5Nhiaw35hWTR
ygUCdNkXR6geXrob5OWdUd7H5u9OdOdPbn6ys+IQ2JktwaIJjKnYTgGY7uBd
M4J3Wyc527HGfjpzPpwXAt3CG3JmaYkkVCVJ95UEW5YZVV+W7j9Nt53u5LvH
G7ZTuOSuoG1QS7ZH6sDxFG5uv++E5OvUkO9UQ35EDflZTVGxopUl98UeX+6T
x54C9vGa7DDPFmuyQTEJ7IpxYNdNBrutgt3JgKVFgFRsJ5qPMN7lAVaK4N0s
iNdOreySwiFaeJOcuaV0f8fSfS3Blul2TFm6vTixjcYpaYPs+KIJWxk4nqrN
7Q+daePNcYb8lBryyzqvkDU8We9ZYC/28Ei0ywrYU8K+Eg624TBvoaiF3LgJ
2LWcyVM0PMWARdMJpGLbBTAhAa+NVlvpWEOmVns5K0YHOYU31pmv5FCVJN1n
uNeVRPVmxJZlob47S3ePN3FquMxsx9OTe2rToL4cR2VpcdOwPVkHF+dpSJYg
dYt2trb7CRnym9r6uKLt5jUBE6FM32NE28OXYA6WcZhnizW7ftekzK4RB3bj
lmDRdPCp2HYCCN7JQbw2Wm3sjDUE7x66YmRjs6zhR1sicearud29JShdGTI/
xb3uS5qo3o6bUS3N0sMB+ksUp0bGQGUcs51KD12jyaO0uDKaask2FJJtkJJi
6xqyJOQ53NZK6xMSbS8v0vZ5FKFok0wb9pdxsAOHeZtiTTafum7cHOz6zuQp
WmMN2J0tWDS/XvL1fPTByNMXolfxtgNE0dvYta4z8tia59Ghjkky1yG8vc62
S65rX6qt8I08xYrK+rectuZo2nrPsWx/z3qWngvRW6Lnu5gYTdONifxYJuG+
uq7wbsbj5pbczwlOmWVaZQtx1KxfV7P+SBf5FvHKvL/VwqPp42CBnNoIerAT
h3mmXAvl5iYleL046FsFoc9yoSN+JYF7W+ij/K7o88Qb9AsA7gngBrPVnRNg
E12QcHuqvTWVHaT9sjRUrq9fpMKXbuo2XhsOCT+Ux97XHTr+rbqy9GCQnhI9
4GdwDIWxxmxLmigZfsjQcod09CViX+PMPO7jUv14cODxCpdqa+f/5K5JJC8X
dw3ZZUBTp8sk+ZEumjrX7GbzkJc3QS/pa4uW6Gn71H+JvnlvsekJIENPu2Th
dl02t9mO+mhuuVznv4BD2xUq/5/w6vG9jvx/zfIPJbYPdVWR5J+lJ8MsK9ET
ngbG0NPaKkJ/Gk82bZslY83tU9C3IVwaLJmKyGL/47xP0jV8SeAy6/qC+yoR
/jDgCGDFw0qOJpiVNr7goNPf4lqLbaqalPFY9DvGokfzu/0n9PleHTfKa/Nm
V/+S3KXvXgVgjSD+UGzfSwu/dNxHcEtmh2Xi/hfyIPQqR/wyBZXA/oTTjLmJ
7mN7q58sLCrA0hL0lKFvDAx20ZPaTFSvT+WFZLcNk5H2zrzFMg1724BJSJfO
+tfB7sua/qdq+t0s+wrgKGDVw2oOqwV/TaLW2ZhbNyJcyPGbg5f8tr0DftcQ
eMR9/Lqe+1f07rzjpv/ENwIfWTX0NauEXq8c9/no97R3Hiigc4+RwPsKoe8U
/p1i71PxX3z//+1/77/y/pgjTXn/VvvqSedvyPxvDHkIaA==\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"HotColor", "[", "#3", "]"}], "&"}], ")"}]}]}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->581930822],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->440924533]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16077],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 " for named color gradients:"
}], "ExampleText",
 CellID->702805721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"ColorData", "[", "\"\<SouthwestColors\>\"", "]"}], "[", "0", 
    "]"}], ",", 
   RowBox[{
    RowBox[{"ColorData", "[", "\"\<SouthwestColors\>\"", "]"}], "[", "1", 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->567842223],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.396811`", ",", "0.31014`", ",", "0.204105`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.35082`", ",", "0.595178`", ",", "0.853742`"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{536, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258376994]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<SouthwestColors\>\"", ",", "\"\<Panel\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10368557],

Cell[BoxData[
 PanelBox[
  StyleBox[
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJwVVXs81IkXnUJNnpFHS0laSyqll1I5yRIieWwlm0d5lI1Cu8qKJSmiFIpN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      "], {{0, 0}, {1, 1}}],
     EventHandlerTag[{"MouseClicked" :> (SelectionMove[
          ButtonNotebook[], After, ButtonCell]; NotebookWrite[
          ButtonNotebook[], 
          ToBoxes[
           
           DataPaclets`ColorDataDump`f$78519[(
              DataPaclets`ColorDataDump`e$78519 - 
              DataPaclets`ColorDataDump`s$78519) First[
               MousePosition["Graphics"]] + 
            DataPaclets`ColorDataDump`s$78519]]]), PassEventsDown -> 
       Automatic, PassEventsUp -> True}]],
    AspectRatio->NCache[
      Rational[1, 8], 0.125],
    ContentSelectable->False,
    ImageSize->250,
    PlotRange->{{0, 1}, {0, 1}}],
   StripOnInput->False,
   CacheGraphics->False],
  FrameMargins->Automatic]], "Output",
 ImageSize->{276, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->530345386]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<SouthwestColors\>\"", "]"}], "[", "#3", 
       "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->103465633],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxlmG1o1VUcx4dRKBv2YjSowDIuRC8CiyisG6fQgkWJOakILJszB2VZvdsb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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
        "]]]}, {}, {}, {}}, 
    Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151, 
     166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
     218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
     180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 235,
      14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246}]},
   VertexColors->CompressedData["
1:eJzdWFlQlFcWbu2wqDghoAgKggiEBEVRC3CG5uDgUgYUDIt0QyQuxBJQQpFh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    "],
   VertexNormals->CompressedData["
1:eJx1WAlQlVUUZlHb1KQUldEmm3SiZkobLSefnlFLFBWVdozGSklLhQo0nTR0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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-1, 1}, {-1, 1}, {-0.8414709848078965, 0.8414709848078965}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->953093564,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->853338141],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 " for named color schemes:"
}], "ExampleText",
 CellID->679244646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"6", ",", "\"\<Panel\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237154420],

Cell[BoxData[
 PanelBox[
  StyleBox[
   GraphicsBox[{
     {RGBColor[0.3411764705882353, 0.3411764705882353, 0.3411764705882353], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{1, 0}, Offset[{-1, -1}, {2, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.3411764705882353, 0.3411764705882353, 0.3411764705882353]]]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[
      0.6431372549019608, 0.10588235294117647`, 0.043137254901960784`], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{2, 0}, Offset[{-1, -1}, {3, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.6431372549019608, 0.10588235294117647`, 
              0.043137254901960784`]]]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]]}, 
     {RGBColor[
      0.19215686274509805`, 0.10588235294117647`, 0.06274509803921569], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{3, 0}, Offset[{-1, -1}, {4, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.19215686274509805`, 0.10588235294117647`, 
              0.06274509803921569]]]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]]}, 
     {RGBColor[0.792156862745098, 0.7333333333333333, 0.611764705882353], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{4, 0}, Offset[{-1, -1}, {5, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.792156862745098, 0.7333333333333333, 0.611764705882353]]]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[0.8117647058823529, 0.596078431372549, 0.027450980392156862`], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{5, 0}, Offset[{-1, -1}, {6, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.8117647058823529, 0.596078431372549, 0.027450980392156862`]]]),
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[0.10588235294117647`, 0.2549019607843137, 0.1607843137254902], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{6, 0}, Offset[{-1, -1}, {7, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.10588235294117647`, 0.2549019607843137, 0.1607843137254902]]]),
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[
      0.12549019607843137`, 0.30980392156862746`, 0.42745098039215684`], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{7, 0}, Offset[{-1, -1}, {8, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.12549019607843137`, 0.30980392156862746`, 
              0.42745098039215684`]]]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]]}, 
     {RGBColor[0.0784313725490196, 0.1450980392156863, 0.3176470588235294], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{8, 0}, Offset[{-1, -1}, {9, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.0784313725490196, 0.1450980392156863, 0.3176470588235294]]]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[0.6588235294117647, 0.6039215686274509, 0.7019607843137254], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{9, 0}, Offset[{-1, -1}, {10, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.6588235294117647, 0.6039215686274509, 0.7019607843137254]]]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[0.5215686274509804, 0.4196078431372549, 0.4549019607843137], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{10, 0}, Offset[{-1, -1}, {11, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.5215686274509804, 0.4196078431372549, 0.4549019607843137]]]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
     {RGBColor[
      0.48627450980392156`, 0.03137254901960784, 0.09411764705882353], 
      EdgeForm[Opacity[0.1]], 
      TagBox[RectangleBox[{11, 0}, Offset[{-1, -1}, {12, 1}]],
       EventHandlerTag[{"MouseClicked" :> (SelectionMove[
            ButtonNotebook[], After, ButtonCell]; NotebookWrite[
            ButtonNotebook[], 
            ToBoxes[
             RGBColor[
             0.48627450980392156`, 0.03137254901960784, 
              0.09411764705882353]]]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]]}},
    AspectRatio->NCache[
      Rational[1, 10], 0.1],
    ContentSelectable->False,
    ImageSize->250,
    PlotRangePadding->None],
   StripOnInput->False,
   CacheGraphics->False],
  FrameMargins->Automatic]], "Output",
 ImageSize->{276, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261426867]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->195796739],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ColorSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
 " to get a simple color selector (click the color rectangle):"
}], "ExampleText",
 CellID->148407395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ColorSetter", "[", 
    RowBox[{"Dynamic", "[", "color", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "color", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->446655730],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[Dynamic[$CellContext`color], "Swatch"], ",", 
   DynamicBox[ToBoxes[$CellContext`color, StandardForm],
    ImageSizeCache->{134.375, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{184, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12206320]
}, Open  ]],

Cell[TextData[{
 "Or use ",
 Cell[BoxData[
  ButtonBox["ColorSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSlider"]], "InlineFormula"],
 " to directly select colors: "
}], "ExampleText",
 CellID->89143513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ColorSlider", "[", 
    RowBox[{"Dynamic", "[", "color", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "color", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->62658812],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[Dynamic[$CellContext`color], "SwatchSpectrum"], ",", 
   DynamicBox[ToBoxes[$CellContext`color, StandardForm],
    ImageSizeCache->{134.375, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{324, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->192229828]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32245],

Cell["Values outside of the 0, 1 range will be clipped:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->483075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"r", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"4", "r"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", 
      RowBox[{"0", "-", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "+", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168215278],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlzEOgzAMRT+FKxB1zFEytVMPESEkGCoqygFyoI7sOZrrQEqpegS+JTt+
sYe3+uanrr37qW+8vY7+0fXN016GUb/KAsCsac/QXrRbchbRd18rra8QQrUR
SkWsUaeyY/NhB7g0d5l1Ie2YkDkCMc1jZlkFjPxyvfESONGCFrSgBS1oQQta
0IIWtDi0xfc6+b9eULwBcCh/wg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->887610250]
}, Open  ]],

Cell[TextData[{
 "In plot functions, use ",
 Cell[BoxData[
  ButtonBox["ColorFunctionScaling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunctionScaling"]], "InlineFormula"],
 " to control global scaling of variables:"
}], "ExampleText",
 CellID->37537136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"DensityPlot", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"#", ",", "0", ",", "0"}], "]"}], "&"}], ")"}]}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "t"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->71933364],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3H9kVWEYwPHvdu82WymRlCaLpIhEJCKRJkqiRMp221ZbmmUtkRKRiEQk
IhGRKImSKImSKJESKVlKpJR+KHXd3vPeuxsn/TOL3e17uO+5531f5z7v8znv
ufccx12Z6+vs6M71dbXlmpp7c9s7u9p2NC3r6Q1VmSqgP7w2Tya8L4R38dVf
KIR1XSjb8/n8mLDuCOu6cm1b6EQmVBXiQn3SM1VXU+5NJrTk40JLUpS2k6aG
VHtrqr32r70kHzM1KWaF4LNQC/UwFsbDRGiEGTAH5sMiWAorYC1shA7ohp2w
Fw7AYTgGJ+EMXIArcAPuwAN4Ai/gDbyDD/AJvsA3+AG/wqfnSyMtBZTkh1w5
ulRY42BCjGwSTInxTYPpMcqZMDvGOhfmxYgXwMIY92JYEqNvhuVxDKtgNayB
dbAeNkALbIKQ9y2wFbZBD/RCH+yC3bAH9sH+ONqDcCiO+QgcjSM/Difi+E/B
6ZiFs3AOzsNFuASX4Spcg+twE27BbbgL9+A+PIRH8BiewjN4Di/hFbyGtzFx
7+EjfIav8B1+htRUq6uuuuqqq6666qqrrrrqqquuuuqqq6666qqrrrrqqquu
uuqqq6666qqrrrrqqquuuuqqq6666qqrrrrqqquuuuqqq6666qqrrrrqqquu
uuqqq6666laAbjaU1YloJm7GNDYqXLnC2T8zldK/I0XakDEKA0uxj84V7FxT
nslFzziTtdZaa6211vp/W1cPXBeUQqzVflTZJ1cNdZqPGvNMar7XaD8E9umz
aHl7WN5tyZTmvef6wd51SXtXFY+G0t2XpMwO6yPAX3iDlU+Iq5KUJesKnPvK
D+2cr4xvfdVHzy88rbXWWmuttdZaa6211lrryrT2yaYR5pwtZ4qBJ5t8NnEE
+frkqbrqqquuuuqqq6666qqrrrrqqquuuuqqq6666qqrrrrqqquuuuqqq666
6qqrrrrqqquuuuqqq6666qqrrrrqqquuuuqqq6666qqrrrrqqquuuiNON+nQ
kurVkGpv/ede2ijJFOJCfSjaU3XFf2LpjyVVvwF5Xflm\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->312834863]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16135],

Cell["Visualizing the RGB color space:", "ExampleText",
 CellID->119505576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", ".7", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"RGBColor", "[", "#", "]"}], ",", 
         RowBox[{"Cuboid", "[", 
          RowBox[{"#", ",", 
           RowBox[{"#", "+", ".1"}]}], "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Tuples", "[", 
       RowBox[{
        RowBox[{"Range", "[", 
         RowBox[{"0", ",", "1", ",", ".2"}], "]"}], ",", "3"}], "]"}]}]}], 
    "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Red\>\"", ",", "\"\<Green\>\"", ",", "\"\<Blue\>\""}], 
     "}"}]}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132332677],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.7], 
   {RGBColor[0., 0., 0.], CuboidBox[{0., 0., 0.}, {0.1, 0.1, 0.1}]}, 
   {RGBColor[0., 0., 0.2], 
    CuboidBox[{0., 0., 0.2}, {0.1, 0.1, 0.30000000000000004`}]}, 
   {RGBColor[0., 0., 0.4], CuboidBox[{0., 0., 0.4}, {0.1, 0.1, 0.5}]}, 
   {RGBColor[0., 0., 0.6000000000000001], 
    CuboidBox[{0., 0., 0.6000000000000001}, {0.1, 0.1, 
     0.7000000000000001}]}, 
   {RGBColor[0., 0., 0.8], CuboidBox[{0., 0., 0.8}, {0.1, 0.1, 0.9}]}, 
   {RGBColor[0., 0., 1.], CuboidBox[{0., 0., 1.}, {0.1, 0.1, 1.1}]}, 
   {RGBColor[0., 0.2, 0.], 
    CuboidBox[{0., 0.2, 0.}, {0.1, 0.30000000000000004`, 0.1}]}, 
   {RGBColor[0., 0.2, 0.2], 
    CuboidBox[{0., 0.2, 0.2}, {0.1, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {RGBColor[0., 0.2, 0.4], 
    CuboidBox[{0., 0.2, 0.4}, {0.1, 0.30000000000000004`, 0.5}]}, 
   {RGBColor[0., 0.2, 0.6000000000000001], 
    CuboidBox[{0., 0.2, 0.6000000000000001}, {0.1, 0.30000000000000004`, 
     0.7000000000000001}]}, 
   {RGBColor[0., 0.2, 0.8], 
    CuboidBox[{0., 0.2, 0.8}, {0.1, 0.30000000000000004`, 0.9}]}, 
   {RGBColor[0., 0.2, 1.], 
    CuboidBox[{0., 0.2, 1.}, {0.1, 0.30000000000000004`, 1.1}]}, 
   {RGBColor[0., 0.4, 0.], CuboidBox[{0., 0.4, 0.}, {0.1, 0.5, 0.1}]}, 
   {RGBColor[0., 0.4, 0.2], 
    CuboidBox[{0., 0.4, 0.2}, {0.1, 0.5, 0.30000000000000004`}]}, 
   {RGBColor[0., 0.4, 0.4], CuboidBox[{0., 0.4, 0.4}, {0.1, 0.5, 0.5}]}, 
   {RGBColor[0., 0.4, 0.6000000000000001], 
    CuboidBox[{0., 0.4, 0.6000000000000001}, {0.1, 0.5, 
     0.7000000000000001}]}, 
   {RGBColor[0., 0.4, 0.8], CuboidBox[{0., 0.4, 0.8}, {0.1, 0.5, 0.9}]}, 
   {RGBColor[0., 0.4, 1.], CuboidBox[{0., 0.4, 1.}, {0.1, 0.5, 1.1}]}, 
   {RGBColor[0., 0.6000000000000001, 0.], 
    CuboidBox[{0., 0.6000000000000001, 0.}, {0.1, 0.7000000000000001, 
     0.1}]}, 
   {RGBColor[0., 0.6000000000000001, 0.2], 
    CuboidBox[{0., 0.6000000000000001, 0.2}, {0.1, 0.7000000000000001, 
     0.30000000000000004`}]}, 
   {RGBColor[0., 0.6000000000000001, 0.4], 
    CuboidBox[{0., 0.6000000000000001, 0.4}, {0.1, 0.7000000000000001, 
     0.5}]}, 
   {RGBColor[0., 0.6000000000000001, 0.6000000000000001], 
    CuboidBox[{0., 0.6000000000000001, 0.6000000000000001}, {0.1, 
     0.7000000000000001, 0.7000000000000001}]}, 
   {RGBColor[0., 0.6000000000000001, 0.8], 
    CuboidBox[{0., 0.6000000000000001, 0.8}, {0.1, 0.7000000000000001, 
     0.9}]}, 
   {RGBColor[0., 0.6000000000000001, 1.], 
    CuboidBox[{0., 0.6000000000000001, 1.}, {0.1, 0.7000000000000001, 
     1.1}]}, 
   {RGBColor[0., 0.8, 0.], CuboidBox[{0., 0.8, 0.}, {0.1, 0.9, 0.1}]}, 
   {RGBColor[0., 0.8, 0.2], 
    CuboidBox[{0., 0.8, 0.2}, {0.1, 0.9, 0.30000000000000004`}]}, 
   {RGBColor[0., 0.8, 0.4], CuboidBox[{0., 0.8, 0.4}, {0.1, 0.9, 0.5}]}, 
   {RGBColor[0., 0.8, 0.6000000000000001], 
    CuboidBox[{0., 0.8, 0.6000000000000001}, {0.1, 0.9, 
     0.7000000000000001}]}, 
   {RGBColor[0., 0.8, 0.8], CuboidBox[{0., 0.8, 0.8}, {0.1, 0.9, 0.9}]}, 
   {RGBColor[0., 0.8, 1.], CuboidBox[{0., 0.8, 1.}, {0.1, 0.9, 1.1}]}, 
   {RGBColor[0., 1., 0.], CuboidBox[{0., 1., 0.}, {0.1, 1.1, 0.1}]}, 
   {RGBColor[0., 1., 0.2], 
    CuboidBox[{0., 1., 0.2}, {0.1, 1.1, 0.30000000000000004`}]}, 
   {RGBColor[0., 1., 0.4], CuboidBox[{0., 1., 0.4}, {0.1, 1.1, 0.5}]}, 
   {RGBColor[0., 1., 0.6000000000000001], 
    CuboidBox[{0., 1., 0.6000000000000001}, {0.1, 1.1, 
     0.7000000000000001}]}, 
   {RGBColor[0., 1., 0.8], CuboidBox[{0., 1., 0.8}, {0.1, 1.1, 0.9}]}, 
   {RGBColor[0., 1., 1.], CuboidBox[{0., 1., 1.}, {0.1, 1.1, 1.1}]}, 
   {RGBColor[0.2, 0., 0.], 
    CuboidBox[{0.2, 0., 0.}, {0.30000000000000004`, 0.1, 0.1}]}, 
   {RGBColor[0.2, 0., 0.2], 
    CuboidBox[{0.2, 0., 0.2}, {0.30000000000000004`, 0.1, 
     0.30000000000000004`}]}, 
   {RGBColor[0.2, 0., 0.4], 
    CuboidBox[{0.2, 0., 0.4}, {0.30000000000000004`, 0.1, 0.5}]}, 
   {RGBColor[0.2, 0., 0.6000000000000001], 
    CuboidBox[{0.2, 0., 0.6000000000000001}, {0.30000000000000004`, 0.1, 
     0.7000000000000001}]}, 
   {RGBColor[0.2, 0., 0.8], 
    CuboidBox[{0.2, 0., 0.8}, {0.30000000000000004`, 0.1, 0.9}]}, 
   {RGBColor[0.2, 0., 1.], 
    CuboidBox[{0.2, 0., 1.}, {0.30000000000000004`, 0.1, 1.1}]}, 
   {RGBColor[0.2, 0.2, 0.], 
    CuboidBox[{0.2, 0.2, 0.}, {0.30000000000000004`, 0.30000000000000004`, 
     0.1}]}, 
   {RGBColor[0.2, 0.2, 0.2], 
    CuboidBox[{0.2, 0.2, 0.2}, {0.30000000000000004`, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {RGBColor[0.2, 0.2, 0.4], 
    CuboidBox[{0.2, 0.2, 0.4}, {0.30000000000000004`, 0.30000000000000004`, 
     0.5}]}, 
   {RGBColor[0.2, 0.2, 0.6000000000000001], 
    CuboidBox[{0.2, 0.2, 0.6000000000000001}, {0.30000000000000004`, 
     0.30000000000000004`, 0.7000000000000001}]}, 
   {RGBColor[0.2, 0.2, 0.8], 
    CuboidBox[{0.2, 0.2, 0.8}, {0.30000000000000004`, 0.30000000000000004`, 
     0.9}]}, 
   {RGBColor[0.2, 0.2, 1.], 
    CuboidBox[{0.2, 0.2, 1.}, {0.30000000000000004`, 0.30000000000000004`, 
     1.1}]}, 
   {RGBColor[0.2, 0.4, 0.], 
    CuboidBox[{0.2, 0.4, 0.}, {0.30000000000000004`, 0.5, 0.1}]}, 
   {RGBColor[0.2, 0.4, 0.2], 
    CuboidBox[{0.2, 0.4, 0.2}, {0.30000000000000004`, 0.5, 
     0.30000000000000004`}]}, 
   {RGBColor[0.2, 0.4, 0.4], 
    CuboidBox[{0.2, 0.4, 0.4}, {0.30000000000000004`, 0.5, 0.5}]}, 
   {RGBColor[0.2, 0.4, 0.6000000000000001], 
    CuboidBox[{0.2, 0.4, 0.6000000000000001}, {0.30000000000000004`, 0.5, 
     0.7000000000000001}]}, 
   {RGBColor[0.2, 0.4, 0.8], 
    CuboidBox[{0.2, 0.4, 0.8}, {0.30000000000000004`, 0.5, 0.9}]}, 
   {RGBColor[0.2, 0.4, 1.], 
    CuboidBox[{0.2, 0.4, 1.}, {0.30000000000000004`, 0.5, 1.1}]}, 
   {RGBColor[0.2, 0.6000000000000001, 0.], 
    CuboidBox[{0.2, 0.6000000000000001, 0.}, {0.30000000000000004`, 
     0.7000000000000001, 0.1}]}, 
   {RGBColor[0.2, 0.6000000000000001, 0.2], 
    CuboidBox[{0.2, 0.6000000000000001, 0.2}, {0.30000000000000004`, 
     0.7000000000000001, 0.30000000000000004`}]}, 
   {RGBColor[0.2, 0.6000000000000001, 0.4], 
    CuboidBox[{0.2, 0.6000000000000001, 0.4}, {0.30000000000000004`, 
     0.7000000000000001, 0.5}]}, 
   {RGBColor[0.2, 0.6000000000000001, 0.6000000000000001], 
    CuboidBox[{0.2, 0.6000000000000001, 0.6000000000000001}, {
     0.30000000000000004`, 0.7000000000000001, 0.7000000000000001}]}, 
   {RGBColor[0.2, 0.6000000000000001, 0.8], 
    CuboidBox[{0.2, 0.6000000000000001, 0.8}, {0.30000000000000004`, 
     0.7000000000000001, 0.9}]}, 
   {RGBColor[0.2, 0.6000000000000001, 1.], 
    CuboidBox[{0.2, 0.6000000000000001, 1.}, {0.30000000000000004`, 
     0.7000000000000001, 1.1}]}, 
   {RGBColor[0.2, 0.8, 0.], 
    CuboidBox[{0.2, 0.8, 0.}, {0.30000000000000004`, 0.9, 0.1}]}, 
   {RGBColor[0.2, 0.8, 0.2], 
    CuboidBox[{0.2, 0.8, 0.2}, {0.30000000000000004`, 0.9, 
     0.30000000000000004`}]}, 
   {RGBColor[0.2, 0.8, 0.4], 
    CuboidBox[{0.2, 0.8, 0.4}, {0.30000000000000004`, 0.9, 0.5}]}, 
   {RGBColor[0.2, 0.8, 0.6000000000000001], 
    CuboidBox[{0.2, 0.8, 0.6000000000000001}, {0.30000000000000004`, 0.9, 
     0.7000000000000001}]}, 
   {RGBColor[0.2, 0.8, 0.8], 
    CuboidBox[{0.2, 0.8, 0.8}, {0.30000000000000004`, 0.9, 0.9}]}, 
   {RGBColor[0.2, 0.8, 1.], 
    CuboidBox[{0.2, 0.8, 1.}, {0.30000000000000004`, 0.9, 1.1}]}, 
   {RGBColor[0.2, 1., 0.], 
    CuboidBox[{0.2, 1., 0.}, {0.30000000000000004`, 1.1, 0.1}]}, 
   {RGBColor[0.2, 1., 0.2], 
    CuboidBox[{0.2, 1., 0.2}, {0.30000000000000004`, 1.1, 
     0.30000000000000004`}]}, 
   {RGBColor[0.2, 1., 0.4], 
    CuboidBox[{0.2, 1., 0.4}, {0.30000000000000004`, 1.1, 0.5}]}, 
   {RGBColor[0.2, 1., 0.6000000000000001], 
    CuboidBox[{0.2, 1., 0.6000000000000001}, {0.30000000000000004`, 1.1, 
     0.7000000000000001}]}, 
   {RGBColor[0.2, 1., 0.8], 
    CuboidBox[{0.2, 1., 0.8}, {0.30000000000000004`, 1.1, 0.9}]}, 
   {RGBColor[0.2, 1., 1.], 
    CuboidBox[{0.2, 1., 1.}, {0.30000000000000004`, 1.1, 1.1}]}, 
   {RGBColor[0.4, 0., 0.], CuboidBox[{0.4, 0., 0.}, {0.5, 0.1, 0.1}]}, 
   {RGBColor[0.4, 0., 0.2], 
    CuboidBox[{0.4, 0., 0.2}, {0.5, 0.1, 0.30000000000000004`}]}, 
   {RGBColor[0.4, 0., 0.4], CuboidBox[{0.4, 0., 0.4}, {0.5, 0.1, 0.5}]}, 
   {RGBColor[0.4, 0., 0.6000000000000001], 
    CuboidBox[{0.4, 0., 0.6000000000000001}, {0.5, 0.1, 
     0.7000000000000001}]}, 
   {RGBColor[0.4, 0., 0.8], CuboidBox[{0.4, 0., 0.8}, {0.5, 0.1, 0.9}]}, 
   {RGBColor[0.4, 0., 1.], CuboidBox[{0.4, 0., 1.}, {0.5, 0.1, 1.1}]}, 
   {RGBColor[0.4, 0.2, 0.], 
    CuboidBox[{0.4, 0.2, 0.}, {0.5, 0.30000000000000004`, 0.1}]}, 
   {RGBColor[0.4, 0.2, 0.2], 
    CuboidBox[{0.4, 0.2, 0.2}, {0.5, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {RGBColor[0.4, 0.2, 0.4], 
    CuboidBox[{0.4, 0.2, 0.4}, {0.5, 0.30000000000000004`, 0.5}]}, 
   {RGBColor[0.4, 0.2, 0.6000000000000001], 
    CuboidBox[{0.4, 0.2, 0.6000000000000001}, {0.5, 0.30000000000000004`, 
     0.7000000000000001}]}, 
   {RGBColor[0.4, 0.2, 0.8], 
    CuboidBox[{0.4, 0.2, 0.8}, {0.5, 0.30000000000000004`, 0.9}]}, 
   {RGBColor[0.4, 0.2, 1.], 
    CuboidBox[{0.4, 0.2, 1.}, {0.5, 0.30000000000000004`, 1.1}]}, 
   {RGBColor[0.4, 0.4, 0.], CuboidBox[{0.4, 0.4, 0.}, {0.5, 0.5, 0.1}]}, 
   {RGBColor[0.4, 0.4, 0.2], 
    CuboidBox[{0.4, 0.4, 0.2}, {0.5, 0.5, 0.30000000000000004`}]}, 
   {RGBColor[0.4, 0.4, 0.4], CuboidBox[{0.4, 0.4, 0.4}, {0.5, 0.5, 0.5}]}, 
   {RGBColor[0.4, 0.4, 0.6000000000000001], 
    CuboidBox[{0.4, 0.4, 0.6000000000000001}, {0.5, 0.5, 
     0.7000000000000001}]}, 
   {RGBColor[0.4, 0.4, 0.8], CuboidBox[{0.4, 0.4, 0.8}, {0.5, 0.5, 0.9}]}, 
   {RGBColor[0.4, 0.4, 1.], CuboidBox[{0.4, 0.4, 1.}, {0.5, 0.5, 1.1}]}, 
   {RGBColor[0.4, 0.6000000000000001, 0.], 
    CuboidBox[{0.4, 0.6000000000000001, 0.}, {0.5, 0.7000000000000001, 
     0.1}]}, 
   {RGBColor[0.4, 0.6000000000000001, 0.2], 
    CuboidBox[{0.4, 0.6000000000000001, 0.2}, {0.5, 0.7000000000000001, 
     0.30000000000000004`}]}, 
   {RGBColor[0.4, 0.6000000000000001, 0.4], 
    CuboidBox[{0.4, 0.6000000000000001, 0.4}, {0.5, 0.7000000000000001, 
     0.5}]}, 
   {RGBColor[0.4, 0.6000000000000001, 0.6000000000000001], 
    CuboidBox[{0.4, 0.6000000000000001, 0.6000000000000001}, {0.5, 
     0.7000000000000001, 0.7000000000000001}]}, 
   {RGBColor[0.4, 0.6000000000000001, 0.8], 
    CuboidBox[{0.4, 0.6000000000000001, 0.8}, {0.5, 0.7000000000000001, 
     0.9}]}, 
   {RGBColor[0.4, 0.6000000000000001, 1.], 
    CuboidBox[{0.4, 0.6000000000000001, 1.}, {0.5, 0.7000000000000001, 
     1.1}]}, 
   {RGBColor[0.4, 0.8, 0.], CuboidBox[{0.4, 0.8, 0.}, {0.5, 0.9, 0.1}]}, 
   {RGBColor[0.4, 0.8, 0.2], 
    CuboidBox[{0.4, 0.8, 0.2}, {0.5, 0.9, 0.30000000000000004`}]}, 
   {RGBColor[0.4, 0.8, 0.4], CuboidBox[{0.4, 0.8, 0.4}, {0.5, 0.9, 0.5}]}, 
   {RGBColor[0.4, 0.8, 0.6000000000000001], 
    CuboidBox[{0.4, 0.8, 0.6000000000000001}, {0.5, 0.9, 
     0.7000000000000001}]}, 
   {RGBColor[0.4, 0.8, 0.8], CuboidBox[{0.4, 0.8, 0.8}, {0.5, 0.9, 0.9}]}, 
   {RGBColor[0.4, 0.8, 1.], CuboidBox[{0.4, 0.8, 1.}, {0.5, 0.9, 1.1}]}, 
   {RGBColor[0.4, 1., 0.], CuboidBox[{0.4, 1., 0.}, {0.5, 1.1, 0.1}]}, 
   {RGBColor[0.4, 1., 0.2], 
    CuboidBox[{0.4, 1., 0.2}, {0.5, 1.1, 0.30000000000000004`}]}, 
   {RGBColor[0.4, 1., 0.4], CuboidBox[{0.4, 1., 0.4}, {0.5, 1.1, 0.5}]}, 
   {RGBColor[0.4, 1., 0.6000000000000001], 
    CuboidBox[{0.4, 1., 0.6000000000000001}, {0.5, 1.1, 
     0.7000000000000001}]}, 
   {RGBColor[0.4, 1., 0.8], CuboidBox[{0.4, 1., 0.8}, {0.5, 1.1, 0.9}]}, 
   {RGBColor[0.4, 1., 1.], CuboidBox[{0.4, 1., 1.}, {0.5, 1.1, 1.1}]}, 
   {RGBColor[0.6000000000000001, 0., 0.], 
    CuboidBox[{0.6000000000000001, 0., 0.}, {0.7000000000000001, 0.1, 
     0.1}]}, 
   {RGBColor[0.6000000000000001, 0., 0.2], 
    CuboidBox[{0.6000000000000001, 0., 0.2}, {0.7000000000000001, 0.1, 
     0.30000000000000004`}]}, 
   {RGBColor[0.6000000000000001, 0., 0.4], 
    CuboidBox[{0.6000000000000001, 0., 0.4}, {0.7000000000000001, 0.1, 
     0.5}]}, 
   {RGBColor[0.6000000000000001, 0., 0.6000000000000001], 
    CuboidBox[{0.6000000000000001, 0., 0.6000000000000001}, {
     0.7000000000000001, 0.1, 0.7000000000000001}]}, 
   {RGBColor[0.6000000000000001, 0., 0.8], 
    CuboidBox[{0.6000000000000001, 0., 0.8}, {0.7000000000000001, 0.1, 
     0.9}]}, 
   {RGBColor[0.6000000000000001, 0., 1.], 
    CuboidBox[{0.6000000000000001, 0., 1.}, {0.7000000000000001, 0.1, 
     1.1}]}, 
   {RGBColor[0.6000000000000001, 0.2, 0.], 
    CuboidBox[{0.6000000000000001, 0.2, 0.}, {0.7000000000000001, 
     0.30000000000000004`, 0.1}]}, 
   {RGBColor[0.6000000000000001, 0.2, 0.2], 
    CuboidBox[{0.6000000000000001, 0.2, 0.2}, {0.7000000000000001, 
     0.30000000000000004`, 0.30000000000000004`}]}, 
   {RGBColor[0.6000000000000001, 0.2, 0.4], 
    CuboidBox[{0.6000000000000001, 0.2, 0.4}, {0.7000000000000001, 
     0.30000000000000004`, 0.5}]}, 
   {RGBColor[0.6000000000000001, 0.2, 0.6000000000000001], 
    CuboidBox[{0.6000000000000001, 0.2, 0.6000000000000001}, {
     0.7000000000000001, 0.30000000000000004`, 0.7000000000000001}]}, 
   {RGBColor[0.6000000000000001, 0.2, 0.8], 
    CuboidBox[{0.6000000000000001, 0.2, 0.8}, {0.7000000000000001, 
     0.30000000000000004`, 0.9}]}, 
   {RGBColor[0.6000000000000001, 0.2, 1.], 
    CuboidBox[{0.6000000000000001, 0.2, 1.}, {0.7000000000000001, 
     0.30000000000000004`, 1.1}]}, 
   {RGBColor[0.6000000000000001, 0.4, 0.], 
    CuboidBox[{0.6000000000000001, 0.4, 0.}, {0.7000000000000001, 0.5, 
     0.1}]}, 
   {RGBColor[0.6000000000000001, 0.4, 0.2], 
    CuboidBox[{0.6000000000000001, 0.4, 0.2}, {0.7000000000000001, 0.5, 
     0.30000000000000004`}]}, 
   {RGBColor[0.6000000000000001, 0.4, 0.4], 
    CuboidBox[{0.6000000000000001, 0.4, 0.4}, {0.7000000000000001, 0.5, 
     0.5}]}, 
   {RGBColor[0.6000000000000001, 0.4, 0.6000000000000001], 
    CuboidBox[{0.6000000000000001, 0.4, 0.6000000000000001}, {
     0.7000000000000001, 0.5, 0.7000000000000001}]}, 
   {RGBColor[0.6000000000000001, 0.4, 0.8], 
    CuboidBox[{0.6000000000000001, 0.4, 0.8}, {0.7000000000000001, 0.5, 
     0.9}]}, 
   {RGBColor[0.6000000000000001, 0.4, 1.], 
    CuboidBox[{0.6000000000000001, 0.4, 1.}, {0.7000000000000001, 0.5, 
     1.1}]}, 
   {RGBColor[0.6000000000000001, 0.6000000000000001, 0.], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.}, {
     0.7000000000000001, 0.7000000000000001, 0.1}]}, 
   {RGBColor[0.6000000000000001, 0.6000000000000001, 0.2], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.2}, {
     0.7000000000000001, 0.7000000000000001, 0.30000000000000004`}]}, 
   {RGBColor[0.6000000000000001, 0.6000000000000001, 0.4], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.4}, {
     0.7000000000000001, 0.7000000000000001, 0.5}]}, 
   {RGBColor[0.6000000000000001, 0.6000000000000001, 0.6000000000000001], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.6000000000000001}, {
     0.7000000000000001, 0.7000000000000001, 0.7000000000000001}]}, 
   {RGBColor[0.6000000000000001, 0.6000000000000001, 0.8], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.8}, {
     0.7000000000000001, 0.7000000000000001, 0.9}]}, 
   {RGBColor[0.6000000000000001, 0.6000000000000001, 1.], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 1.}, {
     0.7000000000000001, 0.7000000000000001, 1.1}]}, 
   {RGBColor[0.6000000000000001, 0.8, 0.], 
    CuboidBox[{0.6000000000000001, 0.8, 0.}, {0.7000000000000001, 0.9, 
     0.1}]}, 
   {RGBColor[0.6000000000000001, 0.8, 0.2], 
    CuboidBox[{0.6000000000000001, 0.8, 0.2}, {0.7000000000000001, 0.9, 
     0.30000000000000004`}]}, 
   {RGBColor[0.6000000000000001, 0.8, 0.4], 
    CuboidBox[{0.6000000000000001, 0.8, 0.4}, {0.7000000000000001, 0.9, 
     0.5}]}, 
   {RGBColor[0.6000000000000001, 0.8, 0.6000000000000001], 
    CuboidBox[{0.6000000000000001, 0.8, 0.6000000000000001}, {
     0.7000000000000001, 0.9, 0.7000000000000001}]}, 
   {RGBColor[0.6000000000000001, 0.8, 0.8], 
    CuboidBox[{0.6000000000000001, 0.8, 0.8}, {0.7000000000000001, 0.9, 
     0.9}]}, 
   {RGBColor[0.6000000000000001, 0.8, 1.], 
    CuboidBox[{0.6000000000000001, 0.8, 1.}, {0.7000000000000001, 0.9, 
     1.1}]}, 
   {RGBColor[0.6000000000000001, 1., 0.], 
    CuboidBox[{0.6000000000000001, 1., 0.}, {0.7000000000000001, 1.1, 
     0.1}]}, 
   {RGBColor[0.6000000000000001, 1., 0.2], 
    CuboidBox[{0.6000000000000001, 1., 0.2}, {0.7000000000000001, 1.1, 
     0.30000000000000004`}]}, 
   {RGBColor[0.6000000000000001, 1., 0.4], 
    CuboidBox[{0.6000000000000001, 1., 0.4}, {0.7000000000000001, 1.1, 
     0.5}]}, 
   {RGBColor[0.6000000000000001, 1., 0.6000000000000001], 
    CuboidBox[{0.6000000000000001, 1., 0.6000000000000001}, {
     0.7000000000000001, 1.1, 0.7000000000000001}]}, 
   {RGBColor[0.6000000000000001, 1., 0.8], 
    CuboidBox[{0.6000000000000001, 1., 0.8}, {0.7000000000000001, 1.1, 
     0.9}]}, 
   {RGBColor[0.6000000000000001, 1., 1.], 
    CuboidBox[{0.6000000000000001, 1., 1.}, {0.7000000000000001, 1.1, 
     1.1}]}, 
   {RGBColor[0.8, 0., 0.], CuboidBox[{0.8, 0., 0.}, {0.9, 0.1, 0.1}]}, 
   {RGBColor[0.8, 0., 0.2], 
    CuboidBox[{0.8, 0., 0.2}, {0.9, 0.1, 0.30000000000000004`}]}, 
   {RGBColor[0.8, 0., 0.4], CuboidBox[{0.8, 0., 0.4}, {0.9, 0.1, 0.5}]}, 
   {RGBColor[0.8, 0., 0.6000000000000001], 
    CuboidBox[{0.8, 0., 0.6000000000000001}, {0.9, 0.1, 
     0.7000000000000001}]}, 
   {RGBColor[0.8, 0., 0.8], CuboidBox[{0.8, 0., 0.8}, {0.9, 0.1, 0.9}]}, 
   {RGBColor[0.8, 0., 1.], CuboidBox[{0.8, 0., 1.}, {0.9, 0.1, 1.1}]}, 
   {RGBColor[0.8, 0.2, 0.], 
    CuboidBox[{0.8, 0.2, 0.}, {0.9, 0.30000000000000004`, 0.1}]}, 
   {RGBColor[0.8, 0.2, 0.2], 
    CuboidBox[{0.8, 0.2, 0.2}, {0.9, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {RGBColor[0.8, 0.2, 0.4], 
    CuboidBox[{0.8, 0.2, 0.4}, {0.9, 0.30000000000000004`, 0.5}]}, 
   {RGBColor[0.8, 0.2, 0.6000000000000001], 
    CuboidBox[{0.8, 0.2, 0.6000000000000001}, {0.9, 0.30000000000000004`, 
     0.7000000000000001}]}, 
   {RGBColor[0.8, 0.2, 0.8], 
    CuboidBox[{0.8, 0.2, 0.8}, {0.9, 0.30000000000000004`, 0.9}]}, 
   {RGBColor[0.8, 0.2, 1.], 
    CuboidBox[{0.8, 0.2, 1.}, {0.9, 0.30000000000000004`, 1.1}]}, 
   {RGBColor[0.8, 0.4, 0.], CuboidBox[{0.8, 0.4, 0.}, {0.9, 0.5, 0.1}]}, 
   {RGBColor[0.8, 0.4, 0.2], 
    CuboidBox[{0.8, 0.4, 0.2}, {0.9, 0.5, 0.30000000000000004`}]}, 
   {RGBColor[0.8, 0.4, 0.4], CuboidBox[{0.8, 0.4, 0.4}, {0.9, 0.5, 0.5}]}, 
   {RGBColor[0.8, 0.4, 0.6000000000000001], 
    CuboidBox[{0.8, 0.4, 0.6000000000000001}, {0.9, 0.5, 
     0.7000000000000001}]}, 
   {RGBColor[0.8, 0.4, 0.8], CuboidBox[{0.8, 0.4, 0.8}, {0.9, 0.5, 0.9}]}, 
   {RGBColor[0.8, 0.4, 1.], CuboidBox[{0.8, 0.4, 1.}, {0.9, 0.5, 1.1}]}, 
   {RGBColor[0.8, 0.6000000000000001, 0.], 
    CuboidBox[{0.8, 0.6000000000000001, 0.}, {0.9, 0.7000000000000001, 
     0.1}]}, 
   {RGBColor[0.8, 0.6000000000000001, 0.2], 
    CuboidBox[{0.8, 0.6000000000000001, 0.2}, {0.9, 0.7000000000000001, 
     0.30000000000000004`}]}, 
   {RGBColor[0.8, 0.6000000000000001, 0.4], 
    CuboidBox[{0.8, 0.6000000000000001, 0.4}, {0.9, 0.7000000000000001, 
     0.5}]}, 
   {RGBColor[0.8, 0.6000000000000001, 0.6000000000000001], 
    CuboidBox[{0.8, 0.6000000000000001, 0.6000000000000001}, {0.9, 
     0.7000000000000001, 0.7000000000000001}]}, 
   {RGBColor[0.8, 0.6000000000000001, 0.8], 
    CuboidBox[{0.8, 0.6000000000000001, 0.8}, {0.9, 0.7000000000000001, 
     0.9}]}, 
   {RGBColor[0.8, 0.6000000000000001, 1.], 
    CuboidBox[{0.8, 0.6000000000000001, 1.}, {0.9, 0.7000000000000001, 
     1.1}]}, 
   {RGBColor[0.8, 0.8, 0.], CuboidBox[{0.8, 0.8, 0.}, {0.9, 0.9, 0.1}]}, 
   {RGBColor[0.8, 0.8, 0.2], 
    CuboidBox[{0.8, 0.8, 0.2}, {0.9, 0.9, 0.30000000000000004`}]}, 
   {RGBColor[0.8, 0.8, 0.4], CuboidBox[{0.8, 0.8, 0.4}, {0.9, 0.9, 0.5}]}, 
   {RGBColor[0.8, 0.8, 0.6000000000000001], 
    CuboidBox[{0.8, 0.8, 0.6000000000000001}, {0.9, 0.9, 
     0.7000000000000001}]}, 
   {RGBColor[0.8, 0.8, 0.8], CuboidBox[{0.8, 0.8, 0.8}, {0.9, 0.9, 0.9}]}, 
   {RGBColor[0.8, 0.8, 1.], CuboidBox[{0.8, 0.8, 1.}, {0.9, 0.9, 1.1}]}, 
   {RGBColor[0.8, 1., 0.], CuboidBox[{0.8, 1., 0.}, {0.9, 1.1, 0.1}]}, 
   {RGBColor[0.8, 1., 0.2], 
    CuboidBox[{0.8, 1., 0.2}, {0.9, 1.1, 0.30000000000000004`}]}, 
   {RGBColor[0.8, 1., 0.4], CuboidBox[{0.8, 1., 0.4}, {0.9, 1.1, 0.5}]}, 
   {RGBColor[0.8, 1., 0.6000000000000001], 
    CuboidBox[{0.8, 1., 0.6000000000000001}, {0.9, 1.1, 
     0.7000000000000001}]}, 
   {RGBColor[0.8, 1., 0.8], CuboidBox[{0.8, 1., 0.8}, {0.9, 1.1, 0.9}]}, 
   {RGBColor[0.8, 1., 1.], CuboidBox[{0.8, 1., 1.}, {0.9, 1.1, 1.1}]}, 
   {RGBColor[1., 0., 0.], CuboidBox[{1., 0., 0.}, {1.1, 0.1, 0.1}]}, 
   {RGBColor[1., 0., 0.2], 
    CuboidBox[{1., 0., 0.2}, {1.1, 0.1, 0.30000000000000004`}]}, 
   {RGBColor[1., 0., 0.4], CuboidBox[{1., 0., 0.4}, {1.1, 0.1, 0.5}]}, 
   {RGBColor[1., 0., 0.6000000000000001], 
    CuboidBox[{1., 0., 0.6000000000000001}, {1.1, 0.1, 
     0.7000000000000001}]}, 
   {RGBColor[1., 0., 0.8], CuboidBox[{1., 0., 0.8}, {1.1, 0.1, 0.9}]}, 
   {RGBColor[1., 0., 1.], CuboidBox[{1., 0., 1.}, {1.1, 0.1, 1.1}]}, 
   {RGBColor[1., 0.2, 0.], 
    CuboidBox[{1., 0.2, 0.}, {1.1, 0.30000000000000004`, 0.1}]}, 
   {RGBColor[1., 0.2, 0.2], 
    CuboidBox[{1., 0.2, 0.2}, {1.1, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {RGBColor[1., 0.2, 0.4], 
    CuboidBox[{1., 0.2, 0.4}, {1.1, 0.30000000000000004`, 0.5}]}, 
   {RGBColor[1., 0.2, 0.6000000000000001], 
    CuboidBox[{1., 0.2, 0.6000000000000001}, {1.1, 0.30000000000000004`, 
     0.7000000000000001}]}, 
   {RGBColor[1., 0.2, 0.8], 
    CuboidBox[{1., 0.2, 0.8}, {1.1, 0.30000000000000004`, 0.9}]}, 
   {RGBColor[1., 0.2, 1.], 
    CuboidBox[{1., 0.2, 1.}, {1.1, 0.30000000000000004`, 1.1}]}, 
   {RGBColor[1., 0.4, 0.], CuboidBox[{1., 0.4, 0.}, {1.1, 0.5, 0.1}]}, 
   {RGBColor[1., 0.4, 0.2], 
    CuboidBox[{1., 0.4, 0.2}, {1.1, 0.5, 0.30000000000000004`}]}, 
   {RGBColor[1., 0.4, 0.4], CuboidBox[{1., 0.4, 0.4}, {1.1, 0.5, 0.5}]}, 
   {RGBColor[1., 0.4, 0.6000000000000001], 
    CuboidBox[{1., 0.4, 0.6000000000000001}, {1.1, 0.5, 
     0.7000000000000001}]}, 
   {RGBColor[1., 0.4, 0.8], CuboidBox[{1., 0.4, 0.8}, {1.1, 0.5, 0.9}]}, 
   {RGBColor[1., 0.4, 1.], CuboidBox[{1., 0.4, 1.}, {1.1, 0.5, 1.1}]}, 
   {RGBColor[1., 0.6000000000000001, 0.], 
    CuboidBox[{1., 0.6000000000000001, 0.}, {1.1, 0.7000000000000001, 
     0.1}]}, 
   {RGBColor[1., 0.6000000000000001, 0.2], 
    CuboidBox[{1., 0.6000000000000001, 0.2}, {1.1, 0.7000000000000001, 
     0.30000000000000004`}]}, 
   {RGBColor[1., 0.6000000000000001, 0.4], 
    CuboidBox[{1., 0.6000000000000001, 0.4}, {1.1, 0.7000000000000001, 
     0.5}]}, 
   {RGBColor[1., 0.6000000000000001, 0.6000000000000001], 
    CuboidBox[{1., 0.6000000000000001, 0.6000000000000001}, {1.1, 
     0.7000000000000001, 0.7000000000000001}]}, 
   {RGBColor[1., 0.6000000000000001, 0.8], 
    CuboidBox[{1., 0.6000000000000001, 0.8}, {1.1, 0.7000000000000001, 
     0.9}]}, 
   {RGBColor[1., 0.6000000000000001, 1.], 
    CuboidBox[{1., 0.6000000000000001, 1.}, {1.1, 0.7000000000000001, 
     1.1}]}, 
   {RGBColor[1., 0.8, 0.], CuboidBox[{1., 0.8, 0.}, {1.1, 0.9, 0.1}]}, 
   {RGBColor[1., 0.8, 0.2], 
    CuboidBox[{1., 0.8, 0.2}, {1.1, 0.9, 0.30000000000000004`}]}, 
   {RGBColor[1., 0.8, 0.4], CuboidBox[{1., 0.8, 0.4}, {1.1, 0.9, 0.5}]}, 
   {RGBColor[1., 0.8, 0.6000000000000001], 
    CuboidBox[{1., 0.8, 0.6000000000000001}, {1.1, 0.9, 
     0.7000000000000001}]}, 
   {RGBColor[1., 0.8, 0.8], CuboidBox[{1., 0.8, 0.8}, {1.1, 0.9, 0.9}]}, 
   {RGBColor[1., 0.8, 1.], CuboidBox[{1., 0.8, 1.}, {1.1, 0.9, 1.1}]}, 
   {RGBColor[1., 1., 0.], CuboidBox[{1., 1., 0.}, {1.1, 1.1, 0.1}]}, 
   {RGBColor[1., 1., 0.2], 
    CuboidBox[{1., 1., 0.2}, {1.1, 1.1, 0.30000000000000004`}]}, 
   {RGBColor[1., 1., 0.4], CuboidBox[{1., 1., 0.4}, {1.1, 1.1, 0.5}]}, 
   {RGBColor[1., 1., 0.6000000000000001], 
    CuboidBox[{1., 1., 0.6000000000000001}, {1.1, 1.1, 
     0.7000000000000001}]}, 
   {RGBColor[1., 1., 0.8], CuboidBox[{1., 1., 0.8}, {1.1, 1.1, 0.9}]}, 
   {RGBColor[1., 1., 1.], CuboidBox[{1., 1., 1.}, {1.1, 1.1, 1.1}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"Red\"", TraditionalForm], 
    FormBox["\"Green\"", TraditionalForm], 
    FormBox["\"Blue\"", TraditionalForm]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{229, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->268382553,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->452337717],

Cell["RGB noise with opacity:", "ExampleText",
 CellID->459168869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Pink", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"100", ",", "100"}], "}"}], ",", "40"}], "]"}], ",", 
    RowBox[{"Raster", "[", 
     RowBox[{
      RowBox[{"RandomReal", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"200", ",", "200", ",", "4"}], "}"}]}], "]"}], ",", 
      RowBox[{"ColorFunction", "\[Rule]", "RGBColor"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1167787],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->24204069]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32156],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CMYKColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CMYKColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Opacity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opacity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Glow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Glow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Raster",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Raster"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Red",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Red"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Green",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Green"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["White",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/White"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16843]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6791],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with RGBColor",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=RGBColor"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->91469026],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->97573413],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->61820560],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout",
 CellID->153587556],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->24820391]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RGBColor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 17, 30.5995742}", "context" -> "System`", 
    "keywords" -> {
     "additive color", "color", "color model", "color space", "device color", 
      "diffuse color", "pigment", "RGB", "RGBA", "RGB color model"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RGBColor[red, green, blue] is a graphics directive which specifies that \
objects which follow are to be displayed, if possible, in the color given. \
RGBColor[r, g, b, a] specifies opacity a. ", "synonyms" -> {"RGB Color"}, 
    "title" -> "RGBColor", "type" -> "Symbol", "uri" -> "ref/RGBColor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15678, 443, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3570066]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 419360, 8086}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3816, 76, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4439, 103, 4192, 83, 70, "ObjectNameGrid"],
Cell[8634, 188, 1138, 35, 70, "Usage",
 CellID->15376]
}, Open  ]],
Cell[CellGroupData[{
Cell[9809, 228, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10287, 245, 951, 34, 70, "Notes",
 CellID->23764],
Cell[11241, 281, 233, 7, 70, "Notes",
 CellID->22531],
Cell[11477, 290, 141, 4, 70, "Notes",
 CellID->11830],
Cell[11621, 296, 534, 15, 70, "Notes",
 CellID->29642],
Cell[12158, 313, 516, 16, 70, "Notes",
 CellID->11320],
Cell[12677, 331, 621, 21, 70, "Notes",
 CellID->607],
Cell[13301, 354, 935, 33, 70, "Notes",
 CellID->28867],
Cell[14239, 389, 746, 26, 70, "Notes",
 CellID->17786],
Cell[14988, 417, 653, 21, 70, "Notes",
 CellID->20574]
}, Closed]],
Cell[CellGroupData[{
Cell[15678, 443, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3570066],
Cell[CellGroupData[{
Cell[16061, 457, 147, 5, 70, "ExampleSection",
 CellID->34774155],
Cell[16211, 464, 84, 1, 70, "ExampleText",
 CellID->149026781],
Cell[CellGroupData[{
Cell[16320, 469, 251, 8, 28, "Input",
 CellID->64769354],
Cell[16574, 479, 263, 8, 121, "Output",
 CellID->562514834]
}, Open  ]],
Cell[16852, 490, 124, 3, 70, "ExampleDelimiter",
 CellID->33200138],
Cell[16979, 495, 74, 1, 70, "ExampleText",
 CellID->263465182],
Cell[CellGroupData[{
Cell[17078, 500, 267, 8, 70, "Input",
 CellID->152479682],
Cell[17348, 510, 5977, 103, 129, 100, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->142307062]
}, Open  ]],
Cell[23340, 616, 125, 3, 70, "ExampleDelimiter",
 CellID->283521252],
Cell[23468, 621, 130, 2, 70, "ExampleText",
 CellID->53708190],
Cell[CellGroupData[{
Cell[23623, 627, 269, 9, 70, "Input",
 CellID->195861199],
Cell[23895, 638, 406, 14, 36, "Output",
 CellID->78435711]
}, Open  ]],
Cell[24316, 655, 125, 3, 70, "ExampleDelimiter",
 CellID->109280459],
Cell[24444, 660, 70, 1, 70, "ExampleText",
 CellID->580206808],
Cell[CellGroupData[{
Cell[24539, 665, 381, 12, 28, "Input",
 CellID->211868938],
Cell[24923, 679, 5727, 98, 128, "Output",
 Evaluatable->False,
 CellID->597373970]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30699, 783, 216, 7, 70, "ExampleSection",
 CellID->19242],
Cell[CellGroupData[{
Cell[30940, 794, 280, 8, 70, "ExampleSubsection",
 CellID->23349739],
Cell[31223, 804, 69, 1, 70, "ExampleText",
 CellID->404625886],
Cell[CellGroupData[{
Cell[31317, 809, 255, 8, 70, "Input",
 CellID->907978],
Cell[31575, 819, 28139, 466, 216, 88, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->441003491]
}, Open  ]],
Cell[59729, 1288, 82, 1, 70, "ExampleText",
 CellID->928327454],
Cell[CellGroupData[{
Cell[59836, 1293, 338, 10, 70, "Input",
 CellID->29801507],
Cell[60177, 1305, 32897, 545, 216, 124, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->121426975]
}, Open  ]],
Cell[93089, 1853, 152, 3, 70, "ExampleText",
 CellID->255057354],
Cell[CellGroupData[{
Cell[93266, 1860, 306, 9, 70, "Input",
 CellID->93466233],
Cell[93575, 1871, 3020, 55, 216, 113, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->590555239]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[96644, 1932, 237, 7, 70, "ExampleSubsection",
 CellID->304353039],
Cell[96884, 1941, 206, 8, 70, "ExampleText",
 CellID->84492988],
Cell[CellGroupData[{
Cell[97115, 1953, 916, 28, 70, "Input",
 CellID->485561805],
Cell[98034, 1983, 514, 18, 123, "Output",
 CellID->338245211]
}, Open  ]],
Cell[98563, 2004, 352, 13, 70, "ExampleText",
 CellID->480333690],
Cell[CellGroupData[{
Cell[98940, 2021, 902, 28, 70, "Input",
 CellID->516667508],
Cell[99845, 2051, 441, 14, 123, "Output",
 CellID->636162078]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[100347, 2072, 239, 7, 70, "ExampleSection",
 CellID->24434],
Cell[100589, 2081, 652, 24, 70, "ExampleText",
 CellID->383015872],
Cell[CellGroupData[{
Cell[101266, 2109, 532, 17, 70, "Input",
 CellID->432857000],
Cell[101801, 2128, 363, 12, 123, "Output",
 CellID->70438]
}, Open  ]],
Cell[CellGroupData[{
Cell[102201, 2145, 548, 18, 70, "Input",
 CellID->1817259],
Cell[102752, 2165, 432, 14, 123, "Output",
 CellID->245700764]
}, Open  ]],
Cell[103199, 2182, 125, 3, 70, "ExampleDelimiter",
 CellID->129929248],
Cell[103327, 2187, 315, 13, 70, "ExampleText",
 CellID->736955090],
Cell[CellGroupData[{
Cell[103667, 2204, 655, 19, 70, "Input",
 CellID->162022429],
Cell[104325, 2225, 914, 29, 91, "Output",
 CellID->5423781]
}, Open  ]],
Cell[105254, 2257, 268, 9, 70, "ExampleText",
 CellID->196212995],
Cell[CellGroupData[{
Cell[105547, 2270, 616, 18, 70, "Input",
 CellID->72375890],
Cell[106166, 2290, 915, 29, 91, "Output",
 CellID->45558819]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[107130, 2325, 223, 7, 70, "ExampleSection",
 CellID->17702],
Cell[107356, 2334, 83, 1, 70, "ExampleText",
 CellID->88338137],
Cell[107442, 2337, 1216, 34, 70, "Input",
 CellID->188096528],
Cell[CellGroupData[{
Cell[108683, 2375, 433, 14, 70, "Input",
 CellID->416844350],
Cell[109119, 2391, 49099, 850, 70, "Output",
 CellID->460568891]
}, Open  ]],
Cell[CellGroupData[{
Cell[158255, 3246, 433, 14, 70, "Input",
 CellID->703730849],
Cell[158691, 3262, 30959, 521, 193, 4551, 84, "CachedBoxData", "BoxData", \
"Output",
 CellID->211736638]
}, Open  ]],
Cell[CellGroupData[{
Cell[189687, 3788, 506, 17, 70, "Input",
 CellID->581930822],
Cell[190196, 3807, 19163, 318, 70, "Output",
 Evaluatable->False,
 CellID->440924533]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[209408, 4131, 233, 7, 70, "ExampleSection",
 CellID->16077],
Cell[209644, 4140, 215, 8, 70, "ExampleText",
 CellID->702805721],
Cell[CellGroupData[{
Cell[209884, 4152, 303, 10, 70, "Input",
 CellID->567842223],
Cell[210190, 4164, 395, 12, 36, "Output",
 CellID->258376994]
}, Open  ]],
Cell[CellGroupData[{
Cell[210622, 4181, 161, 4, 70, "Input",
 CellID->10368557],
Cell[210786, 4187, 4156, 82, 70, "Output",
 CellID->530345386]
}, Open  ]],
Cell[CellGroupData[{
Cell[214979, 4274, 599, 19, 70, "Input",
 CellID->103465633],
Cell[215581, 4295, 35620, 597, 159, 10501, 181, "CachedBoxData", "BoxData", \
"Output",
 CellID->953093564]
}, Open  ]],
Cell[251216, 4895, 125, 3, 70, "ExampleDelimiter",
 CellID->853338141],
Cell[251344, 4900, 213, 8, 70, "ExampleText",
 CellID->679244646],
Cell[CellGroupData[{
Cell[251582, 4912, 140, 4, 70, "Input",
 CellID->237154420],
Cell[251725, 4918, 6153, 134, 70, "Output",
 CellID->261426867]
}, Open  ]],
Cell[257893, 5055, 125, 3, 70, "ExampleDelimiter",
 CellID->195796739],
Cell[258021, 5060, 252, 8, 70, "ExampleText",
 CellID->148407395],
Cell[CellGroupData[{
Cell[258298, 5072, 233, 7, 70, "Input",
 CellID->446655730],
Cell[258534, 5081, 352, 10, 70, "Output",
 CellID->12206320]
}, Open  ]],
Cell[258901, 5094, 222, 8, 70, "ExampleText",
 CellID->89143513],
Cell[CellGroupData[{
Cell[259148, 5106, 232, 7, 70, "Input",
 CellID->62658812],
Cell[259383, 5115, 361, 10, 70, "Output",
 CellID->192229828]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[259793, 5131, 226, 7, 70, "ExampleSection",
 CellID->32245],
Cell[260022, 5140, 137, 2, 70, "ExampleText",
 CellID->483075],
Cell[CellGroupData[{
Cell[260184, 5146, 670, 21, 70, "Input",
 CellID->168215278],
Cell[260857, 5169, 423, 11, 70, "Output",
 Evaluatable->False,
 CellID->887610250]
}, Open  ]],
Cell[261295, 5183, 268, 8, 70, "ExampleText",
 CellID->37537136],
Cell[CellGroupData[{
Cell[261588, 5195, 755, 22, 70, "Input",
 CellID->71933364],
Cell[262346, 5219, 1346, 26, 70, "Output",
 Evaluatable->False,
 CellID->312834863]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[263741, 5251, 224, 7, 70, "ExampleSection",
 CellID->16135],
Cell[263968, 5260, 75, 1, 70, "ExampleText",
 CellID->119505576],
Cell[CellGroupData[{
Cell[264068, 5265, 862, 26, 70, "Input",
 CellID->132332677],
Cell[264933, 5293, 69941, 1233, 258, 24304, 480, "CachedBoxData", "BoxData", \
"Output",
 CellID->268382553]
}, Open  ]],
Cell[334889, 6529, 125, 3, 70, "ExampleDelimiter",
 CellID->452337717],
Cell[335017, 6534, 66, 1, 70, "ExampleText",
 CellID->459168869],
Cell[CellGroupData[{
Cell[335108, 6539, 539, 17, 70, "Input",
 CellID->1167787],
Cell[335650, 6558, 75794, 1247, 70, "Output",
 Evaluatable->False,
 CellID->24204069]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[411505, 7812, 311, 9, 70, "SeeAlsoSection",
 CellID->32156],
Cell[411819, 7823, 3831, 143, 70, "SeeAlso",
 CellID->16843]
}, Open  ]],
Cell[CellGroupData[{
Cell[415687, 7971, 313, 9, 70, "TutorialsSection",
 CellID->6791],
Cell[416003, 7982, 197, 4, 70, "Tutorials",
 CellID->815154705],
Cell[416203, 7988, 162, 3, 70, "Tutorials",
 CellID->659944600]
}, Open  ]],
Cell[CellGroupData[{
Cell[416402, 7996, 305, 8, 70, "RelatedLinksSection"],
Cell[416710, 8006, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[417108, 8023, 318, 9, 70, "MoreAboutSection",
 CellID->91469026],
Cell[417429, 8034, 123, 3, 70, "MoreAbout",
 CellID->97573413],
Cell[417555, 8039, 148, 3, 70, "MoreAbout",
 CellID->61820560],
Cell[417706, 8044, 150, 3, 70, "MoreAbout",
 CellID->153587556],
Cell[417859, 8049, 161, 3, 70, "MoreAbout",
 CellID->24820391]
}, Open  ]],
Cell[418035, 8055, 50, 0, 70, "History"],
Cell[418088, 8057, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

