(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18431,        687]
NotebookOptionsPosition[     14548,        556]
NotebookOutlinePosition[     15866,        593]
CellTagsIndexPosition[     15781,        588]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"], 
          "String Representation of Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringRepresentationOfBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>", 
       2->"\<\"String Representation of Boxes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Power" :> Documentation`HelpLookup["paclet:ref/Power"], 
          "SqrtBox" :> Documentation`HelpLookup["paclet:ref/SqrtBox"], 
          "OverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/OverscriptBox"], "GridBox" :> 
          Documentation`HelpLookup["paclet:ref/GridBox"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Power\"\>", 2->"\<\"SqrtBox\"\>", 
       3->"\<\"OverscriptBox\"\>", 4->"\<\"GridBox\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RadicalBox", "ObjectName",
 CellID->25132],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RadicalBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RadicalBox"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a low-level box construct that represents the \
displayed object ",
     Cell[BoxData[
      FormBox[
       RadicalBox["x", "n"], TraditionalForm]], "InlineMath"],
     " in notebook expressions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11061]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Inside ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\\(", "\[Ellipsis]", "\\)"}], TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RadicalBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadicalBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " can be input as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\\@", 
    RowBox[{"x", "\\%", "n"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->23452],

Cell[TextData[{
 "In a notebook a ",
 Cell[BoxData[
  ButtonBox["RadicalBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadicalBox"]], "InlineFormula"],
 " can be created using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 ", then using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " to move to the index position. ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " moves out of the radical. "
}], "Notes",
 CellID->17560],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RadicalBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadicalBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " is interpreted on input as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "n"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->1277],

Cell[TextData[{
 "The baseline of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RadicalBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadicalBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " is taken to be the baseline of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->21486],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RadicalBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadicalBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " does not fit on a single line, it is output as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "n"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->28717],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", explicit ",
 Cell[BoxData[
  ButtonBox["RadicalBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadicalBox"]], "InlineFormula"],
 " objects are output literally. You can use ",
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 " to see the display form of such objects. "
}], "Notes",
 CellID->5101]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->427476914],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->173320846],

Cell["Display a letter under a radical with a root index:", "ExampleText",
 CellID->199545933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RadicalBox", "[", 
   RowBox[{"\"\<x\>\"", ",", "\"\<3\>\""}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->588923719],

Cell[BoxData[
 TagBox[
  RadicalBox["x", "3"],
  DisplayForm]], "Output",
 ImageSize->{28, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->54401388]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179292804],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["RadicalBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadicalBox"]], "InlineFormula"],
 " form is typically interpreted as a fractional power:"
}], "ExampleText",
 CellID->145883430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   RowBox[{"RadicalBox", "[", 
    RowBox[{"\"\<x\>\"", ",", "\"\<3\>\""}], "]"}], ",", "StandardForm"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5935187],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{"1", "/", "3"}]]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67528443]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->159520666],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Rational", "[", 
      RowBox[{"1", ",", "3"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->253353776]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243599250],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting for an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " root uses ",
 Cell[BoxData[
  ButtonBox["RadicalBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadicalBox"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->85956211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToBoxes", "[", 
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "3"}], ")"}]}], ",", "TraditionalForm"}], "]"}], "//",
   "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35539747],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"FormBox", "[", 
    RowBox[{
     RowBox[{"RadicalBox", "[", 
      RowBox[{"\"\<x\>\"", ",", "\"\<3\>\""}], "]"}], ",", 
     "TraditionalForm"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{321, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->131705388]
}, Open  ]],

Cell["The formatted result looks like this:", "ExampleText",
 CellID->416076514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", 
   RowBox[{"(", 
    RowBox[{"1", "/", "3"}], ")"}]}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114330713],

Cell[BoxData[
 FormBox[
  RadicalBox["x", "3"], TraditionalForm]], "Output",
 ImageSize->{27, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->459498898]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30956],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SqrtBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SqrtBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OverscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OverscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GridBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15201]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17446],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->4668],

Cell[TextData[ButtonBox["String Representation of Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringRepresentationOfBoxes"]], "Tutorials",
 CellID->187054374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->270095754]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RadicalBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 37.6404856}", "context" -> "System`", 
    "keywords" -> {"radicals", "roots", "\\sqrt (TeX)", "surds"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RadicalBox[x, n] is a low-level box construct that represents the \
displayed object Power[x, (n)^-1] in notebook expressions. ", 
    "synonyms" -> {"radical box"}, "title" -> "RadicalBox", "type" -> 
    "Symbol", "uri" -> "ref/RadicalBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7592, 269, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->427476914]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15638, 581}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2317, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2940, 83, 48, 1, 70, "ObjectName",
 CellID->25132],
Cell[2991, 86, 700, 22, 70, "Usage",
 CellID->11061]
}, Open  ]],
Cell[CellGroupData[{
Cell[3728, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4206, 130, 524, 21, 70, "Notes",
 CellID->23452],
Cell[4733, 153, 698, 24, 70, "Notes",
 CellID->17560],
Cell[5434, 179, 714, 28, 70, "Notes",
 CellID->1277],
Cell[6151, 209, 392, 15, 70, "Notes",
 CellID->21486],
Cell[6546, 226, 470, 18, 70, "Notes",
 CellID->28717],
Cell[7019, 246, 536, 18, 70, "Notes",
 CellID->5101]
}, Closed]],
Cell[CellGroupData[{
Cell[7592, 269, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->427476914],
Cell[CellGroupData[{
Cell[7977, 283, 148, 5, 70, "ExampleSection",
 CellID->173320846],
Cell[8128, 290, 94, 1, 70, "ExampleText",
 CellID->199545933],
Cell[CellGroupData[{
Cell[8247, 295, 183, 6, 28, "Input",
 CellID->588923719],
Cell[8433, 303, 215, 8, 54, "Output",
 CellID->54401388]
}, Open  ]],
Cell[8663, 314, 125, 3, 70, "ExampleDelimiter",
 CellID->179292804],
Cell[8791, 319, 241, 8, 70, "ExampleText",
 CellID->145883430],
Cell[CellGroupData[{
Cell[9057, 331, 222, 7, 70, "Input",
 CellID->5935187],
Cell[9282, 340, 203, 7, 36, "Output",
 CellID->67528443]
}, Open  ]],
Cell[CellGroupData[{
Cell[9522, 352, 100, 3, 70, "Input",
 CellID->159520666],
Cell[9625, 357, 413, 15, 50, "Output",
 CellID->253353776]
}, Open  ]],
Cell[10053, 375, 125, 3, 70, "ExampleDelimiter",
 CellID->243599250],
Cell[10181, 380, 510, 19, 70, "ExampleText",
 CellID->85956211],
Cell[CellGroupData[{
Cell[10716, 403, 252, 9, 70, "Input",
 CellID->35539747],
Cell[10971, 414, 453, 16, 50, "Output",
 CellID->131705388]
}, Open  ]],
Cell[11439, 433, 80, 1, 70, "ExampleText",
 CellID->416076514],
Cell[CellGroupData[{
Cell[11544, 438, 179, 6, 70, "Input",
 CellID->114330713],
Cell[11726, 446, 223, 7, 56, "Output",
 CellID->459498898]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12010, 460, 311, 9, 70, "SeeAlsoSection",
 CellID->30956],
Cell[12324, 471, 941, 35, 70, "SeeAlso",
 CellID->15201]
}, Open  ]],
Cell[CellGroupData[{
Cell[13302, 511, 314, 9, 70, "TutorialsSection",
 CellID->17446],
Cell[13619, 522, 178, 4, 70, "Tutorials",
 CellID->4668],
Cell[13800, 528, 172, 3, 70, "Tutorials",
 CellID->187054374]
}, Open  ]],
Cell[CellGroupData[{
Cell[14009, 536, 299, 8, 70, "MoreAboutSection"],
Cell[14311, 546, 165, 3, 70, "MoreAbout",
 CellID->270095754]
}, Open  ]],
Cell[14491, 552, 27, 0, 70, "History"],
Cell[14521, 554, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

