(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38975,       1398]
NotebookOptionsPosition[     31587,       1151]
NotebookOutlinePosition[     33449,       1196]
CellTagsIndexPosition[     33363,       1191]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RadioButtonBar" :> 
          Documentation`HelpLookup["paclet:ref/RadioButtonBar"], "Setter" :> 
          Documentation`HelpLookup["paclet:ref/Setter"], "Checkbox" :> 
          Documentation`HelpLookup["paclet:ref/Checkbox"], "Button" :> 
          Documentation`HelpLookup["paclet:ref/Button"], "Toggler" :> 
          Documentation`HelpLookup["paclet:ref/Toggler"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RadioButtonBar\"\>", 2->"\<\"Setter\"\>", 
       3->"\<\"Checkbox\"\>", 4->"\<\"Button\"\>", 
       5->"\<\"Toggler\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RadioButton", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RadioButton",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RadioButton"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a radio button whose setting ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is set to ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " when the button is clicked. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RadioButton",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RadioButton"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is displayed as ",
     Cell[BoxData[
      TagBox[
       RadioButtonBox[0, {0}],
       EventHandlerTag[{
        "MouseDown" -> Null, PassEventsDown -> Automatic, PassEventsUp -> 
         True}]]]],
     " when ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     ", and as ",
     Cell[BoxData[
      TagBox[
       RadioButtonBox[1, {0}],
       EventHandlerTag[{
        "MouseDown" -> Null, PassEventsDown -> Automatic, PassEventsUp -> 
         True}]]]],
     " otherwise. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RadioButton",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RadioButton"], "[", 
       RowBox[{
        RowBox[{
         ButtonBox["Dynamic",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Dynamic"], "[", 
         StyleBox["x", "TI"], "]"}], ",", 
        StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being reset if the button is clicked. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->1302]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 " is effectively a special case of ",
 Cell[BoxData[
  ButtonBox["Setter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setter"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->750502910]
}], "Notes",
 CellID->3559],

Cell[TextData[{
 "Radio buttons representing several mutually exclusive choices can be \
created by having several ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RadioButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadioButton"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Dynamic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dynamic"], "[", 
     StyleBox["x", "TI"], "]"}], ",", 
    SubscriptBox[
     StyleBox["val", "TI"], 
     StyleBox["i", "TI"]]}], "]"}]], "InlineFormula"],
 " with the same ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " but different ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->731368666,
  ButtonNote->"731368666"]
}], "Notes",
 CellID->1020],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RadioButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadioButton"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RadioButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadioButton"], "[", 
   RowBox[{
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], ",", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16851]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->47343456],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->818253885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RadioButton", "[", "]"}], ",", 
   RowBox[{"RadioButton", "[", 
    RowBox[{"False", ",", "True"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131990289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RadioButtonBox[False, {True}], ",", 
   RadioButtonBox[False, {True}]}], "}"}]], "Output",
 ImageSize->{68, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141051207]
}, Open  ]],

Cell[TextData[{
 "Dynamically change the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->731368666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RadioButton", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "0"}], "]"}], ",", 
   RowBox[{"RadioButton", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->123836227],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RadioButtonBox[Dynamic[$CellContext`x], {0}], ",", 
   RadioButtonBox[Dynamic[$CellContext`x], {1}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{86, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133652230]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->514616474],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->13416912],

Cell["Control the appearance:", "ExampleText",
 CellID->1788243481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RadioButton", "[", 
    RowBox[{"False", ",", "True", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294823549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RadioButtonBox[False, {True},
    Appearance->Tiny], ",", 
   RadioButtonBox[False, {True},
    Appearance->Small], ",", 
   RadioButtonBox[False, {True},
    Appearance->Medium], ",", 
   RadioButtonBox[False, {True},
    Appearance->Large]}], "}"}]], "Output",
 ImageSize->{120, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->292742180]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->974545402],

Cell["Dynamically change the appearance:", "ExampleText",
 CellID->323346172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RadioButton", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "a", ",", 
     RowBox[{"Appearance", "\[Rule]", 
      RowBox[{"Dynamic", "[", "x", "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206979933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RadioButtonBox[Dynamic[$CellContext`x], {Tiny},
    Appearance->Dynamic[$CellContext`x]], ",", 
   RadioButtonBox[Dynamic[$CellContext`x], {Small},
    Appearance->Dynamic[$CellContext`x]], ",", 
   RadioButtonBox[Dynamic[$CellContext`x], {Medium},
    Appearance->Dynamic[$CellContext`x]], ",", 
   RadioButtonBox[Dynamic[$CellContext`x], {Large},
    Appearance->Dynamic[$CellContext`x]]}], "}"}]], "Output",
 ImageSize->{108, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182703903]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->48745542],

Cell["\<\
Values update as the cursor is moved over the clickable area:\
\>", "ExampleText",
 CellID->542841723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RadioButton", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "1", ",", 
     RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"RadioButton", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "2", ",", 
     RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493478890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RadioButtonBox[Dynamic[$CellContext`x], {1},
    AutoAction->True], ",", 
   RadioButtonBox[Dynamic[$CellContext`x], {2},
    AutoAction->True], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{86, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->492664761]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->763904683],

Cell["Set the background color:", "ExampleText",
 CellID->652399918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RadioButton", "[", 
    RowBox[{"Background", "\[Rule]", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Green", ",", "Yellow", ",", "Orange"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->326795745],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RadioButtonBox[False, {True},
    Background->RGBColor[1, 0.5, 0.5]], ",", 
   RadioButtonBox[False, {True},
    Background->RGBColor[0, 1, 0]], ",", 
   RadioButtonBox[False, {True},
    Background->RGBColor[1, 1, 0]], ",", 
   RadioButtonBox[False, {True},
    Background->RGBColor[1, 0.5, 0]]}], "}"}]], "Output",
 ImageSize->{128, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153326513]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266034590],

Cell["Dynamically change the background color:", "ExampleText",
 CellID->38915991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RadioButton", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "Gray", ",", 
     RowBox[{"Background", "\[Rule]", 
      RowBox[{"Dynamic", "[", "x", "]"}]}]}], "]"}], ",", 
   RowBox[{"RadioButton", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "Pink", ",", 
     RowBox[{"Background", "\[Rule]", 
      RowBox[{"Dynamic", "[", "x", "]"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->478223244],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RadioButtonBox[Dynamic[$CellContext`x], {GrayLevel[0.5]},
    Background->Dynamic[$CellContext`x]], ",", 
   RadioButtonBox[Dynamic[$CellContext`x], {RGBColor[1, 0.5, 0.5]},
    Background->Dynamic[$CellContext`x]]}], "}"}]], "Output",
 ImageSize->{68, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39884914]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->106220695],

Cell["Align with surrounding text:", "ExampleText",
 CellID->413800597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RadioButton", "[", 
      RowBox[{"BaselinePosition", "\[Rule]", "b"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"{", 
        RowBox[{"Bottom", ",", "Center", ",", "Top"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1194584793],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RadioButtonBox[False, {True},
    BaselinePosition->Bottom], "xxx", 
   RadioButtonBox[False, {True},
    BaselinePosition->Center], "xxx", 
   RadioButtonBox[False, {True},
    BaselinePosition->Top]}],
  Row[{
    RadioButton[BaselinePosition -> Bottom], 
    RadioButton[BaselinePosition -> Center], 
    RadioButton[BaselinePosition -> Top]}, "xxx"]]], "Output",
 ImageSize->{115, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->562000148]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->204399392],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RadioButton", "[", 
  RowBox[{"x", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 RadioButtonBox[$CellContext`x, {0}]], "Output",
 ImageSize->{23, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->483442590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->488488182],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], " ", "\[Rule]", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the radio button is disabled but visible in its current state:"
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RadioButton", "[", 
  RowBox[{"x", ",", "1", ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->247984633],

Cell[BoxData[
 RadioButtonBox[$CellContext`x, {1},
  Enabled->False]], "Output",
 ImageSize->{23, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113550742]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->577585289],

Cell[TextData[{
 "Increase the clickable area of ",
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->281981288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"RadioButton", "[", 
     RowBox[{"ImageMargins", "\[Rule]", "m"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "20"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->903407930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    RadioButtonBox[False, {True},
     ImageMargins->0],
    StripOnInput->False], ",", 
   FrameBox[
    RadioButtonBox[False, {True},
     ImageMargins->5],
    StripOnInput->False], ",", 
   FrameBox[
    RadioButtonBox[False, {True},
     ImageMargins->10],
    StripOnInput->False], ",", 
   FrameBox[
    RadioButtonBox[False, {True},
     ImageMargins->20],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{238, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->867695220]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->48599551],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RadioButtonBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButtonBar"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 " with the same variable:"
}], "ExampleText",
 CellID->469310745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RadioButtonBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93453470],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      TagBox[GridBox[{
         {
          RadioButtonBox[Dynamic[$CellContext`x], {1}], "1"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          RadioButtonBox[Dynamic[$CellContext`x], {2}], "2"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          RadioButtonBox[Dynamic[$CellContext`x], {3}], "3"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"]}],
     Deployed->True],
    RadioButtonBar[
     Dynamic[$CellContext`x], {1, 2, 3}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{141, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80012987]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RadioButton", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "y", "]"}], ",", "s"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->985467983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RadioButtonBox[Dynamic[$CellContext`y], {1}], ",", 
     RadioButtonBox[Dynamic[$CellContext`y], {2}], ",", 
     RadioButtonBox[Dynamic[$CellContext`y], {3}]}], "}"}], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{130, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->370476420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10921258],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Setter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setter"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->750502910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Setter", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "x", "]"}], ",", "s"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197888666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SetterBox[Dynamic[$CellContext`x], {$CellContext`a}, "a"], ",", 
     SetterBox[Dynamic[$CellContext`x], {$CellContext`b}, "b"], ",", 
     SetterBox[Dynamic[$CellContext`x], {$CellContext`c}, "c"]}], "}"}], ",", 
   
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{112, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331093929]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RadioButton", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "y", "]"}], ",", "s"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11584262],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RadioButtonBox[Dynamic[$CellContext`y], {$CellContext`a}], ",", 
     RadioButtonBox[Dynamic[$CellContext`y], {$CellContext`b}], ",", 
     RadioButtonBox[Dynamic[$CellContext`y], {$CellContext`c}]}], "}"}], ",", 
   
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{130, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->347634637]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29030],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RadioButtonBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadioButtonBar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Setter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Checkbox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Checkbox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Toggler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Toggler"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16039]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29434],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->184522564],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->269971677],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->630280000]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RadioButton - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 40.0467972}", "context" -> "System`", 
    "keywords" -> {
     "radio button", "exactly one button", "select one button", 
      "multiple choice button", "single select button"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RadioButton[x, val] represents a radio button whose setting x is set to \
val when the button is clicked. RadioButton[x, val] is displayed as TagBox[ \
RadioButtonBox[0, {0}], EventHandlerTag[{ \"MouseDown\" -> Null, \
PassEventsDown -> Automatic, PassEventsUp -> True}]] when x is val, and as \
TagBox[ RadioButtonBox[1, {0}], EventHandlerTag[{ \"MouseDown\" -> Null, \
PassEventsDown -> Automatic, PassEventsUp -> True}]] otherwise. \
RadioButton[Dynamic[x], val] takes the setting to be the dynamically updated \
current value of x, with the value of x being reset if the button is clicked. \
", "synonyms" -> {"radio button"}, "title" -> "RadioButton", "type" -> 
    "Symbol", "uri" -> "ref/RadioButton"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9422, 297, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->47343456]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33221, 1184}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2465, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3088, 84, 1576, 37, 70, "ObjectNameGrid"],
Cell[4667, 123, 2365, 76, 70, "Usage",
 CellID->1302]
}, Open  ]],
Cell[CellGroupData[{
Cell[7069, 204, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7547, 221, 415, 15, 70, "Notes",
 CellID->3559],
Cell[7965, 238, 854, 31, 70, "Notes",
 CellID->1020],
Cell[8822, 271, 563, 21, 70, "Notes",
 CellID->16851]
}, Closed]],
Cell[CellGroupData[{
Cell[9422, 297, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->47343456],
Cell[CellGroupData[{
Cell[9806, 311, 148, 5, 70, "ExampleSection",
 CellID->818253885],
Cell[CellGroupData[{
Cell[9979, 320, 220, 7, 28, "Input",
 CellID->131990289],
Cell[10202, 329, 263, 9, 44, "Output",
 CellID->141051207]
}, Open  ]],
Cell[10480, 341, 153, 6, 70, "ExampleText",
 CellID->731368666],
Cell[CellGroupData[{
Cell[10658, 351, 362, 11, 28, "Input",
 CellID->123836227],
Cell[11023, 364, 389, 11, 44, "Output",
 CellID->133652230]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11461, 381, 222, 7, 70, "ExampleSection",
 CellID->514616474],
Cell[CellGroupData[{
Cell[11708, 392, 230, 7, 70, "ExampleSubsection",
 CellID->13416912],
Cell[11941, 401, 67, 1, 70, "ExampleText",
 CellID->1788243481],
Cell[CellGroupData[{
Cell[12033, 406, 389, 12, 70, "Input",
 CellID->294823549],
Cell[12425, 420, 436, 15, 70, "Output",
 CellID->292742180]
}, Open  ]],
Cell[12876, 438, 125, 3, 70, "ExampleDelimiter",
 CellID->974545402],
Cell[13004, 443, 77, 1, 70, "ExampleText",
 CellID->323346172],
Cell[CellGroupData[{
Cell[13106, 448, 457, 14, 70, "Input",
 CellID->206979933],
Cell[13566, 464, 584, 15, 70, "Output",
 CellID->182703903]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14199, 485, 230, 7, 70, "ExampleSubsection",
 CellID->48745542],
Cell[14432, 494, 112, 3, 70, "ExampleText",
 CellID->542841723],
Cell[CellGroupData[{
Cell[14569, 501, 470, 13, 70, "Input",
 CellID->493478890],
Cell[15042, 516, 433, 13, 70, "Output",
 CellID->492664761]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15524, 535, 231, 7, 70, "ExampleSubsection",
 CellID->763904683],
Cell[15758, 544, 68, 1, 70, "ExampleText",
 CellID->652399918],
Cell[CellGroupData[{
Cell[15851, 549, 347, 11, 70, "Input",
 CellID->326795745],
Cell[16201, 562, 490, 15, 70, "Output",
 CellID->153326513]
}, Open  ]],
Cell[16706, 580, 125, 3, 70, "ExampleDelimiter",
 CellID->266034590],
Cell[16834, 585, 82, 1, 70, "ExampleText",
 CellID->38915991],
Cell[CellGroupData[{
Cell[16941, 590, 501, 14, 70, "Input",
 CellID->478223244],
Cell[17445, 606, 407, 11, 70, "Output",
 CellID->39884914]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17901, 623, 237, 7, 70, "ExampleSubsection",
 CellID->106220695],
Cell[18141, 632, 71, 1, 70, "ExampleText",
 CellID->413800597],
Cell[CellGroupData[{
Cell[18237, 637, 417, 13, 70, "Input",
 CellID->1194584793],
Cell[18657, 652, 545, 17, 70, "Output",
 CellID->562000148]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19251, 675, 228, 7, 70, "ExampleSubsection",
 CellID->204399392],
Cell[19482, 684, 212, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[19719, 696, 129, 4, 70, "Input",
 CellID->94729581],
Cell[19851, 702, 192, 6, 70, "Output",
 CellID->483442590]
}, Open  ]],
Cell[20058, 711, 125, 3, 70, "ExampleDelimiter",
 CellID->488488182],
Cell[20186, 716, 375, 12, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[20586, 732, 180, 5, 70, "Input",
 CellID->247984633],
Cell[20769, 739, 210, 7, 70, "Output",
 CellID->113550742]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21028, 752, 233, 7, 70, "ExampleSubsection",
 CellID->577585289],
Cell[21264, 761, 220, 8, 70, "ExampleText",
 CellID->281981288],
Cell[CellGroupData[{
Cell[21509, 773, 363, 12, 70, "Input",
 CellID->903407930],
Cell[21875, 787, 594, 23, 70, "Output",
 CellID->867695220]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[22530, 817, 236, 7, 70, "ExampleSection",
 CellID->48599551],
Cell[22769, 826, 349, 12, 70, "ExampleText",
 CellID->469310745],
Cell[CellGroupData[{
Cell[23143, 842, 316, 10, 70, "Input",
 CellID->93453470],
Cell[23462, 854, 1720, 54, 70, "Output",
 CellID->80012987]
}, Open  ]],
Cell[CellGroupData[{
Cell[25219, 913, 435, 14, 70, "Input",
 CellID->985467983],
Cell[25657, 929, 490, 14, 70, "Output",
 CellID->370476420]
}, Open  ]],
Cell[26162, 946, 124, 3, 70, "ExampleDelimiter",
 CellID->10921258],
Cell[26289, 951, 326, 12, 70, "ExampleText",
 CellID->750502910],
Cell[CellGroupData[{
Cell[26640, 967, 430, 14, 70, "Input",
 CellID->197888666],
Cell[27073, 983, 533, 15, 70, "Output",
 CellID->331093929]
}, Open  ]],
Cell[CellGroupData[{
Cell[27643, 1003, 434, 14, 70, "Input",
 CellID->11584262],
Cell[28080, 1019, 533, 15, 70, "Output",
 CellID->347634637]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28674, 1041, 311, 9, 70, "SeeAlsoSection",
 CellID->29030],
Cell[28988, 1052, 1188, 44, 70, "SeeAlso",
 CellID->16039]
}, Open  ]],
Cell[CellGroupData[{
Cell[30213, 1101, 314, 9, 70, "TutorialsSection",
 CellID->29434],
Cell[30530, 1112, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[30692, 1117, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[30877, 1125, 319, 9, 70, "MoreAboutSection",
 CellID->184522564],
Cell[31199, 1136, 141, 3, 70, "MoreAbout",
 CellID->269971677],
Cell[31343, 1141, 172, 3, 70, "MoreAbout",
 CellID->630280000]
}, Open  ]],
Cell[31530, 1147, 27, 0, 70, "History"],
Cell[31560, 1149, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

