(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     95253,       2965]
NotebookOptionsPosition[     88017,       2725]
NotebookOutlinePosition[     89693,       2767]
CellTagsIndexPosition[     89607,       2762]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetterBar" :> Documentation`HelpLookup["paclet:ref/SetterBar"],
           "PopupMenu" :> Documentation`HelpLookup["paclet:ref/PopupMenu"], 
          "RadioButton" :> Documentation`HelpLookup["paclet:ref/RadioButton"],
           "CheckboxBar" :> 
          Documentation`HelpLookup["paclet:ref/CheckboxBar"], "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SetterBar\"\>", 
       2->"\<\"PopupMenu\"\>", 3->"\<\"RadioButton\"\>", 
       4->"\<\"CheckboxBar\"\>", 5->"\<\"Manipulate\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Creating Inspectors\"\>", 
       3->"\<\"User Interface Structuring & Layout\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RadioButtonBar", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RadioButtonBar",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RadioButtonBar"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a radio button bar with setting ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and with labeled radio buttons for values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RadioButtonBar",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RadioButtonBar"], "[", 
       RowBox[{
        RowBox[{
         ButtonBox["Dynamic",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Dynamic"], "[", 
         StyleBox["x", "TI"], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being reset every time a radio button is pressed."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RadioButtonBar",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RadioButtonBar"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["2", "TR"]], "->", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a radio button bar in which the radio button \
giving value ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is given label ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be strings, boxes, graphics or any other expressions, including \
dynamic expressions. "
}], "Notes",
 CellID->8400],

Cell["The following options can be given: ", "Notes",
 CellID->19514],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the radio button bar ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "background color to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the button bar ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the radio button bar is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LabelStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LabelStyle"], 
    RowBox[{"{", "}"}], Cell[
    "style specifications for the labels", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->15505],

Cell[TextData[{
 "Possible settings for the ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " option include:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->87074349]
}], "Notes",
 CellID->570291772],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Horizontal\>\"", Cell[
    "equally spaced horizontally", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Vertical\>\"", Cell[
    "equally spaced vertically", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Row\>\"", Cell[
    "laid out like text, allowing linewrapping", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->39473540],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " are appended to the default styles typically given by the ",
 Cell[BoxData["\"\<RadioButtonBar\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<RadioButtonBarLabel\>\""], "InlineFormula"],
 " styles in the current stylesheet. "
}], "Notes",
 CellID->55815475]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->135821236],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->381894114],

Cell["Use five possible settings: ", "ExampleText",
 CellID->476628454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RadioButtonBar", "[", 
  RowBox[{"2", ",", 
   RowBox[{"Range", "[", "5", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365756658],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = 2}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {1}], "1"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {2}], "2"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {3}], "3"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {4}], "4"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {5}], "5"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"]}],
      Deployed->True],
     RadioButtonBar[
      Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5}]],
    RadioButtonBar[BoxForm`var$$, {1, 2, 3, 4, 5}]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{184, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7727627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104828318],

Cell["Dynamically updated value: ", "ExampleText",
 CellID->196053014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RadioButtonBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Range", "[", "5", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113553072],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      TagBox[GridBox[{
         {
          RadioButtonBox[Dynamic[$CellContext`x], {1}], "1"}
        },
        ColumnsEqual->False,
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}},
        RowsEqual->False],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          RadioButtonBox[Dynamic[$CellContext`x], {2}], "2"}
        },
        ColumnsEqual->False,
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}},
        RowsEqual->False],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          RadioButtonBox[Dynamic[$CellContext`x], {3}], "3"}
        },
        ColumnsEqual->False,
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}},
        RowsEqual->False],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          RadioButtonBox[Dynamic[$CellContext`x], {4}], "4"}
        },
        ColumnsEqual->False,
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}},
        RowsEqual->False],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          RadioButtonBox[Dynamic[$CellContext`x], {5}], "5"}
        },
        ColumnsEqual->False,
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}},
        RowsEqual->False],
       "Grid"]}],
     Deployed->True],
    RadioButtonBar[
     Dynamic[$CellContext`x], {1, 2, 3, 4, 5}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{216, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38709148]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->49992502],

Cell["Label the values: ", "ExampleText",
 CellID->215089400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RadioButtonBar", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "\"\<Ein\>\""}], ",", 
     RowBox[{"2", "\[Rule]", "\"\<Zwei\>\""}], ",", 
     RowBox[{"3", "\[Rule]", "\"\<Drei\>\""}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->579787708],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = 1}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {1}], "\<\"Ein\"\>"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {2}], "\<\"Zwei\"\>"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {3}], "\<\"Drei\"\>"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"]}],
      Deployed->True],
     RadioButtonBar[
      Dynamic[BoxForm`var$$], {1 -> "Ein", 2 -> "Zwei", 3 -> "Drei"}]],
    RadioButtonBar[BoxForm`var$$, {1 -> "Ein", 2 -> "Zwei", 3 -> "Drei"}]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{165, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->869998425]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->391318237],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->555489394],

Cell["Alter the size:", "ExampleText",
 CellID->87074349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RadioButtonBar", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->836079617],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = $CellContext`x}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {1},
              Appearance->Tiny], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {2},
              Appearance->Tiny], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {3},
              Appearance->Tiny], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       RadioButtonBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> Tiny]],
      RadioButtonBar[BoxForm`var$$, {1, 2, 3}, Appearance -> Tiny]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = $CellContext`x}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {1},
              Appearance->Small], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {2},
              Appearance->Small], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {3},
              Appearance->Small], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       RadioButtonBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> Small]],
      RadioButtonBar[BoxForm`var$$, {1, 2, 3}, Appearance -> Small]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = $CellContext`x}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {1},
              Appearance->Medium], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {2},
              Appearance->Medium], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {3},
              Appearance->Medium], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       RadioButtonBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> Medium]],
      RadioButtonBar[BoxForm`var$$, {1, 2, 3}, Appearance -> Medium]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = $CellContext`x}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {1},
              Appearance->Large], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {2},
              Appearance->Large], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {3},
              Appearance->Large], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}],
        Deployed->True],
       RadioButtonBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> Large]],
      RadioButtonBar[BoxForm`var$$, {1, 2, 3}, Appearance -> Large]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{444, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->775593622]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->258946033],

Cell["Alter orientation:", "ExampleText",
 CellID->54445242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RadioButtonBar", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Horizontal\>\"", ",", "\"\<Vertical\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->556426647],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = $CellContext`x}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           TagBox[GridBox[{
              {
               RadioButtonBox[Dynamic[BoxForm`var$$], {1}], "1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            "Grid"], 
           TagBox[GridBox[{
              {
               RadioButtonBox[Dynamic[BoxForm`var$$], {2}], "2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            "Grid"], 
           TagBox[GridBox[{
              {
               RadioButtonBox[Dynamic[BoxForm`var$$], {3}], "3"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            "Grid"]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
        Deployed->True],
       RadioButtonBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> "Horizontal"]],
      RadioButtonBar[BoxForm`var$$, {1, 2, 3}, Appearance -> "Horizontal"]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = $CellContext`x}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           TagBox[GridBox[{
              {
               RadioButtonBox[Dynamic[BoxForm`var$$], {1}], "1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            "Grid"]},
          {
           TagBox[GridBox[{
              {
               RadioButtonBox[Dynamic[BoxForm`var$$], {2}], "2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            "Grid"]},
          {
           TagBox[GridBox[{
              {
               RadioButtonBox[Dynamic[BoxForm`var$$], {3}], "3"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            "Grid"]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
        Deployed->True],
       RadioButtonBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> "Vertical"]],
      RadioButtonBar[BoxForm`var$$, {1, 2, 3}, Appearance -> "Vertical"]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{158, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1212839]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->489330230],

Cell[TextData[{
 "Using ",
 Cell[BoxData["\"\<Row\>\""], "InlineFormula"],
 " will allow a ",
 Cell[BoxData[
  ButtonBox["RadioButtonBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButtonBar"]], "InlineFormula"],
 " to line break:"
}], "ExampleText",
 CellID->120138620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RadioButtonBar", "[", 
  RowBox[{"x", ",", 
   RowBox[{"Range", "[", "15", "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<Row\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69936339],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = $CellContext`x}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {1}], "1"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {2}], "2"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {3}], "3"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {4}], "4"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {5}], "5"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {6}], "6"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {7}], "7"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {8}], "8"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {9}], "9"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {10}], "10"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {11}], "11"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {12}], "12"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {13}], "13"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {14}], "14"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {15}], "15"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"]}],
      Deployed->True],
     RadioButtonBar[
      Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
      15}]],
    RadioButtonBar[
    BoxForm`var$$, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, 
     Appearance -> "Row"]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{343, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->613974505]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RadioButtonBar", "[", 
  RowBox[{"x", ",", 
   RowBox[{"Range", "[", "15", "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<Horizontal\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->123897460],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = $CellContext`x}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[GridBox[{
        {
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {1}], "1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {2}], "2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {3}], "3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {4}], "4"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {5}], "5"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {6}], "6"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {7}], "7"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {8}], "8"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {9}], "9"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {10}], "10"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {11}], "11"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {12}], "12"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {13}], "13"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {14}], "14"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {15}], "15"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}],
      Deployed->True],
     RadioButtonBar[
      Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
      15}, Appearance -> "Horizontal"]],
    RadioButtonBar[
    BoxForm`var$$, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, 
     Appearance -> "Horizontal"]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{548, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->35611358]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->797212026],

Cell[TextData[{
 "Change the background for the ",
 Cell[BoxData[
  ButtonBox["RadioButtonBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButtonBar"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->208462605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RadioButtonBar", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "Purple"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->616854573],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = RGBColor[1, 0.5, 0.5]}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {1},
            Background->RGBColor[0.5, 0, 0.5]], "1"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {2},
            Background->RGBColor[0.5, 0, 0.5]], "2"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {3},
            Background->RGBColor[0.5, 0, 0.5]], "3"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"]}],
      Deployed->True],
     RadioButtonBar[
      Dynamic[BoxForm`var$$], {1, 2, 3}, Background -> 
      RGBColor[0.5, 0, 0.5]]],
    RadioButtonBar[
    BoxForm`var$$, {1, 2, 3}, Background -> RGBColor[0.5, 0, 0.5]]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{109, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->598956562]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32347561],

Cell["Change the background color dynamically:", "ExampleText",
 CellID->88991824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RadioButtonBar", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Pink", "\[Rule]", "\"\<Pink\>\""}], ",", 
     RowBox[{"Gray", "\[Rule]", "\"\<Gray\>\""}], ",", 
     RowBox[{"Yellow", "\[Rule]", "\"\<Yellow\>\""}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Dynamic", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70412404],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    TagBox[GridBox[{
       {
        RadioButtonBox[Dynamic[$CellContext`x], {RGBColor[1, 0.5, 0.5]},
         Background->Dynamic[$CellContext`x]], "\<\"Pink\"\>"}
      },
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     "Grid"], "  ", 
    TagBox[GridBox[{
       {
        RadioButtonBox[Dynamic[$CellContext`x], {GrayLevel[0.5]},
         Background->Dynamic[$CellContext`x]], "\<\"Gray\"\>"}
      },
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     "Grid"], "  ", 
    TagBox[GridBox[{
       {
        RadioButtonBox[Dynamic[$CellContext`x], {RGBColor[1, 1, 0]},
         Background->Dynamic[$CellContext`x]], "\<\"Yellow\"\>"}
      },
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     "Grid"]}],
   Deployed->True],
  RadioButtonBar[
   Dynamic[$CellContext`x], {
   RGBColor[1, 0.5, 0.5] -> "Pink", GrayLevel[0.5] -> "Gray", 
    RGBColor[1, 1, 0] -> "Yellow"}, Background -> 
   Dynamic[$CellContext`x]]]], "Output",
 ImageSize->{186, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39825688]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->174249557],

Cell["Align the labels with surrounding text:", "ExampleText",
 CellID->348384025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RadioButtonBar", "[", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "b"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Bottom", ",", "Center", ",", "Top"}], 
        "}"}]}], "}"}]}], "]"}], ",", "\"\< xxx \>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86668818],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = 1}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {1},
              BaselinePosition->Automatic], "1"}
           },
           ColumnsEqual->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}},
           RowsEqual->False],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {2},
              BaselinePosition->Automatic], "2"}
           },
           ColumnsEqual->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}},
           RowsEqual->False],
          "Grid"]}],
        Deployed->True],
       RadioButtonBar[
        Dynamic[BoxForm`var$$], {1, 2}, BaselinePosition -> Automatic]],
      RadioButtonBar[BoxForm`var$$, {1, 2}, BaselinePosition -> Automatic]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], " ", "xxx", " ", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = 1}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {1},
              BaselinePosition->Bottom], "1"}
           },
           ColumnsEqual->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}},
           RowsEqual->False],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {2},
              BaselinePosition->Bottom], "2"}
           },
           ColumnsEqual->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}},
           RowsEqual->False],
          "Grid"]}],
        Deployed->True],
       RadioButtonBar[
        Dynamic[BoxForm`var$$], {1, 2}, BaselinePosition -> Bottom]],
      RadioButtonBar[BoxForm`var$$, {1, 2}, BaselinePosition -> Bottom]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], " ", "xxx", " ", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = 1}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {1},
              BaselinePosition->Center], "1"}
           },
           ColumnsEqual->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}},
           RowsEqual->False],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {2},
              BaselinePosition->Center], "2"}
           },
           ColumnsEqual->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}},
           RowsEqual->False],
          "Grid"]}],
        Deployed->True],
       RadioButtonBar[
        Dynamic[BoxForm`var$$], {1, 2}, BaselinePosition -> Center]],
      RadioButtonBar[BoxForm`var$$, {1, 2}, BaselinePosition -> Center]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], " ", "xxx", " ", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = 1}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[
        RowBox[{
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {1},
              BaselinePosition->Top], "1"}
           },
           ColumnsEqual->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}},
           RowsEqual->False],
          "Grid"], "  ", 
         TagBox[GridBox[{
            {
             RadioButtonBox[Dynamic[BoxForm`var$$], {2},
              BaselinePosition->Top], "2"}
           },
           ColumnsEqual->False,
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}},
           RowsEqual->False],
          "Grid"]}],
        Deployed->True],
       RadioButtonBar[
        Dynamic[BoxForm`var$$], {1, 2}, BaselinePosition -> Top]],
      RadioButtonBar[BoxForm`var$$, {1, 2}, BaselinePosition -> Top]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}],
  Row[{
    RadioButtonBar[1, {1, 2}, BaselinePosition -> Automatic], 
    RadioButtonBar[1, {1, 2}, BaselinePosition -> Bottom], 
    RadioButtonBar[1, {1, 2}, BaselinePosition -> Center], 
    RadioButtonBar[1, {1, 2}, BaselinePosition -> Top]}, " xxx "]]], "Output",\

 ImageSize->{351, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1522193247]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->180789041],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["RadioButtonBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButtonBar"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->131444758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RadioButtonBar", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"Enabled", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = 1}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {1},
            Enabled->True], "1"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {2},
            Enabled->True], "2"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {3},
            Enabled->True], "3"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        "Grid"]}],
      Deployed->True],
     RadioButtonBar[
      Dynamic[BoxForm`var$$], {1, 2, 3}, Enabled -> True]],
    RadioButtonBar[BoxForm`var$$, {1, 2, 3}, Enabled -> True]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{109, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21236543]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58378546],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], " ", "\[Rule]", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the bar is disabled but visible in its current state:"
}], "ExampleText",
 CellID->160127829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RadioButtonBar", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227336428],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = 1}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {1},
            Enabled->False], "1"}
         },
         ColumnsEqual->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}},
         RowsEqual->False],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {2},
            Enabled->False], "2"}
         },
         ColumnsEqual->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}},
         RowsEqual->False],
        "Grid"], "  ", 
       TagBox[GridBox[{
          {
           RadioButtonBox[Dynamic[BoxForm`var$$], {3},
            Enabled->False], "3"}
         },
         ColumnsEqual->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}},
         RowsEqual->False],
        "Grid"]}],
      Deployed->True],
     RadioButtonBar[
      Dynamic[BoxForm`var$$], {1, 2, 3}, Enabled -> False]],
    RadioButtonBar[BoxForm`var$$, {1, 2, 3}, Enabled -> False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{109, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->529215618]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->102518576],

Cell["A dynamically updated task list:", "ExampleText",
 CellID->328543182],

Cell[BoxData[
 RowBox[{
  RowBox[{"vlabs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{"Blue", ",", ".8"}], "]"}], "->", "\"\<0%\>\""}], ",", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{"Blue", ",", ".4"}], "]"}], "->", "\"\<50%\>\""}], ",", 
     RowBox[{"Green", "->", "\"\<100%\>\""}], ",", 
     RowBox[{"Pink", "->", "\"\<Overdue\>\""}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91881970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Task-1\>\"", ",", 
       RowBox[{"RadioButtonBar", "[", 
        RowBox[{
         RowBox[{"Dynamic", "[", "t1", "]"}], ",", "vlabs"}], "]"}]}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<Task-2\>\"", ",", 
       RowBox[{"RadioButtonBar", "[", 
        RowBox[{
         RowBox[{"Dynamic", "[", "t2", "]"}], ",", "vlabs"}], "]"}]}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<Task-3\>\"", ",", " ", 
       RowBox[{"RadioButtonBar", "[", 
        RowBox[{
         RowBox[{"Dynamic", "[", "t3", "]"}], ",", "vlabs"}], "]"}]}], 
      "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", 
         RowBox[{"Dynamic", "[", "t1", "]"}]}], ",", 
        RowBox[{"2", "\[Rule]", 
         RowBox[{"Dynamic", "[", "t2", "]"}]}], ",", 
        RowBox[{"3", "\[Rule]", 
         RowBox[{"Dynamic", "[", "t3", "]"}]}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->164899025],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Task-1\"\>", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        TagBox[GridBox[{
           {
            
            RadioButtonBox[Dynamic[$CellContext`t1], {RGBColor[
             0.8, 0.8, 1.]}], "\<\"0%\"\>"}
          },
          ColumnsEqual->False,
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}},
          RowsEqual->False],
         "Grid"], "  ", 
        TagBox[GridBox[{
           {
            
            RadioButtonBox[Dynamic[$CellContext`t1], {RGBColor[
             0.4, 0.4, 1.]}], "\<\"50%\"\>"}
          },
          ColumnsEqual->False,
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}},
          RowsEqual->False],
         "Grid"], "  ", 
        TagBox[GridBox[{
           {
            
            RadioButtonBox[Dynamic[$CellContext`t1], {RGBColor[
             0, 1, 0]}], "\<\"100%\"\>"}
          },
          ColumnsEqual->False,
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}},
          RowsEqual->False],
         "Grid"], "  ", 
        TagBox[GridBox[{
           {
            
            RadioButtonBox[Dynamic[$CellContext`t1], {RGBColor[
             1, 0.5, 0.5]}], "\<\"Overdue\"\>"}
          },
          ColumnsEqual->False,
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}},
          RowsEqual->False],
         "Grid"]}],
       Deployed->True],
      RadioButtonBar[
       Dynamic[$CellContext`t1], {
       RGBColor[0.8, 0.8, 1.] -> "0%", RGBColor[0.4, 0.4, 1.] -> "50%", 
        RGBColor[0, 1, 0] -> "100%", RGBColor[1, 0.5, 0.5] -> "Overdue"}]]},
    {"\<\"Task-2\"\>", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        TagBox[GridBox[{
           {
            
            RadioButtonBox[Dynamic[$CellContext`t2], {RGBColor[
             0.8, 0.8, 1.]}], "\<\"0%\"\>"}
          },
          ColumnsEqual->False,
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}},
          RowsEqual->False],
         "Grid"], "  ", 
        TagBox[GridBox[{
           {
            
            RadioButtonBox[Dynamic[$CellContext`t2], {RGBColor[
             0.4, 0.4, 1.]}], "\<\"50%\"\>"}
          },
          ColumnsEqual->False,
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}},
          RowsEqual->False],
         "Grid"], "  ", 
        TagBox[GridBox[{
           {
            
            RadioButtonBox[Dynamic[$CellContext`t2], {RGBColor[
             0, 1, 0]}], "\<\"100%\"\>"}
          },
          ColumnsEqual->False,
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}},
          RowsEqual->False],
         "Grid"], "  ", 
        TagBox[GridBox[{
           {
            
            RadioButtonBox[Dynamic[$CellContext`t2], {RGBColor[
             1, 0.5, 0.5]}], "\<\"Overdue\"\>"}
          },
          ColumnsEqual->False,
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}},
          RowsEqual->False],
         "Grid"]}],
       Deployed->True],
      RadioButtonBar[
       Dynamic[$CellContext`t2], {
       RGBColor[0.8, 0.8, 1.] -> "0%", RGBColor[0.4, 0.4, 1.] -> "50%", 
        RGBColor[0, 1, 0] -> "100%", RGBColor[1, 0.5, 0.5] -> "Overdue"}]]},
    {"\<\"Task-3\"\>", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        TagBox[GridBox[{
           {
            
            RadioButtonBox[Dynamic[$CellContext`t3], {RGBColor[
             0.8, 0.8, 1.]}], "\<\"0%\"\>"}
          },
          ColumnsEqual->False,
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}},
          RowsEqual->False],
         "Grid"], "  ", 
        TagBox[GridBox[{
           {
            
            RadioButtonBox[Dynamic[$CellContext`t3], {RGBColor[
             0.4, 0.4, 1.]}], "\<\"50%\"\>"}
          },
          ColumnsEqual->False,
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}},
          RowsEqual->False],
         "Grid"], "  ", 
        TagBox[GridBox[{
           {
            
            RadioButtonBox[Dynamic[$CellContext`t3], {RGBColor[
             0, 1, 0]}], "\<\"100%\"\>"}
          },
          ColumnsEqual->False,
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}},
          RowsEqual->False],
         "Grid"], "  ", 
        TagBox[GridBox[{
           {
            
            RadioButtonBox[Dynamic[$CellContext`t3], {RGBColor[
             1, 0.5, 0.5]}], "\<\"Overdue\"\>"}
          },
          ColumnsEqual->False,
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}},
          RowsEqual->False],
         "Grid"]}],
       Deployed->True],
      RadioButtonBar[
       Dynamic[$CellContext`t3], {
       RGBColor[0.8, 0.8, 1.] -> "0%", RGBColor[0.4, 0.4, 1.] -> "50%", 
        RGBColor[0, 1, 0] -> "100%", RGBColor[1, 0.5, 0.5] -> "Overdue"}]]}
   },
   ColumnsEqual->False,
   GridBoxBackground->{"Columns" -> Dynamic[
       GridDump`Restructure[
       Background, {
        None, {1 -> Dynamic[$CellContext`t1], 2 -> Dynamic[$CellContext`t2], 
          3 -> Dynamic[$CellContext`t3]}}, "Columns"]], "ColumnsIndexed" -> 
     Dynamic[
       GridDump`Restructure[
       Background, {
        None, {1 -> Dynamic[$CellContext`t1], 2 -> Dynamic[$CellContext`t2], 
          3 -> Dynamic[$CellContext`t3]}}, "ColumnsIndexed"]], "Rows" -> 
     Dynamic[
       GridDump`Restructure[
       Background, {
        None, {1 -> Dynamic[$CellContext`t1], 2 -> Dynamic[$CellContext`t2], 
          3 -> Dynamic[$CellContext`t3]}}, "Rows"]], "RowsIndexed" -> 
     Dynamic[
       GridDump`Restructure[
       Background, {
        None, {1 -> Dynamic[$CellContext`t1], 2 -> Dynamic[$CellContext`t2], 
          3 -> Dynamic[$CellContext`t3]}}, "RowsIndexed"]], "ItemsIndexed" -> 
     Dynamic[
       GridDump`Restructure[
       Background, {
        None, {1 -> Dynamic[$CellContext`t1], 2 -> Dynamic[$CellContext`t2], 
          3 -> Dynamic[$CellContext`t3]}}, "ItemsIndexed"]]},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{291, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1797109499]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetterBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetterBar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupMenu"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RadioButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadioButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CheckboxBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CheckboxBar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->461211314],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->309970950],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->56593009],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->95101282]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RadioButtonBar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 38.5936350}", "context" -> "System`", 
    "keywords" -> {"single selection control"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RadioButtonBar[x, {val_1, val_2, ...}] represents a radio button bar \
with setting x and with labeled radio buttons for values val_i. \
RadioButtonBar[Dynamic[x], {val_1, val_2, ...}] takes the setting to be the \
dynamically updated current value of x, with the value of x being reset every \
time a radio button is pressed. RadioButtonBar[x, {val_1 -> lbl_1, val_2 -> \
lbl_2, ...}] represents a radio button bar in which the radio button giving \
value val_i is given label lbl_i.", "synonyms" -> {"radio button bar"}, 
    "title" -> "RadioButtonBar", "type" -> "Symbol", "uri" -> 
    "ref/RadioButtonBar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12657, 375, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->135821236]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 89463, 2755}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2654, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3277, 88, 1579, 37, 70, "ObjectNameGrid"],
Cell[4859, 127, 3234, 101, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[8130, 233, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8608, 250, 362, 14, 70, "Notes",
 CellID->8400],
Cell[8973, 266, 69, 1, 70, "Notes",
 CellID->19514],
Cell[9045, 269, 2081, 54, 70, "3ColumnTableMod",
 CellID->15505],
Cell[11129, 325, 308, 11, 70, "Notes",
 CellID->570291772],
Cell[11440, 338, 618, 13, 70, "2ColumnTableMod",
 CellID->39473540],
Cell[12061, 353, 559, 17, 70, "Notes",
 CellID->55815475]
}, Closed]],
Cell[CellGroupData[{
Cell[12657, 375, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->135821236],
Cell[CellGroupData[{
Cell[13042, 389, 148, 5, 70, "ExampleSection",
 CellID->381894114],
Cell[13193, 396, 71, 1, 70, "ExampleText",
 CellID->476628454],
Cell[CellGroupData[{
Cell[13289, 401, 166, 5, 28, "Input",
 CellID->365756658],
Cell[13458, 408, 2705, 82, 41, "Output",
 CellID->7727627]
}, Open  ]],
Cell[16178, 493, 125, 3, 70, "ExampleDelimiter",
 CellID->104828318],
Cell[16306, 498, 70, 1, 70, "ExampleText",
 CellID->196053014],
Cell[CellGroupData[{
Cell[16401, 503, 289, 9, 70, "Input",
 CellID->113553072],
Cell[16693, 514, 3321, 100, 70, "Output",
 CellID->38709148]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20063, 620, 219, 7, 70, "ExampleSection",
 CellID->49992502],
Cell[20285, 629, 61, 1, 70, "ExampleText",
 CellID->215089400],
Cell[CellGroupData[{
Cell[20371, 634, 320, 9, 70, "Input",
 CellID->579787708],
Cell[20694, 645, 1891, 56, 70, "Output",
 CellID->869998425]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22634, 707, 222, 7, 70, "ExampleSection",
 CellID->391318237],
Cell[CellGroupData[{
Cell[22881, 718, 231, 7, 70, "ExampleSubsection",
 CellID->555489394],
Cell[23115, 727, 57, 1, 70, "ExampleText",
 CellID->87074349],
Cell[CellGroupData[{
Cell[23197, 732, 448, 14, 70, "Input",
 CellID->836079617],
Cell[23648, 748, 7816, 223, 70, "Output",
 CellID->775593622]
}, Open  ]],
Cell[31479, 974, 125, 3, 70, "ExampleDelimiter",
 CellID->258946033],
Cell[31607, 979, 60, 1, 70, "ExampleText",
 CellID->54445242],
Cell[CellGroupData[{
Cell[31692, 984, 444, 14, 70, "Input",
 CellID->556426647],
Cell[32139, 1000, 4298, 119, 70, "Output",
 CellID->1212839]
}, Open  ]],
Cell[36452, 1122, 125, 3, 70, "ExampleDelimiter",
 CellID->489330230],
Cell[36580, 1127, 282, 10, 70, "ExampleText",
 CellID->120138620],
Cell[CellGroupData[{
Cell[36887, 1141, 225, 6, 70, "Input",
 CellID->69936339],
Cell[37115, 1149, 7313, 215, 70, "Output",
 CellID->613974505]
}, Open  ]],
Cell[CellGroupData[{
Cell[44465, 1369, 235, 7, 70, "Input",
 CellID->123897460],
Cell[44703, 1378, 7804, 219, 70, "Output",
 CellID->35611358]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[52556, 1603, 231, 7, 70, "ExampleSubsection",
 CellID->797212026],
Cell[52790, 1612, 225, 8, 70, "ExampleText",
 CellID->208462605],
Cell[CellGroupData[{
Cell[53040, 1624, 246, 7, 70, "Input",
 CellID->616854573],
Cell[53289, 1633, 2048, 61, 70, "Output",
 CellID->598956562]
}, Open  ]],
Cell[55352, 1697, 124, 3, 70, "ExampleDelimiter",
 CellID->32347561],
Cell[55479, 1702, 82, 1, 70, "ExampleText",
 CellID->88991824],
Cell[CellGroupData[{
Cell[55586, 1707, 453, 12, 70, "Input",
 CellID->70412404],
Cell[56042, 1721, 1827, 53, 70, "Output",
 CellID->39825688]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[57918, 1780, 237, 7, 70, "ExampleSubsection",
 CellID->174249557],
Cell[58158, 1789, 82, 1, 70, "ExampleText",
 CellID->348384025],
Cell[CellGroupData[{
Cell[58265, 1794, 537, 16, 70, "Input",
 CellID->86668818],
Cell[58805, 1812, 7476, 213, 70, "Output",
 CellID->1522193247]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66330, 2031, 228, 7, 70, "ExampleSubsection",
 CellID->180789041],
Cell[66561, 2040, 218, 8, 70, "ExampleText",
 CellID->131444758],
Cell[CellGroupData[{
Cell[66804, 2052, 240, 7, 70, "Input",
 CellID->94729581],
Cell[67047, 2061, 1915, 59, 70, "Output",
 CellID->21236543]
}, Open  ]],
Cell[68977, 2123, 124, 3, 70, "ExampleDelimiter",
 CellID->58378546],
Cell[69104, 2128, 366, 12, 70, "ExampleText",
 CellID->160127829],
Cell[CellGroupData[{
Cell[69495, 2144, 242, 7, 70, "Input",
 CellID->227336428],
Cell[69740, 2153, 2368, 71, 70, "Output",
 CellID->529215618]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[72169, 2231, 227, 7, 70, "ExampleSection",
 CellID->102518576],
Cell[72399, 2240, 75, 1, 70, "ExampleText",
 CellID->328543182],
Cell[72477, 2243, 481, 14, 70, "Input",
 CellID->91881970],
Cell[CellGroupData[{
Cell[72983, 2261, 1271, 36, 70, "Input",
 CellID->164899025],
Cell[74257, 2299, 10597, 304, 70, "Output",
 CellID->1797109499]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84915, 2610, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[85234, 2621, 1210, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[86481, 2670, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[86802, 2681, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[86964, 2686, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[87149, 2694, 319, 9, 70, "MoreAboutSection",
 CellID->461211314],
Cell[87471, 2705, 141, 3, 70, "MoreAbout",
 CellID->309970950],
Cell[87615, 2710, 148, 3, 70, "MoreAbout",
 CellID->56593009],
Cell[87766, 2715, 179, 3, 70, "MoreAbout",
 CellID->95101282]
}, Open  ]],
Cell[87960, 2721, 27, 0, 70, "History"],
Cell[87990, 2723, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

