(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12925,        448]
NotebookOptionsPosition[     10209,        368]
NotebookOutlinePosition[     11650,        402]
CellTagsIndexPosition[     11607,        399]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["OBSOLETE MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Pseudorandom Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/PseudorandomNumbers"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Pseudorandom Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BlockRandom" :> 
          Documentation`HelpLookup["paclet:ref/BlockRandom"], "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BlockRandom\"\>", 
       2->"\<\"FindInstance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Random", "ObjectName",
 CellID->602],

Cell[TextData[{
 "As of Version 6.0, ",
 Cell[BoxData["Random"], "InlineFormula"],
 " has been superseded by the functions ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 "."
}], "ObsolescenceNote",
 CellID->28607],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Random", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a uniformly distributed pseudorandom ",
     Cell[BoxData[
      ButtonBox["Real",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Real"]], "InlineFormula"],
     " in the range 0 to 1. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Random", "[", 
       RowBox[{
        StyleBox["type", "TI"], ",", 
        StyleBox["range", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a pseudorandom number of the specified type, \
lying in the specified range. Possible types are: ",
     Cell[BoxData[
      ButtonBox["Integer",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Real",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Real"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Complex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
     ". The default range is 0 to 1. You can give the range ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["min", "TI"], ",", 
        StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
     " explicitly; a range specification of ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     " is equivalent to ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{"0", ",", 
        StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23638]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Random", "[", 
   ButtonBox["Integer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integer"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData["0"], "InlineFormula"],
 " or ",
 Cell[BoxData["1"], "InlineFormula"],
 " with probability ",
 Cell[BoxData[
  FractionBox["1", "2"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24237],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Random", "[", 
   ButtonBox["Complex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complex"], "]"}]], "InlineFormula"],
 " gives a pseudorandom complex number in the rectangle with corners ",
 Cell[BoxData["0"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"1", "+", 
   StyleBox["i", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3076],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Random", "[", 
   RowBox[{
    ButtonBox["Complex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complex"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " uses the rectangle defined by ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["z", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["z", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->215],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Random", "[", 
   RowBox[{
    ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"], ",", 
    StyleBox["range", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " generates a pseudorandom real number with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]digit precision. Both leading and trailing digits may be chosen as \
0. "
}], "Notes",
 CellID->7691],

Cell[TextData[{
 Cell[BoxData["Random"], "InlineFormula"],
 " gives a different sequence of pseudorandom numbers whenever you run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can start ",
 Cell[BoxData["Random"], "InlineFormula"],
 " with a particular seed using ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15579]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28655],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlockRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlockRandom",
    ButtonNote->"ObsLink: $RandomState -> BlockRandom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16031]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->212],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->2206],

Cell[TextData[ButtonBox["Pseudorandom Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PseudorandomNumbers"]], "Tutorials",
 CellID->5965]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->21900],

Cell[TextData[{
 ButtonBox["Demonstrations with Random",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Random"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#5107"], None}]], "RelatedLinks",
 CellID->1692],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Random"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Random - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 50.5783168}", "context" -> "System`", 
    "keywords" -> {
     "cellular automata", "Marsaglia-Zaman generator", "numbers", 
      "pseudorandom numbers", "rule 30", "side effects", "Wolfram's method"}, 
    "index" -> True, "label" -> "Obsolete Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "ObsoleteFlag", "summary" -> 
    "Random[] gives a uniformly distributed pseudorandom Real in the range 0 \
to 1. Random[type, range] gives a pseudorandom number of the specified type, \
lying in the specified range. Possible types are: Integer, Real and Complex. \
The default range is 0 to 1. You can give the range {min, max} explicitly; a \
range specification of max is equivalent to {0, max}. ", "synonyms" -> {}, 
    "title" -> "Random", "type" -> "Symbol", "uri" -> "ref/Random"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1467, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2090, 63, 42, 1, 70, "ObjectName",
 CellID->602],
Cell[2135, 66, 432, 15, 70, "ObsolescenceNote",
 CellID->28607],
Cell[2570, 83, 1762, 54, 70, "Usage",
 CellID->23638]
}, Open  ]],
Cell[CellGroupData[{
Cell[4369, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4847, 159, 382, 15, 70, "Notes",
 CellID->24237],
Cell[5232, 176, 403, 14, 70, "Notes",
 CellID->3076],
Cell[5638, 192, 681, 27, 70, "Notes",
 CellID->215],
Cell[6322, 221, 463, 15, 70, "Notes",
 CellID->7691],
Cell[6788, 238, 438, 14, 70, "Notes",
 CellID->15579]
}, Closed]],
Cell[CellGroupData[{
Cell[7263, 257, 311, 9, 70, "SeeAlsoSection",
 CellID->28655],
Cell[7577, 268, 521, 18, 70, "SeeAlso",
 CellID->16031]
}, Open  ]],
Cell[CellGroupData[{
Cell[8135, 291, 312, 9, 70, "TutorialsSection",
 CellID->212],
Cell[8450, 302, 162, 3, 70, "Tutorials",
 CellID->2206],
Cell[8615, 307, 149, 3, 70, "Tutorials",
 CellID->5965]
}, Open  ]],
Cell[CellGroupData[{
Cell[8801, 315, 321, 9, 70, "RelatedLinksSection",
 CellID->21900],
Cell[9125, 326, 357, 12, 70, "RelatedLinks"],
Cell[9485, 340, 265, 6, 70, "RelatedLinks",
 CellID->1692],
Cell[9753, 348, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[10152, 364, 27, 0, 70, "History"],
Cell[10182, 366, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

