(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54155,       1662]
NotebookOptionsPosition[     46208,       1391]
NotebookOutlinePosition[     47929,       1433]
CellTagsIndexPosition[     47843,       1428]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pseudorandom Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/PseudorandomNumbers"], 
          "Random Number Generation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RandomNumberGeneration"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Pseudorandom Numbers\"\>", 
       2->"\<\"Random Number Generation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RandomReal" :> 
          Documentation`HelpLookup["paclet:ref/RandomReal"], "RandomChoice" :> 
          Documentation`HelpLookup["paclet:ref/RandomChoice"], "SeedRandom" :> 
          Documentation`HelpLookup["paclet:ref/SeedRandom"], "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RandomReal\"\>", 
       2->"\<\"RandomChoice\"\>", 3->"\<\"SeedRandom\"\>", 
       4->"\<\"FindInstance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Functions of Complex Variables" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsOfComplexVariables"], 
          "Random Number Generation" :> 
          Documentation`HelpLookup["paclet:guide/RandomNumberGeneration"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Complex Numbers\"\>", 
       2->"\<\"Functions of Complex Variables\"\>", 
       3->"\<\"Random Number Generation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RandomComplex", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomComplex",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomComplex"], "[", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]gives a pseudorandom complex number with real and \
imaginary parts in the range 0 to 1."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"RandomComplex", "[", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], "]"}], TraditionalForm]], 
      "InlineFormula"],
     "\[LineSeparator]gives a pseudorandom complex number in the rectangle \
with corners given by the complex numbers ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomComplex",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomComplex"], "[", 
       SubscriptBox[
        StyleBox["z", "TI"], 
        StyleBox["max", "TI"]], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a pseudorandom complex number in the rectangle \
whose corners are the origin and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomComplex",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomComplex"], "[", 
       RowBox[{
        StyleBox["range", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " pseudorandom complex numbers."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomComplex",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomComplex"], "[", 
       RowBox[{
        StyleBox["range", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Cross]", 
        SubscriptBox["n", "2"], "\[Cross]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " array of pseudorandom complex numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " chooses complex numbers with a uniform probability distribution in the \
rectangle specified."
}], "Notes",
 CellID->28455],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomComplex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomComplex"], "[", 
   RowBox[{
    StyleBox["range", "TI"], ",", 
    RowBox[{
     ButtonBox["WorkingPrecision",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WorkingPrecision"], "->", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " yields complex numbers with ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "-digit precision. Leading or trailing digits in the generated number can \
turn out to be 0. "
}], "Notes",
 CellID->17254],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " gives a different sequence of pseudorandom reals whenever you run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can start with a particular seed using ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11251],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option to ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " can be given to specify the pseudorandom generator used. "
}], "Notes",
 CellID->17887]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41459331],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->178366848],

Cell["\<\
A random complex number with real and imaginary parts in the range 0 to 1:\
\>", "ExampleText",
 CellID->15225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6453],

Cell[BoxData[
 RowBox[{"0.10721860968448493`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.009811134990945769`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99934272]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8198],

Cell[TextData[{
 "A random complex number in the rectangle with corners at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "2"}], "-", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"5", "+", 
    RowBox[{"3", " ", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->21916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "-", "I"}], ",", 
    RowBox[{"5", "+", 
     RowBox[{"3", "I"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31563],

Cell[BoxData[
 RowBox[{"4.452536105310011`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.9334616578137913`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->772707590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12419],

Cell[TextData[{
 "A random complex number in the rectangle with corners at ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"10", "+", 
    RowBox[{"5", " ", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->26742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", 
  RowBox[{"10", "+", 
   RowBox[{"5", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5124],

Cell[BoxData[
 RowBox[{"9.23589158056135`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.3160127782441502`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1019119708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30422],

Cell["5 random complex numbers in the unit square:", "ExampleText",
 CellID->28830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", 
  RowBox[{
   RowBox[{"1", "+", "I"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31854],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.20302733525113714`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.23134498321765817`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.007899166432872695`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.04108699553263251`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.3237340841041261`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9182737614716574`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6908686536633979`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.5399503770126446`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.7018278024804174`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.3524093925842291`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{441, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328299498]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7979],

Cell[TextData[{
 "A 3\[Times]2 array of random complex numbers in the rectangle with corners \
at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "+", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"10", "+", 
    RowBox[{"20", " ", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->6556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "I"}], ",", 
     RowBox[{"10", "+", 
      RowBox[{"20", "I"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25021],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2.762755115867124`", "\[InvisibleSpace]", "+", 
      RowBox[{"11.096595853263011`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"4.8463390321832325`", "\[InvisibleSpace]", "+", 
      RowBox[{"2.4224171675445536`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4.291149930897413`", "\[InvisibleSpace]", "+", 
      RowBox[{"14.397673176735871`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"7.654854296520835`", "\[InvisibleSpace]", "+", 
      RowBox[{"8.691798886066195`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4.209396940704595`", "\[InvisibleSpace]", "+", 
      RowBox[{"6.48318836119127`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"9.41025028791135`", "\[InvisibleSpace]", "+", 
      RowBox[{"18.72088561411747`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{553, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->490429150]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Generate random complex numbers of any magnitude:", "ExampleText",
 CellID->2013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", 
  RowBox[{
   RowBox[{"10", "^", "1000"}], "+", 
   RowBox[{
    RowBox[{"10", "^", "1000"}], "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9370],

Cell[BoxData[
 RowBox[{"6.66495474131294507458278531`15.954589770190987*^999", "+", 
  RowBox[{
  "7.64257487692132864154359594`15.954589770191005*^999", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{348, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->899473139]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16373],

Cell["Generate random complex numbers of any precision:", "ExampleText",
 CellID->10536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", 
  RowBox[{"WorkingPrecision", "->", "30"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21450],

Cell[BoxData[
 RowBox[{"0.047195105106004125476700281471656607834868440961`30.", "+", 
  RowBox[{
  "0.254406434749635775134893047765976195610433292176`30.", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22383187]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"10", "^", "1000"}], "+", 
    RowBox[{
     RowBox[{"10", "^", "1000"}], "I"}]}], ",", 
   RowBox[{"WorkingPrecision", "->", "50"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10625],

Cell[BoxData[
 RowBox[{"7.4862737148896457655592531663247010859561396965094187456532611279`\
50.*^999", "+", 
  RowBox[{
  "8.598686789795105129105244052479938331876330205172707579734878954`50.*^\
998", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{420, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->174776252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18076],

Cell["Generate low-precision complex numbers:", "ExampleText",
 CellID->5808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", "I"}], ",", 
     RowBox[{"1", "+", "I"}]}], "}"}], ",", "5", ",", 
   RowBox[{"WorkingPrecision", "->", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29727],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.249542236328125`5.", "-", 
    RowBox[{"0.227020263671875`5.", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.863037109375`5.000000000000002", "-", 
    RowBox[{"0.8470916748046875`5.000000000000002", " ", "\[ImaginaryI]"}]}], 
   ",", 
   RowBox[{
    RowBox[{"-", "0.066436767578125`5.000000000000002"}], "+", 
    RowBox[{"0.8537750244140625`5.000000000000002", " ", "\[ImaginaryI]"}]}], 
   ",", 
   RowBox[{"0.7903289794921875`5.000000000000002", "-", 
    RowBox[{"0.1910552978515625`4.999999999999999", " ", "\[ImaginaryI]"}]}], 
   ",", 
   RowBox[{"0.5172271728515625`5.", "+", 
    RowBox[{
    "0.2948455810546875`4.999999999999999", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{420, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24649821]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->98200206],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->14962614],

Cell["Generate a random complex number with 50-digit precision:", \
"ExampleText",
 CellID->6981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", 
  RowBox[{"WorkingPrecision", "->", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30209],

Cell[BoxData[
 RowBox[{"0.\
3888768606187058511073898866004836406152769217916763995580407905367`50.", "+",
   
  RowBox[{
  "0.9244180152482280110482868445154873675586257090922789551414854401725`50.",
    " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{386, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->424119802]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomComplex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", "I"}], ",", 
     RowBox[{"1", "+", "I"}]}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "->", "50"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23731],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "0.9954046644323688403946750221853157090316499039608093712326252808172`\
50."}], "+", 
  RowBox[{
  "0.5151083908076521967429693961669503196763126632144106626447421688494`50.",
    " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{386, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->270220137]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Circles at random positions in the complex plane:", "ExampleText",
 CellID->20268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "#", "]"}], ",", 
       RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"10", "+", 
      RowBox[{"10", "I"}]}], ",", "40"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21924],

Cell[BoxData[
 GraphicsBox[{CircleBox[{3.886703275691359, 4.169125547724319}], 
   CircleBox[{0.7741393579163702, 4.984275027773483}], 
   CircleBox[{2.9567919401224074`, 6.431389287362754}], 
   CircleBox[{6.657700277025366, 2.6302780070254883`}], 
   CircleBox[{8.868531068418994, 7.503231252140394}], 
   CircleBox[{9.197661325962637, 1.1000384442242273`}], 
   CircleBox[{0.4413617516724244, 0.6157436311344933}], 
   CircleBox[{2.403383460885087, 1.629494195484995}], 
   CircleBox[{4.6056011620564625`, 7.288789358629016}], 
   CircleBox[{8.401155495677093, 9.270542893225063}], 
   CircleBox[{0.7317222352438568, 7.537503006220954}], 
   CircleBox[{9.981890029572686, 1.8382667709263845`}], 
   CircleBox[{5.29137547369348, 8.59715024551301}], 
   CircleBox[{6.732221365734821, 6.049764699807771}], 
   CircleBox[{3.748881924696481, 8.061455116021088}], 
   CircleBox[{2.2621933716191434`, 3.892398576496112}], 
   CircleBox[{9.266202612915928, 8.713533990456812}], 
   CircleBox[{5.829270839700618, 7.590788078266821}], 
   CircleBox[{2.581664363559646, 5.0086077032549685`}], 
   CircleBox[{0.2726885467386553, 6.633706939985773}], 
   CircleBox[{9.527582035698003, 6.6747963340186285`}], 
   CircleBox[{8.547461199511792, 3.451165612043434}], 
   CircleBox[{0.11223428607054053`, 2.696927855864335}], 
   CircleBox[{1.9089934493962324`, 5.144812298859911}], 
   CircleBox[{2.337057579194257, 0.3465395880780142}], 
   CircleBox[{4.948656483545446, 7.986497077999024}], 
   CircleBox[{4.604759619200922, 5.141540775962447}], 
   CircleBox[{3.8222230125046353`, 8.1017127367412}], 
   CircleBox[{4.915335557033432, 9.865913187678961}], 
   CircleBox[{6.885509031269416, 9.640978477878601}], 
   CircleBox[{2.6866371177317983`, 7.321765992686449}], 
   CircleBox[{0.7424891522172827, 8.904192103331997}], 
   CircleBox[{1.5894185904589064`, 0.28539307089674226`}], 
   CircleBox[{0.8809752736806842, 7.653416920296294}], 
   CircleBox[{6.415057586010999, 2.006447386960506}], 
   CircleBox[{8.058539964559596, 1.039803505213066}], 
   CircleBox[{6.1469099552867075`, 2.8696099833611433`}], 
   CircleBox[{9.701092576893915, 4.315641050550512}], 
   CircleBox[{1.6392079811842342`, 4.448981738134215}], 
   CircleBox[{7.565569046428136, 5.009760958284513}]},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->361420537]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26077],

Cell["Random walk in the complex plane:", "ExampleText",
 CellID->23182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "#", "]"}], ",", 
       RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
    RowBox[{"Accumulate", "[", 
     RowBox[{"RandomComplex", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "-", "I"}], ",", 
         RowBox[{"1", "+", "I"}]}], "}"}], ",", "500"}], "]"}], "]"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18015],

Cell[BoxData[
 GraphicsBox[LineBox[CompressedData["
1:eJwVl3c8198Xxz/2nh+bDx+fjz0/RkbR+5BKViilkEgpEZoSklVGRlo0CKFv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   "]],
  ImageMargins->0.]], "Output",
 ImageSize->{229, 311},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->788752157]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " to get repeatable random values:"
}], "ExampleText",
 CellID->27733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RandomComplex", "[", "]"}], ",", 
   RowBox[{"RandomComplex", "[", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.4396633617394796`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.23397326356636894`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.16045491602121342`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9585893325668644`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->450664415]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
    RowBox[{"RandomComplex", "[", "]"}]}], ",", 
   RowBox[{
    RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
    RowBox[{"RandomComplex", "[", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18108],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.876608492574193`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.5219642502018771`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.876608492574193`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.5219642502018771`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->257234930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2305],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 " to block one use of ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " from affecting others:"
}], "ExampleText",
 CellID->8548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BlockRandom", "[", 
    RowBox[{"RandomComplex", "[", "]"}], "]"}], ",", 
   RowBox[{"RandomComplex", "[", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2192],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.08622342695413243`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.3779129543048858`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.08622342695413243`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.3779129543048858`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355988831]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5393],

Cell[TextData[{
 "With the same seed, ",
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " generates the \"same\" number, regardless of precision:"
}], "ExampleText",
 CellID->21556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SeedRandom", "[", "4567", "]"}], ";", 
    RowBox[{"RandomComplex", "[", 
     RowBox[{"WorkingPrecision", "->", "p"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2660],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5`0.9999999999999999", "+", 
    RowBox[{"0.3125`1.", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.515625`2.0000000000000004", "+", 
    RowBox[{"0.8125`2.0000000000000004", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.521484375`2.9999999999999996", "+", 
    RowBox[{"0.51953125`2.999999999999999", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.52197265625`4.000000000000001", "+", 
    RowBox[{"0.31695556640625`4.", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.5219879150390625`5.000000000000002", "+", 
    RowBox[{"0.5357513427734375`5.", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.521991729736328125`5.999999999999999", "+", 
    RowBox[{"0.28604888916015625`6.000000000000002", " ", "\[ImaginaryI]"}]}],
    ",", 
   RowBox[{"0.5219919681549072266`6.999999999999999", "+", 
    RowBox[{"0.5767907500267028809`7.", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.5219919979572296143`8.000000000000002", "+", 
    RowBox[{"0.6143260598182678223`8.", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.5219920016825199127`9.", "+", 
    RowBox[{
    "0.9146085018292069435`8.999999999999998", " ", "\[ImaginaryI]"}]}], ",", 
   
   RowBox[{"0.52199200249742716550827026367`10.", "+", 
    RowBox[{"0.63373603718355298042297363281`10.", " ", "\[ImaginaryI]"}]}]}],
   "}"}]], "Output",
 ImageSize->{531, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->697582963]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18942],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomComplex"]], "InlineFormula"],
 " generates a uniform distribution, here with mean ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0.5", "+", 
    RowBox[{"0.5", " ", "\[ImaginaryI]"}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->3340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"RandomComplex", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"1", "I"}]}], ",", "10000"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15420],

Cell[BoxData[
 RowBox[{"0.49810033314709545`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.4994104251317973`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29569916]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomChoice",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomChoice"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SeedRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeedRandom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Pseudorandom Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PseudorandomNumbers"]], "Tutorials",
 CellID->32657],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RandomNumberGeneration"]], "Tutorials",
 CellID->86049371]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->122601267],

Cell[TextData[ButtonBox["Functions of Complex Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsOfComplexVariables"]], "MoreAbout",
 CellID->150663698],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RandomNumberGeneration"]], "MoreAbout",
 CellID->5224146]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RandomComplex - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 48.0626274}", "context" -> "System`", 
    "keywords" -> {"random complex number"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RandomComplex[] gives a pseudorandom complex number with real and \
imaginary parts in the range 0 to 1. RandomComplex[{z_min, z_max}] gives a \
pseudorandom complex number in the rectangle with corners given by the \
complex numbers z_min and z_max. RandomComplex[z_max] gives a pseudorandom \
complex number in the rectangle whose corners are the origin and z_max. \
RandomComplex[range, n] gives a list of n pseudorandom complex numbers. \
RandomComplex[range, {n_1, n_2, ...}] gives an n_1*n_2*... array of \
pseudorandom complex numbers. ", "synonyms" -> {"random complex"}, "title" -> 
    "RandomComplex", "type" -> "Symbol", "uri" -> "ref/RandomComplex"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10186, 312, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->41459331]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47700, 1421}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2575, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3198, 86, 1578, 37, 70, "ObjectNameGrid"],
Cell[4779, 125, 3133, 99, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[7949, 229, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8427, 246, 271, 8, 70, "Notes",
 CellID->28455],
Cell[8701, 256, 602, 19, 70, "Notes",
 CellID->17254],
Cell[9306, 277, 473, 15, 70, "Notes",
 CellID->11251],
Cell[9782, 294, 367, 13, 70, "Notes",
 CellID->17887]
}, Closed]],
Cell[CellGroupData[{
Cell[10186, 312, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41459331],
Cell[CellGroupData[{
Cell[10570, 326, 148, 5, 70, "ExampleSection",
 CellID->178366848],
Cell[10721, 333, 121, 3, 70, "ExampleText",
 CellID->15225],
Cell[CellGroupData[{
Cell[10867, 340, 99, 3, 28, "Input",
 CellID->6453],
Cell[10969, 345, 275, 7, 36, "Output",
 CellID->99934272]
}, Open  ]],
Cell[11259, 355, 120, 3, 70, "ExampleDelimiter",
 CellID->8198],
Cell[11382, 360, 375, 14, 70, "ExampleText",
 CellID->21916],
Cell[CellGroupData[{
Cell[11782, 378, 244, 9, 70, "Input",
 CellID->31563],
Cell[12029, 389, 272, 7, 36, "Output",
 CellID->772707590]
}, Open  ]],
Cell[12316, 399, 121, 3, 70, "ExampleDelimiter",
 CellID->12419],
Cell[12440, 404, 317, 11, 70, "ExampleText",
 CellID->26742],
Cell[CellGroupData[{
Cell[12782, 419, 147, 5, 70, "Input",
 CellID->5124],
Cell[12932, 426, 272, 7, 36, "Output",
 CellID->1019119708]
}, Open  ]],
Cell[13219, 436, 121, 3, 70, "ExampleDelimiter",
 CellID->30422],
Cell[13343, 441, 83, 1, 70, "ExampleText",
 CellID->28830],
Cell[CellGroupData[{
Cell[13451, 446, 152, 5, 70, "Input",
 CellID->31854],
Cell[13606, 453, 832, 18, 54, "Output",
 CellID->328299498]
}, Open  ]],
Cell[14453, 474, 120, 3, 70, "ExampleDelimiter",
 CellID->7979],
Cell[14576, 479, 376, 13, 70, "ExampleText",
 CellID->6556],
Cell[CellGroupData[{
Cell[14977, 496, 302, 11, 70, "Input",
 CellID->25021],
Cell[15282, 509, 1086, 26, 54, "Output",
 CellID->490429150]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16417, 541, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[16641, 550, 87, 1, 70, "ExampleText",
 CellID->2013],
Cell[CellGroupData[{
Cell[16753, 555, 203, 7, 70, "Input",
 CellID->9370],
Cell[16959, 564, 325, 9, 36, "Output",
 CellID->899473139]
}, Open  ]],
Cell[17299, 576, 121, 3, 70, "ExampleDelimiter",
 CellID->16373],
Cell[17423, 581, 88, 1, 70, "ExampleText",
 CellID->10536],
Cell[CellGroupData[{
Cell[17536, 586, 145, 4, 70, "Input",
 CellID->21450],
Cell[17684, 592, 328, 9, 36, "Output",
 CellID->22383187]
}, Open  ]],
Cell[CellGroupData[{
Cell[18049, 606, 272, 9, 70, "Input",
 CellID->10625],
Cell[18324, 617, 370, 10, 54, "Output",
 CellID->174776252]
}, Open  ]],
Cell[18709, 630, 121, 3, 70, "ExampleDelimiter",
 CellID->18076],
Cell[18833, 635, 77, 1, 70, "ExampleText",
 CellID->5808],
Cell[CellGroupData[{
Cell[18935, 640, 301, 10, 70, "Input",
 CellID->29727],
Cell[19239, 652, 876, 23, 54, "Output",
 CellID->24649821]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20164, 681, 221, 7, 70, "ExampleSection",
 CellID->98200206],
Cell[CellGroupData[{
Cell[20410, 692, 236, 7, 70, "ExampleSubsection",
 CellID->14962614],
Cell[20649, 701, 97, 2, 70, "ExampleText",
 CellID->6981],
Cell[CellGroupData[{
Cell[20771, 707, 145, 4, 70, "Input",
 CellID->30209],
Cell[20919, 713, 372, 11, 54, "Output",
 CellID->424119802]
}, Open  ]],
Cell[CellGroupData[{
Cell[21328, 729, 292, 10, 70, "Input",
 CellID->23731],
Cell[21623, 741, 390, 12, 54, "Output",
 CellID->270220137]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[22074, 760, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[22304, 769, 88, 1, 70, "ExampleText",
 CellID->20268],
Cell[CellGroupData[{
Cell[22417, 774, 416, 14, 70, "Input",
 CellID->21924],
Cell[22836, 790, 2480, 47, 240, "Output",
 CellID->361420537]
}, Open  ]],
Cell[25331, 840, 121, 3, 70, "ExampleDelimiter",
 CellID->26077],
Cell[25455, 845, 72, 1, 70, "ExampleText",
 CellID->23182],
Cell[CellGroupData[{
Cell[25552, 850, 555, 19, 70, "Input",
 CellID->18015],
Cell[26110, 871, 10794, 182, 332, "Output",
 CellID->788752157]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36953, 1059, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[37194, 1068, 219, 8, 70, "ExampleText",
 CellID->27733],
Cell[CellGroupData[{
Cell[37438, 1080, 182, 6, 70, "Input",
 CellID->3993],
Cell[37623, 1088, 445, 12, 36, "Output",
 CellID->450664415]
}, Open  ]],
Cell[CellGroupData[{
Cell[38105, 1105, 317, 10, 70, "Input",
 CellID->18108],
Cell[38425, 1117, 441, 12, 36, "Output",
 CellID->257234930]
}, Open  ]],
Cell[38881, 1132, 120, 3, 70, "ExampleDelimiter",
 CellID->2305],
Cell[39004, 1137, 365, 13, 70, "ExampleText",
 CellID->8548],
Cell[CellGroupData[{
Cell[39394, 1154, 222, 7, 70, "Input",
 CellID->2192],
Cell[39619, 1163, 445, 12, 36, "Output",
 CellID->355988831]
}, Open  ]],
Cell[40079, 1178, 120, 3, 70, "ExampleDelimiter",
 CellID->5393],
Cell[40202, 1183, 264, 8, 70, "ExampleText",
 CellID->21556],
Cell[CellGroupData[{
Cell[40491, 1195, 319, 10, 70, "Input",
 CellID->2660],
Cell[40813, 1207, 1472, 31, 71, "Output",
 CellID->697582963]
}, Open  ]],
Cell[42300, 1241, 121, 3, 70, "ExampleDelimiter",
 CellID->18942],
Cell[42424, 1246, 370, 13, 70, "ExampleText",
 CellID->3340],
Cell[CellGroupData[{
Cell[42819, 1263, 210, 7, 70, "Input",
 CellID->15420],
Cell[43032, 1272, 273, 7, 36, "Output",
 CellID->29569916]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43366, 1286, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[43685, 1297, 969, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[44691, 1337, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[45012, 1348, 150, 3, 70, "Tutorials",
 CellID->32657],
Cell[45165, 1353, 160, 3, 70, "Tutorials",
 CellID->86049371]
}, Open  ]],
Cell[CellGroupData[{
Cell[45362, 1361, 299, 8, 70, "MoreAboutSection"],
Cell[45664, 1371, 141, 3, 70, "MoreAbout",
 CellID->122601267],
Cell[45808, 1376, 169, 3, 70, "MoreAbout",
 CellID->150663698],
Cell[45980, 1381, 156, 3, 70, "MoreAbout",
 CellID->5224146]
}, Open  ]],
Cell[46151, 1387, 27, 0, 70, "History"],
Cell[46181, 1389, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

