(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29588,       1016]
NotebookOptionsPosition[     23745,        814]
NotebookOutlinePosition[     25142,        852]
CellTagsIndexPosition[     25057,        847]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"], 
          "Random Number Generation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RandomNumberGeneration"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>", 
       2->"\<\"Random Number Generation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NextPrime" :> Documentation`HelpLookup["paclet:ref/NextPrime"],
           "RandomInteger" :> 
          Documentation`HelpLookup["paclet:ref/RandomInteger"], "PrimeQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimeQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NextPrime\"\>", 2->"\<\"RandomInteger\"\>", 
       3->"\<\"PrimeQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"], 
          "Random Number Generation" :> 
          Documentation`HelpLookup["paclet:guide/RandomNumberGeneration"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cryptographic Number Theory\"\>", 
       2->"\<\"Mathematical Functions\"\>", 3->"\<\"Prime Numbers\"\>", 
       4->"\<\"Random Number Generation\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       6->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RandomPrime", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomPrime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomPrime"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["min", "TI"]], ",", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["max", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a pseudorandom prime number in the range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomPrime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomPrime"], "[", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a pseudorandom prime number in the range 2 to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomPrime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomPrime"], "[", 
       RowBox[{
        StyleBox["range", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " pseudorandom primes."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->32210]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A random prime ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " is computed by repeatedly generating pseudorandom integers in the \
specified range until the desired number of primes has been produced."
}], "Notes",
 CellID->8805],

Cell["\<\
If no prime exists in the specified range, the input is returned unevaluated \
with an error message.\
\>", "Notes",
 CellID->4716],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomPrime"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " chooses primes between ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " with equal probability."
}], "Notes",
 CellID->23237],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomPrime"], "[", 
   SubscriptBox[
    StyleBox["i", "TI"], 
    StyleBox["max", "TI"]], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomPrime"], "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25439],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomPrime"], "[", 
   RowBox[{
    StyleBox["range", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives a ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "1"], "\[Times]", 
    SubscriptBox["n", "2"], "\[Times]", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 " array of primes."
}], "Notes",
 CellID->19506783]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->197456980],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->599264264],

Cell["A random prime less than 100:", "ExampleText",
 CellID->20539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPrime", "[", "100", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15613],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160228252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13969],

Cell["A random 10-digit prime:", "ExampleText",
 CellID->27613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPrime", "[", 
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["10", "9"], ",", 
    SuperscriptBox["10", "10"]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31115],

Cell[BoxData["6571343941"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->555031027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32666],

Cell["A list of 10 pseudorandom primes less than 100:", "ExampleText",
 CellID->14863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPrime", "[", 
  RowBox[{"100", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18512],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "37", ",", "97", ",", "37", ",", "11", ",", "43", ",", "67", ",", "83", ",",
    "67", ",", "23", ",", "73"}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156639045]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4853],

Cell["\<\
Generate a random array of primes less than 11 of dimension 4\[Times]5:\
\>", "ExampleText",
 CellID->157335753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPrime", "[", 
  RowBox[{"10", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12353073],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "5", ",", "5", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "7", ",", "3", ",", "7", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2", ",", "5", ",", "2", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "3", ",", "2", ",", "7", ",", "7"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{427, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32364340]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5555],

Cell["Find two large primes for use in RSA encryption:", "ExampleText",
 CellID->31494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"p", ",", "q"}], "}"}], "=", 
  RowBox[{"RandomPrime", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "^", "639"}], ",", 
      RowBox[{"2", "^", "640"}]}], "}"}], ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->735178024],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "335342602217747539513332550039475515255203976984789016690082650876190863685\
437425675104856423938577859710441686299486508065868109745964373056664796721031\
9402124788787653918189872405120293566211", ",", 
   "28852889804915565557507437214869080382469914910342448435703222773268542904\
066649081896702125137288701619996730453384921110157891373071671898628938365036\
24990567859185123634628654418774194155527"}], "}"}]], "Output",
 ImageSize->{583, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195792501]
}, Open  ]],

Cell["This is a 640-binary-digit number:", "ExampleText",
 CellID->17219567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"DigitCount", "[", 
   RowBox[{"p", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39310927],

Cell[BoxData["640"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118638449]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerLength", "[", 
  RowBox[{"p", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->258656632],

Cell[BoxData["640"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->103803940]
}, Open  ]],

Cell["Its binary representation:", "ExampleText",
 CellID->28101061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"p", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->10049155],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"\
101111000010100101101100000011001110101111011000001000101010011111000010100110\
011100000100100110011111011100001110011110011001001111101110111000101100011111\
101011101110110000010101000100110001010011101000011000110011100000101000100000\
010011100001011000101101101111100110010011100110010010100110010110111111001111\
101100101101001110101111110100110011111100010011110110010001001100000101111010\
000101110101111101100100111110010110010111110111111100100100001110000100111110\
111100101110100101100011100101111111010000110000111010100011101111001000101111\
110001110011101000011001111011110011111000101111001001111010100111101011101000\
0111011100000011\"\>", "\<\"2\"\>"],
   335342602217747539513332550039475515255203976984789016690082650876190863685\
437425675104856423938577859710441686299486508065868109745964373056664796721031\
9402124788787653918189872405120293566211,
   Editable->False],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{585, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//BaseForm=",
 CellID->222012450]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3501],

Cell["Sampling of primes from 1 to 100:", "ExampleText",
 CellID->10156],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomPrime", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "100"}], "}"}], ",", 
     RowBox[{"10", "^", "4"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22810],

Cell["The distribution is uniform over the primes:", "ExampleText",
 CellID->25605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Tally", "[", "data", "]"}], ",", 
   RowBox[{"Filling", "  ", "\[Rule]", " ", "Axis"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1779161],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJztkz0KwkAQhRcrS4uUKbRJkcqQwkoMkhCIRGIUsRas7fxtchSPkCPkCB7B
o6iZN4F9F7BxITy+nZ83y5DR/lgeesaYxef7anuiXdTq6yJazUXrEzgXje6i
zUZ0iLgJcX8FT5F/BvdFH4g3a9zDLyrhg/5VJvrU+Fa0QL9mhXnRr0pFx+rv
If8G9ik/sedtCuSrfwx/fZ9Bf+03ER2qn4M+mK9aig4wv5nZ7zGuaK31AfLB
ug89uo+Oc5t1H90JiafEfapf26z76Pwyim+pfkX5Kfl5xD7lJ9SvoHhM9YZ4
QuxQ/ZLiM2KXOLD5/38g//f/xxs2bngd
   "], {{{}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{26, 1}], LineBox[{27, 2}], 
      LineBox[{28, 3}], LineBox[{29, 4}], LineBox[{30, 5}], LineBox[{31, 6}], 
      LineBox[{32, 7}], LineBox[{33, 8}], LineBox[{34, 9}], LineBox[{35, 10}],
       LineBox[{36, 11}], LineBox[{37, 12}], LineBox[{38, 13}], 
      LineBox[{39, 14}], LineBox[{40, 15}], LineBox[{41, 16}], 
      LineBox[{42, 17}], LineBox[{43, 18}], LineBox[{44, 19}], 
      LineBox[{45, 20}], LineBox[{46, 21}], LineBox[{47, 22}], 
      LineBox[{48, 23}], LineBox[{49, 24}], LineBox[{50, 25}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
       66, 67, 68, 69, 70, 71, 72, 73, 74, 75}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->482341780]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2627],

Cell["\<\
If no prime exists in the specified range an error message is returned:\
\>", "ExampleText",
 CellID->18542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPrime", "[", 
  RowBox[{"{", 
   RowBox[{"14", ",", "16"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23059],

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomPrime", "::", "\<\"noprime\"\>"}], ":", 
  " ", "\<\"There are no primes in the specified interval.\"\>"}]], "Message",\
 "MSG",
 CellID->222198610],

Cell[BoxData[
 RowBox[{"RandomPrime", "[", 
  RowBox[{"{", 
   RowBox[{"14", ",", "16"}], "}"}], "]"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->644331962]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3611],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NextPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NextPrime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10994]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25550],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RandomNumberGeneration"]], "Tutorials",
 CellID->86049371]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->263403644],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->757965186],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->345404628],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->181007201],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RandomNumberGeneration"]], "MoreAbout",
 CellID->30023202],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->153324582],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->563031394]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RandomPrime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 51.0314534}", "context" -> "System`", 
    "keywords" -> {"random number"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RandomPrime[{i_min, i_max}] gives a pseudorandom prime number in the \
range i_min to i_max. RandomPrime[i_max] gives a pseudorandom prime number in \
the range 2 to i_max. RandomPrime[range, n] gives a list of n pseudorandom \
primes.", "synonyms" -> {"random prime"}, "title" -> "RandomPrime", "type" -> 
    "Symbol", "uri" -> "ref/RandomPrime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10148, 318, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->197456980]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24913, 840}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3108, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3731, 96, 1576, 37, 70, "ObjectNameGrid"],
Cell[5310, 135, 1899, 62, 70, "Usage",
 CellID->32210]
}, Open  ]],
Cell[CellGroupData[{
Cell[7246, 202, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7724, 219, 269, 7, 70, "Notes",
 CellID->8805],
Cell[7996, 228, 141, 4, 70, "Notes",
 CellID->4716],
Cell[8140, 234, 666, 26, 70, "Notes",
 CellID->23237],
Cell[8809, 262, 573, 22, 70, "Notes",
 CellID->25439],
Cell[9385, 286, 726, 27, 70, "Notes",
 CellID->19506783]
}, Closed]],
Cell[CellGroupData[{
Cell[10148, 318, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->197456980],
Cell[CellGroupData[{
Cell[10533, 332, 148, 5, 70, "ExampleSection",
 CellID->599264264],
Cell[10684, 339, 68, 1, 70, "ExampleText",
 CellID->20539],
Cell[CellGroupData[{
Cell[10777, 344, 105, 3, 28, "Input",
 CellID->15613],
Cell[10885, 349, 159, 5, 36, "Output",
 CellID->160228252]
}, Open  ]],
Cell[11059, 357, 121, 3, 70, "ExampleDelimiter",
 CellID->13969],
Cell[11183, 362, 63, 1, 70, "ExampleText",
 CellID->27613],
Cell[CellGroupData[{
Cell[11271, 367, 205, 7, 70, "Input",
 CellID->31115],
Cell[11479, 376, 167, 5, 36, "Output",
 CellID->555031027]
}, Open  ]],
Cell[11661, 384, 121, 3, 70, "ExampleDelimiter",
 CellID->32666],
Cell[11785, 389, 86, 1, 70, "ExampleText",
 CellID->14863],
Cell[CellGroupData[{
Cell[11896, 394, 129, 4, 70, "Input",
 CellID->18512],
Cell[12028, 400, 301, 9, 36, "Output",
 CellID->156639045]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12378, 415, 215, 7, 70, "ExampleSection",
 CellID->4853],
Cell[12596, 424, 122, 3, 70, "ExampleText",
 CellID->157335753],
Cell[CellGroupData[{
Cell[12743, 431, 179, 6, 70, "Input",
 CellID->12353073],
Cell[12925, 439, 542, 16, 36, "Output",
 CellID->32364340]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13516, 461, 222, 7, 70, "ExampleSection",
 CellID->5555],
Cell[13741, 470, 87, 1, 70, "ExampleText",
 CellID->31494],
Cell[CellGroupData[{
Cell[13853, 475, 310, 11, 70, "Input",
 CellID->735178024],
Cell[14166, 488, 604, 13, 122, "Output",
 CellID->195792501]
}, Open  ]],
Cell[14785, 504, 76, 1, 70, "ExampleText",
 CellID->17219567],
Cell[CellGroupData[{
Cell[14886, 509, 161, 5, 70, "Input",
 CellID->39310927],
Cell[15050, 516, 160, 5, 36, "Output",
 CellID->118638449]
}, Open  ]],
Cell[CellGroupData[{
Cell[15247, 526, 132, 4, 70, "Input",
 CellID->258656632],
Cell[15382, 532, 160, 5, 36, "Output",
 CellID->103803940]
}, Open  ]],
Cell[15557, 540, 68, 1, 70, "ExampleText",
 CellID->28101061],
Cell[CellGroupData[{
Cell[15650, 545, 126, 4, 70, "Input",
 CellID->10049155],
Cell[15779, 551, 1140, 22, 187, "Output",
 CellID->222012450]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16968, 579, 232, 7, 70, "ExampleSection",
 CellID->3501],
Cell[17203, 588, 72, 1, 70, "ExampleText",
 CellID->10156],
Cell[17278, 591, 255, 9, 70, "Input",
 CellID->22810],
Cell[17536, 602, 83, 1, 70, "ExampleText",
 CellID->25605],
Cell[CellGroupData[{
Cell[17644, 607, 366, 10, 70, "Input",
 CellID->1779161],
Cell[18013, 619, 1491, 30, 135, "Output",
 CellID->482341780]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19553, 655, 225, 7, 70, "ExampleSection",
 CellID->2627],
Cell[19781, 664, 118, 3, 70, "ExampleText",
 CellID->18542],
Cell[CellGroupData[{
Cell[19924, 671, 152, 5, 70, "Input",
 CellID->23059],
Cell[20079, 678, 189, 5, 70, "Message",
 CellID->222198610],
Cell[20271, 685, 245, 8, 36, "Output",
 CellID->644331962]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20577, 700, 310, 9, 70, "SeeAlsoSection",
 CellID->3611],
Cell[20890, 711, 704, 26, 70, "SeeAlso",
 CellID->10994]
}, Open  ]],
Cell[CellGroupData[{
Cell[21631, 742, 314, 9, 70, "TutorialsSection",
 CellID->25550],
Cell[21948, 753, 198, 4, 70, "Tutorials",
 CellID->28609],
Cell[22149, 759, 160, 3, 70, "Tutorials",
 CellID->86049371]
}, Open  ]],
Cell[CellGroupData[{
Cell[22346, 767, 319, 9, 70, "MoreAboutSection",
 CellID->263403644],
Cell[22668, 778, 164, 3, 70, "MoreAbout",
 CellID->757965186],
Cell[22835, 783, 155, 3, 70, "MoreAbout",
 CellID->345404628],
Cell[22993, 788, 137, 3, 70, "MoreAbout",
 CellID->181007201],
Cell[23133, 793, 157, 3, 70, "MoreAbout",
 CellID->30023202],
Cell[23293, 798, 179, 3, 70, "MoreAbout",
 CellID->153324582],
Cell[23475, 803, 198, 4, 70, "MoreAbout",
 CellID->563031394]
}, Open  ]],
Cell[23688, 810, 27, 0, 70, "History"],
Cell[23718, 812, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

