(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35970,       1280]
NotebookOptionsPosition[     29486,       1056]
NotebookOutlinePosition[     31019,       1097]
CellTagsIndexPosition[     30933,       1092]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Random Number Generation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RandomNumberGeneration"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Random Number Generation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RandomChoice" :> 
          Documentation`HelpLookup["paclet:ref/RandomChoice"], 
          "RandomInteger" :> 
          Documentation`HelpLookup["paclet:ref/RandomInteger"], "SeedRandom" :> 
          Documentation`HelpLookup["paclet:ref/SeedRandom"], "BlockRandom" :> 
          Documentation`HelpLookup["paclet:ref/BlockRandom"], "Permutations" :> 
          Documentation`HelpLookup["paclet:ref/Permutations"], "Subsets" :> 
          Documentation`HelpLookup["paclet:ref/Subsets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RandomChoice\"\>", 2->"\<\"RandomInteger\"\>", 
       3->"\<\"SeedRandom\"\>", 4->"\<\"BlockRandom\"\>", 
       5->"\<\"Permutations\"\>", 6->"\<\"Subsets\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Random Number Generation" :> 
          Documentation`HelpLookup["paclet:guide/RandomNumberGeneration"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Discrete Mathematics\"\>", 
       2->"\<\"Random Number Generation\"\>", 
       3->"\<\"Rearranging & Restructuring Lists\"\>", 
       4->"\<\"New in 6.0: List Manipulation\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       6->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RandomSample", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomSample",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomSample"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a pseudorandom sample of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomSample",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomSample"], "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["w", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["w", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["e", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["e", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a pseudorandom sample of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
     " chosen using weights ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["w", "i"], TraditionalForm]], "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomSample",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RandomSample"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a pseudorandom permutation of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->28188]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomSample",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomSample"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " never samples any of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " more than once."
}], "Notes",
 CellID->1790],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomSample",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomSample"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " samples each of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " with equal probability. "
}], "Notes",
 CellID->27993],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " gives a different sequence of pseudorandom choices whenever you run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can start with a particular seed using ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13429],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option to ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " can be given to specify the pseudorandom generator used. "
}], "Notes",
 CellID->2319]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49462664],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->590785646],

Cell["\<\
Find a sample in which no elements ever occur more than once:\
\>", "ExampleText",
 CellID->22841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{
   RowBox[{"Range", "[", "30", "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "15", ",", "28", ",", "4", ",", "1", ",", "30", ",", "3", ",", "5", ",", 
   "7", ",", "2", ",", "8", ",", "25", ",", "26", ",", "9", ",", "18", ",", 
   "29", ",", "6", ",", "22", ",", "21", ",", "14", ",", "16"}], 
  "}"}]], "Output",
 ImageSize->{448, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21423818]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2059],

Cell["Generate a random permutation:", "ExampleText",
 CellID->21867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{"Range", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12178],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6", ",", "10", ",", "8", ",", "9", ",", "5", ",", "1", ",", "2", ",", "7", 
   ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->489877454]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16474],

Cell["The elements can be any expressions:", "ExampleText",
 CellID->8067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"1", "/", "x"}], ",", "2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21394],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   SuperscriptBox["x", "2"], ",", 
   SuperscriptBox["\[ExponentialE]", "x"], ",", 
   FractionBox["1", "x"]}], "}"}]], "Output",
 ImageSize->{95, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->543100236]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19646854],

Cell["\<\
With larger weights for later elements, later elements tend to be selected \
for the sample:\
\>", "ExampleText",
 CellID->31137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Range", "[", "30", "]"}], "->", 
    RowBox[{"Range", "[", "30", "]"}]}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "28", ",", "21", ",", "18", ",", "15", ",", "25", ",", "11", ",", "16", ",",
    "22", ",", "26", ",", "30"}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77650544]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32327],

Cell["Successively fill in black squares down the page:", "ExampleText",
 CellID->20317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"FoldList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ReplacePart", "[", 
      RowBox[{"#", ",", 
       RowBox[{"#2", "->", "1"}]}], "]"}], "&"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", 
      RowBox[{"{", "30", "}"}]}], "]"}], ",", 
    RowBox[{"RandomSample", "[", 
     RowBox[{
      RowBox[{"Range", "[", "30", "]"}], ",", "30"}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27385],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmjELgkAYhk9UyAaDHGoocCmopaWhX2BTU1OjSFBDFObfCBoa+rf1WZ/U
VJpZevcenO93733vMx0cws38aLXc+NE68N1p6O9W62DvetuQLF0TQpxontuC
6gtVtxlbNPS4vg1xpI+W0j3Ey7/ujKg0qVhUpsNjtaXptFgnEiQs0rGSCZt0
pGTCIR1WNGFzRwfJjMkeaR3JF0mT1GAfhLvfYB+EPIQ2r0F4R7D41IJQNMEU
j5sEpPckg9UE8cfEFiuIZSM64v7/AWI+YkKogywh2QaxJMTmUxLE/MQ+SH8i
dUFIQUhOOwjfJFisqhNcJD9IxlpTOukolhpI1T2Romv+490sryyKd/kViHYF
JE/Snw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{148, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->44507986]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29225],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SeedRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeedRandom"]], "InlineFormula"],
 " to get repeatable random values:"
}], "ExampleText",
 CellID->27733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RandomSample", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
   RowBox[{"RandomSample", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "3", ",", "6", ",", "10", ",", "1", ",", "9", ",", "8", ",", "7", ",", 
     "2", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "9", ",", "7", ",", "8", ",", "10", ",", "6", ",", "5", ",", "4", ",", 
     "2", ",", "3", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{413, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211174364]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
    RowBox[{"RandomSample", "[", 
     RowBox[{"Range", "[", "10", "]"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
    RowBox[{"RandomSample", "[", 
     RowBox[{"Range", "[", "10", "]"}], "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18108],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "7", ",", "5", ",", "6", ",", "9", ",", "3", ",", "10", ",", 
     "4", ",", "8", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "7", ",", "5", ",", "6", ",", "9", ",", "3", ",", "10", ",", 
     "4", ",", "8", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{413, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->790847120]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2305],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["BlockRandom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlockRandom"]], "InlineFormula"],
 " to block one use of ",
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " from affecting others:"
}], "ExampleText",
 CellID->8548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BlockRandom", "[", 
    RowBox[{"RandomSample", "[", 
     RowBox[{"Range", "[", "10", "]"}], "]"}], "]"}], ",", 
   RowBox[{"RandomSample", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2192],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "10", ",", "3", ",", "9", ",", "6", ",", "8", ",", 
     "4", ",", "5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "10", ",", "3", ",", "9", ",", "6", ",", "8", ",", 
     "4", ",", "5", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{413, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155170509]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5393],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomSample",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomSample"]], "InlineFormula"],
 " of size 1 follows the same distribution as ",
 Cell[BoxData[
  ButtonBox["RandomChoice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomChoice"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1682669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"RandomSample", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "1"}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", "^", "5"}], "}"}]}], "]"}], "//", "Flatten"}], "//", 
   "Tally"}], "//", "Sort"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240177050],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "25255"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "24661"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "25167"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "24917"}], "}"}]}], "}"}]], "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220732894]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"10", "^", "5"}]}], "]"}], "//", "Tally"}], "//", 
  "Sort"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->933502685],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "24978"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "25145"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "25070"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "24807"}], "}"}]}], "}"}]], "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->354248708]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"RandomSample", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"Range", "[", "4", "]"}]}], "->", 
         RowBox[{"{", 
          RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], ",", "1"}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", "^", "5"}], "}"}]}], "]"}], "//", "Flatten"}], "//", 
   "Tally"}], "//", "Sort"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8720075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "84"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "933"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "8890"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "90093"}], "}"}]}], "}"}]], "Output",
 ImageSize->{281, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->232517436]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"10", "^", 
       RowBox[{"Range", "[", "4", "]"}]}], "->", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], ",", 
     RowBox[{"10", "^", "5"}]}], "]"}], "//", "Tally"}], "//", 
  "Sort"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->171548510],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "90"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "903"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "9126"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "89881"}], "}"}]}], "}"}]], "Output",
 ImageSize->{281, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->182108052]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29565],

Cell["\<\
If the sample size is larger than the population size an error message is \
returned:\
\>", "ExampleText",
 CellID->18542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23059],

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomSample", "::", "\<\"smplen\"\>"}], ":", 
  " ", "\<\"RandomSample cannot generate a sample of length \\!\\(5\\), which \
is greater than the length of the sample set \\!\\({a, b, c, d}\\).  If you \
want a choice of possibly repeated elements from the set, use RandomChoice.\"\
\>"}]], "Message", "MSG",
 CellID->322875486],

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "5"}], 
  "]"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->533565205]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->958],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomChoice",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomChoice"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SeedRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeedRandom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlockRandom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlockRandom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Permutations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Permutations"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14228]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1062],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RandomNumberGeneration"]], "Tutorials",
 CellID->86049371]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with RandomSample",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=RandomSample"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->82739100],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->17579734],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RandomNumberGeneration"]], "MoreAbout",
 CellID->264192743],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->388237660],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->357459255],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->426017639],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->250827083]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RandomSample - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 54.0159048}", "context" -> "System`", 
    "keywords" -> {
     "random permutation", "random subset", "sampling without replacement", 
      "urn problem"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RandomSample[{e_1, e_2, ...}, n] gives a pseudorandom sample of n of the \
e_i. RandomSample[{w_1, w_2, ...} -> {e_1, e_2, ...}, n] gives a pseudorandom \
sample of n of the e_i chosen using weights w_i. RandomSample[{e_1, e_2, \
...}] gives a pseudorandom permutation of the e_i.", 
    "synonyms" -> {"random sample"}, "title" -> "RandomSample", "type" -> 
    "Symbol", "uri" -> "ref/RandomSample"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10979, 336, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->49462664]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30790, 1085}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3212, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3835, 97, 1577, 37, 70, "ObjectNameGrid"],
Cell[5415, 136, 2907, 93, 70, "Usage",
 CellID->28188]
}, Open  ]],
Cell[CellGroupData[{
Cell[8359, 234, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8837, 251, 626, 23, 70, "Notes",
 CellID->1790],
Cell[9466, 276, 631, 23, 70, "Notes",
 CellID->27993],
Cell[10100, 301, 473, 15, 70, "Notes",
 CellID->13429],
Cell[10576, 318, 366, 13, 70, "Notes",
 CellID->2319]
}, Closed]],
Cell[CellGroupData[{
Cell[10979, 336, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49462664],
Cell[CellGroupData[{
Cell[11363, 350, 148, 5, 70, "ExampleSection",
 CellID->590785646],
Cell[11514, 357, 108, 3, 70, "ExampleText",
 CellID->22841],
Cell[CellGroupData[{
Cell[11647, 364, 162, 5, 28, "Input",
 CellID->19832],
Cell[11812, 371, 408, 11, 36, "Output",
 CellID->21423818]
}, Open  ]],
Cell[12235, 385, 120, 3, 70, "ExampleDelimiter",
 CellID->2059],
Cell[12358, 390, 69, 1, 70, "ExampleText",
 CellID->21867],
Cell[CellGroupData[{
Cell[12452, 395, 137, 4, 70, "Input",
 CellID->12178],
Cell[12592, 401, 292, 9, 36, "Output",
 CellID->489877454]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12933, 416, 216, 7, 70, "ExampleSection",
 CellID->16474],
Cell[13152, 425, 74, 1, 70, "ExampleText",
 CellID->8067],
Cell[CellGroupData[{
Cell[13251, 430, 253, 8, 70, "Input",
 CellID->21394],
Cell[13507, 440, 309, 10, 51, "Output",
 CellID->543100236]
}, Open  ]],
Cell[13831, 453, 124, 3, 70, "ExampleDelimiter",
 CellID->19646854],
Cell[13958, 458, 139, 4, 70, "ExampleText",
 CellID->31137],
Cell[CellGroupData[{
Cell[14122, 466, 223, 7, 70, "Input",
 CellID->10804],
Cell[14348, 475, 300, 9, 36, "Output",
 CellID->77650544]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14697, 490, 223, 7, 70, "ExampleSection",
 CellID->32327],
Cell[14923, 499, 88, 1, 70, "ExampleText",
 CellID->20317],
Cell[CellGroupData[{
Cell[15036, 504, 484, 16, 70, "Input",
 CellID->27385],
Cell[15523, 522, 638, 15, 70, "Output",
 Evaluatable->False,
 CellID->44507986]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16210, 543, 233, 7, 70, "ExampleSection",
 CellID->29225],
Cell[16446, 552, 219, 8, 70, "ExampleText",
 CellID->27733],
Cell[CellGroupData[{
Cell[16690, 564, 260, 8, 70, "Input",
 CellID->3993],
Cell[16953, 574, 486, 15, 36, "Output",
 CellID->211174364]
}, Open  ]],
Cell[CellGroupData[{
Cell[17476, 594, 397, 12, 70, "Input",
 CellID->18108],
Cell[17876, 608, 486, 15, 36, "Output",
 CellID->790847120]
}, Open  ]],
Cell[18377, 626, 120, 3, 70, "ExampleDelimiter",
 CellID->2305],
Cell[18500, 631, 363, 13, 70, "ExampleText",
 CellID->8548],
Cell[CellGroupData[{
Cell[18888, 648, 301, 9, 70, "Input",
 CellID->2192],
Cell[19192, 659, 486, 15, 36, "Output",
 CellID->155170509]
}, Open  ]],
Cell[19693, 677, 120, 3, 70, "ExampleDelimiter",
 CellID->5393],
Cell[19816, 682, 360, 12, 70, "ExampleText",
 CellID->1682669],
Cell[CellGroupData[{
Cell[20201, 698, 433, 15, 70, "Input",
 CellID->240177050],
Cell[20637, 715, 436, 15, 36, "Output",
 CellID->220732894]
}, Open  ]],
Cell[CellGroupData[{
Cell[21110, 735, 292, 10, 70, "Input",
 CellID->933502685],
Cell[21405, 747, 436, 15, 36, "Output",
 CellID->354248708]
}, Open  ]],
Cell[CellGroupData[{
Cell[21878, 767, 534, 18, 70, "Input",
 CellID->8720075],
Cell[22415, 787, 430, 15, 36, "Output",
 CellID->232517436]
}, Open  ]],
Cell[CellGroupData[{
Cell[22882, 807, 386, 13, 70, "Input",
 CellID->171548510],
Cell[23271, 822, 430, 15, 36, "Output",
 CellID->182108052]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23750, 843, 226, 7, 70, "ExampleSection",
 CellID->29565],
Cell[23979, 852, 132, 4, 70, "ExampleText",
 CellID->18542],
Cell[CellGroupData[{
Cell[24136, 860, 199, 7, 70, "Input",
 CellID->23059],
Cell[24338, 869, 364, 7, 70, "Message",
 CellID->322875486],
Cell[24705, 878, 292, 10, 36, "Output",
 CellID->533565205]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25058, 895, 309, 9, 70, "SeeAlsoSection",
 CellID->958],
Cell[25370, 906, 1465, 53, 70, "SeeAlso",
 CellID->14228]
}, Open  ]],
Cell[CellGroupData[{
Cell[26872, 964, 313, 9, 70, "TutorialsSection",
 CellID->1062],
Cell[27188, 975, 160, 3, 70, "Tutorials",
 CellID->86049371]
}, Open  ]],
Cell[CellGroupData[{
Cell[27385, 983, 305, 8, 70, "RelatedLinksSection"],
Cell[27693, 993, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28099, 1010, 318, 9, 70, "MoreAboutSection",
 CellID->82739100],
Cell[28420, 1021, 150, 3, 70, "MoreAbout",
 CellID->17579734],
Cell[28573, 1026, 158, 3, 70, "MoreAbout",
 CellID->264192743],
Cell[28734, 1031, 177, 3, 70, "MoreAbout",
 CellID->388237660],
Cell[28914, 1036, 164, 3, 70, "MoreAbout",
 CellID->357459255],
Cell[29081, 1041, 179, 3, 70, "MoreAbout",
 CellID->426017639],
Cell[29263, 1046, 151, 3, 70, "MoreAbout",
 CellID->250827083]
}, Open  ]],
Cell[29429, 1052, 27, 0, 70, "History"],
Cell[29459, 1054, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

