(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36605,       1406]
NotebookOptionsPosition[     28144,       1109]
NotebookOutlinePosition[     29577,       1149]
CellTagsIndexPosition[     29491,       1144]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Making Tables of Values" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MakingTablesOfValues"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Making Tables of Values\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Table" :> Documentation`HelpLookup["paclet:ref/Table"], 
          "ConstantArray" :> 
          Documentation`HelpLookup["paclet:ref/ConstantArray"], "Interval" :> 
          Documentation`HelpLookup["paclet:ref/Interval"], "CharacterRange" :> 
          Documentation`HelpLookup["paclet:ref/CharacterRange"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Table\"\>", 
       2->"\<\"ConstantArray\"\>", 3->"\<\"Interval\"\>", 
       4->"\<\"CharacterRange\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Range", "ObjectName",
 CellID->5234],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Range",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Range"], "[", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates the list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Range",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Range"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates the list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Range",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Range"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]], ",", 
        StyleBox["di", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses step ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->30556]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The arguments to ",
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 " need not be integers. "
}], "Notes",
 CellID->10495],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 " starts from ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 ", and successively adds increments of ",
 Cell[BoxData[
  StyleBox["di", "TI"]], "InlineFormula"],
 " until the result is greater than ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13988],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 " uses the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " iteration specification, as applied to a single variable. "
}], "Notes",
 CellID->20731]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->79498037],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->18617474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", "4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27109],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13845]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"1.2", ",", "2.2", ",", "0.15"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1562],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.2`", ",", "1.3499999999999999`", ",", "1.5`", ",", "1.65`", ",", 
   "1.7999999999999998`", ",", "1.95`", ",", "2.1`"}], "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->594499731]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"x", ",", 
   RowBox[{"x", "+", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16642],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"1", "+", "x"}], ",", 
   RowBox[{"2", "+", "x"}], ",", 
   RowBox[{"3", "+", "x"}], ",", 
   RowBox[{"4", "+", "x"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21290]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29082345],

Cell["Use a step of 2:", "ExampleText",
 CellID->564757765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"1", ",", "10", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434129285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "5", ",", "7", ",", "9"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195609464]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11766702],

Cell["Use a negative step:", "ExampleText",
 CellID->5533965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"10", ",", "1", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->577444819],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10", ",", "9", ",", "8", ",", "7", ",", "6", ",", "5", ",", "4", ",", "3", 
   ",", "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->567621513]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->394337865],

Cell["Use an exact numeric valued step:", "ExampleText",
 CellID->156791218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"0", ",", "10", ",", "\[Pi]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "\[Pi]", ",", 
   RowBox[{"2", " ", "\[Pi]"}], ",", 
   RowBox[{"3", " ", "\[Pi]"}]}], "}"}]], "Output",
 ImageSize->{103, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4367111]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141298502],

Cell["Use a machine number step:", "ExampleText",
 CellID->668795808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"0", ",", "10", ",", 
   RowBox[{"N", "[", "\[Pi]", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15200458],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "3.141592653589793`", ",", "6.283185307179586`", ",", 
   "9.42477796076938`"}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->733603458]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->595691025],

Cell["Use a precision 24 step:", "ExampleText",
 CellID->207845559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"0", ",", "10", ",", " ", 
   RowBox[{"N", "[", 
    RowBox[{"\[Pi]", ",", " ", "24"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->344614415],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "3.1415926535897932384626433832795028842`24.", ",", 
   "6.2831853071795864769252867665590057684`24.", ",", 
   "9.42477796076937971538793014983850865259`23.999999999999996"}], 
  "}"}]], "Output",
 ImageSize->{584, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71061522]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43401705],

Cell["Range of very large numbers:", "ExampleText",
 CellID->74362390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{
   RowBox[{"2", "^", "225"}], ",", 
   RowBox[{
    RowBox[{"2", "^", "225"}], " ", "+", " ", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112956938],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "53919893334301279589334030174039261347274288845081144962207220498432", ",",
    "53919893334301279589334030174039261347274288845081144962207220498433", 
   ",", "53919893334301279589334030174039261347274288845081144962207220498434"\
, ",", "53919893334301279589334030174039261347274288845081144962207220498435",
    ",", "53919893334301279589334030174039261347274288845081144962207220498436\
", ",", "53919893334301279589334030174039261347274288845081144962207220498437"\
}], "}"}]], "Output",
 ImageSize->{541, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->256823332]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->269392993],

Cell["Use a symbolic step:", "ExampleText",
 CellID->742464095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"a", ",", "b", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "-", "a"}], ")"}], "/", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74021059],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"a", "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}], ")"}]}]}], ",", 
   RowBox[{"a", "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}], ")"}]}]}], ",", 
   RowBox[{"a", "+", 
    RowBox[{
     FractionBox["3", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}], ")"}]}]}], ",", "b"}], "}"}]], "Output",\

 ImageSize->{323, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202141099]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->239216592],

Cell["Produce a geometric sequence:", "ExampleText",
 CellID->316276007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "^", 
  RowBox[{"Range", "[", "5", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->444297053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"q", ",", 
   SuperscriptBox["q", "2"], ",", 
   SuperscriptBox["q", "3"], ",", 
   SuperscriptBox["q", "4"], ",", 
   SuperscriptBox["q", "5"]}], "}"}]], "Output",
 ImageSize->{120, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22046746]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->231530045],

Cell["Form a polynomial from coefficients:", "ExampleText",
 CellID->40579370],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeff", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "9", ",", "5", ",", "3", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "6"}], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "4"}], ",", "8", ",", "3"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46728706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"poly", " ", "=", " ", 
  RowBox[{"coeff", ".", 
   RowBox[{"x", "^", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"Length", "[", "coeff", "]"}], "-", "1"}]}], 
     "]"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->297577913],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", 
  RowBox[{"9", " ", "x"}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "4"]}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "5"]}], "-", 
  RowBox[{"7", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "9"]}]}]], "Output",
 ImageSize->{330, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1674195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14121249],

Cell["Form a random permutation:", "ExampleText",
 CellID->651353183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomSample", "[", 
  RowBox[{"Range", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->541575160],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10", ",", "6", ",", "8", ",", "1", ",", "9", ",", "7", ",", "3", ",", "5", 
   ",", "4", ",", "2"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35039490]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->126618915],

Cell["Find an inverse permutation:", "ExampleText",
 CellID->302291722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"perm", " ", "=", " ", 
  RowBox[{"RandomSample", "[", 
   RowBox[{"Range", "[", "10", "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->695016472],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "2", ",", "8", ",", "1", ",", "10", ",", "5", ",", "3", ",", "6", 
   ",", "9", ",", "7"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->437020884]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"inverse", " ", "=", " ", "perm"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"inverse", "[", 
    RowBox[{"[", "perm", "]"}], "]"}], "=", 
   RowBox[{"Range", "[", 
    RowBox[{"Length", "[", "perm", "]"}], "]"}]}], 
  ";"}], "\n", "inverse"}], "Input",
 CellLabel->"In[2]:=",
 CellID->244290653],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "2", ",", "7", ",", "1", ",", "6", ",", "8", ",", "10", ",", "3", 
   ",", "9", ",", "5"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->110185318]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->242376443],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Range"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["min", "TI"]], ",", " ", 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["max", "TI"]], ",", 
    StyleBox["di", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"], "[", 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]], ",", " ", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]], ",", 
      StyleBox["di", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->341760817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{
   RowBox[{"-", "4"}], ",", "9", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->473707249],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4"}], ",", 
   RowBox[{"-", "1"}], ",", "2", ",", "5", ",", "8"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->679290539]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"i", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"-", "4"}], ",", "9", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->564176965],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4"}], ",", 
   RowBox[{"-", "1"}], ",", "2", ",", "5", ",", "8"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->288996028]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96609448],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Span",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Span"]], "InlineFormula"],
 " (;;) as ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " specification: "
}], "ExampleText",
 CellID->178980981],

Cell[BoxData[
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->499328818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", "[", 
  RowBox[{"[", 
   RowBox[{"Range", "[", 
    RowBox[{"1", ",", "5", ",", "2"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->164043317],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "c", ",", "e"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6239254]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", "[", 
  RowBox[{"[", 
   RowBox[{"1", ";;", "5", ";;", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->451415798],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "c", ",", "e"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->154866084]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23437],

Cell[TextData[{
 "For some step sizes, ",
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 " may not include the upper limit given:"
}], "ExampleText",
 CellID->959781159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"0", ",", "10", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251244227],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "3", ",", "6", ",", "9"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299908039]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11500730],

Cell["\<\
Even though the lower limit was exact, the inexact step makes the first \
element inexact:\
\>", "ExampleText",
 CellID->156780381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"0", ",", "1", ",", ".1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81153359],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.1`", ",", "0.2`", ",", "0.30000000000000004`", ",", "0.4`", 
   ",", "0.5`", ",", "0.6000000000000001`", ",", "0.7000000000000001`", ",", 
   "0.8`", ",", "0.9`", ",", "1.`"}], "}"}]], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->540417049]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23295],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConstantArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConstantArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interval"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterRange"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31934]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30548],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->9885],

Cell[TextData[ButtonBox["Making Tables of Values",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingTablesOfValues"]], "Tutorials",
 CellID->3789]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->410995158],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->3699758],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->235906208]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Range"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Range - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 54.5784192}", "context" -> "System`", 
    "keywords" -> {
     "index in APL", "iota in APL", "sequence", "span", "arithmetic sequence",
       "geometric sequence", "iterator", "generating lists", 
      "list constructor"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Range[i_max] generates the list {1, 2, ..., i_max}. Range[i_min, i_max] \
generates the list {i_min, ..., i_max}. Range[i_min, i_max, di] uses step \
di.", "synonyms" -> {}, "title" -> "Range", "type" -> "Symbol", "uri" -> 
    "ref/Range"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6657, 224, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->79498037]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29349, 1137}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2353, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2976, 82, 42, 1, 70, "ObjectName",
 CellID->5234],
Cell[3021, 85, 2054, 70, 70, "Usage",
 CellID->30556]
}, Open  ]],
Cell[CellGroupData[{
Cell[5112, 160, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5590, 177, 206, 8, 70, "Notes",
 CellID->10495],
Cell[5799, 187, 525, 20, 70, "Notes",
 CellID->13988],
Cell[6327, 209, 293, 10, 70, "Notes",
 CellID->20731]
}, Closed]],
Cell[CellGroupData[{
Cell[6657, 224, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->79498037],
Cell[CellGroupData[{
Cell[7041, 238, 147, 5, 70, "ExampleSection",
 CellID->18617474],
Cell[CellGroupData[{
Cell[7213, 247, 97, 3, 28, "Input",
 CellID->27109],
Cell[7313, 252, 219, 7, 36, "Output",
 CellID->13845]
}, Open  ]],
Cell[7547, 262, 121, 3, 70, "ExampleDelimiter",
 CellID->14587],
Cell[CellGroupData[{
Cell[7693, 269, 136, 4, 28, "Input",
 CellID->1562],
Cell[7832, 275, 314, 9, 36, "Output",
 CellID->594499731]
}, Open  ]],
Cell[8161, 287, 121, 3, 70, "ExampleDelimiter",
 CellID->16519],
Cell[CellGroupData[{
Cell[8307, 294, 144, 5, 70, "Input",
 CellID->16642],
Cell[8454, 301, 326, 11, 36, "Output",
 CellID->21290]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8829, 318, 219, 7, 70, "ExampleSection",
 CellID->29082345],
Cell[9051, 327, 59, 1, 70, "ExampleText",
 CellID->564757765],
Cell[CellGroupData[{
Cell[9135, 332, 135, 4, 70, "Input",
 CellID->434129285],
Cell[9273, 338, 233, 7, 36, "Output",
 CellID->195609464]
}, Open  ]],
Cell[9521, 348, 124, 3, 70, "ExampleDelimiter",
 CellID->11766702],
Cell[9648, 353, 61, 1, 70, "ExampleText",
 CellID->5533965],
Cell[CellGroupData[{
Cell[9734, 358, 154, 5, 70, "Input",
 CellID->577444819],
Cell[9891, 365, 292, 9, 36, "Output",
 CellID->567621513]
}, Open  ]],
Cell[10198, 377, 125, 3, 70, "ExampleDelimiter",
 CellID->394337865],
Cell[10326, 382, 76, 1, 70, "ExampleText",
 CellID->156791218],
Cell[CellGroupData[{
Cell[10427, 387, 136, 4, 70, "Input",
 CellID->221940],
Cell[10566, 393, 282, 9, 36, "Output",
 CellID->4367111]
}, Open  ]],
Cell[10863, 405, 125, 3, 70, "ExampleDelimiter",
 CellID->141298502],
Cell[10991, 410, 69, 1, 70, "ExampleText",
 CellID->668795808],
Cell[CellGroupData[{
Cell[11085, 415, 167, 5, 70, "Input",
 CellID->15200458],
Cell[11255, 422, 283, 9, 36, "Output",
 CellID->733603458]
}, Open  ]],
Cell[11553, 434, 125, 3, 70, "ExampleDelimiter",
 CellID->595691025],
Cell[11681, 439, 67, 1, 70, "ExampleText",
 CellID->207845559],
Cell[CellGroupData[{
Cell[11773, 444, 204, 6, 70, "Input",
 CellID->344614415],
Cell[11980, 452, 379, 11, 36, "Output",
 CellID->71061522]
}, Open  ]],
Cell[12374, 466, 124, 3, 70, "ExampleDelimiter",
 CellID->43401705],
Cell[12501, 471, 70, 1, 70, "ExampleText",
 CellID->74362390],
Cell[CellGroupData[{
Cell[12596, 476, 211, 7, 70, "Input",
 CellID->112956938],
Cell[12810, 485, 668, 14, 122, "Output",
 CellID->256823332]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13527, 505, 243, 7, 70, "ExampleSection",
 CellID->269392993],
Cell[13773, 514, 63, 1, 70, "ExampleText",
 CellID->742464095],
Cell[CellGroupData[{
Cell[13861, 519, 208, 7, 70, "Input",
 CellID->74021059],
Cell[14072, 528, 683, 26, 51, "Output",
 CellID->202141099]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14804, 560, 227, 7, 70, "ExampleSection",
 CellID->239216592],
Cell[15034, 569, 72, 1, 70, "ExampleText",
 CellID->316276007],
Cell[CellGroupData[{
Cell[15131, 574, 124, 4, 70, "Input",
 CellID->444297053],
Cell[15258, 580, 333, 11, 39, "Output",
 CellID->22046746]
}, Open  ]],
Cell[15606, 594, 125, 3, 70, "ExampleDelimiter",
 CellID->231530045],
Cell[15734, 599, 78, 1, 70, "ExampleText",
 CellID->40579370],
Cell[15815, 602, 357, 11, 70, "Input",
 CellID->46728706],
Cell[CellGroupData[{
Cell[16197, 617, 291, 10, 70, "Input",
 CellID->297577913],
Cell[16491, 629, 684, 24, 36, "Output",
 CellID->1674195]
}, Open  ]],
Cell[17190, 656, 124, 3, 70, "ExampleDelimiter",
 CellID->14121249],
Cell[17317, 661, 69, 1, 70, "ExampleText",
 CellID->651353183],
Cell[CellGroupData[{
Cell[17411, 666, 141, 4, 70, "Input",
 CellID->541575160],
Cell[17555, 672, 291, 9, 36, "Output",
 CellID->35039490]
}, Open  ]],
Cell[17861, 684, 125, 3, 70, "ExampleDelimiter",
 CellID->126618915],
Cell[17989, 689, 71, 1, 70, "ExampleText",
 CellID->302291722],
Cell[CellGroupData[{
Cell[18085, 694, 178, 5, 70, "Input",
 CellID->695016472],
Cell[18266, 701, 292, 9, 36, "Output",
 CellID->437020884]
}, Open  ]],
Cell[CellGroupData[{
Cell[18595, 715, 336, 11, 70, "Input",
 CellID->244290653],
Cell[18934, 728, 292, 9, 36, "Output",
 CellID->110185318]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19275, 743, 237, 7, 70, "ExampleSection",
 CellID->242376443],
Cell[19515, 752, 858, 33, 70, "ExampleText",
 CellID->341760817],
Cell[CellGroupData[{
Cell[20398, 789, 153, 5, 70, "Input",
 CellID->473707249],
Cell[20554, 796, 272, 9, 36, "Output",
 CellID->679290539]
}, Open  ]],
Cell[CellGroupData[{
Cell[20863, 810, 214, 7, 70, "Input",
 CellID->564176965],
Cell[21080, 819, 272, 9, 36, "Output",
 CellID->288996028]
}, Open  ]],
Cell[21367, 831, 124, 3, 70, "ExampleDelimiter",
 CellID->96609448],
Cell[21494, 836, 441, 18, 70, "ExampleText",
 CellID->178980981],
Cell[21938, 856, 195, 7, 70, "Input",
 CellID->499328818],
Cell[CellGroupData[{
Cell[22158, 867, 191, 6, 70, "Input",
 CellID->164043317],
Cell[22352, 875, 211, 7, 36, "Output",
 CellID->6239254]
}, Open  ]],
Cell[CellGroupData[{
Cell[22600, 887, 159, 5, 70, "Input",
 CellID->451415798],
Cell[22762, 894, 213, 7, 36, "Output",
 CellID->154866084]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23024, 907, 226, 7, 70, "ExampleSection",
 CellID->23437],
Cell[23253, 916, 236, 8, 70, "ExampleText",
 CellID->959781159],
Cell[CellGroupData[{
Cell[23514, 928, 135, 4, 70, "Input",
 CellID->251244227],
Cell[23652, 934, 223, 7, 36, "Output",
 CellID->299908039]
}, Open  ]],
Cell[23890, 944, 124, 3, 70, "ExampleDelimiter",
 CellID->11500730],
Cell[24017, 949, 141, 4, 70, "ExampleText",
 CellID->156780381],
Cell[CellGroupData[{
Cell[24183, 957, 134, 4, 70, "Input",
 CellID->81153359],
Cell[24320, 963, 382, 10, 36, "Output",
 CellID->540417049]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24763, 980, 311, 9, 70, "SeeAlsoSection",
 CellID->23295],
Cell[25077, 991, 957, 35, 70, "SeeAlso",
 CellID->31934]
}, Open  ]],
Cell[CellGroupData[{
Cell[26071, 1031, 314, 9, 70, "TutorialsSection",
 CellID->30548],
Cell[26388, 1042, 148, 3, 70, "Tutorials",
 CellID->9885],
Cell[26539, 1047, 153, 3, 70, "Tutorials",
 CellID->3789]
}, Open  ]],
Cell[CellGroupData[{
Cell[26729, 1055, 319, 9, 70, "MoreAboutSection",
 CellID->410995158],
Cell[27051, 1066, 145, 3, 70, "MoreAbout",
 CellID->3699758],
Cell[27199, 1071, 145, 3, 70, "MoreAbout",
 CellID->235906208]
}, Open  ]],
Cell[CellGroupData[{
Cell[27381, 1079, 305, 8, 70, "RelatedLinksSection"],
Cell[27689, 1089, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[28087, 1105, 27, 0, 70, "History"],
Cell[28117, 1107, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

