(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20641,        660]
NotebookOptionsPosition[     17413,        554]
NotebookOutlinePosition[     18774,        592]
CellTagsIndexPosition[     18689,        587]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ImageSize" :> Documentation`HelpLookup["paclet:ref/ImageSize"], 
         "ImageResolution" :> 
         Documentation`HelpLookup["paclet:ref/ImageResolution"], 
         "PixelConstrained" :> 
         Documentation`HelpLookup["paclet:ref/PixelConstrained"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"ImageSize\"\>", 
      2->"\<\"ImageResolution\"\>", 
      3->"\<\"PixelConstrained\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RasterSize", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["RasterSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RasterSize"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Rasterize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Rasterize"]], "InlineFormula"],
     " which determines the absolute pixel size of the raster generated."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["w", "TI"], Cell[TextData[{
     "width ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " pixels"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["w", "TI"], ",", 
      StyleBox["h", "TI"]}], "}"}], Cell[
    "explicit pixel width and height ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox[
        StyleBox["w", "TI"], 
        StyleBox["max", "TI"]], "}"}], ",", 
      RowBox[{"{", 
       SubscriptBox[
        StyleBox["h", "TI"], 
        StyleBox["max", "TI"]], "}"}]}], "}"}], Cell[
    "pixel width and height maximums", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["w", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["w", "TI"], 
         StyleBox["max", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["h", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["h", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "}"}], Cell[
    "pixel width and height ranges", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->21370],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"RasterSize", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["w", "TI"], ",", 
     StyleBox["h", "TI"]}], "}"}]}]], "InlineFormula"],
 " a ",
 Cell[BoxData[
  FormBox["w", TraditionalForm]], "InlineMath"],
 "\[Times]",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " raster will always be generated, with the object being rendered sized to \
fit in it."
}], "Notes",
 CellID->10068],

Cell[TextData[{
 "If the object has a definite aspect ratio that is not ",
 Cell[BoxData[
  FormBox[
   RowBox[{"w", "/", "h"}], TraditionalForm]], "InlineMath"],
 ", then space will be left around it."
}], "Notes",
 CellID->6906],

Cell[TextData[{
 "The position of the object within the ",
 Cell[BoxData[
  FormBox["w", TraditionalForm]], "InlineMath"],
 "\[Times]",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " region is determined by the setting for the object's ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " option."
}], "Notes",
 CellID->12707],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"RasterSize", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["max", "TI"]], "}"}], ",", 
     RowBox[{"{", 
      SubscriptBox[
       StyleBox["h", "TI"], 
       StyleBox["max", "TI"]], "}"}]}], "}"}]}]], "InlineFormula"],
 ", an object is sized so that its width and height are as large as possible \
while not exceeding the specified maximums."
}], "Notes",
 CellID->26956],

Cell["\<\
No extra space is then left around the object, so that the region in which \
the object is drawn is always the same shape as the object itself. \
\>", "Notes",
 CellID->7701],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"RasterSize", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["w", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["w", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["h", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["h", "TI"], 
        StyleBox["max", "TI"]]}], "}"}]}], "}"}]}]], "InlineFormula"],
 ", the object is sized to be as large as possible while not exceeding \
specified maximums, with extra space being left if necessary in order to \
satisfy the minimums."
}], "Notes",
 CellID->23494]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44845496],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->123942384],

Cell["Set different raster sizes in pixel:", "ExampleText",
 CellID->19030806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Rasterize", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ",", "40"}], "]"}], ",", 
     RowBox[{"RasterSize", "\[Rule]", "r"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "50", ",", "200"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->357716098],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDgAWIZIAax/w8esL+EAQxK9lNgxpw59zEE53hgNxJsocec
/XM8wDSJZgJ1YApDpRjwGAjzJljJfWRxIBePU0tKSvAHDaY795eANUApFHAf
5EqghWDX4DYW3UxokBHShlCL4U1CgKAukALSkwhBXfsJhC5puu5DEwFpfidP
F0kAAN5lciU=
     "], {{0, 0}, {118.53333333333336`, 50.80000000000001}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{118.53333333333336`, 50.80000000000001},
    PlotRange->{{0, 118.53333333333336`}, {0, 50.80000000000001}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztlsENwyAMRZG6QTfoENmBc0fIAr0wDrt4lIySYmiCaWljO3Jy6ZeQOMT6
nwe2chsf9/HinLumNaSF+/mvRRAcVYCzA/WVYvo4nZ3iu6bouewq8XwirNTC
h8hkkk3YAPPXNQwGVsHnxkODEILk/K9Mb0kt4qGFj2kTvQxCQS5ORd5D8076
yuhg2bJJFHykWC4GvRVdEbNF6JWWnDbxPk6fZ8xmSa9z5RA34rVGM/FS31f7
rgyHqdZI2S9yqY12TZtjjHa19CFGAJoqW6M6Oo3/M7RGZB4YJfth9ARY3ike

     "], {{0, 0}, {134.62, 45.72}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{134.62, 45.72},
    PlotRange->{{0, 134.62}, {0, 45.72}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztnUFugzAURJF6kl6myrpHyAW6yXFyF7a9BUehoSEEiMH2B8fjYZ4UqYtQ
/c+MB2OH5PP8833+qKrq6/b6vb26v1shhBBCCCGEENu4nqp4Ttcmd90CmcZk
KxlL+FBeiXczpNnpmrsUQUV96RPqUucuRTChyBJpUGSJJCiyRBoUWSIJiiyR
BkWWSAJqZPnXdZcL3nKs2IchsKAiK2gfamF3YMuxYicmGiCNYuXVGv3YQR0d
o7C6AxRZd8YVWovb43+Age2rYVxfLo9TDziQx9e1eFuMTAWqggVkX9UTLz09
Vucu7JWxtWKcz2mqFtpXcyPVwJHVWqw1OaBJXN6bgfWVy0XQkdUxiZ/1t266
duKD6iu3hcAjqyNkDk44T5+D6atl/8BHVsdqFkVkWsFA+mrNPAVEVod77mSd
3pcHoK98zikistrXe71tyxGFgecrv20KiazWsax7DFO1eL4K80wpkdW+Wgu/
4gDc48XGW05IqGHKiayZBhS2Ks1XMW4pIrKcn1yAuTakBOk6GGcV+Miaz9Np
92xc4Pgq3ifIkeW++TvAgmgPjK8sJkGNrDX7HGS1AcRXVocARpb/cncEa2H4
ym4PsMgK/YgC/cI7gq+2eeP5WEWzd2HGSgLHB/VGIYCvtl7LIJ4Es83Ieefx
2X21x4Usd2RtSh7OyVZuX+0z8c4VWevrztbncRjslctXnmfovKfWp2jzhh68
2xkLZXh3QRa6N353ZpbJWyZfWU9t6PGzflIpYswrT/VLvZfkq1wYT23g8fNh
wqHIo4vQEBgyI21ZB4ZGkbiJ5P+786+/UEOjSJP77lfMoFGEphEaeBSBWA0W
I2gUGQZJ6Y3QQKMITSM08CjyyF+8u9ejQqMITSM00ChC0wgNPIoMq7+5CxE9
NIrQNEIDjSI0jdBAowhNIzSwKNJPGovfVuCBRRGWPnhgUST3owtiDoci/ZZC
8RsKPAArcgvTyE8nInbBBIMiUYX113O8LpggUSTiORfcJqhgUWS4qwh6G2gT
VJAoEvBDnzQfXSwDGkVWvukI82dA6eFRBOKJbzGCSRFHLyUMCmKMivwBwRK4
VQ==
     "], {{0, 0}, {127., 44.45}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{127., 44.45},
    PlotRange->{{0, 127.}, {0, 44.45}}]}], "}"}]], "Output",
 ImageSize->{422, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27857261]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RasterSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RasterSize"]], "InlineFormula"],
 " overrides ",
 Cell[BoxData[
  ButtonBox["ImageResolution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageResolution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->182039707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Rasterize", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ",", "50"}], "]"}], ",", 
     RowBox[{"RasterSize", "\[Rule]", "100"}]}], "]"}], ",", 
   RowBox[{"Rasterize", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ",", "50"}], "]"}], ",", 
     RowBox[{"ImageResolution", "\[Rule]", "20"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->482299855],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJztmF0OgyAQhE16kqaX8blHsAfoi8fxLh6Fo1gWrEEF/GFYuw2TmJi2kZ2P
KQvem/ezuVVV9dDXS190PxQVFfnVt1VQdaeuLu931dUE6OoqJMhErO2vLkOC
Sqj2qoRqt4Ch8nQLZw7i36KlRwM/nUAhS7Y8Il3U/iB3itGgpmlGrlRhVspM
C8eqiAVlHGlDpvwMEzBnxUdpwIJy+IzEQA+2mrNipTRAQc3gZAgVaaTTM1Ma
gKBWZHKEimSbRW5KseNZUpP1YMkSKjVyYj9NYhIVYIIOlbMujXcK9uwtQUAF
gSBDtVq90Ru2uACgojRAofp2vMXHjKzSQW2gAIQquvXmYpUKStmjnYoPcTpU
q+bjFDst656zQKRpnbSbAmpZzZJXyCXehb+09cNoWgW92uBxsSPrAsTkgqZE
PCsmF4XVsVEkLU1+8bgorI6NUv6Du2Q6iPhYsbig+RBPCuzCuykTtuFkceHD
Lm+ZYnGxOGPmeuOaWUwuZsdKUX86V//h4nJ9ABKW5l0=
     "], {{0, 0}, {157.41, 55.64999999999999}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{157.41, 55.64999999999999},
    PlotRange->{{0, 157.41}, {0, 55.64999999999999}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzdlc0JwzAMhQWdoCP03EV07ghZoBePo108ikdp/VM5uJDoqTgEKjAooDx9
flHs2/J8LBciuuZ1z6vkr7+MJEw9WNJpIMIHd48hRKOAjIrVrVKY612uIQAm
QWNgaXlNse4AQPkEEhDB7gPWfRiyzdfUf2HbBJV0zsyuA+sERsuEpMZXDAAX
AEjDvvdMUDsLgeYowybAZ5rbxvsDJvqlQS6iuZrVjkmtf9aszJMh3JoxzgUA
NVP5jVqxfZ6C4dR0nk4owvl35BhvilG5Yg==
     "], {{0, 0}, {154.8, 61.2}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{154.8, 61.2},
    PlotRange->{{0, 154.8}, {0, 61.2}}]}], "}"}]], "Output",
 ImageSize->{342, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94644737]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", "50"}], "]"}], ",", 
   RowBox[{"RasterSize", "\[Rule]", "100"}], ",", 
   RowBox[{"ImageResolution", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->961760909],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmF0OgyAQhE16kqaX8blHsAfoi8fxLh6Fo1gWrEEF/GFYuw2TmJi2kZ2P
KQvem/ezuVVV9dDXS190PxQVFfnVt1VQdaeuLu931dUE6OoqJMhErO2vLkOC
Sqj2qoRqt4Ch8nQLZw7i36KlRwM/nUAhS7Y8Il3U/iB3itGgpmlGrlRhVspM
C8eqiAVlHGlDpvwMEzBnxUdpwIJy+IzEQA+2mrNipTRAQc3gZAgVaaTTM1Ma
gKBWZHKEimSbRW5KseNZUpP1YMkSKjVyYj9NYhIVYIIOlbMujXcK9uwtQUAF
gSBDtVq90Ru2uACgojRAofp2vMXHjKzSQW2gAIQquvXmYpUKStmjnYoPcTpU
q+bjFDst656zQKRpnbSbAmpZzZJXyCXehb+09cNoWgW92uBxsSPrAsTkgqZE
PCsmF4XVsVEkLU1+8bgorI6NUv6Du2Q6iPhYsbig+RBPCuzCuykTtuFkceHD
Lm+ZYnGxOGPmeuOaWUwuZsdKUX86V//h4nJ9ABKW5l0=
   "], {{0, 0}, {157.41, 55.64999999999999}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{157.41, 55.64999999999999},
  PlotRange->{{0, 157.41}, {0, 55.64999999999999}}]], "Output",
 ImageSize->{161, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->250603838]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageResolution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageResolution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PixelConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PixelConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RasterSize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 12.7663848}", "context" -> "System`", 
    "keywords" -> {
     "sample count", "raster samples", "raster dimensions", 
      "pixel dimensions", "pixel size", "pixel count"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RasterSize is an option for Rasterize which determines the absolute \
pixel size of the raster generated.", "synonyms" -> {"raster size"}, "title" -> 
    "RasterSize", "type" -> "Symbol", "uri" -> "ref/RasterSize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8609, 285, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->44845496]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18547, 580}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 822, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1445, 46, 1575, 37, 70, "ObjectNameGrid"],
Cell[3023, 85, 621, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3681, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4159, 125, 74, 1, 70, "Notes",
 CellID->1067943069],
Cell[4236, 128, 1758, 55, 70, "2ColumnTableMod",
 CellID->21370],
Cell[5997, 185, 457, 17, 70, "Notes",
 CellID->10068],
Cell[6457, 204, 230, 7, 70, "Notes",
 CellID->6906],
Cell[6690, 213, 420, 14, 70, "Notes",
 CellID->12707],
Cell[7113, 229, 502, 17, 70, "Notes",
 CellID->26956],
Cell[7618, 248, 184, 4, 70, "Notes",
 CellID->7701],
Cell[7805, 254, 767, 26, 70, "Notes",
 CellID->23494]
}, Closed]],
Cell[CellGroupData[{
Cell[8609, 285, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44845496],
Cell[CellGroupData[{
Cell[8993, 299, 148, 5, 70, "ExampleSection",
 CellID->123942384],
Cell[9144, 306, 78, 1, 70, "ExampleText",
 CellID->19030806],
Cell[CellGroupData[{
Cell[9247, 311, 494, 17, 28, "Input",
 CellID->357716098],
Cell[9744, 330, 2463, 51, 74, "Output",
 CellID->27857261]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12256, 387, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[12497, 396, 331, 12, 70, "ExampleText",
 CellID->182039707],
Cell[CellGroupData[{
Cell[12853, 412, 629, 21, 70, "Input",
 CellID->482299855],
Cell[13485, 435, 1431, 31, 84, "Output",
 CellID->94644737]
}, Open  ]],
Cell[CellGroupData[{
Cell[14953, 471, 363, 11, 70, "Input",
 CellID->961760909],
Cell[15319, 484, 910, 19, 77, "Output",
 CellID->250603838]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16290, 510, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[16609, 521, 732, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[17356, 550, 27, 0, 70, "History"],
Cell[17386, 552, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

