(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    238997,       5246]
NotebookOptionsPosition[    227083,       4835]
NotebookOutlinePosition[    228460,       4874]
CellTagsIndexPosition[    228373,       4869]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Export" :> Documentation`HelpLookup["paclet:ref/Export"], 
          "ExportString" :> 
          Documentation`HelpLookup["paclet:ref/ExportString"], "Magnify" :> 
          Documentation`HelpLookup["paclet:ref/Magnify"], "Rotate" :> 
          Documentation`HelpLookup["paclet:ref/Rotate"], "Antialiasing" :> 
          Documentation`HelpLookup["paclet:ref/Antialiasing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Export\"\>", 
       2->"\<\"ExportString\"\>", 3->"\<\"Magnify\"\>", 4->"\<\"Rotate\"\>", 
       5->"\<\"Antialiasing\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Image Processing" :> 
          Documentation`HelpLookup["paclet:guide/ImageProcessing"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Image Processing\"\>", 
       2->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       3->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Rasterize", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rasterize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rasterize"], "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a rasterized graphic of ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rasterize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rasterize"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the element ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " associated with the rasterized form of ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20919]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The expression ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " need not explicitly be a graphic, but can be text, a cell, or any \
expression. "
}], "Notes",
 CellID->25600],

Cell["Possible basic elements include:", "Notes",
 CellID->32343931],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BoundingBox\>\"", Cell[
    "bounding box information for the raster", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "the array of pixel values in the raster", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[
    "a graphics object representing the raster", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RasterSize\>\"", Cell[
    "pixel width and height of the raster", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Regions\>\"", Cell[TextData[{
     "regions specified by ",
     Cell[BoxData[
      ButtonBox["Annotation",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
     " constructs"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RGBColor\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->40295514],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", "\"\<Graphics\>\""}], "]"}]], "InlineFormula"],
 ", and displays in a notebook in a way that approximates the unrasterized \
display of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ", with the same image size."
}], "Notes",
 CellID->3543797],

Cell[TextData[{
 "The following options for ",
 Cell[BoxData[
  ButtonBox["Rasterize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rasterize"]], "InlineFormula"],
 " can be given: "
}], "Notes",
 CellID->21311],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "background to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align with a surrounding text baseline", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageResolution",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageResolution"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "image resolution in dpi for rasterization ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
final displayed image size in printer\[CloseCurlyQuote]s points  \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RasterSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RasterSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "raster size in pixels for rasterization", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->31755],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RasterSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RasterSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ImageResolution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageResolution"]], "InlineFormula"],
 " determine the coarseness of rasterization; ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " determines the size at which the final image will be displayed."
}], "Notes",
 CellID->6444678],

Cell[TextData[{
 "If there is an explicit setting for ",
 Cell[BoxData[
  ButtonBox["RasterSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RasterSize"]], "InlineFormula"],
 ", it overrides any explicit setting for ",
 Cell[BoxData[
  ButtonBox["ImageResolution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageResolution"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->227505925],

Cell[TextData[{
 "When the settings for ",
 Cell[BoxData[
  ButtonBox["RasterSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RasterSize"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ImageResolution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageResolution"]], "InlineFormula"],
 " are small, the graph will appear coarse, and text may be illegible. There \
may also be artifacts associated with aliasing. "
}], "Notes",
 CellID->552043776],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Rasterize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rasterize"]], "InlineFormula"],
 " override any settings for those options in ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16224],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Background",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Background"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " yields a raster with a transparent background. "
}], "Notes",
 CellID->3881],

Cell[TextData[{
 "If no explicit size or resolution option settings are given, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " will rasterize ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " at the size and resolution it would normally be displayed in a notebook."
}], "Notes",
 CellID->274004605],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", "\"\<RasterSize\>\""}], "]"}]], 
  "InlineFormula"],
 " yields ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["w", "TI"], ",", 
    StyleBox["h", "TI"]}], "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["w", "TI"]], "InlineFormula"],
 " is the overall width in pixels of the raster, and ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " is its overall height."
}], "Notes",
 CellID->188627997],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", "\"\<BoundingBox\>\""}], "]"}]], 
  "InlineFormula"],
 " yields ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["w", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["dh", "TI"]}], "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["w", "TI"]], "InlineFormula"],
 " is the overall width, ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " is the overall height and ",
 Cell[BoxData[
  StyleBox["dh", "TI"]], "InlineFormula"],
 " is the offset of the baseline of the contents of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " from the bottom of its bounding box. "
}], "Notes",
 CellID->5973],

Cell[TextData[{
 "Rasters generated by ",
 Cell[BoxData[
  ButtonBox["Rasterize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rasterize"]], "InlineFormula"],
 " can vary slightly from one computer system to another, mainly as a result \
of different fonts and anti-aliasing procedures."
}], "Notes",
 CellID->79788781],

Cell[TextData[{
 "The results from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", "\"\<BoundingBox\>\""}], "]"}]], 
  "InlineFormula"],
 " can depend on details of font metrics, which generally differ between \
different computer systems."
}], "Notes",
 CellID->5651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", "\"\<Regions\>\""}], "]"}]], "InlineFormula"],
 " gives a list of rules of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["reg", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["2", "TR"]], "->", 
     SubscriptBox[
      StyleBox["reg", "TI"], 
      StyleBox["2", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", where each rule ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["i", "TI"]], "->", 
   SubscriptBox[
    StyleBox["reg", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 " is associated with an annotation of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Annotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Annotation"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["i", "TI"]], ",", "\"\<Region\>\""}], "]"}]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["reg", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " give pixel positions in the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["min", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinates run from bottom to top, as in ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->137383301]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68745722],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->263328800],

Cell["Make a 15-pixel-wide rasterization of an image of a disk: ", \
"ExampleText",
 CellID->572072794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Disk", "[", "]"}], "]"}], ",", 
   RowBox[{"RasterSize", "\[Rule]", "15"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->421953973],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwRAFxpgQDkP0fyALj
qP//gTQlpAqQZDt//jzb/v372Y4fP64yAKJCINHv37+zFRQUyAG9xRYQEMD2
/PlzoUEsywOSvX79OpuGhoYWSFZAQIBt+/btPINd1sLCwgwkIyEhAfIN2yCR
AZFs/f39TiCZiIiIARM1MDBwgoXcQIiCUhwHB4cHSBQYkzQVAZJ+IB4wN1KN
B/IV0DdgW4CxS3MRBwcHJ1hqQoQrfUWBOQws2t7ePhCi4FyVkJAAzlXA3MUz
UKLv378HyYBLHg8PD1AsDWZZCWhogkt2UIzCciJI1fLlyyWGgSpK2gYMjACI
b3sc\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{90, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388883247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->484125802],

Cell["\<\
Make a 75-pixel-wide rasterization of text, and display it 200 pixels wide:\
\>", "ExampleText",
 CellID->489804178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"RasterSize", "\[Rule]", "75"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->381853243],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmE0OgyAQhUl6ji56G1Zd9AheoBuP4108CkehMP4UZGzq/ChpfYlJo8n0
e/AYwVvzfDQXY8w1XPdwxd/+1Kkd1bemlO3c0Vy6iq7b/miKXeQ6+y9WfbD6
89EdxU1wvu6nSvjdYwVMTJRQAw2Gg8SwShcFyQmMLFaAp1wF4jY9x+kYXZke
nJrVsOkZTmc2qR48FFSy6clOU3tOrAeHQqItyEHBFX2HvIisTIKhilV7SVPm
tJxEfoLfg6W1+SI4RVFYCV4OnYrZzU7XViWZDi8ob3ar0w8EhARnLWNqueke
aWZDj1FKXdqPvRHpXK54IA4Gf5EPJEwSuaCUVMDi8FV5pNAAQ0awDqmA/dXU
1ns01gBjHMJ0JQ8WwlLjimWDwYk9vVHLdywFsKy7SXzukJIGWLohqcTmoGrB
dtYL3Uq+BA==
   "], {{0, 0}, {39.52, 14.693333333333335`}}, {0, 255},
   ColorFunction->RGBColor],
  ImageMargins->0.,
  ImageSize->200,
  PlotRange->{{0, 39.52}, {0, 14.693333333333335`}}]], "Output",
 ImageSize->{204, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->326303923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->677587502],

Cell["\<\
Make a 36 dpi rasterization of a 3D graphic, with light yellow background:\
\>", "ExampleText",
 CellID->26540558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Cylinder", "[", "]"}], "]"}], ",", 
   RowBox[{"ImageResolution", "\[Rule]", "36"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336674772],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3YmXFMUdB/B9L39J/oIGNMaoMefLy+kqKHJ5cSqw7LIsy8LC7lyt4IEi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   "], {{0, 0}, {360., 396.}}, {0, 255},
   ColorFunction->RGBColor],
  Background->RGBColor[1, 1, 0.85],
  ImageSize->{150., 168.},
  PlotRange->{{0, 360.}, {0, 396.}}]], "Output",
 ImageSize->{154, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->531462053]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26828],

Cell[TextData[{
 "Convert any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression into a raster graphic:"
}], "ExampleText",
 CellID->43641338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Sphere", "[", "]"}], "]"}], ",", 
   RowBox[{"RasterSize", "\[Rule]", "150"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "150"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104493291],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzsvIV702fb//8cx/cv+f0FF8WHjDFhG9tIgQLFocCn7u7u7u7u7u7umqZt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   "], {{0, 0}, {150., 165.}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->150,
  PlotRange->{{0, 150.}, {0, 165.}}]], "Output",
 ImageSize->{154, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31617838]
}, Open  ]],

Cell["The default output is a raster graphic:", "ExampleText",
 CellID->65935054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"InputForm", "[", "%", "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->187107065],

Cell[BoxData[
 TagBox[
  FrameBox["\<\"Graphics[Raster[{{{255, 255, 255}, {255, <<2>>}, <<147>>, \
{255, 255, 255}}, <<162>>}, <<3>>], <<2>>]\"\>",
   BoxFrame->False,
   FrameMargins->False],
  Short[#, 2]& ]], "Output",
 ImageSize->{431, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->593615004]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171634672],

Cell["Get the bounding box information:", "ExampleText",
 CellID->5161197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Grid", "@", 
    RowBox[{"Table", "[", 
     RowBox[{"x", ",", 
      RowBox[{"{", "5", "}"}], ",", 
      RowBox[{"{", "10", "}"}]}], "]"}]}], ",", "\"\<BoundingBox\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54982997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"142", ",", "71", ",", "39"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232557701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->387017186],

Cell["Get the array of pixel values for the raster:", "ExampleText",
 CellID->135873621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Rasterize", "[", 
   RowBox[{
    RowBox[{"Grid", "@", 
     RowBox[{"Table", "[", 
      RowBox[{"x", ",", 
       RowBox[{"{", "5", "}"}], ",", 
       RowBox[{"{", "10", "}"}]}], "]"}]}], ",", "\"\<Data\>\""}], "]"}], "//",
   "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13474602],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"255", ",", "255", ",", "255"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"255", ",", "255", ",", "255"}], "}"}], ",", 
      RowBox[{"\[LeftSkeleton]", "138", "\[RightSkeleton]"}], ",", 
      RowBox[{"{", 
       RowBox[{"255", ",", "255", ",", "255"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"255", ",", "255", ",", "255"}], "}"}]}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "69", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], "}"}], ",", 
      RowBox[{"\[LeftSkeleton]", "141", "\[RightSkeleton]"}]}], "}"}]}], 
   "}"}],
  Short]], "Output",
 ImageSize->{524, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->622122434]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Raster", "[", 
   RowBox[{"%", ",", "Automatic", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "255"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99912673],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlE0OgjAQhYfwo4DsXXIa7UbvQIgJLIwGOQsr7sJROEqdNiR2ZRShYPJI
OszMI+10aL9TVheXa1aXeZYeq+xelPkjPdwqTrkOETU8zntiX7KnRyMlv99b
V9mN7GpST90ZHm0ta+GKavF0d7T1+1aQaNllXWnRTNnY6mq+3qG2rtL0xmn3
Y5xMPF9gVMmFCyFeX42Pk4nnC4zTog4R91f3WWnRTNnY6mq+QYvh7xg3RrT9
cJvsaeGKavE+IC0I/J0GAo+LQWAQ2I4GAoPAIDAIDAIvRT0QGAQGgUFgEHgp
6oHAIDAIDAKDwEtR7z8JTM4T9eMEiQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->66071232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26386666],

Cell["Get the raster graphic:", "ExampleText",
 CellID->164476559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Grid", "@", 
    RowBox[{"Table", "[", 
     RowBox[{"x", ",", 
      RowBox[{"{", "5", "}"}], ",", 
      RowBox[{"{", "10", "}"}]}], "]"}]}], ",", "\"\<Graphics\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142640495],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlE0KgzAQRidKbSk9QJeepmbTQwQp6KK02JzDE3gXj+JR0hl/WtGNyxg+
IXHmewohmnc3tng8jS1zk2aVeRdl/klvr4qjWBFRzSO7EteOq37UzvF9PtOx
azTJZVvX2r7STUcnoaGzZM2UQKKEsSQMpuIsbxwWIe0tVf1Xj2SOOdJaS3rx
rI9mqxy/0e8pf/phlf2/IqFuhm3m7R72fhHS3lI1GmI6G/9TInQ4XYGzZM2U
QFqbdMvslf1gW9gWtvUmhW1hW9gWtvWjh22DZ7AtbAvbetHDtsEz2Ba2hW29
6GHb4Nkm25L6ArO0rWo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, 
   Rational[10875, 71]}},
 CellLabel->"Out[1]=",
 CellID->46233302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->258884861],

Cell["Get the pixel dimensions of the raster:", "ExampleText",
 CellID->209624186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Grid", "@", 
    RowBox[{"Table", "[", 
     RowBox[{"x", ",", 
      RowBox[{"{", "5", "}"}], ",", 
      RowBox[{"{", "10", "}"}]}], "]"}]}], ",", "\"\<RasterSize\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131561653],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"142", ",", "71"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3466175]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42179265],

Cell[TextData[{
 "Define regions using ",
 Cell[BoxData[
  ButtonBox["Annotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->37256258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{"Red", ",", 
     RowBox[{"Annotation", "[", 
      RowBox[{
       RowBox[{"Disk", "[", "]"}], ",", "\"\<Red\>\"", ",", 
       "\"\<Region\>\""}], "]"}], ",", "Blue", ",", 
     RowBox[{"Annotation", "[", 
      RowBox[{
       RowBox[{"Disk", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "0"}], "}"}], "]"}], ",", "\"\<Blue\>\"", ",", 
       "\"\<Region\>\""}], "]"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->845486151],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], 
    TagBox[DiskBox[{0, 0}],
     Annotation[#, "Red", "Region"]& ]}, 
   {RGBColor[0, 0, 1], 
    TagBox[DiskBox[{3, 0}],
     Annotation[#, "Blue", "Region"]& ]}}]], "Output",
 ImageSize->{104, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->17156835]
}, Open  ]],

Cell["Get the defined regions:", "ExampleText",
 CellID->564500291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{"e", ",", "\"\<Regions\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->276823254],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"Red\"\>", ",", "\<\"Region\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"7.1875`", ",", "6.875`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"145.0625`", ",", "144.75`"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"Blue\"\>", ",", "\<\"Region\"\>"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"213.9375`", ",", "6.875`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"351.8125`", ",", "144.75`"}], "}"}]}], "}"}]}]}], 
  "}"}]], "Output",
 ImageSize->{380, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->256157511]
}, Open  ]],

Cell["Display the regions using ractangles:", "ExampleText",
 CellID->995658248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Rasterize", "[", "e", "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FaceForm", "[", "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Rectangle", "@@", 
         RowBox[{"Last", "@", "#"}]}], "&"}], "/@", 
       RowBox[{"Rasterize", "[", 
        RowBox[{"e", ",", "\"\<Regions\>\""}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->370665913],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyll2uITWsYx989+3LMZY+ZfWbOmWNmzN5jQg5F8WEaiUYzLp0UUlJqZ58Q
pzPmgg9IlEskinzwwSU+ICmkfEAIRZImKZR7aWiSIST+53mfZ932uux1aq/a
795rrff9/Z/38lz2X9neFX//k+1duSyb7uzOdq1Yuawn3fFvNz2KRpRSOfr8
WafoN+gXf3IAfZdQO4Zuf6Xv0UrujTaqe/GlKnRTilevcP06Tp3CwYPYtw+H
D+P8eTx4gKEhVekaUeVL+PwZ/f24cAFHjmgAYU6exLVrePkSajj10KZGfC0o
1U0Md+5g3TpMmYKKioSeRRyRCBobsXAhjh7FwIAqD7GDOfH373H8OBYtQlMT
SkqgEnpNYuXlmDwZvb24fRsVBa35he9x9ixmzNBmJHUTRW0t1qzBs2eiUsAK
Gf/iBdauRV0dVKXWj06ditOnLSuD1eOiTgs/a5YWrhb1qirs3ImfPw16sHqC
7/fsQSoFLVzN6jNn4t49y7pg9ZioHzpEe6CFa0S9vV3vomVdsLqMf/MGnZ2s
XsPqpaU4cMCyLlg9Ks369ZBj/Juo0xG4f9+mB6vLeDqEzc1M+J3Vu7vhsC5Y
Xe71Jot6najX1Bjq0RB1Gf/wIW86Ef5g9VWr4LDOpR63Rutrxw7VYM349Wub
6dJMOEe9fatn28BamzebWiVerZg96vLlkeJfdMB//DCG0JXy2DR7NtRIzY5f
vGgbqvzJQ0PIZJr02xh277a6pvLV6SQ0MbG+Hh8++BPNGW/cqNLCq6zUAcrD
o9nTOU+zh/f02DA3a2CAPEhlZHW5ozVfQ2vDBqiMGSnoAPtzdu3STw0OKQ8O
5nE+fuTNb+bd2LIlaGaTJunHzUI5dkwMIE833lOc0AChjBuH7999KRQcbcqC
BW7KkiVMGaV7ku/7nXs55wahocFNyGRsAgWUUEIk4ibEYjZh6dIChFFM8PEt
owcTpk0rljBhQrGElpZiCWPHFkugPFYkYd688N1MJt27WV1tEyhRhxJaW92E
6dNtwrlzvgRKszaB/N9F2LbN4RuUFN+98/WNbNbhp+Qo/f15fvr4MaJRk7J4
cZCf3rrloFAO9EaNuXNNytWrBeJYe7tJuXTJh0JFkhF72tp8Y5gZPe/epckY
EXbOHKunK8LOn29ExJs3C9Lo6uszMkEyiadPrc7uTPD8OfTmSyZYvRrW5Zqv
I3dQ0GprU41CP3Eib4Q3z5w5A9XI60iH++tX7uiTw/Iyn47SLS31sq5m6vPP
mJ4svX07jNMqWZpKRZoj/LO0t0Z48oSUHTUCVSywRodXKJs2mepSoaTTePSI
3xeuUIz6iEoDCoX0uFbUqcil8Iz/W53t3494nNVrWb21lapamONDa0Pa2L4+
ch/6V8Hq48fjyhXenBB1se7GDUycyOopVifn7OrCt29hlanQdfWufU7RPwpW
p3S7dSs+fVLDQtRl/JcvVGVRqqP3rN7RATJIvxpWUF3oIIdavlxnyjLxQVpH
Wr29e6m+KAvRZ0JscBC0/OTliQTK2IIRI5DLcQQo91jg/e+Wc7Qq8h9BeqeG
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, 
   Rational[85, 2]}},
 CellLabel->"Out[3]=",
 CellID->10916442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->154264913],

Cell[TextData[{
 "Get the ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " array:"
}], "ExampleText",
 CellID->713049631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"Rasterize", "[", 
    RowBox[{
     RowBox[{"Grid", "@", 
      RowBox[{"Table", "[", 
       RowBox[{"x", ",", 
        RowBox[{"{", "10", "}"}], ",", 
        RowBox[{"{", "10", "}"}]}], "]"}]}], ",", "\"\<RGBColor\>\""}], "]"}],
    ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23962790],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "]"}], ",", 
      RowBox[{"\[LeftSkeleton]", "138", "\[RightSkeleton]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "]"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "]"}]}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "143", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], "}"}]}], "}"}],
  Short[#, 2]& ]], "Output",
 ImageSize->{433, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->268102996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->298238557],

Cell["Set background color:", "ExampleText",
 CellID->491656649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", "50"}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->431163142],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnDFuwkAQRS3lJDlGGhoa6hwBiRKl4Q701EjpOAE9RY5AT66QG2yAXTsY
79q7Dt7/x4z1kVIkYvTfjmd3xs7r/ON9/lIUxdv583n+XH4+/RiVSqVSqVQq
lQqv43ZSxF6LPTpaVZIU7hPKQZ+tj+hIVANoPb2m6/IAj0T1eO1XhSbveKXJ
O2Zp8o5amrxjlkve1S77V++W4VPZdNv8fbcOfddk8413klAOLsCfJ4B7WIAS
p+EYJoavzcx9f1JpKNckd+MFCre0CLv+k/nKIGuwcKvdVGkv7AaSwFcMWYOE
WzsH2TCQxSuKrySyBgj37hDkvPXtZLKp4utfY8LIGhhcT/vCJS/WuiBfeWQN
Cq63d+HOJtDkPXn5iiRrMHBDXcdy+Av3sMZXKlkDgdvSciRJ3lOjxUFM1pWz
XtejubcPC2iS95YvawOKDm7npMBZCh8lcDRY/qe8t+WYGR/DHPCmzgrJX6+y
wo0c8IHngI0dlFi+GeHGpyQweQN744ovw2YgWvngJuUjJnlbTz0C+eaCm5qM
+ZM34jwrjW8muD0y0f5JpjIX3akQxTcL3F5pmG8OmNiDqh4woOebA27fAjr4
HPBvzHd3eVpkwV6BB3HKSzRD3pqGhRt67iimrrWZ8CD3Bobb5er1jiHteDUI
3Fri87sXVYnOC0af2ZbpHlOfXJ743eOPkFn87pURyq2t6l6r8I//SRa/e/wR
MovfPf4ImcXvHn+EzOJ3jz9CZvG7xx8hs+jd4z/BMYvfPdthI3iIV6To3bNd
dN7lxy1y9+xMird2cAvp3qUudAytbHi0aw8pcvcipo3XG4uO/ES6d51lh5ef
3fLBX6xgFbt7NoDAjq4jeBW/e94TGe5fbwmTCPfq75TpJkrdU/XTL4WkKec=

   "], {{0, 0}, {159, 57}}, {0, 255},
   ColorFunction->RGBColor],
  Background->RGBColor[0.87, 0.94, 1],
  ImageSize->{159, 57},
  PlotRange->{{0, 159}, {0, 57}}]], "Output",
 ImageSize->{163, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->427468069]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1027994973],

Cell["Set image resolution:", "ExampleText",
 CellID->59177267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", "50"}], "]"}], ",", 
   RowBox[{"ImageResolution", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26239287],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdlc0JwzAMhQWdoCP03EV07ghZoBePo108ikdp/VM5uJDoqTgEKjAooDx9
flHs2/J8LBciuuZ1z6vkr7+MJEw9WNJpIMIHd48hRKOAjIrVrVKY612uIQAm
QWNgaXlNse4AQPkEEhDB7gPWfRiyzdfUf2HbBJV0zsyuA+sERsuEpMZXDAAX
AEjDvvdMUDsLgeYowybAZ5rbxvsDJvqlQS6iuZrVjkmtf9aszJMh3JoxzgUA
NVP5jVqxfZ6C4dR0nk4owvl35BhvilG5Yg==
   "], {{0, 0}, {154.8, 61.2}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{154.8, 61.2},
  PlotRange->{{0, 154.8}, {0, 61.2}}]], "Output",
 ImageSize->{159, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237237252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25662789],

Cell["Set raster size in pixel:", "ExampleText",
 CellID->233981062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", "50"}], "]"}], ",", 
   RowBox[{"RasterSize", "\[Rule]", "100"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->76775959],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmF0OgyAQhE16kqaX8blHsAfoi8fxLh6Fo1gWrEEF/GFYuw2TmJi2kZ2P
KQvem/ezuVVV9dDXS190PxQVFfnVt1VQdaeuLu931dUE6OoqJMhErO2vLkOC
Sqj2qoRqt4Ch8nQLZw7i36KlRwM/nUAhS7Y8Il3U/iB3itGgpmlGrlRhVspM
C8eqiAVlHGlDpvwMEzBnxUdpwIJy+IzEQA+2mrNipTRAQc3gZAgVaaTTM1Ma
gKBWZHKEimSbRW5KseNZUpP1YMkSKjVyYj9NYhIVYIIOlbMujXcK9uwtQUAF
gSBDtVq90Ru2uACgojRAofp2vMXHjKzSQW2gAIQquvXmYpUKStmjnYoPcTpU
q+bjFDst656zQKRpnbSbAmpZzZJXyCXehb+09cNoWgW92uBxsSPrAsTkgqZE
PCsmF4XVsVEkLU1+8bgorI6NUv6Du2Q6iPhYsbig+RBPCuzCuykTtuFkceHD
Lm+ZYnGxOGPmeuOaWUwuZsdKUX86V//h4nJ9ABKW5l0=
   "], {{0, 0}, {157.41, 55.64999999999999}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{157.41, 55.64999999999999},
  PlotRange->{{0, 157.41}, {0, 55.64999999999999}}]], "Output",
 ImageSize->{161, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->409535225]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67634164],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RasterSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RasterSize"]], "InlineFormula"],
 " overrides ",
 Cell[BoxData[
  ButtonBox["ImageResolution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageResolution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->182039707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", "50"}], "]"}], ",", 
   RowBox[{"RasterSize", "\[Rule]", "100"}], ",", 
   RowBox[{"ImageResolution", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->961760909],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmF0OgyAQhE16kqaX8blHsAfoi8fxLh6Fo1gWrEEF/GFYuw2TmJi2kZ2P
KQvem/ezuVVV9dDXS190PxQVFfnVt1VQdaeuLu931dUE6OoqJMhErO2vLkOC
Sqj2qoRqt4Ch8nQLZw7i36KlRwM/nUAhS7Y8Il3U/iB3itGgpmlGrlRhVspM
C8eqiAVlHGlDpvwMEzBnxUdpwIJy+IzEQA+2mrNipTRAQc3gZAgVaaTTM1Ma
gKBWZHKEimSbRW5KseNZUpP1YMkSKjVyYj9NYhIVYIIOlbMujXcK9uwtQUAF
gSBDtVq90Ru2uACgojRAofp2vMXHjKzSQW2gAIQquvXmYpUKStmjnYoPcTpU
q+bjFDst656zQKRpnbSbAmpZzZJXyCXehb+09cNoWgW92uBxsSPrAsTkgqZE
PCsmF4XVsVEkLU1+8bgorI6NUv6Du2Q6iPhYsbig+RBPCuzCuykTtuFkceHD
Lm+ZYnGxOGPmeuOaWUwuZsdKUX86V//h4nJ9ABKW5l0=
   "], {{0, 0}, {157.41, 55.64999999999999}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{157.41, 55.64999999999999},
  PlotRange->{{0, 157.41}, {0, 55.64999999999999}}]], "Output",
 ImageSize->{161, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250603838]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->516608053],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->244145057],

Cell["Set background color:", "ExampleText",
 CellID->614127702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Cylinder", "[", "]"}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "120"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightGreen"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59356176],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3YdzHFcdB3DN8JfwFzwXSkgwZWCYYYZBtuXu2JIVWy5q1snq5fbKxi1u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   "], {{0, 0}, {120., 132.}}, {0, 255},
   ColorFunction->RGBColor],
  Background->RGBColor[0.88, 1, 0.88],
  ImageSize->120,
  PlotRange->{{0, 120.}, {0, 132.}}]], "Output",
 ImageSize->{124, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->95556532]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11048437],

Cell["By default, the background is opaque white:", "ExampleText",
 CellID->492467150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Cyan", ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Rasterize", "[", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"Cylinder", "[", "]"}], "]"}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "120"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12094115],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{120, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294329688]
}, Open  ]],

Cell[TextData[{
 "Make the background transparent, by setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Background",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Background"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->539739067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Cyan", ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Rasterize", "[", 
    RowBox[{
     RowBox[{"Graphics3D", "[", 
      RowBox[{"Cylinder", "[", "]"}], "]"}], ",", 
     RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "120"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->699100209],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{120, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50455644]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageResolution",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->370246719],

Cell["Set different image resolution in dpi:", "ExampleText",
 CellID->573595349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Rasterize", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ",", "40"}], "]"}], ",", 
     RowBox[{"ImageResolution", "\[Rule]", "r"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "40", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->58150907],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJzVks0JgDAMhQve3cGDu/TsCC7gpeN0l4ySUTTpjyjYGG0RDBQKDe977+kw
L9PcGWN6OiMdvq+/HW9NHOvxQ6iD8iu46Ih2DldxwAvuWUROh9SC9cGYqgcB
hyGbHDARFZ3n/KUvBC7Y5j0BSLCc7q7IIFZIh4dUDL5cio4Zl7zfEq9xuaCz
pmpw/6dVcRvosMEq1GOd74gAkDbreEqdvfTKdK103s4G3fJx3Q==
     "], {{0, 0}, {133.20000000000002`, 50.4}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{133.20000000000002`, 50.4},
    PlotRange->{{0, 133.20000000000002`}, {0, 50.4}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztlssNgzAQRC2li9zSTMQ5JdBALi6HXijFpSS2Q4xtFoVdD1oiMRIScPC+
8aw/t/756C/GmKt/7v4J769TpzgarVmoG5w2FkbBnB21KaByQ+fz0abAShpT
mItZ0whFQ7eH7wYrWA0RQlo8JlzXxOUucRSrdxTXVlWmoG0scDS1XOMGkUyh
VyXb0QzgyPZhKEUtHyKDovUbsEimMaYPB/og4GVUd0iDpe9Q8NON5YioLuu8
cmawphiO6CXMx6HGAZra7mi1KCum/DhdnrBpHGKlg28pRdWV3w5IEjeNbP78
t9K9C0kSpusY13sgSfORBxOQpE5dT0gSn/ohPCFJ/t9T3FFc9Q1iUiIpmlZ1
1wOSZBdq5f3uOCT76w3OGsUU
     "], {{0, 0}, {126., 46.800000000000004`}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{126., 46.800000000000004`},
    PlotRange->{{0, 126.}, {0, 46.800000000000004`}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztm8ttwzAQRAWkkjSSs88pwQ3k4nLcRCpwKSqFUWzRkvVdSjZ3hp4HBMgh
TlaLp1mKYj6PP9/Hj6qqvpqv3+br//sghBBCCCEoqM+HKonDufauWbwUKSHs
XE6SQAyICXK6eFciQKjlhBjSDQ/vSgQKCgoxQkEhhigoxAgFhRiCEhTRzTmm
y1v5lPZdttDtcfoGxVsrcbsMkOn90FOEmrpd+PRqUPROBkiJ4WsQjE5us6KT
G+MqUsBR4t7F0xlkRRFJtYLZh4CjxD0irhMX7tHDbgW5DwFGiaEDXWRcXOvq
YbGC34cAosTEsyfK4+gDy1YU4UPAUGJ6TGAeo5izohQfAoISs3kAGRRhyoqC
fAgASiytJDGDIjxaUZYPwV2JlSRADYrQt4LOh+RzsGNed5OuP2zCBkXoW0Hk
Q4BWwpQBqEExfKEBVt4OHAeHdT8KMCj664c970EgcVMi4e4HC4rxerIsK7yU
SNuyxgmKueeLgqzwUSL5vscIiuXnzVKscFFiy1st96Cw7D8UYYWDEhvveFcn
7PtR/FbkV2L7i2+v4ZG6P0luRW4ldi0KPIKi8yGlYmYrMiux92xMxqBYOlw7
6eTSpuD09a6d+jX9kqeTS4mlq1/+6/ZPPrfDb6tELviUyEBbsGEOXn/Sv2A6
GDscNTYc6fTfp6OEssPtwIFQtEwYO3wPOO9CioWxw3F1yvfUygJlh1uVqWrm
grHD9jWy2AZjh9uAo6qZC8YOU449Kig7zDj2uGDsMGPNXDB2+FYz1dQjg7DD
7dSjEpkLwg7fSqbymAy+DseKvesoF6QON6Wsy4lUMB1kHTZOsbgCylJTWRB2
2LLeJdxrA4Kvw2vbaNYjIGIOwg7Xc+e5+/8tUPvUVgaUHU4+/CsS4ezw+Iw3
UJYVgTos9vMH4SHwkA==
     "], {{0, 0}, {127.44, 44.64}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{127.44, 44.64},
    PlotRange->{{0, 127.44}, {0, 44.64}}]}], "}"}]], "Output",
 ImageSize->{427, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147151010]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RasterSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->288288183],

Cell["Set different raster sizes in pixels:", "ExampleText",
 CellID->19030806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Rasterize", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ",", "40"}], "]"}], ",", 
     RowBox[{"RasterSize", "\[Rule]", "r"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "50", ",", "200"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->357716098],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGDgAWIZIAax/w8esL+EAQxK9lNgxpw59zEE53hgNxJsocec
/XM8wDSJZgJ1YApDpRjwGAjzJljJfWRxIBePU0tKSvAHDaY795eANUApFHAf
5EqghWDX4DYW3UxokBHShlCL4U1CgKAukALSkwhBXfsJhC5puu5DEwFpfidP
F0kAAN5lciU=
     "], {{0, 0}, {118.53333333333336`, 50.80000000000001}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{118.53333333333336`, 50.80000000000001},
    PlotRange->{{0, 118.53333333333336`}, {0, 50.80000000000001}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztlsENwyAMRZG6QTfoENmBc0fIAr0wDrt4lIySYmiCaWljO3Jy6ZeQOMT6
nwe2chsf9/HinLumNaSF+/mvRRAcVYCzA/WVYvo4nZ3iu6bouewq8XwirNTC
h8hkkk3YAPPXNQwGVsHnxkODEILk/K9Mb0kt4qGFj2kTvQxCQS5ORd5D8076
yuhg2bJJFHykWC4GvRVdEbNF6JWWnDbxPk6fZ8xmSa9z5RA34rVGM/FS31f7
rgyHqdZI2S9yqY12TZtjjHa19CFGAJoqW6M6Oo3/M7RGZB4YJfth9ARY3ike

     "], {{0, 0}, {134.62, 45.72}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{134.62, 45.72},
    PlotRange->{{0, 134.62}, {0, 45.72}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztnUFugzAURJF6kl6myrpHyAW6yXFyF7a9BUehoSEEiMH2B8fjYZ4UqYtQ
/c+MB2OH5PP8833+qKrq6/b6vb26v1shhBBCCCGEENu4nqp4Ttcmd90CmcZk
KxlL+FBeiXczpNnpmrsUQUV96RPqUucuRTChyBJpUGSJJCiyRBoUWSIJiiyR
BkWWSAJqZPnXdZcL3nKs2IchsKAiK2gfamF3YMuxYicmGiCNYuXVGv3YQR0d
o7C6AxRZd8YVWovb43+Age2rYVxfLo9TDziQx9e1eFuMTAWqggVkX9UTLz09
Vucu7JWxtWKcz2mqFtpXcyPVwJHVWqw1OaBJXN6bgfWVy0XQkdUxiZ/1t266
duKD6iu3hcAjqyNkDk44T5+D6atl/8BHVsdqFkVkWsFA+mrNPAVEVod77mSd
3pcHoK98zikistrXe71tyxGFgecrv20KiazWsax7DFO1eL4K80wpkdW+Wgu/
4gDc48XGW05IqGHKiayZBhS2Ks1XMW4pIrKcn1yAuTakBOk6GGcV+Miaz9Np
92xc4Pgq3ifIkeW++TvAgmgPjK8sJkGNrDX7HGS1AcRXVocARpb/cncEa2H4
ym4PsMgK/YgC/cI7gq+2eeP5WEWzd2HGSgLHB/VGIYCvtl7LIJ4Es83Ieefx
2X21x4Usd2RtSh7OyVZuX+0z8c4VWevrztbncRjslctXnmfovKfWp2jzhh68
2xkLZXh3QRa6N353ZpbJWyZfWU9t6PGzflIpYswrT/VLvZfkq1wYT23g8fNh
wqHIo4vQEBgyI21ZB4ZGkbiJ5P+786+/UEOjSJP77lfMoFGEphEaeBSBWA0W
I2gUGQZJ6Y3QQKMITSM08CjyyF+8u9ejQqMITSM00ChC0wgNPIoMq7+5CxE9
NIrQNEIDjSI0jdBAowhNIzSwKNJPGovfVuCBRRGWPnhgUST3owtiDoci/ZZC
8RsKPAArcgvTyE8nInbBBIMiUYX113O8LpggUSTiORfcJqhgUWS4qwh6G2gT
VJAoEvBDnzQfXSwDGkVWvukI82dA6eFRBOKJbzGCSRFHLyUMCmKMivwBwRK4
VQ==
     "], {{0, 0}, {127., 44.45}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{127., 44.45},
    PlotRange->{{0, 127.}, {0, 44.45}}]}], "}"}]], "Output",
 ImageSize->{422, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27857261]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8236],

Cell["Image of the first 1000 letters from the US Constitution:", \
"ExampleText",
 CellID->522564891],

Cell[BoxData[
 RowBox[{
  RowBox[{"txt", "=", 
   RowBox[{"Import", "[", "\"\<ExampleData/USConstitution.txt\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223954388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Text", "@", 
    RowBox[{"StringTake", "[", 
     RowBox[{"txt", ",", "1000"}], "]"}]}], ",", 
   RowBox[{"RasterSize", "\[Rule]", "600"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "300"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->208152707],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztvT1y6zoTQKmaWclsRIkTx7OCqalyqJrEe3Du2LFWoFyBl3Dze7fw7eCN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   "], {{0, 0}, {410.40000000000003`, 367.875}}, {0, 255},
   ColorFunction->RGBColor],
  Background->RGBColor[0.87, 0.94, 1],
  ImageSize->300,
  PlotRange->{{0, 410.40000000000003`}, {0, 367.875}}]], "Output",
 ImageSize->{304, 269},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->547123293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32550322],

Cell[TextData[{
 "Thumbnail of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook:"
}], "ExampleText",
 CellID->299841845],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"Import", "[", "\"\<ExampleData/document.nb\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119336250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"ImageSize", "\[Rule]", "300"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11802],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f2fFNWB7/F+3ftf7O7d+/Db3ntfrzYxyeZh83q5L51NZbNhWF1N1mg0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   "], {{0, 0}, {1103.8133333333333`, 1050.8}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->300,
  PlotRange->{{0, 1103.8133333333333`}, {0, 1050.8}}]], "Output",
 ImageSize->{304, 286},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195948414]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448941515],

Cell["Rasterize a line segment with grid lines:", "ExampleText",
 CellID->719557916],

Cell[BoxData[
 RowBox[{
  RowBox[{"lines", "[", 
   RowBox[{"Antialiasing", "\[Rule]", "a_"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Rasterize", "[", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
           RowBox[{"Antialiasing", "\[Rule]", "a"}]}], "]"}], "]"}], ",", 
        RowBox[{"Background", "\[Rule]", "None"}], ",", 
        RowBox[{"RasterSize", "\[Rule]", "20"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", "False"}], ",", 
      RowBox[{"GridLines", "\[Rule]", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"m", ",", "M"}], "}"}], ",", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"Floor", "[", "m", "]"}], ",", 
           RowBox[{"Ceiling", "[", "M", "]"}]}], "]"}]}], "]"}]}], ",", 
      RowBox[{"GridLinesStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", 
         RowBox[{"Opacity", "[", ".1", "]"}]}], "]"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "6"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99112439],

Cell["With antialiasing:", "ExampleText",
 CellID->217142965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lines", "[", 
  RowBox[{"Antialiasing", "\[Rule]", "True"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40835274],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 170},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41852818]
}, Open  ]],

Cell["Without antialiasing:", "ExampleText",
 CellID->701184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lines", "[", 
  RowBox[{"Antialiasing", "\[Rule]", "False"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->610248628],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 170},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->16544600]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10470],

Cell["Pages from the US Constitution:", "ExampleText",
 CellID->17439323],

Cell[BoxData[
 RowBox[{
  RowBox[{"txt", "=", 
   RowBox[{"Import", "[", "\"\<ExampleData/USConstitution.txt\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170945749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Rasterize", "[", 
       RowBox[{
        RowBox[{"Framed", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"StringTake", "[", 
             RowBox[{"txt", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"2000", "s"}], "+", "1"}], ",", 
                RowBox[{"2000", 
                 RowBox[{"(", 
                  RowBox[{"s", "+", "1"}], ")"}]}]}], "}"}]}], "]"}], ",", 
            RowBox[{"LineIndent", "\[Rule]", "0"}]}], "]"}], ",", 
          RowBox[{"FrameMargins", "\[Rule]", "10"}]}], "]"}], ",", 
        RowBox[{"RasterSize", "\[Rule]", "100"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"s", ",", "0", ",", 
        RowBox[{
         RowBox[{"Quotient", "[", 
          RowBox[{
           RowBox[{"StringLength", "[", "txt", "]"}], ",", "2000"}], "]"}], 
         "-", "1"}]}], "}"}]}], "]"}], ",", "7"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->337391938],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[RasterBox[CompressedData["
1:eJztnU1u40YQRgVk4yN4m4tk7XUuEGCAANll4+N4P8fwJhfICXSUiRxGMX+q
q6ufaFu23gMMzHBISn7T+FBk//387c9fv/10OBz+Pv38cfp5+fPd3d1BBpmk
/ZBBJnsf/S0+H3pj6I2hN4beGHpj6I2hN4beGHpjFLw9P54fyh6fX/724/j0
ED+0PTwd/z/54el7cObLHb4EtjeG3hh6Ywzl22vELQ82mMfdLPSa1/bj8Xpy
0vbG0BtDb4zBfFvHzr85swnAtOTbXnIlkTWE7Y2hN4beGH1v7SJqSbFa257W
SMVOiRjfp31OXjrOL9nJm0TojaE3Rt/bIt9WKRFl2vnIS0YVyrYoi85H/pou
z6Jsdtvsyyy//7t4kwi9MfTGKHhrxc4qQ/J4qZRbrxf+9sspt/Jybn3DQsnX
+JKvKbqvNwnQG0NvjIK3OKPCPEnfraU12OIdXSW7xuJod2xvDL0x9MYYybcK
pIr7XD0LE7Y3ht4YemOM59v8FVxUaEX9Eclbsrg2Oz8C1/odHh5/nz/Prp6g
g2svT1TbG0NvDL0xxvPtsOllaMVaUK2BjtFNLs2rwTe208b2xtAbQ2+Mer5t
sqU/THd9SbOs+nzY3hh6Y+iNUc+3RqaNjkNbZd2mNzbIwNrAj06tmHyHNZXI
nc7c43/gttAbQ28MvTH0xtAbQ2+MgreoLgqmoHaqu+7jbfvV3NR9cF3Y3hh6
Y+iNMZRv5wiqdwGc02zbH5H2MiRZtxxt8pZqUmxvDL0x9MYYyrdaEAXvtdJZ
VB8fVgDbG0NvDL0x+t7iNdzIXNHXy4/x8LZeHm6TszjUbbkESitgR6amTtcg
5TeN3hh6YxS8LcNhmzC9dTny4q00Ii7u6NxtsjzA9sbQG0NvjL63sH5bLQxy
rC30EY8Bfo9fc3dsbwy9MfTGKHjj809b06lK49nKD7ytD6oNSG51+17uTQL0
xtAbQ28MvTH0xtAbo+CtNZ/9prG9MfTG0BtjPN/yXWCaj5PLRd6SVTHXWdoY
IRxeO7ttOEal+Z5weJXLgjcJ0BtDb4yCtzBD+q+zypPrR9cnuYouCdsbQ28M
vTHG8y3Mpf7mMpv+07D6eoffeB9sbwy9MfTG6HvLxn50+z3Htl2Y1Xi9dYDj
PSACCkOFVzXnTt4kQm8MvTH0xtAbQ28MvTEK3tIl1AqLv33JzlbbG0NvDL0x
+t6aL80Gnz2zkyujgtdnpv0X6fLCe+zOMF11sf6bQ28MvTEK3mr9m2NLlxd3
ALzeDgjbG0NvDL0xRvOtvfrHpetbXluC5djeGHpj6I0xkm/Z+7fa9vHxta9H
CnNO1w+S0XaE9a0i0gWaLvQmAXpj6I1R8JaM4/005dbu2N4YemPojaE3ht4Y
emPojdH31tmPflnUraejtk6uT+/qP2nm9wcPzpUBLdOpF8q/QfTG0Buj7+2Y
zCnIAmpxsLSr6X901j/vjO7ozptIujx29SYRemPojVHw5vu3ANsbQ28MvTH0
xtAbQ28MvTH63rIBGF9z7lUF2xtDbwy9MfTG0BtDbwy9MVj91t04Jhl5+zVK
PtsbQ28MvTEK3sDwjDwMixPzk0/5+H4N2xtDbwy9MVC+lYKulHvPj7NxHW/+
y+6I7Y2hN4beGDTf4qG8m9Brj+PNtqQf2kG1dav1mUneLofP7eVNAvTG0Buj
4G3o2bOZVFE01f9p+YnPlWgtLm/ydt4kQG8MvTH63oL9FwaXQoI7Z+XLfbRW
kNssdNkqFNfHp4/ez5tE6I2hN4beGHpj6I2hN4beGHpj6I2hN4beGHpj6I2h
N8ZJ2v39ffCCSlJO0v4BtNwFOA==
       "], {{0, 0}, {599.04, 1203.84}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 599.04}, {0, 1203.84}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnT1uG0kUBgk40RGU+iIbK/YFFjBgwNkmPI5yH4OJ9hw6Ck2ZFjWcft39
uoZDSlAVIEAazo9YaHzo//n6/b9v379sNpv/Dz8/Dz8vv9/d3W1kkKO0vQxy
tHfr/+LjoTeG3hh6Y+iNoTeG3hh6Y+iNoTdGwttuW2+mbXf7/fPjQ/DJw+Pz
6cLp7zXeznm557597ezkG2B5Y+iNoTcGyLfz/Kll2uuRpzj9tj+2u0kwTu7Z
CbTizoeP1tdUYHlj6I2hN0bfW1Q9q0TcKYWCjHq5ZLc9r5hd4wuuhOWNoTeG
3hgJb9OkqrU0Hx5/bWeJF2XgtNIVJ+H0qnrj9+yes6rgSNO40She7k0C9MbQ
GyPhLdsV9nbkKZk2lWpe1FBNdMqVtKOv9tzTnwu9SYDeGHpj6I2hN4beGHpj
JLyh9l00rFDrtXupZa3/TS+L5Y2hN4beGOl8y3RqJeOu1yc26coruuDKHrzM
bbv//PCEk+NlS+1/PvTG0Bsj4W28/y2RPGFdrj7zZFMOYRQnH5/SC8+3pG2P
lSz3JgF6Y+iNoTeG3hh6Y+iNkfCWHB4tjhczRsJa06QFmh3cnH20296g+87y
xtAbQ2+MkXwb7Ea7xNBDc9kCm9gWPeUQxc/TdutFvEmA3hh6Y+iNoTeG3hh6
Y/S95efH7rZFS7M7EbdW0QqvLWb8Fqsbmq3ddt1vbJrK8ZoF4j8pemPojZHw
VqREOY7ZysBaTC2cZDJ5etiwbf2T7eR0/HRF9MbQG6Pv7VQdCuKlW0dq1vfy
gZPu96ss74qnhdSGLTLVuOOZy/1/NvTG0BtDbwy9MfTG0Bsj4a09WbfTGu3t
AfIhF2ftLW8UvTH0xuh7y40v5NKscZ/mNiPxJpnFZkpjG4zMpoVM73kJbxKh
N4beGAlvtR6qoRWdg8lT6SKL95T7tU3fP9kf6P5Ia6E3ht4YCW/J3SYrAxCv
B5trSyfnzxbXt3cvSQx0roTljaE3ht4Y+Xw7C5bcevnw+OHI48OfZVVn53ww
LG8MvTH0xgD5FjcSgwm9eHJvKj/PX+jQGOao3G3WGn2bFXwpbxKgN4beGAlv
jVRJ9a3dJA/D5xbvuGmPUCz0JgF6Y+iNkfDW3zSylza5I0+NicSzp6ydihfx
JgF6Y+iNkfA2sCZ0evzPxLZU6I2+u+o9YHlj6I2hN8ZgviXf+jen9/rm4pyn
RZ1jV8DyxtAbQ2+M0XwDwXWWhLxJO/nodtNCTljeGHpj6I2xMN+KlGsd7NX9
1v6ul8TyxtAbQ28MvTH0xtAbQ2+Mvrfq+tP5tkUfdKU8w/LG0BtDb4yEt+aG
vfXFoWFr9N9/ypUL3TZs64a3atVa3hh6Y+iNMZ5v9RdjxUtNk+MO1/iyF8Ty
xtAbQ2+MkXwb3Cdk/fdkof2Roh3qgjrkcm8SoDeG3hgJb/H03dftx6/zb747
LG8MvTH0xtAbQ28MvTH0xhivvzXe9tJ9c1ajRVnjnQ7LWt4YemPojUHyLb35
W/lRcibw9HHRkOvtsbwx9MbQG2Mk3/Jr5DOEd7vGV74IljeG3hh6Y+iNoTeG
3hh6Y/S9Nd+HNT4dt92bt0nXCcMdMoNHrPSCwuPF49d9dvTG0Buj7222Pquy
+WT9U7ZVb3iHv6zwUq0VvEmE3hh6Y+iNoTeG3hh6Y+S8JdcCxEu3cs3M4M/6
hUE798rTSCxvDL0x9MbQG0NvDL0x9MbQG0NvDL0x9MY4SLu/v4/bjlLnIO03
dCTmaw==
       "], {{0, 0}, {599.04, 1134.72}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 599.04}, {0, 1134.72}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnUtuGzkUABuYjY/g7Vwka61zgQECDDC7bHQc73MMbeYCcwIdJSO7Ybs/
j+RjtSRLUBVgwKa6W50K8cDfI//88fP7jz+GYfjv9PPP6ef196enp0E6GaX9
lk5Ge1/9FveH3hh6Y+iNoTeG3hh6Y+iNoTeG3hgJb4f9snO22/+9P8zLT3+v
rty9HMeSj18Wv7+X/NqH3zK/6xo28ljfGHpj6I3RFd9eg9hhvyw5vuyKge4z
RpXK10yvXN717+y7JtdfG+sbQ28MvTG64tucabvrI/LUAtcsIr1HxS+JTtux
vjH0xtAboye+VWLX7KOor1on6rTG3zWWp6Jo5q1wdB1vhzc/MHpj6I2R8FaK
M79fdjc3LHY1rG8MvTH0xtAbQ28MvTH0xki334Kx/fKUQdh/jDqhrVG7t2na
Wxyis74x9MbQGyMd3+IotJ5RLQW01Uzr4mnNIbjlMpJJdE2Os7Wev/xzozcJ
0BtDb4y2t2OwJKMYMeKVbMnFIaXFJKvLgm95K4xftdmwXH/1ObxJhN4YemPo
jaE3ht4YemMkvFUaaR1jbs0mXHlZb6vp9dlyq43jpd95eE/Q2OhNAvTG0Bsj
4a0jlSDTx0xncrV6qcfLmqljfWPojaE3Rj6+rcPUy26WhVptoTXnGq7wbz0n
1jeG3hh6Y7S9peYXGnOdrdvjklm7btJcLM2clp+zfuC6/NzeJEJvDL0xEt7y
UahUUk+qIjn4n/cWF42USuK+cG+IG+9Byh8avTH0xtAbQ28MvTH0xkh462xQ
dTTGCivZxsZeYSukG0lnsL4x9MbQG6MnvsWst4BbfrreMu6wXIt7EzGrB+sb
Q28MvTF641s8/hYP/oe09vLdOBYXRdrelS1DIt6Ol23W/3DojaE3ht4YemPo
jaE3RsJbewFGus22bIalWoOFrNJmisFFsb4x9MbQGwPEtwX11WjLDmncNwwu
LsTMcu8yzhp7f1Sp37oeGzybNwnQG0NvjLa34tzB7q9v+8Pnp42dw2vpWsfM
8F2j7VfbLql6Js7kz44lcNY3ht4YemMkvBV2sGy3o6Zhp9Zyq2fW9+TaLy6I
L4siofkLV0JvDL0xEt5Q/kKwMe+5ZksryV9bjrnp2wJuvGer/cdDbwy9MRLe
KpHk/vLiz4X1jaE3ht4YemPojaE3ht4YtP227NMNt5Q8dQWsbwy9MfTGaHtb
bo3bGlIr5I1W15BMLotPq+lbOFeeWg0fS3rZ1jeG3hh6YyS8ZfY+igNXPBka
LDlLLVcrhrXjZRWFWN8YemPojdET3ypNr+YWcOFHdzw9YX1j6I2hN4beGHpj
6I2hN0a6/ZYef2skWDU++vLE0iTWN4beGHpjtL0dy4P2hfPokyfI59bfllbz
en7WXaI3ht4Y+fiWOzl0SJ4FEx2LcIV/7tmwvjH0xtAbI+Etn+I0FLcc/0jX
auwfUltJ0rMmpG8r9fU7vB19uNGbBOiNoTdGwlt1tK3Yeaz0ZCfl07T6jjUh
1e8qj+x17dC72ZsE6I2hN0bCm/mnAdY3ht4YemPojaE3ht4YemN0td8eKsO0
jvWNoTeG3hiof5oc8qqlbi2vDGclivu85d8h+bTFQ9r97vGWM/wHPBh6Y+iN
kfDWznZfRZhmlv3saa8LetOrUJqhDO33u3ht49ul0BtDb4y2t+Ag5kbDKbd9
x3w98GrytLCXSN8uu5fD+sbQG0NvjIS3KDTFhyx0cd9Z9tY3ht4YemOg+LYO
UCQLNbw+KmkeE9P8qDkSGK4l3uhNAvTG0BtDbwy9MfTG0Bsj560xcVApv4vN
QADWN4beGHpj6I2hN4beGHpj6I2hN4beGHpjnKQ9Pz8HPUupcpL2P9fANjc=

       "], {{0, 0}, {598.0000000000001, 1201.7500000000002`}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 598.0000000000001}, {0, 1201.7500000000002`}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnUtqG0EURQWZeAmeZiMZe5wNBAyGzDLRcjz3MkQg+9BSEn1sq6vq1Xuv
brcsKT4HDEmru2wdikv9++vjr++PX1ar1e/dz8/dz/7fd3d3KxjkKO0vDHK0
d+m/4vbAmwbeNPCmgTcNvGngTQNvGnjTwJtGwttmXXbN1pvOxc26vV7y8Pxy
umf/yPb5Yfrp9vjRw/Of9+u7i+e3MA71TQNvGnjTwJsG3jTwpoE3jdhb0cRq
21rVv82m2rQ9NmnvFY29SeOtLq38Xa9FHS8WN+/K3KwPBV+DN7DAmwbeNBLe
/ByrYqffe7VzssqxD/jGy0B908CbBt400vlWhZvRJCvD7XT/JNyKp8wkrAt5
Mcf0Lp+E1DcNvGngTSP2Vk0BWLFmR1MVZcXsQ5OWbZ/U7YceSrsk1DcNvGng
TSPhrTslut7ss+/QlnLmWJ3seg+3D/iiC0N908CbBt40hvKtv6LDvFK1wXoh
eSqz7LF6T3Vaks6sxz5FD3G8fjJL2y7uDQzwpoE3jYS3thnWS55yzK1s1Fmj
bX6CFc8eJkanhV8Y6psG3jTwppHOt26UWf1NfzDNTrDbgvqmgTcNvGmo+VZG
k93BrAPN6N6W06N1/7Tugfbah/32ZDDJ2/vvIt7AAG8aeNNIePNnB6YJY622
3U53WsVd3agbG4VeucquswTFb2Eu5Q0M8KaBN42EN7up01u9drpzYNbAGbiz
smi6M2J7Vj1dqG8aeNPAm8ZQvvUD6u2jxIRpHYOXXsmmQX3TwJsG3jSUfLND
rLfXYBJlXucxjMSq2eY9aHdyd49Pm5TNfrFyzd58b2CANw28aSS8heNjPomd
+EOd04ErzsRu89Fgn/f42Hz/nw28aeBNI+EtalbF534km1ht1Lzd2dmb7+6S
8G5eP1Wr6cw/b6Y3MMCbBt40Et60fMs3q8KkCtfX1bwO6xlTt14hTX95pjcw
wJsG3jQS3owe5Y9vZftn608rOPMOvVQshsu8lW/Zkv3yqy+yIt/OBN408KaR
8OYN1NvRkV4gN2lljZxMEu8Uqz+NVg6/37OgNzDAmwbeNGJv1thXNPXpbUSN
aDIwXDv3coEVJtQ3Dbxp4E0j4c0ap4oOhbNXaNz+sUjvUN808KaBNw28aeBN
A28aeNOIvdmzkJ2uYnVmb/RuGu+Icm/w36Sdye1MktblHJeLLO0NLPCmgTeN
2Ns03/p7252wcj9Kznu2n/phO2sA8DA7PNsbWOBNA28aCW9OLt32GNocqG8a
eNPAmwbeNPCmgTcNvGngTQNvGnjTwJvGeP+0eXNfdEZu4j2nVbfXutPbbNXi
TTFoEwrj3sAAbxp400h4S0VTe/THdA/XKthhunL2L/jHiTeB1nswdVb5qbRo
zfDxvlnqPyV408CbRsJbtEw3t/m9esXz8OFvufSb8xdOClzEGxjgTQNvGrE3
d9VZvx862F6yd0BcL9Q3Dbxp4E0jnW+ZZo/R/UwPss09sOiDob5p4E0DbxoJ
b9b5IfGgnHccXPd4cOMskbDDexmobxp408CbRuwtar/lX6rVcF1NsiGobxp4
08CbBt408KaBNw28aSS81f3T+YvH/gOobxp408CbhpBv1luoxl7vEu7Kv/4A
pb5p4E0DbxpD+ZbZiRCtv+3vUEhMZFxP7lHfNPCmgTeNoXxrsih7PlLvBn/K
tb8D4vJZR33TwJsG3jTm5VsP50UJvR1b5/+qi0J908CbBt40xvNt+v6s4KVX
Zhh2TuLN91u1s3y7v6I5DHMpb2CANw28aSS8lct0U4t7uxHk7efanvmrLgr1
TQNvGnjTwJsG3jTwpoE3Dbxp4E0Dbxp409hJu7+/b/qRELCT9g/QJy6j
       "], {{0, 0}, {598.0000000000001, 1109.7500000000002`}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 598.0000000000001}, {0, 1109.7500000000002`}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnTuO20gQQAU4mSNM6ot4U8W+gAEDBjbbRMdR7mNM4nvoHBt5NaMdiSK7
q6sfNRIJvwcMYJMUJTwUCtX/z9//+fr902az+ff49/fx7/XfT09PG+nkJO23
dHKy9+hfsT70xtAbQ28MvTH0xtAbQ28MvTH0xkh4e9mVm2jb/WF8a/dyn1/9
eIw3ht4YemOk89t2/2u/bWW5t/xWzofFW9cXm19RyKiT3zB65vLf1ndt9z93
N/UmBfTG0BtDbwy9MfTG0Bsj4a1Yv01LqaCQq9Vdmc82no+/aPSq0puLv237
7UujqX16brb+Pw69MfTG0BtDbwy9MfTGSHjr7H87FB87Pzl+z/Ej++36xiWM
N4beGHpj6I2hN4beGHpjpOu39/Ls91sNVupPm/ZuTa4EA52bTK/XcjDeGHpj
6I2Rzm9dAwrXjxUatm+TMS4t2cEMkHIruPTa4RDDpFE8+D2TGSO/pt87vXu8
NdObFNAbQ28MvTH0xtAbQ2+MhLfm+oXErIxSfbXGYYUzxhtDbwy9MdreCuOh
+elqp0UBQa5rNHuLLCEtGm8MvTH0xkh4a62NGvSYvWael11uDu1mMk13TRhv
DL0x9MbQG0NvDL0x9MZI129R9VW/Xm3J1mcCr2OWiPHG0BtDb4x0fiuv08ws
Xmh00OW78sJ+ucqEkMJyifGUvGkP4W28SQG9MfTG0BtDbwy9MfTGSHiLxxeS
9VV0t1p6tdu//1+5f5PWeGPojaE3ht4YemPojaE3RsJb185sj6mm7o/xxtAb
Q2+Mrvx23Tycu2P55OHeFm60b3lqk8zqWtfG4tOcNymgN4beGAlv+WwWJKja
jru1V9Uem2wjPFinH+e0xF6+w1vzvUkBvTH0xtAbQ28MvTH0xkh4S42fhlu9
DYmLtEWMjWYw3hh6Y+iNoTeG3hh6Y+iNka7fUmeV1jrNllmDzcF4Y+iNoTdG
Pr9l+JhjAadHNn+8lxbGG0NvDL0x0vkNzAbpyG+rK++MN4beGHpj6I2hN4be
GHpjpOu3Asn9jvIHpK6om854Y+iNoTdGOr8Fp1ANcldh895iopt+vNqYnb52
nFeTvXaFfZCClvV8b1JAbwy9MfTG0BtDbwy9MRLemi3QuHCKH1jrPBPjjaE3
ht4YbW+pnPaerMI2YJjBiovlg0UQd3ATYbwx9MbQGyPhrXd9VtiTVlmNtZSy
LI3xxtAbQ28MvTH0xtAbQ2+MtrdDcD5L+9CZ88XldJ3dBOONoTeG3hgJb832
aXircXxV9cnL9USfXm7dRCUbe37WHdEbQ28MvTH0xtAbQ2+MhLdo/Wlx0kjP
eVi1fX2XPm/EeGPojaE3ht4YemPojaE3Rrp+S5ZS5dps+fVYL8YbQ28MvTHa
3lqr5ue2Ky/vTzRmf9bWt7Kt5IY/uG/O8OnD1Pqfi94YemMkvFUSxSXVXOW0
1lBmcjuR3m3l2HEPw8du7k0K6I2hN0bCW9/xf5cro4P8oiNKoyzUV4yVC7yu
wu9W3qSA3hh6YyS8BWnh8etAH4XxxtAbQ28MvTH0xtAbQ28MvTH0xtAbQ2+M
dPs0HtxMduNff6S8IOtCbp7wdCR33PW3+3H72SbGG0NvDL0x0vktyCd5gn7+
YU5bAcYbQ28MvTHa3g7n6WHhQTPv0zy65nL0TvxYTvYz3hh6Y+iNkc5v47lq
o2NfWgtRI8bpsf4tg6T3wV5aGG8MvTH0xkh4i7raehYaDFcKxGcOrgDjjaE3
ht4YJL+d01Q4QNCzi8jg5TfbTqS5SiIes5jvTQrojaE3RsJbezjgNXlsdz+q
CeQ8Gbi9/CF3Stdf3748uI1qvDH0xtAboz+/zRs/Ha1UPZC17UvAeGPojaE3
Rj6/5fYAz2TCNY2T1jDeGHpj6I2hN4beGHpj6I2hN4beGHpj6I1xlPb8/Nxo
aMqEo7T/AK30wz0=
       "], {{0, 0}, {599.04, 1434.24}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 599.04}, {0, 1434.24}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnUtuIzcQQAVk4yN4m4tMtlrnAgMMMEB22eg43s8xtMkFcgIdxZFiWZa6
q8jiU2tkJe8BBjwtdqv9hijwUyR//fbn799+Wa1Wf+9//tj/HH5/enpaySBv
0l5lkDd7936Lx0NvDL0x9MbQG0NvDL0x9MbQG0NvDL0x9MbQG0NvjIK37eY4
5rR+2Z1+f7/yY/O6e1nHnx7ZbE8PCcocPt1uzr4lvn745/GLJs+8fJ9d+kWn
G7ebf+++uTcJ0BtDb4yR+BYGio9Po5izfvnrIyi1r1+EwR+Xke3yse+h755Y
3xh6Y+iNMR7fPppGl5Enat3tZnGp87SHwfrG0BtDb4y+t173M4tmZ420xkfT
oJd0PBshMStcKRb2Z/e/L+FNIvTG0BtDbwy9MfTG0Buj7y1qv523iOLxsXQg
rtFpzQbrgrvO6b5A+D6b71d1iK1vDL0x9MbQG0NvDL0x9MYoeGukYVSGy1ZJ
wyy5WGqntUb2rmyYLedNAvTG0Buj760+v9BM6sguTm5MijW7t1H6XCUXrlmy
M8vwVmiZ/4P/E3pj6I2hN4beGHpj6I3R93Zqv110Jy+7qLtsXuC9QNSum93Y
yaDrtOuiuYmlVisQbxKhN4beGHpj6I2hN4beGAVv2ShWfZZhOCN3aPahtjT1
/PYF5iAK3iRAbwy9MQre2jGnG8SaHdvm5GzzYhgMO1MJrcmI6Ute700C9MbQ
G0NvDL0x9MbQG6PgLe6fVjPfLnI/Cu2rfuHOpEPWLFw2L876xtAbQ2+Mgrfe
DObHFnCn4DO4mGsyelbaUO7OWN8YemPojTES39pNuLEloo3RvM8QvrpY3xh6
Y+iNMRLf0jiWpcA1d+6dLluYPbyT25a9QDnq9vbY3F3pTQL0xtAbo+CtOOwW
r4fKO6f9edL2EN99m3nWN4beGHpjjMQ3lh9SLP9gWN8YemPojTES3ybR6fVl
Xdrq9j+J9Y2hN4beGHpj6I2hN4beGLT91uqE3m5V++fB+sbQG0NvDBzfZt3V
cAs1dlJMuhlId/u4bMZ2/Nia671JgN4YemMUvJUWzg+uTYij06xYkovSX0B6
VjjOG1kVz8m6wpsE6I2hN0bBW3j4SyOytfPK5sXGAmMh1y77xsb7DMe6t9sG
ZYveIHpj6I2hN4beGHpjFLy1F5zOaRcIli2ky1p77bFWsnEzVe/rl812umXc
4t4kQG8MvTEK3ib9uLybOTiSNn/mA825Wt8YemPojVGPb/XV9Engatx7Nv3a
Gbv7LBnF1jeG3hh6Y/S9lc+OScJRda7z4glji+XvEPSsbwy9MfTGKHgbSuoo
9UPvFZQWxPrG0BtDb4yR+IbzdaPwGDQLmzkn1a5u8ZUaKcRLeZMAvTH0xih4
C0bGjge1pKmzSXhpdnXz54TNxTtjfWPojaE3RsXbISytN99nIasQo+bNpPD2
375+ebD+qvWNoTeG3hgFb6MDa0OfTsq0F3zVNvKdnQBYPoPm9L2LeJMAvTH0
xtAbQ28MvTH0xuh7qwya9QfiVsdVAz/jb/oZWN8YemPojVHwli9J6Kax5ccC
ZiXzx9bH/Ub3aLqRNwnQG0NvjIK3/oTmddGmMkD3/sztph5gJw8fWC92+Ouu
9yYBemPojVHwluSH9E5hXg23qW6Vq3YLrG8MvTH0xijHt24Ey660kn4fdzzO
+sbQG0NvjHJ8Kw2LVU4GDFM4so9qRw3OS+Zv29x2yfULt0ZvDL0x9MbQG0Nv
DL0xCt5Kab3xHpXNvN+HThexvjH0xtAbQ28MvTH0xtAbQ28MvTH0xtAbYy/t
+fk57URKwl7aP78wIdk=
       "], {{0, 0}, {599.04, 1203.84}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 599.04}, {0, 1203.84}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnUFuIzcQAAXk4if4mo/k7PN+IMACAXLLRc/xfZ+hi/8h5CWJvLIVzUw3
2SzLGimuAgysJc5Irm00yCHZ/PX7X9++/7LZbP4+/Px5+Hn998PDw0YGOUr7
RwY52lv7W9wfemPojaE3ht4YemPojaE3ht4YemMUvO22r02enl+en6ZjtO3u
9O7PBvvTv99fObvktfH++Ous5eHXK/yhF8Z4Y+iNoTdGOb/NstmMScpqtswu
//w/9aIYbwy9MfTGqOW3oPM2y2Od7Pdju3j3lBLPc+PygxofvSbGG0NvDL0x
+t727cw2zU7zIWqU65I2ZwPY2UdML39NletjvDH0xtAbo+BtkmSitBM9eYuT
2HlHbt5m9S7ZEMYbQ28MvTH0xtAbQ28MvTH63qbj0/mc6eThWHt8Gr7bmJhY
TrMu+nu7bTInu2iWdBpPN9/+MdZ/PF4GpX9h9MbQG6PgLUgI7ZUh7XmHeIQ7
nYCYJqUka62K8cbQG0NvjL63aH7hvcOTdYrmk57TuYOsI3edv/gyGG8MvTH0
xih4K06PBu/GXbWX9xFlZ83J8YbVD20OnBvfZ3mTS3mTAL0x9MYoeEtmQt+S
z3W+5s1hvDH0xtAbQ28MvTH0xtAbo+8tef522n0wOvP4/8B4Y+iNoTeG3hh6
Y+iNoTcGff42X8KR7NiavdXoBy5uHtctaW8Hy6Yb/rvtbnuZ3qbxxtAbQ2+M
en7rTT4uqiHFC9ha86F3NNA13hh6Y+iN0ffW2r+wzE6thbuzHfRnl+T7VcM1
J7v1t9gbbwy9MfTGKHjrrmpb7LGKpyTmjfNUeQfLTow3ht4YemOA/Bb0yvKK
InnVo3R7ad4PvCGMN4beGHpj1PPbUAXLWeP2LtRWR25eGPNWunbGG0NvDL0x
+t7SAh3RKz+2vfVy4YW3lbsqGG8MvTH0xtAbQ28MvTH0xih4Szawp8s8vsSO
BuONoTeG3hh9b53zFyaZ7fffTkWT+imxPQ/79spLu3xlckhNnnvL53x1BsvH
Rhf5L/hS6I2hN0bBWzshhBkmTikj8wibLLnldZDyWkmdFcXZVR/0JgF6Y+iN
UfBWr8a2TCbnZTDbmWc0PY5WO582W6TT83UsldH18aqS4n3hdl+GAW9yht4Y
BW+f1D3bBHtLS+fdB3RPlO6uV4naf9CbBOiNoTdG39tV14cMz2WMrrvrfdZ5
g495kwi9MfTG0BtDbwy9MfTGKHir7r2accFiRDeI8cbQG0NvjPH8NjrQO2tZ
3rW6qT3kXxHjjaE3ht4Y9fy26K11nsjlBTAryXBstcb1Md4YemPojVHOb2z+
9OeK3zwrNnJmr87SyoXgjDeG3hh6Y5TzW9itSrthyd6ERjXyO8N4Y+iNoTdG
Pb8lHaqBHU+z3VvhKcyHFs9P3Wb91R39fmNYt3N/vhvig94kQG8MvTEK3pIe
1y5b6rYpTCVkLHPgPDVNX7+CoRjjjaE3ht4YfW9D63sXiahfzPw+Md4YemPo
jVHw1i3ccZ1velsYbwy9MfTG0BtDbwy9MfTGKI9PA8JDTksnL/SORq3sGz29
sko5TeONoTeG3hgFb1Ei6u5EyBskZ83cGcYbQ28MvTFG8ttAHY9ldyvIclml
kfhWswYrY7wx9MbQG2Mkv6VZrjwIvWwBpTUx3hh6Y+iN0feWPH+rbWSolFm7
lZQ1hPHG0BtDb4xyfmutdusWSiqerTC/alIwPDxzof0pm7fZh/20LHBrR211
ucuxNff+VdEbQ28MvTH0xtAbQ2+MgrfK1qq8tHjQ14q3nbb6eFGHrXFtvmki
PP7mk7xJgN4YemP0ve3jI2CWz99m++LfGzRHoO150lYlpaDZwKkNH94j1vcm
EXpj6I1R8JamoMUu++5ZqHleapZ6W1x4DTNtjDeG3hh6Y/S97dNB4uDEQfv8
+pvIWnWMN4beGHpj6I2hN4beGHpj6I2hN4beGHpj6I2hN4beGHpjHKQ9Pj5u
ZJCDtH8BX7FhHQ==
       "], {{0, 0}, {599.04, 1296.}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 599.04}, {0, 1296.}}]},
    {
     GraphicsBox[RasterBox[CompressedData["
1:eJztnU1OG0EUBi1lwxHY5iJZs84FIiFFyi4bH4d9VjmDN9xjjkIMxmF+Xne/
rjEwiCoJydjjGSi1PvXfm/l6+/v77Zfdbvf3+PPr+PP4+urqaiednKQ9SCcn
e+/9V3w89MbQG0NvDL0x9MbQG0NvDL0x9MZIeDvsn8dkN3fD/9eTX/eHt/lj
N4TtjaE3ht4YbW/D3c0pze5PL8bMEm/8ZvjR8jzlw/7s/0frU35WzznMjgyv
9cz0mPCKxxOu9iYRemPojaE3ht4YemPojdH2NnR0gfY/P8tQ1fbG0BtDbwyQ
b8twi+KuOFk3+db85Dc/vu0PrSvGl7s/j6OH9oRhgdl313mTCL0x9MZIeCvF
RRgvpfypxEhlzSI+yXySrfJXjSbx6l8cfdSefMt5kwC9MfTG0BtDbwy9MfTG
SHhbDEXP48dogLmbd89Sq6XPn36g6TvbG0NvDL0xevNtMZorJ9t4pDlMU+4l
9JoBuNzjMRt1Vvao9L3Tla2nr3DvnxW9MfTGaHtrrZ+GywTFDWmVubJisq3r
EA6jLK1N7qWm3Tq8SYTeGHpjJLxF654P00WB6TR+dFijl5WOweXlCmdu7+yt
h+16bxKgN4beGAlv9a3+49yIU2WZLeWcSQ82g65d/aKVqorTvF/H4mnOmwTo
jaE3RsJbZeNZu2Aqf2Q9JFsj4vgq6/qQK71JgN4YemMkvBUn/BOFnKVUKVEP
qNJFc6PR6cTd40bick1rc63hdNhq/Z8OvTH0xmh7y9ZnNYeZL0cWpv2L31o1
O7dcfq2Ndi/nTSL0xtAbo+0tHgmeY+ewr49Yq9FUmq8LE69SbNXu9VWHzMsz
X8KbROiNoTdGwltxT0WiLHSSJ+chYXD8YiFg/t1oW0jfjo7LYntj6I2hN0Y+
3yrU58RSZQ7DG/yvl8T2xtAbQ2+Mtrch3E+bKTSYR1+8E3i+d64+j5cqwC8Q
nu3VvEmE3hh6Y7S9xffvrc6Gpcuvyjs9zp8elhvtNoHtjaE3ht4YCW/5iqp5
Ot3dZCbcxid8/X/4QtjeGHpj6I3Rn2+ZO0kukjB4mMIkCYu7UIbxtWh9xHKL
SGYovdabBOiNoTdG21u5dr7wTrt46qlXN+7avU4NKZsPHC7kTSL0xtAbI+Et
XwJfuiNucABZHciuRCQrJpp3913pTQL0xtAbI+EtPQgtFnLWS9ovfOagezl5
8F+u7zes9yYBemPojZHwlpzUWh4TJkxA77MPtoDtjaE3ht4Y+XyLOjmlyvSO
6qqe2tINBaDtjaE3ht4YvfnW+yjAxmOwtrq9rYntjaE3ht4Y+XzrHZ/W71se
Rt/zlrn2E1ffvxdne2PojaE3RttbUJ8FBpvl+1sucjIo299eN8/2xtAbQ2+M
znzL7OuY3d4t/7z7V/9nL4jtjaE3ht4Yvfn2EkezkoRaDFar8mvvhK8zaxCZ
xYtV5fZtbxKhN4beGAlvyQ1j9duJ1NIp0yeMt7otN+gWHrSauEeT+3vfAr0x
9MbQG0NvDL0x9MZIeEvu18XP7IuPeSpQ3S62N4beGHpjpPOt6+F6mU/jc6Z3
obwztjeG3hh6Y6TzLUPjPkiVyNpIauWxvTH0xtAbozffcuVXk0Bb8zTAzYae
7Y2hN4beGHpj6I2hN4beGHpj6I2hN4beGEdp19fX8chSyhyl/QOgYGyF
       "], {{0, 0}, {598.0000000000001, 994.7500000000001}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 598.0000000000001}, {0, 994.7500000000001}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnT1uG0kUBgk40RGU+iKOGe8FDBgwsNkmPI7yPQYTJ3sKHUVLaUSRnHlv
+nVxKJFSFSDDFudHKLU/9H9///XPX7++rVar/3Zff+++nv9+d3e3kk4GaU/S
yWDvo3+K20NvDL0x9MbQG0NvDL0x9MbQG0NvDL0x9MbQG0NvjIK37Sbuglo/
/Lt5enxYJz1Um+3xveuHx+lzDt8sXLz/6E/4xviW3WMf1rs/Dh89v+j1Z57e
svvOgt4kQG8MvTHa3k4TbBxEQdqc5Mbp9fFlpSTcZenrNaOXdoTSgljeGHpj
6I1R8LZPlWltZ5wz41x6Dq7toY43yrqXf94qljeG3hh6Y+iNoTeG3hh6Y5Tr
b0E9LW97nly/+X3TNbUYyxtDbwy9Mc7JtzDNejvfWjmZve74+/GgQ/LY4668
8IGlDr3hnnPtfz30xtAbo+BtvoaW589pjDQGLitdeU8d+XNpLG8MvTH0xjgn
304zh00FOX7ULWF5Y+iNoTdG21s+w22mrZpE3zjfytPemp/urxm3Pevt5aW9
SYTeGHpjFLx1zl7r6Qr7+WOzfWu0Ht1Y67irNI2z+cD7uStp0p7vTQL0xtAb
o+Ct3UU/VyVrLTeoVeHySb+PjY67yStWtdb0+d4kQG8MvTEK3rL5vR2xFszs
zZdFlCuEH4nljaE3ht4Y5XzLqjpvzIyKNrrOPjysAJY3ht4YemP05Ns0za5i
qsaHYHlj6I2hN4beGHpj6I2hN0bbWzw/pDTvomf6R/Dkc0ZmL70o7BOXt+3m
gtXyT+ztouiNUfCWJcxpEB1vEpJMmRttJxIk2/Ow7G1geWPojaE3Rk++RYm0
RF0rX8k1essVdfdZ3hh6Y+iN0Zlv+2GF1nLRWrKtalPRjiP0WrC8MfTG0Buj
5m0YKk0nws3n2JBLzzWy9eb3bNwNixmuqJaWU/F20Y6sG8X/pwy9MfTG0BtD
bwy9MQreZlfHz62+H3B/SzmgN4beGG1vQYLNLUzo2TTp6IHRUGxh2Wl4BlbX
UtPRT76cN4nQG0NvDL0x9MbQG0NvjIK3jjWnS80SiU7aSrfHfDnf9L2bwJY3
ht4YemO0vYXt07QNmObY59i29w3LG0NvDL0xCt5aZyXU5sKN9pNctY+Sr2wK
9x6KQixvDL0x9MboyrfKgYDnrEVtbhO3GqfiJdXMYnlj6I2hN0bbW5gw00rd
TLUtraRNH3szWN4YemPojVHwdsb+lsfnIJR2Dh/dNfeKwkyS0QPLG5gUlvkP
ly7yK/hS6I2hN4beGHpj6I2hN0bBW2m8YF8TW34P8w+Z/tHE8sbQG0NvDJxv
r+mUH6SVfWf2o47lBoeHbKft2b7ngDGL4cYzxH9R9MbQG6PgjfS/5Xu4Jfem
fW7dDywMf4Tp1zcaO9yMtX9Z9MbQG6PgLenqjxIpqU1Ft8cbYyZ5Ndn1d7Ki
4b2xvDH0xtAboyvf8g1DZo5jSOtOV9en1oPljaE3ht4YXfl2yKiTyltzuVbz
VPrTBmPH5sDzHYCzk0aO3jI+P2IZbxKgN4beGAVvhcZmvjR+SrKBUvTY8tbl
+XvzEyKCnQGW9SYBemPojVHwFmZRNTfo9TMp1LH3SHMO8L7D8BLeJEBvDL0x
9MbQG0NvDL0xCt5KXVhRjeu6TmReFssbQ28MvTHa3srT2NKdyf8ELcTaNiPh
G+vnpU7Jxj66tyJpe5MIvTH0xih4Kw4crH/+eFlKFX3WnHObdqy1Vm8lg7DZ
LXHYRrc0Em+4aJnfwVdCbwy9MQreGu3NUTIUKmDJE4IJwzjfsvHW9/QmAXpj
6I2hN4beGHpj6I2hN4beGHpj6I2xk3Z/f99oO8qEnbT/AWpipfw=
       "], {{0, 0}, {598.0000000000001, 1155.7500000000002`}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 598.0000000000001}, {0, 1155.7500000000002`}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnTluW0kQQAk40RGU+iITM/YFBjBgwNkkPI5yH4OJkjmFjjJDm5b0l6ru
6ve10XwPkGHyr3xoFHqp7v789Z8vXz/tdrt/T3/fT38//39zc7OTQc7S/pNB
zvbe+y0uD70x9MbQG0NvDL0x9MbQG0NvDL0xCt6Oh+dm2f7uYfoxY3/34zC5
cHHV88fD8W1+5ctjeWPojaE3Rjm+TWPUOspNA9rs6K8Iln7cTb8/HsJD2VXv
Gxstbwy9MfTGKMe3MKxN4tvqUBSU4jtcYi3O8sbQG0NvjJH4to5Up3/f5jU/
HJY3ht4YemPojaE3ht4YemPQ+lvY6gybn/vDt0tsgHawvDH0xtAbA8S3bIxg
3m6tDbPe3+37N58Pbfy+pP+I1ljG5tGK81Xjvq8dvTH0xih4q8e3xvDB7Puf
3zwsI9vs6HwsNQ56yYht8z0XiSvpy3fD3fm0jfKvEL0x9MYoeGtVk05x4Hj4
9U8UJWZRZR7QpsFnHoiyilkr7WT9VtHRMLgt65DFitz55A3irxS9MfTGKHgL
o8oyCsGAE3TcNbNQJrEorhbG2chpgnH0Mk+32uhNAvTG0Buj4O0F8t+WNbRV
t1sYr36f3Kp0dW9ViZxZuvJGbxKgN4beGAVv5r8FWN4YemPojaE3ht4YemPo
jdH3Fg90ztp9f2SGWxvLG0NvDL0x9MbQG0NvDL0xaP1tmaWWJs3maSFJbbCT
HTe96h3rjZY3ht4YemMUvOVjl8lwaiFzYxHWKvMdVjGwnwOc3qG5HFN/8LTm
TQL0xtAbo+Ctkh/yGBZm9a7e+Wm+bpSwUUhN2ZyF8rLeJEBvDL0xCt7MDwmw
vDH0xtAbQ28MvTH0xtAbY6T+9uqNxAvKM7G8MfTG0BtjvH3ansvZ+Lg6tHml
o+ejlfVGOk9ZvOp2bxKgN4beGAVvSf9bVDHLI0Y1gaRw8/3ffx2OD0+x8Q0k
BVjeGHpj6I0xHt+SqfRRxtrp+7v9NBatb/UmP/IVsLwx9MbQG2M8vi2iXLMF
Ou2U66fsTjNMOkshrR+xOrO7gtPkJ9wP1wYL3iRAbwy9MQreOmsWVZYBjzN+
006z9n7QcOXzxa1mrxFMstjuTQL0xtAbo+Cts37vyCSCedfZooZ27Kw3XnmB
9RNbC5KjlXvL3iRAbwy9Mfrelu3KZcTo1qkabcbK5bNHr2tfabM3bH52+xKr
TdTz2ZvUXyV6Y+iNUfCWhaaRDq5SDkl5lfKRyar1mV+rMzd6kwC9MfTGKHhz
flaA5Y2hN4beGHpj6I2hN4beGPX6W74tcndrqt1lzb2qYHlj6I2hNwZtn6YR
bx3ZxjepX3+Zds29V9C0vDH0xtAbYyS+dbYNLWzTPFsj7qLrc5Y3ht4YemNs
jm9BoHv+5r6z3GUhp3dec2vOS03m7z8+KJzoGv0i83tfD70x9MbQG0NvDL0x
9MYoeOv3sP1hYwcVLG8MvTH0xuh7SxYGSaZTjbdhf9Tvk05EzTfzat9zccMX
9SYRemPojTEU36a9WEGESTeXGVssrrz9VuVoFj/TC4uB7nwytX696I2hN0bB
WzZqUJoF3w6Jx8PTdPtduR74ISZNWN4YemPojTEe38JYl0S2vAm5S8Y0L6Uj
z/LG0BtDb4yh+NbNcOs0FbNMudGNStdLmvTbv7u8fhhe7vz6V0FvDL0x+t6K
6+6GHVnjeyt0t2xoPHEw2Tj8vrrR8/nszfqvDr0x9Mboe+ulxVYWD69ObShN
2tp9hC44yxtDbwy9MQreKkOTj0GsOro6ttjaB8TyxtAbQ28MvTH0xtAbQ28M
vTH0xtAbQ2+Mk7Tb29u4ASo5J2n/A2AkmNI=
       "], {{0, 0}, {598.0000000000001, 1155.7500000000002`}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 598.0000000000001}, {0, 1155.7500000000002`}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnU1uGzkUBgVk4yN4m4vMWuu5wAABBsguGx1H+5xi4M3cQ0fxWFE07mY/
ko+lliXBVYCBpNVqORXiA38eqa/ffvz57ctms/nn7ef728/xz09PTxsZ5CTt
VQY52bv1b/F46I2hN4beGHpj6I2hN4beGHpj6I3R93bYbxejs93L6+vL7vgz
vfL+1+3+8P7S5v3iR/yLPgbbG0NvDL0xEt6mSbXd/xvE3STBJhEX3TmJweCG
eUier8wCdrv/uSvuiT49eFTvFy5+7U4an+5e5b/gU6E3ht4YCW9lSkTRsd39
vXuZBFGiO1fkyfld54fUA+ou+oG2N4beGHpjDOVbs1PUCLHgnvBRvy4+BrY3
ht4YemMM5VsYYkVSVTKwPRJcvHQ4j2EPi+HqousY3RyOjouLzaHu8aULvUmA
3hh6YyS8NSa77mKoeBNsbwy9MfTG0BtDbwy9MfTG6HuL6kOKmbSX3QPNnK2D
7Y2hN4beGHpj6I2hN4beGGz+rVn+UVskrRX9tlZd77ZzaHtj6I2hN0bfWzw+
DYKuWbFWWzwNnlNhHpuL36rYUjH0wPnFlbxJhN4YemMkvOXKdDsJ1t6tUHvy
vOSjU1/XKa77fc/P3SQbp7Ulq3uTAL0x9MbQG0NvDL0x9MZIeGvX9047ZrOK
2UT3bPnY6lTe/1eOG8E+QkwH2xtDbwy9MQbzbRpo/aUBNDVXizv8cckzAYrP
utybBOiNoTdGwltjB1N3afV8pbr1vhV9kz37d3fgku2NoTeG3hij+VZfpmz1
r9q33cWAcxDbG0NvDL0xRvNt0ndKrHh2joCbvzHoEGY+pXhmNWbb3cj5w1fx
JgF6Y+iNkfDm/voA2xtDbwy9MfTG0BtDbwy9Mcb7b90y2tHVz+wRvsFZ5c0Z
v6tu7LK9MfTG0BtjPN/KGNlvpyeTL7YtDBV4BHvBut+qUEzcNU7LnFwpS1zC
Cb0LvUmA3hh6YyS85U/QjQKkus+0HX3LtYnW/eOHBlf+eljRmwTojaE3RsJb
bV0ys99zfn+4QrpIwrCC7thLLKvmbontjaE3ht4Y6XwbirhKOW5cEvyQi7C2
N4beGHpj6I2hN4beGHpjjPTfpmPDzPTXsp82uK7amz274V572xtDbwy9MdL5
Fi819jaTFuetxWGYOotyPrZ1/u1B0RtDb4y+t3TJWe4rnjf10HskbG8MvTH0
xkh4S0XWr6Fie/jZ/27o37f1v5q5pNj1n9+4WrmyijcJ0BtDb4yEt1ogNI4c
Z0W2V8urasnx8mkrepMAvTH0xkh4y5Xjkr0Ji3iJCkiq+xpSp1aen5A7xS4/
TD7df4n5z4neGHpj6I2hN4beGHpjJLy19nsmyno7Ly2GouOHmVdOEi7e0lyl
HS41Ob0NKf/U6I2hN0bC27zeY2Rkmtus2t892isgSeVefYxMzrI7vZM5/8zo
jaE3RsJbvd+1yK6//pieJdKNoPIllmOrfqjf73xd9MbQGyPhLVMfsqlP+McL
E7nD3LrZ1elPtsek84hb3ZsE6I2hN0bCW6r+7RhE1ZNGqu9KlJqc7xz6KodO
LUo8Rp4cUeL3A14LvTH0xuh7u1ptRiUSLzqIqXfkb/HYa3qTCL0x9Mboe2vW
rS26PberkftYbG8MvTH0xkh4659I2Uue28fR6tjeGHpj6I2R80bnwYLdAfXZ
/npahl2724ak7Y2hN4beGHpj6I2hN4beGHpj6I2hN4beGG/Snp+f4yGj1HmT
9h84BUtF
       "], {{0, 0}, {599.04, 1088.6399999999999`}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 599.04}, {0, 1088.6399999999999`}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnU1uGzkUBgXMxkfwdi6S2Xo9FwgQYIDZzcbH8T7H0CZXmHUfJdGPFfXP
I/lYaskSXAUYSKTudrtAfCDZj+w/v/3397c/NpvN/7uff3c/+38/PT1tpJOj
tJ/SydHeR9/F46E3ht4YemPojaE3ht4YemPojaE3RsLb9jUeor28fX89ffvy
9uPtZfzV8H7W63Z2hfNXVQ4XH+JrLtn/ltPB09+4O+ujvEmA3hh6Y7B8C1Lr
nHWjD99Db5Z+syuMg6sUYpPPD+d+MLY3ht4YemO0vQ3zaJrHVPWAqCd2OnE7
6v4NN/lr18P2xtAbQ2+MhLfccDIekIb9sa6DyxcJe4zDcizcHBGTzuHx4Avl
f0L0xtAbo+0t7p4FQ85CaISZ02QSX4vO3igSG7exqcbpNb1JhN4YemMkvI3C
YZp1i1m4UoLNPylMvgVMk218wWuLaWB7Y+iNoTdGPt+qWRRPskWBVrrOx0dW
F7Y3ht4YemPojaE3ht4YemO0vVXn33Yds+3rPdRr3BrbG0NvDL0x9MbQG0Nv
DL0xEt6iubLfhbu1NQX7nt9hWi1f9TG7fvDV6z930V20vTH0xtAbo+2tUb67
6a9nm547qwOJ/t261D5E97f519cv0V1l72RY1ZtE6I2hN0bCW6m0o1QfMg2N
aRVudEqpt1apKgmuU76ZWkfx65fDDGJwkUbcHY+/zP1nRG8MvTES3hrFtLgK
rnB8cFiciqX64flN5lcxrOtNAvTG0Bsj4a3SKXqworUVsb0x9MbQG0NvDL0x
9MbQG6Or/9Ycis4fCnSNZ1MPGjI7lsTj2XUfvNreGHpj6I3RlW+/s6I8LV+J
GrrQfjmPN69OSSxind9D+4Hsxd4kQG8MvTES3mpPS+uPUJt9reIul8WO371g
e2PojaE3Rj7fyrR7Yl11cXeVYyVsbwy9MfTG6Mm36oqD4iiyeG5il6TiexwW
PcPuTc6Xn3Tl6vEUav3zojeG3hh6Y+iNoTeG3hgJb6n+250sC70ZtjeG3hh6
Y7S9lfZH6hkP9q9L7T295xFqPHCe/bqLvUmE3hh6YyS8NcszFklSfBVpe/qu
dEp1wm304ayIbh7OlRezjq+wijcJ0BtDb4yEt7X6XfkKk0Z93T2MhG1vDL0x
9MboybdTfDX7b4kNRgqlcQ+zoNX2xtAbQ2+MtrdRChXHdD+mxwyZ3S8vGsbG
/13sHLLvB57vP168UF50dpk3idAbQ2+MhDf3DwmwvTH0xtAbQ28MvTH0xtAb
I99/a44iyzUYcLvd0jGzubvCiPi6JXm2N4beGHpjtL0F81ejLEq8aGYefY19
eh8D2xtDbwy9MdL51ruIPvvJOSoz3bZtqjjtBtjeGHpj6I2R8Naxf0i94K37
3TSlZRG5EtyrYntj6I2hN8Yl+bbIqGIf79T1Wgxvz8sNHuxRrO2NoTeG3hht
b7XxaeU5QveWR62LRLN/35eZWX8O0kzg9bxJhN4YemPojaE3ht4YemMkvHW9
WKG50WXYy6qQ30Xkpns02d4YemPojYHzrZJdYYg10yl4W/1igWpl8df7ADP3
tHcSzuM5wHO5y+XeJEBvDL0xEt5q81e1eo/p5Fh9XWpi4q7wFvtgCq7xkqxq
6q7oTQL0xtAbo+1taKxEqEbN6ZRt/G7TdnbVq4uHa+spYntj6I2hN0Yy35pv
dg4yLeqPxTk2XP3PXB3bG0NvDL0x9MbQG0NvDL0xEt4yKw7CKa/8e/o2D/eG
GtsbQ28MvTHy+YZeoFAKRrhUP12UUry9wv0sj7/cmwTojaE3RsKb+1sG2N4Y
emPojaE3ht4YemPojUH7b5vDC64eacZsXWxvDL0x9MbQG0NvDL0x9MbQG0Nv
DL0x9MbYSXt+fo4GoFJjJ+0Xn5LuAQ==
       "], {{0, 0}, {598.0000000000001, 1224.7500000000002`}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 598.0000000000001}, {0, 1224.7500000000002`}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnUGO2zYUQA10M0eYbS/Stde5QIEABbrrxsfxPsfwphfoCXyUVDNqxpZE
8n8+2bGneg9IMONIsvBCfHySn+SvX//68vWX3W73z/Dnz+HP288vLy876WSU
9l06Ge09+i0+H3pj6I2hN4beGHpj6I2hN4beGHpjxN7Ox32qx7Y/nn/SOz8D
tjeG3hh6Y+iNoTeG3hh6Y3Tlb4fT8PvpEKdw19cMHxZv2R+/HerJYfGuJ0oR
bW8MvTH0xtAbQ28MvTH0xkh4G/Oo/fHv9kBcMXlrZWW1bHD5+dsnrUzvnoIq
2N4YemPojaE3ht4YemPojZHwVs7HhpzqdHj/a0yiytldNeu7Sslm1zQSxdpQ
3vSx36cp4jzx2x/+eL/q7t6kgN4YemMkvH2Ei3LkqXQzL7Go3ru8jldPNHeQ
wfbG0BtDb4ye+NYxYtYYapteHKdkhWj5BNjeGHpj6I3RE9/msagetSpzBLmw
Vo6WjX7uI7C9MfTG0BujJ75VaQS3qGTu+oLP1EW1vTH0xtAbozO+feRdYb/y
knHNM7dWnUm9GPic797WJztuN9w3PmXVIzaJ3hh6Y+iNoTeG3hh6YyS8Zcb/
GylWLcsqPSGVdzXmaoMvauZ+fXUj4z0rxG8UvTH0xkh4WznX2XV7b5B8X8Ra
nYxIdKKr6ymCDux40W3+D7aE3hh6Y+iNoTeG3hh6Y8TeaqW5l77kbVYEfC5s
bwy9MfTG0BtDbwy9MfTGSHgrjHptMGGbYXtj6I2hNwaKb/8xLc0dfkhOQOxq
M550KevyewtvkinDy0ft8XqsfbPojaE3RuwtPn/hehIzLtCtxZ/ik3//7XC6
vECyDiT8rtJCs4/NTM438iYl9MbQGyPhbe3+ITuyvh5Vgyxe7zrfay+J7e1v
294YemPojZHwlow/6eq4aYzqqZFLbf8bPadw7gMIdOONq9RvEr0x9MZIeMsE
n3zkqdxeyAyDHdHfvuXUDJXRaoiugt5+b1JAbwy9MfTG0BtDbwy9MRLeymP1
4YZvlemA3p3fAn5sk/6zsb0x9MbQG6MrvhXjz6JKJI5jVzzdxrxJbG8MvTH0
xuiKb4ugFJaZ1WJdNOlZyeJ+jLk9HtsbQ28MvTH641txd45UmUe+SmT41+P+
43Cu4vX3FhNge2PojaE3RuytWd/bClldxXLfniIry2N7Y+iNoTdGwlt+pcAk
jkUJWL3UZHYc6lW9XHF9VvM8mtbTKk9IJYfjpSvlbxC9MfTGSHhDO/F2FPHW
C9K6MsDUOF497l1GFG/lTQrojaE3ht4YemPojaE3RsJbb8KW2Lsjvc3I027E
ZHtj6I2hN8Yd4tvVh/OZ1q5qkOn8LF3aX7nS8wEfg94YemPE3grbE7UiSTsE
5VYotKYt5mFqsVh+8YTGOtb2cTbrvEkJvTH0xtAbQ28MvTH0xoi9BefLPO8Q
2V2xvTH0xtAbQ28MvTH0xtAbg+dvmcVZ9PDlnv1+M7vShW/bnYWOt2Htm0Vv
DL0xEt4K0SMx6RmM8GemTePIVtnB8u3UhtakRmN/gOxKsfHqVeo3id4YemMk
vHVt11adrOzZLy4IRJVTtDLlIkH65/lZ90ZvDL0xEt6qvb9ZmhRFm1YV3CTg
NI+Jmf66WGbVShRbga53Cep43Wr9m0NvDL0xYm/n4jrN/F67k5hTD02LoFQ+
9+rxOyON2N4YemPojZHw1t5qsp0a5QfT3L93E+iNoTdGf3yLt7K81Qmn7dNL
SzQnDqqvcSdvUkBvDL0xEt7+z8coYGxvDL0x9MbQG0NvDL0x9MbQG0NvDL0x
9MYYpL2+vsYdUJkySPsXekcFoA==
       "], {{0, 0}, {598.0000000000001, 1201.7500000000002`}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 598.0000000000001}, {0, 1201.7500000000002`}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnUtuGzkQQDsYDOAjeDsXmbXWc4EAAQaYXTY6jvc+hja+Rx/FI0tW1J8i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       "], {{0, 0}, {598.0000000000001, 1500.7500000000002`}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 598.0000000000001}, {0, 1500.7500000000002`}}]},
    {
     GraphicsBox[RasterBox[CompressedData["
1:eJztnU2OGkkUBpFm00fo7VzE617PBSxZGml2s+E4ve9j9Mb3QHMSDw0y1M97
lS+jaAMmQmoJUFaBw6lP+V9/fvv3r29/bDab//Z//+z/Pl4/PT1tpJOjtB/S
ydHetX/F/aE3ht4YemPojaE3ht4YemPojaE3RsHb+/ZQZvt+fr3ZvLzuTq/n
bw+ffH99GbwfXx7y8vXLvtSoTHTV6bv2Lz5bT4r1jaE3ht4Y9XwLE2kYax9Z
tBtm2jz0xte+bcPAnN3n8Mn7qXCUpaNbzb/9FLbDbGyE7XJ4Hgtd7L/hYdAb
Q2+MgreszZaFySRSJgWCm1SadtFXT2MtCNifv2GemfPbHn7GBb1JgN4YemO0
vQWxEATIdXuLvx7rG0NvDL0x9MbQG0NvDL0xCt7C+YW0ozcpll8VdGm3f3f1
Ea+J9Y2hN4beGG1vu8EQVn++DYknQwdjaMNRstbXfa6WJtY3ht4YemMUvDVb
X1m4TZeI5Cl3E5HVhfWNoTeG3hid+RZPgw4jK2t3jdd4xEzvszS1cSp/Haxv
DL0x9MbozLdJyoWfzBebNdMsLpkVuIVBOusbQ28MvTF68m1x/dusK5o36hb6
rXeD9Y2hN4beGG1vpfVvdzZ6th7rG0NvDL0x9MbQG0NvDL0xCt6W+5X3tGjt
gljfGHpj6I3Rl2/5fEEyF5DsG23sbR/c830bDeJdvztsfWPojaE3RttbZZFG
sCg3XEmysE3+zrC+MfTG0Buj4K3RP23F1zgJwzZe1zLg7+EGh2KbMDpy5LO8
SYDeGHpjtL0V5k8fcADO+sbQG0NvDL0x9MbQG0NvjIK3eItBZU/WuZnXOcuQ
b7S/lTlc6xtDbwy9Mcr51kikWWp1jMudr30LZ0uzr0ivjUp27Rq7iDcJ0BtD
b4y2t+Xxt9HJIQ+E9Y2hN4beGHpj6I2hN4beGAVvtcN4ozUeWWMv5PBowLtp
BlrfGHpj6I3RlW+tWLvAuUnzY+L6Jy/S+9duXtoccSy61v7joTeG3hhtb9Xn
Z1WT4ffA+sbQG0NvDL0x9MbQG0NvjII3tOUq7zMW9lVNT+u9wXE56xtDbwy9
MXrzLXmMQnF12dJT7EdfkR5LXo7Nrj2t07Vz7Y72sdxa+4+H3hh6YxS8pdsW
zmlwCrfFWdTF4f1J4gUBGG1quNqIn/WNoTeG3hi9+XbOn1Gbp94hnUTivS4M
tr4x9MbQG6OcbwsJVhpD+2i5Tadil09JKnVmTyz3XlslT59f0JsE6I2hN0bb
W3V9yAMtDvlhfaPojaE3ht4YemPojaE3RsFb+xCP8bPms+7kb/UkGusbQ28M
vTFo/7S5cmPEOAAX7jbp8EZTqAszsOlmseb22O6DUI6XrXP/iOiNoTdGwVsx
JdJm2/CqfXq8vhxW7DYSKeZ22n/WN4beGHpj9ORbHGtfv8zzqpZU4xbd7WRX
BesbQ28MvTFW59s0rCZ91VqPsridgezt6tjysLusNwnQG0NvjIK3dGlu/LZ5
+newEG55BC9aerf8G1qH0a1vKx7vs/Yuj4feGHpjtL0F8wJR4LxtF5/yXAqu
nqZafYIji7vmgQDrvEmE3hh6YxS85WdFFvYLlGPq+KK04+AWRuqsbwy9MfTG
KOdb8XlYlYPKN9H21V/zz70Y1jeG3hh6Y7S9lfZn3V9ArcT6xtAbQ28MvTH0
xtAbQ2+MgrfWwH5jAmI09ZAXm79NG423sM/L+sbQG0NvjJ58a09EzicCBrsV
ggKN2+ZDeYNcvU7X2PrG0BtDb4yefJslzGDh7vIO02zZ2+Z6AbUS6xtDbwy9
MXC+5b3Lya6EyvKz8edJsy3eCrFbswNi83Mm9zO8SYDeGHpjFLw191KFh36s
CJz0YPPhXtewwPLvzH7DfKnwRbxJgN4YemMUvDUfZVWcJrjLfmiG9Y2hN4be
GHpj6I2hN4beGHpj6I2hN4beGHtpz8/PyRiVpOyl/Q+mUS9R
       "], {{0, 0}, {599.04, 1296.}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 599.04}, {0, 1296.}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnU1u20gUBgnMxkfwdi6StdZzgQABBphdNjqO91nnBN7MPXSUjMaMI4p8
3f26SEa2VQUYMCS2fgqND6/ZP/rzy9e/vvwxDMP3898/57///394eBikk1Ha
D+lktHfrT/H+0BtDbwy9MfTG0BtDbwy9MfTG0Buj7e30dCiM0Y7P56efj4v/
h+Hw9O+s1eHp9OvZ+BUuV/5sGzeJ2o5Xhtcfjn+/XPj7vUmE3hh6Y9B8W4ZJ
KY4uj88zMIqj4sX9gRmF56T5t+P02deLzy+7kTeJ0BtDb4yEt2mNFGbLLCsa
wVUNqOt3ucq0ejl3+PzpHFGlKm6edYuk3cObBOiNoTdGwtt1lF2nR7kkW1Zc
9ZgiIXND7G8MvTH0xujMt6gueg4HerP/w7gLK7RSME7f7vbY3xh6Y+iN0fZ2
mt7tb4XPdtMNjbtnp529tLC/MfTG0BsjnW+1XLo8O7kRtwyoUmTtMsG5M/Y3
ht4YemMkvNVvqcUVXWKqtPbUvJCbz+H+atU3BzGbM73+/LMJlPXeJEBvDL0x
9MbQG0NvDL0xEt5q8wvzAqm6Ineo36Orll47LdPF2N8YemPojbEu36YjvsmY
sbJSLr3WtznXcNu8s78x9MbQG6Mn3zpvdtUW9E7D8Pd80Y2xvzH0xtAboyff
6rFWLNVGfi5dC3Z7Veq9SdvKErvFay7qvcRW1ufjoslKbxKgN4beGAlvmQVp
IckSbnlBqzLMrcGrf4DC13H/6b7ojaE3RsLbimW9qTS7fmTzw0Mm1V3P7Ib1
2y7ojaE3RsJbbSQYhsOqc0LCi4OzPm6M/Y2hN4beGG1v25+PVFkS/G6wvzH0
xtAbI+GtWVC1l71VYjC3jSu3S+J6enfFiUmD49Od0BtDb4yEt54luJdiL1wO
1wqojt1VmT37lbt5l+asbhxfhbS8b/TG0Bsj4a0nc7rnKyuAIzGLzFanFO4l
jl9nK28SoDeG3hgJb2uOrMyOYeMxKd8QUfzA5WFp30rjsTlSftfojaE3Rttb
9Xyk8qTq67PButnqZGspQt/YlIT9jaE3ht4YCW+NuuvpMN7GD/KqfX7vaf9v
uA/2N4beGHpjrMu3FQdavvNjgccGQPidozeG3hgJb/XB4+rzLVvNq+dbLt8r
eovtjrXs8SYBemPojaE3ht4YemPojZHw1rmoY14slWY/k6uCK6VabgncbL61
tb/19Y7iem8SoDeG3hgJb+n1t11bSpdBFByVOZQGsCvfsbocJTUtO7ZZa//+
0BtDbwy9MfTG0BtDb4yEt0Zd9LLN8+6wvzH0xtAbY0W+dQ0PKyPBxlC0eBBl
MCsatsrf9OsYoo4NVuu/O/TG0Bsj4S21EmO5VaG10qy+UO2tL/21vzH0xtAb
o+2tc+1Z6XcW6rf009e8ldyzvzH0xtAbozPfOn4zq/enThfXv2nsbwy9MfTG
SHjr2BrQs5eq+PhWR3zsiv2NoTeG3hhtb9n6LX/420fIOvsbQ28MvTG2y7eh
Xs6VHrl5UjHsbwy9MfTG6My3Zk3F0q97A35ij8O+1eD4Ct267x69MfTGaHs7
zTZsBlmU++nAD3UEnP2NoTeG3hh6Y+iNoTeG3hh6Y+iNoTeG3hhnaY+Pj8HI
Uqqcpf0HAkoRNQ==
       "], {{0, 0}, {600.08, 1021.2900000000001`}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 600.08}, {0, 1021.2900000000001`}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnU1uG0cUBglkoyNom4tkzXUuEMBAgOyy4XG09zG4yQVyAh4loT0mPT+v
u18XR+QQrAJkSKPmkCo3PvT//Prl79+//LLb7f49f/11/vr2/dvb2046GaT9
J50M9h79KZ4PvTH0xtAbQ28MvTH0xtAbQ28MvTHa3k4f+0Xv7HC808fbLNY3
ht4YemOwfFtk3fEwubb/OA1Xrt+MCh8Pl/LDb8//3uMvXRfrG0NvDL0xbmi/
zTLte159vWZXXGZ2Mc7G801+vunsx9mtHob1jaE3ht4YvfmWCKh50P28eBpF
X7lZOG3jld76wa0+6xtDbwy9MRLelvEVRFaUWvPOaSUDn25Az/rG0BtDb4xc
vu33+8PxR3btP/5ZNr2WUXYtdh1ki7Nu3CortAbLCVkY5ZuUaXWZCx/jdm8S
oDeG3hh6Y+iNoTeG3hgJb0GDZ97ayXZL418tBtaqA3dByWiWdjH6d/hzzU6w
9Y2hN4beGG1vjfUhQXe1lVfzMss4ui0z5x9pdP9x4eUn75izGF5Arb8uemPo
jZHw1rHe40dKTCZPwxi5ccCteX02+hdQDL3TWt4kQG8MvTES3iozpJksysyi
Ph/WN4beGHpjtL2tsL63toyk3oQrrYVz/duTojeG3hgJb6vOCEzX/VbDrTKt
8LlOMljfGHpj6I3B8i0XRKUEi7dcPdcSX+sbQ28MvTF68i1c2VtvaHVk44xo
J35UptQFjqdFZn8Cbwpa3xh6Y+iNkfCWn9/c5aYVFhOs9QmIQnDVS5Z+dblD
1Kfu2S82vGaV/4KXQm8MvTES3sKx/cwCj3w0RYW7trKWGpBRg7M6ObKiNwnQ
G0NvjLa3Ys5UphWW3cBGL7ISWUFqne4gpoH1jaE3ht4YCW+1/mk5o+pJ+O2F
x8N1z/5WUiuP9Y2hN4beGCDfEpsOyhsNgnPhSneubXwovaq8Arlvs2qzrzqU
u93/q6E3ht4YCW+X85HgRMPoSmvP1JjEdrD8dq32m06nYlfxJgF6Y+iNoTeG
3hh6Y+iNkfA2bvasfMrQ82J9Y+iNoTdGZ76VaM2rxguDg5dvcKo0xPrG0BtD
b4yufDuHz8d0IK66Iau+pK0SfeTAojtjfWPojaE3Rle+jZmd7JF6JFZjZrMU
d7tFA+/xWN8YemPojdGfb6lZy2Jrrbjx4ckOgrO+MfTG0BujJ9/wMNothdfZ
e/XHb41udbRj4kZvEqA3ht4YCW/1yYJMTNW2ZYUtvWb+TK9/sqMI6xtDbwy9
Mdre2oNmlXD7vp7kVFrWu9G5gwzWN4beGHpjJLz1rg+ZsDhgvOsUo8v1rmNA
kgfB3Ra2w2uI8ddGbwy9MRLejtPn1xcDB3VdS5HVnlTNPAOi+tbhjlSfn/W5
6I2hN0bbW+2BWZPk2cjKjftgfWPojaE3ht4YemPojaE3RsJb+xkKL7gp1frG
0BtDb4xcvtXPR2puOA0G0ErbuMq3LRe73Dw3yrfOpO1wrxVu9GLojaE3ht4Y
emPojaE3RsJbY44ysV632UKLDzBPLk15SO/Y+sbQG0NvjP58Sx5/lFzg8axY
3xh6Y+iN0fZWWB/SXIIb77Gqjcsl90RMCxwfsyvf+sbQG0NvjIS36oNH4+fF
zDqeHRvzC7G2uZ1c1jeG3hh6Y+TybbZ/YUKllRUMzWV3MWwd6xtDbwy9Mdre
0vsXNtjK+jysbwy9MfTG0BtDbwy9MfTGSHiLF9ku1oHUHzC6ztkg29koYX1j
6I2hN0ZnvqXoOby3/uCtXTkYK/ccXWk/UXr8Sdb1JgF6Y+iN0fY2PhbpGgXx
grc7feYtYH1j6I2hN4beGHpj6I2hN4beGHpj6I2hN8ZZ2vv7ezw0JWXO0v4H
9HwCVg==
       "], {{0, 0}, {599.04, 1203.84}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 599.04}, {0, 1203.84}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnTFuIzkQAAVc4ic4vY9crHg/cMACC1x2iZ7j3M9wsl+42E/xyiv4LM10
k80aySNBVYAN2+KM5EKjQbJJzp/f//32/Y/NZvPf/uuf/df7zw8PDxsZ5CDt
TQY52Fv7U9weemPojaE3ht4YemPojaE3ht4YemP0vb0+bdNR2nb3Y/fy9rJL
Xt6/tn/x7aTB9ul1/+v++9f8f5fCeGPojaE3RsFbmr4+klXKe377uPz45/mr
+Q2jv/ycpNzPNtE9580m95y+xe+bLPcmAXpj6I3R93bSf5vnlnbmybJKJzEm
d5imr2aG7L7d9un5uG851qU8XMO93yt6Y+iNoTeG3hh6Y+iNUfBWHZ/WxoaT
ZpMuX6NfF3cd8yFwZagbv9HvScXl3iRAbwy9MfreXrP8M01Np7WGZqaK58HK
M3JpShwd9l7Sm0TojaE3RsFbnDHmtdHK5Njff53UW2tFh9YN16rDGm8MvTH0
xhjPb5Np+VkK+ujvNcehK2en5RhvDL0x9MYYyW9JFbI0sXaUAIPc2BiEtoac
I5Nv6Xslfcjl3iRAbwy9Mfremut7Z1NhX/SxV8d4Y+iNoTeG3hh6Y+iNoTcG
7b/FA8CjsV5l6Uhx38Fn+8rKja/BeGPojaE3Bs1vpawVtH/ZDSXMMMvNW9Ym
3yq7GEqTbyVvEqE3ht4YBW9k0j6YmpuVG4qdvbxr11jBm6e4WfGX9QgP15Ir
7xu9MfTG6Hur1hfuqLjwZrxR9MbQG0NvDL0x9MbQG6Pg7Zam/b8M442hN4be
GLX8tt1uR/eWhmPY+a/vZBNx+W3zZj/D3RMZfEx9uB5efMfojaE3ht4YemPo
jaE3Rt9bWl9or+ior227yeGt8cbQG0NvjIK3ozQV752vn6NbTIDxFv7JiSXr
5kTjjaE3ht4Y9fw2Z/C0kMZ64Iv/m2fHeGPojaE3Ri2/desLo094OcthI92z
f8PTOLs7yzw/5ILojaE3Rt9bbX3v7c2gLcN4Y+iNoTeG3hh6Y+iNoTfGsv7b
plMmSCoLt1gwnWC8MfTG0Buj4O061vc+77LqbULlQBL+CNTDBUvM3yd6Y+iN
oTeG3hh6Y+iNUfA2+LiE0+5Z8XSj46Um///lZXe9w1jjjaE3ht4YI/kt3QRa
GzC2LkkfJvh6fP5SOkCOFxjnz/kKP9JmpAp8aE+t3y96Y+iN0fcW1RfSlWnP
k/0FnWMqoza3gfHG0BtDb4yCt84Ru8s7b42W+d9X3vVgvDH0xtAbo+/tqP/W
65INjVi7Dza9aow3ht4YemMM5bfT/NOpO4zswW8nvUnavAqMN4beGHpjFLxV
t3BOEuB79TOuDkxbshVo62K8MfTG0BtjJL+1stn5p+CC6ucVZT/jjaE3ht4Y
fW+9x5XOl66FzYZb9g8hWTPdGW8MvTH0xih4a3XMarNqafvrmU8bxXhj6I2h
N0Ytv832n0bHtc0zWOGQt+Ka4cED4gorezvHEb8fFLzQmwTojaE3ht4YemPo
jaE3RsFbdydU0DW65q2jZ8F4Y+iNoTdG39t0EJeeCj5b6dFdyYb3kK5fSDXe
GHpj6I1R8FZ54PJJmiqufJvMqt1Wh894Y+iNoTcGzW9pujvT3tL0cYHdim1t
b2z4+ELPt7w4emPojVHwNpqOMi5XG+0+SGt+z6Uj3MMNF93iLtEbQ2+MgrdS
Z6z4WMA84dT2q34mN88PuUn0xtAbYyi/ja7mjfJS+LSF9esFoxhvDL0x9Mao
eat10vpJbLQXx4eusw/Qv9VQgcN4Y+iNoTeG3hh6Y+iNoTeG3hh6Y+iNoTfG
Xtrj42M0apQWe2m/ACYO0mk=
       "], {{0, 0}, {599.04, 1226.8799999999999`}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 599.04}, {0, 1226.8799999999999`}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnUtuGzkUAAXMxkfwdi6RM2g9RwgQYHaz8XG8zzG8me2cwUeZyG5/upuP
5GO1FFnoKsCAZbEppUI88PNI/vn9n7++/3E4HP47/fx9+nn5/e7u7iCDTNL+
l0Eme9f+FreH3hh6Y+iNoTeG3hh6Y+iNoTeG3hgJb08P1VHa8eHHw9N7gdNv
r4WPj8+tR4p35385Pv77eJy/tXoZ1LwqE9W5eKp8eSFvEqA3ht4YCW84WKVi
1EtUfHqYfUompm35Ah/FLu1NAvTG0Bsj4a0Weda899/Wv8cxLVdyHZR+LiPh
82XlNLC9MfTG0BsjF9+Ox+NyHPrZ48qPBMtoNr28SWxvDL0x9MbQG0NvDL0x
9MZI9t/yk2Cv/bzb7Zdlsb0x9MbQGyMX34Kh5XrUuVgjiENfpZLPab1o9Bp+
4jVn3iZsbwy9MfTGyMe3MhwVQaw2/1bO0X073vhcnO2NoTeG3hi5+LZYX2iu
cmYSNrqBMRkq54GxnXNSKfMcLwdnIu1Ucqv9/aE3ht4YemPojaE3ht4YfW/r
Ts60Z2Hv2N4YemPojZHwVpnhn83CrXN00xsQTg8+Lka+3XTfz7+Eqw+NRZD6
9yE7tqai29zvEb0x9MZIeIuDT345NR2ygv0R8bxZf8mjnF7rTNwV1XaiXMKb
BOiNoTdGwls/oJUpcL1OVO1xsAJ7HWxvDL0x9MbIx7cD7b8VhcMu3IX/nefG
9sbQG0NvjFx86+aH1KbFxjY+dEeUtWfj2oIdsodmn/DEt1mm8UZvEqA3ht4Y
fW+VJLG3sLDYerAjbG8MvTH0xtAbQ28MvTH0xkh4G9mq0Dp996ObV92JEFVb
L1bZtVqhPdp9K5NP7Zse2OZ+j+iNoTeG3hh6Y+iNoTdGwlsrO/djdq6Z4jsr
3zxjpF5hJe2tvik1qHlZ28ZDnGxvDL0x9MYYiW/Duwl6xVgY7O6PCC+siWNg
kfFyRm8SoDeG3hh9b7n109H4cOvY3hh6Y+iNoTeG3hh6Y+iNkfDW267eGWM2
LqBZ15DODb7+GSa2N4beGHpj9L3Vx6cjQSyIUS+X/QWV5640bR17Xs0wKYpd
0ptE6I2hN0bCW2aTFIpvw9228KOTj1e6jj/nFx2e15sE6I2hN0bCW7n/dCiM
dFYwU1GocYx5K6O4c/Rc0fkcCHFTJdvc7xG9MfTG0BtDbwy9MfTGSHi7gd1S
vx/bG0NvDL0xcvEN3p+1aWasOxTtREi8+/Vc3iRAbwy9MfTG0BtDbwy9MRLe
+MrmimBLaTX5JE6rW9ZfT71r7bl4K+P+06ugN4beGAlvncHjUHZHfXaOLGJe
EdsbQ28MvTHy8W08Sy3bkQsqr+6J+CrY3hh6Y+iNkY9v69gVhKB5uuzZY+BU
+VfB9sbQG0NvjHx8G7z1L3l0UhnTbgPbG0NvDL0xcvHtNT+kmLRvj1j7g9BN
+7AaNYTnvzU/YtHtPGT6ilO5M/wH7Ay9MfTG6HtLn//2Hlt+0ze/LrY3ht4Y
emPojaE3ht4YemMkvLUvQWi/VVmGaCaw9bceVDYysPEv2wU2PTz+3N7RG0Nv
jIS3zJRX7d32VQj5ZLn2I8nTmVpLHqMXMUxPbbW/P/TG0BtDbwy9MfTG0Buj
7y23vpC7P2v0GMzy/pqg83aVY0Zsbwy9MfTGSHgbGpCWsWjs3I90slxyLNx4
ZBVsz+5NAvTG0Buj7+2ZnL6bup253zcr3/oq+Se2N4beGHpj6I2hN4beGHpj
6I2hN4beGHpjnKTd3993xp1ScJL2C0XrU3E=
       "], {{0, 0}, {598.0000000000001, 1178.7500000000002`}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 598.0000000000001}, {0, 1178.7500000000002`}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnUtu2lAUQJE6yRIy7Sa6BsZdQqRKnXXCcph3GUyyhY69lBZKKNh+n/uO
DYZyjhSJmBeHntxevft+/vz24+vbp9Vq9Wv/9X3/dXj98vKykkaO0n5LI0d7
S3+Kx0NvDL0x9MbQG0NvDL0x9MbQG0NvjLq3brs+l2XrbbfbpL8dvNW7stnt
b7R/vb9yk3/V9THeGHpj6I0R8DbIWsnElWO9/bn51yDZ+OLiOENmb3X6wcUw
3hh6Y+iN0ZTferno/bJfd0pB54u51+NE95CdOuONoTeG3hix/LZerze7j0I1
k9nGxen7qX2mV5bpuSXb53qMtS7fe7C4Pl05dBHn8iYJ9MbQG6PurRtns0IC
udHHXhzjjaE3ht4YemPojaE3ht4YAW/hEvLUlwuXkOvNt2VnCTjGG0NvDL0x
5stvifR1GM5KlLellSS5K8WcyUbnVpmxxNDM7LHldP/Pht4YemMEvBUH8LsJ
2S/d35vld2V6mOcVJunMtjp/nuneJIHeGHpjBLyd5k/r/SIyi1pPSom0Nrh5
5tv8b0xN3bZNjhzvM0H8k6I3ht4YemPojaE3ht4YdW/l9SGhga/iErhdpWY8
tCl9ho82u81NpyqMN4beGHpjBLw1Dd3Ht271M1i6ZX/ErLu2jAaMN4beGHpj
8PyWnXks7T6o5r1HWS9ivDH0xtAbI5bfgvMLSVp7dKXaNnWH4b77Mf0qOFLw
1vuKx3Yz/AGeDL0x9MbQG0NvDL0x9MYIeKsN/heLzRsP+98M442hN4beGOH8
lqvjJqzvzc29to3sXd9RCuONoTeG3hix/NY8/laaEu2ltUfFeGPojaE3Rt1b
9Hyk+1q/cW2MN4beGHpj6I2hN4beGHpjxOrTUpmZ6c4VWi52WsiMxzEFvEkC
vTH0xgh4u/H5IROnJ8o3KeTG2b1JAr0x9MaIeNuuB/MLoQRyvvI/HiFyvMkk
9U+J3hh6Y+iNoTeG3hh6YwS8TawWsz29xz2c/LfxRtEbQ28MlN/Kw25fkqfy
Xn5b2PVQ3aN6J89ONd4YemPojRHLb+Pxt3G6S26Er06VPuqqOeONoTeG3hh6
Y+iNoTeG3hh1b/n9C7V1HdWTkQLzoaEJ0HTjq+7uN94YemPojRHwNlp52894
gdVrvaxVzHUN+W3Z2tZ4Y+iNoTdGa35bFWcK8m/lnsfn+NtzoTeG3hgt+e0e
K9DLg3nHP0L3ec3iTRLojaE3Rt1bFy4ty7XktOcp3xvGG0NvDL0xmvLbKKf1
c1TbuBx50tbFz15fTRHjjaE3ht4Ys+S3uY77gCN73RX95DDeGHpj6I0R8NZ0
fu9oqrRLHhLykDXpJcYbQ28MvTH0xtAbQ28MvTFi/bdhZ6zWi0u+27S27d6f
vWW8MfTG0Bsjnt/w2W7VVRyr7DOXy9tXQydh5k+/nLR4+Nhonr/BM6E3ht4Y
AW/FJPBz07Sgt3eq5KhB/g7jE0sWnkI13hh6Y+iNMS2/DfpdkdNCxr2v5Rd7
AIw3ht4YemPg/JY/AamQ34ZXzjdp23ZafdpC81jf3wp6Xm+SQG8MvTEC3uZY
CjJ9Ed2dbV813hh6Y+iN0Z7fmrtG2/7ZmPewOnc6xhtDbwy9Mdrz20Wa6s+K
DofXZi8502N34LYzHLt0bDrLn+Cp0BtDb4yAt+oZRx8Mt1Dl5x0GubG49+oW
A3H9ZwXO5U0S6I2hN0bA2+E//n+2u2o6xhtDbwy9MfTG0BtDbwy9MfTG0BtD
bwy9MfbSXl9fRyNSUmEv7Q8Ute5a
       "], {{0, 0}, {599.04, 1226.8799999999999`}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 599.04}, {0, 1226.8799999999999`}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztnUGOIkcQAFvayzxhrvsRnzn7A5ZWWvnoC8+Z+z6Diy9+BU8Zw2INdHdW
ZXZAM2aJkEYaoLphYkqpyqrK4uu3v37/9mUYhn8OP38efo6/v7y8DLKEk7F3
WcJJ3Wd/igdDaQClAZQGUBpAaQClAZQGUBpAaYCCtN122Gw2293xlwObt/3p
lxPnh4cW7+8fL02atdo/JPY0gNIASgPk0vZvm+bE0ubt7/OrjxujlmJPAygN
oDSA0gBKAygNoDRALffss9l+f54x2hF7GkBpAKUBajHtcj5taM+VhS+N8tPZ
wyMXE3H5LFz3A5xvPp7ca3G4z0rSZIrSAEoDKA2gNIDSAEoD5NL2k1WA8+Dn
+HA/HoPtx6++h0uizbvtto+Rw9rTAEoDKA1QkDbP4Fr7N8LYleaDzbtFbWC2
eFvsaQClAZQGQDEtH4ONWu7DmBZMrA0PsiHEngZQGkBpgFxaO7sMRlM/tq1Y
1wl99QgZvOO+v7gw/VTRH/IRXauDwNNl12h/QpQGUBqgIK20xJnFonGCSeNk
9kZXfKQbS5MpSgMoDZBLi+oIspmx2f6NaDQ1C27x/dvrC5+GPQ2gNIDSAAVp
lf1plXn+TrP/xcx/HXsaQGkApQFyaeV6z08fPt0NexpAaQClAZQGUBpAaQCl
AWq5Zx/rPSVHaQClAWoxzXrPpdJkitIASgMoDaA0gNIASgMUpNX3bIzoVRA0
hnmF2qh819kdEmF7GkBpAKUBUEzrB64g/fzjt8vUNYhL/ULRcVgblwDUsuDi
XriLZ66UJlOUBlAaoCAtqdCcBJDikGzR0KsbneplCJc1UJ1PdRNpMkVpAKUB
CtLSoNTbghuyMC39GZfOcWzapjvGSz7Jf5fv5uVXV0qTKUoDKA1QkBank404
0w10cS45f5heO34pS3WHatyzhn1FlAZQGiCXNpuGWpBdhts29vkIqlHvOY+K
a+uJsacBlAZQGqAgrX7yz9Adp4Vt7vNX3hh7GkBpAKUBrotp183eN2fhwsPN
ktuWD2Gbn0e0hjSZojSA0gAFaelh2rOZq+R4ovJmjOkXIgfLB8fdaD/frhXH
QKxzjWANlAZQGqAgLZ7JLxQftTd4NE/t7uzvvXxmbSsJ9jSA0gBKA9Ri2jX1
njGen/ZsKA2gNEAubcn5aQ8XnRj2NIDSAEoDKA2gNIDSAEoD1Mdp9W1pv/xx
avY0gNIASgMUpFUONGulomHL/Jlu/AS1pZMG6cJrkkGfGt3qX/AkKA2gNEBB
WmWPWXF7xvja+PzG8uW9Fdj8bMlrFilO10Djz4rSAEoDFKTN1z1LQeP8TLmc
vD1qKteQ9kpKR0T75az3XBGlAZQGUBpAaQClAZQGKEgr1TcVtvEvLZWa37Zw
hFG7ZCB8Zrclyxmny5df99QoDaA0QC4t2J/W/56UZpvk+SURr3xubT+Ztd7z
figNoDRALu3jaKDGCWbLY0jxWNpbjP1+bLM7BDex3nMNlAZQGqAgLanTrJ38
f3ntvDj9wbCnAZQGUBoglxaneM0YNQF8e9R8fNXYrbG+nQb2NIDSAEoDoJh2
xzy0dyCb59w+EkoDKA2AYloYr5Jtt61JMHPPJ0FpAKUBCtIW76FdcvwjK3Sq
f13LcHluZKPxGtJkitIASgMUpLV2edV2dIQDtnQRIY+WIXfKRu1pAKUBlAZQ
GkBpAKUBlAZQGkBpAKUBlAY4GHt9fW0mcxJxMPYv6e8wUA==
       "], {{0, 0}, {599.4599999999999, 1169.82}}, {0, 255},
       ColorFunction->RGBColor],
      ImageSize->50,
      PlotRange->{{0, 599.4599999999999}, {0, 1169.82}}]}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{402, 367},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->60635118]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26380],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExportString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magnify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Antialiasing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Antialiasing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8206]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Rasterize",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Rasterize"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->135266827],

Cell[TextData[ButtonBox["Image Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImageProcessing"]], "MoreAbout",
 CellID->452149079],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->425437781],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->388357142]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rasterize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 13, 56.3440894}", "context" -> "System`", 
    "keywords" -> {
     "rasterizing graphics", "rasterizing 3D graphics", 
      "rasterizing formulas", "rasterizing programs"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Rasterize[g] returns a rasterized graphic of g. Rasterize[g, elem] gives \
the element elem associated with the rasterized form of g. ", 
    "synonyms" -> {}, "title" -> "Rasterize", "type" -> "Symbol", "uri" -> 
    "ref/Rasterize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17486, 574, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->68745722]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 228230, 4862}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1974, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2597, 71, 1574, 37, 70, "ObjectNameGrid"],
Cell[4174, 110, 1080, 35, 70, "Usage",
 CellID->20919]
}, Open  ]],
Cell[CellGroupData[{
Cell[5291, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5769, 167, 206, 7, 70, "Notes",
 CellID->25600],
Cell[5978, 176, 68, 1, 70, "Notes",
 CellID->32343931],
Cell[6049, 179, 1351, 31, 70, "2ColumnTableMod",
 CellID->40295514],
Cell[7403, 212, 632, 21, 70, "Notes",
 CellID->3543797],
Cell[8038, 235, 215, 8, 70, "Notes",
 CellID->21311],
Cell[8256, 245, 1936, 51, 70, "3ColumnTableMod",
 CellID->31755],
Cell[10195, 298, 550, 17, 70, "Notes",
 CellID->6444678],
Cell[10748, 317, 395, 13, 70, "Notes",
 CellID->227505925],
Cell[11146, 332, 469, 14, 70, "Notes",
 CellID->552043776],
Cell[11618, 348, 558, 21, 70, "Notes",
 CellID->16224],
Cell[12179, 371, 321, 11, 70, "Notes",
 CellID->3881],
Cell[12503, 384, 497, 15, 70, "Notes",
 CellID->274004605],
Cell[13003, 401, 615, 23, 70, "Notes",
 CellID->188627997],
Cell[13621, 426, 832, 30, 70, "Notes",
 CellID->5973],
Cell[14456, 458, 323, 9, 70, "Notes",
 CellID->79788781],
Cell[14782, 469, 387, 13, 70, "Notes",
 CellID->5651],
Cell[15172, 484, 2277, 85, 70, "Notes",
 CellID->137383301]
}, Closed]],
Cell[CellGroupData[{
Cell[17486, 574, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68745722],
Cell[CellGroupData[{
Cell[17870, 588, 148, 5, 70, "ExampleSection",
 CellID->263328800],
Cell[18021, 595, 103, 2, 70, "ExampleText",
 CellID->572072794],
Cell[CellGroupData[{
Cell[18149, 601, 232, 7, 28, "Input",
 CellID->421953973],
Cell[18384, 610, 582, 14, 126, "Output",
 Evaluatable->False,
 CellID->388883247]
}, Open  ]],
Cell[18981, 627, 125, 3, 70, "ExampleDelimiter",
 CellID->484125802],
Cell[19109, 632, 126, 3, 70, "ExampleText",
 CellID->489804178],
Cell[CellGroupData[{
Cell[19260, 639, 292, 9, 70, "Input",
 CellID->381853243],
Cell[19555, 650, 815, 19, 95, "Output",
 CellID->326303923]
}, Open  ]],
Cell[20385, 672, 125, 3, 70, "ExampleDelimiter",
 CellID->677587502],
Cell[20513, 677, 124, 3, 70, "ExampleText",
 CellID->26540558],
Cell[CellGroupData[{
Cell[20662, 684, 302, 8, 70, "Input",
 CellID->336674772],
Cell[20967, 694, 8072, 138, 189, "Output",
 CellID->531462053]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29088, 838, 217, 7, 70, "ExampleSection",
 CellID->26828],
Cell[29308, 847, 157, 6, 70, "ExampleText",
 CellID->43641338],
Cell[CellGroupData[{
Cell[29490, 857, 287, 8, 70, "Input",
 CellID->104493291],
Cell[29780, 867, 26793, 444, 186, "Output",
 CellID->31617838]
}, Open  ]],
Cell[56588, 1314, 81, 1, 70, "ExampleText",
 CellID->65935054],
Cell[CellGroupData[{
Cell[56694, 1319, 161, 5, 70, "Input",
 CellID->187107065],
Cell[56858, 1326, 359, 11, 54, "Output",
 CellID->593615004]
}, Open  ]],
Cell[57232, 1340, 125, 3, 70, "ExampleDelimiter",
 CellID->171634672],
Cell[57360, 1345, 74, 1, 70, "ExampleText",
 CellID->5161197],
Cell[CellGroupData[{
Cell[57459, 1350, 300, 10, 70, "Input",
 CellID->54982997],
Cell[57762, 1362, 217, 7, 36, "Output",
 CellID->232557701]
}, Open  ]],
Cell[57994, 1372, 125, 3, 70, "ExampleDelimiter",
 CellID->387017186],
Cell[58122, 1377, 88, 1, 70, "ExampleText",
 CellID->135873621],
Cell[CellGroupData[{
Cell[58235, 1382, 327, 11, 70, "Input",
 CellID->13474602],
Cell[58565, 1395, 917, 27, 54, "Output",
 CellID->622122434]
}, Open  ]],
Cell[CellGroupData[{
Cell[59519, 1427, 231, 7, 70, "Input",
 CellID->99912673],
Cell[59753, 1436, 600, 14, 70, "Output",
 Evaluatable->False,
 CellID->66071232]
}, Open  ]],
Cell[60368, 1453, 124, 3, 70, "ExampleDelimiter",
 CellID->26386666],
Cell[60495, 1458, 66, 1, 70, "ExampleText",
 CellID->164476559],
Cell[CellGroupData[{
Cell[60586, 1463, 298, 10, 70, "Input",
 CellID->142640495],
Cell[60887, 1475, 602, 15, 70, "Output",
 Evaluatable->False,
 CellID->46233302]
}, Open  ]],
Cell[61504, 1493, 125, 3, 70, "ExampleDelimiter",
 CellID->258884861],
Cell[61632, 1498, 82, 1, 70, "ExampleText",
 CellID->209624186],
Cell[CellGroupData[{
Cell[61739, 1503, 300, 10, 70, "Input",
 CellID->131561653],
Cell[62042, 1515, 204, 7, 36, "Output",
 CellID->3466175]
}, Open  ]],
Cell[62261, 1525, 124, 3, 70, "ExampleDelimiter",
 CellID->42179265],
Cell[62388, 1530, 207, 8, 70, "ExampleText",
 CellID->37256258],
Cell[CellGroupData[{
Cell[62620, 1542, 544, 16, 70, "Input",
 CellID->845486151],
Cell[63167, 1560, 411, 13, 64, "Output",
 CellID->17156835]
}, Open  ]],
Cell[63593, 1576, 67, 1, 70, "ExampleText",
 CellID->564500291],
Cell[CellGroupData[{
Cell[63685, 1581, 142, 4, 70, "Input",
 CellID->276823254],
Cell[63830, 1587, 790, 26, 54, "Output",
 CellID->256157511]
}, Open  ]],
Cell[64635, 1616, 80, 1, 70, "ExampleText",
 CellID->995658248],
Cell[CellGroupData[{
Cell[64740, 1621, 590, 17, 70, "Input",
 CellID->370665913],
Cell[65333, 1640, 1859, 36, 70, "Output",
 Evaluatable->False,
 CellID->10916442]
}, Open  ]],
Cell[67207, 1679, 125, 3, 70, "ExampleDelimiter",
 CellID->154264913],
Cell[67335, 1684, 197, 8, 70, "ExampleText",
 CellID->713049631],
Cell[CellGroupData[{
Cell[67557, 1696, 367, 12, 70, "Input",
 CellID->23962790],
Cell[67927, 1710, 857, 23, 54, "Output",
 CellID->268102996]
}, Open  ]],
Cell[68799, 1736, 125, 3, 70, "ExampleDelimiter",
 CellID->298238557],
Cell[68927, 1741, 64, 1, 70, "ExampleText",
 CellID->491656649],
Cell[CellGroupData[{
Cell[69016, 1746, 314, 10, 70, "Input",
 CellID->431163142],
Cell[69333, 1758, 1278, 27, 78, "Output",
 CellID->427468069]
}, Open  ]],
Cell[70626, 1788, 126, 3, 70, "ExampleDelimiter",
 CellID->1027994973],
Cell[70755, 1793, 63, 1, 70, "ExampleText",
 CellID->59177267],
Cell[CellGroupData[{
Cell[70843, 1798, 311, 10, 70, "Input",
 CellID->26239287],
Cell[71157, 1810, 616, 15, 82, "Output",
 CellID->237237252]
}, Open  ]],
Cell[71788, 1828, 124, 3, 70, "ExampleDelimiter",
 CellID->25662789],
Cell[71915, 1833, 68, 1, 70, "ExampleText",
 CellID->233981062],
Cell[CellGroupData[{
Cell[72008, 1838, 307, 10, 70, "Input",
 CellID->76775959],
Cell[72318, 1850, 910, 19, 77, "Output",
 CellID->409535225]
}, Open  ]],
Cell[73243, 1872, 124, 3, 70, "ExampleDelimiter",
 CellID->67634164],
Cell[73370, 1877, 331, 12, 70, "ExampleText",
 CellID->182039707],
Cell[CellGroupData[{
Cell[73726, 1893, 363, 11, 70, "Input",
 CellID->961760909],
Cell[74092, 1906, 910, 19, 77, "Output",
 CellID->250603838]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[75051, 1931, 222, 7, 70, "ExampleSection",
 CellID->516608053],
Cell[CellGroupData[{
Cell[75298, 1942, 231, 7, 70, "ExampleSubsection",
 CellID->244145057],
Cell[75532, 1951, 64, 1, 70, "ExampleText",
 CellID->614127702],
Cell[CellGroupData[{
Cell[75621, 1956, 295, 8, 70, "Input",
 CellID->59356176],
Cell[75919, 1966, 5217, 91, 153, "Output",
 CellID->95556532]
}, Open  ]],
Cell[81151, 2060, 124, 3, 70, "ExampleDelimiter",
 CellID->11048437],
Cell[81278, 2065, 86, 1, 70, "ExampleText",
 CellID->492467150],
Cell[CellGroupData[{
Cell[81389, 2070, 643, 20, 70, "Input",
 CellID->12094115],
Cell[82035, 2092, 13108, 219, 70, "Output",
 Evaluatable->False,
 CellID->294329688]
}, Open  ]],
Cell[95158, 2314, 334, 12, 70, "ExampleText",
 CellID->539739067],
Cell[CellGroupData[{
Cell[95517, 2330, 715, 22, 70, "Input",
 CellID->699100209],
Cell[96235, 2354, 12952, 216, 70, "Output",
 Evaluatable->False,
 CellID->50455644]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[109236, 2576, 236, 7, 70, "ExampleSubsection",
 CellID->370246719],
Cell[109475, 2585, 81, 1, 70, "ExampleText",
 CellID->573595349],
Cell[CellGroupData[{
Cell[109581, 2590, 498, 17, 70, "Input",
 CellID->58150907],
Cell[110082, 2609, 2425, 49, 73, "Output",
 CellID->147151010]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112556, 2664, 231, 7, 70, "ExampleSubsection",
 CellID->288288183],
Cell[112790, 2673, 79, 1, 70, "ExampleText",
 CellID->19030806],
Cell[CellGroupData[{
Cell[112894, 2678, 494, 17, 70, "Input",
 CellID->357716098],
Cell[113391, 2697, 2463, 51, 74, "Output",
 CellID->27857261]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[115915, 2755, 222, 7, 70, "ExampleSection",
 CellID->8236],
Cell[116140, 2764, 102, 2, 70, "ExampleText",
 CellID->522564891],
Cell[116245, 2768, 186, 6, 70, "Input",
 CellID->223954388],
Cell[CellGroupData[{
Cell[116456, 2778, 373, 10, 70, "Input",
 CellID->208152707],
Cell[116832, 2790, 33737, 558, 290, "Output",
 CellID->547123293]
}, Open  ]],
Cell[150584, 3351, 124, 3, 70, "ExampleDelimiter",
 CellID->32550322],
Cell[150711, 3356, 137, 6, 70, "ExampleText",
 CellID->299841845],
Cell[150851, 3364, 178, 6, 70, "Input",
 CellID->119336250],
Cell[CellGroupData[{
Cell[151054, 3374, 165, 5, 70, "Input",
 CellID->11802],
Cell[151222, 3381, 16707, 279, 307, "Output",
 CellID->195948414]
}, Open  ]],
Cell[167944, 3663, 125, 3, 70, "ExampleDelimiter",
 CellID->448941515],
Cell[168072, 3668, 84, 1, 70, "ExampleText",
 CellID->719557916],
Cell[168159, 3671, 1621, 43, 70, "Input",
 CellID->99112439],
Cell[169783, 3716, 61, 1, 70, "ExampleText",
 CellID->217142965],
Cell[CellGroupData[{
Cell[169869, 3721, 143, 4, 70, "Input",
 CellID->40835274],
Cell[170015, 3727, 4469, 77, 70, "Output",
 Evaluatable->False,
 CellID->41852818]
}, Open  ]],
Cell[174499, 3807, 61, 1, 70, "ExampleText",
 CellID->701184],
Cell[CellGroupData[{
Cell[174585, 3812, 145, 4, 70, "Input",
 CellID->610248628],
Cell[174733, 3818, 3148, 56, 70, "Output",
 Evaluatable->False,
 CellID->16544600]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[177930, 3880, 224, 7, 70, "ExampleSection",
 CellID->10470],
Cell[178157, 3889, 73, 1, 70, "ExampleText",
 CellID->17439323],
Cell[178233, 3892, 186, 6, 70, "Input",
 CellID->170945749],
Cell[CellGroupData[{
Cell[178444, 3902, 1190, 33, 70, "Input",
 CellID->337391938],
Cell[179637, 3937, 44228, 773, 388, "Output",
 CellID->60635118]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[223926, 4717, 311, 9, 70, "SeeAlsoSection",
 CellID->26380],
Cell[224240, 4728, 1191, 44, 70, "SeeAlso",
 CellID->8206]
}, Open  ]],
Cell[CellGroupData[{
Cell[225468, 4777, 305, 8, 70, "RelatedLinksSection"],
Cell[225776, 4787, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[226176, 4804, 319, 9, 70, "MoreAboutSection",
 CellID->135266827],
Cell[226498, 4815, 143, 3, 70, "MoreAbout",
 CellID->452149079],
Cell[226644, 4820, 185, 3, 70, "MoreAbout",
 CellID->425437781],
Cell[226832, 4825, 179, 3, 70, "MoreAbout",
 CellID->388357142]
}, Open  ]],
Cell[227026, 4831, 27, 0, 70, "History"],
Cell[227056, 4833, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

