(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51556,       1903]
NotebookOptionsPosition[     41982,       1560]
NotebookOutlinePosition[     43380,       1598]
CellTagsIndexPosition[     43294,       1593]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"N" :> Documentation`HelpLookup["paclet:ref/N"], "Chop" :> 
          Documentation`HelpLookup["paclet:ref/Chop"], "Round" :> 
          Documentation`HelpLookup["paclet:ref/Round"], "ContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/ContinuedFraction"], 
          "Convergents" :> Documentation`HelpLookup["paclet:ref/Convergents"],
           "RootApproximant" :> 
          Documentation`HelpLookup["paclet:ref/RootApproximant"], 
          "LatticeReduce" :> 
          Documentation`HelpLookup["paclet:ref/LatticeReduce"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"N\"\>", 2->"\<\"Chop\"\>", 
       3->"\<\"Round\"\>", 4->"\<\"ContinuedFraction\"\>", 
       5->"\<\"Convergents\"\>", 6->"\<\"RootApproximant\"\>", 
       7->"\<\"LatticeReduce\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continued Fractions & Rational Approximations" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuedFractionsAndRationalApproximations"], 
          "Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continued Fractions & Rational Approximations\"\>", 
       2->"\<\"Number Recognition\"\>", 
       3->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rationalize", "ObjectName",
 CellID->18954],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rationalize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rationalize"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]converts an approximate number ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " to a nearby rational with small denominator. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rationalize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rationalize"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["dx", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields the rational number with smallest denominator \
that lies within ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ".  "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->2015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["dx", "TI"]}], "]"}]], "InlineFormula"],
 " works with exact numbers ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24521],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " yields ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " unchanged if there no rational number close enough to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to satisfy the condition ",
 Cell[BoxData[
  RowBox[{"\[VerticalSeparator]", 
   StyleBox["p", "TI"], "/", 
   StyleBox["q", "TI"], "-", 
   StyleBox["x", "TI"], "\[VerticalSeparator]", "<", 
   StyleBox["c", "TI"], "/", 
   SuperscriptBox[
    StyleBox["q", "TI"], "2"]}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " chosen to be ",
 Cell[BoxData[
  SuperscriptBox["10", 
   RowBox[{"-", "4"}]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->140773377],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 " converts any ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to rational form. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->13067,
  ButtonNote->"13067"]
}], "Notes",
 CellID->24207]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->431260183],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->163112237],

Cell["Convert to a rational number:", "ExampleText",
 CellID->1080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", "6.75", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176],

Cell[BoxData[
 FractionBox["27", "4"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6243]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18365],

Cell["Find rational approximations to within a given tolerance:", \
"ExampleText",
 CellID->8584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{"Pi", ",", ".01"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15073],

Cell[BoxData[
 FractionBox["22", "7"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31259]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{"Pi", ",", ".001"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23630],

Cell[BoxData[
 FractionBox["201", "64"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20734]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28736],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rationalize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationalize"]], "InlineFormula"],
 " works with exact numbers:"
}], "ExampleText",
 CellID->27894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Sqrt", "[", "2", "]"}], "]"}], ",", 
   RowBox[{"2", "^", 
    RowBox[{"-", "12"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12310],

Cell[BoxData[
 FractionBox["218", "53"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11810],

Cell["Rationalize all numbers in an expression:", "ExampleText",
 CellID->31969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{"1.2", "+", 
   RowBox[{"6.7", "x"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11489],

Cell[BoxData[
 RowBox[{
  FractionBox["6", "5"], "+", 
  FractionBox[
   RowBox[{"67", " ", "x"}], "10"]}]], "Output",
 ImageSize->{56, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2334]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11485],

Cell[TextData[{
 "No rational number is by default considered \"close enough\" to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   ButtonBox["Pi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pi"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->24747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{"N", "[", "Pi", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20178],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21454],

Cell["Force a rational approximation to be found:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->13067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{
   RowBox[{"N", "[", "Pi", "]"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4952],

Cell[BoxData[
 FractionBox["245850922", "78256779"]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16211]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21598],

Cell["\<\
Successive rational approximations to \[Pi]:\
\>", "ExampleText",
 CellID->32480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Rationalize", "[", 
    RowBox[{"Pi", ",", 
     RowBox[{"10", "^", 
      RowBox[{"-", "n"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["22", "7"], ",", 
   FractionBox["22", "7"], ",", 
   FractionBox["201", "64"], ",", 
   FractionBox["333", "106"], ",", 
   FractionBox["355", "113"], ",", 
   FractionBox["355", "113"], ",", 
   FractionBox["75948", "24175"], ",", 
   FractionBox["100798", "32085"], ",", 
   FractionBox["103993", "33102"], ",", 
   FractionBox["312689", "99532"]}], "}"}]], "Output",
 ImageSize->{442, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25538],

Cell["\<\
Plot the error in progressively better rational approximations to \[Pi]:\
\>", "ExampleText",
 CellID->30195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"Abs", "[", 
     RowBox[{"Pi", "-", 
      RowBox[{"Rationalize", "[", 
       RowBox[{"Pi", ",", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", "n"}], "]"}]}], "]"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9971],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWE1IVFEUvs6bMSsri4jEiIkoJtO0WuSuISIlKIRaSG0UCUboR8qFFSRC
ZDs3kQSRRZBRhBGFFcFALYw2QhuX4sqlS5ev75x77/jenfNm3phZ0APv89zz
nXO+e+695943Z3oGcpeu9Az09fak26/39Of6em+kT127ji6vSik1j7/hnQr/
+/iP/+Z9H2/dbqfWo15+1A/urUabRGcC74TSchD1jeV8Pm/kJFutozalUYWW
fQRtPUf+yvLo6Gg6nWYH2s4z5uTBisllq3h+E0NDQ8xdrQ9oo1iRmGcKc3Nz
eX66u7vhQsX3EZS1r2w229ramuVnZmbG+OK2OjieeKP6wj6XlpZGRkbADDkD
S82M829zJc0a2yaBhxVskfIN4hr4zLiFhYWamhr09vf314q4Tyx3dnaiC4NT
mwsoiv6RvczOzsJLXV3d4uLiFtHLB8Yh44iDXoxrq4h7z7jJyUk4QzQYbBNx
72zcjo4OcJuent4u4t4yDrQGBwczmczU1NSOEH/WexMTE1CClNopenljo4FS
V1cXklYv4l4zDvOGaFgOmIQGEfeKcSADEKLCYJeIe2nZY4VioCCwW8RNsDw2
NoZRjI+Pq3RojC/YC1LU1taWy+XAfo/o5bldERgioDDYK+Ke2VHqpYnk7RNx
TxkHtV6JMNgv4p4wDrsGQXV2MyLusc0G1hASB36NoXGy3sP4kQUse9UkenkU
yAbSimjNIm7MZgMp09lo8e3+I5gph+Zxd+FD39Q7cMG8qMMMrnFQ7r535Qe+
2Q3IIAaNoR/xI+tmBX4v2EwZH8eo8bDCsN9IdTQ2WxLJG9Xgq8tWyzXcl6uU
YJMK2hChdSVtbB1MmneqJNqd3Uq1FOHiqnr8X7j+W2zWkqutFFH3q5L7JsYt
IWz/+3eplfApu///UNzydSHqfnSOZVR+fVlTSWo8FFgcxKS6Is7sOSvrG6NK
UePhSDP6y6WtjDxQQBGz85HaYO9Zlgt3VZXgyPGscPjg6KIBJniUOENiWCEX
5hy4KaJOU1MNyJB9cFmDeCsanQIIDDSazubboUx0MAbHW+g+fkf01279gSZc
6kMrAnvS+tWBNQM1XAJbuDfjgV0E9gQ1SX0nxgO+d0PjybKvwv1dp0fdE30d
Z184i3Gl0ckZEXF1LOMuYNZtE88oZhhGpLpfwgoQcKSF08SrB5cZo4+2oh31
MaaWxry1Qpto7UZf1xV354ZRmx2tWxXCaPutm6zISopBYhhV68uVphgV1Lr3
lTB6ky/faiqdmbWctz+r/be4MhsqJp4uKqSoN6uj2Q+f+wd96YuBvl2Cv754
4ci6BJkYqESGSYPDjHyXPi0POLK74vlbS/w9h35YqqK3mJOWVWdyQPSw1iwa
A3K8TDSbGTwUL3bRt1HziiIWyeUjF31hcbYifp8qZkBcW8y7yQ/fsg764a+x
RkfvrG4T70eJ3qgKqLW1RSN2K/tq4L7b+DH8uF+rf1t2T6O/zaec7MXMs7vj
D5XRu7KOY1fXT5bmi1pV9QswKnm3\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->112523011]
}, Open  ]],

Cell[TextData[{
 "Plot the error in progressively better approximations to ",
 Cell[BoxData[
  SqrtBox["3"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "3", "]"}], "-", 
      RowBox[{"Rationalize", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", "3", "]"}], ",", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", "n"}], "]"}]}], "]"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6735],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWL1PFEEUX26PuyMiEjXxMOqdnFEak7OSYHMaoyR+0Wik8i5gAiboBUm8
yos2mGBCYbRRQ2UoaeivpORPoKSkpBzfezOzszM7s7sHrG7C3L59v/fbtzPv
Y4YnrZWF10utlcW5VvXhcqu9sDj3vvrg3TI88gc8z9uGv/myB/cM7ujvPGPM
8/GOLu83Dp759AfJGxsbQs4HqByAuLbX61WrVbwdtHJ8l6hGo6FQBRjzAMoJ
rkIqqyLdclQwEkfY1k/FxWH8ykkxr6yOyjsUQrm8Q3GNhJ2dnQZdXhEHv16v
z8zM9McWltfkik1PT4NnXgkH/+DgQFtBmu1C+FvTfXHA3mw28fZMsCpyBm1r
abeSUfTVqU3HEUZ9Inl9fV2sawkHf3NzU+hHnFa5brd7UfPrc+RpvE167QeS
YU26dHlFHHxYfvhF1ViMFXw+xAcalMhqb29P6Mua9x2J5snr1eI5M0WhP29J
2+l0tGgvl8tbW1tuziWSobzAEmIgFymaIWeEvhbEHxqJ4BaXGYUBF58y7yaB
SwbKjHhTtrNYa0kCK4pZ+kQsqp4xe27OSVvhfZEyZnR0lJeMMNdgmIuwVi4l
3w5WJycWB38HU1nJuJl3atNxhJ/OkgzR06NLRFOS1UuSYWpLpRIGLQ1+u922
+jsr0aIn3ovnzBSF/jwj7f7+PvQDlXeTk5MTExNuzqckw/RAO1JdRNWau/FW
oh8+zgSlvsrUyjrg2lPcl1Zad+ANBVWPmCVvUnRFzqt60wvmrAknwJvOPxSP
Y39SfoTlKZIPDw+1/IOeoPEm7SY4y+rqKsS7ykfV459rkXKH8U7cskbZ1Ilq
8X23mIgxR29vWrnqJJu9Xe3aXsVbiY77JhOU+qokjuskQ0M3ezxMR5IVQGHb
pqJid3dX6BOsBPeK5u8NpzaZ4xTj2WPG3SWSoQZq0csLpLIeMazMHOAsUHyh
BKs5guIMJVqxyNNR3sKGImdRHf9jH+82rYaZPc/c6DDK7OZ2q9PM3vvPMlFZ
tGyB3YdmLVf1nLTW0Op0qtDRdyj5SyYozb9YDr67U2cUvuPizRtVw2KNx5ne
zSrMtsutMP0c7ce8U+XvmKGnjUNsLb9syGZskd56Msd/QAzg73/y7IqVIeoV
zt5Q5t5UQvLRZuiC8LWWzpfICWC8bw/4Ph9SEoodOMFPmiH9eDpPIucHmk3H
fyHcHoEfompCnYBtOHRJWif8tqtM3ztUmH72qBj6ULYI/6GkwFQXjB70TYsS
7Pq/WKSuKYZAPxyZmbx8Ahi+K0iDhAs+Mw75U3rhYoqp2Un64+L/9fuy9s9P
Oc81Q77Wp56/R8bYH5K2I6M38BcG4XoQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->98668730]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28444],

Cell["Create a polynomial with approximate numerical coefficients:", \
"ExampleText",
 CellID->21329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "n", "]"}], " ", 
     RowBox[{"x", "^", "n"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "6"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7146],

Cell[BoxData[
 RowBox[{
  RowBox[{"2.718281828459045`", " ", "x"}], "+", 
  RowBox[{"7.38905609893065`", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"20.085536923187668`", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"54.598150033144236`", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"148.4131591025766`", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"403.4287934927351`", " ", 
   SuperscriptBox["x", "6"]}]}]], "Output",
 ImageSize->{449, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27046]
}, Open  ]],

Cell["Find a rough approximation involving only rational numbers:", \
"ExampleText",
 CellID->13385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{"%", ",", "0.1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31110],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"8", " ", "x"}], "3"], "+", 
  FractionBox[
   RowBox[{"22", " ", 
    SuperscriptBox["x", "2"]}], "3"], "+", 
  RowBox[{"20", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  FractionBox[
   RowBox[{"109", " ", 
    SuperscriptBox["x", "4"]}], "2"], "+", 
  FractionBox[
   RowBox[{"297", " ", 
    SuperscriptBox["x", "5"]}], "2"], "+", 
  FractionBox[
   RowBox[{"807", " ", 
    SuperscriptBox["x", "6"]}], "2"]}]], "Output",
 ImageSize->{274, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14411]
}, Open  ]],

Cell["Factor the result:", "ExampleText",
 CellID->5817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6314],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", "x", " ", 
  RowBox[{"(", 
   RowBox[{"16", "+", 
    RowBox[{"44", " ", "x"}], "+", 
    RowBox[{"120", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"327", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"891", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"2421", " ", 
     SuperscriptBox["x", "5"]}]}], ")"}]}]], "Output",
 ImageSize->{297, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13017]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23863],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"], "[", "x", "]"}]], 
  "InlineFormula"],
 " returns a rational number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "/", "q"}], TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[VerticalSeparator]", 
    RowBox[{
     RowBox[{"p", "/", "q"}], "-", "x"}], "\[VerticalSeparator]", 
    RowBox[{"<", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "4"}]], "/", 
      SuperscriptBox["q", "2"]}]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->419077351],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0.202898"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1005734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Rationalize", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->155711889],

Cell[BoxData[
 FractionBox["101449", "500000"]], "Output",
 ImageSize->{53, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->750571554]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "q"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Numerator", "[", "r", "]"}], ",", 
     RowBox[{"Denominator", "[", "r", "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{"r", "-", "x"}], "]"}], "<", 
  RowBox[{
   RowBox[{"10", "^", 
    RowBox[{"-", "4"}]}], "/", 
   RowBox[{"q", "^", "2"}]}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->238781467],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22942304]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " unchanged, there is no rational number satisfying this:"
}], "ExampleText",
 CellID->100678885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"N", "[", "Pi", "]"}]}], ";", 
  RowBox[{"Rationalize", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7705013],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->215243993]
}, Open  ]],

Cell[TextData[{
 "Get the rational approximations with smallest denominator error ",
 Cell[BoxData[
  StyleBox["dx", "TI"]], "InlineFormula"],
 " through machine precision:"
}], "ExampleText",
 CellID->317583205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rats", "=", 
  RowBox[{"Union", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Rationalize", "[", 
      RowBox[{"x", ",", 
       RowBox[{"2", "^", 
        RowBox[{"-", "k"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "53"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->70042807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   FractionBox["201", "64"], ",", 
   FractionBox["267", "85"], ",", 
   FractionBox["311", "99"], ",", 
   FractionBox["333", "106"], ",", 
   FractionBox["55358", "17621"], ",", 
   FractionBox["72043", "22932"], ",", 
   FractionBox["85533", "27226"], ",", 
   FractionBox["94053", "29938"], ",", 
   FractionBox["99023", "31520"], ",", 
   FractionBox["101508", "32311"], ",", 
   FractionBox["102928", "32763"], ",", 
   FractionBox["103638", "32989"], ",", 
   FractionBox["103993", "33102"], ",", 
   FractionBox["208341", "66317"], ",", 
   FractionBox["833719", "265381"], ",", 
   FractionBox["4272943", "1360120"], ",", 
   FractionBox["53047102", "16885417"], ",", 
   FractionBox["63885804", "20335483"], ",", 
   FractionBox["74724506", "23785549"], ",", 
   FractionBox["80143857", "25510582"], ",", 
   FractionBox["245850922", "78256779"], ",", 
   FractionBox["5419351", "1725033"], ",", 
   FractionBox["1146408", "364913"], ",", 
   FractionBox["312689", "99532"], ",", 
   FractionBox["104348", "33215"], ",", 
   FractionBox["355", "113"], ",", 
   FractionBox["22", "7"]}], "}"}]], "Output",
 ImageSize->{552, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->117257545]
}, Open  ]],

Cell["\<\
The residual of the inequality is positive for all of these rational \
approximations:\
\>", "ExampleText",
 CellID->204868578],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"r_", ",", "c_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"r", "-", "x"}], "]"}], "-", 
   RowBox[{"c", "/", 
    RowBox[{
     RowBox[{"Denominator", "[", "r", "]"}], "^", "2"}]}]}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->148707154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"f", "[", 
       RowBox[{"#", ",", 
        RowBox[{"10", "^", 
         RowBox[{"-", "4"}]}]}], "]"}]}], "}"}], "&"}], ",", "rats"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->155630336],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "0.14149265358979313`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["201", "64"], ",", "0.000967629175730616`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["267", "85"], ",", "0.0004161691607274295`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["311", "99"], ",", "0.00017850197261117337`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["333", "106"], ",", "0.00008321072756470736`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     FractionBox["55358", "17621"], ",", "2.354520213384915`*^-7"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["72043", "22932"], ",", "1.1913992583633782`*^-7"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["85533", "27226"], ",", "5.827635494968542`*^-8"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["94053", "29938"], ",", "2.8831848802933117`*^-8"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["99023", "31520"], ",", "1.3995783798190884`*^-8"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["101508", "32311"], ",", "7.122549799070846`*^-9"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["102928", "32763"], ",", "3.343995845022251`*^-9"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["103638", "32989"], ",", "1.4935479898336635`*^-9"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["103993", "33102"], ",", "5.777993619170708`*^-10"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["208341", "66317"], ",", "1.2233360938131048`*^-10"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["833719", "265381"], ",", "8.713830834845123`*^-12"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4272943", "1360120"], ",", "4.0406712475936337`*^-13"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["53047102", "16885417"], ",", "1.1990057933121897`*^-14"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["63885804", "20335483"], ",", "6.217007118569564`*^-15"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["74724506", "23785549"], ",", "2.2202692934638813`*^-15"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["80143857", "25510582"], ",", "4.4393555040284137`*^-16"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["245850922", "78256779"], ",", 
     RowBox[{"-", "1.6328867414587007`*^-20"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["5419351", "1725033"], ",", "2.2170855393062564`*^-14"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1146408", "364913"], ",", "1.6099605963027027`*^-12"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["312689", "99532"], ",", "2.913326013521411`*^-11"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["104348", "33215"], ",", "3.3153741592878`*^-10"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["355", "113"], ",", "2.589327225712286`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["22", "7"], ",", "0.001262448451023147`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{556, 300},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->140085888]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->57115447],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["\[Infinity]", "TR"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 " both give rational approximations for real ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->181543892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", "=", " ", 
  RowBox[{"N", "[", "\[Pi]", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30688951],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74145918]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 " gives a rational that is equivalent to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " up to the precision of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2603940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Rationalize", "[", 
   RowBox[{"x", ",", "0"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->76581809],

Cell[BoxData[
 FractionBox["245850922", "78256779"]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->275773070]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "-", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->219216806],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->153384567]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["\[Infinity]", "TR"]}], "]"}]], "InlineFormula"],
 " gets a rational directly from the bitwise representation of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->516225365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{"x", ",", "\[Infinity]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16826303],

Cell[BoxData[
 FractionBox["884279719003555", "281474976710656"]], "Output",
 ImageSize->{122, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->232658966]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"d", ",", "e"}], "}"}], " ", "=", " ", 
  RowBox[{"RealDigits", "[", 
   RowBox[{"x", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->190149045],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", 
     ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
     ",", "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", 
     ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", 
     ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
     ",", "0", ",", "0", ",", "0"}], "}"}], ",", "2"}], "}"}]], "Output",
 ImageSize->{512, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->299341266]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", ".", 
  RowBox[{"(", 
   RowBox[{"2", "^", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{"e", "-", "1"}], ",", 
      RowBox[{"e", "-", "1", "-", "52"}], ",", 
      RowBox[{"-", "1"}]}], "]"}]}], ")"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->799474266],

Cell[BoxData[
 FractionBox["884279719003555", "281474976710656"]], "Output",
 ImageSize->{122, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->919860677]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->514563548],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rationalize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationalize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RootApproximant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootApproximant"]], "InlineFormula"],
 " both give exact quantities approximating real ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->299827748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"N", "[", "E", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->353554484],

Cell[BoxData["2.718281828459045`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165590503]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RootApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootApproximant"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives an algebraic number equivalent to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " up to the precision of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->562549751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ra", "=", 
  RowBox[{"RootApproximant", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->644234018],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "18"}], "-", 
     RowBox[{"2", " ", "#1"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     SuperscriptBox["#1", "4"], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     SuperscriptBox["#1", "6"], "-", 
     RowBox[{"11", " ", 
      SuperscriptBox["#1", "8"]}], "-", 
     RowBox[{"7", " ", 
      SuperscriptBox["#1", "9"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["#1", "10"]}]}], "&"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{469, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->338638413]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ra", "-", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->634603245],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->616186172]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 " gives a rational number equivalent to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " up to the precision of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->183325968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "=", 
  RowBox[{"Rationalize", "[", 
   RowBox[{"x", ",", "0"}], "]"}], " "}]], "Input",
 CellLabel->"In[4]:=",
 CellID->629446211],

Cell[BoxData[
 FractionBox["325368125", "119696244"]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->548926920]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "-", "x"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->76469762],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->276695028]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6098],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuedFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Convergents",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Convergents"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootApproximant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LatticeReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LatticeReduce"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3265]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23530],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->9047]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Rationalize",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Rationalize"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->225321444],

Cell[TextData[ButtonBox["Continued Fractions & Rational Approximations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuedFractionsAndRationalApproximations"]], "MoreAbout",
 CellID->439780539],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->142049997],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->213294363]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rationalize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 14.2039216}", "context" -> "System`", 
    "keywords" -> {
     "continued fractions", "exact numbers", "rational approximation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Rationalize[x] converts an approximate number x to a nearby rational \
with small denominator. Rationalize[x, dx] yields the rational number with \
smallest denominator that lies within dx of x. ", "synonyms" -> {}, "title" -> 
    "Rationalize", "type" -> "Symbol", "uri" -> "ref/Rationalize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6807, 221, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->431260183]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 43151, 1586}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2736, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3359, 89, 49, 1, 70, "ObjectName",
 CellID->18954],
Cell[3411, 92, 1145, 36, 70, "Usage",
 CellID->2015]
}, Open  ]],
Cell[CellGroupData[{
Cell[4593, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5071, 150, 360, 14, 70, "Notes",
 CellID->24521],
Cell[5434, 166, 883, 31, 70, "Notes",
 CellID->140773377],
Cell[6320, 199, 450, 17, 70, "Notes",
 CellID->24207]
}, Closed]],
Cell[CellGroupData[{
Cell[6807, 221, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->431260183],
Cell[CellGroupData[{
Cell[7192, 235, 148, 5, 70, "ExampleSection",
 CellID->163112237],
Cell[7343, 242, 67, 1, 70, "ExampleText",
 CellID->1080],
Cell[CellGroupData[{
Cell[7435, 247, 104, 3, 28, "Input",
 CellID->176],
Cell[7542, 252, 174, 6, 51, "Output",
 CellID->6243]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7765, 264, 216, 7, 70, "ExampleSection",
 CellID->18365],
Cell[7984, 273, 97, 2, 70, "ExampleText",
 CellID->8584],
Cell[CellGroupData[{
Cell[8106, 279, 129, 4, 70, "Input",
 CellID->15073],
Cell[8238, 285, 175, 6, 51, "Output",
 CellID->31259]
}, Open  ]],
Cell[CellGroupData[{
Cell[8450, 296, 130, 4, 70, "Input",
 CellID->23630],
Cell[8583, 302, 177, 6, 51, "Output",
 CellID->20734]
}, Open  ]],
Cell[8775, 311, 121, 3, 70, "ExampleDelimiter",
 CellID->28736],
Cell[8899, 316, 205, 7, 70, "ExampleText",
 CellID->27894],
Cell[CellGroupData[{
Cell[9129, 327, 235, 8, 70, "Input",
 CellID->12310],
Cell[9367, 337, 176, 6, 51, "Output",
 CellID->8419]
}, Open  ]],
Cell[9558, 346, 121, 3, 70, "ExampleDelimiter",
 CellID->11810],
Cell[9682, 351, 80, 1, 70, "ExampleText",
 CellID->31969],
Cell[CellGroupData[{
Cell[9787, 356, 149, 5, 70, "Input",
 CellID->11489],
Cell[9939, 363, 243, 9, 51, "Output",
 CellID->2334]
}, Open  ]],
Cell[10197, 375, 121, 3, 70, "ExampleDelimiter",
 CellID->11485],
Cell[10321, 380, 380, 13, 70, "ExampleText",
 CellID->24747],
Cell[CellGroupData[{
Cell[10726, 397, 132, 4, 70, "Input",
 CellID->20178],
Cell[10861, 403, 171, 5, 36, "Output",
 CellID->29590]
}, Open  ]],
Cell[11047, 411, 121, 3, 70, "ExampleDelimiter",
 CellID->21454],
Cell[11171, 416, 130, 2, 70, "ExampleText",
 CellID->13067],
Cell[CellGroupData[{
Cell[11326, 422, 155, 5, 70, "Input",
 CellID->4952],
Cell[11484, 429, 189, 6, 51, "Output",
 CellID->16211]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11722, 441, 223, 7, 70, "ExampleSection",
 CellID->21598],
Cell[11948, 450, 91, 3, 70, "ExampleText",
 CellID->32480],
Cell[CellGroupData[{
Cell[12064, 457, 293, 10, 70, "Input",
 CellID->6316],
Cell[12360, 469, 550, 17, 51, "Output",
 CellID->193]
}, Open  ]],
Cell[12925, 489, 121, 3, 70, "ExampleDelimiter",
 CellID->25538],
Cell[13049, 494, 119, 3, 70, "ExampleText",
 CellID->30195],
Cell[CellGroupData[{
Cell[13193, 501, 400, 13, 70, "Input",
 CellID->9971],
Cell[13596, 516, 1818, 34, 70, "Output",
 Evaluatable->False,
 CellID->112523011]
}, Open  ]],
Cell[15429, 553, 167, 6, 70, "ExampleText",
 CellID->31497],
Cell[CellGroupData[{
Cell[15621, 563, 470, 15, 70, "Input",
 CellID->6735],
Cell[16094, 580, 1586, 30, 70, "Output",
 Evaluatable->False,
 CellID->98668730]
}, Open  ]],
Cell[17695, 613, 121, 3, 70, "ExampleDelimiter",
 CellID->28444],
Cell[17819, 618, 101, 2, 70, "ExampleText",
 CellID->21329],
Cell[CellGroupData[{
Cell[17945, 624, 281, 10, 70, "Input",
 CellID->7146],
Cell[18229, 636, 583, 17, 36, "Output",
 CellID->27046]
}, Open  ]],
Cell[18827, 656, 100, 2, 70, "ExampleText",
 CellID->13385],
Cell[CellGroupData[{
Cell[18952, 662, 128, 4, 70, "Input",
 CellID->31110],
Cell[19083, 668, 602, 22, 54, "Output",
 CellID->14411]
}, Open  ]],
Cell[19700, 693, 56, 1, 70, "ExampleText",
 CellID->5817],
Cell[CellGroupData[{
Cell[19781, 698, 97, 3, 70, "Input",
 CellID->6314],
Cell[19881, 703, 539, 18, 51, "Output",
 CellID->13017]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20469, 727, 233, 7, 70, "ExampleSection",
 CellID->23863],
Cell[20705, 736, 666, 25, 70, "ExampleText",
 CellID->419077351],
Cell[21374, 763, 115, 4, 70, "Input",
 CellID->1005734],
Cell[CellGroupData[{
Cell[21514, 771, 130, 4, 70, "Input",
 CellID->155711889],
Cell[21647, 777, 188, 6, 51, "Output",
 CellID->750571554]
}, Open  ]],
Cell[CellGroupData[{
Cell[21872, 788, 469, 17, 70, "Input",
 CellID->238781467],
Cell[22344, 807, 160, 5, 36, "Output",
 CellID->22942304]
}, Open  ]],
Cell[22519, 815, 371, 13, 70, "ExampleText",
 CellID->100678885],
Cell[CellGroupData[{
Cell[22915, 832, 181, 6, 70, "Input",
 CellID->7705013],
Cell[23099, 840, 175, 5, 36, "Output",
 CellID->215243993]
}, Open  ]],
Cell[23289, 848, 212, 6, 70, "ExampleText",
 CellID->317583205],
Cell[CellGroupData[{
Cell[23526, 858, 358, 12, 70, "Input",
 CellID->70042807],
Cell[23887, 872, 1295, 34, 111, "Output",
 CellID->117257545]
}, Open  ]],
Cell[25197, 909, 137, 4, 70, "ExampleText",
 CellID->204868578],
Cell[25337, 915, 316, 11, 70, "Input",
 CellID->148707154],
Cell[CellGroupData[{
Cell[25678, 930, 313, 12, 70, "Input",
 CellID->155630336],
Cell[25994, 944, 3446, 113, 321, "Output",
 CellID->140085888]
}, Open  ]],
Cell[29455, 1060, 124, 3, 70, "ExampleDelimiter",
 CellID->57115447],
Cell[29582, 1065, 610, 22, 70, "ExampleText",
 CellID->181543892],
Cell[CellGroupData[{
Cell[30217, 1091, 133, 4, 70, "Input",
 CellID->30688951],
Cell[30353, 1097, 174, 5, 36, "Output",
 CellID->74145918]
}, Open  ]],
Cell[30542, 1105, 446, 16, 70, "ExampleText",
 CellID->2603940],
Cell[CellGroupData[{
Cell[31013, 1125, 153, 5, 70, "Input",
 CellID->76581809],
Cell[31169, 1132, 193, 6, 51, "Output",
 CellID->275773070]
}, Open  ]],
Cell[CellGroupData[{
Cell[31399, 1143, 92, 3, 70, "Input",
 CellID->219216806],
Cell[31494, 1148, 160, 5, 36, "Output",
 CellID->153384567]
}, Open  ]],
Cell[31669, 1156, 416, 14, 70, "ExampleText",
 CellID->516225365],
Cell[CellGroupData[{
Cell[32110, 1174, 140, 4, 70, "Input",
 CellID->16826303],
Cell[32253, 1180, 207, 6, 51, "Output",
 CellID->232658966]
}, Open  ]],
Cell[CellGroupData[{
Cell[32497, 1191, 210, 7, 70, "Input",
 CellID->190149045],
Cell[32710, 1200, 810, 17, 54, "Output",
 CellID->299341266]
}, Open  ]],
Cell[CellGroupData[{
Cell[33557, 1222, 296, 10, 70, "Input",
 CellID->799474266],
Cell[33856, 1234, 207, 6, 51, "Output",
 CellID->919860677]
}, Open  ]],
Cell[34078, 1243, 125, 3, 70, "ExampleDelimiter",
 CellID->514563548],
Cell[34206, 1248, 436, 15, 70, "ExampleText",
 CellID->299827748],
Cell[CellGroupData[{
Cell[34667, 1267, 120, 4, 70, "Input",
 CellID->353554484],
Cell[34790, 1273, 175, 5, 36, "Output",
 CellID->165590503]
}, Open  ]],
Cell[34980, 1281, 432, 15, 70, "ExampleText",
 CellID->562549751],
Cell[CellGroupData[{
Cell[35437, 1300, 135, 4, 70, "Input",
 CellID->644234018],
Cell[35575, 1306, 774, 25, 39, "Output",
 CellID->338638413]
}, Open  ]],
Cell[CellGroupData[{
Cell[36386, 1336, 93, 3, 70, "Input",
 CellID->634603245],
Cell[36482, 1341, 160, 5, 36, "Output",
 CellID->616186172]
}, Open  ]],
Cell[36657, 1349, 447, 16, 70, "ExampleText",
 CellID->183325968],
Cell[CellGroupData[{
Cell[37129, 1369, 159, 5, 70, "Input",
 CellID->629446211],
Cell[37291, 1376, 194, 6, 51, "Output",
 CellID->548926920]
}, Open  ]],
Cell[CellGroupData[{
Cell[37522, 1387, 91, 3, 70, "Input",
 CellID->76469762],
Cell[37616, 1392, 160, 5, 36, "Output",
 CellID->276695028]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37837, 1404, 310, 9, 70, "SeeAlsoSection",
 CellID->6098],
Cell[38150, 1415, 1695, 62, 70, "SeeAlso",
 CellID->3265]
}, Open  ]],
Cell[CellGroupData[{
Cell[39882, 1482, 314, 9, 70, "TutorialsSection",
 CellID->23530],
Cell[40199, 1493, 147, 3, 70, "Tutorials",
 CellID->9047]
}, Open  ]],
Cell[CellGroupData[{
Cell[40383, 1501, 305, 8, 70, "RelatedLinksSection"],
Cell[40691, 1511, 367, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41095, 1528, 319, 9, 70, "MoreAboutSection",
 CellID->225321444],
Cell[41417, 1539, 203, 4, 70, "MoreAbout",
 CellID->439780539],
Cell[41623, 1545, 147, 3, 70, "MoreAbout",
 CellID->142049997],
Cell[41773, 1550, 137, 3, 70, "MoreAbout",
 CellID->213294363]
}, Open  ]],
Cell[41925, 1556, 27, 0, 70, "History"],
Cell[41955, 1558, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

