(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    456612,       8987]
NotebookOptionsPosition[    443878,       8538]
NotebookOutlinePosition[    445122,       8575]
CellTagsIndexPosition[    445035,       8570]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/ComplexNumbers"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Complex Numbers\"\>", 
       2->"\<\"Numerical Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Im" :> Documentation`HelpLookup["paclet:ref/Im"], "I" :> 
          Documentation`HelpLookup["paclet:ref/I"], "Abs" :> 
          Documentation`HelpLookup["paclet:ref/Abs"], "Arg" :> 
          Documentation`HelpLookup["paclet:ref/Arg"], "Complex" :> 
          Documentation`HelpLookup["paclet:ref/Complex"], "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Im\"\>", 2->"\<\"I\"\>", 
       3->"\<\"Abs\"\>", 4->"\<\"Arg\"\>", 5->"\<\"Complex\"\>", 
       6->"\<\"ComplexExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Functions of Complex Variables" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsOfComplexVariables"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Complex Numbers\"\>", 
       2->"\<\"Functions of Complex Variables\"\>", 
       3->"\<\"Mathematical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Re", "ObjectName",
 CellID->5997],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Re",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Re"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the real part of the complex number ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16765]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->203856663],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Re",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Re"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 " is left unevaluated if ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is not a numeric quantity. "
}], "Notes",
 CellID->13888],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->580864602],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->51967432],

Cell["Find the real part of a complex number:", "ExampleText",
 CellID->23484566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"2", "+", 
   RowBox[{"3", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66860157],

Cell[BoxData["2"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8204638]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27808528],

Cell["\<\
Plot the real part of a complex\[Hyphen]valued function:\
\>", "ExampleText",
 CellID->245215821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"ArcSinh", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ")"}], "^", "5"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16381840],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309115429]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4084850],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " to specify regions of the complex plane:"
}], "ExampleText",
 CellID->696243917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ")"}], "^", "2"}], "]"}], ">", 
    RowBox[{"Re", "[", 
     RowBox[{"1", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ")"}], "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10620312],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115579265]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22946],

Cell["\<\
Mixed\[Hyphen]precision complex inputs:\
\>", "ExampleText",
 CellID->431660366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"2", "-", 
     RowBox[{"1.64", "I"}]}], "]"}], ",", 
   RowBox[{"Re", "[", 
    RowBox[{"2.", "-", 
     RowBox[{"3", " ", "I"}]}], "]"}], ",", 
   RowBox[{"Re", "[", 
    RowBox[{"2.0000000000000000000", "-", 
     RowBox[{"1.64", " ", "I"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54504803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2.`", ",", "2.`19.30102999566398"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36676088]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->724429714],

Cell["Exact complex inputs:", "ExampleText",
 CellID->350406651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", "17"}], "+", 
     RowBox[{
      RowBox[{"5", "/", "13"}], " ", "I"}]}], ")"}], "^", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188161188],

Cell[BoxData[
 FractionBox["248821436", "40552535777"]], "Output",
 ImageSize->{92, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145846129]
}, Open  ]],

Cell["Algebraic numbers:", "ExampleText",
 CellID->189932689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "5"}], "+", 
      RowBox[{"11", 
       RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "2"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49031758],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"2662", " ", "#1"}], "+", 
     RowBox[{"308", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"1936", " ", 
      SuperscriptBox["#1", "4"]}], "-", 
     RowBox[{"352", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     RowBox[{"1408", " ", 
      SuperscriptBox["#1", "7"]}], "+", 
     RowBox[{"1024", " ", 
      SuperscriptBox["#1", "10"]}]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{454, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73160594]
}, Open  ]],

Cell["Transcendental numbers:", "ExampleText",
 CellID->16112768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"E", "-", 
   RowBox[{"I", " ", "Pi"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->541573647],

Cell[BoxData["\[ExponentialE]"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->651901333]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->617081273],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->641124220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", "I"}]}], ",", 
    RowBox[{"2", "I"}], ",", 
    RowBox[{"1", "+", 
     RowBox[{"I", " ", "Pi"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->565804157],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446031093]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", 
      RowBox[{"1", "-", 
       RowBox[{"2", "I"}]}]}], ",", 
     RowBox[{"5", "\[Rule]", 
      RowBox[{"17", "-", 
       RowBox[{"3", "I"}]}]}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37446706],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->713068029]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->715927032],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "17"}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->222616360]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3187215],

Cell[TextData[{
 "For some input ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " will automatically simplify:"
}], "ExampleText",
 CellID->404036938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Re", "[", "z", "]"}], ",", 
    RowBox[{"Im", "[", "z", "]"}], ",", 
    RowBox[{"I", " ", 
     RowBox[{"Re", "[", "z", "]"}]}], ",", 
    RowBox[{"Abs", "[", "z", "]"}], ",", 
    RowBox[{"Conjugate", "[", "z", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38527238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Re", "[", "z", "]"}], ",", 
   RowBox[{"Im", "[", "z", "]"}], ",", "0", ",", 
   RowBox[{"Abs", "[", "z", "]"}], ",", 
   RowBox[{"Re", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16884555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->625440949],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->2419991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Re", "[", "z", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->622249986],

Cell[BoxData[
 FormBox[
  RowBox[{"Re", "(", "z", ")"}], TraditionalForm]], "Output",
 ImageSize->{30, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->258357279]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32727],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->56709610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Re", "[", "Infinity", "]"}], ",", 
   RowBox[{"Re", "[", 
    RowBox[{"-", "Infinity"}], "]"}], ",", 
   RowBox[{"Re", "[", 
    RowBox[{"DirectedInfinity", "[", "I", "]"}], "]"}], ",", 
   RowBox[{"Re", "[", "ComplexInfinity", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250479245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", 
   RowBox[{"-", "\[Infinity]"}], ",", "0", ",", "Indeterminate"}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->541528937]
}, Open  ]],

Cell["Check that the quantity is in the right half-plane:", "ExampleText",
 CellID->67897136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Re", "[", 
   RowBox[{"DirectedInfinity", "[", 
    RowBox[{"1", "+", "I"}], "]"}], "]"}], ">", "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->787875748],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->849618516]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8865],

Cell["\<\
Flow around a cylinder as the real part of a complex\[Hyphen]valued function:\
\
\>", "ExampleText",
 CellID->509708943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"x", "+", 
     RowBox[{"I", " ", "y"}], "-", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ")"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"Contours", "->", "40"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181137286],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyMnXW81cX29zlFKBhYhIqNICgWooKzBQUUGxu7wAAxroVXUVEUvaJgI4oS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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{3892, 3893, 280}, {10319, 6123, 4323}, {3895, 3892, 
         280}, {4319, 4318, 340}, {9909, 9910, 3894}, {4363, 3893, 1151}, {
         10358, 6193, 4363}, {4660, 4321, 345}, {4323, 4321, 1152}, {6118, 
         10314, 4320}, {4318, 4320, 1151}, {6965, 7061, 280}, {3895, 4214, 
         1152}, {3893, 3892, 1151}, {5077, 8962, 340}, {4808, 4768, 340}, {
         6607, 8986, 345}, {9914, 9913, 3896}, {5098, 6468, 345}, {8986, 5098,
          345}, {8962, 6569, 340}, {10311, 6115, 4319}, {6738, 5077, 340}, {
         5962, 10193, 4214}, {4321, 4322, 345}, {4777, 4809, 1151}, {4814, 
         4815, 4659}, {4812, 4778, 1152}, {3892, 3895, 1152}, {3893, 3894, 
         280}, {3896, 3895, 280}, {6122, 10316, 4322}, {7061, 6988, 280}, {
         4659, 4660, 345}},
         VertexColors->None], 
        PolygonBox[{{4778, 4807, 3892, 1152}, {6468, 10488, 4659, 345}, {6115,
          10310, 4318, 4319}, {6193, 9908, 3893, 4363}, {6988, 9914, 3896, 
         280}, {6123, 10315, 4321, 4323}, {10310, 6118, 4320, 4318}, {10315, 
         6122, 4322, 4321}, {6701, 10532, 4770, 4789}, {10545, 6294, 4780, 
         4772}, {6478, 10545, 4772, 4786}, {5959, 10358, 4363, 1151}, {9908, 
         9909, 3894, 3893}, {9912, 5962, 4214, 3895}, {9913, 9912, 3895, 
         3896}, {10579, 10619, 4794, 4792}, {5960, 10319, 4323, 1152}, {10716,
          10676, 4797, 4799}, {10619, 10659, 4796, 4794}, {4807, 4777, 1151, 
         3892}, {10676, 10579, 4792, 4797}, {9910, 6965, 280, 3894}, {10659, 
         6701, 4789, 4796}, {10193, 5960, 1152, 4214}, {4813, 4812, 1152, 
         4321}, {10314, 5959, 1151, 4320}, {4810, 4808, 340, 4318}, {10532, 
         6741, 4791, 4770}, {4811, 4813, 4321, 4660}, {4815, 4811, 4660, 
         4659}, {6294, 10716, 4799, 4780}, {6569, 10311, 4319, 340}, {10316, 
         6607, 345, 4322}, {4809, 4810, 4318, 1151}},
         VertexColors->None], 
        PolygonBox[{{10488, 6478, 4786, 4814, 4659}, {6741, 6738, 340, 4768, 
         4791}},
         VertexColors->None]}]}, 
     {RGBColor[0.3826348447434226, 0.21253187612131805`, 0.654819879359048], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{7304, 7520, 2028}, {10358, 5959, 2028}, {6992, 5963, 
         1153}, {6191, 6967, 1412}, {8308, 7304, 2028}, {10319, 5960, 2029}, {
         6118, 10310, 1326}, {6116, 6583, 1326}, {9909, 9908, 1412}, {6618, 
         6124, 1328}, {6190, 6973, 1412}, {6575, 6116, 1326}, {10310, 6115, 
         1326}, {10315, 6123, 1328}, {5963, 6997, 1153}, {6122, 10315, 
         1328}, {7309, 7306, 2029}, {6124, 6610, 1328}, {9912, 9913, 1153}, {
         5962, 9912, 1153}, {6997, 5961, 1153}, {8312, 6618, 1328}, {9908, 
         6193, 1412}, {5959, 10314, 2028}, {7306, 8313, 2029}, {6973, 6191, 
         1412}, {6583, 8305, 1326}, {5960, 10193, 2029}},
         VertexColors->None], 
        PolygonBox[{{8305, 8308, 2028, 1326}, {6608, 8987, 8986, 6607}, {6742,
          6739, 6738, 6741}, {8313, 8312, 1328, 2029}, {6193, 10358, 2028, 
         1412}, {10580, 10620, 10619, 10579}, {8987, 5099, 5098, 8986}, {
         10717, 10677, 10676, 10716}, {10317, 6608, 6607, 10316}, {6739, 5078,
          5077, 6738}, {10533, 6742, 6741, 10532}, {10677, 10580, 10579, 
         10676}, {7520, 6190, 1412, 2028}, {9911, 6966, 6965, 9910}, {5099, 
         6469, 6468, 5098}, {10193, 5962, 1153, 2029}, {6570, 10312, 10311, 
         6569}, {6989, 9915, 9914, 6988}, {6479, 10546, 10545, 6478}, {6469, 
         10489, 10488, 6468}, {7062, 6989, 6988, 7061}, {6702, 10533, 10532, 
         6701}, {6966, 7062, 7061, 6965}, {6295, 10717, 10716, 6294}, {10620, 
         10660, 10659, 10619}, {5078, 8963, 8962, 5077}, {6123, 10319, 2029, 
         1328}, {8963, 6570, 6569, 8962}, {10546, 6295, 6294, 10545}, {5961, 
         7309, 2029, 1153}, {10660, 6702, 6701, 10659}, {10489, 6479, 6478, 
         10488}, {10314, 6118, 1326, 2028}},
         VertexColors->None], 
        PolygonBox[{{10312, 6575, 1326, 6115, 10311}, {6967, 9911, 9910, 9909,
          1412}, {6610, 10317, 10316, 6122, 1328}, {9915, 6992, 1153, 9913, 
         9914}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.40097656463022924`, 0.24442317354785495`, 0.6806013855130119], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{7310, 7308, 2030}, {8312, 8313, 2626}, {5641, 6968, 
         1863}, {6966, 9911, 1863}, {9915, 6989, 1870}, {8306, 5193, 2624}, {
         6190, 7520, 2155}, {9911, 6967, 1863}, {5196, 8314, 2626}, {8308, 
         8305, 2624}, {5647, 7314, 1870}, {7522, 5641, 1863}, {7309, 5961, 
         2030}, {6990, 5647, 1870}, {7517, 7518, 2155}, {6992, 9915, 1870}},
         VertexColors->None], 
        PolygonBox[{{6117, 6584, 6583, 6116}, {6470, 10490, 10489, 6469}, {
         6611, 10318, 10317, 6610}, {7062, 6966, 1863, 1896}, {10661, 6703, 
         6702, 10660}, {10490, 6480, 6479, 10489}, {6989, 7062, 1896, 1870}, {
         5687, 6990, 1870, 1896}, {6968, 5687, 1896, 1863}, {10534, 6743, 
         6742, 10533}, {6740, 5079, 5078, 6739}, {6571, 10313, 10312, 6570}, {
         5964, 6998, 6997, 5963}, {6296, 10718, 10717, 6295}, {10581, 10621, 
         10620, 10580}, {10313, 6576, 6575, 10312}, {5100, 6470, 6469, 
         5099}, {8988, 5100, 5099, 8987}, {6480, 10547, 10546, 6479}, {10547, 
         6296, 6295, 10546}, {5079, 8964, 8963, 5078}, {10678, 10581, 10580, 
         10677}, {6125, 6611, 6610, 6124}, {10718, 10678, 10677, 10717}, {
         6609, 8988, 8987, 6608}, {10318, 6609, 6608, 10317}, {6974, 6192, 
         6191, 6973}, {8964, 6571, 6570, 8963}, {6703, 10534, 10533, 6702}, {
         10621, 10661, 10660, 10620}, {6743, 6740, 6739, 6742}, {6619, 6125, 
         6124, 6618}, {6576, 6117, 6116, 6575}},
         VertexColors->None], 
        PolygonBox[{{7518, 6974, 6973, 6190, 2155}, {8314, 6619, 6618, 8312, 
         2626}, {7308, 7307, 7306, 7309, 2030}, {6998, 7310, 2030, 5961, 
         6997}, {6192, 7522, 1863, 6967, 6191}, {5193, 7305, 7304, 8308, 
         2624}, {7314, 5964, 5963, 6992, 1870}, {6584, 8306, 2624, 8305, 
         6583}, {7307, 5196, 2626, 8313, 7306}, {7305, 7517, 2155, 7520, 
         7304}},
         VertexColors->None]}]}, 
     {RGBColor[0.41931828451703596`, 0.2763144709743919, 0.7063828916669759], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{8872, 6744, 1785}, {10490, 6470, 1696}, {5194, 6615, 
         430}, {6576, 10313, 1756}, {6609, 10318, 1762}, {7522, 6192, 2156}, {
         5189, 6960, 429}, {6582, 5189, 429}, {8932, 5238, 1696}, {7312, 7313,
          2031}, {8141, 6471, 1696}, {6471, 8932, 1696}, {6480, 10490, 
         1696}, {7307, 7308, 430}, {6960, 5191, 429}, {5455, 6612, 1762}, {
         7523, 7521, 2156}, {5619, 8989, 3040}, {8965, 5602, 3036}, {5496, 
         8872, 1785}, {6572, 5441, 1756}, {5197, 7234, 430}, {5196, 7307, 
         430}, {5964, 7314, 2031}, {6744, 8098, 1785}, {7305, 5193, 429}, {
         7468, 7465, 2125}, {7234, 5194, 430}, {7517, 7305, 429}, {6740, 6743,
          1785}, {7461, 7464, 2124}, {5191, 6970, 429}, {6844, 6830, 1820}, {
         6890, 6904, 1826}, {6996, 5197, 430}, {10318, 6611, 1762}, {10313, 
         6571, 1756}},
         VertexColors->None], 
        PolygonBox[{{5642, 6969, 6968, 5641}, {10662, 6704, 6703, 10661}, {
         6830, 5496, 1785, 1820}, {10547, 6480, 1696, 1826}, {5688, 6991, 
         6990, 5687}, {6585, 8307, 8306, 6584}, {10582, 10622, 10621, 
         10581}, {10622, 10662, 10661, 10621}, {10719, 10679, 10678, 10718}, {
         6297, 10719, 10718, 6296}, {6743, 10534, 1820, 1785}, {5238, 6890, 
         1826, 1696}, {6999, 7311, 7310, 6998}, {6969, 5688, 5687, 6968}, {
         8315, 6620, 6619, 8314}, {6117, 6576, 1756, 2124}, {10679, 10582, 
         10581, 10678}, {7519, 6975, 6974, 7518}, {6612, 5619, 3040, 1762}, {
         6571, 8964, 3036, 1756}, {7465, 5455, 1762, 2125}, {5441, 7461, 2124,
          1756}, {6991, 5648, 5647, 6990}, {6611, 6125, 2125, 1762}, {8988, 
         6609, 1762, 3040}, {5602, 6572, 1756, 3036}},
         VertexColors->None], 
        PolygonBox[{{8307, 6582, 429, 5193, 8306}, {5648, 7312, 2031, 7314, 
         5647}, {6615, 8315, 8314, 5196, 430}, {6970, 7519, 7518, 7517, 
         429}, {7521, 5642, 5641, 7522, 2156}, {8098, 5080, 5079, 6740, 
         1785}, {6620, 7468, 2125, 6125, 6619}, {8989, 5101, 5100, 8988, 
         3040}, {5101, 8141, 1696, 6470, 5100}, {6704, 6844, 1820, 10534, 
         6703}, {7311, 6996, 430, 7308, 7310}, {6904, 6297, 6296, 10547, 
         1826}, {6975, 7523, 2156, 6192, 6974}, {7464, 6585, 6584, 6117, 
         2124}, {7313, 6999, 6998, 5964, 2031}, {5080, 8965, 3036, 8964, 
         5079}},
         VertexColors->None]}]}, 
     {RGBColor[0.4376600044038427, 0.30820576840092884`, 0.7321643978209399], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{7054, 6412, 751}, {7000, 8318, 1872}, {7312, 5648, 
         754}, {6412, 7480, 751}, {7311, 6999, 1872}, {7519, 6970, 1864}, {
         7523, 6975, 1864}, {5649, 7063, 754}, {8310, 6616, 1763}, {6996, 
         7311, 1872}, {7468, 6620, 1763}, {6999, 7313, 1872}, {7480, 5643, 
         751}, {8307, 6585, 1758}, {6585, 7464, 1758}, {6414, 7469, 754}, {
         8303, 6971, 1864}, {8315, 6615, 1763}, {5642, 7521, 751}, {6991, 
         5688, 799}, {6616, 5458, 1763}, {6977, 8320, 799}, {6971, 7055, 
         1864}, {5688, 6969, 799}, {6582, 8307, 1758}, {7471, 7000, 1872}, {
         5446, 6586, 1758}, {8320, 6995, 799}, {6620, 8315, 1763}, {6586, 
         8301, 1758}, {6975, 7519, 1864}, {7063, 6414, 754}},
         VertexColors->None], 
        PolygonBox[{{5648, 6991, 799, 754}, {10623, 10663, 10662, 10622}, {
         6298, 10720, 10719, 6297}, {5102, 8142, 8141, 5101}, {5239, 6891, 
         6890, 5238}, {10583, 10623, 10622, 10582}, {5456, 6613, 6612, 
         5455}, {6831, 5497, 5496, 6830}, {7521, 7523, 1864, 751}, {5603, 
         6573, 6572, 5602}, {10680, 10583, 10582, 10679}, {5620, 8990, 8989, 
         5619}, {8933, 5239, 5238, 8932}, {6891, 6905, 6904, 6890}, {6961, 
         5192, 5191, 6960}, {5497, 8873, 8872, 5496}, {6845, 6831, 6830, 
         6844}, {5190, 6961, 6960, 5189}, {6472, 8933, 8932, 6471}, {5442, 
         7462, 7461, 5441}, {8099, 5081, 5080, 8098}, {7055, 7054, 751, 
         1864}, {5081, 8966, 8965, 5080}, {8142, 6472, 6471, 8141}, {8873, 
         6745, 6744, 8872}, {6995, 5649, 754, 799}, {6745, 8099, 8098, 
         6744}, {6613, 5620, 5619, 6612}, {5643, 6977, 799, 751}, {8966, 5603,
          5602, 8965}, {6573, 5442, 5441, 6572}, {6969, 5642, 751, 799}, {
         10720, 10680, 10679, 10719}, {6905, 6298, 6297, 6904}, {7469, 7471, 
         1872, 754}, {7235, 5195, 5194, 7234}, {7466, 5456, 5455, 7465}, {
         8990, 5102, 5101, 8989}, {5198, 7235, 7234, 5197}, {10663, 6705, 
         6704, 10662}, {7313, 7312, 754, 1872}, {6705, 6845, 6844, 6704}},
         VertexColors->None], 
        PolygonBox[{{7462, 5446, 1758, 7464, 7461}, {5195, 8310, 1763, 6615, 
         5194}, {8301, 5190, 5189, 6582, 1758}, {5458, 7466, 7465, 7468, 
         1763}, {8318, 5198, 5197, 6996, 1872}, {5192, 8303, 1864, 6970, 
         5191}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.45600172429064934`, 0.34009706582746574`, 0.7579459039749038], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{8993, 8136, 2549}, {5681, 7056, 1892}, {6977, 5643, 
         1865}, {5649, 6995, 1871}, {5102, 8990, 2549}, {8092, 8971, 2540}, {
         8310, 5195, 2625}, {7481, 6135, 2131}, {8142, 5102, 2549}, {8316, 
         8317, 2627}, {8143, 8993, 2549}, {7470, 6126, 2126}, {8311, 8309, 
         2625}, {8971, 8097, 2540}, {8303, 5192, 2623}, {7054, 7055, 1892}, {
         8304, 8302, 2623}, {6978, 6976, 1865}, {8299, 8300, 2622}, {5190, 
         8301, 2622}, {5198, 8318, 2627}, {5690, 7064, 1897}, {8966, 5081, 
         2540}, {6993, 6994, 1871}, {7471, 7469, 2126}, {5081, 8099, 2540}},
         VertexColors->None], 
        PolygonBox[{{8874, 6746, 6745, 8873}, {5443, 7463, 7462, 5442}, {5447,
          6587, 6586, 5446}, {10624, 10664, 10663, 10623}, {6906, 6299, 6298, 
         6905}, {6994, 5690, 1897, 1871}, {6574, 5443, 5442, 6573}, {10721, 
         10681, 10680, 10720}, {6617, 5459, 5458, 6616}, {10664, 6706, 6705, 
         10663}, {8934, 5240, 5239, 8933}, {10584, 10624, 10623, 10583}, {
         5604, 6574, 6573, 5603}, {6614, 5621, 5620, 6613}, {6473, 8934, 8933,
          6472}, {5209, 6993, 1871, 2629}, {10681, 10584, 10583, 10680}, {
         6995, 8320, 2629, 1871}, {5457, 6614, 6613, 5456}, {6299, 10721, 
         10720, 6298}, {7467, 5457, 5456, 7466}, {5498, 8874, 8873, 5497}, {
         6846, 6832, 6831, 6845}, {7463, 5447, 5446, 7462}, {5459, 7467, 7466,
          5458}, {6892, 6906, 6905, 6891}, {8320, 6977, 1865, 2629}, {6976, 
         5209, 2629, 1865}, {5643, 7480, 2131, 1865}, {7063, 5649, 1871, 
         1897}, {6135, 6978, 1865, 2131}, {6832, 5498, 5497, 6831}, {5240, 
         6892, 6891, 5239}, {6706, 6846, 6845, 6705}},
         VertexColors->None], 
        PolygonBox[{{6415, 7470, 2126, 7469, 6414}, {7064, 6415, 6414, 7063, 
         1897}, {6126, 7001, 7000, 7471, 2126}, {7056, 6413, 6412, 7054, 
         1892}, {8309, 6617, 6616, 8310, 2625}, {7001, 8316, 2627, 8318, 
         7000}, {6587, 8299, 2622, 8301, 6586}, {5621, 8143, 2549, 8990, 
         5620}, {8136, 6473, 6472, 8142, 2549}, {8300, 6962, 6961, 5190, 
         2622}, {6972, 5681, 1892, 7055, 6971}, {8097, 5604, 5603, 8966, 
         2540}, {7236, 8311, 2625, 5195, 7235}, {6746, 8092, 2540, 8099, 
         6745}, {6962, 8304, 2623, 5192, 6961}, {8302, 6972, 6971, 8303, 
         2623}, {6413, 7481, 2131, 7480, 6412}, {8317, 7236, 7235, 5198, 
         2627}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.47434344417745605`, 0.37198836325400275`, 0.7837274101288678], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVWtIlmcYvi0/TUNN8zvx9eIrr1+fUHO52A83N2LTxX5M5yFIbaGtH4ul
n6xkDBakI/3catMxpPxXsBNhobgx2I+xgojCgraFdmB/1mHUZLDp2EHZdXU9
4Y+H93nv9z5c93Uf3vI96eaeVWb2Gc5qnNdjZnkbzToKzR4Wmb2fY7YeH+YL
zC7mmlWHzKoiZpsTZiWQ9yXNDib1/Wy52RROaq2+b4lI5zJkV3BqIQ+lzB7A
fxd8j2UhZrHZP4g7E5Nf6v8cN7sLndsA1heY/eSbHck3ywGWEM4EMLRDfgby
NyB/FnZP4O7Dti5sFkbso7D9yDNrgJ93IP8esToREw/7AbE86HwInZYys1ac
L7OFJRunEfcG6LyCczYkvA8dZsYmhmumOJdiijWD/I4ht2mTH+bWi7MAPNfj
ymUSOsPQ+RQ660rNnvbEL2PShvpD0M1AZ8z0nAt03w4/KU+xyE3El89OxyPz
moUsDZsq3D+B3X74eg73tyGv26D6vQDMf0XNnkcek5Dvgz7St5vQ/wI8ngNX
h4uV5wycfgP97TgXcK/G99qE+qGjwqwNNutgW4dnPc4y6jsPZws4s8A2AR4/
hp/TeL4G/Q2QN2Qr5sFAcVm3mohq9yguvg8j1mhItltwvxOWX/p8BrrNCemz
ZiPQOW/KeyBQ7nPox5s4W9HDReDgOPQ/AM/1ucJI/Gcg/yUsn/Qx6mKNuT5h
La6WqX7kmXwvunsR+NtdoT5hf+S4nmRt7wWqbxvqu83xVoBYIwnVOlOiWtN2
J3SyUyu92eXiMm/yQDzku8cX5nzUfS/6bRfymoPPPsifhO6beH4b1+yQa+ZC
bl5OaDbIFbmgz9OuJqOuLr+jJ//EaQMv48B2AmcQpwm5bvI0I/eQ748xxeLc
tIYlj5XpG+W/RvXO+6Dzw95YDXk6qd57Crb7fdWhvVC8kb/j0B0qESfsOXLJ
+WKe1KPOjUD7hbtlB+L0RoU/H3VIR5XvhLMnb00J1YD8s+8Ko+q9zyPqdfZ5
T6Vqybg3gPHvpHqv1xdW4iQu4qMt8RLPd1nyt6tC8q8SmhPG4q6ac/uKtuOO
T87fIV88cE/8F2hXEHtL2Qp+zgBzyAP2VZ76YcnXPHOW+4ul83hGRlytKet3
c3vCxSW2o8C1JqJcBpwObbnDmA9zyTj+uYcnob/o9kMb7vNR7fylQL3CPqny
NFecKe6kF8PaSwtR2dP2X2BexjmVr5iMzTrS99dO536gfwP/C+y1FtdX3ahL
ulJ7kTt+yu3520nNNnuZs3vS7QTum+m47u8Fis24NZ5mj3PHmcu4HFlnr1Q8
MIffCpQj549zyHkk94mY+Gev3Uqq3/4A3rwK7Rz2Qofrh56I/jf817COxEj/
Q67+jMv9momr9yjPuJ7vjsuetu/64p14XkIupaXC2O/4Y33HXb1Y31fRS40p
/avfAsYDSeXzP1M+F50=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFlIlHEUxa+Olo6ZS24zw+CMM+PyYpn0YFREamKQphnkUtACBblVStkC
aUSbRE9RZC9B0ALViAUZJBWUBfZShFoS9ZAF6ktFYCn9bnceDvy3755zz733
8+9sq22NFpE6EAP+BkTmQH2CyAD7IbdIGNwHT0APdyfBdadIIfdTuSLxaSLt
USI7kkSO+0SOgaJYkeGFxM0W2QLuEPwWmMwR6eL9YfCV9U+/yA/wXIzzYEhk
f8i+n04UGYNrHORxd4k3b3g74jdtqzibh2sOrBbTdMYlctplb585RDr4thOc
4g4Z8occ+rJEroJZ1kfT0YaO2+BIZN3IeYPbzt7x7i24gElLY037NHdTbssh
h9ivCDwM/KwnwbeAabsBX1u+SCuoJveYFJHuAnwAN8EJEB8UcQbNG/Wg2G2e
q9fLQVyGSBnx5olXjp/xfLON91W8v5wq0kyuLaDLYR5UeEQqgY/9C2qyG+1x
1KhhsUgTGOBtGXn2ks9otGnfwFmly3JQ7zvBTKLVYBC+erAVPAIrvCK/MkXW
cHdugcgH3o6Ds3AVE/8j64mQrbXmdXB9IvZEtHnoJEYj+pPRegX9TUE70/X/
nNC+MsP0nyf+RfZF7Jc4jC8cqZnWSntyI/k5cy23e2gqxatNedQnyb7xUqOX
+N+TYhq3B81D9U5ror3whf3nAuuJZnppH0h1mN+18Nd4zEvV9JD1g8hePdBe
0J6ajfREecA0KLfWbDM6x1zWO5p/NdqS0ywX1ai9dg3f+7Kt5/rhDvusV/fS
s2vhWucxLuXs5O6Qz2ZLY2rtdKZ0lrSGj0FFpL6aw3v2NenGrTVIg/tAyGZL
/dXadkd6UWusvbILHxoXW8+MwTXqs1nXGVIvq7LMa/VUtS8i34SA5RBDfrF5
9i94it4ZeqXQa1zaT/HE38N+KMo4OtDiyLR8tOeWUetej3mv+l/DNZJla82p
lFzuuqx3da+1G4z0ptbQw9uWfJs1/Se1or3dZ/G0Jr/hKvGa/+ppG/zfM81L
1VBPHg0B8157tJ9/Tdhvs6z/IJ3d4shs6gyXoHd9wPLT/vgHqszEYg==
         "],
         VertexColors->None], 
        PolygonBox[{{5622, 8994, 8993, 8143, 733}, {8972, 5605, 728, 8097, 
         8971}},
         VertexColors->None]}]}, 
     {RGBColor[0.4926851640642627, 0.4038796606805396, 0.8095089162828317], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1tslFUQx0+hS7ulLUtbaylp6botC6a0KLcYxWgQBdJ6IWK0iJBWCjT2
Ji2QcNFgpHIxRBKFPigkAg8E21JoSbxgTES8wYOICkIMPmgRiCkqiRHU/48Z
wsPJN9/ZOXNm/vOfmW/jtc1zm4aEEMpSQhiq54xECDO1rg8PoTIrhMjIEFoj
ITSNC6F5nL3XRUMYyA7hFx2oHRHC0VgIKdL5Ix7Cn1rzdXZXcQiNY0P4Rjpv
pYVwn3RyU0MY1O9XtGqGm91703WpP7GFnWheCJfG2vtK2VkkuU92tkiul/zJ
ULtzvetnZobwhuSrimFZhskV0umQ3Ck5VQEmpbPD5Qbtb3P9Vwtl4/YQHpRv
f+k5pSiEJ+TLEj2juqtF8gnJk3NDOCm5Xz405BoGL+u5ebT8HKbfCkL4Vmux
5I3aP+Xyi2Uh5CmedborR8/1hSZnS14oea3kkZLnjrJ9YvtU56rkZ4f2Xhtl
75vkS6XsZsjviHxI08qRzgX5drHI4jqqvC2Q3h7ZWKW1U/4WaX9/tslVgnpA
eC2X/IHiXShMDg4znX1671GeKuXDVNl+SnY2yEa98r1E6+9g+VuRbdju1tn3
5Mu8IZbL/hHGB3J/WDKkiimux5IW4x7p36mcdcjOSsn7pDOYYXfO1H65bB/S
fnnMONMoeY90zkpnt9auERbveNnv8nu7FMtk+bNVzzPC+ccyeydWYiOu43re
HTPf7tfZHp1d5Pv97uca8XxzzDDAh27XGZDvF5L22zRhPFVrrmy/q73dSfP7
nHwr1LNBcaULt9nCbanuKpFcPdbycEh106fVHrVaqHc834maDK5w63X5Pkv6
FVmGOb+ny8bzBZa3S7r/Ab0/LZ0NGcZn9KfJ552Oz4fy6yOtWvnUm2rP6lTT
yY7ZWXI3PmZco1ZSYpZTaiQaM5vlWbZPbV31vIIVvGhPGjfgzpxMi5c7iI24
4HX3aMv740nrKfQTcn4lw/Lem2c8xuffJbdJnjHE+gA1TU8gfrDBt4ocq/fp
EdODR6uCcYQcwBP8JZ5Mr3XiIZZGYT+6wPpNRP6kJs3WsHz1C/l6WfZWaG+e
YjuoHKTdFsLbxcaxfp29I9c40iwfmrSS2s8YH8KzpYYT2IMv2Obq7KFi409U
Os+VWj7/UYwbi62uL8vmz3lWBxd1729aW2LGZ7i83/mA7/SoY9Ivkn5PxDAH
b7j9sc4d0aqL2XlqCQ73JewO7NMLwAus3lR8bYolX/62RIwf5K1Xuk967Ntl
b0fS+jXcJVb6xhHdX1Rs934heVKx/cYZahU+4Dd1PD3F+lmO970MYRDVOie9
eWN0l9bnyu0PJSGcLrE+Taz0ZeL9Tnvfl9ziOE/6G/eQ5/nBsO7wffoFfYF8
8Tt8oB4b5cMLowyz2eLjI1pVwuhh4XOPcv+fzjwkOT3fOLC40DiBPKg8Fkt/
mvSPa16diFv/6NNev9ZLaYbBFMcBbMY4Ptfl+78l1rfIFU94vkm2J5ba2Zv9
CJ4ckO3euMUA73Y69yZkWQ3Af/A6FrX+3C3bPSU265YW2iyh1uDXZufY2iw7
gz6c4Cx1TJ2t8Fo7WWy9ib60Tnbyx9gcPCV7c+KG41cFNueYcQd0Z2+J5em4
9r8ssH14NuiY01NrvFewR73DPfpZvfc0anSZ53qX1w74wO+qbKsDuAyX8B++
1kbsnZlD/6J3MVP4LiBeesZ57xvMELCEF62+R1/qjNjcg5/tmhWtWpeybB72
+G8ZqoPqAttj1jLv6EF8I4AR+NDXK+NWH/RR5jP+UIf0QGqKGciMAQdmDnOF
XPe53/Sv1VlWE+TljHh4OmGxwSf6DHVHXTV7zwE/7OMPsbZ4bO2e2yavkZac
W+eQqZe9mXYvWHH2fdmaJBweLbD+QvzMTWLiXuZAg9cluOx33ILfW+21Tl7Y
f0W+r09YLsF5wPGkx6DPXcy3DW5zW+zWjAJj+FDhPYQeSN6ZV9Q4tV7uPrAP
l/e5HNwX8sv3aqvnmjmcH7f6g1OTnVft8rEtYbNhSrbVyVb3tct7b41+fyZh
c4TvP2Lp9LjPeyzMvZv1zUy+VmJ+woW9jjM5bHb8wZuz8PSceHe2zO7n24Q+
QD9gxhAXuYQXzFzkWeo32fnWu/Il/6TedFea9ZLD3ov4HsUGHJsl32drBdkY
0PPXhPGPHHd5rFt0bqJs1qVZHSz3WsDP6R4j3zXUNnVdV2DfImBBTd/4xgw2
M5kfzAG4Bv+It8Vjh4d8k66J25ltPp+p/X6vEfzu9Hl9o89L/+u41W8k3/oy
PZn/HDWOVWOZfWfzjT1UtdlWZrVJLskp3KAuwBQM6T/MYbgxw+uQGuT/RE/c
6rfb65R7+c+xPW56fFcw5+HnBd3VrLsu6v26cL2WsBj4PgG7FK8t3sGROyv9
Xr452Ednfql9Q2C3y3saPR9sN/rc/ky2jyXsHb0J7sOCUvu2wDa1sNpj/B+V
h9Ow
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslFUUhg8tlbaUFujM0M5YOtOvZSgpEJXlB2qigiACKkLC5pKiCRBp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         "],
         VertexColors->None], 
        PolygonBox[{{7476, 7090, 7089, 6133, 2129}, {6942, 5461, 5460, 6941, 
         1847}, {6120, 9581, 1637, 6356, 6119}, {8238, 9031, 3071, 5689, 
         8237}, {9582, 7961, 7960, 6121, 3563}, {6957, 7053, 1891, 5680, 
         6956}, {7051, 5679, 5678, 6349, 1634}, {9033, 8238, 8237, 5691, 
         3072}, {5445, 6934, 1841, 6933, 5444}, {7090, 7479, 2130, 6134, 
         7089}},
         VertexColors->None]}]}, 
     {RGBColor[0.5110268839510694, 0.43577095810707656`, 0.8352904224367957], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV1tsVFUU3VLaMk5bOtPOlLbMdC5TO6WgA7FiNODbCCLQVtCfarTGqKDo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlV1M1XUYxx/e4UAoLwdE5HD+UBwoGzBfWi3LrS6gpPkCtlWUsWVbmt2U
rRLTvAF0XbQ1cIG6YTdZScCBi8ikVc6XXtRpW850iQWomVZ6Aa0+3z3n4rvz
/M/v+T3vz/cXtL2yelOymb0LUsHmiNmr4MEss2VgcWC2CDzD2Vy+15SYFRSa
5YPVyHFwq9wsLWR2Pt0sqcasCf0N6K/KN1uAXAqaZJ/7n1SYtc7HHvgYeaTS
bBT8FfI7dXeadRWZ9aZg8w6zFO4mg4c4u5VJPAVm35eZnUKO8t9jnJ0hlnqS
eI87hv+D2PsFeyvxP1RttjXwfFblmb1cZbaP/Fr4PpdLrth7n//Cc8xOc70Y
3XmBxyqfJ+aZbUdnGziO3B64Tdl6g/MMbKVFPLbb4Dz1SCOeZ7E3QT1eVO2w
P57rOd5balZLfm0ZZo+At9C9Ti3+AG8iXyG3KTCBrcugmbuD+FuZ5zn2xMy6
QT7NysLHWWK6GTa7Ac4g/4qNa+jPoP8A+r9z/2KJx6KYDlCfJfhaDD6q8V7s
pX97yr0nFeQ5wv0nuf81+Y2h8zR4CnwOtpPPNtBhXtNe5A9AN98NfPfg/7tE
fzaQbyv+v6EfHTlmX1GDHnR3B64rGz/RxLNR76VyLqeWZRGvfxqoJZ6uKs+V
kGwt8lLO8zgbxl4//qYT9erA33rOd3HeyPlJzg9Rqy/B83O9Zq/F3Ibuhvkv
zt0RUMfsTCeZrePs9YjP/lF0VtCrv6lHXr7rDPD9A/E/nM1dctoSeI7KLYX/
dnK3M+L5KYZxajoEBsFhMIX/yZjXtgv/7WHfCe3CFuTj9GEF/XocHEN+lHnJ
weef9LIvxWOJVXltFZN0p7g7WeF31uMjA/108AJyK7//UdwP0b8/x2t7iJqN
hrzGw9g7rZ1HXkuBc9FvKHVf8vkFsY4BcYRqeIReflvps6WeNiI3VLruAmz+
i889zGEfmEU+he1K8mrNdh/7sdUP7kn1nRPXXC/02mmetEuDfPeHfKf28t0H
mrN8Z+dwtg67z4Fc5Ith31Ht5gXkLmK/u9R3SzumWdyN3saQz6R2TTHOJnbu
icA5S1wlzlDvZtAPZ3sPdzJ/G+9iNuCiXr5z4Kcj1Oh2iud0GPkf7TjySeqx
o8Z3TLv1To3vbgv92pTjOxzHfpg4l6PfpvrzXcD3ssR3C/Z+jvosV3MnGRuX
q51r1hBjL7Xrizk3iiNV6wl0LtV4zUdLnUN1rh6KC+KVzo3ihN+q3aZsiZMW
4f8o+R4LOb/Hq30mNAviAM2uZlSzqRmux3ZPmdtOx8ce7mdytjDbe7SUs/tA
e4bH10Uuuwp9t2r5vkmtboC4+TxUhH1GJKuGdZzVBx6L3oyhqNdEtVAPi5nz
WsWT7D2oJZ4LRR6Lcu4qcE4UF3YivyQ+i3ht5XOy2Kyk3Hupng7hazjw2MVh
hWHvkfS140PEnp7gd+3QDPY+K/G3Tm+eers55lyiHg9Q/7b5nrtq0MR5NOJc
doB61wb+n2TVXL0bS3DrpQQ3jye4Qhz9aaW/aXrL9AYv5+7VMn8burFxFdvX
QHqq16SR88yIv0X9nHcHzmniMs30aOAcJu5Sz04E/ibqLdQMDgTOoeLOar5/
DHzGNdua2aLAfci2OCSZer5NnFtBEnIztVkYdS4QJ+jt2JHYBb0h56LOSeKi
TnRmo56TctHOL4n4TKr/4nhx+/5C1xXHT1PrKzHnTnGIuE9vqN5OceAA9g5G
/a3Qvos7MsKei3r8P/kmTIc=
         "],
         VertexColors->None], 
        PolygonBox[{{5139, 8240, 1799, 6786, 5138}, {6955, 6758, 6757, 5637, 
         1859}, {8969, 8176, 8175, 5606, 3037}, {8235, 5135, 5134, 6760, 
         1789}, {8176, 8183, 2565, 8182, 8175}, {7233, 5890, 5889, 6789, 
         1799}, {9580, 5002, 5001, 9581, 3562}, {4993, 7050, 1890, 7051, 
         4992}, {9960, 8216, 8215, 9959, 3934}, {8095, 8967, 3037, 8973, 
         8094}, {6579, 5600, 5599, 6934, 1757}, {6752, 7088, 1917, 7087, 
         6751}, {8991, 8139, 8138, 8995, 3041}, {6783, 7959, 2460, 7958, 
         6782}, {8216, 8996, 3041, 5623, 8215}, {5618, 6625, 1764, 6942, 
         5617}, {8236, 6483, 6482, 5137, 2588}, {5639, 6959, 1789, 6761, 
         5638}},
         VertexColors->None]}]}, 
     {RGBColor[0.5293686038378761, 0.46766225553361346`, 0.8610719285907598], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVmtslFUQne5iH8v2sWy33e1j+b5uSyvVFNBE0cSAQQKFYqIiYABbJBgS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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmtsk2UUxw8tdPcBtuvalXZ76cY1EUE0ookhERNhgw/eowMHKiYaJX5Q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         "],
         VertexColors->None], 
        PolygonBox[{{5524, 7232, 1991, 7233, 5523}, {6578, 5114, 2563, 8172, 
         6577}, {6958, 5514, 5513, 6959, 1860}, {8239, 6788, 6787, 8240, 
         2589}, {5123, 6622, 6621, 8208, 2573}, {6312, 6982, 1867, 5645, 
         6311}, {6979, 6312, 6311, 5644, 1866}, {6763, 8234, 2587, 8235, 
         6762}},
         VertexColors->None]}]}, 
     {RGBColor[0.5477103237246828, 0.4995535529601504, 0.8868534347447237], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VmlsVFUUPl2c0k47Q5jO0Omsb5aCRhBBiUACGAM/CgXEaGIEWWIIBgL6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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVWUQx6eLLffe0iK9t7S37W3PXdBGMUQUQknAF3xAdqOGsEgJEgwE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         "],
         VertexColors->None], 
        PolygonBox[{{5549, 6785, 6784, 6823, 1814}, {6756, 5878, 1979, 7213, 
         6755}, {6785, 5548, 1813, 6820, 6784}, {7948, 6756, 6755, 7949, 
         2457}, {5579, 8939, 8938, 6477, 716}, {8879, 5560, 709, 6750, 8878}},
         
         VertexColors->None]}]}, 
     {RGBColor[0.5654612959894245, 0.5302011487086897, 0.9095361380395472], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV2lslFUUfRZsZ9oyLcxMZ5iZzvSb6VAXYjDs4FaDGiGsJqCAFkgbFQyU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslFUUhi9QYWZappXOwHTazvRrKVhDjAaEAgqWYIytIGACUQMFAqJg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         "],
         VertexColors->None], 
        PolygonBox[{{5504, 8860, 3014, 8879, 5503}, {5557, 9647, 3617, 9646, 
         5556}, {8212, 5980, 3425, 9387, 8211}, {9645, 7383, 7382, 9643, 
         3616}, {6183, 8179, 8178, 9650, 3617}, {8185, 6567, 6566, 8186, 
         2566}, {7383, 8187, 2566, 5117, 7382}, {8866, 8807, 8806, 5560, 
         3014}, {8179, 6181, 3616, 9644, 8178}, {8926, 5246, 5245, 8939, 
         3028}, {8889, 8940, 3028, 5579, 8888}, {9388, 5576, 5575, 9386, 
         3425}, {5978, 8212, 8211, 9382, 3423}, {6567, 6071, 2100, 7415, 
         6566}},
         VertexColors->None]}]}, 
     {RGBColor[0.5789467042314378, 0.5518684473988502, 0.9098435638118401], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uMVdUZhlexMOcwM2cYz4zjYWbOOfvchiYN9pbUiBekaiJgVYrgLZai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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3dwlNUaxg8gYU1wA2aXQNjs5svuhuCM5VrGgui1zqhgQUUFBFS4KEqQ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         "],
         VertexColors->None], 
        PolygonBox[{{6182, 7384, 2079, 9645, 6181}, {9383, 5979, 5978, 9384, 
         3424}},
         VertexColors->None]}]}, 
     {RGBColor[0.592432112473451, 0.5735357460890107, 0.910150989584133], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl3tw1NUVxy8EkyXZJAybJ+5usrvJJkA7oJbOCKG1nbEzRa0tBeyUOj4r
jmhA7ZSCxFJLW1DbUUNBoPVFyqMwHRSEkASwYGZamL5EIGqR1rFix4rjgxaI
rf1+/N4Z/7jz++39nXvPOd/zPY/N3bhgZufIEMLdI0Io0TNxYQhlWi1lIRzL
hNBRDOEqfVibCGFjVQhfkMxe7V+UCuH32nu1OYQTY0MoaH9VOoSBhhDmlIZw
tDWE03pfNSqEUbrjOr0PXRDCJO2vbwrheSkdknxR+8u0f0EuhNd0z8W6Z1Dn
B6Xzasm8Xh7CSr1/Ru9HqqWzIoTfaQ3qPa3VqbOf1/MyrdXSdbjav/dJfrme
eyV7mWSG9Jyq343ys1J2XzxactrfKT8Giz7P90ujzAf5ECbKqeM6d7Q2hGph
8qky68xEvefqdSbj+x+V/DNF+3KsLYTn9P6Q7Lmv1Odm6s4X5WO99G2Rj13y
abe+TZCdLdpb1xhCr/b/Imz+rPVv2bdee7/QOiK5K6Wnc1wIH+l9uMR7d+ns
ZNn3Dcmu09lyvW/Rty+NtJ5vR10Xaf/TY/wO3h802c4p+n5bm2OHTx+W2a9/
Ki6ntMYLp1f0XC35V+TLHdJ/sD2E/0n3JHCpst6l0vkV7TVLb4fuWK73b8rf
Utle1ujfA8LjdLvxvVt7m9vs/yHdfyRlfL6j/aa097vFq0e0vq74z9b3W7OO
WZ/4s18G/yAZwmLZ1dXkWJ9VLPrSjinYn8gb/8elszftmD/WonhK77WVipfu
WJExrwe03681v9LcGpE0BzrqQphR8O8/iQNn8ubR7IRjjq4SfTtVYfkHJHOF
5DeNdM5M0Lfz2l8u2/plw6Ds+W1NCGsKxmq1ZP5Rbm4f0H4x6/0dCfMfbOeI
M9fkLDdPfj2V8TdyCZ+482+6ry9nLmyRzKPCa4JwfkG+zk05H/8uW/YnzJm3
SvwO33pk2xuyrT1hbr2kOzZL5ozku/Q+epT9L4mY/FQxKKn2/oWKxS58q4RA
IbyTcty3iifbtMaJC/u0xkl+muTfkfyv6s2rxbrnP1Xm8qGYs+TvZuXZMw3G
hJzIpmznELoUo3nS9ZxwWlS0H/jWGznfKY5fUukalZJ8SaPzjzp0Ou1atFm/
6+TLZ0vMX7AG55sjLujCj3+l7Qt6Psz528u6Z5P255U6V3hy53b53lU0pvi0
tMJ+YStxIkbEDF3UtAW6b6HWecW0T7bcMtq5uVd+7c/almH5epVWRneMEYer
tbbLv4z8ymoNaH+27piVc43sFa5Ncf8NcalfOE4faT9n6/vb8iWh328mnO8/
k49/bbMPNwv7DTpXJluf1R07tPJVzt0RGecvtX84YWw7pfMOrXPlxpL70XNO
+XK+xbHmLu6kbizV2buiTK3kZ+l9it7PSvZci+W4+3y8/4D8XDLGeQoGW9uM
Q7/qwUDzJ3fxJL+2lvssvWON6sFgvfXTn5DDd3rL1JRl8PmWSseuX77u0Zqq
9/HCeEK79f9BOlP15hT1sj32qT/qeZ/uuUl3zNX3TS2uMyuEx09yrsFgv6vB
+P+m1nWKGvXjtPWh694xtqF7lDkyL77XNvte7uyR/PWxb/aLF0dz5kpW+9sb
3Duoj/dUGU/8BWt8bqg1n+DSYtm4ROsK6XhL5463mpO/bHFNBGdyle+3j/Kd
UyJu1ERmAXJztWxb0+x4g/HkVuM8VOO8JWdvV95fknaPoF8tiD2Lvs0etXGT
5N/PmI/0cb5TcyYmnZ/EdL7wX1RwDSWvyD9qFziBHVjR2w/HXr8MXsmW9ZI7
WGFOYxvxbI8xpT+/2+I4bpD+VwvOSXpJZozPrhTnby16BqH2zI/1p0Py0zKu
/fQwZhF6Bf2D/kfdRi86mW2ob8PRZs4wi9AzyBnqPtxIKj6lOXOX/kBsiEup
nstb7c89sZZ8X/J5YbKu6BmE72UNloFHcBpM6JHJKvemffKvt9XY7JHffVq3
SfZGPRfW2e4vS++C+P6UYnh5yr383ibPN9hM/Dn3cX1uc5/eHesuOFHTJqed
G+QFfb6/1jhR1w/FGL0r/E42uwbRR+gh+IU/8AAOPKhzuTa/w4vBOGu9l/F5
zq7SHT9vdh2BR2cil+DsrFjrmCnGtnquaNOdx7OOxUnZ+bj8elm6X096jgJf
8ow5lVwjpvSRpbGH08upmc8Kt2Otxpu5+LVmf6PHUZ/I628Jm7mN5vG19c5n
cpm+ejz2VuZlZi/upKZ/sdR1kl62LWFcyXN6A/lLnab3EGPwRR+63ky7p9JP
iTk8I+6c5Ry8XaHYTkqb29OTrpXUwCPC7GjGucY8vqPWvIUXcALfNwqznqzn
S3gIXmBVIdk9Oc+AR+JsAbbIMWvSy8Bvbazn8Htbud+pLwcqrCvonoez5s/T
8q8741n/TtmQy3lG7kg65sR3p/bfFmj9SeceNYV6Ak79EauEzq0vWN+Vej6d
t+ylMV+ZYX6tex5odE/+r2Lxo9ZPYsATbrynGtWd9lzB7IwO/MLGJY22k1r/
YNIz9516vhD/q5CX16Sdmy/Jv4Up14OBrOs48WHWYxakbjDTYdPHM594tTbm
+JPy5Yk68+EGce+mFuPaobOHa1z/75ctJwueYcbrObbO8+iSpGdGas1q5pNG
vzcJj2ze8YRrgzGPn5fOg0Xn64SC8xCufjXvuRacn5RP4xqcj/CbPgN/viaZ
mVo9uvMhPR/OO8ZgCQbgubPBdmAD80FPjN1Kyd6fdy3vlczajPHskO/Tc8b0
jPz9bso142yd+yj8B2u+gwP/O5l3ySFqFvdRc94XTl1Zx7Ey5gc1dneNuQJP
nki4nsE3cnQo8oT/YMzFzIHwnrmOekVMVuaMG/z9qMYc3i0ePRZrC3lKXyHv
wIAazH6Zzu2qcR4WVG+Ha/2fib5AzMCnWndWZT0TUVfIdzAjD8gH8vd66dmQ
ds0HL2ZJesqLKf+nou59Lml5cmdO2rUAe/ivkKz1/4VmYZ/L27cVivt1dT73
PXFtkdaMSsebeZd5aWPautFLrH7YaP30dmwkptT1rogV+YFtyJwoOOevjrWC
+gFvp+Wc8+DPzD4izu152VXI+y5wpXaDIf8n4A/6KnVff851h75FLLvi/9Gu
2Je7dccjeffnGXHWoQ7xX5Z5BdvBaXrE9lSs1XCA/1FwGXlqPVjiBn1hYvx/
x/xN/sNH/mfcUG+siD88gKvMF8siH/4P1LyCkA==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lw1dUZxk+I3IQkN6TcJGS5N7lrAqgDYr8YgtrO2A9ItaWgTmlLASsg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         "],
         VertexColors->None], 
        PolygonBox[{{9649, 8856, 1408, 6184, 9648}, {8085, 9500, 3515, 6070, 
         8084}, {9651, 6045, 6044, 9652, 3618}, {9502, 8085, 8084, 6072, 
         3516}, {8925, 9390, 9389, 5981, 1168}, {6045, 9501, 3516, 9503, 
         6044}},
         VertexColors->None]}]}, 
     {RGBColor[0.6059175207154642, 0.5952030447791712, 0.9104584153564257], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHlw1dUVxy8hJpC8vIS8l/cS8pK85L28xK0W7UxtqzPdsBZQUUaDUnUU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1l3lw1OUZx98cJByBYLJkd8nm2t1kSdFSpDO1gjM91FZQGmAUkFqugkAt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         "],
         VertexColors->None], 
        PolygonBox[{{8083, 7371, 7370, 5076, 2536}, {7371, 8082, 2535, 5075, 
         7370}, {9654, 6042, 1241, 9651, 9653}, {9375, 9370, 4219, 10199, 
         9374}, {5975, 9375, 9374, 9373, 1167}, {8922, 8892, 8891, 5578, 
         3027}, {8810, 8857, 3013, 5559, 8809}, {9907, 9458, 9457, 9906, 
         3891}},
         VertexColors->None]}]}, 
     {RGBColor[0.6194029289574775, 0.6168703434693317, 0.9107658411287186], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnt01dWVx39AQhKSm9w8byCEhOTm3ksfPsFBawcf6MDQUBGtlBY62Amg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1dUVxy+QhZCX8EKWF0jieyRvi1qVzaJiQSwUVDZxQafQEU1YRAQU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         "],
         VertexColors->None], 
        PolygonBox[{{9357, 9371, 3420, 5975, 9356}, {9378, 9357, 9356, 5977, 
         3422}, {9455, 9449, 9448, 6042, 3488}, {5026, 9453, 3488, 9907, 
         5025}, {9368, 5038, 5037, 9921, 3420}, {9449, 9461, 3489, 6043, 
         9448}},
         VertexColors->None]}]}, 
     {RGBColor[0.6328883371994907, 0.6385376421594922, 0.9110732669010114], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnuclWW1x9+5MswwzN5zH2YPc9uz90YtAUVF8IoRmqUpJYN4yQxQM0vR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd41VUShk9CGgmQhLSbRnrujVioKkIo4lKsCLh0FtAF21rRleaKoqKI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         "],
         VertexColors->None], 
        PolygonBox[{{5856, 9377, 9376, 10145, 4162}, {6033, 7379, 2078, 7381, 
         6032}},
         VertexColors->None]}]}, 
     {RGBColor[0.6463737454415039, 0.6602049408496528, 0.9113806926733042], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3l4ldW1xr9ATjgJCeckIRMkJGQ6B5zAVlABgcpQq3VAARVEnOt0bR0q
FC22oogVrBJQBMEBi9WneAtSAYdaxakMitTeeuvArVqLQOtEsVXkvj/exUP/
+J5vZ5/97b322mt411o7vc+9Ysx/dUqS5K7CJOmsd0ldknTVM6soSY7MJskl
XZPka/1weu8kObsqSe7V4PH5JLm9Mkk+1fg7uiVJR0mSnKwxO9S+WOP/rvby
4iSZp/YRGv96e5I8p29OyCTJoVpnrvrnq786nSQLypJks/p+rfbEVJKMVn+J
1n5FcxxakCQ1FUlykMacoDH/p/mP17dv67eP65NktWho15h5mnuq2n8VPYvU
/1Gt6C/03HfF/DuL3C7X+Etbk6RHTZKcq/53RVOD5vtA667Tb+/r/UO9+zQm
yZvdTf+tGvuM5t1Y6P09mfEeT6nxeqzVkPIc1+rbIvU/rP5jmV9rLaz0up1E
5zy1i9XeljKPr1H7CPH5hOBbqdpTg59T25LkR3o+F90DOY8i86SyPEneSXn+
xaVJ8qu0aVild0kX8+7M5iS5R+e1SjS9qLNYrvlXqF2subro6ae+hfp9osat
0G+vF/sN/4s1xyCt9Yja/Yrc7qF1d2utGzWmtNB9g2PMydpr70bz8xvVSTIm
p7Pt7DG/6upvD1e7v54vU5aLMUXmbXd9+4jO6wONOYQ5RNMS9Q8TDdNSPo/H
xLMF4mOvAsvINaL/Ia11f9pnxnk9KPqXFluuDhGff6dvhqv/a/HvE7XPUvss
ydJEPQ9p7Tt0Rp9rzjfgm3iwTs9G0bVGvJ2t+T+QLN0guc03W/5f0NgXW712
W5xFK4/GzK4yH07T2Fbt/WHNs05jL6sxncPUPzl058li/75W7+K8ZQu5+r2e
cu3nONH5rOhdLr4MVfub+u7fvZLkp/p2l/bypfqni7YpDaJf7XPVLlf7W01J
MlLfvy7+nNTN+71Jfw/XU66+CZono3ELNE8vrfuo1t2uNR/R+1PNs03tb4r2
I/X8T8Zzb4755+n7lTqPOZpzu/Z1e4359oLmO0z7Hyz+TE9bnpHr2/T9DaLh
Y40/TX0j9Fu1+jtrXCc9d6t/tOTkLK11UOgeOshZlqqvQPJwCGNp66lF1zR+
kfY4SO0i6ciEEq+7K2NZ4fsJ+q6jZ5Js0lodWreP+ur0zCr3O6f5L9O3mzR+
XNihB0NmLqkwLW8iMxmvP1J7/6bWfbTWNDAHc/5RY/Zqzr5q/0nt9eLJ1eLJ
Ss25ucznwH6H9FBfH+mNaJmkOTqLV2+oPycaXhENazqbDujZk1gPRtdbF67U
c7yelJ5PNXeibwfo29M0Zo/k4ORuPueT46y3i87e9T6nOtnvY8Sr+UW2e1Vp
28AJ4k0XzTVC7QLt9xDtc2dXf/N4nO9pea/HWk/r26/FmzvUf2/K9pp52MOd
6v8QnS03Hc+qr6vm2KZvVnaynPEeoDELqmyPsEW/1PiHy93+regt1H5Ohlf6
7gzNf6La6/WMYy19exTyrPZAvdslC3k9G0T3c/r2+XrThL26plvYKfGhf6Pp
nqw1r9DzG+2xn2S1f4Pn+lnI56D/sPvY7S2aZ4HmOEd7/Fz8mSbahoXdwtZh
C/F7C/P2fa/q3KeKVzfpzG/VWc/qYR4MyFmX0KP7tf5N2v9SrbNB596qvZ+u
vVybtpxuRB40drbmPFVzNmbMU/g5U3236KnX3/Oyfs9X/6i0/U19yjKJPCLb
a+FRueXmBNH+87zX2yP7cUt72G3t66hyy+1ajVlTax0drb9nxDzv6vdMxnby
WvHsAo3ZpbmPLve3V2nMdZLBIZKxnPTwE+3xmbCf96pvcZP1kzmyGfv260VL
meZJd7OuXVxh/cGfr8jYp+MDV6p9kXj1fKn7af9dfH5QfK8q8Hrtemaq3VW6
9VGT8cdInfmIRtvXXno36unQty+Vmydgg7l631luvUa/50b7ggq33ynwuyPa
vbT/Lci1nm/pjI7VszVj3vNGdu7Wvt4Qb0/S32+m7bf3FIT/LnF7Wcj80QX2
52Pz9un9WjR/3jq4RL/fp+cvmvN89SXi1b905r/u5O/76ts/6SwGVHqd+Vqv
Z6ltYJPG/0py+JTGn6j+PuWWhTHYQ/2W19+5jP0j9o7fc+UH5CUX/MFn3pW3
36QvH/2vqn9Is7/9KGUbX6FnkOg/WHx+rNi25G/gIu3l8BbrITo4U/u9SPLX
X2Mu0xzLQh+xn0tiv6PF/1Ehl7SRs9pC/04fGIl9IlP4lFukZxOajXXWa98D
tcazGj9P33bo+Z6eKzXmKj0FXez3zqyyTUIXn+xhfbxY+O41td8rsP0bGjYQ
X4JPAXuApVjn14FLkT36sIM79Pdk8edtYeN3eluWh+tM5mnMZI25ROs2iA8A
6zbR1Krn8DLjPGT9orCR2My7saey2xta/fcx2lPv7ra96C24CwzwkM5nWd48
wlZin/Dvu+JM4NvVWrdF3y4I3AUPwCefZWxPa7T+XXr+UWSsNVE82Vbn/YBR
8Bng1VE69w/UP0Zb2K73W3l/88dSY+BrNHav+qt72Md9LP9yadi6XWHToQk9
Pj72i+/4sMj+A//yWpl9JXzdWGbedtLZdm4+gLV5s1ah+lLNjklGpYxn8RFT
wFDi26pC47KBgc1YY1mR/dQXmnt4xli4p/bRqGeN9GVW2naOMR+KZ99oOUAX
b/h/hvZ4Zp3nAgteEvS8qzPf2ttniXyDqcFmkyps+7B752vOXnX2K4PL/AZb
Lkubl5zDXPGtTeMWFnjdzcGT3zZbRpHP3eLxjdEGI8zsbpxwnM6oR53l8Ot6
4zmw3HfQB82/W/0zJINn9PZaR4hPF/YyrZ+mjBGwpeO7Gzfwdx+t27fZMndU
6Cn+4gHNeYFkqUrzvJuyDQMndNW3V9TaL9ykvc/Q0wK+qHDMB57GpxIfQOfZ
4vsVKcd02It/dLVulmntbkWm/7Fy//6Fxv9VdPXSHgo6G7sQ93yi/h+nTQex
UFuc+WL1lxbZdmO3sd+9Ys46sEGL16OftcDL3xc9Q8p8PoeEDctoL4XyVWPU
d2SB/X//iHeIYWjD//6BC2jfKJ29rtWYBzlsi3jt46AP2n5Z7PnZ73b0Vf1b
Ux5To/Y88GdiXAgm/LHk9AY93cWPy0XnpXrGF3psbYzfGt8yP/EDvzPHtyUP
pZKHcwqsK8gE8kA8dGyDceMOfTsy5Xk+zlpPRgX+4o1+4UPmhx8Bo2FzsD0b
xMuh2vOcUmMR/CI46p4C/037BNHQV/KxRO2dWWO7kWGDsEUrC+xTmA/by3ki
U5zv6qxxEDE+mHdv4N7ROqNRGdu3QwPDcl5zdL7rRNNNoqeraByTMrZ8Wvt9
q6fPBd/1UazVI+UzQMaSkC3WBSOPqvff+LDZpbYDvOdEOxe4Ah+6U+8der4r
Wv6gvyelLXsF4llnPQ9pH48Umy5kiVzFybX2rdiA20tthzuqzVPWoG929B8X
MvGenpqUY/3rE/Pso7D77GNHnOMnIU+c9UHSwau72DaOl69+WVjl96LlqYzt
OHZsg/o2tpuvxL8zy+1PoXspZ6Z2b+2jTc8z+vttzb1Xz+Naq73I6yHnI4OG
HiGP0IBMIqfbgzZiLWJd9jRMPHhHcy5EVsTzt2pNJ3bpk6AfW3MfMUeBz5Nz
JSbF3hZHHgPfURJ2bKt4+A3pYFOh5fDaiKFO0twva63VMXdJ6Cbfkw9hfBf1
pYss83eGnqPX9HUJXbtUdD6bty1kv+noZ69dwt62ic9l7db1TuCgKuOccfru
dD3bxMNnwEul9umXirapDd7bYVnnu8DD2Iz2oHO//8COzg5bhR/hPST62Vd7
8H1n2lgDHPILrfnHamODyozzaH0LbS/xlWDLmWljBfb8RMp5OuQN+3Z42D0w
+F3NxuFgq7Z2Y4tbxe+f6xmv9coy9vv4f7DAlc3GA+SHyLvhA44Rjt4TPCG2
+Fm7x5MnO7rF2GNAyBj6CP4ljwKdV9U43ibW7hCv5mbdZu/IDTJwV2BjsHe9
xl/Sah4tL/e+0ffpzY4PwaL4AHxPe2D+0vAX+M9PQw7vSHuv8AK7iJ3EpmLD
BoYd26N1v9LzrtrfEb+75hxnbIg4D//+arTJM6xK+Tf6iVU6p5zLAmsOjHN/
VvT/Oe/fWBP8wrqPilcvtzkn1ls63qRnrGjepf0cUuJcC/6yc+RbXpL9q6h3
Lg65ezpj2WtQ36ae5i10bQp6Jstmb8r7b/IirwbN5BrJOZK7GBJ+APszNWXs
i7wRT4Jfro/cEfj0iAJjfMaC58Hp7P220OtT9BSGTy4Lv3yZZGNvvc/jcrU/
qfdvj4q3G0XzXOyazv/xrHNZ1aK3Nu++l/S8mPWcPUXzaynnrJAXbAx4G/ln
DmzUEvFzcZtlm3iafM/sxHYHX8X5zhJP1vU0VuwSejYvfOj2sHvEHv/MGi9N
E52bWm1/sf3gCez/EYpZu9Y6D1CvOae1WW5/qneq1ry4O2wX2BvfBbbAf91c
bllBToZWOJ7mLOAx68DnxyR3YzTv6gLnYfFtKwqMqZD/t0MmyMVhG8F02Fhs
LTa9KsYfLvrL6zzH8SV+0/9ZhXEnWA6M+EzIEn6BtdBZ9ACfBYapq7ecIWPg
QmQFOXmiwHkHcg4PZp3/xDd0aXOuEywNlhkXeGZ2+MGRiTH4UxGDYIfXB1Y5
Q/zbmvff+P4xIVf/zrqN78AH/CbkfFW03wt/uiKwwWTxdUapcQVyuipkdXZ8
w/iSWp8l53hFnD+2hVw6eWri/d+EPWV8P+39MD3rRcvGbs4lM25erMsZjmo2
Xgerv5H13pj3bMnRnAbblnS5dW1qfDcvaJ4fbWQAO0vOjjP6Muv9b05Zvjo3
WMbIKc2P8diX80otV5wDPhkfTR1jUK0x91F6Xyfe3pZyzpL1Od9W9c2qMU7o
kFw8k3fufliFZbQysPwVwR/ian4HE+IL/5a1DR0uXi6sN8aZqLX+UG+9Bd+/
G77gTsnjavHnrc6u5xCrEosXac0SPQ9rrlOzjk34hnwSuSRiT/ixOWKQd8TP
ra2eA4yJvcH+jyuzfQNjXSY+nRp6RG5gW/CZ8yuN+AI7VxO2jrwR+SNs/sGi
5dC87dAdmuO5BucusH/bwgayB7A79md31naDvNOUtM/qtfCBb8feF2kvh4Ft
yRWI9h16Fpc5nku3Gctsib2A7cGiW6LNm7+7hl6gExsjlnon5seGbY0zYu3N
oS/oNDSg+90iJ4Z/JIfNt9gfcDj6As7FVy+LfNdu7fsveeMRaoLkF/Dv1BKp
i/D3HPJ7gR/ulByVafzyrPmwPOR2eoPtPvYa20GOBT4cKuxwSLvzudg8zozz
+r7exbXG4rMkV59V2neSX8C/4lunFTuex4bg38jJ4gMvLXaOBpkBK5OjwV9Q
S8HGoqcrtL9xWa9FbXNzu2PdaQ3Gc2C5pwPjscY/tb+P4rxer7d8w2PyQgu7
2Xd/S3Mc2+6/T9b7FD2Pqf1Zvf0fvo/5qMsyJzlF+Mx+VqEvedfVvqq370RG
yc8dFDk64hN8Ivk9amfMjX8B+90R+I9awY7QqfaIYfFz75c7HtufJ8bnzklc
x3qq2LiCvlXR3yIfNFbnu6nYvvnx+JY8DVgfH8y3/I5PpB5Vl/fYlcF3/B21
RPwQvod8DTSgp6O0p9GNXntLsW0u8taQd35n/9g1gQ3IFWAXsAnkQfEzxCKc
4disY2TsH3zBBt7fZh3jvKjZdsm7brsueAffThGff9pou0KeYG3s5eAKx11g
Dc6DXA/2nNjp6azz/NR3aJOrfzJiMWQO3kIPPpF8E/kp8MYI4vVa6/ChQTs+
pVI0TKl1DuL5iIXRwVeFGX5Qa4xD/e3pwGQ3ak/frTG91LJqo35ArmZNxH3E
f7Q/SIyjyTWDpb+j93EZ1yUPEz+e1zyvhP3ulbE/5zxHZMwH6mA1YSOvb3Vc
RExEjeODcn/DGb0f9Q54wvzw53Od+w81//yszwh9gy/U8mijdxu197k1xnfY
LfD9Pv9S7vmZE36Q08GPD6jw2qx7X+S1sMPYrUNjTN/IPTHPlBLvndwz9xDo
BzuRdyD/AHYij51ELWOReHKvdLYp472MCl7xHh1tdPaXYRuPFE8Ob3X8Cb58
IrAQ8+2N3HhTo2MA/DN3FXbFfYX1ba5bU3OhRkqdkrO8vdWxAXEBtfcnQzep
C+yMHMVMxW53V7luBv5Ad6j7k78nN0Z+ihj3iUrHuROyjoXIH8HrKYGnmYu8
B3rBe2fkQ8gZ7Ij2JNF2TnfbV85tVpzjevX/Pud6LHF5rrtx2bWhY+gX+3w/
6nOc1d7IQ/ZsdE4W/eB8OTtk/vJm43gwPLWXu0Ju8ZkLM/YXD2nNbdXWofGK
NT/T2lnx+0Wd20vtzhE/J396WaX9wJ/V/kGlfQXnko2zfrPZ9xLgM/Wj8ytc
W6IWiO3CX5D3Jp5HZojPwMTgpZdFwys55/K4k0CeGP6DuS6P/B614iUNzpej
g9S8kcMxkTPm7gTjmAN8/Bft6QFqVFnrEPKHvOFzPg47dhs5nkrH6KwJBuX8
yaPwHXJ4Rdr1YHDkeTqTyTljzvtbnVtpCizOXsDh1PC/Xe0YkfO7Jn0A8347
az7P0ren1hhbgYPWBRYi38+dFXzyPt7EnNRbqA/j147T3OfmXJOv0VkdlLd/
gdbhWdMDhoVuaF6ssUty/o3aI3tkr9SH0QdqxAXiw3RhghElrt39od31u6cj
14VNpsbG3SbqeJzL+MhZdRftlQ2uwfbIO+bE5yFj3N1hfLbOtR9wE3LXEViF
fAWYG7wNNhnZYHxS0eA7HNjL7aJrR5PxDTnnQZFfxm4uiHr6/MgJYv/xqzMi
jmrSvnvl7AfwQR2x1sqIe5HJq6mJVRqvcj9oQLV5jZ1YG7aiss75Ms7z9Bbf
1eB8wcTE/3xLDoq8Ofkn+PZM8O5M6eZQ7JLmmqZvf9Ri3nAfY3fGPqdfo+/6
7Ks9pYwXsYev6Rxe1XO8xk3QPibm/E1L3vlH1sAfdETOh5p5c9TNd2mdz1uM
9aFxQzfTiV/lfhW+9ea0sQ45LmpQN0eb3NgPG5wfw879JO28D/d0NgVfBmqd
AW2uz4B7wRNg37HBf/DDdZrj+gbPSwxN7gDMvO9OROQcBmueQXnHdi/09L0Q
dJz4qTBvHlJXHxy19XPEg7Nz1g2wGzYX3P6E+lbrmRR8XxpYAixQVW+ZAec8
kDXWIaeILYI/V5f7DgV2Ap++GLkUbXPF+wsrnSNkPvK/2PbrRdu/ch5HrfXf
OeOE0/Uen3NdEZ+/MfAP8RN3XIgL9qC7OdNxoc7nghbbs6XIfKX1n3oCd5XA
1asDryHP+NJF4U9T+uaxtHMyxPnkwMjL9ax2vZk8PfxenjbPyZ9hP8g5kCNB
JqDnXM13Xrvl43a957S7VlcrmT+lu+X0F6J3Wc72izuG9Xljzm1NvnOAPn+u
safX2W6DNd4PPMM5fR12DB+4NHgI7cuD/n5a87km44sVWmelnjM1rpv6L6p1
7qGUfHCDYw7uyPyowXHb/GLnf8Bmrd1d6wWPgOFWBn5ARoiDkRPiVu5mEXNy
/isiHqY+vDvnb4mnb805HkVOkCni9f/t7nuQ+JoPIzdMXpy7hNALHuBswFTc
h6muMAZ7K3I78GN05LHIN6Ui57Qg2twZeSswDLaYWJe87wP/kYviDs3YjG0+
OYficucd7tO+368zXQWRzwIzUCcj37A/rqXNuZO3OLrWuYt9ddRm11KpKx7b
5DkSjdmbcy5qet75DsaTP/kq65zJONEyPmN975vznSR0aWWcAecLvdiEOdFm
D9uQTY3975zxLPm2mrARV2mtq/PeW0q+srDVdmuI+o4hd6/xb0k23m732vti
hKCB97hoY1N2Rs6IXAvfkTviXsi4oKFGc1e3Oo78IufaD9j0y5zv6RLDghWR
IeJE8kZfxt6Jw/mbnMDCZt/nIH++pd73KcmvPhw2Cpk/KeZiHnQEOQGTY6fu
CRkgTsJX4adO0jwn1vseFjEIuU5yRPinhyPORU5+nLFscLeHOiNzPVLv2gyy
MybohGZqTzVRYx1c4TwLderjw/aBkS4Ujy/K+4yxjfRjD69U3w/yzrdxF2d3
5GfAuewLfEvfFzHnXq1/Xt5/k896InTyLPVN0vNJ1nVV3qOCnkGRLz4/3uQY
yfOBvcBdqbzriNjidN55LnhMnEIdB2x5cNSswQjEK1Pi3tHCyBeBSYj/yb+Q
e4G3t0Sshx16PmwR9vuRsOG3BlZfXXAg7sK2nCHM0Cdn/pDfQ9/QkXNkJyY3
OhZnLN9zN407sD3q7eNLolZIrnui9jEh75rzLVFzXBIxJmeAb1osPtzbYNvZ
Ll+5t8r2jBwsWBteoUefZqxLY9GtnP9mLuSHWJ4cE3vHjmE7b47Y9uZYl/aG
WJd93Sy6htQaV1LjRb6Q2XXi0wtNji3IZ5GHAtfd2Oj7iNxFxP4ha9hA9rAh
4tl7GnzfjtrI8/JXs6sdd5IT5l4gOWSw4Masc3TDpVtnVTm/OVDjB7S4tjMu
7OG2iCuvDD3irtCAvGvTzLc+5iE+JwdJvu/FaKOP+//GR2DPseX4VHJGfEvu
HVo2xDzg7iNytmnXVXj/7H1gheNqcgDcAyX3iI6fKHqPqbbfRq6ejxiNmIr/
EwCPgRMbc/6dvHj/uD8DnmRf8I0c0oTGyCNlnS9Gt8Y1O44lhuVv1kffyM8d
FPYE2hiPb6IGS92RmJo7oNtjni3lrpOyH3DlwZG3IcePnCFj2ETyI+gLtYUz
a11faBbPRzW53sY9Gepb5BO4/3NW3DMHW0yKNnyCJujh90kR+0E7v/WKWAH+
wtsuUYsG5zwk27y03ff4qOmxJr4Umzog5sR+YE+IkffxKc7lFtF5as41HPQG
W8O+qCmDJ5B/8tLQXxu19pXhy4i/0SX0iBjgkoh/ub9Jm5og342Ob6l5lkbd
8+i4zwdvfiGepaTDI7TmKv3+eM55BfDR2vAJ8Ij7+eS7JgYPwVf77eP++5kX
RKw9UHP8rLt1YX99iJiI9eDDVeEjXg4/gS6/FPr8crS5gwH2eSJqCmD/+VH3
HSmdTtUY74MRRgROAMe9Efz5m+Rhm553yp07plYET8jb0ceeOFfwIViI2kh9
resf/P5ujOHcsdfYavbGXsCQxIGLInfBupwh+LYp7lmRN26J9r5aTIXvYLWE
rxtccUAuBgdP/ilblO5jOZsR45lnrfiwJuf7We8Rp1RaP/AtB0d+jHoTdTKw
OvN+L2SJOg/+AF8A3h4abfzDsKgB8dAPHhsv7Naj0XiSs70gznde3A2Gh9w3
3FHnOzKv9PB9eu4ZUg//XeTEGDsv7nxyFwPss+/OUvQzz8XxO3oxI2rl8OpT
fHLed+HJP9CPz22ucE0dnjRFm37y6ydVOgfDfB2xd868I9bCdmLLsGPci9zT
0zTvle4mOWOXQu17cLN1D1uDvSIfDv4F34Bt+J+Pr+L/PqaTy+9j3SEviy0i
/h6u+YblnBfsHzZ0X01Z479bbxnjDhGxEbE2eayftDuXRT3n8YIDdWHym2D+
t3t4Pdai/s//VHAHABlpDZ6Q4yG/Q56HeIFvwSHUYLhbT25nRx/rPPNgX/kW
fzm31fdFqPUsanXth/Z+m8IZcSdoaK3zLviffhUH+Nov9tgaMs6c0IG9pp5L
f1vQSR2FNuufXuV74fh/7hHfFnQypjnG47uJYcBWxBgtISf/D/p5lqY=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd8lGUSx99AQgJJzIa0TbJLQrLsLigKcqCHSpHmKdINvQiKXZTiiahY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         "],
         VertexColors->None], 
        PolygonBox[{{10636, 6655, 1783, 10675, 10635}, {10508, 10693, 10692, 
         10732, 1604}},
         VertexColors->None]}]}, 
     {RGBColor[0.6598591536835171, 0.6818722395398131, 0.9116881184455972], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgt0ldWVx7+EhDxvEpKQe0NySSDJzQWsVlFqYaYoKlSKq4I8lNEC1srD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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1OUZx18MSSBhN0CSzYbswkI2yQKKIqfYEUWByjEKCohVAVE5FQWV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         "],
         VertexColors->None], 
        PolygonBox[{{5024, 9905, 3613, 9630, 5023}, {9919, 5036, 5035, 9359, 
         3416}, {5973, 9355, 9354, 9363, 3417}, {9355, 5972, 3416, 9360, 
         9354}},
         VertexColors->None]}]}, 
     {RGBColor[0.6733445619255303, 0.7035395382299736, 0.91199554421789], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHmQlMUZxts92V122GN2dpY9mZmdXc5ERAEL0JgQCBitooxJJIIXIuqi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlwmY1GUdx192F/ZegZ2dndmZgWV2ZtnlsJDTYtFMg8DqiaeowBBIQFBA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         "],
         VertexColors->None], 
        PolygonBox[{{5074, 7368, 7367, 8080, 2534}, {9636, 9634, 1239, 6036, 
         9635}, {9364, 9366, 9365, 5972, 1166}, {9904, 9632, 9631, 9905, 
         3890}, {7368, 5073, 2533, 8077, 7367}, {9366, 10361, 4365, 9361, 
         9365}, {10035, 8887, 8886, 9676, 3630}, {8802, 5540, 2999, 8816, 
         8801}},
         VertexColors->None]}]}, 
     {RGBColor[0.6868299701675437, 0.7252068369201342, 0.9123029699901828], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmMldUZxg+jMwKzXGburMx65947DqVaGILahEXEBBtsqbI0ASsEMI2m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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl31s1eUVxx/6ckvb2xb6Bre9ve19q2W1G9bpNBEYgtEFE8aULYMpBLa5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         "],
         VertexColors->None], 
        PolygonBox[{{8079, 6067, 3513, 9494, 8078}, {5570, 10030, 4053, 10035,
          5569}, {6038, 9497, 3514, 9496, 6037}, {9641, 6179, 1407, 8817, 
         9640}, {9637, 6038, 6037, 9634, 3614}, {6199, 9679, 9678, 9674, 
         1417}, {6068, 8079, 8078, 9498, 3514}, {10033, 8903, 8902, 8887, 
         4053}},
         VertexColors->None]}]}, 
     {RGBColor[0.7003153784095568, 0.7468741356102947, 0.9126103957624756], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV2lsVFUUPmwtM12gnZZ22ulM30ynZREVgsagIlISiCYUCoiAKAIaRIQI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQ1WUZxx92Edxld0HZ09738NtzDrteRoPWdEpL2SYpZ+SSRmmmIhUp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         "],
         VertexColors->None], 
        PolygonBox[{{9684, 6198, 6197, 9682, 3632}, {6178, 9628, 2076, 7376, 
         6177}},
         VertexColors->None]}]}, 
     {RGBColor[0.71380078665157, 0.7685414343004552, 0.9129178215347684], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV2lsVFUYve0U6DKdLtPSaTudmdfOTIkCJmxFqSCgBYxBAvwALKACEUVb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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1lmlslGUQx4duKbRLC1hKlx67+/YCEgGjQlEQEJDDmKhgDCqH4YhFpZAg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         "],
         VertexColors->None], 
        PolygonBox[{{8164, 6562, 6561, 8162, 2561}, {8200, 9681, 3631, 6200, 
         8199}, {5544, 8805, 8804, 8835, 3000}, {5488, 8823, 3000, 8822, 
         5487}, {7375, 5111, 2561, 8163, 7374}, {8167, 9629, 3612, 6178, 
         8166}, {9627, 7375, 7374, 9628, 3612}, {10032, 5573, 3022, 10034, 
         10031}, {8905, 5230, 5229, 8899, 3022}, {9670, 8200, 8199, 6198, 
         3629}, {9677, 5572, 5571, 9680, 3631}, {9639, 8167, 8166, 6180, 
         3615}, {6562, 7414, 2099, 6069, 6561}, {5543, 9638, 3615, 9642, 
         5542}},
         VertexColors->None]}]}, 
     {RGBColor[0.7272861948935833, 0.7902087329906158, 0.9132252473070613], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlmlsVFUYhg8FWzpMS+10sGW6zJ1hakkETRQwLiEukWj8ARiVhE2gBdQg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtllts1FUQxqfbWrrt9rq7QNmy3f+WLRChPiBg1EgUhGh4QIyBRAGBIrdI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         "],
         VertexColors->None], 
        PolygonBox[{{7943, 6645, 6644, 7941, 2455}, {6645, 7207, 1976, 5874, 
         6644}, {8824, 6721, 698, 5544, 8823}, {7230, 6774, 6773, 5888, 
         1990}, {6461, 8906, 8905, 5573, 714}, {6774, 7956, 2459, 7955, 
         6773}},
         VertexColors->None]}]}, 
     {RGBColor[0.7407716031355964, 0.8118760316807763, 0.9135326730793542], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVltsVFUU3Z0xTqe9vVTutGGm9PbeaQdawZIo9GHiM5aiCYnSClHSGgo+
EhVUAhTUhMRHSDTVKgok2hCNiVUwVL/UD3wwjQYLxcRYagQUUEO0aVHUDyKu
xTofJ3fPPvus/Vpnn4n7NqxYnzCzb7GSWCV1ZkvyZjvTZs1Zs4cyZkNXmvVB
Xou1H/LpWrOzWAkcPID9S5ArITcHZv1YJ4AzUC6Mo5BvLpg9Df05yBeAkYKP
88CZB/0O6Kegj6rMDodmjwDni9jsc6wWYJwolZ8FsDk526w1kPwGbPsgd8FH
vtqsp8asOwUcYJ4D1iTO3AubLtg0wSbC91Gsz0x+xpyvP3G2aa7Zxzg7lBLG
Y7Bp8OQbW1aJWK7C+qhMMY1g7yiK5UeoF1Ya+lPI6W/gG+TjiPO6QGcfwO9x
4FRAHgbGe1j1wLgBm//BdzGlOr1UrrrtQlxXIP4uxLY5KZ81kP9FnZ/F3h2Q
XwHGq4ypXNgPlsnX1dAtwBrF7zX4bgf+y8RIypZnb4N+E/TPJIX3T0b6wflm
h6BvqUTMSfWZPX0X9u9AfxC66xFXe16xPo6z9yDH9rRq0VCumGlX7+QXfOXP
3N8Hzr5Ydm3AaK8SR+bPFSfIhz347sY6BvkM8E9jbQf+YfDr61rlOu1Jty2h
RZk9XQe8GZydwdnbcW45YgvTwqjIy24K+8sj2bQj75WQWxHfjKdYyNX7qxQT
4ymtFA9Y20lPcZEz/eDaVqwe9O5L5HQIqxXnN+fMboRxEvoV8PtjjTi1Ed9G
1HA15DS57/L9FDHMCdXfuxDLYvxeUqbad3iq/ynoVsGmDfLbvKDwcwvkZJ3u
KrkTNZgdAf55nOnG94l6swLkS4E4Sn4eA04HcBaxp9BtqFdfyPeHHefJd+ab
cNwjjwqQu2G/MKs5wPpNuzqPYH+ZJ74UyTusNsSXgN+xnDDH55j95u5jP/a3
xsrhIu7InYFsGvHdGKj+r+HcBOy/g30RZ793cqZO9WVtm6E7G6r/o8jrmlBx
Mo/VLpdVmAPPu9lSRJw9nnJifgWXI+dWSag6E+9Xh+nj7FNuXg0i3qFq3SHy
nH3uhc0f8Ls+VC/OJJU39bug3x/pTu7Afi9wOslhTza0nZXW/WPM30SaF+QY
79VFT3Ngwpcv+tw0D7HEOrsmqznIGbgM+lmx6j8Syo42L+Y0cxk/Z1WDwyF/
GQdtWOOBnGrLeflmTj36BTW5CTgrk8qBd4CxHWFtoP8L+g74XIo1gf3nAtWa
dW5xflgH1puzizX38pq/vKfkKO8w6/yhLwzWghw/mRHPE6FyY16L8+IHubEF
Mc6uEwd+Rpw/1YqznMFxQTwnJ3mOd6ro/LPOnAWf+JqH1xI/UB/IX943niFn
yUvyZyn8d2Lt9TXj2H/2mrFzXjCeffD7ekYzjjNyZ6z5N+5rBlJugq4xViy7
S4V3+f3K6f1j3cij3zPC73LzlPOT8U6VKeY+YKyN9ZuzbNrFwH6wlqwt4/zK
V6wlaeXOOuSAf2sg3QeQD4Tq0XFP53mW83U40owl37fFwmHPK/OyIzbfEerJ
aebHt4PvK2cTe0cfw758s77sMfv7Vkb/G3jviEXfnKWclwNV6inzZH7E2QL/
g9XCXZTVDOL84ZvWGcuWPL0QiavEm3SY9EdecdZxj3VnzTn/xjPS853jGebu
A68iFnf4Ni6MhXH5HUoKk/myr8yZXKJ/4nDG/1CtOc86HPQV833Q92LdnRJP
xyJxlf3l3WaPORdHs7p3TwaaO7yzxOCMJA7fAcbPGcW6jjpOszbrYtkkXJ7M
kbaUac/ZuTerO/4/EDpgpg==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlm1olmUUx88283Gvzu1+Hvbs5X5276WcmkZpbtELSjoLAnEZWLnYtBlZ
OTVwmkIQLaEwt1lamUgRuJrh9FP1wV6chHOmQWUWas2srMStly2U6PfnPB8O
nOs+13Xerv/5X3fUumbJU5lm9gYyAVkRmS0Lzer5eDnHbG212f0Js9o8sxqk
PTD7ptTsa2QN+liZ2bo4+5B/0OfzfVXKrA2Zhz6/2Oy3IrPeArOMbLMY35/h
2yVijU406yTWVqQR273EPEL891k3o8/NNXsYn98Tf2+MPJCN2Nuxz1PS2Fey
Ph94vm9nmV1JmlWzfyl7R/B/CXsluT2B/QL2LeTUxXo7shk9v8osD/kYd8+S
w5t8241cZn2GM0fxZ5Vm2Tm+bib3PORkgee8CH2E+g6ynsy6AV9fEv8avXqZ
/HYQfzzw2g4T/wfqfwX/Xyl/fC7jfAz5nPMNnP8XvVs5IuPoe4l/PuV7daYR
f6fwNwt9O/7eZf06/WhiXU28FyrMFl7POfztmoRP6szk/A58b8OeqjEbIr8R
8ruCNBHDkMPsr2NPEXufL/b6s+jhr6yH8fcj8gt6Fr1IgIk4kol+I7HryGGA
/GrJYSF6Y+j5nebbBeroLMEnMow+EalAypHrkFZiFSOnid+kHMn39nL8xTy+
atsduk019kSOGfVzCvVsYv1H4Hg4RD/2k1MT9U0qBIfEn8N9zEa+MO/BcvB0
F/bVaTzF8VWAj372luGjkL0zyWET+l/4u4/cxrnfD8kvzPbcJ5BfVrnX8Aln
L9KLfnp5a673JkCK0z2KaoFPrWNHGNIsTOPM0RyfiZ+4r4vIA8TKFP7JLcYd
fSt/1PAOPgrZf4j9y/P87uqr/C51h7obYUZY0R0NYH8NzJwC+2ewF9eZHUcG
kSIkr9LvUHeXW+m1aIY1u6pJs/ZImc+PZk61HOTe+1Ne02P0ugP7cmx7iPEf
+zeU+l3pzobweRzBlZ0Ffxn0NxNpo75C6luHj7cCr1Wc8jd7DwRuUw82VjmH
iDs60M8Rqyrhd6V8vks4J2i9BzlG73YGftcnJ/ksLogce5rJEwnHvLA+ivQQ
v5X+7Cf3RayfpG9dN3ivxQG/42tD5FwiTGk2uyPHmmb0ALX0h84l4ihxQW/k
sydOOMf5lshnU5x0kvXdrJ/L8pkQlloj51ZhaghfJ0LHmjhKs9gRObdpJjUb
n0XOhZqRwSrnYHHvMfROcVGJ40szu5n1QIlzhTi2AUz00eM24r1Y4FytHqu3
4uyWhHOGuGIB/RjDb1fks6QZy6h2DtDsW7Vj/T3sNbmOeXH9NXxdrXLOv4p9
AHs99kHsP1NbZY33XjOl2dSbordEM3pn0mtSLXegT+fsTaFziWZkKkB6NO5v
xQfcdwf1ZaX57CwpzSbfy0nn+jnsH0X/M+F7daYZrKyMu12Y1mxpRjQbmrE+
4u1M86dqOsq6L/3+qAblcnPo3K6c1hP/QuhvhThFXHdP6Nyg+9WsrUYeT8+c
fH0aOTfI55TIOUdco5kWN98WT78V+Jghbgg8ljAzQj2LK7021dBT5xwq7uyu
87f6wdC5W3gT1xanZ12cW4KtNPS3VzGVm3x0p3PMCJwTxAWGvoX6slPeO+Fn
FbmNk8MY0hb3uxYmhAXd+UDSfejsEfStnA9SzgfC4zbyfKnUfQmTervXhv7W
ab52JR0zwoo4ayl5zEw6t8zN8bdcHKDZ1/1Npj8fBV6LOGVq5BwpbtQbNI39
s9LnxVG3kM9ghXODOOlpfGXyrR39oZj/y+iNGk7/04jrhElhUZz3auAco/Oa
obni2Qrntun46CXffUi++Z4VSZ8pzZI4ZgbrhsBrUU6NzGNL0s/qjZ5AT/dF
/m8gDOZHzlHiJr1JeqvWl3muerMWE39J6NynGv4HgZZaAw==
         "],
         VertexColors->None], 
        PolygonBox[{{8278, 6781, 6780, 8277, 2615}, {6648, 8273, 2613, 8272, 
         6647}, {5672, 6270, 6269, 7028, 1883}, {6802, 8161, 2560, 5110, 
         6801}, {7209, 5479, 5478, 7208, 1977}, {8192, 6597, 6596, 5119, 
         2569}, {5521, 7229, 1989, 7228, 5520}, {6270, 5674, 1885, 7033, 
         6269}},
         VertexColors->None]}]}, 
     {RGBColor[0.7542570113776097, 0.8335433303709366, 0.913840098851647], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVm1MlWUYvvkQOXCEczgfeg7xcl4OcI5W1sKVxMxis6RWU0iWqLRoUT9a
gawPc7SJUf3JLU0z11pEf2rJFJ1/qh+lhjo1xH7hHLiMtiwkXSautq7L63H9
ePc+7/Pcz/1x3dd936/f8XLzS7lmNoUnD8+7ntnbeB4OmP1ZZrYyYrYW+8eK
zEqw9yjWPWmzH1NmFVjvDpotxX4jlHTh3ibffdeYFVbiHOvVkK+OmwVh4Anc
a8b3EugriJkNQb622OwA9NTjPQidE+VmaSdfVgXfoLcPesZxpyIgf/Zg70vc
bcb3zhKzC4Vmd2D/jwz8xjOB9XMhxAEdf+WYfQW79bVmK/IUWxS2PoDMRQTx
E84mC/VsKVJch6E7EpE/y7ERmm+2Kl92Jp2tj+BzBHr6sa6Ky2/63IC9kzgb
xn4WtuqBzasmXHf4st8NfZfh5xB0jgPnZbCBMG76V1cgn/dF8YZvn8Cnu3H3
dl854PmSAvnzPDBceJvZVXzHw2bzw9LJN79HofNKoXTQ59kE8lEj+RW+ckw8
R1PC4iYGyM+1lOSv4/xx4PCCySZt089p+LbRU94HsHEV9xpM7ytu/eYCxA9c
ShHTXbC7yK17gNNyrGuxXg9fNifN5sw1a8M6BM7sQYyfUX9a+WAeOlwuDuLb
AtLPOK4lFMsl+NkYET/z8xX7O/DtBvTs8pXvOqxXOe4RO/KDOO+A/U+BYyl8
uJ4QptQZhWwczwTuHsKd9qD0B4FNDnQVY28p+Hkq/r9Nvon5BcSxPSmdrBFy
hTzZBEwerBCWzwCH/pRw+B5cOIKnMyQdWwPSYzj/AT5NQv4R1qWvGhiDzXrY
DpOT8GWdJ56dg0+JkPLFuolXqXboY2W1dD8E3M6Af+fnQXdGtjtdrRAT8n8G
Oe3Gve9MvvQ5f3qg80xaeWed73ZxncT+ZfjWFZCd0w6TE1C2KyqcByFb4+ou
Br/8aumkbdplTpgnylGmFXaaEf+9iGljsXyiP6z5Wtcr1uA9VaJaW4Y6eD8m
Lg3BnyPwp539Ial8MBe0z/vU/zrOLaLa7Me7zHGvG3Zb4sKjtFK85H5rseKj
rRzI/IMYzmFvDOvRtLD4F3vnY9pfCB1r0uI8sexyeG5DrO+FVKe/A/vpjPam
4U9htWQOZ9RnmYstWfiXVU0Ts76scOtFXK0pxUtuskeTn68E1XfIAdYP46Ce
NmCy1tPZFDZ+qVA/I35Pu7iOQ/7FoHoCe/BMQj2Ntd7j6r3O9R7mlDExB7zL
XsjeRj7sh+w+T3pHEFc4pv6+F+s5MeWB2Lc4/JnnlrRyPZczJyI95DLjYSx/
Q8Y89Ze463OsccZDGfL/bEr9i70rF7mrj0mG/Op03G7yVEusow5fPY76af++
qHzYmhXuxJw1+lq56pSxs0ezB97jqS+zJyfxXuCpN42jtp4CZy7Ok0+f5ynG
dZg/m319r8R7LKqZxr7IXkmeMP/hKnGgDL6f8DVPPvY088jdN5Lqm8z7rTqk
/iAwa4+I292e5jHP7o8JC+KQi70cT326DLq/iaqnsk4aXB4vYd+Pie+nIXvK
E3/ZY9a7PjON8/muN6aw/s0XDx7DesT1K87AVqeT/X6Dw5C9hPXMGNl3o+Wq
zTuhYyQqHi/GfqhKcqzFvSnxmNwkZuTnW1nNUfJgJ+7ORsXBmYzqijVFvj/r
iyPJcvlH3279c7CHfBhVnyKfZ4Hfz8hTW6nZk3H1AtotqtQ/Df9nvoZ8KXQO
F6nf9Lr59S32Y75mBXlwyNVjU1AYc2axHtpdrQWgszcineTQcRcX9XKmUn6g
SPe5/sJXjplfcpe9nrzlv8nRjGryaEIzgzHSh2Fn90Bac4K5478A/5lYI+xD
YVdHxJHfXD9QoVnFObXBE3fJ29UpzUjOx2HoPJhW7YXd3Qn3vzHg7J6FzSZf
vh7DerGvOPdjfSMluUW+5jex4nzmPyJndAq18Kun+UPbje4/aruvHsH+wJ5C
PAddLNucD/8BtYpl6g==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlX1olXUUx8/cnLqtvd3nTre61/vc6bZbahQrvEZOjMUWCLXUMHLRhBLS
chPzJYK01vqjDJyavVCYERQ5dZP+Kf8ItVlO2zTIFGmR017IDZeZ/pF9vpzn
jy/PeZ7f+Z3zPa9P2PZ8y3MTzOxlkAdOJM2OgzVTzNrB5Vqzv8DPnG0tNbs/
YTYf1OebFfOtC90bgVlQaPYg+qXTzc5ONbtwi9m7vF8PXEdnMXQ6qs0WV/Ce
a7a5gGdo1giWYSuBTj/6d6FfjHyM80Po/sn5Uu4OFJkdgcthAAV7Gj6fcfYp
2M57C3eGsH8K7EJ3IYEdRfebWtd9WAFi+wA+dmP7ymSzvSmzt3m/muOcXoqZ
LZhpdh7+u7C3Nm62KW22EXQgZ3nO49mF7TLsjeL7MvjaPGcb4NvE+1nsr4JD
iO5AlE/FsA+5nG/3Ibfy7Qf8nwazuD8Mnxa4PwKK4FKPjQeqzFaS02fAQuR7
4DpaiU9Qj7waf7NDz1Ur/i5hfwRswfYrYAXn5Zwf5LyZ81FyMVbrteyB/yls
NCU99+J8k8Tu59sHUX4UuzjIt3Iwht9FKecmjr+i/1HgtRT/HOSj6AzTH4V8
m0is7yW9NjOJuQIbcTBozvFD+O0IvTfegd8SYl8K7uVuSa7fzcdGTaHb6CMP
DdifD3qRX1T+A6/1x+i/Bc83wRtgK9hUY3Yy6b08RsP+e6vXVLW8hrwNnevU
/PES/E0ymxN6DVW7b+GQRW8ufPPyvObD2Ouucl3diYdeA+X+C/SHppn9zp3f
wCByV8y/SX4N+Qm4LE861yz2FpPLOys9VsU8CdtJkAD5yjt3qtA3+D/EYyf+
PsHfniKfue0ZvyPdbuQZnD1FXDW5Xp918D3A/Se5f5H4l3OWrvAz6VzFfwM6
O4q95lvq6BswtcxrtCrjPmT7WdAP1ykpr61qPILfLsUGLiCfqfJvkn8E34U+
w5pd9fyJjNuUrQHwqHIPvzr4vYC/BfRTQ8JnVTtmJOE9pt76BfwRekyKZQn2
StNeY9W2g/c27L0f9dse7J3Ed2qGz4Jq2Mr569E+0s7oJNZX63wWFHN74DGI
+xrkEvw1YX839nsLXJ7A/fHJ/i0n6TOjWdG3GymfOc2adkwd8tqoHqqxcn0x
4bEo55s576Xf16FfyUwug187NufCrxN+/2DvWsrta0c8xm7qjPlu1Y5dhNwc
ze9K897YG/qsqUeOIB8OPRfaN9rtqbjnTjupLO47SWdZvgUZr5FqEwMruNsW
um3VaIjdXjDdd6N25EG491V7LyuGgbTnULk7nvZdfizwWdJO3we//tB99RX5
LOuOdDXTd3B2e+i9Lv1u5G2h50I1K0OvPO27QztXu+s09s8VeA6m8f5l4LXS
zGzUPIfeW8qpduOcuPeKbEy8zXeCdkEe8lfcrYzmTTtTvR1EuVCP94Qeg7hr
J82G8zzuZMEs5J08P6dejbn+T2miPndH/zP9425ydwO9tR78h7wev5kK7w31
iHwfCnyXiMN+3nui+miGf4r7jtNuO4M8js+/uT8OriA3h95T6iXlRLtEMSo2
7ZTBat+52rX6R34P18GUz5f+qf8DwWgitA==
         "],
         VertexColors->None], 
        PolygonBox[{{6776, 7951, 2458, 7954, 6775}, {8040, 8957, 3035, 8956, 
         8039}, {5609, 6938, 1760, 6598, 5608}, {9560, 4999, 4998, 9559, 
         3556}, {6797, 9537, 3549, 9536, 6796}, {5876, 6649, 1779, 7209, 
         5875}, {5178, 6778, 1797, 8278, 5177}, {6932, 5593, 5592, 6805, 
         1807}, {7944, 6643, 6642, 7945, 2456}, {5597, 8170, 8169, 8961, 
         3035}, {8170, 9952, 3930, 9955, 8169}, {6646, 5173, 5172, 8273, 
         1779}, {6779, 5887, 5886, 7229, 1797}, {6639, 5171, 2612, 8269, 
         6638}, {8983, 8115, 8114, 8980, 3039}, {8196, 5614, 3039, 8982, 
         8195}, {8201, 8196, 8195, 8204, 2571}, {5175, 6445, 6444, 8276, 
         2614}},
         VertexColors->None]}]}, 
     {RGBColor[0.7672214017359269, 0.8485287766633459, 0.9119745041359135], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVmtslFUQHWi33bbbdtvu1hbosh9tadFgQBFICQ8BA2LQWKGtCiqPqEhA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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsVGUUho90m5lS6HRmSqeFaW93NBoSDRAMSwATFVcoi1JEEAURUVqW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         "],
         VertexColors->None], 
        PolygonBox[{{8271, 5698, 3079, 9042, 8270}, {5537, 6931, 1840, 6932, 
         5536}, {6937, 5452, 5451, 6938, 1844}, {6108, 7953, 7952, 9562, 
         3557}, {5700, 8275, 8274, 9046, 3081}, {8275, 5699, 3080, 9043, 
         8274}, {7947, 6099, 3550, 9538, 7946}, {5696, 8271, 8270, 9040, 
         3078}, {6107, 6354, 1636, 9560, 6106}, {6800, 6098, 6097, 9537, 
         1806}},
         VertexColors->None]}]}, 
     {RGBColor[0.7793322136063064, 0.8525674097181074, 0.9065488712708772], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVVloU1EQndbG2kitMWnSmKZ50aYJWn9FwYpaBcWlaFwQ1Na4gFslAWs/
/PCjIoiCVkUEcUPwSwUFQS21ih8quNUFXCouYBUrglgXUPAcz/0Y3nv3zp05
c+bcecnc1kWtxWZ2EjYE1lNklq8w24Pn6gBslNmFErNPNWYfYR1lZtcyZldh
Ldjvj5v1embvhpltSZi9qDR7hoAffGYlQ826Eed61Owz1l8WK14O1oWYwRFm
WTwXwh4i9gNYAfGzKbPFsHflZknEn42z+3A2hDjHYmadiJtFzplhswxAbwXe
NYjZWqE9nhuH/GH4ezh/EGs/Ec8fQm3AMwnPxWO13pM2C0SEIesw0YcY1zic
bchzDv4dyPUxrppZb2dKcen/EjECqH888hbwfrdWvC0HznHV4KtU3AxWiZ9Z
4G8mrG+keM7BHoH/w4h3ICUcxEC+piL+0oTiMia5vJwQn37Evx3V+yXwdxHW
Ag6HY78X/hmfeMm5OCXYHwL7DvyhIGqEnUHeKHh9UCWed+N9luM2B+y78P2k
SBxsD4uHlcC4CtZfLh00O/w5+M6ATxo+t0q1X+8TlznXozx8nkfUI2L57QnP
8Zh6xr7MB8fr4tIP+TjoOGn3qU9/kKsB3G3HdwjfP+vMfsEKiD8ZmHOe8h9F
f2+k5Us+9o8WJ1/Boc8Tb0HkPYXvK06f7Dl5vlmkXOzvDpx9XOt0m4S+4TcF
GOZXSqPkrQn8TAxJg41haZQc8t6ExujutPmEmfh7a9VX5sqj7gHEnIv1QZxt
TEkz1AX1QZ8Y4yB3cZk01ezJJ4Gc/rjuLLlv8sQ/9fgqIk0+g9aehMUVMewd
ofdv6Hkkrtq78X4ePg9x9i24/JyQVom33WEmH3znfVnviWvyvDEmrVAnv7D+
BrVMMOVhPkC3R1i/ABxzUM/sgJ5cJ95pTjPkn/VSq9U1qpn1Tsf+pph8tuHZ
HFIuzhn2iT1KQsutsJuIeTspfVPbh0arHtbCmdEWU1+qsb8Bdgk+w9LSEPVz
FnxsrhMP1CtnIrktQ482Vmmu7USMtZ60/b5cfaCeVwBXKWLdh//jiO4h9caZ
WnBzlZipa3z+11FDUFrKu1xv3BxmbvLAc9xjTOZfEBeGI6hrmaf4P4B3sE6z
8L6b4YzDPkwKqhfUSE1IGNhn1skag2PEHXnjPWUM6nwgKY7ID+fKnaRmC/N0
ZuRHa3V1cTYUopoP1AzvHHXCuf4lqdmehuafOh1S741BaT7r7hs11u7uCM9y
Nh9K6X01ar0XlZ6p2dPuztK3zc2B5fD9G5Ymq+P6Z/A+nqjUPaf/gYzuc5fL
yX6wF0txdklK/eRc5hyqd/8x+lBjqzzNL/aaGmxxs7EvIk3Qn/XxvhEP79Br
90/srdJ/gvg5e/xu/syr1PzlDPkH8ZQOBQ==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtszFEUxr/WMK2klBlt52E6VWNmPLbSiCaatgnxCloioqpEomKa1mPD
kniEhFIiEUKsdVEWSrxiURKlj0iobirxSNgIgsTjd3Jm8SX3/7/3nPud73zn
VrV1rM8VSmoGAdCfke6AbTOkVvC2XNqckp4EpQWTpQ9R6USFdBy8Z70zKe1K
+v5C9p/Nle4R30ZsLwkTYenHPKljunSyQBqcI+3jXxd4nl+/Ic/rqP/7UiV9
Bn1w6SqWLmSlYvaKQA/r5GxpvNzvOjdFGohIq2ZJpyliDCxn/SDia/t3Du7d
oJO7Q9OkLawb4Tde6jnCcAiBx9x3hPteUNdwhddq8Tc5O0R9K6hnObhdKdWR
fxm4VenckqAyz7GNs9uTHm+anOHfVTjdIVeGf41l0pWYc89MkjZxdjPoD/r+
ZfbqOJNmr5szNSHpIzVPFEmL4Pia2uOzfW8+55+i1QC4wV4r/H+R62fSz34j
5lFaegjW0YvaUu9dGTrOynoPm6ql+jLnYpwOwPUwehwC+1mHyR0CS8lXSP7h
pGtiWhgny/UCDOZzdqFLJ1hpepIzUu2amVYV1Z67EU0aon7HGmpZDe7TnwD3
19OfkXLXwjQ5z3dPyntnNZhXzIPv854xr2XRaEjuuetwvhj1eNP8d8xrslp+
sX4Ot9V5v1iPdhB7Hx1eTnINR/Dv8Fz37r2A9zYYl6bEvcdL8HKa/TB7p+A0
inaX0q6t/euFz9hMfC/3jM3Sp4R7y2bqGnefJ8+rQufXji7/0OEv2M16N3z6
Et5Lm4FWOLfF3A+jaFTLfiDhvbWemBdtpmyWzJPL4LO22v1hMU1otz7lXpko
kfaQqz3muWz/J/VUhn02u5jRZs5+L3Pt33H+O9p8rXCuxnkxZzekPJfdkcv6
jNps7gVHyX0s5n6yO0wL08y0Mk2mEl8c8V7bTB60/uT5WEwQLYvSzmWwwHt7
N+NvkfXYvGOamVbmoW72zma8V/bGWK0bU87das4R/zLhb4nNuPXSPGFesJ42
EFsTdu/bm/CH2rcS/6HE57ee+HjCvW+e3ob/W5Ke2zRqSfmbYm+Jxdgs5PJa
2Ez8B17txKc=
         "],
         VertexColors->None], 
        PolygonBox[{{8959, 8045, 726, 5598, 8958}, {8118, 8985, 8984, 5615, 
         731}},
         VertexColors->None]}]}, 
     {RGBColor[0.791443025476686, 0.856606042772869, 0.9011232384058409], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{8117, 8985, 2544}, {5182, 8288, 2618}, {7046, 5677, 
         1888}, {8280, 5179, 2616}, {8293, 5186, 2620}, {5061, 8953, 2518}, {
         7452, 6105, 2121}, {7070, 5701, 1901}, {8045, 8959, 2518}, {8281, 
         8279, 2616}, {7454, 7455, 2122}, {8289, 8290, 2619}, {6109, 7456, 
         2122}, {8286, 8287, 2618}, {7453, 7451, 2121}, {8977, 5090, 2544}, {
         5671, 7020, 1881}, {5697, 7068, 1900}, {8959, 8042, 2518}, {7018, 
         7019, 1881}, {7047, 7045, 1888}, {5184, 8291, 2619}, {8043, 5061, 
         2518}, {5090, 8119, 2544}, {8985, 8118, 2544}, {8294, 8292, 2620}},
         VertexColors->None], 
        PolygonBox[{{7067, 5671, 1881, 1900}, {5677, 7069, 1901, 1888}, {6689,
          7176, 7175, 6688}, {7045, 7266, 2018, 1888}, {6387, 7448, 7447, 
         6386}, {7176, 7163, 7162, 7175}, {5449, 6592, 6591, 5448}, {8911, 
         5236, 5235, 8910}, {6282, 10519, 10518, 6281}, {5595, 6390, 6389, 
         5594}, {7458, 5449, 5448, 7457}, {6592, 5612, 5611, 6591}, {7020, 
         5932, 2018, 1881}, {5494, 8829, 8828, 5493}, {7266, 7018, 1881, 
         2018}, {10607, 10647, 10646, 10606}, {10519, 10704, 10703, 10518}, {
         7163, 5494, 5493, 7162}, {7448, 5539, 5538, 7447}, {5932, 7046, 1888,
          2018}, {5539, 6808, 6807, 5538}, {5236, 6875, 6874, 5235}, {6666, 
         6689, 6688, 6665}, {5454, 7458, 7457, 5453}, {7019, 5697, 1900, 
         1881}, {10647, 6666, 6665, 10646}, {6875, 6888, 6887, 6874}, {6466, 
         8911, 8910, 6465}, {8829, 6726, 6725, 8828}, {6888, 6282, 6281, 
         6887}, {10704, 10607, 10606, 10703}, {6606, 5454, 5453, 6605}, {6390,
          6387, 6386, 6389}, {5701, 7047, 1888, 1901}},
         VertexColors->None], 
        PolygonBox[{{8953, 5595, 5594, 8045, 2518}, {7069, 6423, 6422, 7070, 
         1901}, {7455, 7041, 7040, 6109, 2122}, {5186, 7226, 7225, 8294, 
         2620}, {7041, 8293, 2620, 8292, 7040}, {7226, 5184, 2619, 8290, 
         7225}, {7026, 7453, 2121, 6105, 7025}, {6423, 7454, 2122, 7456, 
         6422}, {6808, 8280, 2616, 8279, 6807}, {7211, 5182, 2618, 8287, 
         7210}, {6421, 7067, 1900, 7068, 6420}, {8119, 6466, 6465, 8117, 
         2544}, {7451, 6421, 6420, 7452, 2121}, {6726, 8043, 2518, 8042, 
         6725}, {8291, 6606, 6605, 8289, 2619}, {5179, 7211, 7210, 8281, 
         2616}, {8288, 7026, 7025, 8286, 2618}, {5612, 8977, 2544, 8118, 
         5611}},
         VertexColors->None]}]}, 
     {RGBColor[0.8035538373470655, 0.8606446758276305, 0.8956976055408044], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{8284, 6806, 1808}, {6601, 8296, 1761}, {7509, 7042, 
         1887}, {6809, 8284, 1808}, {5671, 7067, 782}, {7989, 7037, 1146}, {
         5454, 6606, 1761}, {5932, 7020, 1146}, {6606, 8291, 1761}, {7046, 
         5932, 1146}, {7280, 7022, 1882}, {7069, 5677, 784}, {6421, 7451, 
         782}, {7450, 6809, 1808}, {6423, 7069, 784}, {7453, 7026, 1882}, {
         7504, 7039, 1887}, {5675, 7507, 784}, {7022, 7289, 1882}, {7015, 
         7989, 1146}, {7021, 7280, 1882}, {7454, 6423, 784}, {7042, 7504, 
         1887}, {7067, 6421, 782}, {7026, 8288, 1882}, {7288, 5669, 782}, {
         6808, 5539, 1808}, {7041, 7455, 1887}, {8296, 6602, 1761}, {8280, 
         6808, 1808}, {6602, 7460, 1761}, {8293, 7041, 1887}},
         VertexColors->None], 
        PolygonBox[{{7289, 7288, 782, 1882}, {10705, 10608, 10607, 10704}, {
         8978, 5091, 5090, 8977}, {7507, 7509, 1887, 784}, {5669, 7015, 1146, 
         782}, {7037, 5675, 784, 1146}, {7451, 7453, 1882, 782}, {5450, 6593, 
         6592, 5449}, {6876, 6889, 6888, 6875}, {10608, 10648, 10647, 
         10607}, {6388, 7449, 7448, 6387}, {5677, 7046, 1146, 784}, {6467, 
         8912, 8911, 6466}, {7455, 7454, 784, 1887}, {5237, 6876, 6875, 
         5236}, {7164, 5495, 5494, 7163}, {5613, 8978, 8977, 5612}, {6727, 
         8044, 8043, 6726}, {8120, 6467, 6466, 8119}, {10520, 10705, 10704, 
         10519}, {5180, 7212, 7211, 5179}, {5062, 8954, 8953, 5061}, {5187, 
         7227, 7226, 5186}, {6667, 6690, 6689, 6666}, {6593, 5613, 5612, 
         6592}, {6889, 6283, 6282, 6888}, {5091, 8120, 8119, 5090}, {8830, 
         6727, 6726, 8829}, {8954, 5596, 5595, 8953}, {5596, 6391, 6390, 
         5595}, {7020, 5671, 782, 1146}, {7212, 5183, 5182, 7211}, {8044, 
         5062, 5061, 8043}, {6283, 10520, 10519, 6282}, {6391, 6388, 6387, 
         6390}, {7459, 5450, 5449, 7458}, {10648, 6667, 6666, 10647}, {5495, 
         8830, 8829, 5494}, {6690, 7177, 7176, 6689}, {8912, 5237, 5236, 
         8911}, {7227, 5185, 5184, 7226}, {7177, 7164, 7163, 7176}},
         VertexColors->None], 
        PolygonBox[{{7449, 7450, 1808, 5539, 7448}, {7039, 5187, 5186, 8293, 
         1887}, {5183, 7021, 1882, 8288, 5182}, {7460, 7459, 7458, 5454, 
         1761}, {5185, 6601, 1761, 8291, 5184}, {6806, 5180, 5179, 8280, 
         1808}},
         VertexColors->None]}]}, 
     {RGBColor[0.8156646492174452, 0.864683308882392, 0.890271972675768], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{5946, 7290, 2023}, {7288, 7289, 2023}, {7503, 7300, 
         428}, {6388, 6391, 1661}, {8044, 6727, 1784}, {7276, 7278, 427}, {
         7508, 6186, 2152}, {7450, 7449, 2120}, {8978, 5613, 3038}, {5181, 
         7276, 427}, {6601, 5185, 428}, {7300, 5188, 428}, {7212, 5180, 
         427}, {6593, 5450, 1759}, {6889, 6876, 1825}, {9567, 6588, 1759}, {
         5180, 6806, 427}, {7459, 7460, 2123}, {6448, 8103, 1695}, {7227, 
         5187, 428}, {9543, 6392, 1661}, {5058, 9543, 1661}, {5183, 7212, 
         427}, {5185, 7227, 428}, {7021, 5183, 427}, {5187, 7039, 428}, {6728,
          7142, 1784}, {7509, 7507, 2152}, {8103, 6451, 1695}, {6467, 8120, 
         1695}, {7142, 6718, 1784}, {8830, 5495, 1784}, {6727, 8830, 1784}, {
         8912, 6467, 1695}, {5237, 8912, 1695}, {7164, 7177, 1954}, {6594, 
         9567, 1759}, {5596, 8954, 3034}},
         VertexColors->None], 
        PolygonBox[{{10609, 10649, 10648, 10608}, {8297, 6603, 6602, 8296}, {
         8950, 5058, 1661, 3034}, {10706, 10609, 10608, 10705}, {6668, 6691, 
         6690, 6667}, {7043, 7505, 7504, 7042}, {6810, 8285, 8284, 6809}, {
         10521, 10706, 10705, 10520}, {6111, 6594, 1759, 2123}, {10549, 6728, 
         1784, 1954}, {7016, 7990, 7989, 7015}, {7449, 6388, 1661, 2120}, {
         7990, 7038, 7037, 7989}, {6588, 8974, 3038, 1759}, {6392, 6103, 2120,
          1661}, {10649, 6668, 6667, 10648}, {6876, 5237, 1695, 1825}, {5495, 
         7164, 1954, 1784}, {5670, 7016, 7015, 5669}, {6391, 5596, 3034, 
         1661}, {7038, 5676, 5675, 7037}, {6284, 10521, 10520, 6283}, {5450, 
         7459, 2123, 1759}, {5613, 6593, 1759, 3038}, {6451, 10535, 1825, 
         1695}, {7281, 7023, 7022, 7280}},
         VertexColors->None], 
        PolygonBox[{{7290, 5670, 5669, 7288, 2023}, {5676, 7508, 2152, 7507, 
         5675}, {7505, 7503, 428, 7039, 7504}, {6186, 7043, 7042, 7509, 
         2152}, {6603, 6111, 2123, 7460, 6602}, {6103, 6810, 6809, 7450, 
         2120}, {6691, 10549, 1954, 7177, 6690}, {8974, 5092, 5091, 8978, 
         3038}, {5063, 8950, 3034, 8954, 5062}, {5188, 8297, 8296, 6601, 
         428}, {5092, 6448, 1695, 8120, 5091}, {7278, 7281, 7280, 7021, 
         427}, {6718, 5063, 5062, 8044, 1784}, {10535, 6284, 6283, 6889, 
         1825}, {8285, 5181, 427, 6806, 8284}, {7023, 5946, 2023, 7289, 
         7022}},
         VertexColors->None]}]}, 
     {RGBColor[0.8277754610878247, 0.8687219419371536, 0.8848463398107317], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{7017, 7994, 1880}, {7034, 7997, 1886}, {7279, 5943, 
         2021}, {7281, 7278, 2021}, {8282, 8283, 2617}, {8298, 8295, 2621}, {
         5181, 8285, 2617}, {6185, 7506, 2151}, {5670, 7290, 1880}, {7503, 
         7505, 2151}, {7994, 7013, 1880}, {7997, 7036, 1886}, {8297, 5188, 
         2621}, {7508, 5676, 1886}, {5676, 7038, 1886}, {7016, 5670, 1880}},
         VertexColors->None], 
        PolygonBox[{{10550, 6729, 6728, 10549}, {7143, 6719, 6718, 7142}, {
         8951, 5059, 5058, 8950}, {6595, 9568, 9567, 6594}, {10610, 10650, 
         10649, 10609}, {6729, 7143, 7142, 6728}, {6285, 10522, 10521, 
         6284}, {8975, 5093, 5092, 8974}, {6692, 10550, 10549, 6691}, {6604, 
         6112, 6111, 6603}, {6452, 10536, 10535, 6451}, {7038, 7990, 2485, 
         1886}, {9544, 6393, 6392, 9543}, {7024, 5947, 5946, 7023}, {5028, 
         7034, 1886, 2485}, {6393, 6104, 6103, 6392}, {8104, 6452, 6451, 
         8103}, {6589, 8975, 8974, 6588}, {5059, 9544, 9543, 5058}, {6719, 
         5064, 5063, 6718}, {7990, 7016, 1880, 2485}, {6187, 7044, 7043, 
         6186}, {10536, 6285, 6284, 10535}, {6449, 8104, 8103, 6448}, {10650, 
         6669, 6668, 10649}, {5093, 6449, 6448, 5092}, {5064, 8951, 8950, 
         5063}, {9568, 6589, 6588, 9567}, {6112, 6595, 6594, 6111}, {7013, 
         5028, 2485, 1880}, {6104, 6811, 6810, 6103}, {6669, 6692, 6691, 
         6668}, {10707, 10610, 10609, 10706}, {10522, 10707, 10706, 10521}},
         VertexColors->None], 
        PolygonBox[{{7277, 7279, 2021, 7278, 7276}, {7044, 6185, 2151, 7505, 
         7043}, {6811, 8282, 2617, 8285, 6810}, {7506, 7301, 7300, 7503, 
         2151}, {5947, 7017, 1880, 7290, 5946}, {8283, 7277, 7276, 5181, 
         2617}, {8295, 6604, 6603, 8297, 2621}, {7301, 8298, 2621, 5188, 
         7300}, {7036, 6187, 6186, 7508, 1886}, {5943, 7024, 7023, 7281, 
         2021}},
         VertexColors->None]}]}, 
     {RGBColor[0.8398862729582044, 0.8727605749919152, 0.8794207069456952], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{8282, 6811, 1321}, {5953, 9578, 2025}, {6604, 8295, 
         1325}, {5947, 7024, 1148}, {8298, 7301, 2025}, {6595, 6112, 1325}, {
         6113, 8126, 1325}, {6104, 6393, 1321}, {7269, 7991, 1148}, {7297, 
         6188, 1409}, {6187, 7036, 1409}, {5935, 7286, 2020}, {6185, 7044, 
         1409}, {7024, 5943, 1148}, {7017, 5947, 1148}, {9549, 5935, 2020}, {
         7277, 8283, 2020}, {7996, 7297, 1409}, {7044, 6187, 1409}, {6112, 
         6604, 1325}, {7279, 7277, 2020}, {6100, 8047, 1321}, {8126, 6110, 
         1325}, {7301, 7506, 2025}, {8047, 6101, 1321}, {6811, 6104, 1321}, {
         5944, 7269, 1148}, {7513, 5953, 2025}},
         VertexColors->None], 
        PolygonBox[{{8952, 5060, 5059, 8951}, {6101, 9549, 2020, 1321}, {5065,
          8952, 8951, 5064}, {5943, 7279, 2020, 1148}, {9569, 6590, 6589, 
         9568}, {7506, 6185, 1409, 2025}, {5029, 7035, 7034, 5028}, {8295, 
         8298, 2025, 1325}, {7995, 7014, 7013, 7994}, {5094, 6450, 6449, 
         5093}, {8105, 6453, 6452, 8104}, {8976, 5094, 5093, 8975}, {8283, 
         8282, 1321, 2020}, {6188, 7513, 2025, 1409}, {6286, 10523, 10522, 
         6285}, {10651, 6670, 6669, 10650}, {7035, 7998, 7997, 7034}, {10708, 
         10611, 10610, 10707}, {9578, 6113, 1325, 2025}, {6453, 10537, 10536, 
         6452}, {10551, 6730, 6729, 10550}, {7014, 5029, 5028, 7013}, {10611, 
         10651, 10650, 10610}, {7144, 6720, 6719, 7143}, {6450, 8105, 8104, 
         6449}, {6590, 8976, 8975, 6589}, {6720, 5065, 5064, 6719}, {7286, 
         5944, 1148, 2020}, {6730, 7144, 7143, 6729}, {10537, 6286, 6285, 
         10536}, {6670, 6693, 6692, 6669}, {6693, 10551, 10550, 6692}, {10523,
          10708, 10707, 10522}, {5060, 9545, 9544, 5059}},
         VertexColors->None], 
        PolygonBox[{{7991, 7995, 7994, 7017, 1148}, {7998, 7996, 1409, 7036, 
         7997}, {6110, 9569, 9568, 6595, 1325}, {9545, 6100, 1321, 6393, 
         9544}},
         VertexColors->None]}]}, 
     {RGBColor[0.8519970848285839, 0.8767992080466767, 0.8739950740806588], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{5095, 10569, 343}, {5029, 7014, 278}, {5060, 8952, 
         323}, {8976, 6590, 343}, {6450, 5094, 343}, {7035, 5029, 278}, {9569,
          6110, 3560}, {7267, 6433, 278}, {10569, 5084, 343}, {10559, 5066, 
         323}, {8952, 5065, 323}, {7136, 10559, 323}, {5065, 6720, 323}, {
         7995, 7991, 2486}, {6100, 9545, 3551}, {5094, 8976, 343}, {6433, 
         7291, 278}, {7996, 7998, 2487}},
         VertexColors->None], 
        PolygonBox[{{6102, 9550, 9549, 6101}, {10552, 6731, 6730, 10551}, {
         10709, 10612, 10611, 10708}, {5936, 7287, 7286, 5935}, {10538, 6287, 
         6286, 10537}, {5954, 9579, 9578, 5953}, {6731, 7145, 7144, 6730}, {
         9579, 6114, 6113, 9578}, {6590, 9569, 3560, 343}, {7298, 6189, 6188, 
         7297}, {7992, 7267, 278, 2486}, {9550, 5936, 5935, 9549}, {10524, 
         10709, 10708, 10523}, {7291, 7999, 2487, 278}, {7287, 5945, 5944, 
         7286}, {6114, 8127, 8126, 6113}, {9570, 5095, 343, 3560}, {6671, 
         6694, 6693, 6670}, {7514, 5954, 5953, 7513}, {6287, 10524, 10523, 
         6286}, {6454, 10538, 10537, 6453}, {5066, 9540, 3551, 323}, {7998, 
         7035, 278, 2487}, {8106, 6454, 6453, 8105}, {10612, 10652, 10651, 
         10611}, {6694, 10552, 10551, 6693}, {6189, 7514, 7513, 6188}, {8048, 
         6102, 6101, 8047}, {10652, 6671, 6670, 10651}, {9545, 5060, 323, 
         3551}, {7014, 7995, 2486, 278}, {5945, 7270, 7269, 5944}},
         VertexColors->None], 
        PolygonBox[{{7145, 7136, 323, 6720, 7144}, {9540, 8048, 8047, 6100, 
         3551}, {7999, 7298, 7297, 7996, 2487}, {5084, 8106, 8105, 6450, 
         343}, {7270, 7992, 2486, 7991, 7269}, {8127, 9570, 3560, 6110, 
         8126}},
         VertexColors->None]}]}, 
     {RGBColor[0.8641078966989635, 0.8808378411014383, 0.8685694412156224], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{9551, 9546, 3552}, {7515, 7510, 2153}, {9573, 9576, 
         3561}, {9550, 6102, 3552}, {5945, 7287, 2022}, {7282, 7285, 2022}, {
         7514, 6189, 2153}, {6114, 9579, 3561}},
         VertexColors->None], 
        PolygonBox[{{5067, 9541, 9540, 5066}, {8107, 6455, 6454, 8106}, {7993,
          7268, 7267, 7992}, {7292, 8000, 7999, 7291}, {10653, 6672, 6671, 
         10652}, {10539, 6288, 6287, 10538}, {7271, 7993, 7992, 7270}, {10710,
          10613, 10612, 10709}, {8000, 7299, 7298, 7999}, {10570, 5085, 5084, 
         10569}, {9541, 8049, 8048, 9540}, {6455, 10539, 10538, 6454}, {6288, 
         10525, 10524, 6287}, {10553, 6732, 6731, 10552}, {5085, 8107, 8106, 
         5084}, {9571, 5096, 5095, 9570}, {8128, 9571, 9570, 8127}, {7146, 
         7137, 7136, 7145}, {10560, 5067, 5066, 10559}, {10525, 10710, 10709, 
         10524}, {6672, 6695, 6694, 6671}, {7137, 10560, 10559, 7136}, {7268, 
         6434, 6433, 7267}, {5096, 10570, 10569, 5095}, {10613, 10653, 10652, 
         10612}, {6434, 7292, 7291, 6433}, {6695, 10553, 10552, 6694}, {6732, 
         7146, 7145, 6731}},
         VertexColors->None], 
        PolygonBox[{{9546, 5937, 5936, 9550, 3552}, {7299, 7515, 2153, 6189, 
         7298}, {8049, 9551, 3552, 6102, 8048}, {5955, 9573, 3561, 9579, 
         5954}, {7285, 7271, 7270, 5945, 2022}, {7510, 5955, 5954, 7514, 
         2153}, {9576, 8128, 8127, 6114, 3561}, {5937, 7282, 2022, 7287, 
         5936}},
         VertexColors->None]}]}, 
     {RGBColor[0.8762187085693431, 0.8848764741561997, 0.863143808350586], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{8000, 7292, 2024}, {5933, 7272, 2019}, {7268, 7993, 
         2019}, {7299, 8000, 2024}, {7271, 7285, 2019}, {7293, 5948, 2024}, {
         7993, 7271, 2019}, {7515, 7299, 2024}},
         VertexColors->None], 
        PolygonBox[{{10711, 10614, 10613, 10710}, {7147, 7138, 7137, 7146}, {
         10554, 6733, 6732, 10553}, {10561, 5068, 5067, 10560}, {5097, 10571, 
         10570, 5096}, {10654, 6673, 6672, 10653}, {7511, 5956, 5955, 7510}, {
         9572, 5097, 5096, 9571}, {10614, 10654, 10653, 10613}, {5938, 7283, 
         7282, 5937}, {8108, 6456, 6455, 8107}, {5956, 9574, 9573, 5955}, {
         5086, 8108, 8107, 5085}, {8129, 9572, 9571, 8128}, {8050, 9552, 9551,
          8049}, {6456, 10540, 10539, 6455}, {5068, 9542, 9541, 5067}, {9547, 
         5938, 5937, 9546}, {10526, 10711, 10710, 10525}, {7138, 10561, 10560,
          7137}, {9577, 8129, 8128, 9576}, {6733, 7147, 7146, 6732}, {6696, 
         10554, 10553, 6695}, {6289, 10526, 10525, 6288}, {10571, 5086, 5085, 
         10570}, {9542, 8050, 8049, 9541}, {9574, 9577, 9576, 9573}, {10540, 
         6289, 6288, 10539}, {9552, 9547, 9546, 9551}, {6673, 6696, 6695, 
         6672}},
         VertexColors->None], 
        PolygonBox[{{6435, 7293, 2024, 7292, 6434}, {5948, 7511, 7510, 7515, 
         2024}, {7272, 6435, 6434, 7268, 2019}, {7283, 5933, 2019, 7285, 
         7282}},
         VertexColors->None]}]}, 
     {RGBColor[0.8883295204397226, 0.8889151072109612, 0.8577181754855497], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{9542, 5068, 2519}, {9572, 8129, 2545}, {8121, 8122, 
         2545}, {8051, 8046, 2519}, {9552, 8050, 2519}, {8050, 9542, 2519}, {
         5097, 9572, 2545}, {8129, 9577, 2545}},
         VertexColors->None], 
        PolygonBox[{{5087, 8109, 8108, 5086}, {10655, 6674, 6673, 10654}, {
         7273, 6436, 6435, 7272}, {7294, 5949, 5948, 7293}, {10541, 6290, 
         6289, 10540}, {7139, 10562, 10561, 7138}, {10615, 10655, 10654, 
         10614}, {6290, 10527, 10526, 6289}, {6436, 7294, 7293, 6435}, {6674, 
         6697, 6696, 6673}, {10555, 6734, 6733, 10554}, {7148, 7139, 7138, 
         7147}, {6457, 10541, 10540, 6456}, {10527, 10712, 10711, 10526}, {
         8109, 6457, 6456, 8108}, {7512, 5957, 5956, 7511}, {5939, 7284, 7283,
          5938}, {6734, 7148, 7147, 6733}, {5949, 7512, 7511, 5948}, {10712, 
         10615, 10614, 10711}, {6697, 10555, 10554, 6696}, {10572, 5087, 5086,
          10571}, {5957, 9575, 9574, 5956}, {9548, 5939, 5938, 9547}, {5934, 
         7273, 7272, 5933}, {7284, 5934, 5933, 7283}},
         VertexColors->None], 
        PolygonBox[{{8122, 10572, 10571, 5097, 2545}, {8046, 9548, 9547, 9552,
          2519}, {10562, 8051, 2519, 5068, 10561}, {9575, 8121, 2545, 9577, 
         9574}},
         VertexColors->None]}]}, 
     {RGBColor[0.9004403323101022, 0.8929537402657228, 0.8522925426205132], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{6441, 5950, 1149}, {7512, 5949, 1149}, {5950, 10576, 
         1149}, {5957, 7512, 1149}, {5934, 7284, 1147}, {7284, 5939, 1147}, {
         8121, 9575, 1149}, {9575, 5957, 1149}, {9548, 8046, 1147}, {10566, 
         5940, 1147}, {5940, 6439, 1147}, {5939, 9548, 1147}},
         VertexColors->None], 
        PolygonBox[{{10528, 10713, 10712, 10527}, {8123, 10573, 10572, 
         8122}, {7140, 10563, 10562, 7139}, {10556, 6735, 6734, 10555}, {
         10542, 6291, 6290, 10541}, {7274, 6437, 6436, 7273}, {10656, 6675, 
         6674, 10655}, {10616, 10656, 10655, 10615}, {7149, 7140, 7139, 
         7148}, {8110, 6458, 6457, 8109}, {10563, 8052, 8051, 10562}, {6698, 
         10556, 10555, 6697}, {6675, 6698, 6697, 6674}, {6735, 7149, 7148, 
         6734}, {10713, 10616, 10615, 10712}, {6291, 10528, 10527, 6290}, {
         5088, 8110, 8109, 5087}, {10573, 5088, 5087, 10572}, {6458, 10542, 
         10541, 6457}, {6437, 7295, 7294, 6436}},
         VertexColors->None], 
        PolygonBox[{{10576, 8123, 8122, 8121, 1149}, {7295, 6441, 1149, 5949, 
         7294}, {8052, 10566, 1147, 8046, 8051}, {6439, 7274, 7273, 5934, 
         1147}},
         VertexColors->None]}]}, 
     {RGBColor[0.9125511441804818, 0.8969923733204843, 0.8468669097554768], 
      EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{10577, 8124, 8123, 10576}, {6440, 7275, 7274, 6439}, {
        10564, 8053, 8052, 10563}, {6292, 10529, 10528, 6291}, {6442, 5951, 
        5950, 6441}, {8053, 10567, 10566, 8052}, {10574, 5089, 5088, 10573}, {
        6676, 6699, 6698, 6675}, {6438, 7296, 7295, 6437}, {10567, 5941, 5940,
         10566}, {6736, 7150, 7149, 6735}, {7275, 6438, 6437, 7274}, {7296, 
        6442, 6441, 7295}, {10529, 10714, 10713, 10528}, {10543, 6292, 6291, 
        10542}, {7141, 10564, 10563, 7140}, {5951, 10577, 10576, 5950}, {
        10557, 6736, 6735, 10556}, {10617, 10657, 10656, 10616}, {10657, 6676,
         6675, 10656}, {6459, 10543, 10542, 6458}, {8111, 6459, 6458, 8110}, {
        5941, 6440, 6439, 5940}, {6699, 10557, 10556, 6698}, {8124, 10574, 
        10573, 8123}, {5089, 8111, 8110, 5088}, {7150, 7141, 7140, 7149}, {
        10714, 10617, 10616, 10713}},
        VertexColors->None]]}, 
     {RGBColor[0.9246619560508614, 0.9010310063752459, 0.8414412768904405], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{8111, 5089, 2543}, {7296, 6438, 1692}, {7141, 7150, 
         1953}, {6438, 7275, 1692}, {10531, 10734, 1692}, {6442, 7296, 
         1692}, {10733, 10531, 1692}, {7275, 6440, 1692}, {8112, 8102, 
         2543}, {10548, 7151, 1953}},
         VertexColors->None], 
        PolygonBox[{{10544, 6293, 6292, 10543}, {6293, 10530, 10529, 6292}, {
         10618, 10658, 10657, 10617}, {6677, 6700, 6699, 6676}, {6700, 10558, 
         10557, 6699}, {10658, 6677, 6676, 10657}, {8125, 10575, 10574, 
         8124}, {10530, 10715, 10714, 10529}, {10578, 8125, 8124, 10577}, {
         10568, 5942, 5941, 10567}, {10565, 8054, 8053, 10564}, {10558, 6737, 
         6736, 10557}, {6460, 10544, 10543, 6459}, {5952, 10578, 10577, 
         5951}, {10715, 10618, 10617, 10714}, {8054, 10568, 10567, 8053}},
         VertexColors->None], 
        PolygonBox[{{10575, 8112, 2543, 5089, 10574}, {5942, 10733, 1692, 
         6440, 5941}, {7151, 10565, 10564, 7141, 1953}, {6737, 10548, 1953, 
         7150, 6736}, {8102, 6460, 6459, 8111, 2543}, {10734, 5952, 5951, 
         6442, 1692}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{8125, 10578, 4784, 4806}, {10578, 5952, 4776, 4784}, {
        10575, 8125, 4806, 4783}, {6293, 10544, 4771, 4779}, {10558, 6700, 
        4788, 4774}, {10530, 6293, 4779, 4767}, {5942, 10568, 4782, 4775}, {
        10733, 5942, 4775, 4801}, {10531, 10733, 4801, 4769}, {10565, 7151, 
        4800, 4781}, {10544, 6460, 4785, 4771}, {6677, 10658, 4795, 4787}, {
        6737, 10558, 4774, 4790}, {10618, 10715, 4798, 4793}, {10568, 8054, 
        4803, 4782}, {6700, 6677, 4787, 4788}, {8102, 8112, 4805, 4804}, {
        8112, 10575, 4783, 4805}, {10715, 10530, 4767, 4798}, {10548, 6737, 
        4790, 4773}, {10734, 10531, 4769, 4802}, {8054, 10565, 4781, 4803}, {
        7151, 10548, 4773, 4800}, {5952, 10734, 4802, 4776}, {10658, 10618, 
        4793, 4795}, {6460, 8102, 4804, 4785}},
        VertexColors->None]]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6460, 10544, 6293, 10530, 10715, 10618, 10658, 6677, 6700, 
         10558, 6737, 10548, 7151, 10565, 8054, 10568, 5942, 10733, 10531, 
         10734, 5952, 10578, 8125, 10575, 8112, 8102, 6460}],
        "6.210000000000001`"],
       Annotation[#, 6.210000000000001, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6459, 10543, 6292, 10529, 10714, 10617, 10657, 6676, 6699, 
         10557, 6736, 7150, 7141, 10564, 8053, 10567, 5941, 6440, 7275, 6438, 
         7296, 6442, 5951, 10577, 8124, 10574, 5089, 8111, 6459}],
        "5.94`"],
       Annotation[#, 5.94, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6458, 10542, 6291, 10528, 10713, 10616, 10656, 6675, 6698, 
         10556, 6735, 7149, 7140, 10563, 8052, 10566, 5940, 6439, 7274, 6437, 
         7295, 6441, 5950, 10576, 8123, 10573, 5088, 8110, 6458}],
        "5.67`"],
       Annotation[#, 5.67, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6457, 10541, 6290, 10527, 10712, 10615, 10655, 6674, 6697, 
         10555, 6734, 7148, 7139, 10562, 8051, 8046, 9548, 5939, 7284, 5934, 
         7273, 6436, 7294, 5949, 7512, 5957, 9575, 8121, 8122, 10572, 5087, 
         8109, 6457}],
        "5.4`"],
       Annotation[#, 5.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6456, 10540, 6289, 10526, 10711, 10614, 10654, 6673, 6696, 
         10554, 6733, 7147, 7138, 10561, 5068, 9542, 8050, 9552, 9547, 5938, 
         7283, 5933, 7272, 6435, 7293, 5948, 7511, 5956, 9574, 9577, 8129, 
         9572, 5097, 10571, 5086, 8108, 6456}],
        "5.130000000000001`"],
       Annotation[#, 5.130000000000001, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6455, 10539, 6288, 10525, 10710, 10613, 10653, 6672, 6695, 
         10553, 6732, 7146, 7137, 10560, 5067, 9541, 8049, 9551, 9546, 5937, 
         7282, 7285, 7271, 7993, 7268, 6434, 7292, 8000, 7299, 7515, 7510, 
         5955, 9573, 9576, 8128, 9571, 5096, 10570, 5085, 8107, 6455}],
        "4.86`"],
       Annotation[#, 4.86, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6102, 9550, 5936, 7287, 5945, 7270, 7992, 7267, 6433, 7291, 
         7999, 7298, 6189, 7514, 5954, 9579, 6114, 8127, 9570, 5095, 10569, 
         5084, 8106, 6454, 10538, 6287, 10524, 10709, 10612, 10652, 6671, 
         6694, 10552, 6731, 7145, 7136, 10559, 5066, 9540, 8048, 6102}],
        "4.59`"],
       Annotation[#, 4.59, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{9549, 6101, 8047, 6100, 9545, 5060, 8952, 5065, 6720, 7144, 
         6730, 10551, 6693, 6670, 10651, 10611, 10708, 10523, 6286, 10537, 
         6453, 8105, 6450, 5094, 8976, 6590, 9569, 6110, 8126, 6113, 9578, 
         5953, 7513, 6188, 7297, 7996, 7998, 7035, 5029, 7014, 7995, 7991, 
         7269, 5944, 7286, 5935, 9549}],
        "4.32`"],
       Annotation[#, 4.32, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6452, 10536, 6285, 10522, 10707, 10610, 10650, 6669, 6692, 
         10550, 6729, 7143, 6719, 5064, 8951, 5059, 9544, 6393, 6104, 6811, 
         8282, 8283, 7277, 7279, 5943, 7024, 5947, 7017, 7994, 7013, 5028, 
         7034, 7997, 7036, 6187, 7044, 6185, 7506, 7301, 8298, 8295, 6604, 
         6112, 6595, 9568, 6589, 8975, 5093, 6449, 8104, 6452}],
        "4.050000000000001`"],
       Annotation[#, 4.050000000000001, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{10535, 6451, 8103, 6448, 5092, 8974, 6588, 9567, 6594, 6111, 
         6603, 8297, 5188, 7300, 7503, 7505, 7043, 6186, 7508, 5676, 7038, 
         7990, 7016, 5670, 7290, 5946, 7023, 7281, 7278, 7276, 5181, 8285, 
         6810, 6103, 6392, 9543, 5058, 8950, 5063, 6718, 7142, 6728, 10549, 
         6691, 6668, 10649, 10609, 10706, 10521, 6284, 10535}],
        "3.7800000000000002`"],
       Annotation[#, 3.7800000000000002`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{8830, 6727, 8044, 5062, 8954, 5596, 6391, 6388, 7449, 7450, 
         6809, 8284, 6806, 5180, 7212, 5183, 7021, 7280, 7022, 7289, 7288, 
         5669, 7015, 7989, 7037, 5675, 7507, 7509, 7042, 7504, 7039, 5187, 
         7227, 5185, 6601, 8296, 6602, 7460, 7459, 5450, 6593, 5613, 8978, 
         5091, 8120, 6467, 8912, 5237, 6876, 6889, 6283, 10520, 10705, 10608, 
         10648, 6667, 6690, 7177, 7164, 5495, 8830}],
        "3.5100000000000002`"],
       Annotation[#, 3.5100000000000002`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7455, 7041, 8293, 5186, 7226, 5184, 8291, 6606, 5454, 7458, 
         5449, 6592, 5612, 8977, 5090, 8119, 6466, 8911, 5236, 6875, 6888, 
         6282, 10519, 10704, 10607, 10647, 6666, 6689, 7176, 7163, 5494, 8829,
          6726, 8043, 5061, 8953, 5595, 6390, 6387, 7448, 5539, 6808, 8280, 
         5179, 7211, 5182, 8288, 7026, 7453, 7451, 6421, 7067, 5671, 7020, 
         5932, 7046, 5677, 7069, 6423, 7454, 7455}],
        "3.24`"],
       Annotation[#, 3.24, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7040, 6109, 7456, 6422, 7070, 5701, 7047, 7045, 7266, 7018, 
         7019, 5697, 7068, 6420, 7452, 6105, 7025, 8286, 8287, 7210, 8281, 
         8279, 6807, 5538, 7447, 6386, 6389, 5594, 8045, 8959, 8042, 6725, 
         8828, 5493, 7162, 7175, 6688, 6665, 10646, 10606, 10703, 10518, 6281,
          6887, 6874, 5235, 8910, 6465, 8117, 8985, 8118, 5611, 6591, 5448, 
         7457, 5453, 6605, 8289, 8290, 7225, 8294, 8292, 7040}],
        "2.97`"],
       Annotation[#, 2.97, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5212, 9991, 9992, 9975, 9976, 5151, 7434, 5150, 9974, 9973, 
         10386, 10385, 6012, 9427, 9426, 8022, 6002, 9418, 10428, 4905, 10427,
          10426, 10425, 7913, 7912, 8724, 8723, 4897, 4974, 7888, 7887, 8685, 
         8684, 4892, 4969, 7859, 7858, 8649, 8648, 4884, 4963, 6334, 5806, 
         7591, 9836}],
        "2.7`"],
       Annotation[#, 2.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5750, 9133, 5751, 6514, 6513, 4844, 4931, 7708, 7707, 8468, 
         8467, 4838, 4925, 7684, 7683, 8441, 8440, 4832, 4920, 7656, 7655, 
         8402, 10414, 8401, 10415, 4827, 9786, 9255, 5845, 10454, 5844, 10137,
          10177, 10176, 5905, 9620, 9621, 9617, 9619, 9618, 9719, 5130, 6409, 
         6250, 7502, 7501, 7525}],
        "2.7`"],
       Annotation[#, 2.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8197, 5615, 8984, 8116, 6464, 8909, 5234, 6873, 6886, 6280, 
         10517, 10702, 10605, 10645, 6664, 6687, 7174, 7161, 5492, 8827, 6724,
          8041, 8958, 5598, 8171, 9953, 6804, 5537, 6931, 5535, 6800, 6098, 
         7947, 6099, 9539, 5877, 9557, 9558, 9554, 9556, 9555, 5174, 9039, 
         5696, 8271, 5698, 7010, 7008, 5215, 7029, 7030, 5700, 8275, 5699, 
         9044, 5176, 10308, 10309, 9563, 9566, 9565, 5885, 9561, 6108, 7953, 
         6107, 6354, 6351, 6937, 5452, 6600, 8202, 8197}],
        "2.7`"],
       Annotation[#, 2.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4826, 7485, 7486, 6265, 7488, 7487, 5904, 10181, 10182, 
         10178, 10180, 10179, 9075, 8399, 8400, 7652, 8404, 8403, 9089, 8438, 
         8439, 7680, 5297, 8442, 5731, 8466, 5308, 7705, 5309, 8469, 5741, 
         8493, 5319, 7729, 5320, 8494, 5752, 8520, 5330, 7752, 5331, 8521, 
         5761, 9138, 9140, 9139, 5345, 7771, 7772, 7773, 9819, 8571, 5358, 
         7794, 7795, 9169, 9170, 9168, 5791, 8597, 5369, 7815, 5370, 8598, 
         5798, 8621, 5381, 7835, 5382, 8622, 5807, 8647, 5393, 7855, 5394, 
         8650, 5821, 8683, 5409, 7884, 8687, 8686, 9224, 8721, 8722, 7910, 
         8726, 8725, 9249, 10370, 10371, 10369, 10373, 10372, 6001, 10223, 
         10224, 10220, 10222, 10221, 10225}],
        "2.43`"],
       Annotation[#, 2.43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8196, 5614, 8983, 8115, 6463, 8908, 5233, 6872, 6885, 6279, 
         10516, 10701, 10604, 10644, 6663, 6686, 7173, 7160, 5491, 8826, 6723,
          8040, 8957, 5597, 8170, 9952, 6803, 5536, 6932, 5593, 6799, 6797, 
         9537, 6097, 7946, 9538, 7944, 6643, 5876, 6649, 9553, 6646, 5173, 
         6639, 5171, 9040, 8270, 9042, 9041, 5668, 7009, 8325, 7031, 5673, 
         9045, 9046, 8274, 9043, 5175, 6445, 5178, 6778, 9564, 6779, 5887, 
         6776, 7951, 9562, 7952, 6106, 9560, 4999, 6353, 5609, 6938, 5451, 
         6599, 8201, 8196}],
        "2.43`"],
       Annotation[#, 2.43, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5842, 8761, 5434, 7938, 5433, 8760, 5837, 9247, 5838, 9248, 
         7911, 7909, 5422, 8720, 9850, 7886, 7885, 7883, 5408, 8682, 9845, 
         7857, 7856, 7854, 8644, 8643, 4883, 4962, 7836, 7834, 8618, 8617, 
         4876, 4958, 7816, 7814, 8595, 8594, 4871, 4953, 7793, 7792, 8569, 
         8568, 4864, 4947, 7770, 7769, 8547, 8546, 4856, 4941, 7753, 7751, 
         8518, 8517, 4849, 4936, 7730, 7728, 8491, 8490, 4843, 4930, 7706, 
         7704, 5307, 8463, 9800, 7682, 7681, 7679, 5296, 8437, 9791, 7654, 
         7653, 7651, 5282, 9074, 5716, 9073, 5715, 8365, 5271, 7626, 5270, 
         8364, 9785}],
        "2.16`"],
       Annotation[#, 2.16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8195, 8982, 8980, 8114, 6462, 8907, 5232, 6871, 6884, 6278, 
         10515, 10700, 10603, 10643, 6662, 6685, 7172, 7159, 5490, 8825, 6722,
          8039, 8956, 8961, 8169, 9955, 5113, 6802, 8161, 6805, 5592, 6798, 
         6796, 9536, 4989, 7945, 6642, 5875, 7209, 5479, 6648, 8273, 5172, 
         6638, 8269, 6640, 5667, 7135, 5666, 7005, 5695, 7027, 5672, 6270, 
         5674, 6447, 8276, 6444, 5177, 8278, 6781, 5521, 7229, 5886, 6775, 
         7954, 4997, 9559, 4998, 6352, 5608, 6598, 8192, 6597, 5121, 8204, 
         8195}],
        "2.16`"],
       Annotation[#, 2.16, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4910, 4984, 7939, 7937, 8757, 8756, 4904, 4979, 7908, 7907, 
         8717, 8716, 4896, 4973, 10129, 5828, 9223, 5829, 6553, 6552, 9211, 
         8645, 8646, 7852, 8642, 8641, 9190, 8619, 8620, 7831, 5380, 8616, 
         5797, 8596, 5368, 7812, 5367, 8593, 5790, 8570, 5357, 7790, 5356, 
         8567, 5777, 8548, 5344, 7767, 5343, 8545, 5760, 8519, 5329, 7749, 
         5328, 8516, 5749, 8492, 5318, 7725, 8489, 8488, 9125, 8464, 8465, 
         7701, 8462, 8461, 9107, 6498, 6499, 5729, 7559, 9798, 9799, 6497, 
         4831, 4919, 7650, 7649, 8397, 8396, 4825, 4915, 7627, 7625, 8361, 
         8360, 9071}],
        "1.8900000000000001`"],
       Annotation[#, 1.8900000000000001`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8981, 8194, 8203, 5120, 6596, 5119, 8206, 8193, 9505, 9504, 
         5610, 6813, 6812, 9510, 5000, 7956, 6774, 7230, 5518, 7228, 5520, 
         6780, 8277, 6446, 5224, 7032, 7033, 6269, 7028, 4866, 6861, 4860, 
         4944, 7762, 7133, 5851, 7004, 5852, 7007, 7006, 5476, 6641, 8272, 
         6647, 5478, 7208, 5477, 7207, 6645, 7943, 4987, 9486, 4988, 6341, 
         5591, 6560, 8160, 5110, 6801, 5112, 9954, 8168, 8960, 8955, 8038, 
         6721, 8824, 5489, 7158, 7171, 6684, 6661, 10642, 10602, 10699, 10514,
          6277, 6883, 6870, 5231, 8906, 6461, 8113, 8979, 8981}],
        "1.8900000000000001`"],
       Annotation[#, 1.8900000000000001`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4824, 9783, 9784, 8359, 8363, 9781, 8362, 10465, 9072, 8394, 
         10413, 8395, 7646, 5281, 8398, 5723, 8435, 5294, 7677, 5295, 8436, 
         5730, 9104, 9106, 9105, 5306, 7700, 7702, 7703, 9804, 8485, 5317, 
         7724, 7726, 7727, 9811, 4848, 8513, 8514, 7748, 7750, 4940, 4855, 
         8542, 8543, 7766, 7768, 4946, 4863, 8564, 8565, 7789, 7791, 4952, 
         4870, 8589, 8590, 7811, 7813, 4957, 4875, 9829, 8613, 5379, 7830, 
         7832, 7833, 9835, 8640, 5392, 7851, 7853, 9209, 9210, 9208, 5820, 
         8680, 5406, 7880, 5407, 8681, 5830, 8715, 5421, 7904, 8719, 8718, 
         10134, 9245, 10501, 9246, 8755, 8759, 10502, 8758, 9254}],
        "1.62`"],
       Annotation[#, 1.62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8823, 5544, 8805, 5543, 9638, 9639, 8167, 9629, 9627, 7375, 
         5111, 8164, 6562, 7414, 5436, 6930, 6340, 6342, 6062, 7942, 9289, 
         7941, 6644, 5874, 7206, 5480, 7365, 7366, 6369, 5022, 7011, 7012, 
         6368, 6367, 7343, 5475, 7086, 5767, 7134, 10138, 10139, 9260, 9262, 
         9261, 7575, 6862, 5565, 6268, 5566, 6863, 8326, 8327, 7321, 5223, 
         6443, 7049, 7048, 5034, 6377, 7395, 7394, 5519, 7231, 5888, 6773, 
         7955, 9297, 7957, 6076, 6814, 5545, 6939, 8837, 8836, 7347, 6073, 
         9708, 9709, 8205, 9956, 5122, 9702, 9669, 9670, 8200, 9681, 9677, 
         5572, 10032, 5573, 8905, 5230, 6869, 6882, 6276, 10513, 10698, 10601,
          10641, 6660, 6683, 7170, 7157, 5488, 8823}],
        "1.62`"],
       Annotation[#, 1.62, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5841, 8754, 5432, 7935, 5431, 9858, 10424, 9859, 10133, 
         10132, 9860, 7906, 7905, 7903, 5420, 8714, 9849, 7882, 7881, 7879, 
         8677, 8676, 4891, 4968, 6336, 5819, 7598, 7599, 4890, 6548, 9189, 
         8614, 8615, 7828, 8612, 8611, 9176, 8591, 8592, 7808, 5366, 8588, 
         5789, 8566, 5355, 7787, 5354, 8563, 5776, 8544, 5342, 7764, 5341, 
         8541, 5759, 8515, 5327, 7746, 8512, 8511, 9132, 8486, 8487, 7721, 
         8484, 8483, 9124, 6507, 9119, 9120, 9118, 5739, 6506, 6505, 4837, 
         4924, 7678, 7676, 5293, 9998, 8432, 9790, 7648, 7647, 7645, 5280, 
         8393, 9782, 9068, 9070, 9069, 5269, 7623, 5268, 8358, 9780}],
        "1.35`"],
       Annotation[#, 1.35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7084, 6030, 7083, 7082, 7076, 5021, 7988, 6014, 7265, 8036, 
         8037, 6637, 10107, 10108, 9146, 9148, 9147, 9149, 8882, 8883, 8101, 
         9473, 10438, 5083, 9474, 9475, 6212, 9700, 6211, 10379, 7393, 5968, 
         9664, 9665, 8009, 8010, 5033, 7322, 5032, 6376, 6049, 7319, 8132, 
         8133, 6777, 9295, 9945, 9296, 8134, 8219, 8218, 5127, 9962, 6815, 
         5546, 6945, 6394, 7348, 6018, 7417, 10383, 6215, 9706, 6216, 9710, 
         6214, 9705, 9671, 9684, 6198, 8199, 6200, 9680, 5571, 10031, 10034, 
         8904, 8899, 5229, 6868, 6881, 6275, 10512, 10697, 10600, 10640, 6659,
          6682, 7169, 7156, 5487, 8822, 8835, 8804, 5542, 9642, 6180, 8166, 
         6178, 9628, 7374, 8163, 8162, 6561, 6069, 7413, 5435, 6925, 5437, 
         6563, 8153, 5108, 8151, 8152, 8071, 9288, 9287, 6650, 8075, 8074, 
         7084}],
        "1.35`"],
       Annotation[#, 1.35, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4909, 4983, 7936, 7934, 8751, 8750, 4903, 4978, 6337, 5836, 
         7601, 7602, 4902, 6557, 9222, 8678, 10500, 8679, 8675, 9207, 10499, 
         9206, 10124, 8638, 8639, 7848, 5391, 8637, 5805, 9186, 9188, 9187, 
         7829, 7827, 5378, 8610, 9828, 7810, 7809, 7807, 8587, 8586, 4869, 
         4951, 7788, 7786, 8562, 8561, 4862, 4945, 7765, 7763, 8539, 8538, 
         4854, 4939, 7747, 7745, 5325, 8510, 9810, 7723, 7722, 7720, 5316, 
         9122, 9123, 9121, 5740, 8460, 5305, 7697, 8459, 10417, 8458, 9103, 
         10468, 8433, 9796, 8434, 8431, 9088, 9087, 10094, 6495, 9085, 9086, 
         9084, 5721, 6494, 6493, 4823, 4914, 7624, 7622, 8355, 8354, 9066}],
        "1.08`"],
       Annotation[#, 1.08, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7077, 5753, 7078, 5765, 7364, 5766, 7085, 8068, 8069, 6092, 
         8073, 8072, 8070, 5552, 10027, 8844, 9327, 9326, 6825, 6826, 5588, 
         6400, 5587, 6924, 6559, 9495, 6067, 8079, 6068, 9497, 6038, 9637, 
         7376, 6177, 8165, 6179, 9641, 5541, 8803, 8834, 8821, 5486, 7155, 
         7168, 6681, 6658, 10639, 10599, 10696, 10511, 6274, 6880, 6867, 5228,
          8898, 8903, 10033, 10030, 5570, 9679, 6199, 8198, 6197, 9682, 10362,
          9683, 9704, 10382, 9703, 9367, 7351, 9707, 6019, 7528, 6017, 7345, 
         5069, 6943, 5624, 6396, 5625, 6817, 6816, 9391, 9392, 8918, 5574, 
         8135, 9590, 9591, 6127, 8131, 8130, 7318, 5967, 7396, 6375, 9349, 
         9350, 9165, 10110, 9166, 9352, 9351, 9663, 7320, 5882, 10156, 9294, 
         9472, 9471, 5883, 7221, 6653, 10437, 6654, 5568, 10029, 5567, 10479, 
         9000, 5636, 8799, 5533, 8797, 5534, 6652, 6651, 8035, 8034, 7264, 
         5931, 9431, 7987, 7077}],
        "1.08`"],
       Annotation[#, 1.08, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4822, 9778, 9779, 8353, 8357, 8356, 9067, 8390, 8391, 7642, 
         5279, 8392, 5722, 8430, 5291, 7673, 5292, 9102, 5728, 9101, 9797, 
         8457, 5304, 7696, 7698, 7699, 9803, 4842, 6510, 6511, 5748, 7569, 
         5747, 9129, 6512, 7075, 6518, 6519, 7131, 7130, 5326, 6520, 5758, 
         9747, 10449, 9748, 9746, 9750, 5339, 10007, 5340, 10476, 9749, 8540, 
         9612, 9611, 5775, 6527, 5352, 7112, 5353, 6530, 5788, 6532, 5365, 
         7191, 7192, 6534, 6533, 7114, 6540, 7590, 7589, 9185, 5804, 9277, 
         10429, 9278, 9276, 9872, 9873, 4882, 9834, 8636, 5390, 7847, 7849, 
         7850, 9844, 10123, 5818, 10486, 9843, 5404, 7876, 5405, 8674, 5827, 
         8711, 5419, 7901, 8713, 8712, 10131, 9243, 9244, 8749, 8753, 8752, 
         9253}],
        "0.81`"],
       Annotation[#, 0.81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8846, 8843, 9895, 9894, 5014, 9896, 7970, 9329, 9328, 5553, 
         6926, 6398, 6399, 9517, 9516, 5073, 7368, 5074, 9494, 8078, 9498, 
         9496, 6037, 9634, 9636, 9632, 9904, 8817, 9640, 5540, 8802, 8833, 
         8820, 5485, 7154, 7167, 6680, 6657, 10638, 10598, 10695, 10510, 6273,
          6879, 6866, 5227, 8897, 8902, 8887, 10035, 5569, 9678, 9674, 9918, 
         10360, 10363, 10361, 9366, 9364, 5974, 7349, 7350, 6206, 7346, 8055, 
         8056, 7344, 7182, 7428, 7429, 6397, 6395, 6944, 5547, 9393, 9394, 
         8011, 9922, 5040, 8914, 8915, 8913, 8917, 8916, 5199, 9477, 9478, 
         9476, 10258, 10257, 7317, 4948, 10111, 6331, 7106, 7105, 5782, 7222, 
         7223, 7103, 7102, 7220, 4996, 8779, 8780, 8777, 5482, 9024, 9025, 
         8884, 5665, 9023, 9903, 9020, 5664, 8798, 9022, 9021, 5481, 8771, 
         8776, 8775, 9430, 7263, 4986, 6339, 7205, 7204, 5754, 7127, 7128, 
         6147, 7495, 6146, 7490, 4859, 9442, 9443, 9441, 9445, 9444, 5164, 
         8845, 8846}],
        "0.81`"],
       Annotation[#, 0.81, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5840, 8748, 5430, 7931, 5429, 8747, 5835, 9240, 9242, 9241, 
         7902, 7900, 5418, 8710, 9848, 7878, 7877, 7875, 5403, 8673, 9842, 
         4889, 4967, 6335, 5817, 7595, 7596, 7597, 6547, 7120, 9416, 5997, 
         9415, 5998, 7196, 7195, 5051, 8018, 6159, 9743, 6384, 6385, 9697, 
         9696, 9609, 9610, 9275, 5863, 9274, 5862, 7190, 5861, 9305, 5899, 
         9302, 9304, 9303, 4868, 4950, 7785, 7110, 5786, 6529, 5787, 6528, 
         6526, 7097, 7498, 7499, 6163, 9752, 9753, 9751, 10404, 10403, 5772, 
         9763, 9761, 9762, 9760, 6263, 7260, 7259, 4853, 4938, 7744, 7743, 
         5850, 9259, 5849, 7129, 9898, 7972, 5925, 9339, 7570, 9130, 10100, 
         10099, 9131, 8482, 9755, 10448, 5315, 10409, 6260, 10408, 10411, 
         10410, 6259, 7554, 6258, 7552, 7073, 6504, 9117, 5737, 9116, 5738, 
         10337, 6142, 10335, 6141, 10336, 4836, 10416, 9601, 7675, 7674, 7672,
          5290, 8429, 9789, 7644, 7643, 7641, 5278, 9064, 9065, 9063, 5714, 
         8352, 5267, 7619, 5266, 8351, 9777}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8249, 5653, 9005, 5982, 9395, 5983, 9396, 5585, 7002, 5651, 
         9720, 8242, 8243, 6818, 8247, 8246, 8244, 6086, 9524, 5857, 9271, 
         7183, 6015, 9698, 6016, 9432, 5973, 9355, 5972, 9365, 9361, 9919, 
         5036, 9673, 9676, 8886, 8901, 8896, 5226, 6865, 6878, 6272, 10509, 
         10694, 10597, 10637, 6656, 6679, 7166, 7153, 5484, 8819, 8832, 8801, 
         8816, 8814, 5024, 9905, 9631, 9635, 6036, 10254, 6039, 7369, 8080, 
         7367, 8077, 8076, 9518, 6084, 8231, 9965, 9966, 6824, 8230, 8229, 
         8228, 5632, 8998, 5532, 9325, 5919, 9324, 5918, 9016, 5663, 8263, 
         9017, 10475, 5161, 9979, 5160, 9978, 9977, 9994, 9993, 5213, 9600, 
         6140, 9599, 6139, 9258, 5848, 9256, 5847, 9257, 5917, 9623, 6174, 
         9622, 6173, 10357, 7250, 5871, 7203, 5872, 9285, 5873, 9286, 5473, 
         8770, 8773, 8772, 5168, 6634, 5167, 9982, 8266, 8322, 8321, 5214, 
         8323, 8324, 8267, 8268, 5169, 7101, 5170, 9012, 9013, 8778, 5660, 
         9616, 6169, 9615, 6168, 7224, 5884, 7325, 9667, 6195, 9666, 6196, 
         9668, 5970, 7104, 5783, 7326, 10114, 10113, 10112, 10261, 10260, 
         10380, 7407, 5795, 7113, 5796, 10119, 10055, 10056, 9971, 9972, 5145,
          10065, 5146, 8250, 8249}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5713, 8348, 9997, 5265, 7618, 7620, 7621, 9775, 9776, 8386, 
         8387, 7639, 7640, 4918, 4830, 8425, 10507, 8426, 7670, 10504, 7671, 
         10466, 10467, 4923, 4835, 9794, 9795, 9312, 10487, 9311, 7566, 5219, 
         10080, 10081, 10079, 5705, 10082, 5706, 9995, 9996, 6145, 10447, 
         5218, 10340, 6144, 10338, 6143, 10339, 5131, 6255, 10405, 10407, 
         10406, 5846, 7542, 7543, 6245, 9867, 9868, 4935, 4847, 7489, 4852, 
         6267, 6246, 7436, 7435, 5755, 9422, 6008, 9421, 6007, 6364, 6363, 
         9423, 6009, 8023, 9928, 5053, 7132, 9603, 9340, 9341, 7973, 9741, 
         9899, 5017, 9742, 6247, 9155, 5773, 7974, 5774, 9156, 6152, 9347, 
         5965, 8003, 8006, 8007, 7111, 7186, 7187, 6264, 7189, 7188, 6314, 
         7239, 5255, 6487, 7962, 7963, 6489, 6490, 6249, 10472, 10473, 9869, 
         9871, 9870, 4956, 4874, 9413, 9414, 9412, 5996, 7194, 7193, 7197, 
         7118, 7119, 6257, 7551, 5803, 7117, 6545, 6546, 5816, 10122, 5815, 
         10485, 9874, 9875, 4966, 4888, 8669, 8670, 7873, 7874, 4972, 4895, 
         8706, 8707, 7898, 7899, 4977, 9857, 9856, 8744, 10013, 5428, 7930, 
         7932, 7933, 9864}],
        "0.27`"],
       Annotation[#, 0.27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7237, 5893, 7538, 5892, 9593, 9594, 10325, 10324, 6130, 9728,
          9729, 8319, 9983, 9984, 7337, 7338, 5995, 10432, 5047, 7057, 5046, 
         10069, 10070, 10068, 10072, 10071, 5200, 7472, 7473, 6131, 10326, 
         10328, 10327, 5007, 10395, 10396, 9885, 9884, 9883, 6229, 9724, 6228,
          9725, 9727, 9726, 5105, 7491, 7492, 6237, 7536, 6153, 7493, 10291, 
         10290, 6220, 10384, 6154, 8245, 6155, 9607, 7783, 9270, 5858, 10146, 
         9272, 9266, 10142, 10143, 9362, 9363, 9354, 9360, 9359, 5035, 9672, 
         9675, 8885, 8900, 8895, 5225, 6864, 6877, 6271, 10508, 10693, 10596, 
         10636, 6655, 6678, 7165, 7152, 5483, 8818, 8831, 8800, 8815, 8813, 
         5023, 9630, 9633, 9447, 9452, 9451, 6031, 7373, 6035, 7534, 6034, 
         10253, 9446, 10341, 10342, 10343, 9602, 6149, 7427, 6082, 10287, 
         6083, 10284, 10286, 10285, 5057, 10391, 10392, 9941, 9940, 9939, 
         6227, 10387, 6226, 10388, 10390, 10389, 4985, 6224, 10463, 6225, 
         7444, 7443, 5163, 10050, 10051, 10047, 10049, 10048, 10073, 6951, 
         5012, 10430, 6172, 7245, 7244, 5162, 10441, 6091, 9527, 10234, 10235,
          9938, 10434, 9937, 5915, 10190, 5916, 9322, 5913, 7248, 7969, 9323, 
         5914, 7249, 8066, 8067, 7362, 7363, 6029, 9438, 9440, 9439, 5019, 
         9018, 9019, 7980, 7979, 7978, 5470, 6325, 10452, 4943, 4858, 6635, 
         10460, 6636, 5781, 9163, 5780, 9164, 9535, 9534, 5153, 10294, 10295, 
         9526, 6089, 7442, 7441, 8258, 8257, 7323, 5969, 7324, 6378, 9353, 
         5971, 9174, 10118, 7237}],
        "0.27`"],
       Annotation[#, 0.27, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4821, 9773, 9774, 8347, 8350, 8349, 10088, 9061, 9062, 8385, 
         8389, 8388, 10093, 9082, 9083, 8424, 8428, 8427, 9100, 10353, 10354, 
         10352, 10356, 10355, 5906, 10186, 10187, 10183, 10185, 10184, 10188, 
         6207, 10462, 6208, 6024, 10239, 10240, 10236, 10238, 10237, 5011, 
         9892, 9893, 9429, 9428, 10233, 6013, 9934, 9935, 9936, 7342, 5056, 
         9933, 9932, 10232, 10231, 5155, 7540, 5156, 6418, 8262, 5154, 9014, 
         9015, 8261, 8260, 8259, 5662, 6630, 6629, 4934, 9809, 9808, 7568, 
         5746, 6081, 10459, 6080, 7968, 7967, 7966, 5464, 8764, 7940, 6430, 
         5220, 7246, 7247, 6427, 6426, 4937, 4851, 6633, 5468, 7361, 5469, 
         8769, 5472, 8768, 5471, 8536, 5337, 7977, 5338, 8537, 5764, 8774, 
         5474, 7981, 7984, 7985, 5658, 9010, 5659, 9011, 5351, 7440, 6329, 
         6330, 7578, 4865, 6772, 9827, 9826, 7579, 6157, 10365, 6202, 10364, 
         6201, 10367, 10368, 10366, 6203, 7336, 5894, 7238, 5895, 7003, 5661, 
         7530, 6416, 6417, 5682, 10066, 5683, 10067, 5256, 7580, 7581, 7582, 
         5694, 9038, 4880, 6315, 5684, 9985, 9986, 9987, 10076, 10075, 5201, 
         6424, 6230, 10442, 5203, 7532, 5202, 10159, 10160, 10158, 5900, 7240,
          9949, 9948, 9947, 6061, 10272, 5258, 8328, 9927, 9926, 5052, 10331, 
         10332, 10330, 10334, 10333, 6138, 6234, 10464, 6233, 10329, 10299, 
         10300, 10298, 10302, 10301, 5901, 10169, 10170, 10166, 10168, 10167, 
         9306, 9204, 9205, 8668, 8672, 8671, 10128, 9220, 9221, 8705, 8709, 
         8708, 10130, 9238, 9239, 8743, 8746, 8745, 9252}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1Ftoz3EYx/FnJ3O4kDDGDnb6z+GGGIrNjdMVJYfNhqGkbJSZHC8kthEl
NKdCTsWFnEqpuSHHiHGhXCjKaWmz4cLx9c/Fe5/v73me3+d5vs///1/BinXz
1qZERKo/TcMijgyOSCQiWumM/IjpmF8YUVwaUYQFztViD9UsptM854uPQB7G
FkW0j4z4ii4MzYqYI55Nx8lV8+2f6136ITtij54teO/8uDiiYUjEI7qB9nhv
I+2mjbSJXzN2o3xoxCo+n/kW5ER00MTwiL98G8T78uuHFPHn6lPpH7kKXr9p
p9gi83TTmXKVzrPoEvnZdCldPiiinlctfaKuWs9DehxEidhA/nPF7suVel6j
NkHPe/cCzuEjrwo7ejrQzLRK71Hio5HASJRiH49CFKEAJShGi3un0wykIC15
Fxzml0l7oxf6og/2qG+zj9tIN9sWM23FGufNdBN65J7hOWrEX9B2HEju3O6/
4xM68QVn9Go1+3HU4QJOY5e73PLZPUA5ro2K2IuVuIMOnOefYV8/5HfazVvv
daENr/EKl/kf1ecE9if74TTe2N14WoZVee5a4s74hp/m/YU6/n/pH1w0/1fa
jXrxLtqJm/xz7CYXw5GPPFxSn02HISv5XcUQjEGZz2QiJmAyJmGv+VtG8OdX
Ze6rYtdwBTdwHQvVNNrxIprt+1GhPsd5q5m3odzzVEzBPf3Pqh3Ar9l+qnke
tdPF9Bid6P4vk7PQ5X5rtViG43I1anr4VuqRac8tznfs+S6Wunua3+dJ3qfw
Ts02uh2r5XbQ9fo1oERdMfbxXFj4/3/AP8kKmU0=
         "]],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5839, 8742, 5427, 7927, 5426, 8741, 5834, 9237, 8703, 9854, 
         8704, 8702, 9219, 9218, 10127, 8666, 8667, 8665, 9203, 9202, 9417, 
         10213, 10214, 9199, 5813, 9198, 5814, 10346, 10347, 10345, 6161, 
         6317, 6316, 7494, 6160, 7433, 7432, 5147, 10400, 6242, 9733, 9735, 
         9734, 6090, 10296, 10297, 9598, 9597, 9730, 10398, 10209, 10210, 
         10208, 10212, 10211, 5992, 9411, 5994, 9410, 5993, 6374, 6373, 9425, 
         6011, 8030, 9931, 5055, 7341, 5054, 8028, 8029, 7986, 9902, 5020, 
         7100, 7983, 7982, 9346, 5930, 10458, 8025, 9929, 8024, 10456, 5929, 
         10192, 9900, 9901, 7081, 5018, 7976, 7975, 9345, 9344, 5221, 7200, 
         5222, 6432, 5324, 6517, 6428, 6429, 6241, 6266, 4850, 6558, 9321, 
         9319, 9320, 9318, 5912, 7124, 7123, 5010, 7071, 7072, 6256, 9754, 
         7564, 7565, 4929, 6319, 5736, 7561, 7562, 7563, 9280, 9279, 9099, 
         8422, 8423, 8421, 9081, 9080, 10092, 8383, 10495, 8384, 8382, 9060, 
         10494, 9059, 10087, 5712, 8346, 5264, 7615, 5263, 8345, 9772}],
        RowBox[{"-", "0.27`"}]],
       Annotation[#, -0.27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7202, 5870, 7537, 5869, 9528, 9529, 10307, 10306, 6094, 9722,
          9723, 8265, 9980, 9981, 7251, 7252, 5920, 10431, 5015, 6952, 10074, 
         10042, 10043, 10041, 10045, 10044, 5166, 7445, 7446, 6093, 10303, 
         10305, 10304, 6953, 10393, 10394, 9880, 9879, 9878, 6096, 9530, 6095,
          9531, 9533, 9532, 5072, 10278, 10279, 9488, 6064, 9489, 6027, 7360, 
         9950, 8155, 6063, 9487, 6040, 7535, 6041, 7381, 6032, 9459, 9461, 
         9449, 9455, 9453, 5026, 8854, 8858, 8811, 8870, 8864, 5508, 6842, 
         6856, 6716, 10674, 10634, 10594, 10691, 10731, 6309, 6916, 6902, 
         5250, 8930, 8944, 8893, 8923, 8920, 5038, 9368, 9371, 9357, 9378, 
         9376, 10145, 10144, 9268, 9481, 10259, 6051, 9483, 6050, 9718, 6219, 
         8220, 8222, 7421, 6077, 9515, 6079, 9512, 9514, 9513, 5106, 10322, 
         10323, 9592, 10491, 6128, 10461, 6129, 9886, 9887, 9888, 10321, 
         10320, 5008, 6231, 10397, 6232, 7475, 7474, 5204, 10060, 10061, 
         10057, 10059, 10058, 5049, 7058, 5050, 10433, 6204, 7340, 7339, 5205,
          10443, 6132, 5898, 9299, 9301, 9300, 5896, 10157, 5897, 9298, 10117,
          9167, 5991, 9409, 5859, 8015, 5860, 9273, 6156, 9608, 7184, 7185, 
         6023, 9434, 9436, 9435, 5045, 10288, 10289, 9523, 10115, 5784, 10116,
          5785, 6769, 6768, 6795, 7496, 7497, 6162, 9745, 6254, 9744, 10402, 
         10401, 5654, 9758, 9759, 9757, 6261, 9756, 6262, 7066, 7065, 5152, 
         10292, 10293, 9525, 6088, 7438, 7437, 8256, 8255, 7079, 5757, 7257, 
         5756, 10191, 5927, 10104, 10105, 7202}],
        RowBox[{"-", "0.27`"}]],
       Annotation[#, -0.27, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5711, 8344, 5262, 7614, 7616, 7617, 9771, 10085, 10086, 9770,
          10412, 9769, 5276, 7636, 5277, 8381, 5720, 8419, 5288, 7668, 5289, 
         8420, 9098, 9097, 6502, 6503, 5735, 9113, 5734, 10098, 4928, 4841, 
         9317, 5908, 9316, 5909, 7122, 7121, 7125, 7126, 5911, 9889, 9890, 
         9891, 7242, 5009, 7965, 7243, 5910, 7550, 6338, 10348, 6165, 10153, 
         10154, 9284, 5866, 9281, 9283, 9282, 6431, 9342, 9343, 7573, 7572, 
         6521, 5763, 6323, 10455, 4942, 4857, 6523, 10457, 6524, 5779, 6327, 
         5778, 7098, 7262, 7261, 10377, 9694, 9695, 10230, 10229, 6010, 9424, 
         10196, 10195, 6194, 10359, 9662, 8008, 5966, 9348, 5793, 7585, 5794, 
         9175, 5377, 7430, 7431, 6333, 4961, 4879, 6544, 9841, 9840, 7594, 
         5810, 7116, 7115, 9200, 9201, 8663, 5401, 7870, 5402, 8664, 5826, 
         8701, 5416, 7896, 5417, 9235, 9236, 9234, 9855, 8740, 5425, 7926, 
         7928, 7929, 9863}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8232, 5635, 8999, 5923, 9333, 5924, 9334, 5551, 9332, 5922, 
         9330, 5921, 9331, 6829, 8157, 8156, 8154, 6065, 9492, 8081, 8082, 
         7371, 8083, 7372, 6043, 9448, 6042, 9654, 9458, 9907, 5025, 8853, 
         8857, 8810, 8869, 8863, 5507, 6841, 6855, 6715, 10673, 10633, 10593, 
         10690, 10730, 6308, 6915, 6901, 5249, 8929, 8943, 8892, 8922, 8919, 
         5037, 9921, 9370, 9375, 5975, 9356, 5977, 9484, 6056, 9701, 6055, 
         6405, 9482, 6404, 9511, 6078, 8221, 8223, 8224, 6918, 10203, 5986, 
         9399, 5987, 9400, 5586, 9406, 5989, 9405, 5988, 9004, 5652, 8248, 
         9037, 10474, 5144, 9970, 5143, 9969, 9968, 10054, 10053, 10344, 6158,
          9485, 6060, 8150, 9946, 7333, 5990, 9408, 8013, 8014, 7327, 8017, 
         8016, 9407, 10207, 10206, 10205, 8064, 9943, 8063, 6022, 9433, 5526, 
         8787, 8792, 8791, 5142, 7107, 5141, 9967, 8241, 9522, 9521, 9606, 
         9153, 9154, 9152, 9740, 9739, 9990, 5210, 10445, 9006, 10444, 9007, 
         8783, 5655, 9614, 6167, 9613, 6166, 7217, 5879, 7258, 9625, 6175, 
         9624, 6176, 9626, 5928, 6366, 6365, 7256, 5926, 7253, 8065, 9437, 
         6028, 10252, 10251, 8264, 5165, 10003, 10004, 10000, 10002, 10001, 
         10052, 5132, 8233, 8232}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4908, 4982, 7925, 7924, 8737, 8736, 4901, 4976, 7897, 7895, 
         5415, 8700, 9847, 7872, 7871, 7869, 5400, 9197, 5812, 9196, 5811, 
         8635, 5389, 7845, 5388, 8634, 9184, 9183, 6538, 6539, 5802, 7586, 
         9831, 9832, 6537, 4873, 4955, 10194, 6332, 7316, 7315, 5362, 6531, 
         7577, 6328, 6326, 7099, 5350, 6525, 7574, 6324, 6322, 7080, 5336, 
         6522, 7571, 6321, 6320, 7198, 7199, 6516, 10152, 6515, 4846, 4933, 
         7074, 5743, 7241, 5744, 9314, 9315, 9313, 5907, 10189, 9114, 9115, 
         8456, 5303, 7693, 5302, 8455, 5726, 9095, 5727, 9096, 7669, 7667, 
         5287, 8418, 9788, 7638, 7637, 7635, 8380, 8379, 4820, 4913, 7613, 
         7612, 8341, 8340, 9057}],
        RowBox[{"-", "0.81`"}]],
       Annotation[#, -0.81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9465, 9463, 10256, 10255, 4861, 9605, 6150, 9604, 6151, 7255,
          7254, 5768, 7215, 7216, 6350, 4994, 7218, 4995, 8785, 8786, 8784, 
         5515, 9035, 9036, 8881, 5692, 9034, 5693, 9001, 5650, 8948, 9003, 
         9002, 5516, 10017, 10018, 9882, 9881, 5005, 7328, 5006, 10204, 6362, 
         7335, 7334, 5984, 7331, 7332, 6240, 9732, 6239, 10399, 7352, 4949, 
         7784, 6164, 7484, 7483, 5211, 8841, 8842, 8839, 9924, 9923, 5044, 
         9925, 8012, 9404, 9403, 5580, 6949, 6406, 6407, 7425, 7424, 5103, 
         7404, 8145, 8144, 7397, 6213, 7401, 7399, 5976, 9373, 9374, 10199, 
         10200, 10198, 9920, 8925, 9390, 5578, 8891, 8942, 8928, 5248, 6900, 
         6914, 6307, 10729, 10689, 10592, 10632, 10672, 6714, 6854, 6840, 
         5506, 8862, 8868, 8809, 5559, 9649, 8856, 9906, 9457, 9653, 9651, 
         6045, 9501, 9502, 8085, 9500, 5076, 7370, 5075, 9490, 9491, 6403, 
         6401, 6928, 5554, 9337, 9338, 7971, 9897, 5016, 8848, 8849, 8847, 
         8851, 8850, 5133, 9464, 9465}],
        RowBox[{"-", "0.81`"}]],
       Annotation[#, -0.81, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4819, 8338, 8339, 7610, 8343, 8342, 9058, 6491, 6492, 5718, 
         9079, 10091, 10090, 4917, 4829, 8414, 8415, 7665, 7666, 4922, 4834, 
         8453, 8454, 7692, 7694, 7695, 9802, 7560, 9112, 9111, 5313, 7718, 
         5314, 8481, 5745, 8507, 5323, 7740, 8509, 8508, 9137, 8532, 8533, 
         7759, 8535, 8534, 9145, 8557, 8558, 7779, 8560, 8559, 9162, 8583, 
         8584, 7805, 5363, 8585, 5792, 8609, 5375, 7825, 5376, 9181, 9182, 
         7587, 9833, 8633, 5387, 7844, 7846, 4965, 4887, 8660, 8661, 7867, 
         7868, 4971, 4894, 6554, 4900, 9853, 7600, 5832, 6556, 6555, 9233, 
         8734, 8735, 7921, 8739, 8738, 9251}],
        RowBox[{"-", "1.08`"}]],
       Annotation[#, -1.08, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9711, 7400, 10197, 10280, 10282, 10281, 9385, 10201, 9383, 
         5979, 8213, 5981, 9389, 5577, 8890, 8941, 8927, 5247, 6899, 6913, 
         6306, 10728, 10688, 10591, 10631, 10671, 6713, 6853, 6839, 5505, 
         8861, 8867, 8808, 5558, 9648, 6184, 8180, 6182, 7384, 9652, 6044, 
         9503, 6072, 8084, 6070, 9499, 6564, 6927, 5589, 6402, 5590, 6828, 
         6827, 9335, 9336, 8852, 5555, 8091, 9519, 9520, 6085, 8087, 8086, 
         7387, 6047, 7391, 6046, 9655, 9656, 9150, 10109, 9151, 9658, 9657, 
         9659, 7302, 5880, 10155, 9293, 9467, 9466, 5881, 7219, 6764, 10435, 
         6765, 5564, 10028, 5563, 10478, 9916, 9917, 8949, 5583, 8947, 5584, 
         6767, 6766, 7500, 6170, 7329, 5985, 7406, 6382, 9685, 9686, 9397, 
         10202, 9398, 9688, 9687, 6379, 7355, 6020, 7354, 6136, 7482, 6137, 
         8062, 8061, 8057, 5550, 10021, 8840, 9402, 9401, 6919, 6920, 5628, 
         6408, 5627, 6947, 6626, 7398, 6052, 7529, 6053, 9711}],
        RowBox[{"-", "1.08`"}]],
       Annotation[#, -1.08, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5709, 8337, 5261, 7609, 7611, 9055, 9056, 9054, 5710, 8377, 
         5274, 7632, 5275, 8378, 5719, 8413, 5286, 7662, 8417, 8416, 9094, 
         6500, 6501, 5732, 9110, 10097, 10096, 4927, 4840, 8478, 8479, 7717, 
         7719, 4932, 4845, 8503, 8504, 7739, 7741, 7742, 9816, 8529, 5335, 
         7758, 7760, 7761, 9818, 8554, 5349, 7778, 7780, 7781, 9823, 8580, 
         5361, 7804, 7806, 4954, 4872, 8606, 8607, 7824, 7826, 4960, 4878, 
         6541, 4886, 9838, 7592, 5809, 6543, 6542, 9195, 8658, 8659, 7864, 
         5399, 8662, 5825, 8698, 5413, 7893, 5414, 8699, 5833, 9230, 9232, 
         9231, 5424, 7920, 7922, 7923, 9862}],
        RowBox[{"-", "1.35`"}]],
       Annotation[#, -1.35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7353, 6021, 6380, 5041, 7524, 5043, 6383, 6057, 7330, 8148, 
         8149, 6486, 5104, 8147, 8146, 8191, 8190, 5118, 8188, 8189, 8100, 
         9468, 10436, 5082, 9469, 9470, 6210, 9699, 6209, 10378, 7392, 5958, 
         9660, 9661, 8001, 8002, 5031, 7516, 7385, 7386, 6048, 7388, 8088, 
         8089, 6759, 9290, 9944, 9291, 8090, 8159, 8158, 5109, 9951, 6565, 
         5439, 6929, 5438, 7416, 6071, 6567, 8185, 8187, 7383, 9645, 6181, 
         8179, 6183, 9647, 5557, 8807, 8866, 8860, 5504, 6838, 6852, 6712, 
         10670, 10630, 10590, 10687, 10727, 6305, 6912, 6898, 5246, 8926, 
         8940, 8889, 5576, 9388, 5980, 8212, 5978, 9384, 9381, 9507, 6074, 
         9714, 6218, 9712, 6217, 9713, 7418, 6054, 7402, 5462, 6948, 5463, 
         6627, 8227, 5128, 8225, 8226, 8058, 9942, 5070, 6790, 8060, 8059, 
         7353}],
        RowBox[{"-", "1.35`"}]],
       Annotation[#, -1.35, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4907, 4981, 7919, 7918, 8731, 8730, 4899, 4975, 7894, 7892, 
         5412, 10012, 8695, 9846, 7866, 7865, 7863, 5398, 8657, 9839, 7593, 
         9194, 9193, 5386, 7842, 5385, 8632, 5801, 8608, 5374, 7822, 5373, 
         8605, 9173, 9172, 8581, 8582, 7801, 8579, 8578, 9161, 8555, 8556, 
         7775, 8553, 8552, 9144, 8530, 8531, 7755, 8528, 8527, 9136, 8505, 
         8506, 7736, 8502, 8501, 9127, 9128, 8480, 5312, 7714, 5311, 8477, 
         5733, 8452, 5301, 7690, 5300, 9092, 9093, 7558, 9793, 7664, 7663, 
         7661, 5285, 8412, 9787, 7634, 7633, 7631, 8374, 8373, 4818, 4912, 
         7608, 7607, 8334, 8333, 9051}],
        RowBox[{"-", "1.62`"}]],
       Annotation[#, -1.62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5579, 8939, 5245, 6897, 6911, 6304, 10726, 10686, 10589, 
         10629, 10669, 6711, 6851, 6837, 5503, 8879, 5560, 8806, 5556, 9646, 
         9650, 8178, 9644, 9643, 7382, 5117, 8186, 6566, 7415, 5440, 6935, 
         6343, 6344, 6066, 7950, 9292, 7948, 6756, 5878, 7214, 5512, 7389, 
         7390, 6372, 5030, 6963, 6964, 6371, 6370, 7303, 8782, 8781, 6860, 
         5562, 7180, 5561, 8880, 6859, 5607, 6922, 8946, 5581, 6313, 5582, 
         6923, 5254, 7405, 5252, 6481, 6987, 6986, 5042, 6381, 7357, 7356, 
         5525, 6822, 5549, 6785, 5548, 8838, 6821, 5626, 6361, 6359, 6940, 
         8763, 8762, 7403, 6075, 9715, 9716, 8210, 9957, 5124, 9506, 9380, 
         9382, 8211, 9387, 9386, 5575, 8888, 5579}],
        RowBox[{"-", "1.62`"}]],
       Annotation[#, -1.62, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4817, 8331, 8332, 7604, 8336, 8335, 10084, 9052, 10492, 9053,
          8372, 8376, 10493, 8375, 9078, 6496, 7557, 7556, 7555, 5724, 6318, 
         4921, 4833, 8448, 8449, 7689, 7691, 4926, 4839, 8473, 8474, 7713, 
         7715, 7716, 9807, 8498, 5322, 7735, 7737, 7738, 9815, 8524, 10006, 
         5334, 7754, 7756, 7757, 9817, 8550, 10009, 5348, 7774, 7776, 7777, 
         9822, 8575, 5360, 7800, 7802, 7803, 9825, 8602, 5372, 7821, 7823, 
         4959, 4877, 8629, 8630, 7841, 7843, 4964, 4885, 6549, 6550, 5823, 
         9214, 5822, 9215, 6551, 10126, 9216, 9217, 8694, 8697, 9851, 8696, 
         10471, 9229, 8728, 10423, 8729, 7915, 8733, 8732, 9250}],
        RowBox[{"-", "1.8900000000000001`"}]],
       Annotation[#, -1.8900000000000001`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6788, 5524, 7232, 5522, 6823, 6784, 6820, 6819, 6946, 5004, 
         6360, 5616, 9508, 9509, 8207, 8209, 5123, 6622, 5126, 9961, 8217, 
         8997, 8992, 8140, 6477, 8938, 5244, 6896, 6910, 6303, 10725, 10685, 
         10588, 10628, 10668, 6710, 6850, 6836, 5502, 8878, 6750, 8096, 8968, 
         8970, 8177, 8184, 5116, 6578, 5114, 8173, 6568, 5601, 6345, 4990, 
         9493, 4991, 7949, 6755, 7213, 5511, 6958, 5514, 6763, 8234, 6753, 
         5510, 7091, 7092, 5854, 7181, 5853, 7178, 6858, 6936, 6921, 4867, 
         6979, 6312, 6982, 6981, 5253, 6485, 8239, 6788}],
        RowBox[{"-", "1.8900000000000001`"}]],
       Annotation[#, -1.8900000000000001`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5707, 8330, 5260, 7603, 7605, 7606, 9768, 10083, 5708, 10484,
          9767, 5272, 7629, 5273, 8371, 5717, 8410, 5283, 7658, 5284, 8411, 
         5725, 8447, 5299, 7686, 8451, 8450, 9109, 8471, 8472, 7710, 8476, 
         8475, 9126, 8496, 8497, 7732, 8500, 8499, 10103, 9134, 10496, 9135, 
         8523, 8526, 10497, 8525, 10106, 9142, 9143, 8549, 8551, 9820, 10470, 
         10498, 10469, 9160, 8573, 10419, 8574, 7797, 8577, 8576, 9171, 8600, 
         8601, 7818, 8604, 8603, 9180, 8627, 8628, 7838, 5384, 8631, 5808, 
         8655, 5396, 7861, 5397, 8656, 5824, 8693, 5410, 7890, 5411, 9228, 
         5831, 9227, 9852, 8727, 5423, 7914, 7916, 7917, 9861}],
        RowBox[{"-", "2.16`"}]],
       Annotation[#, -2.16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6787, 5523, 7233, 5890, 6783, 7959, 5003, 9580, 5002, 6358, 
         5618, 6625, 8208, 6621, 5125, 9960, 8216, 8996, 8991, 8139, 6476, 
         8937, 5243, 6895, 6909, 6302, 10724, 10684, 10587, 10627, 10667, 
         6709, 6849, 6835, 5501, 8877, 6749, 8095, 8967, 8969, 8176, 8183, 
         5115, 6577, 8172, 6579, 5600, 6348, 4993, 7050, 6954, 6955, 6758, 
         5639, 6959, 5513, 6762, 8235, 5135, 6752, 7088, 6754, 5769, 7179, 
         10140, 10141, 9263, 5855, 9265, 7576, 6980, 5644, 6311, 5645, 6484, 
         8236, 6483, 5139, 8240, 6787}],
        RowBox[{"-", "2.16`"}]],
       Annotation[#, -2.16, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4906, 4980, 9877, 9876, 10148, 10147, 5864, 10218, 10219, 
         10215, 10217, 10216, 4898, 10422, 10421, 10420, 7891, 7889, 8690, 
         8689, 4893, 4970, 7862, 7860, 5395, 10011, 8652, 9837, 7840, 7839, 
         7837, 5383, 10010, 8624, 9830, 7820, 7819, 7817, 5371, 8599, 9824, 
         7799, 7798, 7796, 5359, 8572, 9821, 9157, 9159, 9158, 5347, 10008, 
         5346, 10477, 9141, 5762, 8522, 5333, 10005, 5332, 9812, 10418, 9813, 
         10102, 10101, 9814, 7734, 7733, 7731, 5321, 8495, 9805, 7712, 7711, 
         7709, 5310, 8470, 9801, 7688, 7687, 7685, 5298, 9999, 8444, 9792, 
         7660, 7659, 7657, 8407, 8406, 4828, 4916, 7630, 7628, 8368, 8367, 
         4816, 4911, 9866, 9865, 10136, 10135, 5843, 10174, 10175, 10171, 
         10173, 10172, 10226}],
        RowBox[{"-", "2.43`"}]],
       Annotation[#, -2.43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5606, 8175, 8182, 6581, 5445, 6934, 5599, 6347, 4992, 7051, 
         5679, 6957, 7053, 5637, 6757, 5638, 6761, 9026, 6760, 5134, 6751, 
         7087, 7476, 7090, 7479, 7478, 5770, 9264, 7095, 5771, 6984, 5646, 
         9032, 9033, 8238, 9031, 5137, 6482, 5138, 6786, 9584, 6789, 5889, 
         6782, 7958, 9582, 7961, 6120, 9581, 5001, 6357, 5617, 6942, 5461, 
         6624, 9959, 8215, 5623, 8995, 8138, 6475, 8936, 5242, 6894, 6908, 
         6301, 10723, 10683, 10586, 10626, 10666, 6708, 6848, 6834, 5500, 
         8876, 6748, 8094, 8973, 5606}],
        RowBox[{"-", "2.43`"}]],
       Annotation[#, -2.43, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5208, 9988, 9989, 9963, 9964, 5129, 7426, 6171, 10349, 10351,
          10350, 5903, 9310, 10505, 9309, 7964, 5902, 9308, 10506, 9307, 9049,
          9050, 8366, 8370, 8369, 10089, 9076, 9077, 8405, 8409, 8408, 10095, 
         9090, 9091, 8443, 8446, 8445, 9108, 6508, 6509, 5742, 7567, 9806}],
        RowBox[{"-", "2.7`"}]],
       Annotation[#, -2.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5799, 9179, 5800, 6536, 6535, 10120, 9177, 9178, 8623, 8626, 
         8625, 10121, 9191, 9192, 8651, 8654, 8653, 10125, 9212, 9213, 8688, 
         8692, 8691, 9225, 9226, 5999, 8019, 8020, 8021, 6000, 9692, 9693, 
         9689, 9691, 9690, 9721, 5149, 10439, 6222, 6221, 9738, 6244, 9736, 
         6243, 9737, 7527}],
        RowBox[{"-", "2.7`"}]],
       Annotation[#, -2.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8174, 5605, 8972, 8093, 6747, 8875, 5499, 6833, 6847, 6707, 
         10665, 10625, 10585, 10682, 10722, 6300, 6907, 6893, 5241, 8935, 
         6474, 8137, 8994, 5622, 8214, 9958, 6623, 5460, 6941, 6355, 6356, 
         6119, 7960, 6121, 9583, 5891, 9588, 9589, 9585, 9587, 9586, 5140, 
         9030, 5689, 8237, 5691, 6985, 6983, 7096, 7093, 7094, 6134, 7089, 
         6133, 7477, 5136, 10063, 10064, 9027, 9029, 9028, 5640, 7052, 5680, 
         6956, 5678, 6349, 6346, 6933, 5444, 6580, 8181, 8174}],
        RowBox[{"-", "2.7`"}]],
       Annotation[#, -2.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6972, 5681, 7056, 6413, 7481, 6135, 6978, 6976, 5209, 6993, 
         6994, 5690, 7064, 6415, 7470, 6126, 7001, 8316, 8317, 7236, 8311, 
         8309, 6617, 5459, 7467, 5457, 6614, 5621, 8143, 8993, 8136, 6473, 
         8934, 5240, 6892, 6906, 6299, 10721, 10681, 10584, 10624, 10664, 
         6706, 6846, 6832, 5498, 8874, 6746, 8092, 8971, 8097, 5604, 6574, 
         5443, 7463, 5447, 6587, 8299, 8300, 6962, 8304, 8302, 6972}],
        RowBox[{"-", "2.97`"}]],
       Annotation[#, -2.97, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7055, 6971, 8303, 5192, 6961, 5190, 8301, 6586, 5446, 7462, 
         5442, 6573, 5603, 8966, 5081, 8099, 6745, 8873, 5497, 6831, 6845, 
         6705, 10663, 10623, 10583, 10680, 10720, 6298, 6905, 6891, 5239, 
         8933, 6472, 8142, 5102, 8990, 5620, 6613, 5456, 7466, 5458, 6616, 
         8310, 5195, 7235, 5198, 8318, 7000, 7471, 7469, 6414, 7063, 5649, 
         6995, 8320, 6977, 5643, 7480, 6412, 7054, 7055}],
        RowBox[{"-", "3.24`"}]],
       Annotation[#, -3.24, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{8932, 6471, 8141, 5101, 8989, 5619, 6612, 5455, 7465, 7468, 
         6620, 8315, 6615, 5194, 7234, 5197, 6996, 7311, 6999, 7313, 7312, 
         5648, 6991, 5688, 6969, 5642, 7521, 7523, 6975, 7519, 6970, 5191, 
         6960, 5189, 6582, 8307, 6585, 7464, 7461, 5441, 6572, 5602, 8965, 
         5080, 8098, 6744, 8872, 5496, 6830, 6844, 6704, 10662, 10622, 10582, 
         10679, 10719, 6297, 6904, 6890, 5238, 8932}],
        RowBox[{"-", "3.5100000000000002`"}]],
       Annotation[#, -3.5100000000000002`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{10534, 6743, 6740, 5079, 8964, 6571, 10313, 6576, 6117, 6584,
          8306, 5193, 7305, 7517, 7518, 6974, 6192, 7522, 5641, 6968, 5687, 
         6990, 5647, 7314, 5964, 6998, 7310, 7308, 7307, 5196, 8314, 6619, 
         6125, 6611, 10318, 6609, 8988, 5100, 6470, 10490, 6480, 10547, 6296, 
         10718, 10678, 10581, 10621, 10661, 6703, 10534}],
        RowBox[{"-", "3.7800000000000002`"}]],
       Annotation[#, -3.7800000000000002`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{10533, 6742, 6739, 5078, 8963, 6570, 10312, 6575, 6116, 6583,
          8305, 8308, 7304, 7520, 6190, 6973, 6191, 6967, 9911, 6966, 7062, 
         6989, 9915, 6992, 5963, 6997, 5961, 7309, 7306, 8313, 8312, 6618, 
         6124, 6610, 10317, 6608, 8987, 5099, 6469, 10489, 6479, 10546, 6295, 
         10717, 10677, 10580, 10620, 10660, 6702, 10533}],
        RowBox[{"-", "4.050000000000001`"}]],
       Annotation[#, -4.050000000000001, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{10319, 6123, 10315, 6122, 10316, 6607, 8986, 5098, 6468, 
         10488, 6478, 10545, 6294, 10716, 10676, 10579, 10619, 10659, 6701, 
         10532, 6741, 6738, 5077, 8962, 6569, 10311, 6115, 10310, 6118, 10314,
          5959, 10358, 6193, 9908, 9909, 9910, 6965, 7061, 6988, 9914, 9913, 
         9912, 5962, 10193, 5960, 10319}],
        RowBox[{"-", "4.32`"}]],
       Annotation[#, -4.32, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Epilog->{
    DiskBox[{0, 0}, 1]},
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-3, 3}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33781126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117769980],

Cell["\<\
Construct a bivariate real harmonic function from a complex function:\
\>", "ExampleText",
 CellID->88013180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"z", "^", "2"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"z", "+", 
     RowBox[{"z", "^", "3"}]}], "]"}]}], "+", 
  RowBox[{"Tan", "[", 
   FractionBox["1", "z"], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3563239],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["z", "2"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"z", "+", 
     SuperscriptBox["z", "3"]}], "]"}]}], "+", 
  RowBox[{"Tan", "[", 
   FractionBox["1", "z"], "]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{146, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46842816]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Re", "[", 
   RowBox[{"%", " ", "/.", " ", 
    RowBox[{"z", " ", "->", " ", 
     RowBox[{"x", " ", "+", " ", 
      RowBox[{"I", " ", "y"}]}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->78625012],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"2", " ", "x"}], 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}]], "]"}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     FractionBox[
      RowBox[{"2", " ", "x"}], 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     FractionBox[
      RowBox[{"2", " ", "y"}], 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]], "]"}]}]], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Cosh", "[", 
    RowBox[{"y", "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"], " ", "y"}], "-", 
     SuperscriptBox["y", "3"]}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", " ", "x", " ", 
      SuperscriptBox["y", "2"]}]}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["y", "2"], " ", 
   RowBox[{"Cosh", "[", 
    RowBox[{"y", "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"], " ", "y"}], "-", 
     SuperscriptBox["y", "3"]}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", " ", "x", " ", 
      SuperscriptBox["y", "2"]}]}], "]"}]}], "-", 
  RowBox[{"2", " ", "x", " ", "y", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"x", "+", 
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", " ", "x", " ", 
      SuperscriptBox["y", "2"]}]}], "]"}], " ", 
   RowBox[{"Sinh", "[", 
    RowBox[{"y", "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"], " ", "y"}], "-", 
     SuperscriptBox["y", "3"]}], "]"}]}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{539, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->310115406]
}, Open  ]],

Cell["The real part satisfies Laplace's equation:", "ExampleText",
 CellID->223413258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"%", ",", "x", ",", "x"}], "]"}], "+", 
   RowBox[{"D", "[", 
    RowBox[{"%", ",", "y", ",", "y"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->329072254],

Cell[BoxData["0"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->120543138]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->489321682],

Cell[TextData[{
 "Reconstruct an analytic function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"w", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"u", "(", 
      RowBox[{"x", ",", "y"}], ")"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"v", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 " from its real part ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->140819199],

Cell[BoxData[
 RowBox[{
  RowBox[{"analyticReconstruct", "[", 
   RowBox[{"u_", ",", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_"}], "}"}], ",", "z_"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{"u", "//.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "->", 
         RowBox[{"z", "/", "2"}]}], ",", 
        RowBox[{"y", "->", 
         RowBox[{"z", "/", 
          RowBox[{"(", 
           RowBox[{"2", "I"}], ")"}]}]}]}], "}"}]}], ")"}]}], "-", 
   RowBox[{"(", 
    RowBox[{"u", "//.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "->", "0"}], ",", 
       RowBox[{"y", "->", "0"}]}], "}"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459401555],

Cell["Example reconstruction:", "ExampleText",
 CellID->477514636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"analyticReconstruct", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"y", "^", "2"}]}], ",", 
      RowBox[{
       RowBox[{"Exp", "[", "x", "]"}], 
       RowBox[{"Cos", "[", "y", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "z"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->559567262],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["z", "2"], ",", 
   SuperscriptBox["\[ExponentialE]", "z"]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->192490741]
}, Open  ]],

Cell["Check the result:", "ExampleText",
 CellID->21819103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexExpand", "[", 
   RowBox[{"Re", "[", 
    RowBox[{"%", "/.", 
     RowBox[{"z", "->", 
      RowBox[{"x", " ", "+", " ", 
       RowBox[{"I", " ", "y"}]}]}]}], "]"}], "]"}], "//", " ", 
  "Simplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->452269852],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "-", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], " ", 
    RowBox[{"Cos", "[", "y", "]"}]}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{125, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->127573557]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30570],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4903660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", 
       RowBox[{"Pi", "/", "5"}]}], "]"}], " ", "x"}], "]"}], ",", 
   RowBox[{"Re", "[", 
    RowBox[{
     RowBox[{"2", "x"}], "+", "I"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52671911],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "5"]], " ", "x"}], "]"}], ",",
    
   RowBox[{"2", " ", 
    RowBox[{"Re", "[", "x", "]"}]}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{136, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37421771]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"x", " ", ">", " ", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->854391326],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox["5"]}], ")"}], " ", "x"}], ",", 
   RowBox[{"2", " ", "x"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{128, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->933710529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Re", "[", "z", "]"}], "]"}], "\[LessEqual]", 
   RowBox[{"Abs", "[", "z", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->493844822],

Cell[BoxData["True"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->613024248]
}, Open  ]],

Cell[TextData[{
 "Prove that the disk ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", 
     RowBox[{"z", "-", "1"}], "\[RightBracketingBar]"}], "\[LessEqual]", 
    "1"}], TraditionalForm]], "InlineMath"],
 " is in the right half-plane:"
}], "ExampleText",
 CellID->105922167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{"z", ",", 
    RowBox[{"Implies", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"z", "-", "1"}], "]"}], "\[LessEqual]", "1"}], ",", 
      RowBox[{
       RowBox[{"Re", "[", "z", "]"}], "\[GreaterEqual]", "0"}]}], "]"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27229109],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->137550619]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->115418655],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 " assumes variables to be real:"
}], "ExampleText",
 CellID->198910264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Re", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], ")"}], "^", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->664802206],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "3"], "-", 
  RowBox[{"3", " ", "x", " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121956288]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Re", "[", 
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->492127507],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cosh", "[", "y", "]"}], " ", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4893499]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " is not assumed real, and the result should be in terms of ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Im",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Im"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->358028740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "z", "]"}], "^", "2"}], ",", "z", ",", 
   RowBox[{"TargetFunctions", "->", 
    RowBox[{"{", 
     RowBox[{"Re", ",", "Im"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->339331525],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Im", "[", "z", "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"Re", "[", "z", "]"}], "2"]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->46478146]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->403265951],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " does not assume variables to be real:"
}], "ExampleText",
 CellID->400906921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Re", "[", 
   RowBox[{"z1", "+", "z2", "+", "z3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142103329],

Cell[BoxData[
 RowBox[{
  RowBox[{"Re", "[", "z1", "]"}], "+", 
  RowBox[{"Re", "[", "z2", "]"}], "+", 
  RowBox[{"Re", "[", "z3", "]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73905218]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Re", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], ")"}], "^", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45843075],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "3"}], " ", 
   RowBox[{"Im", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}], "]"}]}], "+", 
  RowBox[{"Im", "[", 
   SuperscriptBox["y", "3"], "]"}], "+", 
  RowBox[{"Re", "[", 
   SuperscriptBox["x", "3"], "]"}], "-", 
  RowBox[{"3", " ", 
   RowBox[{"Re", "[", 
    RowBox[{"x", " ", 
     SuperscriptBox["y", "2"]}], "]"}]}]}]], "Output",
 ImageSize->{252, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->365844607]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->159651740],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " to describe regions in the complex plane: "
}], "ExampleText",
 CellID->90137774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"z", "=", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}]}], "}"}], ",", 
      RowBox[{"RegionPlot", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"PlotPoints", "\[Rule]", "40"}]}], "]"}]}], "]"}], "&"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "I"}], ")"}], "z"}], "-", "1"}], "]"}], "<", 
      "0"}], ",", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"z", "^", "2"}], "]"}], "<", "1"}], ",", 
     RowBox[{"0", "<", 
      RowBox[{"Re", "[", 
       FractionBox[
        RowBox[{"z", "+", "1"}], 
        RowBox[{"z", "-", "1"}]], "]"}], "<", "2"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24344574],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{577, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337369601]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->181906380],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can solve equations and inequalities involving ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->122874354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", 
     RowBox[{"z", "^", "2"}], "]"}], ">", "1"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4494620],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Re", "[", "z", "]"}], "<", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox[
         RowBox[{"Re", "[", "z", "]"}], "2"]}]]}], "<", 
     RowBox[{"Im", "[", "z", "]"}], "<", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox[
        RowBox[{"Re", "[", "z", "]"}], "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Re", "[", "z", "]"}], ">", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox[
         RowBox[{"Re", "[", "z", "]"}], "2"]}]]}], "<", 
     RowBox[{"Im", "[", "z", "]"}], "<", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox[
        RowBox[{"Re", "[", "z", "]"}], "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{363, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238124409]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"z", "^", "2"}], "]"}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"1", "+", "z"}], "]"}], "^", "2"}], "\[Equal]", 
     RowBox[{
      RowBox[{"Abs", "[", "z", "]"}], "^", "2"}]}]}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->479600724],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Equal]", 
   RowBox[{"1", "+", 
    SqrtBox["3"], "-", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["3"]}], ")"}]}]}]]}]}]}], "||", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"1", "+", 
    SqrtBox["3"], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["3"]}], ")"}]}]}]]}]}]}]}]], "Output",
 ImageSize->{420, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->397766572]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->438032041],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " you can get sample points of regions:"
}], "ExampleText",
 CellID->245967015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", 
     RowBox[{"z", "^", "2"}], "]"}], ">", "1"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73755777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"z", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "19"}], "+", 
     FractionBox[
      RowBox[{"10", " ", "\[ImaginaryI]"}], "3"]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{119, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27001707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->288777898],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->300470926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "s"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"Re", "[", "s", "]"}], "<", 
     RowBox[{"-", "1"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->433141732],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   RowBox[{"1", "+", "s"}]]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{43, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144215068]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"x", "^", "s"}]}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"Re", "[", "s", "]"}], ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->230624002],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->567006515]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " often generates conditions in terms of ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->139456824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "s"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21592919],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "s", "]"}], "<", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"1", "+", "s"}]]}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     SuperscriptBox["x", "s"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "s", "]"}], "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}]}]}], "]"}]}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{484, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->219566087]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4371],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " can stay unevaluated for numeric arguments:"
}], "ExampleText",
 CellID->48071648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Log", "[", 
     RowBox[{"2", " ", "+", " ", "I"}], "]"}], "]"}], ",", 
   RowBox[{"Re", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", "I"}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299511344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "+", "\[ImaginaryI]"}], "]"}], "]"}], ",", 
   RowBox[{"Re", "[", 
    SqrtBox[
     RowBox[{"1", "+", "\[ImaginaryI]"}]], "]"}]}], "}"}]], "Output",
 ImageSize->{193, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11795865]
}, Open  ]],

Cell["Additional transformation may simplify it:", "ExampleText",
 CellID->93855894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->113740548],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", "5", "]"}], "2"], ",", 
   FractionBox[
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox["2"]}]], 
    SuperscriptBox["2", 
     RowBox[{"3", "/", "4"}]]]}], "}"}]], "Output",
 ImageSize->{142, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->260964116]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18395],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " to plot a 3D projection of the Riemann surface of ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->775549977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", " ", 
      RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], ",", 
     RowBox[{"r", " ", 
      RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", "r", "]"}], 
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", 
         RowBox[{"\[CurlyPhi]", "/", "2"}]}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[CurlyPhi]", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "40"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->422351592],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 255},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->136825218]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6286],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Im",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Im"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Complex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complex"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20570]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7506],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexNumbers"]], "Tutorials",
 CellID->32125],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->11403]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->16803],

Cell[TextData[{
 ButtonBox["Demonstrations with Re",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Re"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/RealPart.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ComplexComponents/Re/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->692031134],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->436160152],

Cell[TextData[ButtonBox["Functions of Complex Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsOfComplexVariables"]], "MoreAbout",
 CellID->130698071],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->423576427]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Re - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 22.3790778}", "context" -> "System`", 
    "keywords" -> {
     "complex number", "complex part", "Re", "real", "real part", 
      "\\Re (TeX)"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Re[z] gives the real part of the complex number z. ", "synonyms" -> {}, 
    "title" -> "Re", "type" -> "Symbol", "uri" -> "ref/Re"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5051, 161, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->580864602]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 444892, 8563}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2620, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3243, 86, 39, 1, 70, "ObjectName",
 CellID->5997],
Cell[3285, 89, 548, 18, 70, "Usage",
 CellID->16765]
}, Open  ]],
Cell[CellGroupData[{
Cell[3870, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4348, 129, 124, 4, 70, "Notes",
 CellID->203856663],
Cell[4475, 135, 347, 12, 70, "Notes",
 CellID->13888],
Cell[4825, 149, 189, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5051, 161, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->580864602],
Cell[CellGroupData[{
Cell[5436, 175, 147, 5, 70, "ExampleSection",
 CellID->51967432],
Cell[5586, 182, 81, 1, 70, "ExampleText",
 CellID->23484566],
Cell[CellGroupData[{
Cell[5692, 187, 139, 5, 28, "Input",
 CellID->66860157],
Cell[5834, 194, 204, 7, 36, "Output",
 CellID->8204638]
}, Open  ]],
Cell[6053, 204, 124, 3, 70, "ExampleDelimiter",
 CellID->27808528],
Cell[6180, 209, 107, 3, 70, "ExampleText",
 CellID->245215821],
Cell[CellGroupData[{
Cell[6312, 216, 470, 16, 28, "Input",
 CellID->16381840],
Cell[6785, 234, 20465, 340, 173, "Output",
 Evaluatable->False,
 CellID->309115429]
}, Open  ]],
Cell[27265, 577, 123, 3, 70, "ExampleDelimiter",
 CellID->4084850],
Cell[27391, 582, 215, 8, 70, "ExampleText",
 CellID->696243917],
Cell[CellGroupData[{
Cell[27631, 594, 634, 22, 28, "Input",
 CellID->10620312],
Cell[28268, 618, 4438, 77, 204, "Output",
 Evaluatable->False,
 CellID->115579265]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32755, 701, 216, 7, 70, "ExampleSection",
 CellID->22946],
Cell[32974, 710, 90, 3, 70, "ExampleText",
 CellID->431660366],
Cell[CellGroupData[{
Cell[33089, 717, 389, 13, 70, "Input",
 CellID->54504803],
Cell[33481, 732, 282, 9, 36, "Output",
 CellID->36676088]
}, Open  ]],
Cell[33778, 744, 125, 3, 70, "ExampleDelimiter",
 CellID->724429714],
Cell[33906, 749, 64, 1, 70, "ExampleText",
 CellID->350406651],
Cell[CellGroupData[{
Cell[33995, 754, 254, 10, 70, "Input",
 CellID->188161188],
Cell[34252, 766, 196, 6, 51, "Output",
 CellID->145846129]
}, Open  ]],
Cell[34463, 775, 61, 1, 70, "ExampleText",
 CellID->189932689],
Cell[CellGroupData[{
Cell[34549, 780, 289, 11, 70, "Input",
 CellID->49031758],
Cell[34841, 793, 645, 21, 39, "Output",
 CellID->73160594]
}, Open  ]],
Cell[35501, 817, 65, 1, 70, "ExampleText",
 CellID->16112768],
Cell[CellGroupData[{
Cell[35591, 822, 146, 5, 70, "Input",
 CellID->541573647],
Cell[35740, 829, 220, 7, 36, "Output",
 CellID->651901333]
}, Open  ]],
Cell[35975, 839, 125, 3, 70, "ExampleDelimiter",
 CellID->617081273],
Cell[36103, 844, 198, 7, 70, "ExampleText",
 CellID->641124220],
Cell[CellGroupData[{
Cell[36326, 855, 294, 11, 70, "Input",
 CellID->565804157],
Cell[36623, 868, 280, 10, 36, "Output",
 CellID->446031093]
}, Open  ]],
Cell[CellGroupData[{
Cell[36940, 883, 349, 12, 70, "Input",
 CellID->37446706],
Cell[37292, 897, 453, 16, 36, "Output",
 CellID->713068029]
}, Open  ]],
Cell[CellGroupData[{
Cell[37782, 918, 102, 3, 70, "Input",
 CellID->715927032],
Cell[37887, 923, 235, 7, 36, "Output",
 CellID->222616360]
}, Open  ]],
Cell[38137, 933, 123, 3, 70, "ExampleDelimiter",
 CellID->3187215],
Cell[38263, 938, 214, 8, 70, "ExampleText",
 CellID->404036938],
Cell[CellGroupData[{
Cell[38502, 950, 363, 11, 70, "Input",
 CellID->38527238],
Cell[38868, 963, 354, 11, 36, "Output",
 CellID->16884555]
}, Open  ]],
Cell[39237, 977, 125, 3, 70, "ExampleDelimiter",
 CellID->625440949],
Cell[39365, 982, 201, 7, 70, "ExampleText",
 CellID->2419991],
Cell[CellGroupData[{
Cell[39591, 993, 136, 4, 70, "Input",
 CellID->622249986],
Cell[39730, 999, 232, 7, 50, "Output",
 CellID->258357279]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40011, 1012, 239, 7, 70, "ExampleSection",
 CellID->32727],
Cell[40253, 1021, 83, 1, 70, "ExampleText",
 CellID->56709610],
Cell[CellGroupData[{
Cell[40361, 1026, 348, 10, 70, "Input",
 CellID->250479245],
Cell[40712, 1038, 326, 11, 36, "Output",
 CellID->541528937]
}, Open  ]],
Cell[41053, 1052, 93, 1, 70, "ExampleText",
 CellID->67897136],
Cell[CellGroupData[{
Cell[41171, 1057, 190, 6, 70, "Input",
 CellID->787875748],
Cell[41364, 1065, 161, 5, 36, "Output",
 CellID->849618516]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41574, 1076, 222, 7, 70, "ExampleSection",
 CellID->8865],
Cell[41799, 1085, 130, 4, 70, "ExampleText",
 CellID->509708943],
Cell[CellGroupData[{
Cell[41954, 1093, 730, 25, 70, "Input",
 CellID->181137286],
Cell[42687, 1120, 327455, 5450, 70, "Output",
 CellID->33781126]
}, Open  ]],
Cell[370157, 6573, 125, 3, 70, "ExampleDelimiter",
 CellID->117769980],
Cell[370285, 6578, 119, 3, 70, "ExampleText",
 CellID->88013180],
Cell[CellGroupData[{
Cell[370429, 6585, 271, 10, 70, "Input",
 CellID->3563239],
Cell[370703, 6597, 411, 15, 51, "Output",
 CellID->46842816]
}, Open  ]],
Cell[CellGroupData[{
Cell[371151, 6617, 271, 8, 70, "Input",
 CellID->78625012],
Cell[371425, 6627, 1907, 63, 97, "Output",
 CellID->310115406]
}, Open  ]],
Cell[373347, 6693, 86, 1, 70, "ExampleText",
 CellID->223413258],
Cell[CellGroupData[{
Cell[373458, 6698, 251, 8, 70, "Input",
 CellID->329072254],
Cell[373712, 6708, 206, 7, 36, "Output",
 CellID->120543138]
}, Open  ]],
Cell[373933, 6718, 125, 3, 70, "ExampleDelimiter",
 CellID->489321682],
Cell[374061, 6723, 568, 21, 70, "ExampleText",
 CellID->140819199],
Cell[374632, 6746, 744, 26, 70, "Input",
 CellID->459401555],
Cell[375379, 6774, 66, 1, 70, "ExampleText",
 CellID->477514636],
Cell[CellGroupData[{
Cell[375470, 6779, 460, 16, 70, "Input",
 CellID->559567262],
Cell[375933, 6797, 315, 11, 39, "Output",
 CellID->192490741]
}, Open  ]],
Cell[376263, 6811, 59, 1, 70, "ExampleText",
 CellID->21819103],
Cell[CellGroupData[{
Cell[376347, 6816, 296, 10, 70, "Input",
 CellID->452269852],
Cell[376646, 6828, 424, 15, 39, "Output",
 CellID->127573557]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[377119, 6849, 233, 7, 70, "ExampleSection",
 CellID->30570],
Cell[377355, 6858, 470, 18, 70, "ExampleText",
 CellID->4903660],
Cell[CellGroupData[{
Cell[377850, 6880, 334, 12, 70, "Input",
 CellID->52671911],
Cell[378187, 6894, 475, 17, 49, "Output",
 CellID->37421771]
}, Open  ]],
Cell[CellGroupData[{
Cell[378699, 6916, 166, 5, 70, "Input",
 CellID->854391326],
Cell[378868, 6923, 400, 15, 51, "Output",
 CellID->933710529]
}, Open  ]],
Cell[CellGroupData[{
Cell[379305, 6943, 235, 7, 70, "Input",
 CellID->493844822],
Cell[379543, 6952, 209, 7, 36, "Output",
 CellID->613024248]
}, Open  ]],
Cell[379767, 6962, 305, 10, 70, "ExampleText",
 CellID->105922167],
Cell[CellGroupData[{
Cell[380097, 6976, 407, 13, 70, "Input",
 CellID->27229109],
Cell[380507, 6991, 161, 5, 36, "Output",
 CellID->137550619]
}, Open  ]],
Cell[380683, 6999, 125, 3, 70, "ExampleDelimiter",
 CellID->115418655],
Cell[380811, 7004, 217, 7, 70, "ExampleText",
 CellID->198910264],
Cell[CellGroupData[{
Cell[381053, 7015, 240, 8, 70, "Input",
 CellID->664802206],
Cell[381296, 7025, 310, 11, 36, "Output",
 CellID->121956288]
}, Open  ]],
Cell[CellGroupData[{
Cell[381643, 7041, 220, 7, 70, "Input",
 CellID->492127507],
Cell[381866, 7050, 239, 8, 36, "Output",
 CellID->4893499]
}, Open  ]],
Cell[382120, 7061, 414, 16, 70, "ExampleText",
 CellID->358028740],
Cell[CellGroupData[{
Cell[382559, 7081, 290, 9, 70, "Input",
 CellID->339331525],
Cell[382852, 7092, 287, 10, 36, "Output",
 CellID->46478146]
}, Open  ]],
Cell[383154, 7105, 125, 3, 70, "ExampleDelimiter",
 CellID->403265951],
Cell[383282, 7110, 227, 7, 70, "ExampleText",
 CellID->400906921],
Cell[CellGroupData[{
Cell[383534, 7121, 176, 5, 70, "Input",
 CellID->142103329],
Cell[383713, 7128, 328, 11, 36, "Output",
 CellID->73905218]
}, Open  ]],
Cell[CellGroupData[{
Cell[384078, 7144, 240, 8, 70, "Input",
 CellID->45843075],
Cell[384321, 7154, 538, 19, 39, "Output",
 CellID->365844607]
}, Open  ]],
Cell[384874, 7176, 125, 3, 70, "ExampleDelimiter",
 CellID->159651740],
Cell[385002, 7181, 216, 8, 70, "ExampleText",
 CellID->90137774],
Cell[CellGroupData[{
Cell[385243, 7193, 1123, 39, 70, "Input",
 CellID->24344574],
Cell[386369, 7234, 8350, 141, 70, "Output",
 Evaluatable->False,
 CellID->337369601]
}, Open  ]],
Cell[394734, 7378, 125, 3, 70, "ExampleDelimiter",
 CellID->181906380],
Cell[394862, 7383, 334, 12, 70, "ExampleText",
 CellID->122874354],
Cell[CellGroupData[{
Cell[395221, 7399, 204, 7, 70, "Input",
 CellID->4494620],
Cell[395428, 7408, 1115, 41, 84, "Output",
 CellID->238124409]
}, Open  ]],
Cell[CellGroupData[{
Cell[396580, 7454, 423, 15, 70, "Input",
 CellID->479600724],
Cell[397006, 7471, 710, 26, 60, "Output",
 CellID->397766572]
}, Open  ]],
Cell[397731, 7500, 125, 3, 70, "ExampleDelimiter",
 CellID->438032041],
Cell[397859, 7505, 233, 8, 70, "ExampleText",
 CellID->245967015],
Cell[CellGroupData[{
Cell[398117, 7517, 211, 7, 70, "Input",
 CellID->73755777],
Cell[398331, 7526, 346, 13, 51, "Output",
 CellID->27001707]
}, Open  ]],
Cell[398692, 7542, 125, 3, 70, "ExampleDelimiter",
 CellID->288777898],
Cell[398820, 7547, 310, 13, 70, "ExampleText",
 CellID->300470926],
Cell[CellGroupData[{
Cell[399155, 7564, 341, 11, 70, "Input",
 CellID->433141732],
Cell[399499, 7577, 268, 10, 51, "Output",
 CellID->144215068]
}, Open  ]],
Cell[CellGroupData[{
Cell[399804, 7592, 317, 10, 70, "Input",
 CellID->230624002],
Cell[400124, 7604, 158, 5, 36, "Output",
 CellID->567006515]
}, Open  ]],
Cell[400297, 7612, 332, 12, 70, "ExampleText",
 CellID->139456824],
Cell[CellGroupData[{
Cell[400654, 7628, 217, 7, 70, "Input",
 CellID->21592919],
Cell[400874, 7637, 723, 24, 51, "Output",
 CellID->219566087]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[401646, 7667, 225, 7, 70, "ExampleSection",
 CellID->4371],
Cell[401874, 7676, 208, 7, 70, "ExampleText",
 CellID->48071648],
Cell[CellGroupData[{
Cell[402107, 7687, 302, 10, 70, "Input",
 CellID->299511344],
Cell[402412, 7699, 385, 13, 43, "Output",
 CellID->11795865]
}, Open  ]],
Cell[402812, 7715, 84, 1, 70, "ExampleText",
 CellID->93855894],
Cell[CellGroupData[{
Cell[402921, 7720, 110, 3, 70, "Input",
 CellID->113740548],
Cell[403034, 7725, 388, 15, 63, "Output",
 CellID->260964116]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[403471, 7746, 224, 7, 70, "ExampleSection",
 CellID->18395],
Cell[403698, 7755, 308, 12, 70, "ExampleText",
 CellID->775549977],
Cell[CellGroupData[{
Cell[404031, 7771, 738, 22, 70, "Input",
 CellID->422351592],
Cell[404772, 7795, 34711, 573, 70, "Output",
 Evaluatable->False,
 CellID->136825218]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[439544, 8375, 310, 9, 70, "SeeAlsoSection",
 CellID->6286],
Cell[439857, 8386, 1393, 53, 70, "SeeAlso",
 CellID->20570]
}, Open  ]],
Cell[CellGroupData[{
Cell[441287, 8444, 313, 9, 70, "TutorialsSection",
 CellID->7506],
Cell[441603, 8455, 140, 3, 70, "Tutorials",
 CellID->32125],
Cell[441746, 8460, 148, 3, 70, "Tutorials",
 CellID->11403]
}, Open  ]],
Cell[CellGroupData[{
Cell[441931, 8468, 321, 9, 70, "RelatedLinksSection",
 CellID->16803],
Cell[442255, 8479, 344, 11, 70, "RelatedLinks"],
Cell[442602, 8492, 179, 4, 70, "RelatedLinks"],
Cell[442784, 8498, 192, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[443013, 8507, 319, 9, 70, "MoreAboutSection",
 CellID->692031134],
Cell[443335, 8518, 141, 3, 70, "MoreAbout",
 CellID->436160152],
Cell[443479, 8523, 169, 3, 70, "MoreAbout",
 CellID->130698071],
Cell[443651, 8528, 155, 3, 70, "MoreAbout",
 CellID->423576427]
}, Open  ]],
Cell[443821, 8534, 27, 0, 70, "History"],
Cell[443851, 8536, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

