(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30931,       1050]
NotebookOptionsPosition[     25836,        879]
NotebookOutlinePosition[     27234,        917]
CellTagsIndexPosition[     27149,        912]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"], 
          "Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Reading Textual Data\"\>", 
       2->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Input" :> Documentation`HelpLookup["paclet:ref/Input"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"], "BinaryRead" :> 
          Documentation`HelpLookup["paclet:ref/BinaryRead"], "Skip" :> 
          Documentation`HelpLookup["paclet:ref/Skip"], "Find" :> 
          Documentation`HelpLookup["paclet:ref/Find"], "StringToStream" :> 
          Documentation`HelpLookup["paclet:ref/StringToStream"], "LinkRead" :> 
          Documentation`HelpLookup["paclet:ref/LinkRead"], "Import" :> 
          Documentation`HelpLookup["paclet:ref/Import"], "OpenRead" :> 
          Documentation`HelpLookup["paclet:ref/OpenRead"], "Write" :> 
          Documentation`HelpLookup["paclet:ref/Write"], "ReadList" :> 
          Documentation`HelpLookup["paclet:ref/ReadList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Input\"\>", 2->"\<\"Get\"\>", 
       3->"\<\"BinaryRead\"\>", 4->"\<\"Skip\"\>", 5->"\<\"Find\"\>", 
       6->"\<\"StringToStream\"\>", 7->"\<\"LinkRead\"\>", 
       8->"\<\"Import\"\>", 9->"\<\"OpenRead\"\>", 10->"\<\"Write\"\>", 
       11->"\<\"ReadList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"External Operations\"\>", 3->"\<\"File Operations\"\>", 
       4->"\<\"Files\"\>", 5->"\<\"Low-Level File Operations\"\>", 
       6->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Read", "ObjectName",
 CellID->24903],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Read",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Read"], "[", 
       StyleBox["stream", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads one expression from an input stream, and returns \
the expression. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Read",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Read"], "[", 
       RowBox[{
        StyleBox["stream", "TI"], ",", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads one object of the specified type. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Read",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Read"], "[", 
       RowBox[{
        StyleBox["stream", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["type", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["type", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads a sequence of objects of the specified types. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->13820]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible types to read are: ", "Notes",
 CellID->30189],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Byte",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Byte"], Cell[
    "single byte, returned as an integer code ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Character",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Character"], Cell["\<\
single character, returned as a one\[Hyphen]character string \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Expression",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Expression"], Cell[TextData[{
     "complete ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Number",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Number"], Cell[TextData[{
     "integer or an approximate number, given in \[OpenCurlyDoubleQuote]",
     Cell[BoxData[
      ButtonBox["E",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/E"]], "InlineFormula"],
     "\[CloseCurlyDoubleQuote] format "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"], Cell[TextData[{
     "approximate number, given in \[OpenCurlyDoubleQuote]",
     Cell[BoxData[
      ButtonBox["E",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/E"]], "InlineFormula"],
     "\[CloseCurlyDoubleQuote] format "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Record",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Record"], Cell[
    "sequence of characters delimited by record separators ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["String",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/String"], Cell[
    "string terminated by a newline ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Word",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Word"], Cell[
    "sequence of characters delimited by word separators ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->3292],

Cell[TextData[{
 "Objects of type ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " can be given in the scientific notation format used by languages such as C \
and Fortran, as well as in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " format. A form like ",
 Cell[BoxData[
  RowBox[{"2.", "e5"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"2", "E5"}]], "InlineFormula"],
 " as well as ",
 Cell[BoxData["2*^5"], "InlineFormula"],
 " can be used to represent the number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Cross]", 
    SuperscriptBox["10", "5"]}], TraditionalForm]], "InlineMath"],
 ". Objects read as type ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " are always returned as approximate numbers. Objects read as type ",
 Cell[BoxData[
  ButtonBox["Number",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Number"]], "InlineFormula"],
 " are returned as integers if they contain no explicit decimal points. "
}], "Notes",
 CellID->20730],

Cell["The following options can be given: ", "Notes",
 CellID->590],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NullRecords",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NullRecords"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to assume a null record between repeated record separators \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NullWords",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NullWords"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to assume a null word between repeated word separators \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RecordSeparators",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RecordSeparators"], 
    RowBox[{"{", 
     RowBox[{"\"\<\\n\>\"", ",", "\"\<\\r\\n\>\"", ",", "\"\<\\r\>\""}], 
     "}"}], Cell["separators allowed between records ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TokenWords",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TokenWords"], 
    RowBox[{"{", "}"}], Cell["words taken as delimiters ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WordSeparators",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordSeparators"], 
    RowBox[{"{", 
     RowBox[{"\"\< \>\"", ",", "\"\<\[Backslash]t\>\""}], "}"}], Cell[
    "separators allowed between words ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->27639],

Cell[TextData[{
 "Objects of type ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 " must be terminated by newlines. "
}], "Notes",
 CellID->4601],

Cell[TextData[{
 "You can specify any nested list of types for ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " to look for. Each successive object read will be placed in the next \
position in the list structure. A depth\[Hyphen]first traversal of the list \
structure is used. "
}], "Notes",
 CellID->9004],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Read",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Read"], "[", 
   RowBox[{
    StyleBox["stream", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Number",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Number"], ",", 
      ButtonBox["Number",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Number"]}], "}"}]}], "]"}]], "InlineFormula"],
 " reads a pair of numbers from an input stream, and gives the result as a \
two\[Hyphen]element list. "
}], "Notes",
 CellID->8540],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Read",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Read"], "[", 
   RowBox[{
    StyleBox["stream", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        ButtonBox["Number",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Number"], ",", 
        ButtonBox["Number",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Number"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        ButtonBox["Number",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Number"], ",", 
        ButtonBox["Number",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Number"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " reads a 2\[Times]2 matrix, going through each column, then each row. "
}], "Notes",
 CellID->7973],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " to get objects to insert into any expression structure, not necessarily a \
list. Example: ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Read",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Read"], "[", 
   RowBox[{
    StyleBox["stream", "TI"], ",", 
    RowBox[{
     ButtonBox["Hold",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hold"], "[", 
     ButtonBox["Expression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Expression"], "]"}]}], "]"}]], 
  "InlineFormula"],
 " gets an expression and places it inside ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21422],

Cell[TextData[{
 "The first argument to ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputStream"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ", or simply ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""], "InlineFormula"],
 " if there is only one open input stream with the specified name. "
}], "Notes",
 CellID->10131],

Cell[TextData[{
 "You can open a file or pipe to get an ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " object using ",
 Cell[BoxData[
  ButtonBox["OpenRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenRead"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9682],

Cell[TextData[{
 "There is always a \[OpenCurlyDoubleQuote]current point\
\[CloseCurlyDoubleQuote] maintained for any stream. When you read an object \
from a stream, the current point is left after the input you read. Successive \
calls to ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " can therefore be used to read successive objects in a stream such as a \
file. "
}], "Notes",
 CellID->4606],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 " for each object you try to read after you have reached the end of a file. \
"
}], "Notes",
 CellID->23220],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it cannot read an object of the type you requested. "
}], "Notes",
 CellID->21271],

Cell[TextData[{
 "If there is a syntax error in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression that you try to read, then ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " leaves the current point at the position of the error, and returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17358]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->235976518],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->26273532],

Cell["Open a stream:", "ExampleText",
 CellID->536748276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{"StringToStream", "[", "\"\<abcdefg 123456\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1696957332],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "69"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25703736]
}, Open  ]],

Cell["Read expressions from the stream:", "ExampleText",
 CellID->52846610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", "str", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1282228059],

Cell[BoxData[
 RowBox[{"123456", " ", "abcdefg"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->749822027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1014990284],

Cell["Open a stream:", "ExampleText",
 CellID->1479095067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{"StringToStream", "[", "\"\<123 abc 456\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2027577044],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "70"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->677229792]
}, Open  ]],

Cell["Read numbers from the stream:", "ExampleText",
 CellID->799319780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", " ", "Number"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1657330475],

Cell[BoxData["123"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->419738482]
}, Open  ]],

Cell["Read words and numbers:", "ExampleText",
 CellID->1303249977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", 
   RowBox[{"{", 
    RowBox[{"Word", ",", "Number"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->949810732],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abc\"\>", ",", "456"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->159586568]
}, Open  ]],

Cell["Close the stream:", "ExampleText",
 CellID->1558639170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1043004084],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->45294710]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30718],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Skip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Skip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Find",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Find"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringToStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringToStream"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Write",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Write"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->772]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12219],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->3755],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->11451]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->42952747],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->306024643],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->137163939],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->909368756],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->254349362],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->208586907],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->60416577]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Read - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 20.7197134}", "context" -> "System`", 
    "keywords" -> {"sequential reading from files", "read from file"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Read[stream] reads one expression from an input stream, and returns the \
expression. Read[stream, type] reads one object of the specified type. \
Read[stream, {type_1, type_2, ...}] reads a sequence of objects of the \
specified types. ", "synonyms" -> {}, "title" -> "Read", "type" -> "Symbol", 
    "uri" -> "ref/Read"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17470, 543, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->235976518]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27005, 905}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3632, 75, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4255, 102, 42, 1, 70, "ObjectName",
 CellID->24903],
Cell[4300, 105, 1484, 46, 70, "Usage",
 CellID->13820]
}, Open  ]],
Cell[CellGroupData[{
Cell[5821, 156, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6299, 173, 61, 1, 70, "Notes",
 CellID->30189],
Cell[6363, 176, 2516, 69, 70, "2ColumnTableMod",
 CellID->3292],
Cell[8882, 247, 1115, 35, 70, "Notes",
 CellID->20730],
Cell[10000, 284, 67, 1, 70, "Notes",
 CellID->590],
Cell[10070, 287, 1860, 47, 70, "3ColumnTableMod",
 CellID->27639],
Cell[11933, 336, 216, 8, 70, "Notes",
 CellID->4601],
Cell[12152, 346, 376, 10, 70, "Notes",
 CellID->9004],
Cell[12531, 358, 569, 19, 70, "Notes",
 CellID->8540],
Cell[13103, 379, 853, 29, 70, "Notes",
 CellID->7973],
Cell[13959, 410, 833, 30, 70, "Notes",
 CellID->21422],
Cell[14795, 442, 604, 20, 70, "Notes",
 CellID->10131],
Cell[15402, 464, 355, 13, 70, "Notes",
 CellID->9682],
Cell[15760, 479, 466, 12, 70, "Notes",
 CellID->4606],
Cell[16229, 493, 371, 13, 70, "Notes",
 CellID->23220],
Cell[16603, 508, 346, 12, 70, "Notes",
 CellID->21271],
Cell[16952, 522, 481, 16, 70, "Notes",
 CellID->17358]
}, Closed]],
Cell[CellGroupData[{
Cell[17470, 543, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->235976518],
Cell[CellGroupData[{
Cell[17855, 557, 147, 5, 70, "ExampleSection",
 CellID->26273532],
Cell[18005, 564, 57, 1, 70, "ExampleText",
 CellID->536748276],
Cell[CellGroupData[{
Cell[18087, 569, 157, 4, 28, "Input",
 CellID->1696957332],
Cell[18247, 575, 224, 7, 36, "Output",
 CellID->25703736]
}, Open  ]],
Cell[18486, 585, 75, 1, 70, "ExampleText",
 CellID->52846610],
Cell[CellGroupData[{
Cell[18586, 590, 103, 3, 28, "Input",
 CellID->1282228059],
Cell[18692, 595, 192, 6, 36, "Output",
 CellID->749822027]
}, Open  ]],
Cell[18899, 604, 126, 3, 70, "ExampleDelimiter",
 CellID->1014990284],
Cell[19028, 609, 58, 1, 70, "ExampleText",
 CellID->1479095067],
Cell[CellGroupData[{
Cell[19111, 614, 154, 4, 70, "Input",
 CellID->2027577044],
Cell[19268, 620, 225, 7, 36, "Output",
 CellID->677229792]
}, Open  ]],
Cell[19508, 630, 72, 1, 70, "ExampleText",
 CellID->799319780],
Cell[CellGroupData[{
Cell[19605, 635, 136, 4, 70, "Input",
 CellID->1657330475],
Cell[19744, 641, 160, 5, 36, "Output",
 CellID->419738482]
}, Open  ]],
Cell[19919, 649, 67, 1, 70, "ExampleText",
 CellID->1303249977],
Cell[CellGroupData[{
Cell[20011, 654, 182, 6, 70, "Input",
 CellID->949810732],
Cell[20196, 662, 215, 7, 36, "Output",
 CellID->159586568]
}, Open  ]],
Cell[20426, 672, 61, 1, 70, "ExampleText",
 CellID->1558639170],
Cell[CellGroupData[{
Cell[20512, 677, 104, 3, 70, "Input",
 CellID->1043004084],
Cell[20619, 682, 162, 5, 36, "Output",
 CellID->45294710]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20842, 694, 311, 9, 70, "SeeAlsoSection",
 CellID->30718],
Cell[21156, 705, 2628, 98, 70, "SeeAlso",
 CellID->772]
}, Open  ]],
Cell[CellGroupData[{
Cell[23821, 808, 314, 9, 70, "TutorialsSection",
 CellID->12219],
Cell[24138, 819, 148, 3, 70, "Tutorials",
 CellID->3755],
Cell[24289, 824, 191, 4, 70, "Tutorials",
 CellID->11451]
}, Open  ]],
Cell[CellGroupData[{
Cell[24517, 833, 318, 9, 70, "MoreAboutSection",
 CellID->42952747],
Cell[24838, 844, 173, 3, 70, "MoreAbout",
 CellID->306024643],
Cell[25014, 849, 149, 3, 70, "MoreAbout",
 CellID->137163939],
Cell[25166, 854, 141, 3, 70, "MoreAbout",
 CellID->909368756],
Cell[25310, 859, 122, 3, 70, "MoreAbout",
 CellID->254349362],
Cell[25435, 864, 159, 3, 70, "MoreAbout",
 CellID->208586907],
Cell[25597, 869, 144, 3, 70, "MoreAbout",
 CellID->60416577]
}, Open  ]],
Cell[25756, 875, 50, 0, 70, "History"],
Cell[25809, 877, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

