(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25224,        810]
NotebookOptionsPosition[     20611,        668]
NotebookOutlinePosition[     22577,        715]
CellTagsIndexPosition[     22492,        710]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Running External Programs" :> 
          Documentation`HelpLookup["paclet:tutorial/RunningExternalPrograms"],
           "Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"], 
          "Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Running External Programs\"\>", 
       2->"\<\"Reading Textual Data\"\>", 
       3->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Import" :> Documentation`HelpLookup["paclet:ref/Import"], 
          "FindList" :> Documentation`HelpLookup["paclet:ref/FindList"], 
          "BinaryReadList" :> 
          Documentation`HelpLookup["paclet:ref/BinaryReadList"], 
          "StringSplit" :> Documentation`HelpLookup["paclet:ref/StringSplit"],
           "Read" :> Documentation`HelpLookup["paclet:ref/Read"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Import\"\>", 2->"\<\"FindList\"\>", 
       3->"\<\"BinaryReadList\"\>", 4->"\<\"StringSplit\"\>", 
       5->"\<\"Read\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], 
          "Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"Constructing Lists\"\>", 3->"\<\"File Operations\"\>", 
       4->"\<\"Files\"\>", 5->"\<\"Importing & Exporting\"\>", 
       6->"\<\"Low-Level File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReadList", "ObjectName",
 CellID->6965],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReadList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]reads all the remaining expressions in a file, and \
returns a list of them. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReadList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReadList"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads objects of the specified type from a file, until \
the end of the file is reached. The list of objects read is returned. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReadList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReadList"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["type", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["type", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads objects with a sequence of types, until the end \
of the file is reached. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReadList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReadList"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
        StyleBox["types", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads only the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " objects of the specified types. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26860]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible types to read are: ", "Notes",
 CellID->30189],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Byte",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Byte"], Cell[
    "single byte, returned as an integer code ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Character",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Character"], Cell["\<\
single character, returned as a one\[Hyphen]character string \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Expression",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Expression"], Cell[TextData[{
     "complete ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Number",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Number"], Cell[TextData[{
     "integer or an approximate number, given in \[OpenCurlyDoubleQuote]",
     Cell[BoxData[
      ButtonBox["E",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/E"]], "InlineFormula"],
     "\[CloseCurlyDoubleQuote] format "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"], Cell[TextData[{
     "approximate number, given in \[OpenCurlyDoubleQuote]",
     Cell[BoxData[
      ButtonBox["E",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/E"]], "InlineFormula"],
     "\[CloseCurlyDoubleQuote] format "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Record",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Record"], Cell[
    "sequence of characters delimited by record separators ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["String",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/String"], Cell[
    "string terminated by a newline ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Word",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Word"], Cell[
    "sequence of characters delimited by word separators ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->3292],

Cell[TextData[{
 "Objects of type ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " can be given in the scientific notation format used by languages such as C \
and Fortran, as well as in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " format. A form like ",
 Cell[BoxData[
  RowBox[{"2.", "e5"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"2", "E5"}]], "InlineFormula"],
 " as well as ",
 Cell[BoxData["2*^5"], "InlineFormula"],
 " can be used to represent the number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Cross]", 
    SuperscriptBox["10", "5"]}], TraditionalForm]], "InlineMath"],
 ". Objects read as type ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " are always returned as approximate numbers. Objects read as type ",
 Cell[BoxData[
  ButtonBox["Number",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Number"]], "InlineFormula"],
 " are returned as integers if they contain no explicit decimal points. "
}], "Notes",
 CellID->20730],

Cell["The following options can be given: ", "Notes",
 CellID->590],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NullRecords",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NullRecords"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to assume a null record between repeated record separators \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NullWords",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NullWords"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to assume a null word between repeated word separators \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RecordSeparators",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RecordSeparators"], 
    RowBox[{"{", 
     RowBox[{"\"\<\\n\>\"", ",", "\"\<\\r\\n\>\"", ",", "\"\<\\r\>\""}], 
     "}"}], Cell["separators allowed between records ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RecordLists",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RecordLists"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "create separate sublists for each record", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TokenWords",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TokenWords"], 
    RowBox[{"{", "}"}], Cell["words taken as delimiters ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WordSeparators",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordSeparators"], 
    RowBox[{"{", 
     RowBox[{"\"\< \>\"", ",", "\"\<\[Backslash]t\>\""}], "}"}], Cell[
    "separators allowed between words ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->27639],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 " is not already open for reading, ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " opens it, then closes it when it is finished. If the file is already open, \
",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " does not close it at the end. "
}], "Notes",
 CellID->9157],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " prints a message if any of the objects remaining in the file are not of \
the specified types. "
}], "Notes",
 CellID->16769],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadList"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["type", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " looks for the sequence of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["type", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in order. If the end of file is reached while part way through the \
sequence of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["type", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 " is returned in place of the elements in the sequence that have not yet \
been read. "
}], "Notes",
 CellID->5031],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadList"], "[", 
   StyleBox["stream", "TI"], "]"}]], "InlineFormula"],
 " reads from an open input stream, as returned by ",
 Cell[BoxData[
  ButtonBox["OpenRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenRead"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18199]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->690468144],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->235206775],

Cell["Read in each line as a separate expression:", "ExampleText",
 CellID->303070591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"StringToStream", "[", "\"\<123\\n45\\nx\\ny\>\"", "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->344227734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"123", ",", "45", ",", "x", ",", "y"}], "}"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317135017]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->722593732],

Cell["Read each line as a string:", "ExampleText",
 CellID->11813814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{
   RowBox[{"StringToStream", "[", "\"\<123\\n45\\nx\\ny\>\"", "]"}], ",", 
   "String"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90975025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"123\"\>", ",", "\<\"45\"\>", ",", "\<\"x\"\>", 
   ",", "\<\"y\"\>"}], "}"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->416712255]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79649609],

Cell["{\"123\", \"45\", \"x\", \"y\"}", "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->244304963]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14964],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryReadList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSplit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Read",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Read"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27473],

Cell[TextData[ButtonBox["Running External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RunningExternalPrograms"]], "Tutorials",
 CellID->20078],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->21349],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->11451]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->94638188],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->127245034],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->982845740],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->2572304],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->884769859],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout",
 CellID->35187063],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->267858547]
}, Open  ]],

Cell["New in 1  |  Last modified in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReadList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 20.0165704}", "context" -> "System`", 
    "keywords" -> {
     "input from data file", "reading arrays from data files", 
      "reading data files", "reading data from external programs", 
      "reading data from files", "reading data from pipes", 
      "reading data from programs", "reading data from spreadsheets", 
      "reading data from streams", "reading matrices from data files", 
      "turning files into strings"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ReadList[\"file\"] reads all the remaining expressions in a file, and \
returns a list of them. ReadList[\"file\", type] reads objects of the \
specified type from a file, until the end of the file is reached. The list of \
objects read is returned. ReadList[\"file\", {type_1, type_2, ...}] reads \
objects with a sequence of types, until the end of the file is reached. \
ReadList[\"file\", types, n] reads only the first n objects of the specified \
types. ", "synonyms" -> {"read list"}, "title" -> "ReadList", "type" -> 
    "Symbol", "uri" -> "ref/ReadList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14738, 441, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->690468144]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22348, 703}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3282, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3905, 99, 45, 1, 70, "ObjectName",
 CellID->6965],
Cell[3953, 102, 2160, 63, 70, "Usage",
 CellID->26860]
}, Open  ]],
Cell[CellGroupData[{
Cell[6150, 170, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6628, 187, 61, 1, 70, "Notes",
 CellID->30189],
Cell[6692, 190, 2516, 69, 70, "2ColumnTableMod",
 CellID->3292],
Cell[9211, 261, 1115, 35, 70, "Notes",
 CellID->20730],
Cell[10329, 298, 67, 1, 70, "Notes",
 CellID->590],
Cell[10399, 301, 2161, 55, 70, "3ColumnTableMod",
 CellID->27639],
Cell[12563, 358, 506, 17, 70, "Notes",
 CellID->9157],
Cell[13072, 377, 263, 8, 70, "Notes",
 CellID->16769],
Cell[13338, 387, 962, 33, 70, "Notes",
 CellID->5031],
Cell[14303, 422, 398, 14, 70, "Notes",
 CellID->18199]
}, Closed]],
Cell[CellGroupData[{
Cell[14738, 441, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->690468144],
Cell[CellGroupData[{
Cell[15123, 455, 148, 5, 70, "ExampleSection",
 CellID->235206775],
Cell[15274, 462, 86, 1, 70, "ExampleText",
 CellID->303070591],
Cell[CellGroupData[{
Cell[15385, 467, 171, 5, 28, "Input",
 CellID->344227734],
Cell[15559, 474, 227, 7, 36, "Output",
 CellID->317135017]
}, Open  ]],
Cell[15801, 484, 125, 3, 70, "ExampleDelimiter",
 CellID->722593732],
Cell[15929, 489, 69, 1, 70, "ExampleText",
 CellID->11813814],
Cell[CellGroupData[{
Cell[16023, 494, 200, 6, 70, "Input",
 CellID->90975025],
Cell[16226, 502, 263, 8, 36, "Output",
 CellID->416712255]
}, Open  ]],
Cell[CellGroupData[{
Cell[16526, 515, 104, 3, 70, "Input",
 CellID->79649609],
Cell[16633, 520, 191, 5, 50, "Output",
 CellID->244304963]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16885, 532, 311, 9, 70, "SeeAlsoSection",
 CellID->14964],
Cell[17199, 543, 1192, 44, 70, "SeeAlso",
 CellID->21695]
}, Open  ]],
Cell[CellGroupData[{
Cell[18428, 592, 314, 9, 70, "TutorialsSection",
 CellID->27473],
Cell[18745, 603, 159, 3, 70, "Tutorials",
 CellID->20078],
Cell[18907, 608, 149, 3, 70, "Tutorials",
 CellID->21349],
Cell[19059, 613, 191, 4, 70, "Tutorials",
 CellID->11451]
}, Open  ]],
Cell[CellGroupData[{
Cell[19287, 622, 318, 9, 70, "MoreAboutSection",
 CellID->94638188],
Cell[19608, 633, 173, 3, 70, "MoreAbout",
 CellID->127245034],
Cell[19784, 638, 147, 3, 70, "MoreAbout",
 CellID->982845740],
Cell[19934, 643, 139, 3, 70, "MoreAbout",
 CellID->2572304],
Cell[20076, 648, 122, 3, 70, "MoreAbout",
 CellID->884769859],
Cell[20201, 653, 153, 3, 70, "MoreAbout",
 CellID->35187063],
Cell[20357, 658, 159, 3, 70, "MoreAbout",
 CellID->267858547]
}, Open  ]],
Cell[20531, 664, 50, 0, 70, "History"],
Cell[20584, 666, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

