(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16340,        594]
NotebookOptionsPosition[     12374,        459]
NotebookOutlinePosition[     13712,        497]
CellTagsIndexPosition[     13627,        492]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Attributes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Locked" :> Documentation`HelpLookup["paclet:ref/Locked"], 
          "Protected" :> Documentation`HelpLookup["paclet:ref/Protected"], 
          "Copyable" :> Documentation`HelpLookup["paclet:ref/Copyable"], 
          "Encode" :> Documentation`HelpLookup["paclet:ref/Encode"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Locked\"\>", 
       2->"\<\"Protected\"\>", 3->"\<\"Copyable\"\>", 
       4->"\<\"Encode\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Package Bulletproofing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReadProtected", "ObjectName",
 CellID->29221],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ReadProtected",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ReadProtected"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which prevents values associated with a \
symbol from being seen. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5191]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Individual values associated with read\[Hyphen]protected symbols can be used \
during evaluation. \
\>", "Notes",
 CellID->29125],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Definition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Definition"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", and related functions give only the attributes for read\[Hyphen]protected \
symbols ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30991]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->247132341],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->444336866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94313039],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Constant", ",", "Protected", ",", "ReadProtected"}], 
  "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84694924]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->154076870],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"Protected", ",", "ReadProtected", ",", "Locked"}], "}"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->458281062]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->271434581],

Cell["Definitions of a read-protected symbol are not shown:", "ExampleText",
 CellID->513822010],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "ReadProtected"}], "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->183199146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->244774659],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", "ReadProtected", "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->604308217]
}, Open  ]],

Cell["\<\
As long as the symbol is not locked, the read protection can be removed:\
\>", "ExampleText",
 CellID->20448696],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAttributes", "[", 
   RowBox[{"f", ",", "ReadProtected"}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20778438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->69611005],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1U0sOgjAQHdqC4aMkrFgZXBivoQtl5SEaYgILo0Huj1NoCQwBicYm7fz6
3pu2cJVVfrvLqshkkpbymRfZK7k8SkxxC4CdASCMAf0avWaakeIE8HBlmI60
NdVDVwXepcHFxcGQk7xB7RtUW26H2iRUKPraSolp6xMuR+c3ZJ/Bug05Iyib
xGyoiU4woaO6s9E6I4RR9BYpcs23JvmY9O//xBbobldfsS6/lfDDbfznjZXl
PRKx6FQRibckHrJxrSHq4Ze/m0C1Bz3NVo+9Koz6n8eaqP0fwXoDXVYQ8w==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->129519379]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19396320],

Cell["\<\
If a symbol is locked and protected, its definitions can be neither changed \
or read:\
\>", "ExampleText",
 CellID->454791059],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"Protected", ",", "ReadProtected", ",", "Locked"}], "}"}]}], 
   "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->298490653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->369328618],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Locked", ",", "Protected", ",", "ReadProtected"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{342, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->393537481]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->117097517],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "::", "\<\"wrsym\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(f\\) is Protected. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/wrsym\\\", ButtonNote -> \
\\\"Clear::wrsym\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->411614023]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20737],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Locked",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locked"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Protected",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Protected"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Copyable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Copyable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Encode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Encode"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9375]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->406],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->21442]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->137691104],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->146741599]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReadProtected - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 21.3603548}", "context" -> "System`", 
    "keywords" -> {
     "hidden", "invisible", "protection of definitions", "security", 
      "attribute"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "ReadProtected is an attribute which prevents values associated with a \
symbol from being seen. ", "synonyms" -> {"read protected"}, "title" -> 
    "ReadProtected", "type" -> "Symbol", "uri" -> "ref/ReadProtected"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4407, 145, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->247132341]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13484, 485}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2107, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2730, 78, 51, 1, 70, "ObjectName",
 CellID->29221],
Cell[2784, 81, 474, 14, 70, "Usage",
 CellID->5191]
}, Open  ]],
Cell[CellGroupData[{
Cell[3295, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3773, 117, 139, 4, 70, "Notes",
 CellID->29125],
Cell[3915, 123, 455, 17, 70, "Notes",
 CellID->30991]
}, Closed]],
Cell[CellGroupData[{
Cell[4407, 145, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->247132341],
Cell[CellGroupData[{
Cell[4792, 159, 148, 5, 70, "ExampleSection",
 CellID->444336866],
Cell[CellGroupData[{
Cell[4965, 168, 106, 3, 28, "Input",
 CellID->94313039],
Cell[5074, 173, 243, 8, 36, "Output",
 CellID->84694924]
}, Open  ]],
Cell[5332, 184, 125, 3, 70, "ExampleDelimiter",
 CellID->154076870],
Cell[5460, 189, 327, 11, 70, "Input",
 CellID->458281062]
}, Open  ]],
Cell[CellGroupData[{
Cell[5824, 205, 237, 7, 70, "ExampleSection",
 CellID->271434581],
Cell[6064, 214, 96, 1, 70, "ExampleText",
 CellID->513822010],
Cell[6163, 217, 271, 9, 70, "Input",
 CellID->183199146],
Cell[CellGroupData[{
Cell[6459, 230, 106, 3, 70, "Input",
 CellID->244774659],
Cell[6568, 235, 524, 17, 36, "Output",
 CellID->604308217]
}, Open  ]],
Cell[7107, 255, 122, 3, 70, "ExampleText",
 CellID->20448696],
Cell[7232, 260, 164, 5, 70, "Input",
 CellID->20778438],
Cell[CellGroupData[{
Cell[7421, 269, 105, 3, 70, "Input",
 CellID->69611005],
Cell[7529, 274, 517, 13, 70, "Output",
 Evaluatable->False,
 CellID->129519379]
}, Open  ]],
Cell[8061, 290, 124, 3, 70, "ExampleDelimiter",
 CellID->19396320],
Cell[8188, 295, 137, 4, 70, "ExampleText",
 CellID->454791059],
Cell[8328, 301, 349, 12, 70, "Input",
 CellID->298490653],
Cell[CellGroupData[{
Cell[8702, 317, 106, 3, 70, "Input",
 CellID->369328618],
Cell[8811, 322, 575, 18, 36, "Output",
 CellID->393537481]
}, Open  ]],
Cell[CellGroupData[{
Cell[9423, 345, 101, 3, 70, "Input",
 CellID->117097517],
Cell[9527, 350, 354, 7, 70, "Message",
 CellID->411614023]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9942, 364, 311, 9, 70, "SeeAlsoSection",
 CellID->20737],
Cell[10256, 375, 934, 35, 70, "SeeAlso",
 CellID->9375]
}, Open  ]],
Cell[CellGroupData[{
Cell[11227, 415, 312, 9, 70, "TutorialsSection",
 CellID->406],
Cell[11542, 426, 131, 3, 70, "Tutorials",
 CellID->21442]
}, Open  ]],
Cell[CellGroupData[{
Cell[11710, 434, 299, 8, 70, "MoreAboutSection"],
Cell[12012, 444, 132, 3, 70, "MoreAbout",
 CellID->137691104],
Cell[12147, 449, 155, 3, 70, "MoreAbout",
 CellID->146741599]
}, Open  ]],
Cell[12317, 455, 27, 0, 70, "History"],
Cell[12347, 457, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

