(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50450,       1928]
NotebookOptionsPosition[     38699,       1510]
NotebookOutlinePosition[     40068,       1548]
CellTagsIndexPosition[     39982,       1543]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Log" :> Documentation`HelpLookup["paclet:ref/Log"], 
          "MantissaExponent" :> 
          Documentation`HelpLookup["paclet:ref/MantissaExponent"], 
          "IntegerExponent" :> 
          Documentation`HelpLookup["paclet:ref/IntegerExponent"], "Accuracy" :> 
          Documentation`HelpLookup["paclet:ref/Accuracy"], "Precision" :> 
          Documentation`HelpLookup["paclet:ref/Precision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Log\"\>", 
       2->"\<\"MantissaExponent\"\>", 3->"\<\"IntegerExponent\"\>", 
       4->"\<\"Accuracy\"\>", 5->"\<\"Precision\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RealExponent", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RealExponent",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RealExponent"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["log", "10"], "(", 
        RowBox[{"\[LeftBracketingBar]", "x", "\[RightBracketingBar]"}], ")"}],
        TraditionalForm]], "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RealExponent",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RealExponent"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["log", "b"], "(", 
        RowBox[{"\[LeftBracketingBar]", "x", "\[RightBracketingBar]"}], ")"}],
        TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is an approximate number consistent with zero, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RealExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealExponent"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"-", 
   RowBox[{
    ButtonBox["Accuracy",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Accuracy"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->365666334],

Cell[TextData[{
 "For any approximate number ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RealExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealExponent"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Precision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Precision"], "[", 
    StyleBox["x", "TI"], "]"}], "-", 
   RowBox[{
    ButtonBox["Accuracy",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Accuracy"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->249696616]
}], "Notes",
 CellID->97107366],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RealExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealExponent"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->176600019]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->143017211],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->493561052],

Cell[TextData[{
 "The base 10 exponent for a number ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->54734855],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "123.456"}], ";"}], "\n", 
 RowBox[{"y", "=", 
  RowBox[{"RealExponent", "[", "123.456", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->561644988],

Cell[BoxData["2.0915122016277716`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41929947]
}, Open  ]],

Cell[TextData[{
 "This is the number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     SubscriptBox["log", "10"], "(", "x", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["10", "y"], "=", 
    RowBox[{"\[LeftBracketingBar]", "x", "\[RightBracketingBar]"}]}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->871160555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"y", "\[Equal]", 
    RowBox[{"Log", "[", 
     RowBox[{"10", ",", 
      RowBox[{"Abs", "[", "x", "]"}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"10", "^", "y"}], "\[Equal]", 
    RowBox[{"Abs", "[", "x", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->545764644],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19315213]
}, Open  ]],

Cell["The base 2 exponent:", "ExampleText",
 CellID->506285977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "=", 
  RowBox[{"RealExponent", "[", 
   RowBox[{"x", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->327280585],

Cell[BoxData["6.947853143387016`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->818075874]
}, Open  ]],

Cell[TextData[{
 "This is the number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     SubscriptBox["log", "2"], "(", 
     RowBox[{"\[LeftBracketingBar]", "x", "\[RightBracketingBar]"}], ")"}]}], 
   TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", "y"], "=", 
    RowBox[{"\[LeftBracketingBar]", "x", "\[RightBracketingBar]"}]}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->828345861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"y", "\[Equal]", 
    RowBox[{"Log", "[", 
     RowBox[{"2", ",", 
      RowBox[{"Abs", "[", "x", "]"}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"2", "^", "y"}], "\[Equal]", 
    RowBox[{"Abs", "[", "x", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->275895332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->35741630]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->737349],

Cell["The real exponent for an arbitrary-precision number:", "ExampleText",
 CellID->332420993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"N", "[", 
   RowBox[{"E", ",", "32"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152949687],

Cell[BoxData["2.7182818284590452353602874713526624977572470937`32."], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135331351]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealExponent", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->215132117],

Cell[BoxData["0.434294481903252`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31245234]
}, Open  ]],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  ButtonBox["RealExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealExponent"]], "InlineFormula"],
 " is given as a machine number whatever the precision of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->419775109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->183363904],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->54923245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->472144095],

Cell["The real exponent for an exact number:", "ExampleText",
 CellID->137983170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealExponent", "[", 
  RowBox[{"987654321", "/", "123456789"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49449751],

Cell[BoxData["0.9030899909494529`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81742185]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->288280019],

Cell["The real exponent for an exact numeric quantity:", "ExampleText",
 CellID->278525647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealExponent", "[", 
  RowBox[{"Pi", "^", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->899974],

Cell[BoxData["1.5618423877889922`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147754416]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11124615],

Cell["Real exponent for zeros:", "ExampleText",
 CellID->133357512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealExponent", "[", "0.", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40778822],

Cell[BoxData[
 RowBox[{"-", "307.6526555685888`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97413037]
}, Open  ]],

Cell[TextData[{
 "This is ",
 Cell[BoxData[
  RowBox[{"-", 
   RowBox[{
    ButtonBox["Accuracy",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Accuracy"], "[", 
    StyleBox["x", "TI"], 
    StyleBox["]", "TI"]}]}]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->447380553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "0.", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7474377],

Cell[BoxData["307.6526555685888`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->581489565]
}, Open  ]],

Cell["The same is true for arbitrary-precision zeros:", "ExampleText",
 CellID->26792431],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0``47"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7292900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealExponent", "[", "x", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->167168875],

Cell[BoxData[
 RowBox[{"-", "47.`"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->758865702]
}, Open  ]],

Cell["Also for exact zero:", "ExampleText",
 CellID->674683148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealExponent", "[", "0", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->135945311],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->67384338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->421627],

Cell["The real exponent for different bases:", "ExampleText",
 CellID->696685555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RealExponent", "[", 
    RowBox[{"Pi", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "5", ",", "7", ",", "10"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88581765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.6514961294723172`", ",", "1.0419780459921848`", ",", 
   "0.7112606687126684`", ",", "0.58827479079912`", ",", 
   "0.4971498726941334`"}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38166935]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "5", ",", "7", ",", "10"}], "}"}], "^", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->293265493],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.1415926535897896`", ",", "3.1415926535897896`", ",", "3.14159265358979`",
    ",", "3.141592653589789`", ",", "3.14159265358979`"}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69148991]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->787975],

Cell["The base can be any number strictly greater than 1:", "ExampleText",
 CellID->95219539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealExponent", "[", 
  RowBox[{"Pi", ",", 
   RowBox[{"1.", "+", "$MachineEpsilon"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156010519],

Cell[BoxData["5.155648407361267`*^15"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->363708713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->85855392],

Cell["The base can be an exact numeric quantity:", "ExampleText",
 CellID->36935047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealExponent", "[", 
  RowBox[{"Pi", ",", "E"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78259935],

Cell[BoxData["1.1447298858493986`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->456632843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44765034],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RealExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealExponent"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->97678809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealExponent", "[", 
  RowBox[{"Range", "[", "20", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26680184],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.3010299956639812`", ",", "0.4771212547196625`", ",", 
   "0.6020599913279624`", ",", "0.6989700043360187`", ",", 
   "0.7781512503836436`", ",", "0.8450980400142569`", ",", 
   "0.9030899869919436`", ",", "0.954242509439325`", ",", "1.`", ",", 
   "1.0413926851582251`", ",", "1.0791812460476249`", ",", 
   "1.113943352306837`", ",", "1.1461280356782382`", ",", 
   "1.1760912590556813`", ",", "1.2041199826559248`", ",", 
   "1.2304489213782739`", ",", "1.255272505103306`", ",", 
   "1.2787536009528289`", ",", "1.3010299956639813`"}], "}"}]], "Output",
 ImageSize->{429, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285026610]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealExponent", "[", 
  RowBox[{"Pi", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "7", ",", "10"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->241998689],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.6514961294723172`", ",", "1.0419780459921848`", ",", 
   "0.8257480647361586`", ",", "0.58827479079912`", ",", 
   "0.4971498726941334`"}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->225202455]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->41077431],

Cell["Determine quickly if a power will overflow:", "ExampleText",
 CellID->163408521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RealExponent", "[", "Pi", "]"}], "*", "1000000000"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->478485765],

Cell[BoxData["4.971498726941334`*^8"], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48312584]
}, Open  ]],

Cell["This predicts that the power can be represented:", "ExampleText",
 CellID->43985252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ">", 
  RowBox[{"RealExponent", "[", "$MaxNumber", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->676796928],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->220109056]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", "^", "1000000000"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->566830960],

Cell[BoxData["4.9446303828896808256807996224`13.245319809215173*^497149872"], \
"Output",
 ImageSize->{176, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19659128]
}, Open  ]],

Cell["A larger power will not work:", "ExampleText",
 CellID->269441943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RealExponent", "[", "Pi", "]"}], "*", "9000000000"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->69833426],

Cell[BoxData["4.474348854247201`*^9"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->12842426]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ">", 
  RowBox[{"RealExponent", "[", "$MaxNumber", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->400757273],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->181959585]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", "^", "9000000000"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->249159997],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->335995302],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->165952356]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->253835307],

Cell[TextData[{
 "Determine quickly the largest power tower ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["b", 
    SuperscriptBox["b", 
     SuperscriptBox["b", "\[AscendingEllipsis]"]]], TraditionalForm]], 
  "InlineMath"],
 " that will not overflow for a given number:"
}], "ExampleText",
 CellID->919425330],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "[", "b_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"k", "=", "0"}], ",", 
      RowBox[{"x", "=", "$MaxNumber"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"x", ">", "1"}], ",", 
       RowBox[{
        RowBox[{"x", "=", 
         RowBox[{"RealExponent", "[", 
          RowBox[{"x", ",", "b"}], "]"}]}], ";", 
        RowBox[{"k", "++"}]}]}], "]"}], ";", 
     RowBox[{"k", "-", "1"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149476634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Power", ",", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"3.", ",", 
     RowBox[{"n", "[", "3.", "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->287494856],

Cell[BoxData["7.625597484987`*^12"], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->366298280]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Power", ",", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"3.", ",", 
     RowBox[{
      RowBox[{"n", "[", "3.", "]"}], "+", "1"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->462535301],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->261828242],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->46640632]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"n", "[", "p", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "2", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->682502758],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1OHDEQ9p1372iASKGgRHDwBoQKpYiSVDzEckKCgh/BIUEeIJGShjZS
pChFioR0nKDlCYiUivaK1HmEZcY3vvWO7cW7d0GLkhNn79gz33hnPo/NbSS9
7a3dpLfTTRZeHyYH2zvdo4VX+4cwJBtCiD58T+YFPKfwpL79NIXebtewlaih
PmIJmiaIK9SjjNNNkqXTahGbKJOF6FgjS9YIYuJyG9iroVVoI6dudTy9TuFE
Wab3smdstGeGriTb8mvSKMsshtXekGeiY6Dr/Om8ZfkzGfCEIXwpGJ2G9iut
w9Zpl5RbY9qPKwf5j0fyz5vf3c0fIoZeaUGPj20tk5V0xqbDZGf2DXlOyQC9
v3eBjzNs3u3lPbOaG2lh7j94Z8Mw/nuyZyO9G4wqg9pxELaIht2w5fxrBmFw
Lc7qMBTJtPj6EQXFMGtdbUKjYNY4bhOFYUgKPsWxScGtA0cer6cA3gg7+zrz
/nVaFirRJgvCsl4eZ1hHB4M/VL1PVfU+//7Ly6bYiYmQQ6yXLz6BLfyJN9jI
q8tb0nyauvanDFzj8/WPJJ+N9a4WDii00mx/Yj/r1OQMcOOFaz2cp7qtx++J
7x/f+RHGCVfVngxKxndube6VqUr+uZau29ViwGWN5o+/eV78myx8OE8q19md
OiXGp2UyPqmKGmlNd3VX1Ryqe87G3Kfuk0FpwCFw3LsUM+p0gdOGYaSjHVOM
8e7tNf3nVcWmaF9hLyTo0tznfIZzOP7ROqF43r/FuEbZ9ccg+D6d8xWJgvs7
y2TGIFe9RNHOuXliF7ODrzeMGzoemiP1zepksO+7t9roJe5feU9/1c7NloIK
QSN5G82AEBuzVmP/TY3avyyKxh04uwh1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->584130423]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->621522143],

Cell[TextData[{
 "For any approximate number ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RealExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealExponent"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Precision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Precision"], "[", 
    StyleBox["x", "TI"], "]"}], "-", 
   RowBox[{
    ButtonBox["Accuracy",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Accuracy"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->249696616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{
   RowBox[{"RandomReal", "[", "]"}], "*", 
   RowBox[{"10", "^", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "300"}], ",", "300"}], "}"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14486465],

Cell[BoxData["3.10127641438096`*^290"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->441599373]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RealExponent", "[", "x", "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{"Precision", "[", "x", "]"}], "-", 
   RowBox[{"Accuracy", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57257306],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->143368652]
}, Open  ]],

Cell["Also true for arbitrary-precision numbers:", "ExampleText",
 CellID->112842772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"WorkingPrecision", "\[Rule]", "47"}], "]"}], "*", 
   RowBox[{"10", "^", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"10", "^", "5"}]}], ",", 
       RowBox[{"10", "^", "5"}]}], "}"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->147854753],

Cell[BoxData["2.\
653042542600755609080838189825792863536744316115351531336554441`47.*^-11313"],\
 "Output",
 ImageSize->{398, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->719045658]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RealExponent", "[", "x", "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{"Precision", "[", "x", "]"}], "-", 
   RowBox[{"Accuracy", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->30680669],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->63336292]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->290687598],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is an approximate zero, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RealExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealExponent"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"-", 
   RowBox[{
    ButtonBox["Accuracy",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Accuracy"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->55310264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"1", "/", "GoldenRatio"}], " ", "-", "GoldenRatio"}], ",", 
    "47"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144406684],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(1 + 1\\/GoldenRatio - GoldenRatio\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->338959200],

Cell[BoxData["0``96.31389110503038"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217002654]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PossibleZeroQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->44868453],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->589846825]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RealExponent", "[", "x", "]"}], "\[Equal]", 
  RowBox[{"-", 
   RowBox[{"Accuracy", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->142302237],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->351662044]
}, Open  ]],

Cell[TextData[{
 "This is the same as saying that the identity ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RealExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealExponent"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Precision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Precision"], "[", 
    StyleBox["x", "TI"], "]"}], "-", 
   RowBox[{
    ButtonBox["Accuracy",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Accuracy"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->305103021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RealExponent", "[", "x", "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{"Precision", "[", "x", "]"}], "-", 
   RowBox[{"Accuracy", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->4143643],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->50910583]
}, Open  ]],

Cell["Since precision is zero for approximate zeros:", "ExampleText",
 CellID->216210672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "x", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->188170419],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->147657982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->49880954],

Cell["\<\
The real exponent of a product is the sum of the real exponents:\
\>", "ExampleText",
 CellID->261046469],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"x", "=", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"WorkingPrecision", "\[Rule]", "20"}], "]"}], "*", 
   RowBox[{"10", "^", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"10", "^", "5"}]}], ",", 
       RowBox[{"10", "^", "5"}]}], "}"}], "]"}]}]}]}], "\n", 
 RowBox[{"y", "=", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"WorkingPrecision", "\[Rule]", "20"}], "]"}], "*", 
   RowBox[{"10", "^", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"10", "^", "5"}]}], ",", 
       RowBox[{"10", "^", "5"}]}], "}"}], "]"}]}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->301507413],

Cell[BoxData["3.28949096811384940652379666597982`20.*^-72725"], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193453093],

Cell[BoxData["8.13324838269440117345578794561`20.*^-16905"], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->417142601]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RealExponent", "[", 
   RowBox[{"x", " ", "y"}], "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{"RealExponent", "[", "x", "]"}], "+", 
   RowBox[{"RealExponent", "[", "y", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->133135677],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10868266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266928251],

Cell["\<\
The real exponent of a power is the real exponent of the base times the \
power:\
\>", "ExampleText",
 CellID->34519768],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "=", "2.1"}], ";", 
  RowBox[{"p", "=", "1000000000"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320524364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RealExponent", "[", "b", "]"}], " ", "p"}], "\[Equal]", 
  RowBox[{"RealExponent", "[", 
   RowBox[{"b", "^", "p"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->55855877],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->214826427]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MantissaExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MantissaExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->96837357]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RealExponent - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 23.1572758}", "context" -> "System`", 
    "keywords" -> {"scale of numbers", "magnitude of numbers", "exponent"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RealExponent[x] gives log_10 \
(\\[LeftBracketingBar]x\\[RightBracketingBar]). RealExponent[x, b] gives \
log_b (\\[LeftBracketingBar]x\\[RightBracketingBar]).", 
    "synonyms" -> {"real exponent"}, "title" -> "RealExponent", "type" -> 
    "Symbol", "uri" -> "ref/RealExponent"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7157, 232, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->143017211]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39839, 1536}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1625, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2248, 65, 1577, 37, 70, "ObjectNameGrid"],
Cell[3828, 104, 1230, 40, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5095, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5573, 166, 559, 21, 70, "Notes",
 CellID->365666334],
Cell[6135, 189, 769, 29, 70, "Notes",
 CellID->97107366],
Cell[6907, 220, 213, 7, 70, "Notes",
 CellID->176600019]
}, Closed]],
Cell[CellGroupData[{
Cell[7157, 232, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->143017211],
Cell[CellGroupData[{
Cell[7542, 246, 148, 5, 70, "ExampleSection",
 CellID->493561052],
Cell[7693, 253, 161, 6, 70, "ExampleText",
 CellID->54734855],
Cell[CellGroupData[{
Cell[7879, 263, 196, 6, 47, "Input",
 CellID->561644988],
Cell[8078, 271, 175, 5, 36, "Output",
 CellID->41929947]
}, Open  ]],
Cell[8268, 279, 431, 17, 70, "ExampleText",
 CellID->871160555],
Cell[CellGroupData[{
Cell[8724, 300, 328, 11, 28, "Input",
 CellID->545764644],
Cell[9055, 313, 208, 7, 36, "Output",
 CellID->19315213]
}, Open  ]],
Cell[9278, 323, 63, 1, 70, "ExampleText",
 CellID->506285977],
Cell[CellGroupData[{
Cell[9366, 328, 155, 5, 70, "Input",
 CellID->327280585],
Cell[9524, 335, 175, 5, 36, "Output",
 CellID->818075874]
}, Open  ]],
Cell[9714, 343, 495, 18, 70, "ExampleText",
 CellID->828345861],
Cell[CellGroupData[{
Cell[10234, 365, 326, 11, 70, "Input",
 CellID->275895332],
Cell[10563, 378, 208, 7, 36, "Output",
 CellID->35741630]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10820, 391, 217, 7, 70, "ExampleSection",
 CellID->737349],
Cell[11040, 400, 95, 1, 70, "ExampleText",
 CellID->332420993],
Cell[CellGroupData[{
Cell[11160, 405, 145, 5, 70, "Input",
 CellID->152949687],
Cell[11308, 412, 210, 5, 36, "Output",
 CellID->135331351]
}, Open  ]],
Cell[CellGroupData[{
Cell[11555, 422, 108, 3, 70, "Input",
 CellID->215132117],
Cell[11666, 427, 174, 5, 36, "Output",
 CellID->31245234]
}, Open  ]],
Cell[11855, 435, 330, 11, 70, "ExampleText",
 CellID->419775109],
Cell[CellGroupData[{
Cell[12210, 450, 110, 3, 70, "Input",
 CellID->183363904],
Cell[12323, 455, 160, 5, 36, "Output",
 CellID->54923245]
}, Open  ]],
Cell[12498, 463, 125, 3, 70, "ExampleDelimiter",
 CellID->472144095],
Cell[12626, 468, 81, 1, 70, "ExampleText",
 CellID->137983170],
Cell[CellGroupData[{
Cell[12732, 473, 146, 4, 70, "Input",
 CellID->49449751],
Cell[12881, 479, 175, 5, 36, "Output",
 CellID->81742185]
}, Open  ]],
Cell[13071, 487, 125, 3, 70, "ExampleDelimiter",
 CellID->288280019],
Cell[13199, 492, 91, 1, 70, "ExampleText",
 CellID->278525647],
Cell[CellGroupData[{
Cell[13315, 497, 130, 4, 70, "Input",
 CellID->899974],
Cell[13448, 503, 176, 5, 36, "Output",
 CellID->147754416]
}, Open  ]],
Cell[13639, 511, 124, 3, 70, "ExampleDelimiter",
 CellID->11124615],
Cell[13766, 516, 67, 1, 70, "ExampleText",
 CellID->133357512],
Cell[CellGroupData[{
Cell[13858, 521, 108, 3, 70, "Input",
 CellID->40778822],
Cell[13969, 526, 191, 6, 36, "Output",
 CellID->97413037]
}, Open  ]],
Cell[14175, 535, 287, 12, 70, "ExampleText",
 CellID->447380553],
Cell[CellGroupData[{
Cell[14487, 551, 103, 3, 70, "Input",
 CellID->7474377],
Cell[14593, 556, 175, 5, 36, "Output",
 CellID->581489565]
}, Open  ]],
Cell[14783, 564, 89, 1, 70, "ExampleText",
 CellID->26792431],
Cell[14875, 567, 112, 4, 70, "Input",
 CellID->7292900],
Cell[CellGroupData[{
Cell[15012, 575, 108, 3, 70, "Input",
 CellID->167168875],
Cell[15123, 580, 178, 6, 36, "Output",
 CellID->758865702]
}, Open  ]],
Cell[15316, 589, 63, 1, 70, "ExampleText",
 CellID->674683148],
Cell[CellGroupData[{
Cell[15404, 594, 108, 3, 70, "Input",
 CellID->135945311],
Cell[15515, 599, 184, 6, 36, "Output",
 CellID->67384338]
}, Open  ]],
Cell[15714, 608, 122, 3, 70, "ExampleDelimiter",
 CellID->421627],
Cell[15839, 613, 81, 1, 70, "ExampleText",
 CellID->696685555],
Cell[CellGroupData[{
Cell[15945, 618, 327, 11, 70, "Input",
 CellID->88581765],
Cell[16275, 631, 332, 10, 36, "Output",
 CellID->38166935]
}, Open  ]],
Cell[CellGroupData[{
Cell[16644, 646, 173, 6, 70, "Input",
 CellID->293265493],
Cell[16820, 654, 325, 9, 36, "Output",
 CellID->69148991]
}, Open  ]],
Cell[17160, 666, 122, 3, 70, "ExampleDelimiter",
 CellID->787975],
Cell[17285, 671, 93, 1, 70, "ExampleText",
 CellID->95219539],
Cell[CellGroupData[{
Cell[17403, 676, 171, 5, 70, "Input",
 CellID->156010519],
Cell[17577, 683, 179, 5, 36, "Output",
 CellID->363708713]
}, Open  ]],
Cell[17771, 691, 124, 3, 70, "ExampleDelimiter",
 CellID->85855392],
Cell[17898, 696, 84, 1, 70, "ExampleText",
 CellID->36935047],
Cell[CellGroupData[{
Cell[18007, 701, 131, 4, 70, "Input",
 CellID->78259935],
Cell[18141, 707, 176, 5, 36, "Output",
 CellID->456632843]
}, Open  ]],
Cell[18332, 715, 124, 3, 70, "ExampleDelimiter",
 CellID->44765034],
Cell[18459, 720, 218, 7, 70, "ExampleText",
 CellID->97678809],
Cell[CellGroupData[{
Cell[18702, 731, 140, 4, 70, "Input",
 CellID->26680184],
Cell[18845, 737, 744, 16, 71, "Output",
 CellID->285026610]
}, Open  ]],
Cell[CellGroupData[{
Cell[19626, 758, 215, 7, 70, "Input",
 CellID->241998689],
Cell[19844, 767, 333, 10, 36, "Output",
 CellID->225202455]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20226, 783, 226, 7, 70, "ExampleSection",
 CellID->41077431],
Cell[20455, 792, 86, 1, 70, "ExampleText",
 CellID->163408521],
Cell[CellGroupData[{
Cell[20566, 797, 141, 4, 70, "Input",
 CellID->478485765],
Cell[20710, 803, 177, 5, 36, "Output",
 CellID->48312584]
}, Open  ]],
Cell[20902, 811, 90, 1, 70, "ExampleText",
 CellID->43985252],
Cell[CellGroupData[{
Cell[21017, 816, 140, 4, 70, "Input",
 CellID->676796928],
Cell[21160, 822, 162, 5, 36, "Output",
 CellID->220109056]
}, Open  ]],
Cell[CellGroupData[{
Cell[21359, 832, 130, 4, 70, "Input",
 CellID->566830960],
Cell[21492, 838, 219, 6, 36, "Output",
 CellID->19659128]
}, Open  ]],
Cell[21726, 847, 72, 1, 70, "ExampleText",
 CellID->269441943],
Cell[CellGroupData[{
Cell[21823, 852, 140, 4, 70, "Input",
 CellID->69833426],
Cell[21966, 858, 177, 5, 36, "Output",
 CellID->12842426]
}, Open  ]],
Cell[CellGroupData[{
Cell[22180, 868, 140, 4, 70, "Input",
 CellID->400757273],
Cell[22323, 874, 161, 5, 36, "Output",
 CellID->181959585]
}, Open  ]],
Cell[CellGroupData[{
Cell[22521, 884, 130, 4, 70, "Input",
 CellID->249159997],
Cell[22654, 890, 357, 7, 70, "Message",
 CellID->335995302],
Cell[23014, 899, 187, 6, 36, "Output",
 CellID->165952356]
}, Open  ]],
Cell[23216, 908, 125, 3, 70, "ExampleDelimiter",
 CellID->253835307],
Cell[23344, 913, 312, 10, 70, "ExampleText",
 CellID->919425330],
Cell[23659, 925, 593, 20, 70, "Input",
 CellID->149476634],
Cell[CellGroupData[{
Cell[24277, 949, 227, 7, 70, "Input",
 CellID->287494856],
Cell[24507, 958, 176, 5, 36, "Output",
 CellID->366298280]
}, Open  ]],
Cell[CellGroupData[{
Cell[24720, 968, 254, 8, 70, "Input",
 CellID->462535301],
Cell[24977, 978, 357, 7, 70, "Message",
 CellID->261828242],
Cell[25337, 987, 186, 6, 36, "Output",
 CellID->46640632]
}, Open  ]],
Cell[CellGroupData[{
Cell[25560, 998, 212, 7, 70, "Input",
 CellID->682502758],
Cell[25775, 1007, 1099, 22, 70, "Output",
 Evaluatable->False,
 CellID->584130423]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26923, 1035, 237, 7, 70, "ExampleSection",
 CellID->621522143],
Cell[27163, 1044, 737, 27, 70, "ExampleText",
 CellID->249696616],
Cell[CellGroupData[{
Cell[27925, 1075, 294, 10, 70, "Input",
 CellID->14486465],
Cell[28222, 1087, 179, 5, 36, "Output",
 CellID->441599373]
}, Open  ]],
Cell[CellGroupData[{
Cell[28438, 1097, 233, 7, 70, "Input",
 CellID->57257306],
Cell[28674, 1106, 161, 5, 36, "Output",
 CellID->143368652]
}, Open  ]],
Cell[28850, 1114, 85, 1, 70, "ExampleText",
 CellID->112842772],
Cell[CellGroupData[{
Cell[28960, 1119, 402, 13, 70, "Input",
 CellID->147854753],
Cell[29365, 1134, 239, 7, 36, "Output",
 CellID->719045658]
}, Open  ]],
Cell[CellGroupData[{
Cell[29641, 1146, 233, 7, 70, "Input",
 CellID->30680669],
Cell[29877, 1155, 160, 5, 36, "Output",
 CellID->63336292]
}, Open  ]],
Cell[30052, 1163, 125, 3, 70, "ExampleDelimiter",
 CellID->290687598],
Cell[30180, 1168, 541, 21, 70, "ExampleText",
 CellID->55310264],
Cell[CellGroupData[{
Cell[30746, 1193, 236, 8, 70, "Input",
 CellID->144406684],
Cell[30985, 1203, 448, 8, 70, "Message",
 CellID->338959200],
Cell[31436, 1213, 177, 5, 36, "Output",
 CellID->217002654]
}, Open  ]],
Cell[CellGroupData[{
Cell[31650, 1223, 108, 3, 70, "Input",
 CellID->44868453],
Cell[31761, 1228, 161, 5, 36, "Output",
 CellID->589846825]
}, Open  ]],
Cell[CellGroupData[{
Cell[31959, 1238, 192, 6, 70, "Input",
 CellID->142302237],
Cell[32154, 1246, 161, 5, 36, "Output",
 CellID->351662044]
}, Open  ]],
Cell[32330, 1254, 642, 23, 70, "ExampleText",
 CellID->305103021],
Cell[CellGroupData[{
Cell[32997, 1281, 232, 7, 70, "Input",
 CellID->4143643],
Cell[33232, 1290, 160, 5, 36, "Output",
 CellID->50910583]
}, Open  ]],
Cell[33407, 1298, 89, 1, 70, "ExampleText",
 CellID->216210672],
Cell[CellGroupData[{
Cell[33521, 1303, 105, 3, 70, "Input",
 CellID->188170419],
Cell[33629, 1308, 160, 5, 36, "Output",
 CellID->147657982]
}, Open  ]],
Cell[33804, 1316, 124, 3, 70, "ExampleDelimiter",
 CellID->49880954],
Cell[33931, 1321, 115, 3, 70, "ExampleText",
 CellID->261046469],
Cell[CellGroupData[{
Cell[34071, 1328, 747, 24, 70, "Input",
 CellID->301507413],
Cell[34821, 1354, 204, 5, 36, "Output",
 CellID->193453093],
Cell[35028, 1361, 201, 5, 36, "Output",
 CellID->417142601]
}, Open  ]],
Cell[CellGroupData[{
Cell[35266, 1371, 265, 8, 70, "Input",
 CellID->133135677],
Cell[35534, 1381, 160, 5, 36, "Output",
 CellID->10868266]
}, Open  ]],
Cell[35709, 1389, 125, 3, 70, "ExampleDelimiter",
 CellID->266928251],
Cell[35837, 1394, 130, 4, 70, "ExampleText",
 CellID->34519768],
Cell[35970, 1400, 154, 5, 70, "Input",
 CellID->320524364],
Cell[CellGroupData[{
Cell[36149, 1409, 224, 7, 70, "Input",
 CellID->55855877],
Cell[36376, 1418, 161, 5, 36, "Output",
 CellID->214826427]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36598, 1430, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[36917, 1441, 1212, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[38166, 1490, 299, 8, 70, "MoreAboutSection"],
Cell[38468, 1500, 159, 3, 70, "MoreAbout",
 CellID->96837357]
}, Open  ]],
Cell[38642, 1506, 27, 0, 70, "History"],
Cell[38672, 1508, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

