(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11503,        425]
NotebookOptionsPosition[      8493,        325]
NotebookOutlinePosition[      9823,        362]
CellTagsIndexPosition[      9739,        357]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Record" :> Documentation`HelpLookup["paclet:ref/Record"], 
          "RecordSeparators" :> 
          Documentation`HelpLookup["paclet:ref/RecordSeparators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Record\"\>", 
       2->"\<\"RecordSeparators\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RecordLists", "ObjectName",
 CellID->9974],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["RecordLists",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RecordLists"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["ReadList",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
     " which specifies whether objects from separate records should be \
returned in separate sublists. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27296]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RecordSeparators",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RecordSeparators"], "->", 
   RowBox[{"{", 
    RowBox[{"\"\<\\n\>\"", ",", "\"\<\\r\\n\>\"", ",", "\"\<\\r\>\""}], 
    "}"}]}]], "InlineFormula"],
 ", setting ",
 Cell[BoxData[
  RowBox[{"RecordLists", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["RecordLists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RecordLists"]], "InlineFormula"],
 " return objects that appear on different lines in different sublists. "
}], "Notes",
 CellID->3764],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"RecordLists", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " returns a single list of all objects it reads. "
}], "Notes",
 CellID->18223],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"RecordLists", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " returns a list containing a sublist for each record. "
}], "Notes",
 CellID->6607]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->505072111],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->371061088],

Cell["A list of numbers:", "ExampleText",
 CellID->2085608532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/numbers\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2077963939],

Cell["\<\
11.1   22.2    33.3
44.4   55.5    66.6\
\>", "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->296420324]
}, Open  ]],

Cell["Read the file:", "ExampleText",
 CellID->1192952071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/numbers\>\"", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->649728837],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "11.1`", ",", "22.2`", ",", "33.3`", ",", "44.4`", ",", "55.5`", ",", 
   "66.6`"}], "}"}]], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->295149944]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["RecordLists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RecordLists"]], "InlineFormula"],
 " sets to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1594510990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/numbers\>\"", ",", "Number", ",", 
   RowBox[{"RecordLists", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->240113995],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11.1`", ",", "22.2`", ",", "33.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44.4`", ",", "55.5`", ",", "66.6`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->154990773]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3140],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Record",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Record"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RecordSeparators",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RecordSeparators"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19796]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12074],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->790]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RecordLists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 27.5480132}", "context" -> "System`", 
    "keywords" -> {"structured lists", "separate records"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RecordLists is an option for ReadList which specifies whether objects \
from separate records should be returned in separate sublists. ", 
    "synonyms" -> {"record lists", "awk"}, "title" -> "RecordLists", "type" -> 
    "Symbol", "uri" -> "ref/RecordLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4628, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->505072111]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9596, 350}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1275, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1898, 59, 48, 1, 70, "ObjectName",
 CellID->9974],
Cell[1949, 62, 648, 19, 70, "Usage",
 CellID->27296]
}, Open  ]],
Cell[CellGroupData[{
Cell[2634, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3112, 103, 706, 23, 70, "Notes",
 CellID->3764],
Cell[3821, 128, 382, 14, 70, "Notes",
 CellID->18223],
Cell[4206, 144, 385, 14, 70, "Notes",
 CellID->6607]
}, Closed]],
Cell[CellGroupData[{
Cell[4628, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->505072111],
Cell[CellGroupData[{
Cell[5013, 177, 148, 5, 70, "ExampleSection",
 CellID->371061088],
Cell[5164, 184, 62, 1, 70, "ExampleText",
 CellID->2085608532],
Cell[CellGroupData[{
Cell[5251, 189, 132, 3, 70, "Input",
 CellID->2077963939],
Cell[5386, 194, 128, 5, 70, "Print",
 CellID->296420324]
}, Open  ]],
Cell[5529, 202, 58, 1, 70, "ExampleText",
 CellID->1192952071],
Cell[CellGroupData[{
Cell[5612, 207, 158, 4, 70, "Input",
 CellID->649728837],
Cell[5773, 213, 275, 9, 36, "Output",
 CellID->295149944]
}, Open  ]],
Cell[6063, 225, 440, 17, 70, "ExampleText",
 CellID->1594510990],
Cell[CellGroupData[{
Cell[6528, 246, 206, 5, 70, "Input",
 CellID->240113995],
Cell[6737, 253, 346, 11, 36, "Output",
 CellID->154990773]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7144, 271, 310, 9, 70, "SeeAlsoSection",
 CellID->3140],
Cell[7457, 282, 463, 17, 70, "SeeAlso",
 CellID->19796]
}, Open  ]],
Cell[CellGroupData[{
Cell[7957, 304, 314, 9, 70, "TutorialsSection",
 CellID->12074],
Cell[8274, 315, 147, 3, 70, "Tutorials",
 CellID->790]
}, Open  ]],
Cell[8436, 321, 27, 0, 70, "History"],
Cell[8466, 323, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

