(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    320497,      10670]
NotebookOptionsPosition[    283585,       9387]
NotebookOutlinePosition[    285566,       9435]
CellTagsIndexPosition[    285479,       9430]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Equations" :> 
          Documentation`HelpLookup["paclet:tutorial/SolvingEquations"], 
          "Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/Inequalities-SymbolicMathematics"], 
          "Generic and Non\[Hyphen]Generic Solutions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GenericAndNonGenericSolutions"], 
          "Equations and Inequalities over Domains" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EquationsAndInequalitiesOverDomains"], 
          "Solving Logical Combinations of Equations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingLogicalCombinationsOfEquations"], 
          "The Representation of Solution Sets" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfSolutionSets"], 
          "Complex Polynomial Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ComplexPolynomialSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Solving Equations\"\>", 
       2->"\<\"Inequalities\"\>", 
       3->"\<\"Generic and Non\[Hyphen]Generic Solutions\"\>", 
       4->"\<\"Equations and Inequalities over Domains\"\>", 
       5->"\<\"Solving Logical Combinations of Equations\"\>", 
       6->"\<\"The Representation of Solution Sets\"\>", 
       7->"\<\"Complex Polynomial Systems\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], 
          "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "Roots" :> 
          Documentation`HelpLookup["paclet:ref/Roots"], "Eliminate" :> 
          Documentation`HelpLookup["paclet:ref/Eliminate"], "Resolve" :> 
          Documentation`HelpLookup["paclet:ref/Resolve"], "LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"], "ToRules" :> 
          Documentation`HelpLookup["paclet:ref/ToRules"], "GroebnerBasis" :> 
          Documentation`HelpLookup["paclet:ref/GroebnerBasis"], 
          "CylindricalDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/CylindricalDecomposition"], 
          "SemialgebraicComponentInstances" :> 
          Documentation`HelpLookup[
           "paclet:ref/SemialgebraicComponentInstances"], "RowReduce" :> 
          Documentation`HelpLookup["paclet:ref/RowReduce"], 
          "ChineseRemainder" :> 
          Documentation`HelpLookup["paclet:ref/ChineseRemainder"], 
          "HermiteDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/HermiteDecomposition"], 
          "Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "SolveAlways" :> Documentation`HelpLookup["paclet:ref/SolveAlways"],
           "RegionPlot" :> Documentation`HelpLookup["paclet:ref/RegionPlot"], 
          "RegionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Solve\"\>", 
       2->"\<\"FindInstance\"\>", 3->"\<\"Roots\"\>", 4->"\<\"Eliminate\"\>", 
       5->"\<\"Resolve\"\>", 6->"\<\"LogicalExpand\"\>", 7->"\<\"ToRules\"\>",
        8->"\<\"GroebnerBasis\"\>", 9->"\<\"CylindricalDecomposition\"\>", 
       10->"\<\"SemialgebraicComponentInstances\"\>", 11->"\<\"RowReduce\"\>",
        12->"\<\"ChineseRemainder\"\>", 13->"\<\"HermiteDecomposition\"\>", 
       14->"\<\"Simplify\"\>", 15->"\<\"SolveAlways\"\>", 
       16->"\<\"RegionPlot\"\>", 
       17->"\<\"RegionPlot3D\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Diophantine Equations" :> 
          Documentation`HelpLookup["paclet:guide/DiophantineEquations"], 
          "Equation Solving" :> 
          Documentation`HelpLookup["paclet:guide/EquationSolving"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Functions of Complex Variables" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsOfComplexVariables"], "Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"], 
          "Manipulating Equations" :> 
          Documentation`HelpLookup["paclet:guide/ManipulatingEquations"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Equations" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialEquations"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>", 
       2->"\<\"Computational Geometry\"\>", 
       3->"\<\"Diophantine Equations\"\>", 4->"\<\"Equation Solving\"\>", 
       5->"\<\"Formula Manipulation\"\>", 
       6->"\<\"Functions of Complex Variables\"\>", 7->"\<\"Inequalities\"\>",
        8->"\<\"Manipulating Equations\"\>", 9->"\<\"Number Theory\"\>", 
       10->"\<\"Polynomial Algebra\"\>", 11->"\<\"Polynomial Equations\"\>", 
       12->"\<\"Polynomial Systems\"\>", 
       13->"\<\"Prime Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Reduce", "ObjectName",
 CellID->21763],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Reduce",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Reduce"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reduces the statement ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " by solving equations or inequalities for ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     " and eliminating quantifiers. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Reduce",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Reduce"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["vars", "TI"], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]does the reduction over the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     ". Common choices of ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     " are ",
     Cell[BoxData[
      ButtonBox["Reals",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Integers",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Complexes",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17753]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The statement ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " can be any logical combination of: "
}], "Notes",
 CellID->27158],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["lhs", "TI"], "==", 
     StyleBox["rhs", "TI"]}], Cell["equations ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["lhs", "TI"], "!=", 
     StyleBox["rhs", "TI"]}], Cell["inequations ", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], ">", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], ">=", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     " "
    }], "TableText"], Cell["inequalities ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["expr", "TI"], "\[Element]", 
     StyleBox["dom", "TI"]}], Cell["domain specifications ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["ForAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ForAll"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["cond", "TI"], ",", 
      StyleBox["expr", "TI"]}], "]"}], Cell[
    "universal quantifiers ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Exists",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exists"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["cond", "TI"], ",", 
      StyleBox["expr", "TI"]}], "]"}], Cell[
    "existential quantifiers ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->25550],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
 " always describes exactly the same mathematical set as ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9037],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "&&", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "&&", 
     StyleBox["\[Ellipsis]", "TR"]}], ",", 
    StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29072],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
 " assumes by default that quantities appearing algebraically in inequalities \
are real, while all other quantities are complex. "
}], "Notes",
 CellID->26739],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
 " restricts all variables and parameters to belong to the domain ",
 Cell[BoxData[
  StyleBox["dom", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1781],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["dom", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 ", or a subset such as ",
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Rationals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationals"]], "InlineFormula"],
 ", then all constants and function values are also restricted to be real. "
}], "Notes",
 CellID->26975],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["expr", "TI"], "&&", 
     RowBox[{
      StyleBox["vars", "TI"], "\[Element]", 
      ButtonBox["Reals",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reals"]}]}], ",", 
    StyleBox["vars", "TI"], ",", 
    ButtonBox["Complexes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complexes"]}], "]"}]], "InlineFormula"],
 " performs reductions with variables assumed real, but function values \
allowed to be complex. "
}], "Notes",
 CellID->29188],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    ButtonBox["Integers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integers"]}], "]"}]], "InlineFormula"],
 " reduces Diophantine equations over the integers. "
}], "Notes",
 CellID->19289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " effectively writes ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as a combination of conditions on ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", 
    SubscriptBox["x", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 " , where each condition involves only the earlier ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->7358],

Cell[TextData[{
 "Algebraic variables in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " free of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " and of each other are treated as independent parameters. "
}], "Notes",
 CellID->10963],

Cell[TextData[{
 "Applying ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to the results of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " yields an expression of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "1"], "||", 
    SubscriptBox["e", "2"], "||", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 ", where each of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " can be thought of as representing a separate component in the set defined \
by ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27254],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " may not be disjoint, and may have different dimensions. After ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 ", each of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " have the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"e", "&&", "e", "&&", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->23509],

Cell[TextData[{
 "Without ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " by default returns a nested collection of conditions on the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 ", combined alternately by ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " on successive levels. "
}], "Notes",
 CellID->27921],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " involves only polynomial equations and inequalities over real or complex \
domains then ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can always in principle solve directly for all the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->26307],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " involves transcendental conditions or integer domains ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " will often introduce additional parameters in its results. "
}], "Notes",
 CellID->6442],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " involves only polynomial conditions, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    ButtonBox["Reals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Reals"]}], "]"}]], "InlineFormula"],
 " gives a cylindrical algebraic decomposition of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27758],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can give explicit representations for solutions to all linear equations \
and inequalities over the integers, and can solve a large fraction of \
Diophantine equations described in the literature. "
}], "Notes",
 CellID->6249],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " involves only polynomial conditions over real or complex domains, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
 " will always eliminate quantifiers, so that quantified variables do not \
appear in the result. "
}], "Notes",
 CellID->13196],

Cell["The following options can be given: ", "Notes",
 CellID->5016],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "Backsubstitution", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to give results unwound by backsubstitution ",
     ButtonBox[" \[RightGuillemet]",
      BaseStyle->"ExampleLink",
      ButtonData->413959440,
      ButtonNote->"413959440"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Cubics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cubics"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to use explicit radicals to solve all cubics ",
     ButtonBox[" \[RightGuillemet]",
      BaseStyle->"ExampleLink",
      ButtonData->458422457,
      ButtonNote->"458422457"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["GeneratedParameters",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GeneratedParameters"], 
    ButtonBox["C",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/C"], Cell[TextData[{
     "how to name parameters that are generated ",
     ButtonBox[" \[RightGuillemet]",
      BaseStyle->"ExampleLink",
      ButtonData->940926257,
      ButtonNote->"940926257"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Modulus",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Modulus"], "0", Cell[TextData[{
     "modulus to assume for integers ",
     ButtonBox[" \[RightGuillemet]",
      BaseStyle->"ExampleLink",
      ButtonData->487344474,
      ButtonNote->"487344474"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Quartics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Quartics"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to use explicit radicals to solve all quartics ",
     ButtonBox[" \[RightGuillemet]",
      BaseStyle->"ExampleLink",
      ButtonData->199602890,
      ButtonNote->"199602890"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->29449],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"Backsubstitution", "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " yields a form in which values from equations generated for earlier ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " are backsubstituted so that the conditions for a particular ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " have only minimal dependence on earlier ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->413959440,
  ButtonNote->"413959440"]
}], "Notes",
 CellID->23083]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80221524],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->93369526],

Cell["Reduce equations and inequalities:", "ExampleText",
 CellID->99167031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "3"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62263588],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[Equal]", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"]}], ")"}], 
    RowBox[{"1", "/", "3"}]]}], "||", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}], "||", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"2", "/", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}]}]], "Output",
 ImageSize->{426, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->368180566]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15483236],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}]}]], "Output",
 ImageSize->{225, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->488535870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64489396],

Cell["Use specific domains:", "ExampleText",
 CellID->139222577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"7", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29655719],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "1"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"8", "-", 
         RowBox[{"3", " ", 
          SqrtBox["7"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"8", "+", 
         RowBox[{"3", " ", 
          SqrtBox["7"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"8", "-", 
         RowBox[{"3", " ", 
          SqrtBox["7"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"8", "+", 
         RowBox[{"3", " ", 
          SqrtBox["7"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]]}], 
     RowBox[{"2", " ", 
      SqrtBox["7"]}]]}]}]}]], "Output",
 ImageSize->{496, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290674151]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"7", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->118871955],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", ">", "1"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"]}]], 
    SqrtBox["7"]]}]}]], "Output",
 ImageSize->{139, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->660880540]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->630769760],

Cell["Reduce a quantified expression:", "ExampleText",
 CellID->46690342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"y", "^", "2"}]}]}], "\[LessEqual]", "1"}], " ", "&&", 
      RowBox[{
       RowBox[{"x", "-", "y"}], "\[GreaterEqual]", "2"}]}]}], "]"}], ",", 
   "a"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127138787],

Cell[BoxData[
 RowBox[{"a", "\[LessEqual]", 
  FractionBox["1", "3"]}]], "Output",
 ImageSize->{37, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34769662]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(40)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22751],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Complex Domain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->84922610],

Cell["A linear system:", "ExampleText",
 CellID->149821829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", "y"}], "-", 
      RowBox[{"5", "z"}]}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      RowBox[{"4", "y"}], "+", 
      RowBox[{"7", "z"}]}], "\[Equal]", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->284710479],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[Equal]", 
   RowBox[{"22", "-", 
    RowBox[{"29", " ", "x"}]}]}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"13", "-", 
    RowBox[{"17", " ", "x"}]}]}]}]], "Output",
 ImageSize->{173, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24909135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->253504289],

Cell["A univariate polynomial equation:", "ExampleText",
 CellID->64844045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"2", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->672643237],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["5"]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}]}]}]], "Output",
 ImageSize->{281, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4234581]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77578128],

Cell["A multivariate polynomial equation:", "ExampleText",
 CellID->169862198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", " ", "z"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288610958],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "1"}]}], "||", 
      RowBox[{"x", "\[Equal]", "1"}]}], ")"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}], "y"]}]}], ")"}]}]], "Output",
 ImageSize->{322, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283126778]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91534336],

Cell["\<\
Systems of polynomial equations and inequations can always be reduced:\
\>", "ExampleText",
 CellID->899471838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "3"}]}], "\[Equal]", "z"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"3", "z"}], "+", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y", " ", "z"}], "\[NotEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145589199],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "x", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "2"]}], "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], "||", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "x", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "2"]}], "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "2"}], "]"}]}], "||", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "x", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "2"]}], "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "3"}], "]"}]}]}], ")"}], 
  "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x", "+", 
      RowBox[{"2", " ", "y"}]}], ")"}]}]}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], " ", "y"}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"2", " ", "x", " ", 
     SuperscriptBox["y", "2"]}]}], "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{549, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294128277]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->644436505],

Cell["A quantified polynomial system:", "ExampleText",
 CellID->159443640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Exists", "[", 
      RowBox[{"y", ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"x", "^", "2"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"y", "^", "2"}]}], "-", 
          RowBox[{"3", "y"}]}], "\[Equal]", "1"}], "&&", 
        RowBox[{"y", "\[NotEqual]", "0"}]}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208385592],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", "0"}], "||", 
  RowBox[{"b", "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81529764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->700158465],

Cell["An algebraic system:", "ExampleText",
 CellID->546492545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", "+", 
        RowBox[{"2", "y"}]}], "]"}], "-", 
      RowBox[{"3", "x"}], "+", 
      RowBox[{"4", "y"}]}], "\[Equal]", "5"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"y", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "3"}], ")"}]}]}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31277144],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{467, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->278265867]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1314432],

Cell["Transcendental equations:", "ExampleText",
 CellID->288893094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "3"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256538498],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"\[Pi]", "-", 
      RowBox[{"ArcSin", "[", 
       FractionBox["1", "3"], "]"}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       FractionBox["1", "3"], "]"}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}]], "Output",
 ImageSize->{482, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607554765]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"4", "^", 
      RowBox[{"(", 
       RowBox[{"x", "^", "2"}], ")"}]}], 
     RowBox[{"2", "^", "x"}]}], "\[Equal]", "8"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->34551955],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{"8", " ", 
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
               RowBox[{"C", "[", "1", "]"}]}], 
              RowBox[{"Log", "[", "2", "]"}]], "+", 
             FractionBox[
              RowBox[{"Log", "[", "8", "]"}], 
              RowBox[{"Log", "[", "2", "]"}]]}], ")"}]}]}]]}], ")"}]}]}], "||",
     
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{"8", " ", 
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
               RowBox[{"C", "[", "1", "]"}]}], 
              RowBox[{"Log", "[", "2", "]"}]], "+", 
             FractionBox[
              RowBox[{"Log", "[", "8", "]"}], 
              RowBox[{"Log", "[", "2", "]"}]]}], ")"}]}]}]]}], ")"}]}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{577, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37115083]
}, Open  ]],

Cell["In this case there is no solution:", "ExampleText",
 CellID->101603241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"75", "/", "11"}], " ", "I", " ", "Pi"}], "+", "17"}]}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->474067602],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6156784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->385408181],

Cell["A system of transcendental equations:", "ExampleText",
 CellID->331511400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "y"}], "]"}], "\[Equal]", 
     RowBox[{"1", "/", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"E", "^", "x"}], "-", "y"}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67423421],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "2", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"1", "+", 
      FractionBox["\[Pi]", "6"], "-", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "2", "]"}]}], "-", 
      RowBox[{"ProductLog", "[", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], ",", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"1", "+", 
          FractionBox["\[Pi]", "6"], "-", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "2", "]"}]}]}]]}], "]"}]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"7", " ", "\[Pi]"}], "6"], "-", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "2", "]"}]}], "-", 
      RowBox[{"ProductLog", "[", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], ",", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"7", " ", "\[Pi]"}], "6"], "-", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "2", "]"}]}]}]]}], "]"}]}]}]}], ")"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", "x"]}]}]}]], "Output",
 ImageSize->{453, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305558310]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->642839680],

Cell["Systems involving special functions:", "ExampleText",
 CellID->226658394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Zeta", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163562302],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "::", "\<\"rhyp\"\>"}], ":", 
  " ", "\<\"Warning: \\!\\(Reduce\\) assumed the Riemann hypothesis in order \
to prove the solution set found is complete.\"\>"}]], "Message",
 CellID->251018665],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "1"}], "&&", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[NotEqual]", "0"}], "&&", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{"ZetaZero", "[", 
        RowBox[{"C", "[", "1", "]"}], "]"}]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{513, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->594592970]
}, Open  ]],

Cell["Solving this system does not require the Riemann hypothesis:", \
"ExampleText",
 CellID->286979904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Zeta", "[", "x", "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"Re", "[", "x", "]"}], "\[Equal]", 
     RowBox[{"1", "/", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"Im", "[", "x", "]"}], "^", "2"}], "<", "500"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->912028475],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"ZetaZero", "[", 
    RowBox[{"-", "2"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"ZetaZero", "[", 
    RowBox[{"-", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"ZetaZero", "[", "1", "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"ZetaZero", "[", "2", "]"}]}]}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221134888]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Real Domain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(15)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->57305448],

Cell["A linear system:", "ExampleText",
 CellID->787469300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", "y"}], "-", 
      RowBox[{"5", "z"}]}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      RowBox[{"4", "y"}], "+", 
      RowBox[{"7", "z"}]}], "\[Equal]", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->9250850],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[Equal]", 
   RowBox[{"22", "-", 
    RowBox[{"29", " ", "x"}]}]}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"13", "-", 
    RowBox[{"17", " ", "x"}]}]}]}]], "Output",
 ImageSize->{173, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208845146]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114190875],

Cell["A univariate polynomial equation:", "ExampleText",
 CellID->81649366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"2", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x", ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193942569],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}]}]], "Output",
 ImageSize->{539, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->866946966]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->489808851],

Cell["A univariate polynomial inequality:", "ExampleText",
 CellID->292696808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"2", "x"}], "+", "1"}], "<", "0"}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->76644507],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "<", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], "<", "x", "<", 
   "1"}]}]], "Output",
 ImageSize->{504, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48543530]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97040171],

Cell["A multivariate polynomial equation:", "ExampleText",
 CellID->630117658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", " ", "z"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->758827168],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "<", "0"}], "||", 
      RowBox[{"y", ">", "0"}]}], ")"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], "y"]}]}]}], ")"}]}]], "Output",
 ImageSize->{434, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->637768961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->354625005],

Cell["A multivariate polynomial inequality:", "ExampleText",
 CellID->14844610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"2", "y"}], " ", "+", 
     RowBox[{"z", "^", "2"}]}], "\[LessEqual]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->223254230],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "&&", 
    RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", ">", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "y"}]}]]}], "\[LessEqual]", "z", "\[LessEqual]", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", " ", "y"}]}]]}]}], ")"}]}]], "Output",
 ImageSize->{507, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17370113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->389602569],

Cell["\<\
Systems of polynomial equations and inequalities can always be reduced:\
\>", "ExampleText",
 CellID->375009844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", " ", "z"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], "\[LessEqual]", 
     RowBox[{
      RowBox[{"3", "z"}], "+", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y", " ", "z"}], ">", "7"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->91668569],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "<", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"7", "-", "#1", "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
  RowBox[{"y", "<", "0"}], "&&", 
  RowBox[{"z", "\[Equal]", 
   FractionBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}], "y"]}]}]], "Output",
 ImageSize->{289, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66066894]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->69923244],

Cell["A quantified polynomial system:", "ExampleText",
 CellID->356535914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Exists", "[", 
      RowBox[{"y", ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"x", "^", "2"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"y", "^", "2"}]}], "-", 
          RowBox[{"3", "y"}]}], "\[Equal]", "1"}], "&&", 
        RowBox[{"y", "<", "0"}]}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->236241633],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "<", "0"}], "&&", 
    RowBox[{"b", "\[GreaterEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[GreaterEqual]", 
     RowBox[{"-", 
      FractionBox["9", "4"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["9", "4"]}], "\[LessEqual]", "b", "<", "0"}]}], 
   ")"}]}]], "Output",
 ImageSize->{360, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->478967716]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125859915],

Cell["An algebraic system:", "ExampleText",
 CellID->15168201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", "+", 
        RowBox[{"2", "y"}]}], "]"}], "-", 
      RowBox[{"3", "x"}], "+", 
      RowBox[{"4", "y"}]}], "\[GreaterEqual]", "5"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"y", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "3"}], ")"}]}]}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126906310],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[LessEqual]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"35", " ", "#1"}], "+", 
       RowBox[{"195", " ", 
        SuperscriptBox["#1", "2"]}], "-", 
       RowBox[{"350", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"264", " ", 
        SuperscriptBox["#1", "4"]}], "-", 
       RowBox[{"96", " ", 
        SuperscriptBox["#1", "5"]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["#1", "6"]}]}], "&"}], ",", "2"}], "]"}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"1", "-", 
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    SuperscriptBox["x", "3"]}]}]}]], "Output",
 ImageSize->{562, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380404304]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141393736],

Cell["Piecewise equations:", "ExampleText",
 CellID->309755201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"Abs", "[", 
           RowBox[{"x", "+", "2"}], "]"}]}], ")"}], "^", "2"}], "-", "1"}], 
      "]"}], "^", "2"}], "\[Equal]", "9"}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6175762],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[LessEqual]", 
   RowBox[{"-", "2"}]}], "||", 
  RowBox[{"x", "\[Equal]", "0"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22728350]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Max", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", 
    RowBox[{"Min", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "^", "2"}], "-", "x"}], ",", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->327866928],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[LessEqual]", "0"}], "&&", 
    RowBox[{"y", "\[LessEqual]", "x"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", "2"}], "&&", 
    RowBox[{"y", "\[LessEqual]", 
     RowBox[{
      RowBox[{"-", 
       SqrtBox["2"]}], " ", 
      SqrtBox["x"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[LessEqual]", 
       RowBox[{"-", "2"}]}], "||", 
      RowBox[{"y", "\[Equal]", "2"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", "2"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[LessEqual]", 
       RowBox[{
        RowBox[{"-", 
         SqrtBox["2"]}], " ", 
        SqrtBox["x"]}]}], "||", 
      RowBox[{
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox["x"]}], "\[LessEqual]", "y", "\[LessEqual]", "x"}]}], ")"}]}],
    ")"}]}]], "Output",
 ImageSize->{463, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37933245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->233833830],

Cell["Piecewise inequalities:", "ExampleText",
 CellID->619582499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"3", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"7", "x"}], "-", "6"}], "]"}], "<", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "x"}], "]"}]}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->712190582],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "-", 
      SqrtBox["33"]}], ")"}]}], "<", "x", "<", 
   RowBox[{"2", "-", 
    SqrtBox["7"]}]}], "||", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      SqrtBox["33"]}], ")"}]}], "<", "x", "<", 
   RowBox[{"2", "+", 
    SqrtBox["7"]}]}]}]], "Output",
 ImageSize->{338, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311288270]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"Ceiling", "[", 
       RowBox[{"x", "^", "2"}], "]"}]}], "]"}], "<", "10"}], ",", "x", ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74944114],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox["5"]}], "<", "x", "<", 
  SqrtBox["5"]}]], "Output",
 ImageSize->{95, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->209676694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22193703],

Cell["Transcendental equations:", "ExampleText",
 CellID->178378100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"E", "^", "x"}], "-", "x"}], "\[Equal]", "7"}], ",", "x", ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32163487],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "7"}], "-", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"-", 
      FractionBox["1", 
       SuperscriptBox["\[ExponentialE]", "7"]]}], "]"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "7"}], "-", 
    RowBox[{"ProductLog", "[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", 
       FractionBox["1", 
        SuperscriptBox["\[ExponentialE]", "7"]]}]}], "]"}]}]}]}]], "Output",
 ImageSize->{369, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30066752]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", " ", 
  RowBox[{
   RowBox[{
    RadicalBox[
     SuperscriptBox["27", 
      RowBox[{
       RowBox[{"2", "x"}], "-", "1"}]], "x"], "==", 
    SqrtBox[
     SuperscriptBox["9", 
      RowBox[{
       RowBox[{"2", "x"}], "-", "1"}]]]}], ",", " ", "x", " ", ",", " ", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->849204275],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", "2187", "]"}], 
     RowBox[{"4", " ", 
      RowBox[{"Log", "[", "3", "]"}]}]], "-", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "24"}], "+", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"Log", "[", "2187", "]"}], "2"], 
        SuperscriptBox[
         RowBox[{"Log", "[", "3", "]"}], "2"]]}]]}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", "2187", "]"}], 
     RowBox[{"4", " ", 
      RowBox[{"Log", "[", "3", "]"}]}]], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "24"}], "+", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"Log", "[", "2187", "]"}], "2"], 
        SuperscriptBox[
         RowBox[{"Log", "[", "3", "]"}], "2"]]}]]}]}]}]}]], "Output",
 ImageSize->{511, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51620580]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53285106],

Cell["Transcendental inequalities:", "ExampleText",
 CellID->245801814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "<", 
    RowBox[{"1", "/", "3"}]}], ",", "x", ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285456402],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "-", 
    RowBox[{"ArcSin", "[", 
     FractionBox["1", "3"], "]"}], "+", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}], "<", "x", "<", 
   RowBox[{
    RowBox[{"ArcSin", "[", 
     FractionBox["1", "3"], "]"}], "+", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}]}]], "Output",
 ImageSize->{443, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->279694008]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", " ", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["2", "x"], "-", "1"}]], ">", 
    FractionBox["1", 
     RowBox[{"1", "-", 
      SuperscriptBox["2", 
       RowBox[{"x", "-", "1"}]]}]]}], ",", " ", "x", " ", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->44025090],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", "x", "<", 
   FractionBox[
    RowBox[{"Log", "[", 
     FractionBox["4", "3"], "]"}], 
    RowBox[{"Log", "[", "2", "]"}]]}], "||", 
  RowBox[{"x", ">", "1"}]}]], "Output",
 ImageSize->{143, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->193547581]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147547389],

Cell["Transcendental systems:", "ExampleText",
 CellID->202401352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "y"}], "]"}], "==", 
     RowBox[{"1", "/", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"E", "^", "x"}], "-", "y"}], "\[LessEqual]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31650260],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"x", "\[Equal]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"\[Pi]", "+", 
            RowBox[{"12", " ", "\[Pi]", " ", 
             RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}], "||", 
        RowBox[{"y", "\[Equal]", 
         RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "\[Pi]"}], "+", 
            RowBox[{"12", " ", "\[Pi]", " ", 
             RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}], ")"}]}], ")"}], "||",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[LessEqual]", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Pi]", "+", 
          RowBox[{"12", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}], "-", 
          RowBox[{"6", " ", 
           RowBox[{"ProductLog", "[", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"1", "+", 
              FractionBox["\[Pi]", "6"], "+", 
              RowBox[{"2", " ", "\[Pi]", " ", 
               RowBox[{"C", "[", "1", "]"}]}]}]], "]"}]}]}], ")"}]}]}], "&&", 
      
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         RowBox[{"\[Pi]", "-", 
          RowBox[{"6", " ", "x"}], "+", 
          RowBox[{"12", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[LessEqual]", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", 
          RowBox[{"5", " ", "\[Pi]"}], "+", 
          RowBox[{"12", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}], "-", 
          RowBox[{"6", " ", 
           RowBox[{"ProductLog", "[", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"1", "+", 
              FractionBox[
               RowBox[{"5", " ", "\[Pi]"}], "6"], "+", 
              RowBox[{"2", " ", "\[Pi]", " ", 
               RowBox[{"C", "[", "1", "]"}]}]}]], "]"}]}]}], ")"}]}]}], "&&", 
      
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", "\[Pi]"}], "-", 
          RowBox[{"6", " ", "x"}], "+", 
          RowBox[{"12", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{570, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->557904129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["3", "x"], "-", 
      SuperscriptBox["2", 
       RowBox[{"2", "y"}]]}], "\[Equal]", "77"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      SqrtBox[
       SuperscriptBox["3", "x"]], "-", 
      SuperscriptBox["2", "y"]}], "\[Equal]", "7"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y"}], "}"}], ",", " ", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->942160119],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", "9", "]"}]}], 
    RowBox[{"Log", "[", "3", "]"}]]}], "&&", 
  RowBox[{"y", "\[Equal]", "1"}]}]], "Output",
 ImageSize->{135, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->198968466]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->164663613],

Cell["Systems involving special functions:", "ExampleText",
 CellID->366956007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"AiryBi", "[", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{"99", "<", "x", "<", "100"}]}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->426417430],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"205874", "\[LessEqual]", 
   RowBox[{"C", "[", "1", "]"}], "\[LessEqual]", "212175"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"AiryBiZero", "[", 
      RowBox[{"C", "[", "1", "]"}], "]"}]}]]}]}]], "Output",
 ImageSize->{458, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11916627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->998532594],

Cell["Systems involving zeros of special functions:", "ExampleText",
 CellID->105914447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"900", "<", 
    RowBox[{
     RowBox[{"AiryAiZero", "[", 
      RowBox[{
       RowBox[{"2", "t"}], "+", "1"}], "]"}], "^", "2"}], "<", "1000"}], ",", 
   "t", ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63580255],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "\[Equal]", 
   FractionBox["35", "2"]}], "||", 
  RowBox[{"t", "\[Equal]", "18"}]}]], "Output",
 ImageSize->{104, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396328815]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Integer Domain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->247179601],

Cell["Linear system of equations:", "ExampleText",
 CellID->91649387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", "y"}], "-", 
      RowBox[{"5", "z"}]}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      RowBox[{"4", "y"}], "+", 
      RowBox[{"7", "z"}]}], "\[Equal]", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31436120],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"C", "[", "1", "]"}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"22", "-", 
    RowBox[{"29", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"13", "-", 
    RowBox[{"17", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}]}]], "Output",
 ImageSize->{405, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124861910]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56626870],

Cell["A linear system of equations and inequalities:", "ExampleText",
 CellID->610547063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "4"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      RowBox[{"4", "y"}]}], "\[LessEqual]", "5"}], "&&", 
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"2", "y"}]}], ">", 
     RowBox[{"-", "21"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336458608],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "7"}]}], "&&", 
      RowBox[{"y", "\[Equal]", "6"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "4"}]}], "&&", 
      RowBox[{"y", "\[Equal]", "4"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "1"}]}], "&&", 
      RowBox[{"y", "\[Equal]", "2"}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{464, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76211477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20516472],

Cell["A univariate polynomial equation:", "ExampleText",
 CellID->68329701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "1000"}], "-", 
     RowBox[{"2", 
      RowBox[{"x", "^", "777"}]}], "+", "1"}], "\[Equal]", "0"}], ",", "x", 
   ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->626380406],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", "1"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11854612]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327203451],

Cell["A univariate polynomial inequality:", "ExampleText",
 CellID->292309597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"2", "x"}], "+", "1"}], "<", "0"}], ",", "x", ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50212146],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[LessEqual]", 
   RowBox[{"-", "2"}]}]}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->545122753]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->487716768],

Cell["Binary quadratic equations:", "ExampleText",
 CellID->149610693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"x", " ", "y"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "109"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408955322],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "12"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "5"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "12"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "7"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "7"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "5"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "7"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "12"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "5"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "7"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "5"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "12"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "5"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "12"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "5"}], "&&", 
    RowBox[{"y", "\[Equal]", "7"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "7"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "12"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "7"}], "&&", 
    RowBox[{"y", "\[Equal]", "5"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "12"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "7"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "12"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "5"}]}]}], ")"}]}]], "Output",
 ImageSize->{522, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355882767]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"3", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "22"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->78572943],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{541, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->562950459]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"6", " ", "x", " ", "y"}], "+", 
     RowBox[{"9", 
      RowBox[{"y", "^", "2"}]}], "-", "x", "+", 
     RowBox[{"2", "y"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->157947200],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "3"}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"C", "[", "1", "]"}]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"C", "[", "1", "]"}], "2"]}]}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"C", "[", "1", "]"}], "+", 
    SuperscriptBox[
     RowBox[{"C", "[", "1", "]"}], "2"]}]}]}]], "Output",
 ImageSize->{413, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->654836023]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160308141],

Cell["A Thue equation:", "ExampleText",
 CellID->146235021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"2", 
      RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
     RowBox[{"y", "^", "3"}]}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264134555],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "5"}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}]}], ")"}]}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->516322150]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140799112],

Cell["A sum of squares equation:", "ExampleText",
 CellID->297997273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"9", 
       RowBox[{"z", "^", "2"}]}], "+", 
      RowBox[{"16", 
       RowBox[{"t", "^", "2"}]}]}], "\[Equal]", "354"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"t", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->454294297],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}], "&&", 
    RowBox[{"t", "\[Equal]", "4"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "4"}], "&&", 
    RowBox[{"z", "\[Equal]", "5"}], "&&", 
    RowBox[{"t", "\[Equal]", "2"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "8"}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}], "&&", 
    RowBox[{"t", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "5"}], "&&", 
    RowBox[{"y", "\[Equal]", "4"}], "&&", 
    RowBox[{"z", "\[Equal]", "1"}], "&&", 
    RowBox[{"t", "\[Equal]", "4"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "5"}], "&&", 
    RowBox[{"y", "\[Equal]", "8"}], "&&", 
    RowBox[{"z", "\[Equal]", "1"}], "&&", 
    RowBox[{"t", "\[Equal]", "2"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "7"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}], "&&", 
    RowBox[{"z", "\[Equal]", "5"}], "&&", 
    RowBox[{"t", "\[Equal]", "2"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "7"}], "&&", 
    RowBox[{"y", "\[Equal]", "4"}], "&&", 
    RowBox[{"z", "\[Equal]", "5"}], "&&", 
    RowBox[{"t", "\[Equal]", "1"}]}], ")"}]}]], "Output",
 ImageSize->{442, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->545719400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146400772],

Cell["The Pythagorean equation:", "ExampleText",
 CellID->756311395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", 
    RowBox[{"z", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242404353],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "|", 
     RowBox[{"C", "[", "2", "]"}], "|", 
     RowBox[{"C", "[", "3", "]"}]}], ")"}], "\[Element]", "Integers"}], "&&", 
  
  RowBox[{
   RowBox[{"C", "[", "3", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"C", "[", "2", "]"}], "2"], "-", 
          SuperscriptBox[
           RowBox[{"C", "[", "3", "]"}], "2"]}], ")"}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"2", " ", 
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"C", "[", "3", "]"}]}]}], "&&", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"C", "[", "2", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"C", "[", "3", "]"}], "2"]}], ")"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"2", " ", 
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"C", "[", "3", "]"}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"C", "[", "2", "]"}], "2"], "-", 
          SuperscriptBox[
           RowBox[{"C", "[", "3", "]"}], "2"]}], ")"}]}]}], "&&", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"C", "[", "2", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"C", "[", "3", "]"}], "2"]}], ")"}]}]}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{510, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->427821337]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11130723],

Cell["A bounded system of equations and inequalities:", "ExampleText",
 CellID->502130737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "+", 
      RowBox[{"y", "^", "4"}], "+", 
      RowBox[{"z", "^", "4"}]}], "\[LessEqual]", "500"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "3"}]}], "\[Equal]", "32"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->572071652],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "3"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "4"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "4"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}]}]], "Output",
 ImageSize->{530, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15060585]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->336612686],

Cell["\<\
A high\[Hyphen]degree system with no solution:\
\>", "ExampleText",
 CellID->90785482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", 
      RowBox[{"x", "^", "7"}]}], "+", 
     RowBox[{"8", 
      RowBox[{"y", "^", "15"}]}], "+", 
     RowBox[{"14", " ", "x", " ", "y", " ", "z"}]}], "\[Equal]", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15565691],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129476275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->311367224],

Cell["Transcendental Diophantine systems:", "ExampleText",
 CellID->357909727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"y", "^", "2"}], "]"}], "<", "x"}], "&&", 
    RowBox[{
     RowBox[{"Abs", "[", "x", "]"}], "<", "5"}], "&&", 
    RowBox[{
     RowBox[{"Abs", "[", "y", "]"}], "<", "5"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114962634],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "3"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", "0"}], "||", 
      RowBox[{"y", "\[Equal]", "1"}], "||", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", "1"}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "4"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", "0"}], "||", 
      RowBox[{"y", "\[Equal]", "1"}], "||", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", "1"}]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{576, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60320429]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"5", 
         RowBox[{"y", "^", "2"}]}], "+", "1"}], "]"}], "+", 
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"5", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->602714198],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "1"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"9", "-", 
            RowBox[{"4", " ", 
             SqrtBox["5"]}]}], ")"}], 
          RowBox[{"C", "[", "1", "]"}]]}], "-", 
        RowBox[{
         SqrtBox["5"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"9", "-", 
            RowBox[{"4", " ", 
             SqrtBox["5"]}]}], ")"}], 
          RowBox[{"C", "[", "1", "]"}]]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"4", " ", 
             SqrtBox["5"]}]}], ")"}], 
          RowBox[{"C", "[", "1", "]"}]]}], "+", 
        RowBox[{
         SqrtBox["5"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"4", " ", 
             SqrtBox["5"]}]}], ")"}], 
          RowBox[{"C", "[", "1", "]"}]]}]}], ")"}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "10"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"9", "-", 
            RowBox[{"4", " ", 
             SqrtBox["5"]}]}], ")"}], 
          RowBox[{"C", "[", "1", "]"}]]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["5"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"9", "-", 
            RowBox[{"4", " ", 
             SqrtBox["5"]}]}], ")"}], 
          RowBox[{"C", "[", "1", "]"}]]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"4", " ", 
             SqrtBox["5"]}]}], ")"}], 
          RowBox[{"C", "[", "1", "]"}]]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["5"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"4", " ", 
             SqrtBox["5"]}]}], ")"}], 
          RowBox[{"C", "[", "1", "]"}]]}]}], ")"}]}]}]}], ")"}]}]], "Output",
 ImageSize->{575, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21570213]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->731201360],

Cell["A polynomial system of congruences:", "ExampleText",
 CellID->4884468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ",", "2"}], "]"}], "\[Equal]", "1"}], "&&",
     
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"x", "-", 
        RowBox[{"2", "y"}]}], ",", "3"}], "]"}], "\[Equal]", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146539654],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdW9tu1DAQTZPNbkuh0Au0XIoKD/AAoi1vgMRFIHjihR9AFUJqHxCo9BPh
u0ImsXe9J5PYju3EpRLrTOJ4xsdje3wyfD65OP3+4+Ti7NvJwafzk1+nZ99+
H3z8eV7eylaSZOVPkiTv95Lyuiivqn/097f8V1/WV3foN5NPi+R1+ZOW4roo
98pyUpYv4f4E3lsDWff8DbS3K/Q81uhB+WHVi9tM66q8DvIeyC809TOQVzVW
4fO3mvZ3QX5kaQ/qf1ChUvVyMr8rEE1FuV2WeVlO4V2SSZyJMofnqXgPdU5F
u7Vx1e25LvUe6tsRehCzvKcdKM9Mnrei1GZdX5RyR5Rc0UD5oJh7CrSmYCK8
hCrUDci/CrtcxS5hPCpna/F3be3PG5ZmjTurAl+bPrBe07MPaa+eGvlt55hJ
X1nu79SovyHHbNKwtH3MbPoQcjTM5k0mrL7FoJm3WohzGeeP0RwQrc5/l/q5
uKu2TTLXg/k6Ym0p7ktY39XHJb6430urw+CrYmGL784gONp5Jz+nMEKzWMUd
sNXVh91ZaGxajxESi1gYz/Dgz6tsn65o+hRwNbEaEX5f7VijPSLeN57BiJvD
dpLw0bFP/+ZRulks/ALfNrEKe6M7L7jHGmQxFyf7wlHnlTyO24Hw6vC61pME
etxVDca2CM2Enlwpm7MSIxNbK1BODayyWE2K5ulLrX3DM2byzNqN2VZgjHhv
whinkhsefp3T7RzdPvOoyyzedmVYkMfaDIfLQAjwnA72k7yCxE1RkkUT0Xqq
lNLDjw3qZyCr+mx5vtuifVv7bO3ieUG6RMbT/io2jvSVo57KH/87zvSlZ3tq
lLr3dNpNs4SPakkcikOVXC7H4vSxw+8u3mbd0ByqHC1fjLctSopH4V2D8xT6
cxcLNG8qGpYV16T/l1/FdeVyMasOnMNI48TPKsms0Ll0KnCIk4Ft44rjZmA5
/iReBnYq8OxvoW9cu72Wn5vOX9scRsAXT+uwD7j6jwev53lahxXfdc2xGhEb
nnaYPoSKoG6yfcf+jMvv6vodJ8+LuxXnJ+PxvTsNe/va5xtZk9Ok6hXUmw2N
jjAMMXKutlYMyxDjTEKOchiGWMWMZFsrfGPGMzx3NVb64UiPNCMSE2t8F2T8
vuAHkUPAvZ+WMIjUnoIMJ+GSCkuzxIy1pXKro34GsqqvD6ssmSUT+56LMhTr
XaNIl+5sM36RQ11PijCsMHrKG2jPF8u9X/VSx2Y9BXlo9hdX2Lea9kOz4zVq
yM4A31PwuatD56j6ypW13fWmRmj4ss6Vqx+Lhe7wJFzRemcAx8Jmhs91DcNp
svHgpcjtDZWP7TOnPMyYmc0rlZeOiydtywSOgy/l2h8+E9iF58eTqhtj7htf
O++14adj4TnHyab15ecxZQiH+hYwzJeMoeIlijfHZUK5aHcs/lMf0RCzzOU8
j8vUc19nY8Czz3lwW6MjDDeKWm1zeH1zo92nROQVrnnG7HJmaZtxNsgihsm5
7ZfZG4Y9Rdz4HO0wrHL8Odq11+j4TPKaLNFzuEeFPpM4A1nVY8t/yszqLk57
yMzqGk26dOeYcTdaK5Y5XcRiA56jbYeibyR8qDRgDdypcC3BFQu/Our402OQ
6eddZQnWzAp7ng9lm/e5NWMi3qf6dUPyT1aWVmaiNpZSWypkua/o2Egy4R6L
i5//F20Ww/thZFAXziC+1arfM7grnvGrJe6ebCzHn1M0TBgV94vW0fAY7frm
Exyw10XB1vhz2VqmLA29sB/FCPSZaVxWvTnyOaCyjHjOvCX3MF28SD9x+LXt
ucvEr9NW3PjVDvvc/r5ke/h5oMMqHtT7nD/kLtY8m8n9S15Kz1SjKbVOWiz2
Tu59db+U0dsCOx57HaJj7otoG564Mfainy9VW7BHFd0RLvfl1CbC3RJjR8LX
Sj9dmcSryco/laF17A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{452, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19398052]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modular Domains",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->208071237],

Cell["A linear system:", "ExampleText",
 CellID->75271447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", "y"}], "-", 
      RowBox[{"5", "z"}]}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      RowBox[{"4", "y"}], "+", 
      RowBox[{"7", "z"}]}], "\[Equal]", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "12"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154699585],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"C", "[", "1", "]"}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"10", "+", 
    RowBox[{"7", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"1", "+", 
    RowBox[{"7", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}]}]], "Output",
 ImageSize->{266, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109556617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21536370],

Cell["A univariate polynomial equation:", "ExampleText",
 CellID->60093961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"2", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55991068],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", "2"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->485395966]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332381957],

Cell["A multivariate polynomial equation:", "ExampleText",
 CellID->210277461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", " ", "z"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7784294],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{502, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->410615911]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82067436],

Cell["A system of polynomial equations and inequations:", "ExampleText",
 CellID->276046792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "3"}]}], "\[Equal]", "z"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"3", "z"}], "+", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y", " ", "z"}], "\[NotEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221242426],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "5"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}], "&&", 
    RowBox[{"z", "\[Equal]", "5"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "5"}], "&&", 
    RowBox[{"y", "\[Equal]", "6"}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "6"}], "&&", 
    RowBox[{"y", "\[Equal]", "4"}], "&&", 
    RowBox[{"z", "\[Equal]", "2"}]}], ")"}]}]], "Output",
 ImageSize->{482, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->425470587]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->651713204],

Cell["Reduce a quantified polynomial system:", "ExampleText",
 CellID->453041102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Exists", "[", 
      RowBox[{"y", ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"x", "^", "2"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"y", "^", "2"}]}], "-", 
          RowBox[{"3", "y"}]}], "\[Equal]", "1"}], "&&", 
        RowBox[{"y", "\[NotEqual]", "0"}]}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->646939176],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", "0"}], "&&", 
  RowBox[{"b", "\[Equal]", "1"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->482201498]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mixed Domains",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->247230330],

Cell["Mixed real and complex variables:", "ExampleText",
 CellID->371793992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->730229669],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["x", "2"]}]]}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["x", "2"]}]]}]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{433, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102282103]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->740254980],

Cell[TextData[{
 "Find real values of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and complex values of ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    StyleBox["x", "TI"], "2"], "+", 
   SuperscriptBox[
    StyleBox["y", "TI"], "2"]}]], "InlineFormula"],
 " is real and less than ",
 Cell[BoxData["1"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->399380530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}], " ", "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67018416],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"Re", "[", "y", "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "y", "]"}], "<", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{
       RowBox[{"Im", "[", "y", "]"}], ">", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"Re", "[", "y", "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "y", "]"}], "<", "0"}], "||", 
      RowBox[{
       RowBox[{"Im", "[", "y", "]"}], ">", "0"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"]}]]}], "<", 
         RowBox[{"Re", "[", "y", "]"}], "<", "0"}], "&&", 
        RowBox[{
         RowBox[{"Im", "[", "y", "]"}], "\[Equal]", "0"}]}], ")"}], "||", 
      RowBox[{
       RowBox[{"Re", "[", "y", "]"}], "\[Equal]", "0"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"0", "<", 
         RowBox[{"Re", "[", "y", "]"}], "<", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"]}]]}], "&&", 
        RowBox[{
         RowBox[{"Im", "[", "y", "]"}], "\[Equal]", "0"}]}], ")"}]}], ")"}]}],
    ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"Re", "[", "y", "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "y", "]"}], "<", "0"}], "||", 
      RowBox[{
       RowBox[{"Im", "[", "y", "]"}], ">", "0"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", "1"}], "&&", 
    RowBox[{
     RowBox[{"Re", "[", "y", "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "y", "]"}], "<", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{
       RowBox[{"Im", "[", "y", "]"}], ">", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{426, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34795850]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->195936302],

Cell[TextData[{
 "Reduce an inequality involving ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->372916470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"1", "<", 
    RowBox[{"Abs", "[", " ", 
     FractionBox[
      RowBox[{"z", "-", "2"}], 
      RowBox[{
       RowBox[{"2", "z"}], "-", "1"}]], "]"}], "<", "2"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->363312606],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", 
     RowBox[{"Re", "[", "z", "]"}], "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"Re", "[", "z", "]"}], "2"]}]]}], "<", 
     RowBox[{"Im", "[", "z", "]"}], "<", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Re", "[", "z", "]"}], "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "\[LessEqual]", 
     RowBox[{"Re", "[", "z", "]"}], "\[LessEqual]", 
     FractionBox["4", "5"]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox[
           RowBox[{"Re", "[", "z", "]"}], "2"]}]]}], "<", 
       RowBox[{"Im", "[", "z", "]"}], "<", 
       RowBox[{"-", 
        FractionBox[
         SqrtBox[
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{"Re", "[", "z", "]"}]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox[
             RowBox[{"Re", "[", "z", "]"}], "2"]}]}]], 
         SqrtBox["5"]]}]}], "||", 
      RowBox[{
       FractionBox[
        SqrtBox[
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"Re", "[", "z", "]"}]}], "-", 
          RowBox[{"5", " ", 
           SuperscriptBox[
            RowBox[{"Re", "[", "z", "]"}], "2"]}]}]], 
        SqrtBox["5"]], "<", 
       RowBox[{"Im", "[", "z", "]"}], "<", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox[
          RowBox[{"Re", "[", "z", "]"}], "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["4", "5"], "<", 
     RowBox[{"Re", "[", "z", "]"}], "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"Re", "[", "z", "]"}], "2"]}]]}], "<", 
     RowBox[{"Im", "[", "z", "]"}], "<", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Re", "[", "z", "]"}], "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{432, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68864444]
}, Open  ]],

Cell["Plot the solution set:", "ExampleText",
 CellID->738493673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "=", 
     RowBox[{"u", "+", 
      RowBox[{"I", " ", "v"}]}]}], "}"}], ",", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{"1", "<", 
      RowBox[{"Abs", "[", " ", 
       FractionBox[
        RowBox[{"z", "-", "2"}], 
        RowBox[{
         RowBox[{"2", "z"}], "-", "1"}]], "]"}], "<", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32712653],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->179148705]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16960],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Backsubstitution",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->63064318],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " appears after ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in the variable list, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " may use ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to express the solution for ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->413959440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "y"}], "\[Equal]", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->386474141],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["3", "2"], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}], "2"]}]]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     SqrtBox[
      RowBox[{
       FractionBox["3", "2"], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}], "2"]}]]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["3", "2"], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}], "2"]}]]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     SqrtBox[
      RowBox[{
       FractionBox["3", "2"], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}], "2"]}]]}]}], ")"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["x", "2"]}]}]}]], "Output",
 ImageSize->{532, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->449644696]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Backsubstitution", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives explicit numeric values for ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->232545081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "y"}], "\[Equal]", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Backsubstitution", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36241711],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"3", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}]}]]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", 
        SqrtBox["3"]}], ")"}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", 
        SqrtBox["3"]}], ")"}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}]}]]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", "+", 
        SqrtBox["3"]}], ")"}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", "+", 
        SqrtBox["3"]}], ")"}]}]}]}], ")"}]}]], "Output",
 ImageSize->{574, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->243651586]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Cubics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->406483917],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " does not use general formulas for solving cubics in radicals:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->458422457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"3", " ", "x"}], "+", "4"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258275847],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}]}]], "Output",
 ImageSize->{456, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->376719144]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cubics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cubics"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " solves all cubics in terms of radicals:"
}], "ExampleText",
 CellID->248533402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"3", " ", "x"}], "+", "4"}], "==", "0"}], ",", "x", ",", 
   RowBox[{"Cubics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->583642825],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      FractionBox[
       SuperscriptBox["5", 
        RowBox[{"2", "/", "3"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"3", " ", 
           SqrtBox["6"]}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "7"}], "+", 
           RowBox[{"3", " ", 
            SqrtBox["6"]}]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", "3"]}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["5", 
       RowBox[{"2", "/", "3"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "7"}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["6"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"3", " ", 
           SqrtBox["6"]}]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", "3"]}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["5", 
       RowBox[{"2", "/", "3"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "7"}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["6"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"3", " ", 
           SqrtBox["6"]}]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]}]}]}]], "Output",
 ImageSize->{401, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2572105]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GeneratedParameters",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->742573599],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " may introduce new parameters to represent the solution:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->940926257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142038859],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["\[Pi]", "3"]}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["\[Pi]", "3"], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}]], "Output",
 ImageSize->{359, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->652335297]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["GeneratedParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
 " to control how the parameters are generated:"
}], "ExampleText",
 CellID->92878819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "2"}]}], ",", "x", ",", 
   RowBox[{"GeneratedParameters", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{"k", ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->158923480],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["k", "1"], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["\[Pi]", "3"]}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       SubscriptBox["k", "1"]}]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["\[Pi]", "3"], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       SubscriptBox["k", "1"]}]}]}]}], ")"}]}]], "Output",
 ImageSize->{312, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->113854815]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->14362624],

Cell["Solve equations over the integers modulo 9:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->487344474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"3", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "4"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", 
       RowBox[{"x", "^", "3"}]}], "-", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"x", " ", "y"}]}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "9"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->260171957],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "8"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "8"}], "&&", 
    RowBox[{"y", "\[Equal]", "4"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "8"}], "&&", 
    RowBox[{"y", "\[Equal]", "7"}]}], ")"}]}]], "Output",
 ImageSize->{331, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50307344]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Quartics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->539120974],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " does not use general formulas for solving quartics in radicals:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->199602890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"3", " ", "x"}], "+", "4"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373599954],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]}]], "Output",
 ImageSize->{466, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->685078356]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quartics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quartics"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " solves all quartics in terms of radicals:"
}], "ExampleText",
 CellID->121123785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"3", " ", "x"}], "+", "4"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"Quartics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->195961662],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        FractionBox["4", "3"]}], "+", 
       FractionBox["52", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "317"}], "+", 
              RowBox[{"9", " ", "\[ImaginaryI]", " ", 
               SqrtBox["5703"]}]}], ")"}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]}]], "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "317"}], "+", 
             RowBox[{"9", " ", "\[ImaginaryI]", " ", 
              SqrtBox["5703"]}]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]}]]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8"}], "-", 
          FractionBox["52", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "317"}], "+", 
                RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                 SqrtBox["5703"]}]}], ")"}]}], ")"}], 
            RowBox[{"1", "/", "3"}]]], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "317"}], "+", 
               RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                SqrtBox["5703"]}]}], ")"}]}], ")"}], 
           RowBox[{"1", "/", "3"}]], "-", 
          FractionBox["18", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              FractionBox["4", "3"]}], "+", 
             FractionBox["52", 
              RowBox[{"3", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "317"}], "+", 
                    RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["5703"]}]}], ")"}]}], ")"}], 
                RowBox[{"1", "/", "3"}]]}]], "+", 
             RowBox[{
              FractionBox["1", "3"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "317"}], "+", 
                   RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["5703"]}]}], ")"}]}], ")"}], 
               RowBox[{"1", "/", "3"}]]}]}]]]}], ")"}]}], ")"}]}]}]}]}], "||",
   
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        FractionBox["4", "3"]}], "+", 
       FractionBox["52", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "317"}], "+", 
              RowBox[{"9", " ", "\[ImaginaryI]", " ", 
               SqrtBox["5703"]}]}], ")"}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]}]], "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "317"}], "+", 
             RowBox[{"9", " ", "\[ImaginaryI]", " ", 
              SqrtBox["5703"]}]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]}]]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8"}], "-", 
          FractionBox["52", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "317"}], "+", 
                RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                 SqrtBox["5703"]}]}], ")"}]}], ")"}], 
            RowBox[{"1", "/", "3"}]]], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "317"}], "+", 
               RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                SqrtBox["5703"]}]}], ")"}]}], ")"}], 
           RowBox[{"1", "/", "3"}]], "-", 
          FractionBox["18", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              FractionBox["4", "3"]}], "+", 
             FractionBox["52", 
              RowBox[{"3", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "317"}], "+", 
                    RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["5703"]}]}], ")"}]}], ")"}], 
                RowBox[{"1", "/", "3"}]]}]], "+", 
             RowBox[{
              FractionBox["1", "3"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "317"}], "+", 
                   RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["5703"]}]}], ")"}]}], ")"}], 
               RowBox[{"1", "/", "3"}]]}]}]]]}], ")"}]}], ")"}]}]}]}]}], "||",
   
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        FractionBox["4", "3"]}], "+", 
       FractionBox["52", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "317"}], "+", 
              RowBox[{"9", " ", "\[ImaginaryI]", " ", 
               SqrtBox["5703"]}]}], ")"}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]}]], "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "317"}], "+", 
             RowBox[{"9", " ", "\[ImaginaryI]", " ", 
              SqrtBox["5703"]}]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]}]]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8"}], "-", 
          FractionBox["52", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "317"}], "+", 
                RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                 SqrtBox["5703"]}]}], ")"}]}], ")"}], 
            RowBox[{"1", "/", "3"}]]], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "317"}], "+", 
               RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                SqrtBox["5703"]}]}], ")"}]}], ")"}], 
           RowBox[{"1", "/", "3"}]], "+", 
          FractionBox["18", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              FractionBox["4", "3"]}], "+", 
             FractionBox["52", 
              RowBox[{"3", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "317"}], "+", 
                    RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["5703"]}]}], ")"}]}], ")"}], 
                RowBox[{"1", "/", "3"}]]}]], "+", 
             RowBox[{
              FractionBox["1", "3"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "317"}], "+", 
                   RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["5703"]}]}], ")"}]}], ")"}], 
               RowBox[{"1", "/", "3"}]]}]}]]]}], ")"}]}], ")"}]}]}]}]}], "||",
   
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        FractionBox["4", "3"]}], "+", 
       FractionBox["52", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "317"}], "+", 
              RowBox[{"9", " ", "\[ImaginaryI]", " ", 
               SqrtBox["5703"]}]}], ")"}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]}]], "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "317"}], "+", 
             RowBox[{"9", " ", "\[ImaginaryI]", " ", 
              SqrtBox["5703"]}]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]}]]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8"}], "-", 
          FractionBox["52", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "317"}], "+", 
                RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                 SqrtBox["5703"]}]}], ")"}]}], ")"}], 
            RowBox[{"1", "/", "3"}]]], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "317"}], "+", 
               RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                SqrtBox["5703"]}]}], ")"}]}], ")"}], 
           RowBox[{"1", "/", "3"}]], "+", 
          FractionBox["18", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", 
              FractionBox["4", "3"]}], "+", 
             FractionBox["52", 
              RowBox[{"3", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "317"}], "+", 
                    RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["5703"]}]}], ")"}]}], ")"}], 
                RowBox[{"1", "/", "3"}]]}]], "+", 
             RowBox[{
              FractionBox["1", "3"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "317"}], "+", 
                   RowBox[{"9", " ", "\[ImaginaryI]", " ", 
                    SqrtBox["5703"]}]}], ")"}]}], ")"}], 
               RowBox[{"1", "/", "3"}]]}]}]]]}], ")"}]}], 
       ")"}]}]}]}]}]}]], "Output",
 ImageSize->{487, 1072},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94595778]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->547069221],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " cannot solve the problem due to high degrees of algebraic numbers \
involved:"
}], "ExampleText",
 CellID->777105701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"Exists", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"y", ",", " ", "z"}], "}"}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "8"}], " ", "+", " ", 
          RowBox[{"2", 
           RowBox[{"y", "^", "8"}]}], " ", "+", " ", 
          RowBox[{"3", 
           RowBox[{"z", "^", "8"}]}]}], " ", "<=", " ", "1"}], " ", "&&", " ",
         
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "3"}], " ", "-", " ", 
          RowBox[{"9", 
           RowBox[{"y", "^", "3"}]}], " ", "+", " ", 
          RowBox[{"7", 
           RowBox[{"z", "^", "3"}]}]}], " ", ">=", " ", "3"}]}]}], "]"}], ",",
      " ", "x", ",", " ", "Reals"}], "]"}], ",", "300"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->568869471],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209762618]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"], "->", "100"}]], 
  "InlineFormula"],
 " enables ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find a solution, but it may be incorrect:"
}], "ExampleText",
 CellID->2548684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"Exists", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y", ",", " ", "z"}], "}"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "8"}], " ", "+", " ", 
         RowBox[{"2", 
          RowBox[{"y", "^", "8"}]}], " ", "+", " ", 
         RowBox[{"3", 
          RowBox[{"z", "^", "8"}]}]}], " ", "<=", " ", "1"}], " ", "&&", " ", 
       
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "3"}], " ", "-", " ", 
         RowBox[{"9", 
          RowBox[{"y", "^", "3"}]}], " ", "+", " ", 
         RowBox[{"7", 
          RowBox[{"z", "^", "3"}]}]}], " ", ">=", " ", "3"}]}]}], "]"}], ",", 
    " ", "x", ",", " ", "Reals", ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "100"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->620387507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"67.97699999999998`", ",", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2618196522352684701774606608633544092649073499"}], "+", 
        
        RowBox[{"112137303438920075611127400135124077321328320", " ", 
         SuperscriptBox["#1", "3"]}], "-", 
        RowBox[{"132814474280704167113940479747995449194074080", " ", 
         SuperscriptBox["#1", "6"]}], "+", 
        RowBox[{"39146793368921485441556580804351146802749608125", " ", 
         SuperscriptBox["#1", "8"]}], "+", 
        RowBox[{"91856705198484666269070399879775363171210560", " ", 
         SuperscriptBox["#1", "9"]}], "-", 
        RowBox[{"1341175495662621729806372147543199870137760000", " ", 
         SuperscriptBox["#1", "11"]}], "-", 
        RowBox[{"42141596434943420720542775053872665433472560", " ", 
         SuperscriptBox["#1", "12"]}], "+", 
        RowBox[{"1582589878455148632715539236814693300312720000", " ", 
         SuperscriptBox["#1", "14"]}], "+", 
        RowBox[{"14592876096802804747928270810337344964750144", " ", 
         SuperscriptBox["#1", "15"]}], "-", 
        RowBox[{"273273142366140173367879981297464977692294766875", " ", 
         SuperscriptBox["#1", "16"]}], "-", 
        RowBox[{"1084874600671729351240909310589456169549920000", " ", 
         SuperscriptBox["#1", "17"]}], "-", 
        RowBox[{"4672251468213613165500303866540607470285280", " ", 
         SuperscriptBox["#1", "18"]}], "+", 
        RowBox[{"7356344450939568322500928613721519152461680000", " ", 
         SuperscriptBox["#1", "19"]}], "+", 
        RowBox[{"486826623827220403020230939919133417925160000", " ", 
         SuperscriptBox["#1", "20"]}], "+", 
        RowBox[{"1621571466270389965629654616387930805757120", " ", 
         SuperscriptBox["#1", "21"]}], "-", 
        RowBox[{"8653932056131816411521412982277635828456280000", " ", 
         SuperscriptBox["#1", "22"]}], "-", 
        RowBox[{"159993801360094923449431503286528552237920000", " ", 
         SuperscriptBox["#1", "23"]}], "+", 
        RowBox[{"1181424427392038088337249041705578494130159397085", " ", 
         SuperscriptBox["#1", "24"]}], "+", 
        RowBox[{"5888520338213011791817834072101573901146000000", " ", 
         SuperscriptBox["#1", "25"]}], "+", 
        RowBox[{"46801330922844246880795344194337790150800000", " ", 
         SuperscriptBox["#1", "26"]}], "-", 
        RowBox[{"24467334554119716937184952245655314221972911360", " ", 
         SuperscriptBox["#1", "27"]}], "-", 
        RowBox[{"2592683832594860546674917271501222308863100000", " ", 
         SuperscriptBox["#1", "28"]}], "-", 
        RowBox[{"15023717692172852187405796260244955218080000", " ", 
         SuperscriptBox["#1", "29"]}], "+", 
        RowBox[{"28712264151480474791676088438741348538206419072", " ", 
         SuperscriptBox["#1", "30"]}], "+", 
        RowBox[{"812007928880976140189494202018689306183440000", " ", 
         SuperscriptBox["#1", "31"]}], "-", 
        RowBox[{"3537388434852562446245779712340529662767287374375", " ", 
         SuperscriptBox["#1", "32"]}], "-", 
        RowBox[{"19419692926214247862900336814814700349248715520", " ", 
         SuperscriptBox["#1", "33"]}], "-", 
        RowBox[{"215801930758779344936762324367020005964760000", " ", 
         SuperscriptBox["#1", "34"]}], "+", 
        RowBox[{"54956519692073469839737650809448309844165320000", " ", 
         SuperscriptBox["#1", "35"]}], "+", 
        RowBox[{"8416105250955529068503592692330519350762985280", " ", 
         SuperscriptBox["#1", "36"]}], "+", 
        RowBox[{"62749943086937329078155618392566103762160000", " ", 
         SuperscriptBox["#1", "37"]}], "-", 
        RowBox[{"64367630445629017037391403984608079326797460000", " ", 
         SuperscriptBox["#1", "38"]}], "-", 
        RowBox[{"2525641537787781382376498550629952426026914560", " ", 
         SuperscriptBox["#1", "39"]}], "+", 
        RowBox[{"7769879867923988538207935524603223179597438700625", " ", 
         SuperscriptBox["#1", "40"]}], "+", 
        RowBox[{"43329124582475416283094388364421875447511480000", " ", 
         SuperscriptBox["#1", "41"]}], "+", 
        RowBox[{"608571619842211233122870844723209029615839360", " ", 
         SuperscriptBox["#1", "42"]}], "-", 
        RowBox[{"87814264603382842854822220404984016052585280000", " ", 
         SuperscriptBox["#1", "43"]}], "-", 
        RowBox[{"18540585580851717955554798423035685485022690000", " ", 
         SuperscriptBox["#1", "44"]}], "-", 
        RowBox[{"156306036132841583716281672642560892872625408", " ", 
         SuperscriptBox["#1", "45"]}], "+", 
        RowBox[{"102705768764820593232701679939710711938148640000", " ", 
         SuperscriptBox["#1", "46"]}], "+", 
        RowBox[{"5366064551542083207779168329149533496316920000", " ", 
         SuperscriptBox["#1", "47"]}], "-", 
        RowBox[{"12933319682733588182976356272163450519472577361975", " ", 
         SuperscriptBox["#1", "48"]}], "-", 
        RowBox[{"68888356902963978599391691551819737543190720000", " ", 
         SuperscriptBox["#1", "49"]}], "-", 
        RowBox[{"1175665676613966204279385048731055803883860000", " ", 
         SuperscriptBox["#1", "50"]}], "+", 
        RowBox[{"102349284026470938371782065432062687964569222400", " ", 
         SuperscriptBox["#1", "51"]}], "+", 
        RowBox[{"29190269364846825839973582629765084651591760000", " ", 
         SuperscriptBox["#1", "52"]}], "+", 
        RowBox[{"259374843939446832787459753544489388431880000", " ", 
         SuperscriptBox["#1", "53"]}], "-", 
        RowBox[{"119587139497995006342197262000331067394096028800", " ", 
         SuperscriptBox["#1", "54"]}], "-", 
        RowBox[{"8205916620950552633901449156541143750450880000", " ", 
         SuperscriptBox["#1", "55"]}], "+", 
        RowBox[{"16612091542028724056189112117561283747502505950625", " ", 
         SuperscriptBox["#1", "56"]}], "+", 
        RowBox[{"80004420208874816613224028609118173868304044800", " ", 
         SuperscriptBox["#1", "57"]}], "+", 
        RowBox[{"1648899263817925705121815992021920771761440000", " ", 
         SuperscriptBox["#1", "58"]}], "-", 
        RowBox[{"87665562868557594190677261244388005157686080000", " ", 
         SuperscriptBox["#1", "59"]}], "-", 
        RowBox[{"33659799063004124213882498578714308256508431680", " ", 
         SuperscriptBox["#1", "60"]}], "-", 
        RowBox[{"304376591320557139693314112878863610419520000", " ", 
         SuperscriptBox["#1", "61"]}], "+", 
        RowBox[{"102367132287597953565962994166169290757271840000", " ", 
         SuperscriptBox["#1", "62"]}], "+", 
        RowBox[{"9257163005429436876882202557014641599211027200", " ", 
         SuperscriptBox["#1", "63"]}], "-", 
        RowBox[{"16599758863903187132239700274652562160030244580625", " ", 
         SuperscriptBox["#1", "64"]}], "-", 
        RowBox[{"68366264026784452691041760938370396396003520000", " ", 
         SuperscriptBox["#1", "65"]}], "-", 
        RowBox[{"1730333554954169873611503086841804695577244800", " ", 
         SuperscriptBox["#1", "66"]}], "+", 
        RowBox[{"54763204308086194241501487468704819730450120000", " ", 
         SuperscriptBox["#1", "67"]}], "+", 
        RowBox[{"28625238073607620492282326877769441262734160000", " ", 
         SuperscriptBox["#1", "68"]}], "+", 
        RowBox[{"262996675955904001926787571198960559623865600", " ", 
         SuperscriptBox["#1", "69"]}], "-", 
        RowBox[{"63927391124183312791754433167377126419456660000", " ", 
         SuperscriptBox["#1", "70"]}], "-", 
        RowBox[{"7753929047003383073397617193398919823922880000", " ", 
         SuperscriptBox["#1", "71"]}], "+", 
        RowBox[{"12904081346226982280605562154285759160691539102775", " ", 
         SuperscriptBox["#1", "72"]}], "+", 
        RowBox[{"42650374794315928136358667562312747263268280000", " ", 
         SuperscriptBox["#1", "73"]}], "+", 
        RowBox[{"1372664308200444591592026324160636334411040000", " ", 
         SuperscriptBox["#1", "74"]}], "-", 
        RowBox[{"24330192224494514789655337374770350707667752192", " ", 
         SuperscriptBox["#1", "75"]}], "-", 
        RowBox[{"17805994084894383068160064561294049724904290000", " ", 
         SuperscriptBox["#1", "76"]}], "-", 
        RowBox[{"172813707224560334012750477036141012377920000", " ", 
         SuperscriptBox["#1", "77"]}], "+", 
        RowBox[{"28399942154308671185921648759612368175302776960", " ", 
         SuperscriptBox["#1", "78"]}], "+", 
        RowBox[{"4778412956595368622445860449020422516912120000", " ", 
         SuperscriptBox["#1", "79"]}], "-", 
        RowBox[{"7739716518119225272823894164887244927820332880625", " ", 
         SuperscriptBox["#1", "80"]}], "-", 
        RowBox[{"18938148902700282758237541155853595804003818240", " ", 
         SuperscriptBox["#1", "81"]}], "-", 
        RowBox[{"816488724555469657654545787895529399711060000", " ", 
         SuperscriptBox["#1", "82"]}], "+", 
        RowBox[{"7296858294042704418061125066571398260373360000", " ", 
         SuperscriptBox["#1", "83"]}], "+", 
        RowBox[{"7894918722252097363756733535000107407825615680", " ", 
         SuperscriptBox["#1", "84"]}], "+", 
        RowBox[{"88281801526603013508862318022814564163080000", " ", 
         SuperscriptBox["#1", "85"]}], "-", 
        RowBox[{"8518456644360681975737407018339545163281240000", " ", 
         SuperscriptBox["#1", "86"]}], "-", 
        RowBox[{"2108672407972653082729083376940532733527847680", " ", 
         SuperscriptBox["#1", "87"]}], "+", 
        RowBox[{"3517309276665022732685811568661876577620337744375", " ", 
         SuperscriptBox["#1", "88"]}], "+", 
        RowBox[{"5679632344998648546512579795877443006666640000", " ", 
         SuperscriptBox["#1", "89"]}], "+", 
        RowBox[{"353677893356315750550316740327368006350342272", " ", 
         SuperscriptBox["#1", "90"]}], "-", 
        RowBox[{"1326302987927784759457772780540558196865440000", " ", 
         SuperscriptBox["#1", "91"]}], "-", 
        RowBox[{"2366582357168305977580095813080181113432700000", " ", 
         SuperscriptBox["#1", "92"]}], "-", 
        RowBox[{"34852629611923609899244650713526533868023040", " ", 
         SuperscriptBox["#1", "93"]}], "+", 
        RowBox[{"1548717310907078775829818316566134361601680000", " ", 
         SuperscriptBox["#1", "94"]}], "+", 
        RowBox[{"631094280277848382313861941203902638909200000", " ", 
         SuperscriptBox["#1", "95"]}], "-", 
        RowBox[{"1172312695762124031690192344345807052060166385965", " ", 
         SuperscriptBox["#1", "96"]}], "-", 
        RowBox[{"1032643519437328344321445223025112312126560000", " ", 
         SuperscriptBox["#1", "97"]}], "-", 
        RowBox[{"105182716457011345078522983571228368962520000", " ", 
         SuperscriptBox["#1", "98"]}], "+", 
        RowBox[{"110484659009863463733574569256113624845465280", " ", 
         SuperscriptBox["#1", "99"]}], "+", 
        RowBox[{"430285353118795373628887591244084593755560000", " ", 
         SuperscriptBox["#1", "100"]}], "+", 
        RowBox[{"10017414382980503861733953120029986800880000", " ", 
         SuperscriptBox["#1", "101"]}], "-", 
        RowBox[{"129050304905153671105623220758057551634624480", " ", 
         SuperscriptBox["#1", "102"]}], "-", 
        RowBox[{"114744173756512190403275159458628937840480000", " ", 
         SuperscriptBox["#1", "103"]}], "+", 
        RowBox[{"270524153931355107361142975288559200669258266875", " ", 
         SuperscriptBox["#1", "104"]}], "+", 
        RowBox[{"86051904618376655059098105797611845779240256", " ", 
         SuperscriptBox["#1", "105"]}], "+", 
        RowBox[{"19124113062091680117605596372788119970960000", " ", 
         SuperscriptBox["#1", "106"]}], "-", 
        RowBox[{"35856873592983761706727696842043851656858160", " ", 
         SuperscriptBox["#1", "108"]}], "-", 
        RowBox[{"1821347305063040569017930666661064484000000", " ", 
         SuperscriptBox["#1", "109"]}], "+", 
        RowBox[{"9561989949766059189667676243578440624786240", " ", 
         SuperscriptBox["#1", "111"]}], "-", 
        RowBox[{"38646291442449791560158201666841790621818288125", " ", 
         SuperscriptBox["#1", "112"]}], "-", 
        RowBox[{"1593674336368698407981121050114388435456480", " ", 
         SuperscriptBox["#1", "114"]}], "+", 
        RowBox[{"151778864215741208274407584901857202930880", " ", 
         SuperscriptBox["#1", "117"]}], "+", 
        RowBox[{"2576418164672784306167144491059578525977861451", " ", 
         SuperscriptBox["#1", "120"]}]}], "&"}], ",", "1"}], "]"}], 
    "\[LessEqual]", "x", "\[LessEqual]", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2618196522352684701774606608633544092649073499"}], "+", 
        
        RowBox[{"112137303438920075611127400135124077321328320", " ", 
         SuperscriptBox["#1", "3"]}], "-", 
        RowBox[{"132814474280704167113940479747995449194074080", " ", 
         SuperscriptBox["#1", "6"]}], "+", 
        RowBox[{"39146793368921485441556580804351146802749608125", " ", 
         SuperscriptBox["#1", "8"]}], "+", 
        RowBox[{"91856705198484666269070399879775363171210560", " ", 
         SuperscriptBox["#1", "9"]}], "-", 
        RowBox[{"1341175495662621729806372147543199870137760000", " ", 
         SuperscriptBox["#1", "11"]}], "-", 
        RowBox[{"42141596434943420720542775053872665433472560", " ", 
         SuperscriptBox["#1", "12"]}], "+", 
        RowBox[{"1582589878455148632715539236814693300312720000", " ", 
         SuperscriptBox["#1", "14"]}], "+", 
        RowBox[{"14592876096802804747928270810337344964750144", " ", 
         SuperscriptBox["#1", "15"]}], "-", 
        RowBox[{"273273142366140173367879981297464977692294766875", " ", 
         SuperscriptBox["#1", "16"]}], "-", 
        RowBox[{"1084874600671729351240909310589456169549920000", " ", 
         SuperscriptBox["#1", "17"]}], "-", 
        RowBox[{"4672251468213613165500303866540607470285280", " ", 
         SuperscriptBox["#1", "18"]}], "+", 
        RowBox[{"7356344450939568322500928613721519152461680000", " ", 
         SuperscriptBox["#1", "19"]}], "+", 
        RowBox[{"486826623827220403020230939919133417925160000", " ", 
         SuperscriptBox["#1", "20"]}], "+", 
        RowBox[{"1621571466270389965629654616387930805757120", " ", 
         SuperscriptBox["#1", "21"]}], "-", 
        RowBox[{"8653932056131816411521412982277635828456280000", " ", 
         SuperscriptBox["#1", "22"]}], "-", 
        RowBox[{"159993801360094923449431503286528552237920000", " ", 
         SuperscriptBox["#1", "23"]}], "+", 
        RowBox[{"1181424427392038088337249041705578494130159397085", " ", 
         SuperscriptBox["#1", "24"]}], "+", 
        RowBox[{"5888520338213011791817834072101573901146000000", " ", 
         SuperscriptBox["#1", "25"]}], "+", 
        RowBox[{"46801330922844246880795344194337790150800000", " ", 
         SuperscriptBox["#1", "26"]}], "-", 
        RowBox[{"24467334554119716937184952245655314221972911360", " ", 
         SuperscriptBox["#1", "27"]}], "-", 
        RowBox[{"2592683832594860546674917271501222308863100000", " ", 
         SuperscriptBox["#1", "28"]}], "-", 
        RowBox[{"15023717692172852187405796260244955218080000", " ", 
         SuperscriptBox["#1", "29"]}], "+", 
        RowBox[{"28712264151480474791676088438741348538206419072", " ", 
         SuperscriptBox["#1", "30"]}], "+", 
        RowBox[{"812007928880976140189494202018689306183440000", " ", 
         SuperscriptBox["#1", "31"]}], "-", 
        RowBox[{"3537388434852562446245779712340529662767287374375", " ", 
         SuperscriptBox["#1", "32"]}], "-", 
        RowBox[{"19419692926214247862900336814814700349248715520", " ", 
         SuperscriptBox["#1", "33"]}], "-", 
        RowBox[{"215801930758779344936762324367020005964760000", " ", 
         SuperscriptBox["#1", "34"]}], "+", 
        RowBox[{"54956519692073469839737650809448309844165320000", " ", 
         SuperscriptBox["#1", "35"]}], "+", 
        RowBox[{"8416105250955529068503592692330519350762985280", " ", 
         SuperscriptBox["#1", "36"]}], "+", 
        RowBox[{"62749943086937329078155618392566103762160000", " ", 
         SuperscriptBox["#1", "37"]}], "-", 
        RowBox[{"64367630445629017037391403984608079326797460000", " ", 
         SuperscriptBox["#1", "38"]}], "-", 
        RowBox[{"2525641537787781382376498550629952426026914560", " ", 
         SuperscriptBox["#1", "39"]}], "+", 
        RowBox[{"7769879867923988538207935524603223179597438700625", " ", 
         SuperscriptBox["#1", "40"]}], "+", 
        RowBox[{"43329124582475416283094388364421875447511480000", " ", 
         SuperscriptBox["#1", "41"]}], "+", 
        RowBox[{"608571619842211233122870844723209029615839360", " ", 
         SuperscriptBox["#1", "42"]}], "-", 
        RowBox[{"87814264603382842854822220404984016052585280000", " ", 
         SuperscriptBox["#1", "43"]}], "-", 
        RowBox[{"18540585580851717955554798423035685485022690000", " ", 
         SuperscriptBox["#1", "44"]}], "-", 
        RowBox[{"156306036132841583716281672642560892872625408", " ", 
         SuperscriptBox["#1", "45"]}], "+", 
        RowBox[{"102705768764820593232701679939710711938148640000", " ", 
         SuperscriptBox["#1", "46"]}], "+", 
        RowBox[{"5366064551542083207779168329149533496316920000", " ", 
         SuperscriptBox["#1", "47"]}], "-", 
        RowBox[{"12933319682733588182976356272163450519472577361975", " ", 
         SuperscriptBox["#1", "48"]}], "-", 
        RowBox[{"68888356902963978599391691551819737543190720000", " ", 
         SuperscriptBox["#1", "49"]}], "-", 
        RowBox[{"1175665676613966204279385048731055803883860000", " ", 
         SuperscriptBox["#1", "50"]}], "+", 
        RowBox[{"102349284026470938371782065432062687964569222400", " ", 
         SuperscriptBox["#1", "51"]}], "+", 
        RowBox[{"29190269364846825839973582629765084651591760000", " ", 
         SuperscriptBox["#1", "52"]}], "+", 
        RowBox[{"259374843939446832787459753544489388431880000", " ", 
         SuperscriptBox["#1", "53"]}], "-", 
        RowBox[{"119587139497995006342197262000331067394096028800", " ", 
         SuperscriptBox["#1", "54"]}], "-", 
        RowBox[{"8205916620950552633901449156541143750450880000", " ", 
         SuperscriptBox["#1", "55"]}], "+", 
        RowBox[{"16612091542028724056189112117561283747502505950625", " ", 
         SuperscriptBox["#1", "56"]}], "+", 
        RowBox[{"80004420208874816613224028609118173868304044800", " ", 
         SuperscriptBox["#1", "57"]}], "+", 
        RowBox[{"1648899263817925705121815992021920771761440000", " ", 
         SuperscriptBox["#1", "58"]}], "-", 
        RowBox[{"87665562868557594190677261244388005157686080000", " ", 
         SuperscriptBox["#1", "59"]}], "-", 
        RowBox[{"33659799063004124213882498578714308256508431680", " ", 
         SuperscriptBox["#1", "60"]}], "-", 
        RowBox[{"304376591320557139693314112878863610419520000", " ", 
         SuperscriptBox["#1", "61"]}], "+", 
        RowBox[{"102367132287597953565962994166169290757271840000", " ", 
         SuperscriptBox["#1", "62"]}], "+", 
        RowBox[{"9257163005429436876882202557014641599211027200", " ", 
         SuperscriptBox["#1", "63"]}], "-", 
        RowBox[{"16599758863903187132239700274652562160030244580625", " ", 
         SuperscriptBox["#1", "64"]}], "-", 
        RowBox[{"68366264026784452691041760938370396396003520000", " ", 
         SuperscriptBox["#1", "65"]}], "-", 
        RowBox[{"1730333554954169873611503086841804695577244800", " ", 
         SuperscriptBox["#1", "66"]}], "+", 
        RowBox[{"54763204308086194241501487468704819730450120000", " ", 
         SuperscriptBox["#1", "67"]}], "+", 
        RowBox[{"28625238073607620492282326877769441262734160000", " ", 
         SuperscriptBox["#1", "68"]}], "+", 
        RowBox[{"262996675955904001926787571198960559623865600", " ", 
         SuperscriptBox["#1", "69"]}], "-", 
        RowBox[{"63927391124183312791754433167377126419456660000", " ", 
         SuperscriptBox["#1", "70"]}], "-", 
        RowBox[{"7753929047003383073397617193398919823922880000", " ", 
         SuperscriptBox["#1", "71"]}], "+", 
        RowBox[{"12904081346226982280605562154285759160691539102775", " ", 
         SuperscriptBox["#1", "72"]}], "+", 
        RowBox[{"42650374794315928136358667562312747263268280000", " ", 
         SuperscriptBox["#1", "73"]}], "+", 
        RowBox[{"1372664308200444591592026324160636334411040000", " ", 
         SuperscriptBox["#1", "74"]}], "-", 
        RowBox[{"24330192224494514789655337374770350707667752192", " ", 
         SuperscriptBox["#1", "75"]}], "-", 
        RowBox[{"17805994084894383068160064561294049724904290000", " ", 
         SuperscriptBox["#1", "76"]}], "-", 
        RowBox[{"172813707224560334012750477036141012377920000", " ", 
         SuperscriptBox["#1", "77"]}], "+", 
        RowBox[{"28399942154308671185921648759612368175302776960", " ", 
         SuperscriptBox["#1", "78"]}], "+", 
        RowBox[{"4778412956595368622445860449020422516912120000", " ", 
         SuperscriptBox["#1", "79"]}], "-", 
        RowBox[{"7739716518119225272823894164887244927820332880625", " ", 
         SuperscriptBox["#1", "80"]}], "-", 
        RowBox[{"18938148902700282758237541155853595804003818240", " ", 
         SuperscriptBox["#1", "81"]}], "-", 
        RowBox[{"816488724555469657654545787895529399711060000", " ", 
         SuperscriptBox["#1", "82"]}], "+", 
        RowBox[{"7296858294042704418061125066571398260373360000", " ", 
         SuperscriptBox["#1", "83"]}], "+", 
        RowBox[{"7894918722252097363756733535000107407825615680", " ", 
         SuperscriptBox["#1", "84"]}], "+", 
        RowBox[{"88281801526603013508862318022814564163080000", " ", 
         SuperscriptBox["#1", "85"]}], "-", 
        RowBox[{"8518456644360681975737407018339545163281240000", " ", 
         SuperscriptBox["#1", "86"]}], "-", 
        RowBox[{"2108672407972653082729083376940532733527847680", " ", 
         SuperscriptBox["#1", "87"]}], "+", 
        RowBox[{"3517309276665022732685811568661876577620337744375", " ", 
         SuperscriptBox["#1", "88"]}], "+", 
        RowBox[{"5679632344998648546512579795877443006666640000", " ", 
         SuperscriptBox["#1", "89"]}], "+", 
        RowBox[{"353677893356315750550316740327368006350342272", " ", 
         SuperscriptBox["#1", "90"]}], "-", 
        RowBox[{"1326302987927784759457772780540558196865440000", " ", 
         SuperscriptBox["#1", "91"]}], "-", 
        RowBox[{"2366582357168305977580095813080181113432700000", " ", 
         SuperscriptBox["#1", "92"]}], "-", 
        RowBox[{"34852629611923609899244650713526533868023040", " ", 
         SuperscriptBox["#1", "93"]}], "+", 
        RowBox[{"1548717310907078775829818316566134361601680000", " ", 
         SuperscriptBox["#1", "94"]}], "+", 
        RowBox[{"631094280277848382313861941203902638909200000", " ", 
         SuperscriptBox["#1", "95"]}], "-", 
        RowBox[{"1172312695762124031690192344345807052060166385965", " ", 
         SuperscriptBox["#1", "96"]}], "-", 
        RowBox[{"1032643519437328344321445223025112312126560000", " ", 
         SuperscriptBox["#1", "97"]}], "-", 
        RowBox[{"105182716457011345078522983571228368962520000", " ", 
         SuperscriptBox["#1", "98"]}], "+", 
        RowBox[{"110484659009863463733574569256113624845465280", " ", 
         SuperscriptBox["#1", "99"]}], "+", 
        RowBox[{"430285353118795373628887591244084593755560000", " ", 
         SuperscriptBox["#1", "100"]}], "+", 
        RowBox[{"10017414382980503861733953120029986800880000", " ", 
         SuperscriptBox["#1", "101"]}], "-", 
        RowBox[{"129050304905153671105623220758057551634624480", " ", 
         SuperscriptBox["#1", "102"]}], "-", 
        RowBox[{"114744173756512190403275159458628937840480000", " ", 
         SuperscriptBox["#1", "103"]}], "+", 
        RowBox[{"270524153931355107361142975288559200669258266875", " ", 
         SuperscriptBox["#1", "104"]}], "+", 
        RowBox[{"86051904618376655059098105797611845779240256", " ", 
         SuperscriptBox["#1", "105"]}], "+", 
        RowBox[{"19124113062091680117605596372788119970960000", " ", 
         SuperscriptBox["#1", "106"]}], "-", 
        RowBox[{"35856873592983761706727696842043851656858160", " ", 
         SuperscriptBox["#1", "108"]}], "-", 
        RowBox[{"1821347305063040569017930666661064484000000", " ", 
         SuperscriptBox["#1", "109"]}], "+", 
        RowBox[{"9561989949766059189667676243578440624786240", " ", 
         SuperscriptBox["#1", "111"]}], "-", 
        RowBox[{"38646291442449791560158201666841790621818288125", " ", 
         SuperscriptBox["#1", "112"]}], "-", 
        RowBox[{"1593674336368698407981121050114388435456480", " ", 
         SuperscriptBox["#1", "114"]}], "+", 
        RowBox[{"151778864215741208274407584901857202930880", " ", 
         SuperscriptBox["#1", "117"]}], "+", 
        RowBox[{"2576418164672784306167144491059578525977861451", " ", 
         SuperscriptBox["#1", "120"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{472, 3645},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->325094556]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19309015],

Cell["Find conditions for a quartic to have all roots equal:", "ExampleText",
 CellID->22609229],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"x", "^", "4"}], " ", "+", " ", 
   RowBox[{"a", " ", 
    RowBox[{"x", "^", "3"}]}], " ", "+", " ", 
   RowBox[{"b", " ", 
    RowBox[{"x", "^", "2"}]}], " ", "+", " ", 
   RowBox[{"c", " ", "x"}], " ", "+", " ", "d"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203029298],

Cell[TextData[{
 "A method using ",
 Cell[BoxData[
  ButtonBox["Subresultants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subresultants"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->305196516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"Drop", "[", 
      RowBox[{
       RowBox[{"Subresultants", "[", 
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], ",", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}],
        ",", 
       RowBox[{"-", "1"}]}], "]"}], "\[Equal]", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"Backsubstitution", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102296639],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "\[Equal]", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"]}], "8"]}], "&&", 
  RowBox[{"c", "\[Equal]", 
   FractionBox[
    SuperscriptBox["a", "3"], "16"]}], "&&", 
  RowBox[{"d", "\[Equal]", 
   FractionBox[
    SuperscriptBox["a", "4"], "256"]}]}]], "Output",
 ImageSize->{186, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->272443440]
}, Open  ]],

Cell["A method using quantifier elimination:", "ExampleText",
 CellID->105832803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], "==", "0"}], ",", 
     RowBox[{"ForAll", "[", 
      RowBox[{"y", ",", 
       RowBox[{
        RowBox[{"f", "[", "y", "]"}], "==", "0"}], ",", " ", 
       RowBox[{"x", "==", "y"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->208008204],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "\[Equal]", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"]}], "8"]}], "&&", 
  RowBox[{"c", "\[Equal]", 
   FractionBox[
    SuperscriptBox["a", "3"], "16"]}], "&&", 
  RowBox[{"d", "\[Equal]", 
   FractionBox[
    SuperscriptBox["a", "4"], "256"]}]}]], "Output",
 ImageSize->{186, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->136094764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64955039],

Cell["Plot a space curve given by an implicit description:", "ExampleText",
 CellID->97590961],

Cell[BoxData[
 RowBox[{
  RowBox[{"curve", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", 
      RowBox[{"x", " ", 
       RowBox[{"y", "^", "2"}]}]}], "==", 
     RowBox[{"z", "^", "2"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14288276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{"curve", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112995221],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", 
        SqrtBox[
         FractionBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["x", "3"]}], 
          RowBox[{"1", "+", "x"}]]]}]}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", "\[Equal]", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"], "-", 
            SuperscriptBox["y", "2"]}]]}]}], "||", 
        RowBox[{"z", "\[Equal]", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["y", "2"]}]]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       SqrtBox[
        FractionBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"], "-", 
          SuperscriptBox["x", "3"]}], 
         RowBox[{"1", "+", "x"}]]]}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", "\[Equal]", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"], "-", 
            SuperscriptBox["y", "2"]}]]}]}], "||", 
        RowBox[{"z", "\[Equal]", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["y", "2"]}]]}]}], ")"}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{423, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80327845]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bound", "=", 
  RowBox[{"N", "[", 
   RowBox[{"First", "[", "red", "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->366482184],

Cell[BoxData[
 RowBox[{"0.`", "\[LessEqual]", "x", "\[LessEqual]", 
  "0.7548776662466927`"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->491191451]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pieces", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], "//.", 
   RowBox[{"{", 
    RowBox[{"ToRules", "[", 
     RowBox[{"Rest", "[", "red", "]"}], "]"}], "}"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->111951020],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"], "-", 
         SuperscriptBox["x", "3"]}], 
        RowBox[{"1", "+", "x"}]]]}], ",", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"], "-", 
        FractionBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"], "-", 
          SuperscriptBox["x", "3"]}], 
         RowBox[{"1", "+", "x"}]]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"], "-", 
         SuperscriptBox["x", "3"]}], 
        RowBox[{"1", "+", "x"}]]]}], ",", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"], "-", 
       FractionBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"], "-", 
         SuperscriptBox["x", "3"]}], 
        RowBox[{"1", "+", "x"}]]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     SqrtBox[
      FractionBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"], "-", 
        SuperscriptBox["x", "3"]}], 
       RowBox[{"1", "+", "x"}]]], ",", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"], "-", 
        FractionBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"], "-", 
          SuperscriptBox["x", "3"]}], 
         RowBox[{"1", "+", "x"}]]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     SqrtBox[
      FractionBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"], "-", 
        SuperscriptBox["x", "3"]}], 
       RowBox[{"1", "+", "x"}]]], ",", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"], "-", 
       FractionBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"], "-", 
         SuperscriptBox["x", "3"]}], 
        RowBox[{"1", "+", "x"}]]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{554, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->385287027]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{"pieces", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"First", "[", "bound", "]"}], ",", 
     RowBox[{"Last", "[", "bound", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->272102385],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{170, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->496468094]
}, Open  ]],

Cell[TextData[{
 "Plot the projection of the space curve on the ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], ")"}]], "InlineFormula"],
 " plane."
}], "ExampleText",
 CellID->525156427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"proj", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"Exists", "[", 
     RowBox[{"z", ",", "curve"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->414817635],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"], "-", 
         SuperscriptBox["x", "3"]}], 
        RowBox[{"1", "+", "x"}]]]}]}], "||", 
    RowBox[{"y", "\[Equal]", 
     SqrtBox[
      FractionBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"], "-", 
        SuperscriptBox["x", "3"]}], 
       RowBox[{"1", "+", "x"}]]]}]}], ")"}]}]], "Output",
 ImageSize->{468, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->143407276]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bounds", "=", 
  RowBox[{"N", "[", 
   RowBox[{"First", "[", "proj", "]"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->18906318],

Cell[BoxData[
 RowBox[{"0.`", "\[LessEqual]", "x", "\[LessEqual]", 
  "0.7548776662466927`"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->129172990]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pieces2d", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], "//.", 
   RowBox[{"{", 
    RowBox[{"ToRules", "[", 
     RowBox[{"Rest", "[", "proj", "]"}], "]"}], "}"}]}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->313185889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"], "-", 
         SuperscriptBox["x", "3"]}], 
        RowBox[{"1", "+", "x"}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     SqrtBox[
      FractionBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"], "-", 
        SuperscriptBox["x", "3"]}], 
       RowBox[{"1", "+", "x"}]]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{264, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->867412955]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{"pieces2d", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"First", "[", "bounds", "]"}], ",", 
     RowBox[{"Last", "[", "bounds", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->286748127],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{102, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->150817383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185129299],

Cell[TextData[{
 "Prove geometric inequalities for ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " sides of a triangle:"
}], "ExampleText",
 CellID->752673305],

Cell[BoxData[{
 RowBox[{
  RowBox[{"triangle", "=", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ">", "c"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ">", "b"}], "&&", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ">", "a"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"acute", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], ">", 
     RowBox[{"c", "^", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], ">", 
     RowBox[{"b", "^", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], ">", 
     RowBox[{"a", "^", "2"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"s", 
     RowBox[{"(", 
      RowBox[{"s", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"s", "-", "b"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"s", "-", "c"}], ")"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->186965933],

Cell["Prove an inequality for triangles:", "ExampleText",
 CellID->16833573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "triangle", ",", 
    RowBox[{
     RowBox[{"a", " ", "b", " ", "c", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "^", "2"}], "/", 
         RowBox[{"b", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "/", 
         RowBox[{"c", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"c", "^", "2"}], "/", 
         RowBox[{"a", "^", "2"}]}]}], ")"}]}], "\[GreaterEqual]", 
     RowBox[{
      RowBox[{"a", "^", "3"}], "+", 
      RowBox[{"b", "^", "3"}], "+", 
      RowBox[{"c", "^", "3"}], "+", 
      RowBox[{"a", " ", "b", 
       RowBox[{"(", 
        RowBox[{"b", "-", "a"}], ")"}]}], "+", 
      RowBox[{"a", " ", "c", 
       RowBox[{"(", 
        RowBox[{"a", "-", "c"}], ")"}]}], "+", 
      RowBox[{"b", " ", "c", 
       RowBox[{"(", 
        RowBox[{"c", "-", "b"}], ")"}]}]}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6016461],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->364441720]
}, Open  ]],

Cell["Prove an inequality for acute triangles:", "ExampleText",
 CellID->277755156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"triangle", "&&", "acute"}], ",", 
    RowBox[{
     RowBox[{"27", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}], "-", 
         RowBox[{"a", "^", "2"}]}], ")"}], "^", "2"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"c", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}], "^", "2"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"c", "^", "2"}]}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"4", "F"}], ")"}], "^", "6"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->210392438],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7448709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->627867075],

Cell["Find a Pythagorean triple:", "ExampleText",
 CellID->445600215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "==", 
     RowBox[{"5", "^", "2"}]}], "&&", 
    RowBox[{"y", ">", "x", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7852666],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "3"}], "&&", 
  RowBox[{"y", "\[Equal]", "4"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->436579911]
}, Open  ]],

Cell["Find a sequence of Pythagorean triples:", "ExampleText",
 CellID->198642000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "==", 
       RowBox[{"z", "^", "2"}]}], "&&", 
      RowBox[{"y", ">", "x", ">", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->319817674],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False", ",", "False", ",", "False", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "3"}], "&&", 
    RowBox[{"y", "\[Equal]", "4"}]}], ",", "False", ",", "False", ",", 
   "False", ",", "False", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "6"}], "&&", 
    RowBox[{"y", "\[Equal]", "8"}]}], ",", "False", ",", "False", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "5"}], "&&", 
    RowBox[{"y", "\[Equal]", "12"}]}], ",", "False", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "9"}], "&&", 
    RowBox[{"y", "\[Equal]", "12"}]}], ",", "False", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "8"}], "&&", 
    RowBox[{"y", "\[Equal]", "15"}]}], ",", "False", ",", "False", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "12"}], "&&", 
    RowBox[{"y", "\[Equal]", "16"}]}], ",", "False", ",", "False", ",", 
   "False", ",", "False", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "7"}], "&&", 
      RowBox[{"y", "\[Equal]", "24"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "15"}], "&&", 
      RowBox[{"y", "\[Equal]", "20"}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "10"}], "&&", 
    RowBox[{"y", "\[Equal]", "24"}]}], ",", "False", ",", "False", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "20"}], "&&", 
    RowBox[{"y", "\[Equal]", "21"}]}], ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "18"}], "&&", 
    RowBox[{"y", "\[Equal]", "24"}]}]}], "}"}]], "Output",
 ImageSize->{584, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->113371853]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->346603618],

Cell["\<\
Find how to pay $2.27 postage with 10, 23 and 37 cent stamps:\
\>", "ExampleText",
 CellID->58707378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "10"}], " ", "+", " ", 
      RowBox[{"b", " ", "23"}], " ", "+", " ", 
      RowBox[{"c", " ", "37"}]}], " ", "==", " ", "227"}], " ", "&&", 
    RowBox[{"a", ">=", "0"}], "&&", 
    RowBox[{"b", ">=", "0"}], "&&", 
    RowBox[{"c", ">=", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340549026],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "1"}], "&&", 
    RowBox[{"b", "\[Equal]", "3"}], "&&", 
    RowBox[{"c", "\[Equal]", "4"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "2"}], "&&", 
    RowBox[{"b", "\[Equal]", "9"}], "&&", 
    RowBox[{"c", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "7"}], "&&", 
    RowBox[{"b", "\[Equal]", "2"}], "&&", 
    RowBox[{"c", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "13"}], "&&", 
    RowBox[{"b", "\[Equal]", "1"}], "&&", 
    RowBox[{"c", "\[Equal]", "2"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "19"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "\[Equal]", "1"}]}], ")"}]}]], "Output",
 ImageSize->{503, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->255790266]
}, Open  ]],

Cell[TextData[{
 "The same task can be accomplished with ",
 Cell[BoxData[
  ButtonBox["IntegerPartitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->262981773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"227", ",", "All", ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", "23", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->465977986],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", 
     ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
     "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "37"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", 
     ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
     "23", ",", "37", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", 
     ",", "23", ",", "23", ",", "37", ",", "37", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "10", ",", "23", ",", "23", ",", "23", ",", "23", ",", "23", 
     ",", "23", ",", "23", ",", "23", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "23", ",", "23", ",", "23", ",", "37", ",", "37", ",", "37", 
     ",", "37"}], "}"}]}], "}"}]], "Output",
 ImageSize->{525, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->46580146]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3592],

Cell["\<\
The result of reduction is equivalent to the original system:\
\>", "ExampleText",
 CellID->165336304],

Cell[BoxData[
 RowBox[{
  RowBox[{"syst", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{"2", "x", " ", "y"}], ">", 
     RowBox[{"z", "^", "2"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8083557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"red", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{"syst", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->122877128],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"]}]]}]}], "&&", 
        RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "x"}]}], "&&", 
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"], "-", 
            SuperscriptBox["y", "2"]}]]}], "\[LessEqual]", "z", 
         "\[LessEqual]", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "x"}]}], "&&", 
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"], "-", 
            SuperscriptBox["y", "2"]}]]}], "<", "z", "<", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "-", "x"}], "<", "y", "<", "0"}], "&&", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SqrtBox["2"]}], " ", 
          SqrtBox[
           RowBox[{"x", " ", "y"}]]}], "<", "z", "<", 
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"x", " ", "y"}]]}]}]}], ")"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"0", "<", "y", "<", 
         RowBox[{"1", "-", "x"}]}], "&&", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SqrtBox["2"]}], " ", 
          SqrtBox[
           RowBox[{"x", " ", "y"}]]}], "<", "z", "<", 
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"x", " ", "y"}]]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{"1", "-", "x"}]}], "&&", 
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"], "-", 
            SuperscriptBox["y", "2"]}]]}], "<", "z", "<", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", "x"}], "<", "y", "<", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"]}]]}], "&&", 
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"], "-", 
            SuperscriptBox["y", "2"]}]]}], "\[LessEqual]", "z", 
         "\[LessEqual]", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"]}]]}], "&&", 
        RowBox[{"z", "\[Equal]", "0"}]}], ")"}]}], ")"}]}], ")"}]}]], "Output",\

 ImageSize->{573, 218},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141116490]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "0", "]"}], ";", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"syst", ",", "red"}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "->", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
       RowBox[{"y", "->", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
       RowBox[{"z", "->", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}]}], "}"}]}], ",", 
    RowBox[{"{", "10", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->314551341],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False"}], "}"}]}], "}"}]], "Output",
 ImageSize->{525, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->354102186]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->105597521],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRules"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ReplaceRepeated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFormula"],
 " can be used to backsubstitute finite solution sets:"
}], "ExampleText",
 CellID->73744098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "y"}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->562807392],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["3", "2"], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}], "2"]}]]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     SqrtBox[
      RowBox[{
       FractionBox["3", "2"], "-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}], "2"]}]]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["3", "2"], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}], "2"]}]]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     SqrtBox[
      RowBox[{
       FractionBox["3", "2"], "+", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}], "2"]}]]}]}], ")"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"1", "-", 
    SuperscriptBox["x", "2"]}]}]}]], "Output",
 ImageSize->{532, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7817485]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "y"}], "\[Equal]", "1"}], "&&", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "2"}]}], "//.", 
  RowBox[{"{", 
   RowBox[{"ToRules", "[", "%", "]"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->417257063],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["3", "2"], "-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}], "2"], "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}], "2"]}], ")"}], "2"]}], "\[Equal]", "2"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["3", "2"], "-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}], "2"], "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}], "2"]}], ")"}], "2"]}], "\[Equal]", "2"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["3", "2"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}], "2"], "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}], "2"]}], ")"}], "2"]}], "\[Equal]", "2"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["3", "2"], "+", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}], "2"], "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}], "2"]}], ")"}], "2"]}], "\[Equal]", "2"}]}], 
  "}"}]], "Output",
 ImageSize->{408, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->365189893]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " to simplify a result of substitution involving simple radicals:"
}], "ExampleText",
 CellID->60990369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4672436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27475001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31417890],

Cell[TextData[{
 "To simplify expressions involving algebraic numbers use ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->454656365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"2", 
       RowBox[{"y", "^", "3"}]}]}], "\[Equal]", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->431013195],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{329, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98997283]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"2", 
       RowBox[{"y", "^", "3"}]}]}], "\[Equal]", "3"}]}], "//.", 
   RowBox[{"{", 
    RowBox[{"ToRules", "[", "%", "]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->444511333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->360347228]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70533676],

Cell[TextData[{
 "To find solution instances use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->762934543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{"2", "x", " ", "y"}], ">", 
     RowBox[{"z", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->94194871],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], ",", 
    RowBox[{"z", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{168, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2580167]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"3", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"0", "<", "x", "<", 
     RowBox[{"10", "^", "10"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->66329980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "708158977"}], ",", 
     RowBox[{"y", "\[Rule]", "408855776"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2642885282"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1525870529"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "978122"}], ",", 
     RowBox[{"y", "\[Rule]", "564719"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{421, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->237474944]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291889716],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " represents solutions of complex equations in terms of replacement rules:"
}], "ExampleText",
 CellID->383494931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->381179523],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["2", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"3", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["2", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", 
          SqrtBox["3"]}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "-", 
         RowBox[{"4", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{527, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75497919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32414259],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " omits solutions involving equations on parameters:"
}], "ExampleText",
 CellID->40844936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", "x"}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12324966],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "a"}]}]]}], 
        RowBox[{"2", " ", "a"}]]}], "||", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "a"}]}]]}], 
        RowBox[{"2", " ", "a"}]]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{433, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27763412]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", "x"}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->282945346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{"4", " ", "a"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{"4", " ", "a"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{274, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->227086603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324507312],

Cell[TextData[{
 "For transcendental equations ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " may not give all solutions:"
}], "ExampleText",
 CellID->290920712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->243345728],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->65631317],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["\[Pi]", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox["\[Pi]", "3"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{136, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179132848]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->301050383],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["\[Pi]", "3"]}], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["\[Pi]", "3"], "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}]], "Output",
 ImageSize->{359, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141290719]
}, Open  ]],

Cell[TextData[{
 "Using inverse functions allows ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " to find some solutions fast:"
}], "ExampleText",
 CellID->184751878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "n"}], "\[Equal]", "1"}], ",", "x"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->143189750],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->788382857],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.715294573045867`*^-14", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", "1"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{177, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17673045]
}, Open  ]],

Cell["\<\
Finding the complete solution may take much longer and the solution may be \
large:\
\>", "ExampleText",
 CellID->280901066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"red", "=", 
     RowBox[{"Reduce", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "n"}], "\[Equal]", "1"}], ",", "x"}], "]"}]}], 
    ")"}], "//", "LeafCount"}], "//", "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->214332995],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"23.043000000000024`", ",", "635"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->28768640]
}, Open  ]],

Cell[TextData[{
 "This finds the values of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "==", "2"}]], "InlineFormula"],
 " is a solution: "
}], "ExampleText",
 CellID->15786440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"red", "/.", 
    RowBox[{"x", "\[Rule]", "2"}]}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->665377366],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{"n", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "1"}], "&&", 
    RowBox[{"n", "\[Equal]", 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}], 
      RowBox[{"Log", "[", "2", "]"}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[LessEqual]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"n", "\[Equal]", 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}], 
      RowBox[{"Log", "[", "2", "]"}]]}]}], ")"}]}]], "Output",
 ImageSize->{492, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->344218654]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "n"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "2"}], ",", 
      RowBox[{"n", "\[Rule]", 
       RowBox[{"2", "I", " ", "Pi", " ", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "/", 
         RowBox[{"Log", "[", "2", "]"}]}]}]}]}], "}"}]}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], ",", "Integers"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[6]:=",
 CellID->174944066],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->334084252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18312152],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SolveAlways",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SolveAlways"]], "InlineFormula"],
 " gives the values of parameters for which complex equations are always \
true:"
}], "ExampleText",
 CellID->685179284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", " ", "-", 
        RowBox[{"2", "b"}], "+", "1"}], ")"}], 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"b", "^", "2"}], "-", "c"}], ")"}], "x"}]}], " ", "\[Equal]", 
    
    RowBox[{
     RowBox[{"a", "^", "2"}], "-", "b", "+", 
     RowBox[{"3", "c"}], "-", "1"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239943741],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], "-", 
       SqrtBox["13"]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SqrtBox["13"]}], ")"}]}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "11"}], "-", 
         RowBox[{"3", " ", 
          SqrtBox["13"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       SqrtBox["13"]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["13"]}], ")"}]}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["11", "2"]}], "+", 
       FractionBox[
        RowBox[{"3", " ", 
         SqrtBox["13"]}], "2"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{372, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22590211]
}, Open  ]],

Cell[TextData[{
 "This solves the same problem using ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->286318889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", "-", 
          RowBox[{"2", "b"}], "+", "1"}], ")"}], 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", 
          RowBox[{"b", "^", "2"}], "-", "c"}], ")"}], "x"}]}], " ", 
      "\[Equal]", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", "b", "+", 
       RowBox[{"3", "c"}], "-", "1"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52715427],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      SqrtBox["13"]}]}], "||", 
    RowBox[{"a", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      SqrtBox["13"]}]}]}], ")"}], "&&", 
  RowBox[{"b", "\[Equal]", 
   FractionBox[
    RowBox[{"1", "+", "a"}], "2"]}], "&&", 
  RowBox[{"c", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"3", " ", "a"}]}], ")"}]}]}]}]], "Output",
 ImageSize->{393, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->95451086]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1616163],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " eliminates quantifiers, possibly without solving the resulting quantifier\
\[Hyphen]free system:"
}], "ExampleText",
 CellID->569389538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", " ", "y"}], ">", 
       RowBox[{"z", "^", "3"}]}]}]}], "]"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22615369],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["z", "3"], "<", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], "\[LessEqual]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["y", "2"]}], "+", 
      SuperscriptBox["y", "4"], "+", 
      RowBox[{
       SuperscriptBox["y", "2"], " ", 
       SuperscriptBox["z", "2"]}], "+", 
      SuperscriptBox["z", "6"]}], "<", "0"}]}], ")"}]}]], "Output",
 ImageSize->{374, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14820215]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"y", "^", "2"}]}], "+", 
       RowBox[{"b", " ", "y"}], "+", "c"}], "\[Equal]", "0"}]}], ",", 
    RowBox[{"x", "\[Equal]", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->393608858],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "\[NotEqual]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{384, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->544943520]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->326154926],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " eliminates variables from systems of complex equations:"
}], "ExampleText",
 CellID->171844387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y"}], "==", 
     RowBox[{"z", "^", "3"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19781343],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["y", "4"], "+", 
   RowBox[{
    SuperscriptBox["y", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["z", "2"]}], ")"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   SuperscriptBox["z", "6"]}]}]], "Output",
 ImageSize->{136, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10482459]
}, Open  ]],

Cell[TextData[{
 "This solves the same problem using ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->587034929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "==", 
      RowBox[{"z", "^", "3"}]}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21165408],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["y", "2"]}], "+", 
      SuperscriptBox["y", "4"], "+", 
      RowBox[{
       SuperscriptBox["y", "2"], " ", 
       SuperscriptBox["z", "2"]}], "+", 
      SuperscriptBox["z", "6"]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[NotEqual]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{316, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56809509]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " additionally solves the resulting equations:"
}], "ExampleText",
 CellID->41914721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "==", 
       RowBox[{"z", "^", "3"}]}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->258905246],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{580, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->237852701]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20208],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " appears in an inequality, it is assumed to be real; ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is allowed to be complex: "
}], "ExampleText",
 CellID->121214518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "<", "1"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"y", "-", 
      RowBox[{"Sqrt", "[", "x", "]"}]}], "==", "0"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186388489],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   SqrtBox["x"]}]}]], "Output",
 ImageSize->{129, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273300452]
}, Open  ]],

Cell[TextData[{
 "When domain ",
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 " is specified, ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " are required to be real:"
}], "ExampleText",
 CellID->1993505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "<", "1"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"y", "-", 
      RowBox[{"Sqrt", "[", "x", "]"}]}], "==", "0"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->571336625],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "\[LessEqual]", "x", "<", "1"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   SqrtBox["x"]}]}]], "Output",
 ImageSize->{121, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->565538614]
}, Open  ]],

Cell[TextData[{
 "This allows complex values of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " for which both sides of the inequality are real:"
}], "ExampleText",
 CellID->412743763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "<", "1"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"y", "-", 
      RowBox[{"Sqrt", "[", "x", "]"}]}], "==", "0"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y"}], "}"}], ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24031670],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "<", 
       RowBox[{"Re", "[", "x", "]"}], "<", "0"}], "&&", 
      RowBox[{
       RowBox[{"Im", "[", "x", "]"}], "\[Equal]", "0"}]}], ")"}], "||", 
    RowBox[{
     RowBox[{"Re", "[", "x", "]"}], "\[Equal]", "0"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0", "<", 
       RowBox[{"Re", "[", "x", "]"}], "<", "1"}], "&&", 
      RowBox[{
       RowBox[{"Im", "[", "x", "]"}], "\[Equal]", "0"}]}], ")"}]}], ")"}], "&&",
   
  RowBox[{"y", "\[Equal]", 
   SqrtBox["x"]}]}]], "Output",
 ImageSize->{531, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->275029945]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->347321242],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " does not solve equations that depend on branch cuts of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions:"
}], "ExampleText",
 CellID->38886635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}]}], "]"}], "-", 
     RowBox[{"x", "^", "2"}], "+", "y", "-", "1"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13849347],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "::", "\<\"useq\"\>"}], ":", 
  " ", "\<\"The answer found by Reduce contains unsolved equation(s) \
\\!\\({\\(\\(0 \[Equal] \\(\\(\\(\\(-1\\)\\) + \\@\\(3 + x + \\(\\(2\\\\ \
x\\^2\\)\\)\\) - \\@\\(4 + x + \\(\\(2\\\\ \\(\\(Power[\\(\\(\[LeftSkeleton] \
2 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) - \\(\\(2\\\\ \\(\\(Power[\\(\\(\
\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\)\\)\\)\\)\\)\\)\\)\\)\\), \\(\\(0 \
\[Equal] \\(\\(\\(\\(-1\\)\\) - \\@\\(3 + x + \\(\\(2\\\\ \\(\\(Power[\\(\\(\
\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\)\\)\\)\\)\\) - \\@\\(4 + x + \
\\(\\(2\\\\ \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\)\\)\
\\)\\) + \\(\\(2\\\\ \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\)\\)\\)\\)\\)\\)\\)\\)}\\). A likely reason for \
this is that the solution set depends on branch cuts of Mathematica \
functions.\"\>"}]], "Message", "MSG",
 CellID->52206412],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       RowBox[{"3", "+", "x", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}]], "-", 
      SqrtBox[
       RowBox[{"4", "+", "x", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"3", "+", "x", "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["x", "2"]}]}]]}]}]]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"2", "+", 
      SuperscriptBox["x", "2"], "-", 
      SqrtBox[
       RowBox[{"3", "+", "x", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox[
       RowBox[{"3", "+", "x", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}]], "-", 
      SqrtBox[
       RowBox[{"4", "+", "x", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{"3", "+", "x", "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["x", "2"]}]}]]}]}]]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"2", "+", 
      SuperscriptBox["x", "2"], "+", 
      SqrtBox[
       RowBox[{"3", "+", "x", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}]}], ")"}]}]], "Output",
 ImageSize->{534, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1063920]
}, Open  ]],

Cell["Plot the region where the first condition is non-zero:", "ExampleText",
 CellID->22762425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", 
     RowBox[{"u", "+", 
      RowBox[{"I", " ", "v"}]}]}], "}"}], ",", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox[
         RowBox[{"3", "+", "x", "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["x", "2"]}]}]], "-", 
        SqrtBox[
         RowBox[{"4", "+", "x", "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["x", "2"]}], "-", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"3", "+", "x", "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["x", "2"]}]}]]}]}]]}], "]"}], ">", "0.001"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->699908885],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs9rE0EUnmbTJmLVS2m9qGla/xNNq9Y/IhShPYhSexKkKEpRpAcVq1VS
SkpUGtoaaiSaUk0l/mgwGLFYBAuBHCqVYrFIobC+2d12NrOb7MzuJk1KlmQ2
szPvmzcz33vzdjJn/f095877+3u7/Z6OPv/Fnt7uSx7fhT54JNQhhGbgO30Y
wW8RfknfGVGEuzpthlSAIgfcHXD3KPlWJe9V8l6qniBJt+DUiZGlSylHAnni
ofJHNBLtehIaTNyhOnyXHh2CFFdxGrbfotSsL4keu9V/43aPquYzv6ZXKWmz
rR11/phue+oaXoZ2m0XCModKZ49yb1furVQ9mZValqvTJkgD2z1BLjGf1w0a
7VyU/k4qTzOr1OXlbs9UuZYzyK3/XCUpaGocp2q0UXmaW/qc3iGGdO3wxFAX
nD0hZZaWlh5KF3LjRAiFQko9n0j4w9xHVV7GTyQSE8/Tqa//kBsnAjSilHeK
tG2YbWNubm5yJlPaNnj6ge1KbbsNuoipVCr4LMmG2GRZJ30EnpGzRwc8HicN
+t+h1HPssb6XggPlR7BrBqux7zWEGgcqHcElISQ+/JKXcnSKeQZpyU6uGWRr
t/oR9otyXGS0qhsjHaQQ9CMPHkSs087bo63IerqSKLIwUoeojiIbRbaIyFif
RgqBjt35EQ8ouukjLS4uPhqLW+EYjrQDsepCIF6isCSLl7Bf81dvs1NTU1YQ
Xs7+jEQiPAjZbPbO8LQVhFwuN3Q3XFkIEARDKMzCgbW1tcHb43qSLBxYX1+/
cXOMvV1jBGzaqRQPwtbW1pWrw+YQ5DEYuD7y/vMfLNwgIYBTANfAgwDEB/oT
BCAlUJMHAYgP9CcIQEqgJg9CLBaLxL4TBBhWGNziHPBJkslk8unkApGE8djc
3DTmgNwu8aL1kvS7hd/BYBAXnWbUfHV19dbQE4IA3YDOsCH4qBl0SgiB8TeZ
TIYHIR6PT0e/ScJS8unLX7ALGEB0hhEBLAl6AXIKAuGhMQJeUZELVAYEMOSx
0DxIh8Nh4DbqKjh7eF5R/crKCph/Op2G1rC+XUXnbMRQl9LUKLQSa2tKUUDe
bg4d+ZRSBos8EOn4phz6sI9Q+eaUsAy4mdq+wF4NWCbxGUdq9x9HgcnIgRPs
JYHQIpNFyDYF3AZzIDYFbgqcFQ8CsWvZM4BRg6GKHN4JVAZ/Bu5F8U48vkVG
IKszv3/T97GgzejoKA8C7eOvDQY2NjZEhtUhGo2+eP2DSJIRZFkdwInNzues
rGvW11YYKtPru/UYQz/OCU18hMsKAnuMR9ZXMzEeHVuCOYFR8WheCRGy9Tjf
+rsGjQCGAeZhBaF63/V2A4HnfR+v4ILOasy/B3GIQqD/m7IHkX/fxn69iu+2
8CIV+9fW3F6XQycOq879yr27X1wJu+3Vg1D7z6aGUOOAGqEazxDUzk+Y5QA+
+bMd0RSOPHh02ofTomeJ9OMknpEz24b9/SBR4/Ly8uWBe/BBbpwI8osJLso/
M8aoe0nOxZlpu3Ye0kR5gfOQ6vNvuB45l6o9t4rq/gMHjRN2\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14235959]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15786],

Cell[TextData[{
 "Find the vertical asymptotes of ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["y", "2"], "-", "2"}]]], "InlineFormula"],
 " by directly using the definition of limit:"
}], "ExampleText",
 CellID->380052021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"M", ",", " ", 
     RowBox[{"M", " ", ">", " ", "0"}], ",", " ", 
     RowBox[{"Exists", "[", 
      RowBox[{"\[Delta]", ",", " ", 
       RowBox[{"\[Delta]", " ", ">", " ", "0"}], ",", " ", "\n", "    ", 
       RowBox[{"ForAll", "[", 
        RowBox[{"y", ",", " ", 
         RowBox[{
          RowBox[{"Element", "[", 
           RowBox[{
            RowBox[{"x", " ", "|", " ", "y"}], ",", " ", "Reals"}], "]"}], 
          " ", "&&", " ", 
          RowBox[{"0", " ", "<", " ", 
           RowBox[{"Abs", "[", 
            RowBox[{"y", " ", "-", " ", "x"}], "]"}], " ", "<", " ", 
           "\[Delta]"}]}], ",", " ", "\n", "     ", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"y", "^", "2"}], " ", "-", " ", "2"}], ")"}]}], "]"}], 
          " ", ">", " ", "M"}]}], "]"}]}], "]"}]}], "]"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->625051074],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox["2"]}]}]], "Output",
 ImageSize->{128, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3884006]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11964],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Roots",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Roots"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eliminate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eliminate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Resolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogicalExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogicalExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToRules"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GroebnerBasis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GroebnerBasis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CylindricalDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CylindricalDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SemialgebraicComponentInstances",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SemialgebraicComponentInstances"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChineseRemainder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChineseRemainder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HermiteDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HermiteDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SolveAlways",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SolveAlways"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21922]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18386],

Cell[TextData[ButtonBox["Solving Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingEquations"]], "Tutorials",
 CellID->15204],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Inequalities-SymbolicMathematics"]], "Tutorials",\

 CellID->31242],

Cell[TextData[ButtonBox["Generic and Non\[Hyphen]Generic Solutions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GenericAndNonGenericSolutions"]], "Tutorials",
 CellID->17719],

Cell[TextData[ButtonBox["Equations and Inequalities over Domains",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EquationsAndInequalitiesOverDomains"]], "Tutorials",
 CellID->5317],

Cell[TextData[ButtonBox["Solving Logical Combinations of Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SolvingLogicalCombinationsOfEquations"]], "Tutorials",
 CellID->4500],

Cell[TextData[ButtonBox["The Representation of Solution Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfSolutionSets"]], "Tutorials",\

 CellID->227434737],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "Tutorials",
 CellID->212396704]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->32656],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#25734"], None}]], "RelatedLinks",
 CellID->11452]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->29131112],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->75864465],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout",
 CellID->631352467],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "MoreAbout",
 CellID->21280044],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "MoreAbout",
 CellID->180241381],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->34517261],

Cell[TextData[ButtonBox["Functions of Complex Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsOfComplexVariables"]], "MoreAbout",
 CellID->295811779],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->150709761],

Cell[TextData[ButtonBox["Manipulating Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManipulatingEquations"]], "MoreAbout",
 CellID->909663281],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->611645809],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->605193937],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "MoreAbout",
 CellID->284674211],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->803497828],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->28662263]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Reduce - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 36.3763642}", "context" -> "System`", 
    "keywords" -> {
     "algebraic equations", "algebraic inequalities", 
      "chinese remainder theorem", "complex variables", 
      "cylindrical decomposition", "Diophantine equations", "domains", 
      "equations", "Groebner basis", "Hardy-Muskat-Williams methods", 
      "inequalities", "integer equations", "linear equations", 
      "linear inequalities", "modular equations", "Pell equations", 
      "polynomial equations", "polynomial inequalities", 
      "reducing inequalities", "regions", "semi-algebraic sets", "solutions", 
      "Thue equations", "transcendental equations", 
      "transcendental inequalities"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Reduce[expr, vars] reduces the statement expr by solving equations or \
inequalities for vars and eliminating quantifiers. Reduce[expr, vars, dom] \
does the reduction over the domain dom. Common choices of dom are Reals, \
Integers and Complexes. ", "synonyms" -> {}, "title" -> "Reduce", "type" -> 
    "Symbol", "uri" -> "ref/Reduce"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[25004, 784, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->80221524]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 285336, 9423}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 6621, 129, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[7244, 156, 44, 1, 70, "ObjectName",
 CellID->21763],
Cell[7291, 159, 1746, 56, 70, "Usage",
 CellID->17753]
}, Open  ]],
Cell[CellGroupData[{
Cell[9074, 220, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9552, 237, 163, 6, 70, "Notes",
 CellID->27158],
Cell[9718, 245, 1921, 54, 70, "2ColumnTableMod",
 CellID->25550],
Cell[11642, 301, 406, 15, 70, "Notes",
 CellID->9037],
Cell[12051, 318, 926, 35, 70, "Notes",
 CellID->29072],
Cell[12980, 355, 394, 12, 70, "Notes",
 CellID->26739],
Cell[13377, 369, 428, 15, 70, "Notes",
 CellID->1781],
Cell[13808, 386, 586, 21, 70, "Notes",
 CellID->26975],
Cell[14397, 409, 635, 21, 70, "Notes",
 CellID->29188],
Cell[15035, 432, 413, 14, 70, "Notes",
 CellID->19289],
Cell[15451, 448, 952, 34, 70, "Notes",
 CellID->7358],
Cell[16406, 484, 299, 10, 70, "Notes",
 CellID->10963],
Cell[16708, 496, 899, 32, 70, "Notes",
 CellID->27254],
Cell[17610, 530, 582, 21, 70, "Notes",
 CellID->23509],
Cell[18195, 553, 745, 27, 70, "Notes",
 CellID->27921],
Cell[18943, 582, 473, 16, 70, "Notes",
 CellID->26307],
Cell[19419, 600, 352, 11, 70, "Notes",
 CellID->6442],
Cell[19774, 613, 585, 21, 70, "Notes",
 CellID->27758],
Cell[20362, 636, 360, 9, 70, "Notes",
 CellID->6249],
Cell[20725, 647, 504, 16, 70, "Notes",
 CellID->13196],
Cell[21232, 665, 68, 1, 70, "Notes",
 CellID->5016],
Cell[21303, 668, 2482, 70, 70, "3ColumnTableMod",
 CellID->29449],
Cell[23788, 740, 1179, 39, 70, "Notes",
 CellID->23083]
}, Closed]],
Cell[CellGroupData[{
Cell[25004, 784, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80221524],
Cell[CellGroupData[{
Cell[25388, 798, 147, 5, 70, "ExampleSection",
 CellID->93369526],
Cell[25538, 805, 76, 1, 70, "ExampleText",
 CellID->99167031],
Cell[CellGroupData[{
Cell[25639, 810, 281, 10, 28, "Input",
 CellID->62263588],
Cell[25923, 822, 1020, 38, 41, "Output",
 CellID->368180566]
}, Open  ]],
Cell[CellGroupData[{
Cell[26980, 865, 274, 10, 28, "Input",
 CellID->15483236],
Cell[27257, 877, 419, 16, 45, "Output",
 CellID->488535870]
}, Open  ]],
Cell[27691, 896, 124, 3, 70, "ExampleDelimiter",
 CellID->64489396],
Cell[27818, 901, 64, 1, 70, "ExampleText",
 CellID->139222577],
Cell[CellGroupData[{
Cell[27907, 906, 411, 14, 70, "Input",
 CellID->29655719],
Cell[28321, 922, 1278, 45, 82, "Output",
 CellID->290674151]
}, Open  ]],
Cell[CellGroupData[{
Cell[29636, 972, 409, 14, 70, "Input",
 CellID->118871955],
Cell[30048, 988, 361, 14, 65, "Output",
 CellID->660880540]
}, Open  ]],
Cell[30424, 1005, 125, 3, 70, "ExampleDelimiter",
 CellID->630769760],
Cell[30552, 1010, 73, 1, 70, "ExampleText",
 CellID->46690342],
Cell[CellGroupData[{
Cell[30650, 1015, 496, 17, 70, "Input",
 CellID->127138787],
Cell[31149, 1034, 211, 7, 51, "Output",
 CellID->34769662]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31409, 1047, 217, 7, 70, "ExampleSection",
 CellID->22751],
Cell[CellGroupData[{
Cell[31651, 1058, 234, 7, 70, "ExampleSubsection",
 CellID->84922610],
Cell[31888, 1067, 59, 1, 70, "ExampleText",
 CellID->149821829],
Cell[CellGroupData[{
Cell[31972, 1072, 476, 17, 70, "Input",
 CellID->284710479],
Cell[32451, 1091, 343, 12, 36, "Output",
 CellID->24909135]
}, Open  ]],
Cell[32809, 1106, 125, 3, 70, "ExampleDelimiter",
 CellID->253504289],
Cell[32937, 1111, 75, 1, 70, "ExampleText",
 CellID->64844045],
Cell[CellGroupData[{
Cell[33037, 1116, 241, 9, 70, "Input",
 CellID->672643237],
Cell[33281, 1127, 553, 21, 51, "Output",
 CellID->4234581]
}, Open  ]],
Cell[33849, 1151, 124, 3, 70, "ExampleDelimiter",
 CellID->77578128],
Cell[33976, 1156, 78, 1, 70, "ExampleText",
 CellID->169862198],
Cell[CellGroupData[{
Cell[34079, 1161, 292, 10, 70, "Input",
 CellID->288610958],
Cell[34374, 1173, 623, 22, 56, "Output",
 CellID->283126778]
}, Open  ]],
Cell[35012, 1198, 124, 3, 70, "ExampleDelimiter",
 CellID->91534336],
Cell[35139, 1203, 121, 3, 70, "ExampleText",
 CellID->899471838],
Cell[CellGroupData[{
Cell[35285, 1210, 531, 18, 70, "Input",
 CellID->145589199],
Cell[35819, 1230, 1662, 54, 69, "Output",
 CellID->294128277]
}, Open  ]],
Cell[37496, 1287, 125, 3, 70, "ExampleDelimiter",
 CellID->644436505],
Cell[37624, 1292, 74, 1, 70, "ExampleText",
 CellID->159443640],
Cell[CellGroupData[{
Cell[37723, 1297, 592, 19, 70, "Input",
 CellID->208385592],
Cell[38318, 1318, 243, 8, 36, "Output",
 CellID->81529764]
}, Open  ]],
Cell[38576, 1329, 125, 3, 70, "ExampleDelimiter",
 CellID->700158465],
Cell[38704, 1334, 63, 1, 70, "ExampleText",
 CellID->546492545],
Cell[CellGroupData[{
Cell[38792, 1339, 539, 19, 70, "Input",
 CellID->31277144],
Cell[39334, 1360, 2342, 42, 70, "Output",
 Evaluatable->False,
 CellID->278265867]
}, Open  ]],
Cell[41691, 1405, 123, 3, 70, "ExampleDelimiter",
 CellID->1314432],
Cell[41817, 1410, 68, 1, 70, "ExampleText",
 CellID->288893094],
Cell[CellGroupData[{
Cell[41910, 1415, 213, 7, 70, "Input",
 CellID->256538498],
Cell[42126, 1424, 702, 22, 51, "Output",
 CellID->607554765]
}, Open  ]],
Cell[CellGroupData[{
Cell[42865, 1451, 289, 11, 70, "Input",
 CellID->34551955],
Cell[43157, 1464, 1522, 48, 78, "Output",
 CellID->37115083]
}, Open  ]],
Cell[44694, 1515, 77, 1, 70, "ExampleText",
 CellID->101603241],
Cell[CellGroupData[{
Cell[44796, 1520, 284, 10, 70, "Input",
 CellID->474067602],
Cell[45083, 1532, 160, 5, 36, "Output",
 CellID->6156784]
}, Open  ]],
Cell[45258, 1540, 125, 3, 70, "ExampleDelimiter",
 CellID->385408181],
Cell[45386, 1545, 80, 1, 70, "ExampleText",
 CellID->331511400],
Cell[CellGroupData[{
Cell[45491, 1550, 401, 14, 70, "Input",
 CellID->67423421],
Cell[45895, 1566, 1528, 44, 98, "Output",
 CellID->305558310]
}, Open  ]],
Cell[47438, 1613, 125, 3, 70, "ExampleDelimiter",
 CellID->642839680],
Cell[47566, 1618, 79, 1, 70, "ExampleText",
 CellID->226658394],
Cell[CellGroupData[{
Cell[47670, 1623, 192, 7, 70, "Input",
 CellID->163562302],
Cell[47865, 1632, 237, 5, 70, "Message",
 CellID->251018665],
Cell[48105, 1639, 774, 25, 36, "Output",
 CellID->594592970]
}, Open  ]],
Cell[48894, 1667, 105, 2, 70, "ExampleText",
 CellID->286979904],
Cell[CellGroupData[{
Cell[49024, 1673, 406, 14, 70, "Input",
 CellID->912028475],
Cell[49433, 1689, 508, 16, 36, "Output",
 CellID->221134888]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49990, 1711, 232, 7, 70, "ExampleSubsection",
 CellID->57305448],
Cell[50225, 1720, 59, 1, 70, "ExampleText",
 CellID->787469300],
Cell[CellGroupData[{
Cell[50309, 1725, 490, 18, 70, "Input",
 CellID->9250850],
Cell[50802, 1745, 344, 12, 36, "Output",
 CellID->208845146]
}, Open  ]],
Cell[51161, 1760, 125, 3, 70, "ExampleDelimiter",
 CellID->114190875],
Cell[51289, 1765, 75, 1, 70, "ExampleText",
 CellID->81649366],
Cell[CellGroupData[{
Cell[51389, 1770, 256, 9, 70, "Input",
 CellID->193942569],
Cell[51648, 1781, 781, 25, 39, "Output",
 CellID->866946966]
}, Open  ]],
Cell[52444, 1809, 125, 3, 70, "ExampleDelimiter",
 CellID->489808851],
Cell[52572, 1814, 78, 1, 70, "ExampleText",
 CellID->292696808],
Cell[CellGroupData[{
Cell[52675, 1819, 247, 9, 70, "Input",
 CellID->76644507],
Cell[52925, 1830, 739, 25, 39, "Output",
 CellID->48543530]
}, Open  ]],
Cell[53679, 1858, 124, 3, 70, "ExampleDelimiter",
 CellID->97040171],
Cell[53806, 1863, 78, 1, 70, "ExampleText",
 CellID->630117658],
Cell[CellGroupData[{
Cell[53909, 1868, 308, 11, 70, "Input",
 CellID->758827168],
Cell[54220, 1881, 728, 26, 56, "Output",
 CellID->637768961]
}, Open  ]],
Cell[54963, 1910, 125, 3, 70, "ExampleDelimiter",
 CellID->354625005],
Cell[55091, 1915, 79, 1, 70, "ExampleText",
 CellID->14844610],
Cell[CellGroupData[{
Cell[55195, 1920, 348, 12, 70, "Input",
 CellID->223254230],
Cell[55546, 1934, 986, 35, 52, "Output",
 CellID->17370113]
}, Open  ]],
Cell[56547, 1972, 125, 3, 70, "ExampleDelimiter",
 CellID->389602569],
Cell[56675, 1977, 122, 3, 70, "ExampleText",
 CellID->375009844],
Cell[CellGroupData[{
Cell[56822, 1984, 540, 19, 70, "Input",
 CellID->91668569],
Cell[57365, 2005, 488, 17, 56, "Output",
 CellID->66066894]
}, Open  ]],
Cell[57868, 2025, 124, 3, 70, "ExampleDelimiter",
 CellID->69923244],
Cell[57995, 2030, 74, 1, 70, "ExampleText",
 CellID->356535914],
Cell[CellGroupData[{
Cell[58094, 2035, 596, 19, 70, "Input",
 CellID->236241633],
Cell[58693, 2056, 639, 23, 51, "Output",
 CellID->478967716]
}, Open  ]],
Cell[59347, 2082, 125, 3, 70, "ExampleDelimiter",
 CellID->125859915],
Cell[59475, 2087, 62, 1, 70, "ExampleText",
 CellID->15168201],
Cell[CellGroupData[{
Cell[59562, 2092, 561, 19, 70, "Input",
 CellID->126906310],
Cell[60126, 2113, 904, 29, 39, "Output",
 CellID->380404304]
}, Open  ]],
Cell[61045, 2145, 125, 3, 70, "ExampleDelimiter",
 CellID->141393736],
Cell[61173, 2150, 63, 1, 70, "ExampleText",
 CellID->309755201],
Cell[CellGroupData[{
Cell[61261, 2155, 420, 15, 70, "Input",
 CellID->6175762],
Cell[61684, 2172, 263, 9, 36, "Output",
 CellID->22728350]
}, Open  ]],
Cell[CellGroupData[{
Cell[61984, 2186, 376, 13, 70, "Input",
 CellID->327866928],
Cell[62363, 2201, 1129, 41, 65, "Output",
 CellID->37933245]
}, Open  ]],
Cell[63507, 2245, 125, 3, 70, "ExampleDelimiter",
 CellID->233833830],
Cell[63635, 2250, 66, 1, 70, "ExampleText",
 CellID->619582499],
Cell[CellGroupData[{
Cell[63726, 2255, 391, 14, 70, "Input",
 CellID->712190582],
Cell[64120, 2271, 554, 22, 51, "Output",
 CellID->311288270]
}, Open  ]],
Cell[CellGroupData[{
Cell[64711, 2298, 320, 11, 70, "Input",
 CellID->74944114],
Cell[65034, 2311, 233, 9, 38, "Output",
 CellID->209676694]
}, Open  ]],
Cell[65282, 2323, 124, 3, 70, "ExampleDelimiter",
 CellID->22193703],
Cell[65409, 2328, 68, 1, 70, "ExampleText",
 CellID->178378100],
Cell[CellGroupData[{
Cell[65502, 2333, 224, 8, 70, "Input",
 CellID->32163487],
Cell[65729, 2343, 636, 22, 52, "Output",
 CellID->30066752]
}, Open  ]],
Cell[CellGroupData[{
Cell[66402, 2370, 379, 14, 70, "Input",
 CellID->849204275],
Cell[66784, 2386, 1083, 38, 71, "Output",
 CellID->51620580]
}, Open  ]],
Cell[67882, 2427, 124, 3, 70, "ExampleDelimiter",
 CellID->53285106],
Cell[68009, 2432, 71, 1, 70, "ExampleText",
 CellID->245801814],
Cell[CellGroupData[{
Cell[68105, 2437, 220, 7, 70, "Input",
 CellID->285456402],
Cell[68328, 2446, 623, 20, 51, "Output",
 CellID->279694008]
}, Open  ]],
Cell[CellGroupData[{
Cell[68988, 2471, 362, 13, 70, "Input",
 CellID->44025090],
Cell[69353, 2486, 348, 12, 61, "Output",
 CellID->193547581]
}, Open  ]],
Cell[69716, 2501, 125, 3, 70, "ExampleDelimiter",
 CellID->147547389],
Cell[69844, 2506, 66, 1, 70, "ExampleText",
 CellID->202401352],
Cell[CellGroupData[{
Cell[69935, 2511, 413, 14, 70, "Input",
 CellID->31650260],
Cell[70351, 2527, 2955, 87, 128, "Output",
 CellID->557904129]
}, Open  ]],
Cell[CellGroupData[{
Cell[73343, 2619, 514, 18, 70, "Input",
 CellID->942160119],
Cell[73860, 2639, 354, 12, 53, "Output",
 CellID->198968466]
}, Open  ]],
Cell[74229, 2654, 125, 3, 70, "ExampleDelimiter",
 CellID->164663613],
Cell[74357, 2659, 79, 1, 70, "ExampleText",
 CellID->366956007],
Cell[CellGroupData[{
Cell[74461, 2664, 328, 11, 70, "Input",
 CellID->426417430],
Cell[74792, 2677, 494, 15, 38, "Output",
 CellID->11916627]
}, Open  ]],
Cell[75301, 2695, 125, 3, 70, "ExampleDelimiter",
 CellID->998532594],
Cell[75429, 2700, 88, 1, 70, "ExampleText",
 CellID->105914447],
Cell[CellGroupData[{
Cell[75542, 2705, 296, 10, 70, "Input",
 CellID->63580255],
Cell[75841, 2717, 266, 9, 51, "Output",
 CellID->396328815]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76156, 2732, 236, 7, 70, "ExampleSubsection",
 CellID->247179601],
Cell[76395, 2741, 69, 1, 70, "ExampleText",
 CellID->91649387],
Cell[CellGroupData[{
Cell[76489, 2746, 495, 18, 70, "Input",
 CellID->31436120],
Cell[76987, 2766, 555, 18, 36, "Output",
 CellID->124861910]
}, Open  ]],
Cell[77557, 2787, 124, 3, 70, "ExampleDelimiter",
 CellID->56626870],
Cell[77684, 2792, 89, 1, 70, "ExampleText",
 CellID->610547063],
Cell[CellGroupData[{
Cell[77798, 2797, 548, 20, 70, "Input",
 CellID->336458608],
Cell[78349, 2819, 708, 24, 36, "Output",
 CellID->76211477]
}, Open  ]],
Cell[79072, 2846, 124, 3, 70, "ExampleDelimiter",
 CellID->20516472],
Cell[79199, 2851, 75, 1, 70, "ExampleText",
 CellID->68329701],
Cell[CellGroupData[{
Cell[79299, 2856, 291, 10, 70, "Input",
 CellID->626380406],
Cell[79593, 2868, 186, 6, 36, "Output",
 CellID->11854612]
}, Open  ]],
Cell[79794, 2877, 125, 3, 70, "ExampleDelimiter",
 CellID->327203451],
Cell[79922, 2882, 78, 1, 70, "ExampleText",
 CellID->292309597],
Cell[CellGroupData[{
Cell[80025, 2887, 250, 9, 70, "Input",
 CellID->50212146],
Cell[80278, 2898, 274, 9, 36, "Output",
 CellID->545122753]
}, Open  ]],
Cell[80567, 2910, 125, 3, 70, "ExampleDelimiter",
 CellID->487716768],
Cell[80695, 2915, 70, 1, 70, "ExampleText",
 CellID->149610693],
Cell[CellGroupData[{
Cell[80790, 2920, 337, 11, 70, "Input",
 CellID->408955322],
Cell[81130, 2933, 1896, 66, 71, "Output",
 CellID->355882767]
}, Open  ]],
Cell[CellGroupData[{
Cell[83063, 3004, 412, 14, 70, "Input",
 CellID->78572943],
Cell[83478, 3020, 4153, 72, 70, "Output",
 Evaluatable->False,
 CellID->562950459]
}, Open  ]],
Cell[CellGroupData[{
Cell[87668, 3097, 408, 13, 70, "Input",
 CellID->157947200],
Cell[88079, 3112, 656, 22, 36, "Output",
 CellID->654836023]
}, Open  ]],
Cell[88750, 3137, 125, 3, 70, "ExampleDelimiter",
 CellID->160308141],
Cell[88878, 3142, 59, 1, 70, "ExampleText",
 CellID->146235021],
Cell[CellGroupData[{
Cell[88962, 3147, 367, 12, 70, "Input",
 CellID->264134555],
Cell[89332, 3161, 427, 15, 36, "Output",
 CellID->516322150]
}, Open  ]],
Cell[89774, 3179, 125, 3, 70, "ExampleDelimiter",
 CellID->140799112],
Cell[89902, 3184, 69, 1, 70, "ExampleText",
 CellID->297997273],
Cell[CellGroupData[{
Cell[89996, 3189, 630, 21, 70, "Input",
 CellID->454294297],
Cell[90629, 3212, 1623, 48, 88, "Output",
 CellID->545719400]
}, Open  ]],
Cell[92267, 3263, 125, 3, 70, "ExampleDelimiter",
 CellID->146400772],
Cell[92395, 3268, 68, 1, 70, "ExampleText",
 CellID->756311395],
Cell[CellGroupData[{
Cell[92488, 3273, 337, 12, 70, "Input",
 CellID->242404353],
Cell[92828, 3287, 2171, 68, 75, "Output",
 CellID->427821337]
}, Open  ]],
Cell[95014, 3358, 124, 3, 70, "ExampleDelimiter",
 CellID->11130723],
Cell[95141, 3363, 90, 1, 70, "ExampleText",
 CellID->502130737],
Cell[CellGroupData[{
Cell[95256, 3368, 507, 17, 70, "Input",
 CellID->572071652],
Cell[95766, 3387, 1260, 41, 54, "Output",
 CellID->15060585]
}, Open  ]],
Cell[97041, 3431, 125, 3, 70, "ExampleDelimiter",
 CellID->336612686],
Cell[97169, 3436, 96, 3, 70, "ExampleText",
 CellID->90785482],
Cell[CellGroupData[{
Cell[97290, 3443, 413, 14, 70, "Input",
 CellID->15565691],
Cell[97706, 3459, 162, 5, 36, "Output",
 CellID->129476275]
}, Open  ]],
Cell[97883, 3467, 125, 3, 70, "ExampleDelimiter",
 CellID->311367224],
Cell[98011, 3472, 78, 1, 70, "ExampleText",
 CellID->357909727],
Cell[CellGroupData[{
Cell[98114, 3477, 428, 14, 70, "Input",
 CellID->114962634],
Cell[98545, 3493, 840, 28, 36, "Output",
 CellID->60320429]
}, Open  ]],
Cell[CellGroupData[{
Cell[99422, 3526, 577, 19, 70, "Input",
 CellID->602714198],
Cell[100002, 3547, 2663, 87, 108, "Output",
 CellID->21570213]
}, Open  ]],
Cell[102680, 3637, 125, 3, 70, "ExampleDelimiter",
 CellID->731201360],
Cell[102808, 3642, 76, 1, 70, "ExampleText",
 CellID->4884468],
Cell[CellGroupData[{
Cell[102909, 3647, 543, 19, 70, "Input",
 CellID->146539654],
Cell[103455, 3668, 2183, 40, 70, "Output",
 Evaluatable->False,
 CellID->19398052]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[105687, 3714, 236, 7, 70, "ExampleSubsection",
 CellID->208071237],
Cell[105926, 3723, 58, 1, 70, "ExampleText",
 CellID->75271447],
Cell[CellGroupData[{
Cell[106009, 3728, 523, 18, 70, "Input",
 CellID->154699585],
Cell[106535, 3748, 473, 16, 36, "Output",
 CellID->109556617]
}, Open  ]],
Cell[107023, 3767, 124, 3, 70, "ExampleDelimiter",
 CellID->21536370],
Cell[107150, 3772, 75, 1, 70, "ExampleText",
 CellID->60093961],
Cell[CellGroupData[{
Cell[107250, 3777, 283, 9, 70, "Input",
 CellID->55991068],
Cell[107536, 3788, 241, 8, 36, "Output",
 CellID->485395966]
}, Open  ]],
Cell[107792, 3799, 125, 3, 70, "ExampleDelimiter",
 CellID->332381957],
Cell[107920, 3804, 78, 1, 70, "ExampleText",
 CellID->210277461],
Cell[CellGroupData[{
Cell[108023, 3809, 336, 11, 70, "Input",
 CellID->7784294],
Cell[108362, 3822, 2356, 43, 70, "Output",
 Evaluatable->False,
 CellID->410615911]
}, Open  ]],
Cell[110733, 3868, 124, 3, 70, "ExampleDelimiter",
 CellID->82067436],
Cell[110860, 3873, 92, 1, 70, "ExampleText",
 CellID->276046792],
Cell[CellGroupData[{
Cell[110977, 3878, 577, 19, 70, "Input",
 CellID->221242426],
Cell[111557, 3899, 658, 21, 36, "Output",
 CellID->425470587]
}, Open  ]],
Cell[112230, 3923, 125, 3, 70, "ExampleDelimiter",
 CellID->651713204],
Cell[112358, 3928, 81, 1, 70, "ExampleText",
 CellID->453041102],
Cell[CellGroupData[{
Cell[112464, 3933, 638, 20, 70, "Input",
 CellID->646939176],
Cell[113105, 3955, 241, 8, 36, "Output",
 CellID->482201498]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[113395, 3969, 234, 7, 70, "ExampleSubsection",
 CellID->247230330],
Cell[113632, 3978, 76, 1, 70, "ExampleText",
 CellID->371793992],
Cell[CellGroupData[{
Cell[113733, 3983, 377, 13, 70, "Input",
 CellID->730229669],
Cell[114113, 3998, 1903, 67, 116, "Output",
 CellID->102282103]
}, Open  ]],
Cell[116031, 4068, 125, 3, 70, "ExampleDelimiter",
 CellID->740254980],
Cell[116159, 4073, 461, 18, 70, "ExampleText",
 CellID->399380530],
Cell[CellGroupData[{
Cell[116645, 4095, 392, 13, 70, "Input",
 CellID->67018416],
Cell[117040, 4110, 2860, 98, 180, "Output",
 CellID->34795850]
}, Open  ]],
Cell[119915, 4211, 125, 3, 70, "ExampleDelimiter",
 CellID->195936302],
Cell[120043, 4216, 255, 10, 70, "ExampleText",
 CellID->372916470],
Cell[CellGroupData[{
Cell[120323, 4230, 300, 11, 70, "Input",
 CellID->363312606],
Cell[120626, 4243, 2246, 77, 185, "Output",
 CellID->68864444]
}, Open  ]],
Cell[122887, 4323, 65, 1, 70, "ExampleText",
 CellID->738493673],
Cell[CellGroupData[{
Cell[122977, 4328, 654, 22, 70, "Input",
 CellID->32712653],
Cell[123634, 4352, 5125, 88, 70, "Output",
 Evaluatable->False,
 CellID->179148705]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[128820, 4447, 218, 7, 70, "ExampleSection",
 CellID->16960],
Cell[CellGroupData[{
Cell[129063, 4458, 236, 7, 70, "ExampleSubsection",
 CellID->63064318],
Cell[129302, 4467, 557, 21, 70, "ExampleText",
 CellID->413959440],
Cell[CellGroupData[{
Cell[129884, 4492, 396, 14, 70, "Input",
 CellID->386474141],
Cell[130283, 4508, 1150, 42, 98, "Output",
 CellID->449644696]
}, Open  ]],
Cell[131448, 4553, 441, 17, 70, "ExampleText",
 CellID->232545081],
Cell[CellGroupData[{
Cell[131914, 4574, 453, 15, 70, "Input",
 CellID->36241711],
Cell[132370, 4591, 2183, 76, 149, "Output",
 CellID->243651586]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[134602, 4673, 227, 7, 70, "ExampleSubsection",
 CellID->406483917],
Cell[134832, 4682, 299, 9, 70, "ExampleText",
 CellID->458422457],
Cell[CellGroupData[{
Cell[135156, 4695, 303, 11, 70, "Input",
 CellID->258275847],
Cell[135462, 4708, 1012, 33, 58, "Output",
 CellID->376719144]
}, Open  ]],
Cell[136489, 4744, 448, 17, 70, "ExampleText",
 CellID->248533402],
Cell[CellGroupData[{
Cell[136962, 4765, 348, 11, 70, "Input",
 CellID->583642825],
Cell[137313, 4778, 2801, 101, 174, "Output",
 CellID->2572105]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[140163, 4885, 240, 7, 70, "ExampleSubsection",
 CellID->742573599],
Cell[140406, 4894, 277, 8, 70, "ExampleText",
 CellID->940926257],
Cell[CellGroupData[{
Cell[140708, 4906, 213, 7, 70, "Input",
 CellID->142038859],
Cell[140924, 4915, 643, 21, 50, "Output",
 CellID->652335297]
}, Open  ]],
Cell[141582, 4939, 252, 8, 70, "ExampleText",
 CellID->92878819],
Cell[CellGroupData[{
Cell[141859, 4951, 385, 12, 70, "Input",
 CellID->158923480],
Cell[142247, 4965, 625, 21, 50, "Output",
 CellID->113854815]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[142921, 4992, 227, 7, 70, "ExampleSubsection",
 CellID->14362624],
Cell[143151, 5001, 134, 2, 70, "ExampleText",
 CellID->487344474],
Cell[CellGroupData[{
Cell[143310, 5007, 575, 20, 70, "Input",
 CellID->260171957],
Cell[143888, 5029, 528, 18, 36, "Output",
 CellID->50307344]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[144465, 5053, 229, 7, 70, "ExampleSubsection",
 CellID->539120974],
Cell[144697, 5062, 301, 9, 70, "ExampleText",
 CellID->199602890],
Cell[CellGroupData[{
Cell[145023, 5075, 303, 11, 70, "Input",
 CellID->373599954],
Cell[145329, 5088, 1296, 42, 58, "Output",
 CellID->685078356]
}, Open  ]],
Cell[146640, 5133, 454, 17, 70, "ExampleText",
 CellID->121123785],
Cell[CellGroupData[{
Cell[147119, 5154, 356, 11, 70, "Input",
 CellID->195961662],
Cell[147478, 5167, 12542, 376, 1093, "Output",
 CellID->94595778]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[160069, 5549, 237, 7, 70, "ExampleSubsection",
 CellID->547069221],
Cell[160309, 5558, 251, 8, 70, "ExampleText",
 CellID->777105701],
Cell[CellGroupData[{
Cell[160585, 5570, 897, 27, 70, "Input",
 CellID->568869471],
Cell[161485, 5599, 165, 5, 36, "Output",
 CellID->209762618]
}, Open  ]],
Cell[161665, 5607, 408, 15, 70, "ExampleText",
 CellID->2548684],
Cell[CellGroupData[{
Cell[162098, 5626, 897, 28, 70, "Input",
 CellID->620387507],
Cell[162998, 5656, 25479, 446, 3666, "Output",
 CellID->325094556]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[188538, 6109, 226, 7, 70, "ExampleSection",
 CellID->19309015],
Cell[188767, 6118, 96, 1, 70, "ExampleText",
 CellID->22609229],
Cell[188866, 6121, 366, 11, 70, "Input",
 CellID->203029298],
Cell[189235, 6134, 208, 8, 70, "ExampleText",
 CellID->305196516],
Cell[CellGroupData[{
Cell[189468, 6146, 632, 19, 70, "Input",
 CellID->102296639],
Cell[190103, 6167, 456, 16, 54, "Output",
 CellID->272443440]
}, Open  ]],
Cell[190574, 6186, 81, 1, 70, "ExampleText",
 CellID->105832803],
Cell[CellGroupData[{
Cell[190680, 6191, 492, 15, 70, "Input",
 CellID->208008204],
Cell[191175, 6208, 456, 16, 54, "Output",
 CellID->136094764]
}, Open  ]],
Cell[191646, 6227, 124, 3, 70, "ExampleDelimiter",
 CellID->64955039],
Cell[191773, 6232, 94, 1, 70, "ExampleText",
 CellID->97590961],
Cell[191870, 6235, 447, 16, 70, "Input",
 CellID->14288276],
Cell[CellGroupData[{
Cell[192342, 6255, 234, 8, 70, "Input",
 CellID->112995221],
Cell[192579, 6265, 1862, 62, 130, "Output",
 CellID->80327845]
}, Open  ]],
Cell[CellGroupData[{
Cell[194478, 6332, 159, 5, 70, "Input",
 CellID->366482184],
Cell[194640, 6339, 236, 7, 36, "Output",
 CellID->491191451]
}, Open  ]],
Cell[CellGroupData[{
Cell[194913, 6351, 277, 9, 70, "Input",
 CellID->111951020],
Cell[195193, 6362, 2184, 75, 99, "Output",
 CellID->385287027]
}, Open  ]],
Cell[CellGroupData[{
Cell[197414, 6442, 276, 8, 70, "Input",
 CellID->272102385],
Cell[197693, 6452, 4226, 73, 70, "Output",
 Evaluatable->False,
 CellID->496468094]
}, Open  ]],
Cell[201934, 6528, 243, 9, 70, "ExampleText",
 CellID->525156427],
Cell[CellGroupData[{
Cell[202202, 6541, 282, 9, 70, "Input",
 CellID->414817635],
Cell[202487, 6552, 906, 31, 66, "Output",
 CellID->143407276]
}, Open  ]],
Cell[CellGroupData[{
Cell[203430, 6588, 160, 5, 70, "Input",
 CellID->18906318],
Cell[203593, 6595, 236, 7, 36, "Output",
 CellID->129172990]
}, Open  ]],
Cell[CellGroupData[{
Cell[203866, 6607, 270, 9, 70, "Input",
 CellID->313185889],
Cell[204139, 6618, 661, 24, 60, "Output",
 CellID->867412955]
}, Open  ]],
Cell[CellGroupData[{
Cell[204837, 6647, 278, 8, 70, "Input",
 CellID->286748127],
Cell[205118, 6657, 3149, 56, 70, "Output",
 Evaluatable->False,
 CellID->150817383]
}, Open  ]],
Cell[208282, 6716, 125, 3, 70, "ExampleDelimiter",
 CellID->185129299],
Cell[208410, 6721, 306, 12, 70, "ExampleText",
 CellID->752673305],
Cell[208719, 6735, 1328, 48, 70, "Input",
 CellID->186965933],
Cell[210050, 6785, 76, 1, 70, "ExampleText",
 CellID->16833573],
Cell[CellGroupData[{
Cell[210151, 6790, 1061, 33, 70, "Input",
 CellID->6016461],
Cell[211215, 6825, 161, 5, 36, "Output",
 CellID->364441720]
}, Open  ]],
Cell[211391, 6833, 83, 1, 70, "ExampleText",
 CellID->277755156],
Cell[CellGroupData[{
Cell[211499, 6838, 963, 31, 70, "Input",
 CellID->210392438],
Cell[212465, 6871, 159, 5, 36, "Output",
 CellID->7448709]
}, Open  ]],
Cell[212639, 6879, 125, 3, 70, "ExampleDelimiter",
 CellID->627867075],
Cell[212767, 6884, 69, 1, 70, "ExampleText",
 CellID->445600215],
Cell[CellGroupData[{
Cell[212861, 6889, 381, 13, 70, "Input",
 CellID->7852666],
Cell[213245, 6904, 241, 8, 36, "Output",
 CellID->436579911]
}, Open  ]],
Cell[213501, 6915, 82, 1, 70, "ExampleText",
 CellID->198642000],
Cell[CellGroupData[{
Cell[213608, 6920, 509, 17, 70, "Input",
 CellID->319817674],
Cell[214120, 6939, 1652, 45, 88, "Output",
 CellID->113371853]
}, Open  ]],
Cell[215787, 6987, 125, 3, 70, "ExampleDelimiter",
 CellID->346603618],
Cell[215915, 6992, 111, 3, 70, "ExampleText",
 CellID->58707378],
Cell[CellGroupData[{
Cell[216051, 6999, 512, 16, 70, "Input",
 CellID->340549026],
Cell[216566, 7017, 992, 31, 54, "Output",
 CellID->255790266]
}, Open  ]],
Cell[217573, 7051, 240, 8, 70, "ExampleText",
 CellID->262981773],
Cell[CellGroupData[{
Cell[217838, 7063, 212, 6, 70, "Input",
 CellID->465977986],
Cell[218053, 7071, 1187, 30, 88, "Output",
 CellID->46580146]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[219289, 7107, 233, 7, 70, "ExampleSection",
 CellID->3592],
Cell[219525, 7116, 112, 3, 70, "ExampleText",
 CellID->165336304],
Cell[219640, 7121, 371, 13, 70, "Input",
 CellID->8083557],
Cell[CellGroupData[{
Cell[220036, 7138, 233, 8, 70, "Input",
 CellID->122877128],
Cell[220272, 7148, 3870, 129, 239, "Output",
 CellID->141116490]
}, Open  ]],
Cell[CellGroupData[{
Cell[224179, 7282, 838, 27, 70, "Input",
 CellID->314551341],
Cell[225020, 7311, 848, 27, 54, "Output",
 CellID->354102186]
}, Open  ]],
Cell[225883, 7341, 125, 3, 70, "ExampleDelimiter",
 CellID->105597521],
Cell[226011, 7346, 369, 12, 70, "ExampleText",
 CellID->73744098],
Cell[CellGroupData[{
Cell[226405, 7362, 396, 14, 70, "Input",
 CellID->562807392],
Cell[226804, 7378, 1128, 41, 98, "Output",
 CellID->7817485]
}, Open  ]],
Cell[CellGroupData[{
Cell[227969, 7424, 366, 13, 70, "Input",
 CellID->417257063],
Cell[228338, 7439, 1799, 64, 104, "Output",
 CellID->365189893]
}, Open  ]],
Cell[230152, 7506, 245, 8, 70, "ExampleText",
 CellID->60990369],
Cell[CellGroupData[{
Cell[230422, 7518, 100, 3, 70, "Input",
 CellID->4672436],
Cell[230525, 7523, 235, 7, 36, "Output",
 CellID->27475001]
}, Open  ]],
Cell[230775, 7533, 124, 3, 70, "ExampleDelimiter",
 CellID->31417890],
Cell[230902, 7538, 243, 8, 70, "ExampleText",
 CellID->454656365],
Cell[CellGroupData[{
Cell[231170, 7550, 446, 16, 70, "Input",
 CellID->431013195],
Cell[231619, 7568, 2399, 43, 70, "Output",
 Evaluatable->False,
 CellID->98997283]
}, Open  ]],
Cell[CellGroupData[{
Cell[234055, 7616, 463, 16, 70, "Input",
 CellID->444511333],
Cell[234521, 7634, 268, 9, 36, "Output",
 CellID->360347228]
}, Open  ]],
Cell[234804, 7646, 124, 3, 70, "ExampleDelimiter",
 CellID->70533676],
Cell[234931, 7651, 222, 8, 70, "ExampleText",
 CellID->762934543],
Cell[CellGroupData[{
Cell[235178, 7663, 465, 16, 70, "Input",
 CellID->94194871],
Cell[235646, 7681, 421, 15, 51, "Output",
 CellID->2580167]
}, Open  ]],
Cell[CellGroupData[{
Cell[236104, 7701, 432, 15, 70, "Input",
 CellID->66329980],
Cell[236539, 7718, 619, 20, 54, "Output",
 CellID->237474944]
}, Open  ]],
Cell[237173, 7741, 125, 3, 70, "ExampleDelimiter",
 CellID->291889716],
Cell[237301, 7746, 244, 7, 70, "ExampleText",
 CellID->383494931],
Cell[CellGroupData[{
Cell[237570, 7757, 412, 15, 70, "Input",
 CellID->381179523],
Cell[237985, 7774, 1073, 39, 51, "Output",
 CellID->75497919]
}, Open  ]],
Cell[239073, 7816, 124, 3, 70, "ExampleDelimiter",
 CellID->32414259],
Cell[239200, 7821, 221, 7, 70, "ExampleText",
 CellID->40844936],
Cell[CellGroupData[{
Cell[239446, 7832, 236, 9, 70, "Input",
 CellID->12324966],
Cell[239685, 7843, 878, 31, 61, "Output",
 CellID->27763412]
}, Open  ]],
Cell[CellGroupData[{
Cell[240600, 7879, 236, 9, 70, "Input",
 CellID->282945346],
Cell[240839, 7890, 668, 25, 57, "Output",
 CellID->227086603]
}, Open  ]],
Cell[241522, 7918, 125, 3, 70, "ExampleDelimiter",
 CellID->324507312],
Cell[241650, 7923, 233, 8, 70, "ExampleText",
 CellID->290920712],
Cell[CellGroupData[{
Cell[241908, 7935, 212, 7, 70, "Input",
 CellID->243345728],
Cell[242123, 7944, 452, 8, 70, "Message",
 CellID->65631317],
Cell[242578, 7954, 392, 14, 49, "Output",
 CellID->179132848]
}, Open  ]],
Cell[CellGroupData[{
Cell[243007, 7973, 213, 7, 70, "Input",
 CellID->301050383],
Cell[243223, 7982, 643, 21, 50, "Output",
 CellID->141290719]
}, Open  ]],
Cell[243881, 8006, 236, 8, 70, "ExampleText",
 CellID->184751878],
Cell[CellGroupData[{
Cell[244142, 8018, 215, 8, 70, "Input",
 CellID->143189750],
Cell[244360, 8028, 453, 8, 70, "Message",
 CellID->788382857],
Cell[244816, 8038, 306, 10, 39, "Output",
 CellID->17673045]
}, Open  ]],
Cell[245137, 8051, 134, 4, 70, "ExampleText",
 CellID->280901066],
Cell[CellGroupData[{
Cell[245296, 8059, 313, 11, 70, "Input",
 CellID->214332995],
Cell[245612, 8072, 222, 7, 36, "Output",
 CellID->28768640]
}, Open  ]],
Cell[245849, 8082, 258, 10, 70, "ExampleText",
 CellID->15786440],
Cell[CellGroupData[{
Cell[246132, 8096, 183, 6, 70, "Input",
 CellID->665377366],
Cell[246318, 8104, 1137, 34, 85, "Output",
 CellID->344218654]
}, Open  ]],
Cell[CellGroupData[{
Cell[247492, 8143, 539, 18, 70, "Input",
 CellID->174944066],
Cell[248034, 8163, 158, 5, 36, "Output",
 CellID->334084252]
}, Open  ]],
Cell[248207, 8171, 124, 3, 70, "ExampleDelimiter",
 CellID->18312152],
Cell[248334, 8176, 261, 8, 70, "ExampleText",
 CellID->685179284],
Cell[CellGroupData[{
Cell[248620, 8188, 545, 19, 70, "Input",
 CellID->239943741],
Cell[249168, 8209, 1299, 48, 86, "Output",
 CellID->22590211]
}, Open  ]],
Cell[250482, 8260, 214, 8, 70, "ExampleText",
 CellID->286318889],
Cell[CellGroupData[{
Cell[250721, 8272, 687, 23, 70, "Input",
 CellID->52715427],
Cell[251411, 8297, 688, 26, 51, "Output",
 CellID->95451086]
}, Open  ]],
Cell[252114, 8326, 123, 3, 70, "ExampleDelimiter",
 CellID->1616163],
Cell[252240, 8331, 272, 8, 70, "ExampleText",
 CellID->569389538],
Cell[CellGroupData[{
Cell[252537, 8343, 457, 15, 70, "Input",
 CellID->22615369],
Cell[252997, 8360, 828, 29, 39, "Output",
 CellID->14820215]
}, Open  ]],
Cell[CellGroupData[{
Cell[253862, 8394, 589, 19, 70, "Input",
 CellID->393608858],
Cell[254454, 8415, 1063, 35, 58, "Output",
 CellID->544943520]
}, Open  ]],
Cell[255532, 8453, 125, 3, 70, "ExampleDelimiter",
 CellID->326154926],
Cell[255660, 8458, 235, 7, 70, "ExampleText",
 CellID->171844387],
Cell[CellGroupData[{
Cell[255920, 8469, 379, 13, 70, "Input",
 CellID->19781343],
Cell[256302, 8484, 429, 16, 39, "Output",
 CellID->10482459]
}, Open  ]],
Cell[256746, 8503, 216, 8, 70, "ExampleText",
 CellID->587034929],
Cell[CellGroupData[{
Cell[256987, 8515, 420, 14, 70, "Input",
 CellID->21165408],
Cell[257410, 8531, 646, 22, 39, "Output",
 CellID->56809509]
}, Open  ]],
Cell[258071, 8556, 217, 7, 70, "ExampleText",
 CellID->41914721],
Cell[CellGroupData[{
Cell[258313, 8567, 503, 17, 70, "Input",
 CellID->258905246],
Cell[258819, 8586, 3413, 60, 70, "Output",
 Evaluatable->False,
 CellID->237852701]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[262281, 8652, 226, 7, 70, "ExampleSection",
 CellID->20208],
Cell[262510, 8661, 270, 9, 70, "ExampleText",
 CellID->121214518],
Cell[CellGroupData[{
Cell[262805, 8674, 357, 12, 70, "Input",
 CellID->186388489],
Cell[263165, 8688, 277, 10, 38, "Output",
 CellID->273300452]
}, Open  ]],
Cell[263457, 8701, 524, 21, 70, "ExampleText",
 CellID->1993505],
Cell[CellGroupData[{
Cell[264006, 8726, 371, 12, 70, "Input",
 CellID->571336625],
Cell[264380, 8740, 269, 9, 38, "Output",
 CellID->565538614]
}, Open  ]],
Cell[264664, 8752, 199, 6, 70, "ExampleText",
 CellID->412743763],
Cell[CellGroupData[{
Cell[264888, 8762, 374, 12, 70, "Input",
 CellID->24031670],
Cell[265265, 8776, 756, 26, 38, "Output",
 CellID->275029945]
}, Open  ]],
Cell[266036, 8805, 125, 3, 70, "ExampleDelimiter",
 CellID->347321242],
Cell[266164, 8810, 293, 10, 70, "ExampleText",
 CellID->38886635],
Cell[CellGroupData[{
Cell[266482, 8824, 359, 12, 70, "Input",
 CellID->13849347],
Cell[266844, 8838, 946, 15, 70, "Message",
 CellID->52206412],
Cell[267793, 8855, 1663, 56, 125, "Output",
 CellID->1063920]
}, Open  ]],
Cell[269471, 8914, 96, 1, 70, "ExampleText",
 CellID->22762425],
Cell[CellGroupData[{
Cell[269592, 8919, 1026, 34, 70, "Input",
 CellID->699908885],
Cell[270621, 8955, 1785, 33, 70, "Output",
 Evaluatable->False,
 CellID->14235959]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[272455, 8994, 224, 7, 70, "ExampleSection",
 CellID->15786],
Cell[272682, 9003, 247, 8, 70, "ExampleText",
 CellID->380052021],
Cell[CellGroupData[{
Cell[272954, 9015, 1072, 29, 70, "Input",
 CellID->625051074],
Cell[274029, 9046, 286, 11, 38, "Output",
 CellID->3884006]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[274376, 9064, 311, 9, 70, "SeeAlsoSection",
 CellID->11964],
Cell[274690, 9075, 4278, 152, 70, "SeeAlso",
 CellID->21922]
}, Open  ]],
Cell[CellGroupData[{
Cell[279005, 9232, 314, 9, 70, "TutorialsSection",
 CellID->18386],
Cell[279322, 9243, 144, 3, 70, "Tutorials",
 CellID->15204],
Cell[279469, 9248, 157, 4, 70, "Tutorials",
 CellID->31242],
Cell[279629, 9254, 181, 3, 70, "Tutorials",
 CellID->17719],
Cell[279813, 9259, 187, 4, 70, "Tutorials",
 CellID->5317],
Cell[280003, 9265, 191, 4, 70, "Tutorials",
 CellID->4500],
Cell[280197, 9271, 183, 4, 70, "Tutorials",
 CellID->227434737],
Cell[280383, 9277, 165, 3, 70, "Tutorials",
 CellID->212396704]
}, Open  ]],
Cell[CellGroupData[{
Cell[280585, 9285, 321, 9, 70, "RelatedLinksSection",
 CellID->32656],
Cell[280909, 9296, 254, 5, 70, "RelatedLinks",
 CellID->11452]
}, Open  ]],
Cell[CellGroupData[{
Cell[281200, 9306, 318, 9, 70, "MoreAboutSection",
 CellID->29131112],
Cell[281521, 9317, 155, 3, 70, "MoreAbout",
 CellID->75864465],
Cell[281679, 9322, 155, 3, 70, "MoreAbout",
 CellID->631352467],
Cell[281837, 9327, 152, 3, 70, "MoreAbout",
 CellID->21280044],
Cell[281992, 9332, 143, 3, 70, "MoreAbout",
 CellID->180241381],
Cell[282138, 9337, 150, 3, 70, "MoreAbout",
 CellID->34517261],
Cell[282291, 9342, 169, 3, 70, "MoreAbout",
 CellID->295811779],
Cell[282463, 9347, 136, 3, 70, "MoreAbout",
 CellID->150709761],
Cell[282602, 9352, 155, 3, 70, "MoreAbout",
 CellID->909663281],
Cell[282760, 9357, 137, 3, 70, "MoreAbout",
 CellID->611645809],
Cell[282900, 9362, 147, 3, 70, "MoreAbout",
 CellID->605193937],
Cell[283050, 9367, 151, 3, 70, "MoreAbout",
 CellID->284674211],
Cell[283204, 9372, 147, 3, 70, "MoreAbout",
 CellID->803497828],
Cell[283354, 9377, 136, 3, 70, "MoreAbout",
 CellID->28662263]
}, Open  ]],
Cell[283505, 9383, 50, 0, 70, "History"],
Cell[283558, 9385, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

