(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     82710,       2052]
NotebookOptionsPosition[     75489,       1803]
NotebookOutlinePosition[     76937,       1843]
CellTagsIndexPosition[     76851,       1838]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReflectionTransform" :> 
          Documentation`HelpLookup["paclet:ref/ReflectionTransform"], 
          "RotationMatrix" :> 
          Documentation`HelpLookup["paclet:ref/RotationMatrix"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ReflectionTransform\"\>", 
       2->"\<\"RotationMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Geometric Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ReflectionMatrix", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReflectionMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReflectionMatrix"], "[", 
       StyleBox["v", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the matrix that represents reflection of points \
in a mirror normal to the vector ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The reflection is in a mirror that goes through the origin.", "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReflectionMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReflectionMatrix"]], "InlineFormula"],
 " works in any number of dimensions. In 2D it reflects in a line; in 3D in a \
plane."
}], "Notes",
 CellID->78941620]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->205746961],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->9509315],

Cell[TextData[{
 "Reflect along the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " axis, or equivalently reflect in the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " axis:"
}], "ExampleText",
 CellID->99688720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReflectionMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412435141],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwGAGxjAQDkP0fyAJj
o///gTSEZAWRzCBRMGBQRuOzgFWxYBEFcYWBNCuQZkOTZ8aqCyzKCueD1TAw
iKCpor1ZzNj8SNAsdjQ+04g1C5RmmKG6mYA0J1G61EdVQUV5/kNyDTc0HDmI
0sWHxuf6jy1GiU8NIK3ouZ8SM6npPkrMQi8peIkyi7hSh5pmgVIBKPeAzGTG
4huILuLKZ0hZzsAIAOFrPR0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{50, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->342757616]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", "0"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->256696064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132842083]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->466193061],

Cell[TextData[{
 "Reflect along the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " or equivalently in the plane given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ".", "p"}], "==", "0"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->161138370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReflectionMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->478006953],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWDtPAkEQXjjlZXxrsFHR0sTCn2ChVgZrO2JMoDAataCjpKSk5CdQUlJS
UlJSUlJSnrMv7/hcvfE8UZK729mb/XZmdvbbG64rr9X7h8pr7a5SunquPFVr
dy+ly8dn6vJSQohbui72BLV9aqnr1vfpeU73NIlFJe0aac88t2SvJ7XVT+wo
rWXV2+l0TO86aBVBXgNZ6zcaDSN7CnVJNUejUa/X46BuOGchq4bDIaK22+1P
RiHqakimu9GfzWb1ej1A9WyvBp6zVdhofkBB25vNJkHIZvodNT0YDDYjbDxW
MoWJgjU/Wnk6mUxkswzxDGsFsS9bT/RyfqJ1A1FMObVkrJeFjXm/3xf656kb
yUYvx9QrRLxfhfndVt0kqCXX2TPrK59rxpNN9ujvZDQPNSqjcda/RP3uPknG
VrlKks22WWhJ5svitY6Mr6fs9XDx/L7pX2GhIF8h35dAzrFQ3ZwZyAcg52PZ
inx/FMtWzOuvbJXvC7EicBbL48XnIPcciOL3dSZOZuEe2nPA8v+BkXnritwZ
ldnxsgVnOQSZlz2/g7qY/WJ5H/f0f903SWplje9XLO08RMjyv60DeOdADlCQ
9/Fc5nEr2oa7A1F5q5sNjXLxfjxbMQKYx/i9w8vrk0Q8Tj4HW63Wl1qal3/O
79x6Qc8X1KVhq6h2mU6nsqkrnvF43O12ZTNc8VCpZKrHsp3LUWMRkBmb8ef5
39YFeRufufoOa9FwDvoxMjtATZPVmHuHEWiKIcgPZZWp6QPbMjHQwuO9EKou
SF2oUfsjB+M1qvxmc/G6s5YX+n8OkXoDgfXOsw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{90, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->288446734]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->44682435],

Cell[TextData[{
 "Reflect along the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " or equivalently in the plane given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ".", "p"}], "==", 
    "0"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->290632457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"ReflectionMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12545088],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWttOwzAMTbeV68ZlFxjaQHub4EPgiY+YJqSNi0CD/9uXQUmaFo1DMsd1
QYA6qXGd2CeO48ZpuuvJy+zmYfIyn05GV4vJ02w+fR5dPi50VT1SKnpVSp31
lb5P9F16md+bvuytvTvUZawbTzx0nFGf3Bh4lMP2nLZXqNVScW5jktZZWVnt
2Fkr782N65bl9MbBdde2/bW2rH+0qQGTPwe+I9THdgqP0ke+68JXDV3WdGWc
0Q2hV3K8Tkb3hF6i8Lhe4+JRXkT/xalX6w6pVX5T6OUY+H2C53qdi8+dBSk+
NSuIj/6vJSGztMW0whVr60Z1wPSaFL/IsyLBD3l25LOU8t+QLXElxNE3nVry
bFqsX3m2LbNfTjbGfotFgXniDTvwUFxxcXStTK4j1B94cLj6Oe169It5iZvt
hsAj/jbwR8BTK4wUn1rRysZHvlfarJi9wxDoqcN6U7/jsLqWxYpEfwg4RfVz
it4s5h3uXoDKYpjVj4GXZmEKX5qFufjcLGxnpUZImdzPiVm0up/wYtanHxqz
lH5ozEapd2zQppVf9pqWXy6Xyv4apjB81r6b2Hf9xg/L4Uh2HSMNwWn+UbtD
+ytrfD9td6hci2m34SPNmsi30U+tDXfAt0puvyf6t1ZSeWUOPOYZafst0X9Y
9qusrKz8jVbmq5fvpDzkbXLdSXqovu+knauPJ/HlvJVKT1OpUUhPV7n43L2r
FJ/au1azFOLFvzFL1ZcImZfdXyK4o/xvX7nalRcqL3zygildb/45vUjcJxPY
jicPvvac9lbkrUn2PwcqegeU+WrP\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{509, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224423021]
}, Open  ]],

Cell["Points in the reflection plane remain fixed:", "ExampleText",
 CellID->87305678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->738409091],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->117935643]
}, Open  ]],

Cell["\<\
Points outside the reflection plane get reflected in the plane:\
\>", "ExampleText",
 CellID->727612132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->499576837],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->708626169]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80868265],

Cell[TextData[{
 "Reflection matrix for symbolic unit vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->741302895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"ReflectionMatrix", "[", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u", ",", "v"}], "}"}], "\[Element]", "Reals"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"u", "^", "2"}], "+", 
       RowBox[{"v", "^", "2"}]}], "\[Equal]", "1"}]}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->214339635],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVq1TAkEUP7g7QAX50oHRgmMQm1WLTZP/gQaGcQaCo4MEGpFIJBKJRCKR
SCQSiUTi+nbfHrc8H7gD1Z25/Xj7Pn57++737qXSrL1/VJr1aqX03Kh81erV
79LTZwNEbsRxnAY8V0UH5gJm6mkIAaPZ+7J3+/2+UM05hs4H1RiMURgdV6mp
FlO60g/q5rRuWo9xsp9U63a7rdfoylPT2Ww2Go3k9ER2/tpKh/OJryiJL3XO
iU6a9UStUsGJp9MpRdXr9Qys0pVHYsSsYlBkvvFWTXlccNhWq1Wr1QqxuYEU
4TmnjPctb/CX9IzYZq18Ia5OpwMg1G2scUUnk0mG+PAOwJOz8oV4IIEgjTbx
qDtcLBZySnFJLZlHwSh9y20MErQ8saLraGDlm1aBUkJsZreJLPwSkuypyiQS
n89JooUR4WLwI94SMaVRl/XZc3pNcykRvEO9jrDe3lircJ+3ejWs5EmOrKz2
i1X719JSmdwmS3PMXtixRzkrYxWVWvG5zLF80VqTsm52L2TbuJln+ow4pC4g
wrDamgiBXbcgtOPoCystXqpux10ulwyHDAaD+XzO4bLj6ksrrV24oFBDlaG4
QDoejzlcHGObvB8weOEPPb4+IGMOh0NdZRCTR26W5qsdl+dZrWuxmcEkoq7J
ntjN7HktR28AHhNu4/8nrCK3xPperbvdrj41WuEpsdTJ6Y1hJZE/kH20uiO+
H5UU/0edyA9/Ne+r\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{114, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->68876052]
}, Open  ]],

Cell[TextData[{
 "Vectors normal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], TraditionalForm]], "InlineMath"],
 " remain unchanged:"
}], "ExampleText",
 CellID->367902149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"%", ".", 
    RowBox[{"Cross", "[", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], "]"}]}], "\[Equal]", 
   RowBox[{"Cross", "[", 
    RowBox[{"{", 
     RowBox[{"u", ",", "v"}], "}"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33561986],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->691769625]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->862634547],

Cell["Transformation applied to a 2D shape:", "ExampleText",
 CellID->479507293],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rectangle", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419323043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
    ",", 
    RowBox[{"GeometricTransformation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}], 
      ",", 
      RowBox[{"ReflectionMatrix", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "]"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150504143],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], RectangleBox[{0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
     {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, GeometricTransformationBox[
    {RGBColor[1, 0, 0], Opacity[0.85], RectangleBox[{0, 0}], 
     {AbsolutePointSize[10], Opacity[1], 
      {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
      {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, 
    NCache[{{Rational[-3, 5], Rational[-4, 5]}, {
      Rational[-4, 5], Rational[3, 5]}}, {{-0.6, -0.8}, {-0.8, 
     0.6}}]]}]], "Output",
 ImageSize->{184, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36993485]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->386347611],

Cell["Transformation applied to a 3D shape:", "ExampleText",
 CellID->137131831],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cuboid", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367829949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
     ",", 
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}],
        ",", 
       RowBox[{"ReflectionMatrix", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167437831],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], CuboidBox[{0, 0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], Point3DBox[{0, 0, 0}]}, 
     {RGBColor[0, 1, 0], Point3DBox[{1, 1, 1}]}}}, 
   InterpretationBox[
    {RGBColor[1., 0., 0.], Opacity[0.85], 
     GraphicsComplex3DBox[{{0., 0., 0.}, {0., 0., 1.}, {-0.8, 0.6, 0.}, {-0.8,
       0.6, 1.}, {-0.6, -0.8, 0.}, {-0.6, -0.8, 
      1.}, {-1.4, -0.20000000000000007`, 0.}, {-1.4, -0.20000000000000007`, 
      1.}}, Polygon3DBox[{{5, 7, 3, 1}, {2, 6, 5, 1}, {4, 8, 6, 2}, {7, 8, 4, 
       3}, {3, 4, 2, 1}, {6, 8, 7, 5}}],
      VertexColors->Automatic,
      VertexNormals->Automatic], 
     {AbsolutePointSize[10.], Opacity[1.], 
      {RGBColor[1., 0., 1.], Point3DBox[{0., 0., 0.}]}, 
      {RGBColor[0., 1., 0.], Point3DBox[{-1.4, -0.20000000000000007`, 1.}]}}},
    
    GeometricTransformation[{
      Opacity[0.85], 
      RGBColor[1, 0, 0], {
       Cuboid[{0, 0, 0}], 
       AbsolutePointSize[10], 
       Opacity[1], {
        RGBColor[1, 0, 1], 
        Point[{0, 0, 0}]}, {
        RGBColor[0, 1, 0], 
        Point[{1, 1, 1}]}}}, {{
       Rational[-3, 5], 
       Rational[-4, 5], 0}, {
       Rational[-4, 5], 
       Rational[3, 5], 0}, {0, 0, 1}}]]},
  Boxed->False]], "Output",
 ImageSize->{184, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->157553530,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->524213021],

Cell["Flipping a surface:", "ExampleText",
 CellID->536880481],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203831765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"g", ",", 
   RowBox[{"g", "/.", 
    RowBox[{"gc_GraphicsComplex", "\[RuleDelayed]", 
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{"gc", ",", 
       RowBox[{"ReflectionMatrix", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}]}], "]"}]}]}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->567874308],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->754179513]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->843482211],

Cell[TextData[{
 "The determinant of a reflection matrix is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->63340187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", " ", 
  RowBox[{"ReflectionMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->319175584],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65131526]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->471805070],

Cell["The inverse of a reflection matrix is the matrix itself:", "ExampleText",
 CellID->170641362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReflectionMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], ".", 
  RowBox[{"ReflectionMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->605212109],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->545786911]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58651581],

Cell["Reflection can be thought of as a special case of scaling:", \
"ExampleText",
 CellID->1017653138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReflectionMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], "\[Equal]", 
  RowBox[{"ScalingMatrix", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->411973994],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62861005]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->371931855],

Cell["Reflection changes the orientation of polygons:", "ExampleText",
 CellID->258837795],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", 
      RowBox[{"Red", ",", "Blue"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112761615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"gr", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".1"}], ",", ".1"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{"gr", ",", 
       RowBox[{"ReflectionMatrix", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".1"}], ",", ".1"}], "}"}]}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->208065477],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {FaceForm[RGBColor[1, 0, 0], RGBColor[0, 0, 1]], 
     Polygon3DBox[{{0, 0, 0}, {1, 0, 0}, {0, 1, 0}},
      VertexNormals->{{0, 0, 1}, {0, 0, 1}, {0, 0, 1}}]},
    PlotRange->{-0.1, 0.1},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    InterpretationBox[
     {FaceForm[RGBColor[1., 0., 0.], RGBColor[0., 0., 1.]], 
      Polygon3DBox[{{0., 1., 0.}, {1., 0., 0.}, {0., 0., 0.}},
       VertexColors->Automatic,
       VertexNormals->{{0., 0., -1.}, {0., 0., -1.}, {0., 0., -1.}}]},
     GeometricTransformation[{
       FaceForm[
        RGBColor[1, 0, 0], 
        RGBColor[0, 0, 1]], 
       Polygon[{{0, 0, 0}, {1, 0, 0}, {0, 1, 0}}, 
        VertexNormals -> {{0, 0, 1}, {0, 0, 1}, {0, 0, 1}}]}, {{1, 0, 0}, {0, 
      1, 0}, {0, 0, -1}}]],
    PlotRange->{-0.1, 0.1},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{390, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->762115173]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12282565],

Cell["Reflections of a cuboid in vertical planes: ", "ExampleText",
 CellID->220650778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"Cuboid", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}], ",", 
       RowBox[{"ReflectionMatrix", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "a", "]"}], ",", 
          RowBox[{"Sin", "[", "a", "]"}], ",", "0"}], "}"}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", 
       RowBox[{"15", 
        RowBox[{"Pi", "/", "16"}]}], ",", 
       RowBox[{"Pi", "/", "16"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25213579],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60822141]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReflectionTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReflectionTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotationMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotationMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->228619426],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->254276923]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReflectionMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 40.0170824}", "context" -> "System`", 
    "keywords" -> {
     "affine transform", "geometric transformation", 
      "improper orthogonal transformation", "inversion in a point", 
      "mirror image", "rotary reflection"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ReflectionMatrix[v] gives the matrix that represents reflection of \
points in a mirror normal to the vector v.", 
    "synonyms" -> {"reflection matrix"}, "title" -> "ReflectionMatrix", 
    "type" -> "Symbol", "uri" -> "ref/ReflectionMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5075, 156, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->205746961]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 76708, 1831}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1319, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1942, 60, 1581, 37, 70, "ObjectNameGrid"],
Cell[3526, 99, 627, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4190, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4668, 140, 97, 1, 70, "Notes",
 CellID->1067943069],
Cell[4768, 143, 270, 8, 70, "Notes",
 CellID->78941620]
}, Closed]],
Cell[CellGroupData[{
Cell[5075, 156, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->205746961],
Cell[CellGroupData[{
Cell[5460, 170, 146, 5, 70, "ExampleSection",
 CellID->9509315],
Cell[5609, 177, 243, 9, 70, "ExampleText",
 CellID->99688720],
Cell[CellGroupData[{
Cell[5877, 190, 194, 6, 28, "Input",
 CellID->412435141],
Cell[6074, 198, 491, 12, 63, "Output",
 Evaluatable->False,
 CellID->342757616]
}, Open  ]],
Cell[CellGroupData[{
Cell[6602, 215, 139, 5, 28, "Input",
 CellID->256696064],
Cell[6744, 222, 222, 8, 36, "Output",
 CellID->132842083]
}, Open  ]],
Cell[6981, 233, 125, 3, 70, "ExampleDelimiter",
 CellID->466193061],
Cell[7109, 238, 440, 17, 70, "ExampleText",
 CellID->161138370],
Cell[CellGroupData[{
Cell[7574, 259, 207, 7, 28, "Input",
 CellID->478006953],
Cell[7784, 268, 1056, 21, 104, "Output",
 Evaluatable->False,
 CellID->288446734]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8889, 295, 219, 7, 70, "ExampleSection",
 CellID->44682435],
Cell[9111, 304, 461, 17, 70, "ExampleText",
 CellID->290632457],
Cell[CellGroupData[{
Cell[9597, 325, 203, 6, 70, "Input",
 CellID->12545088],
Cell[9803, 333, 1033, 21, 70, "Output",
 Evaluatable->False,
 CellID->224423021]
}, Open  ]],
Cell[10851, 357, 86, 1, 70, "ExampleText",
 CellID->87305678],
Cell[CellGroupData[{
Cell[10962, 362, 179, 6, 70, "Input",
 CellID->738409091],
Cell[11144, 370, 242, 8, 36, "Output",
 CellID->117935643]
}, Open  ]],
Cell[11401, 381, 114, 3, 70, "ExampleText",
 CellID->727612132],
Cell[CellGroupData[{
Cell[11540, 388, 159, 5, 70, "Input",
 CellID->499576837],
Cell[11702, 395, 300, 11, 36, "Output",
 CellID->708626169]
}, Open  ]],
Cell[12017, 409, 124, 3, 70, "ExampleDelimiter",
 CellID->80868265],
Cell[12144, 414, 220, 8, 70, "ExampleText",
 CellID->741302895],
Cell[CellGroupData[{
Cell[12389, 426, 498, 17, 70, "Input",
 CellID->214339635],
Cell[12890, 445, 971, 20, 70, "Output",
 Evaluatable->False,
 CellID->68876052]
}, Open  ]],
Cell[13876, 468, 212, 8, 70, "ExampleText",
 CellID->367902149],
Cell[CellGroupData[{
Cell[14113, 480, 324, 11, 70, "Input",
 CellID->33561986],
Cell[14440, 493, 161, 5, 36, "Output",
 CellID->691769625]
}, Open  ]],
Cell[14616, 501, 125, 3, 70, "ExampleDelimiter",
 CellID->862634547],
Cell[14744, 506, 80, 1, 70, "ExampleText",
 CellID->479507293],
Cell[14827, 509, 620, 20, 70, "Input",
 CellID->419323043],
Cell[CellGroupData[{
Cell[15472, 533, 563, 19, 70, "Input",
 CellID->150504143],
Cell[16038, 554, 719, 17, 157, "Output",
 CellID->36993485]
}, Open  ]],
Cell[16772, 574, 125, 3, 70, "ExampleDelimiter",
 CellID->386347611],
Cell[16900, 579, 80, 1, 70, "ExampleText",
 CellID->137131831],
Cell[16983, 582, 637, 20, 70, "Input",
 CellID->367829949],
Cell[CellGroupData[{
Cell[17645, 606, 652, 21, 70, "Input",
 CellID->167437831],
Cell[18300, 629, 3881, 80, 164, 1299, 33, "CachedBoxData", "BoxData", \
"Output",
 CellID->157553530]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22230, 715, 227, 7, 70, "ExampleSection",
 CellID->524213021],
Cell[22460, 724, 62, 1, 70, "ExampleText",
 CellID->536880481],
Cell[22525, 727, 483, 16, 70, "Input",
 CellID->203831765],
Cell[CellGroupData[{
Cell[23033, 747, 396, 12, 70, "Input",
 CellID->567874308],
Cell[23432, 761, 37073, 612, 70, "Output",
 Evaluatable->False,
 CellID->754179513]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60554, 1379, 237, 7, 70, "ExampleSection",
 CellID->843482211],
Cell[60794, 1388, 188, 7, 70, "ExampleText",
 CellID->63340187],
Cell[CellGroupData[{
Cell[61007, 1399, 206, 6, 70, "Input",
 CellID->319175584],
Cell[61216, 1407, 174, 6, 36, "Output",
 CellID->65131526]
}, Open  ]],
Cell[61405, 1416, 125, 3, 70, "ExampleDelimiter",
 CellID->471805070],
Cell[61533, 1421, 99, 1, 70, "ExampleText",
 CellID->170641362],
Cell[CellGroupData[{
Cell[61657, 1426, 296, 9, 70, "Input",
 CellID->605212109],
Cell[61956, 1437, 391, 13, 36, "Output",
 CellID->545786911]
}, Open  ]],
Cell[62362, 1453, 124, 3, 70, "ExampleDelimiter",
 CellID->58651581],
Cell[62489, 1458, 104, 2, 70, "ExampleText",
 CellID->1017653138],
Cell[CellGroupData[{
Cell[62618, 1464, 346, 11, 70, "Input",
 CellID->411973994],
Cell[62967, 1477, 160, 5, 36, "Output",
 CellID->62861005]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63176, 1488, 230, 7, 70, "ExampleSection",
 CellID->371931855],
Cell[63409, 1497, 90, 1, 70, "ExampleText",
 CellID->258837795],
Cell[63502, 1500, 542, 18, 70, "Input",
 CellID->112761615],
Cell[CellGroupData[{
Cell[64069, 1522, 684, 22, 70, "Input",
 CellID->208065477],
Cell[64756, 1546, 5635, 106, 151, "Output",
 CellID->762115173]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[70440, 1658, 227, 7, 70, "ExampleSection",
 CellID->12282565],
Cell[70670, 1667, 87, 1, 70, "ExampleText",
 CellID->220650778],
Cell[CellGroupData[{
Cell[70782, 1672, 768, 23, 70, "Input",
 CellID->25213579],
Cell[71553, 1697, 2485, 45, 70, "Output",
 Evaluatable->False,
 CellID->60822141]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74099, 1749, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[74418, 1760, 489, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[74944, 1782, 319, 9, 70, "MoreAboutSection",
 CellID->228619426],
Cell[75266, 1793, 151, 3, 70, "MoreAbout",
 CellID->254276923]
}, Open  ]],
Cell[75432, 1799, 27, 0, 70, "History"],
Cell[75462, 1801, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

