(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55769,       1664]
NotebookOptionsPosition[     48518,       1420]
NotebookOutlinePosition[     50203,       1463]
CellTagsIndexPosition[     50117,       1458]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReflectionMatrix" :> 
          Documentation`HelpLookup["paclet:ref/ReflectionMatrix"], 
          "TransformationMatrix" :> 
          Documentation`HelpLookup["paclet:ref/TransformationMatrix"], 
          "TransformationFunction" :> 
          Documentation`HelpLookup["paclet:ref/TransformationFunction"], 
          "RotationTransform" :> 
          Documentation`HelpLookup["paclet:ref/RotationTransform"], 
          "TranslationTransform" :> 
          Documentation`HelpLookup["paclet:ref/TranslationTransform"], 
          "ScalingTransform" :> 
          Documentation`HelpLookup["paclet:ref/ScalingTransform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ReflectionMatrix\"\>", 
       2->"\<\"TransformationMatrix\"\>", 3->"\<\"TransformationFunction\"\>",
        4->"\<\"RotationTransform\"\>", 5->"\<\"TranslationTransform\"\>", 
       6->"\<\"ScalingTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Geometric Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ReflectionTransform", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReflectionTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReflectionTransform"], "[", 
       StyleBox["v", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a ",
     Cell[BoxData[
      ButtonBox["TransformationFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TransformationFunction"]], "InlineFormula"],
     " that represents a reflection in a mirror through the origin, normal to \
the vector ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReflectionTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReflectionTransform"], "[", 
       RowBox[{
        StyleBox["v", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a reflection in a mirror through the point ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ", normal to the vector ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReflectionTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReflectionTransform"]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  ButtonBox["TransformationFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TransformationFunction"]], "InlineFormula"],
 " which can be applied to vectors."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReflectionTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReflectionTransform"]], "InlineFormula"],
 " works in any number of dimensions. In 2D it reflects in a line; in 3D in a \
plane."
}], "Notes",
 CellID->78941620],

Cell[TextData[{
 "The point ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " can lie anywhere in the mirror."
}], "Notes",
 CellID->609640982]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43501507],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->67785997],

Cell[TextData[{
 "Reflection in the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "x"}], TraditionalForm]], "InlineMath"],
 " line: "
}], "ExampleText",
 CellID->273748016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rt", "=", 
  RowBox[{"ReflectionTransform", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->533128593],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"0", "1", "0"},
     {"1", "0", "0"},
     {"0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{230, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19797116]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rt", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->417718257],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", ",", "x"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->398279060]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->424857747],

Cell[TextData[{
 "Reflection in the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane:"
}], "ExampleText",
 CellID->959922006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rt", "=", 
  RowBox[{"ReflectionTransform", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340086139],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"1", "0", "0", "0"},
     {"0", "1", "0", "0"},
     {"0", "0", 
      RowBox[{"-", "1"}], "0"},
     {"0", "0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{253, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98814974]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rt", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50844916],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   RowBox[{"-", "z"}]}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->415973424]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->863125841],

Cell[TextData[{
 "Reflection transform for symbolic unit vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", " ", "w"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->741302895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rt", "=", 
  RowBox[{
   RowBox[{"ReflectionTransform", "[", 
    RowBox[{"{", 
     RowBox[{"u", ",", "v", ",", "w"}], "}"}], "]"}], "//", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Element", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", "Reals"}], "]"}], 
        ",", 
        RowBox[{
         RowBox[{
          RowBox[{"u", "^", "2"}], "+", 
          RowBox[{"v", "^", "2"}], "+", 
          RowBox[{"w", "^", "2"}]}], "\[Equal]", "1"}]}], "}"}]}], "]"}], 
    "&"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->319534828],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["u", "2"]}]}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", "u", " ", "v"}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", "u", " ", "w"}], "0"},
     {
      RowBox[{
       RowBox[{"-", "2"}], " ", "u", " ", "v"}], 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["v", "2"]}]}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", "v", " ", "w"}], "0"},
     {
      RowBox[{
       RowBox[{"-", "2"}], " ", "u", " ", "w"}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", "v", " ", "w"}], 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["w", "2"]}]}], "0"},
     {"0", "0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{353, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98915228]
}, Open  ]],

Cell[TextData[{
 "Vectors normal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", " ", "w"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " remain unchanged:"
}], "ExampleText",
 CellID->367902149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rt", "[", 
    RowBox[{"NullSpace", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"u", ",", "v", ",", "w"}], "}"}], "}"}], "]"}], "]"}], "==", 
   RowBox[{"NullSpace", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w"}], "}"}], "}"}], "]"}]}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->476680332],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->101374803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191382942],

Cell["Transformation applied to a 2D shape:", "ExampleText",
 CellID->479507293],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rectangle", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419323043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
    ",", 
    RowBox[{"GeometricTransformation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}], 
      ",", 
      RowBox[{"ReflectionTransform", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".2"}], ",", 
          RowBox[{"-", ".2"}]}], "}"}]}], "]"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150504143],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], RectangleBox[{0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
     {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, GeometricTransformationBox[
    {RGBColor[1, 0, 0], Opacity[0.85], RectangleBox[{0, 0}], 
     {AbsolutePointSize[10], Opacity[1], 
      {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
      {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, {{{0., -1.}, {-1., 
     0.}}, {-0.4, -0.4}}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13233627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->295790755],

Cell["Transformation applied to a 3D shape:", "ExampleText",
 CellID->137131831],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cuboid", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367829949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
     ",", 
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}],
        ",", 
       RowBox[{"ReflectionTransform", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", ".1"}], ",", 
           RowBox[{"-", ".1"}], ",", "0"}], "}"}]}], "]"}]}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167437831],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], CuboidBox[{0, 0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], Point3DBox[{0, 0, 0}]}, 
     {RGBColor[0, 1, 0], Point3DBox[{1, 1, 1}]}}}, 
   InterpretationBox[
    {RGBColor[1., 0., 0.], Opacity[0.85], 
     GraphicsComplex3DBox[{{-0.24000000000000002`, -0.12000000000000002`, 
      0.}, {-0.24000000000000002`, -0.12000000000000002`, 1.}, {-1.04, 0.48, 
      0.}, {-1.04, 0.48, 1.}, {-0.84, -0.92, 0.}, {-0.84, -0.92, 
      1.}, {-1.64, -0.32000000000000006`, 0.}, {-1.64, -0.32000000000000006`, 
      1.}}, Polygon3DBox[{{5, 7, 3, 1}, {2, 6, 5, 1}, {4, 8, 6, 2}, {7, 8, 4, 
       3}, {3, 4, 2, 1}, {6, 8, 7, 5}}],
      VertexColors->Automatic,
      VertexNormals->Automatic], 
     {AbsolutePointSize[10.], Opacity[1.], 
      {RGBColor[1., 0., 1.], 
       Point3DBox[{-0.24000000000000002`, -0.12000000000000002`, 0.}]}, 
      {RGBColor[0., 1., 0.], 
       Point3DBox[{-1.6400000000000001`, -0.32000000000000006`, 1.}]}}},
    GeometricTransformation[{
      Opacity[0.85], 
      RGBColor[1, 0, 0], {
       Cuboid[{0, 0, 0}], 
       AbsolutePointSize[10], 
       Opacity[1], {
        RGBColor[1, 0, 1], 
        Point[{0, 0, 0}]}, {
        RGBColor[0, 1, 0], 
        Point[{1, 1, 1}]}}}, {{{-0.6, -0.8, 0.}, {-0.8, 0.6, 0.}, {0., 0., 
      1.}}, {-0.24000000000000002`, -0.12000000000000002`, 0.}}]]},
  Boxed->False]], "Output",
 ImageSize->{184, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->438701230,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->214438886],

Cell["Reflecting a graphic:", "ExampleText",
 CellID->218675348],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"E", "^", "x"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->618989561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"gr", ",", 
   RowBox[{"Plot", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "7"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
   RowBox[{"gr", "/.", 
    RowBox[{"L_Line", "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"GeometricTransformation", "[", 
        RowBox[{"L", ",", 
         RowBox[{"ReflectionTransform", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], "]"}]}], 
      "}"}]}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->998753329],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126591019]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->613942882],

Cell["The reflection transformation is its own inverse:", "ExampleText",
 CellID->408208320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"ReflectionTransform", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157210761],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {
      FractionBox["1", "3"], 
      RowBox[{"-", 
       FractionBox["2", "3"]}], 
      RowBox[{"-", 
       FractionBox["2", "3"]}], "0"},
     {
      RowBox[{"-", 
       FractionBox["2", "3"]}], 
      FractionBox["1", "3"], 
      RowBox[{"-", 
       FractionBox["2", "3"]}], "0"},
     {
      RowBox[{"-", 
       FractionBox["2", "3"]}], 
      RowBox[{"-", 
       FractionBox["2", "3"]}], 
      FractionBox["1", "3"], "0"},
     {"0", "0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{278, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->615283094]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "[", "t", "]"}], "\[Equal]", "t"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18694822],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->468188320]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->446262192],

Cell["The determinant of the transformation matrix is -1:", "ExampleText",
 CellID->122310989],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"ReflectionTransform", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104075935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"TransformationMatrix", "[", "t", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21892778],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->251798113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96293002],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReflectionTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReflectionTransform"]], "InlineFormula"],
 " can be represented as a scaling transform:"
}], "ExampleText",
 CellID->30247789],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"ReflectionTransform", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316439989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "\[Equal]", 
  RowBox[{"ScalingTransform", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->136990151],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2008777]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->524049675],

Cell["Reflection changes the orientation of polygons:", "ExampleText",
 CellID->122943630],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", 
      RowBox[{"Red", ",", "Blue"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112761615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"gr", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".1"}], ",", ".1"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{"gr", ",", 
       RowBox[{"ReflectionMatrix", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".1"}], ",", ".1"}], "}"}]}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->208065477],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {FaceForm[RGBColor[1, 0, 0], RGBColor[0, 0, 1]], 
     Polygon3DBox[{{0, 0, 0}, {1, 0, 0}, {0, 1, 0}}]},
    PlotRange->{-0.1, 0.1},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    InterpretationBox[
     {FaceForm[RGBColor[1., 0., 0.], RGBColor[0., 0., 1.]], 
      Polygon3DBox[{{0., 1., 0.}, {1., 0., 0.}, {0., 0., 0.}},
       VertexColors->Automatic,
       VertexNormals->Automatic]},
     GeometricTransformation[{
       FaceForm[
        RGBColor[1, 0, 0], 
        RGBColor[0, 0, 1]], 
       Polygon[{{0, 0, 0}, {1, 0, 0}, {0, 1, 0}}]}, {{1, 0, 0}, {0, 1, 0}, {0,
       0, -1}}]],
    PlotRange->{-0.1, 0.1},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{390, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->175114]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->770764648],

Cell["Reflections of a sine wave:", "ExampleText",
 CellID->575144315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"-", "2"}], "Pi"}], ",", 
      RowBox[{"2", "Pi"}]}], "}"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"Axes", "\[Rule]", "False"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "/.", 
  RowBox[{"L_Line", "\[RuleDelayed]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{"L", ",", 
       RowBox[{"ReflectionTransform", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "u", "]"}], ",", 
          RowBox[{"Sin", "[", "u", "]"}]}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{
        RowBox[{"Pi", "/", "14"}], 
        RowBox[{"Range", "[", "7", "]"}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388894634],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->429394984]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReflectionMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReflectionMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransformationMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TransformationMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransformationFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TransformationFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotationTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotationTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TranslationTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TranslationTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalingTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ReflectionTransform",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
ReflectionTransform"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->309833494],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->25285331]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReflectionTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 14, 41.1889874}", "context" -> "System`", 
    "keywords" -> {
     "affine transform", "geometric transformation", 
      "improper orthogonal transformation", "inversion in a point", 
      "mirror image", "mirror reflection", "reflection in a hyperplane", 
      "reflection in an affine space", "rotary reflection"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ReflectionTransform[v] gives a TransformationFunction that represents a \
reflection in a mirror through the origin, normal to the vector v. \
ReflectionTransform[v, p] gives a reflection in a mirror through the point p, \
normal to the vector v.", "synonyms" -> {"reflection transform"}, "title" -> 
    "ReflectionTransform", "type" -> "Symbol", "uri" -> 
    "ref/ReflectionTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6857, 207, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->43501507]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 49975, 1451}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1905, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2528, 70, 1584, 37, 70, "ObjectNameGrid"],
Cell[4115, 109, 1364, 41, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5516, 155, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5994, 172, 388, 12, 70, "Notes",
 CellID->1067943069],
Cell[6385, 186, 276, 8, 70, "Notes",
 CellID->78941620],
Cell[6664, 196, 156, 6, 70, "Notes",
 CellID->609640982]
}, Closed]],
Cell[CellGroupData[{
Cell[6857, 207, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43501507],
Cell[CellGroupData[{
Cell[7241, 221, 147, 5, 70, "ExampleSection",
 CellID->67785997],
Cell[7391, 228, 176, 7, 70, "ExampleText",
 CellID->273748016],
Cell[CellGroupData[{
Cell[7592, 239, 209, 7, 28, "Input",
 CellID->533128593],
Cell[7804, 248, 404, 14, 64, "Output",
 CellID->19797116]
}, Open  ]],
Cell[CellGroupData[{
Cell[8245, 267, 145, 5, 28, "Input",
 CellID->417718257],
Cell[8393, 274, 203, 7, 36, "Output",
 CellID->398279060]
}, Open  ]],
Cell[8611, 284, 125, 3, 70, "ExampleDelimiter",
 CellID->424857747],
Cell[8739, 289, 152, 6, 70, "ExampleText",
 CellID->959922006],
Cell[CellGroupData[{
Cell[8916, 299, 198, 6, 70, "Input",
 CellID->340086139],
Cell[9117, 307, 468, 16, 80, "Output",
 CellID->98814974]
}, Open  ]],
Cell[CellGroupData[{
Cell[9622, 328, 154, 5, 70, "Input",
 CellID->50844916],
Cell[9779, 335, 232, 8, 36, "Output",
 CellID->415973424]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10060, 349, 220, 7, 70, "ExampleSection",
 CellID->863125841],
Cell[10283, 358, 241, 9, 70, "ExampleText",
 CellID->741302895],
Cell[CellGroupData[{
Cell[10549, 371, 692, 23, 70, "Input",
 CellID->319534828],
Cell[11244, 396, 1061, 36, 88, "Output",
 CellID->98915228]
}, Open  ]],
Cell[12320, 435, 230, 9, 70, "ExampleText",
 CellID->367902149],
Cell[CellGroupData[{
Cell[12575, 448, 411, 14, 70, "Input",
 CellID->476680332],
Cell[12989, 464, 161, 5, 36, "Output",
 CellID->101374803]
}, Open  ]],
Cell[13165, 472, 125, 3, 70, "ExampleDelimiter",
 CellID->191382942],
Cell[13293, 477, 80, 1, 70, "ExampleText",
 CellID->479507293],
Cell[13376, 480, 620, 20, 70, "Input",
 CellID->419323043],
Cell[CellGroupData[{
Cell[14021, 504, 709, 24, 70, "Input",
 CellID->150504143],
Cell[14733, 530, 637, 15, 201, "Output",
 CellID->13233627]
}, Open  ]],
Cell[15385, 548, 125, 3, 70, "ExampleDelimiter",
 CellID->295790755],
Cell[15513, 553, 80, 1, 70, "ExampleText",
 CellID->137131831],
Cell[15596, 556, 637, 20, 70, "Input",
 CellID->367829949],
Cell[CellGroupData[{
Cell[16258, 580, 813, 26, 70, "Input",
 CellID->167437831],
Cell[17074, 608, 4000, 78, 160, 1447, 32, "CachedBoxData", "BoxData", \
"Output",
 CellID->438701230]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21123, 692, 227, 7, 70, "ExampleSection",
 CellID->214438886],
Cell[21353, 701, 64, 1, 70, "ExampleText",
 CellID->218675348],
Cell[21420, 704, 280, 10, 70, "Input",
 CellID->618989561],
Cell[CellGroupData[{
Cell[21725, 718, 740, 22, 70, "Input",
 CellID->998753329],
Cell[22468, 742, 3592, 63, 70, "Output",
 Evaluatable->False,
 CellID->126591019]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26109, 811, 237, 7, 70, "ExampleSection",
 CellID->613942882],
Cell[26349, 820, 92, 1, 70, "ExampleText",
 CellID->408208320],
Cell[CellGroupData[{
Cell[26466, 825, 197, 6, 70, "Input",
 CellID->157210761],
Cell[26666, 833, 810, 30, 106, "Output",
 CellID->615283094]
}, Open  ]],
Cell[CellGroupData[{
Cell[27513, 868, 140, 4, 70, "Input",
 CellID->18694822],
Cell[27656, 874, 161, 5, 36, "Output",
 CellID->468188320]
}, Open  ]],
Cell[27832, 882, 125, 3, 70, "ExampleDelimiter",
 CellID->446262192],
Cell[27960, 887, 94, 1, 70, "ExampleText",
 CellID->122310989],
Cell[28057, 890, 218, 7, 70, "Input",
 CellID->104075935],
Cell[CellGroupData[{
Cell[28300, 901, 145, 4, 70, "Input",
 CellID->21892778],
Cell[28448, 907, 175, 6, 36, "Output",
 CellID->251798113]
}, Open  ]],
Cell[28638, 916, 124, 3, 70, "ExampleDelimiter",
 CellID->96293002],
Cell[28765, 921, 241, 7, 70, "ExampleText",
 CellID->30247789],
Cell[29009, 930, 218, 7, 70, "Input",
 CellID->316439989],
Cell[CellGroupData[{
Cell[29252, 941, 247, 8, 70, "Input",
 CellID->136990151],
Cell[29502, 951, 159, 5, 36, "Output",
 CellID->2008777]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29710, 962, 230, 7, 70, "ExampleSection",
 CellID->524049675],
Cell[29943, 971, 90, 1, 70, "ExampleText",
 CellID->122943630],
Cell[30036, 974, 542, 18, 70, "Input",
 CellID->112761615],
Cell[CellGroupData[{
Cell[30603, 996, 684, 22, 70, "Input",
 CellID->208065477],
Cell[31290, 1020, 5479, 104, 151, "Output",
 CellID->175114]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36818, 1130, 228, 7, 70, "ExampleSection",
 CellID->770764648],
Cell[37049, 1139, 70, 1, 70, "ExampleText",
 CellID->575144315],
Cell[CellGroupData[{
Cell[37144, 1144, 978, 29, 70, "Input",
 CellID->388894634],
Cell[38125, 1175, 7146, 121, 70, "Output",
 Evaluatable->False,
 CellID->429394984]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45332, 1303, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[45651, 1314, 1561, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[47249, 1372, 305, 8, 70, "RelatedLinksSection"],
Cell[47557, 1382, 380, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47974, 1399, 319, 9, 70, "MoreAboutSection",
 CellID->309833494],
Cell[48296, 1410, 150, 3, 70, "MoreAbout",
 CellID->25285331]
}, Open  ]],
Cell[48461, 1416, 27, 0, 70, "History"],
Cell[48491, 1418, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

