(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     72816,       2665]
NotebookOptionsPosition[     56930,       2105]
NotebookOutlinePosition[     58546,       2148]
CellTagsIndexPosition[     58460,       2143]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regular Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/RegularExpressions"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-StringsAndCharacters"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Regular Expressions\"\>", 
       2->"\<\"Special Characters\"\>", 3->"\<\"String Patterns\"\>", 
       4->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], 
          "StringCases" :> Documentation`HelpLookup["paclet:ref/StringCases"],
           "StringReplace" :> 
          Documentation`HelpLookup["paclet:ref/StringReplace"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StringExpression\"\>", 
       2->"\<\"StringCases\"\>", 
       3->"\<\"StringReplace\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RegularExpression", "ObjectName",
 CellID->15072],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RegularExpression",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RegularExpression"], "[", "\"\<\!\(\*
StyleBox[\"regex\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the generalized regular expression specified \
by the string ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"regex\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25489]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RegularExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegularExpression"]], "InlineFormula"],
 " can be used to represent classes of strings, in functions like ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28591],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RegularExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegularExpression"]], "InlineFormula"],
 " supports standard regular expression syntax, of the kind used in typical \
string manipulation languages. "
}], "Notes",
 CellID->822],

Cell["\<\
The following basic elements can be used in regular expression strings: \
\>", "Notes",
 CellID->431],

Cell[BoxData[GridBox[{
   {Cell["      ", 
     "TableRowIcon"], "\<\"\\!\\(\\* StyleBox[\"c\", \"TI\"]\\)\"\>", Cell[
    TextData[{
     "the literal character ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\".\"\>", Cell[
    "any character except newline ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"[\!\(\*
SubscriptBox[
StyleBox[\\\"c\\\", \\\"TI\\\"], 
StyleBox[\\\"1\\\", \\\"TR\\\"]]\)\!\(\*
SubscriptBox[
StyleBox[\\\"c\\\", \\\"TI\\\"], 
StyleBox[\\\"2\\\", \\\"TR\\\"]]\)\!\(\*
StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]\)]\"\>", Cell[TextData[{
     "any of the characters ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"[\!\(\*
SubscriptBox[
StyleBox[\\\"c\\\", \\\"TI\\\"], 
StyleBox[\\\"1\\\", \\\"TR\\\"]]\)-\!\(\*
SubscriptBox[
StyleBox[\\\"c\\\", \\\"TI\\\"], 
StyleBox[\\\"2\\\", \\\"TR\\\"]]\)]\"\>", Cell[TextData[{
     "any character in the range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "\[Dash]",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"[^\!\(\*
SubscriptBox[
StyleBox[\\\"c\\\", \\\"TI\\\"], 
StyleBox[\\\"1\\\", \\\"TR\\\"]]\)\!\(\*
SubscriptBox[
StyleBox[\\\"c\\\", \\\"TI\\\"], 
StyleBox[\\\"2\\\", \\\"TR\\\"]]\)\!\(\*
StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]\)]\"\>", Cell[TextData[{
     "any character except the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", 
     "TableRowIcon"], "\<\"\\!\\(\\* StyleBox[\\\"p\\\", \\\"TI\\\"]\\)*\"\>",
     Cell[TextData[{
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " repeated zero or more times "
    }], "TableText"]},
   {Cell["      ", 
     "TableRowIcon"], "\<\"\\!\\(\\* StyleBox[\\\"p\\\", \\\"TI\\\"]\\)+\"\>",
     Cell[TextData[{
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " repeated one or more times "
    }], "TableText"]},
   {Cell["      ", 
     "TableRowIcon"], "\<\"\\!\\(\\* StyleBox[\\\"p\\\", \\\"TI\\\"]\\)?\"\>",
     Cell[TextData[{
     "zero or one occurrence of ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", 
     "TableRowIcon"], "\<\"\\!\\(\\* StyleBox[\\\"p\\\", \
\\\"TI\\\"]\\){\\!\\(\\* StyleBox[\\\"m\\\", \\\"TI\\\"]\\),\\!\\(\\* \
StyleBox[\\\"n\\\", \\\"TI\\\"]\\)}\"\>", Cell[TextData[{
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " repeated between ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " times "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["p", "TI"], "*", 
     RowBox[{"?", 
      RowBox[{",", 
       RowBox[{
        StyleBox["p", "TI"], "+", 
        RowBox[{"?", 
         StyleBox[
          RowBox[{",", 
           StyleBox["p", "TI"], "??"}]]}]}]}]}]}], Cell[
    "the shortest consistent strings that match ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"(\!\(\*
SubscriptBox[
StyleBox[\\\"p\\\", \\\"TI\\\"], 
StyleBox[\\\"1\\\", \\\"TR\\\"]]\)\!\(\*
SubscriptBox[
StyleBox[\\\"p\\\", \\\"TI\\\"], 
StyleBox[\\\"2\\\", \\\"TR\\\"]]\)\!\(\*
StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]\))\"\>", Cell[TextData[{
     "strings matching the sequence ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     "  "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"\!\(\*
SubscriptBox[
StyleBox[\\\"p\\\", \\\"TI\\\"], 
StyleBox[\\\"1\\\", \\\"TR\\\"]]\)|\!\(\*
SubscriptBox[
StyleBox[\\\"p\\\", \\\"TI\\\"], 
StyleBox[\\\"2\\\", \\\"TR\\\"]]\)\"\>", Cell[TextData[{
     "strings matching ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 ShowStringCharacters->False,
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, {None}},
    "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->30983],

Cell["The following represent classes of characters: ", "Notes",
 CellID->8421],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\<\"\\\\\\\\d\"\>", Cell[
    "digit 0\[Dash]9 ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"\\\\\\\\D\"\>", Cell[
    "nondigit ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"\\\\\\\\s\"\>", Cell[
    "space, newline, tab or other whitespace character ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"\\\\\\\\S\"\>", Cell[
    "nonwhitespace character ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"\\\\\\\\w\"\>", Cell[TextData[{
     "word character (letter, digit or ",
     Cell[BoxData["_"], "InlineFormula"],
     ") "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"\\\\\\\\W\"\>", Cell[
    "nonword character ", "TableText"]},
   {Cell["      ", 
     "TableRowIcon"], "\<\"[[:\\!\\(\\* StyleBox[\\\"class\\\", \
\\\"TI\\\"]\\):]]\"\>", Cell["characters in a named class ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"[^[:\!\(\*
StyleBox[\\\"class\\\",
\\\"TI\\\"]\):]]\"\>", Cell["characters not in a named class ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 ShowStringCharacters->False,
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->3341],

Cell[TextData[{
 "The following named classes can be used: ",
 Cell[BoxData["alnum"], "InlineFormula"],
 ", ",
 Cell[BoxData["alpha"], "InlineFormula"],
 ", ",
 Cell[BoxData["ascii"], "InlineFormula"],
 ", ",
 Cell[BoxData["blank"], "InlineFormula"],
 ", ",
 Cell[BoxData["cntrl"], "InlineFormula"],
 ", ",
 Cell[BoxData["digit"], "InlineFormula"],
 ", ",
 Cell[BoxData["graph"], "InlineFormula"],
 ", ",
 Cell[BoxData["lower"], "InlineFormula"],
 ", ",
 Cell[BoxData["print"], "InlineFormula"],
 ", ",
 Cell[BoxData["punct"], "InlineFormula"],
 ", ",
 Cell[BoxData["space"], "InlineFormula"],
 ", ",
 Cell[BoxData["upper"], "InlineFormula"],
 ", ",
 Cell[BoxData["word"], "InlineFormula"],
 ", ",
 Cell[BoxData["xdigit"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13565],

Cell["The following represent positions in strings: ", "Notes",
 CellID->28898],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\<\"^\"\>", Cell[
    "the beginning of the string (or line) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"$\"\>", Cell[
    "the end of the string (or line) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"\\\\\\\\b\"\>", Cell[
    "word boundary ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"\\\\\\\\B\"\>", Cell[
    "anywhere except a word boundary ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 ShowStringCharacters->False,
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->30535],

Cell["\<\
The following set options for all regular expression elements that follow \
them: \
\>", "Notes",
 CellID->30280],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\<\"(?i)\"\>", Cell[
    "treat upper and lower case as equivalent (ignore case) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"(?m)\"\>", Cell[TextData[{
     "make ",
     Cell[BoxData["^"], "InlineFormula"],
     " and ",
     Cell[BoxData["$"], "InlineFormula"],
     " match start and end of lines (multiline mode) "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\<\"(?s)\"\>", Cell[TextData[{
     "allow ",
     Cell[BoxData["."], "InlineFormula"],
     " to match newline "
    }], "TableText"]},
   {Cell["      ", 
     "TableRowIcon"], "\<\"(?-\\!\\(\\* StyleBox[\\\"c\\\", \\\"TI\\\"]\\))\"\
\>", Cell["unset options ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 AutoSpacing->False,
 ShowStringCharacters->False,
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->16742],

Cell["\<\
\[Backslash]\[Backslash]., \[Backslash]\[Backslash][, etc. represent literal \
characters ., [, etc. \
\>", "Notes",
 CellID->19355],

Cell[TextData[{
 "Analogs of named ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " patterns such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ":", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 " can be set up in regular expression strings using ",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox["regex", "TI"], ")"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24190],

Cell[TextData[{
 "Within a regular expression string, \[Backslash]\[Backslash]",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " represents the substring matched by the ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["n", "TI"], "\[Null]"}]]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " parenthesized regular expression object ",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox["regex", "TI"], ")"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29886],

Cell[TextData[{
 "For the purpose of functions such as ",
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 ", any ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"$", 
    StyleBox["n", "TI"]}]]], "InlineFormula"],
 " appearing in the right\[Hyphen]hand side of a rule ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"RegularExpression", "[", "\"\<\!\(\*
StyleBox[\"regex\", \"TI\"]\)\>\"", "]"}], "->", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " is taken to correspond to the substring matched by the ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["n", "TI"], "\[Null]"}]]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " parenthesized regular expression object in ",
 Cell[BoxData[
  StyleBox["regex", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData["$0"], "InlineFormula"],
 " represents the whole matched string."
}], "Notes",
 CellID->23283]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->687049031],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->448696932],

Cell["Find words involving the characters a, b, c, d, e:", "ExampleText",
 CellID->201948962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<adefgh12c34\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<[a-e]+\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96788867],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ade\"\>", ",", "\<\"c\"\>"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39733226]
}, Open  ]],

Cell["Equivalent form using string patterns:", "ExampleText",
 CellID->40515119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<adefgh12c34\>\"", ",", 
   RowBox[{
    RowBox[{"CharacterRange", "[", 
     RowBox[{"\"\<a\>\"", ",", "\"\<e\>\""}], "]"}], ".."}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->168595815],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ade\"\>", ",", "\<\"c\"\>"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6349079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->241125797],

Cell["Decide whether the string consists of words and whitespace:", \
"ExampleText",
 CellID->780695733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abcd\\nefgh\\n1234\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<(.*|\\\\s*)*\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197494752],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43686673]
}, Open  ]],

Cell["Equivalent form using string patterns:", "ExampleText",
 CellID->310839224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abcd\\nefgh\\n1234\>\"", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"WordCharacter", "..."}], "|", "Whitespace"}], ")"}], "..."}]}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->722354709],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102858484]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(20)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->482923845],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Basic Constructs",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(17)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->68279290],

Cell["Extract any character except newline:", "ExampleText",
 CellID->413173619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a23b42c63d80, 123\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<.\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1331233228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"2\"\>", ",", "\<\"3\"\>", ",", "\<\"b\"\>", 
   ",", "\<\"4\"\>", ",", "\<\"2\"\>", ",", "\<\"c\"\>", ",", "\<\"6\"\>", 
   ",", "\<\"3\"\>", ",", "\<\"d\"\>", ",", "\<\"8\"\>", ",", "\<\"0\"\>", 
   ",", "\<\",\"\>", ",", "\<\" \"\>", ",", "\<\"1\"\>", ",", "\<\"2\"\>", 
   ",", "\<\"3\"\>"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->336293576]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a23b42c63d80, 123\>\"", ",", 
   RowBox[{"Except", "[", 
    RowBox[{"\"\<\\n\>\"", ",", "_"}], "]"}]}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1381002159],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"2\"\>", ",", "\<\"3\"\>", ",", "\<\"b\"\>", 
   ",", "\<\"4\"\>", ",", "\<\"2\"\>", ",", "\<\"c\"\>", ",", "\<\"6\"\>", 
   ",", "\<\"3\"\>", ",", "\<\"d\"\>", ",", "\<\"8\"\>", ",", "\<\"0\"\>", 
   ",", "\<\",\"\>", ",", "\<\" \"\>", ",", "\<\"1\"\>", ",", "\<\"2\"\>", 
   ",", "\<\"3\"\>"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4072004]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->399558946],

Cell["Either of the characters \"a\" and \"b\":", "ExampleText",
 CellID->1394383782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a13b12c1da32efg\>\"", ",", " ", 
   RowBox[{"RegularExpression", "[", "\"\<[ab]\>\"", "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->237664735],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159237342]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a13b12c1da32efg\>\"", ",", 
   RowBox[{"\"\<a\>\"", "|", "\"\<b\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->527835478],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"a\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->390715365]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->810428429],

Cell["Any character between \"a\" and \"c\", including \"a\" and \"c\":", \
"ExampleText",
 CellID->2066668010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<adefgh12c34\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<[a-e]\>\"", "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->902285382],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"d\"\>", ",", "\<\"e\"\>", ",", "\<\"c\"\>"}],
   "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177155318]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<adefgh12c34\>\"", ",", 
   RowBox[{"CharacterRange", "[", 
    RowBox[{"\"\<a\>\"", ",", "\"\<e\>\""}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->906650037],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"d\"\>", ",", "\<\"e\"\>", ",", "\<\"c\"\>"}],
   "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->575068813]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->715634742],

Cell["Any character except \"a\" and \"1\":", "ExampleText",
 CellID->1850355604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a13b12c17a32\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<[^a1]\>\"", "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1894418202],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"3\"\>", ",", "\<\"b\"\>", ",", "\<\"2\"\>", ",", "\<\"c\"\>", 
   ",", "\<\"7\"\>", ",", "\<\"3\"\>", ",", "\<\"2\"\>"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31214846]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a13b12c17a32\>\"", ",", 
   RowBox[{"Except", "[", 
    RowBox[{
     RowBox[{"\"\<a\>\"", "|", "\"\<1\>\""}], ",", "_"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->853096129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"3\"\>", ",", "\<\"b\"\>", ",", "\<\"2\"\>", ",", "\<\"c\"\>", 
   ",", "\<\"7\"\>", ",", "\<\"3\"\>", ",", "\<\"2\"\>"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73862564]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->712660851],

Cell["Any digit repeated one or more times:", "ExampleText",
 CellID->1215944221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a23b4222c63333d80\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\d+\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->570121690],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"23\"\>", ",", "\<\"4222\"\>", ",", "\<\"63333\"\>", 
   ",", "\<\"80\"\>"}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165526311]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a23b4222c63333d80\>\"", ",", "NumberString"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->1653685121],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"23\"\>", ",", "\<\"4222\"\>", ",", "\<\"63333\"\>", 
   ",", "\<\"80\"\>"}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17065902]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108172573],

Cell["The character \"a\" repeated 2 or 3 times:", "ExampleText",
 CellID->920137495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<aabc1aaaagh2ade\>\"", ",", " ", 
   RowBox[{"RegularExpression", "[", "\"\<a{2,3}\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->998104839],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aa\"\>", ",", "\<\"aaa\"\>"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->326336660]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<aabc1aaaagh2ade\>\"", ",", " ", 
   RowBox[{
    RowBox[{"w", ":", 
     RowBox[{"(", 
      RowBox[{"x_", " ", "..."}], ")"}]}], " ", "/;", " ", 
    RowBox[{"(", 
     RowBox[{"2", "\[LessEqual]", " ", 
      RowBox[{"StringLength", "[", "w", "]"}], "\[LessEqual]", " ", "3"}], 
     ")"}]}]}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->981436031],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aa\"\>", ",", "\<\"aaa\"\>"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->644287878]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->429180314],

Cell["Any digit:", "ExampleText",
 CellID->721136418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a2322c63333d80\>\"", ",", " ", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\d\>\"", "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->896496057],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"2\"\>", ",", "\<\"3\"\>", ",", "\<\"2\"\>", ",", "\<\"2\"\>", 
   ",", "\<\"6\"\>", ",", "\<\"3\"\>", ",", "\<\"3\"\>", ",", "\<\"3\"\>", 
   ",", "\<\"3\"\>", ",", "\<\"8\"\>", ",", "\<\"0\"\>"}], "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146247635]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a2322c63333d80\>\"", ",", " ", "DigitCharacter"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->895178317],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"2\"\>", ",", "\<\"3\"\>", ",", "\<\"2\"\>", ",", "\<\"2\"\>", 
   ",", "\<\"6\"\>", ",", "\<\"3\"\>", ",", "\<\"3\"\>", ",", "\<\"3\"\>", 
   ",", "\<\"3\"\>", ",", "\<\"8\"\>", ",", "\<\"0\"\>"}], "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19574618]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129192363],

Cell["Nondigit characters:", "ExampleText",
 CellID->1889557305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a2322c63333d80\>\"", ",", " ", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\D\>\"", "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1371796641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219482596]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a2322c63333d80\>\"", ",", " ", 
   RowBox[{"Except", "[", "DigitCharacter", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2017271144],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->622178630]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->753434044],

Cell["Space, newline, tab or other whitespace character:", "ExampleText",
 CellID->537952533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringCases", "[", 
   RowBox[{"\"\<13\\na22\\t bbb\>\"", ",", 
    RowBox[{"RegularExpression", "[", "\"\<\\\\s\>\"", "]"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1037720567],

Cell["{\"\\n\", \"\\t\", \" \"}", "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->380288761]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringCases", "[", 
   RowBox[{"\"\<13\\na22\\t bbb\>\"", ",", "WhitespaceCharacter"}], "]"}], "//",
   "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1074098742],

Cell["{\"\\n\", \"\\t\", \" \"}", "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->16151187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->879770363],

Cell["Nonwhitespace characters:", "ExampleText",
 CellID->462068261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<13\\na22\\t bbb\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\S\>\"", "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1744602693],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1\"\>", ",", "\<\"3\"\>", ",", "\<\"a\"\>", ",", "\<\"2\"\>", 
   ",", "\<\"2\"\>", ",", "\<\"b\"\>", ",", "\<\"b\"\>", ",", "\<\"b\"\>"}], 
  "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3711885]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<13\\na22\\t bbb\>\"", ",", 
   RowBox[{"Except", "[", "WhitespaceCharacter", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->914465744],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1\"\>", ",", "\<\"3\"\>", ",", "\<\"a\"\>", ",", "\<\"2\"\>", 
   ",", "\<\"2\"\>", ",", "\<\"b\"\>", ",", "\<\"b\"\>", ",", "\<\"b\"\>"}], 
  "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->519290613]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42151644],

Cell["Word characters:", "ExampleText",
 CellID->680395075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a23b42c63,d80\>\"", ",", " ", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\w\>\"", "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->829651616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"2\"\>", ",", "\<\"3\"\>", ",", "\<\"b\"\>", 
   ",", "\<\"4\"\>", ",", "\<\"2\"\>", ",", "\<\"c\"\>", ",", "\<\"6\"\>", 
   ",", "\<\"3\"\>", ",", "\<\"d\"\>", ",", "\<\"8\"\>", ",", "\<\"0\"\>"}], 
  "}"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->659777139]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a23b42c63,d80\>\"", ",", "WordCharacter"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1069540298],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"2\"\>", ",", "\<\"3\"\>", ",", "\<\"b\"\>", 
   ",", "\<\"4\"\>", ",", "\<\"2\"\>", ",", "\<\"c\"\>", ",", "\<\"6\"\>", 
   ",", "\<\"3\"\>", ",", "\<\"d\"\>", ",", "\<\"8\"\>", ",", "\<\"0\"\>"}], 
  "}"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99736642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37289726],

Cell["Nonword characters:", "ExampleText",
 CellID->49605250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a23b:42c63;d80\>\"", ",", " ", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\W\>\"", "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1860683377],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\":\"\>", ",", "\<\";\"\>"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->480400730]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a23b:42c63;d80\>\"", ",", 
   RowBox[{"Except", "[", "WordCharacter", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1815347648],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\":\"\>", ",", "\<\";\"\>"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->659614383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->603330583],

Cell["Find all uppercase letters:", "ExampleText",
 CellID->2036831627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<AaBBccDDeefG\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<[[:upper:]]+\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2139821809],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"BB\"\>", ",", "\<\"DD\"\>", 
   ",", "\<\"G\"\>"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408440736]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<AaBBccDDeefG\>\"", ",", 
   RowBox[{
    RowBox[{"CharacterRange", "[", 
     RowBox[{"\"\<A\>\"", ",", "\"\<Z\>\""}], "]"}], ".."}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->398878674],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"BB\"\>", ",", "\<\"DD\"\>", 
   ",", "\<\"G\"\>"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->76835211]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71519887],

Cell["Split a string at the beginning of a new line:", "ExampleText",
 CellID->1858193542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringSplit", "[", 
   RowBox[{"\"\<line1\\nline2\\nline3\>\"", ",", 
    RowBox[{"RegularExpression", "[", "\"\<(?m)^\>\"", "]"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->533628582],

Cell["{\"line1\\n\", \"line2\\n\", \"line3\"}", "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->286480174]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringSplit", "[", 
   RowBox[{"\"\<line1\\nline2\\nline3\>\"", ",", "StartOfLine"}], "]"}], "//",
   "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->165546795],

Cell["{\"line1\\n\", \"line2\\n\", \"line3\"}", "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->76819231]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->847705997],

Cell["Split a string at the end of a new line:", "ExampleText",
 CellID->1951665720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringSplit", "[", 
   RowBox[{"\"\<line1\\nline2\\nline3\>\"", ",", 
    RowBox[{"RegularExpression", "[", "\"\<(?m)$\>\"", "]"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1191440490],

Cell["{\"line1\", \"\\nline2\", \"\\nline3\"}", "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->43523720]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringSplit", "[", 
   RowBox[{"\"\<line1\\nline2\\nline3\>\"", ",", "EndOfLine"}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->62152030],

Cell["{\"line1\", \"\\nline2\", \"\\nline3\"}", "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->550200961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->190371635],

Cell["Insert a character at the boundary of each word:", "ExampleText",
 CellID->980531762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<123 45 6 789\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<\\\\b\>\"", "]"}], 
    "\[RuleDelayed]", " ", "\"\<X\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->855345374],

Cell[BoxData["\<\"X123X X45X X6X X789X\"\>"], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->650664657]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<123 45 6 789\>\"", ",", 
   RowBox[{"WordBoundary", "\[RuleDelayed]", " ", "\"\<X\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1598493099],

Cell[BoxData["\<\"X123X X45X X6X X789X\"\>"], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->78658183]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->557017362],

Cell["\<\
Split a string at every character except at the boundary of a word:\
\>", "ExampleText",
 CellID->7816856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<12X X5X X89\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\B\>\"", "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->659648616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1\"\>", ",", "\<\"2\"\>", ",", "\<\"X X\"\>", ",", "\<\"5\"\>",
    ",", "\<\"X X\"\>", ",", "\<\"8\"\>", ",", "\<\"9\"\>"}], "}"}]], "Output",\

 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->448219024]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<12X X5X X89\>\"", ",", 
   RowBox[{"Except", "[", "WordBoundary", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1933467191],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1\"\>", ",", "\<\"2\"\>", ",", "\<\"X X\"\>", ",", "\<\"5\"\>",
    ",", "\<\"X X\"\>", ",", "\<\"8\"\>", ",", "\<\"9\"\>"}], "}"}]], "Output",\

 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->216570119]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Compound Constructs",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->648433369],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " can contain ",
 Cell[BoxData[
  ButtonBox["RegularExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegularExpression"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->680480745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a13b12c17a32\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<a\>\"", "~~", 
     RowBox[{"x", ":", 
      RowBox[{"RegularExpression", "[", "\"\<\\\\d+\>\"", "]"}]}]}], 
    "\[Rule]", "x"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->732638461],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"13\"\>", ",", "\<\"32\"\>"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->609318497]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a13b12c17a32\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<a\>\"", "~~", 
     RowBox[{"x", ":", 
      RowBox[{"DigitCharacter", ".."}]}]}], "\[Rule]", "x"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->155641224],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"13\"\>", ",", "\<\"32\"\>"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->376041572]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->325798583],

Cell["Conditional patterns:", "ExampleText",
 CellID->132777888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a23b42c63d80, 123\>\"", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"RegularExpression", "[", "\"\<\\\\d+\>\"", "]"}]}], "/;", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"ToExpression", "[", "x", "]"}], ",", "2"}], "]"}], "\[Equal]",
      "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19334138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"2\"\>", ",", "\<\"42\"\>", ",", "\<\"6\"\>", ",", "\<\"80\"\>",
    ",", "\<\"12\"\>"}], "}"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227486932]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a23b42c63d80, 123\>\"", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"DigitCharacter", ".."}]}], "/;", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"ToExpression", "[", "x", "]"}], ",", "2"}], "]"}], "\[Equal]",
      "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->413978551],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"2\"\>", ",", "\<\"42\"\>", ",", "\<\"6\"\>", ",", "\<\"80\"\>",
    ",", "\<\"12\"\>"}], "}"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->276540758]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->645902992],

Cell["Use alternatives to match one or more line breaks:", "ExampleText",
 CellID->127673320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abcd\\nefgh\\n1234\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<(.*|\\\\s*)*\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1842271211],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6137147]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abcd\\nefgh\\n1234\>\"", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"WordCharacter", "..."}], "|", "Whitespace"}], ")"}], "..."}]}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->125011338],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->402128342]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18555042],

Cell["\<\
Nongreedy matches are done by appending a question mark \"?\" to the \
quantifiers:\
\>", "ExampleText",
 CellID->484227033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abc1agh2cde\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<a.+?\\\\d\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163713619],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abc1\"\>", ",", "\<\"agh2\"\>"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->516242676]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abc1agh2cde\>\"", ",", 
   RowBox[{"Shortest", "[", 
    RowBox[{"\"\<a\>\"", "~~", "__", "~~", "DigitCharacter"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13828332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abc1\"\>", ",", "\<\"agh2\"\>"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->486823799]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1773411505],

Cell[TextData[{
 "The ",
 Cell[BoxData["$1"], "InlineFormula"],
 " refers to the letter matched by ",
 Cell[BoxData[
  RowBox[{"(", ".", ")"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->450132437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<aaabcccabbaacba\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<(.)\\\\1\>\"", "]"}], "->", 
    "\"\<$1\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->969697360],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>", ",", "\<\"b\"\>", ",", "\<\"a\"\>"}],
   "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->334341205]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<aaabcccabbaacba\>\"", ",", 
   RowBox[{
    RowBox[{"x_", "~~", "x_"}], "->", "x"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->288778838],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>", ",", "\<\"b\"\>", ",", "\<\"a\"\>"}],
   "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->253935751]
}, Open  ]],

Cell["Numbered subpatterns:", "ExampleText",
 CellID->548797172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a1b6a3b3a3c3a8b8\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<(a(\\\\d))b\\\\2\>\"", "]"}], 
    "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<$0\>\"", ",", "\"\<$1\>\"", ",", "\"\<$2\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->580970759],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"a3b3\"\>", ",", "\<\"a3\"\>", ",", "\<\"3\"\>"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"a8b8\"\>", ",", "\<\"a8\"\>", ",", "\<\"8\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13832382]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16421],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 " to determine string pattern matches:"
}], "ExampleText",
 CellID->53417589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<12345\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<\\\\d+\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470754810],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314658159]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292641023],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 " to find matching substrings:"
}], "ExampleText",
 CellID->169561890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<aaaa bbbb 1234\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<[a-z]+\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->671808455],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aaaa\"\>", ",", "\<\"bbbb\"\>"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->764311465]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->288317008],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StringSplit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringSplit"]], "InlineFormula"],
 " to split a string into substrings using a delimiter pattern:"
}], "ExampleText",
 CellID->228191408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<1.23, 4.56  7.89\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<(\\\\s|,)+\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->632650469],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1.23\"\>", ",", "\<\"4.56\"\>", ",", "\<\"7.89\"\>"}], 
  "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143913118]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22959],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplace"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31884]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11371],

Cell[TextData[ButtonBox["Regular Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RegularExpressions"]], "Tutorials",
 CellID->28398],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]], "Tutorials",
 CellID->336637905],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->30994],

Cell[TextData[ButtonBox["Implementation notes: Basic System Features",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#16446"], None}]], "RelatedLinks",
 CellID->16969]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->553873426],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->330159182]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RegularExpression - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 15, 40.4561296}", "context" -> "System`", 
    "keywords" -> {
     "AWK", "finite state machines", "grep", "Kleene closure", 
      "Kleene star operator", "pattern matching", "Perl", "positive closure", 
      "regex", "regular language", "sed", "string matching"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RegularExpression[\"regex\"] represents the generalized regular \
expression specified by the string \" regex\". ", 
    "synonyms" -> {
     "*", "+", "|", ".", "?", "*?", "(?", "+?", "\\\\", "??", 
      "regular expression"}, "title" -> "RegularExpression", "type" -> 
    "Symbol", "uri" -> "ref/RegularExpression"}, "SearchTextTranslated" -> "",
   "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17635, 555, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->687049031]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 58316, 2136}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2483, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3106, 86, 55, 1, 70, "ObjectName",
 CellID->15072],
Cell[3164, 89, 647, 19, 70, "Usage",
 CellID->25489]
}, Open  ]],
Cell[CellGroupData[{
Cell[3848, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4326, 130, 786, 27, 70, "Notes",
 CellID->28591],
Cell[5115, 159, 290, 8, 70, "Notes",
 CellID->822],
Cell[5408, 169, 111, 3, 70, "Notes",
 CellID->431],
Cell[5522, 174, 5204, 161, 70, "2ColumnTableMod",
 CellID->30983],
Cell[10729, 337, 79, 1, 70, "Notes",
 CellID->8421],
Cell[10811, 340, 1549, 34, 70, "2ColumnTableMod",
 CellID->3341],
Cell[12363, 376, 775, 31, 70, "Notes",
 CellID->13565],
Cell[13141, 409, 79, 1, 70, "Notes",
 CellID->28898],
Cell[13223, 412, 885, 19, 70, "2ColumnTableMod",
 CellID->30535],
Cell[14111, 433, 123, 4, 70, "Notes",
 CellID->30280],
Cell[14237, 439, 1172, 29, 70, "2ColumnTableMod",
 CellID->16742],
Cell[15412, 470, 142, 4, 70, "Notes",
 CellID->19355],
Cell[15557, 476, 389, 15, 70, "Notes",
 CellID->24190],
Cell[15949, 493, 528, 18, 70, "Notes",
 CellID->29886],
Cell[16480, 513, 1118, 37, 70, "Notes",
 CellID->23283]
}, Closed]],
Cell[CellGroupData[{
Cell[17635, 555, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->687049031],
Cell[CellGroupData[{
Cell[18020, 569, 148, 5, 70, "ExampleSection",
 CellID->448696932],
Cell[18171, 576, 93, 1, 70, "ExampleText",
 CellID->201948962],
Cell[CellGroupData[{
Cell[18289, 581, 208, 6, 28, "Input",
 CellID->96788867],
Cell[18500, 589, 220, 7, 36, "Output",
 CellID->39733226]
}, Open  ]],
Cell[18735, 599, 80, 1, 70, "ExampleText",
 CellID->40515119],
Cell[CellGroupData[{
Cell[18840, 604, 255, 8, 70, "Input",
 CellID->168595815],
Cell[19098, 614, 219, 7, 36, "Output",
 CellID->6349079]
}, Open  ]],
Cell[19332, 624, 125, 3, 70, "ExampleDelimiter",
 CellID->241125797],
Cell[19460, 629, 104, 2, 70, "ExampleText",
 CellID->780695733],
Cell[CellGroupData[{
Cell[19589, 635, 223, 6, 70, "Input",
 CellID->197494752],
Cell[19815, 643, 160, 5, 36, "Output",
 CellID->43686673]
}, Open  ]],
Cell[19990, 651, 81, 1, 70, "ExampleText",
 CellID->310839224],
Cell[CellGroupData[{
Cell[20096, 656, 276, 9, 70, "Input",
 CellID->722354709],
Cell[20375, 667, 161, 5, 36, "Output",
 CellID->102858484]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20585, 678, 221, 7, 70, "ExampleSection",
 CellID->482923845],
Cell[CellGroupData[{
Cell[20831, 689, 237, 7, 70, "ExampleSubsection",
 CellID->68279290],
Cell[21071, 698, 80, 1, 70, "ExampleText",
 CellID->413173619],
Cell[CellGroupData[{
Cell[21176, 703, 208, 5, 70, "Input",
 CellID->1331233228],
Cell[21387, 710, 506, 11, 36, "Output",
 CellID->336293576]
}, Open  ]],
Cell[CellGroupData[{
Cell[21930, 726, 229, 6, 70, "Input",
 CellID->1381002159],
Cell[22162, 734, 504, 11, 36, "Output",
 CellID->4072004]
}, Open  ]],
Cell[22681, 748, 125, 3, 70, "ExampleDelimiter",
 CellID->399558946],
Cell[22809, 753, 85, 1, 70, "ExampleText",
 CellID->1394383782],
Cell[CellGroupData[{
Cell[22919, 758, 215, 6, 70, "Input",
 CellID->237664735],
Cell[23137, 766, 239, 8, 36, "Output",
 CellID->159237342]
}, Open  ]],
Cell[CellGroupData[{
Cell[23413, 779, 192, 5, 70, "Input",
 CellID->527835478],
Cell[23608, 786, 239, 8, 36, "Output",
 CellID->390715365]
}, Open  ]],
Cell[23862, 797, 125, 3, 70, "ExampleDelimiter",
 CellID->810428429],
Cell[23990, 802, 111, 2, 70, "ExampleText",
 CellID->2066668010],
Cell[CellGroupData[{
Cell[24126, 808, 207, 6, 70, "Input",
 CellID->902285382],
Cell[24336, 816, 258, 8, 36, "Output",
 CellID->177155318]
}, Open  ]],
Cell[CellGroupData[{
Cell[24631, 829, 231, 6, 70, "Input",
 CellID->906650037],
Cell[24865, 837, 258, 8, 36, "Output",
 CellID->575068813]
}, Open  ]],
Cell[25138, 848, 125, 3, 70, "ExampleDelimiter",
 CellID->715634742],
Cell[25266, 853, 81, 1, 70, "ExampleText",
 CellID->1850355604],
Cell[CellGroupData[{
Cell[25372, 858, 209, 6, 70, "Input",
 CellID->1894418202],
Cell[25584, 866, 313, 8, 36, "Output",
 CellID->31214846]
}, Open  ]],
Cell[CellGroupData[{
Cell[25934, 879, 253, 8, 70, "Input",
 CellID->853096129],
Cell[26190, 889, 313, 8, 36, "Output",
 CellID->73862564]
}, Open  ]],
Cell[26518, 900, 125, 3, 70, "ExampleDelimiter",
 CellID->712660851],
Cell[26646, 905, 81, 1, 70, "ExampleText",
 CellID->1215944221],
Cell[CellGroupData[{
Cell[26752, 910, 215, 6, 70, "Input",
 CellID->570121690],
Cell[26970, 918, 269, 8, 36, "Output",
 CellID->165526311]
}, Open  ]],
Cell[CellGroupData[{
Cell[27276, 931, 168, 5, 70, "Input",
 CellID->1653685121],
Cell[27447, 938, 268, 8, 36, "Output",
 CellID->17065902]
}, Open  ]],
Cell[27730, 949, 125, 3, 70, "ExampleDelimiter",
 CellID->108172573],
Cell[27858, 954, 85, 1, 70, "ExampleText",
 CellID->920137495],
Cell[CellGroupData[{
Cell[27968, 959, 218, 6, 70, "Input",
 CellID->998104839],
Cell[28189, 967, 222, 7, 36, "Output",
 CellID->326336660]
}, Open  ]],
Cell[CellGroupData[{
Cell[28448, 979, 420, 12, 70, "Input",
 CellID->981436031],
Cell[28871, 993, 222, 7, 36, "Output",
 CellID->644287878]
}, Open  ]],
Cell[29108, 1003, 125, 3, 70, "ExampleDelimiter",
 CellID->429180314],
Cell[29236, 1008, 53, 1, 70, "ExampleText",
 CellID->721136418],
Cell[CellGroupData[{
Cell[29314, 1013, 215, 6, 70, "Input",
 CellID->896496057],
Cell[29532, 1021, 390, 9, 36, "Output",
 CellID->146247635]
}, Open  ]],
Cell[CellGroupData[{
Cell[29959, 1035, 172, 5, 70, "Input",
 CellID->895178317],
Cell[30134, 1042, 389, 9, 36, "Output",
 CellID->19574618]
}, Open  ]],
Cell[30538, 1054, 125, 3, 70, "ExampleDelimiter",
 CellID->129192363],
Cell[30666, 1059, 64, 1, 70, "ExampleText",
 CellID->1889557305],
Cell[CellGroupData[{
Cell[30755, 1064, 216, 6, 70, "Input",
 CellID->1371796641],
Cell[30974, 1072, 239, 8, 36, "Output",
 CellID->219482596]
}, Open  ]],
Cell[CellGroupData[{
Cell[31250, 1085, 204, 5, 70, "Input",
 CellID->2017271144],
Cell[31457, 1092, 239, 8, 36, "Output",
 CellID->622178630]
}, Open  ]],
Cell[31711, 1103, 125, 3, 70, "ExampleDelimiter",
 CellID->753434044],
Cell[31839, 1108, 93, 1, 70, "ExampleText",
 CellID->537952533],
Cell[CellGroupData[{
Cell[31957, 1113, 247, 7, 70, "Input",
 CellID->1037720567],
Cell[32207, 1122, 185, 5, 50, "Output",
 CellID->380288761]
}, Open  ]],
Cell[CellGroupData[{
Cell[32429, 1132, 207, 6, 70, "Input",
 CellID->1074098742],
Cell[32639, 1140, 184, 5, 50, "Output",
 CellID->16151187]
}, Open  ]],
Cell[32838, 1148, 125, 3, 70, "ExampleDelimiter",
 CellID->879770363],
Cell[32966, 1153, 68, 1, 70, "ExampleText",
 CellID->462068261],
Cell[CellGroupData[{
Cell[33059, 1158, 212, 6, 70, "Input",
 CellID->1744602693],
Cell[33274, 1166, 333, 9, 36, "Output",
 CellID->3711885]
}, Open  ]],
Cell[CellGroupData[{
Cell[33644, 1180, 204, 5, 70, "Input",
 CellID->914465744],
Cell[33851, 1187, 335, 9, 36, "Output",
 CellID->519290613]
}, Open  ]],
Cell[34201, 1199, 124, 3, 70, "ExampleDelimiter",
 CellID->42151644],
Cell[34328, 1204, 59, 1, 70, "ExampleText",
 CellID->680395075],
Cell[CellGroupData[{
Cell[34412, 1209, 214, 6, 70, "Input",
 CellID->829651616],
Cell[34629, 1217, 411, 10, 36, "Output",
 CellID->659777139]
}, Open  ]],
Cell[CellGroupData[{
Cell[35077, 1232, 163, 4, 70, "Input",
 CellID->1069540298],
Cell[35243, 1238, 410, 10, 36, "Output",
 CellID->99736642]
}, Open  ]],
Cell[35668, 1251, 124, 3, 70, "ExampleDelimiter",
 CellID->37289726],
Cell[35795, 1256, 61, 1, 70, "ExampleText",
 CellID->49605250],
Cell[CellGroupData[{
Cell[35881, 1261, 216, 6, 70, "Input",
 CellID->1860683377],
Cell[36100, 1269, 219, 7, 36, "Output",
 CellID->480400730]
}, Open  ]],
Cell[CellGroupData[{
Cell[36356, 1281, 198, 5, 70, "Input",
 CellID->1815347648],
Cell[36557, 1288, 219, 7, 36, "Output",
 CellID->659614383]
}, Open  ]],
Cell[36791, 1298, 125, 3, 70, "ExampleDelimiter",
 CellID->603330583],
Cell[36919, 1303, 71, 1, 70, "ExampleText",
 CellID->2036831627],
Cell[CellGroupData[{
Cell[37015, 1308, 217, 6, 70, "Input",
 CellID->2139821809],
Cell[37235, 1316, 261, 8, 36, "Output",
 CellID->408440736]
}, Open  ]],
Cell[CellGroupData[{
Cell[37533, 1329, 256, 8, 70, "Input",
 CellID->398878674],
Cell[37792, 1339, 260, 8, 36, "Output",
 CellID->76835211]
}, Open  ]],
Cell[38067, 1350, 124, 3, 70, "ExampleDelimiter",
 CellID->71519887],
Cell[38194, 1355, 90, 1, 70, "ExampleText",
 CellID->1858193542],
Cell[CellGroupData[{
Cell[38309, 1360, 252, 7, 70, "Input",
 CellID->533628582],
Cell[38564, 1369, 199, 5, 50, "Output",
 CellID->286480174]
}, Open  ]],
Cell[CellGroupData[{
Cell[38800, 1379, 204, 6, 70, "Input",
 CellID->165546795],
Cell[39007, 1387, 198, 5, 50, "Output",
 CellID->76819231]
}, Open  ]],
Cell[39220, 1395, 125, 3, 70, "ExampleDelimiter",
 CellID->847705997],
Cell[39348, 1400, 84, 1, 70, "ExampleText",
 CellID->1951665720],
Cell[CellGroupData[{
Cell[39457, 1405, 253, 7, 70, "Input",
 CellID->1191440490],
Cell[39713, 1414, 198, 5, 50, "Output",
 CellID->43523720]
}, Open  ]],
Cell[CellGroupData[{
Cell[39948, 1424, 201, 6, 70, "Input",
 CellID->62152030],
Cell[40152, 1432, 199, 5, 50, "Output",
 CellID->550200961]
}, Open  ]],
Cell[40366, 1440, 125, 3, 70, "ExampleDelimiter",
 CellID->190371635],
Cell[40494, 1445, 91, 1, 70, "ExampleText",
 CellID->980531762],
Cell[CellGroupData[{
Cell[40610, 1450, 264, 7, 70, "Input",
 CellID->855345374],
Cell[40877, 1459, 186, 5, 36, "Output",
 CellID->650664657]
}, Open  ]],
Cell[CellGroupData[{
Cell[41100, 1469, 216, 6, 70, "Input",
 CellID->1598493099],
Cell[41319, 1477, 185, 5, 36, "Output",
 CellID->78658183]
}, Open  ]],
Cell[41519, 1485, 125, 3, 70, "ExampleDelimiter",
 CellID->557017362],
Cell[41647, 1490, 116, 3, 70, "ExampleText",
 CellID->7816856],
Cell[CellGroupData[{
Cell[41788, 1497, 207, 6, 70, "Input",
 CellID->659648616],
Cell[41998, 1505, 320, 9, 36, "Output",
 CellID->448219024]
}, Open  ]],
Cell[CellGroupData[{
Cell[42355, 1519, 194, 5, 70, "Input",
 CellID->1933467191],
Cell[42552, 1526, 320, 9, 36, "Output",
 CellID->216570119]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42921, 1541, 240, 7, 70, "ExampleSubsection",
 CellID->648433369],
Cell[43164, 1550, 357, 12, 70, "ExampleText",
 CellID->680480745],
Cell[CellGroupData[{
Cell[43546, 1566, 305, 9, 70, "Input",
 CellID->732638461],
Cell[43854, 1577, 221, 7, 36, "Output",
 CellID->609318497]
}, Open  ]],
Cell[CellGroupData[{
Cell[44112, 1589, 278, 9, 70, "Input",
 CellID->155641224],
Cell[44393, 1600, 221, 7, 36, "Output",
 CellID->376041572]
}, Open  ]],
Cell[44629, 1610, 125, 3, 70, "ExampleDelimiter",
 CellID->325798583],
Cell[44757, 1615, 64, 1, 70, "ExampleText",
 CellID->132777888],
Cell[CellGroupData[{
Cell[44846, 1620, 405, 12, 70, "Input",
 CellID->19334138],
Cell[45254, 1634, 281, 8, 36, "Output",
 CellID->227486932]
}, Open  ]],
Cell[CellGroupData[{
Cell[45572, 1647, 381, 12, 70, "Input",
 CellID->413978551],
Cell[45956, 1661, 281, 8, 36, "Output",
 CellID->276540758]
}, Open  ]],
Cell[46252, 1672, 125, 3, 70, "ExampleDelimiter",
 CellID->645902992],
Cell[46380, 1677, 93, 1, 70, "ExampleText",
 CellID->127673320],
Cell[CellGroupData[{
Cell[46498, 1682, 224, 6, 70, "Input",
 CellID->1842271211],
Cell[46725, 1690, 159, 5, 36, "Output",
 CellID->6137147]
}, Open  ]],
Cell[CellGroupData[{
Cell[46921, 1700, 276, 9, 70, "Input",
 CellID->125011338],
Cell[47200, 1711, 161, 5, 36, "Output",
 CellID->402128342]
}, Open  ]],
Cell[47376, 1719, 124, 3, 70, "ExampleDelimiter",
 CellID->18555042],
Cell[47503, 1724, 134, 4, 70, "ExampleText",
 CellID->484227033],
Cell[CellGroupData[{
Cell[47662, 1732, 212, 6, 70, "Input",
 CellID->163713619],
Cell[47877, 1740, 225, 7, 36, "Output",
 CellID->516242676]
}, Open  ]],
Cell[CellGroupData[{
Cell[48139, 1752, 245, 7, 70, "Input",
 CellID->13828332],
Cell[48387, 1761, 225, 7, 36, "Output",
 CellID->486823799]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[48673, 1775, 244, 7, 70, "ExampleSection",
 CellID->1773411505],
Cell[48920, 1784, 206, 8, 70, "ExampleText",
 CellID->450132437],
Cell[CellGroupData[{
Cell[49151, 1796, 252, 7, 70, "Input",
 CellID->969697360],
Cell[49406, 1805, 258, 8, 36, "Output",
 CellID->334341205]
}, Open  ]],
Cell[CellGroupData[{
Cell[49701, 1818, 205, 6, 70, "Input",
 CellID->288778838],
Cell[49909, 1826, 258, 8, 36, "Output",
 CellID->253935751]
}, Open  ]],
Cell[50182, 1837, 64, 1, 70, "ExampleText",
 CellID->548797172],
Cell[CellGroupData[{
Cell[50271, 1842, 348, 10, 70, "Input",
 CellID->580970759],
Cell[50622, 1854, 384, 13, 36, "Output",
 CellID->13832382]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51055, 1873, 233, 7, 70, "ExampleSection",
 CellID->16421],
Cell[51291, 1882, 230, 8, 70, "ExampleText",
 CellID->53417589],
Cell[CellGroupData[{
Cell[51546, 1894, 204, 6, 70, "Input",
 CellID->470754810],
Cell[51753, 1902, 161, 5, 36, "Output",
 CellID->314658159]
}, Open  ]],
Cell[51929, 1910, 125, 3, 70, "ExampleDelimiter",
 CellID->292641023],
Cell[52057, 1915, 221, 8, 70, "ExampleText",
 CellID->169561890],
Cell[CellGroupData[{
Cell[52303, 1927, 212, 6, 70, "Input",
 CellID->671808455],
Cell[52518, 1935, 225, 7, 36, "Output",
 CellID->764311465]
}, Open  ]],
Cell[52758, 1945, 125, 3, 70, "ExampleDelimiter",
 CellID->288317008],
Cell[52886, 1950, 253, 8, 70, "ExampleText",
 CellID->228191408],
Cell[CellGroupData[{
Cell[53164, 1962, 218, 6, 70, "Input",
 CellID->632650469],
Cell[53385, 1970, 250, 8, 36, "Output",
 CellID->143913118]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53696, 1985, 311, 9, 70, "SeeAlsoSection",
 CellID->22959],
Cell[54010, 1996, 728, 26, 70, "SeeAlso",
 CellID->31884]
}, Open  ]],
Cell[CellGroupData[{
Cell[54775, 2027, 314, 9, 70, "TutorialsSection",
 CellID->11371],
Cell[55092, 2038, 148, 3, 70, "Tutorials",
 CellID->28398],
Cell[55243, 2043, 174, 4, 70, "Tutorials",
 CellID->336637905],
Cell[55420, 2049, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[55562, 2054, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[55777, 2063, 321, 9, 70, "RelatedLinksSection",
 CellID->30994],
Cell[56101, 2074, 255, 5, 70, "RelatedLinks",
 CellID->16969]
}, Open  ]],
Cell[CellGroupData[{
Cell[56393, 2084, 319, 9, 70, "MoreAboutSection",
 CellID->553873426],
Cell[56715, 2095, 141, 3, 70, "MoreAbout",
 CellID->330159182]
}, Open  ]],
Cell[56871, 2101, 29, 0, 70, "History"],
Cell[56903, 2103, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

