(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13711,        517]
NotebookOptionsPosition[     10287,        399]
NotebookOutlinePosition[     11567,        435]
CellTagsIndexPosition[     11482,        430]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Nonstandard Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonStandardEvaluation"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Nonstandard Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluate" :> 
          Documentation`HelpLookup["paclet:ref/Evaluate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Evaluate\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Evaluation Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReleaseHold", "ObjectName",
 CellID->23628],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReleaseHold",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReleaseHold"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]removes ",
     Cell[BoxData[
      ButtonBox["Hold",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["HoldForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["HoldPattern",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["HoldComplete",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8479]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 " removes only one layer of ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " etc.; it does not remove inner occurrences in nested ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " etc. functions. "
}], "Notes",
 CellID->20363]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->129755618],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->654066897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149640756],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->267289116]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->366617503],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64752435]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4868],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 " removes all standard unevaluated containers:"
}], "ExampleText",
 CellID->18241862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Hold", "[", 
     RowBox[{"1", "+", "2"}], "]"}], ",", 
    RowBox[{"HoldForm", "[", 
     RowBox[{"2", "+", "3"}], "]"}], ",", 
    RowBox[{"HoldComplete", "[", 
     RowBox[{"3", "+", "4"}], "]"}], ",", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"_", "*", "_"}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35931183],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "5", ",", "7", ",", 
   SuperscriptBox["_", "2"]}], "}"}]], "Output",
 ImageSize->{86, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125482270]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22978],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 " removes only the outermost layer of ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->386307478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", 
  RowBox[{"f", "[", 
   RowBox[{"Hold", "[", 
    RowBox[{"1", "+", "2"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->726795939],

Cell[BoxData[
 RowBox[{"f", "[", "3", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61090821]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", 
  RowBox[{"f", "[", 
   RowBox[{"Hold", "[", 
    RowBox[{"1", "+", 
     RowBox[{"g", "[", 
      RowBox[{"Hold", "[", 
       RowBox[{"2", "+", "3"}], "]"}], "]"}]}], "]"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->80425364],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", "+", 
   RowBox[{"g", "[", 
    RowBox[{"Hold", "[", 
     RowBox[{"2", "+", "3"}], "]"}], "]"}]}], "]"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45951327]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8375],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->15093]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18108],

Cell[TextData[ButtonBox["Nonstandard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "Tutorials",
 CellID->28828]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->675325836]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReleaseHold - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 15, 41.7530378}", "context" -> "System`", 
    "keywords" -> {"evaluation control", "thaw", "unfreeze expressions"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ReleaseHold[expr] removes Hold, HoldForm, HoldPattern and HoldComplete \
in expr. ", "synonyms" -> {"release hold"}, "title" -> "ReleaseHold", "type" -> 
    "Symbol", "uri" -> "ref/ReleaseHold"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4609, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->129755618]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11339, 423}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1747, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2370, 74, 49, 1, 70, "ObjectName",
 CellID->23628],
Cell[2422, 77, 1132, 38, 70, "Usage",
 CellID->8479]
}, Open  ]],
Cell[CellGroupData[{
Cell[3591, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4069, 137, 503, 17, 70, "Notes",
 CellID->20363]
}, Closed]],
Cell[CellGroupData[{
Cell[4609, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->129755618],
Cell[CellGroupData[{
Cell[4994, 173, 148, 5, 70, "ExampleSection",
 CellID->654066897],
Cell[CellGroupData[{
Cell[5167, 182, 123, 4, 28, "Input",
 CellID->149640756],
Cell[5293, 188, 211, 7, 36, "Output",
 CellID->267289116]
}, Open  ]],
Cell[CellGroupData[{
Cell[5541, 200, 107, 3, 28, "Input",
 CellID->366617503],
Cell[5651, 205, 157, 5, 36, "Output",
 CellID->64752435]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5857, 216, 215, 7, 70, "ExampleSection",
 CellID->4868],
Cell[6075, 225, 227, 7, 70, "ExampleText",
 CellID->18241862],
Cell[CellGroupData[{
Cell[6327, 236, 424, 13, 70, "Input",
 CellID->35931183],
Cell[6754, 251, 248, 8, 39, "Output",
 CellID->125482270]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7051, 265, 233, 7, 70, "ExampleSection",
 CellID->22978],
Cell[7287, 274, 337, 12, 70, "ExampleText",
 CellID->386307478],
Cell[CellGroupData[{
Cell[7649, 290, 192, 6, 70, "Input",
 CellID->726795939],
Cell[7844, 298, 184, 6, 36, "Output",
 CellID->61090821]
}, Open  ]],
Cell[CellGroupData[{
Cell[8065, 309, 287, 10, 70, "Input",
 CellID->80425364],
Cell[8355, 321, 296, 10, 36, "Output",
 CellID->45951327]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8712, 338, 310, 9, 70, "SeeAlsoSection",
 CellID->8375],
Cell[9025, 349, 196, 6, 70, "SeeAlso",
 CellID->15093]
}, Open  ]],
Cell[CellGroupData[{
Cell[9258, 360, 314, 9, 70, "TutorialsSection",
 CellID->18108],
Cell[9575, 371, 154, 3, 70, "Tutorials",
 CellID->28828]
}, Open  ]],
Cell[CellGroupData[{
Cell[9766, 379, 299, 8, 70, "MoreAboutSection"],
Cell[10068, 389, 147, 3, 70, "MoreAbout",
 CellID->675325836]
}, Open  ]],
Cell[10230, 395, 27, 0, 70, "History"],
Cell[10260, 397, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

