(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34143,       1214]
NotebookOptionsPosition[     28159,       1006]
NotebookOutlinePosition[     29692,       1046]
CellTagsIndexPosition[     29606,       1041]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"], 
          "Repeated Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/RepeatedPatterns"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns and Transformation Rules\"\>", 
       2->"\<\"Repeated Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RepeatedNull" :> 
          Documentation`HelpLookup["paclet:ref/RepeatedNull"], 
          "BlankSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankSequence"], 
          "PatternSequence" :> 
          Documentation`HelpLookup["paclet:ref/PatternSequence"], "Longest" :> 
          Documentation`HelpLookup["paclet:ref/Longest"], "Shortest" :> 
          Documentation`HelpLookup["paclet:ref/Shortest"], "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RepeatedNull\"\>", 
       2->"\<\"BlankSequence\"\>", 3->"\<\"PatternSequence\"\>", 
       4->"\<\"Longest\"\>", 5->"\<\"Shortest\"\>", 
       6->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language: New in 6.0" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Core Language: New in 6.0\"\>", 
       2->"\<\"Patterns\"\>", 
       3->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "Repeated ",
     StyleBox["(..)", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["p", "TI"], ".."}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Repeated",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Repeated"], "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a pattern object which represents a sequence of one \
or more expressions, each matching\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Repeated",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Repeated"], "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["max", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents up to ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     " expressions matching ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Repeated",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Repeated"], "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["min", "TI"], ",", 
          StyleBox["max", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents between ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     " expressions matching ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Repeated",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Repeated"], "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        RowBox[{"{", 
         StyleBox["n", "TI"], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents exactly ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " expressions matching ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->12175]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], ".."}]], "InlineFormula"],
 " can appear as an argument of any function. It represents any sequence of \
arguments. "
}], "Notes",
 CellID->26750],

Cell[TextData[{
 "All the objects in the sequence represented by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], ".."}]], "InlineFormula"],
 " must match ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ", but the objects need not be identical. "
}], "Notes",
 CellID->12859],

Cell[TextData[{
 "The expression ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " may, but need not, itself be a pattern object. "
}], "Notes",
 CellID->22744]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20639976],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->7736177],

Cell[TextData[{
 "Replace any list of ",
 Cell[BoxData["a"], "InlineFormula"],
 "'s by ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", "a", "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ".."}], "}"}], "->", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4168]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14776],

Cell[TextData[{
 "Replace any list of ",
 Cell[BoxData["f"], "InlineFormula"],
 "'s with one argument:"
}], "ExampleText",
 CellID->2397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "a", "]"}], ",", 
      RowBox[{"f", "[", "b", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"f", "[", "a", "]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "b"}], "]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "a", "]"}], ",", 
      RowBox[{"g", "[", "b", "]"}]}], "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "_", "]"}], ".."}], "}"}], "->", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1024],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", "x", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], ",", 
     RowBox[{"g", "[", "b", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12048]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16016],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"a", ".."}]], "InlineFormula"],
 " represents a sequence of ",
 Cell[BoxData["a"], "InlineFormula"],
 "'s inside any head:"
}], "ExampleText",
 CellID->11658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "a"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "a", ",", "a"}], "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ".."}], "]"}], "->", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25675],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "x"}], "}"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14567]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16177],

Cell[TextData[{
 "Replace any list of ",
 Cell[BoxData["a"], "InlineFormula"],
 "'s with length up to 3:"
}], "ExampleText",
 CellID->29805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a", ",", "a", ",", "a"}], "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Repeated", "[", 
     RowBox[{"a", ",", "3"}], "]"}], "}"}], "->", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10420],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", "x", ",", "x", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "a", ",", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18012]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23191],

Cell[TextData[{
 "Replace any list of ",
 Cell[BoxData["a"], "InlineFormula"],
 "'s with lengths between 2 and 3:"
}], "ExampleText",
 CellID->16450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a", ",", "a", ",", "a"}], "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Repeated", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "}"}], "->", "x"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->10847],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "a", "}"}], ",", "x", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "a", ",", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21530]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12901],

Cell["Replace lists with lengths between 0 and 3:", "ExampleText",
 CellID->2560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a", ",", "a", ",", "a"}], "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Repeated", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3"}], "}"}]}], "]"}], "}"}], "->", "x"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->23790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "a", ",", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->850]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27977],

Cell["Replace lists of length exactly 3:", "ExampleText",
 CellID->10219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "a", ",", "a", ",", "a"}], "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Repeated", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", "3", "}"}]}], "]"}], "}"}], "->", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7844],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "a", ",", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22034]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6732],

Cell["\<\
Define a function that takes as an argument any list of pairs:\
\>", "ExampleText",
 CellID->27073],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x", ":", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"_", ",", "_"}], "}"}], ".."}], "}"}]}], "]"}], ":=", 
  RowBox[{"Norm", "[", 
   RowBox[{"N", "[", "x", "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19670],

Cell[BoxData["4.079143328941734`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18197]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18343],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->18352]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"Pi", ",", "E"}], "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"_Integer", " ", ".."}], "}"}], "->", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7856],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"\[Pi]", ",", "\[ExponentialE]"}], "}"}]}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31448]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"Pi", ",", "E"}], "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", "__Integer", " ", "}"}], "->", "x"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"\[Pi]", ",", "\[ExponentialE]"}], "}"}]}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8536]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19052],

Cell[TextData[{
 "Use parentheses or spaces to indicate that ",
 Cell[BoxData[
  RowBox[{"1.", "."}]], "InlineFormula"],
 " is not ",
 Cell[BoxData["1."], "InlineFormula"],
 " followed by a dot:"
}], "ExampleText",
 CellID->2360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"(", "1", ")"}], ".."}], "}"}], "->", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30123],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28930]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1768],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RepeatedNull",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RepeatedNull"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlankSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PatternSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Longest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Longest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Shortest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shortest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3947]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30007],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785],

Cell[TextData[ButtonBox["Repeated Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepeatedPatterns"]], "Tutorials",
 CellID->23655]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->387832715],

Cell[TextData[ButtonBox["Core Language: New in 6.0",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->95772799],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->600393582],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->300337022]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Repeated (..) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 25.3947800}", "context" -> "System`", 
    "keywords" -> {
     "repeated pattern", "repeated expression", "one-or-more", "one or more"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "p .. or Repeated[p] is a pattern object which represents a sequence of \
one or more expressions, each matching p. Repeated[p, max] represents up to \
max expressions matching p. Repeated[p, {min, max}] represents between min \
and max expressions matching p. Repeated[p, {n}] represents exactly n \
expressions matching p.", "synonyms" -> {".."}, "title" -> "Repeated", "type" -> 
    "Symbol", "uri" -> "ref/Repeated"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11337, 313, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20639976]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29463, 1034}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2770, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3393, 90, 4260, 86, 70, "ObjectNameGrid"],
Cell[7656, 178, 2446, 81, 70, "Usage",
 CellID->12175]
}, Open  ]],
Cell[CellGroupData[{
Cell[10139, 264, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10617, 281, 212, 7, 70, "Notes",
 CellID->26750],
Cell[10832, 290, 292, 10, 70, "Notes",
 CellID->12859],
Cell[11127, 302, 173, 6, 70, "Notes",
 CellID->22744]
}, Closed]],
Cell[CellGroupData[{
Cell[11337, 313, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20639976],
Cell[CellGroupData[{
Cell[11721, 327, 146, 5, 70, "ExampleSection",
 CellID->7736177],
Cell[11870, 334, 166, 7, 70, "ExampleText",
 CellID->2998],
Cell[CellGroupData[{
Cell[12061, 345, 443, 16, 28, "Input",
 CellID->16060],
Cell[12507, 363, 297, 10, 36, "Output",
 CellID->4168]
}, Open  ]],
Cell[12819, 376, 121, 3, 70, "ExampleDelimiter",
 CellID->14776],
Cell[12943, 381, 137, 5, 70, "ExampleText",
 CellID->2397],
Cell[CellGroupData[{
Cell[13105, 390, 654, 23, 70, "Input",
 CellID->1024],
Cell[13762, 415, 440, 15, 36, "Output",
 CellID->12048]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14251, 436, 216, 7, 70, "ExampleSection",
 CellID->16016],
Cell[14470, 445, 199, 7, 70, "ExampleText",
 CellID->11658],
Cell[CellGroupData[{
Cell[14694, 456, 398, 14, 70, "Input",
 CellID->25675],
Cell[15095, 472, 264, 9, 36, "Output",
 CellID->14567]
}, Open  ]],
Cell[15374, 484, 121, 3, 70, "ExampleDelimiter",
 CellID->16177],
Cell[15498, 489, 140, 5, 70, "ExampleText",
 CellID->29805],
Cell[CellGroupData[{
Cell[15663, 498, 505, 17, 70, "Input",
 CellID->10420],
Cell[16171, 517, 318, 10, 36, "Output",
 CellID->18012]
}, Open  ]],
Cell[16504, 530, 121, 3, 70, "ExampleDelimiter",
 CellID->23191],
Cell[16628, 535, 149, 5, 70, "ExampleText",
 CellID->16450],
Cell[CellGroupData[{
Cell[16802, 544, 562, 20, 70, "Input",
 CellID->10847],
Cell[17367, 566, 342, 11, 36, "Output",
 CellID->21530]
}, Open  ]],
Cell[17724, 580, 121, 3, 70, "ExampleDelimiter",
 CellID->12901],
Cell[17848, 585, 81, 1, 70, "ExampleText",
 CellID->2560],
Cell[CellGroupData[{
Cell[17954, 590, 562, 20, 70, "Input",
 CellID->23790],
Cell[18519, 612, 297, 9, 36, "Output",
 CellID->850]
}, Open  ]],
Cell[18831, 624, 121, 3, 70, "ExampleDelimiter",
 CellID->27977],
Cell[18955, 629, 73, 1, 70, "ExampleText",
 CellID->10219],
Cell[CellGroupData[{
Cell[19053, 634, 531, 18, 70, "Input",
 CellID->7844],
Cell[19587, 654, 391, 13, 36, "Output",
 CellID->22034]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20027, 673, 222, 7, 70, "ExampleSection",
 CellID->6732],
Cell[20252, 682, 109, 3, 70, "ExampleText",
 CellID->27073],
Cell[20364, 687, 303, 11, 70, "Input",
 CellID->17639],
Cell[CellGroupData[{
Cell[20692, 702, 303, 11, 70, "Input",
 CellID->19670],
Cell[20998, 715, 171, 5, 36, "Output",
 CellID->18197]
}, Open  ]],
Cell[CellGroupData[{
Cell[21206, 725, 313, 11, 70, "Input",
 CellID->18343],
Cell[21522, 738, 402, 14, 36, "Output",
 CellID->18352]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21973, 758, 232, 7, 70, "ExampleSection",
 CellID->4934],
Cell[CellGroupData[{
Cell[22230, 769, 390, 14, 70, "Input",
 CellID->7856],
Cell[22623, 785, 276, 9, 36, "Output",
 CellID->31448]
}, Open  ]],
Cell[CellGroupData[{
Cell[22936, 799, 371, 13, 70, "Input",
 CellID->18764],
Cell[23310, 814, 275, 9, 36, "Output",
 CellID->8536]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23634, 829, 226, 7, 70, "ExampleSection",
 CellID->19052],
Cell[23863, 838, 229, 8, 70, "ExampleText",
 CellID->2360],
Cell[CellGroupData[{
Cell[24117, 850, 368, 14, 70, "Input",
 CellID->30123],
Cell[24488, 866, 258, 9, 36, "Output",
 CellID->28930]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24807, 882, 310, 9, 70, "SeeAlsoSection",
 CellID->1768],
Cell[25120, 893, 1476, 53, 70, "SeeAlso",
 CellID->3947]
}, Open  ]],
Cell[CellGroupData[{
Cell[26633, 951, 314, 9, 70, "TutorialsSection",
 CellID->30007],
Cell[26950, 962, 178, 3, 70, "Tutorials",
 CellID->244552785],
Cell[27131, 967, 144, 3, 70, "Tutorials",
 CellID->23655]
}, Open  ]],
Cell[CellGroupData[{
Cell[27312, 975, 319, 9, 70, "MoreAboutSection",
 CellID->387832715],
Cell[27634, 986, 155, 3, 70, "MoreAbout",
 CellID->95772799],
Cell[27792, 991, 128, 3, 70, "MoreAbout",
 CellID->600393582],
Cell[27923, 996, 141, 3, 70, "MoreAbout",
 CellID->300337022]
}, Open  ]],
Cell[28079, 1002, 50, 0, 70, "History"],
Cell[28132, 1004, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

