(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23537,        903]
NotebookOptionsPosition[     18053,        708]
NotebookOutlinePosition[     19457,        746]
CellTagsIndexPosition[     19372,        741]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingTransformationRules"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Transformation Rules\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Replace" :> Documentation`HelpLookup["paclet:ref/Replace"], 
          "Rule" :> Documentation`HelpLookup["paclet:ref/Rule"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"], "MapAll" :> 
          Documentation`HelpLookup["paclet:ref/MapAll"], "ReplaceRepeated" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceRepeated"], 
          "TransformationFunctions" :> 
          Documentation`HelpLookup["paclet:ref/TransformationFunctions"], 
          "ReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Replace\"\>", 2->"\<\"Rule\"\>", 
       3->"\<\"Set\"\>", 4->"\<\"MapAll\"\>", 5->"\<\"ReplaceRepeated\"\>", 
       6->"\<\"TransformationFunctions\"\>", 
       7->"\<\"ReplaceList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Systems & Discovery" :> 
          Documentation`HelpLookup[
           "paclet:guide/ComputationalSystemsAndDiscovery"], "Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Rules" :> Documentation`HelpLookup["paclet:guide/Rules"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computational Systems & Discovery\"\>", 
       2->"\<\"Core Language\"\>", 3->"\<\"Rules\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "ReplaceAll ",
 StyleBox["(/.)", "OperatorCharacter"]
}], "ObjectName",
 CellID->1279],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], "/.", 
       StyleBox["rules", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]applies a rule or list of rules in an attempt to \
transform each subpart of an expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1895]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 " looks at each part of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", tries all the ",
 Cell[BoxData[
  StyleBox["rules", "TI"]], "InlineFormula"],
 " on it, and then goes on to the next part of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". The first rule that applies to a particular part is used; no further \
rules are tried on that part, or on any of its subparts. "
}], "Notes",
 CellID->3097],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 " applies a particular rule only once to an expression. "
}], "Notes",
 CellID->27319],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "/.", 
   StyleBox["rules", "TI"]}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " if none of the rules apply. "
}], "Notes",
 CellID->6000]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->367562880],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->14560753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "2"}], ",", "y", ",", "z"}], "}"}], "/.", 
  RowBox[{"x", "->", "a"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1440],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   SuperscriptBox["a", "2"], ",", "y", ",", "z"}], "}"}]], "Output",
 ImageSize->{86, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24493]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "2"}], ",", "y", ",", "z"}], "}"}], "/.", 
  RowBox[{"x", "->", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21415],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["a", "2"], ",", 
     SuperscriptBox["b", "2"]}], "}"}], ",", "y", ",", "z"}], "}"}]], "Output",\

 ImageSize->{155, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1607]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "x", "]"}], "/.", 
  RowBox[{"Sin", "->", "Cos"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17389],

Cell[BoxData[
 RowBox[{"Cos", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->18142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", " ", "+", " ", 
   RowBox[{"x", "^", "2"}], " ", "+", " ", 
   RowBox[{"x", "^", "4"}]}], " ", "/.", " ", 
  RowBox[{
   RowBox[{"x", "^", "p_"}], " ", "->", " ", 
   RowBox[{"f", "[", "p", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17745],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"f", "[", "2", "]"}], "+", 
  RowBox[{"f", "[", "4", "]"}]}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "->", "1"}], ",", 
    RowBox[{"x", "->", "3"}], ",", 
    RowBox[{"x", "->", "7"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27757],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14922]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "->", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", "->", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", "->", "7"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32620],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "7"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5704]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "/.", 
  RowBox[{"List", "->", "f"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9962],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31139]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "x", ",", "x"}], "}"}], "/.", 
  RowBox[{"x", ":>", 
   RowBox[{"RandomReal", "[", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27472],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.016364122467221742`", ",", "0.7276044424848305`", ",", 
   "0.4690222586215935`"}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->608906345]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18783],

Cell["Structurally insert into a held expression:", "ExampleText",
 CellID->124288298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hold", "[", 
   RowBox[{"x", "+", "x"}], "]"}], "/.", " ", 
  RowBox[{"x", "\[Rule]", "7"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19253],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"7", "+", "7"}], "]"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259397536]
}, Open  ]],

Cell["\<\
Do not evaluate the right-hand side of the rule before doing the replacement:\
\
\>", "ExampleText",
 CellID->727845470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hold", "[", 
   RowBox[{"x", "+", "x"}], "]"}], "/.", 
  RowBox[{"x", "\[RuleDelayed]", 
   RowBox[{"2", "^", "2"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8990701],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   SuperscriptBox["2", "2"], "+", 
   SuperscriptBox["2", "2"]}], "]"}]], "Output",
 ImageSize->{84, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->115256445]
}, Open  ]],

Cell["Evaluate before replacement:", "ExampleText",
 CellID->173025104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hold", "[", 
   RowBox[{"x", "+", "x"}], "]"}], "/.", 
  RowBox[{"x", "->", 
   RowBox[{"2", "^", "2"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->34757979],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"4", "+", "4"}], "]"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->36782435]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "/.", 
   RowBox[{"a", "\[Rule]", "b"}]}], "/.", 
  RowBox[{"b", "\[Rule]", "d"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", ",", "d", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4051]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "b"}], ",", 
    RowBox[{"b", "\[Rule]", "d"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13961],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16742]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"g", "[", "1", "]"}], ",", 
    RowBox[{"Hold", "[", 
     RowBox[{"g", "[", "1", "]"}], "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"g", "[", "n_", "]"}], "\[RuleDelayed]", 
   RowBox[{"n", "+", "1"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->916459848],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"Hold", "[", 
    RowBox[{"1", "+", "1"}], "]"}]}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110970108]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15044],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Replace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Replace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rule",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rule"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceRepeated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceRepeated"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransformationFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TransformationFunctions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->515824267]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19319],

Cell[TextData[ButtonBox["Applying Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingTransformationRules"]], "Tutorials",
 CellID->1273]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->266901268],

Cell[TextData[ButtonBox["Computational Systems & Discovery",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalSystemsAndDiscovery"]], "MoreAbout",
 CellID->458704572],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->190842923],

Cell[TextData[ButtonBox["Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Rules"]], "MoreAbout",
 CellID->772695279]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReplaceAll (/.) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 26.3479294}", "context" -> "System`", 
    "keywords" -> {
     "controlled transformations", "evaluation at a point", "replacement", 
      "rules", "slash-dot", "substitution", "temporary binding"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "expr /. rules applies a rule or list of rules in an attempt to transform \
each subpart of an expression expr. ", "synonyms" -> {"replace all", "/."}, 
    "title" -> "ReplaceAll", "type" -> "Symbol", "uri" -> "ref/ReplaceAll"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5592, 176, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->367562880]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19229, 734}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2698, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3321, 88, 103, 4, 70, "ObjectName",
 CellID->1279],
Cell[3427, 94, 542, 17, 70, "Usage",
 CellID->1895]
}, Open  ]],
Cell[CellGroupData[{
Cell[4006, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4484, 133, 580, 17, 70, "Notes",
 CellID->3097],
Cell[5067, 152, 226, 7, 70, "Notes",
 CellID->27319],
Cell[5296, 161, 259, 10, 70, "Notes",
 CellID->6000]
}, Closed]],
Cell[CellGroupData[{
Cell[5592, 176, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->367562880],
Cell[CellGroupData[{
Cell[5977, 190, 147, 5, 70, "ExampleSection",
 CellID->14560753],
Cell[CellGroupData[{
Cell[6149, 199, 204, 7, 28, "Input",
 CellID->1440],
Cell[6356, 208, 244, 8, 39, "Output",
 CellID->24493]
}, Open  ]],
Cell[CellGroupData[{
Cell[6637, 221, 254, 9, 28, "Input",
 CellID->21415],
Cell[6894, 232, 373, 14, 39, "Output",
 CellID->1607]
}, Open  ]],
Cell[CellGroupData[{
Cell[7304, 251, 147, 5, 28, "Input",
 CellID->17389],
Cell[7454, 258, 183, 6, 36, "Output",
 CellID->18142]
}, Open  ]],
Cell[7652, 267, 120, 3, 70, "ExampleDelimiter",
 CellID->5393],
Cell[CellGroupData[{
Cell[7797, 274, 288, 9, 70, "Input",
 CellID->17745],
Cell[8088, 285, 242, 8, 36, "Output",
 CellID->17459]
}, Open  ]],
Cell[8345, 296, 121, 3, 70, "ExampleDelimiter",
 CellID->14363],
Cell[CellGroupData[{
Cell[8491, 303, 224, 8, 70, "Input",
 CellID->27757],
Cell[8718, 313, 154, 5, 36, "Output",
 CellID->14922]
}, Open  ]],
Cell[CellGroupData[{
Cell[8909, 323, 302, 11, 70, "Input",
 CellID->32620],
Cell[9214, 336, 208, 7, 36, "Output",
 CellID->5704]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9471, 349, 239, 7, 70, "ExampleSection",
 CellID->26801],
Cell[CellGroupData[{
Cell[9735, 360, 172, 6, 70, "Input",
 CellID->9962],
Cell[9910, 368, 214, 7, 36, "Output",
 CellID->31139]
}, Open  ]],
Cell[10139, 378, 121, 3, 70, "ExampleDelimiter",
 CellID->14908],
Cell[CellGroupData[{
Cell[10285, 385, 203, 7, 70, "Input",
 CellID->27472],
Cell[10491, 394, 277, 9, 36, "Output",
 CellID->608906345]
}, Open  ]],
Cell[10783, 406, 121, 3, 70, "ExampleDelimiter",
 CellID->18783],
Cell[10907, 411, 86, 1, 70, "ExampleText",
 CellID->124288298],
Cell[CellGroupData[{
Cell[11018, 416, 178, 6, 70, "Input",
 CellID->19253],
Cell[11199, 424, 211, 7, 36, "Output",
 CellID->259397536]
}, Open  ]],
Cell[11425, 434, 130, 4, 70, "ExampleText",
 CellID->727845470],
Cell[CellGroupData[{
Cell[11580, 442, 206, 7, 70, "Input",
 CellID->8990701],
Cell[11789, 451, 261, 9, 39, "Output",
 CellID->115256445]
}, Open  ]],
Cell[12065, 463, 71, 1, 70, "ExampleText",
 CellID->173025104],
Cell[CellGroupData[{
Cell[12161, 468, 195, 7, 70, "Input",
 CellID->34757979],
Cell[12359, 477, 210, 7, 36, "Output",
 CellID->36782435]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12618, 490, 233, 7, 70, "ExampleSection",
 CellID->23841],
Cell[CellGroupData[{
Cell[12876, 501, 231, 8, 70, "Input",
 CellID->14097],
Cell[13110, 511, 208, 7, 36, "Output",
 CellID->4051]
}, Open  ]],
Cell[CellGroupData[{
Cell[13355, 523, 255, 9, 70, "Input",
 CellID->13961],
Cell[13613, 534, 209, 7, 36, "Output",
 CellID->16742]
}, Open  ]],
Cell[13837, 544, 121, 3, 70, "ExampleDelimiter",
 CellID->11783],
Cell[CellGroupData[{
Cell[13983, 551, 324, 11, 70, "Input",
 CellID->916459848],
Cell[14310, 564, 261, 9, 36, "Output",
 CellID->110970108]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14632, 580, 311, 9, 70, "SeeAlsoSection",
 CellID->15044],
Cell[14946, 591, 1706, 62, 70, "SeeAlso",
 CellID->515824267]
}, Open  ]],
Cell[CellGroupData[{
Cell[16689, 658, 314, 9, 70, "TutorialsSection",
 CellID->19319],
Cell[17006, 669, 166, 3, 70, "Tutorials",
 CellID->1273]
}, Open  ]],
Cell[CellGroupData[{
Cell[17209, 677, 319, 9, 70, "MoreAboutSection",
 CellID->266901268],
Cell[17531, 688, 177, 3, 70, "MoreAbout",
 CellID->458704572],
Cell[17711, 693, 145, 3, 70, "MoreAbout",
 CellID->190842923],
Cell[17859, 698, 122, 3, 70, "MoreAbout",
 CellID->772695279]
}, Open  ]],
Cell[17996, 704, 27, 0, 70, "History"],
Cell[18026, 706, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

