(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     87075,       3089]
NotebookOptionsPosition[     72039,       2555]
NotebookOutlinePosition[     73829,       2599]
CellTagsIndexPosition[     73743,       2594]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Adding, Removing and Modifying List Elements" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AddingRemovingAndModifyingListElements"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/PartsOfExpressions"], 
          "Manipulating Lists by Their Indices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsByTheirIndices"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Adding, Removing and Modifying List Elements\"\>", 
       2->"\<\"Parts of Expressions\"\>", 
       3->"\<\"Manipulating Lists by Their Indices\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Part" :> Documentation`HelpLookup["paclet:ref/Part"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"], "Extract" :> 
          Documentation`HelpLookup["paclet:ref/Extract"], "MapAt" :> 
          Documentation`HelpLookup["paclet:ref/MapAt"], "FlattenAt" :> 
          Documentation`HelpLookup["paclet:ref/FlattenAt"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"], "Insert" :> 
          Documentation`HelpLookup["paclet:ref/Insert"], "Delete" :> 
          Documentation`HelpLookup["paclet:ref/Delete"], "Sequence" :> 
          Documentation`HelpLookup["paclet:ref/Sequence"], 
          "StringReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/StringReplacePart"], "BitSet" :> 
          Documentation`HelpLookup["paclet:ref/BitSet"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Part\"\>", 2->"\<\"Set\"\>", 
       3->"\<\"Extract\"\>", 4->"\<\"MapAt\"\>", 5->"\<\"FlattenAt\"\>", 
       6->"\<\"SparseArray\"\>", 7->"\<\"Insert\"\>", 8->"\<\"Delete\"\>", 
       9->"\<\"Sequence\"\>", 10->"\<\"StringReplacePart\"\>", 
       11->"\<\"BitSet\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"], 
          "Pattern Matching Functions" :> 
          Documentation`HelpLookup["paclet:guide/PatternMatchingFunctions"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ListManipulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Elements of Lists\"\>", 2->"\<\"Expressions\"\>",
        3->"\<\"Handling Arrays of Data\"\>", 4->"\<\"List Manipulation\"\>", 
       5->"\<\"Parts of Expressions\"\>", 6->"\<\"Parts of Matrices\"\>", 
       7->"\<\"Pattern Matching Functions\"\>", 
       8->"\<\"Rearranging & Restructuring Lists\"\>", 
       9->"\<\"Structural Operations on Expressions\"\>", 
       10->"\<\"New in 6.0: Core Language\"\>", 
       11->"\<\"New in 6.0: List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ReplacePart", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReplacePart",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReplacePart"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["i", "TI"], "->", 
         StyleBox["new", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields an expression in which the ",
     Cell[BoxData[
      StyleBox[
       RowBox[{
        StyleBox["i", "TI"], "\[Null]"}]]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " part of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is replaced by ",
     Cell[BoxData[
      StyleBox["new", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReplacePart",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReplacePart"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["i", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["new", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["i", "TI"], 
            StyleBox["2", "TR"]], "->", 
           SubscriptBox[
            StyleBox["new", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]replaces parts at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["new", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReplacePart",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReplacePart"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           StyleBox["i", "TI"], ",", 
           StyleBox["j", "TI"], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
         StyleBox["new", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces the part at position ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ".\n ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReplacePart",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReplacePart"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["i", "TI"], 
              StyleBox["1", "TR"]], ",", 
             SubscriptBox[
              StyleBox["j", "TI"], 
              StyleBox["1", "TR"]], ",", 
             StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
           SubscriptBox[
            StyleBox["new", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces parts at positions ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["n", "TI"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["n", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["new", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReplacePart",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReplacePart"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["i", "TI"], 
              StyleBox["1", "TR"]], ",", 
             SubscriptBox[
              StyleBox["j", "TI"], 
              StyleBox["1", "TR"]], ",", 
             StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
         StyleBox["new", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces all parts at positions ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["n", "TI"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["n", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["new", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->2517]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Explicit negative part numbers count from the end. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->27221,
  ButtonNote->"27221"]
}], "Notes",
 CellID->20568],

Cell["Part position specifications can be patterns. ", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6713],

Cell[TextData[{
 "Each pattern is effectively tested against each list of part numbers for \
parts in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->30598],

Cell[TextData[{
 "Patterns ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " (such as ",
 Cell[BoxData["x_"], "InlineFormula"],
 ") that are not explicitly lists are treated as ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["p", "TI"], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->13636],

Cell["\<\
Patterns can include constructs such as __, representing position \
specifications of variable lengths.\
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->10191],

Cell[TextData[{
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     StyleBox["i", "TI"], ":>", 
     StyleBox["new", "TI"]}]}], "]"}]], "InlineFormula"],
 " can be used to replace a part without first evaluating it. With a rule \
such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["patt", "TI"], ":>", 
   StyleBox["new", "TI"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["new", "TI"]], "InlineFormula"],
 " is evaluated separately for each position that matches ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->1741],

Cell[TextData[{
 "With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", a head is replaced only when the corresponding position specification is \
explicitly ",
 Cell[BoxData["0"], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->22564],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " a head is replaced whenever the corresponding position specification \
matches ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8853],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " never replaces heads. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->11156],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->11413]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->349088176],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->567063682],

Cell["Replace part 3:", "ExampleText",
 CellID->13512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"3", "->", "xxx"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11107],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "xxx", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8775]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3376],

Cell["Replace parts 2 and 5:", "ExampleText",
 CellID->32426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "->", "xx"}], ",", 
     RowBox[{"5", "->", "yy"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28875],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "xx", ",", "c", ",", "d", ",", "yy"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15477],

Cell[TextData[{
 "Replace part ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], TraditionalForm]], "InlineMath"],
 " of an array:"
}], "ExampleText",
 CellID->26441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], "->", "xx"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"xx", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24361]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8896],

Cell["Replace parts whose positions match a pattern:", "ExampleText",
 CellID->24021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i_", ",", "i_"}], "}"}], "->", "xx"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26171],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xx", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "xx"}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32395]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17862],

Cell["Replace parts in any expression:", "ExampleText",
 CellID->4482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"a", "+", "b", "+", 
    RowBox[{"c", "^", "n"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], "->", 
      RowBox[{"x", "+", "y"}]}], ",", 
     RowBox[{"2", "->", 
      RowBox[{"b", "^", "100"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5176],

Cell[BoxData[
 RowBox[{"a", "+", 
  SuperscriptBox["b", "100"], "+", 
  SuperscriptBox["c", 
   RowBox[{"x", "+", "y"}]]}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15305]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22317],

Cell["Replace a part 3 from the end:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->27221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"-", "3"}], "->", "xxx"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "xxx", ",", "f", ",", "g"}],
   "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4288]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4675],

Cell["Replace several parts by the same expression:", "ExampleText",
 CellID->14178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "3", "}"}], ",", 
      RowBox[{"{", "5", "}"}]}], "}"}], "->", "xxx"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->639],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "xxx", ",", "b", ",", "xxx", ",", "d", ",", "xxx", ",", "f", ",", "g"}], 
  "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2920]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9439],

Cell["Part specifications can be patterns:", "ExampleText",
 CellID->8985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "|", "3", "|", "5"}], ")"}], "->", "xxx"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21242],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "xxx", ",", "b", ",", "xxx", ",", "d", ",", "xxx", ",", "f", ",", "g"}], 
  "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25687]
}, Open  ]],

Cell["Replace every part except those with indices 1, 3 or 5:", "ExampleText",
 CellID->11058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"Except", "[", 
     RowBox[{"1", "|", "3", "|", "5"}], "]"}], "->", "xxx"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3063],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "xxx", ",", "c", ",", "xxx", ",", "e", ",", "xxx", ",", "xxx"}], 
  "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5915]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17671],

Cell["Replace every part whose index is even:", "ExampleText",
 CellID->1576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"_", "?", "EvenQ"}], "->", "xxx"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "xxx", ",", "c", ",", "xxx", ",", "e", ",", "xxx", ",", "g"}], 
  "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1733]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28259],

Cell["Replace all elements in the first sublist:", "ExampleText",
 CellID->31048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", "f", "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "_"}], "}"}], "->", "xx"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18314],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xx", ",", "xx", ",", "xx"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", "f", "}"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13151]
}, Open  ]],

Cell["Replace the last element in each sublist:", "ExampleText",
 CellID->16836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", "f", "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", 
      RowBox[{"-", "1"}]}], "}"}], "->", "xx"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24541],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "xx"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "xx"}], "}"}], ",", 
   RowBox[{"{", "xx", "}"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11500]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1564],

Cell["Replace elements on the diagonal:", "ExampleText",
 CellID->22046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i_", ",", "i_"}], "}"}], "->", "x"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15699],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "x", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1077]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29568],

Cell["\<\
Part specification patterns can contain variables that are used in the \
replacements:\
\>", "ExampleText",
 CellID->28028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i_", ",", "i_"}], "}"}], "->", 
    RowBox[{"f", "[", "i", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11491],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "1", "]"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"f", "[", "2", "]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"f", "[", "3", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2080],

Cell["Patterns can represent part lists of variable length: ", "ExampleText",
 CellID->24233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"___", ",", "2", ",", "___"}], "}"}], "->", "x"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29811],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "x", ",", "0"}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "x", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30484]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", "f", "}"}]}], "}"}], ",", 
   RowBox[{"i__", "->", 
    RowBox[{"s", "[", "i", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12969],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"s", "[", "1", "]"}], ",", 
   RowBox[{"s", "[", "2", "]"}], ",", 
   RowBox[{"s", "[", "3", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18224]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16055],

Cell["\<\
The right-hand side of the rule is evaluated separately for each replacement \
done:\
\>", "ExampleText",
 CellID->22520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i_", ",", "i_"}], "}"}], ":>", 
    RowBox[{"RandomReal", "[", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28451],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.5198794058065732`", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "0.3193076401784234`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{206, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6535]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16541],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->14024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"5", "->", "a"}], ",", "10"}], "]"}], ",", 
   RowBox[{"7", "->", "b"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14199],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "10", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23432]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19944],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "a", ",", "0", ",", "b", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10307]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23855],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 " works on heads:"
}], "ExampleText",
 CellID->10528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"0", "->", "g"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8474],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4597]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "g", "]"}], "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], "->", "hh"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12414],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "hh", "]"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20299]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23192],

Cell[TextData[{
 "Replace all heads by ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->15555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"y", "^", "2"}], "+", " ", 
    RowBox[{"c", " ", 
     RowBox[{"z", "^", "2"}]}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"___", ",", "0"}], "}"}], "->", "List"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6272],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "2"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4928]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31497],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Heads",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->30148],

Cell["Replace all ordinary parts, but not heads:", "ExampleText",
 CellID->194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"_", "->", "g"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31208],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", ",", "g"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23807]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12626],

Cell["Also replace heads:", "ExampleText",
 CellID->16389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"_", "->", "g"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9109],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"g", ",", "g"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29145]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25697],

Cell["Never replace heads:", "ExampleText",
 CellID->23615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"0", "->", "g"}], ",", 
   RowBox[{"Heads", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4081],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17896]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2064],

Cell["Border a matrix with x's:", "ExampleText",
 CellID->20451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplacePart", "[", 
   RowBox[{
    RowBox[{"IdentityMatrix", "[", "5", "]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"_", ",", 
       RowBox[{"1", "|", "5"}]}], "}"}], "->", "x"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24117],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\:f3a2", GridBox[{
     {"x", "0", "0", "0", "x"},
     {"x", "1", "0", "0", "x"},
     {"x", "0", "1", "0", "x"},
     {"x", "0", "0", "1", "x"},
     {"x", "0", "0", "0", "x"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
      "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->4048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31614],

Cell["Highlight two squares in an array:", "ExampleText",
 CellID->13410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"ReplacePart", "[", 
   RowBox[{
    RowBox[{"Array", "[", 
     RowBox[{"GCD", ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "15"}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "12"}], "}"}]}], "}"}], "->", "Red"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23963],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmVmYGDgh2IQ+95dEHhrTyw9ayYIvMSgcakPBYOnGDSp5pDqHlz2
UstfuGgGHACX+j27QeA1Bk1r9YJg8BCDHij34FIPcddGDJrUeBmlkcPzIAZN
LfNxxS+u/FUOBs8xaFzmG4PBYwwal3pc5uNyD6npE5K7P2Dke2qFz0Cnl4FJ
nxcx6IFyD7XKN1z1Ea3LT4g9VzHogfIvqeFP63YCeebcxKCHir9IjV9Sy2dS
zYfQd3HQQ8X9g4fG1a4baHfRyp2k1qeDrX4n1T2ktn8GW3uDWvXCcLV3sJVv
Q918UunB2d4YuuYMtvGEoa5+lKYPDQA4ree7
   "], {{0, 0}, {15, 15}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{118, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{114., Automatic}},
 CellLabel->"Out[1]=",
 CellID->20273]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14303],

Cell["\<\
Generate a difference pattern for two cellular automaton initial conditions \
differing by one bit:\
\>", "ExampleText",
 CellID->30194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", "=", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"1", ",", "100"}], "]"}]}], "}"}], ",", 
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", "i"}], " ", 
       RowBox[{"CellularAutomaton", "[", 
        RowBox[{"30", ",", 
         RowBox[{"ReplacePart", "[", 
          RowBox[{"u", ",", 
           RowBox[{"50", "->", "i"}]}], "]"}], ",", "50"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->533],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy1l8txwzAMRIF0khrSSUrw+J7+b/GQ3MUynwu5kC2PLI/wiM8C9Pvj6/Px
FhEfr/P5OvPoGM+Np8c7xjG+jJ8ixjun9TPGtFOG1uUyuYhYxqEbw7IYygXS
BcC1G8Q0lCtU627Q+vLvGJEpq5yY9RErhAHyOQLGVw4QsMRNxu4KkcGAcdlY
edFuEJmVV16i0lBmtwiRAYxqbQVDeI1AYCoLLN8LXQgkUVkUIqrtTheKyIo9
XlT+lS4EEvQgWMOlPwtCVI7eFVUHBsQmc6ajGozDi03J0swL50JU99b+5El3
bsLeupRDegVJrl5TYipaIopD06aiBSQ4DBP9yeoFe3u1E2rcRqgJBFHbpFcQ
FZ54Y0Xovqp2IkZE9RDUkU/dipBguXUBiHb0TL8X2qsSiXAjakDFlhUvgkPJ
Nrt/EjCuw7XJ+QsiCjG3wWJwp9aGKKuYrS0QtsBmhHmw/oLU0YbQwdEHkT17
G4TdqhPi26r9j2isqEnoR+DvXy+iPd3tRTsZ/V70I/or6gzxDT4JE6c=
   "], {{0, 0}, {100, 51}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16007]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2767],

Cell["Insert a black cell at a random position at each step:", "ExampleText",
 CellID->29838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ReplacePart", "[", 
       RowBox[{"#", ",", 
        RowBox[{
         RowBox[{"RandomInteger", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "30"}], "}"}], "]"}], "->", "1"}]}], "]"}], 
      "&"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", "30", "}"}]}], "]"}], ",", "20"}], "]"}], ",", 
   RowBox[{"Mesh", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4415],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{166, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{166., Automatic}},
 CellLabel->"Out[1]=",
 CellID->210773538]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19173],

Cell["Successively replace parts of a list:", "ExampleText",
 CellID->13886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ReplacePart", "[", 
     RowBox[{"#1", ",", 
      RowBox[{"#2", "->", "x"}]}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2", ",", "3", ",", "1", ",", "4"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "c", ",", "d", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "x", ",", "d", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "d", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{322, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14988],

Cell["Successively replace disks in a graphic by circles:", "ExampleText",
 CellID->3736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Disk", "[", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"5", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", "5", "}"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"ImageSize", "->", "Tiny"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5595],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.5], DiskBox[{3.0022, 1.6284}], DiskBox[{1.0485, 0.91316}], 
   DiskBox[{4.9334, 1.3723}], DiskBox[{0.34688, 3.8064}], 
   DiskBox[{1.6953, 3.16}]},
  ImageMargins->0.]], "Output",
 ImageSize->{104, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->Tiny},
 CellLabel->"Out[1]=",
 CellID->10952]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"g", ",", "Disk"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "5", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{441, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24455]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ReplacePart", "[", 
     RowBox[{"#1", ",", 
      RowBox[{"#2", "->", "Circle"}]}], "]"}], "&"}], ",", "g", ",", "%"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->9964],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {GrayLevel[0.5], DiskBox[{3.0022, 1.6284}], DiskBox[{1.0485, 0.91316}], 
     DiskBox[{4.9334, 1.3723}], DiskBox[{0.34688, 3.8064}], 
     DiskBox[{1.6953, 3.16}]},
    ImageSize->Tiny], ",", 
   GraphicsBox[
    {GrayLevel[0.5], CircleBox[{3.0022, 1.6284}], DiskBox[{1.0485, 0.91316}], 
     DiskBox[{4.9334, 1.3723}], DiskBox[{0.34688, 3.8064}], 
     DiskBox[{1.6953, 3.16}]},
    ImageSize->Tiny], ",", 
   GraphicsBox[
    {GrayLevel[0.5], CircleBox[{3.0022, 1.6284}], 
     CircleBox[{1.0485, 0.91316}], DiskBox[{4.9334, 1.3723}], 
     DiskBox[{0.34688, 3.8064}], DiskBox[{1.6953, 3.16}]},
    ImageSize->Tiny], ",", 
   GraphicsBox[
    {GrayLevel[0.5], CircleBox[{3.0022, 1.6284}], 
     CircleBox[{1.0485, 0.91316}], CircleBox[{4.9334, 1.3723}], 
     DiskBox[{0.34688, 3.8064}], DiskBox[{1.6953, 3.16}]},
    ImageSize->Tiny], ",", 
   GraphicsBox[
    {GrayLevel[0.5], CircleBox[{3.0022, 1.6284}], 
     CircleBox[{1.0485, 0.91316}], CircleBox[{4.9334, 1.3723}], 
     CircleBox[{0.34688, 3.8064}], DiskBox[{1.6953, 3.16}]},
    ImageSize->Tiny], ",", 
   GraphicsBox[
    {GrayLevel[0.5], CircleBox[{3.0022, 1.6284}], 
     CircleBox[{1.0485, 0.91316}], CircleBox[{4.9334, 1.3723}], 
     CircleBox[{0.34688, 3.8064}], CircleBox[{1.6953, 3.16}]},
    ImageSize->Tiny]}], "}"}]], "Output",
 ImageSize->{341, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->288627194],

Cell["Successively replace entries in a 2D array:", "ExampleText",
 CellID->65527882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Mesh", "\[Rule]", "True"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], "&"}], "/@", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ReplacePart", "[", 
      RowBox[{"#", ",", 
       RowBox[{
        RowBox[{"RandomInteger", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "5"}], "}"}], ",", 
          RowBox[{"{", "2", "}"}]}], "]"}], "\[Rule]", "1"}]}], "]"}], "&"}], 
    ",", 
    RowBox[{"ConstantArray", "[", 
     RowBox[{"0", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5"}], "}"}]}], "]"}], ",", "10"}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->329835308],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztne1O2zAUQJ2mpezz937yCHsEtmnbrz1EhSbBpGlT4Xn6qiYfqFRuE9vX
1yahB4k2xum9js+pQ0xqfm0ebn//3Tzc3Wyufm43/2/vbu6vfvzbNj+qK2Oq
rTHmzyfTbNtmq/tuv+6b736z37psHj/vdrsPzvPHgZ9f7l9l6qbYxbTmwimv
E+vfRe4vjm/6r3X7kBDPLb934l8kxnfr3fa78VP7KzV+UH4s8pSxCIuwCIui
4mNRlvhYJO4VLMIiLMIiaXwsyhIfi8S9gkUCizLOMgnbHuxeofg+Nwfd8+0v
dN9tf2z/546vPIJh0fj+WIRFWIRFWIRFWIRFypSxaAYWLfty/4qVxSM8EvFd
7cu2t2lpcQmXcAmXpupSzPxl3cU2T/fcWbPYR4k5wqD6oxa/iYxaJktQK46y
vNVou1u/fC77M4h6TzVDljEvpn55mGthjrOoGJacJagVR1lcj1UMOyiH5Ejt
P40cL27Z4fF05efRU7u/tPPFtsfNp308Xb13xFbpVfUsU/OwfW+5++XwT5JH
4t2pkVX5rBqYJfHMqpQldmyobAnzit0VodRe8bWFMH/w7/7C/KnxffXt9UHV
SNXahFEh+TFqvJ5xSpIfq07Uv9BvW7h0Xi5lnE+LnbEcmCEcNCZ2xlIpfuwM
86CRvvhu/UB/Dhrj6/9C8ddO/C5f7OiGS7iES7iES7iES7iES7iESzKXYu4e
xCM8GvLI3R+LsAiLsGgyFil+1jnWvYF6NfeU4qvNrgvjB89+x7DPGD+ov7DI
U8YiLMIiLMoRH4uwCIuwKIQyFmERFmHRaJZClLForhbFzzK1Adz/ABG6FZrx
+37vFMvEFo71Wsb4apYr9Vfuu0W/WShDWafXoAxlKEM5R3woa7QaylCGMpRL
xD9fyjO8uhbOYbC22aze+VAe3x/KUIYylKHsif86KLefgGrXnlok0oT2HGif
XHsC6lCHOtQT66E+VerhczFFnGGV79hWFF7l+6st5gLrcSe0otR63F9sMR8O
Mzv5tI9MO19se17zytm9Me4R1hpH5OlR1riOPqcEZkk8rzxlubadIXX/1D6u
NI5mpJ6/CY7Xl/mbYOmxAOpToD7Za9BC8aFuoX7G1Cc28zAFZ4SzX8HOxMYf
mM0Sry8TuP+ZjRRQ7+qhLskPdVUqgb0OdahDXUZ9cneVQDsj7cncKQZlKEMZ
ylAOoDzDT+gUin+e83dQhjKUoZyDApShDGUoa7QXyiUoQBnKUJZTDr+6bl/o
rk9pqkfBVQhb\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{370, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166385923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174000128],

Cell["Replace elements whose indices are not relatively prime:", "ExampleText",
 CellID->451143844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "y_"}], "}"}], "/;", 
     RowBox[{"CoprimeQ", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "\[Rule]", 
    RowBox[{"x", "+", "y"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36926101],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "5", ",", "0", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "0", ",", "7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0", ",", "7", ",", "0", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7", ",", "8", ",", "9", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->438707225]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22347],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 " uses rules in the order given:"
}], "ExampleText",
 CellID->32146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "->", "u"}], ",", 
     RowBox[{"_", "->", "x"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4792],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", "u", ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19080]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20417],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 " takes lists of positions in the same form as generated by ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "x", ",", "c", ",", "d", ",", "x", ",", "e"}],
     "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "6", "}"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11714]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "x", ",", "c", ",", "d", ",", "x", ",", "e"}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "3", "}"}], ",", 
      RowBox[{"{", "6", "}"}]}], "}"}], "->", "yy"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13029],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "yy", ",", "c", ",", "d", ",", "yy", ",", "e"}],
   "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5965],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 " takes the same part rules as ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "x"}], ",", 
      RowBox[{"5", "->", "y"}]}], "}"}], ",", "10"}], "]"}], "//", 
  "Normal"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2197],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "0", ",", "0", ",", "0", ",", "y", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29353]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{"0", "&"}], ",", "10"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "->", "x"}], ",", 
     RowBox[{"5", "->", "y"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "0", ",", "0", ",", "0", ",", "y", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14016]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4504],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 " only affects parts that are already present:"
}], "ExampleText",
 CellID->29063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"5", "->", "x"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1866],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20605]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5086],

Cell[TextData[{
 "Particularly in an ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 " function, the order of parts may change when they are replaced:"
}], "ExampleText",
 CellID->29054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"ReplacePart", "[", 
    RowBox[{
     RowBox[{"a", "+", "b", "+", "c"}], ",", 
     RowBox[{"1", "->", "x"}]}], "]"}], ",", 
   RowBox[{"3", "->", "y"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4931],

Cell[BoxData[
 RowBox[{"b", "+", "c", "+", "y"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10294]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26799],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Extract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extract"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FlattenAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FlattenAt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Insert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Insert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Delete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Delete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitSet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitSet"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13334]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5829],

Cell[TextData[ButtonBox["Adding, Removing and Modifying List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AddingRemovingAndModifyingListElements"]], "Tutorials",
 CellID->3338],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartsOfExpressions"]], "Tutorials",
 CellID->22130],

Cell[TextData[ButtonBox["Manipulating Lists by Their Indices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsByTheirIndices"]], "Tutorials",\

 CellID->21890]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->115522000],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->443327267],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->375970351],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->218002137],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->148647199],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->247821941],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->203624707],

Cell[TextData[ButtonBox["Pattern Matching Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PatternMatchingFunctions"]], "MoreAbout",
 CellID->35268786],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->4978273],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->212903860],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->260560181],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->27229792]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ReplacePart"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReplacePart - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 28.2229774}", "context" -> "System`", 
    "keywords" -> {
     "changing parts", "expressions", "lists", "multiple parts", "parts", 
      "replacements", "unevaluated expressions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ReplacePart[expr, i -> new] yields an expression in which the \
i\\[Null]\\[Null]^th part of expr is replaced by new. ReplacePart[expr, {i_1 \
-> new_1, i_2 -> new_2, ...}] replaces parts at positions i_n by new_n. \
ReplacePart[expr, {i, j, ...} -> new] replaces the part at position {i, j, \
...}. ReplacePart[expr, {{i_1, j_1, ...} -> new_1, ...}] replaces parts at \
positions {i_n, j_n, ...} by new_n. ReplacePart[expr, {{i_1, j_1, ...}, ...} \
-> new] replaces all parts at positions {i_n, j_n, ...} by new. ", 
    "synonyms" -> {"replace part"}, "title" -> "ReplacePart", "type" -> 
    "Symbol", "uri" -> "ref/ReplacePart"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[19623, 560, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->349088176]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 73599, 2587}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4785, 97, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5408, 124, 4195, 83, 70, "ObjectNameGrid"],
Cell[9606, 209, 5295, 172, 70, "Usage",
 CellID->2517]
}, Open  ]],
Cell[CellGroupData[{
Cell[14938, 386, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[15416, 403, 205, 7, 70, "Notes",
 CellID->20568],
Cell[15624, 412, 208, 4, 70, "Notes",
 CellID->6713],
Cell[15835, 418, 329, 10, 70, "Notes",
 CellID->30598],
Cell[16167, 430, 437, 15, 70, "Notes",
 CellID->13636],
Cell[16607, 447, 274, 7, 70, "Notes",
 CellID->10191],
Cell[16884, 456, 841, 29, 70, "Notes",
 CellID->1741],
Cell[17728, 487, 573, 18, 70, "Notes",
 CellID->22564],
Cell[18304, 507, 528, 18, 70, "Notes",
 CellID->8853],
Cell[18835, 527, 419, 14, 70, "Notes",
 CellID->11156],
Cell[19257, 543, 329, 12, 70, "Notes",
 CellID->11413]
}, Closed]],
Cell[CellGroupData[{
Cell[19623, 560, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->349088176],
Cell[CellGroupData[{
Cell[20008, 574, 148, 5, 70, "ExampleSection",
 CellID->567063682],
Cell[20159, 581, 54, 1, 70, "ExampleText",
 CellID->13512],
Cell[CellGroupData[{
Cell[20238, 586, 232, 7, 28, "Input",
 CellID->11107],
Cell[20473, 595, 231, 7, 36, "Output",
 CellID->8775]
}, Open  ]],
Cell[20719, 605, 120, 3, 70, "ExampleDelimiter",
 CellID->3376],
Cell[20842, 610, 61, 1, 70, "ExampleText",
 CellID->32426],
Cell[CellGroupData[{
Cell[20928, 615, 310, 10, 70, "Input",
 CellID->28875],
Cell[21241, 627, 232, 7, 36, "Output",
 CellID->28459]
}, Open  ]],
Cell[21488, 637, 121, 3, 70, "ExampleDelimiter",
 CellID->15477],
Cell[21612, 642, 198, 8, 70, "ExampleText",
 CellID->26441],
Cell[CellGroupData[{
Cell[21835, 654, 358, 13, 70, "Input",
 CellID->10983],
Cell[22196, 669, 299, 11, 36, "Output",
 CellID->24361]
}, Open  ]],
Cell[22510, 683, 120, 3, 70, "ExampleDelimiter",
 CellID->8896],
Cell[22633, 688, 85, 1, 70, "ExampleText",
 CellID->24021],
Cell[CellGroupData[{
Cell[22743, 693, 360, 13, 70, "Input",
 CellID->26171],
Cell[23106, 708, 300, 11, 36, "Output",
 CellID->32395]
}, Open  ]],
Cell[23421, 722, 121, 3, 70, "ExampleDelimiter",
 CellID->17862],
Cell[23545, 727, 70, 1, 70, "ExampleText",
 CellID->4482],
Cell[CellGroupData[{
Cell[23640, 732, 398, 14, 70, "Input",
 CellID->5176],
Cell[24041, 748, 260, 9, 36, "Output",
 CellID->15305]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24350, 763, 216, 7, 70, "ExampleSection",
 CellID->22317],
Cell[24569, 772, 117, 2, 70, "ExampleText",
 CellID->27221],
Cell[CellGroupData[{
Cell[24711, 778, 276, 9, 70, "Input",
 CellID->6734],
Cell[24990, 789, 254, 8, 36, "Output",
 CellID->4288]
}, Open  ]],
Cell[25259, 800, 120, 3, 70, "ExampleDelimiter",
 CellID->4675],
Cell[25382, 805, 84, 1, 70, "ExampleText",
 CellID->14178],
Cell[CellGroupData[{
Cell[25491, 810, 397, 13, 70, "Input",
 CellID->639],
Cell[25891, 825, 261, 9, 36, "Output",
 CellID->2920]
}, Open  ]],
Cell[26167, 837, 120, 3, 70, "ExampleDelimiter",
 CellID->9439],
Cell[26290, 842, 74, 1, 70, "ExampleText",
 CellID->8985],
Cell[CellGroupData[{
Cell[26389, 847, 321, 11, 70, "Input",
 CellID->21242],
Cell[26713, 860, 262, 9, 36, "Output",
 CellID->25687]
}, Open  ]],
Cell[26990, 872, 94, 1, 70, "ExampleText",
 CellID->11058],
Cell[CellGroupData[{
Cell[27109, 877, 330, 11, 70, "Input",
 CellID->3063],
Cell[27442, 890, 263, 9, 36, "Output",
 CellID->5915]
}, Open  ]],
Cell[27720, 902, 121, 3, 70, "ExampleDelimiter",
 CellID->17671],
Cell[27844, 907, 77, 1, 70, "ExampleText",
 CellID->1576],
Cell[CellGroupData[{
Cell[27946, 912, 286, 9, 70, "Input",
 CellID->30538],
Cell[28235, 923, 261, 9, 36, "Output",
 CellID->1733]
}, Open  ]],
Cell[28511, 935, 121, 3, 70, "ExampleDelimiter",
 CellID->28259],
Cell[28635, 940, 81, 1, 70, "ExampleText",
 CellID->31048],
Cell[CellGroupData[{
Cell[28741, 945, 404, 14, 70, "Input",
 CellID->18314],
Cell[29148, 961, 345, 12, 36, "Output",
 CellID->13151]
}, Open  ]],
Cell[29508, 976, 80, 1, 70, "ExampleText",
 CellID->16836],
Cell[CellGroupData[{
Cell[29613, 981, 426, 15, 70, "Input",
 CellID->24541],
Cell[30042, 998, 345, 12, 36, "Output",
 CellID->11500]
}, Open  ]],
Cell[30402, 1013, 120, 3, 70, "ExampleDelimiter",
 CellID->1564],
Cell[30525, 1018, 72, 1, 70, "ExampleText",
 CellID->22046],
Cell[CellGroupData[{
Cell[30622, 1023, 452, 15, 70, "Input",
 CellID->15699],
Cell[31077, 1040, 386, 13, 36, "Output",
 CellID->1077]
}, Open  ]],
Cell[31478, 1056, 121, 3, 70, "ExampleDelimiter",
 CellID->29568],
Cell[31602, 1061, 133, 4, 70, "ExampleText",
 CellID->28028],
Cell[CellGroupData[{
Cell[31760, 1069, 482, 16, 70, "Input",
 CellID->11491],
Cell[32245, 1087, 479, 16, 36, "Output",
 CellID->6092]
}, Open  ]],
Cell[32739, 1106, 120, 3, 70, "ExampleDelimiter",
 CellID->2080],
Cell[32862, 1111, 93, 1, 70, "ExampleText",
 CellID->24233],
Cell[CellGroupData[{
Cell[32980, 1116, 467, 16, 70, "Input",
 CellID->29811],
Cell[33450, 1134, 328, 11, 36, "Output",
 CellID->30484]
}, Open  ]],
Cell[CellGroupData[{
Cell[33815, 1150, 384, 13, 70, "Input",
 CellID->12969],
Cell[34202, 1165, 297, 10, 36, "Output",
 CellID->18224]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34548, 1181, 239, 7, 70, "ExampleSection",
 CellID->16055],
Cell[34790, 1190, 131, 4, 70, "ExampleText",
 CellID->22520],
Cell[CellGroupData[{
Cell[34946, 1198, 393, 14, 70, "Input",
 CellID->28451],
Cell[35342, 1214, 333, 11, 36, "Output",
 CellID->6535]
}, Open  ]],
Cell[35690, 1228, 121, 3, 70, "ExampleDelimiter",
 CellID->16541],
Cell[35814, 1233, 330, 12, 70, "ExampleText",
 CellID->14024],
Cell[CellGroupData[{
Cell[36169, 1249, 243, 8, 70, "Input",
 CellID->14199],
Cell[36415, 1259, 450, 16, 36, "Output",
 CellID->23432]
}, Open  ]],
Cell[CellGroupData[{
Cell[36902, 1280, 98, 3, 70, "Input",
 CellID->19944],
Cell[37003, 1285, 287, 9, 36, "Output",
 CellID->10307]
}, Open  ]],
Cell[37305, 1297, 121, 3, 70, "ExampleDelimiter",
 CellID->23855],
Cell[37429, 1302, 195, 7, 70, "ExampleText",
 CellID->10528],
Cell[CellGroupData[{
Cell[37649, 1313, 204, 7, 70, "Input",
 CellID->8474],
Cell[37856, 1322, 203, 7, 36, "Output",
 CellID->4597]
}, Open  ]],
Cell[CellGroupData[{
Cell[38096, 1334, 287, 10, 70, "Input",
 CellID->12414],
Cell[38386, 1346, 233, 8, 36, "Output",
 CellID->20299]
}, Open  ]],
Cell[38634, 1357, 121, 3, 70, "ExampleDelimiter",
 CellID->23192],
Cell[38758, 1362, 192, 8, 70, "ExampleText",
 CellID->15555],
Cell[CellGroupData[{
Cell[38975, 1374, 372, 13, 70, "Input",
 CellID->6272],
Cell[39350, 1389, 462, 17, 36, "Output",
 CellID->4928]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39861, 1412, 218, 7, 70, "ExampleSection",
 CellID->31497],
Cell[CellGroupData[{
Cell[40104, 1423, 222, 7, 70, "ExampleSubsection",
 CellID->30148],
Cell[40329, 1432, 79, 1, 70, "ExampleText",
 CellID->194],
Cell[CellGroupData[{
Cell[40433, 1437, 205, 7, 70, "Input",
 CellID->31208],
Cell[40641, 1446, 204, 7, 36, "Output",
 CellID->23807]
}, Open  ]],
Cell[40860, 1456, 121, 3, 70, "ExampleDelimiter",
 CellID->12626],
Cell[40984, 1461, 58, 1, 70, "ExampleText",
 CellID->16389],
Cell[CellGroupData[{
Cell[41067, 1466, 246, 8, 70, "Input",
 CellID->9109],
Cell[41316, 1476, 204, 7, 36, "Output",
 CellID->29145]
}, Open  ]],
Cell[41535, 1486, 121, 3, 70, "ExampleDelimiter",
 CellID->25697],
Cell[41659, 1491, 59, 1, 70, "ExampleText",
 CellID->23615],
Cell[CellGroupData[{
Cell[41743, 1496, 247, 8, 70, "Input",
 CellID->4081],
Cell[41993, 1506, 204, 7, 36, "Output",
 CellID->17896]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[42258, 1520, 222, 7, 70, "ExampleSection",
 CellID->2064],
Cell[42483, 1529, 64, 1, 70, "ExampleText",
 CellID->20451],
Cell[CellGroupData[{
Cell[42572, 1534, 313, 11, 70, "Input",
 CellID->24117],
Cell[42888, 1547, 715, 21, 108, "Output",
 CellID->4048]
}, Open  ]],
Cell[43618, 1571, 121, 3, 70, "ExampleDelimiter",
 CellID->31614],
Cell[43742, 1576, 73, 1, 70, "ExampleText",
 CellID->13410],
Cell[CellGroupData[{
Cell[43840, 1581, 482, 17, 70, "Input",
 CellID->23963],
Cell[44325, 1600, 694, 17, 135, "Output",
 CellID->20273]
}, Open  ]],
Cell[45034, 1620, 121, 3, 70, "ExampleDelimiter",
 CellID->14303],
Cell[45158, 1625, 146, 4, 70, "ExampleText",
 CellID->30194],
Cell[CellGroupData[{
Cell[45329, 1633, 710, 23, 70, "Input",
 CellID->533],
Cell[46042, 1658, 824, 18, 117, "Output",
 CellID->16007]
}, Open  ]],
Cell[46881, 1679, 120, 3, 70, "ExampleDelimiter",
 CellID->2767],
Cell[47004, 1684, 93, 1, 70, "ExampleText",
 CellID->29838],
Cell[CellGroupData[{
Cell[47122, 1689, 555, 18, 70, "Input",
 CellID->4415],
Cell[47680, 1709, 2417, 44, 70, "Output",
 Evaluatable->False,
 CellID->210773538]
}, Open  ]],
Cell[50112, 1756, 121, 3, 70, "ExampleDelimiter",
 CellID->19173],
Cell[50236, 1761, 76, 1, 70, "ExampleText",
 CellID->13886],
Cell[CellGroupData[{
Cell[50337, 1766, 408, 13, 70, "Input",
 CellID->7058],
Cell[50748, 1781, 716, 20, 54, "Output",
 CellID->3948]
}, Open  ]],
Cell[51479, 1804, 121, 3, 70, "ExampleDelimiter",
 CellID->14988],
Cell[51603, 1809, 89, 1, 70, "ExampleText",
 CellID->3736],
Cell[CellGroupData[{
Cell[51717, 1814, 442, 14, 70, "Input",
 CellID->5595],
Cell[52162, 1830, 389, 11, 96, "Output",
 CellID->10952]
}, Open  ]],
Cell[CellGroupData[{
Cell[52588, 1846, 125, 4, 70, "Input",
 CellID->3342],
Cell[52716, 1852, 575, 17, 36, "Output",
 CellID->24455]
}, Open  ]],
Cell[CellGroupData[{
Cell[53328, 1874, 255, 9, 70, "Input",
 CellID->9964],
Cell[53586, 1885, 1489, 37, 179, "Output",
 CellID->21566]
}, Open  ]],
Cell[55090, 1925, 125, 3, 70, "ExampleDelimiter",
 CellID->288627194],
Cell[55218, 1930, 85, 1, 70, "ExampleText",
 CellID->65527882],
Cell[CellGroupData[{
Cell[55328, 1935, 754, 25, 70, "Input",
 CellID->329835308],
Cell[56085, 1962, 1506, 29, 70, "Output",
 Evaluatable->False,
 CellID->166385923]
}, Open  ]],
Cell[57606, 1994, 125, 3, 70, "ExampleDelimiter",
 CellID->174000128],
Cell[57734, 1999, 99, 1, 70, "ExampleText",
 CellID->451143844],
Cell[CellGroupData[{
Cell[57858, 2004, 449, 15, 70, "Input",
 CellID->36926101],
Cell[58310, 2021, 632, 18, 36, "Output",
 CellID->438707225]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58991, 2045, 233, 7, 70, "ExampleSection",
 CellID->22347],
Cell[59227, 2054, 210, 7, 70, "ExampleText",
 CellID->32146],
Cell[CellGroupData[{
Cell[59462, 2065, 307, 10, 70, "Input",
 CellID->4792],
Cell[59772, 2077, 229, 7, 36, "Output",
 CellID->19080]
}, Open  ]],
Cell[60016, 2087, 121, 3, 70, "ExampleDelimiter",
 CellID->20417],
Cell[60140, 2092, 363, 12, 70, "ExampleText",
 CellID->17095],
Cell[CellGroupData[{
Cell[60528, 2108, 226, 7, 70, "Input",
 CellID->1940],
Cell[60757, 2117, 247, 9, 36, "Output",
 CellID->11714]
}, Open  ]],
Cell[CellGroupData[{
Cell[61041, 2131, 361, 12, 70, "Input",
 CellID->13029],
Cell[61405, 2145, 255, 8, 36, "Output",
 CellID->31784]
}, Open  ]],
Cell[61675, 2156, 120, 3, 70, "ExampleDelimiter",
 CellID->5965],
Cell[61798, 2161, 339, 12, 70, "ExampleText",
 CellID->7749],
Cell[CellGroupData[{
Cell[62162, 2177, 266, 10, 70, "Input",
 CellID->2197],
Cell[62431, 2189, 287, 9, 36, "Output",
 CellID->29353]
}, Open  ]],
Cell[CellGroupData[{
Cell[62755, 2203, 308, 11, 70, "Input",
 CellID->1367],
Cell[63066, 2216, 287, 9, 36, "Output",
 CellID->14016]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63402, 2231, 225, 7, 70, "ExampleSection",
 CellID->4504],
Cell[63630, 2240, 224, 7, 70, "ExampleText",
 CellID->29063],
Cell[CellGroupData[{
Cell[63879, 2251, 219, 7, 70, "Input",
 CellID->1866],
Cell[64101, 2260, 219, 7, 36, "Output",
 CellID->20605]
}, Open  ]],
Cell[64335, 2270, 120, 3, 70, "ExampleDelimiter",
 CellID->5086],
Cell[64458, 2275, 263, 8, 70, "ExampleText",
 CellID->29054],
Cell[CellGroupData[{
Cell[64746, 2287, 277, 9, 70, "Input",
 CellID->4931],
Cell[65026, 2298, 186, 6, 36, "Output",
 CellID->10294]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65273, 2311, 311, 9, 70, "SeeAlsoSection",
 CellID->26799],
Cell[65587, 2322, 2644, 98, 70, "SeeAlso",
 CellID->13334]
}, Open  ]],
Cell[CellGroupData[{
Cell[68268, 2425, 313, 9, 70, "TutorialsSection",
 CellID->5829],
Cell[68584, 2436, 195, 4, 70, "Tutorials",
 CellID->3338],
Cell[68782, 2442, 149, 3, 70, "Tutorials",
 CellID->22130],
Cell[68934, 2447, 179, 4, 70, "Tutorials",
 CellID->21890]
}, Open  ]],
Cell[CellGroupData[{
Cell[69150, 2456, 319, 9, 70, "MoreAboutSection",
 CellID->115522000],
Cell[69472, 2467, 144, 3, 70, "MoreAbout",
 CellID->443327267],
Cell[69619, 2472, 134, 3, 70, "MoreAbout",
 CellID->375970351],
Cell[69756, 2477, 155, 3, 70, "MoreAbout",
 CellID->218002137],
Cell[69914, 2482, 145, 3, 70, "MoreAbout",
 CellID->148647199],
Cell[70062, 2487, 150, 3, 70, "MoreAbout",
 CellID->247821941],
Cell[70215, 2492, 144, 3, 70, "MoreAbout",
 CellID->203624707],
Cell[70362, 2497, 161, 3, 70, "MoreAbout",
 CellID->35268786],
Cell[70526, 2502, 175, 3, 70, "MoreAbout",
 CellID->4978273],
Cell[70704, 2507, 181, 3, 70, "MoreAbout",
 CellID->212903860],
Cell[70888, 2512, 156, 3, 70, "MoreAbout",
 CellID->260560181],
Cell[71047, 2517, 163, 3, 70, "MoreAbout",
 CellID->27229792]
}, Open  ]],
Cell[CellGroupData[{
Cell[71247, 2525, 305, 8, 70, "RelatedLinksSection"],
Cell[71555, 2535, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[71959, 2551, 50, 0, 70, "History"],
Cell[72012, 2553, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

