(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15538,        569]
NotebookOptionsPosition[     12117,        454]
NotebookOutlinePosition[     13490,        492]
CellTagsIndexPosition[     13405,        487]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingTransformationRules"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Transformation Rules\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Replace" :> Documentation`HelpLookup["paclet:ref/Replace"], 
          "ReplaceAll" :> Documentation`HelpLookup["paclet:ref/ReplaceAll"], 
          "Rule" :> Documentation`HelpLookup["paclet:ref/Rule"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"], "FixedPoint" :> 
          Documentation`HelpLookup["paclet:ref/FixedPoint"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Replace\"\>", 
       2->"\<\"ReplaceAll\"\>", 3->"\<\"Rule\"\>", 4->"\<\"Set\"\>", 
       5->"\<\"FixedPoint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rules" :> Documentation`HelpLookup["paclet:guide/Rules"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Rules\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "ReplaceRepeated ",
 StyleBox["(//.)", "OperatorCharacter"]
}], "ObjectName",
 CellID->7198],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], "//.", 
       StyleBox["rules", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]repeatedly performs replacements until ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " no longer changes. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11252]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "//.", 
   StyleBox["rules", "TI"]}]], "InlineFormula"],
 " effectively applies ",
 Cell[BoxData["/."], "InlineFormula"],
 " repeatedly, until the results it gets no longer change. "
}], "Notes",
 CellID->4229],

Cell[TextData[{
 "It performs one complete pass over the expression using ",
 Cell[BoxData["/."], "InlineFormula"],
 ", then carries out the next pass. "
}], "Notes",
 CellID->14283],

Cell[TextData[{
 "You should be very careful to avoid infinite loops when you use the ",
 Cell[BoxData["//."], "InlineFormula"],
 " operator. The command ",
 Cell[BoxData[
  RowBox[{"x", "//.", 
   RowBox[{"x", "->", 
    RowBox[{"x", "+", "1"}]}]}]], "InlineFormula"],
 " will, for example, lead to an infinite loop. "
}], "Notes",
 CellID->20351],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplaceRepeated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFormula"],
 " takes the option ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 ", which specifies the maximum number of times it will try to apply the \
rules you give. The default setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MaxIterations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxIterations"], "->", "65536"}]], 
  "InlineFormula"],
 ". With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MaxIterations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxIterations"], "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " there is no limit. "
}], "Notes",
 CellID->31356]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->464200840],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->117130428],

Cell["\<\
Apply rules for power and product laws for logarithms of real numbers \
recursively:\
\>", "ExampleText",
 CellID->121362979],

Cell[BoxData[
 RowBox[{
  RowBox[{"rules", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"x_", " ", "y_"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"Log", "[", "x", "]"}], "+", 
       RowBox[{"Log", "[", "y", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"x_", "^", "k_"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"k", " ", 
       RowBox[{"Log", "[", "x", "]"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->474150738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"a", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"c", "^", "d"}]}], ")"}], "^", "e"}]}], "]"}], "]"}], "//.", 
  "rules"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->221788376],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Log", "[", "a", "]"}], "+", 
    RowBox[{"e", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Log", "[", "b", "]"}], "+", 
       RowBox[{"d", " ", 
        RowBox[{"Log", "[", "c", "]"}]}]}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{218, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92153645]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 " does just a single replacement:"
}], "ExampleText",
 CellID->764533319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"a", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"c", "^", "d"}]}], ")"}], "^", "e"}]}], "]"}], "]"}], "/.", 
  "rules"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->357828361],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"Log", "[", 
   RowBox[{"a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "d"]}], ")"}], "e"]}], "]"}]}]], "Output",
 ImageSize->{106, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14833280]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32156],

Cell["\<\
Undo \[OpenCurlyDoubleQuote]currying\[CloseCurlyDoubleQuote] of function \
arguments:\
\>", "ExampleText",
 CellID->29773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], "[", "b", "]"}], "[", "c", "]"}], "[", "d",
    "]"}], "//.", 
  RowBox[{
   RowBox[{
    RowBox[{"g_", "[", "x_", "]"}], "[", "y__", "]"}], "\[Rule]", 
   RowBox[{"g", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20106]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16983],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Replace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Replace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rule",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rule"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FixedPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPoint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14138]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4901],

Cell[TextData[ButtonBox["Applying Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingTransformationRules"]], "Tutorials",
 CellID->27774]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->39436912],

Cell[TextData[ButtonBox["Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Rules"]], "MoreAbout",
 CellID->21840997]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReplaceRepeated (//.) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 29.2230030}", "context" -> "System`", 
    "keywords" -> {
     "repeated rule application", "replacement", "ReplaceRepeated", 
      "slash-slash-dot", "recursive replacement"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "expr //. rules repeatedly performs replacements until expr no longer \
changes. ", "synonyms" -> {"replace repeated", "//."}, "title" -> 
    "ReplaceRepeated", "type" -> "Symbol", "uri" -> "ref/ReplaceRepeated"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5586, 185, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->464200840]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13262, 480}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2085, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2708, 77, 109, 4, 70, "ObjectName",
 CellID->7198],
Cell[2820, 83, 511, 16, 70, "Usage",
 CellID->11252]
}, Open  ]],
Cell[CellGroupData[{
Cell[3368, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3846, 121, 279, 9, 70, "Notes",
 CellID->4229],
Cell[4128, 132, 182, 5, 70, "Notes",
 CellID->14283],
Cell[4313, 139, 348, 10, 70, "Notes",
 CellID->20351],
Cell[4664, 151, 885, 29, 70, "Notes",
 CellID->31356]
}, Closed]],
Cell[CellGroupData[{
Cell[5586, 185, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->464200840],
Cell[CellGroupData[{
Cell[5971, 199, 148, 5, 70, "ExampleSection",
 CellID->117130428],
Cell[6122, 206, 135, 4, 70, "ExampleText",
 CellID->121362979],
Cell[6260, 212, 528, 17, 70, "Input",
 CellID->474150738],
Cell[CellGroupData[{
Cell[6813, 233, 293, 11, 28, "Input",
 CellID->221788376],
Cell[7109, 246, 457, 16, 51, "Output",
 CellID->92153645]
}, Open  ]],
Cell[7581, 265, 213, 7, 70, "ExampleText",
 CellID->764533319],
Cell[CellGroupData[{
Cell[7819, 276, 297, 11, 70, "Input",
 CellID->357828361],
Cell[8119, 289, 363, 13, 51, "Output",
 CellID->14833280]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8531, 308, 223, 7, 70, "ExampleSection",
 CellID->32156],
Cell[8757, 317, 132, 4, 70, "ExampleText",
 CellID->29773],
Cell[CellGroupData[{
Cell[8914, 325, 356, 13, 70, "Input",
 CellID->575],
Cell[9273, 340, 224, 7, 36, "Output",
 CellID->20106]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9558, 354, 311, 9, 70, "SeeAlsoSection",
 CellID->16983],
Cell[9872, 365, 1174, 44, 70, "SeeAlso",
 CellID->14138]
}, Open  ]],
Cell[CellGroupData[{
Cell[11083, 414, 313, 9, 70, "TutorialsSection",
 CellID->4901],
Cell[11399, 425, 167, 3, 70, "Tutorials",
 CellID->27774]
}, Open  ]],
Cell[CellGroupData[{
Cell[11603, 433, 318, 9, 70, "MoreAboutSection",
 CellID->39436912],
Cell[11924, 444, 121, 3, 70, "MoreAbout",
 CellID->21840997]
}, Open  ]],
Cell[12060, 450, 27, 0, 70, "History"],
Cell[12090, 452, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

