(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20781,        817]
NotebookOptionsPosition[     15936,        641]
NotebookOutlinePosition[     17184,        678]
CellTagsIndexPosition[     17099,        673]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Getting Pieces of Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GettingPiecesOfLists"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Getting Pieces of Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Most" :> Documentation`HelpLookup["paclet:ref/Most"], "Drop" :> 
          Documentation`HelpLookup["paclet:ref/Drop"], "First" :> 
          Documentation`HelpLookup["paclet:ref/First"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Most\"\>", 2->"\<\"Drop\"\>", 3->"\<\"First\"\>",
        4->"\<\"Part\"\>", 5->"\<\"Take\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Parts of Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rest", "ObjectName",
 CellID->29695],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rest",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rest"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with the first element removed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rest"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5049]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->198697694],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->365268598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26672],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27215]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19111],

Cell[TextData[{
 "The head need not be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"a", "+", "b", "+", "c", "+", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31454],

Cell[BoxData[
 RowBox[{"b", "+", "c", "+", "d"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15195]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8507],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17683],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rest"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->7957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"Range", "[", "100", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27963],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "99", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 99, ">"],
     Editable->False], ",", 
    RowBox[{"{", "99", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32502]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18616],

Cell["Nest the operation of finding the rest of a list:", "ExampleText",
 CellID->22499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"Rest", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}]}], "}"}]], "Output",
 ImageSize->{318, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18299]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21127],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rest"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 ". "
}], "ExampleText",
 CellID->27167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11539],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27445]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28484],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28004]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17161],

Cell[TextData[{
 "The expression is evaluated before ",
 Cell[BoxData[
  ButtonBox["Rest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rest"]], "InlineFormula"],
 " is applied:"
}], "ExampleText",
 CellID->17727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"c", "+", "a", "+", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7064],

Cell[BoxData[
 RowBox[{"b", "+", "c"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3660]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28390],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rest"]], "InlineFormula"],
 " always operates on the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of expressions:"
}], "ExampleText",
 CellID->5412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"1", "/", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13240],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10180]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"1", "/", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4406],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"b", ",", 
     RowBox[{"-", "1"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->9551]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16373],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Most",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Most"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["First",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/First"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27561]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29217],

Cell[TextData[ButtonBox["Getting Pieces of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GettingPiecesOfLists"]], "Tutorials",
 CellID->2015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->150278070],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->636188206],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->70802363]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Rest"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 36.6919442}", "context" -> "System`", 
    "keywords" -> {
     "drop first element", "remove fist element in list", "tail of list"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Rest[expr] gives expr with the first element removed. ", 
    "synonyms" -> {"cdr"}, "title" -> "Rest", "type" -> "Symbol", "uri" -> 
    "ref/Rest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4407, 144, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->198697694]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16956, 666}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2208, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2831, 79, 42, 1, 70, "ObjectName",
 CellID->29695],
Cell[2876, 82, 552, 18, 70, "Usage",
 CellID->3705]
}, Open  ]],
Cell[CellGroupData[{
Cell[3465, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3943, 122, 427, 17, 70, "Notes",
 CellID->5049]
}, Closed]],
Cell[CellGroupData[{
Cell[4407, 144, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->198697694],
Cell[CellGroupData[{
Cell[4792, 158, 148, 5, 70, "ExampleSection",
 CellID->365268598],
Cell[CellGroupData[{
Cell[4965, 167, 163, 5, 28, "Input",
 CellID->26672],
Cell[5131, 174, 209, 7, 36, "Output",
 CellID->27215]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5389, 187, 216, 7, 70, "ExampleSection",
 CellID->19111],
Cell[5608, 196, 191, 8, 70, "ExampleText",
 CellID->6006],
Cell[CellGroupData[{
Cell[5824, 208, 139, 4, 70, "Input",
 CellID->31454],
Cell[5966, 214, 186, 6, 36, "Output",
 CellID->15195]
}, Open  ]],
Cell[CellGroupData[{
Cell[6189, 225, 167, 5, 70, "Input",
 CellID->8507],
Cell[6359, 232, 212, 7, 36, "Output",
 CellID->837]
}, Open  ]],
Cell[6586, 242, 121, 3, 70, "ExampleDelimiter",
 CellID->17683],
Cell[6710, 247, 313, 12, 70, "ExampleText",
 CellID->7957],
Cell[CellGroupData[{
Cell[7048, 263, 169, 5, 70, "Input",
 CellID->27963],
Cell[7220, 270, 452, 16, 36, "Output",
 CellID->32502]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7721, 292, 223, 7, 70, "ExampleSection",
 CellID->18616],
Cell[7947, 301, 88, 1, 70, "ExampleText",
 CellID->22499],
Cell[CellGroupData[{
Cell[8060, 306, 218, 7, 70, "Input",
 CellID->23168],
Cell[8281, 315, 476, 15, 36, "Output",
 CellID->18299]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8806, 336, 233, 7, 70, "ExampleSection",
 CellID->21127],
Cell[9042, 345, 434, 17, 70, "ExampleText",
 CellID->27167],
Cell[CellGroupData[{
Cell[9501, 366, 163, 5, 70, "Input",
 CellID->11539],
Cell[9667, 373, 209, 7, 36, "Output",
 CellID->27445]
}, Open  ]],
Cell[CellGroupData[{
Cell[9913, 385, 191, 7, 70, "Input",
 CellID->28484],
Cell[10107, 394, 209, 7, 36, "Output",
 CellID->28004]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10365, 407, 226, 7, 70, "ExampleSection",
 CellID->17161],
Cell[10594, 416, 217, 8, 70, "ExampleText",
 CellID->17727],
Cell[CellGroupData[{
Cell[10836, 428, 128, 4, 70, "Input",
 CellID->7064],
Cell[10967, 434, 175, 6, 36, "Output",
 CellID->3660]
}, Open  ]],
Cell[11157, 443, 121, 3, 70, "ExampleDelimiter",
 CellID->28390],
Cell[11281, 448, 328, 12, 70, "ExampleText",
 CellID->5412],
Cell[CellGroupData[{
Cell[11634, 464, 119, 4, 70, "Input",
 CellID->13240],
Cell[11756, 470, 171, 6, 36, "Output",
 CellID->10180]
}, Open  ]],
Cell[CellGroupData[{
Cell[11964, 481, 122, 4, 70, "Input",
 CellID->4406],
Cell[12089, 487, 363, 14, 50, "Output",
 CellID->9551]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12513, 508, 311, 9, 70, "SeeAlsoSection",
 CellID->16373],
Cell[12827, 519, 1148, 44, 70, "SeeAlso",
 CellID->27561]
}, Open  ]],
Cell[CellGroupData[{
Cell[14012, 568, 314, 9, 70, "TutorialsSection",
 CellID->29217],
Cell[14329, 579, 153, 3, 70, "Tutorials",
 CellID->2015]
}, Open  ]],
Cell[CellGroupData[{
Cell[14519, 587, 319, 9, 70, "MoreAboutSection",
 CellID->150278070],
Cell[14841, 598, 144, 3, 70, "MoreAbout",
 CellID->636188206],
Cell[14988, 603, 149, 3, 70, "MoreAbout",
 CellID->70802363]
}, Open  ]],
Cell[CellGroupData[{
Cell[15174, 611, 305, 8, 70, "RelatedLinksSection"],
Cell[15482, 621, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[15879, 637, 27, 0, 70, "History"],
Cell[15909, 639, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

