(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     73015,       2650]
NotebookOptionsPosition[     61219,       2226]
NotebookOutlinePosition[     62632,       2265]
CellTagsIndexPosition[     62546,       2260]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Operations on Polynomials\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subresultants" :> 
          Documentation`HelpLookup["paclet:ref/Subresultants"], 
          "Discriminant" :> 
          Documentation`HelpLookup["paclet:ref/Discriminant"], 
          "PolynomialGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialGCD"], "Eliminate" :> 
          Documentation`HelpLookup["paclet:ref/Eliminate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Subresultants\"\>", 
       2->"\<\"Discriminant\"\>", 3->"\<\"PolynomialGCD\"\>", 
       4->"\<\"Eliminate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Polynomial Algebra\"\>", 
       2->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Resultant", "ObjectName",
 CellID->18578],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Resultant",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Resultant"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["var", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]computes the resultant of the polynomials ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " with respect to the variable ",
     Cell[BoxData[
      StyleBox["var", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Resultant",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Resultant"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["var", "TI"], ",", 
        RowBox[{
         ButtonBox["Modulus",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Modulus"], "->", 
         StyleBox["p", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]computes the resultant modulo the prime ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20313]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The resultant of two polynomials ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 ", both with leading coefficient one, is the product of all the differences \
",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["p", "TI"], 
    StyleBox["i", "TI"]], "-", 
   SubscriptBox[
    StyleBox["q", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 " between roots of the polynomials. The resultant is always a number or a \
polynomial. "
}], "Notes",
 CellID->2650]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->278239443],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->131606433],

Cell["\<\
The resultant vanishes exactly when the polynomials have roots in common:\
\>", "ExampleText",
 CellID->22729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "a"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "b"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "c"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "d"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "e"}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7238],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{"b", "-", "c"}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"b", "-", "d"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "d"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"b", "-", "e"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "e"}], ")"}]}]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1734921]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3468],

Cell["Resultant of polynomials with numeric coefficients:", "ExampleText",
 CellID->571022051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"2", "x"}], "+", "7"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", "x", "+", "5"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->158217380],

Cell[BoxData["265"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4942272]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18803302],

Cell["Resultant of polynomials with parametric coefficients:", "ExampleText",
 CellID->657821953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"b", " ", "x"}], "+", "c"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "c"}], ")"}], 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "-", "c"}], ")"}], "x"}], "+", "9"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->467347150],

Cell[BoxData[
 RowBox[{
  RowBox[{"81", " ", 
   SuperscriptBox["a", "3"]}], "-", 
  RowBox[{"9", " ", "a", " ", 
   SuperscriptBox["b", "3"]}], "+", 
  RowBox[{"9", " ", 
   SuperscriptBox["b", "4"]}], "-", 
  RowBox[{"18", " ", 
   SuperscriptBox["a", "3"], " ", "c"}], "+", 
  RowBox[{"36", " ", 
   SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
  RowBox[{"36", " ", "a", " ", 
   SuperscriptBox["b", "2"], " ", "c"}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["b", "3"], " ", "c"}], "-", 
  RowBox[{
   SuperscriptBox["b", "4"], " ", "c"}], "+", 
  RowBox[{"18", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["c", "2"]}], "-", 
  RowBox[{"4", " ", 
   SuperscriptBox["a", "2"], " ", "b", " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"3", " ", "a", " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["c", "3"]}], "-", 
  RowBox[{"4", " ", "a", " ", "b", " ", 
   SuperscriptBox["c", "3"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["c", "4"]}]}]], "Output",
 ImageSize->{435, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75243147]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259850701],

Cell["Resultant over integers modulo 3:", "ExampleText",
 CellID->551921929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"2", "x"}], "+", "7"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", "x", "+", "5"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->895543351],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25664304]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78990641],

Cell["The resultant reflects the multiplicities of roots:", "ExampleText",
 CellID->29247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "a"}], ")"}], "^", "2"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "b"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "c"}], ")"}], "^", "2"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "d"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "e"}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10543],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "-", "c"}], ")"}], "4"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "b"}], "+", "c"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"b", "-", "d"}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "a"}], "+", "d"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"b", "-", "e"}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "a"}], "+", "e"}], ")"}], "2"]}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->437473186]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32457],

Cell["\<\
The resultant of rational functions is defined using the multiplicative \
property:\
\>", "ExampleText",
 CellID->221250015],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["f", "1"], "=", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "3"}]}], ";", 
  RowBox[{
   SubscriptBox["f", "2"], "=", 
   RowBox[{
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "-", "7"}]}], ";", 
  RowBox[{
   SubscriptBox["g", "1"], "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "x", "+", "5"}]}], ";", 
  RowBox[{
   SubscriptBox["g", "2"], "=", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"3", "x"}], "+", "8"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->456253729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{"Resultant", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "1"], 
     RowBox[{
      SubscriptBox["f", "2"], "^", "2"}]}], ",", 
    RowBox[{
     SubscriptBox["g", "1"], 
     RowBox[{
      SubscriptBox["g", "2"], "^", "3"}]}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167581085],

Cell[BoxData["10245478724269744968742734862760"], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7201166]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r2", "=", 
  RowBox[{
   RowBox[{"Resultant", "[", 
    RowBox[{
     SubscriptBox["f", "1"], ",", 
     SubscriptBox["g", "1"], ",", "x"}], "]"}], 
   RowBox[{
    RowBox[{"Resultant", "[", 
     RowBox[{
      SubscriptBox["f", "2"], ",", 
      SubscriptBox["g", "1"], ",", "x"}], "]"}], "^", "2"}], 
   RowBox[{
    RowBox[{"Resultant", "[", 
     RowBox[{
      SubscriptBox["f", "1"], ",", 
      SubscriptBox["g", "2"], ",", "x"}], "]"}], "^", "3"}], 
   RowBox[{
    RowBox[{"Resultant", "[", 
     RowBox[{
      SubscriptBox["f", "2"], ",", 
      SubscriptBox["g", "2"], ",", "x"}], "]"}], "^", "6"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->167342213],

Cell[BoxData["10245478724269744968742734862760"], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->544664239]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r1", "\[Equal]", "r2"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->421779290],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->674582916]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{"Resultant", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "1"], "/", 
     SubscriptBox["f", "2"]}], ",", 
    RowBox[{
     SubscriptBox["g", "1"], "/", 
     RowBox[{
      SubscriptBox["g", "2"], "^", "2"}]}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->301348124],

Cell[BoxData[
 FractionBox["84413315", "979708"]], "Output",
 ImageSize->{69, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->395007392]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r2", "=", 
  RowBox[{
   RowBox[{"Resultant", "[", 
    RowBox[{
     SubscriptBox["f", "1"], ",", 
     SubscriptBox["g", "1"], ",", "x"}], "]"}], 
   RowBox[{
    RowBox[{"Resultant", "[", 
     RowBox[{
      SubscriptBox["f", "2"], ",", 
      SubscriptBox["g", "1"], ",", "x"}], "]"}], "^", 
    RowBox[{"-", "1"}]}], 
   RowBox[{
    RowBox[{"Resultant", "[", 
     RowBox[{
      SubscriptBox["f", "1"], ",", 
      SubscriptBox["g", "2"], ",", "x"}], "]"}], "^", 
    RowBox[{"-", "2"}]}], 
   RowBox[{
    RowBox[{"Resultant", "[", 
     RowBox[{
      SubscriptBox["f", "2"], ",", 
      SubscriptBox["g", "2"], ",", "x"}], "]"}], "^", "2"}]}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->130044316],

Cell[BoxData[
 FractionBox["84413315", "979708"]], "Output",
 ImageSize->{69, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->48625105]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r1", "\[Equal]", "r2"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->84865543],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->691750723]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20611],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->10673],

Cell["\<\
This compares timings of the available methods of resultant computation:\
\>", "ExampleText",
 CellID->178377156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{
      RowBox[{"Resultant", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "100"}], "-", 
         RowBox[{"2", 
          RowBox[{"x", "^", "77"}]}], "+", 
         RowBox[{"3", "x"}], "+", "4"}], ",", 
        RowBox[{
         RowBox[{"x", "^", "97"}], "+", 
         RowBox[{"3", 
          RowBox[{"x", "^", "55"}]}], "-", 
         RowBox[{"11", 
          RowBox[{"x", "^", "3"}]}], "+", "9"}], ",", "x", ",", 
        RowBox[{"Method", "\[Rule]", "#"}]}], "]"}], "//", "Short"}], "]"}], 
    "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
    "Automatic", ",", "Modular", " ", ",", "Subresultants", ",", " ", 
     "\"\<BezoutMatrix\>\"", ",", "\"\<SylvesterMatrix\>\""}], "}"}]}], "//", 
  "ColumnForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130170461],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{"0.016000000000009312`", ",", 
       RowBox[{"23121538961960848095293481212695412", 
        RowBox[{"\[LeftSkeleton]", "48", "\[RightSkeleton]"}], 
        "265924418056229593467896831334882576"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"23121538961960848095293481212695412", 
        RowBox[{"\[LeftSkeleton]", "48", "\[RightSkeleton]"}], 
        "265924418056229593467896831334882576"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"23121538961960848095293481212695412", 
        RowBox[{"\[LeftSkeleton]", "48", "\[RightSkeleton]"}], 
        "265924418056229593467896831334882576"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"0.21899999999998976`", ",", 
       RowBox[{"23121538961960848095293481212695412", 
        RowBox[{"\[LeftSkeleton]", "48", "\[RightSkeleton]"}], 
        "265924418056229593467896831334882576"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"0.5619999999999956`", ",", 
       RowBox[{"23121538961960848095293481212695412", 
        RowBox[{"\[LeftSkeleton]", "48", "\[RightSkeleton]"}], 
        "265924418056229593467896831334882576"}]}], "}"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{{0.016000000000009312`, 
     Short[
     2312153896196084809529348121269541260207310548450255097214709679164279115\
8461132160265924418056229593467896831334882576]}, {0., 
     Short[
     2312153896196084809529348121269541260207310548450255097214709679164279115\
8461132160265924418056229593467896831334882576]}, {0., 
     Short[
     2312153896196084809529348121269541260207310548450255097214709679164279115\
8461132160265924418056229593467896831334882576]}, {0.21899999999998976`, 
     Short[
     2312153896196084809529348121269541260207310548450255097214709679164279115\
8461132160265924418056229593467896831334882576]}, {0.5619999999999956, 
     Short[
     2312153896196084809529348121269541260207310548450255097214709679164279115\
8461132160265924418056229593467896831334882576]}}],
  Editable->False]], "Output",
 ImageSize->{656, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314367192]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{
      RowBox[{"Resultant", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"a", " ", 
          RowBox[{"x", "^", "10"}]}], "+", 
         RowBox[{"b", " ", 
          RowBox[{"x", "^", "5"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}], "x"}], "+", 
         RowBox[{"a", " ", "b", " ", "c"}]}], ",", 
        RowBox[{
         RowBox[{"c", " ", 
          RowBox[{"x", "^", "5"}]}], "-", 
         RowBox[{"a", " ", 
          RowBox[{"x", "^", "3"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "x"}], "+", "7"}], ",", "x", ",", 
        RowBox[{"Method", "\[Rule]", "#"}]}], "]"}], "//", "Short"}], "]"}], 
    "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
    "Automatic", ",", "Modular", " ", ",", "Subresultants", ",", " ", 
     "\"\<BezoutMatrix\>\"", ",", "\"\<SylvesterMatrix\>\""}], "}"}]}], "//", 
  "ColumnForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95396236],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnNtuGzcQhuldreRTZKcNAl+0RYCifZMmVz2gfQIjaJFcBA7SoL3KMxR9
gKLXzUtuxV2OdjT7Dw+r6OBkDFhacmfI4XA45H6W9f3t2xe/vrp9+/L57ZNn
b25fv3j5/PcnT+/erKrqE+dO/nPO/XbjVtft6qr79T/vV7/OzVavVaj6J1w3
3Z3av9Yk3XZv/4q6akvJb4HmH9maZPefWRq+7Is04iaUG0VO1s9XL41z6/t1
KC9YWWunYf11Bjj6OQ13L4R2k9n6XFhThTK1+4iNmstJPWpvEcrXoj9pX+fj
2bosrKHeerM7odEItBGfhffL0Ia0BM9uV9twe6j7ilw+ujvLaoPiZQHvYh1c
e4r6y+p/XDsXutIfWOsS+Hy3dmJZubaw7qOtPY7Ht30LD4X93mM1W3011JJz
1o16tIaojfMsH13A2nNYeyVa7FeSnF1s+wMkJSOJlWWk4VZRK3OwMlGOluU5
iCvcq/cO5UC196StesbhUossiy6CRd3KGyJCjaRLWItjFddeMR9UbsiUcyhd
Bc9QPu/We2hbajeqByOxyjz0mSifdHJ53i+NUikfyWzJlSjbhjkuK35mwZMz
N87YMp4itkyMYGmntOimhTEa2S/OEvexHdTftFxbkuPrNp55m2BJXvxKe0vO
K76H9SoU0jXwBdUndhYQnfycGDnXqT7DESajVbau2JUVqRSDaWkcEY/bIVfl
rd61Zzf2aN0OOTt5Z+axT2o8B5EVJHvS828FWjuF0vi0MC0PR8530UwCM28o
U45Q9hnFW3oW4M8usf0I2lCUD5VdXvSh2jLZY/5yMWrhvB2yHz1Bco0voLek
F2T5S2UEDevfOalJErP1su5/amAX3E8z4/MM1uad6JYFunqkpeMRnl2S84Db
uhRSV1vYlfdEV7Ir51k31cO6NXBmF0KqHeK5fBV8Lcpwn2b3H0QsQDu4zoUu
2jHf8atq2W4SGnr3OYn2Bi7P90HaPWs33h2WkXZ8PedYvF++U/hRXiv2LYI9
nKqt9RWPfSVsp6eVb4DPKjc+C8l9BJ4zkjPyLrT+k6h/GrH8l6CzZO+bJwft
lIj75+UfhMefJeyIPS915dGqkM8ovV3E0d6FWflRSH3XMlbH6n9uh5muQ7bg
kUiz11Nrr/K+6MoIuFxrRr7LT/H3i3yX7KXGv41/y9pPlH8XPXkZAe+rjIBv
jnIPBLwoTo2BGwM/JgZOPIo/gVbAB8a+kbSx70Ozb7kWpJaMiyvsg0jWNAq+
jcf8pVFwFKlo11NOGMa/EznU+LcvH5Z/z9wm/amDb2s3Zl7Gv41/Yztiz0rG
v+8z/0ZZkjzagJkwDp4+0R8rB4e5IotyGPueaqex70HrPrNvzFpTz3fLrLaN
fw9zafy7r9qGf0+LVbg6jIGP4tYY+H4YuJxtskjGEjoZ0SksstuAloyJp1fx
2rPGxAvjOf1XSWnDw6SGUXFgi1FxOLKSWC35bDj8W7qx8UQuNTbuy4dj4/T0
I3mYxp6NjRsbx3aMcl8yFxobz5c8hs+GozXK9YyJp0/0x8rEp/GLqjUmPt1O
Y+KD1n1m4vA/nHleBDJGwGMWGQEfxvwBPwHe9mdjLGvc27j3MXFv/tlvZf42
PG/8O0fa+Peh+Tf8THiSGBkDj41btcUYOBzZ7uPV6DeqNfqNyoej3/TJcM6K
iKPSiuTvRr+NfmM7uO7HTr//CtefQ0/6l79F3fWWkjdAU9JvXVOj31hDo9/2
TSjl5/d90G48i1Not33C22i2rP04aHa/RqbRbPvukr7KyPXmKMvJdReVJeQ6
cqYyOm10+kPT6ZKTBJEg+yaSHGmjzrugzqXxOsrNxpOVcau2GE+GI9smEu07
tFGtkWJU3iUpjtMgIsVGhndHhvEM3LX7IsN6/7y8fzLc20V06q7dDRnuaa5X
6YmvO/kfAi7iwQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{425, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->354321632]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20997],

Cell["\<\
By default the resultant is computed over the rational numbers:\
\>", "ExampleText",
 CellID->133742431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"c", " ", "x"}], "+", "d"}], ",", 
   RowBox[{
    RowBox[{"d", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"b", " ", "x"}], "+", "a"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2515],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "6"], "-", 
  RowBox[{
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["b", "2"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["a", "3"], " ", 
   SuperscriptBox["b", "2"], " ", "c"}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["c", "2"]}], "-", 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["c", "4"]}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "3"], " ", "d"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", "d"}], "+", 
  RowBox[{"2", " ", "a", " ", 
   SuperscriptBox["b", "3"], " ", "c", " ", "d"}], "-", 
  RowBox[{"4", " ", 
   SuperscriptBox["a", "2"], " ", "b", " ", 
   SuperscriptBox["c", "2"], " ", "d"}], "-", 
  RowBox[{"2", " ", "a", " ", "b", " ", 
   SuperscriptBox["c", "3"], " ", "d"}], "-", 
  RowBox[{"3", " ", 
   SuperscriptBox["a", "4"], " ", 
   SuperscriptBox["d", "2"]}], "-", 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["d", "2"]}], "-", 
  RowBox[{
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["d", "2"]}], "+", 
  RowBox[{"4", " ", "a", " ", 
   SuperscriptBox["b", "2"], " ", "c", " ", 
   SuperscriptBox["d", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "2"]}], "+", 
  RowBox[{"2", " ", "a", " ", 
   SuperscriptBox["c", "3"], " ", 
   SuperscriptBox["d", "2"]}], "-", 
  RowBox[{"6", " ", "a", " ", "b", " ", "c", " ", 
   SuperscriptBox["d", "3"]}], "-", 
  RowBox[{"2", " ", "b", " ", 
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "3"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["d", "4"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["d", "4"]}], "+", 
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SuperscriptBox["d", "4"]}], "-", 
  SuperscriptBox["d", "6"]}]], "Output",
 ImageSize->{464, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274333141]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180435940],

Cell["\<\
Compute the resultant of the same polynomials over the integers modulo 2:\
\>", "ExampleText",
 CellID->3114652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"c", " ", "x"}], "+", "d"}], ",", 
   RowBox[{
    RowBox[{"d", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"b", " ", "x"}], "+", "a"}], ",", "x", ",", 
   RowBox[{"Modulus", "->", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23740],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFV9tu4jAQNYlJgXCptvTy2K/ZfdqPQNVK9KFq1eXruw/ZmHja4WQ8sXFQ
kcCXmTlzt83v3WH/52V3eH7aPf56373tn5/+Pv58fW+3yokxkw9jzObBtPOm
nR2/7vOv/XZTnBXt77Rlq92qJP7GVH5/5sdVgD7347IdHXkNfFOGXyo4dYId
Ep9ldtCo2RHi4ziloo/sWij0GPnqmAVTdoP7LYBzIXhipp/rTrDj6u1KUehz
1QmImD+bgJhjTZysbPP4iDlRiEP8Xv8un6mrZqjuqeNT7F6oMko+mF7qWCWn
jJvOkVSNqZ6Ni5TmXxhD0QsRHcf2E5lMDV0FuqqzQtVWfj+uP4g7rsI2sJ5y
abaPd6muJc2Dy5+JIa/kiko4/wbznpfLuNoa65SLv90LY86UrgPSs6hMXOiG
Z1xFUuVJnswjEYNRANns+30AT7Vl5HidJxmtE3i+TlVHuPPjEc36Fjh+iLLs
UdyO27htvl7QuHaaeFdtg3ok7htRZwiT9NcBHtl6DTFE0+Rwr/vfMPOUB49s
ISMW8lAF6EvgW8Ma+4vTsAoIE2vPTaWbzy2xBzn+SrHhesAfyYYTnyyv+5JV
2UKk/gC84jMp3APjM3LC6TOFGbgTIiLxYe+hHEYW6VeNfOIgnw3onwfk134f
M1hF6sOTcRaQ20TGJWQn6iU92DHbAB7yXQt6DK171eC0S6/MoWgM8fOz0pr+
PSPxa/oIJ9fO+0S9iF97OzR/5ai7nNwDdUjbOVHH7PI1vtvPycKY9o+RDW6P
hkfxkE9GsgZfE1IUV7COiTplH99cEj/iIf9YdmI1DumV8AvFX8xW1wt0buE9
hO+63F5IrfXUXsBay7U/txe0XpXicduwe8KYyX8L5P/N\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{506, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31668321]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243356014],

Cell["\<\
Compute the resultant of the same polynomials over the integers modulo 3:\
\>", "ExampleText",
 CellID->19707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"c", " ", "x"}], "+", "d"}], ",", 
   RowBox[{
    RowBox[{"d", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"b", " ", "x"}], "+", "a"}], ",", "x", ",", 
   RowBox[{"Modulus", "->", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18445],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWk1T2zAQNXGCIV+kJUlpL0l6pMfSv9Ce+iMyTGfg0GmH8v/dOPY6ystb
aWW7UGYgkbTafbtayfI+vm+fH3783D4/3m/X3562vx8e7/+sv/562nWlZ0nS
GyVJsrlJdt/z3bf9r/xMdr+HZrh1sfs72Ck4rz6lPak+R4VUWltIBlV/v/oc
K3KiL3X0FcNZQH5YyWn2+6BPsy84Re/AqDcDvWNFzsWh+eOzh/iyejWSgbue
SYX9tHdIe0e0F73gGmPstNHIMXJZm53uY8Hndh+LGOvdr+IENPZfCGP3/u13
TnIJGs4jYqGvuOzTpppFR3QGOPayBpqHoGPSQAfiGHcQpUEHuFAHxzVydQRx
+TMgDrUtEmXW4joVsv3IPMW9k0G7zdkueNpkqqbTlqMRp0owJ0KROvK2I2S2
bMXTGHOo9Vka7Y0ti8osZjcqnnG93WcPpPHk7hE0F8QC04VyTJe+Tiq64Kra
7Xh2tkGfHSHuLmtUmz6lYhCnZsS4LzArtTyw5FRzv2jcYE65M9g7RCpW+mV/
ksgJUMwrg1MOvGNxO5o1JrPmlY1zaqNfjWizxpUM03ytahwZ0IvvWZSFLMLC
aXxYVOce+wwzyvje18aVj3g+iO+Y48XXK6oJNchbLOZe8fW9Ym1OZJfOOnsR
EX3y5o27S/diWcUPdxWzMlW0F/NnphgdRbnvShe9C+/olFpgWPa7fT8iMWEZ
g0/wy5yfVLP8kDH1uQE3ATbvRrFzrcgvoY0nk4ZvqthBvy8C/mGOZgF7M0U/
nrWSNRI/Le44D/eGJudmJeI9HAwfAtHFaK3ywxnk9q+hjedRaBXRDsrjOM6/
DcgjvhB+eZow3EX/qrNoulpCqF86qp8io+bzD+cX/qI/OF7oP5xc72EUpSfQ
3lSzmVYNRQJrbrGD8jiO828D8ogvhF9OHsQh/bhKzXJ1A218Mr52rnZ9Akyh
vQiMr6pol9HNq59YbuO4VZzZlkq8y4D45C7zA0OQJvyZ7TIa6KPPLrtTMIaE
jbu4WCUK7ab5sR+ZcZ7YQcaEVb5cOyH5/bP16K6NtwO8rf6PbAa306Yqx/Lx
9biiNnHsPmLtY8Fl21iPYble13e0E96BLmuMez2WFbHp8OQMvE/E8SFtvWA1
ZzsCv3TMPnFP57AvNnS8kh9nybML8P6gWorOe7PmMtOLv+w9TGMGbGefNtuW
yYzJZHwJ1k/iMGP24h1Fs6rJtTnZvTxMw1y12miTpXG4m+mMvxPZqvoaG9NM
20jRxqukXd6F2nnLuZOXuQdZ+SuMlp21sa8I47Oa2dU8s3M+9rtPt3YOT4Si
U6upnzI3muT4RFKqXrP8mGux2xK+ZQEaFl6byGC8VeydMkainzFGmpZTDD4O
50q17Zu1j0xdE+bsgLxNY0VXcHLGQuLFmMaiuXHWJlVth3ggwbaEtqwj3rCE
VbD9zwTjb4rZWPPW/xOAYdD4GaxQSb0MsQ7rNXOra7IXEHMv5/V8TT5V5D8y
FE77Tc5rKhqPE6qv4f0IYx7ieVz/mNwM5FhtwMefCG+Eu1fsj+kqrXMbX2Hl
ObAKGlvFHOWcV8B5d4E25i6OL+po9Kq970YlVNtFr1Yt51ui4upnO9Pn7edA
dL5Ae15HB72w8AVWngGj3oRHYHV9nHcXaCO/geN7/TVPiOdOqM4fyxO0zRUc
x7r8v9lJydlfTOoLlQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{523, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230977613]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8349],

Cell["Decide whether two polynomials have common roots:", "ExampleText",
 CellID->591123552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"5", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"7", "x"}], "+", "3"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"8", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"9", "x"}], "-", "11"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->308727008],

Cell[BoxData[
 RowBox[{"-", "10321"}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->601834061]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"5", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"7", "x"}], "+", "3"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"8", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"9", "x"}], "-", "11"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->543446760],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->316019870]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"5", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"7", "x"}], "+", "14"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"8", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"9", "x"}], "+", "58"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->56784027],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->374564846]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"5", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"7", "x"}], "+", "14"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"8", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"9", "x"}], "+", "58"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->839744023],

Cell[BoxData[
 RowBox[{"2", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->446223157]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67755956],

Cell["Find conditions for two polynomials to have common roots:", \
"ExampleText",
 CellID->228807574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Resultant", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", 
       RowBox[{"2", "a", " ", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "x"}], "-", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"2", "a", " ", "x"}], "+", "3"}], ",", "x"}], "]"}], 
    "\[Equal]", "0"}], ",", "a"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355447784],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", "2"}], "||", 
  RowBox[{"a", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "14"}], "-", 
       RowBox[{"10", " ", "#1"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"a", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "14"}], "-", 
       RowBox[{"10", " ", "#1"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "3"]}]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"a", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "14"}], "-", 
       RowBox[{"10", " ", "#1"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "3"]}]}], "&"}], ",", "3"}], "]"}]}]}]], "Output",\

 ImageSize->{520, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3920796]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"PolynomialGCD", "[", 
     RowBox[{"##", ",", 
      RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}], "&"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", 
       RowBox[{"2", "a", " ", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "x"}], "-", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"2", "a", " ", "x"}], "+", "3"}]}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{"ToRules", "[", "%", "]"}], "}"}]}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79086758],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW91u0zAUzpKm67rRZuyCDSboELDxAogngAvEKyBVE9J2gUBjbwTvwBNw
w8MAN8BliFO7dT4fx3aadm13Kq2ZnePzf46dfOrb8fXF+w/j68vz8ej11fjT
xeX559Grj1fFVLIVRfFxFEVvDqPi/7z4r/xTn4fFXxS9K77jYvqbvL6E8Y68
plPqKJlyKan08QvH/R0Yx0vk+hXGmUPKFxjvN5Yq/IerKWmC7q6XlGHxncjo
6Hc7kkssr4PimhbXjqRPgD7R7qXy2gGavuSh7iueiRx3S8Ez+skdQbENnLZ1
CeSKO7Ci65SxJy2dmFYSGFYquSkxr4/TvOqJ5XqrC5x6wd5KnTJ8vKXkorfo
TMR8RStSQ5dhOa13okhJM2bjgNnEPqvps+fQd0hZaXAVMekS0ceM6hHcqHVU
JP2l7ho+FutjVYEknzqtO+SqzYgQcqOy2idCtI/CI9Sz8nHXnlhLdQ69o6gs
UD3J8IXRJ4KiiTkLOlJSdQ9TuwQtzewjyDfNZ3vdNAa1K3blCvRu4rVS6Tj9
Nvb42KIhdgVT3jrHoaPJC4uD2y9+ccA9CePQh/FWuU6cBzuEH1QVIddU0rcZ
K+x9NBcyzxpEKqDv1/LB3hheT2i3K4KufVZIXO/YkOeoFmITXmNo9wFlodcT
i6k/dQKvaoOZQOdo8CkkIM6mhxZVf5YVQfEVPEW3Mvd2l51Zrj3p12jZ1SVs
SCSw2izeC4pExU9Bkdi3RCKksgZ59U0A1pH9LK4/5aqTJJ5HUWP9fptdMAO+
7hVHlJ3OuFEewr52Wzx42NiDbe4Mj+32OvdcV30187Xt2Q49bKMTXMUwC+Ku
6vfIukqnHmys1+gscXntvpfX6LzMpOQn+ex9WKp4wjOIesqOZXxV9xZkZv9X
b2kPNEqaAjXdd/LEnexeTr/NG+arY1Xm5IlWHVqsUtlC5YP5bv4SxmcwHsEY
39nj+lMYn1BaWCrKX8vnMH4UqKXLSuOtt1VLERmdu6itMxiP8iquhPSnMD7J
yezRZ6MfDou+O+LyDGSW9T8VhLtYr3LXDzXLyEiG4lqDBXJpGw0jnytbR8N6
udZBGAULwnW6OX0SZRSM8pZ6Z+53VmAUrC6jGAUzYsEoWCVC/ihYPC1bRr9Q
/s2iXwOHRxj9qo9DW+gXdgZcNTkPMtq1OmgXnr1D91NGu2yxmR/tQgvJN26M
bnnU282iW2gVdd6n+iCjXPURaY5ykXiKZ2UxuqXZyehWgAcXh27V5SujWbNV
jGYtFs2ane/FJKNX64deTfCIVUOr/LRaNjrVm2q1cDTKkMo41PxcGIfSdNXu
MQ7FOJTyCuNQzU5lq4ZDUf2hTl9GoJaHQOFvQhh7UtLWAXvCXMToMfZUH4e2
sCcXksHYk+YXxp7kFGNPtN2MPW0G9hRaY4w9+UVkvl9YNa0sxp40O72QE1f+
3xYPNsee5slXxp5mq4QvH/j4ciP91Qx1Ovbx1wbhTdT8+uNN1DzjTYw3zZqB
D96kMkzNljua4aN57j4lqH9ZKZUuv0kKYR/1fgVxGaww8fWT5LgLY7/nDKXl
xA7Mc9s5RvWarsbhXyOt5udg2iUuf7144XlZTP7xWpnLT5+k7ufVXNwjqdRd
n1yks1uNJhUQbf0HawmgXA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{540, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->258755717]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29837],

Cell["\<\
The resultant is zero if and only if the polynomials have a common root:\
\>", "ExampleText",
 CellID->415645544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "3"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "4"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "5"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "6"}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240861899],

Cell[BoxData[
 RowBox[{"-", "8640"}]], "Output",
 ImageSize->{40, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1869557]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "3"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "4"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "5"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331006545],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->296283084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->738537184],

Cell[TextData[{
 "The polynomials have a zero resultant if and only if they have a \
nonconstant ",
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->36645106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"2", "x"}], "-", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88198790],

Cell[BoxData["16"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260118885]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"2", "x"}], "-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->197370412],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156148187]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"2", "x"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->651409364],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->765663050]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"2", "x"}], "+", "1"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->258928960],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->76931498]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->469458071],

Cell[TextData[{
 "The resultant can be represented in terms of roots as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"R", "(", 
     RowBox[{"f", ",", "g"}], ")"}], "==", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["a", "n"], "m"], 
     SuperscriptBox[
      SubscriptBox["b", "m"], "n"], 
     RowBox[{
      UnderscriptBox["\[Product]", 
       RowBox[{
        RowBox[{"1", "\[LessEqual]", "i", "\[LessEqual]", "n"}], ",", 
        RowBox[{"1", "\[LessEqual]", "j", "\[LessEqual]", "m"}]}]], 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["r", "i"], "-", 
        SubscriptBox["s", "j"]}], ")"}]}]}]}], TraditionalForm]]],
 ":"
}], "ExampleText",
 CellID->601348015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["a", "3"], 
    RowBox[{"(", 
     RowBox[{"x", "-", 
      SubscriptBox["r", "1"]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", 
      SubscriptBox["r", "2"]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", 
      SubscriptBox["r", "3"]}], ")"}]}], ",", 
   RowBox[{
    SubscriptBox["b", "2"], 
    RowBox[{"(", 
     RowBox[{"x", "-", 
      SubscriptBox["s", "1"]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", 
      SubscriptBox["s", "2"]}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140339877],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["a", "3", "2"], " ", 
  SubsuperscriptBox["b", "2", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["r", "1"], "-", 
    SubscriptBox["s", "1"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["r", "2"], "-", 
    SubscriptBox["s", "1"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["r", "3"], "-", 
    SubscriptBox["s", "1"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["r", "1"], "-", 
    SubscriptBox["s", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["r", "2"], "-", 
    SubscriptBox["s", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["r", "3"], "-", 
    SubscriptBox["s", "2"]}], ")"}]}]], "Output",
 ImageSize->{360, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->632627236]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25196393],

Cell[TextData[{
 "Equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{
       RowBox[{"n", "(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", "2"}]], 
     SubscriptBox["a", "n"], 
     RowBox[{"D", "(", "f", ")"}]}], "==", 
    RowBox[{"R", 
     RowBox[{"(", 
      RowBox[{"f", ",", 
       RowBox[{"f", "'"}]}], ")"}]}]}], TraditionalForm]]],
 " relates ",
 Cell[BoxData[
  ButtonBox["Discriminant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Discriminant"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Resultant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resultant"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->182035434],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"3", 
     RowBox[{"x", "^", "7"}]}], "-", 
    RowBox[{"5", "x"}], "+", "4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Exponent", "[", 
    RowBox[{"f", ",", "x"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->339245623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{"f", ",", 
   RowBox[{"D", "[", 
    RowBox[{"f", ",", "x"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->547246616],

Cell[BoxData["4720053663936"], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70017958]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "^", 
   RowBox[{"(", 
    RowBox[{"n", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], 
  RowBox[{"Coefficient", "[", 
   RowBox[{"f", ",", "x", ",", "n"}], "]"}], 
  RowBox[{"Discriminant", "[", 
   RowBox[{"f", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->57279941],

Cell[BoxData["4720053663936"], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->364745298]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143783185],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " can also be used to find conditions for common roots:"
}], "ExampleText",
 CellID->52418523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "a"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "b"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "c"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "d"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "e"}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->620],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{"b", "-", "c"}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "c"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"b", "-", "d"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "d"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"b", "-", "e"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "e"}], ")"}]}]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244386108]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"GroebnerBasis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "a"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"x", "-", "b"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "c"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"x", "-", "d"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"x", "-", "e"}], ")"}]}]}], "}"}], ",", "x"}], "]"}], ",", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"#", ",", "x"}], "]"}], "&"}]}], "]"}], "//", 
  "Factor"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10605398],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "c"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"b", "-", "c"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"a", "-", "d"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"b", "-", "d"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"a", "-", "e"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"b", "-", "e"}], ")"}]}], "}"}]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37671651]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53308748],

Cell[TextData[{
 "The same problem can also be solved using ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " and  ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->143233499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "a"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"x", "-", "b"}], ")"}]}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "c"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"x", "-", "d"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"x", "-", "e"}], ")"}]}], "\[Equal]", "0"}]}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27659348],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "\[Equal]", "a"}], "||", 
  RowBox[{"c", "\[Equal]", "b"}], "||", 
  RowBox[{"d", "\[Equal]", "a"}], "||", 
  RowBox[{"d", "\[Equal]", "b"}], "||", 
  RowBox[{"e", "\[Equal]", "a"}], "||", 
  RowBox[{"e", "\[Equal]", "b"}]}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82180695]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "a"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "b"}], ")"}]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "c"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "d"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "e"}], ")"}]}], "\[Equal]", "0"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216082837],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", "c"}], "||", 
  RowBox[{"a", "\[Equal]", "d"}], "||", 
  RowBox[{"a", "\[Equal]", "e"}], "||", 
  RowBox[{"b", "\[Equal]", "c"}], "||", 
  RowBox[{"b", "\[Equal]", "d"}], "||", 
  RowBox[{"b", "\[Equal]", "e"}]}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2170928]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Eliminate", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "a"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"x", "-", "b"}], ")"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "c"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"x", "-", "d"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"x", "-", "e"}], ")"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
    "x"}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32168],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "c"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "b"}], "+", "c"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"a", "-", "d"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"b", "-", "d"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"a", "-", "e"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"b", "-", "e"}], ")"}]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{295, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27675165]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9900],

Cell["The following two polynomials have no common root:", "ExampleText",
 CellID->125557288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{"x", "-", "1", "+", 
    RowBox[{"10", "^", 
     RowBox[{"(", 
      RowBox[{"-", "17"}], ")"}]}]}], ",", 
   RowBox[{"x", "-", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228730721],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", "100000000000000000"]}]], "Output",
 ImageSize->{153, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->608365664]
}, Open  ]],

Cell["\<\
Using approximate coefficients they will appear to have a common root:\
\>", "ExampleText",
 CellID->795876576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{"x", "-", "1.", "+", 
    RowBox[{"10", "^", 
     RowBox[{"(", 
      RowBox[{"-", "17"}], ")"}]}]}], ",", 
   RowBox[{"x", "-", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->629959692],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2083867]
}, Open  ]],

Cell["Using higher precision shows they have no common root:", "ExampleText",
 CellID->14906024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{"x", "-", "1`20", "+", 
    RowBox[{"10", "^", 
     RowBox[{"(", 
      RowBox[{"-", "17"}], ")"}]}]}], ",", 
   RowBox[{"x", "-", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->592591123],

Cell[BoxData[
 RowBox[{"-", "1.`3.000000000000001*^-17"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22189416]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30101],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subresultants",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subresultants"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Discriminant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Discriminant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eliminate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eliminate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19104]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17225],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->4826]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->270593407],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->42414261],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->17958644]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Resultant"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Resultant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 38.4888652}", "context" -> "System`", 
    "keywords" -> {
     "common roots in polynomials", "resultants of polynomials"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Resultant[poly_1, poly_2, var] computes the resultant of the polynomials \
poly_1 and poly_2 with respect to the variable var. Resultant[poly_1, poly_2, \
var, Modulus -> p] computes the resultant modulo the prime p. ", 
    "synonyms" -> {}, "title" -> "Resultant", "type" -> "Symbol", "uri" -> 
    "ref/Resultant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5902, 192, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->278239443]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 62403, 2253}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2297, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2920, 83, 47, 1, 70, "ObjectName",
 CellID->18578],
Cell[2970, 86, 1811, 59, 70, "Usage",
 CellID->20313]
}, Open  ]],
Cell[CellGroupData[{
Cell[4818, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5296, 167, 569, 20, 70, "Notes",
 CellID->2650]
}, Closed]],
Cell[CellGroupData[{
Cell[5902, 192, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->278239443],
Cell[CellGroupData[{
Cell[6287, 206, 148, 5, 70, "ExampleSection",
 CellID->131606433],
Cell[6438, 213, 120, 3, 70, "ExampleText",
 CellID->22729],
Cell[CellGroupData[{
Cell[6583, 220, 431, 16, 28, "Input",
 CellID->7238],
Cell[7017, 238, 581, 22, 36, "Output",
 CellID->1734921]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7647, 266, 215, 7, 70, "ExampleSection",
 CellID->3468],
Cell[7865, 275, 94, 1, 70, "ExampleText",
 CellID->571022051],
Cell[CellGroupData[{
Cell[7984, 280, 278, 10, 70, "Input",
 CellID->158217380],
Cell[8265, 292, 158, 5, 36, "Output",
 CellID->4942272]
}, Open  ]],
Cell[8438, 300, 124, 3, 70, "ExampleDelimiter",
 CellID->18803302],
Cell[8565, 305, 97, 1, 70, "ExampleText",
 CellID->657821953],
Cell[CellGroupData[{
Cell[8687, 310, 566, 21, 70, "Input",
 CellID->467347150],
Cell[9256, 333, 1393, 44, 54, "Output",
 CellID->75243147]
}, Open  ]],
Cell[10664, 380, 125, 3, 70, "ExampleDelimiter",
 CellID->259850701],
Cell[10792, 385, 76, 1, 70, "ExampleText",
 CellID->551921929],
Cell[CellGroupData[{
Cell[10893, 390, 322, 10, 70, "Input",
 CellID->895543351],
Cell[11218, 402, 157, 5, 36, "Output",
 CellID->25664304]
}, Open  ]],
Cell[11390, 410, 124, 3, 70, "ExampleDelimiter",
 CellID->78990641],
Cell[11517, 415, 90, 1, 70, "ExampleText",
 CellID->29247],
Cell[CellGroupData[{
Cell[11632, 420, 486, 18, 70, "Input",
 CellID->10543],
Cell[12121, 440, 670, 25, 36, "Output",
 CellID->437473186]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12840, 471, 239, 7, 70, "ExampleSection",
 CellID->32457],
Cell[13082, 480, 134, 4, 70, "ExampleText",
 CellID->221250015],
Cell[13219, 486, 579, 22, 70, "Input",
 CellID->456253729],
Cell[CellGroupData[{
Cell[13823, 512, 357, 13, 70, "Input",
 CellID->167581085],
Cell[14183, 527, 188, 5, 36, "Output",
 CellID->7201166]
}, Open  ]],
Cell[CellGroupData[{
Cell[14408, 537, 693, 23, 70, "Input",
 CellID->167342213],
Cell[15104, 562, 190, 5, 36, "Output",
 CellID->544664239]
}, Open  ]],
Cell[CellGroupData[{
Cell[15331, 572, 101, 3, 70, "Input",
 CellID->421779290],
Cell[15435, 577, 161, 5, 36, "Output",
 CellID->674582916]
}, Open  ]],
Cell[CellGroupData[{
Cell[15633, 587, 340, 12, 70, "Input",
 CellID->301348124],
Cell[15976, 601, 190, 6, 51, "Output",
 CellID->395007392]
}, Open  ]],
Cell[CellGroupData[{
Cell[16203, 612, 733, 25, 70, "Input",
 CellID->130044316],
Cell[16939, 639, 189, 6, 51, "Output",
 CellID->48625105]
}, Open  ]],
Cell[CellGroupData[{
Cell[17165, 650, 100, 3, 70, "Input",
 CellID->84865543],
Cell[17268, 655, 161, 5, 36, "Output",
 CellID->691750723]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17478, 666, 218, 7, 70, "ExampleSection",
 CellID->20611],
Cell[CellGroupData[{
Cell[17721, 677, 223, 7, 70, "ExampleSubsection",
 CellID->10673],
Cell[17947, 686, 123, 3, 70, "ExampleText",
 CellID->178377156],
Cell[CellGroupData[{
Cell[18095, 693, 871, 27, 70, "Input",
 CellID->130170461],
Cell[18969, 722, 2392, 58, 96, "Output",
 CellID->314367192]
}, Open  ]],
Cell[CellGroupData[{
Cell[21398, 785, 1072, 33, 70, "Input",
 CellID->95396236],
Cell[22473, 820, 2181, 40, 70, "Output",
 Evaluatable->False,
 CellID->354321632]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24703, 866, 224, 7, 70, "ExampleSubsection",
 CellID->20997],
Cell[24930, 875, 114, 3, 70, "ExampleText",
 CellID->133742431],
Cell[CellGroupData[{
Cell[25069, 882, 475, 16, 70, "Input",
 CellID->2515],
Cell[25547, 900, 2395, 74, 71, "Output",
 CellID->274333141]
}, Open  ]],
Cell[27957, 977, 125, 3, 70, "ExampleDelimiter",
 CellID->180435940],
Cell[28085, 982, 122, 3, 70, "ExampleText",
 CellID->3114652],
Cell[CellGroupData[{
Cell[28232, 989, 517, 17, 70, "Input",
 CellID->23740],
Cell[28752, 1008, 1109, 22, 70, "Output",
 Evaluatable->False,
 CellID->31668321]
}, Open  ]],
Cell[29876, 1033, 125, 3, 70, "ExampleDelimiter",
 CellID->243356014],
Cell[30004, 1038, 120, 3, 70, "ExampleText",
 CellID->19707],
Cell[CellGroupData[{
Cell[30149, 1045, 517, 17, 70, "Input",
 CellID->18445],
Cell[30669, 1064, 1940, 36, 70, "Output",
 Evaluatable->False,
 CellID->230977613]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[32670, 1107, 222, 7, 70, "ExampleSection",
 CellID->8349],
Cell[32895, 1116, 92, 1, 70, "ExampleText",
 CellID->591123552],
Cell[CellGroupData[{
Cell[33012, 1121, 409, 14, 70, "Input",
 CellID->308727008],
Cell[33424, 1137, 179, 6, 36, "Output",
 CellID->601834061]
}, Open  ]],
Cell[CellGroupData[{
Cell[33640, 1148, 403, 14, 70, "Input",
 CellID->543446760],
Cell[34046, 1164, 158, 5, 36, "Output",
 CellID->316019870]
}, Open  ]],
Cell[CellGroupData[{
Cell[34241, 1174, 409, 14, 70, "Input",
 CellID->56784027],
Cell[34653, 1190, 158, 5, 36, "Output",
 CellID->374564846]
}, Open  ]],
Cell[CellGroupData[{
Cell[34848, 1200, 404, 14, 70, "Input",
 CellID->839744023],
Cell[35255, 1216, 180, 6, 36, "Output",
 CellID->446223157]
}, Open  ]],
Cell[35450, 1225, 124, 3, 70, "ExampleDelimiter",
 CellID->67755956],
Cell[35577, 1230, 102, 2, 70, "ExampleText",
 CellID->228807574],
Cell[CellGroupData[{
Cell[35704, 1236, 522, 17, 70, "Input",
 CellID->355447784],
Cell[36229, 1255, 1215, 41, 58, "Output",
 CellID->3920796]
}, Open  ]],
Cell[CellGroupData[{
Cell[37481, 1301, 719, 23, 70, "Input",
 CellID->79086758],
Cell[38203, 1326, 1883, 35, 70, "Output",
 Evaluatable->False,
 CellID->258755717]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40135, 1367, 233, 7, 70, "ExampleSection",
 CellID->29837],
Cell[40371, 1376, 123, 3, 70, "ExampleText",
 CellID->415645544],
Cell[CellGroupData[{
Cell[40519, 1383, 492, 18, 70, "Input",
 CellID->240861899],
Cell[41014, 1403, 176, 6, 36, "Output",
 CellID->1869557]
}, Open  ]],
Cell[CellGroupData[{
Cell[41227, 1414, 492, 18, 70, "Input",
 CellID->331006545],
Cell[41722, 1434, 158, 5, 36, "Output",
 CellID->296283084]
}, Open  ]],
Cell[41895, 1442, 125, 3, 70, "ExampleDelimiter",
 CellID->738537184],
Cell[42023, 1447, 271, 9, 70, "ExampleText",
 CellID->36645106],
Cell[CellGroupData[{
Cell[42319, 1460, 321, 11, 70, "Input",
 CellID->88198790],
Cell[42643, 1473, 159, 5, 36, "Output",
 CellID->260118885]
}, Open  ]],
Cell[CellGroupData[{
Cell[42839, 1483, 316, 11, 70, "Input",
 CellID->197370412],
Cell[43158, 1496, 158, 5, 36, "Output",
 CellID->156148187]
}, Open  ]],
Cell[CellGroupData[{
Cell[43353, 1506, 322, 11, 70, "Input",
 CellID->651409364],
Cell[43678, 1519, 158, 5, 36, "Output",
 CellID->765663050]
}, Open  ]],
Cell[CellGroupData[{
Cell[43873, 1529, 316, 11, 70, "Input",
 CellID->258928960],
Cell[44192, 1542, 213, 7, 36, "Output",
 CellID->76931498]
}, Open  ]],
Cell[44420, 1552, 125, 3, 70, "ExampleDelimiter",
 CellID->469458071],
Cell[44548, 1557, 699, 23, 70, "ExampleText",
 CellID->601348015],
Cell[CellGroupData[{
Cell[45272, 1584, 624, 23, 70, "Input",
 CellID->140339877],
Cell[45899, 1609, 875, 32, 36, "Output",
 CellID->632627236]
}, Open  ]],
Cell[46789, 1644, 124, 3, 70, "ExampleDelimiter",
 CellID->25196393],
Cell[46916, 1649, 763, 30, 70, "ExampleText",
 CellID->182035434],
Cell[47682, 1681, 341, 12, 70, "Input",
 CellID->339245623],
Cell[CellGroupData[{
Cell[48048, 1697, 192, 6, 70, "Input",
 CellID->547246616],
Cell[48243, 1705, 170, 5, 36, "Output",
 CellID->70017958]
}, Open  ]],
Cell[CellGroupData[{
Cell[48450, 1715, 423, 15, 70, "Input",
 CellID->57279941],
Cell[48876, 1732, 171, 5, 36, "Output",
 CellID->364745298]
}, Open  ]],
Cell[49062, 1740, 125, 3, 70, "ExampleDelimiter",
 CellID->143783185],
Cell[49190, 1745, 240, 7, 70, "ExampleText",
 CellID->52418523],
Cell[CellGroupData[{
Cell[49455, 1756, 430, 16, 70, "Input",
 CellID->620],
Cell[49888, 1774, 583, 22, 36, "Output",
 CellID->244386108]
}, Open  ]],
Cell[CellGroupData[{
Cell[50508, 1801, 720, 25, 70, "Input",
 CellID->10605398],
Cell[51231, 1828, 537, 19, 36, "Output",
 CellID->37671651]
}, Open  ]],
Cell[51783, 1850, 124, 3, 70, "ExampleDelimiter",
 CellID->53308748],
Cell[51910, 1855, 477, 18, 70, "ExampleText",
 CellID->143233499],
Cell[CellGroupData[{
Cell[52412, 1877, 710, 25, 70, "Input",
 CellID->27659348],
Cell[53125, 1904, 405, 12, 36, "Output",
 CellID->82180695]
}, Open  ]],
Cell[CellGroupData[{
Cell[53567, 1921, 589, 21, 70, "Input",
 CellID->216082837],
Cell[54159, 1944, 404, 12, 36, "Output",
 CellID->2170928]
}, Open  ]],
Cell[CellGroupData[{
Cell[54600, 1961, 626, 22, 70, "Input",
 CellID->32168],
Cell[55229, 1985, 565, 20, 36, "Output",
 CellID->27675165]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55843, 2011, 225, 7, 70, "ExampleSection",
 CellID->9900],
Cell[56071, 2020, 93, 1, 70, "ExampleText",
 CellID->125557288],
Cell[CellGroupData[{
Cell[56189, 2025, 271, 9, 70, "Input",
 CellID->228730721],
Cell[56463, 2036, 214, 7, 51, "Output",
 CellID->608365664]
}, Open  ]],
Cell[56692, 2046, 121, 3, 70, "ExampleText",
 CellID->795876576],
Cell[CellGroupData[{
Cell[56838, 2053, 272, 9, 70, "Input",
 CellID->629959692],
Cell[57113, 2064, 158, 5, 36, "Output",
 CellID->2083867]
}, Open  ]],
Cell[57286, 2072, 96, 1, 70, "ExampleText",
 CellID->14906024],
Cell[CellGroupData[{
Cell[57407, 2077, 274, 9, 70, "Input",
 CellID->592591123],
Cell[57684, 2088, 198, 6, 36, "Output",
 CellID->22189416]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57943, 2101, 311, 9, 70, "SeeAlsoSection",
 CellID->30101],
Cell[58257, 2112, 971, 35, 70, "SeeAlso",
 CellID->19104]
}, Open  ]],
Cell[CellGroupData[{
Cell[59265, 2152, 314, 9, 70, "TutorialsSection",
 CellID->17225],
Cell[59582, 2163, 179, 4, 70, "Tutorials",
 CellID->4826]
}, Open  ]],
Cell[CellGroupData[{
Cell[59798, 2172, 319, 9, 70, "MoreAboutSection",
 CellID->270593407],
Cell[60120, 2183, 146, 3, 70, "MoreAbout",
 CellID->42414261],
Cell[60269, 2188, 146, 3, 70, "MoreAbout",
 CellID->17958644]
}, Open  ]],
Cell[CellGroupData[{
Cell[60452, 2196, 305, 8, 70, "RelatedLinksSection"],
Cell[60760, 2206, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[61162, 2222, 27, 0, 70, "History"],
Cell[61192, 2224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

