(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11868,        423]
NotebookOptionsPosition[      8651,        317]
NotebookOutlinePosition[      9953,        354]
CellTagsIndexPosition[      9869,        349]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EvaluatePacket" :> 
          Documentation`HelpLookup["paclet:ref/EvaluatePacket"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EvaluatePacket\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink Mathematica Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkMathematicaFunctions"], "MathLink Packets" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkPackets"], 
          "Parallel & Grid Computing" :> 
          Documentation`HelpLookup[
           "paclet:guide/ParallelAndGridComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MathLink Mathematica Functions\"\>", 
       2->"\<\"MathLink Packets\"\>", 
       3->"\<\"Parallel & Grid Computing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReturnPacket", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ReturnPacket",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ReturnPacket"], "[", "expr", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packet that contains the expression ",
     StyleBox["expr", "TI"],
     ", the result of an ",
     Cell[BoxData[
      ButtonBox["EvaluatePacket",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFormula"],
     " evaluation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->245899584],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process: "
}], "ExampleText",
 CellID->166775284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320545019],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "717", ",", "9"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->833122701]
}, Open  ]],

Cell["Read the first packet:", "ExampleText",
 CellID->132987931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1944338714],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->361348026]
}, Open  ]],

Cell[TextData[{
 "Write the expression ",
 Cell[BoxData[
  RowBox[{"2", "+", "2"}]], "InlineFormula"],
 " to the link without evaluating it:"
}], "ExampleText",
 CellID->1412893454],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"2", "+", "2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->677592424],

Cell[TextData[{
 "The result is a ",
 Cell[BoxData[
  ButtonBox["ReturnPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReturnPacket"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->1678227575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2137264733],

Cell[BoxData[
 RowBox[{"ReturnPacket", "[", "22178066152632447507", "]"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->155980362]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->17546490],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[BoxData[Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"],
   FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["MathLink Mathematica Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], "MoreAbout",
 CellID->265853077],

Cell[TextData[ButtonBox["MathLink Packets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkPackets"]], "MoreAbout",
 CellID->520452486],

Cell[TextData[ButtonBox["Parallel & Grid Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "MoreAbout",
 CellID->238018367]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReturnPacket - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 16, 42.5514692}", "context" -> "System`", 
    "keywords" -> {"evaluation packet", "return packet"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ReturnPacket[expr] is a MathLink packet that contains the expression \
expr, the result of an EvaluatePacket evaluation.", 
    "synonyms" -> {"return packet"}, "title" -> "ReturnPacket", "type" -> 
    "Symbol", "uri" -> "ref/ReturnPacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3665, 114, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9734, 342}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2176, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2799, 81, 55, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2857, 84, 771, 25, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3665, 114, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4042, 128, 148, 5, 70, "ExampleSection",
 CellID->245899584],
Cell[4193, 135, 149, 6, 70, "ExampleText",
 CellID->166775284],
Cell[CellGroupData[{
Cell[4367, 145, 234, 7, 28, "Input",
 CellID->320545019],
Cell[4604, 154, 260, 8, 36, "Output",
 CellID->833122701]
}, Open  ]],
Cell[4879, 165, 65, 1, 70, "ExampleText",
 CellID->132987931],
Cell[CellGroupData[{
Cell[4969, 170, 108, 3, 28, "Input",
 CellID->1944338714],
Cell[5080, 175, 215, 6, 36, "Output",
 CellID->361348026]
}, Open  ]],
Cell[5310, 184, 181, 6, 70, "ExampleText",
 CellID->1412893454],
Cell[5494, 192, 195, 6, 70, "Input",
 CellID->677592424],
Cell[5692, 200, 219, 8, 70, "ExampleText",
 CellID->1678227575],
Cell[CellGroupData[{
Cell[5936, 212, 108, 3, 70, "Input",
 CellID->2137264733],
Cell[6047, 217, 216, 6, 36, "Output",
 CellID->155980362]
}, Open  ]],
Cell[6278, 226, 57, 1, 70, "ExampleText",
 CellID->17546490],
Cell[6338, 229, 109, 3, 70, "Input",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6496, 238, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[6815, 249, 216, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7068, 260, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7389, 271, 371, 11, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[7797, 287, 299, 8, 70, "MoreAboutSection"],
Cell[8099, 297, 170, 3, 70, "MoreAbout",
 CellID->265853077],
Cell[8272, 302, 143, 3, 70, "MoreAbout",
 CellID->520452486],
Cell[8418, 307, 161, 3, 70, "MoreAbout",
 CellID->238018367]
}, Open  ]],
Cell[8594, 313, 27, 0, 70, "History"],
Cell[8624, 315, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

