(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    118558,       2716]
NotebookOptionsPosition[    110965,       2471]
NotebookOutlinePosition[    112643,       2516]
CellTagsIndexPosition[    112505,       2510]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RiemannSiegelZ" :> 
          Documentation`HelpLookup["paclet:ref/RiemannSiegelZ"], "Zeta" :> 
          Documentation`HelpLookup["paclet:ref/Zeta"], "RamanujanTauTheta" :> 
          Documentation`HelpLookup["paclet:ref/RamanujanTauTheta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RiemannSiegelZ\"\>", 
       2->"\<\"Zeta\"\>", 3->"\<\"RamanujanTauTheta\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"], 
          "Zeta Functions & Polylogarithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/ZetaFunctionsAndPolylogarithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Number Theoretic Functions\"\>", 
       2->"\<\"Prime Numbers\"\>", 
       3->"\<\"Zeta Functions & Polylogarithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RiemannSiegelTheta", "ObjectName",
 CellID->4760],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RiemannSiegelTheta",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RiemannSiegelTheta"], "[", 
       StyleBox["t", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Riemann\[Hyphen]Siegel function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[CurlyTheta]", "(", "t", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14090]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CurlyTheta]", "(", "t", ")"}], "=", 
    RowBox[{"Im", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"log", " ", "\[CapitalGamma]", " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "4"], "+", " ", 
          RowBox[{"i", 
           FractionBox["t", "2"]}]}], ")"}]}], "-", 
       FractionBox[
        RowBox[{"t", " ", "log", " ", "\[Pi]"}], "2"]}], ")"}]}]}], 
   TraditionalForm]], "InlineMath"],
 " for real ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->31612],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CurlyTheta]", "(", "t", ")"}], TraditionalForm]], 
  "InlineMath"],
 " arises in the study of the Riemann zeta function on the critical line. It \
is closely related to the number of zeros of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Zeta]", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], "+", 
      RowBox[{"i", " ", "u"}]}], ")"}]}], TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "<", "u", "<", "t"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->3259],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CurlyTheta]", "(", "t", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is an analytic function of ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " except for branch cuts on the imaginary axis running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PlusMinus]", 
    FractionBox["i", "2"]}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[PlusMinus]", "i"}], " ", "\[Infinity]"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->31113],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["RiemannSiegelTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RiemannSiegelTheta"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->55837624],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RiemannSiegelTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RiemannSiegelTheta"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RiemannSiegelTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RiemannSiegelTheta"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36836079],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->194102816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"RiemannSiegelTheta", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "50"}], ",", "50"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{218, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173186203]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion at infinity:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"RiemannSiegelTheta", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "Infinity", ",", "6"}], "}"}]}], "]"}], " "}]], "Input",\

 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"Log", "[", "2", "]"}], "-", 
     RowBox[{"Log", "[", "\[Pi]", "]"}], "-", 
     RowBox[{"Log", "[", 
      FractionBox["1", "t"], "]"}]}], 
    FractionBox["2", "t"]], "-", 
   FractionBox["\[Pi]", "8"], "+", 
   FractionBox["1", 
    RowBox[{"48", " ", "t"}]], "+", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", "t"], ")"}], "3"]}], "5760"], "+", 
   FractionBox[
    RowBox[{"31", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", "t"], ")"}], "5"]}], "80640"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "t"], "]"}], "7"],
    SeriesData[$CellContext`t, 
     DirectedInfinity[1], {}, -1, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`t, 
   DirectedInfinity[1], {
   Rational[1, 2] (-1 - Log[2] - Log[Pi] - Log[$CellContext`t^(-1)]), 
    Rational[-1, 8] Pi, 
    Rational[1, 48], 0, 
    Rational[7, 5760], 0, 
    Rational[31, 80640]}, -1, 7, 1],
  Editable->False]], "Output",
 ImageSize->{427, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->389235905]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Evaluate for complex arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannSiegelTheta", "[", 
  RowBox[{"2.5", "+", 
   RowBox[{"2.4", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3.300072782223255`"}], "-", 
  RowBox[{"0.9621368365307732`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152697911]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate to high precision:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"RiemannSiegelTheta", "[", "10", "]"}], ",", "50"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  "3.0670743962898952917020135348094859759880681141917325211913435118699`50."}\
]], "Output",
 ImageSize->{369, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2955053]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannSiegelTheta", "[", "10.0000000000000000000", "]"}]], "Input",\

 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", "3.06707439628989529170201353389`18.96281615167311"}]], "Output",\

 ImageSize->{152, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100565960]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RiemannSiegelTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RiemannSiegelTheta"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannSiegelTheta", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.9562175578521241`"}], ",", 
   RowBox[{"-", "2.19819085737941`"}], ",", 
   RowBox[{"-", "2.404219376891251`"}]}], "}"}]], "Output",
 ImageSize->{211, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->286301583]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40294281],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->473252925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannSiegelTheta", "[", "t", "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195293287],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox["\[CurlyTheta]",
    RiemannSiegelTheta], "(", "t", ")"}], TraditionalForm]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->558714861]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Series expansion at the origin:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"RiemannSiegelTheta", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Log", "[", "\[Pi]", "]"}]}], "+", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        FractionBox["1", "4"]}], "]"}]}], ")"}], " ", "t"}], "-", 
   RowBox[{
    FractionBox["1", "48"], " ", 
    RowBox[{"PolyGamma", "[", 
     RowBox[{"2", ",", 
      FractionBox["1", "4"]}], "]"}], " ", 
    SuperscriptBox["t", "3"]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"PolyGamma", "[", 
      RowBox[{"4", ",", 
       FractionBox["1", "4"]}], "]"}], " ", 
     SuperscriptBox["t", "5"]}], "3840"], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"PolyGamma", "[", 
      RowBox[{"6", ",", 
       FractionBox["1", "4"]}], "]"}], " ", 
     SuperscriptBox["t", "7"]}], "645120"], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"PolyGamma", "[", 
      RowBox[{"8", ",", 
       FractionBox["1", "4"]}], "]"}], " ", 
     SuperscriptBox["t", "9"]}], "185794560"], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"PolyGamma", "[", 
      RowBox[{"10", ",", 
       FractionBox["1", "4"]}], "]"}], " ", 
     SuperscriptBox["t", "11"]}], "81749606400"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "t", "]"}], "13"],
    SeriesData[$CellContext`t, 0, {}, 1, 13, 1],
    Editable->False]}],
  SeriesData[$CellContext`t, 0, {Rational[1, 2] (-Log[Pi] + PolyGamma[0, 
       Rational[1, 4]]), 0, Rational[-1, 48] PolyGamma[2, 
      Rational[1, 4]], 0, Rational[1, 3840] PolyGamma[4, 
      Rational[1, 4]], 0, Rational[-1, 645120] PolyGamma[6, 
      Rational[1, 4]], 0, Rational[1, 185794560] PolyGamma[8, 
      Rational[1, 4]], 0, Rational[-1, 81749606400] PolyGamma[10, 
      Rational[1, 4]]}, 1, 13, 1],
  Editable->False]], "Output",
 ImageSize->{515, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->567881287]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion at a branch point:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"RiemannSiegelTheta", "[", "z", "]"}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"I", "/", "2"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[Pi]"}], " ", 
   RowBox[{"Floor", "[", 
    FractionBox[
     RowBox[{
      FractionBox["\[Pi]", "2"], "-", 
      RowBox[{"Arg", "[", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", 
        RowBox[{"2", " ", "z"}]}], "]"}]}], 
     RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "-", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"Log", "[", "2", "]"}]}], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["\[ImaginaryI]", "2"]}], "+", "z"}], "]"}]}]}], 
       ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "EulerGamma"}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"Log", "[", "\[Pi]", "]"}]}], "+", 
        RowBox[{"PolyGamma", "[", 
         RowBox[{"0", ",", 
          FractionBox["1", "2"]}], "]"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"z", "-", 
        FractionBox["\[ImaginaryI]", "2"]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "48"]}], " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", 
         FractionBox["\[ImaginaryI]", "2"]}], ")"}], "2"]}], "+", 
     RowBox[{
      FractionBox["1", "96"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"PolyGamma", "[", 
          RowBox[{"2", ",", 
           FractionBox["1", "2"]}], "]"}]}], "-", 
        RowBox[{"PolyGamma", "[", 
         RowBox[{"2", ",", "1"}], "]"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", 
         FractionBox["\[ImaginaryI]", "2"]}], ")"}], "3"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"z", "-", 
         FractionBox["\[ImaginaryI]", "2"]}], "]"}], "4"],
      SeriesData[$CellContext`z, 
       Complex[0, 
        Rational[1, 2]], {}, 0, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     Complex[0, 
      Rational[1, 2]], {
     Rational[1, 4] (-Pi + Complex[0, -2] Log[2] + 
       Complex[0, 2] Log[Complex[0, 
            Rational[-1, 2]] + $CellContext`z]), 
      Rational[1, 4] (-EulerGamma - 2 Log[Pi] + PolyGamma[0, 
         Rational[1, 2]]), Complex[0, 
        Rational[-1, 48]] Pi^2, Rational[1, 96] (-PolyGamma[2, 
          Rational[1, 2]] - PolyGamma[2, 1])}, 0, 4, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{495, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->327491768]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Plot real and imaginary parts over the complex plane: ", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"RiemannSiegelTheta", "[", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", 
       RowBox[{"-", "10"}], ",", " ", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Im", "[", 
      RowBox[{"RiemannSiegelTheta", "[", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", 
       RowBox[{"-", "10"}], ",", " ", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142016382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Show interlacing of the roots of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", 
   RowBox[{"RiemannSiegelTheta", "[", "t", "]"}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RiemannSiegelZ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RiemannSiegelZ"], "[", "t", "]"}]], 
  "InlineFormula"],
 "."
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"RiemannSiegelTheta", "[", "t", "]"}], "]"}], ",", 
     RowBox[{"RiemannSiegelZ", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "80"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{252, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54602739]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Numerically find a root of a transcendental equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"RiemannSiegelTheta", "[", "x", "]"}], "+", " ", 
     RowBox[{"RiemannSiegelTheta", "[", 
      RowBox[{"x", "+", "1"}], "]"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "18.274525610203355`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113074245]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"RiemannSiegelTheta", "[", 
     RowBox[{
      RowBox[{"10", "^", "5"}], "-", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "50"}]}], " ", "I"}]}], "]"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(Im[\\(\\(RiemannSiegelTheta[\\(\\(100000 - \
\[ImaginaryI]\\/\\(1000000000000000000 \\(\\(\[LeftSkeleton] 12 \
\[RightSkeleton]\\)\\) 00000000000000000000\\)\\)\\)]\\)\\)]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->257788541],

Cell[BoxData[
 RowBox[{"-", 
  "4.837524199278358134931279109`15.038466440631248*^-50"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384565274]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Im", "[", 
      RowBox[{"RiemannSiegelTheta", "[", 
       RowBox[{
        RowBox[{"10", "^", "5"}], "-", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "50"}]}], " ", "I"}]}], "]"}], "]"}], ",", "20"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"-", 
  "4.83752419927835813493127910863862429`19.999999999999996*^-50"}]], "Output",\

 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->274742820]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Machine-number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannSiegelTheta", "[", 
  RowBox[{"100", "^", 
   RowBox[{"-", "200."}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  "2.686091709612714072081786`12.985898214709117*^-400"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167396758]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48682097]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Riemann surface of ",
 Cell[BoxData[
  ButtonBox["RiemannSiegelTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RiemannSiegelTheta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", "=", 
     RowBox[{"10", "^", 
      RowBox[{"-", "8"}]}]}], "}"}], ",", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Plot3D", "[", 
        RowBox[{
         RowBox[{"Re", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"Log", "[", "Pi", "]"}]}], "/", "2"}], 
            RowBox[{"(", 
             RowBox[{"x", "+", 
              RowBox[{"I", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"I", "/", "2"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"LogGamma", "[", 
               RowBox[{
                RowBox[{"1", "/", "4"}], "+", 
                RowBox[{"I", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"x", "+", 
                    RowBox[{"I", " ", "y"}]}], ")"}], "/", "2"}]}]}], "]"}], 
              "-", 
              RowBox[{"LogGamma", "[", 
               RowBox[{
                RowBox[{"1", "/", "4"}], "-", 
                RowBox[{"I", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"x", "+", 
                    RowBox[{"I", " ", "y"}]}], ")"}], "/", "2"}]}]}], "]"}], 
              "+", 
              RowBox[{"2", " ", "Pi", " ", "I", " ", 
               RowBox[{"(", 
                RowBox[{"k1", "-", "k2"}], ")"}]}]}], ")"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"i", "+", "\[Epsilon]"}], ",", 
           RowBox[{"i", "+", "1", "-", "\[Epsilon]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"j", "+", "\[Epsilon]"}], ",", 
           RowBox[{"j", "+", "1", "-", "\[Epsilon]"}]}], "}"}], ",", 
         RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
         RowBox[{"BoundaryStyle", "\[Rule]", "None"}], ",", 
         RowBox[{"PlotPoints", "\[Rule]", "4"}], ",", 
         RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"RGBColor", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k1", "+", "1"}], ")"}], "/", "2"}], ",", "0", ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k2", "+", "1"}], ")"}], "/", "2"}]}], "]"}], 
           "}"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k1", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k2", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"-", "3"}], ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"BoxRatios", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{211, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222786492]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29891],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RiemannSiegelZ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RiemannSiegelZ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Zeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Zeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RamanujanTauTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RamanujanTauTheta"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20576]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17070],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->9471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->16255],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Riemann-SiegelFunctions.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ZetaFunctionsandPolylogarithms/\
RiemannSiegelTheta/"], None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->349645405],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->641166947],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->315460357],

Cell[TextData[ButtonBox["Zeta Functions & Polylogarithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ZetaFunctionsAndPolylogarithms"]], "MoreAbout",
 CellID->54844299]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RiemannSiegelTheta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 17, 36.0997150}", "context" -> "System`", 
    "keywords" -> {"Riemann-Siegel theta", "Riemann Siegel theta"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RiemannSiegelTheta[t] gives the Riemann-Siegel function \
\\[CurlyTheta](t). ", "synonyms" -> {"riemann siegel theta"}, "title" -> 
    "RiemannSiegelTheta", "type" -> "Symbol", "uri" -> 
    "ref/RiemannSiegelTheta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6813, 233, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->36836079]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[21844, 737, 122, 1, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"],
  Cell[62924, 1437, 483, 17, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"],
  Cell[81348, 1866, 247, 8, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 112040, 2496},
 {"XRef-2005-4-26-23-37-1.8558342", 112196, 2500}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2300, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2923, 82, 55, 1, 70, "ObjectName",
 CellID->4760],
Cell[2981, 85, 639, 20, 70, "Usage",
 CellID->14090]
}, Open  ]],
Cell[CellGroupData[{
Cell[3657, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4135, 127, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4258, 133, 611, 22, 70, "Notes",
 CellID->31612],
Cell[4872, 157, 589, 20, 70, "Notes",
 CellID->3259],
Cell[5464, 179, 577, 21, 70, "Notes",
 CellID->31113],
Cell[6044, 202, 267, 8, 70, "Notes",
 CellID->55837624],
Cell[6314, 212, 238, 7, 70, "Notes",
 CellID->31226],
Cell[6555, 221, 221, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6813, 233, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36836079],
Cell[CellGroupData[{
Cell[7197, 247, 148, 5, 70, "ExampleSection",
 CellID->194102816],
Cell[CellGroupData[{
Cell[7370, 256, 231, 7, 28, "Input"],
Cell[7604, 265, 2811, 50, 156, "Output",
 Evaluatable->False,
 CellID->173186203]
}, Open  ]],
Cell[10430, 318, 105, 2, 70, "ExampleDelimiter"],
Cell[10538, 322, 52, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[10615, 326, 241, 8, 70, "Input"],
Cell[10859, 336, 1277, 43, 69, "Output",
 CellID->389235905]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12185, 385, 200, 6, 70, "ExampleSection"],
Cell[12388, 393, 54, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12467, 397, 140, 4, 70, "Input"],
Cell[12610, 403, 269, 8, 36, "Output",
 CellID->152697911]
}, Open  ]],
Cell[12894, 414, 105, 2, 70, "ExampleDelimiter"],
Cell[13002, 418, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13077, 422, 151, 5, 70, "Input"],
Cell[13231, 429, 251, 8, 36, "Output",
 CellID->2955053]
}, Open  ]],
Cell[13497, 440, 105, 2, 70, "ExampleDelimiter"],
Cell[13605, 444, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13723, 450, 117, 3, 70, "Input"],
Cell[13843, 455, 226, 7, 36, "Output",
 CellID->100565960]
}, Open  ]],
Cell[14084, 465, 105, 2, 70, "ExampleDelimiter"],
Cell[14192, 469, 210, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14427, 479, 157, 4, 70, "Input"],
Cell[14587, 485, 322, 10, 36, "Output",
 CellID->286301583]
}, Open  ]],
Cell[14924, 498, 124, 3, 70, "ExampleDelimiter",
 CellID->40294281],
Cell[15051, 503, 203, 7, 70, "ExampleText",
 CellID->473252925],
Cell[CellGroupData[{
Cell[15279, 514, 155, 5, 70, "Input",
 CellID->195293287],
Cell[15437, 521, 279, 9, 50, "Output",
 CellID->558714861]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15765, 536, 223, 6, 70, "ExampleSection"],
Cell[15991, 544, 54, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16070, 548, 211, 6, 70, "Input"],
Cell[16284, 556, 1969, 59, 97, "Output",
 CellID->567881287]
}, Open  ]],
Cell[18268, 618, 105, 2, 70, "ExampleDelimiter"],
Cell[18376, 622, 58, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[18459, 626, 241, 7, 70, "Input"],
Cell[18703, 635, 2882, 88, 121, "Output",
 CellID->327491768]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21634, 729, 207, 6, 70, "ExampleSection"],
Cell[21844, 737, 122, 1, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[21991, 742, 908, 28, 70, "Input"],
Cell[22902, 772, 39899, 658, 70, "Output",
 Evaluatable->False,
 CellID->142016382]
}, Open  ]],
Cell[62816, 1433, 105, 2, 70, "ExampleDelimiter"],
Cell[62924, 1437, 483, 17, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[63432, 1458, 338, 10, 70, "Input"],
Cell[63773, 1470, 13078, 218, 70, "Output",
 Evaluatable->False,
 CellID->54602739]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76900, 1694, 217, 6, 70, "ExampleSection"],
Cell[77120, 1702, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[77221, 1706, 341, 10, 70, "Input"],
Cell[77565, 1718, 227, 7, 36, "Output",
 CellID->113074245]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[77841, 1731, 210, 6, 70, "ExampleSection"],
Cell[78054, 1739, 226, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[78305, 1750, 316, 11, 70, "Input"],
Cell[78624, 1763, 586, 10, 70, "Message",
 CellID->257788541],
Cell[79213, 1775, 231, 7, 36, "Output",
 CellID->384565274]
}, Open  ]],
Cell[CellGroupData[{
Cell[79481, 1787, 458, 15, 70, "Input"],
Cell[79942, 1804, 241, 8, 36, "Output",
 CellID->274742820]
}, Open  ]],
Cell[80198, 1815, 105, 2, 70, "ExampleDelimiter"],
Cell[80306, 1819, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[80424, 1825, 141, 4, 70, "Input"],
Cell[80568, 1831, 229, 7, 36, "Output",
 CellID->167396758]
}, Open  ]],
Cell[CellGroupData[{
Cell[80834, 1843, 90, 2, 70, "Input"],
Cell[80927, 1847, 161, 5, 36, "Output",
 CellID->48682097]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[81137, 1858, 208, 6, 70, "ExampleSection"],
Cell[81348, 1866, 247, 8, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[81620, 1878, 3130, 86, 70, "Input"],
Cell[84753, 1966, 22937, 380, 70, "Output",
 Evaluatable->False,
 CellID->222786492]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107751, 2353, 311, 9, 70, "SeeAlsoSection",
 CellID->29891],
Cell[108065, 2364, 718, 26, 70, "SeeAlso",
 CellID->20576]
}, Open  ]],
Cell[CellGroupData[{
Cell[108820, 2395, 314, 9, 70, "TutorialsSection",
 CellID->17070],
Cell[109137, 2406, 143, 3, 70, "Tutorials",
 CellID->9471]
}, Open  ]],
Cell[CellGroupData[{
Cell[109317, 2414, 321, 9, 70, "RelatedLinksSection",
 CellID->16255],
Cell[109641, 2425, 194, 4, 70, "RelatedLinks"],
Cell[109838, 2431, 219, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110094, 2440, 319, 9, 70, "MoreAboutSection",
 CellID->349645405],
Cell[110416, 2451, 162, 3, 70, "MoreAbout",
 CellID->641166947],
Cell[110581, 2456, 137, 3, 70, "MoreAbout",
 CellID->315460357],
Cell[110721, 2461, 172, 3, 70, "MoreAbout",
 CellID->54844299]
}, Open  ]],
Cell[110908, 2467, 27, 0, 70, "History"],
Cell[110938, 2469, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

