(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38612,        900]
NotebookOptionsPosition[     35305,        789]
NotebookOutlinePosition[     36609,        827]
CellTagsIndexPosition[     36524,        822]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Left" :> Documentation`HelpLookup["paclet:ref/Left"], "Center" :> 
         Documentation`HelpLookup["paclet:ref/Center"], "Forward" :> 
         Documentation`HelpLookup["paclet:ref/Forward"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Left\"\>", 2->"\<\"Center\"\>", 
      3->"\<\"Forward\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Right", "ObjectName",
 CellID->10895],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Right",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Right"]], "InlineFormula"],
     " \[LineSeparator]is a symbol that represents the right-hand side for \
purposes of alignment and positioning. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32346]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->171184308],

Cell["Align the contents of a grid to the right:", "ExampleText",
 CellID->94306447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Right"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", "4"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176068346],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b", "c"}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Right}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{4}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{185, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8002492]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->825938041],

Cell[TextData[{
 "Place the control of ",
 Cell[BoxData[
  ButtonBox["MenuView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MenuView"]], "InlineFormula"],
 " at the right of the panel:"
}], "ExampleText",
 CellID->156257647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MenuView", "[", 
  RowBox[{
   RowBox[{"Range", "[", "2", "]"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Right"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115448565],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = 1}, 
   InterpretationBox[
    StyleBox[
     PanelBox[
      TagBox[GridBox[{
         {
          ItemBox[
           StyleBox[Cell[BoxData[
             PaneSelectorBox[{1->"1", 2->"2"}, Dynamic[BoxForm`var$$],
              Alignment->{Left, Top},
              ImageSize->All]],
             Background->GrayLevel[1]],
            Deployed->False,
            StripOnInput->False],
           Background->GrayLevel[1],
           Frame->True,
           FrameStyle->GrayLevel[0.8235294117647058],
           StripOnInput->False], 
          ItemBox[
           PopupMenuBox[Dynamic[BoxForm`var$$], {1->"1", 2->"2"},
            DefaultBaseStyle->"MenuViewLabel",
            Enabled->Automatic],
           Alignment->Top,
           StripOnInput->False]}
        },
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        RowsEqual->False],
       "Grid"],
      BaselinePosition->Automatic,
      DefaultBaseStyle->"MenuView",
      FrameMargins->6,
      ImageMargins->Automatic],
     Deployed->True,
     StripOnInput->False],
    MenuView[{1, 2}, ControlPlacement -> Right]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{81, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24866555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->188606542],

Cell["Align text to the right:", "ExampleText",
 CellID->221801404],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<abcd \>\"", ",", 
      RowBox[{"{", "60", "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367642920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"TextAlignment", "\[Rule]", "Right"}]}], "]"}], "]"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->539273144],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnd1KwzAYQNO/rRd638s9wRAfwEu9qqBvUIawXYgy9/41aZr+LRVltU27
M+iW5PvOmUjIsvSDpdlp//aenQ67bPN0zD73h93X5vHjKIcCTwj/TgjxkAjZ
zmWruMzjXl6yH8RxLPTDpGzl5enhoCIqcCsvTwOLjj7Lp1CNhfofVSbIjl++
RmWQLLLmkLW2zvNUPa3qftEoKZOnEL/Tb8ZV08eDBw8ePAW3yi9ZbYuFPKry
mqPQ0NDQA9Nx3vctKBBGohXdlc/uiyAhISEbpH2NSdu5xijO91i2vn/+bhgw
YMDglKF/f1VZwprSi2vQ4JurbQgFBbUIyn4q/5rXq4hq3nT6a+LEL4jbTyeZ
dcTHn3UvuV4Vb/N6p0T/5747dRJTRanPIGtZWdRn4MGDB88YHuozoKGh50JT
nwEJCfmfJPUZGDBguEYD9RlQUFBdivoM4q7cKWfWER9/1lGfQX3G36PqI9TF
u+xkkTWXLPve07U7qXjw4MGDx02PfVf/W7t7d8KhoaGh3aPt3/zN6XLzVLm7
ZrtTAwAJCQk5DGlfEf12rjGKeVUMYMCAAcOyDf17WrfrNqCgoK6Zst89m7rG
gjjxS+L20/yp/yrixIef1Wp06kqupffdqRgbOpokiW61f9mqGDb55a9ged+c
UT8h\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{560, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->433277574]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->338216689],

Cell["Align text to the right of the enclosing graphic:", "ExampleText",
 CellID->125552549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{"\"\<ABCDEF\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"Right", ",", "Automatic"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Right", ",", "Automatic"}], "}"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186093363],

Cell[BoxData[
 GraphicsBox[{
   InsetBox["\<\"ABCDEF\"\>", ImageScaled[{1., 0.5}], {Right, Automatic}], 
   CircleBox[{0, 0}]},
  Axes->True,
  Ticks->None]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->43575547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->493017311],

Cell["View 3D objects from the right:", "ExampleText",
 CellID->727675960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sphere", "[", "]"}], ",", 
      RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sphere", "[", "]"}], ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", "Right"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198155887],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{SphereBox[{0, 0, 0}], CuboidBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[{SphereBox[{0, 0, 0}], CuboidBox[{0, 0, 0}]},
    ViewPoint->Right,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->6212931]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27494],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Left",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Left"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Center",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Center"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Forward",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Forward"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7631]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Right - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 17, 53.2407788}", "context" -> "System`", 
    "keywords" -> {
     "view point", "view position", "camera position", "grid alignment", 
      "control placement"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Right is a symbol that represents the right-hand side for purposes of \
alignment and positioning. ", "synonyms" -> {}, "title" -> "Right", "type" -> 
    "Symbol", "uri" -> "ref/Right"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1903, 65, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36390, 815}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 726, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1349, 43, 43, 1, 70, "ObjectName",
 CellID->10895],
Cell[1395, 46, 471, 14, 70, "Usage",
 CellID->32346]
}, Open  ]],
Cell[CellGroupData[{
Cell[1903, 65, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2280, 79, 148, 5, 70, "ExampleSection",
 CellID->171184308],
Cell[2431, 86, 84, 1, 70, "ExampleText",
 CellID->94306447],
Cell[CellGroupData[{
Cell[2540, 91, 343, 10, 28, "Input",
 CellID->176068346],
Cell[2886, 103, 405, 14, 40, "Output",
 CellID->8002492]
}, Open  ]],
Cell[3306, 120, 125, 3, 70, "ExampleDelimiter",
 CellID->825938041],
Cell[3434, 125, 230, 8, 70, "ExampleText",
 CellID->156257647],
Cell[CellGroupData[{
Cell[3689, 137, 209, 6, 28, "Input",
 CellID->115448565],
Cell[3901, 145, 1458, 46, 68, "Output",
 CellID->24866555]
}, Open  ]],
Cell[5374, 194, 125, 3, 70, "ExampleDelimiter",
 CellID->188606542],
Cell[5502, 199, 67, 1, 70, "ExampleText",
 CellID->221801404],
Cell[5572, 202, 244, 8, 70, "Input",
 CellID->367642920],
Cell[CellGroupData[{
Cell[5841, 214, 236, 8, 28, "Input",
 CellID->539273144],
Cell[6080, 224, 887, 19, 83, "Output",
 Evaluatable->False,
 CellID->433277574]
}, Open  ]],
Cell[6982, 246, 125, 3, 70, "ExampleDelimiter",
 CellID->338216689],
Cell[7110, 251, 92, 1, 70, "ExampleText",
 CellID->125552549],
Cell[CellGroupData[{
Cell[7227, 256, 512, 15, 70, "Input",
 CellID->186093363],
Cell[7742, 273, 351, 11, 121, "Output",
 CellID->43575547]
}, Open  ]],
Cell[8108, 287, 125, 3, 70, "ExampleDelimiter",
 CellID->493017311],
Cell[8236, 292, 74, 1, 70, "ExampleText",
 CellID->727675960],
Cell[CellGroupData[{
Cell[8335, 297, 494, 16, 70, "Input",
 CellID->198155887],
Cell[8832, 315, 25345, 423, 131, "Output",
 CellID->6212931]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34238, 745, 311, 9, 70, "SeeAlsoSection",
 CellID->27494],
Cell[34552, 756, 681, 26, 70, "SeeAlso",
 CellID->7631]
}, Open  ]],
Cell[35248, 785, 27, 0, 70, "History"],
Cell[35278, 787, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

